(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    397190,       8075]
NotebookOptionsPosition[    356225,       6913]
NotebookOutlinePosition[    387042,       7750]
CellTagsIndexPosition[    386274,       7717]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Numerical Differential Equation Solving in \
Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/NDSolveOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Advanced Numerical Differential Equation Solving in \
Mathematica\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"NDSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Introduction to Advanced Numerical Differential Equation Solving in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellID->1216565954],

Cell[CellGroupData[{

Cell["Overview", "Section",
 CellTags->"s:2.1",
 CellID->75354863],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is a general numerical differential equation solver. It can handle a wide \
range of ",
 StyleBox["ordinary differential equations", "TI"],
 " (ODEs) as well as some ",
 StyleBox["partial differential equations", "TI"],
 " (PDEs). In a system of ordinary differential equations there can be any \
number of unknown functions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x", "TI"], "i"], TraditionalForm]], "InlineFormula"],
 ", but all of these functions must depend on a single \
\[OpenCurlyDoubleQuote]independent variable\[CloseCurlyDoubleQuote] ",
 StyleBox["t", "TI"],
 ", which is the same for each function. Partial differential equations \
involve two or more independent variables.",
 " ",
 StyleBox["NDSolve", "MR"],
 " can also solve some ",
 StyleBox["differential-algebraic equations",
  FontSlant->"Italic"],
 " (DAEs), which are typically a mix of differential and algebraic \
equations."
}], "Text",
 CellID->1594837105],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", "{", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "2"], ",", 
     StyleBox["...", "TI"], "}", ",", 
     StyleBox["u", "TI"], ",", "{", 
     StyleBox["t", "TI"], ",", 
     StyleBox["tmin", "TI"], ",", 
     StyleBox["tmax", "TI"], "}", "]"}], Cell[TextData[{
     "find a numerical solution for the function ",
     StyleBox["u", "TI"],
     " with ",
     StyleBox["t", "TI"],
     " in the range ",
     StyleBox["tmin", "TI"],
     " to ",
     StyleBox["tmax", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", "{", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "2"], ",", 
     StyleBox["...", "TI"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["u", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["u", "TI"], "2"], ",", 
     StyleBox["...", "TI"], "}", ",", "{", 
     StyleBox["t", "TI"], ",", 
     StyleBox["tmin", "TI"], ",", 
     StyleBox["tmax", "TI"], "}", "]"}], Cell[TextData[{
     "find numerical solutions for several functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["i", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->153380323],

Cell["\<\
Finding numerical solutions to ordinary differential equations. \
\>", "Caption",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1688868674],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " represents solutions for the functions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x", "TI"], "i"], TraditionalForm]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects. The",
 StyleBox["InterpolatingFunction", "MR"],
 " objects provide approximations to the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x", "TI"], "i"], TraditionalForm]], "InlineFormula"],
 " over the range of values ",
 StyleBox["tmin", "TI"],
 " to ",
 StyleBox["tmax", "TI"],
 " for the independent variable ",
 StyleBox["t", "TI"],
 ". \nIn general, ",
 StyleBox["NDSolve", "MR"],
 " finds solutions iteratively. It starts at a particular value of ",
 StyleBox["t", "TI"],
 ", then takes a sequence of steps, trying eventually to cover the whole \
range ",
 StyleBox["tmin", "TI"],
 " to ",
 StyleBox["tmax", "TI"],
 ". \nIn order to get started, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " has to be given appropriate initial or boundary conditions for the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x", "TI"], "i"], TraditionalForm]], "InlineFormula"],
 " and their derivatives. These conditions specify values for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     SubscriptBox[
      StyleBox["x", "TI"], "i"],
     TraditionalForm], "[", "t"}], TraditionalForm]]],
 StyleBox["]", "MR"],
 ", and perhaps derivatives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox[
       StyleBox["x", "TI"], "i"],
      TraditionalForm], "'"}], "[", "t"}], TraditionalForm]]],
 StyleBox["]", "MR"],
 ", at particular points ",
 StyleBox["t", "TI"],
 ". When there is only one ",
 StyleBox["t", "TI"],
 " at which conditions are given, the equations and initial conditions are \
collectively referred to as an initial value problem. A boundary value occurs \
when there are multiple points ",
 StyleBox["t", "TI"],
 ". ",
 StyleBox["NDSolve", "MR"],
 " can solve nearly all initial value problems that can symbolically be put \
in normal form (i.e. are solvable for the highest derivative order), but only \
linear boundary value problems."
}], "Text",
 CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"},
 CellID->1805661336],

Cell[TextData[{
 "This finds a solution for ",
 StyleBox["x", "MR"],
 " with ",
 StyleBox["t", "MR"],
 " in the range ",
 StyleBox["0", "MR"],
 " to ",
 StyleBox["2", "MR"],
 ", using an initial condition for ",
 StyleBox["x", "MR",
  FontFamily->"Courier"],
 " at ",
 StyleBox["t\[Equal]1", "MR",
  FontFamily->"Courier"],
 ". "
}], "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->82760112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "==", 
      RowBox[{"x", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "==", "3"}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[1]:=",
 CellID->925938952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[1]=",
 CellID->698244241]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", the initial or boundary conditions you give must be sufficient to \
determine the solutions for the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x", "TI"], "i"], TraditionalForm]], "InlineFormula"],
 " completely. When you use ",
 StyleBox[ButtonBox["DSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DSolve"], "MR"],
 " to find symbolic solutions to differential equations, you may specify \
fewer conditions. The reason is that ",
 StyleBox["DSolve", "MR"],
 " automatically inserts arbitrary symbolic constants ",
 StyleBox["C[i]", "MR"],
 " to represent degrees of freedom associated with initial conditions that \
you have not specified explicitly. Since ",
 StyleBox["NDSolve", "MR"],
 " must give a numerical solution, it cannot represent these kinds of \
additional degrees of freedom. As a result, you must explicitly give all the \
initial or boundary conditions that are needed to determine the solution. \n\
In a typical case, if you have differential equations with up to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "\"\<th\>\""], TraditionalForm]], 
  "InlineFormula"],
 " derivatives, then you need to either give initial conditions for up to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], TraditionalForm]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "\"\<th\>\""], TraditionalForm]], 
  "InlineFormula"],
 " derivatives, or give boundary conditions at ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineFormula"],
 " points. "
}], "Text",
 CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"},
 CellID->1321156179],

Cell["\<\
This solves an initial value problem for a second order equation, which \
requires two conditions, and are given at t \[Equal] 0.\
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"},
 CellID->1497635469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", "x", 
   ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[2]:=",
 CellID->569913881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[2]=",
 CellID->471131597]
}, Open  ]],

Cell["This plots the solution obtained.", "MathCaption",
 CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"},
 CellID->447645229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[3]:=",
 CellID->1244935384],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJwV0Xs41PkeB/AZd1tGRo6mJcdtDpszOg5S6rx/mkpGy3GpZUkq7OJxTRcR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     "]]}},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  ImageSize->Automatic,
  Method->{},
  PlotRange->{{0, 2}, {1., 6.32199019694547}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 233},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[3]=",
 CellID->1319806552]
}, Open  ]],

Cell["Here is a simple boundary value problem. ", "MathCaption",
 CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"},
 CellID->1630958702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[4]:=",
 CellID->1135344520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[4]=",
 CellID->2067392509]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " to solve systems of coupled differential equations as long as each \
variable has the appropriate number of conditions. "
}], "Text",
 CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"},
 CellID->419380819],

Cell["\<\
This finds a numerical solution to a pair of coupled equations. \
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"},
 CellID->1957151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], " ", 
        RowBox[{"x", "[", "t", "]"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"x", "[", "t", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"y", "[", "t", "]"}], "2"]}]]}]}], ",", " ", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",",
       " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->495083166],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "100.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "100.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{323, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1644677160]
}, Open  ]],

Cell["Here is a plot of both solutions. ", "MathCaption",
 CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"},
 CellID->1201251468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", " ", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], " ", "/.", " ", "%"}], "]"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"PlotPoints", "\[Rule]", "200"}]}], "]"}]], "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"In[6]:=",
 CellID->1294195954],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVXX/IpcdVfve7977ft5ukrlrrtqL91Fa32mporE1rf6S2aaJt7FZrGhTp
xipuwNK1Bg0iBgoaETEgaIqIgYoGRY1FJCJiFAoRUaJQiEphUShBQYMiBlG8
PjPPmXOeM++8d/fffpDNfeeeOXPmzHN+zI937j33P3jlBz9y/4MPfPj+07s+
dv/VKw98+EdP3/3Rj6Foc2aazlyZpukfLkz4vMen+t8X7Pf7aVM+1b/6vw+W
D9Pn2zffVj4cP//8808//fTDDz983333Xbx4ESR4nI5Xa72rfDgHmkcfffTK
lSt33HHH+fPnL1y4gA9g8sQTTzz33HNnV2u/rXy46dq1a08++STI77777ltv
vRUkqH316tXHHnsMjF944YXpJasc3lTbf+aZZ0CMKqh4cnJyenp66dIlMHzq
qaeeffbZl3rtVvm22u6LL75IwS9fvsx2b7/9dnQCJSjHt9PLV9v9htoutIUm
0BCaQ6NompI//vjjaPeVq7Vf06QG4UMPPUSpoTUoAMygDKjkVau1X5VrQ2iK
jm488sgjFP01q7WrVGfZcQxyVxtcp29crfuKVhfahqJ0sDDUpe43rdb9EmnX
FY664ANuUNf0ptW652td0LAuZVZVT29brXtTrQsYgpIIwfdonXWLzO9crTvX
usSn14VZQAaCZLp7te6ZWpcYI7ZhGUSm1b2n1i22dYSqc8fjf5u+MCo0RsKL
sC5W8f5av9bbRr1p2nWcXmy9wBihF649YIcGOt3Lihv+r/wVichIGNeCHf7/
7+X5xDsG5KJjEBIdg0K/9wbl+jcZGUUEewjbmj7knDYDDf1z1jAUCw1zdAwV
P+Aa1nq9HJ9r+kEtoBH6cU1j3Iumr1Q+JzZSff1/rM/oOC1qOoIypg2kAK4L
vj4yxMhnm/T0IMQW2qYtQZrpR4b1/q7qHlIRk5SWjgN6+LFhnc/UOtA0OKOH
kA+aIhAh4E8M6/xNq4NeoC8YY6gW3cMjhPupYZ2/qnVop2DPOmgQisVwfnxY
5y+kDthDMBonuoc6PzOs82mRjcPOOugeFPNzwzp/JnXQjsvGIf6FYZ0/qXUg
BhEKvbEO2kHhL3qdUuWP2rhQxyBEE4Qi9PXLQ/5/WP45xrDBFNED9IMKLjb5
K8Man6o18D20hUGnwcBDFLT/2rDG79YalMv7AF0BdtMnhzV+u9YAMEDlUrEb
028Ma/xmrUEL4hgClpCwSPVbwxq/XmtABrQBeSAVZOPwTb8zrPF4rcGxQBsE
Pdoouvr9YY1flX74cKCNEtn/YFjjE6Ir7Udp46lhjV9qUmHU6OJRz/rxx8Ma
FTUzNINRg3YhFdACRfzpkPrRSg2MggikqACooPKfJ+z9fKNCB2nZEAdCfXrI
82erzNACNAlSaBL/4nOR+ZlhjZ9uemENNIGG0FzR5F8Oa3z8QI2/HtZ4uPZh
WeNvh9Q/WanBDbpW6s8MqauH21E/0CKGCJ+n54a0P145wyahceqSqvn7IfWD
bTSBMYAYxgjNg/qzQ+rq0WeiBYjEaAJcMJtrQ+qPVqnRQYZYyFNw+E9D2h+u
tMA6EYAeFvv+3JD2gSYFEAiZAXH28PmEqR+qHMGFzhKwK/b/L0OONc7u8D2o
mMZC6ulfh7TfL71C65ChRPoXhrQfqrSUlONWevUfQ9rvEw2ALyQpfP9zSPs9
DT0cB2oAj/81pL6v9Y42aOPw30Pae5sUnBEQDNP/DGk/UP7ZQhNADUQAJP9v
SFfzvB3EA1iYZ5XssXx1Zkj/vkqPdpESgB7ILCNXvmKCd9LRb7vne1p/URP9
BZeiyfLV7obqv6fV50hA6mL15SvOIxd5Zvfcssy7KnPYFnoMPhiiwuNcJdZc
cBrkhl4X4wAzg5JL8c2Vei3jvjPXwXiU4pccrFPnDlv0FTJGnfM3pKd3tLrU
k8n4RcMxfXulxTjQz5guXjqkfWulhc5hNUA39F+KXzakfUulBTsQwmQAmlL8
pUPaN1daYJuzRbqt/XiOfHuTl9M1VCrFXzakfWN9hpiQAZLU4i8fUr6hcgX6
mcKYtF8xpL1NJICBwWRL8emQ9vX1mc6gSfBVTlkIb23c4LXgAKzlrx5yq/Pn
DXVa/FUpfPWQ8nWNKwSEmMb1a4a0rxWuzf4vDim/rnIFM2AyuI5XBGrpBlKC
a/HZpfDrh5Rf21AFllAChC7Frx3S1h5sABB61lgxWVC+urUP4ynZYikcrz/U
VY8NJ5zFp5bCW4eUdeQ2oOEiUC1+/ZDyK0XOkhGUwtuGlBU3G+gdchbvXwpj
raMQvrKNj8j3hiGvitcNjBOabJ7xm4eU1Qo2wBtMs3wshW8cUlbL2nB0gONa
PF5PeUWjZGZTi988pHy5UDYcf8uQ8sKA8i0HKKEikLUejSmrD9pwAtUo3zqk
fNmAcrweVNegNlAmlN8o3z6krJ61+CS4mUZ5x5Dyi/eGYHSqUb4jIaN69A1Q
A5Q1ZHzrkNcXNj0KysarU6TkXKO1OqY8P+jJu4aUfIarhjdquLxzSFljYrEw
yNlyi3cfoMxjM6a8pT7DCoGhRnnXkPLm1jp8VstMxutwpOQKY+M5pqyrhBt4
IPSoUdYV8Rrxt9Ny1Yc1MpJZQ9ebpkHNc4Oefjtpu0xo09XsMwhyouvMnM52
lIVTyamOB2h4z2oNfWY2A1wg/Whaf69r6PBK38mg1fe6rkZ5FeVEO+hca+2e
4ciREoyZ5xygnFsPkNQ2O/yOA5RZ3kOUYMh4eIByNxj19x2gzLY9pty2HmHK
1yz20gFKLms0nocos8UGZSHcDvo85kUMZat6/wHKrPFDlFAic+3rUkI1zIAO
UB4N5PzOA5Tc/rgRyux7DlFmKxbKY6fEXx7r7wqqWam8J/sPrFB4D1YpXHKh
2LTZmmRrw/ouZkexcwqKWB++e/Q9BVz/nuKtf89Jx/r3hIXZGmIYANUimXgP
82qIxYg1tHUQwjjw7wotLbzy3bkaaCzmr5FFnpyclDypPB/ZzOS2BSckKUhV
yAl1EJXxkW7BOOHBNnSq997SO+MPH9xfo16pUSiO0Cj9PBo1qyCdpfOGvt1C
FjZLWTx/orlSli0Vyn8rzy1lpqWyFa51QBlsdUvN4A8f6MfJomyGsAYEhq4K
1viMvpo9kR6CmJ/iMx4sHvuzLa/x2Sbo5rmP8N1J04eUqz4qHeT7vYVOCDHq
xPMAw3XV8s7tkF9zB6lMSTYcW5drSzgDZBCEJcQRK2oJoXTcxp87qNY7zqPK
9hNrUJuE4Nz0S41bDTTH9d/IDPBc5kI1MoOb623iWQCPolxkm1wSqCP0h84Q
hvbMOXuxOH8Gffq+f7ZIUPWPYWQ7XP2uym39AV3Uw5eGh7kbf6dP33P3J31v
cWVuGqUXC09h7Xt7hpNdh6PyfAR2ri+TQ05DGI5oM8SRR1UOneHI4zbTHLMe
WhatjCV0y7RVIoAm+nD9Ywmtl3WpU7TJ4eGYV3xi8FRvhj0ifpYStuj5Elef
DRNc1MCfZYhgCLZag4tDBb+ubTwXDnPzD9zShVrnZv/gUdA4N9xB/BIJnGN6
5i5O0POASokMFVelqY2FqX3LGGgTZXfNsYyBCp48rhHRo8zUpqns/M4No3gu
PssxBfr++xJttH4pdf7oY2CK7ReqXfNN4IdBDHrLKfk9l22LTQTWNp6VE1jl
41Ebfcvj6qiFd+ee56TIAiHITwS79GNEFnFHXLCE3oscq6w7bx09cKs1JPNf
lpAv4T47KiMrJSr5rIiCeHSCxpmWQzpS4DvWMQpaCPFOrvTarLMTHEImUHo7
kCiQy+VTx/qG6+4lOvIZ3bWVGXJkRiERZOtbp2is+o4CmA0HthI0PhjuEkt2
zb9xd2jy3uH74iN8vkHIE++l2xtbPHa8gxo05SvtLcSDInwugscyBHyGVrl9
ZTU8zjQ/tuHOZpGzO/3FhRLjw7XkwGLMpolFz/JJSCzuCB13nOz5jhrdtwTM
IiA1zO9YwpEmuFnTcyvLamdBPD3nLPhmYqolxKrWkmxpG/bWZsqkJ+5c4+wU
/p0F2ez/TpAsOaFhSPJNa4v4Vc5Un5ZwGJQP+6XentbHEn6mJ/YRNjtSq6Gt
7yTSKCrQME+TWB32hh5ou7A092Z4RM1kOWKdxfYY0QxVYIkxixrsq9hawaFF
0g6dNutwv2uzvKMmia0xEJ3UBj7SLbJ0jrlXyxCJMp/5swMWI6md4gmLQz3a
yxzLMM/aLovl/0QJQUNkKP6I6FksgK2zhPqWkSr7lXTn7FKsPRkOdU7j/bM5
zU5a0dHn2CrOyIXdV8wQkVrCFbAiQd0ftD0nrUm+7OdO/Ljah0YVxx+DcUIG
9beTiMXebFv7sjJwZKPUMnbSE7vMb7TH/JZK3YoORMoNQ3tBhEqtdTj2bM8R
srWtqqSpTUYzhyOyAkPvUfP6lmETt+5V3bFWtMy+so0/iaM7r8/hIyLPUwek
5vlhej7/t6Q99QN9VcT2vWe3xJlzUjswxPM7llBW8XmRY3BgjV+xmtowj01R
C7G2AhwBTQY/1vCe8zsbH8JevTe1ougM3VrWFdZvMauO7DFnVfuaDcV6cZWs
rFSwhmVKigVti0rTKEAfwPJt1iWDn/GilGpDrMn+VCzNEbGnqfg4k27WGbC0
ZHN+tqc8ieqteAZGYJbQgXLcWIv4V+tiK4zHVbazkMFifT04qUCrUp7B/8sJ
ie6UBEUxq4h1RFpFrM/6OgAki+9jla7Wn2Mdbb+XPHf2LNodZaU/9ownYOUe
hdKz6Kj5K5t9chw9/7WVl25tiGqffO0J1dmS70JEqc0vO59OVrW1ba1UoqEs
7JukhJGM1yI+bXNrmvVt2W+t7b5J8RkexvIy2kzxEFUixoneZlgj4Tz2+6bk
YzVP4hixF2zdR8qGSXkpvmnQLHebsbnTNNGwdXwpWvF55EhSlY6jTn9PGn7m
4HTSWRTeiixECUs4HGzDrcaynGmyaeaNWI2Nged+ZgX9yjmtps/rw8p2C+uQ
fHr2PY99Wl27xdc/9i0Gqdhk4ijYeF5mOPJZhaJwpzzdPmafRfhIVR6zxjVq
mbzdX5jtbRsC3HBKcMsIYIO9hdfRidm3xW624lJpphD5p8aUmDPZCvg2W5h5
P9oSZWPpwJYoSeLj3JOFURJaNOk8BpuHZqljXb3ENna6pt5vGFIjE9u3tCLF
If4bEcUzCtMM57niy9362B8OXiejIZ51XSKpS8XQKt22bNyq5d+obVmE9xzV
EEGExPyRthV7eP2sZLewIcn65ziFlVbzI1dpejvubIsgsdboDMO2fJ1QkTn7
6nZnRZpLRo5dT9sygrnayd2jiuWYO8WBZb9qWRxHShormLQs9xuCKYmdKR76
nqFGnp1rMMU4twg2YJZF788/27BQy+IIJT6uWY03IYlhZJP9gcTraedaT77D
fbVZbMfBfKJHLttXq+8VqJW58WgU8j1C8xEdb9W0WQsHspPXfBJru6dNtSk8
v3NbM43XzLQEwRuxNfMA284j8Dn2immLsUtz1D3vFjbFGEhbc+z5YDCOadyj
rjtbY9Sw1iLSbRtuWFWxOsc+bYMObUozUwKN5e7f9m1bqnnMo04HPv/eECe9
tTHK935hk9Fs+GIP+phLidzD5R6Eb7F5IcfIdR6e2NYNq3zFW511ffID8Z+s
wnkr9mbNmUnB3vQZdhdTLRvvOJsddxzMT7q9WfsVzGpvnkKxQpfJWIc73knX
LocZR5dfmE47DhqtLQ+lTtzmXNVm8jdic5YLcqwiN+RzN6OSExNEVsQ74t33
K/Zt4W1uOtu3P5mdh99n93xti8imOjOa+jlftohp9lHYN6efLSgi8iaVhz2T
j0om6z1l5NgZW43wNafZs819sunIBK0G7WoZhdmuzkFlrhDr6mM825yGOooc
u0nHN0adOvHwsbHoQjk0p6axEI3uoSzqd3NflSM4pxjiHMxTpvzRkF+fZ8e8
o6mL9RZjOr62JtXJYKunXb7BYbBSR7ONVC09Vg8o+V+VWOZa0+pKn1lIf8qL
z5Ff08Jil4W4DIvsz+0N5ygbH7fFmglx577fFUXL9Z7sW3CnfLK62mFrs6hH
/8V2NPIRbvRbaldu1UkqjTJ9VF1GT2kz8jFb819KIkjear571NatUryTVbCQ
JGV1rv3k3Z3W1jjZnnuu1J7aO80k+6Xwb8xPXVMmx1Jq9peIVi/jMV12lV2O
nWYeQRl5elA6T4u3h/2Fy2uegaU+gqs8iDNSu7xm75y76Ur63vBdpPR9JltX
Gq+K9Nll2A3tqMP5YtWki5Qpq5TVs9nHb9+cGduLM+nDHC3xo8bZjsY3wovl
PtPJuJ29H66+sZ/IOAv8xWo5n2Wu3fRvoDlayEHfxv4ovjj6LNc1HZmtz2ot
9EHLLJB1lxagfJS/tqvRWiwmeQvFoOtRc8Stcg+b9hxj3xI88nBdiS2EpsXW
MrXNtchDebegOcoaSO2ol5mkt5iyMuqsx+JijMve7T5Zn+WD/cnkbYeeXYcy
orCPXp7r2nNnFRLNKFmgeNvx66Njv17TWzH5x3rvOCtUja1ZmczB0xyUQ8By
3c+T1emFl+kwkbJSWv/Ymvt6Gl+JIPZH4wN1y3Jd81ErU7zTQpeeW8uVXtYH
En/qhfakXiLsSVfNNLb05/GWvGVtPemOdkHdqKcRWZIVs9UlvepMpaRkpNc8
Q8Y6pLd8del/aC3kopphT44Wmqe1dfapK4L9CmGfHYp37+M/cRbZK587+xB7
799Q6e1v0/Hn946XhX2Tvl/ziSjfR3U+d/4kzU9lXTlFW4k2i2jXR8PeH3We
M0VriUoiV79zebSQh31eYpKwWUZX6njYzsDjL/2aRoKu/7OuEYWeIoZ1/jP5
HY1L2l5EMeWulricHZC7nuZRbagl8vNheuWvnkG1ypHvpE/Zq2Y+to+4730s
x4/lGrPZ885yzTJ6Sxyv1ITl9JY+ssxYTwkLup5F9hF5aGELi18/2dLvTg7b
S8iUPawUQSWyLCJhvyPTR/iYf3NUdD6rfHtL7+bpSZ61qKP8Ok82yCyW8wCJ
+KvlKgd1PfSMKc6orWkmQ2z0nnjpobSdLoMZzD9YrlFaM4NlprKMokqv/Dkm
S6ujPpfxUlZPU6amPkZ3BchzKY+c8q9z0+LSLttq69qbb6FPP4NctpCaLxSc
ju3U96nsOeaT9flE9Ti1bWRbXVDuXOPqZhW2KtavAa/ODlIs63krIi3VcY+v
KJK19IjTUzviNLbu3rv4nvl4drrV2fiRH5muRLYDMc5DBqtg2k6a5esJLfUm
qOB5t8YKPZ0SXqVtVi/Rqfx1b01Q2+vp3NK7TPI+3FKm68dq3ZnWDIW7kSyX
/HWc2RferrfgrTanPoPvYrBcfZaiiGgjfVnjbvTqG9R2Ox9pozq+U7XPqfzt
AgrmkZVz3UEubHtjmw5TtFj1ZL7haOsSHq+PuxU9W7PXnbZAaR/LJz9UdJR4
qv780N609Mc6sw2v0I4ssVf9DLs7wzdzT5j8JJ7fpDLELlOltN2KPt8YIn3D
c5DRnmpV5o5z5x/dojReq6XpySYt1wyfnzUuTXKqrLMmW6PWOeskJ2WW0ujM
1+0mZaCaP+tMc6qnmL2vRq1WoGvGTp14q72rLbnNZMljjybNzXn6htSkWGbm
uh4StldtbcUiI+LQIsMO+llqP+vtc14+R67E527XvXkv2Q1lpOt20PU0l8hw
YytTHe8UAWR/Js119NSu4jv2WdSXk6OvhvpXGoeVi+QPCWmyCr2IFUsusqa6
gu6YTWZ/VuP1lozVkpfrOksLp7aJTB9N3eUbruSGJF0OFKvBae1Gc9ouglKS
ZFGKeVkpjx2TxFvjp4xcaDztZLrXTS0qD52hak6sewQeyw9aX2SmtL4OuTKK
/Y5ib+NLjMpOymLmFpFlvKYSZ1HyWIalLWeSeqZdLSssSDNl3ZdZxo3lytLa
Pr+uDGsWphaq2JL91FhFTGdcVZrYgQgdyAmBfe/d1YZ0pzXKg4/sJFZpvF3d
rw1rSefZdB1V16S1TY2c/aklUq/tO7okyYrWqH2sE2/VuUriY2pzhq7FtDOr
UVa9kKNcTyKJnzlkcbFmQYuLtYRNN7q0uD62RM60W2BU3l45sEo5no11cTT5
GznPn9qTE6Up748T9mtndzK9WO6uy+3MJhRvunejKyGyW7dVrLj9R16TTpn0
u3LL03zCOUXPGyjfqXU69zgtls699fvth07iKDaDr6NLd+zT/qrui7oU4xMQ
6Vxrf0qIpRoHQwrHmpzx8ZPjNklhffekyee4Z9JzPxKLDtlXRI7+VDe/j9yN
eF6ucPDUm+JQ3jxcrC6EFyX/9T32pV8Svqk9eW83rYXJu14Jn3oKdRkNulNe
NndZnIl3KxmeO0l793q2zUclvY/QnzPZHsCsauR6pd2Rsv59pnS+pz8n1p26
SyerHceJr3uGxMF1ls5/euRLp+A9X5X3JdwS+Mqd1XePNfYI6cxr31bHwU45
dPFbpZUZzSFbCmz73TEppsRcizaj83V5dzplNPI2fPJL8o5+2L9idXAaZHkO
tSCF1OqP196I0FPdS//d4ldVRnp/1TGkKzhxAvGavi3oaLHzvaT1uJXQ4jad
cOw+MiHDtZFKxyhydOsp1pDXTrql/qaeuU9NEcFHP3F1W1QO28gupr51PT1u
dPoug+tE3wKxc/JsuLP2JKN7nNTK1N4HbStiMeNu8vUzo5W75SI7460DfVYV
OyrLqBK3W0SW1J18C/9hNk378PiqqEweOt6N8BFVVKYZjEYbzZukfBHnu3dT
0/t/3seEeG/Rcq9d7olF+i56pDcL3HIFr4L4ZDOui4RNL020juMUwby15Psd
3dq3bcxm25umukLfRS5dWTLcyWmG0FPCO+n0jQWXL73xR/BHuz76tq66yb4j
tcHx1nWoy+1HVpp0JQLoLV7Xve+xJkIpx+Lg8WYE9dx0F7SSZW5D3LsfsvFj
qWvfxm/OlmP6Id76c+bdjQjyNpygJZW6xScv76Or95xENp7Q7a2lWxS8F3or
QcirqInx07fV7a0S1tB3r/UGA2pF7+VgLV2VcPlSDPAeal/s/Wla0E4QqPwc
0fq+q63Q6DtvbofJtogRpfPe6zuEZiGyumq7VvrugY9oevOcD7EeRJuJPdmb
DyA9VqOJdM2A5AavQRZPpGs2onfaOHIMTyz16GA+qbOKO+Q2jRVEugY0nhhO
rsndH0SFzE8iAqS7RDxDTqj1VhI+SStYCR+W3oT22oY/xZXeQsNKWkJA6A0i
rKW350ztqhJfcejv3SEqyEXvd6J69Z0FtxR9T9z6qXY4yRVAgbBurz08S+JG
JEirdhOISkbl6802tBq96YAwYJu3HEB07HwS0ct3sohozZflnrhBBjFnpBh+
urtubKxZ6nFBb0IKu7esgEhlr/UWJo4Tsat3N8mIBMb0zhLTUdyf07hTOH2r
W7Qffivd28QHak/vLFJeHFu9DYwlSsNael8ZMa2jvbzlhb1Xz3+5v/eszP1R
0d93TTdaah+ILvWpQlPmiJAjuHBwZEVieZtaWYuEAuO2KNaRWVq6zekQWmO/
gmhdnvslWjXfZX+OxTKpueOMSEMGEenRwGKT3jcneAlcWWaltzCSs95vpyWk
iXsZW6wmdqkn9kJWqawWe7oTzcnsu+yAAi9x9yepT+VeRmoxuNA/5b0flsXq
msZ/vb2Ojfu9VQUfEMlzLUODem1+Vh68gSvq0OPJ3QobgiPu9qJOlAJ6g2TB
gxoRbRb880K7uBf+ofprgVaDWNc79OjbqPNAZQFlv+dJNOpuiNwuvMghT8TX
sK+k8/hoORcx5h7WZrp6Hyf1cCxeT3yz2dnluGvMbF5yb4texILjBb2K+zOb
v9H7GllL7mMyXcktj2VEyNmQEfcPzuJ95VZD65Ny1Zua3WdfrnfjNuk27JBn
N2VUUMdzILsJke6RNfABj4FZNIrny36bIsdLEXq1/mat34w4uNnzav2JR+dR
5kQX6y/Nxn2ip7xvl99DTSjy+UChx/dx/+j5+hu3Jd895A9jxY43evbr62cF
adSl3njMEdAbrvnvSZMAtfw+RrNkIuhYuNC/zmJDikF6UsWXjqnf48s7kW1V
BR1HnbgnGLjgdcWT37OMJp72O7Q5/HHvL+gv1B/Pi1uULtRfKbVnusfCT5/j
ewjP62Hjbms8xx20aAnPfnvkhlctey5QVomm+oJ/uvc40ds6Kul5D0D0l52N
73niw+NQ6X+6pxjypFv4C2rqlW7pDt2gv1xviy4fBVuDvfxz2XvZqs9ZGXva
+4n4Fnqbk9Yub3a0O+f5k1/Fihxhl/jbSX5nOq/djdU1dDXuwabVxZ3rTFYC
N9SjX71TbJJJj+mBPYm71nldcdx5Dpzw1tegP633UBo9r7isymp6TM/8Qdt4
Bv90IwMvI3Mfft071/nzxam+7anWVUSQ+53y5hV2TW/pbvXYYHV8pNtZ4k51
0ue716ue093teLD6a/hhJKu/7JNWCIgdZgD0CcQO/Rb91EnT5Wn9ycP4zRuz
uZOGeRs7x8JF/p6b13/8Or9nYDo6brq2Ps6tj5b5OBZNJ/693va9iaOxn1rR
CTVAnWgGRp2g46f1D4zPNrTpWkORANX8NnIZ9dEvT5xbkYI5003NXuiK7DeY
Qkf1Ny5sDe91K5w4WvxlqEfqDye3tu+MGotbAcrH4e+I2Brf6vc2j1z93mZj
3fdpZbZ8d2/+jhm3AT6+a4H2g0Etsffz45vpzP8DogP9Hg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"Out[6]=",
 CellID->489659545]
}, Open  ]],

Cell[TextData[{
 "You can give initial conditions as equations of any kind. If these \
equations have multiple solutions, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " will generate multiple solutions. "
}], "Text",
 CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"},
 CellID->256584290],

Cell["\<\
The initial conditions in this case lead to multiple solutions. \
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"},
 CellID->1567178311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], "-", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "^", "3"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "^", "2"}], "==", "4"}]}], "}"}], ",", 
   "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[7]:=",
 CellID->389314559],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxst\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Maximum number of \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(10000\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" steps reached at \
the point \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(x\\)\\!\\(\\*StyleBox[\\\"\\\\\\\
\" == \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(1.1160976563722613`*^-8\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\
\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NDSolve/mxst\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"During evaluation of In[7]:=",
 CellID->1114592087],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.1160976563722613`*^-8"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}]}], "}"}]], "Output",
 ImageSize->{373, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[7]=",
 CellID->494369864]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " was not able to find the solution for y'[x] \[Equal] - Sqrt[y[x]^3], y[0] \
\[Equal] -2 because of problems with the branch cut in the square root \
function."
}], "Text",
 CellID->4754978],

Cell[TextData[{
 "This shows the real part of the solutions that ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " was able to find. (The upper two solutions are strictly real.)"
}], "MathCaption",
 CellID->1665687237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Part", "[", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], " ", "/.", " ", "%"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->87877419],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW3uMHWUVn965c3e39KVFXEGwxj+siZEmCt1C0VuRUhuaNopYMdiutbpF
kaUUbKihBgLVFClEpT4IbXwVjbE+kKLRFF8ppmqDUYuKVqlaa6wrvuoDvf7O
Od93ZubMmXvv0iYmxknut/P4nff5zveY2WWjG8bWXjW6Yd2a0TkXrx8dH1u3
5to5i69ej1vplCSZMpYkyaPDCc47OOMfHevwk1M5m0ltGp92+M+rezxpoW3i
QVaLGCg8SboikzRAcDTiZQHZRJPhcka73U7SsbGxzXwkU6lJt2zZspePZJCa
9Pjx4wUJz2fWQ4ajSgiUs5hy+/btJc4bN25s85EMsuTBwcGgJVmepHPnzg3P
m2gyptm9e3fgmaIhYad11yBcn83XBw8eDNRNNMJxxYoVQUpKUozkBjXZ+Pj4
5njs2LGDqZN0YmKi4AmJGase7lZjstho0aAm27Ztm3JfvXo1W5tks2bNSuIx
PDzM2iWZRgfHrl272AtJeujQoSBhQnODIt0y8ldSkx05cmRvPBCTJCU/ZCtX
rmzHY86cOUwmMqGTyoT/WeZhN3/H0LBGGbykNPAwc0o5TWGLykEGJA2S3oQt
ohCc8wOX9/UV3ZGZgVp1R+AaLAW55EjR7AGbh1QKCbmZuSO3He6aIVCduTeL
NpD3OI7pgQMHgq5fci24g/OjaAHTcoLPmzdPQy13YJO4DyFqmCh/2uV/d5k/
XCr6I2c0rKI/TuQOQisY5KBQwYiPutzvZe7QQXAIsFCibwgvmCDckblyByYI
BmD1+/td7vcxd/QoozsULPu+BTEaVkAQJvHOvn37Aq+troQHqWnBPA0vqMFD
vD0yMiL+h/LG/2QpS4DygddmV8L+fm1oan1BaASDIAsVzLiulJkHmavWDMqG
clShuslKjWrR7/5YdLicMxrVqs6aMxrVYs5c4XKfKOeMeqSaM7ZHFfoqyFe4
3M8LVa5Y67l847eg+CxTmoBY4FDSKd2b5/bS0jhRqGM4W7JkCQHEjqLW54QI
NhwpTdeiBZ1uIwgJGKkgbI0/t4JoVu6MlL2CE9gbRqM9e/bgOgzUpD33BhoR
yvVJzJYjNePhc41OaUWDtE/7rXXzXevohv/EsbsHJivHH+6g+PNI2CyOyTI2
IitKY6MdCZ5x0jwxYBA1ce6aK/14hOynDD21E8dy2FUay2VOpCMWcUH1lLta
NUvzk7xyTp2EP2I/nqwfogW+/T7XqmeezXdQjrV2VedJPC/jaqAVHQeqW5hT
SV8SBugdUgmeVPQnEzn/SZF/P5nBdTDTcQcH6r3YNYi+D4RYK32C8qJa6aa4
1sW63Qp/47WN7PzC/UaSV+1WzbVfU6nptdp6Mk8Gg59W4+fbOWOS19NPkP5/
jX/2f6/+17x69kmW2p4k/ixz/ayTYqXVYlGP573wvhRq+qkr8cHJrU5z+Z6u
c5IWj8C6Hk8GeTarq4ekxVNaXf8kA9SkmP/3tFHmZrpmTjKWhDEvSBow82be
10jzOVSLJel6Lmiiuw1BU10ZBUvydd5MV7Mjxn7RCsN34No09jeN/bIDpPsH
ScbPdbYbrMr3oexe0DmuVt8xWjWMr3yt7I5Y7ivRSmdbgT73VdP46rJS1n2B
tdE5bpil6T4Uj/KZ8YvVoGH84muQ7xZe6/plJ5rMSG8YX6Qmb3illeqKMTzX
PTrR3tj/blf6bZzgOseT6X5C+4Li/3yOS0SZkdMwFttV0EdcmTewzOK8itYN
4j1ddYt3szz+MsdOjc/J0qZZcXzRlXolS9WV+N7izh/46dyVvFyd0dLsTjTU
HYWQwXl897tyL2e5xX21XK5a2853HJNM9xnavD2Sz6SVA82kD7nSllGTz9mh
bL520xUsnFrdS6VdXbuXeqzUZ2gsYERTM5X2WZhT3ksKa6Fmcd/U8n7C1f+F
rL96C0ab/RIwJ7hYpJmoO1R5vlNziiuDx4d8TybuJ7W0TkvSoTXrfJjtSRl2
pZzJUnQvLEgxe520H8l3NBLoCjavqHmOK2M2NS31loSFdtQK9YJauc7fa9g1
OjU83+GVBtW5ppEkq1ap3rSqVVtSySpyWaNQHSjHG6YaUMPrOl45FNfpLG1I
peGQ6iBjFu9eg3ejUH9R90UHk1XUXMhcvfchPLI1Fy5cKMNG2Dmlx8uZxq7N
eTU3A9erVq3atGmTJIi4FXkoC12J2V7eYSSiS+o5Fa7Z4hnSTyVswpzW00ki
lUeYS78noos0QvW7HnQ6jXmLB4W31DdJhjbvjqrWIc0u0LiQl+1qWfJMclnm
UaJtg8LeknDIdkfO8Vw3Y0+nZrpkrERXdhPAqKgbjEauMdE8lw/vTUwvagQb
pVuJ8yQHRR0mep7yITZcA6aJj6TPiBIypiLjlLi+972AmlNkDoFUquPB8LNc
Di/yOEhZkKKDGEHHLlWGdg6Sqch/mUghLDA/4Z0JcJP9aQLOdql5dj8k1Ukq
LJ7BiwiCkDJwhkvL2TiEKMH99bRDLu3Selpogl7BwHw3g0iXF2hgmgw40kuQ
SPBA8m9X1qXUDEpXQK7BtYgP/AR/Q9A/XBp+SziEuMD/iKPKwjn8TKPvX1y6
K6IsMEcAkdEwCsqKgo+7NKOdUFlhOVc1ngjAEyCiPeljLtValgSm8AaoYBLi
LpKg3lGXht9/DCCfRJJoJyYlvy75+ipGQiexI+EtfviPcvExl/c1TAFOCAc0
gT5iAfnqZy7FBqaAhWIBtIGbIY/6/U9cio3UtBA06AzN4ScYDJGPuOhNzB8e
grXQHv0SUiCLNPp+p26EKF7fyBxQAmAHrJH6BC9Qrj3cF4ebWGPkA7wCdaE0
+iic+N1Ot7H2FqaCHwCey4dQ7Veq4thJtZrGtVuZCjBDJW956yr71gqVGPjN
rlS3RyqxC24Rx36tL6/cSQ0tT8SpCAvN/x90o/hexiIA6LFIKkSevP8VF3sX
a4WMQhapVgif/y76AwUtwBmpRNn9QKkffIgxMAw5BNcgQWnuc7/L7x7GIjul
OwZNP+9idzJWNQUF1cvPulheQ9HXAW1+WQiTdru4jzFPZI3Yg3hS9fiUi90V
5QMF+Ygi6fpJF/sJxsKNSAxgwZ166L0lP7EUetcKBdHXYMzHXV781r6JLivz
bOD8N+2fYRweK+7DLu5zFdxOF3dfBXePi7u/jIOhd7u4ByIO9iIx4bwPlvzB
GUdvQsVhte/8vxz9BhwSBol2l4vjfKdVEfIFeYhkeJ+L28s4iENGIVmRjO/p
dOvHX2U8YACjA4CQ+2Yfc8yv87V0C3orckefdN9gBAxFzsF5EH17F0qqa0KB
UIiOIL1NKVLHpocKmtGadqt6oDL/Llx/K3pOluQoBe/qxFrWcOzgWpxKBtB3
Mu904/HtGDcEF/0C7G91cTwe0F5Y0PkWF3Ug+g46CrebS1n3cIEL1ambXC7f
i1yQI2AE5d7h4niMTKVPU4/f7KL4SyX6ngvRoTy40UX9MPoBUYfmEP52F/dI
wQKaBW5yUT/ia5iPQNE684aSF34cZY3xQc53uTwa8wRcqPq9zUX9lK+hC7xA
Nfp6F8UzHFrpygQhuc5F/Zyv4QKoRaf+fuAvCnrRXGW9i3os5h/8TtpfU/LB
4RiVoPW4y+OXUWuEhLLuahf1K76GG2VllrzVRcmes6yk6PQtnW515zfRRtlk
T97c6a96HI05CY1pXXdln3S/jXmFYk0+XVfRjirN0YgKnh/rk/vv+Bp9JNC9
qU+6Y4bujV199nuDXuvGYcKg3uCi/mBQa1zU4wb1+lKO/dE8HXV5/MmgVruo
P3dCNoe4rnJRvOai9w6IIp2+zkX9NeZWyET/uyxa1tP+kf/0b3yN5ESq0elr
S5b/nZ9CVaQKnV7u8hAUrIHlVMt8FK8/qQ+ip1I/fo2L+idf4zlQ5MWVLuoJ
40X/Ddm/jH8uc1G8lqZahXJGp68qeaBjPHCpy6MTbUONorl1PWqKse+VtchG
tBFepdNXMDLt5N+ZeX2HmjREXCiqX3tUvlFzeEgPlhkkna44YV4YxWAzzdQn
wyt+uJYabyw/AX1awT8nwmPA+GeZRid+a1gXnQHjjWW1GTBobL6kFjkULKpH
TDX6LlVkBAoCmYkZCfWppbW8+F1DoV+9vBY5zUhd0gOZS69HyjcSKFdhRL24
FinfCeR9d3EPJKIB6dQrc2QEzjRSL6rlNctIfVkPJKRiTUQ21yOfwvdQoFCm
6PTCWuRT+Z5MZOn0pT2QsiLqjuQdVXqngpDT6aKKd2ZHS0JOL6rldarxY7sW
+TS+J2s7On1JD6Ssm8iPgoyV0v5HjJ2bUMP/V1IYA17c0cowoEhhE5jVc4EG
iCd5ocClSzWxe0bUPJ3v5eP/BS6nyhfNnbxenmbyYGHfHKwuw9G7YGY4Tbpq
yheyMAqm0en5GqleVVMoZZ5PMT6/NhtON7E8rwcy73/1yDM65f63QJEReIaJ
/YJaXs/ke3n1HKlFnmliOL8HMs+XeqR8a5VXJ//dVY5ERZbXml2QJ/Mrp2TK
fwChM9f1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->33574964]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " can solve a mixed system of differential and algebraic equations, referred \
to as ",
 StyleBox["differential-algebraic equations",
  FontSlant->"Italic"],
 " (DAEs). In fact, the example above is an example of a sort of DAE, where \
the equations are not expressed explicitly in terms of the derivatives.",
 " ",
 "Typically, however, in DAEs, you are not able to solve for the derivatives \
at all and the problem must be solved using a different method entirely."
}], "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1207072263],

Cell["Here is a simple DAE.", "MathCaption",
 CellID->1893538755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
       RowBox[{"y", "[", "t", "]"}]}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "^", "2"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], "^", "2"}]}], " ", "\[Equal]", " ", 
      "1"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->240895414],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndsz\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"At \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\
\\(t\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" == \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(1.6656481721762058`\\)\\!\\(\\*StyleBox[\\\"\\\\\\\", \
step size is effectively zero; singularity or stiff system suspected.\\\\\\\"\
\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NDSolve/ndsz\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[9]:=",
 CellID->2063305692],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.6656481721761867`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.6656481721761867`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->374216355]
}, Open  ]],

Cell[TextData[{
 "Note that while both of the equations have derivative terms, the variable \
",
 StyleBox["y",
  FontSlant->"Italic"],
 " appears without any derivatives, so ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " issues a warning message. When the usual substitution to convert to first \
order equations is made, one of the equations does indeed become effectively \
algebraic."
}], "Text",
 CellID->1562051593],

Cell[TextData[{
 "Also, since ",
 StyleBox["y",
  FontSlant->"Italic"],
 " only appears algebraically, it is not necessary to give an initial \
condition to determine its values. Finding initial conditions that are \
consistent with DAEs can, in fact, be quite difficult.",
 " ",
 "The tutorial on ",
 StyleBox[ButtonBox["DAEs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveIntroductoryTutorialDAEs"], "MR"],
 " has more information."
}], "Text",
 CellID->1483163037],

Cell["This shows a plot of the solutions.", "MathCaption",
 CellID->1252229693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", " ", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], " ", "/.", " ", "%"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1.66"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->2079832720],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJwVx3swFAgAx3Gvoy6MEwqTO6YiOedxbi+cn1FWOu+UTYyl8WoIkccWp5xc
3qUOXRkbadAu50zecxySaL3XrsdiWbZda73fU7f98Z3vfHQDIjwCZaSkpCDp
y62qnX2OmgTYkOV0vL68NrBK6XCVLaDDGZin2UKTlkRborsh/l2p3JvXbuhx
C0qcoJPhGmOdnlhBRqmed+AQPRJV10PqviuLxMNDnmwGPRmEgA/zMc+ToSDl
ntdLzwXJcJxvlpkLO4prZA+9GOHjf1C3Q4uhY/5KMTTgb8S6dYTUM6rhKbfC
lxluQPPqRHvlw3rEnx9bfKrUBqJGmLS/+F+8dDK4I5vRie5L5de4w+2ISLrq
WtfUjQMDHpYt7l04ukQ5Y0lkYIf57HDRzns0PhcyO3wH8KtCqs+rKAYIVxXN
VW8OobahSJnd3Y8SQomWwz8j0Kowjti7MQhOhVGpLmMUx0Q1FcPCIaxmDt8M
4LDRPPUpz+TyCDazVnvTtScg89fTkOIhJt6dkO0mmXHAmbFXUP+ehXNL5wwU
rKah46bm1FrAxjd385WfeM1grY0cfGttDPZ+s50bZC4KtDn9usYTWHES2L1P
noV0IVuUSZmE3H1BblTWHHgefj/LlXOQw3hZmlnNQ/r1Gy4s/hTSXJbHvBnz
qHGsf1yXNY15zR+5e6wFRMVpu9A0Z9CyblalssuH9QJhyJ8+gz2t087bCgI0
K9vqU3/ioiy+RilPRQiq6kmhbCMX3bz1POoPi9CzbjIlE2dxschEeM9KBM/H
cSl5XbO4FKR/gOW7BBs9Cm3NfQ7tgTSHaYoY0VQhOYw1B2eSxmtfu2WEhtRK
cz15iEk1P5I6uAzvkmejR8Z5cCF9EKhfWUEMU71K7DWPqbd0V6nJFZRNH/r6
9OA8jFrC84+HrUJV3ihWdHkBRlfKHWpWVpHRQrQ2G1oA/85/Ywn31qAYZutH
8+aDRCQxKw6u41HCfh9hjI+kSotrFtnriPOmOKaRPoJcsDy4c2wD+65hRNfZ
j9gwNKjUL91A+nJK6WiQAET7X4JyLDZhUxl7YmdLAJe9whq3jk00CX5z/P2B
EAe9ooNvO24h8UF+dLjaIpItDT9PsbdwsXckdoO+iMp238808ja2Wz3sA86K
kMln5Y7MbcP5rFH5ebYIp56YfkWI2UGhSmR/7N0lUBbkudK7O9i4zfK6cFyM
tLYGqnzGLvzGX/QZT4ix3tRDNs2SOMRo/xNHDMMGz1Zi9i4WtRLsg6fFeEvQ
jByQ2MZCEKs9I4Za3F6XRs4ulnOZj25J3PjnYvQZiVOYhdQXEmef5HVfkLiz
3fhUg8T+bya/9ZE4eI5X3Sfx/ynKC1A=
     "]]}, {
    {Hue[0.90606797749979, 0.6, 0.6]}, LineBox[CompressedData["
1:eJwV0Xs0lIkbB3ChadlGsbK5lNSSXA6TLKr1LbuM1r1YUiK3PXbJoJ9aG5u2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     "]]}},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  ImageSize->Automatic,
  Method->{},
  PlotRange->{{0, 1.66}, {0., 0.999999999999999}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->497711672]
}, Open  ]],

Cell[TextData[{
 "From the plot, you can see that the derivative of ",
 StyleBox["y",
  FontSlant->"Italic"],
 " is tending to vary arbitrarily fast.",
 " ",
 "Even though it does not explicitly appear in the equations, this condition \
means that the solver cannot continue further."
}], "Text",
 CellID->349681429],

Cell[TextData[{
 "Unknown functions in differential equations do not necessarily have to be \
represented by single symbols. If you have a large number of unknown \
functions, for example, you will often find it more convenient to give the \
functions names like ",
 StyleBox["x", "MR"],
 StyleBox["[", "MR"],
 StyleBox["i", "MR"],
 StyleBox["]", "MR"],
 " or ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox[
     StyleBox["x",
      FontSlant->"Plain"], 
     StyleBox["i",
      FontSlant->"Plain"]], "MR"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"},
 CellID->2021358328],

Cell["\<\
This constructs a set of twenty-five coupled differential equations and \
initial conditions and solves them.\
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
 CellID->1414283321],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "25"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    FormBox[
     SubscriptBox["x", "0"],
     TraditionalForm], "[", "t_", "]"}], ":=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    FormBox[
     SubscriptBox["x", "n"],
     TraditionalForm], "[", "t_", "]"}], ":=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eqns", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["x", "i"], "'"}], "[", "t", "]"}], " ", "\[Equal]", 
        " ", 
        RowBox[{
         SuperscriptBox["n", "2"], 
         RowBox[{"(", " ", 
          RowBox[{
           RowBox[{
            SubscriptBox["x", 
             RowBox[{"i", "+", "1"}]], "[", "t", "]"}], " ", "-", " ", 
           RowBox[{"2", " ", 
            RowBox[{
             SubscriptBox["x", "i"], "[", "t", "]"}]}], " ", "+", " ", 
           RowBox[{
            SubscriptBox["x", 
             RowBox[{"i", "-", "1"}]], "[", "t", "]"}]}], ")"}]}]}], ",", " ",
        
       RowBox[{
        RowBox[{
         SubscriptBox["x", "i"], "[", "0", "]"}], " ", "\[Equal]", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"i", "/", "n"}], ")"}], "10"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "i"], "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"NDSolve", "[", 
  RowBox[{"eqns", ",", "vars", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", ".25"}], "}"}]}], "]"}]}], "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"In[11]:=",
 CellID->1485025949],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{371, 407},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"Out[16]=",
 CellID->556037485]
}, Open  ]],

Cell[TextData[{
 "This actually computes an approximate solution of the heat equation for a \
rod with constant temperatures at either end of the rod.",
 " ",
 "(For more accurate solutions, you can increase ",
 StyleBox["n",
  FontSlant->"Italic"],
 ".)"
}], "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1833664140],

Cell["\<\
The result is an approximate solution to the heat equation for a \
1-dimensional rod of length 1 with constant temperature maintained at either \
end. This shows the solutions considered as spatial values as a function of \
time.\
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
 CellID->1486983100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"vars", " ", "/.", " ", 
     RowBox[{"First", "[", "%", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", ".25", ",", ".025"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"In[17]:=",
 CellID->2135121774],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 279},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"Out[17]=",
 CellID->233609777]
}, Open  ]],

Cell[TextData[{
 "An unknown function can also be specified to have a vector (or matrix) \
value. The dimensionality of an unknown function is taken from its initial \
condition. You can mix scalar and vector unknown functions as long as the \
equations have consistent dimensionality according to the rules of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " arithmetic. The InterpolatingFunction result will give values with the \
same dimensionality as the unknown function.",
 " ",
 "Using non-scalar variables is very convenient when a system of differential \
equations is governed by a process that may be difficult or inefficient to \
express symbolically."
}], "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->540750920],

Cell["\<\
This uses a vector valued unknown function to solve the same system as above.\
\
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
 CellID->1281834080],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", "?", "VectorQ"}], "]"}], " ", ":=", " ", 
   RowBox[{"ListConvolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", "x", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", "0"}], "]"}]}], ";"}], "\n", 
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"X", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"f", "[", 
       RowBox[{"X", "[", "t", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"X", "[", "0", "]"}], " ", "\[Equal]", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"n", "-", "1"}], "]"}], "/", "n"}], ")"}], "^", "10"}]}]}], 
    "}"}], ",", "X", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", ".25"}], "}"}]}], "]"}]}], "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"In[18]:=",
 CellID->1800041850],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"X", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.25`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{323, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"Out[19]=",
 CellID->347002595]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is able to solve some partial differential equations directly when you \
specify more independent variables."
}], "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->701528743],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", "{", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "2"], ",", 
     StyleBox["...", "TI"], "}", ",", 
     StyleBox["u", "TI"], ",", "{", 
     StyleBox["t", "TI"], ",", 
     StyleBox["tmin", "TI"], ",", 
     StyleBox["tmax", "TI"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["xmin", "TI"], ",", 
     StyleBox["xmax", "TI"], "}", ",", 
     StyleBox["...", "TI"], "]"}], Cell[TextData[{
     "solve a sytem of partial differential equations for a function ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "[", 
       StyleBox["t", "TI"], ",", 
       StyleBox["x", "TI"], 
       StyleBox["...", "TI"], "]"}]], "InlineFormula"],
     " with ",
     StyleBox["t", "TI"],
     " in the range ",
     StyleBox["tmin", "TI"],
     " to ",
     StyleBox["tmax", "TI"],
     " and ",
     StyleBox["x", "TI"],
     " in the range ",
     StyleBox["xmin", "TI"],
     " to ",
     StyleBox["xmax", "TI"],
     ", ..."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", "{", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "2"], ",", 
     StyleBox["...", "TI"], "}", 
     StyleBox[",", "MR"], "{", 
     SubscriptBox[
      StyleBox["u", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["u", "TI"], "2"], ",", 
     StyleBox["...", "TI"], "}", ",", "{", 
     StyleBox["t", "TI"], ",", 
     StyleBox["tmin", "TI"], ",", 
     StyleBox["tmax", "TI"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["xmin", "TI"], ",", 
     StyleBox["xmax", "TI"], "}", ",", 
     StyleBox["...", "TI"], "]"}], Cell[TextData[{
     "solve a system of partial differential equations for several functions \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], "i"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->41872761],

Cell["\<\
Finding numerical solutions to partial differential equations. \
\>", "Caption",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1246456493],

Cell[TextData[{
 "Here is a solution of the heat equation found directly by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
 CellID->1342052705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      SuperscriptBox["x", "10"]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"0", ",", "t"}], "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}], " ", "\[Equal]", " ", "1"}]}], "}"}], 
   ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", ".25"}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"In[20]:=",
 CellID->46627739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.25`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{387, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"Out[20]=",
 CellID->190032263]
}, Open  ]],

Cell["Here is a plot of the solution. ", "MathCaption",
 CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
 CellID->1429930124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], " ", "/.", " ", "%"}], "]"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", ".25"}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"In[21]:=",
 CellID->204763040],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 292},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"Out[21]=",
 CellID->84568514]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " currently uses the numerical method of lines to compute solutions to \
partial differential equations. The method is restricted to problems that can \
be posed with an initial condition in at least one independent variable. For \
example, the method cannot solve elliptic PDEs such as Laplace's equation \
because these require boundary values. For the problems it does solve, the \
method of lines is quite general, handling systems of PDEs or nonlinearity \
well, and often quite fast.",
 " ",
 "Details of the method are given in \"",
 ButtonBox["Numerical Solution of Partial Differential Equations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolvePDE"],
 "\"."
}], "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1175985231],

Cell["\<\
This finds a numerical solution to a generalization of the nonlinear sine\
\[Hyphen]Gordon equation to two spatial dimensions with periodic boundary \
conditions.\
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"},
 CellID->445658454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", " ", "x", ",", " ", "y"}], "]"}], ",", " ", "t", 
        ",", " ", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", " ", "x", ",", " ", "y"}], "]"}], ",", " ", "x", 
         ",", " ", "x"}], "]"}], " ", "+", " ", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", " ", "x", ",", " ", "y"}], "]"}], ",", " ", "y", 
         ",", " ", "y"}], "]"}], " ", "-", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", " ", "x", ",", " ", "y"}], "]"}], "]"}]}]}], ",", 
     " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"0", ",", " ", "x", ",", " ", "y"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "u", "]"}], "[", 
       RowBox[{"0", ",", "x", ",", "y"}], "]"}], " ", "\[Equal]", " ", "0"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", " ", 
        RowBox[{"-", "5"}], ",", " ", "y"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", " ", "5", ",", " ", "y"}], "]"}], " ", "\[Equal]", 
      " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", " ", "x", ",", " ", 
        RowBox[{"-", "5"}]}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", " ", "x", ",", " ", "5"}], "]"}], " ", "\[Equal]", 
      " ", "0"}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"In[22]:=",
 CellID->1957259914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "3.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5.`"}], ",", "5.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5.`"}], ",", "5.`"}], "}"}]}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{453, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"Out[22]=",
 CellID->1599270862]
}, Open  ]],

Cell["\<\
Here is a plot of the result at t\[Equal]3.\
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"},
 CellID->2007710047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"3", ",", "x", ",", "y"}], "]"}], " ", "/.", " ", "%"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"In[23]:=",
 CellID->1292939303],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1XAdUFEm3bnRcGdEREcMaQBRYc86iXWbB7Jpz4jcCJswKiIKoqCAq6Lpm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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmQf8T9Ubx++553sqIav8SUIoM0SDhCRbCYmyR0s77aGMtmiKaJe0B8pW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         "]], Polygon3DBox[CompressedData["
1:eJwtmnOgJFceRqtv3Q53w4ltmxtONBPbnti2bdt2srFte2MnG9vJhnvO++qP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         "]], Polygon3DBox[CompressedData["
1:eJwt13fcjvUeB/Db476JaBjJSk4IKR2P/ZAQZWdmRkZZZRbKLHtmZzZk1mnZ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         "]], 
        Polygon3DBox[{{1177, 833, 832, 1176, 710, 711}, {1054, 1053, 700, 324,
          325, 701}}]}]}, {}, {}, {}}, {
     Line3DBox[{270, 1, 266, 227, 738, 16, 752, 31, 767, 46, 782, 61, 797, 76,
       812, 91, 828, 829, 106, 856, 121, 870, 136, 884, 151, 899, 166, 914, 
      181, 929, 196, 1070, 247, 272, 211, 268, 260, 481, 212, 482, 213, 483, 
      214, 484, 215, 485, 216, 486, 217, 487, 488, 218, 489, 219, 490, 220, 
      491, 221, 492, 222, 493, 223, 494, 224, 727, 249, 273, 225, 269, 261, 
      956, 210, 942, 195, 927, 180, 912, 165, 897, 150, 882, 135, 868, 120, 
      854, 853, 105, 825, 90, 810, 75, 795, 60, 780, 45, 765, 30, 1048, 229, 
      271, 15, 267, 251, 301, 14, 299, 13, 297, 12, 295, 11, 293, 10, 291, 9, 
      289, 8, 286, 285, 7, 283, 6, 281, 5, 279, 4, 277, 3, 275, 2, 728, 250, 
      270}], {{}, 
      Line3DBox[{738, 1046, 495, 737, 1282, 957, 739, 1283, 958, 740, 1284, 
       959, 741, 1285, 960, 742, 1286, 961, 743, 1287, 1081, 1183, 744, 1288, 
       962, 745, 1289, 963, 746, 1290, 964, 747, 1291, 965, 748, 1292, 966, 
       749, 1293, 967, 750, 1294, 1047, 968, 1048}], 
      Line3DBox[{752, 1082, 1184, 751, 510, 753, 1295, 969, 754, 1296, 970, 
       755, 1297, 971, 756, 1298, 972, 757, 1299, 1083, 1185, 758, 1084, 1186,
        759, 1300, 973, 760, 1301, 974, 761, 1302, 975, 762, 1303, 976, 763, 
       1304, 977, 764, 1305, 978, 765}], 
      Line3DBox[{767, 1085, 1187, 766, 1086, 1188, 768, 526, 769, 1306, 979, 
       770, 1307, 980, 771, 1308, 981, 772, 1309, 1087, 1189, 773, 1088, 1190,
        774, 1089, 1191, 775, 1310, 982, 776, 1311, 983, 777, 1312, 984, 778, 
       1313, 985, 779, 1314, 986, 780}], 
      Line3DBox[{782, 1090, 1192, 781, 1091, 1193, 783, 1092, 1194, 784, 542, 
       785, 1315, 987, 786, 1316, 1049, 1050, 787, 1317, 1053, 1054, 1195, 
       788, 1093, 1196, 789, 1094, 1197, 790, 1095, 1198, 791, 1318, 988, 792,
        1319, 989, 793, 1320, 990, 794, 1321, 991, 795}], 
      Line3DBox[{797, 1096, 1199, 796, 1097, 1200, 798, 1098, 1201, 799, 1099,
        1202, 800, 556, 801, 1322, 1051, 1072, 1052, 802, 1323, 1055, 1073, 
       1056, 1203, 803, 1100, 1204, 804, 1101, 1205, 805, 1102, 1206, 806, 
       1103, 1207, 807, 1324, 992, 808, 1325, 993, 809, 1326, 994, 810}], 
      Line3DBox[{812, 1104, 1208, 811, 1105, 1209, 813, 1106, 1210, 814, 1174,
        1380, 1057, 815, 1175, 1381, 1058, 816, 568, 817, 1327, 1107, 1211, 
       818, 1108, 1212, 819, 1109, 1213, 820, 1110, 1214, 821, 1111, 1215, 
       822, 1112, 1216, 823, 1328, 995, 824, 1329, 996, 825}], 
      Line3DBox[{829, 1330, 997, 827, 1331, 998, 831, 1332, 999, 833, 1177, 
       1383, 1000, 1074, 1179, 1385, 1001, 836, 1333, 1002, 838, 1334, 583, 
       840, 1335, 1003, 842, 1336, 1004, 844, 1337, 1005, 846, 1338, 1006, 
       848, 1339, 1007, 850, 1340, 1008, 852, 1341, 1009, 854}], 
      Line3DBox[{853, 590, 851, 1227, 1122, 849, 1226, 1121, 847, 1225, 1120, 
       845, 1224, 1119, 843, 1223, 1118, 841, 1222, 1117, 839, 1221, 582, 837,
        1220, 1116, 835, 1060, 1384, 1178, 834, 1059, 1382, 1176, 832, 1219, 
       1115, 830, 1218, 1114, 826, 1217, 1113, 828}], 
      Line3DBox[{856, 1123, 1228, 855, 1342, 1010, 857, 1343, 1011, 858, 1344,
        1012, 859, 1345, 1013, 860, 1346, 1014, 861, 1347, 1124, 1229, 862, 
       599, 863, 1348, 1015, 864, 1061, 1386, 1016, 1075, 1180, 1387, 1017, 
       865, 1349, 1018, 866, 1350, 1019, 867, 1351, 1020, 868}], 
      Line3DBox[{870, 1125, 1230, 869, 1126, 1231, 871, 1352, 1021, 872, 1353,
        1022, 873, 1354, 1023, 874, 1355, 1024, 875, 1356, 1127, 1232, 876, 
       1128, 1233, 877, 614, 878, 1062, 1388, 1025, 1076, 1181, 1389, 1026, 
       879, 1357, 1027, 880, 1358, 1028, 881, 1359, 1029, 882}], 
      Line3DBox[{884, 1129, 1234, 883, 1130, 1235, 885, 1131, 1236, 886, 1360,
        1030, 887, 1361, 1031, 888, 1362, 1032, 889, 1363, 1132, 1237, 890, 
       1063, 1077, 1133, 1238, 891, 1066, 1079, 1134, 1239, 892, 629, 893, 
       1364, 1033, 894, 1365, 1034, 895, 1366, 1035, 896, 1367, 1036, 897}], 
      Line3DBox[{899, 1135, 1240, 898, 1136, 1241, 900, 1137, 1242, 901, 1138,
        1243, 902, 1368, 1037, 903, 1369, 1038, 904, 1370, 1139, 1244, 905, 
       1064, 1078, 1065, 1245, 906, 1067, 1080, 1068, 1246, 907, 1140, 1247, 
       908, 645, 909, 1371, 1039, 910, 1372, 1040, 911, 1373, 1041, 912}], 
      Line3DBox[{914, 1141, 1248, 913, 1142, 1249, 915, 1143, 1250, 916, 1144,
        1251, 917, 1145, 1252, 918, 1374, 1042, 919, 1375, 1146, 1253, 920, 
       1147, 1254, 921, 1148, 1255, 922, 1149, 1256, 923, 1150, 1257, 924, 
       661, 925, 1376, 1043, 926, 1377, 1044, 927}], 
      Line3DBox[{929, 1151, 1258, 928, 1152, 1259, 930, 1153, 1260, 931, 1154,
        1261, 932, 1155, 1262, 933, 1156, 1263, 934, 1378, 1157, 1264, 935, 
       1158, 1265, 936, 1159, 1266, 937, 1160, 1267, 938, 1161, 1268, 939, 
       1162, 1269, 940, 677, 941, 1379, 1045, 942}], 
      Line3DBox[{956, 1071, 725, 955, 1281, 1173, 954, 1280, 1172, 953, 1279, 
       1171, 952, 1278, 1170, 951, 1277, 1169, 950, 1276, 1168, 949, 1275, 
       685, 948, 1274, 1167, 947, 1273, 1166, 946, 1272, 1165, 945, 1271, 
       1164, 944, 1270, 1163, 943, 1182, 1390, 1069, 1070}]}, {{}, 
      Line3DBox[{275, 496, 1282, 276, 510, 304, 1188, 525, 319, 1193, 540, 
       334, 1200, 553, 347, 1209, 566, 362, 1218, 579, 1331, 377, 592, 1342, 
       392, 1231, 606, 407, 1235, 620, 422, 1241, 635, 437, 1249, 650, 452, 
       1259, 665, 467, 1270, 680, 482}], 
      Line3DBox[{277, 497, 1283, 278, 511, 1295, 305, 526, 320, 1194, 541, 
       335, 1201, 554, 348, 1210, 567, 363, 1219, 580, 1332, 378, 593, 1343, 
       393, 607, 1352, 408, 1236, 621, 423, 1242, 636, 438, 1250, 651, 453, 
       1260, 666, 468, 1271, 681, 483}], 
      Line3DBox[{279, 498, 1284, 280, 512, 1296, 306, 527, 1306, 321, 542, 
       336, 1202, 555, 349, 1380, 706, 707, 364, 1382, 710, 711, 1383, 379, 
       594, 1344, 394, 608, 1353, 409, 622, 1360, 424, 1243, 637, 439, 1251, 
       652, 454, 1261, 667, 469, 1272, 682, 484}], 
      Line3DBox[{281, 499, 1285, 282, 513, 1297, 307, 528, 1307, 322, 543, 
       1315, 337, 556, 350, 1381, 708, 731, 709, 365, 1384, 712, 732, 713, 
       1385, 380, 595, 1345, 395, 609, 1354, 410, 623, 1361, 425, 638, 1368, 
       440, 1252, 653, 455, 1262, 668, 470, 1273, 683, 485}], 
      Line3DBox[{283, 500, 1286, 284, 514, 1298, 308, 529, 1308, 323, 696, 
       1316, 697, 729, 698, 1322, 699, 351, 568, 366, 1220, 581, 1333, 381, 
       596, 1346, 396, 610, 1355, 411, 624, 1362, 426, 639, 1369, 441, 654, 
       1374, 456, 1263, 669, 471, 1274, 684, 486}], 
      Line3DBox[{285, 501, 1287, 287, 515, 1299, 309, 530, 1309, 324, 700, 
       1317, 702, 730, 703, 1323, 705, 352, 569, 1327, 367, 582, 1334, 382, 
       597, 1347, 397, 611, 1356, 412, 625, 1363, 427, 640, 1370, 442, 655, 
       1375, 457, 670, 1378, 472, 685, 487}], 
      Line3DBox[{289, 503, 1288, 290, 1186, 517, 311, 1190, 532, 326, 1196, 
       545, 339, 1204, 558, 354, 1212, 571, 369, 1222, 584, 1335, 384, 599, 
       399, 1233, 613, 414, 720, 1238, 627, 429, 721, 1245, 642, 444, 1254, 
       657, 459, 1265, 672, 474, 1276, 687, 489}], 
      Line3DBox[{291, 504, 1289, 292, 518, 1300, 312, 1191, 533, 327, 1197, 
       546, 340, 1205, 559, 355, 1213, 572, 370, 1223, 585, 1336, 385, 600, 
       1348, 400, 614, 415, 722, 1239, 628, 430, 723, 1246, 643, 445, 1255, 
       658, 460, 1266, 673, 475, 1277, 688, 490}], 
      Line3DBox[{293, 505, 1290, 294, 519, 1301, 313, 534, 1310, 328, 1198, 
       547, 341, 1206, 560, 356, 1214, 573, 371, 1224, 586, 1337, 386, 714, 
       733, 601, 1386, 401, 717, 735, 615, 1388, 416, 629, 431, 1247, 644, 
       446, 1256, 659, 461, 1267, 674, 476, 1278, 689, 491}], 
      Line3DBox[{295, 506, 1291, 296, 520, 1302, 314, 535, 1311, 329, 548, 
       1318, 342, 1207, 561, 357, 1215, 574, 372, 1225, 587, 1338, 387, 715, 
       734, 716, 1387, 402, 718, 736, 719, 1389, 417, 630, 1364, 432, 645, 
       447, 1257, 660, 462, 1268, 675, 477, 1279, 690, 492}], 
      Line3DBox[{297, 507, 1292, 298, 521, 1303, 315, 536, 1312, 330, 549, 
       1319, 343, 562, 1324, 358, 1216, 575, 373, 1226, 588, 1339, 388, 602, 
       1349, 403, 616, 1357, 418, 631, 1365, 433, 646, 1371, 448, 661, 463, 
       1269, 676, 478, 1280, 691, 493}], 
      Line3DBox[{299, 508, 1293, 300, 522, 1304, 316, 537, 1313, 331, 550, 
       1320, 344, 563, 1325, 359, 576, 1328, 374, 1227, 589, 1340, 389, 603, 
       1350, 404, 617, 1358, 419, 632, 1366, 434, 647, 1372, 449, 662, 1376, 
       464, 677, 479, 1281, 692, 494}], 
      Line3DBox[{301, 694, 1294, 695, 302, 523, 1305, 317, 538, 1314, 332, 
       551, 1321, 345, 564, 1326, 360, 577, 1329, 375, 590, 1341, 390, 604, 
       1351, 405, 618, 1359, 420, 633, 1367, 435, 648, 1373, 450, 663, 1377, 
       465, 678, 1379, 480, 725, 726, 727}], 
      Line3DBox[{481, 679, 724, 1390, 466, 664, 1258, 451, 649, 1248, 436, 
       634, 1240, 421, 619, 1234, 406, 605, 1230, 391, 591, 1228, 376, 1330, 
       578, 1217, 361, 565, 1208, 346, 552, 1199, 333, 539, 1192, 318, 524, 
       1187, 303, 509, 1184, 274, 495, 693, 728}], 
      Line3DBox[{488, 686, 1275, 473, 671, 1264, 458, 656, 1253, 443, 641, 
       1244, 428, 626, 1237, 413, 612, 1232, 398, 598, 1229, 383, 583, 1221, 
       368, 570, 1211, 353, 557, 1203, 704, 338, 544, 1195, 701, 325, 531, 
       1189, 310, 516, 1185, 288, 502, 1183, 286}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0fHk8l833PhKPtGhRaFGivSyJFCZSlkrWIkmyV6IUFbJmTdmXRGTLkp0Q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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageMargins->0.,
  ImageSize->Automatic,
  Method->{
   "RotationControl" -> "Globe", "SpherePoints" -> Automatic, 
    "CylinderPoints" -> Automatic},
  PlotRange->{{-5, 5}, {-5, 5}, {-0.231409925782279, 0.052109807077}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{364, 292},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:1", "ndsg:0"},
 CellLabel->"Out[23]=",
 CellID->1654332481,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "As mentioned above, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " works by taking a sequence of steps in the independent variable ",
 StyleBox["t", "TI"],
 ". ",
 StyleBox["NDSolve", "MR"],
 " uses an adaptive procedure to determine the size of these steps. In \
general, if the solution appears to be varying rapidly in a particular \
region, then ",
 StyleBox["NDSolve", "MR"],
 " will reduce the step size to be able to better track the solution. "
}], "Text",
 CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"},
 CellID->1940059119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " allows you to specify the precision or accuracy of result you want. In \
general, ",
 StyleBox["NDSolve", "MR"],
 " makes the steps it takes smaller and smaller until the solution reached \
satisfies either the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " ",
 StyleBox["or", "TI"],
 " the ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " you give. The setting for ",
 StyleBox["AccuracyGoal", "MR"],
 " effectively determines the absolute error to allow in the solution, while \
the setting for ",
 StyleBox["PrecisionGoal", "MR"],
 " determines the relative error. If you need to track a solution whose value \
comes close to zero, then you will typically need to increase the setting for \
",
 StyleBox["AccuracyGoal", "MR"],
 ". By setting ",
 StyleBox["AccuracyGoal -> Infinity", "MR"],
 ", you tell ",
 StyleBox["NDSolve", "MR"],
 " to use ",
 StyleBox["PrecisionGoal", "MR"],
 " only. Generally, ",
 StyleBox["AccuracyGoal", "MR"],
 " and ",
 StyleBox["PrecisionGoal", "MR"],
 " are used to control the error local to a particular time step. For some \
differential equations, this error can accumulate, so it is possible that the \
precision or accuracy of the result at the end of the time interval may be \
much less than what you might expect from the settings of ",
 StyleBox["AccuracyGoal", "MR"],
 " and ",
 StyleBox["PrecisionGoal.", "MR"],
 "\n",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " uses the setting you give for ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " to determine the precision to use in its internal computations. If you \
specify large values for ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 ", then you typically need to give a somewhat larger value for ",
 StyleBox["WorkingPrecision", "MR"],
 ". With the default setting of ",
 StyleBox["Automatic", "MR"],
 ", ",
 StyleBox["AccuracyGoal", "MR"],
 " and ",
 StyleBox["PrecisionGoal", "MR"],
 " are both equal to half of the setting for ",
 StyleBox["WorkingPrecision", "MR"],
 "."
}], "Text",
 CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"},
 CellID->1076263921],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " uses error estimates for determining whether it is meeting the specified \
tolerances. When working with systems of equations, it uses the setting of \
the option ",
 StyleBox["NormFunction->f ", "MR"],
 "to combine errors in different components. The norm is scaled in terms of \
the tolerances, given so that ",
 StyleBox["NDSolve", "MR"],
 " tries to take steps such that \n",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       SubscriptBox["err", "1"], 
       RowBox[{
        RowBox[{
         SubscriptBox["tol", "r"], 
         RowBox[{"Abs", "[", 
          SubscriptBox["x", "1"], "]"}]}], " ", "+", " ", 
        SubscriptBox["tol", "a"]}]], ",", " ", 
      FractionBox[
       SubscriptBox["err", "2"], 
       RowBox[{
        RowBox[{
         SubscriptBox["tol", "r"], 
         RowBox[{"Abs", "[", 
          SubscriptBox["x", "2"], "]"}]}], " ", "+", " ", 
        SubscriptBox["tol", "a"]}]], ",", " ", "..."}], "}"}], "]"}], " ", 
   "\[LessEqual]", " ", "1"}]]],
 "\nwhere ",
 Cell[BoxData[
  SubscriptBox["err", "i"]]],
 "is the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["i", "th"], TraditionalForm]]],
 "component of the error and ",
 Cell[BoxData[
  SubscriptBox["x", "i"]]],
 " is the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["i", 
    RowBox[{"th", " "}]], TraditionalForm]]],
 "component of the current solution."
}], "Text",
 CellID->1312728516],

Cell["\<\
This generates a high\[Hyphen]precision solution to a differential equation. \
\
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"},
 CellID->1813933799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'''"}], "[", "t", "]"}], "==", 
      RowBox[{"x", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "==", 
      RowBox[{
       RowBox[{"x", "''"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", "x", 
   ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "->", "20"}], ",", 
   RowBox[{"PrecisionGoal", "->", "20"}], ",", 
   RowBox[{"WorkingPrecision", "->", "25"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[24]:=",
 CellID->343063594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.`25."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{470, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[24]=",
 CellID->517167345]
}, Open  ]],

Cell["Here is the value of the solution at the endpoint.", "MathCaption",
 CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"},
 CellID->1306488759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "[", "1", "]"}], "/.", "%"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[25]:=",
 CellID->29244087],

Cell[BoxData[
 RowBox[{"{", "1.16805831337591852558062006876187245696`24.843082604958617", 
  "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[25]=",
 CellID->1777658954]
}, Open  ]],

Cell[TextData[{
 "Through its adaptive procedure, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is able to solve \[OpenCurlyDoubleQuote]stiff\[CloseCurlyDoubleQuote] \
differential equations in which there are several components varying with ",
 StyleBox["t", "TI"],
 " at extremely different rates."
}], "Text",
 CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"},
 CellID->1294126886],

Cell[TextData[{
 StyleBox["NDSolve", "MR"],
 " follows the general procedure of reducing step size until it tracks \
solutions accurately. There is a problem, however, when the true solution has \
a singularity. In this case, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " might go on reducing the step size forever, and never terminate. To avoid \
this problem, the option ",
 StyleBox["MaxSteps", "MR"],
 " specifies the maximum number of steps that ",
 StyleBox["NDSolve", "MR"],
 " will ever take in attempting to find a solution. For ordinary differential \
equations, the default setting is ",
 StyleBox["MaxSteps -> 10000", "MR"],
 ". "
}], "Text",
 CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
 CellID->1379597626],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " stops after taking 10,000 steps. "
}], "MathCaption",
 CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"},
 CellID->530521190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"1", "/", 
       RowBox[{"x", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"-", "1"}], "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[26]:=",
 CellID->428477318],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxst\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Maximum number of \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(10000\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" steps reached at \
the point \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(x\\)\\!\\(\\*StyleBox[\\\"\\\\\\\
\" == \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(-1.0041321640972122`*^-172\\)\\!\\(\\*StyleBox[\\\"\\\\\\\
\".\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NDSolve/mxst\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"During evaluation of In[26]:=",
 CellID->595309333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", 
           RowBox[{"-", "1.0041321640972122`*^-172"}]}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{447, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[26]=",
 CellID->1831950394]
}, Open  ]],

Cell[TextData[{
 "There is in fact a singularity in the solution at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"},
 CellID->1130006062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[27]:=",
 CellID->1074028589],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJwBQQS++yFib1JlAgAAAEMAAAACAAAAlx8L9f//7788cHoFAADwP7j8EcR8
/e+/OoDEu0EB8D/Y2RiT+frvv8AONqCDAvA/GpQmMfP177/9oT8BCAXwP5wI
Qm3m6++/O6HsIxMK8D+g8XjlzNfvv1xW0PUyFPA/qsPm1Zmv77/RoWIemSjw
P7xnwrYzX++/qpxCPwJS8D9q6gX14LDuv+sxTSy1rvA/D+A3ihsO7r9JBlxJ
DgnxP9s14oKHbu2/xltb0mtl8T8xxhj4bMHsv5fzLKwkzvE/fck9xN8f7L8l
geZbazTyP1IH7wzMcOu/DKKV0pGo8j9PpRi56cTqvynxKgJgIPM/QrYwvJQk
6r9TMA8FrZXzP78B1Tu5dum/+M97mGQb9D8ywGcSa9Tov8NCAbPTnvQ/zN5y
TE416L+x9H+jWyb1P/A3CgOriOe/32mL6YHB9T8KBJAQlefmv3kXepiDWvY/
rgqimvg45r+HsmOIJwr3P3lxLIiNjeW/VTBRn2XB9z86S6XMr+3kvxceIKfb
dvg/hV+qjUtA5L9XB/u6Ukj5P8bmnaV0nuO/d9qts+EY+j+RqB06F+/iv8NG
uGOXCvs/g8oVMutC4r/RlojGign8P2tf/IBMouG/N9pH5esI/T/dLm9MJ/Tg
v9JBfLopM/4/RXHQbo9R4L831oGOEGD/P6knVOlRZN+/UpN7K1lPAEDb4R/u
dwrevzavMqgeCwFA+oHIoLjH3L/mBcWyP8oBQCyXiUzsadu/OrqPrT+tAkCs
bDu/ghLav97xS+Q/owNAGSjK3zPS2L+kIObQqqAEQJlYcfnXdte/uzL1xAjS
BUAGb/XAljLWv4WISKfHEAdAwUVqT7j01L+MBIi4pW4IQJCR99bMm9O/l1ao
n2ocCkBLw2EM/FnSvwaEH5lN5gtAGWrkOh790L9N4LENOiMOQKjthy62bs+/
/AkcovRJEECyOtjRVS/Ovx9SqYhN9hBAvIcodfXvzL+JXuXqgrERQNlJkRGI
lcu/wXX3xbiPEkD2C/qtGjvKv50zzC3chBNAALQ/+Mf3yL+1ATZZn4EUQAlc
hUJ1tMe/8V1IfFGZFUAmeeOFFVbGv3u3rSIg7BZAtIeSp+Wmxb/H86VNl6UX
QEOWQcm198S/erqg1ClrGECuc5DTuJ/Dv7h6pMUyFxpAZOK3WLrzwr99mO3u
+QMbQBpR3927R8K/Qx+imygCHEByFAuW2QbBv/QWrUgAEh5AHvYgcmhmwL9I
V/MaLjgfQJSvbZzui7+/rPNNXN46IED/57FN/y++v02aL2/u9SBAaiD2/g/U
vL/ZvFHwocIhQNZYOrAgeLu/WiA7KJejIkBBkX5hMRy6v3CmL+P3myNAmK+f
wFzXuL+SwO1CYpwkQPDNwB+Ikre/E2SLWGe4JUBI7OF+s022v4kYR8O99CZA
H1Zl/J1btb8vk50e8PwnQFdlM2M=
     "]]}},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  ImageSize->Medium,
  Method->{},
  PlotRange->{{-1, 0}, {1.00000002040816, 11.9940194671013}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[27]=",
 CellID->781774652]
}, Open  ]],

Cell[TextData[{
 "The default setting ",
 StyleBox["MaxSteps", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["10000", "MR"],
 " should be sufficient for most equations with smooth solutions. When \
solutions have a complicated structure, however, you may sometimes have to \
choose larger settings for ",
 StyleBox["MaxSteps", "MR"],
 ". With the setting ",
 StyleBox["MaxSteps", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["Infinity", "MR"],
 " there is no upper limit on the number of steps used. "
}], "Text",
 CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"},
 CellID->324575119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " has several different methods built in for computing solutions as well as \
a mechanism for adding additional methods. With the default setting ",
 StyleBox["Method->Automatic", "MR"],
 ", ",
 StyleBox["NDSolve", "MR"],
 " will choose a method which should be appropriate for the differential \
equations. For example, if the equations have stiffness, implicit methods \
will be used as needed, or if the equations make a DAE, a special DAE method \
will be used. In general, it is not possible to determine the nature of \
solutions to differential equations without actually solving them: thus, the \
default Automatic methods are good for solving as wide variety of problems, \
but the one chosen may not be the best one available for your particular \
problem.",
 " ",
 "Also, you may want to choose methods, such as symplectic integrators, which \
preserve certain properties of the solution."
}], "Text",
 CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
 CellID->1120656328],

Cell[TextData[{
 "Choosing an appropriate method for a particular system can be quite \
difficult. To complicate it further, many methods have their own settings \
which can greatly affect solution efficiency and accuracy. Much of this \
documentation consists of descriptions of methods to give you an idea of when \
they should be used and how to adjust them to solve particular problems. \
Furthermore, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " has a ",
 ButtonBox["mechanism",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolvePlugIns"],
 " that allows you to define your own methods and still have the equations \
and results processed by ",
 StyleBox["NDSolve", "MR"],
 " just as for the built-in methods."
}], "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1191489329],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " computes a solution, there are typically three phases. First, the \
equations are processed, usually into a function which represents the right \
hand side of the equations in normal form. Next, the function is used to \
iterate the solution from the initial conditions. Finally, data saved during \
the iteration procedure is processed into one or more ",
 StyleBox["InterpolatingFunction", "MR",
  FontFamily->"Courier"],
 StyleBox["s", "MR"],
 ". Using functions in the ",
 StyleBox["NDSolve`", "MR",
  FontFamily->"Courier"],
 " context, you can run these steps separately and, more importantly, have \
more control over the iteration process.",
 " ",
 "The steps are tied by an ",
 StyleBox[ButtonBox["NDSolve`StateData",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveStateData"], "MR"],
 " object which keeps all of the data necessary for solving the differential \
equations."
}], "Text",
 CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
 CellID->1754505243],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->11308057],

Cell[TextData[{
 ButtonBox["Advanced Numerical Differential Equation Solving in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->604721514]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Advanced Numerical Differential Equation \
Solving in Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Advanced Numerical Differential Equation Solving in Mathematica", 
         "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NDSolveOverview"]], "Text", FontFamily -> "Verdana"],
     "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NDSolveDesign#75354863"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 52.9620628}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The Mathematica function NDSolve is a general numerical differential \
equation solver. It can handle a wide range of ordinary differential \
equations (ODEs) as well as some partial differential equations (PDEs). In a \
system of ordinary differential equations there can be any number of unknown \
functions x_i, but all of these functions must depend on a single \
'independent variable' t, which is the same for each function. Partial \
differential equations involve two or more independent variables. NDSolve can \
also solve some differential-algebraic equations (DAEs), which are typically \
a mix of differential and algebraic equations. Finding numerical solutions to \
ordinary differential equations. NDSolve represents solutions for the \
functions x_i as InterpolatingFunction objects. TheInterpolatingFunction \
objects provide approximations to the x_i over the range of values tmin to \
tmax for the independent variable t. In general, NDSolve finds solutions \
iteratively. It starts at a particular value of t, then takes a sequence of \
steps, trying eventually to cover the whole range tmin to tmax. In order to \
get started, NDSolve has to be given appropriate initial or boundary \
conditions for the x_i and their derivatives. These conditions specify values \
for x_i[t], and perhaps derivatives x_i'[t], at particular points t. When \
there is only one t at which conditions are given, the equations and initial \
conditions are collectively referred to as an initial value problem. A \
boundary value occurs when there are multiple points t. NDSolve can solve \
nearly all initial value problems that can symbolically be put in normal form \
(i.e. are solvable for the highest derivative order), but only linear \
boundary value problems.", "synonyms" -> {}, "title" -> 
    "Introduction to Advanced Numerical Differential Equation Solving in \
Mathematica", "type" -> "Tutorial", "uri" -> 
    "tutorial/NDSolveIntroductoryTutorial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "s:2.1"->{
  Cell[2065, 68, 66, 2, 70, "Section",
   CellTags->"s:2.1",
   CellID->75354863]},
 "S3.9.7"->{
  Cell[4804, 158, 152, 4, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1688868674],
  Cell[4959, 164, 2524, 81, 70, "Text",
   CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"},
   CellID->1805661336],
  Cell[7486, 247, 414, 18, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->82760112],
  Cell[7925, 269, 457, 15, 28, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->925938952],
  Cell[8385, 286, 506, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->698244241],
  Cell[8906, 307, 1853, 49, 70, "Text",
   CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"},
   CellID->1321156179],
  Cell[10762, 358, 228, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"},
   CellID->1497635469],
  Cell[11015, 367, 582, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->569913881],
  Cell[11600, 389, 506, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->471131597],
  Cell[12121, 410, 124, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"},
   CellID->447645229],
  Cell[12270, 416, 316, 10, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1244935384],
  Cell[12589, 428, 2622, 54, 254, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1319806552],
  Cell[15226, 485, 132, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"},
   CellID->1630958702],
  Cell[15383, 491, 609, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1135344520],
  Cell[15995, 513, 507, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->2067392509],
  Cell[16517, 534, 354, 10, 70, "Text",
   CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"},
   CellID->419380819],
  Cell[16874, 546, 161, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"},
   CellID->1957151],
  Cell[19031, 623, 126, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"},
   CellID->1201251468],
  Cell[30880, 837, 360, 10, 70, "Text",
   CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"},
   CellID->256584290],
  Cell[31243, 849, 164, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"},
   CellID->1567178311],
  Cell[31432, 857, 568, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->389314559],
  Cell[32003, 879, 724, 14, 70, "Message",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1114592087],
  Cell[32730, 895, 1469, 52, 94, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->494369864],
  Cell[49381, 1322, 626, 21, 70, "Text",
   CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"},
   CellID->2021358328],
  Cell[50010, 1345, 209, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1414283321],
  Cell[56434, 1504, 329, 7, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1486983100],
  Cell[110431, 2414, 179, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1281834080],
  Cell[114643, 2562, 151, 4, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1246456493],
  Cell[114797, 2568, 289, 9, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
   CellID->1342052705],
  Cell[116755, 2640, 124, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
   CellID->1429930124],
  Cell[168236, 3512, 261, 6, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"},
   CellID->445658454],
  Cell[171591, 3619, 143, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"},
   CellID->2007710047],
  Cell[338776, 6374, 627, 17, 70, "Text",
   CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"},
   CellID->1940059119],
  Cell[339406, 6393, 2752, 81, 70, "Text",
   CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"},
   CellID->1076263921],
  Cell[343739, 6530, 179, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"},
   CellID->1813933799],
  Cell[343943, 6539, 759, 24, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->343063594],
  Cell[344705, 6565, 508, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->517167345],
  Cell[345228, 6586, 142, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"},
   CellID->1306488759],
  Cell[345395, 6592, 161, 5, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->29244087],
  Cell[345559, 6599, 284, 8, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1777658954],
  Cell[345858, 6610, 458, 12, 70, "Text",
   CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"},
   CellID->1294126886],
  Cell[346319, 6624, 800, 20, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1379597626],
  Cell[347122, 6646, 257, 8, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"},
   CellID->530521190],
  Cell[347404, 6658, 554, 19, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->428477318],
  Cell[347961, 6679, 727, 14, 70, "Message",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->595309333],
  Cell[348691, 6695, 654, 22, 39, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1831950394],
  Cell[349360, 6720, 255, 8, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"},
   CellID->1130006062],
  Cell[349640, 6732, 338, 11, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1074028589],
  Cell[349981, 6745, 2032, 44, 244, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->781774652],
  Cell[352028, 6792, 594, 20, 70, "Text",
   CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"},
   CellID->324575119],
  Cell[352625, 6814, 1115, 23, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1120656328],
  Cell[354611, 6862, 1123, 28, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1754505243]},
 "b:1"->{
  Cell[4804, 158, 152, 4, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1688868674],
  Cell[4959, 164, 2524, 81, 70, "Text",
   CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"},
   CellID->1805661336],
  Cell[7486, 247, 414, 18, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->82760112],
  Cell[7925, 269, 457, 15, 28, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->925938952],
  Cell[8385, 286, 506, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->698244241],
  Cell[8906, 307, 1853, 49, 70, "Text",
   CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"},
   CellID->1321156179],
  Cell[10762, 358, 228, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"},
   CellID->1497635469],
  Cell[11015, 367, 582, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->569913881],
  Cell[11600, 389, 506, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->471131597],
  Cell[12121, 410, 124, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"},
   CellID->447645229],
  Cell[12270, 416, 316, 10, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1244935384],
  Cell[12589, 428, 2622, 54, 254, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1319806552],
  Cell[15226, 485, 132, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"},
   CellID->1630958702],
  Cell[15383, 491, 609, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1135344520],
  Cell[15995, 513, 507, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->2067392509],
  Cell[16517, 534, 354, 10, 70, "Text",
   CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"},
   CellID->419380819],
  Cell[16874, 546, 161, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"},
   CellID->1957151],
  Cell[19031, 623, 126, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"},
   CellID->1201251468],
  Cell[19182, 629, 531, 16, 28, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1294195954],
  Cell[19716, 647, 11149, 187, 239, "Output",
   Evaluatable->False,
   CellTags->{"b:1", "ndsg:0"},
   CellID->489659545],
  Cell[30880, 837, 360, 10, 70, "Text",
   CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"},
   CellID->256584290],
  Cell[31243, 849, 164, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"},
   CellID->1567178311],
  Cell[31432, 857, 568, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->389314559],
  Cell[32003, 879, 724, 14, 70, "Message",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1114592087],
  Cell[32730, 895, 1469, 52, 94, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->494369864],
  Cell[40128, 1075, 665, 16, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1207072263],
  Cell[49381, 1322, 626, 21, 70, "Text",
   CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"},
   CellID->2021358328],
  Cell[50010, 1345, 209, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1414283321],
  Cell[50244, 1354, 1907, 64, 138, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1485025949],
  Cell[52154, 1420, 3944, 69, 428, "Output",
   Evaluatable->False,
   CellTags->{"b:1", "ndsg:0"},
   CellID->556037485],
  Cell[56113, 1492, 318, 10, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1833664140],
  Cell[56434, 1504, 329, 7, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1486983100],
  Cell[56788, 1515, 352, 11, 28, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->2135121774],
  Cell[57143, 1528, 52537, 866, 300, "Output",
   Evaluatable->False,
   CellTags->{"b:1", "ndsg:0"},
   CellID->233609777],
  Cell[109695, 2397, 733, 15, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->540750920],
  Cell[110431, 2414, 179, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1281834080],
  Cell[110635, 2423, 1030, 33, 70, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1800041850],
  Cell[111668, 2458, 499, 18, 36, "Output",
   CellTags->{"b:1", "ndsg:0"},
   CellID->347002595],
  Cell[112182, 2479, 307, 9, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->701528743],
  Cell[114643, 2562, 151, 4, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1246456493],
  Cell[114797, 2568, 289, 9, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
   CellID->1342052705],
  Cell[115111, 2581, 1031, 33, 70, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->46627739],
  Cell[116145, 2616, 595, 21, 36, "Output",
   CellTags->{"b:1", "ndsg:0"},
   CellID->190032263],
  Cell[116755, 2640, 124, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
   CellID->1429930124],
  Cell[116904, 2646, 457, 15, 28, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->204763040],
  Cell[117364, 2663, 49978, 824, 313, "Output",
   Evaluatable->False,
   CellTags->{"b:1", "ndsg:0"},
   CellID->84568514],
  Cell[167357, 3490, 876, 20, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1175985231],
  Cell[168236, 3512, 261, 6, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"},
   CellID->445658454],
  Cell[168522, 3522, 2327, 67, 70, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1957259914],
  Cell[170852, 3591, 724, 25, 36, "Output",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1599270862],
  Cell[171591, 3619, 143, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"},
   CellID->2007710047],
  Cell[171759, 3627, 468, 16, 70, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1292939303],
  Cell[172230, 3645, 166531, 2726, 313, 77785, 1266, "CachedBoxData", 
  "BoxData", "Output",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1654332481],
  Cell[338776, 6374, 627, 17, 70, "Text",
   CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"},
   CellID->1940059119],
  Cell[339406, 6393, 2752, 81, 70, "Text",
   CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"},
   CellID->1076263921],
  Cell[343739, 6530, 179, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"},
   CellID->1813933799],
  Cell[343943, 6539, 759, 24, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->343063594],
  Cell[344705, 6565, 508, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->517167345],
  Cell[345228, 6586, 142, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"},
   CellID->1306488759],
  Cell[345395, 6592, 161, 5, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->29244087],
  Cell[345559, 6599, 284, 8, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1777658954],
  Cell[345858, 6610, 458, 12, 70, "Text",
   CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"},
   CellID->1294126886],
  Cell[346319, 6624, 800, 20, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1379597626],
  Cell[347122, 6646, 257, 8, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"},
   CellID->530521190],
  Cell[347404, 6658, 554, 19, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->428477318],
  Cell[347961, 6679, 727, 14, 70, "Message",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->595309333],
  Cell[348691, 6695, 654, 22, 39, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1831950394],
  Cell[349360, 6720, 255, 8, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"},
   CellID->1130006062],
  Cell[349640, 6732, 338, 11, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1074028589],
  Cell[349981, 6745, 2032, 44, 244, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->781774652],
  Cell[352028, 6792, 594, 20, 70, "Text",
   CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"},
   CellID->324575119],
  Cell[352625, 6814, 1115, 23, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1120656328],
  Cell[353743, 6839, 865, 21, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1191489329],
  Cell[354611, 6862, 1123, 28, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1754505243]},
 "ndsg:0"->{
  Cell[4804, 158, 152, 4, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1688868674],
  Cell[4959, 164, 2524, 81, 70, "Text",
   CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"},
   CellID->1805661336],
  Cell[7486, 247, 414, 18, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->82760112],
  Cell[7925, 269, 457, 15, 28, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->925938952],
  Cell[8385, 286, 506, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->698244241],
  Cell[8906, 307, 1853, 49, 70, "Text",
   CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"},
   CellID->1321156179],
  Cell[10762, 358, 228, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"},
   CellID->1497635469],
  Cell[11015, 367, 582, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->569913881],
  Cell[11600, 389, 506, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->471131597],
  Cell[12121, 410, 124, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"},
   CellID->447645229],
  Cell[12270, 416, 316, 10, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1244935384],
  Cell[12589, 428, 2622, 54, 254, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1319806552],
  Cell[15226, 485, 132, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"},
   CellID->1630958702],
  Cell[15383, 491, 609, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1135344520],
  Cell[15995, 513, 507, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->2067392509],
  Cell[16517, 534, 354, 10, 70, "Text",
   CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"},
   CellID->419380819],
  Cell[16874, 546, 161, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"},
   CellID->1957151],
  Cell[19031, 623, 126, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"},
   CellID->1201251468],
  Cell[19182, 629, 531, 16, 28, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1294195954],
  Cell[19716, 647, 11149, 187, 239, "Output",
   Evaluatable->False,
   CellTags->{"b:1", "ndsg:0"},
   CellID->489659545],
  Cell[30880, 837, 360, 10, 70, "Text",
   CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"},
   CellID->256584290],
  Cell[31243, 849, 164, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"},
   CellID->1567178311],
  Cell[31432, 857, 568, 20, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->389314559],
  Cell[32003, 879, 724, 14, 70, "Message",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1114592087],
  Cell[32730, 895, 1469, 52, 94, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->494369864],
  Cell[40128, 1075, 665, 16, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1207072263],
  Cell[49381, 1322, 626, 21, 70, "Text",
   CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"},
   CellID->2021358328],
  Cell[50010, 1345, 209, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1414283321],
  Cell[50244, 1354, 1907, 64, 138, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1485025949],
  Cell[52154, 1420, 3944, 69, 428, "Output",
   Evaluatable->False,
   CellTags->{"b:1", "ndsg:0"},
   CellID->556037485],
  Cell[56113, 1492, 318, 10, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1833664140],
  Cell[56434, 1504, 329, 7, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1486983100],
  Cell[56788, 1515, 352, 11, 28, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->2135121774],
  Cell[57143, 1528, 52537, 866, 300, "Output",
   Evaluatable->False,
   CellTags->{"b:1", "ndsg:0"},
   CellID->233609777],
  Cell[109695, 2397, 733, 15, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->540750920],
  Cell[110431, 2414, 179, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1281834080],
  Cell[110635, 2423, 1030, 33, 70, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1800041850],
  Cell[111668, 2458, 499, 18, 36, "Output",
   CellTags->{"b:1", "ndsg:0"},
   CellID->347002595],
  Cell[112182, 2479, 307, 9, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->701528743],
  Cell[114643, 2562, 151, 4, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1246456493],
  Cell[114797, 2568, 289, 9, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
   CellID->1342052705],
  Cell[115111, 2581, 1031, 33, 70, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->46627739],
  Cell[116145, 2616, 595, 21, 36, "Output",
   CellTags->{"b:1", "ndsg:0"},
   CellID->190032263],
  Cell[116755, 2640, 124, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
   CellID->1429930124],
  Cell[116904, 2646, 457, 15, 28, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->204763040],
  Cell[117364, 2663, 49978, 824, 313, "Output",
   Evaluatable->False,
   CellTags->{"b:1", "ndsg:0"},
   CellID->84568514],
  Cell[167357, 3490, 876, 20, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1175985231],
  Cell[168236, 3512, 261, 6, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"},
   CellID->445658454],
  Cell[168522, 3522, 2327, 67, 70, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1957259914],
  Cell[170852, 3591, 724, 25, 36, "Output",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1599270862],
  Cell[171591, 3619, 143, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"},
   CellID->2007710047],
  Cell[171759, 3627, 468, 16, 70, "Input",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1292939303],
  Cell[172230, 3645, 166531, 2726, 313, 77785, 1266, "CachedBoxData", 
  "BoxData", "Output",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1654332481],
  Cell[338776, 6374, 627, 17, 70, "Text",
   CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"},
   CellID->1940059119],
  Cell[339406, 6393, 2752, 81, 70, "Text",
   CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"},
   CellID->1076263921],
  Cell[343739, 6530, 179, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"},
   CellID->1813933799],
  Cell[343943, 6539, 759, 24, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->343063594],
  Cell[344705, 6565, 508, 18, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->517167345],
  Cell[345228, 6586, 142, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"},
   CellID->1306488759],
  Cell[345395, 6592, 161, 5, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->29244087],
  Cell[345559, 6599, 284, 8, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1777658954],
  Cell[345858, 6610, 458, 12, 70, "Text",
   CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"},
   CellID->1294126886],
  Cell[346319, 6624, 800, 20, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1379597626],
  Cell[347122, 6646, 257, 8, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"},
   CellID->530521190],
  Cell[347404, 6658, 554, 19, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->428477318],
  Cell[347961, 6679, 727, 14, 70, "Message",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->595309333],
  Cell[348691, 6695, 654, 22, 39, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1831950394],
  Cell[349360, 6720, 255, 8, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"},
   CellID->1130006062],
  Cell[349640, 6732, 338, 11, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1074028589],
  Cell[349981, 6745, 2032, 44, 244, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->781774652],
  Cell[352028, 6792, 594, 20, 70, "Text",
   CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"},
   CellID->324575119],
  Cell[352625, 6814, 1115, 23, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1120656328],
  Cell[353743, 6839, 865, 21, 70, "Text",
   CellTags->{"b:1", "ndsg:0"},
   CellID->1191489329],
  Cell[354611, 6862, 1123, 28, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1754505243]},
 "7.4"->{
  Cell[4959, 164, 2524, 81, 70, "Text",
   CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"},
   CellID->1805661336]},
 "7.5"->{
  Cell[7486, 247, 414, 18, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->82760112]},
 "7.8"->{
  Cell[8906, 307, 1853, 49, 70, "Text",
   CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"},
   CellID->1321156179]},
 "7.6"->{
  Cell[10762, 358, 228, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"},
   CellID->1497635469]},
 "7.10"->{
  Cell[12121, 410, 124, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"},
   CellID->447645229]},
 "7.7"->{
  Cell[15226, 485, 132, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"},
   CellID->1630958702]},
 "7.18"->{
  Cell[16517, 534, 354, 10, 70, "Text",
   CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"},
   CellID->419380819]},
 "7.19"->{
  Cell[16874, 546, 161, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"},
   CellID->1957151]},
 "7.17"->{
  Cell[19031, 623, 126, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"},
   CellID->1201251468]},
 "7.15"->{
  Cell[30880, 837, 360, 10, 70, "Text",
   CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"},
   CellID->256584290]},
 "7.16"->{
  Cell[31243, 849, 164, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"},
   CellID->1567178311]},
 "7.22"->{
  Cell[49381, 1322, 626, 21, 70, "Text",
   CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"},
   CellID->2021358328]},
 "7.23"->{
  Cell[50010, 1345, 209, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1414283321],
  Cell[56434, 1504, 329, 7, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1486983100],
  Cell[110431, 2414, 179, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
   CellID->1281834080]},
 "7.25"->{
  Cell[114797, 2568, 289, 9, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
   CellID->1342052705],
  Cell[116755, 2640, 124, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
   CellID->1429930124]},
 "7.46"->{
  Cell[168236, 3512, 261, 6, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"},
   CellID->445658454]},
 "7.47"->{
  Cell[171591, 3619, 143, 4, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"},
   CellID->2007710047]},
 "7.30"->{
  Cell[338776, 6374, 627, 17, 70, "Text",
   CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"},
   CellID->1940059119]},
 "7.27"->{
  Cell[339406, 6393, 2752, 81, 70, "Text",
   CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"},
   CellID->1076263921]},
 "7.28"->{
  Cell[343739, 6530, 179, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"},
   CellID->1813933799]},
 "7.29"->{
  Cell[345228, 6586, 142, 2, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"},
   CellID->1306488759]},
 "7.33"->{
  Cell[345858, 6610, 458, 12, 70, "Text",
   CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"},
   CellID->1294126886]},
 "7.36"->{
  Cell[346319, 6624, 800, 20, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1379597626],
  Cell[352625, 6814, 1115, 23, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1120656328],
  Cell[354611, 6862, 1123, 28, 70, "Text",
   CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
   CellID->1754505243]},
 "7.37"->{
  Cell[347122, 6646, 257, 8, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"},
   CellID->530521190]},
 "7.38"->{
  Cell[349360, 6720, 255, 8, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"},
   CellID->1130006062]},
 "7.39"->{
  Cell[352028, 6792, 594, 20, 70, "Text",
   CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"},
   CellID->324575119]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"s:2.1", 359869, 6982},
 {"S3.9.7", 359966, 6986},
 {"b:1", 365903, 7143},
 {"ndsg:0", 374161, 7371},
 {"7.4", 382416, 7599},
 {"7.5", 382540, 7603},
 {"7.8", 382668, 7607},
 {"7.6", 382792, 7611},
 {"7.10", 382923, 7615},
 {"7.7", 383053, 7619},
 {"7.18", 383184, 7623},
 {"7.19", 383309, 7627},
 {"7.17", 383438, 7631},
 {"7.15", 383570, 7635},
 {"7.16", 383695, 7639},
 {"7.22", 383827, 7643},
 {"7.23", 383954, 7647},
 {"7.25", 384330, 7657},
 {"7.46", 384586, 7664},
 {"7.47", 384719, 7668},
 {"7.30", 384853, 7672},
 {"7.27", 384981, 7676},
 {"7.28", 385110, 7680},
 {"7.29", 385244, 7684},
 {"7.33", 385378, 7688},
 {"7.36", 385506, 7692},
 {"7.37", 385868, 7702},
 {"7.38", 386001, 7706},
 {"7.39", 386135, 7710}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1245, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1870, 59, 170, 5, 70, "Title",
 CellID->1216565954],
Cell[CellGroupData[{
Cell[2065, 68, 66, 2, 70, "Section",
 CellTags->"s:2.1",
 CellID->75354863],
Cell[2134, 72, 1160, 33, 70, "Text",
 CellID->1594837105],
Cell[3297, 107, 1504, 49, 70, "DefinitionBox",
 CellID->153380323],
Cell[4804, 158, 152, 4, 70, "Caption",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1688868674],
Cell[4959, 164, 2524, 81, 70, "Text",
 CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"},
 CellID->1805661336],
Cell[7486, 247, 414, 18, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->82760112],
Cell[CellGroupData[{
Cell[7925, 269, 457, 15, 28, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->925938952],
Cell[8385, 286, 506, 18, 36, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->698244241]
}, Open  ]],
Cell[8906, 307, 1853, 49, 70, "Text",
 CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"},
 CellID->1321156179],
Cell[10762, 358, 228, 5, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"},
 CellID->1497635469],
Cell[CellGroupData[{
Cell[11015, 367, 582, 20, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->569913881],
Cell[11600, 389, 506, 18, 36, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->471131597]
}, Open  ]],
Cell[12121, 410, 124, 2, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"},
 CellID->447645229],
Cell[CellGroupData[{
Cell[12270, 416, 316, 10, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1244935384],
Cell[12589, 428, 2622, 54, 254, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1319806552]
}, Open  ]],
Cell[15226, 485, 132, 2, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"},
 CellID->1630958702],
Cell[CellGroupData[{
Cell[15383, 491, 609, 20, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1135344520],
Cell[15995, 513, 507, 18, 36, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->2067392509]
}, Open  ]],
Cell[16517, 534, 354, 10, 70, "Text",
 CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"},
 CellID->419380819],
Cell[16874, 546, 161, 4, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"},
 CellID->1957151],
Cell[CellGroupData[{
Cell[17060, 554, 1176, 36, 70, "Input",
 CellID->495083166],
Cell[18239, 592, 777, 28, 54, "Output",
 CellID->1644677160]
}, Open  ]],
Cell[19031, 623, 126, 2, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"},
 CellID->1201251468],
Cell[CellGroupData[{
Cell[19182, 629, 531, 16, 28, "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1294195954],
Cell[19716, 647, 11149, 187, 239, "Output",
 Evaluatable->False,
 CellTags->{"b:1", "ndsg:0"},
 CellID->489659545]
}, Open  ]],
Cell[30880, 837, 360, 10, 70, "Text",
 CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"},
 CellID->256584290],
Cell[31243, 849, 164, 4, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"},
 CellID->1567178311],
Cell[CellGroupData[{
Cell[31432, 857, 568, 20, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->389314559],
Cell[32003, 879, 724, 14, 70, "Message",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1114592087],
Cell[32730, 895, 1469, 52, 94, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->494369864]
}, Open  ]],
Cell[34214, 950, 325, 9, 70, "Text",
 CellID->4754978],
Cell[34542, 961, 291, 8, 70, "MathCaption",
 CellID->1665687237],
Cell[CellGroupData[{
Cell[34858, 973, 457, 14, 28, "Input",
 CellID->87877419],
Cell[35318, 989, 4795, 83, 241, "Output",
 Evaluatable->False,
 CellID->33574964]
}, Open  ]],
Cell[40128, 1075, 665, 16, 70, "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1207072263],
Cell[40796, 1093, 65, 1, 70, "MathCaption",
 CellID->1893538755],
Cell[CellGroupData[{
Cell[40886, 1098, 920, 29, 70, "Input",
 CellID->240895414],
Cell[41809, 1129, 632, 12, 70, "Message",
 CellID->2063305692],
Cell[42444, 1143, 806, 28, 54, "Output",
 CellID->374216355]
}, Open  ]],
Cell[43265, 1174, 497, 14, 70, "Text",
 CellID->1562051593],
Cell[43765, 1190, 481, 14, 70, "Text",
 CellID->1483163037],
Cell[44249, 1206, 79, 1, 70, "MathCaption",
 CellID->1252229693],
Cell[CellGroupData[{
Cell[44353, 1211, 387, 13, 70, "Input",
 CellID->2079832720],
Cell[44743, 1226, 4304, 82, 251, "Output",
 CellID->497711672]
}, Open  ]],
Cell[49062, 1311, 316, 9, 70, "Text",
 CellID->349681429],
Cell[49381, 1322, 626, 21, 70, "Text",
 CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"},
 CellID->2021358328],
Cell[50010, 1345, 209, 5, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
 CellID->1414283321],
Cell[CellGroupData[{
Cell[50244, 1354, 1907, 64, 138, "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1485025949],
Cell[52154, 1420, 3944, 69, 428, "Output",
 Evaluatable->False,
 CellTags->{"b:1", "ndsg:0"},
 CellID->556037485]
}, Open  ]],
Cell[56113, 1492, 318, 10, 70, "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1833664140],
Cell[56434, 1504, 329, 7, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
 CellID->1486983100],
Cell[CellGroupData[{
Cell[56788, 1515, 352, 11, 28, "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellID->2135121774],
Cell[57143, 1528, 52537, 866, 300, "Output",
 Evaluatable->False,
 CellTags->{"b:1", "ndsg:0"},
 CellID->233609777]
}, Open  ]],
Cell[109695, 2397, 733, 15, 70, "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->540750920],
Cell[110431, 2414, 179, 5, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"},
 CellID->1281834080],
Cell[CellGroupData[{
Cell[110635, 2423, 1030, 33, 70, "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1800041850],
Cell[111668, 2458, 499, 18, 36, "Output",
 CellTags->{"b:1", "ndsg:0"},
 CellID->347002595]
}, Open  ]],
Cell[112182, 2479, 307, 9, 70, "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->701528743],
Cell[112492, 2490, 2148, 70, 70, "DefinitionBox",
 CellID->41872761],
Cell[114643, 2562, 151, 4, 70, "Caption",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1246456493],
Cell[114797, 2568, 289, 9, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
 CellID->1342052705],
Cell[CellGroupData[{
Cell[115111, 2581, 1031, 33, 70, "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellID->46627739],
Cell[116145, 2616, 595, 21, 36, "Output",
 CellTags->{"b:1", "ndsg:0"},
 CellID->190032263]
}, Open  ]],
Cell[116755, 2640, 124, 2, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"},
 CellID->1429930124],
Cell[CellGroupData[{
Cell[116904, 2646, 457, 15, 28, "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellID->204763040],
Cell[117364, 2663, 49978, 824, 313, "Output",
 Evaluatable->False,
 CellTags->{"b:1", "ndsg:0"},
 CellID->84568514]
}, Open  ]],
Cell[167357, 3490, 876, 20, 70, "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1175985231],
Cell[168236, 3512, 261, 6, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"},
 CellID->445658454],
Cell[CellGroupData[{
Cell[168522, 3522, 2327, 67, 70, "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1957259914],
Cell[170852, 3591, 724, 25, 36, "Output",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1599270862]
}, Open  ]],
Cell[171591, 3619, 143, 4, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"},
 CellID->2007710047],
Cell[CellGroupData[{
Cell[171759, 3627, 468, 16, 70, "Input",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1292939303],
Cell[172230, 3645, 166531, 2726, 313, 77785, 1266, "CachedBoxData", \
"BoxData", "Output",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1654332481]
}, Open  ]],
Cell[338776, 6374, 627, 17, 70, "Text",
 CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"},
 CellID->1940059119],
Cell[339406, 6393, 2752, 81, 70, "Text",
 CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"},
 CellID->1076263921],
Cell[342161, 6476, 1575, 52, 70, "Text",
 CellID->1312728516],
Cell[343739, 6530, 179, 5, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"},
 CellID->1813933799],
Cell[CellGroupData[{
Cell[343943, 6539, 759, 24, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->343063594],
Cell[344705, 6565, 508, 18, 36, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->517167345]
}, Open  ]],
Cell[345228, 6586, 142, 2, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"},
 CellID->1306488759],
Cell[CellGroupData[{
Cell[345395, 6592, 161, 5, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->29244087],
Cell[345559, 6599, 284, 8, 36, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1777658954]
}, Open  ]],
Cell[345858, 6610, 458, 12, 70, "Text",
 CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"},
 CellID->1294126886],
Cell[346319, 6624, 800, 20, 70, "Text",
 CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
 CellID->1379597626],
Cell[347122, 6646, 257, 8, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"},
 CellID->530521190],
Cell[CellGroupData[{
Cell[347404, 6658, 554, 19, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->428477318],
Cell[347961, 6679, 727, 14, 70, "Message",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->595309333],
Cell[348691, 6695, 654, 22, 39, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1831950394]
}, Open  ]],
Cell[349360, 6720, 255, 8, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"},
 CellID->1130006062],
Cell[CellGroupData[{
Cell[349640, 6732, 338, 11, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1074028589],
Cell[349981, 6745, 2032, 44, 244, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->781774652]
}, Open  ]],
Cell[352028, 6792, 594, 20, 70, "Text",
 CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"},
 CellID->324575119],
Cell[352625, 6814, 1115, 23, 70, "Text",
 CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
 CellID->1120656328],
Cell[353743, 6839, 865, 21, 70, "Text",
 CellTags->{"b:1", "ndsg:0"},
 CellID->1191489329],
Cell[354611, 6862, 1123, 28, 70, "Text",
 CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"},
 CellID->1754505243],
Cell[CellGroupData[{
Cell[355759, 6894, 71, 1, 70, "RelatedTutorialsSection",
 CellID->11308057],
Cell[355833, 6897, 326, 9, 70, "RelatedTutorials",
 CellID->604721514]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[356198, 6911, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

