(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     87990,       2563]
NotebookOptionsPosition[     77420,       2225]
NotebookOutlinePosition[     80709,       2306]
CellTagsIndexPosition[     80590,       2299]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Advanced Numerical Differential Equation Solving in \
Mathematica" :> 
         Documentation`HelpLookup["paclet:tutorial/NDSolveOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Advanced Numerical Differential Equation Solving in Mathematica\
\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Solution of Differential-Algebraic Equations", "Title",
 CellTags->{"c:1", "b:10", "ndsg:4.0"},
 CellID->831696002],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellID->75354863],

Cell["\<\
In general, a system of ordinary differential equations (ODEs) can be \
expressed in the normal form,\
\>", "Text",
 CellID->578816],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["x", "\[Prime]",
    MultilineFunction->None], "=", 
   RowBox[{
    StyleBox["f",
     FontWeight->"Bold"], "(", 
    RowBox[{"t", ",", "x"}], ")"}]}], TraditionalForm]], "DisplayMath",
 CellID->1278618954],

Cell[TextData[{
 "The derivatives of the dependent variables ",
 StyleBox["x",
  FontSlant->"Italic"],
 " are expressed explicitly in terms of the independent variable, ",
 StyleBox["t",
  FontSlant->"Italic"],
 ", and the dependent variables, ",
 StyleBox["x",
  FontSlant->"Italic"],
 ". As long as the function ",
 StyleBox["f",
  FontSlant->"Italic"],
 " has sufficient continuity, a unique solution can always be found for an \
initial value problem where the values of the dependent variables are given \
at a specific value of the independent variable."
}], "Text",
 CellID->1512605811],

Cell["\<\
With differential-algebraic equations (DAEs), the derivatives are not, in \
general, expressed explicitly. In fact, derivatives of some of the dependent \
variables typically do not appear in the equations. The general form of a \
system of DAEs is\
\>", "Text",
 CellID->1839802567],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", 
    RowBox[{"t", ",", "x", ",", 
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None]}], ")"}], "=", "0"}], 
  TraditionalForm]], "NumberedEquation",
 CellID->216404578],

Cell[TextData[{
 "where the Jacobian with respect to ",
 StyleBox["x",
  FontSlant->"Italic"],
 "', ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PartialD]", "F"}], "/", 
    RowBox[{"\[PartialD]", 
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None]}]}], TraditionalForm]]],
 "may be singular."
}], "Text",
 CellID->1348616385],

Cell[TextData[{
 "A system of DAEs can be converted to a system of ODEs by differentiating it \
with respect to the independent variable ",
 StyleBox["t",
  FontSlant->"Italic"],
 ". The ",
 StyleBox["index",
  FontSlant->"Italic"],
 " of a DAE is effectively the number of times you need to differentiate the \
DAEs to get a system of ODEs. Even though the differentiation is possible, it \
is not generally used as a computational technique because properties of the \
original DAEs are often lost in numerical simulations of the differentiated \
equations."
}], "Text",
 CellID->1146620965],

Cell[TextData[{
 "Thus, numerical methods for DAEs are designed to work with the general form \
of a system of DAEs. The methods in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " are designed to generally solve index-1 DAEs, but may work for higher \
index problems as well."
}], "Text",
 CellID->594982083],

Cell["\<\
This documentation will show numerous examples which illustrate some of the \
differences between solving DAEs and ODEs.\
\>", "Text",
 CellID->1349052446],

Cell["\<\
This loads packages which will be used in the examples and turns off a \
message.\
\>", "MathCaption",
 CellID->309798999],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`InterpolatingFunctionAnatomy`\>\"",
    "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[10]:=",
 CellID->1586876784],

Cell[TextData[{
 "The specification of initial conditions is quite different for DAEs than \
for ODEs. For ODEs, as already mentioned, a set of initial conditions \
uniquely determines a solution. For DAEs, the situation is not nearly so \
simple; it may even be difficult to find initial conditions that satisfy the \
equations at all. To better understand this issue, consider the following \
example [",
 ButtonBox["AP98",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#18232"],
 "]."
}], "Text",
 CellID->615945576],

Cell["\<\
Here is a system of DAEs with three equations, but only one differential \
term.\
\>", "MathCaption",
 CellID->465997587],

Cell[BoxData[
 RowBox[{
  RowBox[{"DAE", "=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{
        RowBox[{
         SuperscriptBox[
          SubscriptBox["x", "1"], "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         SubscriptBox["x", "3"], "[", "t", "]"}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["x", "2"], "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            SubscriptBox["x", "2"], "[", "t", "]"}]}], ")"}]}], "\[Equal]", 
        "0"}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], " ", 
          RowBox[{
           SubscriptBox["x", "2"], "[", "t", "]"}]}], "+", 
         RowBox[{
          RowBox[{
           SubscriptBox["x", "3"], "[", "t", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             SubscriptBox["x", "2"], "[", "t", "]"}]}], ")"}]}]}], "\[Equal]",
         "t"}]}
     }], ")"}]}], ";"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->379204134],

Cell[TextData[{
 "The initial conditions are clearly not free; the second equation requires \
that ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    SubscriptBox["x", "2"], "[", 
    SubscriptBox["t", "0"], "]"}]}]]],
 "is either 0 or 1.",
 " "
}], "Text",
 CellID->700976264],

Cell[TextData[{
 "This solves the system of DAEs starting with a specified initial condition \
for the derivative of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]]],
 ".",
 " "
}], "MathCaption",
 CellID->494643879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"DAE", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["x", "1"], "'"}], "[", "0", "]"}], "\[Equal]", " ", 
       "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"], ",", 
      SubscriptBox["x", "3"]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->590967424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{
     SubscriptBox["x", "2"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{
     SubscriptBox["x", "3"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{314, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->459520405]
}, Open  ]],

Cell[TextData[{
 "To get this solution, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " first searches for initial conditions that satisfy the equations, using a \
combination of ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and a procedure much like ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ". Once consistent initial conditions are found, the DAE is solved using the \
IDA method."
}], "Text",
 CellID->102242057],

Cell[TextData[{
 "This shows the initial conditions found by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1594331506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], "'"}], "[", "0", "]"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], "[", "0", "]"}], ",", 
      RowBox[{
       SubscriptBox["x", "2"], "[", "0", "]"}], ",", 
      RowBox[{
       SubscriptBox["x", "3"], "[", "0", "]"}]}], "}"}]}], "}"}], " ", "/.", 
  " ", 
  RowBox[{"First", "[", "sol", "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->804974765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1.`", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->258262379]
}, Open  ]],

Cell[TextData[{
 "This shows a plot of the solution. The solution ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "0", "]"}], " "}]]],
 "is obscured by the solution ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    SubscriptBox["x", "3"], "[", "0", "]"}]}]]],
 ", which has the same constant value of 1."
}], "MathCaption",
 CellID->640880811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], "[", "t", "]"}], ",", 
       RowBox[{
        SubscriptBox["x", "2"], "[", "t", "]"}], ",", 
       RowBox[{
        SubscriptBox["x", "3"], "[", "t", "]"}]}], "}"}], " ", "/.", " ", 
     RowBox[{"First", "[", "sol", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", "\[IndentingNewLine]",
    
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Black", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1198721133],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->15020721]
}, Open  ]],

Cell["\<\
However, there may not be a solution from all initial conditions that satisfy \
the equations. \
\>", "Text",
 CellID->1518089858],

Cell[TextData[{
 "This tries to find a solution with ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["x", "2"], "[", "0", "]"}]]],
 "starting from steady state with derivative 0.",
 " "
}], "MathCaption",
 CellID->1525136211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sols", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"DAE", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["x", "1"], "'"}], "[", "0", "]"}], " ", "\[Equal]", " ",
        "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"], ",", 
      SubscriptBox["x", "3"]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->207385666],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"nderr\"\>"}], ":", 
  " ", "\<\"Error test failure at \\!\\(t\\) == \\!\\(0.`\\); unable to \
continue.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[16]:=",
 CellID->458967743],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{
     SubscriptBox["x", "2"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{
     SubscriptBox["x", "3"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{314, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->45521524]
}, Open  ]],

Cell[TextData[{
 "This shows the initial conditions found by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1039081668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], "'"}], "[", "0", "]"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], "[", "0", "]"}], ",", 
      RowBox[{
       SubscriptBox["x", "2"], "[", "0", "]"}], ",", 
      RowBox[{
       SubscriptBox["x", "3"], "[", "0", "]"}]}], "}"}]}], "}"}], " ", "/.", 
  " ", 
  RowBox[{"First", "[", "sols", "]"}]}]], "Input",
 CellLabel->"In[17]:=",
 CellID->2123907456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.`", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->482823292]
}, Open  ]],

Cell[TextData[{
 "If you look at the equations with ",
 Cell[BoxData[
  SubscriptBox["x", "2"]]],
 "set to 1, you can see why it is not possible to advance beyond ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = 1."
}], "Text",
 CellID->404203831],

Cell[TextData[{
 "Substitute ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "1"}]]],
 " into the equations."
}], "MathCaption",
 CellID->1816226375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DAE", " ", "/.", " ", 
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "t", "]"}], "\[Rule]", "1"}]}]], "Input",
 CellLabel->"In[18]:=",
 CellID->2083723153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       SubscriptBox["x", "1"], "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
     RowBox[{
      SubscriptBox["x", "3"], "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", "True", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "1"], "[", "t", "]"}], "\[Equal]", "t"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->251158091]
}, Open  ]],

Cell[TextData[{
 "The middle equation effectively drops out. If you differentiate the last \
equation with",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "1"}]}]]],
 ", you get the condition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "'"}], "[", "t", "]"}], "\[Equal]", "1"}]]],
 ", but then the first equation is inconsistent with the value of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "3"], "[", "t", "]"}], " ", "=", " ", "0"}]]],
 "in the initial conditions. "
}], "Text",
 CellID->815363692],

Cell[TextData[{
 "It turns out that the only solution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "1"}]]],
 "is {",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "t"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "1"}], ","}]]],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "3"], "[", "t", "]"}], "=", " ", "1"}]]],
 "}, and along this solution, the system has index 2.",
 " "
}], "Text",
 CellID->531221588],

Cell[TextData[{
 "The other set of solutions for the problem is when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "0"}]]],
 ".",
 " ",
 "You can find these by specifying that as an initial condition."
}], "Text",
 CellID->954389015],

Cell[TextData[{
 "This finds a solution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "0"}]]],
 ". It is also necessary to specify a value for ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["x", "1"], "[", "0", "]"}]]],
 " because it is a differential variable."
}], "MathCaption",
 CellID->1125162691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol0", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"DAE", ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], 
      ",", " ", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "2"], "[", "0", "]"}], " ", "\[Equal]", " ", 
       "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"], ",", 
      SubscriptBox["x", "3"]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[19]:=",
 CellID->2118098372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{
     SubscriptBox["x", "2"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{
     SubscriptBox["x", "3"], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{314, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->38305462]
}, Open  ]],

Cell["\<\
This shows a plot of the nonzero components of the solution. \
\>", "MathCaption",
 CellID->1591160279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], "[", "t", "]"}], ",", 
       RowBox[{
        SubscriptBox["x", "3"], "[", "t", "]"}]}], "}"}], " ", "/.", " ", 
     RowBox[{"First", "[", "sol0", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", "\[IndentingNewLine]",
    
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->349818858],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->184486456]
}, Open  ]],

Cell[TextData[{
 "In general, you must specify initial conditions for the differential \
variables because typically there is a parametrized general solution. For \
this problem with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "0"}]]],
 ", the general solution is {",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "1"], "[", "t", "]"}], "=", " ", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "[", "0", "]"}], " ", "+", " ", 
    RowBox[{
     SuperscriptBox["t", "2"], "/", "2"}]}]}]]],
 ",",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "[", "t", "]"}], "=", " ", "0"}]]],
 ",",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "3"], "[", "t", "]"}], "==", " ", "t"}]]],
 "}, so it is necessary to give ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    SubscriptBox["x", "1"], "[", "0", "]"}]}]]],
 "to determine the solution."
}], "Text",
 CellID->2085804158],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " cannot always find initial conditions consistent with the equations \
because sometimes this is a difficult problem. [",
 ButtonBox["BCP89",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#27005"],
 "] \[OpenCurlyDoubleQuote]Often the most difficult part of solving a DAE \
system in applications is to determine a consistent set of initial conditions \
with which to start the computation.\[CloseCurlyDoubleQuote] "
}], "Text",
 CellID->940786282],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " fails to find a consistent initial condition."
}], "MathCaption",
 CellID->1924950375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"DAE", ",", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}],
     "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"], ",", 
     SubscriptBox["x", "3"]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->40562567],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"icfail\"\>"}], ":", 
  " ", "\<\"Unable to find initial conditions that satisfy the residual \
function within specified tolerances.  Try giving initial conditions for both \
values and derivatives of the functions.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[22]:=",
 CellID->287280240],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->17699100]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " fails to find consistent initial conditions, you can use ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " with a good starting value or some other procedure to obtain consistent \
initial conditions and supply them. If you know values close to a good \
starting guess, ",
 StyleBox["NDSolve", "MR"],
 " uses these values to start its search, which may help. You may specify \
values of the dependent variables and their derivatives."
}], "Text",
 CellID->1080336564],

Cell["\<\
With index-1 systems of DAEs, it is often possible to differentiate and use \
an ODE solver to get the solution. \
\>", "Text",
 CellID->1028514951],

Cell["\<\
Here is the Robertson chemical kinetics problem. Because of the large and \
small rate constants, the problem is quite stiff.\
\>", "MathCaption",
 CellID->1781162625],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kinetics", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["y", "1"], "'"}], "[", "t", "]"}], " ", "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "25"]}], " ", 
        RowBox[{
         SubscriptBox["y", "1"], "[", "t", "]"}]}], " ", "+", " ", 
       RowBox[{
        SuperscriptBox["10", "4"], 
        RowBox[{
         SubscriptBox["y", "2"], "[", "t", "]"}], " ", 
        RowBox[{
         SubscriptBox["y", "3"], "[", "t", "]"}]}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["y", "2"], "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      
      RowBox[{
       RowBox[{
        FractionBox["1", "25"], " ", 
        RowBox[{
         SubscriptBox["y", "1"], "[", "t", "]"}]}], " ", "-", "  ", 
       RowBox[{"3", " ", 
        SuperscriptBox["10", "7"], 
        SuperscriptBox[
         RowBox[{
          SubscriptBox["y", "2"], "[", "t", "]"}], "2"]}]}]}]}], " ", "}"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"balance", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["y", "1"], "[", "t", "]"}], " ", "+", " ", 
     RowBox[{
      SubscriptBox["y", "2"], "[", "t", "]"}], " ", "+", " ", 
     RowBox[{
      SubscriptBox["y", "3"], "[", "t", "]"}]}], " ", "\[Equal]", " ", 
    "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"start", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["y", "1"], "[", "0", "]"}], "  ", "\[Equal]", " ", "1"}], 
     ",", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["y", "2"], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], 
     ",", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["y", "3"], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}],
     "}"}]}], ";"}]}], "Input",
 CellLabel->"In[23]:=",
 CellID->1088931542],

Cell["\<\
This solves the Robertson kinetics problem as an ODE by differentiating the \
balance equation.\
\>", "MathCaption",
 CellID->399121162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"odesol", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kinetics", ",", " ", 
       RowBox[{"D", "[", 
        RowBox[{"balance", ",", "t"}], "]"}], ",", " ", "start"}], "}"}], ",",
      " ", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["y", "1"], ",", " ", 
       SubscriptBox["y", "2"], ",", " ", 
       SubscriptBox["y", "3"]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", " ", "0", ",", " ", "40000"}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[26]:=",
 CellID->1158815189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["y", "1"], "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "40000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], ",", 
   RowBox[{
    SubscriptBox["y", "2"], "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "40000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], ",", 
   RowBox[{
    SubscriptBox["y", "3"], "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "40000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}]}], "}"}]], "Output",
 ImageSize->{330, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->109845408]
}, Open  ]],

Cell[TextData[{
 "The stiffness of the problem is supported by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "1"], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "2"], TraditionalForm]]],
 " having their main variation on two completely different time scales."
}], "Text",
 CellID->374966153],

Cell[TextData[{
 "This shows the solutions ",
 Cell[BoxData[
  SubscriptBox["y", "1"]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["y", "2"]]],
 "."
}], "MathCaption",
 CellID->1747514809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["y", "1"], "[", "t", "]"}], " ", "/.", " ", "odesol"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "25"}], "}"}], ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["y", "2"], "[", "t", "]"}], " ", "/.", " ", "odesol"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "0.01"}], "}"}], ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Ticks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.0", ",", "0.005", ",", "0.01"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.0", ",", "0.000005", ",", "0.000015", ",", "0.000025", ",", 
           "0.000035"}], "}"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   "}"}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->187915228],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWUtIVUEYHu/cF5hEm7JFoLXoAUFUiovUSioiIlpUi2hhF00XZZhtalMt
alOb2iiEEj2gx8JIjMAgEiIhEiIhKgiDoEXSQloIwen/53XmzMx53O65EnTJ
mfnn9b++/5+Z0/7OgZ6uk50DvaXOhj39nad7ektnGnb39UMXrSGEjMFfSz2B
tgct9jfmeVBHlw1QUpicF3UG6gzUVNAky6aJH45mtVmSDs7qZsQaLHELj/34
lKxP89Ukp3rEFjmsi/o8vWRr8vZo1uBWqlwGqzdjrabG/iadghTauoxGK3lC
xl00l6ZR+K6QUAoq5uvSJOKukNBojOTL4BzihRA53F5q9nxMmxKG9enoDpsj
44aQ1ZqN9B1kndV2jBrfYsluY4X1OCLAsKHozzj3MDViviWX/mPuK43e7kql
MfDC2fIZtAyZcO0yNv/Txx/PJz6PDL+5cf0V7Tv1hNDentH21iH4R5ZjQZ+O
fxDrK8aRHZ1mpCeQvx7KZuhsEnrkjdpEv9lf8D2zUYkXXU6+/AJl6fgjKMFg
CVclLwNI83tPBPxVlHNmZ3+Cj86fewYNK5sXYuiiQXfZPCgAAhjMvP9ODnvu
HLfJt6GZgREvFy9MzM8vsNVBjzYFuOnzsdni8eznztAGvr3gzcLO/qamGxRv
KnFKwYLg1YWF32SbC2ta/s9Z+5v4teMPbd8IdV1Aa84ZeIKNEUytTiv6dMi5
HslZ6Q5ssLnEWFFn0LVOf7KIgdTQVgXbFIU1VjklkbGrryNE8TKs4yN0bu7X
kUP3pD9VtFtYircpzsjK9dgPQeEpFNn6mF5z7efLCcn24YN32DRxtzRWMtva
ijf4KkpGXElVKPGfuoMVdBv5dmzzom85Gcd+UXRBlxdyWJS8zEuhd3b5tmAL
wZpgUyZt+acpCaMDNgmOBe6ux47ej9XD8ql+NnHuBw/cBsNjszVdPfK2HjoO
PJllsHNXx030+9/pokXa9NtveJ1oT1eTBK8neVsmFLKr6F3nWVlF31nDct7T
MH3l8gs4naqug86bzYbzENJNdK6JzbdKi317R/A0Ri2yDplcGaFsOvBSV3qI
qIzNRzllQ7GNnuM4kLYL6WVeLlfCjOffLQKxCyDBi10k3hPcxtWXDcqTMPal
nI1iX/K69Nzp66O0sl428uXJ7QdW4QGUNv7L+Lbg45iHoqdiOWlmct5bwDJg
H7Jj8fQiwaiFBwWcfdw7cVmJEj2nQSiIPdErixjPAi1wNsDNAI6pUD+Uk538
WJHapBrfPsIfj85cuzoZKnNMJsIhMDxkosXEjMNqwZMcIHT3zvTaEJ2iT2rc
uIq6EHd2UjYGGA0NTkEQnh0YJysABvp3htoojRLmYpRgZ7r6xZ/buqcoJJmp
119RteVMP37hT0s/RkNSxGaVMRnYeasncxZ1zTesgnWHQZtfKfXvovJljvRm
xsl5xpWBgaGKd5EnBjYH/wGZhlNYHfZt7BYbjf6/HVLzByxMi9Y=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->112558196]
}, Open  ]],

Cell["This solves the Robertson kinetics problem as a DAE.", "MathCaption",
 CellID->1467349736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"daesol", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kinetics", ",", " ", "balance", ",", " ", "start"}], "}"}], 
     ",", " ", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["y", "1"], ",", " ", 
       SubscriptBox["y", "2"], ",", " ", 
       SubscriptBox["y", "3"]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", " ", "0", ",", " ", "40000"}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[33]:=",
 CellID->592119060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["y", "1"], "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "40000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], ",", 
   RowBox[{
    SubscriptBox["y", "2"], "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "40000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], ",", 
   RowBox[{
    SubscriptBox["y", "3"], "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "40000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}]}], "}"}]], "Output",
 ImageSize->{330, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->63406555]
}, Open  ]],

Cell["\<\
The solutions for a given component will appear quite close, but comparing \
the chemical balance constraint shows a difference between them.\
\>", "Text",
 CellID->1403589241],

Cell[TextData[{
 "Here is a graph of the error in the balance equation for the ODE and DAE \
solutions, shown in black and blue respectively. A log-log scale is used \
because of the large variation in ",
 StyleBox["t",
  FontSlant->"Italic"],
 " and the magnitude of the error."
}], "MathCaption",
 CellID->197455629],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"berr", "[", "t_", "]"}], " ", "=", " ", 
   RowBox[{"Abs", "[", 
    RowBox[{"Apply", "[", 
     RowBox[{"Subtract", ",", "balance"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"gode", " ", "=", " ", 
   RowBox[{"First", "[", 
    RowBox[{"InterpolatingFunctionCoordinates", "[", 
     RowBox[{
      SubscriptBox["y", "1"], " ", "/.", " ", "odesol"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"gdae", " ", "=", " ", 
   RowBox[{"First", "[", 
    RowBox[{"InterpolatingFunctionCoordinates", "[", 
     RowBox[{
      SubscriptBox["y", "1"], " ", "/.", " ", "daesol"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"gode", ",", " ", 
          RowBox[{
           RowBox[{"berr", "[", "gode", "]"}], " ", "/.", " ", "odesol"}]}], 
         "}"}], "]"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"gdae", ",", " ", 
          RowBox[{
           RowBox[{"berr", "[", "gdae", "]"}], " ", "/.", " ", "daesol"}]}], 
         "}"}], "]"}], ",", " ", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[51]:=",
 CellID->835496381],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->381996026]
}, Open  ]],

Cell["\<\
In this case, both solutions satisfied the balance equations well beyond \
expected tolerances. Note that even though the error in the balance equation \
was greater at some points for the DAE solution, over the long term, the DAE \
solution is brought back to better satisfy the constraint once the range of \
quick variation is passed.\
\>", "Text",
 CellID->1151844644],

Cell["You may want to solve some DAEs of the form", "Text",
 CellID->1960659073],

Cell[BoxData[
 FormBox[
  RowBox[{GridBox[{
     {
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "\[Prime]",
         MultilineFunction->None], "(", "t", ")"}], "=", 
       RowBox[{"f", "(", 
        RowBox[{"t", ",", 
         RowBox[{"x", "(", "t", ")"}]}], ")"}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"g", "(", 
         RowBox[{"t", ",", 
          RowBox[{"x", "(", "t", ")"}]}], ")"}], "=", "0"}], " ", ","}]}
    }], "\[NoBreak]"}], TraditionalForm]], "DisplayMath",
 CellID->1905425553],

Cell[TextData[{
 "such that the solution of the differential equation is required to satisfy \
a particular constraint. ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " cannot handle such DAEs directly because the index is too high and ",
 StyleBox["NDSolve", "MR"],
 " expects the number of equations to be the same as the number of dependent \
variables. ",
 StyleBox["NDSolve", "MR"],
 " does, however, have a ",
 StyleBox["Projection", "MR"],
 " method that will often solve the problem."
}], "Text",
 CellID->574695588],

Cell["\<\
A very simple example of such a constrained system is a nonlinear oscillator \
modeling the motion of a pendulum.\
\>", "Text",
 CellID->1404335704],

Cell["\<\
This defines the equation, invariant constraint, and starting condition for a \
simulation of the motion of a pendulum.\
\>", "MathCaption",
 CellID->107760763],

Cell[BoxData[{
 RowBox[{
  RowBox[{"equation", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", "[", "t", "]"}], "]"}]}], " ", "\[Equal]", " ", "0"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"invariant", " ", "=", " ", 
   RowBox[{
    SuperscriptBox[
     RowBox[{
      RowBox[{"x", "'"}], "[", "t", "]"}], "2"], "-", " ", 
    RowBox[{"2", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "[", "t", "]"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"start", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
    "}"}]}], ";"}]}], "Input",
 CellLabel->"In[55]:=",
 CellID->698522796],

Cell["\<\
Note that the differential equation is effectively the derivative of the \
invariant, so one way to solve the equation is to use the invariant.\
\>", "Text",
 CellID->1342656214],

Cell[TextData[{
 "This solves for the motion of a pendulum using the invariant equation. The \
",
 StyleBox["SolveDelayed", "MR"],
 " option tells ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " not to symbolically solve the quadratic equation for ",
 StyleBox["x'",
  FontSlant->"Italic"],
 ", but instead to solve the system as a DAE."
}], "MathCaption",
 CellID->1048547045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isol", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"invariant", " ", "\[Equal]", " ", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"Cos", "[", "1", "]"}]}]}], ",", " ", "start"}], "}"}], ",", 
     "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}], ",", " ", 
     RowBox[{"SolveDelayed", "\[Rule]", "True"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[58]:=",
 CellID->475989523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->226323969]
}, Open  ]],

Cell[TextData[{
 "However, this solution may not be quite what you expect: the invariant \
equation has the solution ",
 StyleBox["x",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] == constant when it starts with ",
 StyleBox["x'",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] == 0. In fact it does not have unique solutions from this starting point. \
This is because if you do actually solve for ",
 StyleBox["x'",
  FontSlant->"Italic"],
 ", the function does not satisfy the continuity requirements for uniqueness. \
"
}], "Text",
 CellID->1436181185],

Cell[TextData[{
 "This solves for the motion of a pendulum using only the differential \
equation. The method ",
 StyleBox["ExplicitRungeKutta", "MR"],
 " is used because it can also be a submethod of the projection method."
}], "MathCaption",
 CellID->1058431016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsol", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"equation", ",", "start"}], "}"}], ",", "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "2000"}], "}"}], ",", " ", 
     RowBox[{"Method", "\[Rule]", "ExplicitRungeKutta"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[59]:=",
 CellID->316071698],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "2000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[59]=",
 CellID->49161494]
}, Open  ]],

Cell["\<\
This shows the solution plotted over the last several periods.\
\>", "MathCaption",
 CellID->692109993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], " ", "/.", " ", "dsol"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1950", ",", " ", "2000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->1405003240],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytncurJVlWxk/d87rn5s1XVT7vved1T9bL/0EciIqIFA7UgTgoCyFroN10
lxOd6MSa6EQnNog98AE+BiVCi9CC2CA2iA1io6ggLUg76EawcVAgXHfEiogv
9m9/ETdvZidk5jlnR3yx1re+tfY+cXbs/aPvf/T8Z3/u/Y8+/OD93Q997v3P
Pv/wg8/vfvAzn0sfTV+bTF57PplM/unJJL2+Sq/qv9WfD9PfeBmvHlf/TtvW
q/q/965pWaZ/q4YjHHGUXi4GzzpGy7T6Z6b3k8l88Nw4OP4ctW9vhHWvfv/N
b/7P7//e1z799P8m76b3R1/563//nvrzP/6jf/jXf/lW9fIdc9xk+rW//88/
/9I/Vy/ftcd/5zuffvF3/i79Wxy/uoHv8/T/7bolXfmDn/mTX/+1r/zKL3+5
vsIsXe6nf+oPf+GjL/3ll/8tPvnCb301taYPv/3t/w0rPnz+yce/+lfpw0l3
TkJJ5/zpJ1+PT5Ldv/SLf4FzfvM3/uYzP/9njSep4Sd//A/ScZOTl4za3eqf
eTIzGZJepot94xv/PXm7Pi9dPHEedr3dMvdj7/1uxfRRYrD+bJ4OSQdWEn3+
ydf/8b+ac5NridMUmWRfHJfOSq+Txcm/xFUcN//q3/5Hcjm9TP+m1/HpNDmZ
nKpevpJf0wCt1Z7sfat6seh8SO+SY8m9+vN5MjcZnV6G0Y19wUF6mexJVk0C
I52dMBJSepeikQQUn3feRGDSYYEdbKSXcZHGywSRjpOXVaa2Wemy80577R/5
4S+G/RGbuHYXh/QnqS1lRHzeXTv9STYl78KmBBIONP7Cg/QnQSSg+DxFLMUt
Pu+zFohAmSYdJDVUL29duepUe7JMtCXy4qOO0cmbxfXiuLCj4yz9CZXUx0+D
iTrS4PZZfV4wUuDNwpf4vNKIR+uOqtGq404H/apap1Bf2NC/VvI0BSCulgxN
5upqXTbGedOQntpTYzqka1+GAjseQx3NuXEdnduppGmPZFR7x3vT3ul/LJK9
owJF+Xuo3yd7fuD7f/uqzdxplBm1d6przhf/YUWn4aZdjER7Ao+EaNqjFA3j
i/FnsPcIrER7lyujLMgrxvEAr6ZgLdoj39Qurw4WX15Fe6SgzhdrB7A2hVcH
sMYoHKAlr/7bOCqukkxOhgulq7N1e5UtVFqcp5y7tBpSDA9gewpvD2CD2Xmw
GpIf0d5Vq1HvddQMqOFFV4caK5SPjHG0K9cvEZMZYnhpNSR7DmB1CnsuwWrg
q45eIjPEwrQdCfVaZ/DmEpxPodguxk31msGbS8R4BsVe2hgzhmJrCnsvkVEz
aDLaVR3HNCBOPYpiQI3skTEzWMUYz2DVJVhhDPc2xtLIJTIn2lUdo73rb0ZZ
kHJnYGWPWM+hlb2NhVhhrL1WFGtqZW8zlVqU1zOrFbE6xgJjrerHWM+RIXvE
Itq/73u/0ODvEYsZMmSPDJiDtT3smVstyh5qsYtiU5Vvj7Ag1EDR+JCxmEPR
e7yP9m7U2bTrvcfX++r8qs9hNZ4jWntokhpk9Lz3p8i3OZS2h7LmiDljMEfM
99DEDNfzMaYGVZ/meL9H9KjBHTQxxoJivADqzsaCSlMsqOQdYhH4yv9dE/MF
7Ngj5oGrvN8hWgtobYdojXmvvFzAm52NAZUmzlsFs0oGrqrcDix5XLFE7e2Q
OQtobwe2xrxXbfYosjqsUFXxMRCbjMECbO5wPY+vKunxGT31bYzeGAviamEV
LGVRwVubQYpNq/ClVbC0Fuep59razMlxy+gpU3fIIHlfOX8KbhaZcqXoBVDC
KlWpBTRAZS9gZbSrvjAzPJvSQJyvPifaVaV3iM5YzHVVomzhVcROtX4Lr5Zg
bQtlU7nRrr5giWiQ5aXVnOwJfNWbHewZY0GoRNlCcUvEdgtFL62CqXDF1uML
bwtFL4Hn8ZUxjOIdy0J916BXdeIq+i4XKPouWN8JTJnC6rK0SqbSZY3D7VfL
LdheQlNbsL2AH1uwPeY9la5828KqJZRJpVPJG+AtrZXKvCVY8fhiZQO8Y2h6
A3vHWBBXHoVKp5LVR0S7qtQGynT4laaOrfak8CUyYoPoHcOOaFedGvNe1ekY
V91YpTPPpPQ2Q+Jz1ROPS4WrKm7BEjNkY6MmrTBqY94L1aNQgVI0FX4MxVGB
Hl+1PNpVu9dW4YrWxkaPGaJR0TALVcxW9mwpyltHZSsmm1FcVcs4T9VsbZWd
4/aVfWwzQ/hjsZdVHkXKZn6trcLFBhV+nGUGWdUoK3DVM3pc2XlsM0P48r5y
/hYUeAwu11D0ClxGu2r2MWLlFa3jN9DQMY5fW0Uz4xg1ZoSiNhZ7xkB5SgUG
C6qC6yaWJzYjFMvAVY8W7apyzIw1YrmCN2vLrjKD9eLuiPeqrR5F772Vqq3R
zvwlu+rZ1ni/aths68WJzTT1HR5PGTLmNZWns9aIVd+qfg31GUFcaYd1YoUY
r8FutCtD1zZa0hCj5b0/sYpWXjGvV3i/hlXMiAsoj5kR7cqwOF95uwbeCqyT
ZWYG8cdYUG11VkqBzFspkBlxAS2dIGbRriq7Qsw8u8qwC0SPGXIBTY15r6t6
FCqRVsqrNkOoQI+rHmsFtlgvclzleeAq84g75rWU4VHIvbj2ylYsL6DkE+B5
Vpm/Oav9zLuw7KoPIP4YC7LaW6meawWvvQLF6gWsjnbWB1nt6wPzWxnI/D6B
18QfYwGzmHpV5gJKpJXnVpGq7W394NgycFU/mCHnll3VKeb3SZYhiqK8rpym
d/Q+UFVDvVVUHq2Sl7lVmEXV09Y5cNg35SzKa0ZnLMbihMo/h7I5Ij63SmM9
kLJPrJXSDPP1HJo5gT2O1TLTVC/GWBDnRKHibkEr52DNW0mWia8qx4wgy7eg
xXPLsrTIKN4bYYH5TBTMiiusVA/jrbwOXz1dnK97Q+dXvVlrReaRXdUdRm/M
eypR3lKJ7X0AKpDfls6hQG+dWMhxVX9uQaOeTXnJaHmv2XPxLqdXnvKXyot2
jRfOLavE13ggzlfPeG7ZZf3BzLbe9c4QtTEWmN8a75/D61tghQqMdlWxM+Cf
WivldZyv/tzjM/OEx++sZ7A3WGhn6vZntrez3TlrdwU1OQ+Um+I7LFNfTsvP
kA38pSXHZTYqG24hWzzjypYzRDQYqb3OZmQvwQOfAuCoP66j3vzM6pd+6Pho
Vw09s/j0QzXS52+OX/HJsdkpFNbyfj9owLMQ8QN0j6YX5EkKPIUuwg/1qN4P
Klw9bpyvOuL8KfGZ4cRXRrKO8FdhxuEmepp3n0uP3n5WANnv9S6+WQGinRUK
c+KKCkV+xLfHZ56L/yF+6nkhA/Wn0uNty7t0RLufXjmdq7KeZbi0l7jKu6eW
b+XpGfR5Cn2Q7zE++jzw/Qq4nnfM8iv8YH2hH6qr0c76JLxoV132/GuM1+df
dUnn5z1V+79nQeo6zdCkBm+d1OCs67OZ42pky2z1rGp8z2rhs1Wsjo1amLOq
IU9x1dvWSuYsrSQ+rSS7ikLgq0bcxvFPTdSYm/3jx1hQTGklM5XzeqNdmeqt
JAvyyuNLM9GuniTalZEeX9qJdlX6+yMsMA/VX1GRt6HAp42y4xkQjb+eWlxa
l88grXDOMjzWG0ZL7JHNMW+pPI2qmNd9q/qxuW2tY7WUd55FaSfaMZuw923I
s6mMI773nr9p3LYcKgOinXUBs/2KukB2r8NnxpHlYXxm3BNEb4wFzF3u5YnP
a1opq6JdI6InwLtjrcS82Z7VHl+sxPn65h346lOewF6xUJHAXyGddco/1gGN
a7xVmAkGq4TLOoA5lL364nGVCWRzLOb0mihUHq3U8dGufH3yQvga/dyGBh1+
xVZ8rvrEJ+1aVl8f8Rozs3B2v0fz9SDPN1klbQSuqpVnk7iYQdrr6Tybygji
j8VcqB6Feaa89XkmNplnHl/V0tcBVjONDzy+ovXiLFQxuwtrnkBxtO4xYnbH
Wod5b0U9EBseX30R6wLz+jr8MQ1gflqBQhbUjweevoU4K8Uuq5YyjfXAs6t6
0MdVxinDxryVd4GqqkPFeauYd/KeiruTWUcWVdM9rrx/AvbuQFuM0pj36odb
69gf34VyHkPZ3jrmMasVWSW++ve7NhMYNdYZVcsx75lvQqHiuELEY3jlrbwO
H3Oiel55fI0PPL5YI8tjLFCJim0cr/7UWVlp5p61jvksRXt2h3CZcZhDWeCq
Sqqf11hOyvBnY85Srxo+xvu71jpVwztgj9WxrVZPMm9ZBxgdVT2yODaqYb7J
isdQZt+qYgZHYR1xZY1nU1WKeezrDKM1jO+95wzuuxaFeab30Y4ZHD0rH9Xv
VS3vgZVHyKi7YDvwVS2jXaMWssw6E/gaW46xwHxT9cnzjdZhJkcvZo+A673H
/LdelXoxfLKrOkP8Me+lFG8l85p1ATM8ev1vnK+MugflPsrYJa4yqs085jWr
YFxPY70xr/GLbIHC/GO1UjXLrSObxMX8t6JqkU3VhUewg1WxZfONEa/xC2yv
Jwp05jPrQZ5v8lrKDVz1RJ5N4kq5rAOPLKusM9LcWMxVvTwK8035Fe2qlqwH
zDePr2rmM43VTKw+siyrGpLlYRa631R71jyC8mjdQ8TsnrVOSr0Ha8guq9VD
y65i7tklvrQ7pgFVM4+ivL6H92El8y+3UuzqOoGrTGNd8OyqLjh2lXliNR/T
8em7QFX1oeK8Vcw7WpXjyypqSd57XHnfZ1F4On8strnCqrPDSvXnERvVzIdW
Wbk1xa/GvTriWZQd3lvZw+rl64o0OOa9ai5RqLD71kp5dR9ePTTslvhkWfWF
LHt8alVjQ7I8xgKVJ5SHUPB9XPXhVe8eaFGd8ItwL6ae3Ry3ZJeZRnaJr+o4
1r/Te6Lgl53CSlUtb+V1+BrrxfmqNzm7xKV2hUN2x7xnHtK6/Bcd1Qfc+yzq
g7TA+uBYFa689xlHNokrFrzXXHHhvkVh3qkniXblqbeSrEqJD5Fh93E95nW0
q5+Odva4qiNkd4wF5p9YCRT8slNYiTvAPVYewOvXwcoDyzLrDllm5uGO1Aj+
GAtSjLNS+Ufr1L/Sugdgl9XxATR1HzHz7KrOPEC0WB+iXdVzzHvc8+gp6wG8
qk7tzymsVnxqZ6LW8wsLD3DXeNZ5cBXjLaJla0Q3qEfWytzXet3Ta61LL2Ig
2vSNqlhtBWpnSMaf2ooeQh+xjC7Zr+A09/II1vT/1/iT66i8Dp3VyFrRtzG2
Zi6bf9Zfb3vSf9+Mwl32aO3YPAaTefe+QauPWvavd9UubBtKo8UzaehG1gbF
xTetWkvzrjb1WaDt5XXkTaOFsFi5Vlu8DKV2NtGykfevpf9fq/7vIlvmHO4x
8epa+bnHeK3vZWeOtyvrw1gdsZavuGnQp56x5pOw2bI101j/BrZG+Wqiq9oY
0e0YAgNHLXoxl9nXCfWbpRLrMxaliS8X1e4uEq8579jqW/qC163fN1Xe9yrS
0rWK7+Myf5uV0a0HM8V7MnCVoyG/kgj5TSQi3F/t+8asyKcolo3d6IGXyCPy
OvL+JvHGVedd9fMWNxea2pbEUvGdK+KMdaRfNM7FdQftnun7xA2j0dgSIwc7
8pt3eflq0Q6xN9HGeGiJPPuuRru4T8irazV6w8y1UWqyvFqDPvhjHdP7Adxr
PGzPiG9Xlr+ZetiXi3+cb6vUvFPzy8S/36s36q3+r/NkmWBLmO9a1NWzvd6/
aq+auRFiWxHrhqCliau+Tde8zPq8cFw47SEdGQ121swa6UwmEz/CFIIq+RtW
Z4rb0GhVI2B9U49z9X2jr6dxqzT+LbnHXVp+n+l95433ql/xnqMs+fbAxLaw
n/fOCu5Ukd/A8ayv7KmJP/b9TN9SiPIGvOLYLN7jl70eaw8sy8THPbSeV2TZ
s0CWyRrsGWBBtcmj4K4PrKwyxXJesEtcsqu7zm9YTcpORoN1nPhj3uvXX4/C
97RSmRrv9R2fVnt8/X7TZ1Os6vueZ5UsamwTXt+rfZ1MfmKwIsyhRfYL9RPK
6k+u2k1h+OTeSfu+0ewJ2mu+i++Wpzgqrs61sc1VIvwDV+mUP3oVruCt9lsv
5Au/SfmrKF8GfYlELq5SMzzT97fyCtFbcKVwc4XoHIsrHI8ootdfXauI4HtQ
EdkqEC/HIteSNldp9pryV+m8GbjKdUx2ishWqOFV+rs1vZK6QzQDipCVr6CI
Zrx/E0VgpOxQMz/z1c15vNZoYU3WSM5XfmXUyp6vHitqaF7jh6/L2sz+XrXf
X5fznhkV+TEYlbhx/ZJRCW/x62yxFsx1XrMH40p9w+c/gJdxffWQ/vrqsVy0
tZ7aMNvuuu68MRY5gqQXGmuxn3VjM90JkJYDV3WM0fGjImpfv2xwPOHHnNKs
HwWF9xyfE4WZwDtl+r0kzufImOwSX+z67wccW/L7h8aWcT7m3vB+jGVB30Bp
nWJG6/gLJ38bex0x89+OcM+Xd2yL7xWYRVqwy29HwB/QAH8DIwp/hSELGsk6
K8Uucckufo0o2OX3amkt2vndGfgD3kMhhZXqQ7yVzENameOrPpBV/vJJVvPM
a1kdxOt+/+IeMLkV/HWXVlBhzH+yxypF9vj7K9njr9vUJjMM+AMxZp7xV2LO
JKCVZIFWEp9WkmX+Bs85AMwwssxfM4E/wAJ+QSxmCnC+hmppPpuE1jGP8bxy
gfsx5mGoD3qImHKeBjPMzrAY8J75Riv5OzutzGcQlVYSn1Zq3PAQeDm7rC/U
luqCZXfAeyqQ1qlm+/lXH2OWCK3kDAfObsvZ1fwPsprPHyhZ5ewazM8qvI/x
Nmfy0Lo8/2QdZw7SOrJK66QxP/eOrLLu0HvOsIJmB7xn/tFK5h+t5DwszhDk
DCfOv2R1Y90hC6yOnJ/JeWBgeYAFzhjOUZR/tI4zhjkHl3N0aZ1GKXG+Ms2z
Kzb8HF3OUgO7A95zDjtnEirfvZWcJ0krlYeBr+qYs8u6wxmOqgeeXc5UBLsD
3vMJAaJQgbQyn4OrufVklbj6DuYzL2dVuGRzYD55N8bjXpScixXWsJrRGuYZ
n6PgPGjWAbJIfM5k5lMwZJP40OhArPmcElGYb3zegYrjnHyyrNGJf9aG9YAs
E59aZaaBZcuCnldgtcqf0iqf9GGVVMzz5ypoFZ+z4nNUZJVPvZFVPomAuboD
sZdVnjs+A0crqcD8eQl5T+uIy2fnyKrHVf5DowPe8qkr1k4+hUmrqDRZ6Z5I
knX5c5P92HsWmWH5sz/CRR8z4HWeXzqbz7DlT22WCqNVZJPVifh8Ro9s8iky
apN5j+e7Brxn/vLJXV3VP7mr/tI/ucvqdR2+vPLPTbO+kAU+SYjqOMAC841P
b/OpTsU2f3ae1pFdPhtPXNUB/+x8/mxuyS7xxa7699J75jVR+PwyrdR7/6Qv
2c3XQyB++9y0WCUeWSUe+oYBr5l/RFGPkj8rL8VxbQqu2MG64HD7MfYrgjDj
yCbxUS0L7zkz3q/MwbzjeglctYFWkl2ue0J81gWNLf16DGSZ+I6FaTcrit7z
bFU1b51iznrg18bhmhnE59o3ZFeauAN7n4ANrjozpgFx5KxU/kmxfv0TWpev
0sT1UYTLOqNvxlx3xbMqO7ge0k28JgqrGa3UaKWtC1Scx+WqMqw3OavC5epS
qn4tm49HvJUSvFVcd4R1IF/fSFZx3SEpliuIvQhuuQod2SQ+nkIf8F55Fihc
R4h5xtXW9N6vNUd287W1ytWjuFYe85hrbHE1OWYaRj+WBa0/Ruu4ziFX2mMe
K+b5uma0Sqx6XOaxYu1Z5bpn8mMs9rLKc6dMYA3l2pbeSq4aRyuJryoY+Mzr
fA29ll1lHMZ6A15z9UPWUFUv1gOusvoEGnArA8o64nIdVLLJGS5cKZTrGmLU
M+B9rjxZxzUlVQe4dq23jqtC0jriyw6/ZiXrALXKOoNvyAPeM5+5Mra8Yj3w
qy0zb5nXsjLaudoy103V8R6fKwQz4zCmxJiO+cbV0ZVfrFr5GtasA2RVVnlW
VQdyXGYa2dTvcGRzrH+n8mid3od1XEFbLDy1VqpqeStzfK1frOoYuFy/mNES
i2TVe3+EPIqrcM3qfC15Wad8jvNYD8gqreNa1FyrmqyyHrBa6q4JWR3znsrj
uuXK/2hnvsoqWnkKq56CbZ/PxCfLrAfcCYDromPVuAEWpEi3a4Lyj/VAec16
wFXZWReindVS35I8u9yTgrtBcG18fEMe8F5KOYOyuC/KUxzvV+gnC6qabj8S
sTuOq31gyGqOV9zxGvBa3HgU5h/rApWnasXdHQKfuyoQn/Uh34NC3jNazDjZ
Ed7Xa1N3PVywUM0Gdzu1BDPcV4lXoCppOZnhvklknvjMedYk4gvPM68xAZkP
hmIeu1go94Eqnk5sIsL99fwONqqBvirQfvLDPVjEl9/3iftOcV8s4jNf8Y3z
Jfkp91PidZRxrI7ch835If5ZFblvGfdvI//cN4/7lnF/JXzjf0F+qgeCufeT
slq+sxqFzcx62pzvrSdc7nVHXHIsbnKOuVcW7t8ZDupZzIM1hhoWftilcUJc
X6Mr7r7o91bLee7XtFPkjN+7jXzLHo/PHMbq9gP8lL8okCfVEl7H78FHP5jr
9INx4F6fqr1+L1Hhc9etWzje1yLcw+t6q3YvMc8KK0e+72u5g6Oile/fyp1J
ybZU4NnOccudV5ltZJu79eJe4cDIhbWCVnJ/T+4/qVrhrSS73PNX1+vv+StW
mavEE4u3gD/mNTOWVuVK1K6kipHPEOJyn2eyyX1mr8OXxvxuu7irFd6bJ1yD
W/Xt3GMz0LlLrazxu1AL78Jax/xm/RGerw/cb547LeOumfE+vj2sjXVSHKsW
92FWjPwO6Pn+7sJlZpFNZZbHlfK5s/qQt6E2v+s8lUbrdLU2A5ivYZXGRyfw
gvvOjuPquAuw07L4dMDLiPraWsPd5ZnnVJQ4jfM1MnBWlSwyo7gjOvHJJjMK
+9N0dxjrL2DNE5VraxnVJct8rkr1zKULMEl85vrK4gvP4zOr8LuBiXt8N13j
6BPowFsnHTA3W7WtrVWqBcxJ7ivucPvxv8jUj3uvxtuwZA1VBKrqoLeKKpP3
VFlulXAu4D33CHe4YpGqxx1s423wsc6sUQw5MuCO09GuvpeKinb1dicWXzEJ
fNYC4ksrXvG4c228Dn6DM/W9VFa0Kx9X8Ia9G/eOpXXMVyqf7Hp82eOVjzvY
xvtQ2xpcU2neOt2ninZlxAqKo3We3fzJ8EqDG8RwBQ0GrnqxFTTS672y1byq
tds28DHO1VhxDR9X4IB93wq2MjtZFdo8YzVYw0fuPMs8WIED63Mc3vgs3r3K
mAVSMXu92GNI30jX1jbpam2zQP3vGu+jXf05s4D7VVrfIwSN77I11xhtEv/U
/jE43FibxOHaav86fNnJHOBuldbnuNxke5Xn5bHVGm3TtZiX5HsDbR4jZ9Y2
x3R8mwMcH2yQW4GL31p64zKNo/yZVBizUtHLLSIulc9qQOVTuVKFZ5L4Yt5G
uRmLbu25VJgU5RUsRUW7xg/Rrp6ce+gxA+Leqfq2aFcVoII3NgPwGwJ9DxE3
vtM2KWyDDFhCkdGuqk8Fb5Axx9AXM2BplazrUckbm2H4fYa+N+s7bWErd3xj
LiwRh2hXz0FNb7JcEIcb6Iv7bLGXYdXZgANyan2OyzU+S5vc5425wJ2RNtCm
17K0SS1voU3uO7W1uaDjA191Ja6vOmF9D3k12IoftbZF/Nr9kHY2B5gjygHu
GrdF/HJc9Rbcp2UDXTBWZ/JV99UTdTvokjuabZvrU69bq3dxuwFf1G2OK3+3
Vu/kT3wtYX/pZxy7Ax/Uqte6xvzU+sJqVe+X0N4W16NWvdalbWp9gTiVfkcd
3NvzVMe8zhVX6pzrPlHv0a56s7W6VHypd64PRd0vwGPpd3C+h24WVr/UvfzY
gieulxV26X7BwuqYOpU9W/AU56vv8viyR37HqEwLM27B8ALKpVKjXSOWuLIy
IdpVdaNdmbGAcndWcaoMcX1lBteN2wGPkSsjHj363p4nxqnUORQQ7cooKnln
laoIUalcm3MHBS3A884qDr+BZX6Hr3t7nvinkuaWb2U0+d5ZpYpHj08liwcq
OdqV0Yxb6Xdcaw9dku89+JtbvqV78r2DTufIm8DXaHiO41l55zje6w2/r2V+
h7b20BH53kOnXCFsb3Wqir8DHvNkD7w59MHKO7d5Ir1xxdJz+V2VtgjQ5BJH
ceW/6qrVeILVKKzhCqSqRjuLyyhKNVxxLNq5KijxpTKu+whvg+bGW56lnNlb
bYpjapOryFzCSq67EOerRszh5R4szJB7ga8awdUt4HWzwu0ByuEz8nsocY6r
sBLOkGGXYGmGTNlbZSpT9mBphkwJfFWQGeyB180dhYM9i7FU3Znh/SW4nUGx
l1YLimW0q+5MLb60MIP2PD5+6ZbXzffpA7ifIZaX4H5qYyktkOuqvaoHXDks
zlO1mwLnZrjCkZeVk+Gd+rQp8uOAGPDZOea/j5liPsXxB8RgamOWjk+Ep3+L
mDHmxL/IY9pstBBXVW1jzBjzKd4fbMz1/hL5xtgdEKv2WbxnyCg+uxO4ynvi
wtumhh4Q0zhL1cFrQD0RY3SEvDvg/RR4B6sB4UW7ajSf3zhAA9QIvG5i+Awx
CVRl/wHcTZHXjBHn1D9DbDg39mBjJXsOyKQj2EMtHMEeeJ3Uo7OUf5xt2HHZ
cMunRZ4hn45g5TOwyHXT6/ZFx2L6E7p4ExnmccUeZ5PC28a7uFqn5O5qb9Wf
d15ftTNT3kQmHEGJz2xMNPqI63VWpT/B1JvIAK7J/wwZcAStwbvsap3iuquF
d/29GONK8XnXg1y14/DaukWnrKv2h6Dq+KrqhDUaJ79ZsBeY8Xmnlat2Dld9
p6u+Z1kZX8wZN3Nia6R5x2uzWV/Y399XLK5bfz7vtNGMPN++Qn4nT94qGIv8
DIQud8KFQNC+TxH2uG9XrEJeZ282z5czWMOnLuZhWPhU7RSRLpPe923XnlqN
//FpF4cIQHw6C7ioJnFc17s0o7O3cx+bs1/Jm1mYm2hPqnunUkt1oSpfmuwP
29IhKWjh4Nv2vMksGZUcC3beGTgrhSF5lzSe/NrewO7qlniXYUk7VQ9fX6Oq
c6lUpWtP3r1Sda32b3h35PhqH71oTxYlW7LjU8S6u+4vwWv1z3uvfG47m3px
5efi60jOuVVL9epDvJq89v8zwH9L\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->418284098]
}, Open  ]],

Cell[TextData[{
 "This shows a plot of the invariant at the ends of the time steps ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " took."
}], "MathCaption",
 CellID->1850925182],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ts", " ", "=", " ", 
   RowBox[{"First", "[", 
    RowBox[{"InterpolatingFunctionCoordinates", "[", 
     RowBox[{"x", " ", "/.", " ", "dsol"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"ts", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"invariant", " ", "+", 
         RowBox[{"2", " ", 
          RowBox[{"Cos", "[", "1", "]"}]}]}], "/.", "dsol"}], " ", "/.", " ", 
       
       RowBox[{"t", "\[Rule]", "ts"}]}]}], "}"}], "]"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[61]:=",
 CellID->553836800],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->667611864]
}, Open  ]],

Cell["\<\
The error in the invariant is not large, but it does show a steady and \
consistent drift. Eventually, it could be large enough to affect the fidelity \
of the solution.\
\>", "Text",
 CellID->1450956344],

Cell["\<\
This solves for the motion of the pendulum, constraining the motion at each \
step to lie on the invariant.\
\>", "MathCaption",
 CellID->741752028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"psol", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"equation", ",", " ", "start"}], "}"}], ",", " ", "x", ",", " ",
      
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "2000"}], "}"}], ",", " ", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Projection", ",", " ", 
        RowBox[{"Method", "\[Rule]", "ExplicitRungeKutta"}], ",", " ", 
        RowBox[{"Invariants", "\[Rule]", "invariant"}]}], "}"}]}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[63]:=",
 CellID->1442689765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "2000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[63]=",
 CellID->42003555]
}, Open  ]],

Cell[TextData[{
 "This shows a plot of the invariant at the ends of the time steps ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " took with the projection method."
}], "MathCaption",
 CellID->1333871088],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ts", " ", "=", " ", 
   RowBox[{"First", "[", 
    RowBox[{"InterpolatingFunctionCoordinates", "[", 
     RowBox[{"x", " ", "/.", " ", "psol"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"ts", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"invariant", " ", "+", " ", 
         RowBox[{"2", " ", 
          RowBox[{"Cos", "[", "1", "]"}]}]}], "/.", "psol"}], " ", "/.", " ", 
       
       RowBox[{"t", "\[Rule]", "ts"}]}]}], "}"}], "]"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[64]:=",
 CellID->1462822454],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW91vHdURX9/dvV92bL5CaaWqqB8SPNGq5atqvPfLJnEcQqABSkGpC6WJ
lIYKwlPVR1BVtW+t1N442CYkpSDUoqpUfUFIlar2oeKVZ/6R2/k4Z87s7LHv
jW8SMPjK3rtnz5yZ38yZ3TvnzM6xtfOnf/KztfNnnl2786EX135++syzL925
/MKLcCmdSZKZ00mSfHBHAucjOKP/e0ejUZLiGX3o61t4ktzIHuxI8t/+5l9w
fvmND4tDf4TzpIn9LW6f+elf5Ch0SQ1aScptJM7xkPEIJkzxyrzw1My0uMe/
fxmOjzx8iTmeeuZtx7GOh2Z0PBwzpK6LfOmtxa5Ds0ZWePn8e9AEGQmhS4PG
qelvqH5gy/rWBX6Zb92ghJPM8M8MP8LfrpoDzgXELWRYboKBHKcWzQ1f1RY1
WNtV22jqzOhL1s7NJFWslEcRkQ0yQQQdKSIoeRXiymmGA/dM+QwrQMgzjTw1
Y+aDTzfBc584eQU6lvrrcEHO2Xu52Tk0lKOQOe/ldvBeHsGEpHlbWGpmwqYB
DZLVjNLBkb1U5EhvLXYdmuylvc4FxuHsL92uHfobqh/YOi8VmGW+dYMSTjLD
PzP8CH/TqM3nAAKlsY8KIseHfVSuGkCCtF21jKbOjLbso2YqKjbKo4isZUmz
XOuEqNhDA+9M+QXDZw/VuFMzxnjof//z8Qvn/vaP9z6CC3JOXjPHzd//7t9y
FLIf/+jtZ57+MzRphjN9hfS9WVhpJlrKL3/xz6Mrmy+/9PcnH7+yvHTx17/6
wD3VoyPhCAKS2snH3kjaLIcVFCKRz5YULs6yr2/9D8ShlNT0p6afNJo1fAW/
4Vs3aOEkM/wzZQ9gA+oO+uvHVjY1V237gIR9l9tgKMePfHcOrh5efu3RRy4Z
ZBVLNKKz6O6kIIt910xWxVZ5FBHJOQBXl/vrg946dAAEmCmZJw0tSXEOM619
pnCyIqJCIjoIy4BOefINiEbIO3PpoWsJWyh6FZkg+hp8374zV9VTV20Kfej+
Cv2J8+dw5dZteTM4/tSSatvKzqaQZXE3R7vRwxN8k0gaznqNqI3Ho62bWaiP
tkPvJd00lmdjLEU68VwfcFJT9Z35adqljLunHaspd7TZ3dFZaWxLf5fTMnPf
+baU06wVpueyN3v2db/Rkr9DPbCqgE6K/ijOgh9lHw1y3LU4dO0D1IbfR9ee
o3a38P01007NeG6vrmw9/dSbgV7F4mb8Taaf8cBayo2/1fBnPP1umd/y4KJr
zxv95s34r1Hkyctl+APBXzEUB017wWvkbNtUdoXhzq4jONwF/23qxedR5p9q
8V/jTF/Vz/+D2ItxCpwfWX6ti0CGAAfOQW2Ymeefe2fQvQChchdXABhwt8Ce
/c6wWBxCbAPnMKbfuQADeh1YfSBF2sXIGv94BCL/4Q/+1OVofehmhPvx8HVg
AUKA4/HVTWS6OMTYnJoinK9gb2d4eOni0cMbXUJ67uy7r77yPuIggpOPXlpd
2SjUEObJELu0jmOYTOCv3M5qQBAKzHF4MXzsxCUmQDyLQShoA+EhCiUdoLdH
+uCCogYt4l4gHfbVYFzSYEAFAVo9sqHsSdJvAQ4QAqN2DJvhFcMnT14G9wLk
rrcYrp16C+JlZoaGRovyvKCWfs54ENuZIHmqBbjGYlgAnBckEjR354t4fvzY
FlD6+fKIaNGUzLHl0QmYDRkHRoD4HjmEt0SLuyBEhbUNOw1MEOBHXyE8uYyH
UBZNRfZodAg2G571Jm9BCHATo61AHBzRbbxpxcDiQjxSZpwNhHNCXskyl3Gl
WTjV2PrczgtRcTF4fyp4eeXVZJ8AMWA07ZR8b+rffhsLXOtY1kYxNu6YJpZt
mR4dqew2lrU8s+jz61rGtPUKr4Wx3KeJbn0MvTDaj2r3fnTzae/5LFqlcHrp
Owe/vzcq3/O2/0HXz48P/7FUD4xC5BTjkkYx9VQ7MfedbePpd0c73amTcLjf
tNOrHH/fKNzBk43y7Rn4nsFvsQQS7D0L3L8rBFXt97YfPHAV9JPZoDPiO4V3
frVuVQ2voQ1K65mrkX99LFD9dbxBvhBf7U1gh3snoNudPbpqRuwTe7tnrH9i
66jBjn9wzPj4sxoP12+nY9CzK3LcIhg6aoqQknucfe9L/I8Rj33qiSs0duh2
QZhR2HUI7bbn62SNox/Xzjy/UnvM+EzaMHB2zIhx/VfXHlb4WQ3y7cZ3iz+g
sZvR2ZwzbRsV2/5PG31cq4embMe5Tne37Me6+7p/NnUv7b2Wfs/t6rs2mjT/
afeIbB6xuosx+T7OTrlVPJ1mPyq6n3ONcFve8RzzePSxvaLyrtTna4+I2/h2
IMcWSyqjgfkGm5HJTPuL1JYMR9IyGZOvmvzGl9X45QFtjGO+48iG6/8C/Zzr
N4EGvfXk20X5jbJ20E7bwXsAvlmUhLjsG0X5bR81uuJB8s4HBg9+e5/3gxcG
/XXZ7OX8iFBw9kPviSe1XsG727y93it4/9zvNDMhc24NPCv4c2kGyogQHwTQ
1FvsnMpQO9lf6vl8yoAuSqZCwAF0OC4vXXz+uXeOrmy6zEbh9++9Sryh7nbD
F4cnHt4i7XmfftFlWI6vbvY7nFFI2p1DapOekkeARUxBnOb7lLApPByAL3mO
o0c2XGKAMzEo6WZWXNIznAXBPJBPE3BuQnIPiCb1aApvcLYSK46AOFOSzGGO
gvCx0To+aTDoDjmZ5TNCpcwE2JOzD7nI8PODmO+Q6ZP8DaDiFIWTX6A5e90L
a6feOnH8dUkZsGVgZs6e+auXnIox3eyzKM5gMHieYkJ0G1tfp4/g/pHkFdw/
mHvrON8QVnwi/shj2Y4tzFx5O3bKY9gKLsPFs8+YnX94n3Y5I8rzeJqmdmH9
nhbfkdd/33jvxBWf55hqX/dtI7f4PlM0ZzZZrGnjQZvXmyZm87GVzRRNE2Pa
WDgaK+/ynbp61Ja7iyl3jvX236mzcdsnln0Me6DlepRSRQO/oy/VE1L+YGst
eBWoK2po3ZILxUhV4mS6DMTW5tTUuBD3kpXq/LLS6sqWqZQxlSsBh9epUjNU
i9OlAamu5ZA6lUzbYLbMA2DtLJ0/+I6YrRPRaExtiRS9kMVbxp6FL0nCqhh+
O7pa3ROrgCKkc1HaolymwxrYiqqsYg2aoYbU1RSqiIel57JWKuL1OmkZ/6hS
42VpS/7G3h5qhGrKXtpMgUc7di+Uq15KtROZvyIlFraag+dRV+bwXWAKf5wv
6UITW+NTU+PC+o2et0RpZNqqmIDBa5KbihiL1dOlAaWuFZEqmJL+s2Ue8Lez
dP7g6trWoWg0pnZFlsRp1JY4K+z51YqhWPUUe36UtigX/zByW41V9QL2fL1y
Dzaj9ywbWntTH9Uw+ri+ppnVtOJZ7O/hjU7tB4W8sRk4BG9PKVzYpkIEK264
CEdKOmx1jKl6KdX7kL/PmzKiatWM0PObT7bShJ/2r77yPqwaz519V9jZah4a
PaslCOORKqJhnAd3oDP1JJogcJn12uIqtsA33aRWpcrXzS5X5pgCH8bTjta4
SBFO6mcjWiqFVTpVLlV2ZMnbojTa4tVJErvQu365tQXxna9qJyYAmNLl68Bs
nVWjqh32NWO0JS9j3w/1SuK5Ips7Ag/1rP9E1zLJzP8BVhOHpQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[65]=",
 CellID->80925146]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->555808719],

Cell[TextData[{
 ButtonBox["Advanced Numerical Differential Equation Solving in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->604721514]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Solution of Differential-Algebraic Equations - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Advanced Numerical Differential Equation Solving in Mathematica", 
         "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NDSolveOverview"]], "Text", FontFamily -> "Verdana"],
     "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NDSolveBVP#3518691"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NDSolveIDAMethod"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 51.9307864}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In general, a system of ordinary differential equations (ODEs) can be \
expressed in the normal form, The derivatives of the dependent variables x \
are expressed explicitly in terms of the independent variable, t, and the \
dependent variables, x. As long as the function f has sufficient continuity, \
a unique solution can always be found for an initial value problem where the \
values of the dependent variables are given at a specific value of the \
independent variable. With differential-algebraic equations (DAEs), the \
derivatives are not, in general, expressed explicitly. In fact, derivatives \
of some of the dependent variables typically do not appear in the equations. \
The general form of a system of DAEs is", "synonyms" -> {}, "title" -> 
    "Numerical Solution of Differential-Algebraic Equations", "type" -> 
    "Tutorial", "uri" -> "tutorial/NDSolveIntroductoryTutorialDAEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:1"->{
  Cell[1328, 44, 131, 2, 70, "Title",
   CellTags->{"c:1", "b:10", "ndsg:4.0"},
   CellID->831696002]},
 "b:10"->{
  Cell[1328, 44, 131, 2, 70, "Title",
   CellTags->{"c:1", "b:10", "ndsg:4.0"},
   CellID->831696002]},
 "ndsg:4.0"->{
  Cell[1328, 44, 131, 2, 70, "Title",
   CellTags->{"c:1", "b:10", "ndsg:4.0"},
   CellID->831696002]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:1", 80229, 2284},
 {"b:10", 80344, 2288},
 {"ndsg:4.0", 80463, 2292}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 703, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1328, 44, 131, 2, 70, "Title",
 CellTags->{"c:1", "b:10", "ndsg:4.0"},
 CellID->831696002],
Cell[CellGroupData[{
Cell[1484, 50, 50, 1, 70, "Section",
 CellID->75354863],
Cell[1537, 53, 142, 4, 70, "Text",
 CellID->578816],
Cell[1682, 59, 260, 9, 70, "DisplayMath",
 CellID->1278618954],
Cell[1945, 70, 593, 17, 70, "Text",
 CellID->1512605811],
Cell[2541, 89, 293, 6, 70, "Text",
 CellID->1839802567],
Cell[2837, 97, 241, 8, 70, "NumberedEquation",
 CellID->216404578],
Cell[3081, 107, 354, 14, 70, "Text",
 CellID->1348616385],
Cell[3438, 123, 593, 14, 70, "Text",
 CellID->1146620965],
Cell[4034, 139, 383, 10, 70, "Text",
 CellID->594982083],
Cell[4420, 151, 165, 4, 70, "Text",
 CellID->1349052446],
Cell[4588, 157, 132, 4, 70, "MathCaption",
 CellID->309798999],
Cell[4723, 163, 213, 7, 70, "Input",
 InitializationCell->True,
 CellID->1586876784],
Cell[4939, 172, 542, 12, 70, "Text",
 CellID->615945576],
Cell[5484, 186, 131, 4, 70, "MathCaption",
 CellID->465997587],
Cell[5618, 192, 1160, 40, 70, "Input",
 CellID->379204134],
Cell[6781, 234, 276, 11, 70, "Text",
 CellID->700976264],
Cell[7060, 247, 242, 9, 70, "MathCaption",
 CellID->494643879],
Cell[CellGroupData[{
Cell[7327, 260, 564, 19, 70, "Input",
 CellID->590967424],
Cell[7894, 281, 1130, 41, 71, "Output",
 CellID->459520405]
}, Open  ]],
Cell[9039, 325, 645, 20, 70, "Text",
 CellID->102242057],
Cell[9687, 347, 226, 8, 70, "MathCaption",
 CellID->1594331506],
Cell[CellGroupData[{
Cell[9938, 359, 536, 19, 70, "Input",
 CellID->804974765],
Cell[10477, 380, 296, 10, 36, "Output",
 CellID->258262379]
}, Open  ]],
Cell[10788, 393, 369, 13, 70, "MathCaption",
 CellID->640880811],
Cell[CellGroupData[{
Cell[11182, 410, 689, 21, 47, "Input",
 CellID->1198721133],
Cell[11874, 433, 3409, 60, 251, "Output",
 Evaluatable->False,
 CellID->15020721]
}, Open  ]],
Cell[15298, 496, 140, 4, 70, "Text",
 CellID->1518089858],
Cell[15441, 502, 222, 8, 70, "MathCaption",
 CellID->1525136211],
Cell[CellGroupData[{
Cell[15688, 514, 570, 19, 70, "Input",
 CellID->207385666],
Cell[16261, 535, 251, 6, 70, "Message",
 CellID->458967743],
Cell[16515, 543, 1129, 41, 71, "Output",
 CellID->45521524]
}, Open  ]],
Cell[17659, 587, 226, 8, 70, "MathCaption",
 CellID->1039081668],
Cell[CellGroupData[{
Cell[17910, 599, 538, 19, 70, "Input",
 CellID->2123907456],
Cell[18451, 620, 296, 10, 36, "Output",
 CellID->482823292]
}, Open  ]],
Cell[18762, 633, 245, 9, 70, "Text",
 CellID->404203831],
Cell[19010, 644, 197, 8, 70, "MathCaption",
 CellID->1816226375],
Cell[CellGroupData[{
Cell[19232, 656, 189, 6, 70, "Input",
 CellID->2083723153],
Cell[19424, 664, 596, 21, 36, "Output",
 CellID->251158091]
}, Open  ]],
Cell[20035, 688, 624, 21, 70, "Text",
 CellID->815363692],
Cell[20662, 711, 599, 24, 70, "Text",
 CellID->531221588],
Cell[21264, 737, 283, 10, 70, "Text",
 CellID->954389015],
Cell[21550, 749, 355, 12, 70, "MathCaption",
 CellID->1125162691],
Cell[CellGroupData[{
Cell[21930, 765, 673, 22, 70, "Input",
 CellID->2118098372],
Cell[22606, 789, 1129, 41, 71, "Output",
 CellID->38305462]
}, Open  ]],
Cell[23750, 833, 113, 3, 70, "MathCaption",
 CellID->1591160279],
Cell[CellGroupData[{
Cell[23888, 840, 604, 19, 47, "Input",
 CellID->349818858],
Cell[24495, 861, 4142, 72, 249, "Output",
 Evaluatable->False,
 CellID->184486456]
}, Open  ]],
Cell[28652, 936, 969, 35, 70, "Text",
 CellID->2085804158],
Cell[29624, 973, 606, 14, 70, "Text",
 CellID->940786282],
Cell[30233, 989, 222, 7, 70, "MathCaption",
 CellID->1924950375],
Cell[CellGroupData[{
Cell[30480, 1000, 502, 17, 70, "Input",
 CellID->40562567],
Cell[30985, 1019, 363, 7, 70, "Message",
 CellID->287280240],
Cell[31351, 1028, 175, 6, 36, "Output",
 CellID->17699100]
}, Open  ]],
Cell[31541, 1037, 686, 18, 70, "Text",
 CellID->1080336564],
Cell[32230, 1057, 158, 4, 70, "Text",
 CellID->1028514951],
Cell[32391, 1063, 177, 4, 70, "MathCaption",
 CellID->1781162625],
Cell[32571, 1069, 1931, 65, 70, "Input",
 CellID->1088931542],
Cell[34505, 1136, 146, 4, 70, "MathCaption",
 CellID->399121162],
Cell[CellGroupData[{
Cell[34676, 1144, 614, 19, 70, "Input",
 CellID->1158815189],
Cell[35293, 1165, 1085, 40, 71, "Output",
 CellID->109845408]
}, Open  ]],
Cell[36393, 1208, 325, 11, 70, "Text",
 CellID->374966153],
Cell[36721, 1221, 186, 9, 70, "MathCaption",
 CellID->1747514809],
Cell[CellGroupData[{
Cell[36932, 1234, 1118, 33, 101, "Input",
 CellID->187915228],
Cell[38053, 1269, 1729, 32, 77, "Output",
 Evaluatable->False,
 CellID->112558196]
}, Open  ]],
Cell[39797, 1304, 96, 1, 70, "MathCaption",
 CellID->1467349736],
Cell[CellGroupData[{
Cell[39918, 1309, 551, 17, 70, "Input",
 CellID->592119060],
Cell[40472, 1328, 1084, 40, 71, "Output",
 CellID->63406555]
}, Open  ]],
Cell[41571, 1371, 186, 4, 70, "Text",
 CellID->1403589241],
Cell[41760, 1377, 318, 8, 70, "MathCaption",
 CellID->197455629],
Cell[CellGroupData[{
Cell[42103, 1389, 1688, 49, 155, "Input",
 CellID->835496381],
Cell[43794, 1440, 4125, 72, 112, "Output",
 Evaluatable->False,
 CellID->381996026]
}, Open  ]],
Cell[47934, 1515, 382, 7, 70, "Text",
 CellID->1151844644],
Cell[48319, 1524, 80, 1, 70, "Text",
 CellID->1960659073],
Cell[48402, 1527, 528, 18, 70, "DisplayMath",
 CellID->1905425553],
Cell[48933, 1547, 598, 16, 70, "Text",
 CellID->574695588],
Cell[49534, 1565, 158, 4, 70, "Text",
 CellID->1404335704],
Cell[49695, 1571, 170, 4, 70, "MathCaption",
 CellID->107760763],
Cell[49868, 1577, 887, 30, 70, "Input",
 CellID->698522796],
Cell[50758, 1609, 188, 4, 70, "Text",
 CellID->1342656214],
Cell[50949, 1615, 452, 14, 70, "MathCaption",
 CellID->1048547045],
Cell[CellGroupData[{
Cell[51426, 1633, 547, 16, 70, "Input",
 CellID->475989523],
Cell[51976, 1651, 437, 16, 36, "Output",
 CellID->226323969]
}, Open  ]],
Cell[52428, 1670, 610, 21, 70, "Text",
 CellID->1436181185],
Cell[53041, 1693, 264, 6, 70, "MathCaption",
 CellID->1058431016],
Cell[CellGroupData[{
Cell[53330, 1703, 411, 12, 70, "Input",
 CellID->316071698],
Cell[53744, 1717, 436, 16, 36, "Output",
 CellID->49161494]
}, Open  ]],
Cell[54195, 1736, 113, 3, 70, "MathCaption",
 CellID->692109993],
Cell[CellGroupData[{
Cell[54333, 1743, 268, 8, 28, "Input",
 CellID->1405003240],
Cell[54604, 1753, 11588, 194, 236, "Output",
 Evaluatable->False,
 CellID->418284098]
}, Open  ]],
Cell[66207, 1950, 252, 8, 70, "MathCaption",
 CellID->1850925182],
Cell[CellGroupData[{
Cell[66484, 1962, 688, 20, 47, "Input",
 CellID->553836800],
Cell[67175, 1984, 3337, 59, 213, "Output",
 Evaluatable->False,
 CellID->667611864]
}, Open  ]],
Cell[70527, 2046, 214, 5, 70, "Text",
 CellID->1450956344],
Cell[70744, 2053, 158, 4, 70, "MathCaption",
 CellID->741752028],
Cell[CellGroupData[{
Cell[70927, 2061, 609, 17, 70, "Input",
 CellID->1442689765],
Cell[71539, 2080, 436, 16, 36, "Output",
 CellID->42003555]
}, Open  ]],
Cell[71990, 2099, 279, 8, 70, "MathCaption",
 CellID->1333871088],
Cell[CellGroupData[{
Cell[72294, 2111, 694, 20, 47, "Input",
 CellID->1462822454],
Cell[72991, 2133, 3925, 68, 213, "Output",
 Evaluatable->False,
 CellID->80925146]
}, Open  ]],
Cell[CellGroupData[{
Cell[76953, 2206, 72, 1, 70, "RelatedTutorialsSection",
 CellID->555808719],
Cell[77028, 2209, 326, 9, 70, "RelatedTutorials",
 CellID->604721514]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[77393, 2223, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

