(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17157,        593]
NotebookOptionsPosition[     11191,        398]
NotebookOutlinePosition[     12590,        437]
CellTagsIndexPosition[     12547,        434]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA OVERVIEW", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[TextData[{
 "Advanced Numerical Differential Equation Solving in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "TOCDocumentTitle",
 CellID->1472032537],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveIntroductoryTutorial"]], "TOCChapter",
 CellID->24464],

Cell[TextData[ButtonBox["Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveIntroductoryTutorial"]], "TOCSection",
 CellID->899521417],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["The Design of the NDSolve Framework",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign"]], "TOCSection",
 CellID->87525888],

Cell[TextData[ButtonBox["Features",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#75354863"]], "TOCSubsection",
 CellID->257375598],

Cell[TextData[ButtonBox["Common time stepping",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#1791028983"]], "TOCSubsection",
 CellID->3540156],

Cell[TextData[ButtonBox["Data encapsulation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#587411179"]], "TOCSubsection",
 CellID->360749784],

Cell[TextData[ButtonBox["Method hierarchy",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#154961554"]], "TOCSubsection",
 CellID->525760751],

Cell[TextData[ButtonBox["User extensibility",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#1518443729"]], "TOCSubsection",
 CellID->252061602],

Cell[TextData[ButtonBox["Method classes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#74982980"]], "TOCSubsection",
 CellID->26913457],

Cell[TextData[ButtonBox["Automatic selection and user controllability",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#2101685400"]], "TOCSubsection",
 CellID->436869768],

Cell[TextData[ButtonBox["Shared features",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#1332704694"]], "TOCSubsection",
 CellID->75849843],

Cell[TextData[ButtonBox["Some basic methods",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#958103344"]], "TOCSubsection",
 CellID->263407120],

Cell[TextData[ButtonBox["Acknowledgements",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDesign#590065589"]], "TOCSubsection",
 CellID->323825395]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ODE Integration Methods", "TOCChapter",
 CellID->2120397131],

Cell[CellGroupData[{

Cell["Methods", "TOCSection",
 CellID->355076882],

Cell[TextData[ButtonBox["ExplicitRungeKutta",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveExplicitRungeKutta"]], "TOCSubsection",
 CellID->88006700],

Cell[TextData[ButtonBox["ImplicitRungeKutta",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveImplicitRungeKutta"]], "TOCSubsection",
 CellID->218390630],

Cell[TextData[ButtonBox["SymplecticPartitionedRungeKutta",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveSPRK"]], "TOCSubsection",
 CellID->259591880]
}, Open  ]],

Cell[CellGroupData[{

Cell["Controller methods", "TOCSection",
 CellID->445960514],

Cell[TextData[ButtonBox["Composition and Splitting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveSplitting"]], "TOCSubsection",
 CellID->379788635],

Cell[TextData[ButtonBox["DoubleStep",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveDoubleStep"]], "TOCSubsection",
 CellID->44299997],

Cell[TextData[ButtonBox["Event Location",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveEventLocator"]], "TOCSubsection",
 CellID->8595363],

Cell[TextData[ButtonBox["Extrapolation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveExtrapolation"]], "TOCSubsection",
 CellID->139149116],

Cell[TextData[ButtonBox["FixedStep",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveFixedStep"]], "TOCSubsection",
 CellID->702340085],

Cell[TextData[ButtonBox["OrthogonalProjection",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveOrthogonalProjection"]], "TOCSubsection",\

 CellID->912554824],

Cell[TextData[ButtonBox["Projection",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveProjection"]], "TOCSubsection",
 CellID->9346537],

Cell[TextData[ButtonBox["StiffnessSwitching",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveStiffnessSwitching"]], "TOCSubsection",
 CellID->125809869]
}, Open  ]],

Cell[CellGroupData[{

Cell["Submethods", "TOCSection",
 CellID->10801330],

Cell[TextData[ButtonBox["ExplicitEuler",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveExtrapolation#1712532361"]], "TOCSubsection",
 CellID->828665419],

Cell[TextData[ButtonBox["ExplicitMidpoint",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveExtrapolation#1712532361"]], "TOCSubsection",
 CellID->639487991],

Cell[TextData[ButtonBox["ExplicitModifiedMidpoint",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveExtrapolation#1712532361"]], "TOCSubsection",
 CellID->447622900],

Cell[TextData[ButtonBox["LinearlyImplicitEuler",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveExtrapolation#1712532361"]], "TOCSubsection",
 CellID->522310617],

Cell[TextData[ButtonBox["LinearlyImplicitMidpoint",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveExtrapolation#1712532361"]], "TOCSubsection",
 CellID->279919522],

Cell[TextData[ButtonBox["LinearlyImplicitModifiedMidpoint",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveExtrapolation#1712532361"]], "TOCSubsection",
 CellID->184717226],

Cell[TextData[ButtonBox["LocallyExact",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveLocallyExact"]], "TOCSubsection",
 CellID->103390388]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extensions", "TOCSection",
 CellID->270896867],

Cell[TextData[ButtonBox["Method Plug-in Framework",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePlugIns"]], "TOCSubsection",
 CellID->17290018]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Partial Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePDE"]], "TOCChapter",
 CellID->460121640],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["The Numerical Method of Lines",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePDE"]], "TOCSection",
 CellID->99670715],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePDE#1699661144"]], "TOCSubsection",
 CellID->282748605],

Cell[TextData[ButtonBox["Spatial Derivative Approximations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePDE#1106740037"]], "TOCSubsection",
 CellID->180912804],

Cell[TextData[ButtonBox["Boundary Conditions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePDE#1306392612"]], "TOCSubsection",
 CellID->110883995],

Cell[TextData[ButtonBox["Spatial Error Estimates",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePDE#2081642391"]], "TOCSubsection",
 CellID->239379963]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Boundary Value Problems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveBVP"]], "TOCChapter",
 CellID->271372540],

Cell[TextData[ButtonBox["Shooting Method",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveBVP#659822336"]], "TOCSection",
 CellID->252558828],

Cell[TextData[ButtonBox["Chasing Method",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveBVP#948663323"]], "TOCSection",
 CellID->236538119],

Cell[TextData[ButtonBox["Boundary Value Problems with Parameters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveBVP#3518691"]], "TOCSection",
 CellID->62795157]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Differential-Algebraic Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveIntroductoryTutorialDAEs"]], "TOCChapter",\

 CellID->151973878],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveIntroductoryTutorialDAEs"]], "TOCSection",\

 CellID->61426304],

Cell[TextData[ButtonBox["IDA Method",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveIDAMethod"]], "TOCSection",
 CellID->33999882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Components and Data Structures",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveIntroductoryTutorialStateData"]], "TOCChapter",
 CellID->2563529],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveIntroductoryTutorialStateData#2125957807"]], \
"TOCSection",
 CellID->200364771],

Cell[TextData[ButtonBox["Example",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NDSolveIntroductoryTutorialStateData#580655648"]], \
"TOCSection",
 CellID->863037763],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Creating NDSolve`StateData Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveStateData"]], "TOCSection",
 CellID->27718042],

Cell[TextData[ButtonBox["ProcessEquations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveStateData#1805463009"]], "TOCSubsection",\

 CellID->245309011],

Cell[TextData[ButtonBox["Reinitialize",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveStateData#568926686"]], "TOCSubsection",
 CellID->224277447]
}, Open  ]],

Cell[TextData[ButtonBox["Iterating Solutions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveStateData#1408385626"]], "TOCSection",
 CellID->217847776],

Cell[TextData[ButtonBox["Getting Solution Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveStateData#1284231932"]], "TOCSection",
 CellID->127661040],

Cell[TextData[ButtonBox["NDSolve`StateData methods",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveStateData#93858351"]], "TOCSection",
 CellID->107818116]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["DifferentialEquations Utility Packages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePackages"]], "TOCChapter",
 CellID->27247067],

Cell[TextData[ButtonBox["InterpolatingFunctionAnatomy",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePackages#120436095"]], "TOCSection",
 CellID->2154197],

Cell[TextData[ButtonBox["NDSolveUtilities",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolvePackages#287875440"]], "TOCSection",
 CellID->235943391]
}, Open  ]],

Cell[TextData[ButtonBox["References",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NDSolveReferences"]], "TOCChapter",
 CellID->614043269],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Advanced Numerical Differential Equation Solving in Mathematica \
- Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 56.9152890}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Overview", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Introduction ODE Integration Methods Partial Differential Equations", 
    "synonyms" -> {}, "title" -> 
    "Advanced Numerical Differential Equation Solving in Mathematica", "type" -> 
    "Overview", "uri" -> "tutorial/NDSolveOverview"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[704, 27, 165, 5, 70, "TOCDocumentTitle",
 CellID->1472032537],
Cell[CellGroupData[{
Cell[894, 36, 151, 3, 70, "TOCChapter",
 CellID->24464],
Cell[1048, 41, 151, 3, 70, "TOCSection",
 CellID->899521417],
Cell[CellGroupData[{
Cell[1224, 48, 163, 3, 70, "TOCSection",
 CellID->87525888],
Cell[1390, 53, 149, 3, 70, "TOCSubsection",
 CellID->257375598],
Cell[1542, 58, 161, 3, 70, "TOCSubsection",
 CellID->3540156],
Cell[1706, 63, 160, 3, 70, "TOCSubsection",
 CellID->360749784],
Cell[1869, 68, 158, 3, 70, "TOCSubsection",
 CellID->525760751],
Cell[2030, 73, 161, 3, 70, "TOCSubsection",
 CellID->252061602],
Cell[2194, 78, 154, 3, 70, "TOCSubsection",
 CellID->26913457],
Cell[2351, 83, 187, 3, 70, "TOCSubsection",
 CellID->436869768],
Cell[2541, 88, 157, 3, 70, "TOCSubsection",
 CellID->75849843],
Cell[2701, 93, 160, 3, 70, "TOCSubsection",
 CellID->263407120],
Cell[2864, 98, 158, 3, 70, "TOCSubsection",
 CellID->323825395]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3071, 107, 66, 1, 70, "TOCChapter",
 CellID->2120397131],
Cell[CellGroupData[{
Cell[3162, 112, 49, 1, 70, "TOCSection",
 CellID->355076882],
Cell[3214, 115, 161, 3, 70, "TOCSubsection",
 CellID->88006700],
Cell[3378, 120, 162, 3, 70, "TOCSubsection",
 CellID->218390630],
Cell[3543, 125, 161, 3, 70, "TOCSubsection",
 CellID->259591880]
}, Open  ]],
Cell[CellGroupData[{
Cell[3741, 133, 60, 1, 70, "TOCSection",
 CellID->445960514],
Cell[3804, 136, 160, 3, 70, "TOCSubsection",
 CellID->379788635],
Cell[3967, 141, 145, 3, 70, "TOCSubsection",
 CellID->44299997],
Cell[4115, 146, 150, 3, 70, "TOCSubsection",
 CellID->8595363],
Cell[4268, 151, 152, 3, 70, "TOCSubsection",
 CellID->139149116],
Cell[4423, 156, 144, 3, 70, "TOCSubsection",
 CellID->702340085],
Cell[4570, 161, 168, 4, 70, "TOCSubsection",
 CellID->912554824],
Cell[4741, 167, 144, 3, 70, "TOCSubsection",
 CellID->9346537],
Cell[4888, 172, 162, 3, 70, "TOCSubsection",
 CellID->125809869]
}, Open  ]],
Cell[CellGroupData[{
Cell[5087, 180, 51, 1, 70, "TOCSection",
 CellID->10801330],
Cell[5141, 183, 166, 4, 70, "TOCSubsection",
 CellID->828665419],
Cell[5310, 189, 169, 4, 70, "TOCSubsection",
 CellID->639487991],
Cell[5482, 195, 177, 4, 70, "TOCSubsection",
 CellID->447622900],
Cell[5662, 201, 174, 4, 70, "TOCSubsection",
 CellID->522310617],
Cell[5839, 207, 177, 4, 70, "TOCSubsection",
 CellID->279919522],
Cell[6019, 213, 185, 4, 70, "TOCSubsection",
 CellID->184717226],
Cell[6207, 219, 150, 3, 70, "TOCSubsection",
 CellID->103390388]
}, Open  ]],
Cell[CellGroupData[{
Cell[6394, 227, 52, 1, 70, "TOCSection",
 CellID->270896867],
Cell[6449, 230, 156, 3, 70, "TOCSubsection",
 CellID->17290018]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6654, 239, 156, 3, 70, "TOCChapter",
 CellID->460121640],
Cell[CellGroupData[{
Cell[6835, 246, 154, 3, 70, "TOCSection",
 CellID->99670715],
Cell[6992, 251, 152, 3, 70, "TOCSubsection",
 CellID->282748605],
Cell[7147, 256, 173, 3, 70, "TOCSubsection",
 CellID->180912804],
Cell[7323, 261, 159, 3, 70, "TOCSubsection",
 CellID->110883995],
Cell[7485, 266, 163, 3, 70, "TOCSubsection",
 CellID->239379963]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7697, 275, 149, 3, 70, "TOCChapter",
 CellID->271372540],
Cell[7849, 280, 151, 3, 70, "TOCSection",
 CellID->252558828],
Cell[8003, 285, 150, 3, 70, "TOCSection",
 CellID->236538119],
Cell[8156, 290, 172, 3, 70, "TOCSection",
 CellID->62795157]
}, Open  ]],
Cell[CellGroupData[{
Cell[8365, 298, 181, 4, 70, "TOCChapter",
 CellID->151973878],
Cell[8549, 304, 160, 4, 70, "TOCSection",
 CellID->61426304],
Cell[8712, 310, 141, 3, 70, "TOCSection",
 CellID->33999882]
}, Open  ]],
Cell[CellGroupData[{
Cell[8890, 318, 183, 4, 70, "TOCChapter",
 CellID->2563529],
Cell[9076, 324, 180, 5, 70, "TOCSection",
 CellID->200364771],
Cell[9259, 331, 174, 5, 70, "TOCSection",
 CellID->863037763],
Cell[CellGroupData[{
Cell[9458, 340, 165, 3, 70, "TOCSection",
 CellID->27718042],
Cell[9626, 345, 164, 4, 70, "TOCSubsection",
 CellID->245309011],
Cell[9793, 351, 157, 3, 70, "TOCSubsection",
 CellID->224277447]
}, Open  ]],
Cell[9965, 357, 162, 3, 70, "TOCSection",
 CellID->217847776],
Cell[10130, 362, 169, 3, 70, "TOCSection",
 CellID->127661040],
Cell[10302, 367, 166, 3, 70, "TOCSection",
 CellID->107818116]
}, Open  ]],
Cell[CellGroupData[{
Cell[10505, 375, 168, 3, 70, "TOCChapter",
 CellID->27247067],
Cell[10676, 380, 167, 3, 70, "TOCSection",
 CellID->2154197],
Cell[10846, 385, 157, 3, 70, "TOCSection",
 CellID->235943391]
}, Open  ]],
Cell[11018, 391, 143, 3, 70, "TOCChapter",
 CellID->614043269],
Cell[11164, 396, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

