(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60101,       2330]
NotebookOptionsPosition[     33780,       1291]
NotebookOutlinePosition[     50334,       1953]
CellTagsIndexPosition[     47383,       1828]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Advanced Numerical Differential Equation Solving in \
Mathematica" :> 
         Documentation`HelpLookup["paclet:tutorial/NDSolveOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Advanced Numerical Differential Equation Solving in Mathematica\
\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Advanced Numerical Differential Equation Solving in Mathematica: References\
\>", "Title",
 CellTags->"c:1",
 CellID->12891],

Cell[TextData[{
 "[AP91] U. Ascher and L. Petzold, \"Projected implicit Runge-Kutta methods \
for differential algebraic equations\",",
 " ",
 "SIAM J. Numer. Anal., ",
 StyleBox["28",
  FontWeight->"Bold"],
 ", 1991, 1097-1120."
}], "Reference",
 CellTags->"AP91",
 CellID->12140],

Cell[TextData[{
 "[AP98] U. Ascher and L. Petzold, ",
 StyleBox["Computer Methods for Ordinary Differential Equations and \
Differential-Algebraic Equations",
  FontSlant->"Italic"],
 ", Philadelphia, SIAM Press, 1998."
}], "Reference",
 CellTags->"AP98",
 CellID->18232],

Cell[TextData[{
 "[ATLAS00] R. C. Whaley, A. Petitet, and J. J. Dongarra, \"Automated \
empirical optimization of software and the ATLAS project\". Available \
electronically from ",
 ButtonBox["http://math-atlas.sourceforge.net/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://math-atlas.sourceforge.net/"], None}],
 "."
}], "Reference",
 CellTags->"ATALS00",
 CellID->21834],

Cell[TextData[{
 "[BD83] G. Bader and P. Deuflhard, \"A semi-implicit mid-point rule for \
stiff systems of ordinary differential equations\". Numer. Math, ",
 StyleBox["41",
  FontWeight->"Bold"],
 ", 1983, 373-398."
}], "Reference",
 CellTags->"BD83",
 CellID->25441],

Cell[TextData[{
 "[BG94] G. Benettin and A. Giorgilli, \"On the Hamiltonian interpolation of \
near to the identity symplectic mappings with application to symplectic \
integration algorithms\". J. Stat. Phys. ",
 StyleBox["74",
  FontWeight->"Bold"],
 ", 1994, 1117-1143."
}], "Reference",
 CellTags->"BG94",
 CellID->9765],

Cell[TextData[{
 "[BZ65] I.S. Berezin and N.P. Zhidkov, ",
 StyleBox["Computing Methods",
  FontSlant->"Italic"],
 ", Volume 2, Pergamon, 1965."
}], "Reference",
 CellTags->"BZ65",
 CellID->5356],

Cell[TextData[{
 "[BM02] S. Blanes and P. C.",
 " ",
 "Moan, \"Practical symplectic partitioned Runge Kutta and Runge Kutta Nystr\
\[ODoubleDot]m methods\". J. Comput. Appl. Math. ",
 StyleBox["142",
  FontWeight->"Bold"],
 ", 2002, 313-330."
}], "Reference",
 CellTags->"BM02",
 CellID->26833],

Cell[TextData[{
 "[BCR99a] S. Blanes, F. Casas and J. Ros, \"Symplectic integration with \
processing: a general study\". SIAM J. Sci. Comput. ",
 StyleBox["21",
  FontWeight->"Bold"],
 ", 1999, 711-727."
}], "Reference",
 CellTags->"BCR99a",
 CellID->31786],

Cell["\<\
[BCR99b] S. Blanes, F. Casas and J. Ros, \"Extrapolation of symplectic \
integrators\". Report DAMTP NA09, Cambridge University, 1999.\
\>", "Reference",
 CellTags->"BCR99b",
 CellID->1528],

Cell[TextData[{
 "[BS89a] P. Bogacki and L. F. Shampine, \"A 3(2) pair of Runge-Kutta \
formulas\". Appl. Math. Letters, ",
 StyleBox["2",
  FontWeight->"Bold"],
 ", 1989, 1-9."
}], "Reference",
 CellTags->"BS89a",
 CellID->2609],

Cell["\<\
[BS89b] P. Bogacki and L. F. Shampine, \"An efficient Runge-Kutta (4, 5) pair\
\". Report 89-20, Math. Dept. Southern Methodist University, Dallas, Texas, \
1989.\
\>", "Reference",
 CellTags->"BS89b",
 CellID->4363],

Cell["\<\
[BGS93] R. W. Brankin, I. Gladwell and L. F. Shampine, \"RKSUITE: A Suite of \
Explicit Runge-Kutta Codes\". In: Contributions to Numerical Mathematics, R. \
P. Agarwal ed., WSSIAA 2. World Scientific, 1993, 41-53.\
\>", "Reference",
 CellTags->"BGS93",
 CellID->6300],

Cell[TextData[{
 "[BCP89] K. Brenan, S. Campbell, and L. Petzold, ",
 StyleBox["Numerical Solutions of Initial-Value Problems in \
Differential-Algebraic Equations",
  FontSlant->"Italic"],
 ", New York, Elsevier Science Publishing, 1989."
}], "Reference",
 CellTags->"BCP89",
 CellID->27005],

Cell[TextData[{
 "[BHP94] P. N. Brown, A. C. Hindmarsh, and L. R. Petzold, \"Using Krylov \
Methods in the Solution of Large-Scale Differential-Algebraic Systems\", SIAM \
J. Sci. Comput., ",
 StyleBox["15",
  FontWeight->"Bold"],
 ", 1994, 1467-1488."
}], "Reference",
 CellTags->"BHP94",
 CellID->19530],

Cell[TextData[{
 "[BHP98] P. N. Brown, A. C. Hindmarsh, and L. R. Petzold, \"Consistent \
Initial Condition Calculation for Differential-Algebraic Systems\", SIAM J. \
Sci. Comput., ",
 StyleBox["19",
  FontWeight->"Bold"],
 ", 1998, 1495-1512."
}], "Reference",
 CellTags->"BHP98",
 CellID->16131],

Cell[TextData[{
 "[B87] J. C. Butcher, ",
 StyleBox["The numerical analysis of ordinary differential equations: Runge \
Kutta and general linear methods",
  FontSlant->"Italic"],
 ". John Wiley, Chichester, 1987."
}], "Reference",
 CellTags->"B87",
 CellID->810],

Cell[TextData[{
 "[BS64] R. Bulirsch and J. Stoer, \"Fehlerabsch\[ADoubleDot]tzungen und \
Extrapolation mit rationalen Funktionen bei Verfahren vom Richardson-Typus\". \
Numer. Math., ",
 StyleBox["6",
  FontWeight->"Bold"],
 ", 1964, 413-427."
}], "Reference",
 CellTags->"BS64",
 CellID->22705],

Cell[TextData[{
 "[CIZ97] M. P. Calvo, A. Iserles and A. Zanna, \"Numerical solution of \
isospectral flows\". Math. Comp. ",
 StyleBox["66",
  FontWeight->"Bold"],
 " 220, 1997, 1461-1486."
}], "Reference",
 CellTags->"CIZ97",
 CellID->19797],

Cell[TextData[{
 "[CIZ99] M. P. Calvo, A. Iserles and A. Zanna, \"Conservative methods for \
the Toda lattice equations\". IMA J. Numer. Anal. ",
 StyleBox["19",
  FontWeight->"Bold"],
 ", 1999, 509-523."
}], "Reference",
 CellTags->"CIZ99",
 CellID->15918],

Cell[TextData[{
 "[CR91] J. Candy and R. Rozmus, \"A symplectic integration algorithm for \
separable Hamiltonian functions\". J. Comput. Phys. ",
 StyleBox["92",
  FontWeight->"Bold"],
 ", 1991, 230-256."
}], "Reference",
 CellTags->"CR91",
 CellID->13316],

Cell[TextData[{
 "[CH94] S. D. Cohen and A. C. Hindmarsh, ",
 StyleBox["CVODE User Guide",
  FontSlant->"Italic"],
 ", Lawrence Livermore National Laboratory report UCRL-MA-118618, September \
1994."
}], "Reference",
 CellTags->"CH94",
 CellID->6996],

Cell[TextData[{
 "[CH96] S. D. Cohen and A. C. Hindmarsh, \"CVODE, a Stiff/Nonstiff ODE \
Solver in C\", Computers in Physics, ",
 StyleBox["10",
  FontWeight->"Bold"],
 ", No. 2, 1996, 138-143."
}], "Reference",
 CellTags->"CH96",
 CellID->25889],

Cell[TextData[{
 "[C87] G. J. Cooper, \"Stability of Runge-Kutta methods for trajectory \
problems\", IMA J. Numer. Anal. ",
 StyleBox["7",
  FontWeight->"Bold"],
 ", 1987. 1-13."
}], "Reference",
 CellTags->"C87",
 CellID->14833],

Cell[TextData[{
 "[DP80] J. R. Dormand and P. J. Prince, \"A family of embedded Runge-Kutta \
formulae\". J. Comp. Appl. Math. ",
 StyleBox["6",
  FontWeight->"Bold"],
 ", 1980, 19-26."
}], "Reference",
 CellTags->"DP80",
 CellID->20618],

Cell[TextData[{
 "[DL01] N. Del Buono and L. Lopez, \"Runge-Kutta type methods based on \
geodesics for systems of ODEs on the Stiefel manifold\", BIT ",
 StyleBox["41",
  FontWeight->"Bold"],
 " (5), 2001, 912-923."
}], "Reference",
 CellTags->"DL01",
 CellID->2703],

Cell[TextData[{
 "[D83] P. Deuflhard, \"Order and step size control in extrapolation \
methods\". Numer. Math., ",
 StyleBox["41",
  FontWeight->"Bold"],
 ", 1983, 399-422."
}], "Reference",
 CellTags->"D83",
 CellID->27711],

Cell[TextData[{
 "[D85] P. Deuflhard, \"Recent progress in extrapolation methods for ordinary \
differential equations\". SIAM Rev., ",
 StyleBox["27",
  FontWeight->"Bold"],
 ", 1985, 505-535."
}], "Reference",
 CellTags->"D85",
 CellID->15460],

Cell["\<\
[DN87] P. Deuflhard and U. Nowak, \"Extrapolation integrators for quasilinear \
implicit ODEs\". In: P. Deuflhard, B. Engquist eds., Large-scale scientific \
computing, Birkh\[ADoubleDot]user, Boston, 1987.\
\>", "Reference",
 CellTags->"DN87",
 CellID->16135],

Cell[TextData[{
 "[DHZ87] P. Deuflhard, E. Hairer and J. Zugck, \"One-step and extrapolation \
methods for differential-algebraic systems\". Numer. Math., ",
 StyleBox["51",
  FontWeight->"Bold"],
 ", 1987, 501-516."
}], "Reference",
 CellTags->"DHZ87",
 CellID->9690],

Cell[TextData[{
 "[DRV94] L. Dieci, R. D. Russel and E. S. Van Vleck, \"Unitary integrators \
and applications to continuous orthonormalization techniques\", SIAM J. Num. \
Anal. ",
 StyleBox["31",
  FontWeight->"Bold"],
 ", 1994, 261-281."
}], "Reference",
 CellTags->"DRV94",
 CellID->3420],

Cell[TextData[{
 "[DV99] L. Dieci and E. S. Van Vleck, \"Computation of orthonormal factors \
for fundamental solution matrices\", Numer. Math. ",
 StyleBox["83",
  FontWeight->"Bold"],
 ", 1999, 599-620."
}], "Reference",
 CellTags->"DV99",
 CellID->2646],

Cell[TextData[{
 "[DLP98a] F. Diele, L. Lopez and R. Peluso, \"The Cayley transform in the \
numerical solution of unitary differential systems\". Adv. Comput. Math., ",
 StyleBox["8",
  FontWeight->"Bold"],
 ", 1998, 317-334."
}], "Reference",
 CellTags->"DLP98a",
 CellID->8860],

Cell[TextData[{
 "[DLP98b] F. Diele, L. Lopez and T. Politi, \"One step semi-explicit methods \
based on the Cayley transform for solving isospectral flows\". J. Comput. \
Appl. Math. ",
 StyleBox["89",
  FontWeight->"Bold"],
 ", 1998, 219-223."
}], "Reference",
 CellTags->"DLP98b",
 CellID->28445],

Cell[TextData[{
 "[ET92] D. J. D. Earn and S. Tremaine, \"Exact numerical studies of \
Hamiltonian maps: iterating without roundoff error\". Physica D. ",
 StyleBox["56",
  FontWeight->"Bold"],
 ", 1992, 1-22."
}], "Reference",
 CellTags->"ET92",
 CellID->16590],

Cell[TextData[{
 "[F69] E. Fehlberg, \"Low-order classical Runge-Kutta formulas with step \
size control and their application to heat transfer problems\". NASA \
Technical Report 315, 1969 (extract published in Computing, ",
 StyleBox["6",
  FontWeight->"Bold"],
 ", 1970, 61-71)."
}], "Reference",
 CellTags->"F69",
 CellID->145],

Cell[TextData[{
 "[FR90] E. Forest and R. D. Ruth, \"Fourth order symplectic integration\". \
Physica D. ",
 StyleBox["43",
  FontWeight->"Bold"],
 ", 1990, 105-117."
}], "Reference",
 CellTags->"FR90",
 CellID->21370],

Cell[TextData[{
 "[F92] B. Fornberg, \"Fast generation of weights in finite difference \
formulas,\" ",
 StyleBox["Recent Developments in Numerical Methods and Software for ",
  FontSlant->"Italic"],
 "ODE",
 StyleBox["s",
  FontSlant->"Italic"],
 "/DAE",
 StyleBox["s",
  FontSlant->"Italic"],
 "/PDE",
 StyleBox["s",
  FontSlant->"Italic"],
 " (G.D. Byrne and W. E. Schiesser, eds.), World Scientific, Singapore, 1992, \
97-123"
}], "Reference",
 CellTags->"F92",
 CellID->21013],

Cell[TextData[{
 "[F96a] B. Fornberg,",
 " ",
 StyleBox["A Practical guide to Pseudospectral Methods",
  FontSlant->"Italic"],
 ", Cambridge University Press, Cambridge, U.K., 1996."
}], "Reference",
 ShowCellBracket->False,
 CellTags->"F96",
 CellID->22110],

Cell[TextData[{
 "[F98] B. Fornberg, \"Calculation of weights in finite difference \
formulas\", ",
 StyleBox["SIAM Review",
  FontSlant->"Italic"],
 " 40 No. 3, 1998, 685-691. (Available in ",
 ButtonBox["PDF",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://amath.colorado.edu/faculty/fornberg/Docs/sirev_cl.pdf"], 
    None}],
 ")"
}], "Reference",
 CellTags->"F98",
 CellID->9836],

Cell[TextData[{
 "[F96b] T. Fukushima. \"Reduction of round-off errors in the extrapolation \
methods and its application to the integration of orbital motion.\" Astron. \
J. ",
 StyleBox["112",
  FontWeight->"Bold"],
 " 3, 1996, 1298-1301."
}], "Reference",
 CellTags->"F96",
 CellID->26897022],

Cell[TextData[{
 "[G51] S. Gill, \"A process for the step-by-step integration of differential \
equations\". In: an automatic digital computing machine, Proc. Cambridge \
Philos. Soc., ",
 StyleBox["47",
  FontWeight->"Bold"],
 ", 1951, 96-108."
}], "Reference",
 CellTags->"G51",
 CellID->10068],

Cell[TextData[{
 "[G65] W. B. Gragg, \"On extrapolation algorithms for ordinary initial value \
problems\". SIAM J. Num. Anal. ",
 StyleBox["2",
  FontWeight->"Bold"],
 ", 1965, 384-403."
}], "Reference",
 CellTags->"G65",
 CellID->6906],

Cell[TextData[{
 "[G\[CapitalOSlash]84] C. W. Gear and O. \[CapitalOSlash]sterby, \"Solving \
ordinary differential equations with discontinuities\". ACM Trans. Math. \
Soft. ",
 StyleBox["10",
  FontWeight->"Bold"],
 ", 1984, 23-44."
}], "Reference",
 CellTags->"G\[CapitalOSlash]84",
 CellID->12707],

Cell[TextData[{
 "[G91] K. Gustafsson, \"Control theoretic techniques for stepsize selection \
in explicit Runge-Kutta methods\". ACM Trans. Math. Soft., ",
 StyleBox["17",
  FontWeight->"Bold"],
 ", 533-554."
}], "Reference",
 CellTags->"G91",
 CellID->26956],

Cell[TextData[{
 "[G94] K. Gustafsson, \"Control theoretic techniques for stepsize selection \
in implicit Runge-Kutta methods\". ACM Trans. Math. Soft., ",
 StyleBox["20",
  FontWeight->"Bold"],
 ", 496-517."
}], "Reference",
 CellTags->"G94",
 CellID->7701],

Cell[TextData[{
 "[GMW81] P. Gill, W. Murray, and M. Wright, ",
 StyleBox["Practical Optimization",
  FontSlant->"Italic"],
 ", Academic Press, Oxford, 1981."
}], "Reference",
 CellTags->"GMW81",
 CellID->16479],

Cell[TextData[{
 "[GDC91] B. Gladman, M. Duncan, and J. Candy, \"Symplectic integrators for \
long-term integrations in celestial mechanics\". Celest. Mech. ",
 StyleBox["52",
  FontWeight->"Bold"],
 ", 1991, 221-240."
}], "Reference",
 CellTags->"GDC91",
 CellID->23494],

Cell[TextData[{
 "[GSB87] I. Gladwell, L. F. Shampine and R. W. Brankin, \"Automatic \
selection of the initial step size for an ODE solver\". J. Comp. Appl. Math. \
",
 StyleBox["18",
  FontWeight->"Bold"],
 ", 1987, 175-192."
}], "Reference",
 CellTags->"GSB87",
 CellID->30254],

Cell[TextData[{
 "[GVL96] G. H. Golub and C. F. Van Loan, ",
 StyleBox["Matrix computations",
  FontSlant->"Italic"],
 ", Johns Hopkins University Press, Baltimore, 3rd edn, 1996."
}], "Reference",
 CellTags->"GVL96",
 CellID->18126],

Cell[TextData[{
 "[H94] E. Hairer, \"Backward analysis of numerical integrators and \
symplectic methods\". Annals of Numerical Mathematics, ",
 StyleBox["1",
  FontWeight->"Bold"],
 ", 1984, 107-132."
}], "Reference",
 CellTags->"H94",
 CellID->1113],

Cell[TextData[{
 "[H97] E. Hairer, \"Variable time step integration with symplectic \
methods\". Appl. Numer. Math. ",
 StyleBox["25",
  FontWeight->"Bold"],
 ", 1997, 219-227."
}], "Reference",
 CellTags->"H97",
 CellID->20646],

Cell[TextData[{
 "[H00] E. Hairer, \"Symmetric projection methods for differential equations \
on manifolds\". BIT. ",
 StyleBox["40",
  FontWeight->"Bold"],
 " (4), 2000, 726-734."
}], "Reference",
 CellTags->"H00",
 CellID->25443],

Cell[TextData[{
 "[HL97] E. Hairer and Ch. Lubich, \"The life-span of backward error analysis \
for numerical integrators\". Numer. Math. ",
 StyleBox["76",
  FontWeight->"Bold"],
 ", 1997, 441-462. Erratum: http://www.unige.ch/math/folks/hairer."
}], "Reference",
 CellTags->"HL97",
 CellID->28914],

Cell[TextData[{
 "[HL88a] E. Hairer and Ch. Lubich, \"Extrapolation at stiff differential \
equations\". Numer. Math., ",
 StyleBox["52",
  FontWeight->"Bold"],
 ", 1988, 377-400."
}], "Reference",
 CellTags->"HL88a",
 CellID->12515],

Cell["\<\
[HL88b] E. Hairer and Ch. Lubich, \"On extrapolation methods for stiff and \
differential-algebraic equations\". Teubner Texte zur Mathematik, Band 104, \
Teubner, Leipzig, 1988, 64-73.\
\>", "Reference",
 CellTags->"HL88b",
 CellID->18787],

Cell[TextData[{
 "[HO90] E. Hairer and A. Ostermann, \"Dense output for extrapolation methods\
\". Numer. Math., ",
 StyleBox["58",
  FontWeight->"Bold"],
 ", 1990, 419-439."
}], "Reference",
 CellTags->"HO90",
 CellID->90],

Cell[TextData[{
 "[HW96] E. Hairer and G. Wanner, ",
 StyleBox["Solving Ordinary Differential Equations II, Stiff and \
Differential-Algebraic Problem",
  FontSlant->"Italic"],
 "s, Springer-Verlag, Berlin,",
 " ",
 "2nd edn., 1996."
}], "Reference",
 CellTags->"HW96",
 CellID->32197],

Cell[TextData[{
 "[HW99] E. Hairer and G. Wanner, \"Stiff differential equations solved by \
Radau methods\", J. Comp. Appl. Math. ",
 StyleBox["111",
  FontWeight->"Bold"],
 ", 1999, 93-111."
}], "Reference",
 CellTags->"HW99",
 CellID->29569],

Cell[TextData[{
 "[HLW02] E. Hairer, Ch. Lubich and G. Wanner, ",
 StyleBox["Geometric Numerical Integration. Structure-Preserving Algorithms \
for Ordinary Differential Equations",
  FontSlant->"Italic"],
 ", Springer Ser. Comput. Math. 31, Springer-Verlag, 2002."
}], "Reference",
 CellTags->"HLW02",
 CellID->2433],

Cell[TextData[{
 "[HNW93] E. Hairer, S. P. N\[OSlash]rsett and G. Wanner, ",
 StyleBox["Solving Ordinary Differential Equations I, Nonstiff Problems",
  FontSlant->"Italic"],
 ", Springer-Verlag, Berlin, 2nd edn., 1993."
}], "Reference",
 CellTags->"HNW93",
 CellID->24148],

Cell[TextData[{
 "[H97] D. Higham, \"Time-stepping and preserving orthonormality\", BIT ",
 StyleBox["37",
  FontWeight->"Bold"],
 " 1, 1997, 24-36."
}], "Reference",
 CellTags->"H97",
 CellID->26130],

Cell["\<\
[H89] N. J. Higham, \"Matrix nearness problems and applications\". In: M. J. \
C. Gover and S. Barnett eds., Applications of Matrix Theory. Oxford \
University Press, Oxford, 1989, 1-27.\
\>", "Reference",
 CellTags->"H89",
 CellID->7204],

Cell[TextData[{
 "[H96] N. J. Higham, ",
 StyleBox["Accuracy and stability of numerical algorithms",
  FontSlant->"Italic"],
 ". SIAM, Philadelphia, 1996."
}], "Reference",
 CellTags->"H96",
 CellID->12862],

Cell["\<\
[H83] A. C. Hindmarsh, \"Odepack, a systematized collection of ode solvers\". \
In: Scientific Computing, R. S. Stepleman et al. eds., North-Holland, \
Amsterdam, 1983, 55-64.\
\>", "Reference",
 CellTags->"H83",
 CellID->18460],

Cell[TextData[{
 "[HT99] A Hindmarsh and A. Taylor, ",
 StyleBox["User Documentation for IDA,A Differential-Algebraic Equation \
Solver for Sequential and Parallel Computers, ",
  FontSlant->"Italic"],
 "Lawrence Livermore National Laboratory report",
 StyleBox[", ",
  FontSlant->"Italic"],
 "UCRL-MA-136910, December 1999"
}], "Reference",
 CellTags->"HT99",
 CellID->17230],

Cell[TextData[{
 "[KL97] W. H. Kahan and R. C. Li, \"Composition constants for raising the \
order of unconventional schemes for ordinary differential equations\". Math. \
Comp. ",
 StyleBox["66",
  FontWeight->"Bold"],
 ", 1997, 1089-1099."
}], "Reference",
 CellTags->"KL97",
 CellID->24611],

Cell["\<\
[K65] W. H. Kahan, \"Further remarks on reducing truncation errors\". \
Comm.ACM., Vol. 8 No.40., 1965.\
\>", "Reference",
 CellTags->"K65",
 CellID->4309],

Cell[TextData[{
 "[K93] I. Koren, ",
 StyleBox["Computer arithmetic algorithms",
  FontSlant->"Italic"],
 ". Prentice Hall, New Jersey, 1993."
}], "Reference",
 CellTags->"K93",
 CellID->4568],

Cell[TextData[{
 "[L87] J. D. Lambert, ",
 StyleBox["Numerical Methods for OrdinaryDifferential Equations",
  FontSlant->"Italic"],
 ". John Wiley, Chichester, 1987."
}], "Reference",
 CellTags->"L87",
 CellID->7030],

Cell[TextData[{
 "[LAPACK99] E. Anderson, Z. Bai, C. Bischof, S. Blackford, J. Demmel, J. \
Dongarra, J. Du Croz, A. Greenbaum, S. Hammarling, A. McKenney and D. \
Sorenson, ",
 StyleBox["LAPACK Users' Guide",
  FontSlant->"Italic"],
 ". 3rd edn. SIAM, Philadelphia, 1999."
}], "Reference",
 CellTags->"LAPACK99",
 CellID->18138],

Cell["\<\
[M68] G. Marchuk, \"Some applications of splitting-up methods to the solution \
of mathematical physics problems\", Aplikace Matematiky 13, 1968, 103-132.\
\>", "Reference",
 CellTags->"M68",
 CellID->24932],

Cell[TextData[{
 "[MR99] J. E. Marsden and T. Ratiu, ",
 StyleBox["Introduction to mechanics and symmetry",
  FontSlant->"Italic"],
 ". Texts in Applied Mathematics, Vol. 17. 2nd edn. Springer-Verlag, New \
York. 1999."
}], "Reference",
 CellTags->"MR99",
 CellID->7001],

Cell[TextData[{
 "[M93] R. I. McLachlan, \"Explicit Lie-Poisson integration and the Euler \
equations\", Phys. Rev. Lett. ",
 StyleBox["71",
  FontWeight->"Bold"],
 ", 1993, 3043-3046."
}], "Reference",
 CellTags->"M93",
 CellID->29102],

Cell[TextData[{
 "[M95a] R. I. McLachlan, \"On the numerical integration of ordinary \
differential equations by symmetric composition methods\". SIAM J. Sci. Comp. \
",
 StyleBox["16",
  FontWeight->"Bold"],
 ", 1995, 151-168."
}], "Reference",
 CellTags->"M95a",
 CellID->16191],

Cell[TextData[{
 "[M95b] R. I. McLachlan, \"Composition methods in the presence of small \
parameters\". BIT. ",
 StyleBox["35",
  FontWeight->"Bold"],
 ", 1995, 258-268."
}], "Reference",
 CellTags->"M95b",
 CellID->3406],

Cell[TextData[{
 "[M01] R. I. McLachlan, \"Families of high-order composition methods\". \
Numerical Algorithms. ",
 StyleBox["31",
  FontWeight->"Bold"],
 ", 2002, 233-246."
}], "Reference",
 CellTags->"M01",
 CellID->17804],

Cell[TextData[{
 "[MA92] R. I. McLachlan and P. Atela, \"The accuracy of symplectic \
integrators\". Nonlinearity. ",
 StyleBox["5",
  FontWeight->"Bold"],
 ", 1992, 541-562."
}], "Reference",
 CellTags->"MA92",
 CellID->8579],

Cell[TextData[{
 "[MQ02] R. I. McLachlan and G. R. W. Quispel, \"Splitting methods\", Acta \
Numerica ",
 StyleBox["11",
  FontWeight->"Bold"],
 ",",
 " ",
 "2002, 341-434. "
}], "Reference",
 CellTags->"MQ02",
 CellID->31673],

Cell[TextData[{
 "[MG80] A. Mitchell and D. Griffiths, ",
 StyleBox["The Finite Difference Method in Partial Differential Equations",
  FontSlant->"Italic"],
 ", John Wiley and Sons, New York, 1980."
}], "Reference",
 CellTags->"MG80",
 CellID->28210],

Cell[TextData[{
 "[M65a] O. M\[OSlash]ller, \"Quasi double-precision in floating point \
addition\". BIT, ",
 StyleBox["5",
  FontWeight->"Bold"],
 ", 1965, 37-50."
}], "Reference",
 CellTags->"M65a",
 CellID->28965],

Cell[TextData[{
 "[M65b] O. M\[OSlash]ller, \"Note on quasi double-precision\". BIT, ",
 StyleBox["5",
  FontWeight->"Bold"],
 ", 1965, 251-255."
}], "Reference",
 CellTags->"M65b",
 CellID->37],

Cell[TextData[{
 "[M97] A. Murua, \"On order conditions for partitioned symplectic methods\". \
SIAM J. Numer. Anal. ",
 StyleBox["34",
  FontWeight->"Bold"],
 " (6), 1997, 2204-2211."
}], "Reference",
 CellTags->"M97",
 CellID->22219],

Cell[TextData[{
 "[MS99] A. Murua and J. M. Sanz-Serna, \"Order conditions for numerical \
integrators obtained by composing simpler integrators\". Phil. Trans. Royal \
Soc. A ",
 StyleBox["357",
  FontWeight->"Bold"],
 ", 1999, 1079-1100."
}], "Reference",
 CellTags->"MS99",
 CellID->9818],

Cell[TextData[{
 "[M04] C. B. Moler, ",
 StyleBox["Numerical Computing with MATLAB",
  FontSlant->"Italic"],
 ", SIAM, Philadelphia, 2004."
}], "Reference",
 CellTags->"M04",
 CellID->25049],

Cell[TextData[{
 "[Na79] T. Y. Na, ",
 StyleBox["Computational Methods in Engineering: Boundary Value Problems",
  FontSlant->"Italic"],
 ", Academic Press, New York, 1979."
}], "Reference",
 CellTags->"Na79",
 CellID->712],

Cell[TextData[{
 "[OS92] D. I. Okunbor and R. D. Skeel, \"Explicit canonical methods for \
Hamiltonian systems\". Math. Comp. ",
 StyleBox["59",
  FontWeight->"Bold"],
 ", 1992, 439-455."
}], "Reference",
 CellTags->"OS92",
 CellID->28646],

Cell["\<\
[O95] H. Olsson, \"Practical implementation of Runge-Kutta methods for \
initial value problems\". Licentiate thesis, Department of Computer Science, \
Lund University, 1995.\
\>", "Reference",
 CellTags->"O95",
 CellID->6718],

Cell["\<\
[O98] H. Olsson, \"Runge-Kutta solution of initial value problems: methods, \
algorithms and implementation\". PhD Thesis, Department of Computer Science, \
Lund University, 1998.\
\>", "Reference",
 CellTags->"O98",
 CellID->25038],

Cell[TextData[{
 "[OS00] H. Olsson and G. S\[ODoubleDot]derlind, \"The approximate \
Runge-Kutta computational process\". BIT, ",
 StyleBox["40",
  FontWeight->"Bold"],
 " No. 2, 2000, 351-373."
}], "Reference",
 CellTags->"OS00",
 CellID->9289],

Cell[TextData[{
 "[P83] L. R. Petzold, \"Automatic selection of methods for solving stiff and \
nonstiff systems of ordinary differential equations\". SIAM J. Sci. Stat. \
Comput. ",
 StyleBox["4",
  FontWeight->"Bold"],
 ", 1983, 136-148."
}], "Reference",
 CellTags->"P83",
 CellID->2690],

Cell[TextData[{
 "[QSS00] A. Quarteroni, R. Sacco, and F. Saleri, ",
 StyleBox["Numerical Mathematics",
  FontSlant->"Italic"],
 ", Springer-Verlag, New York, 2000."
}], "Reference",
 CellTags->"QSS00",
 CellID->9033],

Cell[TextData[{
 "[QV94] A. Quarteroni and A. Valli, ",
 StyleBox["Numerical Approximation of Partial Differential Equations",
  FontSlant->"Italic"],
 ", Springer-Verlag, Berlin, 1994."
}], "Reference",
 CellTags->"QV94",
 CellID->14672],

Cell[TextData[{
 "[QT90] T. Quinn and S. Tremaine, \"Roundoff error in long-term planetary \
orbit integrations\". Astron. J. ",
 StyleBox["99",
  FontWeight->"Bold"],
 " (3), 1990, 1016-1023."
}], "Reference",
 CellTags->"QT90",
 CellID->19989],

Cell["\<\
[R93] S. Reich, \"Numerical integration of the generalized Euler equations\", \
Tech. Rep. 93-20, 1993, Dept. Comput. Sci., Univ. of British Columbia.\
\>", "Reference",
 CellTags->"R93",
 CellID->25453],

Cell[TextData[{
 "[R99] S. Reich, \"Backward error analysis for numerical integrators\". SIAM \
J. Num. Anal., ",
 StyleBox["36",
  FontWeight->"Bold"],
 ", 1999, 1549-1570."
}], "Reference",
 CellTags->"R99",
 CellID->24544],

Cell[TextData[{
 "[R98] B. Rubinstein, \"Numerical Solution of Linear Boundary Value Problems\
\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 StyleBox["MathSource",
  FontSlant->"Italic"],
 " package, ",
 ButtonBox["http://library.wolfram.com/database/MathSource/2127/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://library.wolfram.com/database/MathSource/2127/"], None}]
}], "Reference",
 CellTags->"R98",
 CellID->20165],

Cell[TextData[{
 "[RM57] R. Richtmeyer and K. Morton, ",
 StyleBox["Difference Methods for Initial Value Problems",
  FontSlant->"Italic"],
 ", Malabar, Krieger Publishing Company, Florida, 1994 (original edition \
1957)."
}], "Reference",
 CellTags->"RM57",
 CellID->18503],

Cell["\<\
[R87] B. C. Robertson, \"Detecting stiffness with explicit Runge-Kutta \
formulas\". Report 193/87, Dept. Comp. Sci., University of Toronto, 1987.\
\>", "Reference",
 CellTags->"R87",
 CellID->28770],

Cell[TextData[{
 "[SC94] J. M. Sanz-Serna and M. P. Calvo, ",
 StyleBox["Numerical Hamiltonian problems",
  FontSlant->"Italic"],
 ", Applied Mathematics and Mathematical Computation, ",
 StyleBox["7",
  FontWeight->"Bold"],
 ", Chapman and Hall, London, 1994."
}], "Reference",
 CellTags->"SC94",
 CellID->17569],

Cell[TextData[{
 "[S91] W. Schiesser, ",
 StyleBox["The Numerical Method of Lines",
  FontSlant->"Italic"],
 ", Academic Press,",
 " ",
 "San Diego, 1991."
}], "Reference",
 CellTags->"S91",
 CellID->739],

Cell["\<\
[S86] L. F. Shampine. \"Conservation laws and the numerical solution of \
ODEs\", Comp. Maths. Appl. 12B, 1986, 1287-1296.\
\>", "Reference",
 CellTags->"S86",
 CellID->29968],

Cell[TextData[{
 "[S87] L. F. Shampine, \"Control of step size and order in extrapolation \
codes\". J. Comp. Appl. Math., ",
 StyleBox["18",
  FontWeight->"Bold"],
 ", 1987, 3-16."
}], "Reference",
 CellTags->"S87",
 CellID->15837],

Cell[TextData[{
 "[S94] L. F. Shampine, ",
 StyleBox["Numerical solution of ordinary differential equations.",
  FontSlant->"Italic"],
 " Chapman and Hall, New York, 1994."
}], "Reference",
 CellTags->"S94",
 CellID->21224],

Cell[TextData[{
 "[SB83] L. F. Shampine and L. S. Baca, \"Smoothing the extrapolated midpoint \
rule\". Numer. Math.. ",
 StyleBox["41",
  FontWeight->"Bold"],
 ", 1983, 165-175."
}], "Reference",
 CellTags->"SB83",
 CellID->7456],

Cell[TextData[{
 "[SG75] L. Shampine and M. Gordon, ",
 StyleBox["Computer Solutions of Ordinary Differential Equations",
  FontSlant->"Italic"],
 ", San Francisco, W.H. Freeman, 1975."
}], "Reference",
 CellTags->"SG75",
 CellID->23388],

Cell[TextData[{
 "[SGT03] L. Shampine, I Gladwell, and S. Thompson, ",
 StyleBox["Solving ODEs with MATLAB",
  FontSlant->"Italic"],
 ", Cambridge University Press, Cambridge, 2003."
}], "Reference",
 CellTags->"SGT03",
 CellID->24366],

Cell[TextData[{
 "[SBB83] L. F. Shampine, L. S. Baca and H. J. Bauer, \"Output in \
extrapolation codes\". Comp. and Maths. with Appl. ",
 StyleBox["9",
  FontWeight->"Bold"],
 ", 1983, 245-255."
}], "Reference",
 CellTags->"SBB83",
 CellID->6296],

Cell[TextData[{
 "[SS03] M. Sofroniou and G. Spaletta, \"Increment formulations for rounding \
error reduction in the numerical solution of structured differential \
systems\". Future Generation Computer Systems, Del Buono and Politi eds., \
Elsevier Science, North-Holland, Amsterdam, ",
 StyleBox["19",
  FontWeight->"Bold"],
 " 3, 2003, 375-383."
}], "Reference",
 CellTags->"SS02",
 CellID->23658],

Cell[TextData[{
 "[SS04] M. Sofroniou and G. Spaletta, \"Construction of explicit Runge-Kutta \
pairs with stiffness detection\", Mathematical and Computer Modelling, \
special issue on The Numerical Analysis of Ordinary Differential Equations, \
Elsevier Science, North Holland, Amsterdam, ",
 StyleBox["40",
  FontWeight->"Bold"],
 " 11-12, 2004, 1157-1169"
}], "Reference",
 CellTags->"SS04",
 CellID->9420],

Cell[TextData[{
 "[SS05] M. Sofroniou and G. Spaletta, \"Derivation of symmetric composition \
constants for symmetric integrators\", Optimization Methods and Software, ",
 StyleBox["20",
  FontWeight->"Bold"],
 " 4-5, 2005, 597-613."
}], "Reference",
 CellTags->"SS05",
 CellID->17586],

Cell[TextData[{
 "[SS06] M. Sofroniou and G. Spaletta, \"Hybrid solvers for splitting and \
composition methods\", J. Comp. Appl. Math., special issue from the \
International Workshop on the Technological Aspects of Mathematics, F. Mazzia \
and T. Politi eds., ",
 StyleBox["185",
  FontWeight->"Bold"],
 " 2, 2006, 278-291."
}], "Reference",
 CellTags->"SS06",
 CellID->146830885],

Cell["\<\
[S84] G. Sottas, \"Dynamic adaptive selection between explicit and implicit \
methods when solving ODEs\". Report, Sect. de math, University of \
Gen\[EGrave]ve, 1984.\
\>", "Reference",
 CellTags->"S84",
 CellID->23832],

Cell[TextData[{
 "[S68] G. Strang, \"On the construction of difference schemes\", SIAM J. \
Num. Anal. ",
 StyleBox["5",
  FontWeight->"Bold"],
 ", 1968, 506-517."
}], "Reference",
 CellTags->"S68",
 CellID->25],

Cell[TextData[{
 "[S70] H. J. Stetter, \"Symmetric two-step algorithms for ordinary \
differential equations\". Computing, Vol. ",
 StyleBox["5",
  FontWeight->"Bold"],
 ", 1970, 267-280."
}], "Reference",
 CellTags->"S70",
 CellID->29276],

Cell[TextData[{
 "[S90] M. Suzuki, \"Fractal decomposition of exponential operators with \
applications to many-body theories and Monte Carlo simulations\", Phys. Lett. \
A ",
 StyleBox["146",
  FontWeight->"Bold"],
 ", 1990, 319-323."
}], "Reference",
 CellTags->"S90",
 CellID->3309],

Cell["\<\
[T59] H. F. Trotter, \"On the product of semi-group operators\", Proc. Am. \
Math. Soc. 10 ,1959, 545-551.\
\>", "Reference",
 CellTags->"T59",
 CellID->8091],

Cell[TextData[{
 "[V78] J. H. Verner, Explicit Runge-Kutta methods with estimates of the \
local truncation error, SIAM J. Num. Anal., Vol. ",
 StyleBox["15",
  FontWeight->"Bold"],
 ", 1978, 772-790."
}], "Reference",
 CellTags->"V78",
 CellID->23842],

Cell["\<\
[V79] E. Vitasek, \"A-stability and numerical solution of evolution \
problems\". IAC `Mauro Picone', Series III, Vol. 186, 1979, 42.\
\>", "Reference",
 CellTags->"V79",
 CellID->11721],

Cell[TextData[{
 "[W76] G.B. Whitham, ",
 StyleBox["Linear and Nonlinear Waves",
  FontSlant->"Italic"],
 ", John Wiley and Sons, New York, 1976."
}], "Reference",
 CellTags->"W76",
 CellID->8787],

Cell[TextData[{
 "[WH91] J. Wisdom and M. Holman, Symplectic maps for the N-body problem. \
Astron. J. ",
 StyleBox["102",
  FontWeight->"Bold"],
 ", 1991, 1528-1538."
}], "Reference",
 CellTags->"WH91",
 CellID->19109],

Cell[TextData[{
 "[Y90] H. Yoshida, \"Construction of high order symplectic integrators\". \
Phys. Lett. A. ",
 StyleBox["150",
  FontWeight->"Bold"],
 ", 1990, 262-268."
}], "Reference",
 CellTags->"Y90",
 CellID->21389],

Cell["\<\
[Z98] A. Zanna, On the numerical solution of isospectral flows, Ph. D. \
Thesis, Cambridge University, 1998.\
\>", "Reference",
 CellTags->"Z98",
 CellID->14383],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->668287648],

Cell[TextData[{
 ButtonBox["Advanced Numerical Differential Equation Solving in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->604721514]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Advanced Numerical Differential Equation Solving in \
Mathematica: References - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Advanced Numerical Differential Equation Solving in Mathematica", 
         "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NDSolveOverview"]], "Text", FontFamily -> "Verdana"],
     "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NDSolvePackages#287875440"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 40, 17.3064360}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "", "synonyms" -> {}, "title" -> 
    "Advanced Numerical Differential Equation Solving in Mathematica: \
References", "type" -> "Tutorial", "uri" -> "tutorial/NDSolveReferences"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:1"->{
  Cell[1328, 44, 134, 4, 70, "Title",
   CellTags->"c:1",
   CellID->12891]},
 "AP91"->{
  Cell[1465, 50, 281, 10, 70, "Reference",
   CellTags->"AP91",
   CellID->12140]},
 "AP98"->{
  Cell[1749, 62, 271, 8, 70, "Reference",
   CellTags->"AP98",
   CellID->18232]},
 "ATALS00"->{
  Cell[2023, 72, 388, 11, 70, "Reference",
   CellTags->"ATALS00",
   CellID->21834]},
 "BD83"->{
  Cell[2414, 85, 269, 8, 70, "Reference",
   CellTags->"BD83",
   CellID->25441]},
 "BG94"->{
  Cell[2686, 95, 324, 9, 70, "Reference",
   CellTags->"BG94",
   CellID->9765]},
 "BZ65"->{
  Cell[3013, 106, 195, 7, 70, "Reference",
   CellTags->"BZ65",
   CellID->5356]},
 "BM02"->{
  Cell[3211, 115, 294, 10, 70, "Reference",
   CellTags->"BM02",
   CellID->26833]},
 "BCR99a"->{
  Cell[3508, 127, 258, 8, 70, "Reference",
   CellTags->"BCR99a",
   CellID->31786]},
 "BCR99b"->{
  Cell[3769, 137, 199, 5, 70, "Reference",
   CellTags->"BCR99b",
   CellID->1528]},
 "BS89a"->{
  Cell[3971, 144, 229, 8, 70, "Reference",
   CellTags->"BS89a",
   CellID->2609]},
 "BS89b"->{
  Cell[4203, 154, 226, 6, 70, "Reference",
   CellTags->"BS89b",
   CellID->4363]},
 "BGS93"->{
  Cell[4432, 162, 278, 6, 70, "Reference",
   CellTags->"BGS93",
   CellID->6300]},
 "BCP89"->{
  Cell[4713, 170, 292, 8, 70, "Reference",
   CellTags->"BCP89",
   CellID->27005]},
 "BHP94"->{
  Cell[5008, 180, 305, 9, 70, "Reference",
   CellTags->"BHP94",
   CellID->19530]},
 "BHP98"->{
  Cell[5316, 191, 298, 9, 70, "Reference",
   CellTags->"BHP98",
   CellID->16131]},
 "B87"->{
  Cell[5617, 202, 262, 8, 70, "Reference",
   CellTags->"B87",
   CellID->810]},
 "BS64"->{
  Cell[5882, 212, 297, 9, 70, "Reference",
   CellTags->"BS64",
   CellID->22705]},
 "CIZ97"->{
  Cell[6182, 223, 243, 8, 70, "Reference",
   CellTags->"CIZ97",
   CellID->19797]},
 "CIZ99"->{
  Cell[6428, 233, 257, 8, 70, "Reference",
   CellTags->"CIZ99",
   CellID->15918]},
 "CR91"->{
  Cell[6688, 243, 257, 8, 70, "Reference",
   CellTags->"CR91",
   CellID->13316]},
 "CH94"->{
  Cell[6948, 253, 250, 8, 70, "Reference",
   CellTags->"CH94",
   CellID->6996]},
 "CH96"->{
  Cell[7201, 263, 247, 8, 70, "Reference",
   CellTags->"CH96",
   CellID->25889]},
 "C87"->{
  Cell[7451, 273, 230, 8, 70, "Reference",
   CellTags->"C87",
   CellID->14833]},
 "DP80"->{
  Cell[7684, 283, 237, 8, 70, "Reference",
   CellTags->"DP80",
   CellID->20618]},
 "DL01"->{
  Cell[7924, 293, 267, 8, 70, "Reference",
   CellTags->"DL01",
   CellID->2703]},
 "D83"->{
  Cell[8194, 303, 224, 8, 70, "Reference",
   CellTags->"D83",
   CellID->27711]},
 "D85"->{
  Cell[8421, 313, 245, 8, 70, "Reference",
   CellTags->"D85",
   CellID->15460]},
 "DN87"->{
  Cell[8669, 323, 270, 6, 70, "Reference",
   CellTags->"DN87",
   CellID->16135]},
 "DHZ87"->{
  Cell[8942, 331, 268, 8, 70, "Reference",
   CellTags->"DHZ87",
   CellID->9690]},
 "DRV94"->{
  Cell[9213, 341, 292, 9, 70, "Reference",
   CellTags->"DRV94",
   CellID->3420]},
 "DV99"->{
  Cell[9508, 352, 256, 8, 70, "Reference",
   CellTags->"DV99",
   CellID->2646]},
 "DLP98a"->{
  Cell[9767, 362, 280, 8, 70, "Reference",
   CellTags->"DLP98a",
   CellID->8860]},
 "DLP98b"->{
  Cell[10050, 372, 299, 9, 70, "Reference",
   CellTags->"DLP98b",
   CellID->28445]},
 "ET92"->{
  Cell[10352, 383, 262, 8, 70, "Reference",
   CellTags->"ET92",
   CellID->16590]},
 "F69"->{
  Cell[10617, 393, 331, 9, 70, "Reference",
   CellTags->"F69",
   CellID->145]},
 "FR90"->{
  Cell[10951, 404, 218, 8, 70, "Reference",
   CellTags->"FR90",
   CellID->21370]},
 "F92"->{
  Cell[11172, 414, 481, 18, 70, "Reference",
   CellTags->"F92",
   CellID->21013]},
 "F96"->{
  Cell[11656, 434, 258, 9, 70, "Reference",
   CellTags->"F96",
   CellID->22110],
  Cell[12314, 461, 295, 9, 70, "Reference",
   CellTags->"F96",
   CellID->26897022]},
 "F98"->{
  Cell[11917, 445, 394, 14, 70, "Reference",
   CellTags->"F98",
   CellID->9836]},
 "G51"->{
  Cell[12612, 472, 296, 9, 70, "Reference",
   CellTags->"G51",
   CellID->10068]},
 "G65"->{
  Cell[12911, 483, 237, 8, 70, "Reference",
   CellTags->"G65",
   CellID->6906]},
 "G\[CapitalOSlash]84"->{
  Cell[13151, 493, 301, 9, 70, "Reference",
   CellTags->"G\[CapitalOSlash]84",
   CellID->12707]},
 "G91"->{
  Cell[13455, 504, 260, 8, 70, "Reference",
   CellTags->"G91",
   CellID->26956]},
 "G94"->{
  Cell[13718, 514, 259, 8, 70, "Reference",
   CellTags->"G94",
   CellID->7701]},
 "GMW81"->{
  Cell[13980, 524, 211, 7, 70, "Reference",
   CellTags->"GMW81",
   CellID->16479]},
 "GDC91"->{
  Cell[14194, 533, 271, 8, 70, "Reference",
   CellTags->"GDC91",
   CellID->23494]},
 "GSB87"->{
  Cell[14468, 543, 280, 9, 70, "Reference",
   CellTags->"GSB87",
   CellID->30254]},
 "GVL96"->{
  Cell[14751, 554, 233, 7, 70, "Reference",
   CellTags->"GVL96",
   CellID->18126]},
 "H94"->{
  Cell[14987, 563, 251, 8, 70, "Reference",
   CellTags->"H94",
   CellID->1113]},
 "H97"->{
  Cell[15241, 573, 228, 8, 70, "Reference",
   CellTags->"H97",
   CellID->20646],
  Cell[17855, 672, 200, 7, 70, "Reference",
   CellTags->"H97",
   CellID->26130]},
 "H00"->{
  Cell[15472, 583, 232, 8, 70, "Reference",
   CellTags->"H00",
   CellID->25443]},
 "HL97"->{
  Cell[15707, 593, 299, 8, 70, "Reference",
   CellTags->"HL97",
   CellID->28914]},
 "HL88a"->{
  Cell[16009, 603, 233, 8, 70, "Reference",
   CellTags->"HL88a",
   CellID->12515]},
 "HL88b"->{
  Cell[16245, 613, 250, 6, 70, "Reference",
   CellTags->"HL88b",
   CellID->18787]},
 "HO90"->{
  Cell[16498, 621, 223, 8, 70, "Reference",
   CellTags->"HO90",
   CellID->90]},
 "HW96"->{
  Cell[16724, 631, 285, 10, 70, "Reference",
   CellTags->"HW96",
   CellID->32197]},
 "HW99"->{
  Cell[17012, 643, 244, 8, 70, "Reference",
   CellTags->"HW99",
   CellID->29569]},
 "HLW02"->{
  Cell[17259, 653, 317, 8, 70, "Reference",
   CellTags->"HLW02",
   CellID->2433]},
 "HNW93"->{
  Cell[17579, 663, 273, 7, 70, "Reference",
   CellTags->"HNW93",
   CellID->24148]},
 "H89"->{
  Cell[18058, 681, 248, 6, 70, "Reference",
   CellTags->"H89",
   CellID->7204]},
 "H96"->{
  Cell[18309, 689, 206, 7, 70, "Reference",
   CellTags->"H96",
   CellID->12862]},
 "H83"->{
  Cell[18518, 698, 238, 6, 70, "Reference",
   CellTags->"H83",
   CellID->18460]},
 "HT99"->{
  Cell[18759, 706, 376, 11, 70, "Reference",
   CellTags->"HT99",
   CellID->17230]},
 "KL97"->{
  Cell[19138, 719, 293, 9, 70, "Reference",
   CellTags->"KL97",
   CellID->24611]},
 "K65"->{
  Cell[19434, 730, 165, 5, 70, "Reference",
   CellTags->"K65",
   CellID->4309]},
 "K93"->{
  Cell[19602, 737, 192, 7, 70, "Reference",
   CellTags->"K93",
   CellID->4568]},
 "L87"->{
  Cell[19797, 746, 216, 7, 70, "Reference",
   CellTags->"L87",
   CellID->7030]},
 "LAPACK99"->{
  Cell[20016, 755, 329, 9, 70, "Reference",
   CellTags->"LAPACK99",
   CellID->18138]},
 "M68"->{
  Cell[20348, 766, 217, 5, 70, "Reference",
   CellTags->"M68",
   CellID->24932]},
 "MR99"->{
  Cell[20568, 773, 270, 8, 70, "Reference",
   CellTags->"MR99",
   CellID->7001]},
 "M93"->{
  Cell[20841, 783, 236, 8, 70, "Reference",
   CellTags->"M93",
   CellID->29102]},
 "M95a"->{
  Cell[21080, 793, 280, 9, 70, "Reference",
   CellTags->"M95a",
   CellID->16191]},
 "M95b"->{
  Cell[21363, 804, 222, 8, 70, "Reference",
   CellTags->"M95b",
   CellID->3406]},
 "M01"->{
  Cell[21588, 814, 225, 8, 70, "Reference",
   CellTags->"M01",
   CellID->17804]},
 "MA92"->{
  Cell[21816, 824, 226, 8, 70, "Reference",
   CellTags->"MA92",
   CellID->8579]},
 "MQ02"->{
  Cell[22045, 834, 226, 10, 70, "Reference",
   CellTags->"MQ02",
   CellID->31673]},
 "MG80"->{
  Cell[22274, 846, 251, 7, 70, "Reference",
   CellTags->"MG80",
   CellID->28210]},
 "M65a"->{
  Cell[22528, 855, 216, 8, 70, "Reference",
   CellTags->"M65a",
   CellID->28965]},
 "M65b"->{
  Cell[22747, 865, 194, 7, 70, "Reference",
   CellTags->"M65b",
   CellID->37]},
 "M97"->{
  Cell[22944, 874, 235, 8, 70, "Reference",
   CellTags->"M97",
   CellID->22219]},
 "MS99"->{
  Cell[23182, 884, 291, 9, 70, "Reference",
   CellTags->"MS99",
   CellID->9818]},
 "M04"->{
  Cell[23476, 895, 190, 7, 70, "Reference",
   CellTags->"M04",
   CellID->25049]},
 "Na79"->{
  Cell[23669, 904, 223, 7, 70, "Reference",
   CellTags->"Na79",
   CellID->712]},
 "OS92"->{
  Cell[23895, 913, 239, 8, 70, "Reference",
   CellTags->"OS92",
   CellID->28646]},
 "O95"->{
  Cell[24137, 923, 236, 6, 70, "Reference",
   CellTags->"O95",
   CellID->6718]},
 "O98"->{
  Cell[24376, 931, 242, 6, 70, "Reference",
   CellTags->"O98",
   CellID->25038]},
 "OS00"->{
  Cell[24621, 939, 245, 8, 70, "Reference",
   CellTags->"OS00",
   CellID->9289]},
 "P83"->{
  Cell[24869, 949, 290, 9, 70, "Reference",
   CellTags->"P83",
   CellID->2690]},
 "QSS00"->{
  Cell[25162, 960, 217, 7, 70, "Reference",
   CellTags->"QSS00",
   CellID->9033]},
 "QV94"->{
  Cell[25382, 969, 238, 7, 70, "Reference",
   CellTags->"QV94",
   CellID->14672]},
 "QT90"->{
  Cell[25623, 978, 245, 8, 70, "Reference",
   CellTags->"QT90",
   CellID->19989]},
 "R93"->{
  Cell[25871, 988, 213, 5, 70, "Reference",
   CellTags->"R93",
   CellID->25453]},
 "R99"->{
  Cell[26087, 995, 225, 8, 70, "Reference",
   CellTags->"R99",
   CellID->24544]},
 "R98"->{
  Cell[26315, 1005, 451, 15, 70, "Reference",
   CellTags->"R98",
   CellID->20165]},
 "RM57"->{
  Cell[26769, 1022, 274, 8, 70, "Reference",
   CellTags->"RM57",
   CellID->18503]},
 "R87"->{
  Cell[27046, 1032, 209, 5, 70, "Reference",
   CellTags->"R87",
   CellID->28770]},
 "SC94"->{
  Cell[27258, 1039, 313, 10, 70, "Reference",
   CellTags->"SC94",
   CellID->17569]},
 "S91"->{
  Cell[27574, 1051, 204, 9, 70, "Reference",
   CellTags->"S91",
   CellID->739]},
 "S86"->{
  Cell[27781, 1062, 185, 5, 70, "Reference",
   CellTags->"S86",
   CellID->29968]},
 "S87"->{
  Cell[27969, 1069, 232, 8, 70, "Reference",
   CellTags->"S87",
   CellID->15837]},
 "S94"->{
  Cell[28204, 1079, 223, 7, 70, "Reference",
   CellTags->"S94",
   CellID->21224]},
 "SB83"->{
  Cell[28430, 1088, 230, 8, 70, "Reference",
   CellTags->"SB83",
   CellID->7456]},
 "SG75"->{
  Cell[28663, 1098, 237, 7, 70, "Reference",
   CellTags->"SG75",
   CellID->23388]},
 "SGT03"->{
  Cell[28903, 1107, 235, 7, 70, "Reference",
   CellTags->"SGT03",
   CellID->24366]},
 "SBB83"->{
  Cell[29141, 1116, 247, 8, 70, "Reference",
   CellTags->"SBB83",
   CellID->6296]},
 "SS02"->{
  Cell[29391, 1126, 401, 10, 70, "Reference",
   CellTags->"SS02",
   CellID->23658]},
 "SS04"->{
  Cell[29795, 1138, 410, 10, 70, "Reference",
   CellTags->"SS04",
   CellID->9420]},
 "SS05"->{
  Cell[30208, 1150, 286, 8, 70, "Reference",
   CellTags->"SS05",
   CellID->17586]},
 "SS06"->{
  Cell[30497, 1160, 382, 10, 70, "Reference",
   CellTags->"SS06",
   CellID->146830885]},
 "S84"->{
  Cell[30882, 1172, 230, 6, 70, "Reference",
   CellTags->"S84",
   CellID->23832]},
 "S68"->{
  Cell[31115, 1180, 211, 8, 70, "Reference",
   CellTags->"S68",
   CellID->25]},
 "S70"->{
  Cell[31329, 1190, 239, 8, 70, "Reference",
   CellTags->"S70",
   CellID->29276]},
 "S90"->{
  Cell[31571, 1200, 285, 9, 70, "Reference",
   CellTags->"S90",
   CellID->3309]},
 "T59"->{
  Cell[31859, 1211, 168, 5, 70, "Reference",
   CellTags->"T59",
   CellID->8091]},
 "V78"->{
  Cell[32030, 1218, 252, 8, 70, "Reference",
   CellTags->"V78",
   CellID->23842]},
 "V79"->{
  Cell[32285, 1228, 196, 5, 70, "Reference",
   CellTags->"V79",
   CellID->11721]},
 "W76"->{
  Cell[32484, 1235, 196, 7, 70, "Reference",
   CellTags->"W76",
   CellID->8787]},
 "WH91"->{
  Cell[32683, 1244, 219, 8, 70, "Reference",
   CellTags->"WH91",
   CellID->19109]},
 "Y90"->{
  Cell[32905, 1254, 221, 8, 70, "Reference",
   CellTags->"Y90",
   CellID->21389]},
 "Z98"->{
  Cell[33129, 1264, 171, 5, 70, "Reference",
   CellTags->"Z98",
   CellID->14383]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:1", 35630, 1335},
 {"AP91", 35719, 1339},
 {"AP98", 35814, 1343},
 {"ATALS00", 35911, 1347},
 {"BD83", 36009, 1351},
 {"BG94", 36103, 1355},
 {"BZ65", 36196, 1359},
 {"BM02", 36290, 1363},
 {"BCR99a", 36388, 1367},
 {"BCR99b", 36487, 1371},
 {"BS89a", 36584, 1375},
 {"BS89b", 36680, 1379},
 {"BGS93", 36776, 1383},
 {"BCP89", 36872, 1387},
 {"BHP94", 36969, 1391},
 {"BHP98", 37066, 1395},
 {"B87", 37161, 1399},
 {"BS64", 37253, 1403},
 {"CIZ97", 37349, 1407},
 {"CIZ99", 37446, 1411},
 {"CR91", 37542, 1415},
 {"CH94", 37637, 1419},
 {"CH96", 37731, 1423},
 {"C87", 37825, 1427},
 {"DP80", 37919, 1431},
 {"DL01", 38014, 1435},
 {"D83", 38107, 1439},
 {"D85", 38200, 1443},
 {"DN87", 38294, 1447},
 {"DHZ87", 38390, 1451},
 {"DRV94", 38486, 1455},
 {"DV99", 38581, 1459},
 {"DLP98a", 38677, 1463},
 {"DLP98b", 38775, 1467},
 {"ET92", 38873, 1471},
 {"F69", 38968, 1475},
 {"FR90", 39061, 1479},
 {"F92", 39156, 1483},
 {"F96", 39251, 1487},
 {"F98", 39431, 1494},
 {"G51", 39525, 1498},
 {"G65", 39619, 1502},
 {"G\[CapitalOSlash]84", 39728, 1506},
 {"G91", 39838, 1510},
 {"G94", 39932, 1514},
 {"GMW81", 40027, 1518},
 {"GDC91", 40125, 1522},
 {"GSB87", 40223, 1526},
 {"GVL96", 40321, 1530},
 {"H94", 40417, 1534},
 {"H97", 40510, 1538},
 {"H00", 40687, 1545},
 {"HL97", 40782, 1549},
 {"HL88a", 40879, 1553},
 {"HL88b", 40977, 1557},
 {"HO90", 41074, 1561},
 {"HW96", 41167, 1565},
 {"HW99", 41264, 1569},
 {"HLW02", 41361, 1573},
 {"HNW93", 41458, 1577},
 {"H89", 41554, 1581},
 {"H96", 41647, 1585},
 {"H83", 41741, 1589},
 {"HT99", 41836, 1593},
 {"KL97", 41933, 1597},
 {"K65", 42028, 1601},
 {"K93", 42121, 1605},
 {"L87", 42214, 1609},
 {"LAPACK99", 42312, 1613},
 {"M68", 42411, 1617},
 {"MR99", 42506, 1621},
 {"M93", 42600, 1625},
 {"M95a", 42695, 1629},
 {"M95b", 42791, 1633},
 {"M01", 42885, 1637},
 {"MA92", 42980, 1641},
 {"MQ02", 43075, 1645},
 {"MG80", 43172, 1649},
 {"M65a", 43268, 1653},
 {"M65b", 43364, 1657},
 {"M97", 43456, 1661},
 {"MS99", 43551, 1665},
 {"M04", 43645, 1669},
 {"Na79", 43740, 1673},
 {"OS92", 43834, 1677},
 {"O95", 43929, 1681},
 {"O98", 44022, 1685},
 {"OS00", 44117, 1689},
 {"P83", 44211, 1693},
 {"QSS00", 44306, 1697},
 {"QV94", 44402, 1701},
 {"QT90", 44498, 1705},
 {"R93", 44593, 1709},
 {"R99", 44687, 1713},
 {"R98", 44781, 1717},
 {"RM57", 44878, 1721},
 {"R87", 44974, 1725},
 {"SC94", 45070, 1729},
 {"S91", 45167, 1733},
 {"S86", 45260, 1737},
 {"S87", 45355, 1741},
 {"S94", 45450, 1745},
 {"SB83", 45546, 1749},
 {"SG75", 45642, 1753},
 {"SGT03", 45740, 1757},
 {"SBB83", 45839, 1761},
 {"SS02", 45936, 1765},
 {"SS04", 46034, 1769},
 {"SS05", 46131, 1773},
 {"SS06", 46228, 1777},
 {"S84", 46329, 1781},
 {"S68", 46424, 1785},
 {"S70", 46516, 1789},
 {"S90", 46611, 1793},
 {"T59", 46705, 1797},
 {"V78", 46799, 1801},
 {"V79", 46894, 1805},
 {"W76", 46989, 1809},
 {"WH91", 47084, 1813},
 {"Y90", 47180, 1817},
 {"Z98", 47275, 1821}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 703, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1328, 44, 134, 4, 70, "Title",
 CellTags->"c:1",
 CellID->12891],
Cell[1465, 50, 281, 10, 70, "Reference",
 CellTags->"AP91",
 CellID->12140],
Cell[1749, 62, 271, 8, 70, "Reference",
 CellTags->"AP98",
 CellID->18232],
Cell[2023, 72, 388, 11, 70, "Reference",
 CellTags->"ATALS00",
 CellID->21834],
Cell[2414, 85, 269, 8, 70, "Reference",
 CellTags->"BD83",
 CellID->25441],
Cell[2686, 95, 324, 9, 70, "Reference",
 CellTags->"BG94",
 CellID->9765],
Cell[3013, 106, 195, 7, 70, "Reference",
 CellTags->"BZ65",
 CellID->5356],
Cell[3211, 115, 294, 10, 70, "Reference",
 CellTags->"BM02",
 CellID->26833],
Cell[3508, 127, 258, 8, 70, "Reference",
 CellTags->"BCR99a",
 CellID->31786],
Cell[3769, 137, 199, 5, 70, "Reference",
 CellTags->"BCR99b",
 CellID->1528],
Cell[3971, 144, 229, 8, 70, "Reference",
 CellTags->"BS89a",
 CellID->2609],
Cell[4203, 154, 226, 6, 70, "Reference",
 CellTags->"BS89b",
 CellID->4363],
Cell[4432, 162, 278, 6, 70, "Reference",
 CellTags->"BGS93",
 CellID->6300],
Cell[4713, 170, 292, 8, 70, "Reference",
 CellTags->"BCP89",
 CellID->27005],
Cell[5008, 180, 305, 9, 70, "Reference",
 CellTags->"BHP94",
 CellID->19530],
Cell[5316, 191, 298, 9, 70, "Reference",
 CellTags->"BHP98",
 CellID->16131],
Cell[5617, 202, 262, 8, 70, "Reference",
 CellTags->"B87",
 CellID->810],
Cell[5882, 212, 297, 9, 70, "Reference",
 CellTags->"BS64",
 CellID->22705],
Cell[6182, 223, 243, 8, 70, "Reference",
 CellTags->"CIZ97",
 CellID->19797],
Cell[6428, 233, 257, 8, 70, "Reference",
 CellTags->"CIZ99",
 CellID->15918],
Cell[6688, 243, 257, 8, 70, "Reference",
 CellTags->"CR91",
 CellID->13316],
Cell[6948, 253, 250, 8, 70, "Reference",
 CellTags->"CH94",
 CellID->6996],
Cell[7201, 263, 247, 8, 70, "Reference",
 CellTags->"CH96",
 CellID->25889],
Cell[7451, 273, 230, 8, 70, "Reference",
 CellTags->"C87",
 CellID->14833],
Cell[7684, 283, 237, 8, 70, "Reference",
 CellTags->"DP80",
 CellID->20618],
Cell[7924, 293, 267, 8, 70, "Reference",
 CellTags->"DL01",
 CellID->2703],
Cell[8194, 303, 224, 8, 70, "Reference",
 CellTags->"D83",
 CellID->27711],
Cell[8421, 313, 245, 8, 70, "Reference",
 CellTags->"D85",
 CellID->15460],
Cell[8669, 323, 270, 6, 70, "Reference",
 CellTags->"DN87",
 CellID->16135],
Cell[8942, 331, 268, 8, 70, "Reference",
 CellTags->"DHZ87",
 CellID->9690],
Cell[9213, 341, 292, 9, 70, "Reference",
 CellTags->"DRV94",
 CellID->3420],
Cell[9508, 352, 256, 8, 70, "Reference",
 CellTags->"DV99",
 CellID->2646],
Cell[9767, 362, 280, 8, 70, "Reference",
 CellTags->"DLP98a",
 CellID->8860],
Cell[10050, 372, 299, 9, 70, "Reference",
 CellTags->"DLP98b",
 CellID->28445],
Cell[10352, 383, 262, 8, 70, "Reference",
 CellTags->"ET92",
 CellID->16590],
Cell[10617, 393, 331, 9, 70, "Reference",
 CellTags->"F69",
 CellID->145],
Cell[10951, 404, 218, 8, 70, "Reference",
 CellTags->"FR90",
 CellID->21370],
Cell[11172, 414, 481, 18, 70, "Reference",
 CellTags->"F92",
 CellID->21013],
Cell[11656, 434, 258, 9, 70, "Reference",
 CellTags->"F96",
 CellID->22110],
Cell[11917, 445, 394, 14, 70, "Reference",
 CellTags->"F98",
 CellID->9836],
Cell[12314, 461, 295, 9, 70, "Reference",
 CellTags->"F96",
 CellID->26897022],
Cell[12612, 472, 296, 9, 70, "Reference",
 CellTags->"G51",
 CellID->10068],
Cell[12911, 483, 237, 8, 70, "Reference",
 CellTags->"G65",
 CellID->6906],
Cell[13151, 493, 301, 9, 70, "Reference",
 CellTags->"G\[CapitalOSlash]84",
 CellID->12707],
Cell[13455, 504, 260, 8, 70, "Reference",
 CellTags->"G91",
 CellID->26956],
Cell[13718, 514, 259, 8, 70, "Reference",
 CellTags->"G94",
 CellID->7701],
Cell[13980, 524, 211, 7, 70, "Reference",
 CellTags->"GMW81",
 CellID->16479],
Cell[14194, 533, 271, 8, 70, "Reference",
 CellTags->"GDC91",
 CellID->23494],
Cell[14468, 543, 280, 9, 70, "Reference",
 CellTags->"GSB87",
 CellID->30254],
Cell[14751, 554, 233, 7, 70, "Reference",
 CellTags->"GVL96",
 CellID->18126],
Cell[14987, 563, 251, 8, 70, "Reference",
 CellTags->"H94",
 CellID->1113],
Cell[15241, 573, 228, 8, 70, "Reference",
 CellTags->"H97",
 CellID->20646],
Cell[15472, 583, 232, 8, 70, "Reference",
 CellTags->"H00",
 CellID->25443],
Cell[15707, 593, 299, 8, 70, "Reference",
 CellTags->"HL97",
 CellID->28914],
Cell[16009, 603, 233, 8, 70, "Reference",
 CellTags->"HL88a",
 CellID->12515],
Cell[16245, 613, 250, 6, 70, "Reference",
 CellTags->"HL88b",
 CellID->18787],
Cell[16498, 621, 223, 8, 70, "Reference",
 CellTags->"HO90",
 CellID->90],
Cell[16724, 631, 285, 10, 70, "Reference",
 CellTags->"HW96",
 CellID->32197],
Cell[17012, 643, 244, 8, 70, "Reference",
 CellTags->"HW99",
 CellID->29569],
Cell[17259, 653, 317, 8, 70, "Reference",
 CellTags->"HLW02",
 CellID->2433],
Cell[17579, 663, 273, 7, 70, "Reference",
 CellTags->"HNW93",
 CellID->24148],
Cell[17855, 672, 200, 7, 70, "Reference",
 CellTags->"H97",
 CellID->26130],
Cell[18058, 681, 248, 6, 70, "Reference",
 CellTags->"H89",
 CellID->7204],
Cell[18309, 689, 206, 7, 70, "Reference",
 CellTags->"H96",
 CellID->12862],
Cell[18518, 698, 238, 6, 70, "Reference",
 CellTags->"H83",
 CellID->18460],
Cell[18759, 706, 376, 11, 70, "Reference",
 CellTags->"HT99",
 CellID->17230],
Cell[19138, 719, 293, 9, 70, "Reference",
 CellTags->"KL97",
 CellID->24611],
Cell[19434, 730, 165, 5, 70, "Reference",
 CellTags->"K65",
 CellID->4309],
Cell[19602, 737, 192, 7, 70, "Reference",
 CellTags->"K93",
 CellID->4568],
Cell[19797, 746, 216, 7, 70, "Reference",
 CellTags->"L87",
 CellID->7030],
Cell[20016, 755, 329, 9, 70, "Reference",
 CellTags->"LAPACK99",
 CellID->18138],
Cell[20348, 766, 217, 5, 70, "Reference",
 CellTags->"M68",
 CellID->24932],
Cell[20568, 773, 270, 8, 70, "Reference",
 CellTags->"MR99",
 CellID->7001],
Cell[20841, 783, 236, 8, 70, "Reference",
 CellTags->"M93",
 CellID->29102],
Cell[21080, 793, 280, 9, 70, "Reference",
 CellTags->"M95a",
 CellID->16191],
Cell[21363, 804, 222, 8, 70, "Reference",
 CellTags->"M95b",
 CellID->3406],
Cell[21588, 814, 225, 8, 70, "Reference",
 CellTags->"M01",
 CellID->17804],
Cell[21816, 824, 226, 8, 70, "Reference",
 CellTags->"MA92",
 CellID->8579],
Cell[22045, 834, 226, 10, 70, "Reference",
 CellTags->"MQ02",
 CellID->31673],
Cell[22274, 846, 251, 7, 70, "Reference",
 CellTags->"MG80",
 CellID->28210],
Cell[22528, 855, 216, 8, 70, "Reference",
 CellTags->"M65a",
 CellID->28965],
Cell[22747, 865, 194, 7, 70, "Reference",
 CellTags->"M65b",
 CellID->37],
Cell[22944, 874, 235, 8, 70, "Reference",
 CellTags->"M97",
 CellID->22219],
Cell[23182, 884, 291, 9, 70, "Reference",
 CellTags->"MS99",
 CellID->9818],
Cell[23476, 895, 190, 7, 70, "Reference",
 CellTags->"M04",
 CellID->25049],
Cell[23669, 904, 223, 7, 70, "Reference",
 CellTags->"Na79",
 CellID->712],
Cell[23895, 913, 239, 8, 70, "Reference",
 CellTags->"OS92",
 CellID->28646],
Cell[24137, 923, 236, 6, 70, "Reference",
 CellTags->"O95",
 CellID->6718],
Cell[24376, 931, 242, 6, 70, "Reference",
 CellTags->"O98",
 CellID->25038],
Cell[24621, 939, 245, 8, 70, "Reference",
 CellTags->"OS00",
 CellID->9289],
Cell[24869, 949, 290, 9, 70, "Reference",
 CellTags->"P83",
 CellID->2690],
Cell[25162, 960, 217, 7, 70, "Reference",
 CellTags->"QSS00",
 CellID->9033],
Cell[25382, 969, 238, 7, 70, "Reference",
 CellTags->"QV94",
 CellID->14672],
Cell[25623, 978, 245, 8, 70, "Reference",
 CellTags->"QT90",
 CellID->19989],
Cell[25871, 988, 213, 5, 70, "Reference",
 CellTags->"R93",
 CellID->25453],
Cell[26087, 995, 225, 8, 70, "Reference",
 CellTags->"R99",
 CellID->24544],
Cell[26315, 1005, 451, 15, 70, "Reference",
 CellTags->"R98",
 CellID->20165],
Cell[26769, 1022, 274, 8, 70, "Reference",
 CellTags->"RM57",
 CellID->18503],
Cell[27046, 1032, 209, 5, 70, "Reference",
 CellTags->"R87",
 CellID->28770],
Cell[27258, 1039, 313, 10, 70, "Reference",
 CellTags->"SC94",
 CellID->17569],
Cell[27574, 1051, 204, 9, 70, "Reference",
 CellTags->"S91",
 CellID->739],
Cell[27781, 1062, 185, 5, 70, "Reference",
 CellTags->"S86",
 CellID->29968],
Cell[27969, 1069, 232, 8, 70, "Reference",
 CellTags->"S87",
 CellID->15837],
Cell[28204, 1079, 223, 7, 70, "Reference",
 CellTags->"S94",
 CellID->21224],
Cell[28430, 1088, 230, 8, 70, "Reference",
 CellTags->"SB83",
 CellID->7456],
Cell[28663, 1098, 237, 7, 70, "Reference",
 CellTags->"SG75",
 CellID->23388],
Cell[28903, 1107, 235, 7, 70, "Reference",
 CellTags->"SGT03",
 CellID->24366],
Cell[29141, 1116, 247, 8, 70, "Reference",
 CellTags->"SBB83",
 CellID->6296],
Cell[29391, 1126, 401, 10, 70, "Reference",
 CellTags->"SS02",
 CellID->23658],
Cell[29795, 1138, 410, 10, 70, "Reference",
 CellTags->"SS04",
 CellID->9420],
Cell[30208, 1150, 286, 8, 70, "Reference",
 CellTags->"SS05",
 CellID->17586],
Cell[30497, 1160, 382, 10, 70, "Reference",
 CellTags->"SS06",
 CellID->146830885],
Cell[30882, 1172, 230, 6, 70, "Reference",
 CellTags->"S84",
 CellID->23832],
Cell[31115, 1180, 211, 8, 70, "Reference",
 CellTags->"S68",
 CellID->25],
Cell[31329, 1190, 239, 8, 70, "Reference",
 CellTags->"S70",
 CellID->29276],
Cell[31571, 1200, 285, 9, 70, "Reference",
 CellTags->"S90",
 CellID->3309],
Cell[31859, 1211, 168, 5, 70, "Reference",
 CellTags->"T59",
 CellID->8091],
Cell[32030, 1218, 252, 8, 70, "Reference",
 CellTags->"V78",
 CellID->23842],
Cell[32285, 1228, 196, 5, 70, "Reference",
 CellTags->"V79",
 CellID->11721],
Cell[32484, 1235, 196, 7, 70, "Reference",
 CellTags->"W76",
 CellID->8787],
Cell[32683, 1244, 219, 8, 70, "Reference",
 CellTags->"WH91",
 CellID->19109],
Cell[32905, 1254, 221, 8, 70, "Reference",
 CellTags->"Y90",
 CellID->21389],
Cell[33129, 1264, 171, 5, 70, "Reference",
 CellTags->"Z98",
 CellID->14383],
Cell[CellGroupData[{
Cell[33325, 1273, 72, 1, 70, "RelatedTutorialsSection",
 CellID->668287648],
Cell[33400, 1276, 326, 9, 70, "RelatedTutorials",
 CellID->604721514]
}, Open  ]]
}, Open  ]],
Cell[33753, 1289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

