(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2391578,     191271]
NotebookOptionsPosition[   2368152,     190504]
NotebookOutlinePosition[   2373042,     190643]
CellTagsIndexPosition[   2372492,     190624]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymplecticPartitionedRungeKutta Method for NDSolve", "Title",
 CellTags->"c:1",
 CellID->2010207326],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->"s:1",
 CellID->990230510],

Cell["\<\
When numerically solving Hamiltonian dynamical systems it is advantageous if \
the numerical method yields a symplectic map.\
\>", "Text",
 CellID->1130610062],

Cell["\<\
The phase space of a Hamiltonian system is a symplectic manifold on which \
there exists a natural symplectic structure in the canonically conjugate \
coordinates.\
\>", "BulletedText",
 CellID->2032103047],

Cell["\<\
The time evolution of a Hamiltonian system is such that the Poincar\[EAcute] \
integral invariants associated with the symplectic structure are preserved.\
\>", "BulletedText",
 CellID->2059659804],

Cell[CellGroupData[{

Cell["\<\
A symplectic integrator computes exactly, assuming infinite precision \
arithmetic, the evolution of a nearby Hamiltonian, whose phase space \
structure is close to that of the original system.\
\>", "BulletedText",
 CellID->1134904799],

Cell["\<\
If the Hamiltonian can be written in separable form, H(p, q) = T(p) + V(q), \
there exists an efficient class of explicit symplectic numerical integration \
methods.\
\>", "Text",
 CellID->891620883],

Cell[TextData[{
 "An important property of symplectic numerical methods when applied to \
Hamiltonian systems is that a nearby Hamiltonian is approximately conserved \
for exponentially long times (see [",
 ButtonBox["BG94",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#9765"],
 "] , [",
 ButtonBox["HL97",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#28914"],
 "]",
 " ",
 "and [",
 ButtonBox["R99",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#24544"],
 "])."
}], "Text",
 CellID->1924130317]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hamiltonian systems", "Subsection",
 CellID->900729228],

Cell["Consider a differential equation", "Text",
 CellID->743770253],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["dy", "dt"], " ", "=", " ", 
    RowBox[{"F", "(", 
     RowBox[{"t", ",", " ", "y"}], ")"}]}], ",", " ", 
   RowBox[{
    RowBox[{"y", "(", 
     SubscriptBox["t", "0"], ")"}], " ", "=", " ", 
    RowBox[{
     SubscriptBox["y", "0"], "."}]}]}], TraditionalForm]], "NumberedEquation",\

 CellTags->"ODEEquation",
 CellID->1159293607],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]]],
 "-degree of freedom Hamiltonian system is a particular instance of (",
 
 CounterBox["NumberedEquation", "ODEEquation"],
 ") with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["p", "d"], ",", 
       RowBox[{
        SubscriptBox["q", "1"], "\[Ellipsis]"}], ",", 
       SubscriptBox["q", "d"]}], ")"}], "T"]}], TraditionalForm]]],
 ", where"
}], "Text",
 CellID->1750155313],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["dy", "dt"], " ", "=", " ", 
   RowBox[{
    SuperscriptBox["J", 
     RowBox[{"-", "1"}]], 
    RowBox[{
     RowBox[{"\[Del]", " ", "H"}], "."}]}]}], 
  TraditionalForm]], "NumberedEquation",
 CellTags->"HamiltonianODEEquation",
 CellID->1067077961],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox["\[Del]", TraditionalForm]]],
 " represents the gradient operator:"
}], "Text",
 CellID->1128830108],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Del]", " ", 
   RowBox[{"=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[PartialD]", 
        RowBox[{"/", 
         RowBox[{"\[PartialD]", 
          SubscriptBox["p", "1"]}]}]}], ",", "\[Ellipsis]", ",", 
       RowBox[{"\[PartialD]", 
        RowBox[{"/", 
         RowBox[{"\[PartialD]", 
          SubscriptBox["p", "d"]}]}]}], ",", 
       RowBox[{"\[PartialD]", 
        RowBox[{"/", 
         RowBox[{"\[PartialD]", 
          SubscriptBox["q", "1"]}]}]}], ",", 
       RowBox[{"\[Ellipsis]", 
        RowBox[{"\[PartialD]", 
         RowBox[{"/", 
          RowBox[{"\[PartialD]", 
           SubscriptBox["q", "d"]}]}]}]}]}], ")"}], "T"]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->1795247325],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox["J", TraditionalForm]]],
 " is the skew symmetric matrix:"
}], "Text",
 CellID->1676446952],

Cell[BoxData[
 FormBox[
  RowBox[{"J", " ", "=", 
   RowBox[{"(", GridBox[{
      {"0", "I"},
      {
       RowBox[{"-", "I"}], "0"}
     }], ")"}]}], TraditionalForm]], "DisplayMath",
 CellID->1351389060],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]]],
 " are the identity and zero ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[Cross]", "d"}], TraditionalForm]]],
 " matrices."
}], "Text",
 CellID->194400514],

Cell[TextData[{
 "The components of ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]]],
 " are often referred to as position or coordinate variables and the \
components of ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 " as the momenta."
}], "Text",
 CellID->734303601],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]]],
 " is autonomous, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"dH", "/", "dt"}], " ", "=", " ", "0"}], TraditionalForm]]],
 ". Then ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]]],
 " is a conserved quantity that remains constant along solutions of the \
system. In applications, this usually corresponds to conservation of energy."
}], "Text",
 CellID->238708315],

Cell[TextData[{
 "A numerical method applied to a Hamiltonian system (",
 
 CounterBox["NumberedEquation", "HamiltonianODEEquation"],
 ") is said to be symplectic if it produces a symplectic map. That is, let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["p", "*"], ",", 
      SuperscriptBox["q", "*"]}], ")"}], " ", "=", " ", 
    RowBox[{"\[Psi]", "(", 
     RowBox[{"p", ",", "q"}], ")"}]}], TraditionalForm]]],
 " be a ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["C", "1"], TraditionalForm]]],
 "transformation defined in a domain \[CapitalOmega].:"
}], "Text",
 CellID->545427242],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ForAll]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"p", ",", "q"}], ")"}], "\[Element]", "\[CapitalOmega]"}]}], 
   " ", ",", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Psi]", "\[Prime]T"], "J", " ", 
     SuperscriptBox["\[Psi]", "\[Prime]"]}], "=", " ", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[PartialD]", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "*"], ",", 
           SuperscriptBox["q", "*"]}], ")"}], "T"]}], 
       RowBox[{"\[PartialD]", 
        RowBox[{"(", 
         RowBox[{"p", ",", "q"}], ")"}]}]], "J", 
      FractionBox[
       RowBox[{"\[PartialD]", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "*"], ",", 
          SuperscriptBox["q", "*"]}], ")"}]}], 
       RowBox[{"\[PartialD]", 
        RowBox[{"(", 
         RowBox[{"p", ",", "q"}], ")"}]}]]}], "=", "J", " "}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->771727562],

Cell["where the Jacobian of the transformation is:", "Text",
 CellID->2116291431],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Psi]", "\[Prime]"], "=", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["p", "*"], ",", 
        SuperscriptBox["q", "*"]}], ")"}]}], 
     RowBox[{"\[PartialD]", 
      RowBox[{"(", 
       RowBox[{"p", ",", "q"}], ")"}]}]], "=", 
    RowBox[{"(", GridBox[{
       {
        FractionBox[
         RowBox[{"\[PartialD]", 
          SuperscriptBox["p", "*"]}], 
         RowBox[{"\[PartialD]", "p"}]], 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SuperscriptBox["p", "*"]}], 
         RowBox[{"\[PartialD]", "q"}]]},
       {
        FractionBox[
         RowBox[{"\[PartialD]", 
          SuperscriptBox["q", "*"]}], 
         RowBox[{"\[PartialD]", "p"}]], 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SuperscriptBox["q", "*"]}], 
         RowBox[{"\[PartialD]", "q"}]]}
      }], ")"}], " "}]}], TraditionalForm]], "DisplayMath",
 CellID->1998974521],

Cell["\<\
The flow of a Hamiltonian system is depicted below together with the \
projection onto the planes formed by canonically conjugate coordinate and \
momenta pairs. The sum of the oriented areas remains constant as the flow \
evolves in time.\
\>", "Text",
 CellID->1379439382],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00195608 0.0238095 0.00192467 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.4 0 0 1 k
1 Mabswid
[ ] 0 Mabsdash
.55992 .50315 m
.55964 .50883 L
.55882 .51435 L
.55749 .51968 L
.55566 .52478 L
.55067 .53422 L
.54405 .54245 L
.53603 .54923 L
.52682 .55436 L
.52184 .55622 L
.51664 .55759 L
.51126 .55844 L
.50572 .55872 L
.50018 .55844 L
.49479 .55759 L
.4896 .55622 L
.48462 .55436 L
.47541 .54923 L
.46739 .54245 L
.46077 .53422 L
.45577 .52478 L
.45395 .51968 L
.45262 .51435 L
.45179 .50884 L
.45151 .50315 L
.45179 .49747 L
.45262 .49195 L
.45395 .48663 L
.45577 .48152 L
.46077 .47208 L
.46739 .46386 L
.47541 .45707 L
.48462 .45195 L
.4896 .45008 L
.49479 .44871 L
.50018 .44787 L
.50572 .44758 L
.51126 .44787 L
.51664 .44871 L
.52184 .45008 L
.52682 .45195 L
.53603 .45707 L
.54405 .46386 L
.55067 .47208 L
.55566 .48152 L
.55749 .48663 L
.55882 .49195 L
.55964 .49747 L
.55992 .50315 L
.55992 .50315 L
Mistroke
Mfstroke
.45146 .50378 m
.45196 .52345 L
.45345 .54286 L
.4559 .56199 L
.45929 .58082 L
.4636 .59932 L
.4688 .61746 L
.47486 .63522 L
.48177 .65258 L
.48949 .66951 L
.49801 .686 L
.5073 .70201 L
.51733 .71752 L
.52808 .73251 L
.53953 .74695 L
.55166 .76082 L
.56443 .77409 L
.57782 .78675 L
.59182 .79877 L
.60639 .81012 L
.62151 .82077 L
.63716 .83072 L
.65331 .83992 L
.66994 .84837 L
.68703 .85602 L
.70454 .86287 L
.72246 .86888 L
.74077 .87403 L
.75943 .8783 L
.77842 .88166 L
.79772 .88409 L
.81731 .88557 L
.83716 .88606 L
s
.55992 .50417 m
.56028 .51821 L
.56136 .53207 L
.56312 .54573 L
.56556 .55917 L
.56866 .57237 L
.57239 .58532 L
.57675 .598 L
.58172 .6104 L
.58728 .62249 L
.5934 .63425 L
.60008 .64568 L
.60729 .65676 L
.61503 .66746 L
.62326 .67777 L
.63198 .68767 L
.64116 .69715 L
.6508 .70618 L
.66086 .71476 L
.67134 .72286 L
.68221 .73047 L
.69347 .73757 L
.70508 .74414 L
.71704 .75017 L
.72933 .75563 L
.74193 .76052 L
.75481 .76481 L
.76798 .76849 L
.78139 .77154 L
.79505 .77394 L
.80894 .77567 L
.82302 .77672 L
.83729 .77708 L
s
.89261 .83151 m
.89232 .83708 L
.89148 .8425 L
.89012 .84773 L
.88825 .85274 L
.88314 .86201 L
.87637 .87009 L
.86816 .87675 L
.85874 .88178 L
.85365 .88361 L
.84834 .88496 L
.84283 .88578 L
.83716 .88606 L
s
.89261 .83151 m
.89232 .82593 L
.89148 .82051 L
.89012 .81528 L
.88825 .81027 L
.88314 .801 L
.87637 .79293 L
.86816 .78627 L
.85874 .78124 L
.85365 .7794 L
.84834 .77806 L
.84283 .77723 L
.83716 .77695 L
s
[ 5 ] 0 Mabsdash
.57616 .70851 m
.57184 .71263 L
.56809 .71703 L
.56492 .72165 L
.56233 .72646 L
.56031 .73143 L
.55887 .73652 L
.55801 .74168 L
.55772 .74688 L
.558 .75209 L
.55887 .75725 L
.56031 .76234 L
.56233 .76731 L
.56492 .77212 L
.56809 .77675 L
.57184 .78114 L
.57616 .78526 L
s
[ ] 0 Mabsdash
.65513 .78849 m
.65885 .78429 L
.66207 .77981 L
.6648 .77509 L
.66703 .77018 L
.67001 .75992 L
.671 .74934 L
.67001 .73877 L
.66703 .72851 L
.6648 .7236 L
.66208 .71888 L
.65885 .7144 L
.65513 .7102 L
s
[ 5 ] 0 Mabsdash
.572 .71236 m
.57655 .70783 L
.58138 .7039 L
.58648 .70057 L
.59179 .69785 L
.59727 .69573 L
.60288 .69422 L
.60857 .69332 L
.6143 .69302 L
.62003 .69332 L
.62573 .69422 L
.63133 .69573 L
.63681 .69785 L
.64212 .70057 L
.64722 .7039 L
.65206 .70783 L
.6566 .71236 L
s
[ ] 0 Mabsdash
.65712 .78547 m
.6528 .78986 L
.64819 .79368 L
.64335 .7969 L
.63829 .79954 L
.63308 .80159 L
.62775 .80306 L
.62234 .80394 L
.61688 .80423 L
.61143 .80394 L
.60602 .80306 L
.60068 .80159 L
.59547 .79954 L
.59042 .7969 L
.58557 .79368 L
.58097 .78986 L
.57665 .78547 L
s
.65068 .79271 m
.647 .78955 L
.66356 .77822 L
.65437 .79588 L
.65068 .79271 L
F
.30104 .33916 m
.30104 .96657 L
s
.30104 .95694 m
.30594 .95694 L
.30104 .97619 L
.29615 .95694 L
.30104 .95694 L
F
.30104 .33916 m
.05153 .23005 L
s
.06047 .23396 m
.05848 .23835 L
.0426 .22614 L
.06246 .22956 L
.06047 .23396 L
F
.30104 .33916 m
.96641 .33916 L
s
.95663 .33916 m
.95663 .33435 L
.97619 .33916 L
.95663 .34398 L
.95663 .33916 L
F
.30104 .33916 m
.16243 .06638 L
s
.1668 .07499 m
.16243 .07714 L
.15805 .05777 L
.17117 .07283 L
.1668 .07499 L
F
.10698 .74846 m
.10754 .75963 L
.10916 .77003 L
.11171 .77943 L
.1151 .78763 L
.1192 .7944 L
.12391 .79951 L
.12912 .80273 L
.1347 .80386 L
.14029 .80273 L
.14549 .79951 L
.1502 .7944 L
.15431 .78763 L
.15769 .77944 L
.16025 .77003 L
.16186 .75963 L
.16243 .74846 L
.16186 .7373 L
.16025 .7269 L
.15769 .71749 L
.15431 .70929 L
.1502 .70253 L
.1455 .69742 L
.14029 .69419 L
.1347 .69307 L
.12912 .69419 L
.12391 .69742 L
.1192 .70253 L
.1151 .70929 L
.11171 .71749 L
.10916 .7269 L
.10754 .7373 L
.10698 .74846 L
.10698 .74846 L
s
.67091 .17417 m
.66977 .17969 L
.66649 .18484 L
.6613 .18949 L
.65442 .19355 L
.64609 .19689 L
.63652 .19942 L
.62595 .20101 L
.61461 .20157 L
.60326 .20101 L
.59269 .19942 L
.58313 .19689 L
.57479 .19355 L
.56792 .18949 L
.56273 .18484 L
.55945 .17969 L
.5583 .17417 L
.55945 .16865 L
.56273 .16351 L
.56792 .15885 L
.57479 .1548 L
.58313 .15145 L
.59269 .14893 L
.60326 .14733 L
.61461 .14677 L
.62595 .14733 L
.63652 .14893 L
.64609 .15145 L
.65442 .1548 L
.6613 .15885 L
.66649 .16351 L
.66977 .16865 L
.67091 .17417 L
.67091 .17417 L
s
[ 5 ] 0 Mabsdash
.55806 .74738 m
.55806 .17453 L
s
.67091 .74714 m
.67091 .17429 L
s
[ ] 0 Mabsdash
.60964 .14704 m
.6173 .14704 L
s
.60752 .14704 m
.60752 .14223 L
.62708 .14704 L
.60752 .15186 L
.60752 .14704 L
F
[ 5 ] 0 Mabsdash
.1347 .80386 m
.61987 .80386 L
s
.1347 .69306 m
.61987 .69306 L
s
[ ] 0 Mabsdash
.10719 .75206 m
.10719 .74556 L
s
.10719 .75519 m
.1023 .75519 L
.10719 .73594 L
.11208 .75519 L
.10719 .75519 L
F
gsave
.23898 .95728 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.6875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
74.312 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.04728 .2567 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.6875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(q) show
69.000 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
74.312 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.18225 .06615 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.6875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(q) show
69.000 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
74.312 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.9549 .36063 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.6875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
74.312 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.66932 .78406 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.0625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C) show
71.000 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
74.375 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.11183 .72632 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
71.625 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
76.938 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70355 .18452 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 36.4375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math2
%%IncludeFont: Math2
/Math2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 23.688 moveto
(\\250) show
76.000 21.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
82.000 23.062 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
87.312 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
( ) show
89.562 21.188 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(dq) show
101.562 24.812 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
106.875 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.6478 .17586 m
.69572 .2028 L
s
.65629 .18063 m
.65387 .18481 L
.63931 .17108 L
.65872 .17646 L
.65629 .18063 L
F
gsave
.59107 .15854 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
71.625 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
76.938 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.03359 .82255 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 36.4375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math2
%%IncludeFont: Math2
/Math2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 23.688 moveto
(\\250) show
76.000 21.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
82.000 23.062 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
87.312 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
( ) show
89.562 21.188 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(dq) show
101.562 24.812 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
106.875 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08836 .82062 m
.13726 .77443 L
s
.13021 .7811 m
.12682 .77763 L
.14432 .76777 L
.13359 .78457 L
.13021 .7811 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 288},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[71]:=",
 CellID->709872441,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 287}, {287, 0}} -> {-12.1746, -12.3733, 1.78129, \
1.81037}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partitioned Runge-Kutta methods", "Subsection",
 CellID->795760461],

Cell[TextData[{
 "It is sometimes possible to integrate certain components of (",
 
 CounterBox["NumberedEquation", "ODEEquation"],
 ") using one Runge-Kutta method and other components using a different \
Runge-Kutta method. The overall ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]]],
 " stage scheme is called a Partitioned Runge-Kutta method and the free \
parameters are represented by two Butcher tableaux:"
}], "Text",
 CellID->2121814707],

Cell[BoxData[
 FormBox[
  RowBox[{GridBox[{
     {" ", 
      SubscriptBox["a", "11"], "\[CenterEllipsis]", 
      SubscriptBox["a", 
       RowBox[{"1", "s"}]]},
     {" ", "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
      "\[VerticalEllipsis]"},
     {" ", 
      SubscriptBox["a", "s1"], "\[CenterEllipsis]", 
      SubscriptBox["a", "ss"]},
     {" ", 
      SubscriptBox["b", "1"], "\[CenterEllipsis]", 
      SubscriptBox["b", "s"]}
    },
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, False, False, {True}, False}, "RowsIndexed" -> {}}], "      ",
    GridBox[{
     {" ", 
      SubscriptBox["A", "11"], "\[CenterEllipsis]", 
      SubscriptBox["A", 
       RowBox[{"1", "s"}]]},
     {" ", "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
      "\[VerticalEllipsis]"},
     {" ", 
      SubscriptBox["A", "s1"], "\[CenterEllipsis]", 
      SubscriptBox["A", "ss"]},
     {" ", 
      SubscriptBox["B", "1"], "\[CenterEllipsis]", 
      SubscriptBox["B", "s"]}
    },
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, False, False, {True}, False}, "RowsIndexed" -> {}}]}],
   TraditionalForm]], "NumberedEquation",
 CellTags->"PRKTableaux",
 CellID->299847121]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symplectic partitioned Runge-Kutta methods", "Subsection",
 CellID->1085096924],

Cell["\<\
For general Hamiltonian systems symplectic Runge-Kutta methods are \
necessarily implicit.\
\>", "Text",
 CellID->335821424],

Cell[TextData[{
 "However, for separable Hamiltonians ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"H", "(", 
     RowBox[{"p", ",", " ", "q", ",", " ", "t"}], ")"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"T", "(", "p", ")"}], " ", "+", " ", 
     RowBox[{"V", "(", 
      RowBox[{"q", ",", " ", "t"}], ")"}]}]}], TraditionalForm]]],
 " there exists explicit schemes corresponding to symplectic partitioned \
Runge-Kutta methods."
}], "Text",
 CellID->162570800],

Cell[TextData[{
 "Instead of (",
 
 CounterBox["NumberedEquation", "PRKTableaux"],
 ") the free parameters now take either the form:"
}], "Text",
 CellID->2075327434],

Cell[BoxData[
 FormBox[
  RowBox[{GridBox[{
     {" ", "0", "\[CenterEllipsis]", "0", "0"},
     {" ", 
      SubscriptBox["b", "1"], "0", "\[CenterEllipsis]", 
      "\[VerticalEllipsis]"},
     {" ", "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
      "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
     {" ", 
      SubscriptBox["b", "1"], "\[CenterEllipsis]", 
      SubscriptBox["b", 
       RowBox[{"s", "-", "1"}]], "0"},
     {" ", 
      SubscriptBox["b", "1"], "\[CenterEllipsis]", 
      SubscriptBox["b", 
       RowBox[{"s", "-", "1"}]], 
      SubscriptBox["b", "s"]}
    },
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, False, False, False, {True}, False}, 
      "RowsIndexed" -> {}}], "        ", GridBox[{
     {" ", 
      SubscriptBox["B", "1"], "\[CenterEllipsis]", "0", "0"},
     {" ", 
      SubscriptBox["B", "1"], 
      SubscriptBox["B", "2"], "\[CenterEllipsis]", "\[VerticalEllipsis]"},
     {" ", "\[VerticalEllipsis]", "\[VerticalEllipsis]", 
      "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
     {" ", 
      SubscriptBox["B", "1"], 
      SubscriptBox["B", "2"], "\[CenterEllipsis]", 
      SubscriptBox["B", "s"]},
     {" ", 
      SubscriptBox["B", "1"], 
      SubscriptBox["B", "2"], "\[CenterEllipsis]", 
      SubscriptBox["B", "s"]}
    },
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, False, False, False, {True}, False}, 
      "RowsIndexed" -> {}}], " "}], TraditionalForm]], "NumberedEquation",
 CellTags->"SPRKTableaux1",
 CellID->1466431486],

Cell["or the form:", "Text",
 CellID->47190199],

Cell[BoxData[
 FormBox[
  RowBox[{GridBox[{
     {" ", 
      SubscriptBox["b", "1"], "\[CenterEllipsis]", "0", "0"},
     {" ", 
      SubscriptBox["b", "1"], 
      SubscriptBox["b", "2"], "\[CenterEllipsis]", "\[VerticalEllipsis]"},
     {" ", "\[VerticalEllipsis]", "\[VerticalEllipsis]", 
      "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
     {" ", 
      SubscriptBox["b", "1"], 
      SubscriptBox["b", "2"], "\[CenterEllipsis]", 
      SubscriptBox["b", "s"]},
     {" ", 
      SubscriptBox["b", "1"], 
      SubscriptBox["b", "2"], "\[CenterEllipsis]", 
      SubscriptBox["b", "s"]}
    },
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, False, False, False, {True}, False}, 
      "RowsIndexed" -> {}}], "       ", GridBox[{
     {" ", "0", "\[CenterEllipsis]", "0", "0"},
     {" ", 
      SubscriptBox["B", "1"], "0", "\[CenterEllipsis]", 
      "\[VerticalEllipsis]"},
     {" ", "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
      "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
     {" ", 
      SubscriptBox["B", "1"], "\[CenterEllipsis]", 
      SubscriptBox["B", 
       RowBox[{"s", "-", "1"}]], "0"},
     {" ", 
      SubscriptBox["B", "1"], "\[CenterEllipsis]", 
      SubscriptBox["B", 
       RowBox[{"s", "-", "1"}]], 
      SubscriptBox["B", "s"]}
    },
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, False, False, False, {True}, False}, 
      "RowsIndexed" -> {}}]}], TraditionalForm]], "NumberedEquation",
 CellTags->"SPRKTableaux2",
 CellID->1987503591],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "d"}], TraditionalForm]]],
 " free parameters of (",
 
 CounterBox["NumberedEquation", "SPRKTableaux2"],
 ") are sometimes represented using the shorthand notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{
      SubscriptBox["b", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["b", "s"]}], "]"}], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["B", "1"], ",", 
      SubscriptBox["\[Ellipsis]B", "s"]}], ")"}]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->453852637],

Cell["\<\
The differential system for a separable Hamiltonian system can be written as:\
\
\>", "Text",
 CellID->938811082],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox[
     SubscriptBox["dp", "i"], "dt"], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"q", ",", "t"}], ")"}], "=", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[PartialD]", 
        RowBox[{"V", "(", 
         RowBox[{"q", ",", "t"}], ")"}]}], 
       RowBox[{"\[PartialD]", 
        SubscriptBox["q", "i"]}]]}]}]}], ",", "    ", 
   RowBox[{
    FractionBox[
     SubscriptBox["dq", "i"], "dt"], "=", 
    RowBox[{
     RowBox[{"g", "(", "p", ")"}], "=", 
     FractionBox[
      RowBox[{"\[PartialD]", 
       RowBox[{"T", "(", "p", ")"}]}], 
      RowBox[{"\[PartialD]", 
       SubscriptBox["p", "i"]}]]}]}], ",", "    ", 
   RowBox[{"i", "=", "1"}], ",", "\[Ellipsis]", ",", 
   RowBox[{"d", "."}]}], TraditionalForm]], "DisplayMath",
 CellID->1764150260],

Cell[TextData[{
 "In general the force evaluations ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     RowBox[{"\[PartialD]", 
      RowBox[{"V", "(", 
       RowBox[{"q", ",", "t"}], ")"}]}]}], "/", 
    RowBox[{"\[PartialD]", "q"}]}], TraditionalForm]]],
 " are computationally dominant and (",
 
 CounterBox["NumberedEquation", "SPRKTableaux2"],
 ") is preferred over (",
 
 CounterBox["NumberedEquation", "SPRKTableaux1"],
 ") since it is possible to save one force evaluation per time step when \
dense output is required."
}], "Text",
 CellID->1354581865]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard algorithm", "Subsection",
 CellID->1682581336],

Cell[TextData[{
 "The structure of (",
 
 CounterBox["NumberedEquation", "SPRKTableaux2"],
 ") permits a particularly simple implementation (see for example [",
 ButtonBox["SC94",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#17569"],
 "])."
}], "Text",
 CellID->775960219],

Cell[TextData[{
 StyleBox["Algorithm 1",
  FontWeight->"Bold"],
 " (Standard SPRK)"
}], "Text",
 CellID->957253531],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["P", "0"], "=", " ", 
   SubscriptBox["p", "n"]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   FormBox[
    RowBox[{
     SubscriptBox["Q", "1"], "=", " ", 
     SubscriptBox["q", "n"]}],
    TraditionalForm], "\n"}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"for", " ", "i"}], " ", "=", " ", "1"}], ",", "\[Ellipsis]", ",", 
   "s"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{
    SubscriptBox["P", "i"], "=", 
    RowBox[{
     SubscriptBox["P", 
      RowBox[{"i", "-", "1"}]], "+", " ", 
     RowBox[{
      SubscriptBox["h", 
       RowBox[{"n", "+", "1"}]], 
      SubscriptBox["b", "i"], 
      RowBox[{"f", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["Q", "i"], ",", 
         RowBox[{
          SubscriptBox["t", "n"], "+", " ", 
          RowBox[{
           SubscriptBox["C", "i"], 
           SubscriptBox["h", 
            RowBox[{"n", "+", "1"}]]}]}]}], ")"}]}]}]}]}]}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   FormBox[
    RowBox[{"\t", 
     RowBox[{
      SubscriptBox["Q", 
       RowBox[{"i", "+", "1"}]], "=", 
      RowBox[{
       SubscriptBox["Q", "i"], "+", " ", 
       RowBox[{
        SubscriptBox["h", 
         RowBox[{"n", "+", "1"}]], 
        SubscriptBox["B", "i"], 
        RowBox[{"g", "(", 
         SubscriptBox["P", "i"], ")"}]}]}]}]}],
    TraditionalForm], "\n"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"Return", " ", 
    SubscriptBox["p", 
     RowBox[{"n", "+", "1"}]]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "s"], "and", " ", 
     SubscriptBox["q", 
      RowBox[{"n", "+", "1"}]]}], "=", 
    RowBox[{
     SubscriptBox["Q", 
      RowBox[{"s", "+", "1"}]], "."}]}]}], TraditionalForm]}], "DisplayMath",
 CellID->602175649],

Cell[TextData[{
 "The time-weights are given by: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["C", "j"], "=", " ", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], 
       RowBox[{"j", "-", "1"}]], 
      SubscriptBox["B", "i"]}]}], ",", " ", 
    RowBox[{"j", " ", "=", " ", "1"}], ",", "\[Ellipsis]", ",", 
    RowBox[{"s", "."}]}], TraditionalForm]]]
}], "Text",
 CellID->1904790327],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["B", "s"], "=", "0"}], TraditionalForm]]],
 " then Algorithm 1 effectively reduces to an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "-", "1"}], TraditionalForm]]],
 " stage scheme since it has the First Same As Last (FSAL) property."
}], "Text",
 CellID->605017208]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellID->131138954],

Cell["This loads some useful packages.", "Text",
 CellID->1108695739],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveProblems`\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveUtilities`\>\"", "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->799417722]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Harmonic oscillator", "Subsection",
 CellID->865442555],

Cell["\<\
The Harmonic oscillator is a simple Hamiltonian problem that models a \
material point attached to a spring. For simplicity we consider unit mass and \
spring constant for which the Hamiltonian is given in separable form:\
\>", "Text",
 CellID->1347404055],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   FormBox[
    RowBox[{
     RowBox[{"H", "(", 
      RowBox[{"p", ",", "q"}], ")"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "(", "p", ")"}], " ", "+", " ", 
       RowBox[{"V", "(", "q", ")"}]}], " ", "=", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["p", "2"], "/", "2"}], "+", 
       RowBox[{
        SuperscriptBox["q", "2"], "/", "2"}]}]}]}],
    TraditionalForm]}], TraditionalForm]], "DisplayMath",
 CellID->1344844964],

Cell["The equations of motion are given by:", "Text",
 CellID->1637170117],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    FormBox[
     RowBox[{
      FractionBox["dp", "dt"], "=", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[PartialD]", "H"}], 
         RowBox[{"\[PartialD]", "q"}]]}], "=", 
       RowBox[{"-", "q"}]}]}],
     TraditionalForm], ",", "    ", 
    FormBox[
     RowBox[{
      FractionBox["dq", "dt"], "=", 
      RowBox[{
       FractionBox[
        RowBox[{"\[PartialD]", "H"}], 
        RowBox[{"\[PartialD]", "p"}]], "=", "p"}]}],
     TraditionalForm], ",", "    ", 
    FormBox[
     RowBox[{
      RowBox[{"q", "(", "0", ")"}], "=", "1"}],
     TraditionalForm], ",", "    ", 
    RowBox[{
     FormBox[
      RowBox[{
       RowBox[{"p", "(", "0", ")"}], "=", "0"}],
      TraditionalForm], "."}]}]}], TraditionalForm]]]], "NumberedEquation",
 CellTags->"HarmonicOscillator",
 CellID->1316211838]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input", "Subsection",
 CellID->1196335838],

Cell[BoxData[{
 RowBox[{
  RowBox[{"system", " ", "=", " ", 
   RowBox[{"GetNDSolveProblem", "[", "\"\<HarmonicOscillator\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"eqs", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"system", "[", "\"\<System\>\"", "]"}], ",", 
     RowBox[{"system", "[", "\"\<InitialConditions\>\"", "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"system", "[", "\"\<DependentVariables\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"H", " ", "=", " ", 
   RowBox[{"system", "[", "\"\<Invariants\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"time", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"T", ",", " ", "0", ",", " ", "100"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"step", " ", "=", " ", 
   RowBox[{"1", "/", "25"}]}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->869125851]
}, Open  ]],

Cell[CellGroupData[{

Cell["Explicit Euler method", "Subsection",
 CellID->2026084279],

Cell["\<\
Numerically integrate the equations of motion for the Harmonic oscillator \
using the explicit Euler method.\
\>", "Text",
 CellID->1992096299],

Cell[BoxData[
 RowBox[{
  RowBox[{"solee", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"eqs", ",", "vars", ",", "time", ",", " ", 
     RowBox[{"Method", "\[Rule]", "\"\<ExplicitEuler\>\""}], ",", " ", 
     RowBox[{"StartingStepSize", "\[Rule]", "step"}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", "Infinity"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->843456910],

Cell["\<\
Since the method is dissipative, the trajectory spirals into or away from the \
fixed point at the origin.\
\>", "Text",
 CellID->178447753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"vars", " ", "/.", " ", 
     RowBox[{"First", "[", "solee", "]"}]}], "]"}], ",", 
   RowBox[{"Evaluate", "[", "time", "]"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "100"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->929709575],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 371},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->5427405]
}, Open  ]],

Cell["\<\
A dissipative method typically exhibits linear error growth in the value of \
the Hamiltonian.\
\>", "Text",
 CellID->341018553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvariantErrorPlot", "[", 
  RowBox[{"H", ",", " ", "vars", ",", " ", "T", ",", " ", "solee", ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->857553362],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnH9wXFUVxzf7I0l/EQptaWkLaSptINAWWpukTdtgoIWUFtFiVVCJnWqi
VGpaB3+hCCqjqIOoozJoGZRx0EEZVPAXjuIIow6iKIo/UVQURUdRQUW9vrtv
3553v+e+c86ClP7RTPs2L3s/53zOeffdfbubzZaxveM7d43tndgx1r1pcmz3
+MSOPd0bL5hMflRpK5XaxpP/E3NLyfeuVEr/+6+J5H/6bfF3hyXbcgKsS26r
yW25sT/k761mkVzjp2sbt5XcqPz+YHJbyUWp5G5LpZlhzEbWUi39SXNbp0sV
GjfIOBzR7zft+RHxcQPGcf1ixswxaX2pzd8WVLfe5O0HlGpNm0b8wQOyog0R
hmXB+4MI1rr8uHJxhCe9kgExfyV6z5r9eiyGjNmKK6n71vLneFEnnqyqstVn
vePrCl99stWm7IpXH1x1aPXxUSwr4oyG/TkN0/Qn+UqrsI/3H6Lsa+P3d7yn
Op/vZ9vBbh+Q3d4A+8PK/dp+mL3dpWdo7Sm1qGcPVi7M7zfbW2Tqq07lMneZ
vyBL/nX6TaXf9Se34268PmyjIaZfoOvBul23DzGlHqfNtTXipvtJxJzr6gbX
must7pZlbtlCt7DU4TeVXtc76SY7XWepK+fu/5UjOVe02J+uaM5a4p3mqECd
UyM5e02zaR5kKueqS37U2KfM0/ymRtXS8VrkpHNnMeSpKRV1RCqaJ2boi1VS
a1aS7Pls0yNxDxfjroK4FTCvwfGvRDJMFzOsETL4jkyLRGwXI9bXgGoScdgN
p+WjdezMaBNjblL6kNZdTa7Z4+fBY2L0LUXzcJabRSsERXtEjPZsv6k1ozWO
Pdb8MIvhQ2yPmlCd7RDloQYXNzk3alJVevWgWN15ftOej5n2Cc+ZB8QoO6Nm
GON+McZENs+aJxjy94n8+VGH/BnlV5efiTF2M4cyrCXY3XvFeHtyTrTK41G/
R4xxIXNC/m6Rf63K3yXyFzG+BvydIn8x4+tnd7W5yiWBviVGuDTXRVrJqmBx
B4vhQ7wlY5urF80KYm9z0nn3NkdncRFdbH85qx/NvyLy71Ky3yrSVyj0F0X6
yvixy51PXxD590WPHD6q3SzGeH/mkB7B5ATC/n1G5K+CDiB9k0hfrdA3ivSH
FfqTIn0N0Ni3Gxjt4WsV6nonzfWPZrRfqCJXINeLxtdB7nLuscnPFpn+WG62
pY9CmP06kf+44v4Rkf6E0rdrRfoGhb5GpD8F5vgos0+kb1Ryf0ikb1JyXy3S
n1ZyXyXSn1Vyf1Ckb47ONlqbPsBoD38um2VpzmRBwqzvcdIZ8vmMb65HyL9X
tP6SUvOVIn2rQr9bpL8c7RjRV4i0f5yqr+aN3GmX5YxfVXzfKdK3KfQ7RPpr
SrWXi/TXo9WGGWuNmYLPhG+PsmG+TmDwdd47ojHersbwr0fcrvTtEpd/3UIz
+YbfdORNaEV/a+BT9MrANx2u7Gh0KYsjvU51Z7Q3bw5idDRckP12lA3z41y4
K8pcIjLfiTJvEpnvRpmLRebuKPNGkflelHmDyHw/ylwkMvdEmdeLzA+izOsY
45EfRse+2knr971R5jWi048K8xQzP44yF4rMT/ymvck0T7NXidRPs0zJI1L6
EofHZebnrnFG9rieNMdecfx99fGNl0br4/fo41n1kyLziyjzSpH5ZZTZLTL3
R5kLojPsV1mf0rHJdpc4u37N+voK0eU3rK+79PHM/XyReSDKvFxkfsvqlsf/
jtX9MnH8g6zuCX08q2FcZH7PapDH/4HV8FJx/EOshpfo41kNO6Pz7o/MfYc4
7/6UxU7WgG1uWyP2DtHnz8z/xfp45j8mMn9hdcjjH2bH4Dxx/F9ZDS8yjM/7
yOP/xnxeKI7/O/N5gWF83kce/wjzOTc6fx5lHs8T58+jzOMc0eMfzOP54vh/
Rn208Xkfefy/mM9zxfGP1fdTH5/CMDqIvl0c/29W7XMM4/PVhuPTi9jsK/u9
DLzK/g+zPDuIwn8zBa/0cf+/0KX/S7zAcNvjiOifudRrraVm9Gxkq8s/r2nd
r75hV1LPeoJV+02ZVX5WeIQrdISz36fB4+s3FTgiYRScV00iyPxMlalPt2D+
nmlk8nNYZ2rMbavKtEMHjESQZYvKdEAWIxFkOYMxGdIJ0UedtDY3iSD6ZtVo
CmQxEkGWUZWZyubK6UYmP1d0ZhpzO01lpkMHjESQZZPKzIAsRiLIslFlDoEs
RiLIcmrhjOyC6CPqjOxi0U9RjQ6FLEYiyDKiMjMjtRgIdvV8ssodDpmMRFDP
sMrMgixWIq1nn9tnIGbXf5b+FpWvfYORICtOZMBsVvOQOrvmQPT1qs8clmWd
yhwBWYwEq0Vm5kIWIxFkWasy8yCLlaBZohNHwixZYyTIykgEtQ+qzHzIwokM
mM+ir1bn4gKIPqD6LIDO6sRC6Gy/kSArI8Fql5mjIIuRCLI8XWWOhixWgjoc
EtnnPNKvDI9dT3dD31cFcfBKvgL7sSv9bqil9YjZRwV4J5c79vymRbtFYLeS
27HPA8T6tgj6H4nDPvGA7+r4TQ/0/6TwOOaeFVVd/P0cikJVhVFi86eH9fZE
lVkMWawEdUknjoF+LDcSZGUlyEonloDVMiNBVpzIgCXsSPQ5bUVeCtFPUH2W
Qs060Qs1H28kyMpKkJVOHAtWfUaCrIxEcESOU5njIIuVoNp1og9qP7ZwTvWB
zVJ1RvWBDY+NxPFg02skyMpKkJVOnABWS41E2CsLQVY6sQyslhgJsrISZKUT
y8HqGCNBVpzIgOVgs1idgSvA5mmqzQqwsRJkpRMngtViI0FWViLslUycBFY9
RoKsrARZ6cRKsFpkJMiKExmwEmyOVufTKrDpVm1WgY2VICudWA1WRxkJsrIS
ZKUT/WC10EiQlZUgq5DI/02A2PX2ABguCOj00jp9ppNtLe9KDEAVYdTH907H
ANQZxsw/RykVRMyeOJzl8s92LCS6DELX5kPX8rXZKxyErkFU4zs5g9CnMEps
Bq2Bao40EmRqJchKJ9aClfzJOiLIykqQlU7I78/6zRB4z2VEBgyB7xynrb1D
4MtjI7EObI4wEmRlJchKJ/QurgfvOUYi7KaFIG+d2ABWs40EWVkJstIJ3s1s
wDD4HqbOsGHwnaVmHwZfnTgZrOTPthJBVlaCrHRCn5PPiHTTQpC3lSBvndC9
R8B7ZuF8GQHfLnW+jIAvj9267ynge6iRIG8rQd46oXufCt5dRiLst4Ugb53Y
BFYzjARZWQmy4kQGnK3OqNPAV/5cOhHkayXIVyf0o386eE8zEuRtJchbJ3Tv
UfCeGhD1v24V/JZY7JpzFCoJY2R8bke5Eh6FOsN4rbzXUXytH8sdc9kM/ZkS
uLCIBR3aDB0Ko8jPhmLvTGyGDkE84/sb+uzQR5wB/ek0EtQLK0HV6oTuvQW8
O4wEeVsJ8uaEfV3cCr7yX9cggnytBPnqhN7nM8G7ZiTI20qQt07I3vv37xcd
2Nnx/oN/r6u1+3m3K5HV+GCXn9j9ZYfrp3/8o78BWGr7Hxx10ug=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 361},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->545384791]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symplectic method", "Subsection",
 CellID->388208752],

Cell["\<\
Numerically integrate the equations of motion for the Harmonic oscillator \
using a symplectic partitioned Runge-Kutta method.\
\>", "Text",
 CellID->697573305],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"eqs", ",", "vars", ",", "time", ",", " ", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<SymplecticPartitionedRungeKutta\>\"", ",", " ", 
        RowBox[{"\"\<DifferenceOrder\>\"", "\[Rule]", "2"}], ",", " ", 
        RowBox[{"\"\<PositionVariables\>\"", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["Y", "1"], "[", "T", "]"}], "}"}]}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"StartingStepSize", "\[Rule]", "step"}], ",", " ", 
     RowBox[{"MaxSteps", "\[Rule]", "Infinity"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->952078810],

Cell["The solution is now a closed curve.", "Text",
 CellID->1327019834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"vars", " ", "/.", " ", 
     RowBox[{"First", "[", "sol", "]"}]}], "]"}], ",", 
   RowBox[{"Evaluate", "[", "time", "]"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->314239917],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 357},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->37850038]
}, Open  ]],

Cell["\<\
In contrast to dissipative methods, symplectic integrators yield an error in \
the Hamiltonian that remains bounded.\
\>", "Text",
 CellID->862117522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvariantErrorPlot", "[", 
  RowBox[{"H", ",", " ", "vars", ",", "T", ",", " ", "sol", ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->1090200137],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnX2MVcUZhy+7e1dAvkFEWWFBBEQ+5ZuNLAEEUaAIFClKYEFgESuomKiN
kKgJ2KqtttpG26KpttW22gYSNBETtalN1ESb6B+a1iZKok1t0zZpm9Tm9J69
H3POc2bu7931LktSbrL37twz8/zemXdmzpyZOeeuatvfvuOrbft3b29rXn5L
27723dtvbV6295bCV/W9crle7YW/tSNyhf+jXK74F792F/6K/4b/m1h4rysk
mF/4bCh81pXC8+KjDWVSVPp2TumzvvQ5F+HZhc/6BKU+8ZnLTUgzS6q5fPGb
yntH6ly9izc7k44xLo3fGpMx/PFmdiZeULFsY6Hoc73iz0DuFki7Z5ZKPZev
WFPizzotc9TiSZNR4fEUwZqvOF6dl1C9NtQqJ2H9+Eh92LJT5ot5tSnJfLKN
B33aTbkq9z4LonR/4e99yr1NXRTufdjruN4nplh6xHEl65eUc9DxTTKn9Qj3
R7jfKT5+qvVqbW9cnul6cabE/99KvKmT4e7W1yVW6lY6XiytUC+U/MyLEm/5
guEFOgep3roh/hD9PM8PKtxRFgjHb62niS3F8KFD8QmgvT3KTUX4LISndDL+
heI40zcifHEPllO+o2I3N8e29O6dtb3YY/C4C/vz/kV54ePknS/0GxEeH7kr
oJ6tj8ePR4sWRUeOZG3254nxGXbxz/OWWXfrqfjUC9vXiHBPto/s2cLZxXyM
RJjlMriT6QeinEd60zPs4g9CuF+2HBNnt7jUu3JGG+5VdVbRaubqoi6ld6X0
ZYQHIZzNNUdBw5FiEcIXeY87i5gD9u/jEJ85tFrIFuIUpiGc91oYTr8FOWSv
uUxaOBoppiE8B2GeE6eKPoDxzzFa5AjTEJ6DcMdZv6GoUDRyV+YbrdoMOzmW
KDKL5VBXFwtnv7GquNKcgvA8qE5GXueL48ONFqD0EuF5sGgzFHvj+OVS8RwQ
2r1EZ8FmKPC4VdERFkORYxX/cae4xqjoUiyGAok8vg4WDEH4bGnBJiisB4Hn
sHWwYAjCfsVYcBLI53n960i7oDwE4T5RYsYuk69JoHGMtNJrjaN/XZbcJKQg
YSUUWX9bpMIjIK4AoQkKmni2aFP0QRMssCo4wgYo8GzeDoVNRgWXYgOIA73H
nQU3SoXrQWCptII4SRJ/ghQ8P7dCQRNngZjvZGuyKjhCHuGtXgucwneMCi4F
CVtFC5ohFY6AOBuE6VDQxBtFOU+HoibWg7hTtJDrjURH6CDmi4T168s6b3k5
9eWLhCr1n35oixJrERlrbhK0yaDNlPn7AVLMh8JkKGjipcKr9IGV6Ah9oHAd
iD80EtPnv2peeVgSFwrP7AJxoiQ+A+IuEDXhLWguAVETtglf3iQJ/UFYK2qD
legIa0EYCsXXjER7G90oibcLoiZ8BMII2HCZlxADvi181hJVG+tNFKnpL78d
WaIjXACFK0D8qZHoUlwg/HVYEmmDar2jJPEoiGy9A0DsL4mvIcU1UBgABU38
Coi0kb7WxHNBbPWWoyPebiRyvOgI46H4opFob+2rJfFuQdSEz0BogA3LJeE+
pKANVkLY+35CDBjl1XYpfxVVG9OMgu4M0D6Vlo+C3gxvrXPEg5LIc4q/ZTji
MEl8CcQdcbixQqigNelFX2k3VgAVCU36Ekiq/Z9rJIbb+92SMAY2XQLCn42E
sK+eNxLsPcRSSbxfEDXhT9DsC2KW0NXV97iVxlG5VnHQV+8Sebg6a0HNV5o6
bBfhg6IWny52DvOWp7PzpR60M17Z5mzkUtj7+6h7V4OjUj1lPRyGclrq9bez
87buLMcUqRGWXgtL2WI8lnViTbEh8ZlU/Q1Ur0Z5sN71zVjBvid+4/rqMIQ1
5ZfQ5bmBftXEy0Fk+X5DEi4BgaNNtkkr0RE42vynkcBa42x8WhIeFS1igZEQ
rrma8EdocoymCbcJ715rJIS96SfEgL5ebZfy11G1a+i+0N0I2nvScp7dN4Ko
CTtELdojCW9D05oiPTfAsVx1wo+RgiNSKyE8AtWEFuH7RySBM+OcQ45KKS0U
l4ozyZybe9xIDLdqTXhC1KrpkhC/9YOuTvUedDh/qwl7vF51NuzwEmLAHsRk
fdgeVesLeCXP9bC3peUNXn1HfNNICPtdE/YKv7dJwvvQtKZIr7IlNWdJwveF
z62EsO81gbMZJBwxEtK7ApLEz40Ep8l1ZU1oFf5/SBKehSbnZCYYCeE5mWYQ
G7zEMpC7RZpBK18F+1v1m8Krfu0koU3Uzb2SwBnkNaKuWomOsAaE942EcD15
VRLu8OYiPettIYR7O034GASd4r+wcqFM8bDwv5UQ9rcmTBC1+BkjwdkwGsS/
GwlOczSImrACBPYs/tWfGHBU1LWRUbU+gCs89GA/0AbInMRvo0HlWElTXhVe
1QRer7CnvUMSfKuV1UblVqIjXAbCR0ZCuG96QRLuEfVllZEQrjOa8BcQdIp/
wMorZIrD3hrkrMwSujLXXG5Zvjm+w96Sdrn2WND1OT3//b1ZXsI+rmHTvqM9
YF8cjbN0M2HnyahGc7ZdLrP0vp+krZ/0sE/XwT6eRw70sH0nUF7sfYZm7avB
HSonUCrboVoHq7JW+M5y45CKd3Vpyguwgy1whCSsBoFnuXuMhPBZTRPGwoaL
QfjMSAjXiueMhPA5SRMe8BLS+86qE/4NTZ3iU2jw/jJNOOCtQel9Zf5x4wFv
mafvVQiPG7k/jalPSMuHQn8ZiB8aCU5zGYiawD2X9Pl+SXhd1Nw+RoKzgfsZ
eG+aJsZvvLOQ949pyvOwg/3CWEngWivr5v1GQriOagL3EnPG5F9GQtjDTxkJ
9p0Y8yXxu4LoJ5QBnIOfG1Vr6R/CuuukdfuF362EsN81gburSXjdSHA2bALx
XSPBaW4CURN2ev3sbLhBEt6BpjWF0+RK0mRJeBopOCaxEsJjEk1YIPz/qCR0
3B16VoVQeKXXvrJPOfITKqkKL6ffCUIV/z/mJcSAJ1GCTBnfTRvezfikV9fR
pknL34Ue7+yxEtL3rFRPcYPwuSbwnqltsOEdI8Gl2AYbeG/PG0Zi2BeasE/U
oq2S8AE0rSnSd2kkNWdLwuNebzobrITwWUQTposa9YSRkN7PniT+x0uIAbxv
jHeM0IsPRtXO4otELfqWzMnPQODMwnhJiN84muWu67ykvIEUy2EXd2Jr4lZR
0+h1KzFM2CcJfEbGahA+MBLC9eUVI8E+bt0giXcKoiacBIH7AFsl4XNoZlN0
dR64ONlVfnEO6iFvLXM58dhRw5k5WsM9qrwDhZ559pRbF0fiDNsYWLkUZRjf
Vd09M8O28nOWjIHlf+vW8gvNe14Jq9hnH+p2q5LWcC74GMqI/UlT1roa7Cw+
hjJhTeeuyYEZK9ijvIIU3DHNnZSaeA2I6p4WTeSzNVpA5BXWnUaiI7SA8LGR
EB6XHpeEe0UNWmkkhGuDJvy1o41UCBXxFTLlIVhLbU1oEgTWEysxPcrm3sgk
8ZiXGAObEJM7QU9G1car65GaPdddMicvQ68NhAaEhxiJzqY2KDQgrInHvf5L
78BKhjVxFYjsOe6VBD7Pkbtj2FNYiY7A3TILofgLI9E+Ml0siQ8KoiZ8Ak3u
ItOEu7y1wdmwThL4tCfVH1iJ6V0TSQWuh79sJKZ3QVTz3a1eYgzc3Mla0BhV
63F+CxpbEvfu9JY5fU60Re7l0cQlwr9smxdKIp9Ox1U51pgHjMT0WnqSsBaK
PzIS7X6eJ4nfE0RN+AM0uf6sCb29vgz7drORmF5n4VpkNd9aFdLrMFybzB53
FuyWCqzBLAVN+B0IfNLhFEl4CinYbjWBmqqd+okxMF6by+WLpP79y+l3Jr69
6qrkPT3h/q1IKtrQ2JicE1frBNXzOtfrsbAHNXG3aBlcFdFEPu3UPz+X9o+F
mJ4R5xxhVjE9nrUo2Hu9LZJ4syByDmiOJD6GFK1QGA8FTeRzbDkPymf7sbZZ
FdJX45yD5LV10oJvGhVICJc7r214VdcoFX8OhZEgrIAir/K0Ap8kzadl+q5d
kxbxatCqmL4ST4Y5o7ESCjd7FWIBPn2ZKTmzwZa2LqrWz34NNI7J/c9LdccX
yZLh06Z5xeZ/Jiwtcsetii6F/7m36b1B3DuXPG5VTI9ks/MB6dF4UtH/tGEX
HiQt4LPUeU7n3jGOvvxPH3ZhqwXpXT3cR8FxL0cVHPlkLXZhq0UcW6X3ZWRa
TunJ1kUjrpQa7LuKT8cuaIwdW/qq8k0s0SFkpTrL5kJlKo7PwXH/s8Pd8cFG
C9KjFvbyHCdV8ybjbxHHtYXjQGCr54iEZcjVGsbnM8lVfG3xYE+rThLZi7AM
GX+c8JGKf37G4s6uJcbnlOTvM3JFZ7CnF6nmE9Z7/28ruPg8q6r07CV9vyRS
sxWm3tl42dgdJYswf6+EvzdCq1mvOCLgcRuPY5eu81gPfb+n0n3revouD/7e
C1u63x8sH5d/Fd/G5wiv63xeT/r9lebXzB+Beh46nq/0Is4e9lv+31ji6Ct8
XPE4J6jS89wVP++klk/pspZdMuwfXfHsFj7OeZLsrEXP/KZRD/weXQ3u6Dr1
VnPscea3Kmtr75kSPz1KPG6ZS1xf2+t/bvvoCQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 338},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->421539505]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rounding error reduction", "Section",
 CellTags->"s:2",
 CellID->1464293172],

Cell[TextData[{
 "In certain cases, Lattice symplectic methods exist and can avoid step by \
step roundoff accumulation, but such an approach is not always possible ",
 "[",
 ButtonBox["ET92",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#16590"],
 "]",
 "."
}], "Text",
 CellID->847506816],

Cell["\<\
Consider the previous example where the combination of step size and order of \
the method is now chosen such that the error in the Hamiltonian is around the \
order of unit roundoff in IEEE double precision arithmetic.\
\>", "Text",
 CellID->1721447766],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"solnoca", " ", "=", " ", 
    RowBox[{"NDSolve", "[", 
     RowBox[{"eqs", ",", "vars", ",", "time", ",", " ", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<SymplecticPartitionedRungeKutta\>\"", ",", " ", 
         RowBox[{"\"\<DifferenceOrder\>\"", "\[Rule]", "10"}], ",", " ", 
         RowBox[{"\"\<PositionVariables\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["Y", "1"], "[", "T", "]"}], "}"}]}]}], "}"}]}], ",", 
      " ", 
      RowBox[{"StartingStepSize", "\[Rule]", "step"}], ",", " ", 
      RowBox[{"MaxSteps", "\[Rule]", "Infinity"}], ",", 
      RowBox[{"\"\<CompensatedSummation\>\"", "\[Rule]", "False"}]}], "]"}]}],
    ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{"InvariantErrorPlot", "[", 
  RowBox[{"H", ",", " ", "vars", ",", "T", ",", " ", "solnoca", ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], "Input",
 CellLabel->"In[15]:=",
 CellID->1595432126],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJztmH2IlXUWx2dUWKaGWm2iDGt3XirHzJpptprtmPOimWUvM02pNP2hWSEI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   "], {{}, 
    {RGBColor[0, 0, 1], PointBox[CompressedData["
1:eJwVz1VgFQQAQNFHiZSKhDSidHfnRtfGWNAxOkc3SHcKCoqC0g1KdyOgNEp3
o3SHyPHj3P+bKTomrHOsQCBQQkpSitKUoSzlKE8FggimIpWoTBWqUo3q1KAm
tahNCKHUIYy6hBNBJFHUoz4NaEgjGtOEpjSjOdG0oCWtaE0b2tKO9nSgI534
fyyGLnSlG93pQU960Zs+9KUf/RnAQAbxFYMZwlCGMZwRjGQUoxnDWMYxnglM
ZBKTmcLXTGUa3/At05nBd3zPTH7gR2Yxm5/4mTnMZR7zWcBCFrGYJSxlGctZ
wUpW8Qu/spo1rGUd69nARjaxmS1sZRvb2cFOdrGbPexlH7+xnwMc5Hf+4BCH
OcJRjnGcE5zkT/7iFKc5w1nOcZ4LXOQSl7nCVa5xnRvc5Ba3ucNd/uYf7nGf
BzzkEY95wlOe8ZwXvOQVr3nDW/7lHf8RiB0IxCI2cYhLPD4gPh+SgIQkIjFJ
+IiP+YSkfEoykpOClHxGKlKThrSkIz0ZyMjnZOILviQzWchKNrKTg5zkIjd5
yEs+8lOAghSiMEUoSjGKU4KSlKI0ZShLOcpTgSCCqUglKlOFqlSjOjWoSS1q
E0IodQijLuFEEEkU9ahPAxrSiMY0oSnNaE40LWhJK1rThra0oz0d6EgnOhND
F7rSjfesrpZA
      "]]}, {}}],
  AspectRatio->1,
  AxesOrigin->{0, 0},
  Frame->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->Automatic,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  RotateLabel->False]], "Output",
 ImageSize->{364, 321},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]="]
}, Open  ]],

Cell["\<\
There is a curious drift in the error in the Hamiltonian that is actually a \
numerical artifact of floating point arithmetic.\
\>", "Text",
 CellID->373381840],

Cell["\<\
This phenomenon can have an impact on long time integrations.\
\>", "Text",
 CellID->313391033],

Cell[TextData[{
 "This section describes the formulation used by ",
 StyleBox["SymplecticPartitionedRungeKutta", "MR"],
 " in order to reduce the effect of such errors."
}], "Text",
 CellID->1156122963],

Cell["\<\
There are two types of errors in integrating a flow numerically, those along \
the flow and those transverse to the flow. In contrast to dissipative \
systems, the rounding errors in Hamiltonian systems that are transverse to \
the flow are not damped asymptotically.\
\>", "Text",
 CellID->1718226805],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0029216 0.0238095 0.00291978 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.4 0 0 1 k
1 Mabswid
[ ] 0 Mabsdash
.23085 .3953 m
.23043 .40392 L
.2292 .41229 L
.22721 .42037 L
.22449 .42812 L
.21702 .44244 L
.20714 .45491 L
.19515 .46521 L
.1814 .47298 L
.17396 .47582 L
.1662 .47789 L
.15817 .47917 L
.14989 .47961 L
.14161 .47917 L
.13357 .47789 L
.12581 .47582 L
.11838 .47298 L
.10462 .46521 L
.09264 .45491 L
.08275 .44244 L
.07529 .42812 L
.07257 .42037 L
.07057 .41229 L
.06935 .40392 L
.06893 .3953 L
.06935 .38668 L
.07057 .37831 L
.07257 .37023 L
.07529 .36249 L
.08275 .34817 L
.09264 .33569 L
.10462 .3254 L
.11837 .31762 L
.12581 .31479 L
.13357 .31271 L
.14161 .31143 L
.14989 .311 L
.15817 .31143 L
.1662 .31271 L
.17396 .31479 L
.1814 .31762 L
.19515 .3254 L
.20714 .33569 L
.21702 .34817 L
.22449 .36249 L
.22721 .37023 L
.2292 .37831 L
.23043 .38668 L
.23085 .3953 L
.23085 .3953 L
Mistroke
Mfstroke
.06885 .39625 m
.0696 .42609 L
.07182 .45554 L
.07548 .48457 L
.08055 .51313 L
.08698 .54118 L
.09475 .56871 L
.1038 .59565 L
.11412 .62199 L
.12565 .64768 L
.13838 .67268 L
.15225 .69697 L
.16723 .7205 L
.18329 .74324 L
.20039 .76515 L
.2185 .78619 L
.23758 .80633 L
.25758 .82553 L
.27849 .84376 L
.30025 .86098 L
.32284 .87715 L
.34621 .89223 L
.37033 .90619 L
.39517 .919 L
.42069 .93062 L
.44685 .941 L
.47362 .95012 L
.50095 .95793 L
.52883 .96441 L
.55719 .96951 L
.58603 .9732 L
.61528 .97544 L
.64493 .97619 L
s
.23085 .39684 m
.23139 .41815 L
.23299 .43917 L
.23562 .45989 L
.23927 .48028 L
.24389 .50031 L
.24947 .51996 L
.25599 .5392 L
.26341 .558 L
.2717 .57633 L
.28085 .59419 L
.29083 .61152 L
.3016 .62832 L
.31315 .64456 L
.32545 .6602 L
.33847 .67522 L
.35219 .6896 L
.36658 .7033 L
.38161 .71632 L
.39726 .72861 L
.4135 .74015 L
.43031 .75092 L
.44766 .76089 L
.46552 .77003 L
.48387 .77833 L
.50269 .78574 L
.52193 .79225 L
.54159 .79783 L
.56164 .80245 L
.58204 .80609 L
.60277 .80872 L
.62381 .81032 L
.64513 .81086 L
s
.72774 .89343 m
.72732 .90189 L
.72606 .91011 L
.72402 .91804 L
.72123 .92564 L
.7136 .9397 L
.70349 .95195 L
.69123 .96206 L
.67716 .96969 L
.66955 .97247 L
.66162 .97451 L
.65339 .97576 L
.64493 .97619 L
s
.72774 .89342 m
.72732 .88496 L
.72606 .87674 L
.72402 .86881 L
.72123 .86121 L
.7136 .84715 L
.70349 .8349 L
.69123 .8248 L
.67716 .81716 L
.66955 .81438 L
.66162 .81234 L
.65339 .81109 L
.64493 .81066 L
s
.4793 .1476 m
.47888 .15622 L
.47765 .16459 L
.47566 .17267 L
.47293 .18042 L
.46547 .19474 L
.45558 .20721 L
.4436 .21751 L
.42985 .22528 L
.42241 .22811 L
.41465 .23019 L
.40661 .23147 L
.39834 .2319 L
.39006 .23147 L
.38202 .23019 L
.37426 .22811 L
.36682 .22528 L
.35307 .21751 L
.34109 .20721 L
.3312 .19474 L
.32374 .18042 L
.32102 .17267 L
.31902 .16459 L
.31779 .15622 L
.31738 .1476 L
.31779 .13898 L
.31902 .13061 L
.32102 .12253 L
.32374 .11479 L
.3312 .10047 L
.34109 .08799 L
.35307 .0777 L
.36682 .06992 L
.37426 .06709 L
.38202 .06501 L
.39006 .06373 L
.39834 .0633 L
.40661 .06373 L
.41465 .06501 L
.42241 .06709 L
.42985 .06992 L
.4436 .0777 L
.45558 .08799 L
.46547 .10047 L
.47293 .11479 L
.47566 .12253 L
.47765 .13061 L
.47888 .13898 L
.4793 .1476 L
.4793 .1476 L
Mistroke
Mfstroke
.31729 .14796 m
.31804 .1778 L
.32027 .20725 L
.32393 .23627 L
.329 .26483 L
.33543 .29289 L
.34319 .32041 L
.35225 .34736 L
.36256 .3737 L
.3741 .39938 L
.38682 .42439 L
.40069 .44868 L
.41568 .47221 L
.43174 .49494 L
.44884 .51685 L
.46695 .5379 L
.48602 .55804 L
.50603 .57724 L
.52693 .59547 L
.5487 .61268 L
.57128 .62885 L
.59466 .64394 L
.61878 .6579 L
.64362 .67071 L
.66914 .68232 L
.6953 .69271 L
.72207 .70182 L
.7494 .70964 L
.77727 .71612 L
.80564 .72121 L
.83447 .72491 L
.86373 .72714 L
.89337 .7279 L
s
.4793 .14914 m
.47984 .17045 L
.48143 .19147 L
.48407 .21219 L
.48771 .23258 L
.49234 .25261 L
.49792 .27226 L
.50443 .29149 L
.51185 .31029 L
.52015 .32863 L
.5293 .34649 L
.53927 .36382 L
.55005 .38062 L
.5616 .39685 L
.5739 .41249 L
.58692 .42752 L
.60064 .4419 L
.61502 .4556 L
.63006 .46862 L
.64571 .48091 L
.66195 .49245 L
.67876 .50322 L
.69611 .51319 L
.71397 .52233 L
.73232 .53062 L
.75113 .53804 L
.77038 .54454 L
.79004 .55012 L
.81009 .55475 L
.83049 .55839 L
.85122 .56102 L
.87226 .56262 L
.89358 .56316 L
s
.97619 .64573 m
.97576 .65419 L
.97451 .66241 L
.97247 .67034 L
.96968 .67794 L
.96205 .692 L
.95194 .70425 L
.93968 .71435 L
.92561 .72199 L
.918 .72477 L
.91007 .72681 L
.90184 .72806 L
.89337 .72849 L
s
.97619 .64572 m
.97576 .63726 L
.97451 .62904 L
.97247 .62111 L
.96968 .61351 L
.96205 .59945 L
.95194 .5872 L
.93968 .57709 L
.92561 .56946 L
.918 .56668 L
.91007 .56464 L
.90184 .56339 L
.89337 .56296 L
s
.46222 .35546 m
.46189 .36824 L
.46093 .38085 L
.45935 .39327 L
.45717 .4055 L
.4544 .41751 L
.45105 .42929 L
.44714 .44083 L
.44269 .45211 L
.43772 .4631 L
.43223 .47381 L
.42625 .48421 L
.41979 .49428 L
.41286 .50402 L
.40548 .5134 L
.39768 .52241 L
.38945 .53103 L
.38082 .53925 L
.37181 .54705 L
.36242 .55442 L
.35268 .56135 L
.3426 .56781 L
.3322 .57378 L
.32148 .57927 L
.31048 .58424 L
.2992 .58869 L
.28765 .59259 L
.27586 .59594 L
.26384 .59871 L
.25161 .60089 L
.23917 .60247 L
.22656 .60343 L
.21377 .60375 L
s
.46222 .37006 m
.45491 .37006 L
.46222 .34086 L
.46952 .37006 L
.46222 .37006 L
F
.48466 .39684 m
.49179 .41799 L
.50061 .43854 L
.51098 .45837 L
.52279 .47738 L
.53592 .49547 L
.55023 .51253 L
.5656 .52845 L
.58191 .54315 L
.59904 .5565 L
.61687 .56841 L
.63525 .57878 L
.65409 .58749 L
.67324 .59445 L
.69258 .59955 L
.712 .60268 L
.73137 .60375 L
s
.71676 .60375 m
.71676 .59645 L
.74598 .60375 L
.71676 .61105 L
.71676 .60375 L
F
gsave
.10415 .38002 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.1875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
70.375 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(H) show
76.500 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
78.625 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
83.938 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.35979 .126 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.4375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 16.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
64.812 8.500 moveto
(`) show
70.375 20.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(H) show
76.500 20.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
78.625 20.250 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
83.938 16.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.34226 .50557 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.0625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
67.625 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
71.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5497 .54937 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.75 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
67.625 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
73.875 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 288},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[103]:=",
 CellID->1950561150,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 287}, {287, 0}} -> {-8.15118, -8.15627, 1.19262, \
1.19336}}],

Cell["\<\
Many numerical methods for ordinary differential equations involve \
computations of the form:\
\>", "Text",
 CellID->324851153],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["y", 
    RowBox[{"n", "+", "1"}]], "=", " ", 
   RowBox[{
    SubscriptBox["y", "n"], " ", "+", " ", 
    SubscriptBox["\[Delta]", "n"]}]}], TraditionalForm]]]], "Text",
 CellID->767078995],

Cell[TextData[{
 "where the increments ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    SubscriptBox["\[Delta]", "n"]}], TraditionalForm]]],
 " are usually smaller in magnitude than the approximations ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    SubscriptBox["y", "n"]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->672203353],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"e", "(", "x", ")"}], TraditionalForm]]],
 " denote the exponent and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "(", "x", ")"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", " ", ">", " ", 
    RowBox[{"m", "(", "x", ")"}], " ", "\[GreaterEqual]", " ", 
    RowBox[{"1", "/", "\[Beta]"}]}], TraditionalForm]]],
 ", the mantissa of a number ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 " in precision ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 " radix ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]]],
 " arithmetic: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", " ", "=", " ", 
    RowBox[{
     RowBox[{"m", "(", "x", ")"}], "\[Cross]", 
     SuperscriptBox["\[Beta]", 
      RowBox[{"e", "(", "x", ")"}]]}]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->203451784],

Cell["Then we can write:", "Text",
 CellID->611691646],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["y", "n"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "(", 
      SubscriptBox["y", "n"], ")"}], " ", "\[Cross]", " ", 
     SuperscriptBox["\[Beta]", 
      RowBox[{"e", "(", 
       SubscriptBox["y", "n"], ")"}]]}], "=", 
    RowBox[{
     SubsuperscriptBox["y", "n", "h"], "+", 
     RowBox[{
      SubsuperscriptBox["y", "n", "l"], "\[Cross]", 
      SuperscriptBox["\[Beta]", 
       RowBox[{"e", "(", 
        SubscriptBox["\[Delta]", "n"], ")"}]]}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->1515660263],

Cell["and", "Text",
 CellID->381899537],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\[Delta]", "n"],
    TraditionalForm], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "(", 
      SubscriptBox["\[Delta]", "n"], ")"}], " ", "\[Cross]", 
     SuperscriptBox["\[Beta]", 
      RowBox[{"e", "(", 
       SubscriptBox["\[Delta]", "n"], ")"}]]}], "=", " ", 
    RowBox[{
     FormBox[
      SubsuperscriptBox["\[Delta]", "n", "h"],
      TraditionalForm], "+", "  ", 
     RowBox[{
      FormBox[
       SubsuperscriptBox["\[Delta]", "n", "l"],
       TraditionalForm], "\[Cross]", 
      SuperscriptBox["\[Beta]", 
       RowBox[{
        RowBox[{"e", "(", 
         SubscriptBox["y", "n"], ")"}], "-", "p"}]]}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->1541401221],

Cell["\<\
Aligning according to exponents these quantities can be represented \
pictorially as:\
\>", "Text",
 CellID->547454949],

Cell[BoxData[
 FormBox[
  FrameBox[GridBox[{
     {"           ", 
      RowBox[{"      ", 
       SubsuperscriptBox["y", "n", "l"], "     "}], 
      RowBox[{
       SubsuperscriptBox["y", "n", "h"], " "}]},
     {
      RowBox[{
       SubsuperscriptBox["\[Delta]", "n", "l"], " "}], 
      RowBox[{"     ", 
       SubsuperscriptBox["\[Delta]", "n", "h"], "   "}], "           "}
    },
    GridBoxDividers->{
     "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}}]], 
  TraditionalForm]], "DisplayMath",
 CellID->722918090],

Cell["\<\
where numbers on the left have a smaller scale than numbers on the right.\
\>", "Text",
 CellID->251470935],

Cell[TextData[{
 "We are interested in an efficient way of computing the quantities ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Delta]", "n", "l"], TraditionalForm]]],
 " that effectively represent the radix ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]]],
 " digits discarded due to the difference in the exponents of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "n"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    SubscriptBox["\[Delta]", "n"]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->1045681121],

Cell[CellGroupData[{

Cell["Compensated summation", "Subsection",
 CellID->1111126842],

Cell[TextData[{
 "The basic motivation for compensated summation is to simulate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "n"}], TraditionalForm]]],
 " bit addition using only ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " bit arithmetic."
}], "Text",
 CellID->949044240]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellID->1997759931],

Cell["\<\
This repeatedly adds a fixed amount to a starting value. Cumulative roundoff \
error has a significant influence on the result.\
\>", "Text",
 CellID->290663029],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"reps", " ", "=", " ", 
   SuperscriptBox["10", "6"]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"base", " ", "=", " ", "0."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"inc", " ", "=", " ", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"base", " ", "=", " ", 
     RowBox[{"base", " ", "+", " ", "inc"}]}], ",", 
    RowBox[{"{", "reps", "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"InputForm", "[", "base", "]"}]}], "Input",
 CellLabel->"In[17]:=",
 CellID->1263284158],

Cell["100000.00000133288", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]//InputForm="]
}, Open  ]],

Cell["\<\
In many applications the increment may vary and the number of operations is \
not known in advance.\
\>", "Text",
 CellID->1152780551]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithm", "Subsection",
 CellID->206000647],

Cell[TextData[{
 "Compensated summation (see for example [",
 ButtonBox["B87",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#810"],
 "] and ",
 "[",
 ButtonBox["H96",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#12862"],
 "]",
 ") computes the rounding error along with the sum so that:"
}], "Text",
 CellID->1125883869],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["y", 
    RowBox[{"n", "+", "1"}]], "=", 
   RowBox[{
    SubscriptBox["y", "n"], "+", 
    RowBox[{"h", " ", 
     RowBox[{"f", "(", 
      SubscriptBox["y", "n"], ")"}]}]}]}], TraditionalForm]], "DisplayMath",
 CellID->469590075],

Cell["is replaced by:", "Text",
 CellID->1053507463],

Cell[TextData[{
 StyleBox["Algorithm 2",
  FontWeight->"Bold"],
 " (Compensated Summation)"
}], "Text",
 CellID->699847988],

Cell[BoxData[{
 FormBox[
  RowBox[{"yerr", "=", "0"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"for", " ", "i"}], " ", "=", " ", "1"}], ",", "\[Ellipsis]", ",", 
   "N"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]y", "n"], "=", 
    RowBox[{
     RowBox[{"h", " ", 
      RowBox[{"f", "(", 
       SubscriptBox["y", "n"], ")"}]}], "+", "yerr"}]}]}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{
    SubscriptBox["y", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["y", "n"], "+", 
     SubscriptBox["\[CapitalDelta]y", "n"]}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{"yerr", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["y", "n"], "-", 
       SubscriptBox["y", 
        RowBox[{"n", "+", "1"}]]}], ")"}], " ", "+", " ", 
     SubscriptBox["\[CapitalDelta]y", "n"]}]}]}], 
  TraditionalForm]}], "DisplayMath",
 CellID->2065022201],

Cell["The algorithm is carried out componentwise for vectors.", "Text",
 CellID->862226371]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellID->1073229828],

Cell[TextData[{
 "The function ",
 StyleBox["CompensatedAdd", "MR"],
 " (in the ",
 StyleBox["Developer`", "MR"],
 " context) implements the algorithm for compensated summation."
}], "Text",
 CellID->230929586],

Cell["\<\
By repeatedly feeding back the rounding error from one sum into the next, the \
effect of rounding errors is significantly reduced.\
\>", "Text",
 CellID->2018349334],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"err", " ", "=", " ", "0."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"base", " ", "=", " ", "0."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"inc", " ", "=", " ", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"base", ",", "err"}], "}"}], " ", "=", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"Developer`CompensatedAdd", "[", 
      RowBox[{"base", " ", ",", "inc", ",", "err"}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "reps", "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"InputForm", "[", "base", "]"}]}], "Input",
 CellLabel->"In[22]:=",
 CellID->643972985],

Cell["100000.", "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]//InputForm="]
}, Open  ]],

Cell[TextData[{
 "An undocumented option ",
 StyleBox["CompensatedSummation", "MR"],
 " controls whether built-in integration methods in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " use compensated summation."
}], "Text",
 CellID->195716839]
}, Open  ]],

Cell[CellGroupData[{

Cell["An alternative algorithm", "Subsection",
 CellID->1411051980],

Cell["\<\
There are various ways that compensated summation can be used.\
\>", "Text",
 CellID->706210441],

Cell["\<\
One way is to compute the error in every addition update in the main loop in \
Algorithm 1.\
\>", "Text",
 CellID->399168624],

Cell[TextData[{
 "An alternative algorithm, which we propose because of its more general \
applicability, together with reduced arithmetic cost, is given below. The \
essential ingredients are the increments ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalDelta]P", "i"], "=", 
    RowBox[{
     SubscriptBox["P", "i"], "-", 
     SubscriptBox["p", "n"]}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalDelta]Q", "i"], "=", 
    RowBox[{
     SubscriptBox["Q", "i"], "-", 
     SubscriptBox["q", "n"]}]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->2022743626],

Cell[TextData[{
 StyleBox["Algorithm 3",
  FontWeight->"Bold"],
 " (Increment SPRK)"
}], "Text",
 CellID->74387056],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["\[CapitalDelta]P", "0"], "=", " ", "0"}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   FormBox[
    RowBox[{
     SubscriptBox["\[CapitalDelta]Q", "1"], "=", " ", "0"}],
    TraditionalForm], "\[IndentingNewLine]"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"for", " ", "i"}], " ", "=", " ", "1"}], ",", "\[Ellipsis]", ",", 
   "s"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]P", "i"], "=", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]P", 
      RowBox[{"i", "-", "1"}]], "+", " ", 
     RowBox[{
      SubscriptBox["h", 
       RowBox[{"n", "+", "1"}]], 
      SubscriptBox["b", "i"], 
      RowBox[{"f", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["q", "n"], "+", 
          SubscriptBox["\[CapitalDelta]Q", "i"]}], ",", 
         RowBox[{
          SubscriptBox["t", "n"], "+", " ", 
          RowBox[{
           SubscriptBox["C", "i"], 
           SubscriptBox["h", 
            RowBox[{"n", "+", "1"}]]}]}]}], ")"}]}]}]}]}]}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   FormBox[
    RowBox[{"\t", 
     RowBox[{
      SubscriptBox["\[CapitalDelta]Q", 
       RowBox[{"i", "+", "1"}]], "=", 
      RowBox[{
       SubscriptBox["\[CapitalDelta]Q", "i"], "+", " ", 
       RowBox[{
        SubscriptBox["h", 
         RowBox[{"n", "+", "1"}]], 
        SubscriptBox["B", "i"], 
        RowBox[{"g", "(", 
         RowBox[{
          SubscriptBox["p", "n"], "+", 
          SubscriptBox["\[CapitalDelta]P", "i"]}], ")"}]}]}]}]}],
    TraditionalForm], "\n"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"Return", " ", 
    SubscriptBox["\[CapitalDelta]p", 
     RowBox[{"n", "+", "1"}]]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalDelta]P", "s"], "and", " ", 
     SubscriptBox["\[CapitalDelta]q", 
      RowBox[{"n", "+", "1"}]]}], "=", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]Q", 
      RowBox[{"s", "+", "1"}]], "."}]}]}], TraditionalForm]}], "DisplayMath",
 CellID->781068161],

Cell[TextData[{
 "The desired values ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["p", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["p", "n"], "+", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"n", "+", "1"}]]}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["q", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["q", "n"], "+", 
     SubscriptBox["\[CapitalDelta]q", 
      RowBox[{"n", "+", "1"}]]}]}], TraditionalForm]]],
 " are obtained using compensated summation."
}], "Text",
 CellID->1416661200],

Cell["\<\
Compensated summation could also be used in every addition update in the main \
loop of Algorithm 3, but our experiments have shown that this adds a \
non-negligible overhead for a relatively small gain in accuracy.\
\>", "Text",
 CellID->621842005]
}, Open  ]],

Cell["Numerical examples", "Subsection",
 CellID->1503986252],

Cell[CellGroupData[{

Cell["Rounding error model", "Subsection",
 CellID->1668132135],

Cell[TextData[{
 "The amount of expected roundoff error in the relative error of the \
Hamiltonian for the harmonic oscillator (",
 
 CounterBox["NumberedEquation", "HarmonicOscillator"],
 ") will now be quantified. A probabilistic average case analysis is \
considered in preference to a worst case upper bound."
}], "Text",
 CellID->1667523127],

Cell[TextData[{
 "For a one-dimensional random walk with equal probability of a deviation, \
the expected absolute distance after N steps is O(",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     RowBox[{" ", "n"}]], ")"}], TraditionalForm]]],
 "."
}], "Text",
 CellID->467629446],

Cell[TextData[{
 "The relative error for a floating point operation +, -, *, /",
 " ",
 "using IEEE round to nearest mode satisfies the following bound [",
 ButtonBox["K93",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#4568"],
 "]:"
}], "Text",
 CellID->469692728],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[Epsilon]", "round"], " ", "\[LessEqual]", " ", 
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", 
    SuperscriptBox["\[Beta]", 
     RowBox[{
      RowBox[{"-", "p"}], "+", "1"}]]}], " ", "\[TildeTilde]", " ", 
   FormBox[
    RowBox[{"1.11022", "\[Cross]", 
     SuperscriptBox["10", 
      RowBox[{"-", "16"}]]}],
    TraditionalForm]}], TraditionalForm]], "DisplayMath",
 CellID->1517799410],

Cell[TextData[{
 "where the base ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Beta]", "=", "2"}], TraditionalForm]]],
 " is used for representing floating point numbers on our machine and p=53 \
for IEEE double precision."
}], "Text",
 CellID->758292475],

Cell[TextData[{
 "Therefore the roundoff error after ",
 StyleBox["n",
  FontSlant->"Italic"],
 " steps is expected to be approximately:"
}], "Text",
 CellID->1732976886],

Cell[BoxData[
 FormBox[
  RowBox[{"k", " ", "\[Epsilon]", " ", 
   SqrtBox["n"]}], TraditionalForm]], "DisplayMath",
 CellID->1527252721],

Cell[TextData[{
 "for some constant ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]]],
 "."
}], "Text",
 CellID->1911073027],

Cell[TextData[{
 "In the examples that follow a constant step size of 1/25 is used and the \
integration is performed over the interval [0, 80000] for a total of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Cross]", 
    SuperscriptBox["10", "6"]}], TraditionalForm]]],
 " integration steps. The error in the Hamiltonian is sampled every 200 \
integration steps."
}], "Text",
 CellID->1938977533],

Cell[TextData[{
 "The 8",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " order 15 stage (FSAL) method D of Yoshida is used. Similar results have \
been obtained for the 6",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " order 7 stage (FSAL) method A of Yoshida with the same number of \
integration steps and a step size of 1/160."
}], "Text",
 CellID->505652943]
}, Open  ]],

Cell[CellGroupData[{

Cell["Without compensated summation", "Subsection",
 CellID->233179454],

Cell[TextData[{
 "The relative error in the Hamiltonian is displayed below for the standard \
formulation in Algorithm 1 (green) and for the increment formulation in \
Algorithm 3 (red) for the Harmonic oscillator (",
 
 CounterBox["NumberedEquation", "HarmonicOscillator"],
 ")."
}], "Text",
 CellID->845001348],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.373189 0.00433577 0.0147151 0.00434192 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.25 Mabswid
[ ] 0 Mabsdash
.21472 .12055 m
.21472 .12543 L
s
[(0)] .20009 .08582 -1 -1 Mshowa
.40044 .12055 m
.40044 .12543 L
s
[(20000)] .33378 .08582 -1 -1 Mshowa
.58617 .12055 m
.58617 .12543 L
s
[(40000)] .51951 .08582 -1 -1 Mshowa
.7719 .12055 m
.7719 .12543 L
s
[(60000)] .70524 .08582 -1 -1 Mshowa
.95762 .12055 m
.95762 .12543 L
s
[(80000)] .89096 .08582 -1 -1 Mshowa
.125 Mabswid
.26115 .12055 m
.26115 .12348 L
s
.30759 .12055 m
.30759 .12348 L
s
.35402 .12055 m
.35402 .12348 L
s
.44688 .12055 m
.44688 .12348 L
s
.49331 .12055 m
.49331 .12348 L
s
.53974 .12055 m
.53974 .12348 L
s
.6326 .12055 m
.6326 .12348 L
s
.67903 .12055 m
.67903 .12348 L
s
.72546 .12055 m
.72546 .12348 L
s
.81833 .12055 m
.81833 .12348 L
s
.86476 .12055 m
.86476 .12348 L
s
.91119 .12055 m
.91119 .12348 L
s
.25 Mabswid
.19615 .12055 m
.97619 .12055 L
s
.19615 .13205 m
.20103 .13205 L
s
[(0)] .16364 .11984 -1 -1 Mshowa
.19615 .23782 m
.20103 .23782 L
s
[(1)] .02381 .21937 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .21937 -1 -1 Mshowa
P
[(10)] .07584 .21937 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .24216 -1 -1 Mshowa
P
.19615 .3436 m
.20103 .3436 L
s
[(2)] .02381 .32515 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .32515 -1 -1 Mshowa
P
[(10)] .07584 .32515 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .34794 -1 -1 Mshowa
P
.19615 .44938 m
.20103 .44938 L
s
[(3)] .02381 .43093 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .43093 -1 -1 Mshowa
P
[(10)] .07584 .43093 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .45373 -1 -1 Mshowa
P
.19615 .55517 m
.20103 .55517 L
s
[(4)] .02381 .53671 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .53671 -1 -1 Mshowa
P
[(10)] .07584 .53671 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .55951 -1 -1 Mshowa
P
.125 Mabswid
.19615 .1532 m
.19908 .1532 L
s
.19615 .17435 m
.19908 .17435 L
s
.19615 .19551 m
.19908 .19551 L
s
.19615 .21667 m
.19908 .21667 L
s
.19615 .25898 m
.19908 .25898 L
s
.19615 .28013 m
.19908 .28013 L
s
.19615 .3013 m
.19908 .3013 L
s
.19615 .32245 m
.19908 .32245 L
s
.19615 .36476 m
.19908 .36476 L
s
.19615 .38592 m
.19908 .38592 L
s
.19615 .40708 m
.19908 .40708 L
s
.19615 .42823 m
.19908 .42823 L
s
.19615 .47055 m
.19908 .47055 L
s
.19615 .4917 m
.19908 .4917 L
s
.19615 .51286 m
.19908 .51286 L
s
.19615 .53401 m
.19908 .53401 L
s
.19615 .57633 m
.19908 .57633 L
s
.19615 .59748 m
.19908 .59748 L
s
.25 Mabswid
.19615 .12055 m
.19615 .60332 L
s
.21472 .59843 m
.21472 .60332 L
s
.40044 .59843 m
.40044 .60332 L
s
.58617 .59843 m
.58617 .60332 L
s
.7719 .59843 m
.7719 .60332 L
s
.95762 .59843 m
.95762 .60332 L
s
.125 Mabswid
.26115 .60039 m
.26115 .60332 L
s
.30759 .60039 m
.30759 .60332 L
s
.35402 .60039 m
.35402 .60332 L
s
.44688 .60039 m
.44688 .60332 L
s
.49331 .60039 m
.49331 .60332 L
s
.53974 .60039 m
.53974 .60332 L
s
.6326 .60039 m
.6326 .60332 L
s
.67903 .60039 m
.67903 .60332 L
s
.72546 .60039 m
.72546 .60332 L
s
.81833 .60039 m
.81833 .60332 L
s
.86476 .60039 m
.86476 .60332 L
s
.91119 .60039 m
.91119 .60332 L
s
.25 Mabswid
.19615 .60332 m
.97619 .60332 L
s
.97132 .13205 m
.97619 .13205 L
s
.97132 .23782 m
.97619 .23782 L
s
.97132 .3436 m
.97619 .3436 L
s
.97132 .44938 m
.97619 .44938 L
s
.97132 .55517 m
.97619 .55517 L
s
.125 Mabswid
.97327 .1532 m
.97619 .1532 L
s
.97327 .17435 m
.97619 .17435 L
s
.97327 .19551 m
.97619 .19551 L
s
.97327 .21667 m
.97619 .21667 L
s
.97327 .25898 m
.97619 .25898 L
s
.97327 .28013 m
.97619 .28013 L
s
.97327 .3013 m
.97619 .3013 L
s
.97327 .32245 m
.97619 .32245 L
s
.97327 .36476 m
.97619 .36476 L
s
.97327 .38592 m
.97619 .38592 L
s
.97327 .40708 m
.97619 .40708 L
s
.97327 .42823 m
.97619 .42823 L
s
.97327 .47055 m
.97619 .47055 L
s
.97327 .4917 m
.97619 .4917 L
s
.97327 .51286 m
.97619 .51286 L
s
.97327 .53401 m
.97619 .53401 L
s
.97327 .57633 m
.97619 .57633 L
s
.97327 .59748 m
.97619 .59748 L
s
.25 Mabswid
.97619 .12055 m
.97619 .60332 L
s
1 0 1 0 k
1.43926 Mabswid
.21472 .13205 m
.21472 .13205 L
s
.21479 .13415 m
.21479 .13415 L
s
.21487 .13275 m
.21487 .13275 L
s
.21495 .13509 m
.21495 .13509 L
s
.21502 .13979 m
.21502 .13979 L
s
.2151 .14214 m
.2151 .14214 L
s
.21517 .13956 m
.21517 .13956 L
s
.21525 .13861 m
.21525 .13861 L
s
.21532 .14355 m
.21532 .14355 L
s
.2154 .14731 m
.2154 .14731 L
s
.21547 .14614 m
.21547 .14614 L
s
.21554 .14355 m
.21554 .14355 L
s
.21561 .14167 m
.21561 .14167 L
s
.21569 .1405 m
.21569 .1405 L
s
.21576 .14238 m
.21576 .14238 L
s
.21584 .14402 m
.21584 .14402 L
s
.21591 .13415 m
.21591 .13415 L
s
.21599 .13651 m
.21599 .13651 L
s
.21606 .14073 m
.21606 .14073 L
s
.21613 .14848 m
.21613 .14848 L
s
.21621 .14531 m
.21621 .14531 L
s
.21629 .1432 m
.21629 .1432 L
s
.21636 .15013 m
.21636 .15013 L
s
.21643 .14848 m
.21643 .14848 L
s
.21651 .14519 m
.21651 .14519 L
s
.21658 .14132 m
.21658 .14132 L
s
.21666 .13861 m
.21666 .13861 L
s
.21673 .14097 m
.21673 .14097 L
s
.21681 .14684 m
.21681 .14684 L
s
.21688 .14672 m
.21688 .14672 L
s
.21695 .14943 m
.21695 .14943 L
s
.21703 .15095 m
.21703 .15095 L
s
.21711 .15447 m
.21711 .15447 L
s
.21717 .15753 m
.21717 .15753 L
s
.21725 .1681 m
.21725 .1681 L
s
.21732 .16903 m
.21732 .16903 L
s
.2174 .16657 m
.2174 .16657 L
s
.21747 .17127 m
.21747 .17127 L
s
.21755 .17138 m
.21755 .17138 L
s
.21762 .16951 m
.21762 .16951 L
s
.21769 .17068 m
.21769 .17068 L
s
.21776 .17291 m
.21776 .17291 L
s
.21784 .16986 m
.21784 .16986 L
s
.21792 .17045 m
.21792 .17045 L
s
.21799 .16927 m
.21799 .16927 L
s
.21807 .1728 m
.21807 .1728 L
s
.21814 .17373 m
.21814 .17373 L
s
.21822 .1762 m
.21822 .1762 L
s
.21829 .18113 m
.21829 .18113 L
s
.21837 .18301 m
.21837 .18301 L
s
.21844 .18419 m
.21844 .18419 L
s
.21851 .18583 m
.21851 .18583 L
s
.21858 .1789 m
.21858 .1789 L
s
.21866 .17009 m
.21866 .17009 L
s
.21874 .17608 m
.21874 .17608 L
s
.21881 .17138 m
.21881 .17138 L
s
.21888 .16798 m
.21888 .16798 L
s
.21896 .1661 m
.21896 .1661 L
s
.21903 .16786 m
.21903 .16786 L
s
.21911 .16692 m
.21911 .16692 L
s
.21918 .17127 m
.21918 .17127 L
s
.21926 .16986 m
.21926 .16986 L
s
.21933 .1587 m
.21933 .1587 L
s
.2194 .16528 m
.2194 .16528 L
s
.21947 .16586 m
.21947 .16586 L
s
.21955 .16716 m
.21955 .16716 L
s
.21963 .16599 m
.21963 .16599 L
s
.2197 .16704 m
.2197 .16704 L
s
.21978 .16046 m
.21978 .16046 L
s
.21985 .16187 m
.21985 .16187 L
s
.21993 .16539 m
.21993 .16539 L
s
.22 .16445 m
.22 .16445 L
s
.22008 .16939 m
.22008 .16939 L
s
.22014 .16974 m
.22014 .16974 L
s
.22022 .17549 m
.22022 .17549 L
s
.22029 .17632 m
.22029 .17632 L
s
.22037 .17644 m
.22037 .17644 L
s
.22044 .17502 m
.22044 .17502 L
s
.22052 .17726 m
.22052 .17726 L
s
.22059 .17244 m
.22059 .17244 L
s
.22067 .16798 m
.22067 .16798 L
s
.22074 .16939 m
.22074 .16939 L
s
.22082 .16986 m
.22082 .16986 L
s
.22089 .16763 m
.22089 .16763 L
s
.22096 .1688 m
.22096 .1688 L
s
.22103 .16998 m
.22103 .16998 L
s
.22111 .16634 m
.22111 .16634 L
s
.22119 .16469 m
.22119 .16469 L
s
.22126 .16317 m
.22126 .16317 L
s
.22134 .16504 m
.22134 .16504 L
s
.22141 .15811 m
.22141 .15811 L
s
.22149 .16422 m
.22149 .16422 L
s
.22156 .1661 m
.22156 .1661 L
s
.22164 .16328 m
.22164 .16328 L
s
.22171 .16058 m
.22171 .16058 L
s
.22178 .15624 m
.22178 .15624 L
s
.22185 .15365 m
.22185 .15365 L
s
.22193 .15177 m
.22193 .15177 L
s
.222 .16387 m
.222 .16387 L
s
.22208 .16281 m
.22208 .16281 L
s
.22215 .1681 m
.22215 .1681 L
s
.22223 .16481 m
.22223 .16481 L
s
.2223 .16258 m
.2223 .16258 L
s
.22238 .16704 m
.22238 .16704 L
s
.22245 .16399 m
.22245 .16399 L
s
.22252 .16328 m
.22252 .16328 L
s
.22259 .15976 m
.22259 .15976 L
s
.22267 .16563 m
.22267 .16563 L
s
.22275 .16669 m
.22275 .16669 L
s
.22282 .16751 m
.22282 .16751 L
s
.2229 .15976 m
.2229 .15976 L
s
.22297 .16375 m
.22297 .16375 L
s
.22305 .16681 m
.22305 .16681 L
s
.22312 .16739 m
.22312 .16739 L
s
.2232 .16998 m
.2232 .16998 L
s
.22327 .17385 m
.22327 .17385 L
s
.22334 .18043 m
.22334 .18043 L
s
.22341 .17726 m
.22341 .17726 L
s
.22349 .1728 m
.22349 .1728 L
s
.22356 .17127 m
.22356 .17127 L
s
.22364 .17256 m
.22364 .17256 L
s
.22371 .17115 m
.22371 .17115 L
s
.22379 .16634 m
.22379 .16634 L
s
.22386 .15929 m
.22386 .15929 L
s
.22394 .15342 m
.22394 .15342 L
s
.22401 .15612 m
.22401 .15612 L
s
.22409 .15318 m
.22409 .15318 L
s
.22416 .15189 m
.22416 .15189 L
s
.22423 .14919 m
.22423 .14919 L
s
.22431 .15001 m
.22431 .15001 L
s
.22438 .15271 m
.22438 .15271 L
s
.22446 .152 m
.22446 .152 L
s
.22453 .15118 m
.22453 .15118 L
s
.22461 .15694 m
.22461 .15694 L
s
.22468 .15154 m
.22468 .15154 L
s
.22475 .1526 m
.22475 .1526 L
s
.22483 .14731 m
.22483 .14731 L
s
.22491 .14919 m
.22491 .14919 L
s
.22497 .15271 m
.22497 .15271 L
s
.22505 .15154 m
.22505 .15154 L
s
.22512 .1533 m
.22512 .1533 L
s
.2252 .15236 m
.2252 .15236 L
s
.22527 .1486 m
.22527 .1486 L
s
.22535 .14661 m
.22535 .14661 L
s
.22542 .14519 m
.22542 .14519 L
s
.22549 .14661 m
.22549 .14661 L
s
.22557 .15036 m
.22557 .15036 L
s
.22565 .1513 m
.22565 .1513 L
s
.22572 .14778 m
.22572 .14778 L
s
.22579 .15048 m
.22579 .15048 L
s
.22587 .14978 m
.22587 .14978 L
s
.22594 .14943 m
.22594 .14943 L
s
.22602 .14402 m
.22602 .14402 L
s
.22609 .14496 m
.22609 .14496 L
s
.22617 .14108 m
.22617 .14108 L
s
.22624 .14238 m
.22624 .14238 L
s
.22631 .14602 m
.22631 .14602 L
s
.22638 .14661 m
.22638 .14661 L
s
.22646 .15494 m
.22646 .15494 L
s
.22654 .14919 m
.22654 .14919 L
s
.22661 .14848 m
.22661 .14848 L
s
.22668 .14754 m
.22668 .14754 L
s
.22676 .1486 m
.22676 .1486 L
s
.22683 .15048 m
.22683 .15048 L
s
.22691 .15342 m
.22691 .15342 L
s
.22698 .14907 m
.22698 .14907 L
s
.22706 .15741 m
.22706 .15741 L
s
.22713 .15365 m
.22713 .15365 L
s
.2272 .15365 m
.2272 .15365 L
s
.22728 .15295 m
.22728 .15295 L
s
.22735 .14907 m
.22735 .14907 L
s
.22743 .15189 m
.22743 .15189 L
s
.2275 .15541 m
.2275 .15541 L
s
.22758 .15823 m
.22758 .15823 L
s
.22765 .15682 m
.22765 .15682 L
s
.22773 .16082 m
.22773 .16082 L
s
.2278 .15953 m
.2278 .15953 L
s
.22788 .15764 m
.22788 .15764 L
s
.22794 .15365 m
.22794 .15365 L
s
.22802 .15882 m
.22802 .15882 L
s
.22809 .15624 m
.22809 .15624 L
s
.22817 .15624 m
.22817 .15624 L
s
.22824 .16093 m
.22824 .16093 L
s
.22832 .15811 m
.22832 .15811 L
s
.22839 .1607 m
.22839 .1607 L
s
.22847 .15647 m
.22847 .15647 L
s
.22854 .15717 m
.22854 .15717 L
s
.22862 .158 m
.22862 .158 L
s
.22869 .16716 m
.22869 .16716 L
s
.22876 .16352 m
.22876 .16352 L
s
.22883 .16516 m
.22883 .16516 L
s
.22891 .16551 m
.22891 .16551 L
s
.22899 .16868 m
.22899 .16868 L
s
.22906 .17456 m
.22906 .17456 L
s
.22914 .17479 m
.22914 .17479 L
s
.22921 .16963 m
.22921 .16963 L
s
.22929 .16622 m
.22929 .16622 L
s
.22936 .15882 m
.22936 .15882 L
s
.22944 .16187 m
.22944 .16187 L
s
.22951 .15988 m
.22951 .15988 L
s
.22958 .16128 m
.22958 .16128 L
s
.22965 .16563 m
.22965 .16563 L
s
.22973 .16939 m
.22973 .16939 L
s
.2298 .17209 m
.2298 .17209 L
s
.22988 .17232 m
.22988 .17232 L
s
.22995 .16821 m
.22995 .16821 L
s
.23003 .17232 m
.23003 .17232 L
s
.2301 .16774 m
.2301 .16774 L
s
.23018 .16927 m
.23018 .16927 L
s
.23025 .17385 m
.23025 .17385 L
s
.23032 .17479 m
.23032 .17479 L
s
.23039 .17009 m
.23039 .17009 L
s
.23047 .16986 m
.23047 .16986 L
s
.23055 .16798 m
.23055 .16798 L
s
.23062 .17232 m
.23062 .17232 L
s
.2307 .17045 m
.2307 .17045 L
s
.23077 .17385 m
.23077 .17385 L
s
.23085 .17526 m
.23085 .17526 L
s
.23092 .17432 m
.23092 .17432 L
s
.231 .17327 m
.231 .17327 L
s
.23107 .17174 m
.23107 .17174 L
s
.23114 .17644 m
.23114 .17644 L
s
.23121 .17784 m
.23121 .17784 L
s
.23129 .17667 m
.23129 .17667 L
s
.23136 .1735 m
.23136 .1735 L
s
.23144 .17432 m
.23144 .17432 L
s
.23151 .17655 m
.23151 .17655 L
s
.23159 .17608 m
.23159 .17608 L
s
.23166 .18113 m
.23166 .18113 L
s
.23174 .17714 m
.23174 .17714 L
s
.23181 .17831 m
.23181 .17831 L
s
.23189 .17913 m
.23189 .17913 L
s
.23196 .17973 m
.23196 .17973 L
s
.23203 .17632 m
.23203 .17632 L
s
.23211 .17362 m
.23211 .17362 L
s
.23218 .17327 m
.23218 .17327 L
s
.23226 .18066 m
.23226 .18066 L
s
.23233 .1809 m
.23233 .1809 L
s
.23241 .17961 m
.23241 .17961 L
s
.23248 .17561 m
.23248 .17561 L
s
.23256 .17397 m
.23256 .17397 L
s
.23263 .17385 m
.23263 .17385 L
s
.23271 .17714 m
.23271 .17714 L
s
.23277 .17596 m
.23277 .17596 L
s
.23285 .17479 m
.23285 .17479 L
s
.23292 .17549 m
.23292 .17549 L
s
.233 .17913 m
.233 .17913 L
s
.23307 .18137 m
.23307 .18137 L
s
.23315 .18148 m
.23315 .18148 L
s
.23322 .18043 m
.23322 .18043 L
s
.23329 .18818 m
.23329 .18818 L
s
.23337 .18372 m
.23337 .18372 L
s
.23345 .17855 m
.23345 .17855 L
s
.23352 .17937 m
.23352 .17937 L
s
.23359 .18419 m
.23359 .18419 L
s
.23367 .189 m
.23367 .189 L
s
.23374 .18912 m
.23374 .18912 L
s
.23382 .18348 m
.23382 .18348 L
s
.23389 .18148 m
.23389 .18148 L
s
.23397 .17702 m
.23397 .17702 L
s
.23404 .1782 m
.23404 .1782 L
s
.23411 .18325 m
.23411 .18325 L
s
.23419 .18701 m
.23419 .18701 L
s
.23427 .1863 m
.23427 .1863 L
s
.23434 .18512 m
.23434 .18512 L
s
.23441 .17996 m
.23441 .17996 L
s
.23448 .17549 m
.23448 .17549 L
s
.23456 .17796 m
.23456 .17796 L
s
.23463 .17679 m
.23463 .17679 L
s
.23471 .17456 m
.23471 .17456 L
s
.23478 .17573 m
.23478 .17573 L
s
.23486 .17843 m
.23486 .17843 L
s
.23493 .17878 m
.23493 .17878 L
s
.235 .17761 m
.235 .17761 L
s
.23508 .18372 m
.23508 .18372 L
s
.23515 .18489 m
.23515 .18489 L
s
.23523 .1903 m
.23523 .1903 L
s
.2353 .19382 m
.2353 .19382 L
s
.23538 .19006 m
.23538 .19006 L
s
.23545 .18748 m
.23545 .18748 L
s
.23553 .18876 m
.23553 .18876 L
s
.2356 .19182 m
.2356 .19182 L
s
.23568 .18677 m
.23568 .18677 L
s
.23574 .18759 m
.23574 .18759 L
s
.23582 .18865 m
.23582 .18865 L
s
.2359 .19287 m
.2359 .19287 L
s
.23597 .19452 m
.23597 .19452 L
s
.23604 .19711 m
.23604 .19711 L
s
.23612 .20204 m
.23612 .20204 L
s
.23619 .19546 m
.23619 .19546 L
s
.23627 .1937 m
.23627 .1937 L
s
.23634 .1944 m
.23634 .1944 L
s
.23642 .18935 m
.23642 .18935 L
s
.23649 .18348 m
.23649 .18348 L
s
.23656 .17878 m
.23656 .17878 L
s
.23663 .18384 m
.23663 .18384 L
s
.23671 .18125 m
.23671 .18125 L
s
.23679 .18078 m
.23679 .18078 L
s
.23686 .18372 m
.23686 .18372 L
s
.23694 .18125 m
.23694 .18125 L
s
.23701 .18031 m
.23701 .18031 L
s
.23709 .18372 m
.23709 .18372 L
s
.23716 .17843 m
.23716 .17843 L
s
.23724 .18008 m
.23724 .18008 L
s
.23731 .17925 m
.23731 .17925 L
s
.23738 .18043 m
.23738 .18043 L
s
.23745 .17878 m
.23745 .17878 L
s
.23753 .1762 m
.23753 .1762 L
s
.2376 .17479 m
.2376 .17479 L
s
.23768 .17502 m
.23768 .17502 L
s
.23775 .17538 m
.23775 .17538 L
s
.23783 .17315 m
.23783 .17315 L
s
.2379 .1708 m
.2379 .1708 L
s
.23798 .17009 m
.23798 .17009 L
s
.23805 .1708 m
.23805 .1708 L
s
.23813 .17291 m
.23813 .17291 L
s
.23819 .16986 m
.23819 .16986 L
s
.23827 .1722 m
.23827 .1722 L
s
.23835 .1728 m
.23835 .1728 L
s
.23842 .17855 m
.23842 .17855 L
s
.2385 .17948 m
.2385 .17948 L
s
.23857 .18348 m
.23857 .18348 L
s
.23865 .17784 m
.23865 .17784 L
s
.23872 .17197 m
.23872 .17197 L
s
.2388 .16317 m
.2388 .16317 L
s
.23887 .16175 m
.23887 .16175 L
s
.23894 .15694 m
.23894 .15694 L
s
.23901 .1621 m
.23901 .1621 L
s
.23909 .15976 m
.23909 .15976 L
s
.23916 .15694 m
.23916 .15694 L
s
.23924 .15905 m
.23924 .15905 L
s
.23931 .15953 m
.23931 .15953 L
s
.23939 .16164 m
.23939 .16164 L
s
.23946 .15612 m
.23946 .15612 L
s
.23954 .15682 m
.23954 .15682 L
s
.23961 .16305 m
.23961 .16305 L
s
.23969 .15717 m
.23969 .15717 L
s
.23976 .15905 m
.23976 .15905 L
s
.23983 .15671 m
.23983 .15671 L
s
.23991 .15835 m
.23991 .15835 L
s
.23998 .16035 m
.23998 .16035 L
s
.24006 .1661 m
.24006 .1661 L
s
.24013 .16622 m
.24013 .16622 L
s
.24021 .16469 m
.24021 .16469 L
s
.24028 .16187 m
.24028 .16187 L
s
.24036 .17103 m
.24036 .17103 L
s
.24043 .16634 m
.24043 .16634 L
s
.24051 .16892 m
.24051 .16892 L
s
.24057 .16856 m
.24057 .16856 L
s
.24065 .16599 m
.24065 .16599 L
s
.24072 .16927 m
.24072 .16927 L
s
.2408 .17021 m
.2408 .17021 L
s
.24087 .17479 m
.24087 .17479 L
s
.24095 .1722 m
.24095 .1722 L
s
.24102 .16599 m
.24102 .16599 L
s
.2411 .16399 m
.2411 .16399 L
s
.24117 .17127 m
.24117 .17127 L
s
.24125 .16998 m
.24125 .16998 L
s
.24132 .17773 m
.24132 .17773 L
s
.24139 .17843 m
.24139 .17843 L
s
.24147 .1708 m
.24147 .1708 L
s
.24154 .17573 m
.24154 .17573 L
s
.24162 .17327 m
.24162 .17327 L
s
.24169 .17197 m
.24169 .17197 L
s
.24177 .1735 m
.24177 .1735 L
s
.24184 .1735 m
.24184 .1735 L
s
.24191 .17103 m
.24191 .17103 L
s
.24199 .17491 m
.24199 .17491 L
s
.24207 .17244 m
.24207 .17244 L
s
.24214 .17092 m
.24214 .17092 L
s
.24221 .16986 m
.24221 .16986 L
s
.24228 .16058 m
.24228 .16058 L
s
.24236 .16281 m
.24236 .16281 L
s
.24243 .15835 m
.24243 .15835 L
s
.24251 .15717 m
.24251 .15717 L
s
.24258 .15941 m
.24258 .15941 L
s
.24266 .16117 m
.24266 .16117 L
s
.24273 .15964 m
.24273 .15964 L
s
.24281 .16023 m
.24281 .16023 L
s
.24288 .15529 m
.24288 .15529 L
s
.24296 .15506 m
.24296 .15506 L
s
.24303 .1621 m
.24303 .1621 L
s
.2431 .16469 m
.2431 .16469 L
s
.24318 .1614 m
.24318 .1614 L
s
.24325 .15976 m
.24325 .15976 L
s
.24333 .15517 m
.24333 .15517 L
s
.2434 .15753 m
.2434 .15753 L
s
.24348 .15377 m
.24348 .15377 L
s
.24354 .15471 m
.24354 .15471 L
s
.24362 .1526 m
.24362 .1526 L
s
.2437 .14872 m
.2437 .14872 L
s
.24377 .14684 m
.24377 .14684 L
s
.24384 .14308 m
.24384 .14308 L
s
.24392 .13933 m
.24392 .13933 L
s
.24399 .13791 m
.24399 .13791 L
s
.24407 .14273 m
.24407 .14273 L
s
.24414 .14343 m
.24414 .14343 L
s
.24422 .14402 m
.24422 .14402 L
s
.24429 .15729 m
.24429 .15729 L
s
.24436 .16305 m
.24436 .16305 L
s
.24444 .16856 m
.24444 .16856 L
s
.24452 .16222 m
.24452 .16222 L
s
.24459 .16258 m
.24459 .16258 L
s
.24466 .16798 m
.24466 .16798 L
s
.24474 .16939 m
.24474 .16939 L
s
.24481 .17068 m
.24481 .17068 L
s
.24489 .16375 m
.24489 .16375 L
s
.24496 .16317 m
.24496 .16317 L
s
.24504 .16457 m
.24504 .16457 L
s
.24511 .16915 m
.24511 .16915 L
s
.24518 .16504 m
.24518 .16504 L
s
.24525 .16246 m
.24525 .16246 L
s
.24533 .16093 m
.24533 .16093 L
s
.2454 .1614 m
.2454 .1614 L
s
.24548 .1614 m
.24548 .1614 L
s
.24555 .16117 m
.24555 .16117 L
s
.24563 .15706 m
.24563 .15706 L
s
.2457 .15858 m
.2457 .15858 L
s
.24578 .15753 m
.24578 .15753 L
s
.24585 .16234 m
.24585 .16234 L
s
.24593 .16516 m
.24593 .16516 L
s
.24599 .17056 m
.24599 .17056 L
s
.24607 .17855 m
.24607 .17855 L
s
.24615 .17456 m
.24615 .17456 L
s
.24622 .17549 m
.24622 .17549 L
s
.2463 .17362 m
.2463 .17362 L
s
.24637 .17573 m
.24637 .17573 L
s
.24645 .1715 m
.24645 .1715 L
s
.24652 .17467 m
.24652 .17467 L
s
.2466 .17185 m
.2466 .17185 L
s
.24667 .17362 m
.24667 .17362 L
s
.24674 .17256 m
.24674 .17256 L
s
.24681 .16892 m
.24681 .16892 L
s
.24689 .16774 m
.24689 .16774 L
s
.24696 .17103 m
.24696 .17103 L
s
.24704 .17502 m
.24704 .17502 L
s
.24711 .17549 m
.24711 .17549 L
s
.24719 .18078 m
.24719 .18078 L
s
.24726 .17667 m
.24726 .17667 L
s
.24734 .17444 m
.24734 .17444 L
s
.24741 .17103 m
.24741 .17103 L
s
.24749 .17009 m
.24749 .17009 L
s
.24756 .17385 m
.24756 .17385 L
s
.24763 .17467 m
.24763 .17467 L
s
.24771 .17691 m
.24771 .17691 L
s
.24778 .17479 m
.24778 .17479 L
s
.24786 .17033 m
.24786 .17033 L
s
.24793 .16551 m
.24793 .16551 L
s
.24801 .16187 m
.24801 .16187 L
s
.24808 .15905 m
.24808 .15905 L
s
.24816 .15917 m
.24816 .15917 L
s
.24823 .15917 m
.24823 .15917 L
s
.24831 .16293 m
.24831 .16293 L
s
.24837 .15471 m
.24837 .15471 L
s
.24845 .15154 m
.24845 .15154 L
s
.24852 .15424 m
.24852 .15424 L
s
.2486 .15389 m
.2486 .15389 L
s
.24867 .14966 m
.24867 .14966 L
s
.24875 .14637 m
.24875 .14637 L
s
.24882 .14437 m
.24882 .14437 L
s
.2489 .1405 m
.2489 .1405 L
s
.24897 .13615 m
.24897 .13615 L
s
.24905 .14015 m
.24905 .14015 L
s
.24912 .14202 m
.24912 .14202 L
s
.24919 .13686 m
.24919 .13686 L
s
.24927 .13333 m
.24927 .13333 L
s
.24934 .14437 m
.24934 .14437 L
s
.24942 .14543 m
.24942 .14543 L
s
.24949 .14637 m
.24949 .14637 L
s
.24957 .1425 m
.24957 .1425 L
s
.24964 .13886 m
.24964 .13886 L
s
.24972 .14355 m
.24972 .14355 L
s
.24979 .14085 m
.24979 .14085 L
s
.24987 .14202 m
.24987 .14202 L
s
.24994 .14531 m
.24994 .14531 L
s
.25001 .14579 m
.25001 .14579 L
s
.25008 .14919 m
.25008 .14919 L
s
.25016 .14614 m
.25016 .14614 L
s
.25023 .14661 m
.25023 .14661 L
s
.25031 .14425 m
.25031 .14425 L
s
.25038 .14684 m
.25038 .14684 L
s
.25046 .14179 m
.25046 .14179 L
s
.25053 .13733 m
.25053 .13733 L
s
.25061 .13733 m
.25061 .13733 L
s
.25068 .14143 m
.25068 .14143 L
s
.25076 .13803 m
.25076 .13803 L
s
.25083 .13651 m
.25083 .13651 L
s
.2509 .13838 m
.2509 .13838 L
s
.25098 .13909 m
.25098 .13909 L
s
.25105 .1419 m
.25105 .1419 L
s
.25113 .14449 m
.25113 .14449 L
s
.2512 .14226 m
.2512 .14226 L
s
.25128 .13933 m
.25128 .13933 L
s
.25135 .13803 m
.25135 .13803 L
s
.25143 .13462 m
.25143 .13462 L
s
.2515 .13228 m
.2515 .13228 L
s
.25157 .13251 m
.25157 .13251 L
s
.25164 .1412 m
.25164 .1412 L
s
.25172 .14472 m
.25172 .14472 L
s
.25179 .14355 m
.25179 .14355 L
s
.25187 .13838 m
.25187 .13838 L
s
.25194 .13439 m
.25194 .13439 L
s
.25202 .13298 m
.25202 .13298 L
s
.25209 .13627 m
.25209 .13627 L
s
.25216 .13768 m
.25216 .13768 L
s
.25224 .13604 m
.25224 .13604 L
s
.25232 .13933 m
.25232 .13933 L
s
.25239 .13533 m
.25239 .13533 L
s
.25246 .13415 m
.25246 .13415 L
s
.25254 .13275 m
.25254 .13275 L
s
.25261 .13733 m
.25261 .13733 L
s
.25269 .13991 m
.25269 .13991 L
s
.25276 .14073 m
.25276 .14073 L
s
.25284 .14519 m
.25284 .14519 L
s
.25291 .13674 m
.25291 .13674 L
s
.25298 .13439 m
.25298 .13439 L
s
.25306 .13462 m
.25306 .13462 L
s
.25313 .13392 m
.25313 .13392 L
s
.2532 .13768 m
.2532 .13768 L
s
.25328 .13533 m
.25328 .13533 L
s
.25335 .13439 m
.25335 .13439 L
s
.25343 .13744 m
.25343 .13744 L
s
.2535 .13439 m
.2535 .13439 L
s
.25358 .13557 m
.25358 .13557 L
s
.25365 .14238 m
.25365 .14238 L
s
.25373 .1419 m
.25373 .1419 L
s
.25379 .13861 m
.25379 .13861 L
s
.25387 .14167 m
.25387 .14167 L
s
.25395 .13886 m
.25395 .13886 L
s
.25402 .13486 m
.25402 .13486 L
s
.2541 .13251 m
.2541 .13251 L
s
.25417 .13838 m
.25417 .13838 L
s
.25425 .13744 m
.25425 .13744 L
s
.25432 .13627 m
.25432 .13627 L
s
.2544 .13815 m
.2544 .13815 L
s
.25447 .13979 m
.25447 .13979 L
s
.25454 .13744 m
.25454 .13744 L
s
.25461 .13815 m
.25461 .13815 L
s
.25469 .13838 m
.25469 .13838 L
s
.25477 .13909 m
.25477 .13909 L
s
.25484 .14519 m
.25484 .14519 L
s
.25491 .14496 m
.25491 .14496 L
s
.25499 .14825 m
.25499 .14825 L
s
.25506 .14379 m
.25506 .14379 L
s
.25514 .15412 m
.25514 .15412 L
s
.25521 .156 m
.25521 .156 L
s
.25529 .15224 m
.25529 .15224 L
s
.25536 .15036 m
.25536 .15036 L
s
.25543 .14637 m
.25543 .14637 L
s
.25551 .14731 m
.25551 .14731 L
s
.25558 .1419 m
.25558 .1419 L
s
.25566 .13721 m
.25566 .13721 L
s
.25573 .13439 m
.25573 .13439 L
s
.25581 .13651 m
.25581 .13651 L
s
.25588 .13345 m
.25588 .13345 L
s
.25596 .14073 m
.25596 .14073 L
s
.25603 .14332 m
.25603 .14332 L
s
.25611 .14684 m
.25611 .14684 L
s
.25617 .14919 m
.25617 .14919 L
s
.25625 .14872 m
.25625 .14872 L
s
.25632 .14825 m
.25632 .14825 L
s
.2564 .14449 m
.2564 .14449 L
s
.25647 .14472 m
.25647 .14472 L
s
.25655 .14285 m
.25655 .14285 L
s
.25662 .13486 m
.25662 .13486 L
s
.2567 .13462 m
.2567 .13462 L
s
.25677 .14073 m
.25677 .14073 L
s
.25685 .14297 m
.25685 .14297 L
s
.25692 .13921 m
.25692 .13921 L
s
.25699 .14085 m
.25699 .14085 L
s
.25707 .13791 m
.25707 .13791 L
s
.25714 .1358 m
.25714 .1358 L
s
.25722 .13604 m
.25722 .13604 L
s
.25729 .13968 m
.25729 .13968 L
s
.25737 .14261 m
.25737 .14261 L
s
.25744 .14179 m
.25744 .14179 L
s
.25752 .13604 m
.25752 .13604 L
s
.25759 .13228 m
.25759 .13228 L
s
.25767 .13474 m
.25767 .13474 L
s
.25774 .13756 m
.25774 .13756 L
s
.25781 .13521 m
.25781 .13521 L
s
.25788 .13275 m
.25788 .13275 L
s
.25796 .13779 m
.25796 .13779 L
s
.25803 .13921 m
.25803 .13921 L
s
.25811 .13497 m
.25811 .13497 L
s
.25818 .13803 m
.25818 .13803 L
s
.25826 .13497 m
.25826 .13497 L
s
.25833 .13979 m
.25833 .13979 L
s
.25841 .13968 m
.25841 .13968 L
s
.25848 .13933 m
.25848 .13933 L
s
.25856 .13721 m
.25856 .13721 L
s
.25863 .13968 m
.25863 .13968 L
s
.2587 .13791 m
.2587 .13791 L
s
.25878 .13345 m
.25878 .13345 L
s
.25885 .13886 m
.25885 .13886 L
s
.25893 .14143 m
.25893 .14143 L
s
.259 .15013 m
.259 .15013 L
s
.25908 .14731 m
.25908 .14731 L
s
.25915 .15224 m
.25915 .15224 L
s
.25923 .15013 m
.25923 .15013 L
s
.2593 .15506 m
.2593 .15506 L
s
.25937 .15435 m
.25937 .15435 L
s
.25944 .15154 m
.25944 .15154 L
s
.25952 .15412 m
.25952 .15412 L
s
.25959 .15858 m
.25959 .15858 L
s
.25967 .15248 m
.25967 .15248 L
s
.25974 .15671 m
.25974 .15671 L
s
.25982 .15318 m
.25982 .15318 L
s
.25989 .15083 m
.25989 .15083 L
s
.25997 .14707 m
.25997 .14707 L
s
.26004 .1405 m
.26004 .1405 L
s
.26012 .13744 m
.26012 .13744 L
s
.26019 .13298 m
.26019 .13298 L
s
.26026 .13545 m
.26026 .13545 L
s
.26034 .13592 m
.26034 .13592 L
s
.26041 .13651 m
.26041 .13651 L
s
.26049 .1385 m
.26049 .1385 L
s
.26056 .14026 m
.26056 .14026 L
s
.26064 .14507 m
.26064 .14507 L
s
.26071 .14202 m
.26071 .14202 L
s
.26078 .14696 m
.26078 .14696 L
s
.26086 .14848 m
.26086 .14848 L
s
.26094 .14754 m
.26094 .14754 L
s
.261 .14167 m
.261 .14167 L
s
.26108 .13651 m
.26108 .13651 L
s
.26115 .14202 m
.26115 .14202 L
s
.26123 .13651 m
.26123 .13651 L
s
.2613 .13768 m
.2613 .13768 L
s
.26138 .14097 m
.26138 .14097 L
s
.26145 .1405 m
.26145 .1405 L
s
.26153 .13486 m
.26153 .13486 L
s
.2616 .13369 m
.2616 .13369 L
s
.26167 .13909 m
.26167 .13909 L
s
.26175 .13815 m
.26175 .13815 L
s
.26182 .14026 m
.26182 .14026 L
s
.2619 .14308 m
.2619 .14308 L
s
.26197 .14202 m
.26197 .14202 L
s
.26205 .14297 m
.26205 .14297 L
s
.26212 .14707 m
.26212 .14707 L
s
.2622 .14696 m
.2622 .14696 L
s
.26227 .14425 m
.26227 .14425 L
s
.26234 .14402 m
.26234 .14402 L
s
.26241 .13486 m
.26241 .13486 L
s
.26249 .13392 m
.26249 .13392 L
s
.26257 .13275 m
.26257 .13275 L
s
.26264 .13345 m
.26264 .13345 L
s
.26271 .13944 m
.26271 .13944 L
s
.26279 .14073 m
.26279 .14073 L
s
.26286 .14003 m
.26286 .14003 L
s
.26294 .14379 m
.26294 .14379 L
s
.26301 .14778 m
.26301 .14778 L
s
.26309 .15271 m
.26309 .15271 L
s
.26316 .15377 m
.26316 .15377 L
s
.26323 .15988 m
.26323 .15988 L
s
.26331 .15612 m
.26331 .15612 L
s
.26338 .15189 m
.26338 .15189 L
s
.26346 .14872 m
.26346 .14872 L
s
.26353 .14579 m
.26353 .14579 L
s
.26361 .15189 m
.26361 .15189 L
s
.26368 .15295 m
.26368 .15295 L
s
.26376 .15823 m
.26376 .15823 L
s
.26383 .15553 m
.26383 .15553 L
s
.26391 .15377 m
.26391 .15377 L
s
.26397 .14731 m
.26397 .14731 L
s
.26405 .14836 m
.26405 .14836 L
s
.26412 .14379 m
.26412 .14379 L
s
.2642 .14367 m
.2642 .14367 L
s
.26427 .14719 m
.26427 .14719 L
s
.26435 .15001 m
.26435 .15001 L
s
.26442 .1425 m
.26442 .1425 L
s
.2645 .13815 m
.2645 .13815 L
s
.26457 .13721 m
.26457 .13721 L
s
.26465 .13345 m
.26465 .13345 L
s
.26472 .13615 m
.26472 .13615 L
s
.26479 .13956 m
.26479 .13956 L
s
.26487 .1338 m
.26487 .1338 L
s
.26494 .13251 m
.26494 .13251 L
s
.26502 .13392 m
.26502 .13392 L
s
.26509 .13427 m
.26509 .13427 L
s
.26517 .13333 m
.26517 .13333 L
s
.26524 .13404 m
.26524 .13404 L
s
.26532 .1358 m
.26532 .1358 L
s
.26539 .13404 m
.26539 .13404 L
s
.26547 .13509 m
.26547 .13509 L
s
.26554 .13533 m
.26554 .13533 L
s
.26561 .13216 m
.26561 .13216 L
s
.26568 .13298 m
.26568 .13298 L
s
.26576 .13791 m
.26576 .13791 L
s
.26583 .13979 m
.26583 .13979 L
s
.26591 .14402 m
.26591 .14402 L
s
.26598 .13462 m
.26598 .13462 L
s
.26606 .13627 m
.26606 .13627 L
s
.26613 .13651 m
.26613 .13651 L
s
.26621 .13275 m
.26621 .13275 L
s
.26628 .13604 m
.26628 .13604 L
s
.26636 .13627 m
.26636 .13627 L
s
.26643 .13662 m
.26643 .13662 L
s
.2665 .13557 m
.2665 .13557 L
s
.26658 .13486 m
.26658 .13486 L
s
.26665 .13521 m
.26665 .13521 L
s
.26673 .13815 m
.26673 .13815 L
s
.2668 .13733 m
.2668 .13733 L
s
.26688 .13897 m
.26688 .13897 L
s
.26695 .13886 m
.26695 .13886 L
s
.26703 .1419 m
.26703 .1419 L
s
.2671 .14097 m
.2671 .14097 L
s
.26717 .14073 m
.26717 .14073 L
s
.26724 .14273 m
.26724 .14273 L
s
.26732 .14543 m
.26732 .14543 L
s
.26739 .14285 m
.26739 .14285 L
s
.26747 .13744 m
.26747 .13744 L
s
.26754 .14449 m
.26754 .14449 L
s
.26762 .14989 m
.26762 .14989 L
s
.26769 .14308 m
.26769 .14308 L
s
.26777 .14167 m
.26777 .14167 L
s
.26784 .14614 m
.26784 .14614 L
s
.26792 .14519 m
.26792 .14519 L
s
.26799 .14379 m
.26799 .14379 L
s
.26806 .14132 m
.26806 .14132 L
s
.26814 .14061 m
.26814 .14061 L
s
.26821 .14073 m
.26821 .14073 L
s
.26829 .1358 m
.26829 .1358 L
s
.26836 .13486 m
.26836 .13486 L
s
.26844 .13604 m
.26844 .13604 L
s
.26851 .13439 m
.26851 .13439 L
s
.26858 .13392 m
.26858 .13392 L
s
.26866 .13415 m
.26866 .13415 L
s
.26874 .13251 m
.26874 .13251 L
s
.2688 .13533 m
.2688 .13533 L
s
.26888 .13674 m
.26888 .13674 L
s
.26895 .13944 m
.26895 .13944 L
s
.26903 .13263 m
.26903 .13263 L
s
.2691 .1412 m
.2691 .1412 L
s
.26918 .1419 m
.26918 .1419 L
s
.26925 .13861 m
.26925 .13861 L
s
.26933 .13486 m
.26933 .13486 L
s
.2694 .13557 m
.2694 .13557 L
s
.26948 .13815 m
.26948 .13815 L
s
.26956 .13298 m
.26956 .13298 L
s
.26962 .13439 m
.26962 .13439 L
s
.2697 .13439 m
.2697 .13439 L
s
.26977 .13956 m
.26977 .13956 L
s
.26985 .13298 m
.26985 .13298 L
s
.26992 .13474 m
.26992 .13474 L
s
.27 .1358 m
.27 .1358 L
s
.27007 .13216 m
.27007 .13216 L
s
.27014 .13627 m
.27014 .13627 L
s
.27021 .13721 m
.27021 .13721 L
s
.27029 .13933 m
.27029 .13933 L
s
.27037 .13345 m
.27037 .13345 L
s
.27044 .13886 m
.27044 .13886 L
s
.27051 .13838 m
.27051 .13838 L
s
.27059 .1513 m
.27059 .1513 L
s
.27066 .14543 m
.27066 .14543 L
s
.27074 .14261 m
.27074 .14261 L
s
.27081 .14567 m
.27081 .14567 L
s
.27089 .14567 m
.27089 .14567 L
s
.27096 .14238 m
.27096 .14238 L
s
.27103 .14073 m
.27103 .14073 L
s
.27111 .13768 m
.27111 .13768 L
s
.27119 .1419 m
.27119 .1419 L
s
.27126 .13791 m
.27126 .13791 L
s
.27133 .13275 m
.27133 .13275 L
s
.27141 .13509 m
.27141 .13509 L
s
.27148 .13521 m
.27148 .13521 L
s
.27156 .13228 m
.27156 .13228 L
s
.27163 .13216 m
.27163 .13216 L
s
.27171 .13205 m
.27171 .13205 L
s
.27177 .13651 m
.27177 .13651 L
s
.27185 .1405 m
.27185 .1405 L
s
.27192 .14872 m
.27192 .14872 L
s
.272 .15295 m
.272 .15295 L
s
.27207 .16023 m
.27207 .16023 L
s
.27215 .16187 m
.27215 .16187 L
s
.27222 .16704 m
.27222 .16704 L
s
.2723 .16774 m
.2723 .16774 L
s
.27237 .17596 m
.27237 .17596 L
s
.27245 .17878 m
.27245 .17878 L
s
.27252 .17925 m
.27252 .17925 L
s
.27259 .17761 m
.27259 .17761 L
s
.27267 .17973 m
.27267 .17973 L
s
.27274 .17714 m
.27274 .17714 L
s
.27282 .17925 m
.27282 .17925 L
s
.27289 .18137 m
.27289 .18137 L
s
.27297 .17831 m
.27297 .17831 L
s
.27304 .17761 m
.27304 .17761 L
s
.27312 .17127 m
.27312 .17127 L
s
.27319 .16915 m
.27319 .16915 L
s
.27327 .17362 m
.27327 .17362 L
s
.27334 .16892 m
.27334 .16892 L
s
.27341 .17174 m
.27341 .17174 L
s
.27348 .17948 m
.27348 .17948 L
s
.27356 .17973 m
.27356 .17973 L
s
.27363 .17902 m
.27363 .17902 L
s
.27371 .17738 m
.27371 .17738 L
s
.27378 .17784 m
.27378 .17784 L
s
.27386 .17691 m
.27386 .17691 L
s
.27393 .17784 m
.27393 .17784 L
s
.27401 .18395 m
.27401 .18395 L
s
.27408 .18395 m
.27408 .18395 L
s
.27416 .18277 m
.27416 .18277 L
s
.27423 .17948 m
.27423 .17948 L
s
.2743 .17902 m
.2743 .17902 L
s
.27438 .17855 m
.27438 .17855 L
s
.27445 .17973 m
.27445 .17973 L
s
.27453 .18066 m
.27453 .18066 L
s
.2746 .17925 m
.2746 .17925 L
s
.27468 .17479 m
.27468 .17479 L
s
.27475 .17338 m
.27475 .17338 L
s
.27483 .16915 m
.27483 .16915 L
s
.2749 .16399 m
.2749 .16399 L
s
.27497 .16422 m
.27497 .16422 L
s
.27504 .15905 m
.27504 .15905 L
s
.27512 .16093 m
.27512 .16093 L
s
.27519 .15929 m
.27519 .15929 L
s
.27527 .15647 m
.27527 .15647 L
s
.27534 .15858 m
.27534 .15858 L
s
.27542 .16375 m
.27542 .16375 L
s
.27549 .16234 m
.27549 .16234 L
s
.27557 .16375 m
.27557 .16375 L
s
.27564 .16187 m
.27564 .16187 L
s
.27572 .1621 m
.27572 .1621 L
s
.27579 .15788 m
.27579 .15788 L
s
.27586 .156 m
.27586 .156 L
s
.27594 .15248 m
.27594 .15248 L
s
.27601 .15929 m
.27601 .15929 L
s
.27609 .15811 m
.27609 .15811 L
s
.27616 .156 m
.27616 .156 L
s
.27624 .15717 m
.27624 .15717 L
s
.27631 .15811 m
.27631 .15811 L
s
.27639 .16234 m
.27639 .16234 L
s
.27646 .16375 m
.27646 .16375 L
s
.27654 .15953 m
.27654 .15953 L
s
.2766 .16727 m
.2766 .16727 L
s
.27668 .17596 m
.27668 .17596 L
s
.27675 .1762 m
.27675 .1762 L
s
.27683 .18254 m
.27683 .18254 L
s
.2769 .18372 m
.2769 .18372 L
s
.27698 .18207 m
.27698 .18207 L
s
.27705 .18301 m
.27705 .18301 L
s
.27713 .18325 m
.27713 .18325 L
s
.2772 .18771 m
.2772 .18771 L
s
.27728 .18865 m
.27728 .18865 L
s
.27736 .19569 m
.27736 .19569 L
s
.27742 .19476 m
.27742 .19476 L
s
.2775 .19405 m
.2775 .19405 L
s
.27757 .19358 m
.27757 .19358 L
s
.27765 .191 m
.27765 .191 L
s
.27772 .18559 m
.27772 .18559 L
s
.2778 .18748 m
.2778 .18748 L
s
.27787 .18912 m
.27787 .18912 L
s
.27794 .19287 m
.27794 .19287 L
s
.27802 .19429 m
.27802 .19429 L
s
.2781 .2011 m
.2781 .2011 L
s
.27817 .20063 m
.27817 .20063 L
s
.27824 .19804 m
.27824 .19804 L
s
.27831 .19311 m
.27831 .19311 L
s
.27839 .19452 m
.27839 .19452 L
s
.27846 .19452 m
.27846 .19452 L
s
.27854 .19546 m
.27854 .19546 L
s
.27861 .1964 m
.27861 .1964 L
s
.27869 .19311 m
.27869 .19311 L
s
.27876 .19287 m
.27876 .19287 L
s
.27883 .19264 m
.27883 .19264 L
s
.27891 .1863 m
.27891 .1863 L
s
.27899 .1863 m
.27899 .1863 L
s
.27906 .18748 m
.27906 .18748 L
s
.27913 .18512 m
.27913 .18512 L
s
.27921 .18841 m
.27921 .18841 L
s
.27928 .18724 m
.27928 .18724 L
s
.27936 .18748 m
.27936 .18748 L
s
.27943 .19311 m
.27943 .19311 L
s
.27951 .18606 m
.27951 .18606 L
s
.27957 .19287 m
.27957 .19287 L
s
.27965 .19194 m
.27965 .19194 L
s
.27973 .19358 m
.27973 .19358 L
s
.2798 .19217 m
.2798 .19217 L
s
.27987 .1924 m
.27987 .1924 L
s
.27995 .1917 m
.27995 .1917 L
s
.28002 .18701 m
.28002 .18701 L
s
.2801 .18301 m
.2801 .18301 L
s
.28017 .17784 m
.28017 .17784 L
s
.28025 .17244 m
.28025 .17244 L
s
.28032 .17197 m
.28032 .17197 L
s
.28039 .17056 m
.28039 .17056 L
s
.28047 .17056 m
.28047 .17056 L
s
.28054 .17338 m
.28054 .17338 L
s
.28062 .17056 m
.28062 .17056 L
s
.28069 .17973 m
.28069 .17973 L
s
.28077 .17761 m
.28077 .17761 L
s
.28084 .17831 m
.28084 .17831 L
s
.28092 .1802 m
.28092 .1802 L
s
.28099 .18559 m
.28099 .18559 L
s
.28107 .18277 m
.28107 .18277 L
s
.28114 .18466 m
.28114 .18466 L
s
.28121 .18512 m
.28121 .18512 L
s
.28128 .18536 m
.28128 .18536 L
s
.28136 .17902 m
.28136 .17902 L
s
.28144 .17573 m
.28144 .17573 L
s
.28151 .17573 m
.28151 .17573 L
s
.28158 .17573 m
.28158 .17573 L
s
.28166 .1762 m
.28166 .1762 L
s
.28173 .17644 m
.28173 .17644 L
s
.28181 .17925 m
.28181 .17925 L
s
.28188 .17925 m
.28188 .17925 L
s
.28196 .1816 m
.28196 .1816 L
s
.28203 .18277 m
.28203 .18277 L
s
.2821 .18184 m
.2821 .18184 L
s
.28218 .18043 m
.28218 .18043 L
s
.28225 .18489 m
.28225 .18489 L
s
.28233 .18606 m
.28233 .18606 L
s
.2824 .18724 m
.2824 .18724 L
s
.28248 .18254 m
.28248 .18254 L
s
.28255 .17808 m
.28255 .17808 L
s
.28263 .1762 m
.28263 .1762 L
s
.2827 .17573 m
.2827 .17573 L
s
.28277 .17244 m
.28277 .17244 L
s
.28284 .17315 m
.28284 .17315 L
s
.28292 .16727 m
.28292 .16727 L
s
.28299 .16492 m
.28299 .16492 L
s
.28307 .1722 m
.28307 .1722 L
s
.28314 .17714 m
.28314 .17714 L
s
.28322 .18066 m
.28322 .18066 L
s
.28329 .18207 m
.28329 .18207 L
s
.28337 .17456 m
.28337 .17456 L
s
.28344 .17738 m
.28344 .17738 L
s
.28352 .1762 m
.28352 .1762 L
s
.28359 .18301 m
.28359 .18301 L
s
.28366 .17714 m
.28366 .17714 L
s
.28374 .1715 m
.28374 .1715 L
s
.28381 .16915 m
.28381 .16915 L
s
.28389 .16915 m
.28389 .16915 L
s
.28396 .16963 m
.28396 .16963 L
s
.28404 .1722 m
.28404 .1722 L
s
.28411 .16821 m
.28411 .16821 L
s
.28419 .17596 m
.28419 .17596 L
s
.28426 .17784 m
.28426 .17784 L
s
.28434 .18372 m
.28434 .18372 L
s
.28441 .18395 m
.28441 .18395 L
s
.28448 .17878 m
.28448 .17878 L
s
.28455 .17526 m
.28455 .17526 L
s
.28463 .17549 m
.28463 .17549 L
s
.2847 .1809 m
.2847 .1809 L
s
.28478 .18137 m
.28478 .18137 L
s
.28485 .18419 m
.28485 .18419 L
s
.28493 .18888 m
.28493 .18888 L
s
.285 .191 m
.285 .191 L
s
.28508 .19217 m
.28508 .19217 L
s
.28516 .1964 m
.28516 .1964 L
s
.28522 .19593 m
.28522 .19593 L
s
.2853 .19287 m
.2853 .19287 L
s
.28537 .19499 m
.28537 .19499 L
s
.28545 .19006 m
.28545 .19006 L
s
.28552 .19123 m
.28552 .19123 L
s
.2856 .1924 m
.2856 .1924 L
s
.28567 .18559 m
.28567 .18559 L
s
.28574 .1863 m
.28574 .1863 L
s
.28582 .18748 m
.28582 .18748 L
s
.2859 .1802 m
.2859 .1802 L
s
.28597 .17549 m
.28597 .17549 L
s
.28604 .16539 m
.28604 .16539 L
s
.28611 .16352 m
.28611 .16352 L
s
.28619 .15835 m
.28619 .15835 L
s
.28626 .16422 m
.28626 .16422 L
s
.28634 .1661 m
.28634 .1661 L
s
.28641 .16774 m
.28641 .16774 L
s
.28649 .16516 m
.28649 .16516 L
s
.28656 .16751 m
.28656 .16751 L
s
.28664 .17362 m
.28664 .17362 L
s
.28672 .17573 m
.28672 .17573 L
s
.28679 .18043 m
.28679 .18043 L
s
.28686 .17738 m
.28686 .17738 L
s
.28693 .18372 m
.28693 .18372 L
s
.28701 .18724 m
.28701 .18724 L
s
.28708 .18137 m
.28708 .18137 L
s
.28716 .18137 m
.28716 .18137 L
s
.28723 .17855 m
.28723 .17855 L
s
.28731 .18442 m
.28731 .18442 L
s
.28738 .18771 m
.28738 .18771 L
s
.28745 .18113 m
.28745 .18113 L
s
.28753 .1816 m
.28753 .1816 L
s
.2876 .18419 m
.2876 .18419 L
s
.28767 .18865 m
.28767 .18865 L
s
.28775 .18888 m
.28775 .18888 L
s
.28782 .18865 m
.28782 .18865 L
s
.2879 .19194 m
.2879 .19194 L
s
.28797 .19264 m
.28797 .19264 L
s
.28805 .19711 m
.28805 .19711 L
s
.28812 .2018 m
.28812 .2018 L
s
.28819 .20509 m
.28819 .20509 L
s
.28827 .21214 m
.28827 .21214 L
s
.28835 .21613 m
.28835 .21613 L
s
.28842 .21801 m
.28842 .21801 L
s
.28849 .21801 m
.28849 .21801 L
s
.28857 .21965 m
.28857 .21965 L
s
.28864 .21542 m
.28864 .21542 L
s
.28872 .20979 m
.28872 .20979 L
s
.28879 .21002 m
.28879 .21002 L
s
.28887 .20603 m
.28887 .20603 L
s
.28894 .21261 m
.28894 .21261 L
s
.28901 .20979 m
.28901 .20979 L
s
.28908 .21284 m
.28908 .21284 L
s
.28916 .21284 m
.28916 .21284 L
s
.28924 .21613 m
.28924 .21613 L
s
.28931 .21026 m
.28931 .21026 L
s
.28938 .21167 m
.28938 .21167 L
s
.28946 .20861 m
.28946 .20861 L
s
.28953 .20486 m
.28953 .20486 L
s
.28961 .19898 m
.28961 .19898 L
s
.28968 .19711 m
.28968 .19711 L
s
.28976 .19616 m
.28976 .19616 L
s
.28983 .19687 m
.28983 .19687 L
s
.2899 .19968 m
.2899 .19968 L
s
.28998 .20462 m
.28998 .20462 L
s
.29005 .19711 m
.29005 .19711 L
s
.29013 .19804 m
.29013 .19804 L
s
.2902 .20885 m
.2902 .20885 L
s
.29028 .21026 m
.29028 .21026 L
s
.29035 .20744 m
.29035 .20744 L
s
.29043 .21073 m
.29043 .21073 L
s
.2905 .2105 m
.2905 .2105 L
s
.29057 .21073 m
.29057 .21073 L
s
.29064 .2065 m
.29064 .2065 L
s
.29072 .20157 m
.29072 .20157 L
s
.29079 .20157 m
.29079 .20157 L
s
.29087 .20697 m
.29087 .20697 L
s
.29094 .20345 m
.29094 .20345 L
s
.29102 .20392 m
.29102 .20392 L
s
.29109 .20908 m
.29109 .20908 L
s
.29117 .21261 m
.29117 .21261 L
s
.29124 .21449 m
.29124 .21449 L
s
.29132 .21496 m
.29132 .21496 L
s
.29139 .21707 m
.29139 .21707 L
s
.29146 .21378 m
.29146 .21378 L
s
.29154 .21895 m
.29154 .21895 L
s
.29161 .2213 m
.29161 .2213 L
s
.29169 .22693 m
.29169 .22693 L
s
.29176 .22364 m
.29176 .22364 L
s
.29184 .22271 m
.29184 .22271 L
s
.29191 .21895 m
.29191 .21895 L
s
.29199 .22459 m
.29199 .22459 L
s
.29206 .2267 m
.29206 .2267 L
s
.29214 .22106 m
.29214 .22106 L
s
.29221 .22999 m
.29221 .22999 L
s
.29228 .22834 m
.29228 .22834 L
s
.29235 .23257 m
.29235 .23257 L
s
.29243 .2368 m
.29243 .2368 L
s
.2925 .2368 m
.2925 .2368 L
s
.29258 .23703 m
.29258 .23703 L
s
.29265 .2469 m
.29265 .2469 L
s
.29273 .2415 m
.29273 .2415 L
s
.2928 .23516 m
.2928 .23516 L
s
.29288 .2408 m
.29288 .2408 L
s
.29296 .23727 m
.29296 .23727 L
s
.29302 .23868 m
.29302 .23868 L
s
.2931 .23187 m
.2931 .23187 L
s
.29317 .22506 m
.29317 .22506 L
s
.29325 .22834 m
.29325 .22834 L
s
.29332 .22459 m
.29332 .22459 L
s
.2934 .21778 m
.2934 .21778 L
s
.29347 .21425 m
.29347 .21425 L
s
.29355 .21918 m
.29355 .21918 L
s
.29362 .21683 m
.29362 .21683 L
s
.2937 .22224 m
.2937 .22224 L
s
.29377 .21707 m
.29377 .21707 L
s
.29384 .21731 m
.29384 .21731 L
s
.29391 .21942 m
.29391 .21942 L
s
.29399 .22012 m
.29399 .22012 L
s
.29406 .21778 m
.29406 .21778 L
s
.29414 .22482 m
.29414 .22482 L
s
.29421 .22693 m
.29421 .22693 L
s
.29429 .22623 m
.29429 .22623 L
s
.29436 .22552 m
.29436 .22552 L
s
.29444 .22482 m
.29444 .22482 L
s
.29452 .23117 m
.29452 .23117 L
s
.29459 .22999 m
.29459 .22999 L
s
.29466 .22506 m
.29466 .22506 L
s
.29473 .22012 m
.29473 .22012 L
s
.29481 .22294 m
.29481 .22294 L
s
.29488 .22177 m
.29488 .22177 L
s
.29496 .21731 m
.29496 .21731 L
s
.29503 .21636 m
.29503 .21636 L
s
.29511 .21284 m
.29511 .21284 L
s
.29518 .21519 m
.29518 .21519 L
s
.29526 .22247 m
.29526 .22247 L
s
.29533 .22529 m
.29533 .22529 L
s
.2954 .22341 m
.2954 .22341 L
s
.29547 .22506 m
.29547 .22506 L
s
.29555 .2213 m
.29555 .2213 L
s
.29562 .21778 m
.29562 .21778 L
s
.2957 .22341 m
.2957 .22341 L
s
.29577 .22741 m
.29577 .22741 L
s
.29585 .2267 m
.29585 .2267 L
s
.29592 .22412 m
.29592 .22412 L
s
.29599 .22083 m
.29599 .22083 L
s
.29607 .21237 m
.29607 .21237 L
s
.29615 .20462 m
.29615 .20462 L
s
.29622 .20157 m
.29622 .20157 L
s
.29629 .20415 m
.29629 .20415 L
s
.29637 .19264 m
.29637 .19264 L
s
.29644 .19358 m
.29644 .19358 L
s
.29652 .18654 m
.29652 .18654 L
s
.29659 .19147 m
.29659 .19147 L
s
.29667 .18912 m
.29667 .18912 L
s
.29674 .18888 m
.29674 .18888 L
s
.29681 .18865 m
.29681 .18865 L
s
.29689 .1816 m
.29689 .1816 L
s
.29697 .18466 m
.29697 .18466 L
s
.29704 .18489 m
.29704 .18489 L
s
.29711 .1823 m
.29711 .1823 L
s
.29718 .17948 m
.29718 .17948 L
s
.29726 .18536 m
.29726 .18536 L
s
.29733 .18066 m
.29733 .18066 L
s
.29741 .18277 m
.29741 .18277 L
s
.29748 .18372 m
.29748 .18372 L
s
.29756 .17925 m
.29756 .17925 L
s
.29763 .17573 m
.29763 .17573 L
s
.2977 .16352 m
.2977 .16352 L
s
.29778 .16986 m
.29778 .16986 L
s
.29785 .16845 m
.29785 .16845 L
s
.29793 .16516 m
.29793 .16516 L
s
.298 .16539 m
.298 .16539 L
s
.29808 .16586 m
.29808 .16586 L
s
.29815 .16399 m
.29815 .16399 L
s
.29823 .16492 m
.29823 .16492 L
s
.2983 .16845 m
.2983 .16845 L
s
.29837 .16704 m
.29837 .16704 L
s
.29844 .16492 m
.29844 .16492 L
s
.29852 .16328 m
.29852 .16328 L
s
.2986 .15811 m
.2986 .15811 L
s
.29867 .15905 m
.29867 .15905 L
s
.29874 .16469 m
.29874 .16469 L
s
.29882 .16704 m
.29882 .16704 L
s
.29889 .16634 m
.29889 .16634 L
s
.29897 .1715 m
.29897 .1715 L
s
.29904 .17878 m
.29904 .17878 L
s
.29912 .17549 m
.29912 .17549 L
s
.29919 .17409 m
.29919 .17409 L
s
.29926 .17925 m
.29926 .17925 L
s
.29934 .1816 m
.29934 .1816 L
s
.29941 .18325 m
.29941 .18325 L
s
.29949 .18606 m
.29949 .18606 L
s
.29956 .18841 m
.29956 .18841 L
s
.29964 .18654 m
.29964 .18654 L
s
.29971 .18748 m
.29971 .18748 L
s
.29979 .18113 m
.29979 .18113 L
s
.29986 .18512 m
.29986 .18512 L
s
.29994 .18888 m
.29994 .18888 L
s
.30001 .18865 m
.30001 .18865 L
s
.30008 .19194 m
.30008 .19194 L
s
.30015 .19664 m
.30015 .19664 L
s
.30023 .19476 m
.30023 .19476 L
s
.3003 .19311 m
.3003 .19311 L
s
.30038 .19499 m
.30038 .19499 L
s
.30045 .19476 m
.30045 .19476 L
s
.30053 .19711 m
.30053 .19711 L
s
.3006 .20016 m
.3006 .20016 L
s
.30068 .20674 m
.30068 .20674 L
s
.30076 .20345 m
.30076 .20345 L
s
.30082 .20321 m
.30082 .20321 L
s
.3009 .20532 m
.3009 .20532 L
s
.30097 .20556 m
.30097 .20556 L
s
.30105 .20086 m
.30105 .20086 L
s
.30112 .20063 m
.30112 .20063 L
s
.3012 .20345 m
.3012 .20345 L
s
.30127 .20932 m
.30127 .20932 L
s
.30135 .21801 m
.30135 .21801 L
s
.30142 .22317 m
.30142 .22317 L
s
.3015 .22224 m
.3015 .22224 L
s
.30157 .22271 m
.30157 .22271 L
s
.30164 .22388 m
.30164 .22388 L
s
.30171 .22153 m
.30171 .22153 L
s
.30179 .222 m
.30179 .222 L
s
.30186 .22482 m
.30186 .22482 L
s
.30194 .22788 m
.30194 .22788 L
s
.30201 .23117 m
.30201 .23117 L
s
.30209 .23374 m
.30209 .23374 L
s
.30216 .23257 m
.30216 .23257 L
s
.30224 .24009 m
.30224 .24009 L
s
.30232 .23539 m
.30232 .23539 L
s
.30239 .23539 m
.30239 .23539 L
s
.30246 .23516 m
.30246 .23516 L
s
.30253 .22764 m
.30253 .22764 L
s
.30261 .22106 m
.30261 .22106 L
s
.30268 .22435 m
.30268 .22435 L
s
.30276 .2213 m
.30276 .2213 L
s
.30283 .22412 m
.30283 .22412 L
s
.30291 .22741 m
.30291 .22741 L
s
.30298 .22811 m
.30298 .22811 L
s
.30306 .22975 m
.30306 .22975 L
s
.30313 .2213 m
.30313 .2213 L
s
.3032 .22083 m
.3032 .22083 L
s
.30327 .21824 m
.30327 .21824 L
s
.30335 .21284 m
.30335 .21284 L
s
.30342 .21284 m
.30342 .21284 L
s
.3035 .21824 m
.3035 .21824 L
s
.30357 .21472 m
.30357 .21472 L
s
.30365 .21143 m
.30365 .21143 L
s
.30372 .2119 m
.30372 .2119 L
s
.3038 .21378 m
.3038 .21378 L
s
.30388 .21731 m
.30388 .21731 L
s
.30395 .22106 m
.30395 .22106 L
s
.30402 .222 m
.30402 .222 L
s
.30409 .21519 m
.30409 .21519 L
s
.30417 .21143 m
.30417 .21143 L
s
.30424 .20861 m
.30424 .20861 L
s
.30432 .22106 m
.30432 .22106 L
s
.30439 .22247 m
.30439 .22247 L
s
.30447 .22599 m
.30447 .22599 L
s
.30454 .22693 m
.30454 .22693 L
s
.30461 .22952 m
.30461 .22952 L
s
.30469 .22764 m
.30469 .22764 L
s
.30477 .22975 m
.30477 .22975 L
s
.30484 .22811 m
.30484 .22811 L
s
.30491 .22858 m
.30491 .22858 L
s
.30498 .23234 m
.30498 .23234 L
s
.30506 .22858 m
.30506 .22858 L
s
.30513 .22834 m
.30513 .22834 L
s
.30521 .22576 m
.30521 .22576 L
s
.30528 .22928 m
.30528 .22928 L
s
.30536 .22741 m
.30536 .22741 L
s
.30543 .22388 m
.30543 .22388 L
s
.30551 .22459 m
.30551 .22459 L
s
.30559 .22952 m
.30559 .22952 L
s
.30565 .22623 m
.30565 .22623 L
s
.30573 .21895 m
.30573 .21895 L
s
.3058 .21284 m
.3058 .21284 L
s
.30588 .21425 m
.30588 .21425 L
s
.30595 .21331 m
.30595 .21331 L
s
.30603 .21214 m
.30603 .21214 L
s
.3061 .21848 m
.3061 .21848 L
s
.30617 .2206 m
.30617 .2206 L
s
.30624 .21895 m
.30624 .21895 L
s
.30632 .21989 m
.30632 .21989 L
s
.3064 .21778 m
.3064 .21778 L
s
.30647 .22294 m
.30647 .22294 L
s
.30654 .21824 m
.30654 .21824 L
s
.30662 .21378 m
.30662 .21378 L
s
.30669 .21214 m
.30669 .21214 L
s
.30677 .21731 m
.30677 .21731 L
s
.30684 .21143 m
.30684 .21143 L
s
.30692 .21237 m
.30692 .21237 L
s
.30699 .21331 m
.30699 .21331 L
s
.30706 .20861 m
.30706 .20861 L
s
.30714 .20626 m
.30714 .20626 L
s
.30722 .20626 m
.30722 .20626 L
s
.30729 .20603 m
.30729 .20603 L
s
.30736 .20603 m
.30736 .20603 L
s
.30744 .21002 m
.30744 .21002 L
s
.30751 .21472 m
.30751 .21472 L
s
.30759 .21707 m
.30759 .21707 L
s
.30766 .21683 m
.30766 .21683 L
s
.30774 .21284 m
.30774 .21284 L
s
.30781 .20768 m
.30781 .20768 L
s
.30788 .21002 m
.30788 .21002 L
s
.30795 .2105 m
.30795 .2105 L
s
.30803 .21778 m
.30803 .21778 L
s
.3081 .22012 m
.3081 .22012 L
s
.30818 .21731 m
.30818 .21731 L
s
.30825 .21918 m
.30825 .21918 L
s
.30833 .21707 m
.30833 .21707 L
s
.3084 .22764 m
.3084 .22764 L
s
.30848 .22529 m
.30848 .22529 L
s
.30856 .22388 m
.30856 .22388 L
s
.30862 .2213 m
.30862 .2213 L
s
.3087 .21848 m
.3087 .21848 L
s
.30877 .21801 m
.30877 .21801 L
s
.30885 .21824 m
.30885 .21824 L
s
.30892 .21683 m
.30892 .21683 L
s
.309 .21942 m
.309 .21942 L
s
.30907 .2206 m
.30907 .2206 L
s
.30915 .2166 m
.30915 .2166 L
s
.30922 .21472 m
.30922 .21472 L
s
.3093 .21754 m
.3093 .21754 L
s
.30937 .22317 m
.30937 .22317 L
s
.30944 .21895 m
.30944 .21895 L
s
.30951 .2166 m
.30951 .2166 L
s
.30959 .21589 m
.30959 .21589 L
s
.30966 .21449 m
.30966 .21449 L
s
.30974 .21472 m
.30974 .21472 L
s
.30981 .21331 m
.30981 .21331 L
s
.30989 .21307 m
.30989 .21307 L
s
.30996 .2105 m
.30996 .2105 L
s
.31004 .21519 m
.31004 .21519 L
s
.31012 .21425 m
.31012 .21425 L
s
.31019 .21542 m
.31019 .21542 L
s
.31026 .20579 m
.31026 .20579 L
s
.31033 .20509 m
.31033 .20509 L
s
.31041 .20227 m
.31041 .20227 L
s
.31048 .19616 m
.31048 .19616 L
s
.31056 .20674 m
.31056 .20674 L
s
.31063 .20861 m
.31063 .20861 L
s
.31071 .20979 m
.31071 .20979 L
s
.31078 .2119 m
.31078 .2119 L
s
.31086 .21519 m
.31086 .21519 L
s
.31093 .21378 m
.31093 .21378 L
s
.311 .21449 m
.311 .21449 L
s
.31107 .21942 m
.31107 .21942 L
s
.31115 .21378 m
.31115 .21378 L
s
.31122 .21425 m
.31122 .21425 L
s
.3113 .21425 m
.3113 .21425 L
s
.31137 .21378 m
.31137 .21378 L
s
.31145 .21683 m
.31145 .21683 L
s
.31152 .21895 m
.31152 .21895 L
s
.3116 .22012 m
.3116 .22012 L
s
.31168 .22693 m
.31168 .22693 L
s
.31175 .22576 m
.31175 .22576 L
s
.31182 .22811 m
.31182 .22811 L
s
.31189 .22788 m
.31189 .22788 L
s
.31197 .22788 m
.31197 .22788 L
s
.31204 .23045 m
.31204 .23045 L
s
.31212 .22529 m
.31212 .22529 L
s
.31219 .22858 m
.31219 .22858 L
s
.31227 .22482 m
.31227 .22482 L
s
.31234 .22388 m
.31234 .22388 L
s
.31242 .22435 m
.31242 .22435 L
s
.31249 .22459 m
.31249 .22459 L
s
.31257 .22693 m
.31257 .22693 L
s
.31264 .2213 m
.31264 .2213 L
s
.31271 .21942 m
.31271 .21942 L
s
.31278 .22271 m
.31278 .22271 L
s
.31286 .22764 m
.31286 .22764 L
s
.31293 .22905 m
.31293 .22905 L
s
.31301 .22952 m
.31301 .22952 L
s
.31308 .22999 m
.31308 .22999 L
s
.31316 .23281 m
.31316 .23281 L
s
.31323 .23374 m
.31323 .23374 L
s
.31331 .2307 m
.31331 .2307 L
s
.31339 .23304 m
.31339 .23304 L
s
.31345 .23821 m
.31345 .23821 L
s
.31353 .2422 m
.31353 .2422 L
s
.3136 .24103 m
.3136 .24103 L
s
.31368 .24314 m
.31368 .24314 L
s
.31375 .24127 m
.31375 .24127 L
s
.31383 .25019 m
.31383 .25019 L
s
.3139 .25489 m
.3139 .25489 L
s
.31397 .26499 m
.31397 .26499 L
s
.31405 .26404 m
.31405 .26404 L
s
.31413 .26404 m
.31413 .26404 L
s
.3142 .26311 m
.3142 .26311 L
s
.31427 .25559 m
.31427 .25559 L
s
.31434 .25723 m
.31434 .25723 L
s
.31442 .257 m
.31442 .257 L
s
.31449 .25583 m
.31449 .25583 L
s
.31457 .25536 m
.31457 .25536 L
s
.31464 .25865 m
.31464 .25865 L
s
.31472 .25653 m
.31472 .25653 L
s
.31479 .25301 m
.31479 .25301 L
s
.31486 .25512 m
.31486 .25512 L
s
.31494 .25606 m
.31494 .25606 L
s
.31502 .25676 m
.31502 .25676 L
s
.31509 .25676 m
.31509 .25676 L
s
.31516 .25277 m
.31516 .25277 L
s
.31524 .25183 m
.31524 .25183 L
s
.31531 .25442 m
.31531 .25442 L
s
.31539 .2469 m
.31539 .2469 L
s
.31546 .24361 m
.31546 .24361 L
s
.31554 .24009 m
.31554 .24009 L
s
.31561 .23633 m
.31561 .23633 L
s
.31568 .23656 m
.31568 .23656 L
s
.31576 .24173 m
.31576 .24173 L
s
.31584 .24455 m
.31584 .24455 L
s
.3159 .24361 m
.3159 .24361 L
s
.31598 .24573 m
.31598 .24573 L
s
.31605 .24995 m
.31605 .24995 L
s
.31613 .25324 m
.31613 .25324 L
s
.3162 .24666 m
.3162 .24666 L
s
.31628 .24808 m
.31628 .24808 L
s
.31636 .24032 m
.31636 .24032 L
s
.31642 .24549 m
.31642 .24549 L
s
.3165 .24455 m
.3165 .24455 L
s
.31657 .24666 m
.31657 .24666 L
s
.31665 .24432 m
.31665 .24432 L
s
.31672 .24596 m
.31672 .24596 L
s
.3168 .24549 m
.3168 .24549 L
s
.31687 .24244 m
.31687 .24244 L
s
.31695 .24103 m
.31695 .24103 L
s
.31702 .23985 m
.31702 .23985 L
s
.3171 .24808 m
.3171 .24808 L
s
.31717 .24761 m
.31717 .24761 L
s
.31724 .24573 m
.31724 .24573 L
s
.31731 .24573 m
.31731 .24573 L
s
.31739 .24948 m
.31739 .24948 L
s
.31747 .24526 m
.31747 .24526 L
s
.31754 .24432 m
.31754 .24432 L
s
.31761 .24103 m
.31761 .24103 L
s
.31769 .24032 m
.31769 .24032 L
s
.31776 .23798 m
.31776 .23798 L
s
.31784 .24009 m
.31784 .24009 L
s
.31792 .23938 m
.31792 .23938 L
s
.31799 .23445 m
.31799 .23445 L
s
.31806 .23422 m
.31806 .23422 L
s
.31813 .23563 m
.31813 .23563 L
s
.31821 .23492 m
.31821 .23492 L
s
.31828 .22717 m
.31828 .22717 L
s
.31836 .22811 m
.31836 .22811 L
s
.31843 .22388 m
.31843 .22388 L
s
.31851 .2267 m
.31851 .2267 L
s
.31858 .23022 m
.31858 .23022 L
s
.31866 .2267 m
.31866 .2267 L
s
.31873 .22764 m
.31873 .22764 L
s
.31881 .22364 m
.31881 .22364 L
s
.31887 .23022 m
.31887 .23022 L
s
.31895 .23281 m
.31895 .23281 L
s
.31902 .23398 m
.31902 .23398 L
s
.3191 .23422 m
.3191 .23422 L
s
.31917 .23516 m
.31917 .23516 L
s
.31925 .23586 m
.31925 .23586 L
s
.31932 .22693 m
.31932 .22693 L
s
.3194 .22975 m
.3194 .22975 L
s
.31948 .23633 m
.31948 .23633 L
s
.31955 .23351 m
.31955 .23351 L
s
.31962 .23609 m
.31962 .23609 L
s
.31969 .23045 m
.31969 .23045 L
s
.31977 .22928 m
.31977 .22928 L
s
.31984 .23022 m
.31984 .23022 L
s
.31992 .23469 m
.31992 .23469 L
s
.31999 .22975 m
.31999 .22975 L
s
.32007 .23045 m
.32007 .23045 L
s
.32014 .23093 m
.32014 .23093 L
s
.32022 .22858 m
.32022 .22858 L
s
.32029 .22741 m
.32029 .22741 L
s
.32037 .22881 m
.32037 .22881 L
s
.32044 .22834 m
.32044 .22834 L
s
.32051 .23163 m
.32051 .23163 L
s
.32058 .22412 m
.32058 .22412 L
s
.32066 .22881 m
.32066 .22881 L
s
.32073 .22459 m
.32073 .22459 L
s
.32081 .21683 m
.32081 .21683 L
s
.32088 .21683 m
.32088 .21683 L
s
.32096 .22482 m
.32096 .22482 L
s
.32103 .23022 m
.32103 .23022 L
s
.32111 .22858 m
.32111 .22858 L
s
.32119 .23045 m
.32119 .23045 L
s
.32125 .22788 m
.32125 .22788 L
s
.32133 .23163 m
.32133 .23163 L
s
.3214 .23845 m
.3214 .23845 L
s
.32148 .2368 m
.32148 .2368 L
s
.32155 .2408 m
.32155 .2408 L
s
.32163 .24643 m
.32163 .24643 L
s
.3217 .2422 m
.3217 .2422 L
s
.32178 .23821 m
.32178 .23821 L
s
.32185 .23891 m
.32185 .23891 L
s
.32193 .2314 m
.32193 .2314 L
s
.322 .23868 m
.322 .23868 L
s
.32207 .23633 m
.32207 .23633 L
s
.32214 .23422 m
.32214 .23422 L
s
.32222 .23398 m
.32222 .23398 L
s
.32229 .23656 m
.32229 .23656 L
s
.32237 .23351 m
.32237 .23351 L
s
.32244 .24055 m
.32244 .24055 L
s
.32252 .24384 m
.32252 .24384 L
s
.32259 .24127 m
.32259 .24127 L
s
.32267 .2408 m
.32267 .2408 L
s
.32274 .23703 m
.32274 .23703 L
s
.32282 .23234 m
.32282 .23234 L
s
.32289 .22952 m
.32289 .22952 L
s
.32296 .22482 m
.32296 .22482 L
s
.32304 .23093 m
.32304 .23093 L
s
.32311 .22905 m
.32311 .22905 L
s
.32319 .23422 m
.32319 .23422 L
s
.32326 .23868 m
.32326 .23868 L
s
.32334 .23257 m
.32334 .23257 L
s
.32341 .22177 m
.32341 .22177 L
s
.32348 .21683 m
.32348 .21683 L
s
.32356 .21636 m
.32356 .21636 L
s
.32364 .21378 m
.32364 .21378 L
s
.3237 .21472 m
.3237 .21472 L
s
.32378 .21519 m
.32378 .21519 L
s
.32385 .21613 m
.32385 .21613 L
s
.32393 .21425 m
.32393 .21425 L
s
.324 .21542 m
.324 .21542 L
s
.32408 .2206 m
.32408 .2206 L
s
.32416 .21871 m
.32416 .21871 L
s
.32422 .21707 m
.32422 .21707 L
s
.3243 .21636 m
.3243 .21636 L
s
.32437 .20838 m
.32437 .20838 L
s
.32445 .21355 m
.32445 .21355 L
s
.32452 .21895 m
.32452 .21895 L
s
.3246 .21989 m
.3246 .21989 L
s
.32467 .21965 m
.32467 .21965 L
s
.32475 .22623 m
.32475 .22623 L
s
.32482 .22388 m
.32482 .22388 L
s
.3249 .22153 m
.3249 .22153 L
s
.32497 .22482 m
.32497 .22482 L
s
.32504 .22599 m
.32504 .22599 L
s
.32511 .23163 m
.32511 .23163 L
s
.32519 .23398 m
.32519 .23398 L
s
.32527 .23093 m
.32527 .23093 L
s
.32534 .22646 m
.32534 .22646 L
s
.32541 .22858 m
.32541 .22858 L
s
.32549 .23821 m
.32549 .23821 L
s
.32556 .23633 m
.32556 .23633 L
s
.32564 .23774 m
.32564 .23774 L
s
.32572 .23985 m
.32572 .23985 L
s
.32579 .24103 m
.32579 .24103 L
s
.32586 .23962 m
.32586 .23962 L
s
.32593 .24267 m
.32593 .24267 L
s
.32601 .24784 m
.32601 .24784 L
s
.32608 .25254 m
.32608 .25254 L
s
.32616 .25065 m
.32616 .25065 L
s
.32623 .25065 m
.32623 .25065 L
s
.32631 .25277 m
.32631 .25277 L
s
.32638 .25465 m
.32638 .25465 L
s
.32646 .25371 m
.32646 .25371 L
s
.32653 .25489 m
.32653 .25489 L
s
.32661 .25207 m
.32661 .25207 L
s
.32667 .25653 m
.32667 .25653 L
s
.32675 .26052 m
.32675 .26052 L
s
.32682 .25347 m
.32682 .25347 L
s
.3269 .25653 m
.3269 .25653 L
s
.32697 .25371 m
.32697 .25371 L
s
.32705 .25583 m
.32705 .25583 L
s
.32712 .2523 m
.32712 .2523 L
s
.3272 .25489 m
.3272 .25489 L
s
.32728 .25418 m
.32728 .25418 L
s
.32735 .25254 m
.32735 .25254 L
s
.32742 .25042 m
.32742 .25042 L
s
.32749 .24432 m
.32749 .24432 L
s
.32757 .24737 m
.32757 .24737 L
s
.32764 .2415 m
.32764 .2415 L
s
.32772 .23891 m
.32772 .23891 L
s
.32779 .2415 m
.32779 .2415 L
s
.32787 .25042 m
.32787 .25042 L
s
.32794 .24314 m
.32794 .24314 L
s
.32802 .24502 m
.32802 .24502 L
s
.32809 .2408 m
.32809 .2408 L
s
.32817 .25137 m
.32817 .25137 L
s
.32824 .25113 m
.32824 .25113 L
s
.32831 .2509 m
.32831 .2509 L
s
.32838 .25254 m
.32838 .25254 L
s
.32846 .25065 m
.32846 .25065 L
s
.32853 .2516 m
.32853 .2516 L
s
.32861 .24761 m
.32861 .24761 L
s
.32868 .25065 m
.32868 .25065 L
s
.32876 .25676 m
.32876 .25676 L
s
.32884 .26311 m
.32884 .26311 L
s
.32891 .25771 m
.32891 .25771 L
s
.32899 .26099 m
.32899 .26099 L
s
.32905 .26357 m
.32905 .26357 L
s
.32913 .25865 m
.32913 .25865 L
s
.3292 .26123 m
.3292 .26123 L
s
.32928 .2671 m
.32928 .2671 L
s
.32935 .26639 m
.32935 .26639 L
s
.32943 .26522 m
.32943 .26522 L
s
.3295 .26381 m
.3295 .26381 L
s
.32958 .26381 m
.32958 .26381 L
s
.32965 .26052 m
.32965 .26052 L
s
.32973 .26475 m
.32973 .26475 L
s
.3298 .26499 m
.3298 .26499 L
s
.32987 .26804 m
.32987 .26804 L
s
.32994 .26804 m
.32994 .26804 L
s
.33002 .26546 m
.33002 .26546 L
s
.33009 .2671 m
.33009 .2671 L
s
.33017 .26264 m
.33017 .26264 L
s
.33024 .26123 m
.33024 .26123 L
s
.33032 .25958 m
.33032 .25958 L
s
.33039 .25771 m
.33039 .25771 L
s
.33047 .25606 m
.33047 .25606 L
s
.33055 .25394 m
.33055 .25394 L
s
.33062 .25254 m
.33062 .25254 L
s
.33069 .25019 m
.33069 .25019 L
s
.33076 .24808 m
.33076 .24808 L
s
.33084 .24855 m
.33084 .24855 L
s
.33091 .24713 m
.33091 .24713 L
s
.33099 .24761 m
.33099 .24761 L
s
.33106 .24314 m
.33106 .24314 L
s
.33114 .23915 m
.33114 .23915 L
s
.33121 .24103 m
.33121 .24103 L
s
.33128 .23798 m
.33128 .23798 L
s
.33136 .24244 m
.33136 .24244 L
s
.33144 .24314 m
.33144 .24314 L
s
.3315 .24878 m
.3315 .24878 L
s
.33158 .24479 m
.33158 .24479 L
s
.33165 .24596 m
.33165 .24596 L
s
.33173 .24408 m
.33173 .24408 L
s
.3318 .24713 m
.3318 .24713 L
s
.33188 .24032 m
.33188 .24032 L
s
.33196 .23445 m
.33196 .23445 L
s
.33202 .23798 m
.33202 .23798 L
s
.3321 .23915 m
.3321 .23915 L
s
.33218 .23445 m
.33218 .23445 L
s
.33225 .22905 m
.33225 .22905 L
s
.33232 .23751 m
.33232 .23751 L
s
.3324 .23703 m
.3324 .23703 L
s
.33247 .2321 m
.33247 .2321 L
s
.33255 .23398 m
.33255 .23398 L
s
.33262 .23539 m
.33262 .23539 L
s
.3327 .23374 m
.3327 .23374 L
s
.33277 .23656 m
.33277 .23656 L
s
.33284 .23985 m
.33284 .23985 L
s
.33291 .24197 m
.33291 .24197 L
s
.33299 .24573 m
.33299 .24573 L
s
.33307 .2422 m
.33307 .2422 L
s
.33314 .24808 m
.33314 .24808 L
s
.33321 .24855 m
.33321 .24855 L
s
.33329 .24713 m
.33329 .24713 L
s
.33336 .24925 m
.33336 .24925 L
s
.33344 .25606 m
.33344 .25606 L
s
.33352 .257 m
.33352 .257 L
s
.33359 .25207 m
.33359 .25207 L
s
.33366 .24878 m
.33366 .24878 L
s
.33373 .25019 m
.33373 .25019 L
s
.33381 .25629 m
.33381 .25629 L
s
.33388 .26452 m
.33388 .26452 L
s
.33396 .26311 m
.33396 .26311 L
s
.33403 .25818 m
.33403 .25818 L
s
.33411 .26075 m
.33411 .26075 L
s
.33418 .25771 m
.33418 .25771 L
s
.33426 .25818 m
.33426 .25818 L
s
.33433 .26217 m
.33433 .26217 L
s
.33441 .25935 m
.33441 .25935 L
s
.33447 .26193 m
.33447 .26193 L
s
.33455 .26357 m
.33455 .26357 L
s
.33462 .26733 m
.33462 .26733 L
s
.3347 .26945 m
.3347 .26945 L
s
.33477 .27344 m
.33477 .27344 L
s
.33485 .27626 m
.33485 .27626 L
s
.33492 .27461 m
.33492 .27461 L
s
.335 .27861 m
.335 .27861 L
s
.33508 .27885 m
.33508 .27885 L
s
.33515 .27673 m
.33515 .27673 L
s
.33522 .28119 m
.33522 .28119 L
s
.33529 .28706 m
.33529 .28706 L
s
.33537 .2873 m
.33537 .2873 L
s
.33544 .29059 m
.33544 .29059 L
s
.33552 .28331 m
.33552 .28331 L
s
.33559 .29152 m
.33559 .29152 L
s
.33567 .292 m
.33567 .292 L
s
.33574 .28941 m
.33574 .28941 L
s
.33582 .28988 m
.33582 .28988 L
s
.33589 .29012 m
.33589 .29012 L
s
.33597 .29434 m
.33597 .29434 L
s
.33604 .29152 m
.33604 .29152 L
s
.33611 .29434 m
.33611 .29434 L
s
.33618 .29458 m
.33618 .29458 L
s
.33626 .29035 m
.33626 .29035 L
s
.33633 .29059 m
.33633 .29059 L
s
.33641 .288 m
.33641 .288 L
s
.33648 .28918 m
.33648 .28918 L
s
.33656 .292 m
.33656 .292 L
s
.33664 .28895 m
.33664 .28895 L
s
.33671 .28706 m
.33671 .28706 L
s
.33679 .28871 m
.33679 .28871 L
s
.33685 .29294 m
.33685 .29294 L
s
.33693 .29317 m
.33693 .29317 L
s
.337 .29975 m
.337 .29975 L
s
.33708 .29834 m
.33708 .29834 L
s
.33715 .2974 m
.33715 .2974 L
s
.33723 .3021 m
.33723 .3021 L
s
.3373 .30092 m
.3373 .30092 L
s
.33738 .29505 m
.33738 .29505 L
s
.33745 .29646 m
.33745 .29646 L
s
.33753 .29434 m
.33753 .29434 L
s
.3376 .28683 m
.3376 .28683 L
s
.33767 .29059 m
.33767 .29059 L
s
.33774 .28706 m
.33774 .28706 L
s
.33782 .28706 m
.33782 .28706 L
s
.33789 .2873 m
.33789 .2873 L
s
.33797 .28848 m
.33797 .28848 L
s
.33804 .29481 m
.33804 .29481 L
s
.33812 .29434 m
.33812 .29434 L
s
.33819 .29881 m
.33819 .29881 L
s
.33827 .30187 m
.33827 .30187 L
s
.33835 .30398 m
.33835 .30398 L
s
.33842 .2967 m
.33842 .2967 L
s
.33849 .29152 m
.33849 .29152 L
s
.33856 .28895 m
.33856 .28895 L
s
.33864 .28659 m
.33864 .28659 L
s
.33871 .28941 m
.33871 .28941 L
s
.33879 .29247 m
.33879 .29247 L
s
.33886 .29035 m
.33886 .29035 L
s
.33894 .29224 m
.33894 .29224 L
s
.33901 .29224 m
.33901 .29224 L
s
.33909 .29505 m
.33909 .29505 L
s
.33916 .29364 m
.33916 .29364 L
s
.33924 .29106 m
.33924 .29106 L
s
.3393 .28918 m
.3393 .28918 L
s
.33938 .29552 m
.33938 .29552 L
s
.33945 .30069 m
.33945 .30069 L
s
.33953 .30421 m
.33953 .30421 L
s
.3396 .30304 m
.3396 .30304 L
s
.33968 .30539 m
.33968 .30539 L
s
.33976 .31126 m
.33976 .31126 L
s
.33982 .31384 m
.33982 .31384 L
s
.3399 .31149 m
.3399 .31149 L
s
.33998 .31337 m
.33998 .31337 L
s
.34005 .30844 m
.34005 .30844 L
s
.34012 .30069 m
.34012 .30069 L
s
.3402 .30868 m
.3402 .30868 L
s
.34027 .30891 m
.34027 .30891 L
s
.34035 .30069 m
.34035 .30069 L
s
.34042 .30304 m
.34042 .30304 L
s
.3405 .30726 m
.3405 .30726 L
s
.34057 .30633 m
.34057 .30633 L
s
.34064 .30468 m
.34064 .30468 L
s
.34072 .3068 m
.34072 .3068 L
s
.3408 .30515 m
.3408 .30515 L
s
.34087 .30351 m
.34087 .30351 L
s
.34094 .31055 m
.34094 .31055 L
s
.34101 .31361 m
.34101 .31361 L
s
.34109 .3169 m
.34109 .3169 L
s
.34116 .31666 m
.34116 .31666 L
s
.34124 .3183 m
.34124 .3183 L
s
.34132 .31948 m
.34132 .31948 L
s
.34139 .31572 m
.34139 .31572 L
s
.34146 .31149 m
.34146 .31149 L
s
.34153 .31619 m
.34153 .31619 L
s
.34161 .31008 m
.34161 .31008 L
s
.34168 .30962 m
.34168 .30962 L
s
.34176 .31008 m
.34176 .31008 L
s
.34183 .30773 m
.34183 .30773 L
s
.34191 .30398 m
.34191 .30398 L
s
.34198 .30351 m
.34198 .30351 L
s
.34206 .30351 m
.34206 .30351 L
s
.34213 .30491 m
.34213 .30491 L
s
.34221 .3075 m
.34221 .3075 L
s
.34227 .30938 m
.34227 .30938 L
s
.34235 .30022 m
.34235 .30022 L
s
.34243 .30022 m
.34243 .30022 L
s
.3425 .29787 m
.3425 .29787 L
s
.34257 .29364 m
.34257 .29364 L
s
.34265 .28636 m
.34265 .28636 L
s
.34272 .28566 m
.34272 .28566 L
s
.3428 .29716 m
.3428 .29716 L
s
.34288 .30116 m
.34288 .30116 L
s
.34295 .30162 m
.34295 .30162 L
s
.34302 .30327 m
.34302 .30327 L
s
.34309 .3122 m
.34309 .3122 L
s
.34317 .31948 m
.34317 .31948 L
s
.34324 .32042 m
.34324 .32042 L
s
.34332 .3129 m
.34332 .3129 L
s
.34339 .31619 m
.34339 .31619 L
s
.34347 .31854 m
.34347 .31854 L
s
.34354 .31736 m
.34354 .31736 L
s
.34362 .31196 m
.34362 .31196 L
s
.34369 .31807 m
.34369 .31807 L
s
.34377 .30797 m
.34377 .30797 L
s
.34384 .30962 m
.34384 .30962 L
s
.34391 .30962 m
.34391 .30962 L
s
.34398 .31384 m
.34398 .31384 L
s
.34406 .31525 m
.34406 .31525 L
s
.34413 .31478 m
.34413 .31478 L
s
.34421 .31055 m
.34421 .31055 L
s
.34428 .31643 m
.34428 .31643 L
s
.34436 .3169 m
.34436 .3169 L
s
.34444 .31995 m
.34444 .31995 L
s
.34451 .32042 m
.34451 .32042 L
s
.34459 .32371 m
.34459 .32371 L
s
.34465 .31572 m
.34465 .31572 L
s
.34473 .31478 m
.34473 .31478 L
s
.3448 .31244 m
.3448 .31244 L
s
.34488 .30938 m
.34488 .30938 L
s
.34495 .30773 m
.34495 .30773 L
s
.34503 .30327 m
.34503 .30327 L
s
.3451 .30915 m
.3451 .30915 L
s
.34518 .30656 m
.34518 .30656 L
s
.34525 .30938 m
.34525 .30938 L
s
.34533 .30868 m
.34533 .30868 L
s
.3454 .30962 m
.3454 .30962 L
s
.34547 .30797 m
.34547 .30797 L
s
.34554 .31525 m
.34554 .31525 L
s
.34562 .31408 m
.34562 .31408 L
s
.34569 .31454 m
.34569 .31454 L
s
.34577 .31102 m
.34577 .31102 L
s
.34584 .31314 m
.34584 .31314 L
s
.34592 .30844 m
.34592 .30844 L
s
.346 .30421 m
.346 .30421 L
s
.34607 .30586 m
.34607 .30586 L
s
.34615 .30398 m
.34615 .30398 L
s
.34622 .30398 m
.34622 .30398 L
s
.34629 .30139 m
.34629 .30139 L
s
.34636 .29458 m
.34636 .29458 L
s
.34644 .29481 m
.34644 .29481 L
s
.34651 .29905 m
.34651 .29905 L
s
.34659 .29716 m
.34659 .29716 L
s
.34666 .28871 m
.34666 .28871 L
s
.34674 .29106 m
.34674 .29106 L
s
.34681 .29434 m
.34681 .29434 L
s
.34689 .28495 m
.34689 .28495 L
s
.34696 .28401 m
.34696 .28401 L
s
.34704 .2819 m
.34704 .2819 L
s
.3471 .28354 m
.3471 .28354 L
s
.34718 .28307 m
.34718 .28307 L
s
.34725 .28213 m
.34725 .28213 L
s
.34733 .28519 m
.34733 .28519 L
s
.3474 .28237 m
.3474 .28237 L
s
.34748 .27838 m
.34748 .27838 L
s
.34756 .27814 m
.34756 .27814 L
s
.34763 .28237 m
.34763 .28237 L
s
.34771 .28566 m
.34771 .28566 L
s
.34778 .28448 m
.34778 .28448 L
s
.34785 .28401 m
.34785 .28401 L
s
.34792 .28683 m
.34792 .28683 L
s
.348 .28613 m
.348 .28613 L
s
.34807 .29411 m
.34807 .29411 L
s
.34815 .29646 m
.34815 .29646 L
s
.34822 .29505 m
.34822 .29505 L
s
.3483 .29576 m
.3483 .29576 L
s
.34837 .29458 m
.34837 .29458 L
s
.34844 .30162 m
.34844 .30162 L
s
.34852 .30398 m
.34852 .30398 L
s
.3486 .30374 m
.3486 .30374 L
s
.34867 .29928 m
.34867 .29928 L
s
.34874 .29434 m
.34874 .29434 L
s
.34881 .29552 m
.34881 .29552 L
s
.34889 .2927 m
.34889 .2927 L
s
.34896 .28988 m
.34896 .28988 L
s
.34904 .28753 m
.34904 .28753 L
s
.34912 .3028 m
.34912 .3028 L
s
.34919 .30985 m
.34919 .30985 L
s
.34926 .30891 m
.34926 .30891 L
s
.34934 .30304 m
.34934 .30304 L
s
.34942 .30092 m
.34942 .30092 L
s
.34948 .30491 m
.34948 .30491 L
s
.34956 .30187 m
.34956 .30187 L
s
.34963 .2981 m
.34963 .2981 L
s
.34971 .29623 m
.34971 .29623 L
s
.34978 .29905 m
.34978 .29905 L
s
.34986 .29998 m
.34986 .29998 L
s
.34993 .29529 m
.34993 .29529 L
s
.35001 .29693 m
.35001 .29693 L
s
.35007 .29388 m
.35007 .29388 L
s
.35015 .29364 m
.35015 .29364 L
s
.35023 .29082 m
.35023 .29082 L
s
.3503 .29552 m
.3503 .29552 L
s
.35037 .30116 m
.35037 .30116 L
s
.35045 .2974 m
.35045 .2974 L
s
.35052 .29505 m
.35052 .29505 L
s
.3506 .2981 m
.3506 .2981 L
s
.35068 .28941 m
.35068 .28941 L
s
.35075 .28659 m
.35075 .28659 L
s
.35082 .29152 m
.35082 .29152 L
s
.35089 .288 m
.35089 .288 L
s
.35097 .27743 m
.35097 .27743 L
s
.35105 .28895 m
.35105 .28895 L
s
.35112 .28424 m
.35112 .28424 L
s
.35119 .28706 m
.35119 .28706 L
s
.35127 .28636 m
.35127 .28636 L
s
.35134 .28495 m
.35134 .28495 L
s
.35142 .28378 m
.35142 .28378 L
s
.35149 .28613 m
.35149 .28613 L
s
.35157 .28824 m
.35157 .28824 L
s
.35164 .29294 m
.35164 .29294 L
s
.35171 .28965 m
.35171 .28965 L
s
.35178 .28378 m
.35178 .28378 L
s
.35186 .28167 m
.35186 .28167 L
s
.35193 .27603 m
.35193 .27603 L
s
.35201 .27814 m
.35201 .27814 L
s
.35208 .27861 m
.35208 .27861 L
s
.35216 .27509 m
.35216 .27509 L
s
.35224 .27579 m
.35224 .27579 L
s
.35231 .27673 m
.35231 .27673 L
s
.35239 .27414 m
.35239 .27414 L
s
.35245 .2779 m
.35245 .2779 L
s
.35253 .27767 m
.35253 .27767 L
s
.3526 .27603 m
.3526 .27603 L
s
.35268 .2678 m
.35268 .2678 L
s
.35275 .2678 m
.35275 .2678 L
s
.35283 .26616 m
.35283 .26616 L
s
.3529 .26334 m
.3529 .26334 L
s
.35298 .2624 m
.35298 .2624 L
s
.35305 .25606 m
.35305 .25606 L
s
.35313 .2523 m
.35313 .2523 L
s
.3532 .25489 m
.3532 .25489 L
s
.35327 .26029 m
.35327 .26029 L
s
.35334 .25371 m
.35334 .25371 L
s
.35342 .25277 m
.35342 .25277 L
s
.35349 .25277 m
.35349 .25277 L
s
.35357 .25137 m
.35357 .25137 L
s
.35364 .25301 m
.35364 .25301 L
s
.35372 .25818 m
.35372 .25818 L
s
.3538 .25888 m
.3538 .25888 L
s
.35387 .26123 m
.35387 .26123 L
s
.35395 .26099 m
.35395 .26099 L
s
.35402 .26804 m
.35402 .26804 L
s
.35409 .27109 m
.35409 .27109 L
s
.35416 .26851 m
.35416 .26851 L
s
.35424 .26921 m
.35424 .26921 L
s
.35431 .26945 m
.35431 .26945 L
s
.35439 .26569 m
.35439 .26569 L
s
.35446 .27673 m
.35446 .27673 L
s
.35454 .27978 m
.35454 .27978 L
s
.35461 .28401 m
.35461 .28401 L
s
.35469 .28378 m
.35469 .28378 L
s
.35476 .28683 m
.35476 .28683 L
s
.35484 .28566 m
.35484 .28566 L
s
.3549 .28613 m
.3549 .28613 L
s
.35498 .27767 m
.35498 .27767 L
s
.35505 .2819 m
.35505 .2819 L
s
.35513 .28683 m
.35513 .28683 L
s
.3552 .27743 m
.3552 .27743 L
s
.35528 .2725 m
.35528 .2725 L
s
.35536 .27133 m
.35536 .27133 L
s
.35543 .26921 m
.35543 .26921 L
s
.35551 .27673 m
.35551 .27673 L
s
.35558 .27509 m
.35558 .27509 L
s
.35565 .27157 m
.35565 .27157 L
s
.35572 .2718 m
.35572 .2718 L
s
.3558 .27297 m
.3558 .27297 L
s
.35587 .27203 m
.35587 .27203 L
s
.35595 .27908 m
.35595 .27908 L
s
.35602 .28049 m
.35602 .28049 L
s
.3561 .27414 m
.3561 .27414 L
s
.35617 .27978 m
.35617 .27978 L
s
.35625 .27767 m
.35625 .27767 L
s
.35632 .27321 m
.35632 .27321 L
s
.3564 .28002 m
.3564 .28002 L
s
.35647 .27814 m
.35647 .27814 L
s
.35654 .27391 m
.35654 .27391 L
s
.35661 .27509 m
.35661 .27509 L
s
.35669 .2772 m
.35669 .2772 L
s
.35676 .28002 m
.35676 .28002 L
s
.35684 .27649 m
.35684 .27649 L
s
.35692 .26757 m
.35692 .26757 L
s
.35699 .27368 m
.35699 .27368 L
s
.35706 .27509 m
.35706 .27509 L
s
.35714 .27556 m
.35714 .27556 L
s
.35722 .27015 m
.35722 .27015 L
s
.35729 .27109 m
.35729 .27109 L
s
.35736 .26733 m
.35736 .26733 L
s
.35743 .26945 m
.35743 .26945 L
s
.35751 .26639 m
.35751 .26639 L
s
.35758 .27062 m
.35758 .27062 L
s
.35766 .27274 m
.35766 .27274 L
s
.35773 .27227 m
.35773 .27227 L
s
.35781 .26851 m
.35781 .26851 L
s
.35788 .27344 m
.35788 .27344 L
s
.35796 .28049 m
.35796 .28049 L
s
.35803 .28378 m
.35803 .28378 L
s
.3581 .28049 m
.3581 .28049 L
s
.35817 .28753 m
.35817 .28753 L
s
.35825 .28448 m
.35825 .28448 L
s
.35832 .27978 m
.35832 .27978 L
s
.3584 .28401 m
.3584 .28401 L
s
.35848 .28659 m
.35848 .28659 L
s
.35855 .28378 m
.35855 .28378 L
s
.35862 .28471 m
.35862 .28471 L
s
.35869 .28495 m
.35869 .28495 L
s
.35877 .27885 m
.35877 .27885 L
s
.35885 .2819 m
.35885 .2819 L
s
.35892 .28519 m
.35892 .28519 L
s
.35899 .28941 m
.35899 .28941 L
s
.35907 .29152 m
.35907 .29152 L
s
.35914 .29552 m
.35914 .29552 L
s
.35922 .29481 m
.35922 .29481 L
s
.35929 .29858 m
.35929 .29858 L
s
.35937 .30257 m
.35937 .30257 L
s
.35944 .30116 m
.35944 .30116 L
s
.35951 .30257 m
.35951 .30257 L
s
.35959 .30187 m
.35959 .30187 L
s
.35967 .30444 m
.35967 .30444 L
s
.35973 .30327 m
.35973 .30327 L
s
.35981 .29834 m
.35981 .29834 L
s
.35988 .2974 m
.35988 .2974 L
s
.35996 .2981 m
.35996 .2981 L
s
.36004 .29998 m
.36004 .29998 L
s
.36011 .29858 m
.36011 .29858 L
s
.36019 .30562 m
.36019 .30562 L
s
.36026 .30468 m
.36026 .30468 L
s
.36033 .29693 m
.36033 .29693 L
s
.3604 .29763 m
.3604 .29763 L
s
.36048 .30351 m
.36048 .30351 L
s
.36055 .30327 m
.36055 .30327 L
s
.36063 .29458 m
.36063 .29458 L
s
.3607 .30069 m
.3607 .30069 L
s
.36078 .29834 m
.36078 .29834 L
s
.36085 .29975 m
.36085 .29975 L
s
.36093 .30234 m
.36093 .30234 L
s
.361 .30116 m
.361 .30116 L
s
.36107 .30045 m
.36107 .30045 L
s
.36114 .30609 m
.36114 .30609 L
s
.36122 .30797 m
.36122 .30797 L
s
.3613 .30891 m
.3613 .30891 L
s
.36137 .3075 m
.36137 .3075 L
s
.36144 .3122 m
.36144 .3122 L
s
.36152 .31149 m
.36152 .31149 L
s
.3616 .3176 m
.3616 .3176 L
s
.36167 .32112 m
.36167 .32112 L
s
.36175 .31925 m
.36175 .31925 L
s
.36182 .32254 m
.36182 .32254 L
s
.36189 .327 m
.36189 .327 L
s
.36196 .32582 m
.36196 .32582 L
s
.36204 .32864 m
.36204 .32864 L
s
.36211 .32347 m
.36211 .32347 L
s
.36219 .31948 m
.36219 .31948 L
s
.36226 .3129 m
.36226 .3129 L
s
.36234 .32089 m
.36234 .32089 L
s
.36241 .3183 m
.36241 .3183 L
s
.36249 .31736 m
.36249 .31736 L
s
.36256 .31337 m
.36256 .31337 L
s
.36264 .31172 m
.36264 .31172 L
s
.3627 .31854 m
.3627 .31854 L
s
.36278 .32488 m
.36278 .32488 L
s
.36285 .32324 m
.36285 .32324 L
s
.36293 .3223 m
.36293 .3223 L
s
.363 .31972 m
.363 .31972 L
s
.36308 .31807 m
.36308 .31807 L
s
.36316 .31807 m
.36316 .31807 L
s
.36323 .32136 m
.36323 .32136 L
s
.36331 .32511 m
.36331 .32511 L
s
.36338 .32464 m
.36338 .32464 L
s
.36345 .32606 m
.36345 .32606 L
s
.36352 .323 m
.36352 .323 L
s
.3636 .32464 m
.3636 .32464 L
s
.36367 .32746 m
.36367 .32746 L
s
.36375 .32418 m
.36375 .32418 L
s
.36382 .32676 m
.36382 .32676 L
s
.3639 .32558 m
.3639 .32558 L
s
.36397 .33005 m
.36397 .33005 L
s
.36405 .33264 m
.36405 .33264 L
s
.36412 .33968 m
.36412 .33968 L
s
.3642 .33428 m
.3642 .33428 L
s
.36427 .33874 m
.36427 .33874 L
s
.36434 .3324 m
.36434 .3324 L
s
.36441 .33146 m
.36441 .33146 L
s
.36449 .32958 m
.36449 .32958 L
s
.36456 .33192 m
.36456 .33192 L
s
.36464 .33592 m
.36464 .33592 L
s
.36472 .33498 m
.36472 .33498 L
s
.36479 .33451 m
.36479 .33451 L
s
.36487 .33287 m
.36487 .33287 L
s
.36494 .33075 m
.36494 .33075 L
s
.36502 .33099 m
.36502 .33099 L
s
.36509 .33428 m
.36509 .33428 L
s
.36516 .33122 m
.36516 .33122 L
s
.36523 .33639 m
.36523 .33639 L
s
.36531 .33827 m
.36531 .33827 L
s
.36538 .3385 m
.36538 .3385 L
s
.36546 .33428 m
.36546 .33428 L
s
.36553 .33451 m
.36553 .33451 L
s
.36561 .33803 m
.36561 .33803 L
s
.36568 .34062 m
.36568 .34062 L
s
.36576 .34179 m
.36576 .34179 L
s
.36583 .34062 m
.36583 .34062 L
s
.3659 .34109 m
.3659 .34109 L
s
.36597 .34438 m
.36597 .34438 L
s
.36605 .3432 m
.36605 .3432 L
s
.36612 .34531 m
.36612 .34531 L
s
.3662 .34649 m
.3662 .34649 L
s
.36628 .35683 m
.36628 .35683 L
s
.36635 .35847 m
.36635 .35847 L
s
.36642 .35588 m
.36642 .35588 L
s
.3665 .3573 m
.3665 .3573 L
s
.36658 .35965 m
.36658 .35965 L
s
.36665 .36387 m
.36665 .36387 L
s
.36672 .36528 m
.36672 .36528 L
s
.36679 .36763 m
.36679 .36763 L
s
.36687 .37233 m
.36687 .37233 L
s
.36694 .37303 m
.36694 .37303 L
s
.36702 .3681 m
.36702 .3681 L
s
.36709 .37209 m
.36709 .37209 L
s
.36717 .37045 m
.36717 .37045 L
s
.36724 .37444 m
.36724 .37444 L
s
.36731 .37186 m
.36731 .37186 L
s
.36739 .37139 m
.36739 .37139 L
s
.36747 .36387 m
.36747 .36387 L
s
.36753 .36434 m
.36753 .36434 L
s
.36761 .35541 m
.36761 .35541 L
s
.36768 .35777 m
.36768 .35777 L
s
.36776 .35894 m
.36776 .35894 L
s
.36784 .36105 m
.36784 .36105 L
s
.36791 .36293 m
.36791 .36293 L
s
.36799 .36293 m
.36799 .36293 L
s
.36806 .36458 m
.36806 .36458 L
s
.36813 .36646 m
.36813 .36646 L
s
.36821 .36059 m
.36821 .36059 L
s
.36828 .35612 m
.36828 .35612 L
s
.36835 .35941 m
.36835 .35941 L
s
.36843 .36035 m
.36843 .36035 L
s
.3685 .36176 m
.3685 .36176 L
s
.36858 .36669 m
.36858 .36669 L
s
.36865 .35988 m
.36865 .35988 L
s
.36873 .36341 m
.36873 .36341 L
s
.3688 .36317 m
.3688 .36317 L
s
.36887 .36364 m
.36887 .36364 L
s
.36894 .36669 m
.36894 .36669 L
s
.36902 .36716 m
.36902 .36716 L
s
.3691 .36411 m
.3691 .36411 L
s
.36917 .36293 m
.36917 .36293 L
s
.36924 .37022 m
.36924 .37022 L
s
.36932 .36458 m
.36932 .36458 L
s
.3694 .36622 m
.3694 .36622 L
s
.36947 .37303 m
.36947 .37303 L
s
.36955 .38079 m
.36955 .38079 L
s
.36962 .38149 m
.36962 .38149 L
s
.36969 .37984 m
.36969 .37984 L
s
.36976 .37656 m
.36976 .37656 L
s
.36984 .37656 m
.36984 .37656 L
s
.36992 .37937 m
.36992 .37937 L
s
.36999 .38149 m
.36999 .38149 L
s
.37006 .38289 m
.37006 .38289 L
s
.37014 .37961 m
.37014 .37961 L
s
.37021 .37773 m
.37021 .37773 L
s
.37029 .37397 m
.37029 .37397 L
s
.37036 .37303 m
.37036 .37303 L
s
.37044 .37961 m
.37044 .37961 L
s
.3705 .37984 m
.3705 .37984 L
s
.37058 .37585 m
.37058 .37585 L
s
.37065 .37632 m
.37065 .37632 L
s
.37073 .36833 m
.37073 .36833 L
s
.3708 .37303 m
.3708 .37303 L
s
.37088 .37022 m
.37088 .37022 L
s
.37096 .36974 m
.37096 .36974 L
s
.37103 .37045 m
.37103 .37045 L
s
.37111 .37538 m
.37111 .37538 L
s
.37118 .38361 m
.37118 .38361 L
s
.37125 .38478 m
.37125 .38478 L
s
.37132 .38525 m
.37132 .38525 L
s
.3714 .38172 m
.3714 .38172 L
s
.37147 .37984 m
.37147 .37984 L
s
.37155 .38079 m
.37155 .38079 L
s
.37162 .38149 m
.37162 .38149 L
s
.3717 .38289 m
.3717 .38289 L
s
.37177 .38243 m
.37177 .38243 L
s
.37185 .37351 m
.37185 .37351 L
s
.37192 .36693 m
.37192 .36693 L
s
.372 .36951 m
.372 .36951 L
s
.37207 .36833 m
.37207 .36833 L
s
.37214 .37585 m
.37214 .37585 L
s
.37221 .37843 m
.37221 .37843 L
s
.37229 .37585 m
.37229 .37585 L
s
.37236 .37256 m
.37236 .37256 L
s
.37244 .36458 m
.37244 .36458 L
s
.37252 .3688 m
.37252 .3688 L
s
.37259 .36293 m
.37259 .36293 L
s
.37267 .35988 m
.37267 .35988 L
s
.37274 .35284 m
.37274 .35284 L
s
.37282 .34673 m
.37282 .34673 L
s
.37289 .35307 m
.37289 .35307 L
s
.37296 .35259 m
.37296 .35259 L
s
.37303 .35095 m
.37303 .35095 L
s
.37311 .35002 m
.37311 .35002 L
s
.37318 .3472 m
.37318 .3472 L
s
.37326 .34531 m
.37326 .34531 L
s
.37333 .34297 m
.37333 .34297 L
s
.37341 .34274 m
.37341 .34274 L
s
.37348 .34367 m
.37348 .34367 L
s
.37356 .34391 m
.37356 .34391 L
s
.37363 .33874 m
.37363 .33874 L
s
.3737 .3371 m
.3737 .3371 L
s
.37377 .33616 m
.37377 .33616 L
s
.37385 .33639 m
.37385 .33639 L
s
.37392 .33334 m
.37392 .33334 L
s
.374 .33451 m
.374 .33451 L
s
.37408 .33545 m
.37408 .33545 L
s
.37415 .33733 m
.37415 .33733 L
s
.37422 .34414 m
.37422 .34414 L
s
.3743 .34461 m
.3743 .34461 L
s
.37438 .34038 m
.37438 .34038 L
s
.37445 .34766 m
.37445 .34766 L
s
.37452 .35142 m
.37452 .35142 L
s
.37459 .35495 m
.37459 .35495 L
s
.37467 .35683 m
.37467 .35683 L
s
.37474 .35518 m
.37474 .35518 L
s
.37482 .35565 m
.37482 .35565 L
s
.37489 .35213 m
.37489 .35213 L
s
.37497 .35331 m
.37497 .35331 L
s
.37504 .3472 m
.37504 .3472 L
s
.37512 .34344 m
.37512 .34344 L
s
.37519 .34555 m
.37519 .34555 L
s
.37527 .35236 m
.37527 .35236 L
s
.37533 .35424 m
.37533 .35424 L
s
.37541 .35189 m
.37541 .35189 L
s
.37548 .34813 m
.37548 .34813 L
s
.37556 .3486 m
.37556 .3486 L
s
.37564 .35307 m
.37564 .35307 L
s
.37571 .35307 m
.37571 .35307 L
s
.37579 .35448 m
.37579 .35448 L
s
.37586 .35448 m
.37586 .35448 L
s
.37593 .35565 m
.37593 .35565 L
s
.37601 .35002 m
.37601 .35002 L
s
.37608 .3479 m
.37608 .3479 L
s
.37615 .34555 m
.37615 .34555 L
s
.37623 .34602 m
.37623 .34602 L
s
.3763 .34555 m
.3763 .34555 L
s
.37638 .34367 m
.37638 .34367 L
s
.37645 .34203 m
.37645 .34203 L
s
.37653 .34109 m
.37653 .34109 L
s
.3766 .33921 m
.3766 .33921 L
s
.37667 .33592 m
.37667 .33592 L
s
.37675 .34038 m
.37675 .34038 L
s
.37683 .34391 m
.37683 .34391 L
s
.3769 .34884 m
.3769 .34884 L
s
.37697 .34602 m
.37697 .34602 L
s
.37704 .3479 m
.37704 .3479 L
s
.37712 .35119 m
.37712 .35119 L
s
.3772 .35823 m
.3772 .35823 L
s
.37727 .35424 m
.37727 .35424 L
s
.37735 .35213 m
.37735 .35213 L
s
.37742 .35189 m
.37742 .35189 L
s
.37749 .3486 m
.37749 .3486 L
s
.37756 .3472 m
.37756 .3472 L
s
.37764 .35541 m
.37764 .35541 L
s
.37772 .35753 m
.37772 .35753 L
s
.37779 .35659 m
.37779 .35659 L
s
.37786 .35588 m
.37786 .35588 L
s
.37794 .36059 m
.37794 .36059 L
s
.37801 .36551 m
.37801 .36551 L
s
.37809 .36505 m
.37809 .36505 L
s
.37816 .36411 m
.37816 .36411 L
s
.37824 .35753 m
.37824 .35753 L
s
.3783 .36223 m
.3783 .36223 L
s
.37838 .36622 m
.37838 .36622 L
s
.37846 .36035 m
.37846 .36035 L
s
.37853 .36458 m
.37853 .36458 L
s
.3786 .36059 m
.3786 .36059 L
s
.37868 .35941 m
.37868 .35941 L
s
.37876 .36481 m
.37876 .36481 L
s
.37883 .36646 m
.37883 .36646 L
s
.37891 .36763 m
.37891 .36763 L
s
.37898 .36998 m
.37898 .36998 L
s
.37905 .37538 m
.37905 .37538 L
s
.37912 .37656 m
.37912 .37656 L
s
.3792 .38736 m
.3792 .38736 L
s
.37927 .38877 m
.37927 .38877 L
s
.37935 .39441 m
.37935 .39441 L
s
.37942 .39488 m
.37942 .39488 L
s
.3795 .39488 m
.3795 .39488 L
s
.37957 .39652 m
.37957 .39652 L
s
.37965 .40333 m
.37965 .40333 L
s
.37972 .39934 m
.37972 .39934 L
s
.3798 .40099 m
.3798 .40099 L
s
.37987 .39699 m
.37987 .39699 L
s
.37994 .39464 m
.37994 .39464 L
s
.38001 .39299 m
.38001 .39299 L
s
.38009 .38807 m
.38009 .38807 L
s
.38016 .3883 m
.38016 .3883 L
s
.38024 .38689 m
.38024 .38689 L
s
.38032 .39582 m
.38032 .39582 L
s
.38039 .39605 m
.38039 .39605 L
s
.38047 .3991 m
.38047 .3991 L
s
.38054 .40169 m
.38054 .40169 L
s
.38062 .40028 m
.38062 .40028 L
s
.38069 .39957 m
.38069 .39957 L
s
.38076 .39934 m
.38076 .39934 L
s
.38083 .39887 m
.38083 .39887 L
s
.38091 .39182 m
.38091 .39182 L
s
.38098 .39299 m
.38098 .39299 L
s
.38106 .38689 m
.38106 .38689 L
s
.38113 .38783 m
.38113 .38783 L
s
.38121 .38924 m
.38121 .38924 L
s
.38128 .39018 m
.38128 .39018 L
s
.38136 .38384 m
.38136 .38384 L
s
.38143 .38172 m
.38143 .38172 L
s
.3815 .38266 m
.3815 .38266 L
s
.38157 .38172 m
.38157 .38172 L
s
.38165 .37773 m
.38165 .37773 L
s
.38172 .37961 m
.38172 .37961 L
s
.3818 .38431 m
.3818 .38431 L
s
.38188 .38595 m
.38188 .38595 L
s
.38195 .39042 m
.38195 .39042 L
s
.38202 .39253 m
.38202 .39253 L
s
.3821 .39182 m
.3821 .39182 L
s
.38218 .39441 m
.38218 .39441 L
s
.38225 .39699 m
.38225 .39699 L
s
.38232 .40263 m
.38232 .40263 L
s
.38239 .40474 m
.38239 .40474 L
s
.38247 .39863 m
.38247 .39863 L
s
.38254 .39558 m
.38254 .39558 L
s
.38262 .3977 m
.38262 .3977 L
s
.38269 .40028 m
.38269 .40028 L
s
.38277 .4031 m
.38277 .4031 L
s
.38284 .40145 m
.38284 .40145 L
s
.38292 .39206 m
.38292 .39206 L
s
.38299 .39065 m
.38299 .39065 L
s
.38307 .38431 m
.38307 .38431 L
s
.38313 .38571 m
.38313 .38571 L
s
.38321 .38571 m
.38321 .38571 L
s
.38328 .38947 m
.38328 .38947 L
s
.38336 .39417 m
.38336 .39417 L
s
.38344 .39253 m
.38344 .39253 L
s
.38351 .39042 m
.38351 .39042 L
s
.38359 .38618 m
.38359 .38618 L
s
.38366 .38361 m
.38366 .38361 L
s
.38373 .38196 m
.38373 .38196 L
s
.38381 .37679 m
.38381 .37679 L
s
.38388 .37632 m
.38388 .37632 L
s
.38395 .38289 m
.38395 .38289 L
s
.38403 .37397 m
.38403 .37397 L
s
.3841 .37397 m
.3841 .37397 L
s
.38418 .36927 m
.38418 .36927 L
s
.38425 .37092 m
.38425 .37092 L
s
.38433 .37092 m
.38433 .37092 L
s
.3844 .36857 m
.3844 .36857 L
s
.38447 .36035 m
.38447 .36035 L
s
.38455 .36598 m
.38455 .36598 L
s
.38463 .36481 m
.38463 .36481 L
s
.3847 .36317 m
.3847 .36317 L
s
.38477 .3688 m
.38477 .3688 L
s
.38484 .37186 m
.38484 .37186 L
s
.38492 .37397 m
.38492 .37397 L
s
.385 .37115 m
.385 .37115 L
s
.38507 .37209 m
.38507 .37209 L
s
.38515 .37632 m
.38515 .37632 L
s
.38522 .37491 m
.38522 .37491 L
s
.38529 .37632 m
.38529 .37632 L
s
.38536 .37303 m
.38536 .37303 L
s
.38544 .37468 m
.38544 .37468 L
s
.38552 .37656 m
.38552 .37656 L
s
.38559 .37984 m
.38559 .37984 L
s
.38566 .38713 m
.38566 .38713 L
s
.38574 .39346 m
.38574 .39346 L
s
.38581 .38172 m
.38581 .38172 L
s
.38589 .38595 m
.38589 .38595 L
s
.38596 .39276 m
.38596 .39276 L
s
.38604 .39535 m
.38604 .39535 L
s
.3861 .39535 m
.3861 .39535 L
s
.38618 .39323 m
.38618 .39323 L
s
.38626 .39558 m
.38626 .39558 L
s
.38633 .39723 m
.38633 .39723 L
s
.3864 .39605 m
.3864 .39605 L
s
.38648 .39441 m
.38648 .39441 L
s
.38656 .39417 m
.38656 .39417 L
s
.38663 .39582 m
.38663 .39582 L
s
.38671 .40263 m
.38671 .40263 L
s
.38678 .39793 m
.38678 .39793 L
s
.38685 .3984 m
.38685 .3984 L
s
.38692 .3984 m
.38692 .3984 L
s
.387 .39981 m
.387 .39981 L
s
.38708 .39582 m
.38708 .39582 L
s
.38715 .39323 m
.38715 .39323 L
s
.38722 .39253 m
.38722 .39253 L
s
.3873 .39817 m
.3873 .39817 L
s
.38737 .39981 m
.38737 .39981 L
s
.38745 .39934 m
.38745 .39934 L
s
.38752 .39652 m
.38752 .39652 L
s
.3876 .39206 m
.3876 .39206 L
s
.38767 .38947 m
.38767 .38947 L
s
.38774 .39323 m
.38774 .39323 L
s
.38781 .39394 m
.38781 .39394 L
s
.38789 .38877 m
.38789 .38877 L
s
.38796 .39018 m
.38796 .39018 L
s
.38804 .39276 m
.38804 .39276 L
s
.38812 .39464 m
.38812 .39464 L
s
.38819 .38783 m
.38819 .38783 L
s
.38827 .39042 m
.38827 .39042 L
s
.38834 .39182 m
.38834 .39182 L
s
.38842 .38994 m
.38842 .38994 L
s
.38849 .38713 m
.38849 .38713 L
s
.38856 .38525 m
.38856 .38525 L
s
.38863 .38525 m
.38863 .38525 L
s
.38871 .37937 m
.38871 .37937 L
s
.38878 .37303 m
.38878 .37303 L
s
.38886 .37538 m
.38886 .37538 L
s
.38893 .37491 m
.38893 .37491 L
s
.38901 .37843 m
.38901 .37843 L
s
.38908 .37491 m
.38908 .37491 L
s
.38916 .37656 m
.38916 .37656 L
s
.38923 .3775 m
.38923 .3775 L
s
.3893 .37585 m
.3893 .37585 L
s
.38937 .37209 m
.38937 .37209 L
s
.38945 .37561 m
.38945 .37561 L
s
.38952 .37656 m
.38952 .37656 L
s
.3896 .37115 m
.3896 .37115 L
s
.38968 .36622 m
.38968 .36622 L
s
.38975 .36434 m
.38975 .36434 L
s
.38983 .36927 m
.38983 .36927 L
s
.3899 .36481 m
.3899 .36481 L
s
.38998 .36833 m
.38998 .36833 L
s
.39005 .36716 m
.39005 .36716 L
s
.39012 .37045 m
.39012 .37045 L
s
.39019 .37374 m
.39019 .37374 L
s
.39027 .37656 m
.39027 .37656 L
s
.39034 .37279 m
.39034 .37279 L
s
.39042 .37351 m
.39042 .37351 L
s
.39049 .36857 m
.39049 .36857 L
s
.39057 .3688 m
.39057 .3688 L
s
.39064 .37351 m
.39064 .37351 L
s
.39072 .36646 m
.39072 .36646 L
s
.39079 .36269 m
.39079 .36269 L
s
.39087 .36059 m
.39087 .36059 L
s
.39093 .36317 m
.39093 .36317 L
s
.39101 .36269 m
.39101 .36269 L
s
.39108 .35471 m
.39108 .35471 L
s
.39116 .3573 m
.39116 .3573 L
s
.39124 .36082 m
.39124 .36082 L
s
.39131 .35636 m
.39131 .35636 L
s
.39139 .35636 m
.39139 .35636 L
s
.39146 .36434 m
.39146 .36434 L
s
.39154 .36341 m
.39154 .36341 L
s
.39161 .36364 m
.39161 .36364 L
s
.39169 .36693 m
.39169 .36693 L
s
.39175 .37115 m
.39175 .37115 L
s
.39183 .37374 m
.39183 .37374 L
s
.3919 .37703 m
.3919 .37703 L
s
.39198 .37585 m
.39198 .37585 L
s
.39205 .3688 m
.39205 .3688 L
s
.39213 .37022 m
.39213 .37022 L
s
.3922 .36833 m
.3922 .36833 L
s
.39227 .37022 m
.39227 .37022 L
s
.39235 .36693 m
.39235 .36693 L
s
.39243 .37468 m
.39243 .37468 L
s
.3925 .3688 m
.3925 .3688 L
s
.39257 .36622 m
.39257 .36622 L
s
.39264 .36833 m
.39264 .36833 L
s
.39272 .37186 m
.39272 .37186 L
s
.3928 .37421 m
.3928 .37421 L
s
.39287 .3789 m
.39287 .3789 L
s
.39295 .38219 m
.39295 .38219 L
s
.39302 .37561 m
.39302 .37561 L
s
.39309 .37351 m
.39309 .37351 L
s
.39317 .37186 m
.39317 .37186 L
s
.39325 .37468 m
.39325 .37468 L
s
.39332 .37843 m
.39332 .37843 L
s
.39339 .37397 m
.39339 .37397 L
s
.39346 .36974 m
.39346 .36974 L
s
.39354 .37327 m
.39354 .37327 L
s
.39361 .37092 m
.39361 .37092 L
s
.39369 .37374 m
.39369 .37374 L
s
.39376 .36998 m
.39376 .36998 L
s
.39384 .37233 m
.39384 .37233 L
s
.39391 .37585 m
.39391 .37585 L
s
.39398 .37773 m
.39398 .37773 L
s
.39406 .38055 m
.39406 .38055 L
s
.39413 .38243 m
.39413 .38243 L
s
.3942 .38478 m
.3942 .38478 L
s
.39428 .37914 m
.39428 .37914 L
s
.39436 .37656 m
.39436 .37656 L
s
.39443 .37491 m
.39443 .37491 L
s
.39451 .37632 m
.39451 .37632 L
s
.39458 .37444 m
.39458 .37444 L
s
.39466 .38289 m
.39466 .38289 L
s
.39472 .38266 m
.39472 .38266 L
s
.3948 .38431 m
.3948 .38431 L
s
.39488 .38571 m
.39488 .38571 L
s
.39495 .37984 m
.39495 .37984 L
s
.39502 .3782 m
.39502 .3782 L
s
.3951 .37468 m
.3951 .37468 L
s
.39517 .36551 m
.39517 .36551 L
s
.39525 .37092 m
.39525 .37092 L
s
.39532 .36669 m
.39532 .36669 L
s
.3954 .36481 m
.3954 .36481 L
s
.39547 .36317 m
.39547 .36317 L
s
.39554 .36716 m
.39554 .36716 L
s
.39561 .36622 m
.39561 .36622 L
s
.39569 .36551 m
.39569 .36551 L
s
.39577 .36693 m
.39577 .36693 L
s
.39584 .36505 m
.39584 .36505 L
s
.39592 .36646 m
.39592 .36646 L
s
.39599 .35917 m
.39599 .35917 L
s
.39607 .36269 m
.39607 .36269 L
s
.39614 .36411 m
.39614 .36411 L
s
.39622 .35189 m
.39622 .35189 L
s
.39629 .3587 m
.39629 .3587 L
s
.39636 .36059 m
.39636 .36059 L
s
.39643 .36269 m
.39643 .36269 L
s
.39651 .35894 m
.39651 .35894 L
s
.39658 .35941 m
.39658 .35941 L
s
.39666 .35894 m
.39666 .35894 L
s
.39673 .36998 m
.39673 .36998 L
s
.39681 .37186 m
.39681 .37186 L
s
.39688 .37092 m
.39688 .37092 L
s
.39696 .36387 m
.39696 .36387 L
s
.39703 .36974 m
.39703 .36974 L
s
.3971 .36505 m
.3971 .36505 L
s
.39717 .36974 m
.39717 .36974 L
s
.39725 .37421 m
.39725 .37421 L
s
.39732 .3674 m
.39732 .3674 L
s
.3974 .358 m
.3974 .358 L
s
.39748 .36364 m
.39748 .36364 L
s
.39755 .36223 m
.39755 .36223 L
s
.39763 .3681 m
.39763 .3681 L
s
.3977 .37209 m
.3977 .37209 L
s
.39778 .37162 m
.39778 .37162 L
s
.39785 .36598 m
.39785 .36598 L
s
.39792 .37374 m
.39792 .37374 L
s
.39799 .37491 m
.39799 .37491 L
s
.39807 .37444 m
.39807 .37444 L
s
.39814 .37303 m
.39814 .37303 L
s
.39822 .37632 m
.39822 .37632 L
s
.39829 .37186 m
.39829 .37186 L
s
.39837 .37162 m
.39837 .37162 L
s
.39844 .37209 m
.39844 .37209 L
s
.39852 .37186 m
.39852 .37186 L
s
.39859 .36622 m
.39859 .36622 L
s
.39867 .36857 m
.39867 .36857 L
s
.39874 .37022 m
.39874 .37022 L
s
.39881 .36082 m
.39881 .36082 L
s
.39888 .36598 m
.39888 .36598 L
s
.39896 .36598 m
.39896 .36598 L
s
.39904 .36364 m
.39904 .36364 L
s
.39911 .36833 m
.39911 .36833 L
s
.39919 .36998 m
.39919 .36998 L
s
.39926 .36152 m
.39926 .36152 L
s
.39934 .358 m
.39934 .358 L
s
.39941 .35588 m
.39941 .35588 L
s
.39949 .35965 m
.39949 .35965 L
s
.39955 .36105 m
.39955 .36105 L
s
.39963 .35941 m
.39963 .35941 L
s
.3997 .35988 m
.3997 .35988 L
s
.39978 .36293 m
.39978 .36293 L
s
.39985 .36833 m
.39985 .36833 L
s
.39993 .36763 m
.39993 .36763 L
s
.4 .36505 m
.4 .36505 L
s
.40008 .3688 m
.40008 .3688 L
s
.40015 .36035 m
.40015 .36035 L
s
.40023 .36951 m
.40023 .36951 L
s
.4003 .36974 m
.4003 .36974 L
s
.40037 .36693 m
.40037 .36693 L
s
.40044 .36575 m
.40044 .36575 L
s
.40052 .35847 m
.40052 .35847 L
s
.4006 .36105 m
.4006 .36105 L
s
.40067 .35659 m
.40067 .35659 L
s
.40075 .35095 m
.40075 .35095 L
s
.40082 .36293 m
.40082 .36293 L
s
.40089 .36293 m
.40089 .36293 L
s
.40097 .36458 m
.40097 .36458 L
s
.40105 .36269 m
.40105 .36269 L
s
.40112 .36152 m
.40112 .36152 L
s
.40119 .36176 m
.40119 .36176 L
s
.40126 .36293 m
.40126 .36293 L
s
.40134 .36152 m
.40134 .36152 L
s
.40141 .36269 m
.40141 .36269 L
s
.40149 .36857 m
.40149 .36857 L
s
.40156 .37139 m
.40156 .37139 L
s
.40164 .37515 m
.40164 .37515 L
s
.40171 .37397 m
.40171 .37397 L
s
.40179 .36458 m
.40179 .36458 L
s
.40186 .36528 m
.40186 .36528 L
s
.40193 .36059 m
.40193 .36059 L
s
.402 .36035 m
.402 .36035 L
s
.40208 .35471 m
.40208 .35471 L
s
.40216 .35284 m
.40216 .35284 L
s
.40223 .35259 m
.40223 .35259 L
s
.40231 .35189 m
.40231 .35189 L
s
.40238 .35236 m
.40238 .35236 L
s
.40246 .35072 m
.40246 .35072 L
s
.40252 .35002 m
.40252 .35002 L
s
.4026 .34813 m
.4026 .34813 L
s
.40268 .34978 m
.40268 .34978 L
s
.40275 .35213 m
.40275 .35213 L
s
.40282 .34907 m
.40282 .34907 L
s
.4029 .35166 m
.4029 .35166 L
s
.40297 .35894 m
.40297 .35894 L
s
.40305 .36176 m
.40305 .36176 L
s
.40312 .35588 m
.40312 .35588 L
s
.4032 .35048 m
.4032 .35048 L
s
.40327 .35002 m
.40327 .35002 L
s
.40334 .34391 m
.40334 .34391 L
s
.40342 .34485 m
.40342 .34485 L
s
.4035 .33968 m
.4035 .33968 L
s
.40357 .33897 m
.40357 .33897 L
s
.40364 .34485 m
.40364 .34485 L
s
.40372 .34531 m
.40372 .34531 L
s
.40379 .34696 m
.40379 .34696 L
s
.40387 .3472 m
.40387 .3472 L
s
.40394 .35401 m
.40394 .35401 L
s
.40402 .35424 m
.40402 .35424 L
s
.40409 .35236 m
.40409 .35236 L
s
.40416 .34485 m
.40416 .34485 L
s
.40423 .34249 m
.40423 .34249 L
s
.40431 .34132 m
.40431 .34132 L
s
.40438 .34226 m
.40438 .34226 L
s
.40446 .34226 m
.40446 .34226 L
s
.40453 .34156 m
.40453 .34156 L
s
.40461 .33803 m
.40461 .33803 L
s
.40468 .33545 m
.40468 .33545 L
s
.40476 .33945 m
.40476 .33945 L
s
.40483 .33827 m
.40483 .33827 L
s
.4049 .33686 m
.4049 .33686 L
s
.40497 .33592 m
.40497 .33592 L
s
.40505 .34297 m
.40505 .34297 L
s
.40513 .34578 m
.40513 .34578 L
s
.4052 .34367 m
.4052 .34367 L
s
.40528 .35048 m
.40528 .35048 L
s
.40535 .35025 m
.40535 .35025 L
s
.40543 .3486 m
.40543 .3486 L
s
.4055 .34766 m
.4055 .34766 L
s
.40558 .34297 m
.40558 .34297 L
s
.40565 .34414 m
.40565 .34414 L
s
.40572 .34367 m
.40572 .34367 L
s
.40579 .3385 m
.40579 .3385 L
s
.40587 .34109 m
.40587 .34109 L
s
.40594 .34391 m
.40594 .34391 L
s
.40602 .34226 m
.40602 .34226 L
s
.40609 .34414 m
.40609 .34414 L
s
.40617 .34391 m
.40617 .34391 L
s
.40624 .34766 m
.40624 .34766 L
s
.40632 .34955 m
.40632 .34955 L
s
.40639 .34626 m
.40639 .34626 L
s
.40647 .34602 m
.40647 .34602 L
s
.40654 .35612 m
.40654 .35612 L
s
.40661 .35072 m
.40661 .35072 L
s
.40668 .35471 m
.40668 .35471 L
s
.40676 .35518 m
.40676 .35518 L
s
.40684 .35565 m
.40684 .35565 L
s
.40691 .35401 m
.40691 .35401 L
s
.40699 .34884 m
.40699 .34884 L
s
.40706 .35189 m
.40706 .35189 L
s
.40714 .34931 m
.40714 .34931 L
s
.40721 .35471 m
.40721 .35471 L
s
.40729 .34766 m
.40729 .34766 L
s
.40735 .33874 m
.40735 .33874 L
s
.40743 .34179 m
.40743 .34179 L
s
.4075 .3472 m
.4075 .3472 L
s
.40758 .34673 m
.40758 .34673 L
s
.40765 .34884 m
.40765 .34884 L
s
.40773 .35213 m
.40773 .35213 L
s
.4078 .35777 m
.4078 .35777 L
s
.40788 .35612 m
.40788 .35612 L
s
.40795 .35988 m
.40795 .35988 L
s
.40803 .36598 m
.40803 .36598 L
s
.4081 .37022 m
.4081 .37022 L
s
.40817 .36716 m
.40817 .36716 L
s
.40824 .36551 m
.40824 .36551 L
s
.40832 .36974 m
.40832 .36974 L
s
.4084 .36364 m
.4084 .36364 L
s
.40847 .36833 m
.40847 .36833 L
s
.40855 .37069 m
.40855 .37069 L
s
.40862 .36646 m
.40862 .36646 L
s
.4087 .37233 m
.4087 .37233 L
s
.40877 .36904 m
.40877 .36904 L
s
.40885 .37303 m
.40885 .37303 L
s
.40892 .37374 m
.40892 .37374 L
s
.40899 .3688 m
.40899 .3688 L
s
.40906 .36387 m
.40906 .36387 L
s
.40914 .37351 m
.40914 .37351 L
s
.40921 .37327 m
.40921 .37327 L
s
.40929 .37303 m
.40929 .37303 L
s
.40936 .38219 m
.40936 .38219 L
s
.40944 .37914 m
.40944 .37914 L
s
.40951 .38243 m
.40951 .38243 L
s
.40959 .37937 m
.40959 .37937 L
s
.40966 .37444 m
.40966 .37444 L
s
.40973 .37351 m
.40973 .37351 L
s
.4098 .36927 m
.4098 .36927 L
s
.40988 .36833 m
.40988 .36833 L
s
.40996 .37115 m
.40996 .37115 L
s
.41003 .3782 m
.41003 .3782 L
s
.41011 .37491 m
.41011 .37491 L
s
.41018 .38125 m
.41018 .38125 L
s
.41026 .38266 m
.41026 .38266 L
s
.41033 .38618 m
.41033 .38618 L
s
.41041 .38595 m
.41041 .38595 L
s
.41048 .3876 m
.41048 .3876 L
s
.41055 .38548 m
.41055 .38548 L
s
.41062 .38289 m
.41062 .38289 L
s
.4107 .37303 m
.4107 .37303 L
s
.41077 .37538 m
.41077 .37538 L
s
.41085 .37279 m
.41085 .37279 L
s
.41092 .37444 m
.41092 .37444 L
s
.411 .3681 m
.411 .3681 L
s
.41107 .36411 m
.41107 .36411 L
s
.41114 .36481 m
.41114 .36481 L
s
.41122 .36551 m
.41122 .36551 L
s
.4113 .36857 m
.4113 .36857 L
s
.41137 .36833 m
.41137 .36833 L
s
.41144 .36763 m
.41144 .36763 L
s
.41152 .36341 m
.41152 .36341 L
s
.41159 .36317 m
.41159 .36317 L
s
.41167 .36505 m
.41167 .36505 L
s
.41174 .36152 m
.41174 .36152 L
s
.41182 .36505 m
.41182 .36505 L
s
.41189 .3587 m
.41189 .3587 L
s
.41196 .35777 m
.41196 .35777 L
s
.41204 .35636 m
.41204 .35636 L
s
.41212 .35847 m
.41212 .35847 L
s
.41218 .36082 m
.41218 .36082 L
s
.41226 .36246 m
.41226 .36246 L
s
.41233 .36082 m
.41233 .36082 L
s
.41241 .35941 m
.41241 .35941 L
s
.41248 .35777 m
.41248 .35777 L
s
.41256 .36246 m
.41256 .36246 L
s
.41263 .36269 m
.41263 .36269 L
s
.4127 .36082 m
.4127 .36082 L
s
.41277 .36763 m
.41277 .36763 L
s
.41285 .37022 m
.41285 .37022 L
s
.41293 .36693 m
.41293 .36693 L
s
.413 .36763 m
.413 .36763 L
s
.41308 .36317 m
.41308 .36317 L
s
.41315 .36082 m
.41315 .36082 L
s
.41323 .36411 m
.41323 .36411 L
s
.4133 .35988 m
.4133 .35988 L
s
.41338 .36223 m
.41338 .36223 L
s
.41345 .36598 m
.41345 .36598 L
s
.41352 .36223 m
.41352 .36223 L
s
.41359 .36176 m
.41359 .36176 L
s
.41367 .36293 m
.41367 .36293 L
s
.41375 .36387 m
.41375 .36387 L
s
.41382 .36246 m
.41382 .36246 L
s
.41389 .35988 m
.41389 .35988 L
s
.41397 .36152 m
.41397 .36152 L
s
.41404 .36035 m
.41404 .36035 L
s
.41412 .35448 m
.41412 .35448 L
s
.41419 .35307 m
.41419 .35307 L
s
.41427 .35284 m
.41427 .35284 L
s
.41434 .34156 m
.41434 .34156 L
s
.41441 .3385 m
.41441 .3385 L
s
.41448 .3331 m
.41448 .3331 L
s
.41456 .3284 m
.41456 .3284 L
s
.41464 .33287 m
.41464 .33287 L
s
.41471 .33357 m
.41471 .33357 L
s
.41479 .32958 m
.41479 .32958 L
s
.41486 .33827 m
.41486 .33827 L
s
.41494 .33498 m
.41494 .33498 L
s
.41501 .33287 m
.41501 .33287 L
s
.41509 .33475 m
.41509 .33475 L
s
.41515 .3371 m
.41515 .3371 L
s
.41523 .33945 m
.41523 .33945 L
s
.4153 .3385 m
.4153 .3385 L
s
.41538 .33992 m
.41538 .33992 L
s
.41545 .34249 m
.41545 .34249 L
s
.41553 .34203 m
.41553 .34203 L
s
.4156 .3432 m
.4156 .3432 L
s
.41568 .3378 m
.41568 .3378 L
s
.41575 .3371 m
.41575 .3371 L
s
.41583 .3371 m
.41583 .3371 L
s
.4159 .33052 m
.4159 .33052 L
s
.41597 .32864 m
.41597 .32864 L
s
.41604 .33099 m
.41604 .33099 L
s
.41612 .3284 m
.41612 .3284 L
s
.4162 .32347 m
.4162 .32347 L
s
.41627 .31995 m
.41627 .31995 L
s
.41635 .31666 m
.41635 .31666 L
s
.41642 .31549 m
.41642 .31549 L
s
.4165 .30962 m
.4165 .30962 L
s
.41657 .30726 m
.41657 .30726 L
s
.41665 .3021 m
.41665 .3021 L
s
.41672 .30092 m
.41672 .30092 L
s
.41679 .30985 m
.41679 .30985 L
s
.41686 .31172 m
.41686 .31172 L
s
.41694 .31172 m
.41694 .31172 L
s
.41701 .30985 m
.41701 .30985 L
s
.41709 .31008 m
.41709 .31008 L
s
.41716 .31337 m
.41716 .31337 L
s
.41724 .31196 m
.41724 .31196 L
s
.41731 .31619 m
.41731 .31619 L
s
.41739 .30891 m
.41739 .30891 L
s
.41746 .31079 m
.41746 .31079 L
s
.41753 .30868 m
.41753 .30868 L
s
.4176 .3122 m
.4176 .3122 L
s
.41768 .31361 m
.41768 .31361 L
s
.41776 .30891 m
.41776 .30891 L
s
.41783 .3075 m
.41783 .3075 L
s
.41791 .30162 m
.41791 .30162 L
s
.41798 .29881 m
.41798 .29881 L
s
.41806 .29411 m
.41806 .29411 L
s
.41813 .28706 m
.41813 .28706 L
s
.41821 .28918 m
.41821 .28918 L
s
.41828 .28777 m
.41828 .28777 L
s
.41835 .29177 m
.41835 .29177 L
s
.41842 .28706 m
.41842 .28706 L
s
.4185 .28331 m
.4185 .28331 L
s
.41857 .27838 m
.41857 .27838 L
s
.41865 .27908 m
.41865 .27908 L
s
.41872 .27509 m
.41872 .27509 L
s
.4188 .27203 m
.4188 .27203 L
s
.41887 .27109 m
.41887 .27109 L
s
.41895 .27157 m
.41895 .27157 L
s
.41902 .27297 m
.41902 .27297 L
s
.4191 .27203 m
.4191 .27203 L
s
.41917 .25982 m
.41917 .25982 L
s
.41924 .26147 m
.41924 .26147 L
s
.41932 .26052 m
.41932 .26052 L
s
.41939 .25841 m
.41939 .25841 L
s
.41947 .25935 m
.41947 .25935 L
s
.41954 .25676 m
.41954 .25676 L
s
.41962 .2516 m
.41962 .2516 L
s
.41969 .257 m
.41969 .257 L
s
.41976 .26123 m
.41976 .26123 L
s
.41984 .26452 m
.41984 .26452 L
s
.41992 .27062 m
.41992 .27062 L
s
.41998 .26875 m
.41998 .26875 L
s
.42006 .2678 m
.42006 .2678 L
s
.42013 .26992 m
.42013 .26992 L
s
.42021 .26357 m
.42021 .26357 L
s
.42028 .26217 m
.42028 .26217 L
s
.42036 .27062 m
.42036 .27062 L
s
.42043 .27015 m
.42043 .27015 L
s
.4205 .26733 m
.4205 .26733 L
s
.42058 .25935 m
.42058 .25935 L
s
.42066 .25301 m
.42066 .25301 L
s
.42073 .24948 m
.42073 .24948 L
s
.4208 .25301 m
.4208 .25301 L
s
.42088 .24972 m
.42088 .24972 L
s
.42095 .24596 m
.42095 .24596 L
s
.42103 .24972 m
.42103 .24972 L
s
.4211 .2523 m
.4211 .2523 L
s
.42118 .25207 m
.42118 .25207 L
s
.42125 .25183 m
.42125 .25183 L
s
.42132 .24878 m
.42132 .24878 L
s
.42139 .24173 m
.42139 .24173 L
s
.42147 .24337 m
.42147 .24337 L
s
.42155 .23962 m
.42155 .23962 L
s
.42162 .24337 m
.42162 .24337 L
s
.42169 .24291 m
.42169 .24291 L
s
.42177 .2509 m
.42177 .2509 L
s
.42184 .25771 m
.42184 .25771 L
s
.42192 .26123 m
.42192 .26123 L
s
.42199 .26499 m
.42199 .26499 L
s
.42207 .26898 m
.42207 .26898 L
s
.42214 .26757 m
.42214 .26757 L
s
.42221 .26968 m
.42221 .26968 L
s
.42229 .2678 m
.42229 .2678 L
s
.42236 .26616 m
.42236 .26616 L
s
.42244 .26569 m
.42244 .26569 L
s
.42251 .26898 m
.42251 .26898 L
s
.42259 .2718 m
.42259 .2718 L
s
.42266 .26311 m
.42266 .26311 L
s
.42274 .25888 m
.42274 .25888 L
s
.42281 .26686 m
.42281 .26686 L
s
.42289 .26686 m
.42289 .26686 L
s
.42295 .26029 m
.42295 .26029 L
s
.42303 .25254 m
.42303 .25254 L
s
.4231 .2509 m
.4231 .2509 L
s
.42318 .24337 m
.42318 .24337 L
s
.42325 .23798 m
.42325 .23798 L
s
.42333 .24055 m
.42333 .24055 L
s
.4234 .23539 m
.4234 .23539 L
s
.42348 .23374 m
.42348 .23374 L
s
.42355 .23516 m
.42355 .23516 L
s
.42363 .23539 m
.42363 .23539 L
s
.4237 .2368 m
.4237 .2368 L
s
.42377 .2408 m
.42377 .2408 L
s
.42384 .23492 m
.42384 .23492 L
s
.42392 .23351 m
.42392 .23351 L
s
.424 .23257 m
.424 .23257 L
s
.42407 .23163 m
.42407 .23163 L
s
.42415 .23703 m
.42415 .23703 L
s
.42422 .23422 m
.42422 .23422 L
s
.4243 .23351 m
.4243 .23351 L
s
.42437 .22529 m
.42437 .22529 L
s
.42445 .22741 m
.42445 .22741 L
s
.42452 .22271 m
.42452 .22271 L
s
.42459 .21965 m
.42459 .21965 L
s
.42466 .22012 m
.42466 .22012 L
s
.42474 .22552 m
.42474 .22552 L
s
.42481 .22364 m
.42481 .22364 L
s
.42489 .21824 m
.42489 .21824 L
s
.42496 .22271 m
.42496 .22271 L
s
.42504 .22153 m
.42504 .22153 L
s
.42511 .21989 m
.42511 .21989 L
s
.42519 .22247 m
.42519 .22247 L
s
.42526 .22083 m
.42526 .22083 L
s
.42533 .22224 m
.42533 .22224 L
s
.4254 .2213 m
.4254 .2213 L
s
.42548 .22599 m
.42548 .22599 L
s
.42556 .22459 m
.42556 .22459 L
s
.42563 .22341 m
.42563 .22341 L
s
.42571 .2321 m
.42571 .2321 L
s
.42578 .23327 m
.42578 .23327 L
s
.42586 .24173 m
.42586 .24173 L
s
.42593 .24197 m
.42593 .24197 L
s
.42601 .24384 m
.42601 .24384 L
s
.42608 .23962 m
.42608 .23962 L
s
.42615 .24314 m
.42615 .24314 L
s
.42622 .24361 m
.42622 .24361 L
s
.4263 .24408 m
.4263 .24408 L
s
.42637 .24337 m
.42637 .24337 L
s
.42645 .24526 m
.42645 .24526 L
s
.42652 .24761 m
.42652 .24761 L
s
.4266 .24549 m
.4266 .24549 L
s
.42667 .24948 m
.42667 .24948 L
s
.42675 .24808 m
.42675 .24808 L
s
.42682 .24808 m
.42682 .24808 L
s
.4269 .25065 m
.4269 .25065 L
s
.42697 .25277 m
.42697 .25277 L
s
.42704 .25301 m
.42704 .25301 L
s
.42712 .24713 m
.42712 .24713 L
s
.42719 .24901 m
.42719 .24901 L
s
.42727 .24643 m
.42727 .24643 L
s
.42734 .24995 m
.42734 .24995 L
s
.42742 .24855 m
.42742 .24855 L
s
.42749 .25207 m
.42749 .25207 L
s
.42757 .25277 m
.42757 .25277 L
s
.42764 .25512 m
.42764 .25512 L
s
.42772 .25277 m
.42772 .25277 L
s
.42778 .25347 m
.42778 .25347 L
s
.42786 .25606 m
.42786 .25606 L
s
.42793 .257 m
.42793 .257 L
s
.42801 .26217 m
.42801 .26217 L
s
.42808 .26404 m
.42808 .26404 L
s
.42816 .2617 m
.42816 .2617 L
s
.42823 .26311 m
.42823 .26311 L
s
.4283 .257 m
.4283 .257 L
s
.42838 .26075 m
.42838 .26075 L
s
.42846 .2678 m
.42846 .2678 L
s
.42853 .26404 m
.42853 .26404 L
s
.4286 .26123 m
.4286 .26123 L
s
.42868 .26075 m
.42868 .26075 L
s
.42875 .25935 m
.42875 .25935 L
s
.42883 .25935 m
.42883 .25935 L
s
.4289 .26334 m
.4289 .26334 L
s
.42898 .25794 m
.42898 .25794 L
s
.42905 .26546 m
.42905 .26546 L
s
.42912 .27085 m
.42912 .27085 L
s
.4292 .27085 m
.4292 .27085 L
s
.42928 .26546 m
.42928 .26546 L
s
.42935 .26733 m
.42935 .26733 L
s
.42942 .26264 m
.42942 .26264 L
s
.42949 .25536 m
.42949 .25536 L
s
.42957 .25301 m
.42957 .25301 L
s
.42964 .24713 m
.42964 .24713 L
s
.42972 .2469 m
.42972 .2469 L
s
.42979 .25371 m
.42979 .25371 L
s
.42987 .26005 m
.42987 .26005 L
s
.42994 .25888 m
.42994 .25888 L
s
.43001 .25418 m
.43001 .25418 L
s
.43009 .25137 m
.43009 .25137 L
s
.43017 .2516 m
.43017 .2516 L
s
.43024 .24784 m
.43024 .24784 L
s
.43031 .24925 m
.43031 .24925 L
s
.43039 .25042 m
.43039 .25042 L
s
.43046 .24901 m
.43046 .24901 L
s
.43054 .25301 m
.43054 .25301 L
s
.43061 .25019 m
.43061 .25019 L
s
.43069 .2523 m
.43069 .2523 L
s
.43075 .2523 m
.43075 .2523 L
s
.43083 .25559 m
.43083 .25559 L
s
.43091 .25629 m
.43091 .25629 L
s
.43098 .24948 m
.43098 .24948 L
s
.43105 .25254 m
.43105 .25254 L
s
.43113 .25982 m
.43113 .25982 L
s
.4312 .25747 m
.4312 .25747 L
s
.43128 .257 m
.43128 .257 L
s
.43135 .25113 m
.43135 .25113 L
s
.43143 .25512 m
.43143 .25512 L
s
.4315 .25042 m
.4315 .25042 L
s
.43157 .24972 m
.43157 .24972 L
s
.43164 .25042 m
.43164 .25042 L
s
.43172 .24103 m
.43172 .24103 L
s
.4318 .24197 m
.4318 .24197 L
s
.43187 .2408 m
.43187 .2408 L
s
.43195 .24127 m
.43195 .24127 L
s
.43202 .2368 m
.43202 .2368 L
s
.4321 .2368 m
.4321 .2368 L
s
.43217 .23845 m
.43217 .23845 L
s
.43225 .24479 m
.43225 .24479 L
s
.43232 .24596 m
.43232 .24596 L
s
.43239 .24761 m
.43239 .24761 L
s
.43246 .25418 m
.43246 .25418 L
s
.43254 .25042 m
.43254 .25042 L
s
.43261 .25207 m
.43261 .25207 L
s
.43269 .2523 m
.43269 .2523 L
s
.43276 .25606 m
.43276 .25606 L
s
.43284 .25277 m
.43284 .25277 L
s
.43291 .24972 m
.43291 .24972 L
s
.43299 .24713 m
.43299 .24713 L
s
.43306 .24901 m
.43306 .24901 L
s
.43314 .2509 m
.43314 .2509 L
s
.4332 .25042 m
.4332 .25042 L
s
.43328 .25371 m
.43328 .25371 L
s
.43336 .25653 m
.43336 .25653 L
s
.43343 .24737 m
.43343 .24737 L
s
.43351 .24479 m
.43351 .24479 L
s
.43358 .24009 m
.43358 .24009 L
s
.43366 .24314 m
.43366 .24314 L
s
.43373 .24173 m
.43373 .24173 L
s
.43381 .2415 m
.43381 .2415 L
s
.43388 .24643 m
.43388 .24643 L
s
.43395 .2469 m
.43395 .2469 L
s
.43402 .24384 m
.43402 .24384 L
s
.4341 .24972 m
.4341 .24972 L
s
.43417 .24291 m
.43417 .24291 L
s
.43425 .23985 m
.43425 .23985 L
s
.43432 .23492 m
.43432 .23492 L
s
.4344 .23422 m
.4344 .23422 L
s
.43447 .22811 m
.43447 .22811 L
s
.43455 .22506 m
.43455 .22506 L
s
.43462 .22858 m
.43462 .22858 L
s
.4347 .22599 m
.4347 .22599 L
s
.43477 .22271 m
.43477 .22271 L
s
.43484 .22247 m
.43484 .22247 L
s
.43492 .2307 m
.43492 .2307 L
s
.43499 .23492 m
.43499 .23492 L
s
.43507 .23539 m
.43507 .23539 L
s
.43514 .23821 m
.43514 .23821 L
s
.43522 .23045 m
.43522 .23045 L
s
.43529 .22764 m
.43529 .22764 L
s
.43537 .22552 m
.43537 .22552 L
s
.43544 .22741 m
.43544 .22741 L
s
.43552 .22552 m
.43552 .22552 L
s
.43558 .22364 m
.43558 .22364 L
s
.43566 .22153 m
.43566 .22153 L
s
.43573 .22153 m
.43573 .22153 L
s
.43581 .21965 m
.43581 .21965 L
s
.43588 .22177 m
.43588 .22177 L
s
.43596 .22106 m
.43596 .22106 L
s
.43603 .21496 m
.43603 .21496 L
s
.43611 .21378 m
.43611 .21378 L
s
.43618 .21848 m
.43618 .21848 L
s
.43626 .21965 m
.43626 .21965 L
s
.43633 .22341 m
.43633 .22341 L
s
.4364 .22153 m
.4364 .22153 L
s
.43648 .22317 m
.43648 .22317 L
s
.43655 .22928 m
.43655 .22928 L
s
.43663 .22788 m
.43663 .22788 L
s
.4367 .22177 m
.4367 .22177 L
s
.43678 .21731 m
.43678 .21731 L
s
.43685 .22341 m
.43685 .22341 L
s
.43692 .22693 m
.43692 .22693 L
s
.437 .22576 m
.437 .22576 L
s
.43708 .22364 m
.43708 .22364 L
s
.43715 .22599 m
.43715 .22599 L
s
.43722 .22623 m
.43722 .22623 L
s
.43729 .22646 m
.43729 .22646 L
s
.43737 .22364 m
.43737 .22364 L
s
.43744 .2213 m
.43744 .2213 L
s
.43752 .22153 m
.43752 .22153 L
s
.43759 .21402 m
.43759 .21402 L
s
.43767 .21472 m
.43767 .21472 L
s
.43774 .21965 m
.43774 .21965 L
s
.43782 .21801 m
.43782 .21801 L
s
.43789 .21472 m
.43789 .21472 L
s
.43797 .21355 m
.43797 .21355 L
s
.43804 .21731 m
.43804 .21731 L
s
.43811 .21683 m
.43811 .21683 L
s
.43819 .21778 m
.43819 .21778 L
s
.43826 .2206 m
.43826 .2206 L
s
.43834 .22341 m
.43834 .22341 L
s
.43841 .22224 m
.43841 .22224 L
s
.43849 .22153 m
.43849 .22153 L
s
.43855 .21613 m
.43855 .21613 L
s
.43863 .21613 m
.43863 .21613 L
s
.43871 .21636 m
.43871 .21636 L
s
.43878 .21425 m
.43878 .21425 L
s
.43885 .20415 m
.43885 .20415 L
s
.43893 .20579 m
.43893 .20579 L
s
.439 .20486 m
.439 .20486 L
s
.43908 .20016 m
.43908 .20016 L
s
.43915 .19311 m
.43915 .19311 L
s
.43923 .191 m
.43923 .191 L
s
.4393 .19429 m
.4393 .19429 L
s
.43937 .1924 m
.43937 .1924 L
s
.43945 .19358 m
.43945 .19358 L
s
.43953 .19053 m
.43953 .19053 L
s
.4396 .19287 m
.4396 .19287 L
s
.43967 .19804 m
.43967 .19804 L
s
.43975 .19922 m
.43975 .19922 L
s
.43982 .2011 m
.43982 .2011 L
s
.4399 .2018 m
.4399 .2018 L
s
.43997 .20532 m
.43997 .20532 L
s
.44005 .20979 m
.44005 .20979 L
s
.44012 .2112 m
.44012 .2112 L
s
.44019 .20955 m
.44019 .20955 L
s
.44026 .21402 m
.44026 .21402 L
s
.44034 .2166 m
.44034 .2166 L
s
.44041 .21096 m
.44041 .21096 L
s
.44049 .21378 m
.44049 .21378 L
s
.44056 .21989 m
.44056 .21989 L
s
.44064 .21731 m
.44064 .21731 L
s
.44071 .21284 m
.44071 .21284 L
s
.44079 .2119 m
.44079 .2119 L
s
.44086 .20439 m
.44086 .20439 L
s
.44094 .20791 m
.44094 .20791 L
s
.441 .20227 m
.441 .20227 L
s
.44108 .20297 m
.44108 .20297 L
s
.44116 .19992 m
.44116 .19992 L
s
.44123 .19992 m
.44123 .19992 L
s
.44131 .19593 m
.44131 .19593 L
s
.44138 .1964 m
.44138 .1964 L
s
.44146 .19335 m
.44146 .19335 L
s
.44153 .19217 m
.44153 .19217 L
s
.44161 .19123 m
.44161 .19123 L
s
.44168 .19217 m
.44168 .19217 L
s
.44175 .19194 m
.44175 .19194 L
s
.44182 .19616 m
.44182 .19616 L
s
.4419 .19898 m
.4419 .19898 L
s
.44197 .1964 m
.44197 .1964 L
s
.44205 .19522 m
.44205 .19522 L
s
.44212 .19217 m
.44212 .19217 L
s
.4422 .19311 m
.4422 .19311 L
s
.44227 .18748 m
.44227 .18748 L
s
.44235 .1903 m
.44235 .1903 L
s
.44242 .19123 m
.44242 .19123 L
s
.4425 .18654 m
.4425 .18654 L
s
.44257 .18395 m
.44257 .18395 L
s
.44264 .1863 m
.44264 .1863 L
s
.44272 .18512 m
.44272 .18512 L
s
.44279 .18748 m
.44279 .18748 L
s
.44287 .18254 m
.44287 .18254 L
s
.44294 .18325 m
.44294 .18325 L
s
.44302 .18184 m
.44302 .18184 L
s
.44309 .18395 m
.44309 .18395 L
s
.44317 .18137 m
.44317 .18137 L
s
.44324 .18794 m
.44324 .18794 L
s
.44332 .18654 m
.44332 .18654 L
s
.44338 .18983 m
.44338 .18983 L
s
.44346 .18794 m
.44346 .18794 L
s
.44353 .19546 m
.44353 .19546 L
s
.44361 .19522 m
.44361 .19522 L
s
.44368 .19476 m
.44368 .19476 L
s
.44376 .1917 m
.44376 .1917 L
s
.44383 .19264 m
.44383 .19264 L
s
.44391 .19522 m
.44391 .19522 L
s
.44398 .19452 m
.44398 .19452 L
s
.44406 .19711 m
.44406 .19711 L
s
.44413 .19875 m
.44413 .19875 L
s
.4442 .19711 m
.4442 .19711 L
s
.44428 .19804 m
.44428 .19804 L
s
.44435 .19123 m
.44435 .19123 L
s
.44443 .1917 m
.44443 .1917 L
s
.4445 .19405 m
.4445 .19405 L
s
.44458 .20768 m
.44458 .20768 L
s
.44465 .20556 m
.44465 .20556 L
s
.44473 .20838 m
.44473 .20838 L
s
.4448 .20439 m
.4448 .20439 L
s
.44488 .20861 m
.44488 .20861 L
s
.44495 .20297 m
.44495 .20297 L
s
.44502 .20768 m
.44502 .20768 L
s
.44509 .2065 m
.44509 .2065 L
s
.44517 .20932 m
.44517 .20932 L
s
.44524 .20415 m
.44524 .20415 L
s
.44532 .21167 m
.44532 .21167 L
s
.44539 .21355 m
.44539 .21355 L
s
.44547 .21143 m
.44547 .21143 L
s
.44554 .20932 m
.44554 .20932 L
s
.44562 .21237 m
.44562 .21237 L
s
.44569 .21096 m
.44569 .21096 L
s
.44577 .21707 m
.44577 .21707 L
s
.44584 .2213 m
.44584 .2213 L
s
.44591 .21542 m
.44591 .21542 L
s
.44599 .21519 m
.44599 .21519 L
s
.44606 .21731 m
.44606 .21731 L
s
.44614 .22247 m
.44614 .22247 L
s
.44621 .22764 m
.44621 .22764 L
s
.44629 .22928 m
.44629 .22928 L
s
.44636 .23234 m
.44636 .23234 L
s
.44644 .23304 m
.44644 .23304 L
s
.44651 .22975 m
.44651 .22975 L
s
.44658 .22459 m
.44658 .22459 L
s
.44665 .22083 m
.44665 .22083 L
s
.44673 .22741 m
.44673 .22741 L
s
.4468 .22811 m
.4468 .22811 L
s
.44688 .21942 m
.44688 .21942 L
s
.44695 .22083 m
.44695 .22083 L
s
.44703 .22435 m
.44703 .22435 L
s
.4471 .2307 m
.4471 .2307 L
s
.44717 .2267 m
.44717 .2267 L
s
.44725 .22693 m
.44725 .22693 L
s
.44733 .23234 m
.44733 .23234 L
s
.4474 .22764 m
.4474 .22764 L
s
.44747 .23022 m
.44747 .23022 L
s
.44755 .22529 m
.44755 .22529 L
s
.44762 .22341 m
.44762 .22341 L
s
.4477 .21683 m
.4477 .21683 L
s
.44777 .21801 m
.44777 .21801 L
s
.44785 .222 m
.44785 .222 L
s
.44792 .22576 m
.44792 .22576 L
s
.44799 .22083 m
.44799 .22083 L
s
.44807 .21589 m
.44807 .21589 L
s
.44815 .21167 m
.44815 .21167 L
s
.44821 .21284 m
.44821 .21284 L
s
.44829 .21871 m
.44829 .21871 L
s
.44836 .21895 m
.44836 .21895 L
s
.44844 .22153 m
.44844 .22153 L
s
.44851 .21449 m
.44851 .21449 L
s
.44859 .22083 m
.44859 .22083 L
s
.44866 .22271 m
.44866 .22271 L
s
.44874 .21871 m
.44874 .21871 L
s
.4488 .21683 m
.4488 .21683 L
s
.44888 .21683 m
.44888 .21683 L
s
.44896 .21965 m
.44896 .21965 L
s
.44903 .21143 m
.44903 .21143 L
s
.44911 .21307 m
.44911 .21307 L
s
.44918 .21284 m
.44918 .21284 L
s
.44926 .21355 m
.44926 .21355 L
s
.44933 .2166 m
.44933 .2166 L
s
.44941 .21871 m
.44941 .21871 L
s
.44948 .21355 m
.44948 .21355 L
s
.44955 .20885 m
.44955 .20885 L
s
.44962 .20532 m
.44962 .20532 L
s
.4497 .20674 m
.4497 .20674 L
s
.44978 .21096 m
.44978 .21096 L
s
.44985 .21002 m
.44985 .21002 L
s
.44992 .2166 m
.44992 .2166 L
s
.45 .21378 m
.45 .21378 L
s
.45007 .21519 m
.45007 .21519 L
s
.45015 .21472 m
.45015 .21472 L
s
.45022 .21378 m
.45022 .21378 L
s
.4503 .21331 m
.4503 .21331 L
s
.45037 .20979 m
.45037 .20979 L
s
.45044 .20392 m
.45044 .20392 L
s
.45052 .20063 m
.45052 .20063 L
s
.45059 .20157 m
.45059 .20157 L
s
.45067 .20392 m
.45067 .20392 L
s
.45074 .20486 m
.45074 .20486 L
s
.45082 .19922 m
.45082 .19922 L
s
.45089 .19358 m
.45089 .19358 L
s
.45097 .19358 m
.45097 .19358 L
s
.45104 .19382 m
.45104 .19382 L
s
.45112 .19311 m
.45112 .19311 L
s
.45118 .18748 m
.45118 .18748 L
s
.45126 .19123 m
.45126 .19123 L
s
.45133 .18794 m
.45133 .18794 L
s
.45141 .18724 m
.45141 .18724 L
s
.45148 .18419 m
.45148 .18419 L
s
.45156 .17948 m
.45156 .17948 L
s
.45163 .17925 m
.45163 .17925 L
s
.45171 .1816 m
.45171 .1816 L
s
.45178 .17948 m
.45178 .17948 L
s
.45186 .17385 m
.45186 .17385 L
s
.45193 .17385 m
.45193 .17385 L
s
.452 .18489 m
.452 .18489 L
s
.45208 .17902 m
.45208 .17902 L
s
.45215 .1823 m
.45215 .1823 L
s
.45223 .18559 m
.45223 .18559 L
s
.4523 .17948 m
.4523 .17948 L
s
.45238 .18277 m
.45238 .18277 L
s
.45245 .17948 m
.45245 .17948 L
s
.45253 .18043 m
.45253 .18043 L
s
.4526 .17644 m
.4526 .17644 L
s
.45268 .17855 m
.45268 .17855 L
s
.45275 .17667 m
.45275 .17667 L
s
.45282 .17338 m
.45282 .17338 L
s
.45289 .17644 m
.45289 .17644 L
s
.45297 .16939 m
.45297 .16939 L
s
.45304 .1715 m
.45304 .1715 L
s
.45312 .17784 m
.45312 .17784 L
s
.45319 .17315 m
.45319 .17315 L
s
.45327 .17127 m
.45327 .17127 L
s
.45334 .16986 m
.45334 .16986 L
s
.45342 .16422 m
.45342 .16422 L
s
.45349 .16704 m
.45349 .16704 L
s
.45357 .16281 m
.45357 .16281 L
s
.45364 .16422 m
.45364 .16422 L
s
.45371 .16375 m
.45371 .16375 L
s
.45379 .16634 m
.45379 .16634 L
s
.45386 .16586 m
.45386 .16586 L
s
.45394 .16492 m
.45394 .16492 L
s
.45401 .16399 m
.45401 .16399 L
s
.45409 .1607 m
.45409 .1607 L
s
.45416 .15976 m
.45416 .15976 L
s
.45424 .16258 m
.45424 .16258 L
s
.45431 .16634 m
.45431 .16634 L
s
.45438 .16634 m
.45438 .16634 L
s
.45445 .16469 m
.45445 .16469 L
s
.45453 .16492 m
.45453 .16492 L
s
.4546 .16821 m
.4546 .16821 L
s
.45468 .16563 m
.45468 .16563 L
s
.45475 .16963 m
.45475 .16963 L
s
.45483 .16634 m
.45483 .16634 L
s
.4549 .16634 m
.4549 .16634 L
s
.45497 .17197 m
.45497 .17197 L
s
.45505 .17667 m
.45505 .17667 L
s
.45513 .18184 m
.45513 .18184 L
s
.4552 .18489 m
.4552 .18489 L
s
.45527 .18348 m
.45527 .18348 L
s
.45535 .18701 m
.45535 .18701 L
s
.45542 .19405 m
.45542 .19405 L
s
.4555 .18771 m
.4555 .18771 L
s
.45557 .18301 m
.45557 .18301 L
s
.45565 .18301 m
.45565 .18301 L
s
.45572 .18113 m
.45572 .18113 L
s
.45579 .17549 m
.45579 .17549 L
s
.45587 .17878 m
.45587 .17878 L
s
.45595 .17902 m
.45595 .17902 L
s
.45601 .17973 m
.45601 .17973 L
s
.45609 .17291 m
.45609 .17291 L
s
.45616 .17127 m
.45616 .17127 L
s
.45624 .17432 m
.45624 .17432 L
s
.45631 .17103 m
.45631 .17103 L
s
.45639 .16821 m
.45639 .16821 L
s
.45646 .16915 m
.45646 .16915 L
s
.45654 .16845 m
.45654 .16845 L
s
.4566 .16868 m
.4566 .16868 L
s
.45668 .17338 m
.45668 .17338 L
s
.45676 .17855 m
.45676 .17855 L
s
.45683 .1802 m
.45683 .1802 L
s
.45691 .17738 m
.45691 .17738 L
s
.45698 .17127 m
.45698 .17127 L
s
.45706 .17362 m
.45706 .17362 L
s
.45713 .17784 m
.45713 .17784 L
s
.45721 .18043 m
.45721 .18043 L
s
.45728 .18419 m
.45728 .18419 L
s
.45735 .18701 m
.45735 .18701 L
s
.45742 .18137 m
.45742 .18137 L
s
.4575 .18301 m
.4575 .18301 L
s
.45758 .18395 m
.45758 .18395 L
s
.45765 .18066 m
.45765 .18066 L
s
.45772 .18184 m
.45772 .18184 L
s
.4578 .18325 m
.4578 .18325 L
s
.45787 .17925 m
.45787 .17925 L
s
.45795 .18184 m
.45795 .18184 L
s
.45802 .17573 m
.45802 .17573 L
s
.4581 .17291 m
.4581 .17291 L
s
.45817 .18254 m
.45817 .18254 L
s
.45824 .18419 m
.45824 .18419 L
s
.45832 .17902 m
.45832 .17902 L
s
.45839 .17315 m
.45839 .17315 L
s
.45847 .16986 m
.45847 .16986 L
s
.45854 .16328 m
.45854 .16328 L
s
.45862 .15036 m
.45862 .15036 L
s
.45869 .15248 m
.45869 .15248 L
s
.45877 .14825 m
.45877 .14825 L
s
.45884 .14661 m
.45884 .14661 L
s
.45892 .14143 m
.45892 .14143 L
s
.45898 .14308 m
.45898 .14308 L
s
.45906 .13439 m
.45906 .13439 L
s
.45913 .1358 m
.45913 .1358 L
s
.45921 .13697 m
.45921 .13697 L
s
.45928 .13933 m
.45928 .13933 L
s
.45936 .14402 m
.45936 .14402 L
s
.45943 .14754 m
.45943 .14754 L
s
.45951 .14895 m
.45951 .14895 L
s
.45958 .14943 m
.45958 .14943 L
s
.45966 .152 m
.45966 .152 L
s
.45973 .14496 m
.45973 .14496 L
s
.4598 .14825 m
.4598 .14825 L
s
.45988 .15435 m
.45988 .15435 L
s
.45995 .14848 m
.45995 .14848 L
s
.46003 .14801 m
.46003 .14801 L
s
.4601 .1412 m
.4601 .1412 L
s
.46018 .14285 m
.46018 .14285 L
s
.46025 .13838 m
.46025 .13838 L
s
.46033 .14519 m
.46033 .14519 L
s
.4604 .14614 m
.4604 .14614 L
s
.46048 .14332 m
.46048 .14332 L
s
.46055 .13697 m
.46055 .13697 L
s
.46062 .13533 m
.46062 .13533 L
s
.46069 .13205 m
.46069 .13205 L
s
.46077 .1358 m
.46077 .1358 L
s
.46084 .13791 m
.46084 .13791 L
s
.46092 .13686 m
.46092 .13686 L
s
.46099 .13392 m
.46099 .13392 L
s
.46107 .13298 m
.46107 .13298 L
s
.46114 .13533 m
.46114 .13533 L
s
.46122 .13651 m
.46122 .13651 L
s
.46129 .14297 m
.46129 .14297 L
s
.46137 .14484 m
.46137 .14484 L
s
.46144 .14778 m
.46144 .14778 L
s
.46151 .14696 m
.46151 .14696 L
s
.46159 .14367 m
.46159 .14367 L
s
.46166 .14332 m
.46166 .14332 L
s
.46174 .14437 m
.46174 .14437 L
s
.46181 .14954 m
.46181 .14954 L
s
.46189 .14661 m
.46189 .14661 L
s
.46196 .14966 m
.46196 .14966 L
s
.46204 .14567 m
.46204 .14567 L
s
.46211 .14226 m
.46211 .14226 L
s
.46218 .14684 m
.46218 .14684 L
s
.46225 .14332 m
.46225 .14332 L
s
.46233 .1486 m
.46233 .1486 L
s
.4624 .14085 m
.4624 .14085 L
s
.46248 .13756 m
.46248 .13756 L
s
.46255 .14143 m
.46255 .14143 L
s
.46263 .14343 m
.46263 .14343 L
s
.4627 .1419 m
.4627 .1419 L
s
.46278 .14202 m
.46278 .14202 L
s
.46285 .14437 m
.46285 .14437 L
s
.46293 .14661 m
.46293 .14661 L
s
.463 .15224 m
.463 .15224 L
s
.46307 .1513 m
.46307 .1513 L
s
.46315 .15318 m
.46315 .15318 L
s
.46322 .15612 m
.46322 .15612 L
s
.4633 .154 m
.4633 .154 L
s
.46337 .14637 m
.46337 .14637 L
s
.46345 .14919 m
.46345 .14919 L
s
.46352 .14261 m
.46352 .14261 L
s
.46359 .13944 m
.46359 .13944 L
s
.46367 .14097 m
.46367 .14097 L
s
.46375 .14261 m
.46375 .14261 L
s
.46381 .13674 m
.46381 .13674 L
s
.46389 .13991 m
.46389 .13991 L
s
.46396 .13322 m
.46396 .13322 L
s
.46404 .13298 m
.46404 .13298 L
s
.46411 .14343 m
.46411 .14343 L
s
.46419 .14003 m
.46419 .14003 L
s
.46426 .14238 m
.46426 .14238 L
s
.46434 .14637 m
.46434 .14637 L
s
.46441 .14143 m
.46441 .14143 L
s
.46449 .14355 m
.46449 .14355 L
s
.46457 .14472 m
.46457 .14472 L
s
.46463 .14461 m
.46463 .14461 L
s
.46471 .14285 m
.46471 .14285 L
s
.46478 .14554 m
.46478 .14554 L
s
.46486 .14661 m
.46486 .14661 L
s
.46493 .1506 m
.46493 .1506 L
s
.46501 .15013 m
.46501 .15013 L
s
.46508 .15165 m
.46508 .15165 L
s
.46515 .15624 m
.46515 .15624 L
s
.46522 .15671 m
.46522 .15671 L
s
.4653 .16117 m
.4653 .16117 L
s
.46538 .16539 m
.46538 .16539 L
s
.46545 .16258 m
.46545 .16258 L
s
.46552 .15941 m
.46552 .15941 L
s
.4656 .16328 m
.4656 .16328 L
s
.46567 .16492 m
.46567 .16492 L
s
.46575 .16622 m
.46575 .16622 L
s
.46582 .16246 m
.46582 .16246 L
s
.4659 .16469 m
.4659 .16469 L
s
.46597 .16963 m
.46597 .16963 L
s
.46604 .17397 m
.46604 .17397 L
s
.46612 .17549 m
.46612 .17549 L
s
.4662 .18395 m
.4662 .18395 L
s
.46627 .18559 m
.46627 .18559 L
s
.46634 .18477 m
.46634 .18477 L
s
.46642 .18865 m
.46642 .18865 L
s
.46649 .17479 m
.46649 .17479 L
s
.46657 .17925 m
.46657 .17925 L
s
.46664 .18043 m
.46664 .18043 L
s
.46672 .1836 m
.46672 .1836 L
s
.46678 .18219 m
.46678 .18219 L
s
.46686 .1762 m
.46686 .1762 L
s
.46693 .17925 m
.46693 .17925 L
s
.46701 .18043 m
.46701 .18043 L
s
.46708 .18055 m
.46708 .18055 L
s
.46716 .18277 m
.46716 .18277 L
s
.46723 .17784 m
.46723 .17784 L
s
.46731 .18066 m
.46731 .18066 L
s
.46738 .17902 m
.46738 .17902 L
s
.46746 .17655 m
.46746 .17655 L
s
.46753 .17409 m
.46753 .17409 L
s
.4676 .17561 m
.4676 .17561 L
s
.46768 .17973 m
.46768 .17973 L
s
.46775 .18677 m
.46775 .18677 L
s
.46783 .18642 m
.46783 .18642 L
s
.4679 .18783 m
.4679 .18783 L
s
.46798 .1816 m
.46798 .1816 L
s
.46805 .18654 m
.46805 .18654 L
s
.46813 .18372 m
.46813 .18372 L
s
.4682 .1782 m
.4682 .1782 L
s
.46828 .18148 m
.46828 .18148 L
s
.46835 .1823 m
.46835 .1823 L
s
.46842 .17644 m
.46842 .17644 L
s
.46849 .17973 m
.46849 .17973 L
s
.46857 .18325 m
.46857 .18325 L
s
.46864 .18594 m
.46864 .18594 L
s
.46872 .18794 m
.46872 .18794 L
s
.46879 .1843 m
.46879 .1843 L
s
.46887 .18736 m
.46887 .18736 L
s
.46894 .18031 m
.46894 .18031 L
s
.46902 .18195 m
.46902 .18195 L
s
.46909 .18277 m
.46909 .18277 L
s
.46917 .19053 m
.46917 .19053 L
s
.46924 .18994 m
.46924 .18994 L
s
.46931 .18724 m
.46931 .18724 L
s
.46939 .18548 m
.46939 .18548 L
s
.46946 .17726 m
.46946 .17726 L
s
.46954 .18184 m
.46954 .18184 L
s
.46961 .17973 m
.46961 .17973 L
s
.46969 .18113 m
.46969 .18113 L
s
.46976 .17761 m
.46976 .17761 L
s
.46984 .17691 m
.46984 .17691 L
s
.46991 .18254 m
.46991 .18254 L
s
.46998 .18148 m
.46998 .18148 L
s
.47005 .18923 m
.47005 .18923 L
s
.47013 .18876 m
.47013 .18876 L
s
.4702 .19276 m
.4702 .19276 L
s
.47028 .19676 m
.47028 .19676 L
s
.47035 .19875 m
.47035 .19875 L
s
.47043 .20016 m
.47043 .20016 L
s
.4705 .19933 m
.4705 .19933 L
s
.47058 .19287 m
.47058 .19287 L
s
.47065 .19569 m
.47065 .19569 L
s
.47073 .19804 m
.47073 .19804 L
s
.4708 .19616 m
.4708 .19616 L
s
.47087 .19711 m
.47087 .19711 L
s
.47095 .19429 m
.47095 .19429 L
s
.47102 .19335 m
.47102 .19335 L
s
.4711 .19499 m
.4711 .19499 L
s
.47117 .19604 m
.47117 .19604 L
s
.47125 .20861 m
.47125 .20861 L
s
.47132 .21026 m
.47132 .21026 L
s
.4714 .20908 m
.4714 .20908 L
s
.47147 .21731 m
.47147 .21731 L
s
.47155 .22165 m
.47155 .22165 L
s
.47162 .22506 m
.47162 .22506 L
s
.47169 .23045 m
.47169 .23045 L
s
.47176 .23551 m
.47176 .23551 L
s
.47184 .24396 m
.47184 .24396 L
s
.47191 .24455 m
.47191 .24455 L
s
.47199 .24725 m
.47199 .24725 L
s
.47206 .24549 m
.47206 .24549 L
s
.47214 .24467 m
.47214 .24467 L
s
.47221 .24995 m
.47221 .24995 L
s
.47229 .2496 m
.47229 .2496 L
s
.47237 .24843 m
.47237 .24843 L
s
.47243 .24666 m
.47243 .24666 L
s
.47251 .24326 m
.47251 .24326 L
s
.47258 .23727 m
.47258 .23727 L
s
.47266 .24009 m
.47266 .24009 L
s
.47273 .23868 m
.47273 .23868 L
s
.47281 .24103 m
.47281 .24103 L
s
.47288 .24549 m
.47288 .24549 L
s
.47295 .24537 m
.47295 .24537 L
s
.47303 .24995 m
.47303 .24995 L
s
.47311 .25347 m
.47311 .25347 L
s
.47318 .25347 m
.47318 .25347 L
s
.47325 .2617 m
.47325 .2617 L
s
.47332 .2671 m
.47332 .2671 L
s
.4734 .27074 m
.4734 .27074 L
s
.47347 .2678 m
.47347 .2678 L
s
.47355 .2745 m
.47355 .2745 L
s
.47362 .27908 m
.47362 .27908 L
s
.4737 .28002 m
.4737 .28002 L
s
.47377 .28413 m
.47377 .28413 L
s
.47384 .28636 m
.47384 .28636 L
s
.47392 .28331 m
.47392 .28331 L
s
.474 .27967 m
.474 .27967 L
s
.47407 .28037 m
.47407 .28037 L
s
.47414 .28296 m
.47414 .28296 L
s
.47422 .28788 m
.47422 .28788 L
s
.47429 .28495 m
.47429 .28495 L
s
.47437 .28777 m
.47437 .28777 L
s
.47444 .2873 m
.47444 .2873 L
s
.47452 .28765 m
.47452 .28765 L
s
.47459 .29235 m
.47459 .29235 L
s
.47466 .28213 m
.47466 .28213 L
s
.47474 .27838 m
.47474 .27838 L
s
.47481 .27802 m
.47481 .27802 L
s
.47488 .27485 m
.47488 .27485 L
s
.47496 .27227 m
.47496 .27227 L
s
.47503 .26616 m
.47503 .26616 L
s
.47511 .26628 m
.47511 .26628 L
s
.47518 .26863 m
.47518 .26863 L
s
.47526 .26123 m
.47526 .26123 L
s
.47533 .25723 m
.47533 .25723 L
s
.4754 .26487 m
.4754 .26487 L
s
.47548 .26099 m
.47548 .26099 L
s
.47555 .26205 m
.47555 .26205 L
s
.47563 .25794 m
.47563 .25794 L
s
.4757 .25876 m
.4757 .25876 L
s
.47578 .25865 m
.47578 .25865 L
s
.47585 .26135 m
.47585 .26135 L
s
.47593 .25489 m
.47593 .25489 L
s
.476 .25489 m
.476 .25489 L
s
.47608 .26264 m
.47608 .26264 L
s
.47615 .26147 m
.47615 .26147 L
s
.47622 .26816 m
.47622 .26816 L
s
.47629 .26863 m
.47629 .26863 L
s
.47637 .27062 m
.47637 .27062 L
s
.47645 .27133 m
.47645 .27133 L
s
.47652 .2718 m
.47652 .2718 L
s
.47659 .27356 m
.47659 .27356 L
s
.47667 .27003 m
.47667 .27003 L
s
.47674 .26828 m
.47674 .26828 L
s
.47682 .2705 m
.47682 .2705 L
s
.47689 .27274 m
.47689 .27274 L
s
.47697 .28202 m
.47697 .28202 L
s
.47704 .28589 m
.47704 .28589 L
s
.47711 .28706 m
.47711 .28706 L
s
.47719 .28542 m
.47719 .28542 L
s
.47726 .28378 m
.47726 .28378 L
s
.47734 .27896 m
.47734 .27896 L
s
.47741 .27579 m
.47741 .27579 L
s
.47749 .27731 m
.47749 .27731 L
s
.47756 .28025 m
.47756 .28025 L
s
.47764 .27743 m
.47764 .27743 L
s
.47771 .27814 m
.47771 .27814 L
s
.47778 .2671 m
.47778 .2671 L
s
.47785 .27274 m
.47785 .27274 L
s
.47793 .27344 m
.47793 .27344 L
s
.478 .27285 m
.478 .27285 L
s
.47808 .27474 m
.47808 .27474 L
s
.47815 .27274 m
.47815 .27274 L
s
.47823 .27603 m
.47823 .27603 L
s
.4783 .27685 m
.4783 .27685 L
s
.47838 .27603 m
.47838 .27603 L
s
.47845 .27474 m
.47845 .27474 L
s
.47853 .27485 m
.47853 .27485 L
s
.4786 .26616 m
.4786 .26616 L
s
.47867 .26322 m
.47867 .26322 L
s
.47875 .27015 m
.47875 .27015 L
s
.47882 .26616 m
.47882 .26616 L
s
.4789 .26017 m
.4789 .26017 L
s
.47897 .25512 m
.47897 .25512 L
s
.47905 .25501 m
.47905 .25501 L
s
.47912 .26111 m
.47912 .26111 L
s
.4792 .26675 m
.4792 .26675 L
s
.47927 .26193 m
.47927 .26193 L
s
.47935 .26393 m
.47935 .26393 L
s
.47942 .25641 m
.47942 .25641 L
s
.47949 .25723 m
.47949 .25723 L
s
.47956 .25524 m
.47956 .25524 L
s
.47964 .25254 m
.47964 .25254 L
s
.47971 .24925 m
.47971 .24925 L
s
.47979 .25207 m
.47979 .25207 L
s
.47986 .2469 m
.47986 .2469 L
s
.47994 .24561 m
.47994 .24561 L
s
.48001 .2503 m
.48001 .2503 L
s
.48009 .24737 m
.48009 .24737 L
s
.48017 .24596 m
.48017 .24596 L
s
.48023 .23845 m
.48023 .23845 L
s
.48031 .24103 m
.48031 .24103 L
s
.48038 .23997 m
.48038 .23997 L
s
.48046 .23845 m
.48046 .23845 L
s
.48053 .24479 m
.48053 .24479 L
s
.48061 .24502 m
.48061 .24502 L
s
.48068 .24843 m
.48068 .24843 L
s
.48075 .24537 m
.48075 .24537 L
s
.48083 .2469 m
.48083 .2469 L
s
.48091 .25172 m
.48091 .25172 L
s
.48098 .25665 m
.48098 .25665 L
s
.48105 .26475 m
.48105 .26475 L
s
.48112 .26264 m
.48112 .26264 L
s
.4812 .26334 m
.4812 .26334 L
s
.48127 .25489 m
.48127 .25489 L
s
.48135 .25207 m
.48135 .25207 L
s
.48142 .25019 m
.48142 .25019 L
s
.4815 .25019 m
.4815 .25019 L
s
.48157 .25324 m
.48157 .25324 L
s
.48165 .25688 m
.48165 .25688 L
s
.48173 .25771 m
.48173 .25771 L
s
.4818 .25465 m
.4818 .25465 L
s
.48187 .25641 m
.48187 .25641 L
s
.48194 .25771 m
.48194 .25771 L
s
.48202 .25665 m
.48202 .25665 L
s
.48209 .25065 m
.48209 .25065 L
s
.48217 .25324 m
.48217 .25324 L
s
.48224 .26005 m
.48224 .26005 L
s
.48232 .26193 m
.48232 .26193 L
s
.48239 .26346 m
.48239 .26346 L
s
.48246 .25641 m
.48246 .25641 L
s
.48254 .26087 m
.48254 .26087 L
s
.48261 .257 m
.48261 .257 L
s
.48268 .2624 m
.48268 .2624 L
s
.48276 .26123 m
.48276 .26123 L
s
.48283 .25982 m
.48283 .25982 L
s
.48291 .25641 m
.48291 .25641 L
s
.48298 .26052 m
.48298 .26052 L
s
.48306 .25993 m
.48306 .25993 L
s
.48313 .25982 m
.48313 .25982 L
s
.4832 .25806 m
.4832 .25806 L
s
.48328 .26604 m
.48328 .26604 L
s
.48336 .26487 m
.48336 .26487 L
s
.48343 .26299 m
.48343 .26299 L
s
.4835 .26522 m
.4835 .26522 L
s
.48358 .26522 m
.48358 .26522 L
s
.48365 .26264 m
.48365 .26264 L
s
.48373 .26616 m
.48373 .26616 L
s
.4838 .26992 m
.4838 .26992 L
s
.48388 .26992 m
.48388 .26992 L
s
.48395 .27239 m
.48395 .27239 L
s
.48402 .27062 m
.48402 .27062 L
s
.48409 .26546 m
.48409 .26546 L
s
.48417 .26416 m
.48417 .26416 L
s
.48425 .26921 m
.48425 .26921 L
s
.48432 .27556 m
.48432 .27556 L
s
.48439 .27743 m
.48439 .27743 L
s
.48447 .27767 m
.48447 .27767 L
s
.48454 .28119 m
.48454 .28119 L
s
.48462 .27896 m
.48462 .27896 L
s
.48469 .27838 m
.48469 .27838 L
s
.48477 .28131 m
.48477 .28131 L
s
.48484 .28272 m
.48484 .28272 L
s
.48491 .28296 m
.48491 .28296 L
s
.48499 .27626 m
.48499 .27626 L
s
.48506 .27556 m
.48506 .27556 L
s
.48514 .27438 m
.48514 .27438 L
s
.48521 .27403 m
.48521 .27403 L
s
.48529 .27521 m
.48529 .27521 L
s
.48536 .27638 m
.48536 .27638 L
s
.48544 .26992 m
.48544 .26992 L
s
.48551 .27274 m
.48551 .27274 L
s
.48558 .27027 m
.48558 .27027 L
s
.48565 .26299 m
.48565 .26299 L
s
.48573 .26452 m
.48573 .26452 L
s
.4858 .26487 m
.4858 .26487 L
s
.48588 .26475 m
.48588 .26475 L
s
.48595 .26569 m
.48595 .26569 L
s
.48603 .26005 m
.48603 .26005 L
s
.4861 .25865 m
.4861 .25865 L
s
.48618 .24843 m
.48618 .24843 L
s
.48625 .24666 m
.48625 .24666 L
s
.48633 .24337 m
.48633 .24337 L
s
.4864 .24573 m
.4864 .24573 L
s
.48647 .23786 m
.48647 .23786 L
s
.48655 .24337 m
.48655 .24337 L
s
.48662 .24373 m
.48662 .24373 L
s
.4867 .24666 m
.4867 .24666 L
s
.48677 .24737 m
.48677 .24737 L
s
.48685 .25477 m
.48685 .25477 L
s
.48692 .257 m
.48692 .257 L
s
.487 .25301 m
.487 .25301 L
s
.48707 .26052 m
.48707 .26052 L
s
.48715 .26123 m
.48715 .26123 L
s
.48722 .25583 m
.48722 .25583 L
s
.48729 .25383 m
.48729 .25383 L
s
.48736 .2503 m
.48736 .2503 L
s
.48744 .24773 m
.48744 .24773 L
s
.48751 .24713 m
.48751 .24713 L
s
.48759 .25113 m
.48759 .25113 L
s
.48766 .24831 m
.48766 .24831 L
s
.48774 .24561 m
.48774 .24561 L
s
.48781 .2415 m
.48781 .2415 L
s
.48789 .24408 m
.48789 .24408 L
s
.48797 .23891 m
.48797 .23891 L
s
.48803 .23809 m
.48803 .23809 L
s
.48811 .2388 m
.48811 .2388 L
s
.48818 .24514 m
.48818 .24514 L
s
.48826 .23422 m
.48826 .23422 L
s
.48833 .23351 m
.48833 .23351 L
s
.48841 .23422 m
.48841 .23422 L
s
.48848 .23633 m
.48848 .23633 L
s
.48856 .23516 m
.48856 .23516 L
s
.48863 .22788 m
.48863 .22788 L
s
.48871 .22776 m
.48871 .22776 L
s
.48878 .22341 m
.48878 .22341 L
s
.48885 .22928 m
.48885 .22928 L
s
.48892 .22541 m
.48892 .22541 L
s
.489 .22776 m
.489 .22776 L
s
.48907 .22717 m
.48907 .22717 L
s
.48915 .22646 m
.48915 .22646 L
s
.48922 .22646 m
.48922 .22646 L
s
.4893 .22459 m
.4893 .22459 L
s
.48937 .22658 m
.48937 .22658 L
s
.48945 .22741 m
.48945 .22741 L
s
.48953 .2348 m
.48953 .2348 L
s
.4896 .23045 m
.4896 .23045 L
s
.48967 .23281 m
.48967 .23281 L
s
.48974 .23187 m
.48974 .23187 L
s
.48982 .2341 m
.48982 .2341 L
s
.48989 .23539 m
.48989 .23539 L
s
.48997 .23234 m
.48997 .23234 L
s
.49004 .23187 m
.49004 .23187 L
s
.49012 .2321 m
.49012 .2321 L
s
.49019 .23656 m
.49019 .23656 L
s
.49027 .2314 m
.49027 .2314 L
s
.49034 .23563 m
.49034 .23563 L
s
.49041 .23938 m
.49041 .23938 L
s
.49048 .23316 m
.49048 .23316 L
s
.49056 .23551 m
.49056 .23551 L
s
.49063 .24561 m
.49063 .24561 L
s
.49071 .2469 m
.49071 .2469 L
s
.49078 .24455 m
.49078 .24455 L
s
.49086 .24173 m
.49086 .24173 L
s
.49093 .24138 m
.49093 .24138 L
s
.491 .23927 m
.491 .23927 L
s
.49108 .23845 m
.49108 .23845 L
s
.49116 .2415 m
.49116 .2415 L
s
.49123 .23691 m
.49123 .23691 L
s
.4913 .2368 m
.4913 .2368 L
s
.49138 .23856 m
.49138 .23856 L
s
.49145 .2368 m
.49145 .2368 L
s
.49153 .23703 m
.49153 .23703 L
s
.4916 .24055 m
.4916 .24055 L
s
.49168 .23985 m
.49168 .23985 L
s
.49175 .23422 m
.49175 .23422 L
s
.49182 .23938 m
.49182 .23938 L
s
.4919 .23245 m
.4919 .23245 L
s
.49198 .23962 m
.49198 .23962 L
s
.49205 .24209 m
.49205 .24209 L
s
.49212 .24561 m
.49212 .24561 L
s
.49219 .24291 m
.49219 .24291 L
s
.49227 .24643 m
.49227 .24643 L
s
.49234 .24009 m
.49234 .24009 L
s
.49242 .24349 m
.49242 .24349 L
s
.49249 .23997 m
.49249 .23997 L
s
.49257 .24197 m
.49257 .24197 L
s
.49264 .24232 m
.49264 .24232 L
s
.49271 .24067 m
.49271 .24067 L
s
.49279 .24291 m
.49279 .24291 L
s
.49286 .24831 m
.49286 .24831 L
s
.49294 .24737 m
.49294 .24737 L
s
.49301 .25054 m
.49301 .25054 L
s
.49309 .25148 m
.49309 .25148 L
s
.49316 .24878 m
.49316 .24878 L
s
.49324 .25019 m
.49324 .25019 L
s
.49331 .24831 m
.49331 .24831 L
s
.49338 .24843 m
.49338 .24843 L
s
.49345 .25583 m
.49345 .25583 L
s
.49353 .25125 m
.49353 .25125 L
s
.49361 .25195 m
.49361 .25195 L
s
.49368 .24678 m
.49368 .24678 L
s
.49375 .24444 m
.49375 .24444 L
s
.49383 .24396 m
.49383 .24396 L
s
.4939 .24596 m
.4939 .24596 L
s
.49398 .24596 m
.49398 .24596 L
s
.49405 .2523 m
.49405 .2523 L
s
.49413 .25489 m
.49413 .25489 L
s
.4942 .26428 m
.4942 .26428 L
s
.49427 .26229 m
.49427 .26229 L
s
.49435 .26428 m
.49435 .26428 L
s
.49442 .26593 m
.49442 .26593 L
s
.4945 .26534 m
.4945 .26534 L
s
.49457 .26217 m
.49457 .26217 L
s
.49465 .2604 m
.49465 .2604 L
s
.49472 .26029 m
.49472 .26029 L
s
.4948 .25911 m
.4948 .25911 L
s
.49487 .26804 m
.49487 .26804 L
s
.49495 .27097 m
.49495 .27097 L
s
.49502 .26675 m
.49502 .26675 L
s
.49509 .26816 m
.49509 .26816 L
s
.49516 .26863 m
.49516 .26863 L
s
.49524 .26439 m
.49524 .26439 L
s
.49531 .25771 m
.49531 .25771 L
s
.49539 .25783 m
.49539 .25783 L
s
.49546 .26052 m
.49546 .26052 L
s
.49554 .26499 m
.49554 .26499 L
s
.49561 .26511 m
.49561 .26511 L
s
.49569 .25606 m
.49569 .25606 L
s
.49577 .25371 m
.49577 .25371 L
s
.49583 .25113 m
.49583 .25113 L
s
.49591 .25242 m
.49591 .25242 L
s
.49598 .24608 m
.49598 .24608 L
s
.49606 .25336 m
.49606 .25336 L
s
.49613 .2509 m
.49613 .2509 L
s
.49621 .25653 m
.49621 .25653 L
s
.49628 .25207 m
.49628 .25207 L
s
.49636 .25723 m
.49636 .25723 L
s
.49643 .26123 m
.49643 .26123 L
s
.49651 .27062 m
.49651 .27062 L
s
.49658 .27591 m
.49658 .27591 L
s
.49665 .27485 m
.49665 .27485 L
s
.49672 .27661 m
.49672 .27661 L
s
.4968 .28131 m
.4968 .28131 L
s
.49687 .28519 m
.49687 .28519 L
s
.49695 .27414 m
.49695 .27414 L
s
.49702 .27157 m
.49702 .27157 L
s
.4971 .27391 m
.4971 .27391 L
s
.49717 .27309 m
.49717 .27309 L
s
.49725 .26757 m
.49725 .26757 L
s
.49733 .26287 m
.49733 .26287 L
s
.4974 .26299 m
.4974 .26299 L
s
.49747 .26404 m
.49747 .26404 L
s
.49754 .25512 m
.49754 .25512 L
s
.49762 .25853 m
.49762 .25853 L
s
.49769 .26264 m
.49769 .26264 L
s
.49777 .25841 m
.49777 .25841 L
s
.49784 .25301 m
.49784 .25301 L
s
.49792 .25019 m
.49792 .25019 L
s
.49799 .25442 m
.49799 .25442 L
s
.49807 .2617 m
.49807 .2617 L
s
.49814 .25747 m
.49814 .25747 L
s
.49821 .26616 m
.49821 .26616 L
s
.49828 .26334 m
.49828 .26334 L
s
.49836 .26663 m
.49836 .26663 L
s
.49843 .26804 m
.49843 .26804 L
s
.49851 .26804 m
.49851 .26804 L
s
.49858 .26557 m
.49858 .26557 L
s
.49866 .26968 m
.49866 .26968 L
s
.49873 .26698 m
.49873 .26698 L
s
.49881 .27015 m
.49881 .27015 L
s
.49889 .27074 m
.49889 .27074 L
s
.49896 .26828 m
.49896 .26828 L
s
.49903 .27121 m
.49903 .27121 L
s
.4991 .2725 m
.4991 .2725 L
s
.49918 .2718 m
.49918 .2718 L
s
.49925 .27802 m
.49925 .27802 L
s
.49933 .28319 m
.49933 .28319 L
s
.4994 .28601 m
.4994 .28601 L
s
.49948 .29294 m
.49948 .29294 L
s
.49955 .30257 m
.49955 .30257 L
s
.49962 .30421 m
.49962 .30421 L
s
.4997 .30386 m
.4997 .30386 L
s
.49978 .29893 m
.49978 .29893 L
s
.49985 .3021 m
.49985 .3021 L
s
.49992 .30903 m
.49992 .30903 L
s
.49999 .30468 m
.49999 .30468 L
s
.50007 .3028 m
.50007 .3028 L
s
.50014 .30621 m
.50014 .30621 L
s
.50022 .31161 m
.50022 .31161 L
s
.50029 .31184 m
.50029 .31184 L
s
.50037 .31948 m
.50037 .31948 L
s
.50044 .32042 m
.50044 .32042 L
s
.50052 .327 m
.50052 .327 L
s
.5006 .32511 m
.5006 .32511 L
s
.50066 .32864 m
.50066 .32864 L
s
.50074 .32993 m
.50074 .32993 L
s
.50081 .32688 m
.50081 .32688 L
s
.50089 .32312 m
.50089 .32312 L
s
.50096 .32441 m
.50096 .32441 L
s
.50104 .32394 m
.50104 .32394 L
s
.50111 .32828 m
.50111 .32828 L
s
.50118 .32418 m
.50118 .32418 L
s
.50125 .32418 m
.50125 .32418 L
s
.50133 .33264 m
.50133 .33264 L
s
.50141 .3277 m
.50141 .3277 L
s
.50148 .32629 m
.50148 .32629 L
s
.50155 .32206 m
.50155 .32206 L
s
.50163 .32511 m
.50163 .32511 L
s
.5017 .32089 m
.5017 .32089 L
s
.50178 .32124 m
.50178 .32124 L
s
.50185 .32206 m
.50185 .32206 L
s
.50193 .32347 m
.50193 .32347 L
s
.502 .32136 m
.502 .32136 L
s
.50207 .32347 m
.50207 .32347 L
s
.50215 .32089 m
.50215 .32089 L
s
.50223 .32476 m
.50223 .32476 L
s
.5023 .33486 m
.5023 .33486 L
s
.50237 .33698 m
.50237 .33698 L
s
.50245 .33733 m
.50245 .33733 L
s
.50252 .33346 m
.50252 .33346 L
s
.5026 .33568 m
.5026 .33568 L
s
.50267 .33521 m
.50267 .33521 L
s
.50275 .3385 m
.50275 .3385 L
s
.50282 .33792 m
.50282 .33792 L
s
.50289 .33005 m
.50289 .33005 L
s
.50296 .33275 m
.50296 .33275 L
s
.50304 .3351 m
.50304 .3351 L
s
.50311 .33005 m
.50311 .33005 L
s
.50319 .33322 m
.50319 .33322 L
s
.50326 .3277 m
.50326 .3277 L
s
.50334 .33357 m
.50334 .33357 L
s
.50341 .33475 m
.50341 .33475 L
s
.50349 .33428 m
.50349 .33428 L
s
.50357 .33733 m
.50357 .33733 L
s
.50363 .33545 m
.50363 .33545 L
s
.50371 .33451 m
.50371 .33451 L
s
.50378 .33334 m
.50378 .33334 L
s
.50386 .33146 m
.50386 .33146 L
s
.50393 .3284 m
.50393 .3284 L
s
.50401 .33017 m
.50401 .33017 L
s
.50408 .33592 m
.50408 .33592 L
s
.50416 .3351 m
.50416 .3351 L
s
.50423 .33463 m
.50423 .33463 L
s
.50431 .32923 m
.50431 .32923 L
s
.50438 .33909 m
.50438 .33909 L
s
.50445 .33968 m
.50445 .33968 L
s
.50452 .33686 m
.50452 .33686 L
s
.5046 .33909 m
.5046 .33909 L
s
.50467 .33756 m
.50467 .33756 L
s
.50475 .33745 m
.50475 .33745 L
s
.50482 .33792 m
.50482 .33792 L
s
.5049 .33252 m
.5049 .33252 L
s
.50497 .33428 m
.50497 .33428 L
s
.50505 .33663 m
.50505 .33663 L
s
.50513 .32864 m
.50513 .32864 L
s
.5052 .33381 m
.5052 .33381 L
s
.50527 .33169 m
.50527 .33169 L
s
.50534 .33005 m
.50534 .33005 L
s
.50542 .33157 m
.50542 .33157 L
s
.50549 .32899 m
.50549 .32899 L
s
.50557 .3331 m
.50557 .3331 L
s
.50564 .33756 m
.50564 .33756 L
s
.50572 .34003 m
.50572 .34003 L
s
.50579 .34461 m
.50579 .34461 L
s
.50587 .34626 m
.50587 .34626 L
s
.50594 .34156 m
.50594 .34156 L
s
.50602 .34262 m
.50602 .34262 L
s
.50608 .34755 m
.50608 .34755 L
s
.50616 .35084 m
.50616 .35084 L
s
.50623 .35331 m
.50623 .35331 L
s
.50631 .35765 m
.50631 .35765 L
s
.50638 .36176 m
.50638 .36176 L
s
.50646 .36152 m
.50646 .36152 L
s
.50653 .36211 m
.50653 .36211 L
s
.50661 .35471 m
.50661 .35471 L
s
.50669 .35965 m
.50669 .35965 L
s
.50676 .35965 m
.50676 .35965 L
s
.50683 .3573 m
.50683 .3573 L
s
.5069 .36293 m
.5069 .36293 L
s
.50698 .35518 m
.50698 .35518 L
s
.50705 .35765 m
.50705 .35765 L
s
.50713 .35154 m
.50713 .35154 L
s
.5072 .35037 m
.5072 .35037 L
s
.50728 .35331 m
.50728 .35331 L
s
.50735 .35331 m
.50735 .35331 L
s
.50743 .35331 m
.50743 .35331 L
s
.5075 .35401 m
.5075 .35401 L
s
.50758 .35565 m
.50758 .35565 L
s
.50765 .35718 m
.50765 .35718 L
s
.50772 .356 m
.50772 .356 L
s
.50779 .35495 m
.50779 .35495 L
s
.50787 .36187 m
.50787 .36187 L
s
.50794 .36129 m
.50794 .36129 L
s
.50802 .35917 m
.50802 .35917 L
s
.50809 .35882 m
.50809 .35882 L
s
.50817 .34766 m
.50817 .34766 L
s
.50824 .34496 m
.50824 .34496 L
s
.50832 .34813 m
.50832 .34813 L
s
.5084 .34508 m
.5084 .34508 L
s
.50846 .3459 m
.50846 .3459 L
s
.50854 .35518 m
.50854 .35518 L
s
.50861 .35659 m
.50861 .35659 L
s
.50869 .35448 m
.50869 .35448 L
s
.50876 .35565 m
.50876 .35565 L
s
.50884 .35952 m
.50884 .35952 L
s
.50891 .35131 m
.50891 .35131 L
s
.50899 .34978 m
.50899 .34978 L
s
.50906 .34673 m
.50906 .34673 L
s
.50914 .35048 m
.50914 .35048 L
s
.50921 .34943 m
.50921 .34943 L
s
.50928 .35424 m
.50928 .35424 L
s
.50935 .36423 m
.50935 .36423 L
s
.50943 .37139 m
.50943 .37139 L
s
.5095 .36845 m
.5095 .36845 L
s
.50958 .36387 m
.50958 .36387 L
s
.50965 .36751 m
.50965 .36751 L
s
.50973 .36951 m
.50973 .36951 L
s
.5098 .3674 m
.5098 .3674 L
s
.50987 .3681 m
.50987 .3681 L
s
.50995 .37033 m
.50995 .37033 L
s
.51003 .37397 m
.51003 .37397 L
s
.5101 .37914 m
.5101 .37914 L
s
.51017 .37937 m
.51017 .37937 L
s
.51025 .37961 m
.51025 .37961 L
s
.51032 .37691 m
.51032 .37691 L
s
.5104 .37186 m
.5104 .37186 L
s
.51047 .37303 m
.51047 .37303 L
s
.51055 .37033 m
.51055 .37033 L
s
.51062 .36716 m
.51062 .36716 L
s
.51069 .37221 m
.51069 .37221 L
s
.51077 .37585 m
.51077 .37585 L
s
.51085 .37726 m
.51085 .37726 L
s
.51091 .37585 m
.51091 .37585 L
s
.51099 .3775 m
.51099 .3775 L
s
.51106 .3775 m
.51106 .3775 L
s
.51114 .37855 m
.51114 .37855 L
s
.51121 .3762 m
.51121 .3762 L
s
.51129 .38219 m
.51129 .38219 L
s
.51137 .38478 m
.51137 .38478 L
s
.51143 .389 m
.51143 .389 L
s
.51151 .38313 m
.51151 .38313 L
s
.51158 .38149 m
.51158 .38149 L
s
.51166 .38501 m
.51166 .38501 L
s
.51173 .38196 m
.51173 .38196 L
s
.51181 .37937 m
.51181 .37937 L
s
.51188 .37726 m
.51188 .37726 L
s
.51196 .37632 m
.51196 .37632 L
s
.51203 .37456 m
.51203 .37456 L
s
.51211 .37608 m
.51211 .37608 L
s
.51218 .37597 m
.51218 .37597 L
s
.51225 .36869 m
.51225 .36869 L
s
.51232 .37186 m
.51232 .37186 L
s
.5124 .36892 m
.5124 .36892 L
s
.51248 .36575 m
.51248 .36575 L
s
.51255 .36246 m
.51255 .36246 L
s
.51262 .36493 m
.51262 .36493 L
s
.5127 .36763 m
.5127 .36763 L
s
.51277 .37291 m
.51277 .37291 L
s
.51285 .37972 m
.51285 .37972 L
s
.51293 .38219 m
.51293 .38219 L
s
.513 .3809 m
.513 .3809 L
s
.51307 .38736 m
.51307 .38736 L
s
.51314 .38947 m
.51314 .38947 L
s
.51322 .38607 m
.51322 .38607 L
s
.51329 .3876 m
.51329 .3876 L
s
.51337 .38678 m
.51337 .38678 L
s
.51344 .38407 m
.51344 .38407 L
s
.51352 .38266 m
.51352 .38266 L
s
.51359 .38043 m
.51359 .38043 L
s
.51367 .37092 m
.51367 .37092 L
s
.51374 .37186 m
.51374 .37186 L
s
.51382 .37339 m
.51382 .37339 L
s
.51388 .36915 m
.51388 .36915 L
s
.51396 .37374 m
.51396 .37374 L
s
.51403 .36974 m
.51403 .36974 L
s
.51411 .37843 m
.51411 .37843 L
s
.51418 .37867 m
.51418 .37867 L
s
.51426 .37573 m
.51426 .37573 L
s
.51433 .37561 m
.51433 .37561 L
s
.51441 .37362 m
.51441 .37362 L
s
.51449 .37115 m
.51449 .37115 L
s
.51456 .36763 m
.51456 .36763 L
s
.51463 .36152 m
.51463 .36152 L
s
.5147 .36305 m
.5147 .36305 L
s
.51478 .35941 m
.51478 .35941 L
s
.51485 .35753 m
.51485 .35753 L
s
.51493 .36458 m
.51493 .36458 L
s
.515 .36376 m
.515 .36376 L
s
.51508 .36458 m
.51508 .36458 L
s
.51515 .36423 m
.51515 .36423 L
s
.51523 .36681 m
.51523 .36681 L
s
.5153 .36469 m
.5153 .36469 L
s
.51538 .36904 m
.51538 .36904 L
s
.51545 .37197 m
.51545 .37197 L
s
.51552 .37715 m
.51552 .37715 L
s
.51559 .37937 m
.51559 .37937 L
s
.51567 .38137 m
.51567 .38137 L
s
.51574 .38008 m
.51574 .38008 L
s
.51582 .38161 m
.51582 .38161 L
s
.51589 .38513 m
.51589 .38513 L
s
.51597 .38501 m
.51597 .38501 L
s
.51604 .38079 m
.51604 .38079 L
s
.51612 .38043 m
.51612 .38043 L
s
.5162 .3856 m
.5162 .3856 L
s
.51626 .37997 m
.51626 .37997 L
s
.51634 .37738 m
.51634 .37738 L
s
.51641 .37479 m
.51641 .37479 L
s
.51649 .38266 m
.51649 .38266 L
s
.51656 .38254 m
.51656 .38254 L
s
.51664 .3856 m
.51664 .3856 L
s
.51671 .39511 m
.51671 .39511 L
s
.51679 .39488 m
.51679 .39488 L
s
.51686 .40145 m
.51686 .40145 L
s
.51694 .39793 m
.51694 .39793 L
s
.51701 .39699 m
.51701 .39699 L
s
.51708 .3984 m
.51708 .3984 L
s
.51715 .39863 m
.51715 .39863 L
s
.51723 .39371 m
.51723 .39371 L
s
.5173 .39687 m
.5173 .39687 L
s
.51738 .40157 m
.51738 .40157 L
s
.51745 .40474 m
.51745 .40474 L
s
.51753 .3977 m
.51753 .3977 L
s
.5176 .40486 m
.5176 .40486 L
s
.51767 .40627 m
.51767 .40627 L
s
.51775 .4132 m
.51775 .4132 L
s
.51783 .4132 m
.51783 .4132 L
s
.5179 .40827 m
.5179 .40827 L
s
.51797 .40897 m
.51797 .40897 L
s
.51805 .40662 m
.51805 .40662 L
s
.51812 .40991 m
.51812 .40991 L
s
.5182 .41073 m
.5182 .41073 L
s
.51827 .41191 m
.51827 .41191 L
s
.51835 .40239 m
.51835 .40239 L
s
.51842 .40274 m
.51842 .40274 L
s
.51849 .40662 m
.51849 .40662 L
s
.51857 .40498 m
.51857 .40498 L
s
.51865 .39957 m
.51865 .39957 L
s
.51871 .39699 m
.51871 .39699 L
s
.51879 .39981 m
.51879 .39981 L
s
.51886 .39617 m
.51886 .39617 L
s
.51894 .39852 m
.51894 .39852 L
s
.51901 .40404 m
.51901 .40404 L
s
.51909 .39969 m
.51909 .39969 L
s
.51917 .40486 m
.51917 .40486 L
s
.51923 .40463 m
.51923 .40463 L
s
.51931 .41273 m
.51931 .41273 L
s
.51939 .40768 m
.51939 .40768 L
s
.51946 .41038 m
.51946 .41038 L
s
.51953 .41202 m
.51953 .41202 L
s
.51961 .41062 m
.51961 .41062 L
s
.51968 .41249 m
.51968 .41249 L
s
.51976 .41496 m
.51976 .41496 L
s
.51983 .41402 m
.51983 .41402 L
s
.51991 .41848 m
.51991 .41848 L
s
.51998 .41801 m
.51998 .41801 L
s
.52005 .41578 m
.52005 .41578 L
s
.52012 .41942 m
.52012 .41942 L
s
.5202 .42095 m
.5202 .42095 L
s
.52028 .42823 m
.52028 .42823 L
s
.52035 .42259 m
.52035 .42259 L
s
.52042 .42154 m
.52042 .42154 L
s
.5205 .41473 m
.5205 .41473 L
s
.52057 .41273 m
.52057 .41273 L
s
.52065 .41343 m
.52065 .41343 L
s
.52073 .41449 m
.52073 .41449 L
s
.5208 .41743 m
.5208 .41743 L
s
.52087 .42059 m
.52087 .42059 L
s
.52094 .42341 m
.52094 .42341 L
s
.52102 .42166 m
.52102 .42166 L
s
.52109 .4193 m
.52109 .4193 L
s
.52117 .41743 m
.52117 .41743 L
s
.52124 .41884 m
.52124 .41884 L
s
.52132 .41813 m
.52132 .41813 L
s
.52139 .41813 m
.52139 .41813 L
s
.52147 .42294 m
.52147 .42294 L
s
.52154 .42059 m
.52154 .42059 L
s
.52162 .4152 m
.52162 .4152 L
s
.52168 .41366 m
.52168 .41366 L
s
.52176 .41484 m
.52176 .41484 L
s
.52183 .41426 m
.52183 .41426 L
s
.52191 .4078 m
.52191 .4078 L
s
.52198 .40451 m
.52198 .40451 L
s
.52206 .40404 m
.52206 .40404 L
s
.52213 .40756 m
.52213 .40756 L
s
.52221 .4051 m
.52221 .4051 L
s
.52229 .40885 m
.52229 .40885 L
s
.52236 .41202 m
.52236 .41202 L
s
.52243 .41919 m
.52243 .41919 L
s
.5225 .42471 m
.5225 .42471 L
s
.52258 .41977 m
.52258 .41977 L
s
.52265 .41132 m
.52265 .41132 L
s
.52273 .41249 m
.52273 .41249 L
s
.5228 .4092 m
.5228 .4092 L
s
.52288 .40662 m
.52288 .40662 L
s
.52295 .40756 m
.52295 .40756 L
s
.52303 .40498 m
.52303 .40498 L
s
.5231 .40709 m
.5231 .40709 L
s
.52318 .40674 m
.52318 .40674 L
s
.52325 .40662 m
.52325 .40662 L
s
.52332 .40709 m
.52332 .40709 L
s
.52339 .40791 m
.52339 .40791 L
s
.52347 .40498 m
.52347 .40498 L
s
.52354 .40192 m
.52354 .40192 L
s
.52362 .40028 m
.52362 .40028 L
s
.52369 .40075 m
.52369 .40075 L
s
.52377 .40286 m
.52377 .40286 L
s
.52385 .39922 m
.52385 .39922 L
s
.52392 .40568 m
.52392 .40568 L
s
.524 .41109 m
.524 .41109 L
s
.52406 .41273 m
.52406 .41273 L
s
.52414 .41167 m
.52414 .41167 L
s
.52421 .4159 m
.52421 .4159 L
s
.52429 .41778 m
.52429 .41778 L
s
.52436 .41766 m
.52436 .41766 L
s
.52444 .41977 m
.52444 .41977 L
s
.52451 .41731 m
.52451 .41731 L
s
.52459 .41672 m
.52459 .41672 L
s
.52466 .41801 m
.52466 .41801 L
s
.52474 .4152 m
.52474 .4152 L
s
.52481 .40838 m
.52481 .40838 L
s
.52488 .40932 m
.52488 .40932 L
s
.52495 .40662 m
.52495 .40662 L
s
.52503 .40615 m
.52503 .40615 L
s
.5251 .40827 m
.5251 .40827 L
s
.52518 .41755 m
.52518 .41755 L
s
.52525 .41531 m
.52525 .41531 L
s
.52533 .41414 m
.52533 .41414 L
s
.5254 .41578 m
.5254 .41578 L
s
.52548 .40862 m
.52548 .40862 L
s
.52556 .40368 m
.52556 .40368 L
s
.52563 .39969 m
.52563 .39969 L
s
.5257 .39992 m
.5257 .39992 L
s
.52577 .39488 m
.52577 .39488 L
s
.52585 .39981 m
.52585 .39981 L
s
.52592 .40192 m
.52592 .40192 L
s
.526 .39746 m
.526 .39746 L
s
.52607 .40004 m
.52607 .40004 L
s
.52615 .39535 m
.52615 .39535 L
s
.52622 .38536 m
.52622 .38536 L
s
.52629 .38289 m
.52629 .38289 L
s
.52637 .38642 m
.52637 .38642 L
s
.52645 .38935 m
.52645 .38935 L
s
.52651 .39476 m
.52651 .39476 L
s
.52659 .39406 m
.52659 .39406 L
s
.52666 .39182 m
.52666 .39182 L
s
.52674 .39206 m
.52674 .39206 L
s
.52681 .38982 m
.52681 .38982 L
s
.52689 .39535 m
.52689 .39535 L
s
.52697 .3984 m
.52697 .3984 L
s
.52703 .39441 m
.52703 .39441 L
s
.52711 .39264 m
.52711 .39264 L
s
.52719 .3883 m
.52719 .3883 L
s
.52726 .38266 m
.52726 .38266 L
s
.52733 .38396 m
.52733 .38396 L
s
.52741 .38431 m
.52741 .38431 L
s
.52748 .38665 m
.52748 .38665 L
s
.52756 .38266 m
.52756 .38266 L
s
.52763 .38254 m
.52763 .38254 L
s
.52771 .37961 m
.52771 .37961 L
s
.52778 .37386 m
.52778 .37386 L
s
.52785 .37561 m
.52785 .37561 L
s
.52792 .37291 m
.52792 .37291 L
s
.528 .37209 m
.528 .37209 L
s
.52808 .37409 m
.52808 .37409 L
s
.52815 .37444 m
.52815 .37444 L
s
.52822 .37151 m
.52822 .37151 L
s
.5283 .37162 m
.5283 .37162 L
s
.52837 .36998 m
.52837 .36998 L
s
.52845 .37468 m
.52845 .37468 L
s
.52853 .3775 m
.52853 .3775 L
s
.5286 .38032 m
.5286 .38032 L
s
.52867 .37256 m
.52867 .37256 L
s
.52874 .36705 m
.52874 .36705 L
s
.52882 .37186 m
.52882 .37186 L
s
.52889 .36775 m
.52889 .36775 L
s
.52897 .3708 m
.52897 .3708 L
s
.52904 .3654 m
.52904 .3654 L
s
.52912 .36915 m
.52912 .36915 L
s
.52919 .35905 m
.52919 .35905 L
s
.52927 .35541 m
.52927 .35541 L
s
.52934 .35588 m
.52934 .35588 L
s
.52942 .35331 m
.52942 .35331 L
s
.52948 .35648 m
.52948 .35648 L
s
.52956 .35541 m
.52956 .35541 L
s
.52963 .35788 m
.52963 .35788 L
s
.52971 .35753 m
.52971 .35753 L
s
.52978 .3573 m
.52978 .3573 L
s
.52986 .36411 m
.52986 .36411 L
s
.52993 .37585 m
.52993 .37585 L
s
.53001 .37843 m
.53001 .37843 L
s
.53009 .38231 m
.53009 .38231 L
s
.53016 .37526 m
.53016 .37526 L
s
.53023 .37773 m
.53023 .37773 L
s
.5303 .37433 m
.5303 .37433 L
s
.53038 .37397 m
.53038 .37397 L
s
.53045 .36293 m
.53045 .36293 L
s
.53053 .35588 m
.53053 .35588 L
s
.5306 .35401 m
.5306 .35401 L
s
.53068 .35518 m
.53068 .35518 L
s
.53075 .35401 m
.53075 .35401 L
s
.53083 .35612 m
.53083 .35612 L
s
.5309 .35659 m
.5309 .35659 L
s
.53098 .358 m
.53098 .358 L
s
.53105 .35976 m
.53105 .35976 L
s
.53112 .36246 m
.53112 .36246 L
s
.53119 .36105 m
.53119 .36105 L
s
.53127 .35929 m
.53127 .35929 L
s
.53134 .35988 m
.53134 .35988 L
s
.53142 .358 m
.53142 .358 L
s
.53149 .35189 m
.53149 .35189 L
s
.53157 .35471 m
.53157 .35471 L
s
.53165 .35072 m
.53165 .35072 L
s
.53172 .34696 m
.53172 .34696 L
s
.5318 .34755 m
.5318 .34755 L
s
.53186 .34895 m
.53186 .34895 L
s
.53194 .35013 m
.53194 .35013 L
s
.53201 .35483 m
.53201 .35483 L
s
.53209 .34602 m
.53209 .34602 L
s
.53216 .34262 m
.53216 .34262 L
s
.53224 .34262 m
.53224 .34262 L
s
.53231 .33733 m
.53231 .33733 L
s
.53239 .33968 m
.53239 .33968 L
s
.53246 .3432 m
.53246 .3432 L
s
.53254 .33651 m
.53254 .33651 L
s
.53261 .33216 m
.53261 .33216 L
s
.53268 .33346 m
.53268 .33346 L
s
.53275 .33181 m
.53275 .33181 L
s
.53283 .33369 m
.53283 .33369 L
s
.5329 .32746 m
.5329 .32746 L
s
.53298 .31818 m
.53298 .31818 L
s
.53305 .32265 m
.53305 .32265 L
s
.53313 .32606 m
.53313 .32606 L
s
.5332 .32453 m
.5332 .32453 L
s
.53328 .32171 m
.53328 .32171 L
s
.53336 .31713 m
.53336 .31713 L
s
.53343 .3203 m
.53343 .3203 L
s
.5335 .32265 m
.5335 .32265 L
s
.53357 .31995 m
.53357 .31995 L
s
.53365 .31443 m
.53365 .31443 L
s
.53372 .31466 m
.53372 .31466 L
s
.5338 .31572 m
.5338 .31572 L
s
.53387 .32324 m
.53387 .32324 L
s
.53395 .31643 m
.53395 .31643 L
s
.53402 .31901 m
.53402 .31901 L
s
.5341 .31713 m
.5341 .31713 L
s
.53417 .31267 m
.53417 .31267 L
s
.53425 .30832 m
.53425 .30832 L
s
.53431 .30762 m
.53431 .30762 L
s
.53439 .30069 m
.53439 .30069 L
s
.53446 .30491 m
.53446 .30491 L
s
.53454 .30421 m
.53454 .30421 L
s
.53461 .31349 m
.53461 .31349 L
s
.53469 .3122 m
.53469 .3122 L
s
.53477 .31431 m
.53477 .31431 L
s
.53483 .31232 m
.53483 .31232 L
s
.53491 .31361 m
.53491 .31361 L
s
.53499 .3129 m
.53499 .3129 L
s
.53506 .31372 m
.53506 .31372 L
s
.53513 .31032 m
.53513 .31032 L
s
.53521 .31279 m
.53521 .31279 L
s
.53528 .31361 m
.53528 .31361 L
s
.53536 .31055 m
.53536 .31055 L
s
.53543 .31408 m
.53543 .31408 L
s
.53551 .323 m
.53551 .323 L
s
.53558 .323 m
.53558 .323 L
s
.53565 .32018 m
.53565 .32018 L
s
.53573 .31725 m
.53573 .31725 L
s
.53581 .31748 m
.53581 .31748 L
s
.53588 .31384 m
.53588 .31384 L
s
.53595 .3122 m
.53595 .3122 L
s
.53602 .3102 m
.53602 .3102 L
s
.5361 .30844 m
.5361 .30844 L
s
.53617 .3149 m
.53617 .3149 L
s
.53625 .3129 m
.53625 .3129 L
s
.53633 .3122 m
.53633 .3122 L
s
.5364 .31044 m
.5364 .31044 L
s
.53647 .31384 m
.53647 .31384 L
s
.53654 .31596 m
.53654 .31596 L
s
.53662 .31619 m
.53662 .31619 L
s
.53669 .31948 m
.53669 .31948 L
s
.53677 .32007 m
.53677 .32007 L
s
.53684 .32136 m
.53684 .32136 L
s
.53692 .32007 m
.53692 .32007 L
s
.53699 .31748 m
.53699 .31748 L
s
.53707 .31501 m
.53707 .31501 L
s
.53714 .31172 m
.53714 .31172 L
s
.53722 .31079 m
.53722 .31079 L
s
.53728 .31267 m
.53728 .31267 L
s
.53736 .30926 m
.53736 .30926 L
s
.53744 .30891 m
.53744 .30891 L
s
.53751 .31361 m
.53751 .31361 L
s
.53758 .31795 m
.53758 .31795 L
s
.53766 .3129 m
.53766 .3129 L
s
.53773 .31783 m
.53773 .31783 L
s
.53781 .32124 m
.53781 .32124 L
s
.53789 .32206 m
.53789 .32206 L
s
.53796 .31877 m
.53796 .31877 L
s
.53803 .31901 m
.53803 .31901 L
s
.5381 .32124 m
.5381 .32124 L
s
.53818 .31431 m
.53818 .31431 L
s
.53825 .32018 m
.53825 .32018 L
s
.53833 .321 m
.53833 .321 L
s
.5384 .31525 m
.5384 .31525 L
s
.53848 .31372 m
.53848 .31372 L
s
.53855 .30973 m
.53855 .30973 L
s
.53863 .31419 m
.53863 .31419 L
s
.5387 .3129 m
.5387 .3129 L
s
.53878 .31279 m
.53878 .31279 L
s
.53885 .30703 m
.53885 .30703 L
s
.53892 .30327 m
.53892 .30327 L
s
.53899 .30421 m
.53899 .30421 L
s
.53907 .30398 m
.53907 .30398 L
s
.53914 .30409 m
.53914 .30409 L
s
.53922 .30398 m
.53922 .30398 L
s
.53929 .30187 m
.53929 .30187 L
s
.53937 .30151 m
.53937 .30151 L
s
.53945 .30022 m
.53945 .30022 L
s
.53952 .29306 m
.53952 .29306 L
s
.5396 .28706 m
.5396 .28706 L
s
.53966 .29152 m
.53966 .29152 L
s
.53974 .29141 m
.53974 .29141 L
s
.53981 .28671 m
.53981 .28671 L
s
.53989 .2873 m
.53989 .2873 L
s
.53996 .29552 m
.53996 .29552 L
s
.54004 .29317 m
.54004 .29317 L
s
.54011 .29881 m
.54011 .29881 L
s
.54019 .28906 m
.54019 .28906 L
s
.54026 .28718 m
.54026 .28718 L
s
.54034 .28542 m
.54034 .28542 L
s
.54041 .29458 m
.54041 .29458 L
s
.54048 .29364 m
.54048 .29364 L
s
.54055 .29247 m
.54055 .29247 L
s
.54063 .30069 m
.54063 .30069 L
s
.5407 .2974 m
.5407 .2974 L
s
.54078 .29564 m
.54078 .29564 L
s
.54085 .29 m
.54085 .29 L
s
.54093 .2927 m
.54093 .2927 L
s
.54101 .29481 m
.54101 .29481 L
s
.54108 .29881 m
.54108 .29881 L
s
.54116 .29728 m
.54116 .29728 L
s
.54123 .29434 m
.54123 .29434 L
s
.5413 .29646 m
.5413 .29646 L
s
.54137 .30269 m
.54137 .30269 L
s
.54145 .29858 m
.54145 .29858 L
s
.54152 .29822 m
.54152 .29822 L
s
.5416 .30151 m
.5416 .30151 L
s
.54167 .30092 m
.54167 .30092 L
s
.54175 .30245 m
.54175 .30245 L
s
.54182 .30162 m
.54182 .30162 L
s
.5419 .30656 m
.5419 .30656 L
s
.54197 .30562 m
.54197 .30562 L
s
.54205 .3122 m
.54205 .3122 L
s
.54211 .31244 m
.54211 .31244 L
s
.54219 .31678 m
.54219 .31678 L
s
.54226 .31525 m
.54226 .31525 L
s
.54234 .31244 m
.54234 .31244 L
s
.54241 .31126 m
.54241 .31126 L
s
.54249 .3075 m
.54249 .3075 L
s
.54257 .3082 m
.54257 .3082 L
s
.54264 .30668 m
.54264 .30668 L
s
.54272 .31149 m
.54272 .31149 L
s
.54279 .30726 m
.54279 .30726 L
s
.54286 .30844 m
.54286 .30844 L
s
.54293 .30703 m
.54293 .30703 L
s
.54301 .30598 m
.54301 .30598 L
s
.54308 .30915 m
.54308 .30915 L
s
.54316 .31149 m
.54316 .31149 L
s
.54323 .31478 m
.54323 .31478 L
s
.54331 .31901 m
.54331 .31901 L
s
.54338 .31279 m
.54338 .31279 L
s
.54345 .3122 m
.54345 .3122 L
s
.54353 .3169 m
.54353 .3169 L
s
.54361 .32594 m
.54361 .32594 L
s
.54368 .33028 m
.54368 .33028 L
s
.54375 .33064 m
.54375 .33064 L
s
.54382 .33945 m
.54382 .33945 L
s
.5439 .33933 m
.5439 .33933 L
s
.54397 .3331 m
.54397 .3331 L
s
.54405 .33616 m
.54405 .33616 L
s
.54413 .33815 m
.54413 .33815 L
s
.5442 .33956 m
.5442 .33956 L
s
.54427 .3405 m
.54427 .3405 L
s
.54435 .34309 m
.54435 .34309 L
s
.54443 .34473 m
.54443 .34473 L
s
.54449 .3412 m
.54449 .3412 L
s
.54457 .34038 m
.54457 .34038 L
s
.54464 .34003 m
.54464 .34003 L
s
.54472 .34297 m
.54472 .34297 L
s
.54479 .3412 m
.54479 .3412 L
s
.54487 .34684 m
.54487 .34684 L
s
.54494 .34403 m
.54494 .34403 L
s
.54502 .34543 m
.54502 .34543 L
s
.54508 .33639 m
.54508 .33639 L
s
.54516 .3385 m
.54516 .3385 L
s
.54524 .34109 m
.54524 .34109 L
s
.54531 .34062 m
.54531 .34062 L
s
.54538 .34062 m
.54538 .34062 L
s
.54546 .33581 m
.54546 .33581 L
s
.54553 .34097 m
.54553 .34097 L
s
.54561 .35002 m
.54561 .35002 L
s
.54569 .35413 m
.54569 .35413 L
s
.54576 .35683 m
.54576 .35683 L
s
.54583 .35483 m
.54583 .35483 L
s
.5459 .35259 m
.5459 .35259 L
s
.54598 .34931 m
.54598 .34931 L
s
.54606 .35025 m
.54606 .35025 L
s
.54613 .3506 m
.54613 .3506 L
s
.5462 .35495 m
.5462 .35495 L
s
.54628 .35413 m
.54628 .35413 L
s
.54635 .35319 m
.54635 .35319 L
s
.54643 .35072 m
.54643 .35072 L
s
.5465 .35189 m
.5465 .35189 L
s
.54658 .35213 m
.54658 .35213 L
s
.54665 .34895 m
.54665 .34895 L
s
.54672 .34837 m
.54672 .34837 L
s
.54679 .34602 m
.54679 .34602 L
s
.54687 .35401 m
.54687 .35401 L
s
.54694 .3553 m
.54694 .3553 L
s
.54702 .35424 m
.54702 .35424 L
s
.54709 .35671 m
.54709 .35671 L
s
.54717 .36152 m
.54717 .36152 L
s
.54725 .36364 m
.54725 .36364 L
s
.54732 .36658 m
.54732 .36658 L
s
.5474 .36012 m
.5474 .36012 L
s
.54746 .35952 m
.54746 .35952 L
s
.54754 .35718 m
.54754 .35718 L
s
.54761 .35636 m
.54761 .35636 L
s
.54769 .35718 m
.54769 .35718 L
s
.54776 .35436 m
.54776 .35436 L
s
.54784 .35648 m
.54784 .35648 L
s
.54791 .35436 m
.54791 .35436 L
s
.54799 .35483 m
.54799 .35483 L
s
.54806 .34743 m
.54806 .34743 L
s
.54814 .35072 m
.54814 .35072 L
s
.54821 .34567 m
.54821 .34567 L
s
.54828 .34743 m
.54828 .34743 L
s
.54835 .34766 m
.54835 .34766 L
s
.54843 .34249 m
.54843 .34249 L
s
.5485 .33815 m
.5485 .33815 L
s
.54858 .33885 m
.54858 .33885 L
s
.54865 .34015 m
.54865 .34015 L
s
.54873 .34485 m
.54873 .34485 L
s
.54881 .34167 m
.54881 .34167 L
s
.54888 .34179 m
.54888 .34179 L
s
.54896 .34356 m
.54896 .34356 L
s
.54903 .34156 m
.54903 .34156 L
s
.5491 .34179 m
.5491 .34179 L
s
.54917 .33803 m
.54917 .33803 L
s
.54925 .34649 m
.54925 .34649 L
s
.54932 .34884 m
.54932 .34884 L
s
.5494 .34907 m
.5494 .34907 L
s
.54947 .34778 m
.54947 .34778 L
s
.54955 .35259 m
.54955 .35259 L
s
.54962 .35189 m
.54962 .35189 L
s
.5497 .34391 m
.5497 .34391 L
s
.54977 .34508 m
.54977 .34508 L
s
.54985 .34285 m
.54985 .34285 L
s
.54991 .3405 m
.54991 .3405 L
s
.54999 .33686 m
.54999 .33686 L
s
.55006 .34249 m
.55006 .34249 L
s
.55014 .3385 m
.55014 .3385 L
s
.55021 .33686 m
.55021 .33686 L
s
.55029 .33275 m
.55029 .33275 L
s
.55037 .32758 m
.55037 .32758 L
s
.55044 .32828 m
.55044 .32828 L
s
.55052 .32618 m
.55052 .32618 L
s
.55059 .32899 m
.55059 .32899 L
s
.55066 .32982 m
.55066 .32982 L
s
.55073 .32571 m
.55073 .32571 L
s
.55081 .3324 m
.55081 .3324 L
s
.55088 .33099 m
.55088 .33099 L
s
.55096 .33017 m
.55096 .33017 L
s
.55103 .32993 m
.55103 .32993 L
s
.55111 .33017 m
.55111 .33017 L
s
.55118 .32558 m
.55118 .32558 L
s
.55126 .3223 m
.55126 .3223 L
s
.55133 .32182 m
.55133 .32182 L
s
.55141 .32324 m
.55141 .32324 L
s
.55148 .3196 m
.55148 .3196 L
s
.55155 .32089 m
.55155 .32089 L
s
.55162 .32347 m
.55162 .32347 L
s
.5517 .32394 m
.5517 .32394 L
s
.55177 .32758 m
.55177 .32758 L
s
.55185 .32875 m
.55185 .32875 L
s
.55193 .33146 m
.55193 .33146 L
s
.552 .33087 m
.552 .33087 L
s
.55207 .33334 m
.55207 .33334 L
s
.55215 .32641 m
.55215 .32641 L
s
.55223 .32735 m
.55223 .32735 L
s
.5523 .32629 m
.5523 .32629 L
s
.55237 .32982 m
.55237 .32982 L
s
.55244 .32911 m
.55244 .32911 L
s
.55252 .33216 m
.55252 .33216 L
s
.55259 .33028 m
.55259 .33028 L
s
.55267 .32089 m
.55267 .32089 L
s
.55274 .33146 m
.55274 .33146 L
s
.55282 .33028 m
.55282 .33028 L
s
.55289 .33122 m
.55289 .33122 L
s
.55297 .33228 m
.55297 .33228 L
s
.55304 .33275 m
.55304 .33275 L
s
.55311 .33216 m
.55311 .33216 L
s
.55318 .33557 m
.55318 .33557 L
s
.55326 .33357 m
.55326 .33357 L
s
.55333 .33369 m
.55333 .33369 L
s
.55341 .3371 m
.55341 .3371 L
s
.55349 .33334 m
.55349 .33334 L
s
.55356 .33346 m
.55356 .33346 L
s
.55363 .33369 m
.55363 .33369 L
s
.5537 .33521 m
.5537 .33521 L
s
.55378 .3371 m
.55378 .3371 L
s
.55386 .33827 m
.55386 .33827 L
s
.55393 .33463 m
.55393 .33463 L
s
.554 .33192 m
.554 .33192 L
s
.55408 .33428 m
.55408 .33428 L
s
.55415 .33628 m
.55415 .33628 L
s
.55423 .32982 m
.55423 .32982 L
s
.5543 .32887 m
.5543 .32887 L
s
.55438 .32664 m
.55438 .32664 L
s
.55445 .32688 m
.55445 .32688 L
s
.55452 .323 m
.55452 .323 L
s
.5546 .3183 m
.5546 .3183 L
s
.55468 .32018 m
.55468 .32018 L
s
.55474 .31596 m
.55474 .31596 L
s
.55482 .31172 m
.55482 .31172 L
s
.55489 .31865 m
.55489 .31865 L
s
.55497 .31736 m
.55497 .31736 L
s
.55505 .30891 m
.55505 .30891 L
s
.55512 .30985 m
.55512 .30985 L
s
.5552 .31126 m
.5552 .31126 L
s
.55527 .29998 m
.55527 .29998 L
s
.55534 .30045 m
.55534 .30045 L
s
.55541 .29893 m
.55541 .29893 L
s
.55549 .29881 m
.55549 .29881 L
s
.55556 .2967 m
.55556 .2967 L
s
.55564 .29623 m
.55564 .29623 L
s
.55571 .29552 m
.55571 .29552 L
s
.55579 .2967 m
.55579 .2967 L
s
.55586 .29763 m
.55586 .29763 L
s
.55594 .29012 m
.55594 .29012 L
s
.55601 .29658 m
.55601 .29658 L
s
.55608 .29282 m
.55608 .29282 L
s
.55615 .28495 m
.55615 .28495 L
s
.55623 .27309 m
.55623 .27309 L
s
.55631 .2671 m
.55631 .2671 L
s
.55638 .26793 m
.55638 .26793 L
s
.55645 .27192 m
.55645 .27192 L
s
.55653 .27003 m
.55653 .27003 L
s
.55661 .26369 m
.55661 .26369 L
s
.55668 .25911 m
.55668 .25911 L
s
.55676 .26816 m
.55676 .26816 L
s
.55683 .26581 m
.55683 .26581 L
s
.5569 .26252 m
.5569 .26252 L
s
.55697 .26311 m
.55697 .26311 L
s
.55705 .26522 m
.55705 .26522 L
s
.55712 .26945 m
.55712 .26945 L
s
.5572 .26698 m
.5572 .26698 L
s
.55727 .26828 m
.55727 .26828 L
s
.55735 .26898 m
.55735 .26898 L
s
.55742 .2718 m
.55742 .2718 L
s
.5575 .27673 m
.5575 .27673 L
s
.55757 .27168 m
.55757 .27168 L
s
.55765 .2745 m
.55765 .2745 L
s
.55771 .27297 m
.55771 .27297 L
s
.55779 .27521 m
.55779 .27521 L
s
.55786 .26968 m
.55786 .26968 L
s
.55794 .27438 m
.55794 .27438 L
s
.55801 .27978 m
.55801 .27978 L
s
.55809 .27826 m
.55809 .27826 L
s
.55817 .27767 m
.55817 .27767 L
s
.55824 .2745 m
.55824 .2745 L
s
.55832 .27097 m
.55832 .27097 L
s
.55839 .2691 m
.55839 .2691 L
s
.55846 .27368 m
.55846 .27368 L
s
.55853 .27321 m
.55853 .27321 L
s
.55861 .27755 m
.55861 .27755 L
s
.55868 .28002 m
.55868 .28002 L
s
.55876 .27873 m
.55876 .27873 L
s
.55883 .27626 m
.55883 .27626 L
s
.55891 .27344 m
.55891 .27344 L
s
.55898 .2725 m
.55898 .2725 L
s
.55906 .27157 m
.55906 .27157 L
s
.55913 .27015 m
.55913 .27015 L
s
.55921 .27109 m
.55921 .27109 L
s
.55928 .26593 m
.55928 .26593 L
s
.55935 .26569 m
.55935 .26569 L
s
.55942 .26499 m
.55942 .26499 L
s
.5595 .26005 m
.5595 .26005 L
s
.55957 .25723 m
.55957 .25723 L
s
.55965 .26581 m
.55965 .26581 L
s
.55973 .25841 m
.55973 .25841 L
s
.5598 .26111 m
.5598 .26111 L
s
.55988 .25935 m
.55988 .25935 L
s
.55995 .26252 m
.55995 .26252 L
s
.56003 .26745 m
.56003 .26745 L
s
.5601 .27414 m
.5601 .27414 L
s
.56017 .27661 m
.56017 .27661 L
s
.56024 .27368 m
.56024 .27368 L
s
.56032 .26475 m
.56032 .26475 L
s
.56039 .27203 m
.56039 .27203 L
s
.56047 .26945 m
.56047 .26945 L
s
.56054 .26616 m
.56054 .26616 L
s
.56062 .27157 m
.56062 .27157 L
s
.56069 .26933 m
.56069 .26933 L
s
.56077 .2678 m
.56077 .2678 L
s
.56084 .26768 m
.56084 .26768 L
s
.56091 .26452 m
.56091 .26452 L
s
.56098 .26311 m
.56098 .26311 L
s
.56106 .27157 m
.56106 .27157 L
s
.56113 .2725 m
.56113 .2725 L
s
.56121 .26616 m
.56121 .26616 L
s
.56129 .26499 m
.56129 .26499 L
s
.56136 .26452 m
.56136 .26452 L
s
.56143 .2624 m
.56143 .2624 L
s
.56151 .26404 m
.56151 .26404 L
s
.56159 .26593 m
.56159 .26593 L
s
.56166 .26839 m
.56166 .26839 L
s
.56173 .26921 m
.56173 .26921 L
s
.5618 .26733 m
.5618 .26733 L
s
.56188 .26499 m
.56188 .26499 L
s
.56195 .257 m
.56195 .257 L
s
.56203 .25406 m
.56203 .25406 L
s
.5621 .25865 m
.5621 .25865 L
s
.56218 .26322 m
.56218 .26322 L
s
.56225 .26733 m
.56225 .26733 L
s
.56232 .26651 m
.56232 .26651 L
s
.5624 .26229 m
.5624 .26229 L
s
.56248 .25818 m
.56248 .25818 L
s
.56254 .26464 m
.56254 .26464 L
s
.56262 .26135 m
.56262 .26135 L
s
.56269 .26464 m
.56269 .26464 L
s
.56277 .26123 m
.56277 .26123 L
s
.56285 .2597 m
.56285 .2597 L
s
.56292 .26475 m
.56292 .26475 L
s
.563 .2597 m
.563 .2597 L
s
.56307 .25865 m
.56307 .25865 L
s
.56314 .25418 m
.56314 .25418 L
s
.56322 .25665 m
.56322 .25665 L
s
.56329 .25771 m
.56329 .25771 L
s
.56336 .25688 m
.56336 .25688 L
s
.56344 .26428 m
.56344 .26428 L
s
.56351 .26264 m
.56351 .26264 L
s
.56359 .2718 m
.56359 .2718 L
s
.56366 .26921 m
.56366 .26921 L
s
.56374 .26663 m
.56374 .26663 L
s
.56381 .26428 m
.56381 .26428 L
s
.56388 .26804 m
.56388 .26804 L
s
.56395 .26428 m
.56395 .26428 L
s
.56403 .26593 m
.56403 .26593 L
s
.56411 .25794 m
.56411 .25794 L
s
.56418 .25465 m
.56418 .25465 L
s
.56425 .2523 m
.56425 .2523 L
s
.56433 .24972 m
.56433 .24972 L
s
.56441 .25254 m
.56441 .25254 L
s
.56448 .25465 m
.56448 .25465 L
s
.56456 .25735 m
.56456 .25735 L
s
.56463 .26111 m
.56463 .26111 L
s
.5647 .25653 m
.5647 .25653 L
s
.56477 .25347 m
.56477 .25347 L
s
.56485 .25289 m
.56485 .25289 L
s
.56493 .24808 m
.56493 .24808 L
s
.565 .25077 m
.565 .25077 L
s
.56507 .25301 m
.56507 .25301 L
s
.56515 .25113 m
.56515 .25113 L
s
.56522 .24866 m
.56522 .24866 L
s
.5653 .25688 m
.5653 .25688 L
s
.56537 .26005 m
.56537 .26005 L
s
.56545 .26182 m
.56545 .26182 L
s
.56551 .25641 m
.56551 .25641 L
s
.56559 .2617 m
.56559 .2617 L
s
.56566 .26217 m
.56566 .26217 L
s
.56574 .25853 m
.56574 .25853 L
s
.56581 .25747 m
.56581 .25747 L
s
.56589 .26757 m
.56589 .26757 L
s
.56597 .26569 m
.56597 .26569 L
s
.56604 .26357 m
.56604 .26357 L
s
.56612 .26381 m
.56612 .26381 L
s
.56619 .26639 m
.56619 .26639 L
s
.56626 .26075 m
.56626 .26075 L
s
.56633 .26581 m
.56633 .26581 L
s
.56641 .27003 m
.56641 .27003 L
s
.56648 .27391 m
.56648 .27391 L
s
.56656 .27074 m
.56656 .27074 L
s
.56663 .26264 m
.56663 .26264 L
s
.56671 .25876 m
.56671 .25876 L
s
.56678 .26005 m
.56678 .26005 L
s
.56686 .26686 m
.56686 .26686 L
s
.56693 .26639 m
.56693 .26639 L
s
.56701 .26393 m
.56701 .26393 L
s
.56708 .27027 m
.56708 .27027 L
s
.56715 .27614 m
.56715 .27614 L
s
.56722 .27062 m
.56722 .27062 L
s
.5673 .27332 m
.5673 .27332 L
s
.56737 .26898 m
.56737 .26898 L
s
.56745 .27227 m
.56745 .27227 L
s
.56753 .27509 m
.56753 .27509 L
s
.5676 .27039 m
.5676 .27039 L
s
.56768 .27414 m
.56768 .27414 L
s
.56775 .26957 m
.56775 .26957 L
s
.56783 .27379 m
.56783 .27379 L
s
.5679 .27814 m
.5679 .27814 L
s
.56797 .27778 m
.56797 .27778 L
s
.56804 .27168 m
.56804 .27168 L
s
.56812 .27532 m
.56812 .27532 L
s
.56819 .27673 m
.56819 .27673 L
s
.56827 .27778 m
.56827 .27778 L
s
.56834 .27755 m
.56834 .27755 L
s
.56842 .28167 m
.56842 .28167 L
s
.56849 .27661 m
.56849 .27661 L
s
.56857 .2819 m
.56857 .2819 L
s
.56864 .28718 m
.56864 .28718 L
s
.56871 .27978 m
.56871 .27978 L
s
.56878 .28072 m
.56878 .28072 L
s
.56886 .27978 m
.56886 .27978 L
s
.56893 .28249 m
.56893 .28249 L
s
.56901 .28167 m
.56901 .28167 L
s
.56909 .28142 m
.56909 .28142 L
s
.56916 .29012 m
.56916 .29012 L
s
.56923 .28542 m
.56923 .28542 L
s
.56931 .28167 m
.56931 .28167 L
s
.56939 .28237 m
.56939 .28237 L
s
.56946 .28202 m
.56946 .28202 L
s
.56953 .27967 m
.56953 .27967 L
s
.5696 .28072 m
.5696 .28072 L
s
.56968 .28072 m
.56968 .28072 L
s
.56975 .28167 m
.56975 .28167 L
s
.56983 .2806 m
.56983 .2806 L
s
.5699 .27685 m
.5699 .27685 L
s
.56998 .27614 m
.56998 .27614 L
s
.57005 .2671 m
.57005 .2671 L
s
.57013 .27544 m
.57013 .27544 L
s
.5702 .2718 m
.5702 .2718 L
s
.57028 .27062 m
.57028 .27062 L
s
.57034 .26875 m
.57034 .26875 L
s
.57042 .26522 m
.57042 .26522 L
s
.57049 .2705 m
.57049 .2705 L
s
.57057 .27227 m
.57057 .27227 L
s
.57065 .26945 m
.57065 .26945 L
s
.57072 .26921 m
.57072 .26921 L
s
.5708 .26921 m
.5708 .26921 L
s
.57087 .27003 m
.57087 .27003 L
s
.57094 .27379 m
.57094 .27379 L
s
.57102 .27414 m
.57102 .27414 L
s
.57109 .28072 m
.57109 .28072 L
s
.57116 .27826 m
.57116 .27826 L
s
.57124 .28342 m
.57124 .28342 L
s
.57131 .2799 m
.57131 .2799 L
s
.57139 .28471 m
.57139 .28471 L
s
.57146 .29517 m
.57146 .29517 L
s
.57154 .292 m
.57154 .292 L
s
.57161 .29787 m
.57161 .29787 L
s
.57168 .29634 m
.57168 .29634 L
s
.57176 .30022 m
.57176 .30022 L
s
.57184 .30198 m
.57184 .30198 L
s
.57191 .30691 m
.57191 .30691 L
s
.57198 .30656 m
.57198 .30656 L
s
.57205 .31208 m
.57205 .31208 L
s
.57213 .31279 m
.57213 .31279 L
s
.57221 .31267 m
.57221 .31267 L
s
.57228 .31501 m
.57228 .31501 L
s
.57236 .31196 m
.57236 .31196 L
s
.57243 .31995 m
.57243 .31995 L
s
.5725 .31783 m
.5725 .31783 L
s
.57257 .32124 m
.57257 .32124 L
s
.57265 .3169 m
.57265 .3169 L
s
.57273 .31772 m
.57273 .31772 L
s
.5728 .31372 m
.5728 .31372 L
s
.57287 .31772 m
.57287 .31772 L
s
.57295 .31549 m
.57295 .31549 L
s
.57302 .32054 m
.57302 .32054 L
s
.5731 .32723 m
.5731 .32723 L
s
.57317 .32641 m
.57317 .32641 L
s
.57325 .32606 m
.57325 .32606 L
s
.57331 .31666 m
.57331 .31666 L
s
.57339 .31454 m
.57339 .31454 L
s
.57347 .32112 m
.57347 .32112 L
s
.57354 .32042 m
.57354 .32042 L
s
.57361 .32089 m
.57361 .32089 L
s
.57369 .325 m
.57369 .325 L
s
.57377 .32159 m
.57377 .32159 L
s
.57384 .31901 m
.57384 .31901 L
s
.57392 .32112 m
.57392 .32112 L
s
.57399 .32182 m
.57399 .32182 L
s
.57406 .3176 m
.57406 .3176 L
s
.57413 .31561 m
.57413 .31561 L
s
.57421 .30962 m
.57421 .30962 L
s
.57428 .31783 m
.57428 .31783 L
s
.57436 .32112 m
.57436 .32112 L
s
.57443 .31678 m
.57443 .31678 L
s
.57451 .31525 m
.57451 .31525 L
s
.57458 .31314 m
.57458 .31314 L
s
.57466 .30468 m
.57466 .30468 L
s
.57473 .30773 m
.57473 .30773 L
s
.57481 .30398 m
.57481 .30398 L
s
.57488 .29881 m
.57488 .29881 L
s
.57495 .29411 m
.57495 .29411 L
s
.57502 .29129 m
.57502 .29129 L
s
.5751 .28577 m
.5751 .28577 L
s
.57517 .2893 m
.57517 .2893 L
s
.57525 .28941 m
.57525 .28941 L
s
.57533 .29399 m
.57533 .29399 L
s
.5754 .29306 m
.5754 .29306 L
s
.57548 .29587 m
.57548 .29587 L
s
.57555 .30198 m
.57555 .30198 L
s
.57563 .30374 m
.57563 .30374 L
s
.5757 .30668 m
.5757 .30668 L
s
.57577 .3109 m
.57577 .3109 L
s
.57584 .31478 m
.57584 .31478 L
s
.57592 .31279 m
.57592 .31279 L
s
.57599 .30855 m
.57599 .30855 L
s
.57607 .30257 m
.57607 .30257 L
s
.57614 .2981 m
.57614 .2981 L
s
.57622 .29399 m
.57622 .29399 L
s
.57629 .29693 m
.57629 .29693 L
s
.57637 .29775 m
.57637 .29775 L
s
.57644 .30234 m
.57644 .30234 L
s
.57651 .30316 m
.57651 .30316 L
s
.57658 .30621 m
.57658 .30621 L
s
.57666 .30374 m
.57666 .30374 L
s
.57673 .30269 m
.57673 .30269 L
s
.57681 .29752 m
.57681 .29752 L
s
.57689 .30222 m
.57689 .30222 L
s
.57696 .3068 m
.57696 .3068 L
s
.57704 .3095 m
.57704 .3095 L
s
.57711 .30962 m
.57711 .30962 L
s
.57719 .30762 m
.57719 .30762 L
s
.57726 .30327 m
.57726 .30327 L
s
.57733 .30386 m
.57733 .30386 L
s
.5774 .30644 m
.5774 .30644 L
s
.57748 .30633 m
.57748 .30633 L
s
.57755 .29611 m
.57755 .29611 L
s
.57763 .30057 m
.57763 .30057 L
s
.5777 .30515 m
.5777 .30515 L
s
.57778 .30903 m
.57778 .30903 L
s
.57785 .31384 m
.57785 .31384 L
s
.57793 .31925 m
.57793 .31925 L
s
.578 .31865 m
.578 .31865 L
s
.57808 .31772 m
.57808 .31772 L
s
.57814 .31536 m
.57814 .31536 L
s
.57822 .31044 m
.57822 .31044 L
s
.57829 .3068 m
.57829 .3068 L
s
.57837 .30327 m
.57837 .30327 L
s
.57845 .30022 m
.57845 .30022 L
s
.57852 .2927 m
.57852 .2927 L
s
.5786 .292 m
.5786 .292 L
s
.57867 .29446 m
.57867 .29446 L
s
.57874 .29787 m
.57874 .29787 L
s
.57882 .29364 m
.57882 .29364 L
s
.5789 .28788 m
.5789 .28788 L
s
.57896 .29224 m
.57896 .29224 L
s
.57904 .29247 m
.57904 .29247 L
s
.57911 .29634 m
.57911 .29634 L
s
.57919 .29552 m
.57919 .29552 L
s
.57926 .29728 m
.57926 .29728 L
s
.57934 .29775 m
.57934 .29775 L
s
.57941 .30515 m
.57941 .30515 L
s
.57948 .30726 m
.57948 .30726 L
s
.57956 .30586 m
.57956 .30586 L
s
.57964 .30903 m
.57964 .30903 L
s
.57971 .30491 m
.57971 .30491 L
s
.57978 .30339 m
.57978 .30339 L
s
.57985 .29716 m
.57985 .29716 L
s
.57993 .30045 m
.57993 .30045 L
s
.58001 .29446 m
.58001 .29446 L
s
.58008 .29822 m
.58008 .29822 L
s
.58016 .30069 m
.58016 .30069 L
s
.58023 .30398 m
.58023 .30398 L
s
.5803 .30421 m
.5803 .30421 L
s
.58038 .30633 m
.58038 .30633 L
s
.58045 .3028 m
.58045 .3028 L
s
.58053 .30245 m
.58053 .30245 L
s
.5806 .30162 m
.5806 .30162 L
s
.58067 .30633 m
.58067 .30633 L
s
.58075 .30633 m
.58075 .30633 L
s
.58082 .30738 m
.58082 .30738 L
s
.5809 .30269 m
.5809 .30269 L
s
.58097 .30726 m
.58097 .30726 L
s
.58105 .30468 m
.58105 .30468 L
s
.58111 .30398 m
.58111 .30398 L
s
.58119 .31114 m
.58119 .31114 L
s
.58127 .31549 m
.58127 .31549 L
s
.58134 .3129 m
.58134 .3129 L
s
.58141 .31419 m
.58141 .31419 L
s
.58149 .3109 m
.58149 .3109 L
s
.58157 .30762 m
.58157 .30762 L
s
.58164 .30844 m
.58164 .30844 L
s
.58172 .31137 m
.58172 .31137 L
s
.58179 .30644 m
.58179 .30644 L
s
.58187 .30269 m
.58187 .30269 L
s
.58193 .30234 m
.58193 .30234 L
s
.58201 .30304 m
.58201 .30304 L
s
.58209 .30269 m
.58209 .30269 L
s
.58216 .30797 m
.58216 .30797 L
s
.58223 .30844 m
.58223 .30844 L
s
.58231 .30915 m
.58231 .30915 L
s
.58238 .30162 m
.58238 .30162 L
s
.58246 .30069 m
.58246 .30069 L
s
.58253 .29529 m
.58253 .29529 L
s
.58261 .2967 m
.58261 .2967 L
s
.58268 .29787 m
.58268 .29787 L
s
.58275 .30069 m
.58275 .30069 L
s
.58282 .30116 m
.58282 .30116 L
s
.5829 .29423 m
.5829 .29423 L
s
.58297 .29141 m
.58297 .29141 L
s
.58305 .30116 m
.58305 .30116 L
s
.58313 .29952 m
.58313 .29952 L
s
.5832 .30257 m
.5832 .30257 L
s
.58328 .3001 m
.58328 .3001 L
s
.58335 .29928 m
.58335 .29928 L
s
.58343 .30092 m
.58343 .30092 L
s
.5835 .29998 m
.5835 .29998 L
s
.58357 .29834 m
.58357 .29834 L
s
.58364 .29905 m
.58364 .29905 L
s
.58372 .29798 m
.58372 .29798 L
s
.58379 .29317 m
.58379 .29317 L
s
.58387 .29082 m
.58387 .29082 L
s
.58394 .28859 m
.58394 .28859 L
s
.58402 .29623 m
.58402 .29623 L
s
.58409 .2927 m
.58409 .2927 L
s
.58417 .28977 m
.58417 .28977 L
s
.58424 .29376 m
.58424 .29376 L
s
.58431 .29035 m
.58431 .29035 L
s
.58438 .29317 m
.58438 .29317 L
s
.58446 .29082 m
.58446 .29082 L
s
.58453 .28777 m
.58453 .28777 L
s
.58461 .29082 m
.58461 .29082 L
s
.58469 .29611 m
.58469 .29611 L
s
.58476 .28953 m
.58476 .28953 L
s
.58484 .28824 m
.58484 .28824 L
s
.58491 .28589 m
.58491 .28589 L
s
.58499 .28354 m
.58499 .28354 L
s
.58506 .28871 m
.58506 .28871 L
s
.58513 .29035 m
.58513 .29035 L
s
.5852 .29998 m
.5852 .29998 L
s
.58528 .29905 m
.58528 .29905 L
s
.58535 .30151 m
.58535 .30151 L
s
.58543 .30234 m
.58543 .30234 L
s
.5855 .30527 m
.5855 .30527 L
s
.58558 .30398 m
.58558 .30398 L
s
.58565 .30562 m
.58565 .30562 L
s
.58573 .30562 m
.58573 .30562 L
s
.5858 .3028 m
.5858 .3028 L
s
.58588 .30162 m
.58588 .30162 L
s
.58594 .29881 m
.58594 .29881 L
s
.58602 .30551 m
.58602 .30551 L
s
.58609 .30116 m
.58609 .30116 L
s
.58617 .31008 m
.58617 .31008 L
s
.58625 .31055 m
.58625 .31055 L
s
.58632 .30609 m
.58632 .30609 L
s
.5864 .30069 m
.5864 .30069 L
s
.58647 .30162 m
.58647 .30162 L
s
.58655 .29998 m
.58655 .29998 L
s
.58662 .29975 m
.58662 .29975 L
s
.5867 .29998 m
.5867 .29998 L
s
.58676 .30327 m
.58676 .30327 L
s
.58684 .30656 m
.58684 .30656 L
s
.58691 .30269 m
.58691 .30269 L
s
.58699 .31196 m
.58699 .31196 L
s
.58706 .30633 m
.58706 .30633 L
s
.58714 .31314 m
.58714 .31314 L
s
.58721 .3122 m
.58721 .3122 L
s
.58728 .30997 m
.58728 .30997 L
s
.58736 .31361 m
.58736 .31361 L
s
.58744 .31384 m
.58744 .31384 L
s
.58751 .31032 m
.58751 .31032 L
s
.58758 .30456 m
.58758 .30456 L
s
.58765 .30468 m
.58765 .30468 L
s
.58773 .30162 m
.58773 .30162 L
s
.58781 .30398 m
.58781 .30398 L
s
.58788 .29905 m
.58788 .29905 L
s
.58796 .2994 m
.58796 .2994 L
s
.58803 .30304 m
.58803 .30304 L
s
.5881 .30726 m
.5881 .30726 L
s
.58818 .30985 m
.58818 .30985 L
s
.58826 .30703 m
.58826 .30703 L
s
.58833 .30174 m
.58833 .30174 L
s
.5884 .31008 m
.5884 .31008 L
s
.58847 .31102 m
.58847 .31102 L
s
.58855 .30997 m
.58855 .30997 L
s
.58862 .31631 m
.58862 .31631 L
s
.5887 .31666 m
.5887 .31666 L
s
.58877 .32429 m
.58877 .32429 L
s
.58885 .32594 m
.58885 .32594 L
s
.58892 .3324 m
.58892 .3324 L
s
.58899 .33428 m
.58899 .33428 L
s
.58907 .33087 m
.58907 .33087 L
s
.58914 .3324 m
.58914 .3324 L
s
.58921 .33428 m
.58921 .33428 L
s
.58929 .3324 m
.58929 .3324 L
s
.58937 .33604 m
.58937 .33604 L
s
.58944 .34015 m
.58944 .34015 L
s
.58952 .3432 m
.58952 .3432 L
s
.58959 .35177 m
.58959 .35177 L
s
.58967 .34449 m
.58967 .34449 L
s
.58973 .34461 m
.58973 .34461 L
s
.58981 .34766 m
.58981 .34766 L
s
.58989 .34555 m
.58989 .34555 L
s
.58996 .34931 m
.58996 .34931 L
s
.59003 .35213 m
.59003 .35213 L
s
.59011 .35142 m
.59011 .35142 L
s
.59018 .35694 m
.59018 .35694 L
s
.59026 .35823 m
.59026 .35823 L
s
.59033 .3499 m
.59033 .3499 L
s
.59041 .35248 m
.59041 .35248 L
s
.59048 .35037 m
.59048 .35037 L
s
.59055 .35553 m
.59055 .35553 L
s
.59063 .35894 m
.59063 .35894 L
s
.5907 .36505 m
.5907 .36505 L
s
.59078 .36293 m
.59078 .36293 L
s
.59085 .36481 m
.59085 .36481 L
s
.59093 .37256 m
.59093 .37256 L
s
.591 .37726 m
.591 .37726 L
s
.59108 .37468 m
.59108 .37468 L
s
.59115 .38102 m
.59115 .38102 L
s
.59123 .38548 m
.59123 .38548 L
s
.5913 .38301 m
.5913 .38301 L
s
.59137 .38384 m
.59137 .38384 L
s
.59144 .38219 m
.59144 .38219 L
s
.59152 .38971 m
.59152 .38971 L
s
.59159 .39229 m
.59159 .39229 L
s
.59167 .39077 m
.59167 .39077 L
s
.59174 .39147 m
.59174 .39147 L
s
.59182 .38865 m
.59182 .38865 L
s
.59189 .38877 m
.59189 .38877 L
s
.59197 .38431 m
.59197 .38431 L
s
.59204 .38196 m
.59204 .38196 L
s
.59211 .37832 m
.59211 .37832 L
s
.59218 .37867 m
.59218 .37867 L
s
.59226 .3876 m
.59226 .3876 L
s
.59234 .39488 m
.59234 .39488 L
s
.59241 .40052 m
.59241 .40052 L
s
.59249 .39981 m
.59249 .39981 L
s
.59256 .3964 m
.59256 .3964 L
s
.59264 .39617 m
.59264 .39617 L
s
.59271 .39488 m
.59271 .39488 L
s
.59279 .39217 m
.59279 .39217 L
s
.59286 .39171 m
.59286 .39171 L
s
.59293 .39593 m
.59293 .39593 L
s
.593 .39981 m
.593 .39981 L
s
.59308 .40004 m
.59308 .40004 L
s
.59315 .40052 m
.59315 .40052 L
s
.59323 .39628 m
.59323 .39628 L
s
.5933 .389 m
.5933 .389 L
s
.59338 .39535 m
.59338 .39535 L
s
.59345 .39264 m
.59345 .39264 L
s
.59353 .39406 m
.59353 .39406 L
s
.5936 .39147 m
.5936 .39147 L
s
.59368 .38419 m
.59368 .38419 L
s
.59375 .38372 m
.59375 .38372 L
s
.59382 .38501 m
.59382 .38501 L
s
.59389 .38337 m
.59389 .38337 L
s
.59397 .38407 m
.59397 .38407 L
s
.59405 .38207 m
.59405 .38207 L
s
.59412 .38713 m
.59412 .38713 L
s
.5942 .39194 m
.5942 .39194 L
s
.59427 .39406 m
.59427 .39406 L
s
.59435 .39675 m
.59435 .39675 L
s
.59442 .39429 m
.59442 .39429 L
s
.5945 .39124 m
.5945 .39124 L
s
.59456 .39417 m
.59456 .39417 L
s
.59464 .39805 m
.59464 .39805 L
s
.59471 .40122 m
.59471 .40122 L
s
.59479 .40004 m
.59479 .40004 L
s
.59486 .40321 m
.59486 .40321 L
s
.59494 .40145 m
.59494 .40145 L
s
.59501 .39899 m
.59501 .39899 L
s
.59509 .39124 m
.59509 .39124 L
s
.59516 .39394 m
.59516 .39394 L
s
.59524 .39299 m
.59524 .39299 L
s
.59531 .39217 m
.59531 .39217 L
s
.59538 .39605 m
.59538 .39605 L
s
.59545 .39723 m
.59545 .39723 L
s
.59553 .39089 m
.59553 .39089 L
s
.59561 .39089 m
.59561 .39089 L
s
.59568 .39124 m
.59568 .39124 L
s
.59576 .38689 m
.59576 .38689 L
s
.59583 .38865 m
.59583 .38865 L
s
.5959 .38982 m
.5959 .38982 L
s
.59598 .39499 m
.59598 .39499 L
s
.59606 .39476 m
.59606 .39476 L
s
.59613 .39793 m
.59613 .39793 L
s
.5962 .40227 m
.5962 .40227 L
s
.59627 .40803 m
.59627 .40803 L
s
.59635 .41038 m
.59635 .41038 L
s
.59642 .40638 m
.59642 .40638 L
s
.5965 .40427 m
.5965 .40427 L
s
.59657 .39723 m
.59657 .39723 L
s
.59665 .39406 m
.59665 .39406 L
s
.59672 .38689 m
.59672 .38689 L
s
.5968 .38043 m
.5968 .38043 L
s
.59687 .38137 m
.59687 .38137 L
s
.59694 .3775 m
.59694 .3775 L
s
.59701 .37703 m
.59701 .37703 L
s
.59709 .38172 m
.59709 .38172 L
s
.59717 .37867 m
.59717 .37867 L
s
.59724 .37984 m
.59724 .37984 L
s
.59732 .389 m
.59732 .389 L
s
.59739 .39124 m
.59739 .39124 L
s
.59747 .39488 m
.59747 .39488 L
s
.59753 .39746 m
.59753 .39746 L
s
.59761 .39605 m
.59761 .39605 L
s
.59769 .39558 m
.59769 .39558 L
s
.59776 .40321 m
.59776 .40321 L
s
.59783 .39711 m
.59783 .39711 L
s
.59791 .39957 m
.59791 .39957 L
s
.59798 .39758 m
.59798 .39758 L
s
.59806 .39323 m
.59806 .39323 L
s
.59813 .39112 m
.59813 .39112 L
s
.59821 .39488 m
.59821 .39488 L
s
.59828 .39453 m
.59828 .39453 L
s
.59835 .39511 m
.59835 .39511 L
s
.59843 .39394 m
.59843 .39394 L
s
.59851 .39546 m
.59851 .39546 L
s
.59858 .3964 m
.59858 .3964 L
s
.59865 .39346 m
.59865 .39346 L
s
.59873 .39699 m
.59873 .39699 L
s
.5988 .39593 m
.5988 .39593 L
s
.59888 .39758 m
.59888 .39758 L
s
.59895 .39429 m
.59895 .39429 L
s
.59903 .39453 m
.59903 .39453 L
s
.5991 .39593 m
.5991 .39593 L
s
.59917 .39464 m
.59917 .39464 L
s
.59924 .39253 m
.59924 .39253 L
s
.59932 .39699 m
.59932 .39699 L
s
.59939 .39887 m
.59939 .39887 L
s
.59947 .39899 m
.59947 .39899 L
s
.59954 .40192 m
.59954 .40192 L
s
.59962 .40603 m
.59962 .40603 L
s
.59969 .40521 m
.59969 .40521 L
s
.59977 .41073 m
.59977 .41073 L
s
.59984 .40979 m
.59984 .40979 L
s
.59991 .40967 m
.59991 .40967 L
s
.59998 .41743 m
.59998 .41743 L
s
.60006 .41695 m
.60006 .41695 L
s
.60014 .41848 m
.60014 .41848 L
s
.60021 .42388 m
.60021 .42388 L
s
.60029 .42705 m
.60029 .42705 L
s
.60036 .42541 m
.60036 .42541 L
s
.60044 .428 m
.60044 .428 L
s
.60051 .42095 m
.60051 .42095 L
s
.60059 .42506 m
.60059 .42506 L
s
.60066 .41695 m
.60066 .41695 L
s
.60073 .41907 m
.60073 .41907 L
s
.6008 .41825 m
.6008 .41825 L
s
.60088 .41426 m
.60088 .41426 L
s
.60095 .41284 m
.60095 .41284 L
s
.60103 .41155 m
.60103 .41155 L
s
.6011 .41085 m
.6011 .41085 L
s
.60118 .41226 m
.60118 .41226 L
s
.60125 .41743 m
.60125 .41743 L
s
.60133 .4166 m
.60133 .4166 L
s
.6014 .42341 m
.6014 .42341 L
s
.60148 .42001 m
.60148 .42001 L
s
.60155 .41355 m
.60155 .41355 L
s
.60162 .42154 m
.60162 .42154 L
s
.60169 .42705 m
.60169 .42705 L
s
.60177 .42765 m
.60177 .42765 L
s
.60185 .42471 m
.60185 .42471 L
s
.60192 .42283 m
.60192 .42283 L
s
.602 .42658 m
.602 .42658 L
s
.60207 .4334 m
.60207 .4334 L
s
.60215 .43668 m
.60215 .43668 L
s
.60222 .43668 m
.60222 .43668 L
s
.6023 .43528 m
.6023 .43528 L
s
.60236 .43622 m
.60236 .43622 L
s
.60244 .4442 m
.60244 .4442 L
s
.60251 .4381 m
.60251 .4381 L
s
.60259 .42847 m
.60259 .42847 L
s
.60266 .428 m
.60266 .428 L
s
.60274 .42353 m
.60274 .42353 L
s
.60281 .42729 m
.60281 .42729 L
s
.60289 .43081 m
.60289 .43081 L
s
.60296 .4294 m
.60296 .4294 L
s
.60304 .43493 m
.60304 .43493 L
s
.60311 .43046 m
.60311 .43046 L
s
.60318 .43293 m
.60318 .43293 L
s
.60325 .42964 m
.60325 .42964 L
s
.60333 .42917 m
.60333 .42917 L
s
.60341 .42024 m
.60341 .42024 L
s
.60348 .42518 m
.60348 .42518 L
s
.60356 .42376 m
.60356 .42376 L
s
.60363 .42318 m
.60363 .42318 L
s
.60371 .42083 m
.60371 .42083 L
s
.60378 .42224 m
.60378 .42224 L
s
.60386 .42365 m
.60386 .42365 L
s
.60393 .41966 m
.60393 .41966 L
s
.604 .41331 m
.604 .41331 L
s
.60407 .41848 m
.60407 .41848 L
s
.60415 .42177 m
.60415 .42177 L
s
.60422 .42166 m
.60422 .42166 L
s
.6043 .42729 m
.6043 .42729 L
s
.60437 .42635 m
.60437 .42635 L
s
.60445 .4193 m
.60445 .4193 L
s
.60452 .4193 m
.60452 .4193 L
s
.6046 .42788 m
.6046 .42788 L
s
.60467 .42694 m
.60467 .42694 L
s
.60474 .41942 m
.60474 .41942 L
s
.60481 .42119 m
.60481 .42119 L
s
.60489 .42166 m
.60489 .42166 L
s
.60497 .42729 m
.60497 .42729 L
s
.60504 .424 m
.60504 .424 L
s
.60512 .424 m
.60512 .424 L
s
.60519 .4193 m
.60519 .4193 L
s
.60527 .4186 m
.60527 .4186 L
s
.60534 .4112 m
.60534 .4112 L
s
.60542 .41296 m
.60542 .41296 L
s
.60549 .41214 m
.60549 .41214 L
s
.60556 .41002 m
.60556 .41002 L
s
.60563 .41261 m
.60563 .41261 L
s
.60571 .41402 m
.60571 .41402 L
s
.60578 .41191 m
.60578 .41191 L
s
.60586 .41062 m
.60586 .41062 L
s
.60593 .41531 m
.60593 .41531 L
s
.60601 .42142 m
.60601 .42142 L
s
.60608 .428 m
.60608 .428 L
s
.60615 .42682 m
.60615 .42682 L
s
.60623 .43034 m
.60623 .43034 L
s
.60631 .42753 m
.60631 .42753 L
s
.60638 .42612 m
.60638 .42612 L
s
.60645 .42776 m
.60645 .42776 L
s
.60653 .42448 m
.60653 .42448 L
s
.6066 .42612 m
.6066 .42612 L
s
.60668 .42753 m
.60668 .42753 L
s
.60675 .43081 m
.60675 .43081 L
s
.60683 .43927 m
.60683 .43927 L
s
.6069 .4368 m
.6069 .4368 L
s
.60697 .43657 m
.60697 .43657 L
s
.60705 .43633 m
.60705 .43633 L
s
.60713 .43822 m
.60713 .43822 L
s
.60719 .43633 m
.60719 .43633 L
s
.60727 .4368 m
.60727 .4368 L
s
.60734 .44174 m
.60734 .44174 L
s
.60742 .43551 m
.60742 .43551 L
s
.60749 .43528 m
.60749 .43528 L
s
.60757 .44585 m
.60757 .44585 L
s
.60764 .4482 m
.60764 .4482 L
s
.60771 .4395 m
.60771 .4395 L
s
.60778 .43786 m
.60778 .43786 L
s
.60786 .43386 m
.60786 .43386 L
s
.60794 .4287 m
.60794 .4287 L
s
.60801 .42259 m
.60801 .42259 L
s
.60809 .42318 m
.60809 .42318 L
s
.60816 .41719 m
.60816 .41719 L
s
.60824 .41391 m
.60824 .41391 L
s
.60831 .40991 m
.60831 .40991 L
s
.60839 .41155 m
.60839 .41155 L
s
.60846 .40603 m
.60846 .40603 L
s
.60853 .40674 m
.60853 .40674 L
s
.6086 .40838 m
.6086 .40838 L
s
.60868 .41331 m
.60868 .41331 L
s
.60876 .41155 m
.60876 .41155 L
s
.60883 .41109 m
.60883 .41109 L
s
.6089 .41684 m
.6089 .41684 L
s
.60898 .41813 m
.60898 .41813 L
s
.60905 .41391 m
.60905 .41391 L
s
.60913 .41343 m
.60913 .41343 L
s
.6092 .41672 m
.6092 .41672 L
s
.60928 .4166 m
.60928 .4166 L
s
.60935 .41414 m
.60935 .41414 L
s
.60942 .41226 m
.60942 .41226 L
s
.60949 .41391 m
.60949 .41391 L
s
.60957 .41378 m
.60957 .41378 L
s
.60965 .40838 m
.60965 .40838 L
s
.60972 .41179 m
.60972 .41179 L
s
.6098 .4112 m
.6098 .4112 L
s
.60987 .40791 m
.60987 .40791 L
s
.60995 .41249 m
.60995 .41249 L
s
.61002 .41273 m
.61002 .41273 L
s
.6101 .41402 m
.6101 .41402 L
s
.61016 .40991 m
.61016 .40991 L
s
.61024 .42024 m
.61024 .42024 L
s
.61031 .42119 m
.61031 .42119 L
s
.61039 .4186 m
.61039 .4186 L
s
.61046 .41062 m
.61046 .41062 L
s
.61054 .41402 m
.61054 .41402 L
s
.61061 .41214 m
.61061 .41214 L
s
.61069 .41461 m
.61069 .41461 L
s
.61076 .41438 m
.61076 .41438 L
s
.61084 .4159 m
.61084 .4159 L
s
.61091 .41543 m
.61091 .41543 L
s
.61098 .41402 m
.61098 .41402 L
s
.61105 .41261 m
.61105 .41261 L
s
.61113 .41085 m
.61113 .41085 L
s
.61121 .41355 m
.61121 .41355 L
s
.61128 .41002 m
.61128 .41002 L
s
.61136 .40909 m
.61136 .40909 L
s
.61143 .41179 m
.61143 .41179 L
s
.61151 .41202 m
.61151 .41202 L
s
.61158 .4159 m
.61158 .4159 L
s
.61166 .4213 m
.61166 .4213 L
s
.61173 .41907 m
.61173 .41907 L
s
.6118 .42248 m
.6118 .42248 L
s
.61187 .42095 m
.61187 .42095 L
s
.61195 .40932 m
.61195 .40932 L
s
.61202 .41085 m
.61202 .41085 L
s
.6121 .41132 m
.6121 .41132 L
s
.61217 .41261 m
.61217 .41261 L
s
.61225 .41226 m
.61225 .41226 L
s
.61232 .40909 m
.61232 .40909 L
s
.6124 .41438 m
.6124 .41438 L
s
.61247 .41743 m
.61247 .41743 L
s
.61254 .41942 m
.61254 .41942 L
s
.61261 .41391 m
.61261 .41391 L
s
.61269 .41366 m
.61269 .41366 L
s
.61277 .41085 m
.61277 .41085 L
s
.61284 .41109 m
.61284 .41109 L
s
.61292 .41249 m
.61292 .41249 L
s
.61299 .42189 m
.61299 .42189 L
s
.61307 .41977 m
.61307 .41977 L
s
.61314 .42259 m
.61314 .42259 L
s
.61322 .42201 m
.61322 .42201 L
s
.61329 .41954 m
.61329 .41954 L
s
.61336 .41977 m
.61336 .41977 L
s
.61343 .42212 m
.61343 .42212 L
s
.61351 .42388 m
.61351 .42388 L
s
.61358 .42154 m
.61358 .42154 L
s
.61366 .41919 m
.61366 .41919 L
s
.61373 .41684 m
.61373 .41684 L
s
.61381 .42259 m
.61381 .42259 L
s
.61388 .4274 m
.61388 .4274 L
s
.61396 .43046 m
.61396 .43046 L
s
.61403 .43152 m
.61403 .43152 L
s
.61411 .43094 m
.61411 .43094 L
s
.61418 .43034 m
.61418 .43034 L
s
.61425 .4233 m
.61425 .4233 L
s
.61433 .42694 m
.61433 .42694 L
s
.6144 .4267 m
.6144 .4267 L
s
.61448 .42765 m
.61448 .42765 L
s
.61455 .4253 m
.61455 .4253 L
s
.61463 .42729 m
.61463 .42729 L
s
.6147 .4287 m
.6147 .4287 L
s
.61477 .42894 m
.61477 .42894 L
s
.61485 .43328 m
.61485 .43328 L
s
.61493 .43504 m
.61493 .43504 L
s
.61499 .43493 m
.61499 .43493 L
s
.61507 .43281 m
.61507 .43281 L
s
.61514 .43094 m
.61514 .43094 L
s
.61522 .43563 m
.61522 .43563 L
s
.61529 .43598 m
.61529 .43598 L
s
.61537 .4334 m
.61537 .4334 L
s
.61544 .43304 m
.61544 .43304 L
s
.61551 .43105 m
.61551 .43105 L
s
.61559 .43222 m
.61559 .43222 L
s
.61567 .43058 m
.61567 .43058 L
s
.61574 .43293 m
.61574 .43293 L
s
.61581 .43563 m
.61581 .43563 L
s
.61589 .43022 m
.61589 .43022 L
s
.61596 .43469 m
.61596 .43469 L
s
.61604 .43762 m
.61604 .43762 L
s
.61611 .43575 m
.61611 .43575 L
s
.61619 .4354 m
.61619 .4354 L
s
.61626 .43246 m
.61626 .43246 L
s
.61633 .43622 m
.61633 .43622 L
s
.6164 .44056 m
.6164 .44056 L
s
.61648 .44326 m
.61648 .44326 L
s
.61656 .44044 m
.61656 .44044 L
s
.61663 .44115 m
.61663 .44115 L
s
.6167 .43833 m
.6167 .43833 L
s
.61678 .43986 m
.61678 .43986 L
s
.61685 .44056 m
.61685 .44056 L
s
.61693 .44103 m
.61693 .44103 L
s
.617 .43081 m
.617 .43081 L
s
.61708 .42717 m
.61708 .42717 L
s
.61715 .42682 m
.61715 .42682 L
s
.61722 .42448 m
.61722 .42448 L
s
.6173 .4287 m
.6173 .4287 L
s
.61737 .42236 m
.61737 .42236 L
s
.61745 .41907 m
.61745 .41907 L
s
.61752 .42036 m
.61752 .42036 L
s
.6176 .42012 m
.6176 .42012 L
s
.61767 .42506 m
.61767 .42506 L
s
.61775 .42682 m
.61775 .42682 L
s
.61782 .42894 m
.61782 .42894 L
s
.6179 .43504 m
.6179 .43504 L
s
.61796 .43857 m
.61796 .43857 L
s
.61804 .43481 m
.61804 .43481 L
s
.61811 .43715 m
.61811 .43715 L
s
.61819 .4334 m
.61819 .4334 L
s
.61826 .43246 m
.61826 .43246 L
s
.61834 .43798 m
.61834 .43798 L
s
.61841 .43986 m
.61841 .43986 L
s
.61849 .43493 m
.61849 .43493 L
s
.61856 .4388 m
.61856 .4388 L
s
.61864 .43727 m
.61864 .43727 L
s
.61871 .4388 m
.61871 .4388 L
s
.61878 .44091 m
.61878 .44091 L
s
.61885 .4442 m
.61885 .4442 L
s
.61893 .45124 m
.61893 .45124 L
s
.61901 .45089 m
.61901 .45089 L
s
.61908 .45066 m
.61908 .45066 L
s
.61916 .45149 m
.61916 .45149 L
s
.61923 .459 m
.61923 .459 L
s
.61931 .46323 m
.61931 .46323 L
s
.61938 .46699 m
.61938 .46699 L
s
.61946 .4664 m
.61946 .4664 L
s
.61953 .46617 m
.61953 .46617 L
s
.6196 .46815 m
.6196 .46815 L
s
.61967 .46699 m
.61967 .46699 L
s
.61975 .46535 m
.61975 .46535 L
s
.61982 .4738 m
.61982 .4738 L
s
.6199 .47861 m
.6199 .47861 L
s
.61997 .47544 m
.61997 .47544 L
s
.62005 .47368 m
.62005 .47368 L
s
.62012 .47145 m
.62012 .47145 L
s
.6202 .47169 m
.6202 .47169 L
s
.62027 .47145 m
.62027 .47145 L
s
.62034 .4671 m
.62034 .4671 L
s
.62041 .46852 m
.62041 .46852 L
s
.62049 .47063 m
.62049 .47063 L
s
.62057 .46863 m
.62057 .46863 L
s
.62064 .4671 m
.62064 .4671 L
s
.62072 .4671 m
.62072 .4671 L
s
.62079 .47169 m
.62079 .47169 L
s
.62087 .47603 m
.62087 .47603 L
s
.62094 .47156 m
.62094 .47156 L
s
.62102 .47426 m
.62102 .47426 L
s
.62109 .47286 m
.62109 .47286 L
s
.62116 .4698 m
.62116 .4698 L
s
.62123 .46675 m
.62123 .46675 L
s
.62131 .4637 m
.62131 .4637 L
s
.62138 .46229 m
.62138 .46229 L
s
.62146 .4678 m
.62146 .4678 L
s
.62153 .47016 m
.62153 .47016 L
s
.62161 .46088 m
.62161 .46088 L
s
.62168 .46217 m
.62168 .46217 L
s
.62176 .45572 m
.62176 .45572 L
s
.62183 .45935 m
.62183 .45935 L
s
.62191 .46088 m
.62191 .46088 L
s
.62198 .4637 m
.62198 .4637 L
s
.62205 .45618 m
.62205 .45618 L
s
.62213 .45478 m
.62213 .45478 L
s
.6222 .45184 m
.6222 .45184 L
s
.62228 .4442 m
.62228 .4442 L
s
.62235 .45137 m
.62235 .45137 L
s
.62243 .45712 m
.62243 .45712 L
s
.6225 .45782 m
.6225 .45782 L
s
.62258 .45418 m
.62258 .45418 L
s
.62265 .45289 m
.62265 .45289 L
s
.62273 .45054 m
.62273 .45054 L
s
.62279 .459 m
.62279 .459 L
s
.62287 .45759 m
.62287 .45759 L
s
.62294 .46194 m
.62294 .46194 L
s
.62302 .46252 m
.62302 .46252 L
s
.62309 .45982 m
.62309 .45982 L
s
.62317 .46617 m
.62317 .46617 L
s
.62324 .46416 m
.62324 .46416 L
s
.62331 .46875 m
.62331 .46875 L
s
.62339 .47403 m
.62339 .47403 L
s
.62347 .48119 m
.62347 .48119 L
s
.62354 .48672 m
.62354 .48672 L
s
.62361 .48824 m
.62361 .48824 L
s
.62369 .48977 m
.62369 .48977 L
s
.62376 .48977 m
.62376 .48977 L
s
.62384 .49106 m
.62384 .49106 L
s
.62391 .50093 m
.62391 .50093 L
s
.62399 .50703 m
.62399 .50703 L
s
.62406 .50386 m
.62406 .50386 L
s
.62413 .49799 m
.62413 .49799 L
s
.62421 .49611 m
.62421 .49611 L
s
.62429 .49987 m
.62429 .49987 L
s
.62436 .49705 m
.62436 .49705 L
s
.62443 .49728 m
.62443 .49728 L
s
.6245 .49917 m
.6245 .49917 L
s
.62458 .49576 m
.62458 .49576 L
s
.62465 .49917 m
.62465 .49917 L
s
.62473 .50104 m
.62473 .50104 L
s
.6248 .50069 m
.6248 .50069 L
s
.62488 .49611 m
.62488 .49611 L
s
.62495 .48989 m
.62495 .48989 L
s
.62502 .49376 m
.62502 .49376 L
s
.6251 .49635 m
.6251 .49635 L
s
.62518 .49752 m
.62518 .49752 L
s
.62525 .49553 m
.62525 .49553 L
s
.62532 .49787 m
.62532 .49787 L
s
.6254 .4947 m
.6254 .4947 L
s
.62547 .49283 m
.62547 .49283 L
s
.62555 .49752 m
.62555 .49752 L
s
.62562 .49412 m
.62562 .49412 L
s
.6257 .49071 m
.6257 .49071 L
s
.62576 .49024 m
.62576 .49024 L
s
.62584 .49658 m
.62584 .49658 L
s
.62592 .48672 m
.62592 .48672 L
s
.62599 .49106 m
.62599 .49106 L
s
.62606 .49682 m
.62606 .49682 L
s
.62614 .50116 m
.62614 .50116 L
s
.62621 .49728 m
.62621 .49728 L
s
.62629 .49893 m
.62629 .49893 L
s
.62636 .49752 m
.62636 .49752 L
s
.62644 .50492 m
.62644 .50492 L
s
.62651 .50715 m
.62651 .50715 L
s
.62658 .50903 m
.62658 .50903 L
s
.62665 .50293 m
.62665 .50293 L
s
.62673 .5041 m
.62673 .5041 L
s
.62681 .49447 m
.62681 .49447 L
s
.62688 .49423 m
.62688 .49423 L
s
.62696 .49905 m
.62696 .49905 L
s
.62703 .49822 m
.62703 .49822 L
s
.62711 .5014 m
.62711 .5014 L
s
.62718 .49952 m
.62718 .49952 L
s
.62726 .49646 m
.62726 .49646 L
s
.62733 .49164 m
.62733 .49164 L
s
.6274 .4954 m
.6274 .4954 L
s
.62747 .49728 m
.62747 .49728 L
s
.62755 .49329 m
.62755 .49329 L
s
.62762 .48848 m
.62762 .48848 L
s
.6277 .48437 m
.6277 .48437 L
s
.62777 .48155 m
.62777 .48155 L
s
.62785 .4859 m
.62785 .4859 L
s
.62792 .48566 m
.62792 .48566 L
s
.628 .48801 m
.628 .48801 L
s
.62807 .49071 m
.62807 .49071 L
s
.62815 .49482 m
.62815 .49482 L
s
.62821 .49329 m
.62821 .49329 L
s
.62829 .49376 m
.62829 .49376 L
s
.62837 .49365 m
.62837 .49365 L
s
.62844 .49047 m
.62844 .49047 L
s
.62852 .4947 m
.62852 .4947 L
s
.62859 .49752 m
.62859 .49752 L
s
.62867 .49752 m
.62867 .49752 L
s
.62874 .49976 m
.62874 .49976 L
s
.62882 .49857 m
.62882 .49857 L
s
.62889 .50222 m
.62889 .50222 L
s
.62896 .5021 m
.62896 .5021 L
s
.62903 .50151 m
.62903 .50151 L
s
.62911 .50246 m
.62911 .50246 L
s
.62918 .49952 m
.62918 .49952 L
s
.62926 .49588 m
.62926 .49588 L
s
.62933 .496 m
.62933 .496 L
s
.62941 .49905 m
.62941 .49905 L
s
.62948 .49553 m
.62948 .49553 L
s
.62956 .49365 m
.62956 .49365 L
s
.62963 .48613 m
.62963 .48613 L
s
.62971 .4832 m
.62971 .4832 L
s
.62978 .48155 m
.62978 .48155 L
s
.62985 .4832 m
.62985 .4832 L
s
.62993 .48143 m
.62993 .48143 L
s
.63 .4799 m
.63 .4799 L
s
.63008 .48777 m
.63008 .48777 L
s
.63015 .47814 m
.63015 .47814 L
s
.63023 .47568 m
.63023 .47568 L
s
.6303 .47415 m
.6303 .47415 L
s
.63038 .48531 m
.63038 .48531 L
s
.63045 .48119 m
.63045 .48119 L
s
.63053 .48355 m
.63053 .48355 L
s
.63059 .48014 m
.63059 .48014 L
s
.63067 .48495 m
.63067 .48495 L
s
.63074 .48084 m
.63074 .48084 L
s
.63082 .48155 m
.63082 .48155 L
s
.63089 .48331 m
.63089 .48331 L
s
.63097 .48884 m
.63097 .48884 L
s
.63104 .48343 m
.63104 .48343 L
s
.63112 .48543 m
.63112 .48543 L
s
.63119 .48143 m
.63119 .48143 L
s
.63127 .47509 m
.63127 .47509 L
s
.63134 .47344 m
.63134 .47344 L
s
.63141 .47568 m
.63141 .47568 L
s
.63149 .4738 m
.63149 .4738 L
s
.63156 .4772 m
.63156 .4772 L
s
.63164 .47709 m
.63164 .47709 L
s
.63171 .4846 m
.63171 .4846 L
s
.63179 .48072 m
.63179 .48072 L
s
.63186 .4859 m
.63186 .4859 L
s
.63193 .47826 m
.63193 .47826 L
s
.63201 .47333 m
.63201 .47333 L
s
.63209 .4772 m
.63209 .4772 L
s
.63216 .47274 m
.63216 .47274 L
s
.63223 .46934 m
.63223 .46934 L
s
.6323 .47228 m
.6323 .47228 L
s
.63238 .47239 m
.63238 .47239 L
s
.63245 .47344 m
.63245 .47344 L
s
.63253 .47627 m
.63253 .47627 L
s
.6326 .47263 m
.6326 .47263 L
s
.63268 .46311 m
.63268 .46311 L
s
.63275 .461 m
.63275 .461 L
s
.63283 .45877 m
.63283 .45877 L
s
.6329 .4617 m
.6329 .4617 L
s
.63298 .45853 m
.63298 .45853 L
s
.63305 .46064 m
.63305 .46064 L
s
.63312 .45971 m
.63312 .45971 L
s
.6332 .46299 m
.6332 .46299 L
s
.63327 .45572 m
.63327 .45572 L
s
.63335 .45747 m
.63335 .45747 L
s
.63342 .45513 m
.63342 .45513 L
s
.6335 .45677 m
.6335 .45677 L
s
.63356 .46252 m
.63356 .46252 L
s
.63364 .46088 m
.63364 .46088 L
s
.63372 .46029 m
.63372 .46029 L
s
.63379 .46346 m
.63379 .46346 L
s
.63386 .46488 m
.63386 .46488 L
s
.63394 .46535 m
.63394 .46535 L
s
.63401 .46652 m
.63401 .46652 L
s
.63409 .46288 m
.63409 .46288 L
s
.63416 .46675 m
.63416 .46675 L
s
.63424 .46241 m
.63424 .46241 L
s
.63431 .46558 m
.63431 .46558 L
s
.63438 .4637 m
.63438 .4637 L
s
.63446 .46488 m
.63446 .46488 L
s
.63454 .46346 m
.63454 .46346 L
s
.63461 .46053 m
.63461 .46053 L
s
.63468 .46252 m
.63468 .46252 L
s
.63476 .4684 m
.63476 .4684 L
s
.63483 .46605 m
.63483 .46605 L
s
.63491 .46135 m
.63491 .46135 L
s
.63498 .45572 m
.63498 .45572 L
s
.63506 .46241 m
.63506 .46241 L
s
.63513 .45888 m
.63513 .45888 L
s
.6352 .46252 m
.6352 .46252 L
s
.63527 .46393 m
.63527 .46393 L
s
.63535 .46804 m
.63535 .46804 L
s
.63542 .46769 m
.63542 .46769 L
s
.6355 .4684 m
.6355 .4684 L
s
.63557 .46957 m
.63557 .46957 L
s
.63565 .4745 m
.63565 .4745 L
s
.63572 .47027 m
.63572 .47027 L
s
.6358 .46863 m
.6358 .46863 L
s
.63587 .47086 m
.63587 .47086 L
s
.63595 .46581 m
.63595 .46581 L
s
.63601 .45653 m
.63601 .45653 L
s
.63609 .459 m
.63609 .459 L
s
.63617 .45688 m
.63617 .45688 L
s
.63624 .45641 m
.63624 .45641 L
s
.63632 .45548 m
.63632 .45548 L
s
.63639 .45747 m
.63639 .45747 L
s
.63647 .45618 m
.63647 .45618 L
s
.63654 .45489 m
.63654 .45489 L
s
.63662 .44961 m
.63662 .44961 L
s
.63669 .44855 m
.63669 .44855 L
s
.63676 .45184 m
.63676 .45184 L
s
.63683 .44972 m
.63683 .44972 L
s
.63691 .45043 m
.63691 .45043 L
s
.63698 .45043 m
.63698 .45043 L
s
.63706 .44443 m
.63706 .44443 L
s
.63713 .44585 m
.63713 .44585 L
s
.63721 .44396 m
.63721 .44396 L
s
.63728 .4395 m
.63728 .4395 L
s
.63736 .4395 m
.63736 .4395 L
s
.63743 .4375 m
.63743 .4375 L
s
.63751 .44408 m
.63751 .44408 L
s
.63758 .44749 m
.63758 .44749 L
s
.63765 .45466 m
.63765 .45466 L
s
.63773 .45525 m
.63773 .45525 L
s
.6378 .45266 m
.6378 .45266 L
s
.63788 .44937 m
.63788 .44937 L
s
.63795 .45172 m
.63795 .45172 L
s
.63803 .44808 m
.63803 .44808 L
s
.6381 .44585 m
.6381 .44585 L
s
.63818 .44021 m
.63818 .44021 L
s
.63825 .44115 m
.63825 .44115 L
s
.63833 .44103 m
.63833 .44103 L
s
.63839 .43775 m
.63839 .43775 L
s
.63847 .44396 m
.63847 .44396 L
s
.63854 .44772 m
.63854 .44772 L
s
.63862 .44491 m
.63862 .44491 L
s
.63869 .44326 m
.63869 .44326 L
s
.63877 .44068 m
.63877 .44068 L
s
.63884 .44021 m
.63884 .44021 L
s
.63892 .43563 m
.63892 .43563 L
s
.63899 .43375 m
.63899 .43375 L
s
.63907 .43586 m
.63907 .43586 L
s
.63914 .43117 m
.63914 .43117 L
s
.63921 .43304 m
.63921 .43304 L
s
.63929 .43328 m
.63929 .43328 L
s
.63936 .43386 m
.63936 .43386 L
s
.63944 .43269 m
.63944 .43269 L
s
.63951 .43551 m
.63951 .43551 L
s
.63959 .43246 m
.63959 .43246 L
s
.63966 .43516 m
.63966 .43516 L
s
.63973 .43164 m
.63973 .43164 L
s
.63981 .4287 m
.63981 .4287 L
s
.63989 .42471 m
.63989 .42471 L
s
.63996 .42976 m
.63996 .42976 L
s
.64003 .43022 m
.64003 .43022 L
s
.6401 .42588 m
.6401 .42588 L
s
.64018 .42635 m
.64018 .42635 L
s
.64025 .42224 m
.64025 .42224 L
s
.64033 .41942 m
.64033 .41942 L
s
.6404 .42166 m
.6404 .42166 L
s
.64048 .4152 m
.64048 .4152 L
s
.64055 .41613 m
.64055 .41613 L
s
.64063 .42095 m
.64063 .42095 L
s
.6407 .42236 m
.6407 .42236 L
s
.64078 .41884 m
.64078 .41884 L
s
.64085 .42623 m
.64085 .42623 L
s
.64092 .424 m
.64092 .424 L
s
.641 .42154 m
.641 .42154 L
s
.64107 .42494 m
.64107 .42494 L
s
.64115 .42823 m
.64115 .42823 L
s
.64122 .43094 m
.64122 .43094 L
s
.6413 .428 m
.6413 .428 L
s
.64137 .42858 m
.64137 .42858 L
s
.64145 .42858 m
.64145 .42858 L
s
.64152 .43094 m
.64152 .43094 L
s
.64159 .43058 m
.64159 .43058 L
s
.64166 .43528 m
.64166 .43528 L
s
.64174 .4361 m
.64174 .4361 L
s
.64181 .43692 m
.64181 .43692 L
s
.64189 .44162 m
.64189 .44162 L
s
.64196 .44139 m
.64196 .44139 L
s
.64204 .44044 m
.64204 .44044 L
s
.64211 .44209 m
.64211 .44209 L
s
.64218 .4381 m
.64218 .4381 L
s
.64226 .43645 m
.64226 .43645 L
s
.64234 .43845 m
.64234 .43845 L
s
.64241 .43775 m
.64241 .43775 L
s
.64248 .43586 m
.64248 .43586 L
s
.64256 .43715 m
.64256 .43715 L
s
.64263 .43575 m
.64263 .43575 L
s
.64271 .4341 m
.64271 .4341 L
s
.64278 .43446 m
.64278 .43446 L
s
.64286 .4381 m
.64286 .4381 L
s
.64293 .4354 m
.64293 .4354 L
s
.643 .44068 m
.643 .44068 L
s
.64308 .43351 m
.64308 .43351 L
s
.64316 .43094 m
.64316 .43094 L
s
.64322 .43328 m
.64322 .43328 L
s
.6433 .43187 m
.6433 .43187 L
s
.64337 .43668 m
.64337 .43668 L
s
.64345 .43269 m
.64345 .43269 L
s
.64352 .43293 m
.64352 .43293 L
s
.6436 .42729 m
.6436 .42729 L
s
.64367 .42647 m
.64367 .42647 L
s
.64375 .42835 m
.64375 .42835 L
s
.64381 .42658 m
.64381 .42658 L
s
.64389 .42788 m
.64389 .42788 L
s
.64397 .43058 m
.64397 .43058 L
s
.64404 .4253 m
.64404 .4253 L
s
.64412 .43187 m
.64412 .43187 L
s
.64419 .428 m
.64419 .428 L
s
.64427 .42448 m
.64427 .42448 L
s
.64434 .42694 m
.64434 .42694 L
s
.64442 .43105 m
.64442 .43105 L
s
.64449 .42929 m
.64449 .42929 L
s
.64456 .42976 m
.64456 .42976 L
s
.64463 .43094 m
.64463 .43094 L
s
.64471 .42494 m
.64471 .42494 L
s
.64479 .42776 m
.64479 .42776 L
s
.64486 .43058 m
.64486 .43058 L
s
.64493 .43481 m
.64493 .43481 L
s
.64501 .43269 m
.64501 .43269 L
s
.64508 .4287 m
.64508 .4287 L
s
.64516 .43011 m
.64516 .43011 L
s
.64523 .43304 m
.64523 .43304 L
s
.64531 .43211 m
.64531 .43211 L
s
.64538 .43176 m
.64538 .43176 L
s
.64545 .43586 m
.64545 .43586 L
s
.64553 .42459 m
.64553 .42459 L
s
.6456 .42541 m
.6456 .42541 L
s
.64568 .42847 m
.64568 .42847 L
s
.64575 .43434 m
.64575 .43434 L
s
.64583 .43199 m
.64583 .43199 L
s
.6459 .43199 m
.6459 .43199 L
s
.64598 .42823 m
.64598 .42823 L
s
.64605 .42964 m
.64605 .42964 L
s
.64613 .43398 m
.64613 .43398 L
s
.64619 .4314 m
.64619 .4314 L
s
.64627 .43762 m
.64627 .43762 L
s
.64634 .43034 m
.64634 .43034 L
s
.64642 .43434 m
.64642 .43434 L
s
.64649 .43775 m
.64649 .43775 L
s
.64657 .43563 m
.64657 .43563 L
s
.64664 .4354 m
.64664 .4354 L
s
.64672 .42705 m
.64672 .42705 L
s
.64679 .42119 m
.64679 .42119 L
s
.64687 .42212 m
.64687 .42212 L
s
.64694 .42271 m
.64694 .42271 L
s
.64701 .42341 m
.64701 .42341 L
s
.64709 .42353 m
.64709 .42353 L
s
.64716 .42294 m
.64716 .42294 L
s
.64724 .41743 m
.64724 .41743 L
s
.64731 .41261 m
.64731 .41261 L
s
.64739 .41226 m
.64739 .41226 L
s
.64746 .41155 m
.64746 .41155 L
s
.64754 .41449 m
.64754 .41449 L
s
.64761 .41907 m
.64761 .41907 L
s
.64769 .41273 m
.64769 .41273 L
s
.64776 .4179 m
.64776 .4179 L
s
.64783 .41825 m
.64783 .41825 L
s
.6479 .42001 m
.6479 .42001 L
s
.64798 .42072 m
.64798 .42072 L
s
.64805 .42036 m
.64805 .42036 L
s
.64813 .42212 m
.64813 .42212 L
s
.6482 .42072 m
.6482 .42072 L
s
.64828 .42119 m
.64828 .42119 L
s
.64835 .42236 m
.64835 .42236 L
s
.64843 .42177 m
.64843 .42177 L
s
.6485 .42236 m
.6485 .42236 L
s
.64858 .41719 m
.64858 .41719 L
s
.64865 .41731 m
.64865 .41731 L
s
.64872 .42765 m
.64872 .42765 L
s
.6488 .42812 m
.6488 .42812 L
s
.64887 .4314 m
.64887 .4314 L
s
.64895 .4334 m
.64895 .4334 L
s
.64902 .4314 m
.64902 .4314 L
s
.6491 .43715 m
.6491 .43715 L
s
.64917 .43386 m
.64917 .43386 L
s
.64925 .43117 m
.64925 .43117 L
s
.64932 .42847 m
.64932 .42847 L
s
.64939 .42905 m
.64939 .42905 L
s
.64946 .42765 m
.64946 .42765 L
s
.64954 .43575 m
.64954 .43575 L
s
.64961 .43434 m
.64961 .43434 L
s
.64969 .43105 m
.64969 .43105 L
s
.64976 .43469 m
.64976 .43469 L
s
.64984 .43986 m
.64984 .43986 L
s
.64991 .43645 m
.64991 .43645 L
s
.64998 .4395 m
.64998 .4395 L
s
.65006 .4381 m
.65006 .4381 L
s
.65014 .43633 m
.65014 .43633 L
s
.65021 .43904 m
.65021 .43904 L
s
.65028 .4375 m
.65028 .4375 L
s
.65036 .43234 m
.65036 .43234 L
s
.65043 .43293 m
.65043 .43293 L
s
.65051 .43222 m
.65051 .43222 L
s
.65058 .43081 m
.65058 .43081 L
s
.65066 .43715 m
.65066 .43715 L
s
.65073 .44232 m
.65073 .44232 L
s
.6508 .44232 m
.6508 .44232 L
s
.65088 .44373 m
.65088 .44373 L
s
.65096 .43598 m
.65096 .43598 L
s
.65102 .43563 m
.65102 .43563 L
s
.6511 .4368 m
.6511 .4368 L
s
.65117 .43516 m
.65117 .43516 L
s
.65125 .43833 m
.65125 .43833 L
s
.65132 .44068 m
.65132 .44068 L
s
.6514 .44303 m
.6514 .44303 L
s
.65147 .44174 m
.65147 .44174 L
s
.65155 .43645 m
.65155 .43645 L
s
.65161 .43927 m
.65161 .43927 L
s
.65169 .44091 m
.65169 .44091 L
s
.65177 .44491 m
.65177 .44491 L
s
.65184 .44232 m
.65184 .44232 L
s
.65192 .43398 m
.65192 .43398 L
s
.65199 .43739 m
.65199 .43739 L
s
.65207 .43316 m
.65207 .43316 L
s
.65214 .43034 m
.65214 .43034 L
s
.65222 .43117 m
.65222 .43117 L
s
.65229 .42847 m
.65229 .42847 L
s
.65236 .42694 m
.65236 .42694 L
s
.65243 .42612 m
.65243 .42612 L
s
.65251 .42952 m
.65251 .42952 L
s
.65259 .43187 m
.65259 .43187 L
s
.65266 .43363 m
.65266 .43363 L
s
.65273 .43293 m
.65273 .43293 L
s
.65281 .43058 m
.65281 .43058 L
s
.65288 .42858 m
.65288 .42858 L
s
.65296 .43069 m
.65296 .43069 L
s
.65303 .43692 m
.65303 .43692 L
s
.65311 .43762 m
.65311 .43762 L
s
.65318 .4381 m
.65318 .4381 L
s
.65325 .44032 m
.65325 .44032 L
s
.65333 .44725 m
.65333 .44725 L
s
.6534 .44538 m
.6534 .44538 L
s
.65348 .44714 m
.65348 .44714 L
s
.65355 .44479 m
.65355 .44479 L
s
.65363 .44396 m
.65363 .44396 L
s
.6537 .44596 m
.6537 .44596 L
s
.65378 .43857 m
.65378 .43857 L
s
.65385 .43739 m
.65385 .43739 L
s
.65393 .43704 m
.65393 .43704 L
s
.65399 .43293 m
.65399 .43293 L
s
.65407 .44021 m
.65407 .44021 L
s
.65414 .44186 m
.65414 .44186 L
s
.65422 .44655 m
.65422 .44655 L
s
.65429 .45442 m
.65429 .45442 L
s
.65437 .45842 m
.65437 .45842 L
s
.65444 .45959 m
.65444 .45959 L
s
.65452 .45525 m
.65452 .45525 L
s
.65459 .45313 m
.65459 .45313 L
s
.65467 .45289 m
.65467 .45289 L
s
.65474 .45525 m
.65474 .45525 L
s
.65481 .44855 m
.65481 .44855 L
s
.65489 .44514 m
.65489 .44514 L
s
.65496 .44702 m
.65496 .44702 L
s
.65504 .45019 m
.65504 .45019 L
s
.65511 .45782 m
.65511 .45782 L
s
.65519 .45101 m
.65519 .45101 L
s
.65526 .44832 m
.65526 .44832 L
s
.65534 .44984 m
.65534 .44984 L
s
.65541 .45113 m
.65541 .45113 L
s
.65549 .4536 m
.65549 .4536 L
s
.65556 .45665 m
.65556 .45665 L
s
.65563 .46699 m
.65563 .46699 L
s
.6557 .4671 m
.6557 .4671 L
s
.65578 .46875 m
.65578 .46875 L
s
.65585 .47027 m
.65585 .47027 L
s
.65593 .47121 m
.65593 .47121 L
s
.656 .47638 m
.656 .47638 L
s
.65608 .47967 m
.65608 .47967 L
s
.65615 .47145 m
.65615 .47145 L
s
.65623 .47192 m
.65623 .47192 L
s
.6563 .48049 m
.6563 .48049 L
s
.65638 .48096 m
.65638 .48096 L
s
.65645 .47791 m
.65645 .47791 L
s
.65652 .48178 m
.65652 .48178 L
s
.6566 .4859 m
.6566 .4859 L
s
.65667 .47967 m
.65667 .47967 L
s
.65675 .47791 m
.65675 .47791 L
s
.65682 .47756 m
.65682 .47756 L
s
.6569 .4799 m
.6569 .4799 L
s
.65697 .48273 m
.65697 .48273 L
s
.65705 .48601 m
.65705 .48601 L
s
.65712 .48108 m
.65712 .48108 L
s
.65719 .48061 m
.65719 .48061 L
s
.65726 .47709 m
.65726 .47709 L
s
.65734 .47344 m
.65734 .47344 L
s
.65741 .46992 m
.65741 .46992 L
s
.65749 .47098 m
.65749 .47098 L
s
.65756 .46957 m
.65756 .46957 L
s
.65764 .46558 m
.65764 .46558 L
s
.65771 .4684 m
.65771 .4684 L
s
.65779 .46828 m
.65779 .46828 L
s
.65786 .46922 m
.65786 .46922 L
s
.65794 .4644 m
.65794 .4644 L
s
.65801 .46757 m
.65801 .46757 L
s
.65808 .47462 m
.65808 .47462 L
s
.65816 .47403 m
.65816 .47403 L
s
.65823 .47615 m
.65823 .47615 L
s
.65831 .4758 m
.65831 .4758 L
s
.65838 .47509 m
.65838 .47509 L
s
.65846 .47744 m
.65846 .47744 L
s
.65853 .48495 m
.65853 .48495 L
s
.6586 .48824 m
.6586 .48824 L
s
.65868 .49129 m
.65868 .49129 L
s
.65876 .48683 m
.65876 .48683 L
s
.65882 .48719 m
.65882 .48719 L
s
.6589 .49353 m
.6589 .49353 L
s
.65897 .49423 m
.65897 .49423 L
s
.65905 .49188 m
.65905 .49188 L
s
.65912 .49259 m
.65912 .49259 L
s
.6592 .49505 m
.6592 .49505 L
s
.65927 .49024 m
.65927 .49024 L
s
.65935 .49212 m
.65935 .49212 L
s
.65942 .48648 m
.65942 .48648 L
s
.6595 .4893 m
.6595 .4893 L
s
.65958 .48859 m
.65958 .48859 L
s
.65964 .48754 m
.65964 .48754 L
s
.65972 .49658 m
.65972 .49658 L
s
.65979 .49611 m
.65979 .49611 L
s
.65987 .49787 m
.65987 .49787 L
s
.65994 .49717 m
.65994 .49717 L
s
.66002 .49905 m
.66002 .49905 L
s
.66009 .49987 m
.66009 .49987 L
s
.66016 .49869 m
.66016 .49869 L
s
.66023 .49635 m
.66023 .49635 L
s
.66031 .48765 m
.66031 .48765 L
s
.66039 .48072 m
.66039 .48072 L
s
.66046 .48049 m
.66046 .48049 L
s
.66053 .48261 m
.66053 .48261 L
s
.66061 .47944 m
.66061 .47944 L
s
.66068 .48296 m
.66068 .48296 L
s
.66076 .4799 m
.66076 .4799 L
s
.66083 .47473 m
.66083 .47473 L
s
.66091 .46699 m
.66091 .46699 L
s
.66098 .46746 m
.66098 .46746 L
s
.66105 .46887 m
.66105 .46887 L
s
.66113 .47051 m
.66113 .47051 L
s
.66121 .46416 m
.66121 .46416 L
s
.66128 .46194 m
.66128 .46194 L
s
.66135 .45501 m
.66135 .45501 L
s
.66143 .45289 m
.66143 .45289 L
s
.6615 .44972 m
.6615 .44972 L
s
.66158 .45043 m
.66158 .45043 L
s
.66165 .44725 m
.66165 .44725 L
s
.66173 .4388 m
.66173 .4388 L
s
.66179 .44303 m
.66179 .44303 L
s
.66187 .44561 m
.66187 .44561 L
s
.66194 .44855 m
.66194 .44855 L
s
.66202 .45572 m
.66202 .45572 L
s
.66209 .45489 m
.66209 .45489 L
s
.66217 .46064 m
.66217 .46064 L
s
.66224 .46217 m
.66224 .46217 L
s
.66232 .45853 m
.66232 .45853 L
s
.66239 .45912 m
.66239 .45912 L
s
.66247 .4583 m
.66247 .4583 L
s
.66254 .45242 m
.66254 .45242 L
s
.66261 .44491 m
.66261 .44491 L
s
.66269 .4381 m
.66269 .4381 L
s
.66276 .43633 m
.66276 .43633 L
s
.66284 .44115 m
.66284 .44115 L
s
.66291 .43892 m
.66291 .43892 L
s
.66299 .44808 m
.66299 .44808 L
s
.66306 .44068 m
.66306 .44068 L
s
.66314 .43798 m
.66314 .43798 L
s
.66321 .44115 m
.66321 .44115 L
s
.66329 .43997 m
.66329 .43997 L
s
.66336 .43857 m
.66336 .43857 L
s
.66343 .43622 m
.66343 .43622 L
s
.6635 .44056 m
.6635 .44056 L
s
.66358 .44115 m
.66358 .44115 L
s
.66365 .43868 m
.66365 .43868 L
s
.66373 .43246 m
.66373 .43246 L
s
.6638 .43069 m
.6638 .43069 L
s
.66388 .42729 m
.66388 .42729 L
s
.66395 .42623 m
.66395 .42623 L
s
.66403 .42541 m
.66403 .42541 L
s
.6641 .42623 m
.6641 .42623 L
s
.66418 .41755 m
.66418 .41755 L
s
.66425 .41907 m
.66425 .41907 L
s
.66432 .4193 m
.66432 .4193 L
s
.6644 .41378 m
.6644 .41378 L
s
.66447 .40991 m
.66447 .40991 L
s
.66455 .40263 m
.66455 .40263 L
s
.66462 .40592 m
.66462 .40592 L
s
.6647 .39969 m
.6647 .39969 L
s
.66477 .39957 m
.66477 .39957 L
s
.66485 .39593 m
.66485 .39593 L
s
.66492 .3991 m
.66492 .3991 L
s
.66499 .40239 m
.66499 .40239 L
s
.66506 .41014 m
.66506 .41014 L
s
.66514 .41179 m
.66514 .41179 L
s
.66521 .41155 m
.66521 .41155 L
s
.66529 .40944 m
.66529 .40944 L
s
.66536 .40416 m
.66536 .40416 L
s
.66544 .39817 m
.66544 .39817 L
s
.66551 .39945 m
.66551 .39945 L
s
.66559 .39875 m
.66559 .39875 L
s
.66566 .39382 m
.66566 .39382 L
s
.66574 .39464 m
.66574 .39464 L
s
.66581 .39229 m
.66581 .39229 L
s
.66588 .39441 m
.66588 .39441 L
s
.66596 .39394 m
.66596 .39394 L
s
.66603 .39605 m
.66603 .39605 L
s
.66611 .39065 m
.66611 .39065 L
s
.66618 .39042 m
.66618 .39042 L
s
.66626 .38654 m
.66626 .38654 L
s
.66633 .38642 m
.66633 .38642 L
s
.66641 .39171 m
.66641 .39171 L
s
.66648 .38783 m
.66648 .38783 L
s
.66656 .38783 m
.66656 .38783 L
s
.66663 .38842 m
.66663 .38842 L
s
.6667 .39135 m
.6667 .39135 L
s
.66677 .391 m
.66677 .391 L
s
.66685 .3883 m
.66685 .3883 L
s
.66692 .38994 m
.66692 .38994 L
s
.667 .39182 m
.667 .39182 L
s
.66707 .39417 m
.66707 .39417 L
s
.66715 .3903 m
.66715 .3903 L
s
.66722 .38971 m
.66722 .38971 L
s
.6673 .38912 m
.6673 .38912 L
s
.66738 .38125 m
.66738 .38125 L
s
.66744 .38231 m
.66744 .38231 L
s
.66752 .38454 m
.66752 .38454 L
s
.66759 .38842 m
.66759 .38842 L
s
.66767 .38313 m
.66767 .38313 L
s
.66774 .389 m
.66774 .389 L
s
.66782 .39229 m
.66782 .39229 L
s
.66789 .3957 m
.66789 .3957 L
s
.66796 .40063 m
.66796 .40063 L
s
.66804 .40216 m
.66804 .40216 L
s
.66812 .39664 m
.66812 .39664 L
s
.66819 .39441 m
.66819 .39441 L
s
.66826 .38877 m
.66826 .38877 L
s
.66833 .38219 m
.66833 .38219 L
s
.66841 .38384 m
.66841 .38384 L
s
.66848 .3876 m
.66848 .3876 L
s
.66856 .38982 m
.66856 .38982 L
s
.66863 .39288 m
.66863 .39288 L
s
.66871 .39135 m
.66871 .39135 L
s
.66878 .38924 m
.66878 .38924 L
s
.66885 .38994 m
.66885 .38994 L
s
.66893 .38665 m
.66893 .38665 L
s
.66901 .38489 m
.66901 .38489 L
s
.66908 .38172 m
.66908 .38172 L
s
.66915 .37914 m
.66915 .37914 L
s
.66923 .38008 m
.66923 .38008 L
s
.6693 .38079 m
.6693 .38079 L
s
.66938 .38971 m
.66938 .38971 L
s
.66945 .38795 m
.66945 .38795 L
s
.66953 .38301 m
.66953 .38301 L
s
.6696 .37597 m
.6696 .37597 L
s
.66967 .37397 m
.66967 .37397 L
s
.66975 .37374 m
.66975 .37374 L
s
.66982 .37279 m
.66982 .37279 L
s
.66989 .37162 m
.66989 .37162 L
s
.66997 .36951 m
.66997 .36951 L
s
.67004 .37351 m
.67004 .37351 L
s
.67012 .3782 m
.67012 .3782 L
s
.67019 .3775 m
.67019 .3775 L
s
.67027 .3802 m
.67027 .3802 L
s
.67034 .38149 m
.67034 .38149 L
s
.67041 .37503 m
.67041 .37503 L
s
.67049 .37503 m
.67049 .37503 L
s
.67056 .37773 m
.67056 .37773 L
s
.67064 .37374 m
.67064 .37374 L
s
.67071 .37726 m
.67071 .37726 L
s
.67079 .37585 m
.67079 .37585 L
s
.67086 .37515 m
.67086 .37515 L
s
.67094 .37104 m
.67094 .37104 L
s
.67101 .37339 m
.67101 .37339 L
s
.67109 .37256 m
.67109 .37256 L
s
.67116 .3701 m
.67116 .3701 L
s
.67123 .36223 m
.67123 .36223 L
s
.6713 .35694 m
.6713 .35694 L
s
.67138 .358 m
.67138 .358 L
s
.67146 .35483 m
.67146 .35483 L
s
.67153 .35048 m
.67153 .35048 L
s
.6716 .35295 m
.6716 .35295 L
s
.67168 .34849 m
.67168 .34849 L
s
.67175 .34978 m
.67175 .34978 L
s
.67183 .35259 m
.67183 .35259 L
s
.6719 .35588 m
.6719 .35588 L
s
.67198 .35929 m
.67198 .35929 L
s
.67205 .35553 m
.67205 .35553 L
s
.67212 .35683 m
.67212 .35683 L
s
.6722 .36211 m
.6722 .36211 L
s
.67227 .35917 m
.67227 .35917 L
s
.67235 .36234 m
.67235 .36234 L
s
.67242 .36152 m
.67242 .36152 L
s
.6725 .35988 m
.6725 .35988 L
s
.67257 .35377 m
.67257 .35377 L
s
.67265 .35624 m
.67265 .35624 L
s
.67272 .36258 m
.67272 .36258 L
s
.67279 .36059 m
.67279 .36059 L
s
.67286 .36094 m
.67286 .36094 L
s
.67294 .3486 m
.67294 .3486 L
s
.67301 .34696 m
.67301 .34696 L
s
.67309 .34955 m
.67309 .34955 L
s
.67316 .34931 m
.67316 .34931 L
s
.67324 .34543 m
.67324 .34543 L
s
.67331 .35224 m
.67331 .35224 L
s
.67339 .34849 m
.67339 .34849 L
s
.67346 .34743 m
.67346 .34743 L
s
.67354 .35025 m
.67354 .35025 L
s
.67361 .34849 m
.67361 .34849 L
s
.67368 .34626 m
.67368 .34626 L
s
.67376 .35624 m
.67376 .35624 L
s
.67383 .35659 m
.67383 .35659 L
s
.67391 .35354 m
.67391 .35354 L
s
.67398 .35307 m
.67398 .35307 L
s
.67406 .35307 m
.67406 .35307 L
s
.67413 .35037 m
.67413 .35037 L
s
.67421 .34285 m
.67421 .34285 L
s
.67428 .34743 m
.67428 .34743 L
s
.67436 .3499 m
.67436 .3499 L
s
.67443 .35166 m
.67443 .35166 L
s
.6745 .35166 m
.6745 .35166 L
s
.67457 .35319 m
.67457 .35319 L
s
.67465 .35025 m
.67465 .35025 L
s
.67472 .34837 m
.67472 .34837 L
s
.6748 .34673 m
.6748 .34673 L
s
.67487 .35706 m
.67487 .35706 L
s
.67495 .35718 m
.67495 .35718 L
s
.67502 .35847 m
.67502 .35847 L
s
.6751 .36094 m
.6751 .36094 L
s
.67518 .35882 m
.67518 .35882 L
s
.67524 .36129 m
.67524 .36129 L
s
.67532 .35777 m
.67532 .35777 L
s
.67539 .35471 m
.67539 .35471 L
s
.67547 .35259 m
.67547 .35259 L
s
.67554 .35565 m
.67554 .35565 L
s
.67562 .35741 m
.67562 .35741 L
s
.67569 .35565 m
.67569 .35565 L
s
.67576 .35894 m
.67576 .35894 L
s
.67584 .35271 m
.67584 .35271 L
s
.67592 .35284 m
.67592 .35284 L
s
.67599 .34955 m
.67599 .34955 L
s
.67606 .35095 m
.67606 .35095 L
s
.67613 .34813 m
.67613 .34813 L
s
.67621 .35588 m
.67621 .35588 L
s
.67628 .35518 m
.67628 .35518 L
s
.67636 .35307 m
.67636 .35307 L
s
.67643 .35119 m
.67643 .35119 L
s
.67651 .35354 m
.67651 .35354 L
s
.67658 .35553 m
.67658 .35553 L
s
.67666 .35037 m
.67666 .35037 L
s
.67674 .35002 m
.67674 .35002 L
s
.67681 .35084 m
.67681 .35084 L
s
.67688 .35013 m
.67688 .35013 L
s
.67695 .35119 m
.67695 .35119 L
s
.67703 .35048 m
.67703 .35048 L
s
.6771 .34649 m
.6771 .34649 L
s
.67718 .34661 m
.67718 .34661 L
s
.67725 .34778 m
.67725 .34778 L
s
.67733 .35037 m
.67733 .35037 L
s
.6774 .3479 m
.6774 .3479 L
s
.67747 .34931 m
.67747 .34931 L
s
.67755 .34778 m
.67755 .34778 L
s
.67762 .35107 m
.67762 .35107 L
s
.67769 .35048 m
.67769 .35048 L
s
.67777 .35119 m
.67777 .35119 L
s
.67784 .35072 m
.67784 .35072 L
s
.67792 .34802 m
.67792 .34802 L
s
.67799 .34438 m
.67799 .34438 L
s
.67807 .34438 m
.67807 .34438 L
s
.67814 .33651 m
.67814 .33651 L
s
.67821 .33968 m
.67821 .33968 L
s
.67829 .3398 m
.67829 .3398 L
s
.67837 .34262 m
.67837 .34262 L
s
.67844 .33897 m
.67844 .33897 L
s
.67851 .34109 m
.67851 .34109 L
s
.67859 .33933 m
.67859 .33933 L
s
.67866 .34249 m
.67866 .34249 L
s
.67874 .34097 m
.67874 .34097 L
s
.67881 .3432 m
.67881 .3432 L
s
.67889 .3472 m
.67889 .3472 L
s
.67896 .34755 m
.67896 .34755 L
s
.67903 .35002 m
.67903 .35002 L
s
.6791 .34708 m
.6791 .34708 L
s
.67918 .35013 m
.67918 .35013 L
s
.67926 .34919 m
.67926 .34919 L
s
.67933 .35236 m
.67933 .35236 L
s
.6794 .3486 m
.6794 .3486 L
s
.67948 .34274 m
.67948 .34274 L
s
.67955 .33498 m
.67955 .33498 L
s
.67963 .3284 m
.67963 .3284 L
s
.6797 .33275 m
.6797 .33275 L
s
.67978 .32558 m
.67978 .32558 L
s
.67985 .33017 m
.67985 .33017 L
s
.67992 .32793 m
.67992 .32793 L
s
.68 .3324 m
.68 .3324 L
s
.68007 .33216 m
.68007 .33216 L
s
.68015 .33463 m
.68015 .33463 L
s
.68022 .33451 m
.68022 .33451 L
s
.6803 .3378 m
.6803 .3378 L
s
.68037 .33498 m
.68037 .33498 L
s
.68045 .33005 m
.68045 .33005 L
s
.68052 .3331 m
.68052 .3331 L
s
.68059 .33216 m
.68059 .33216 L
s
.68066 .33052 m
.68066 .33052 L
s
.68074 .32359 m
.68074 .32359 L
s
.68081 .32535 m
.68081 .32535 L
s
.68089 .32324 m
.68089 .32324 L
s
.68096 .32735 m
.68096 .32735 L
s
.68104 .32511 m
.68104 .32511 L
s
.68111 .33052 m
.68111 .33052 L
s
.68119 .32746 m
.68119 .32746 L
s
.68126 .32993 m
.68126 .32993 L
s
.68134 .32476 m
.68134 .32476 L
s
.68141 .32723 m
.68141 .32723 L
s
.68148 .32653 m
.68148 .32653 L
s
.68156 .31948 m
.68156 .31948 L
s
.68163 .31172 m
.68163 .31172 L
s
.68171 .31208 m
.68171 .31208 L
s
.68178 .30891 m
.68178 .30891 L
s
.68186 .30915 m
.68186 .30915 L
s
.68193 .30915 m
.68193 .30915 L
s
.68201 .31255 m
.68201 .31255 L
s
.68208 .30868 m
.68208 .30868 L
s
.68216 .3095 m
.68216 .3095 L
s
.68223 .30386 m
.68223 .30386 L
s
.6823 .3082 m
.6823 .3082 L
s
.68237 .30292 m
.68237 .30292 L
s
.68245 .2994 m
.68245 .2994 L
s
.68252 .29505 m
.68252 .29505 L
s
.6826 .29587 m
.6826 .29587 L
s
.68267 .30609 m
.68267 .30609 L
s
.68275 .30656 m
.68275 .30656 L
s
.68282 .31196 m
.68282 .31196 L
s
.6829 .31055 m
.6829 .31055 L
s
.68298 .30938 m
.68298 .30938 L
s
.68304 .29963 m
.68304 .29963 L
s
.68312 .29798 m
.68312 .29798 L
s
.68319 .29681 m
.68319 .29681 L
s
.68327 .29505 m
.68327 .29505 L
s
.68334 .29493 m
.68334 .29493 L
s
.68342 .29998 m
.68342 .29998 L
s
.68349 .31102 m
.68349 .31102 L
s
.68357 .30915 m
.68357 .30915 L
s
.68364 .31666 m
.68364 .31666 L
s
.68372 .31631 m
.68372 .31631 L
s
.68379 .3183 m
.68379 .3183 L
s
.68386 .3109 m
.68386 .3109 L
s
.68393 .31561 m
.68393 .31561 L
s
.68401 .30926 m
.68401 .30926 L
s
.68408 .31302 m
.68408 .31302 L
s
.68416 .31114 m
.68416 .31114 L
s
.68423 .31172 m
.68423 .31172 L
s
.68431 .31408 m
.68431 .31408 L
s
.68438 .31501 m
.68438 .31501 L
s
.68446 .31326 m
.68446 .31326 L
s
.68454 .3102 m
.68454 .3102 L
s
.68461 .30808 m
.68461 .30808 L
s
.68468 .31736 m
.68468 .31736 L
s
.68475 .32347 m
.68475 .32347 L
s
.68483 .33052 m
.68483 .33052 L
s
.6849 .33216 m
.6849 .33216 L
s
.68498 .33416 m
.68498 .33416 L
s
.68505 .34015 m
.68505 .34015 L
s
.68513 .34367 m
.68513 .34367 L
s
.6852 .33604 m
.6852 .33604 L
s
.68528 .33639 m
.68528 .33639 L
s
.68535 .33933 m
.68535 .33933 L
s
.68542 .35107 m
.68542 .35107 L
s
.68549 .34696 m
.68549 .34696 L
s
.68557 .35025 m
.68557 .35025 L
s
.68564 .3587 m
.68564 .3587 L
s
.68572 .36458 m
.68572 .36458 L
s
.68579 .36658 m
.68579 .36658 L
s
.68587 .36411 m
.68587 .36411 L
s
.68594 .36669 m
.68594 .36669 L
s
.68601 .36927 m
.68601 .36927 L
s
.68609 .36446 m
.68609 .36446 L
s
.68617 .35753 m
.68617 .35753 L
s
.68624 .35284 m
.68624 .35284 L
s
.68631 .34813 m
.68631 .34813 L
s
.68639 .35002 m
.68639 .35002 L
s
.68646 .35048 m
.68646 .35048 L
s
.68654 .34872 m
.68654 .34872 L
s
.68661 .35331 m
.68661 .35331 L
s
.68669 .34473 m
.68669 .34473 L
s
.68676 .34109 m
.68676 .34109 L
s
.68683 .34414 m
.68683 .34414 L
s
.68691 .34461 m
.68691 .34461 L
s
.68699 .34473 m
.68699 .34473 L
s
.68706 .34696 m
.68706 .34696 L
s
.68713 .35201 m
.68713 .35201 L
s
.6872 .35741 m
.6872 .35741 L
s
.68728 .35823 m
.68728 .35823 L
s
.68735 .36341 m
.68735 .36341 L
s
.68743 .36505 m
.68743 .36505 L
s
.6875 .36904 m
.6875 .36904 L
s
.68758 .36798 m
.68758 .36798 L
s
.68765 .37479 m
.68765 .37479 L
s
.68772 .37972 m
.68772 .37972 L
s
.6878 .37773 m
.6878 .37773 L
s
.68787 .38466 m
.68787 .38466 L
s
.68795 .38595 m
.68795 .38595 L
s
.68802 .38266 m
.68802 .38266 L
s
.6881 .38407 m
.6881 .38407 L
s
.68817 .37867 m
.68817 .37867 L
s
.68825 .38008 m
.68825 .38008 L
s
.68832 .38055 m
.68832 .38055 L
s
.68839 .37867 m
.68839 .37867 L
s
.68846 .37656 m
.68846 .37656 L
s
.68854 .37997 m
.68854 .37997 L
s
.68862 .38079 m
.68862 .38079 L
s
.68869 .38125 m
.68869 .38125 L
s
.68876 .38137 m
.68876 .38137 L
s
.68884 .38443 m
.68884 .38443 L
s
.68891 .38748 m
.68891 .38748 L
s
.68899 .38466 m
.68899 .38466 L
s
.68906 .38665 m
.68906 .38665 L
s
.68914 .39065 m
.68914 .39065 L
s
.68921 .39464 m
.68921 .39464 L
s
.68928 .39699 m
.68928 .39699 L
s
.68936 .39899 m
.68936 .39899 L
s
.68943 .39992 m
.68943 .39992 L
s
.68951 .39887 m
.68951 .39887 L
s
.68958 .39605 m
.68958 .39605 L
s
.68966 .38795 m
.68966 .38795 L
s
.68973 .38689 m
.68973 .38689 L
s
.68981 .38525 m
.68981 .38525 L
s
.68988 .38889 m
.68988 .38889 L
s
.68996 .38853 m
.68996 .38853 L
s
.69003 .38689 m
.69003 .38689 L
s
.6901 .38853 m
.6901 .38853 L
s
.69017 .39147 m
.69017 .39147 L
s
.69025 .39593 m
.69025 .39593 L
s
.69032 .39299 m
.69032 .39299 L
s
.6904 .39018 m
.6904 .39018 L
s
.69047 .38783 m
.69047 .38783 L
s
.69055 .38689 m
.69055 .38689 L
s
.69062 .38407 m
.69062 .38407 L
s
.6907 .38525 m
.6907 .38525 L
s
.69078 .38289 m
.69078 .38289 L
s
.69084 .38618 m
.69084 .38618 L
s
.69092 .38161 m
.69092 .38161 L
s
.69099 .37832 m
.69099 .37832 L
s
.69107 .37351 m
.69107 .37351 L
s
.69114 .37057 m
.69114 .37057 L
s
.69122 .36822 m
.69122 .36822 L
s
.69129 .36705 m
.69129 .36705 L
s
.69137 .37162 m
.69137 .37162 L
s
.69144 .37139 m
.69144 .37139 L
s
.69152 .3674 m
.69152 .3674 L
s
.69159 .37256 m
.69159 .37256 L
s
.69166 .37069 m
.69166 .37069 L
s
.69173 .36951 m
.69173 .36951 L
s
.69181 .37256 m
.69181 .37256 L
s
.69188 .37256 m
.69188 .37256 L
s
.69196 .37726 m
.69196 .37726 L
s
.69203 .37797 m
.69203 .37797 L
s
.69211 .37303 m
.69211 .37303 L
s
.69218 .37303 m
.69218 .37303 L
s
.69226 .37045 m
.69226 .37045 L
s
.69234 .37069 m
.69234 .37069 L
s
.69241 .36633 m
.69241 .36633 L
s
.69248 .37022 m
.69248 .37022 L
s
.69255 .36693 m
.69255 .36693 L
s
.69263 .36693 m
.69263 .36693 L
s
.6927 .36329 m
.6927 .36329 L
s
.69278 .37197 m
.69278 .37197 L
s
.69285 .37139 m
.69285 .37139 L
s
.69293 .37221 m
.69293 .37221 L
s
.693 .37468 m
.693 .37468 L
s
.69308 .3775 m
.69308 .3775 L
s
.69315 .37679 m
.69315 .37679 L
s
.69322 .37656 m
.69322 .37656 L
s
.69329 .37808 m
.69329 .37808 L
s
.69337 .37832 m
.69337 .37832 L
s
.69344 .37421 m
.69344 .37421 L
s
.69352 .3789 m
.69352 .3789 L
s
.69359 .38595 m
.69359 .38595 L
s
.69367 .3802 m
.69367 .3802 L
s
.69374 .37867 m
.69374 .37867 L
s
.69382 .37668 m
.69382 .37668 L
s
.6939 .37668 m
.6939 .37668 L
s
.69397 .38161 m
.69397 .38161 L
s
.69404 .38689 m
.69404 .38689 L
s
.69411 .38266 m
.69411 .38266 L
s
.69419 .38254 m
.69419 .38254 L
s
.69426 .37738 m
.69426 .37738 L
s
.69434 .37374 m
.69434 .37374 L
s
.69441 .37797 m
.69441 .37797 L
s
.69449 .37209 m
.69449 .37209 L
s
.69456 .36728 m
.69456 .36728 L
s
.69463 .36658 m
.69463 .36658 L
s
.69471 .36211 m
.69471 .36211 L
s
.69479 .36105 m
.69479 .36105 L
s
.69486 .36141 m
.69486 .36141 L
s
.69493 .3553 m
.69493 .3553 L
s
.695 .35683 m
.695 .35683 L
s
.69508 .35812 m
.69508 .35812 L
s
.69515 .35636 m
.69515 .35636 L
s
.69523 .35259 m
.69523 .35259 L
s
.6953 .35331 m
.6953 .35331 L
s
.69538 .35177 m
.69538 .35177 L
s
.69545 .35683 m
.69545 .35683 L
s
.69553 .36411 m
.69553 .36411 L
s
.69561 .36458 m
.69561 .36458 L
s
.69567 .35366 m
.69567 .35366 L
s
.69575 .35812 m
.69575 .35812 L
s
.69582 .34766 m
.69582 .34766 L
s
.6959 .36141 m
.6959 .36141 L
s
.69597 .36399 m
.69597 .36399 L
s
.69605 .36341 m
.69605 .36341 L
s
.69612 .36152 m
.69612 .36152 L
s
.69619 .36012 m
.69619 .36012 L
s
.69626 .36152 m
.69626 .36152 L
s
.69634 .36693 m
.69634 .36693 L
s
.69642 .37315 m
.69642 .37315 L
s
.69649 .37303 m
.69649 .37303 L
s
.69656 .37339 m
.69656 .37339 L
s
.69664 .36658 m
.69664 .36658 L
s
.69671 .37479 m
.69671 .37479 L
s
.69679 .37773 m
.69679 .37773 L
s
.69686 .37984 m
.69686 .37984 L
s
.69694 .37855 m
.69694 .37855 L
s
.69701 .37797 m
.69701 .37797 L
s
.69708 .38125 m
.69708 .38125 L
s
.69716 .38865 m
.69716 .38865 L
s
.69724 .38536 m
.69724 .38536 L
s
.69731 .38278 m
.69731 .38278 L
s
.69738 .39229 m
.69738 .39229 L
s
.69746 .38361 m
.69746 .38361 L
s
.69753 .38361 m
.69753 .38361 L
s
.69761 .38396 m
.69761 .38396 L
s
.69768 .3809 m
.69768 .3809 L
s
.69776 .38466 m
.69776 .38466 L
s
.69783 .38618 m
.69783 .38618 L
s
.6979 .38889 m
.6979 .38889 L
s
.69797 .39042 m
.69797 .39042 L
s
.69805 .39299 m
.69805 .39299 L
s
.69812 .39311 m
.69812 .39311 L
s
.6982 .39453 m
.6982 .39453 L
s
.69827 .39429 m
.69827 .39429 L
s
.69835 .39288 m
.69835 .39288 L
s
.69842 .39335 m
.69842 .39335 L
s
.6985 .38947 m
.6985 .38947 L
s
.69858 .38807 m
.69858 .38807 L
s
.69864 .39687 m
.69864 .39687 L
s
.69872 .39089 m
.69872 .39089 L
s
.69879 .38513 m
.69879 .38513 L
s
.69887 .38396 m
.69887 .38396 L
s
.69894 .38219 m
.69894 .38219 L
s
.69902 .38466 m
.69902 .38466 L
s
.69909 .38454 m
.69909 .38454 L
s
.69917 .38478 m
.69917 .38478 L
s
.69924 .38642 m
.69924 .38642 L
s
.69932 .39042 m
.69932 .39042 L
s
.69939 .3802 m
.69939 .3802 L
s
.69946 .37515 m
.69946 .37515 L
s
.69953 .37679 m
.69953 .37679 L
s
.69961 .37879 m
.69961 .37879 L
s
.69968 .3775 m
.69968 .3775 L
s
.69976 .37327 m
.69976 .37327 L
s
.69983 .37115 m
.69983 .37115 L
s
.69991 .37279 m
.69991 .37279 L
s
.69998 .37115 m
.69998 .37115 L
s
.70006 .37045 m
.70006 .37045 L
s
.70014 .3688 m
.70014 .3688 L
s
.70021 .36681 m
.70021 .36681 L
s
.70028 .36575 m
.70028 .36575 L
s
.70035 .36974 m
.70035 .36974 L
s
.70043 .37397 m
.70043 .37397 L
s
.7005 .37679 m
.7005 .37679 L
s
.70058 .38161 m
.70058 .38161 L
s
.70065 .37033 m
.70065 .37033 L
s
.70073 .36469 m
.70073 .36469 L
s
.7008 .36223 m
.7008 .36223 L
s
.70088 .35753 m
.70088 .35753 L
s
.70095 .36646 m
.70095 .36646 L
s
.70103 .36798 m
.70103 .36798 L
s
.70109 .36528 m
.70109 .36528 L
s
.70117 .35952 m
.70117 .35952 L
s
.70124 .36152 m
.70124 .36152 L
s
.70132 .36293 m
.70132 .36293 L
s
.70139 .36563 m
.70139 .36563 L
s
.70147 .36622 m
.70147 .36622 L
s
.70154 .36446 m
.70154 .36446 L
s
.70162 .36364 m
.70162 .36364 L
s
.7017 .36469 m
.7017 .36469 L
s
.70177 .36281 m
.70177 .36281 L
s
.70184 .35812 m
.70184 .35812 L
s
.70191 .35777 m
.70191 .35777 L
s
.70199 .35965 m
.70199 .35965 L
s
.70206 .35683 m
.70206 .35683 L
s
.70214 .35765 m
.70214 .35765 L
s
.70221 .35917 m
.70221 .35917 L
s
.70229 .36187 m
.70229 .36187 L
s
.70236 .36258 m
.70236 .36258 L
s
.70244 .36763 m
.70244 .36763 L
s
.70251 .36693 m
.70251 .36693 L
s
.70259 .35612 m
.70259 .35612 L
s
.70266 .36012 m
.70266 .36012 L
s
.70273 .36082 m
.70273 .36082 L
s
.7028 .35354 m
.7028 .35354 L
s
.70288 .35224 m
.70288 .35224 L
s
.70295 .35154 m
.70295 .35154 L
s
.70303 .34907 m
.70303 .34907 L
s
.7031 .35213 m
.7031 .35213 L
s
.70318 .34966 m
.70318 .34966 L
s
.70325 .34649 m
.70325 .34649 L
s
.70333 .34508 m
.70333 .34508 L
s
.70341 .34391 m
.70341 .34391 L
s
.70347 .34015 m
.70347 .34015 L
s
.70355 .34849 m
.70355 .34849 L
s
.70362 .35718 m
.70362 .35718 L
s
.7037 .36352 m
.7037 .36352 L
s
.70377 .37022 m
.70377 .37022 L
s
.70385 .36481 m
.70385 .36481 L
s
.70392 .36399 m
.70392 .36399 L
s
.704 .35965 m
.704 .35965 L
s
.70407 .35377 m
.70407 .35377 L
s
.70415 .35894 m
.70415 .35894 L
s
.70422 .36387 m
.70422 .36387 L
s
.70429 .36575 m
.70429 .36575 L
s
.70436 .36293 m
.70436 .36293 L
s
.70444 .36681 m
.70444 .36681 L
s
.70451 .36317 m
.70451 .36317 L
s
.70459 .36423 m
.70459 .36423 L
s
.70466 .35636 m
.70466 .35636 L
s
.70474 .35636 m
.70474 .35636 L
s
.70481 .36094 m
.70481 .36094 L
s
.70488 .35236 m
.70488 .35236 L
s
.70496 .35541 m
.70496 .35541 L
s
.70504 .35671 m
.70504 .35671 L
s
.70511 .35941 m
.70511 .35941 L
s
.70518 .35765 m
.70518 .35765 L
s
.70526 .35905 m
.70526 .35905 L
s
.70533 .35683 m
.70533 .35683 L
s
.70541 .36129 m
.70541 .36129 L
s
.70548 .36187 m
.70548 .36187 L
s
.70556 .35354 m
.70556 .35354 L
s
.70563 .35401 m
.70563 .35401 L
s
.7057 .35588 m
.7057 .35588 L
s
.70578 .36129 m
.70578 .36129 L
s
.70586 .36223 m
.70586 .36223 L
s
.70592 .36927 m
.70592 .36927 L
s
.706 .36716 m
.706 .36716 L
s
.70607 .3661 m
.70607 .3661 L
s
.70615 .36728 m
.70615 .36728 L
s
.70622 .36658 m
.70622 .36658 L
s
.7063 .36633 m
.7063 .36633 L
s
.70638 .37351 m
.70638 .37351 L
s
.70644 .37468 m
.70644 .37468 L
s
.70652 .37351 m
.70652 .37351 L
s
.70659 .36646 m
.70659 .36646 L
s
.70667 .36117 m
.70667 .36117 L
s
.70674 .36669 m
.70674 .36669 L
s
.70682 .36423 m
.70682 .36423 L
s
.70689 .36598 m
.70689 .36598 L
s
.70697 .3654 m
.70697 .3654 L
s
.70704 .36705 m
.70704 .36705 L
s
.70712 .35965 m
.70712 .35965 L
s
.70719 .35694 m
.70719 .35694 L
s
.70726 .35107 m
.70726 .35107 L
s
.70733 .35201 m
.70733 .35201 L
s
.70741 .35048 m
.70741 .35048 L
s
.70749 .35259 m
.70749 .35259 L
s
.70756 .34931 m
.70756 .34931 L
s
.70763 .34673 m
.70763 .34673 L
s
.70771 .34614 m
.70771 .34614 L
s
.70778 .3472 m
.70778 .3472 L
s
.70786 .35201 m
.70786 .35201 L
s
.70794 .35084 m
.70794 .35084 L
s
.70801 .35753 m
.70801 .35753 L
s
.70808 .35518 m
.70808 .35518 L
s
.70815 .35401 m
.70815 .35401 L
s
.70823 .34837 m
.70823 .34837 L
s
.7083 .34567 m
.7083 .34567 L
s
.70838 .3371 m
.70838 .3371 L
s
.70845 .34062 m
.70845 .34062 L
s
.70853 .34766 m
.70853 .34766 L
s
.7086 .34062 m
.7086 .34062 L
s
.70868 .33933 m
.70868 .33933 L
s
.70875 .33616 m
.70875 .33616 L
s
.70883 .33404 m
.70883 .33404 L
s
.70889 .3452 m
.70889 .3452 L
s
.70897 .34038 m
.70897 .34038 L
s
.70904 .33921 m
.70904 .33921 L
s
.70912 .33897 m
.70912 .33897 L
s
.70919 .34109 m
.70919 .34109 L
s
.70927 .34578 m
.70927 .34578 L
s
.70934 .34485 m
.70934 .34485 L
s
.70942 .35154 m
.70942 .35154 L
s
.7095 .35236 m
.7095 .35236 L
s
.70957 .34943 m
.70957 .34943 L
s
.70964 .34485 m
.70964 .34485 L
s
.70971 .35072 m
.70971 .35072 L
s
.70979 .34226 m
.70979 .34226 L
s
.70986 .34485 m
.70986 .34485 L
s
.70994 .33451 m
.70994 .33451 L
s
.71001 .33087 m
.71001 .33087 L
s
.71009 .33334 m
.71009 .33334 L
s
.71016 .3351 m
.71016 .3351 L
s
.71024 .33299 m
.71024 .33299 L
s
.71031 .33287 m
.71031 .33287 L
s
.71039 .32911 m
.71039 .32911 L
s
.71046 .32735 m
.71046 .32735 L
s
.71053 .32982 m
.71053 .32982 L
s
.7106 .32511 m
.7106 .32511 L
s
.71068 .32606 m
.71068 .32606 L
s
.71075 .33005 m
.71075 .33005 L
s
.71083 .33157 m
.71083 .33157 L
s
.7109 .32653 m
.7109 .32653 L
s
.71098 .3297 m
.71098 .3297 L
s
.71105 .33862 m
.71105 .33862 L
s
.71113 .33921 m
.71113 .33921 L
s
.71121 .34085 m
.71121 .34085 L
s
.71127 .33404 m
.71127 .33404 L
s
.71135 .33439 m
.71135 .33439 L
s
.71142 .34167 m
.71142 .34167 L
s
.7115 .34414 m
.7115 .34414 L
s
.71157 .34543 m
.71157 .34543 L
s
.71165 .34802 m
.71165 .34802 L
s
.71172 .34015 m
.71172 .34015 L
s
.7118 .34085 m
.7118 .34085 L
s
.71187 .34426 m
.71187 .34426 L
s
.71195 .34555 m
.71195 .34555 L
s
.71202 .35342 m
.71202 .35342 L
s
.71209 .35777 m
.71209 .35777 L
s
.71216 .35389 m
.71216 .35389 L
s
.71224 .35448 m
.71224 .35448 L
s
.71231 .3553 m
.71231 .3553 L
s
.71239 .36223 m
.71239 .36223 L
s
.71246 .36763 m
.71246 .36763 L
s
.71254 .36399 m
.71254 .36399 L
s
.71261 .3607 m
.71261 .3607 L
s
.71268 .35929 m
.71268 .35929 L
s
.71276 .36317 m
.71276 .36317 L
s
.71284 .36927 m
.71284 .36927 L
s
.71291 .37162 m
.71291 .37162 L
s
.71298 .36857 m
.71298 .36857 L
s
.71306 .37045 m
.71306 .37045 L
s
.71313 .37444 m
.71313 .37444 L
s
.71321 .37668 m
.71321 .37668 L
s
.71328 .3708 m
.71328 .3708 L
s
.71336 .37022 m
.71336 .37022 L
s
.71343 .36962 m
.71343 .36962 L
s
.7135 .37244 m
.7135 .37244 L
s
.71358 .36951 m
.71358 .36951 L
s
.71366 .3688 m
.71366 .3688 L
s
.71372 .37409 m
.71372 .37409 L
s
.7138 .37561 m
.7138 .37561 L
s
.71387 .37468 m
.71387 .37468 L
s
.71395 .37033 m
.71395 .37033 L
s
.71402 .36869 m
.71402 .36869 L
s
.7141 .36962 m
.7141 .36962 L
s
.71418 .37186 m
.71418 .37186 L
s
.71424 .36728 m
.71424 .36728 L
s
.71432 .37608 m
.71432 .37608 L
s
.71439 .37585 m
.71439 .37585 L
s
.71447 .37162 m
.71447 .37162 L
s
.71454 .37585 m
.71454 .37585 L
s
.71462 .37268 m
.71462 .37268 L
s
.71469 .38043 m
.71469 .38043 L
s
.71477 .38478 m
.71477 .38478 L
s
.71484 .38935 m
.71484 .38935 L
s
.71492 .39171 m
.71492 .39171 L
s
.71499 .38008 m
.71499 .38008 L
s
.71506 .38419 m
.71506 .38419 L
s
.71513 .38243 m
.71513 .38243 L
s
.71521 .38079 m
.71521 .38079 L
s
.71529 .38219 m
.71529 .38219 L
s
.71536 .37867 m
.71536 .37867 L
s
.71543 .37632 m
.71543 .37632 L
s
.71551 .38008 m
.71551 .38008 L
s
.71558 .3809 m
.71558 .3809 L
s
.71566 .38243 m
.71566 .38243 L
s
.71574 .37832 m
.71574 .37832 L
s
.71581 .37479 m
.71581 .37479 L
s
.71588 .3789 m
.71588 .3789 L
s
.71595 .37491 m
.71595 .37491 L
s
.71603 .37961 m
.71603 .37961 L
s
.7161 .37468 m
.7161 .37468 L
s
.71618 .36904 m
.71618 .36904 L
s
.71625 .36716 m
.71625 .36716 L
s
.71633 .36152 m
.71633 .36152 L
s
.7164 .35765 m
.7164 .35765 L
s
.71648 .36211 m
.71648 .36211 L
s
.71655 .36059 m
.71655 .36059 L
s
.71663 .36187 m
.71663 .36187 L
s
.71669 .36329 m
.71669 .36329 L
s
.71677 .36211 m
.71677 .36211 L
s
.71684 .36152 m
.71684 .36152 L
s
.71692 .36317 m
.71692 .36317 L
s
.71699 .36892 m
.71699 .36892 L
s
.71707 .37022 m
.71707 .37022 L
s
.71714 .37421 m
.71714 .37421 L
s
.71722 .37679 m
.71722 .37679 L
s
.7173 .37209 m
.7173 .37209 L
s
.71737 .37632 m
.71737 .37632 L
s
.71744 .36998 m
.71744 .36998 L
s
.71751 .37221 m
.71751 .37221 L
s
.71759 .37162 m
.71759 .37162 L
s
.71766 .37456 m
.71766 .37456 L
s
.71774 .37561 m
.71774 .37561 L
s
.71781 .37374 m
.71781 .37374 L
s
.71789 .36845 m
.71789 .36845 L
s
.71796 .3661 m
.71796 .3661 L
s
.71804 .36446 m
.71804 .36446 L
s
.71811 .36199 m
.71811 .36199 L
s
.71819 .36434 m
.71819 .36434 L
s
.71826 .36376 m
.71826 .36376 L
s
.71833 .36281 m
.71833 .36281 L
s
.7184 .36927 m
.7184 .36927 L
s
.71848 .37279 m
.71848 .37279 L
s
.71855 .37691 m
.71855 .37691 L
s
.71863 .38102 m
.71863 .38102 L
s
.7187 .39299 m
.7187 .39299 L
s
.71878 .39276 m
.71878 .39276 L
s
.71886 .38525 m
.71886 .38525 L
s
.71893 .38454 m
.71893 .38454 L
s
.71901 .38783 m
.71901 .38783 L
s
.71907 .37984 m
.71907 .37984 L
s
.71915 .37949 m
.71915 .37949 L
s
.71922 .36857 m
.71922 .36857 L
s
.7193 .37479 m
.7193 .37479 L
s
.71937 .3701 m
.71937 .3701 L
s
.71945 .37127 m
.71945 .37127 L
s
.71952 .3708 m
.71952 .3708 L
s
.7196 .37045 m
.7196 .37045 L
s
.71967 .37022 m
.71967 .37022 L
s
.71975 .36962 m
.71975 .36962 L
s
.71982 .37022 m
.71982 .37022 L
s
.71989 .37433 m
.71989 .37433 L
s
.71996 .37444 m
.71996 .37444 L
s
.72004 .37315 m
.72004 .37315 L
s
.72011 .36998 m
.72011 .36998 L
s
.72019 .36763 m
.72019 .36763 L
s
.72026 .36012 m
.72026 .36012 L
s
.72034 .36035 m
.72034 .36035 L
s
.72041 .35905 m
.72041 .35905 L
s
.72049 .36281 m
.72049 .36281 L
s
.72057 .35952 m
.72057 .35952 L
s
.72064 .35788 m
.72064 .35788 L
s
.72071 .3553 m
.72071 .3553 L
s
.72078 .35553 m
.72078 .35553 L
s
.72086 .35072 m
.72086 .35072 L
s
.72093 .35259 m
.72093 .35259 L
s
.72101 .34907 m
.72101 .34907 L
s
.72108 .34708 m
.72108 .34708 L
s
.72116 .34485 m
.72116 .34485 L
s
.72123 .33956 m
.72123 .33956 L
s
.7213 .34027 m
.7213 .34027 L
s
.72138 .34332 m
.72138 .34332 L
s
.72146 .3351 m
.72146 .3351 L
s
.72152 .33428 m
.72152 .33428 L
s
.7216 .33721 m
.7216 .33721 L
s
.72167 .34226 m
.72167 .34226 L
s
.72175 .34673 m
.72175 .34673 L
s
.72182 .34344 m
.72182 .34344 L
s
.7219 .34426 m
.7219 .34426 L
s
.72198 .34614 m
.72198 .34614 L
s
.72204 .33803 m
.72204 .33803 L
s
.72212 .33686 m
.72212 .33686 L
s
.7222 .33568 m
.7222 .33568 L
s
.72227 .35002 m
.72227 .35002 L
s
.72234 .35224 m
.72234 .35224 L
s
.72242 .35248 m
.72242 .35248 L
s
.72249 .35295 m
.72249 .35295 L
s
.72257 .35189 m
.72257 .35189 L
s
.72264 .35048 m
.72264 .35048 L
s
.72272 .34943 m
.72272 .34943 L
s
.72279 .35541 m
.72279 .35541 L
s
.72286 .35588 m
.72286 .35588 L
s
.72293 .35142 m
.72293 .35142 L
s
.72301 .3573 m
.72301 .3573 L
s
.72309 .35553 m
.72309 .35553 L
s
.72316 .35894 m
.72316 .35894 L
s
.72323 .35401 m
.72323 .35401 L
s
.72331 .35166 m
.72331 .35166 L
s
.72338 .35612 m
.72338 .35612 L
s
.72346 .35671 m
.72346 .35671 L
s
.72354 .35624 m
.72354 .35624 L
s
.72361 .35659 m
.72361 .35659 L
s
.72368 .35952 m
.72368 .35952 L
s
.72375 .35882 m
.72375 .35882 L
s
.72383 .35506 m
.72383 .35506 L
s
.7239 .35952 m
.7239 .35952 L
s
.72398 .3573 m
.72398 .3573 L
s
.72405 .36035 m
.72405 .36035 L
s
.72413 .35777 m
.72413 .35777 L
s
.7242 .36633 m
.7242 .36633 L
s
.72428 .37279 m
.72428 .37279 L
s
.72435 .36987 m
.72435 .36987 L
s
.72443 .37561 m
.72443 .37561 L
s
.72449 .37972 m
.72449 .37972 L
s
.72457 .38642 m
.72457 .38642 L
s
.72464 .3802 m
.72464 .3802 L
s
.72472 .37679 m
.72472 .37679 L
s
.72479 .3755 m
.72479 .3755 L
s
.72487 .37115 m
.72487 .37115 L
s
.72494 .36998 m
.72494 .36998 L
s
.72502 .36763 m
.72502 .36763 L
s
.7251 .36423 m
.7251 .36423 L
s
.72517 .36035 m
.72517 .36035 L
s
.72524 .36411 m
.72524 .36411 L
s
.72531 .35965 m
.72531 .35965 L
s
.72539 .35271 m
.72539 .35271 L
s
.72546 .35436 m
.72546 .35436 L
s
.72554 .36082 m
.72554 .36082 L
s
.72561 .36833 m
.72561 .36833 L
s
.72569 .36434 m
.72569 .36434 L
s
.72576 .36469 m
.72576 .36469 L
s
.72584 .35859 m
.72584 .35859 L
s
.72591 .36352 m
.72591 .36352 L
s
.72599 .36269 m
.72599 .36269 L
s
.72606 .36234 m
.72606 .36234 L
s
.72613 .36869 m
.72613 .36869 L
s
.7262 .37057 m
.7262 .37057 L
s
.72628 .36246 m
.72628 .36246 L
s
.72635 .35929 m
.72635 .35929 L
s
.72643 .35636 m
.72643 .35636 L
s
.7265 .35377 m
.7265 .35377 L
s
.72658 .35002 m
.72658 .35002 L
s
.72666 .3459 m
.72666 .3459 L
s
.72673 .34966 m
.72673 .34966 L
s
.72681 .34661 m
.72681 .34661 L
s
.72687 .34766 m
.72687 .34766 L
s
.72695 .34684 m
.72695 .34684 L
s
.72702 .34543 m
.72702 .34543 L
s
.7271 .3432 m
.7271 .3432 L
s
.72717 .34473 m
.72717 .34473 L
s
.72725 .34097 m
.72725 .34097 L
s
.72732 .34203 m
.72732 .34203 L
s
.7274 .33874 m
.7274 .33874 L
s
.72747 .33827 m
.72747 .33827 L
s
.72755 .33921 m
.72755 .33921 L
s
.72762 .33992 m
.72762 .33992 L
s
.72769 .33475 m
.72769 .33475 L
s
.72776 .33169 m
.72776 .33169 L
s
.72784 .33545 m
.72784 .33545 L
s
.72791 .33545 m
.72791 .33545 L
s
.72799 .3378 m
.72799 .3378 L
s
.72806 .34179 m
.72806 .34179 L
s
.72814 .34461 m
.72814 .34461 L
s
.72821 .33545 m
.72821 .33545 L
s
.72829 .33639 m
.72829 .33639 L
s
.72837 .33216 m
.72837 .33216 L
s
.72844 .33287 m
.72844 .33287 L
s
.72851 .33357 m
.72851 .33357 L
s
.72858 .3324 m
.72858 .3324 L
s
.72866 .32875 m
.72866 .32875 L
s
.72873 .31865 m
.72873 .31865 L
s
.72881 .31901 m
.72881 .31901 L
s
.72888 .3169 m
.72888 .3169 L
s
.72896 .31795 m
.72896 .31795 L
s
.72903 .323 m
.72903 .323 L
s
.72911 .32547 m
.72911 .32547 L
s
.72918 .33169 m
.72918 .33169 L
s
.72926 .32793 m
.72926 .32793 L
s
.72932 .32406 m
.72932 .32406 L
s
.7294 .32558 m
.7294 .32558 L
s
.72947 .32464 m
.72947 .32464 L
s
.72955 .32664 m
.72955 .32664 L
s
.72962 .32464 m
.72962 .32464 L
s
.7297 .32289 m
.7297 .32289 L
s
.72978 .32206 m
.72978 .32206 L
s
.72984 .31584 m
.72984 .31584 L
s
.72992 .3088 m
.72992 .3088 L
s
.73 .3095 m
.73 .3095 L
s
.73007 .3095 m
.73007 .3095 L
s
.73014 .30997 m
.73014 .30997 L
s
.73022 .30668 m
.73022 .30668 L
s
.73029 .3075 m
.73029 .3075 L
s
.73037 .30762 m
.73037 .30762 L
s
.73044 .3102 m
.73044 .3102 L
s
.73052 .31267 m
.73052 .31267 L
s
.73059 .30726 m
.73059 .30726 L
s
.73066 .30621 m
.73066 .30621 L
s
.73074 .3068 m
.73074 .3068 L
s
.73082 .3028 m
.73082 .3028 L
s
.73089 .30316 m
.73089 .30316 L
s
.73096 .30491 m
.73096 .30491 L
s
.73103 .30962 m
.73103 .30962 L
s
.73111 .31172 m
.73111 .31172 L
s
.73118 .30997 m
.73118 .30997 L
s
.73126 .30316 m
.73126 .30316 L
s
.73134 .29858 m
.73134 .29858 L
s
.73141 .2981 m
.73141 .2981 L
s
.73148 .3122 m
.73148 .3122 L
s
.73155 .3122 m
.73155 .3122 L
s
.73163 .30574 m
.73163 .30574 L
s
.7317 .31079 m
.7317 .31079 L
s
.73178 .31279 m
.73178 .31279 L
s
.73185 .30598 m
.73185 .30598 L
s
.73193 .31184 m
.73193 .31184 L
s
.732 .30539 m
.732 .30539 L
s
.73208 .30468 m
.73208 .30468 L
s
.73215 .30022 m
.73215 .30022 L
s
.73223 .29905 m
.73223 .29905 L
s
.73229 .30187 m
.73229 .30187 L
s
.73237 .29576 m
.73237 .29576 L
s
.73245 .29352 m
.73245 .29352 L
s
.73252 .28742 m
.73252 .28742 L
s
.73259 .28155 m
.73259 .28155 L
s
.73267 .28131 m
.73267 .28131 L
s
.73274 .28284 m
.73274 .28284 L
s
.73282 .27955 m
.73282 .27955 L
s
.7329 .27673 m
.7329 .27673 L
s
.73297 .2779 m
.73297 .2779 L
s
.73304 .27885 m
.73304 .27885 L
s
.73311 .27673 m
.73311 .27673 L
s
.73319 .27297 m
.73319 .27297 L
s
.73326 .27109 m
.73326 .27109 L
s
.73334 .26686 m
.73334 .26686 L
s
.73341 .27168 m
.73341 .27168 L
s
.73349 .27074 m
.73349 .27074 L
s
.73356 .27673 m
.73356 .27673 L
s
.73364 .27567 m
.73364 .27567 L
s
.73371 .27696 m
.73371 .27696 L
s
.73379 .2799 m
.73379 .2799 L
s
.73386 .2819 m
.73386 .2819 L
s
.73393 .28683 m
.73393 .28683 L
s
.734 .28848 m
.734 .28848 L
s
.73408 .29 m
.73408 .29 L
s
.73415 .29658 m
.73415 .29658 L
s
.73423 .30034 m
.73423 .30034 L
s
.7343 .30316 m
.7343 .30316 L
s
.73438 .30327 m
.73438 .30327 L
s
.73446 .30362 m
.73446 .30362 L
s
.73453 .30069 m
.73453 .30069 L
s
.73461 .29658 m
.73461 .29658 L
s
.73467 .29094 m
.73467 .29094 L
s
.73475 .29881 m
.73475 .29881 L
s
.73482 .29763 m
.73482 .29763 L
s
.7349 .29564 m
.7349 .29564 L
s
.73497 .29681 m
.73497 .29681 L
s
.73505 .29987 m
.73505 .29987 L
s
.73512 .29787 m
.73512 .29787 L
s
.7352 .29846 m
.7352 .29846 L
s
.73527 .30104 m
.73527 .30104 L
s
.73535 .31478 m
.73535 .31478 L
s
.73542 .31525 m
.73542 .31525 L
s
.73549 .3129 m
.73549 .3129 L
s
.73556 .30609 m
.73556 .30609 L
s
.73564 .30187 m
.73564 .30187 L
s
.73571 .3075 m
.73571 .3075 L
s
.73579 .3102 m
.73579 .3102 L
s
.73586 .31654 m
.73586 .31654 L
s
.73594 .31431 m
.73594 .31431 L
s
.73602 .31326 m
.73602 .31326 L
s
.73609 .31478 m
.73609 .31478 L
s
.73617 .3169 m
.73617 .3169 L
s
.73624 .31666 m
.73624 .31666 L
s
.73631 .32418 m
.73631 .32418 L
s
.73638 .32746 m
.73638 .32746 L
s
.73646 .32629 m
.73646 .32629 L
s
.73653 .32359 m
.73653 .32359 L
s
.73661 .32077 m
.73661 .32077 L
s
.73668 .31807 m
.73668 .31807 L
s
.73676 .31079 m
.73676 .31079 L
s
.73683 .3176 m
.73683 .3176 L
s
.73691 .32159 m
.73691 .32159 L
s
.73698 .32242 m
.73698 .32242 L
s
.73706 .32488 m
.73706 .32488 L
s
.73712 .32206 m
.73712 .32206 L
s
.7372 .32194 m
.7372 .32194 L
s
.73727 .31596 m
.73727 .31596 L
s
.73735 .31725 m
.73735 .31725 L
s
.73742 .31244 m
.73742 .31244 L
s
.7375 .31783 m
.7375 .31783 L
s
.73758 .31372 m
.73758 .31372 L
s
.73765 .3176 m
.73765 .3176 L
s
.73773 .31854 m
.73773 .31854 L
s
.7378 .31842 m
.7378 .31842 L
s
.73787 .31608 m
.73787 .31608 L
s
.73794 .31161 m
.73794 .31161 L
s
.73802 .31279 m
.73802 .31279 L
s
.73809 .31854 m
.73809 .31854 L
s
.73817 .31172 m
.73817 .31172 L
s
.73824 .30551 m
.73824 .30551 L
s
.73832 .30644 m
.73832 .30644 L
s
.73839 .30891 m
.73839 .30891 L
s
.73846 .30868 m
.73846 .30868 L
s
.73854 .31184 m
.73854 .31184 L
s
.73862 .31384 m
.73862 .31384 L
s
.73869 .31901 m
.73869 .31901 L
s
.73876 .31596 m
.73876 .31596 L
s
.73883 .31501 m
.73883 .31501 L
s
.73891 .31067 m
.73891 .31067 L
s
.73898 .31302 m
.73898 .31302 L
s
.73906 .3068 m
.73906 .3068 L
s
.73914 .30738 m
.73914 .30738 L
s
.73921 .29963 m
.73921 .29963 L
s
.73928 .3021 m
.73928 .3021 L
s
.73936 .30409 m
.73936 .30409 L
s
.73944 .30234 m
.73944 .30234 L
s
.73951 .30633 m
.73951 .30633 L
s
.73958 .30726 m
.73958 .30726 L
s
.73965 .30456 m
.73965 .30456 L
s
.73973 .31055 m
.73973 .31055 L
s
.7398 .31349 m
.7398 .31349 L
s
.73988 .31396 m
.73988 .31396 L
s
.73995 .31631 m
.73995 .31631 L
s
.74003 .31619 m
.74003 .31619 L
s
.74009 .31114 m
.74009 .31114 L
s
.74017 .30938 m
.74017 .30938 L
s
.74025 .30726 m
.74025 .30726 L
s
.74032 .3109 m
.74032 .3109 L
s
.74039 .31279 m
.74039 .31279 L
s
.74047 .31619 m
.74047 .31619 L
s
.74054 .31678 m
.74054 .31678 L
s
.74062 .31736 m
.74062 .31736 L
s
.7407 .31619 m
.7407 .31619 L
s
.74077 .31631 m
.74077 .31631 L
s
.74084 .31302 m
.74084 .31302 L
s
.74091 .31337 m
.74091 .31337 L
s
.74099 .31631 m
.74099 .31631 L
s
.74107 .3223 m
.74107 .3223 L
s
.74114 .32265 m
.74114 .32265 L
s
.74121 .31936 m
.74121 .31936 L
s
.74129 .32664 m
.74129 .32664 L
s
.74136 .32394 m
.74136 .32394 L
s
.74144 .31936 m
.74144 .31936 L
s
.74151 .31854 m
.74151 .31854 L
s
.74159 .31877 m
.74159 .31877 L
s
.74166 .32254 m
.74166 .32254 L
s
.74173 .32535 m
.74173 .32535 L
s
.7418 .32464 m
.7418 .32464 L
s
.74188 .32664 m
.74188 .32664 L
s
.74195 .32899 m
.74195 .32899 L
s
.74203 .32571 m
.74203 .32571 L
s
.7421 .32242 m
.7421 .32242 L
s
.74218 .32147 m
.74218 .32147 L
s
.74226 .31678 m
.74226 .31678 L
s
.74233 .31326 m
.74233 .31326 L
s
.74241 .30598 m
.74241 .30598 L
s
.74248 .30116 m
.74248 .30116 L
s
.74255 .29646 m
.74255 .29646 L
s
.74262 .29141 m
.74262 .29141 L
s
.7427 .29388 m
.7427 .29388 L
s
.74277 .29294 m
.74277 .29294 L
s
.74285 .29434 m
.74285 .29434 L
s
.74292 .29481 m
.74292 .29481 L
s
.743 .2927 m
.743 .2927 L
s
.74307 .29505 m
.74307 .29505 L
s
.74315 .28918 m
.74315 .28918 L
s
.74322 .28941 m
.74322 .28941 L
s
.74329 .28495 m
.74329 .28495 L
s
.74336 .2819 m
.74336 .2819 L
s
.74344 .28213 m
.74344 .28213 L
s
.74351 .28389 m
.74351 .28389 L
s
.74359 .28953 m
.74359 .28953 L
s
.74366 .29047 m
.74366 .29047 L
s
.74374 .28918 m
.74374 .28918 L
s
.74382 .28636 m
.74382 .28636 L
s
.74389 .28812 m
.74389 .28812 L
s
.74397 .29094 m
.74397 .29094 L
s
.74404 .29352 m
.74404 .29352 L
s
.74411 .28566 m
.74411 .28566 L
s
.74418 .28613 m
.74418 .28613 L
s
.74426 .28307 m
.74426 .28307 L
s
.74433 .2819 m
.74433 .2819 L
s
.74441 .28142 m
.74441 .28142 L
s
.74448 .28319 m
.74448 .28319 L
s
.74456 .28378 m
.74456 .28378 L
s
.74463 .28131 m
.74463 .28131 L
s
.74471 .28272 m
.74471 .28272 L
s
.74478 .2806 m
.74478 .2806 L
s
.74486 .28284 m
.74486 .28284 L
s
.74492 .27849 m
.74492 .27849 L
s
.745 .27955 m
.745 .27955 L
s
.74507 .28272 m
.74507 .28272 L
s
.74515 .28777 m
.74515 .28777 L
s
.74522 .29505 m
.74522 .29505 L
s
.7453 .30351 m
.7453 .30351 L
s
.74538 .30609 m
.74538 .30609 L
s
.74545 .30292 m
.74545 .30292 L
s
.74553 .29952 m
.74553 .29952 L
s
.7456 .29446 m
.7456 .29446 L
s
.74567 .30174 m
.74567 .30174 L
s
.74574 .29987 m
.74574 .29987 L
s
.74582 .30656 m
.74582 .30656 L
s
.74589 .31208 m
.74589 .31208 L
s
.74597 .31161 m
.74597 .31161 L
s
.74604 .31067 m
.74604 .31067 L
s
.74612 .31431 m
.74612 .31431 L
s
.74619 .3203 m
.74619 .3203 L
s
.74627 .32089 m
.74627 .32089 L
s
.74634 .32136 m
.74634 .32136 L
s
.74642 .327 m
.74642 .327 L
s
.74649 .3223 m
.74649 .3223 L
s
.74656 .32594 m
.74656 .32594 L
s
.74663 .33075 m
.74663 .33075 L
s
.74671 .3311 m
.74671 .3311 L
s
.74678 .32629 m
.74678 .32629 L
s
.74686 .32159 m
.74686 .32159 L
s
.74694 .32136 m
.74694 .32136 L
s
.74701 .32136 m
.74701 .32136 L
s
.74708 .32042 m
.74708 .32042 L
s
.74716 .32711 m
.74716 .32711 L
s
.74724 .32758 m
.74724 .32758 L
s
.74731 .32629 m
.74731 .32629 L
s
.74738 .32476 m
.74738 .32476 L
s
.74745 .32676 m
.74745 .32676 L
s
.74753 .32558 m
.74753 .32558 L
s
.7476 .32182 m
.7476 .32182 L
s
.74768 .31854 m
.74768 .31854 L
s
.74775 .32089 m
.74775 .32089 L
s
.74783 .32618 m
.74783 .32618 L
s
.7479 .32371 m
.7479 .32371 L
s
.74798 .3277 m
.74798 .3277 L
s
.74805 .32265 m
.74805 .32265 L
s
.74812 .323 m
.74812 .323 L
s
.74819 .32606 m
.74819 .32606 L
s
.74827 .31525 m
.74827 .31525 L
s
.74834 .31619 m
.74834 .31619 L
s
.74842 .30962 m
.74842 .30962 L
s
.7485 .30926 m
.7485 .30926 L
s
.74857 .30527 m
.74857 .30527 L
s
.74864 .30985 m
.74864 .30985 L
s
.74871 .30269 m
.74871 .30269 L
s
.74879 .30116 m
.74879 .30116 L
s
.74887 .30762 m
.74887 .30762 L
s
.74894 .31149 m
.74894 .31149 L
s
.74901 .31701 m
.74901 .31701 L
s
.74909 .31267 m
.74909 .31267 L
s
.74916 .31361 m
.74916 .31361 L
s
.74924 .31384 m
.74924 .31384 L
s
.74931 .31244 m
.74931 .31244 L
s
.74939 .31208 m
.74939 .31208 L
s
.74946 .31525 m
.74946 .31525 L
s
.74953 .31572 m
.74953 .31572 L
s
.74961 .31561 m
.74961 .31561 L
s
.74969 .3129 m
.74969 .3129 L
s
.74975 .31431 m
.74975 .31431 L
s
.74983 .30891 m
.74983 .30891 L
s
.7499 .31102 m
.7499 .31102 L
s
.74998 .3196 m
.74998 .3196 L
s
.75006 .32171 m
.75006 .32171 L
s
.75013 .32606 m
.75013 .32606 L
s
.75021 .32429 m
.75021 .32429 L
s
.75028 .3331 m
.75028 .3331 L
s
.75035 .33639 m
.75035 .33639 L
s
.75042 .33992 m
.75042 .33992 L
s
.7505 .34191 m
.7505 .34191 L
s
.75057 .34226 m
.75057 .34226 L
s
.75065 .34367 m
.75065 .34367 L
s
.75072 .34449 m
.75072 .34449 L
s
.7508 .34379 m
.7508 .34379 L
s
.75087 .34661 m
.75087 .34661 L
s
.75095 .35107 m
.75095 .35107 L
s
.75102 .35741 m
.75102 .35741 L
s
.75109 .35741 m
.75109 .35741 L
s
.75116 .36269 m
.75116 .36269 L
s
.75124 .36187 m
.75124 .36187 L
s
.75132 .35565 m
.75132 .35565 L
s
.75139 .35541 m
.75139 .35541 L
s
.75146 .35236 m
.75146 .35236 L
s
.75154 .35965 m
.75154 .35965 L
s
.75162 .36434 m
.75162 .36434 L
s
.75169 .36411 m
.75169 .36411 L
s
.75177 .35976 m
.75177 .35976 L
s
.75184 .36317 m
.75184 .36317 L
s
.75191 .36987 m
.75191 .36987 L
s
.75198 .36927 m
.75198 .36927 L
s
.75206 .37022 m
.75206 .37022 L
s
.75213 .37291 m
.75213 .37291 L
s
.75221 .37374 m
.75221 .37374 L
s
.75228 .37209 m
.75228 .37209 L
s
.75236 .36622 m
.75236 .36622 L
s
.75243 .35905 m
.75243 .35905 L
s
.75251 .36223 m
.75251 .36223 L
s
.75258 .36469 m
.75258 .36469 L
s
.75266 .36716 m
.75266 .36716 L
s
.75272 .37104 m
.75272 .37104 L
s
.7528 .37221 m
.7528 .37221 L
s
.75287 .37421 m
.75287 .37421 L
s
.75295 .37573 m
.75295 .37573 L
s
.75302 .37421 m
.75302 .37421 L
s
.7531 .37315 m
.7531 .37315 L
s
.75318 .37867 m
.75318 .37867 L
s
.75325 .37949 m
.75325 .37949 L
s
.75333 .38501 m
.75333 .38501 L
s
.7534 .38513 m
.7534 .38513 L
s
.75347 .38678 m
.75347 .38678 L
s
.75354 .38583 m
.75354 .38583 L
s
.75362 .38924 m
.75362 .38924 L
s
.75369 .39417 m
.75369 .39417 L
s
.75377 .39558 m
.75377 .39558 L
s
.75384 .39394 m
.75384 .39394 L
s
.75392 .39276 m
.75392 .39276 L
s
.75399 .39664 m
.75399 .39664 L
s
.75407 .39863 m
.75407 .39863 L
s
.75414 .39981 m
.75414 .39981 L
s
.75422 .39957 m
.75422 .39957 L
s
.75429 .39981 m
.75429 .39981 L
s
.75436 .40145 m
.75436 .40145 L
s
.75443 .41085 m
.75443 .41085 L
s
.75451 .41578 m
.75451 .41578 L
s
.75458 .41719 m
.75458 .41719 L
s
.75466 .41672 m
.75466 .41672 L
s
.75474 .42412 m
.75474 .42412 L
s
.75481 .42506 m
.75481 .42506 L
s
.75489 .41884 m
.75489 .41884 L
s
.75496 .41449 m
.75496 .41449 L
s
.75504 .4152 m
.75504 .4152 L
s
.75511 .41555 m
.75511 .41555 L
s
.75518 .42518 m
.75518 .42518 L
s
.75525 .43011 m
.75525 .43011 L
s
.75533 .43715 m
.75533 .43715 L
s
.7554 .43586 m
.7554 .43586 L
s
.75548 .43798 m
.75548 .43798 L
s
.75555 .44009 m
.75555 .44009 L
s
.75563 .43704 m
.75563 .43704 L
s
.7557 .44303 m
.7557 .44303 L
s
.75578 .44408 m
.75578 .44408 L
s
.75585 .44526 m
.75585 .44526 L
s
.75592 .44479 m
.75592 .44479 L
s
.75599 .44608 m
.75599 .44608 L
s
.75607 .44725 m
.75607 .44725 L
s
.75614 .44749 m
.75614 .44749 L
s
.75622 .44585 m
.75622 .44585 L
s
.7563 .44538 m
.7563 .44538 L
s
.75637 .44279 m
.75637 .44279 L
s
.75644 .44737 m
.75644 .44737 L
s
.75652 .44443 m
.75652 .44443 L
s
.7566 .45231 m
.7566 .45231 L
s
.75667 .45677 m
.75667 .45677 L
s
.75674 .45525 m
.75674 .45525 L
s
.75681 .45371 m
.75681 .45371 L
s
.75689 .44678 m
.75689 .44678 L
s
.75696 .4469 m
.75696 .4469 L
s
.75704 .4435 m
.75704 .4435 L
s
.75711 .4462 m
.75711 .4462 L
s
.75719 .44503 m
.75719 .44503 L
s
.75726 .44256 m
.75726 .44256 L
s
.75733 .44408 m
.75733 .44408 L
s
.75741 .4375 m
.75741 .4375 L
s
.75749 .44396 m
.75749 .44396 L
s
.75755 .44068 m
.75755 .44068 L
s
.75763 .43974 m
.75763 .43974 L
s
.7577 .44186 m
.7577 .44186 L
s
.75778 .44585 m
.75778 .44585 L
s
.75786 .44232 m
.75786 .44232 L
s
.75793 .44068 m
.75793 .44068 L
s
.75801 .44221 m
.75801 .44221 L
s
.75808 .44232 m
.75808 .44232 L
s
.75815 .43892 m
.75815 .43892 L
s
.75823 .44268 m
.75823 .44268 L
s
.7583 .44068 m
.7583 .44068 L
s
.75837 .43762 m
.75837 .43762 L
s
.75845 .44127 m
.75845 .44127 L
s
.75852 .43129 m
.75852 .43129 L
s
.7586 .42682 m
.7586 .42682 L
s
.75867 .43504 m
.75867 .43504 L
s
.75875 .43504 m
.75875 .43504 L
s
.75882 .4388 m
.75882 .4388 L
s
.75889 .43927 m
.75889 .43927 L
s
.75896 .44221 m
.75896 .44221 L
s
.75904 .44139 m
.75904 .44139 L
s
.75912 .43845 m
.75912 .43845 L
s
.75919 .4368 m
.75919 .4368 L
s
.75926 .44162 m
.75926 .44162 L
s
.75934 .4334 m
.75934 .4334 L
s
.75942 .44209 m
.75942 .44209 L
s
.75949 .44338 m
.75949 .44338 L
s
.75957 .4489 m
.75957 .4489 L
s
.75964 .45043 m
.75964 .45043 L
s
.75971 .45043 m
.75971 .45043 L
s
.75978 .45478 m
.75978 .45478 L
s
.75986 .45019 m
.75986 .45019 L
s
.75994 .46006 m
.75994 .46006 L
s
.76001 .46205 m
.76001 .46205 L
s
.76008 .46299 m
.76008 .46299 L
s
.76016 .4644 m
.76016 .4644 L
s
.76023 .46769 m
.76023 .46769 L
s
.76031 .46194 m
.76031 .46194 L
s
.76038 .46323 m
.76038 .46323 L
s
.76046 .46264 m
.76046 .46264 L
s
.76052 .46264 m
.76052 .46264 L
s
.7606 .46252 m
.7606 .46252 L
s
.76067 .46558 m
.76067 .46558 L
s
.76075 .4738 m
.76075 .4738 L
s
.76082 .47004 m
.76082 .47004 L
s
.7609 .46182 m
.7609 .46182 L
s
.76098 .46581 m
.76098 .46581 L
s
.76105 .46288 m
.76105 .46288 L
s
.76113 .459 m
.76113 .459 L
s
.7612 .46064 m
.7612 .46064 L
s
.76127 .46006 m
.76127 .46006 L
s
.76134 .45089 m
.76134 .45089 L
s
.76142 .45806 m
.76142 .45806 L
s
.76149 .45395 m
.76149 .45395 L
s
.76157 .45759 m
.76157 .45759 L
s
.76164 .45124 m
.76164 .45124 L
s
.76172 .45266 m
.76172 .45266 L
s
.76179 .4543 m
.76179 .4543 L
s
.76187 .45536 m
.76187 .45536 L
s
.76194 .45712 m
.76194 .45712 L
s
.76202 .4577 m
.76202 .4577 L
s
.76209 .45947 m
.76209 .45947 L
s
.76216 .45525 m
.76216 .45525 L
s
.76223 .45665 m
.76223 .45665 L
s
.76231 .44996 m
.76231 .44996 L
s
.76238 .44655 m
.76238 .44655 L
s
.76246 .45254 m
.76246 .45254 L
s
.76254 .45806 m
.76254 .45806 L
s
.76261 .45572 m
.76261 .45572 L
s
.76269 .45865 m
.76269 .45865 L
s
.76276 .45572 m
.76276 .45572 L
s
.76284 .45595 m
.76284 .45595 L
s
.76291 .46252 m
.76291 .46252 L
s
.76298 .46628 m
.76298 .46628 L
s
.76305 .46699 m
.76305 .46699 L
s
.76313 .46922 m
.76313 .46922 L
s
.7632 .47908 m
.7632 .47908 L
s
.76328 .4792 m
.76328 .4792 L
s
.76335 .47544 m
.76335 .47544 L
s
.76343 .47485 m
.76343 .47485 L
s
.7635 .47473 m
.7635 .47473 L
s
.76358 .48014 m
.76358 .48014 L
s
.76365 .47932 m
.76365 .47932 L
s
.76372 .47697 m
.76372 .47697 L
s
.76379 .47251 m
.76379 .47251 L
s
.76387 .4738 m
.76387 .4738 L
s
.76394 .46652 m
.76394 .46652 L
s
.76402 .46523 m
.76402 .46523 L
s
.7641 .47403 m
.7641 .47403 L
s
.76417 .47627 m
.76417 .47627 L
s
.76424 .48296 m
.76424 .48296 L
s
.76432 .48483 m
.76432 .48483 L
s
.7644 .48695 m
.7644 .48695 L
s
.76447 .4893 m
.76447 .4893 L
s
.76454 .48777 m
.76454 .48777 L
s
.76461 .49012 m
.76461 .49012 L
s
.76469 .49388 m
.76469 .49388 L
s
.76476 .48884 m
.76476 .48884 L
s
.76484 .48378 m
.76484 .48378 L
s
.76491 .48226 m
.76491 .48226 L
s
.76499 .48273 m
.76499 .48273 L
s
.76506 .48636 m
.76506 .48636 L
s
.76514 .48812 m
.76514 .48812 L
s
.76521 .48413 m
.76521 .48413 L
s
.76529 .47908 m
.76529 .47908 L
s
.76535 .48084 m
.76535 .48084 L
s
.76543 .47415 m
.76543 .47415 L
s
.7655 .47228 m
.7655 .47228 L
s
.76558 .46699 m
.76558 .46699 L
s
.76566 .46346 m
.76566 .46346 L
s
.76573 .45982 m
.76573 .45982 L
s
.76581 .45407 m
.76581 .45407 L
s
.76588 .459 m
.76588 .459 L
s
.76595 .45196 m
.76595 .45196 L
s
.76603 .45184 m
.76603 .45184 L
s
.7661 .45453 m
.7661 .45453 L
s
.76617 .46252 m
.76617 .46252 L
s
.76625 .46053 m
.76625 .46053 L
s
.76632 .46593 m
.76632 .46593 L
s
.7664 .46393 m
.7664 .46393 L
s
.76647 .46288 m
.76647 .46288 L
s
.76655 .45842 m
.76655 .45842 L
s
.76662 .45089 m
.76662 .45089 L
s
.76669 .4489 m
.76669 .4489 L
s
.76677 .45478 m
.76677 .45478 L
s
.76685 .46241 m
.76685 .46241 L
s
.76692 .45723 m
.76692 .45723 L
s
.76699 .44984 m
.76699 .44984 L
s
.76706 .45066 m
.76706 .45066 L
s
.76714 .45525 m
.76714 .45525 L
s
.76722 .45641 m
.76722 .45641 L
s
.76729 .44937 m
.76729 .44937 L
s
.76737 .44972 m
.76737 .44972 L
s
.76744 .44632 m
.76744 .44632 L
s
.76751 .4435 m
.76751 .4435 L
s
.76758 .43822 m
.76758 .43822 L
s
.76766 .44373 m
.76766 .44373 L
s
.76774 .43152 m
.76774 .43152 L
s
.76781 .43211 m
.76781 .43211 L
s
.76788 .42964 m
.76788 .42964 L
s
.76796 .43551 m
.76796 .43551 L
s
.76803 .43293 m
.76803 .43293 L
s
.76811 .43633 m
.76811 .43633 L
s
.76818 .43386 m
.76818 .43386 L
s
.76826 .43269 m
.76826 .43269 L
s
.76832 .43375 m
.76832 .43375 L
s
.7684 .43551 m
.7684 .43551 L
s
.76847 .43528 m
.76847 .43528 L
s
.76855 .42835 m
.76855 .42835 L
s
.76862 .42987 m
.76862 .42987 L
s
.7687 .43386 m
.7687 .43386 L
s
.76878 .43386 m
.76878 .43386 L
s
.76885 .43164 m
.76885 .43164 L
s
.76893 .4388 m
.76893 .4388 L
s
.769 .44279 m
.769 .44279 L
s
.76907 .44468 m
.76907 .44468 L
s
.76914 .44491 m
.76914 .44491 L
s
.76922 .45207 m
.76922 .45207 L
s
.76929 .45266 m
.76929 .45266 L
s
.76937 .44021 m
.76937 .44021 L
s
.76944 .43833 m
.76944 .43833 L
s
.76952 .4368 m
.76952 .4368 L
s
.76959 .43386 m
.76959 .43386 L
s
.76967 .43199 m
.76967 .43199 L
s
.76974 .42788 m
.76974 .42788 L
s
.76982 .43293 m
.76982 .43293 L
s
.76989 .43363 m
.76989 .43363 L
s
.76996 .42353 m
.76996 .42353 L
s
.77003 .42236 m
.77003 .42236 L
s
.77011 .42248 m
.77011 .42248 L
s
.77018 .42259 m
.77018 .42259 L
s
.77026 .42424 m
.77026 .42424 L
s
.77034 .42107 m
.77034 .42107 L
s
.77041 .42518 m
.77041 .42518 L
s
.77049 .42541 m
.77049 .42541 L
s
.77056 .42658 m
.77056 .42658 L
s
.77064 .42588 m
.77064 .42588 L
s
.77071 .42506 m
.77071 .42506 L
s
.77078 .42424 m
.77078 .42424 L
s
.77085 .426 m
.77085 .426 L
s
.77093 .42283 m
.77093 .42283 L
s
.771 .43058 m
.771 .43058 L
s
.77108 .42964 m
.77108 .42964 L
s
.77115 .42976 m
.77115 .42976 L
s
.77123 .43011 m
.77123 .43011 L
s
.7713 .42847 m
.7713 .42847 L
s
.77138 .42459 m
.77138 .42459 L
s
.77145 .42964 m
.77145 .42964 L
s
.77152 .42658 m
.77152 .42658 L
s
.77159 .42694 m
.77159 .42694 L
s
.77167 .42436 m
.77167 .42436 L
s
.77174 .43316 m
.77174 .43316 L
s
.77182 .43187 m
.77182 .43187 L
s
.7719 .42448 m
.7719 .42448 L
s
.77197 .42236 m
.77197 .42236 L
s
.77205 .42776 m
.77205 .42776 L
s
.77212 .42917 m
.77212 .42917 L
s
.7722 .43422 m
.7722 .43422 L
s
.77227 .43152 m
.77227 .43152 L
s
.77234 .43117 m
.77234 .43117 L
s
.77241 .43234 m
.77241 .43234 L
s
.77249 .43351 m
.77249 .43351 L
s
.77256 .44021 m
.77256 .44021 L
s
.77264 .44432 m
.77264 .44432 L
s
.77271 .44456 m
.77271 .44456 L
s
.77279 .44432 m
.77279 .44432 L
s
.77286 .44396 m
.77286 .44396 L
s
.77294 .43857 m
.77294 .43857 L
s
.77301 .44209 m
.77301 .44209 L
s
.77309 .44244 m
.77309 .44244 L
s
.77315 .44044 m
.77315 .44044 L
s
.77323 .43762 m
.77323 .43762 L
s
.7733 .44361 m
.7733 .44361 L
s
.77338 .4455 m
.77338 .4455 L
s
.77346 .44643 m
.77346 .44643 L
s
.77353 .46029 m
.77353 .46029 L
s
.77361 .46217 m
.77361 .46217 L
s
.77368 .45971 m
.77368 .45971 L
s
.77375 .45677 m
.77375 .45677 L
s
.77383 .45641 m
.77383 .45641 L
s
.77391 .45254 m
.77391 .45254 L
s
.77397 .45478 m
.77397 .45478 L
s
.77405 .45289 m
.77405 .45289 L
s
.77412 .45324 m
.77412 .45324 L
s
.7742 .45501 m
.7742 .45501 L
s
.77427 .45242 m
.77427 .45242 L
s
.77435 .45618 m
.77435 .45618 L
s
.77442 .45935 m
.77442 .45935 L
s
.77449 .4617 m
.77449 .4617 L
s
.77457 .46511 m
.77457 .46511 L
s
.77465 .45688 m
.77465 .45688 L
s
.77472 .4664 m
.77472 .4664 L
s
.77479 .46558 m
.77479 .46558 L
s
.77486 .46029 m
.77486 .46029 L
s
.77494 .4543 m
.77494 .4543 L
s
.77502 .45513 m
.77502 .45513 L
s
.77509 .45407 m
.77509 .45407 L
s
.77517 .44984 m
.77517 .44984 L
s
.77524 .45031 m
.77524 .45031 L
s
.77531 .45008 m
.77531 .45008 L
s
.77538 .45525 m
.77538 .45525 L
s
.77546 .45759 m
.77546 .45759 L
s
.77554 .45313 m
.77554 .45313 L
s
.77561 .44585 m
.77561 .44585 L
s
.77568 .45242 m
.77568 .45242 L
s
.77576 .45113 m
.77576 .45113 L
s
.77583 .4556 m
.77583 .4556 L
s
.77591 .45818 m
.77591 .45818 L
s
.77598 .45501 m
.77598 .45501 L
s
.77606 .45489 m
.77606 .45489 L
s
.77612 .45782 m
.77612 .45782 L
s
.7762 .45759 m
.7762 .45759 L
s
.77628 .45383 m
.77628 .45383 L
s
.77635 .45149 m
.77635 .45149 L
s
.77642 .44643 m
.77642 .44643 L
s
.7765 .45254 m
.7765 .45254 L
s
.77658 .45525 m
.77658 .45525 L
s
.77665 .44961 m
.77665 .44961 L
s
.77673 .44937 m
.77673 .44937 L
s
.7768 .44585 m
.7768 .44585 L
s
.77688 .45124 m
.77688 .45124 L
s
.77694 .45572 m
.77694 .45572 L
s
.77702 .45383 m
.77702 .45383 L
s
.7771 .45548 m
.7771 .45548 L
s
.77717 .44996 m
.77717 .44996 L
s
.77724 .44443 m
.77724 .44443 L
s
.77732 .44796 m
.77732 .44796 L
s
.77739 .45313 m
.77739 .45313 L
s
.77747 .44996 m
.77747 .44996 L
s
.77754 .45019 m
.77754 .45019 L
s
.77762 .45688 m
.77762 .45688 L
s
.77769 .45971 m
.77769 .45971 L
s
.77776 .46135 m
.77776 .46135 L
s
.77783 .46017 m
.77783 .46017 L
s
.77791 .46558 m
.77791 .46558 L
s
.77798 .46875 m
.77798 .46875 L
s
.77806 .46664 m
.77806 .46664 L
s
.77814 .4678 m
.77814 .4678 L
s
.77821 .47791 m
.77821 .47791 L
s
.77829 .48096 m
.77829 .48096 L
s
.77836 .48096 m
.77836 .48096 L
s
.77844 .47756 m
.77844 .47756 L
s
.77851 .47473 m
.77851 .47473 L
s
.77858 .47544 m
.77858 .47544 L
s
.77865 .47673 m
.77865 .47673 L
s
.77873 .46558 m
.77873 .46558 L
s
.7788 .46323 m
.7788 .46323 L
s
.77888 .4657 m
.77888 .4657 L
s
.77895 .46746 m
.77895 .46746 L
s
.77903 .46875 m
.77903 .46875 L
s
.7791 .47051 m
.7791 .47051 L
s
.77918 .4637 m
.77918 .4637 L
s
.77925 .46628 m
.77925 .46628 L
s
.77932 .46205 m
.77932 .46205 L
s
.77939 .45453 m
.77939 .45453 L
s
.77947 .45606 m
.77947 .45606 L
s
.77954 .45818 m
.77954 .45818 L
s
.77962 .45982 m
.77962 .45982 L
s
.7797 .45395 m
.7797 .45395 L
s
.77977 .45031 m
.77977 .45031 L
s
.77985 .44772 m
.77985 .44772 L
s
.77992 .44209 m
.77992 .44209 L
s
.78 .45054 m
.78 .45054 L
s
.78007 .45395 m
.78007 .45395 L
s
.78014 .45124 m
.78014 .45124 L
s
.78021 .45254 m
.78021 .45254 L
s
.78029 .4455 m
.78029 .4455 L
s
.78036 .4435 m
.78036 .4435 L
s
.78044 .44326 m
.78044 .44326 L
s
.78051 .43986 m
.78051 .43986 L
s
.78059 .44197 m
.78059 .44197 L
s
.78066 .44032 m
.78066 .44032 L
s
.78074 .4381 m
.78074 .4381 L
s
.78081 .4442 m
.78081 .4442 L
s
.78089 .44268 m
.78089 .44268 L
s
.78095 .44103 m
.78095 .44103 L
s
.78103 .43386 m
.78103 .43386 L
s
.7811 .43434 m
.7811 .43434 L
s
.78118 .424 m
.78118 .424 L
s
.78126 .42201 m
.78126 .42201 L
s
.78133 .41837 m
.78133 .41837 L
s
.78141 .41825 m
.78141 .41825 L
s
.78148 .4193 m
.78148 .4193 L
s
.78156 .4193 m
.78156 .4193 L
s
.78163 .4186 m
.78163 .4186 L
s
.78171 .4132 m
.78171 .4132 L
s
.78177 .41366 m
.78177 .41366 L
s
.78185 .41813 m
.78185 .41813 L
s
.78192 .41438 m
.78192 .41438 L
s
.782 .41602 m
.782 .41602 L
s
.78207 .41402 m
.78207 .41402 L
s
.78215 .41402 m
.78215 .41402 L
s
.78222 .41426 m
.78222 .41426 L
s
.78229 .41625 m
.78229 .41625 L
s
.78237 .41872 m
.78237 .41872 L
s
.78245 .41637 m
.78245 .41637 L
s
.78252 .41366 m
.78252 .41366 L
s
.78259 .41672 m
.78259 .41672 L
s
.78266 .41602 m
.78266 .41602 L
s
.78274 .41214 m
.78274 .41214 L
s
.78282 .41743 m
.78282 .41743 L
s
.78289 .41848 m
.78289 .41848 L
s
.78297 .41731 m
.78297 .41731 L
s
.78304 .42565 m
.78304 .42565 L
s
.78311 .42212 m
.78311 .42212 L
s
.78319 .42541 m
.78319 .42541 L
s
.78327 .42259 m
.78327 .42259 L
s
.78334 .41884 m
.78334 .41884 L
s
.78341 .41602 m
.78341 .41602 L
s
.78348 .41414 m
.78348 .41414 L
s
.78356 .41602 m
.78356 .41602 L
s
.78363 .41179 m
.78363 .41179 L
s
.78371 .41813 m
.78371 .41813 L
s
.78378 .41648 m
.78378 .41648 L
s
.78386 .41766 m
.78386 .41766 L
s
.78392 .4193 m
.78392 .4193 L
s
.78401 .42212 m
.78401 .42212 L
s
.78408 .42448 m
.78408 .42448 L
s
.78415 .42376 m
.78415 .42376 L
s
.78422 .42541 m
.78422 .42541 L
s
.7843 .43868 m
.7843 .43868 L
s
.78438 .43962 m
.78438 .43962 L
s
.78445 .44808 m
.78445 .44808 L
s
.78453 .44902 m
.78453 .44902 L
s
.7846 .44396 m
.7846 .44396 L
s
.78468 .44678 m
.78468 .44678 L
s
.78474 .44408 m
.78474 .44408 L
s
.78482 .44678 m
.78482 .44678 L
s
.7849 .45077 m
.7849 .45077 L
s
.78497 .44855 m
.78497 .44855 L
s
.78504 .44491 m
.78504 .44491 L
s
.78512 .44479 m
.78512 .44479 L
s
.78519 .44714 m
.78519 .44714 L
s
.78527 .44961 m
.78527 .44961 L
s
.78534 .44996 m
.78534 .44996 L
s
.78542 .45066 m
.78542 .45066 L
s
.78549 .45231 m
.78549 .45231 L
s
.78556 .45548 m
.78556 .45548 L
s
.78564 .46017 m
.78564 .46017 L
s
.78571 .46416 m
.78571 .46416 L
s
.78579 .46416 m
.78579 .46416 L
s
.78586 .47051 m
.78586 .47051 L
s
.78594 .47309 m
.78594 .47309 L
s
.78601 .47544 m
.78601 .47544 L
s
.78609 .47251 m
.78609 .47251 L
s
.78616 .48002 m
.78616 .48002 L
s
.78624 .47873 m
.78624 .47873 L
s
.78631 .47861 m
.78631 .47861 L
s
.78638 .47744 m
.78638 .47744 L
s
.78645 .47603 m
.78645 .47603 L
s
.78653 .48108 m
.78653 .48108 L
s
.7866 .48214 m
.7866 .48214 L
s
.78668 .48049 m
.78668 .48049 L
s
.78675 .48014 m
.78675 .48014 L
s
.78683 .48131 m
.78683 .48131 L
s
.7869 .47204 m
.7869 .47204 L
s
.78698 .46969 m
.78698 .46969 L
s
.78705 .46945 m
.78705 .46945 L
s
.78712 .46722 m
.78712 .46722 L
s
.78719 .46159 m
.78719 .46159 L
s
.78727 .46664 m
.78727 .46664 L
s
.78734 .46969 m
.78734 .46969 L
s
.78742 .46652 m
.78742 .46652 L
s
.7875 .46241 m
.7875 .46241 L
s
.78757 .45888 m
.78757 .45888 L
s
.78765 .46652 m
.78765 .46652 L
s
.78772 .46757 m
.78772 .46757 L
s
.7878 .46241 m
.7878 .46241 L
s
.78787 .45924 m
.78787 .45924 L
s
.78794 .46628 m
.78794 .46628 L
s
.78801 .46252 m
.78801 .46252 L
s
.78809 .46628 m
.78809 .46628 L
s
.78816 .46699 m
.78816 .46699 L
s
.78824 .46488 m
.78824 .46488 L
s
.78831 .46135 m
.78831 .46135 L
s
.78839 .45618 m
.78839 .45618 L
s
.78846 .45818 m
.78846 .45818 L
s
.78854 .46499 m
.78854 .46499 L
s
.78861 .46722 m
.78861 .46722 L
s
.78869 .46628 m
.78869 .46628 L
s
.78876 .4678 m
.78876 .4678 L
s
.78883 .46815 m
.78883 .46815 L
s
.7889 .46182 m
.7889 .46182 L
s
.78898 .45888 m
.78898 .45888 L
s
.78906 .46535 m
.78906 .46535 L
s
.78913 .46135 m
.78913 .46135 L
s
.78921 .45618 m
.78921 .45618 L
s
.78928 .4543 m
.78928 .4543 L
s
.78936 .44749 m
.78936 .44749 L
s
.78943 .44256 m
.78943 .44256 L
s
.78951 .44091 m
.78951 .44091 L
s
.78957 .44585 m
.78957 .44585 L
s
.78965 .44115 m
.78965 .44115 L
s
.78972 .43598 m
.78972 .43598 L
s
.7898 .43386 m
.7898 .43386 L
s
.78987 .43129 m
.78987 .43129 L
s
.78995 .43551 m
.78995 .43551 L
s
.79002 .43246 m
.79002 .43246 L
s
.7901 .43575 m
.7901 .43575 L
s
.79017 .43645 m
.79017 .43645 L
s
.79025 .43692 m
.79025 .43692 L
s
.79032 .44221 m
.79032 .44221 L
s
.79039 .43997 m
.79039 .43997 L
s
.79046 .44021 m
.79046 .44021 L
s
.79054 .44115 m
.79054 .44115 L
s
.79062 .44361 m
.79062 .44361 L
s
.79069 .4361 m
.79069 .4361 L
s
.79077 .43081 m
.79077 .43081 L
s
.79084 .42894 m
.79084 .42894 L
s
.79091 .426 m
.79091 .426 L
s
.79099 .42541 m
.79099 .42541 L
s
.79107 .428 m
.79107 .428 L
s
.79114 .42765 m
.79114 .42765 L
s
.79121 .42835 m
.79121 .42835 L
s
.79128 .42448 m
.79128 .42448 L
s
.79136 .42576 m
.79136 .42576 L
s
.79143 .424 m
.79143 .424 L
s
.79151 .43504 m
.79151 .43504 L
s
.79158 .4341 m
.79158 .4341 L
s
.79166 .42776 m
.79166 .42776 L
s
.79173 .42518 m
.79173 .42518 L
s
.79181 .42929 m
.79181 .42929 L
s
.79188 .42635 m
.79188 .42635 L
s
.79195 .42365 m
.79195 .42365 L
s
.79202 .42001 m
.79202 .42001 L
s
.7921 .42306 m
.7921 .42306 L
s
.79218 .42506 m
.79218 .42506 L
s
.79225 .42024 m
.79225 .42024 L
s
.79233 .42212 m
.79233 .42212 L
s
.7924 .42072 m
.7924 .42072 L
s
.79248 .42107 m
.79248 .42107 L
s
.79254 .41919 m
.79254 .41919 L
s
.79262 .41355 m
.79262 .41355 L
s
.7927 .41097 m
.7927 .41097 L
s
.79277 .40897 m
.79277 .40897 L
s
.79284 .41378 m
.79284 .41378 L
s
.79292 .41331 m
.79292 .41331 L
s
.79299 .41625 m
.79299 .41625 L
s
.79307 .42154 m
.79307 .42154 L
s
.79314 .42095 m
.79314 .42095 L
s
.79322 .426 m
.79322 .426 L
s
.79329 .42506 m
.79329 .42506 L
s
.79336 .42788 m
.79336 .42788 L
s
.79344 .42119 m
.79344 .42119 L
s
.79352 .42987 m
.79352 .42987 L
s
.79359 .42448 m
.79359 .42448 L
s
.79366 .4193 m
.79366 .4193 L
s
.79374 .41414 m
.79374 .41414 L
s
.79381 .41109 m
.79381 .41109 L
s
.79389 .41202 m
.79389 .41202 L
s
.79396 .41014 m
.79396 .41014 L
s
.79404 .40239 m
.79404 .40239 L
s
.79411 .41085 m
.79411 .41085 L
s
.79418 .41414 m
.79418 .41414 L
s
.79425 .41167 m
.79425 .41167 L
s
.79433 .41167 m
.79433 .41167 L
s
.7944 .41496 m
.7944 .41496 L
s
.79448 .41648 m
.79448 .41648 L
s
.79455 .41625 m
.79455 .41625 L
s
.79463 .41578 m
.79463 .41578 L
s
.7947 .4159 m
.7947 .4159 L
s
.79478 .41461 m
.79478 .41461 L
s
.79485 .42635 m
.79485 .42635 L
s
.79492 .42388 m
.79492 .42388 L
s
.79499 .42236 m
.79499 .42236 L
s
.79507 .42271 m
.79507 .42271 L
s
.79515 .41966 m
.79515 .41966 L
s
.79522 .4233 m
.79522 .4233 L
s
.7953 .42553 m
.7953 .42553 L
s
.79537 .42847 m
.79537 .42847 L
s
.79545 .43058 m
.79545 .43058 L
s
.79552 .42705 m
.79552 .42705 L
s
.7956 .426 m
.7956 .426 L
s
.79567 .42765 m
.79567 .42765 L
s
.79574 .42647 m
.79574 .42647 L
s
.79581 .42224 m
.79581 .42224 L
s
.79589 .42565 m
.79589 .42565 L
s
.79596 .4274 m
.79596 .4274 L
s
.79604 .42729 m
.79604 .42729 L
s
.79611 .4287 m
.79611 .4287 L
s
.79619 .42929 m
.79619 .42929 L
s
.79626 .428 m
.79626 .428 L
s
.79634 .42541 m
.79634 .42541 L
s
.79641 .4253 m
.79641 .4253 L
s
.79649 .41884 m
.79649 .41884 L
s
.79656 .42294 m
.79656 .42294 L
s
.79663 .42424 m
.79663 .42424 L
s
.7967 .4152 m
.7967 .4152 L
s
.79678 .41366 m
.79678 .41366 L
s
.79686 .41261 m
.79686 .41261 L
s
.79693 .41191 m
.79693 .41191 L
s
.79701 .4078 m
.79701 .4078 L
s
.79708 .40392 m
.79708 .40392 L
s
.79716 .40627 m
.79716 .40627 L
s
.79723 .4031 m
.79723 .4031 L
s
.79731 .40721 m
.79731 .40721 L
s
.79737 .40545 m
.79737 .40545 L
s
.79745 .4031 m
.79745 .4031 L
s
.79752 .40368 m
.79752 .40368 L
s
.7976 .40016 m
.7976 .40016 L
s
.79767 .40356 m
.79767 .40356 L
s
.79775 .40169 m
.79775 .40169 L
s
.79782 .39957 m
.79782 .39957 L
s
.7979 .40099 m
.7979 .40099 L
s
.79797 .40451 m
.79797 .40451 L
s
.79805 .39945 m
.79805 .39945 L
s
.79812 .40052 m
.79812 .40052 L
s
.79819 .40521 m
.79819 .40521 L
s
.79826 .40956 m
.79826 .40956 L
s
.79834 .41002 m
.79834 .41002 L
s
.79842 .40685 m
.79842 .40685 L
s
.79849 .40991 m
.79849 .40991 L
s
.79857 .40556 m
.79857 .40556 L
s
.79864 .41226 m
.79864 .41226 L
s
.79872 .41155 m
.79872 .41155 L
s
.79879 .41637 m
.79879 .41637 L
s
.79887 .41484 m
.79887 .41484 L
s
.79894 .41672 m
.79894 .41672 L
s
.79901 .42142 m
.79901 .42142 L
s
.79908 .426 m
.79908 .426 L
s
.79916 .42682 m
.79916 .42682 L
s
.79923 .43281 m
.79923 .43281 L
s
.79931 .42658 m
.79931 .42658 L
s
.79938 .42353 m
.79938 .42353 L
s
.79946 .41766 m
.79946 .41766 L
s
.79953 .42024 m
.79953 .42024 L
s
.79961 .41343 m
.79961 .41343 L
s
.79968 .41426 m
.79968 .41426 L
s
.79975 .41473 m
.79975 .41473 L
s
.79982 .41402 m
.79982 .41402 L
s
.7999 .41508 m
.7999 .41508 L
s
.79998 .40697 m
.79998 .40697 L
s
.80005 .40216 m
.80005 .40216 L
s
.80013 .39863 m
.80013 .39863 L
s
.8002 .39735 m
.8002 .39735 L
s
.80028 .40356 m
.80028 .40356 L
s
.80035 .39875 m
.80035 .39875 L
s
.80043 .39723 m
.80043 .39723 L
s
.8005 .39323 m
.8005 .39323 L
s
.80057 .3903 m
.80057 .3903 L
s
.80064 .39323 m
.80064 .39323 L
s
.80072 .39264 m
.80072 .39264 L
s
.80079 .39323 m
.80079 .39323 L
s
.80087 .39264 m
.80087 .39264 L
s
.80094 .38583 m
.80094 .38583 L
s
.80102 .39276 m
.80102 .39276 L
s
.80109 .39652 m
.80109 .39652 L
s
.80116 .39605 m
.80116 .39605 L
s
.80124 .40122 m
.80124 .40122 L
s
.80132 .40416 m
.80132 .40416 L
s
.80139 .40498 m
.80139 .40498 L
s
.80146 .40979 m
.80146 .40979 L
s
.80154 .40944 m
.80154 .40944 L
s
.80161 .4078 m
.80161 .4078 L
s
.80169 .41461 m
.80169 .41461 L
s
.80176 .41531 m
.80176 .41531 L
s
.80184 .41202 m
.80184 .41202 L
s
.80191 .41249 m
.80191 .41249 L
s
.80198 .40909 m
.80198 .40909 L
s
.80206 .40615 m
.80206 .40615 L
s
.80214 .39758 m
.80214 .39758 L
s
.8022 .4011 m
.8022 .4011 L
s
.80228 .3964 m
.80228 .3964 L
s
.80235 .39793 m
.80235 .39793 L
s
.80243 .39863 m
.80243 .39863 L
s
.8025 .3991 m
.8025 .3991 L
s
.80258 .39628 m
.80258 .39628 L
s
.80265 .39346 m
.80265 .39346 L
s
.80272 .39711 m
.80272 .39711 L
s
.80279 .39723 m
.80279 .39723 L
s
.80287 .39288 m
.80287 .39288 L
s
.80295 .39417 m
.80295 .39417 L
s
.80302 .39464 m
.80302 .39464 L
s
.8031 .39969 m
.8031 .39969 L
s
.80317 .39077 m
.80317 .39077 L
s
.80325 .39065 m
.80325 .39065 L
s
.80332 .38877 m
.80332 .38877 L
s
.8034 .38571 m
.8034 .38571 L
s
.80347 .37949 m
.80347 .37949 L
s
.80354 .37608 m
.80354 .37608 L
s
.80361 .37914 m
.80361 .37914 L
s
.80369 .38548 m
.80369 .38548 L
s
.80377 .37867 m
.80377 .37867 L
s
.80384 .38079 m
.80384 .38079 L
s
.80391 .38384 m
.80391 .38384 L
s
.80399 .38795 m
.80399 .38795 L
s
.80406 .38713 m
.80406 .38713 L
s
.80414 .38924 m
.80414 .38924 L
s
.80421 .38384 m
.80421 .38384 L
s
.80429 .38618 m
.80429 .38618 L
s
.80436 .39182 m
.80436 .39182 L
s
.80443 .38736 m
.80443 .38736 L
s
.8045 .3863 m
.8045 .3863 L
s
.80458 .38924 m
.80458 .38924 L
s
.80466 .38771 m
.80466 .38771 L
s
.80473 .39159 m
.80473 .39159 L
s
.80481 .39675 m
.80481 .39675 L
s
.80488 .40381 m
.80488 .40381 L
s
.80496 .40533 m
.80496 .40533 L
s
.80503 .40615 m
.80503 .40615 L
s
.80511 .40474 m
.80511 .40474 L
s
.80517 .40463 m
.80517 .40463 L
s
.80525 .40545 m
.80525 .40545 L
s
.80532 .40897 m
.80532 .40897 L
s
.8054 .40674 m
.8054 .40674 L
s
.80547 .4092 m
.80547 .4092 L
s
.80555 .4092 m
.80555 .4092 L
s
.80562 .4078 m
.80562 .4078 L
s
.8057 .40827 m
.8057 .40827 L
s
.80577 .40204 m
.80577 .40204 L
s
.80585 .40356 m
.80585 .40356 L
s
.80592 .40321 m
.80592 .40321 L
s
.80599 .39934 m
.80599 .39934 L
s
.80606 .40063 m
.80606 .40063 L
s
.80614 .40709 m
.80614 .40709 L
s
.80622 .40838 m
.80622 .40838 L
s
.80629 .41167 m
.80629 .41167 L
s
.80637 .41813 m
.80637 .41813 L
s
.80644 .4132 m
.80644 .4132 L
s
.80652 .42024 m
.80652 .42024 L
s
.80659 .41461 m
.80659 .41461 L
s
.80667 .41825 m
.80667 .41825 L
s
.80674 .42001 m
.80674 .42001 L
s
.80681 .42283 m
.80681 .42283 L
s
.80688 .42341 m
.80688 .42341 L
s
.80696 .42776 m
.80696 .42776 L
s
.80703 .42271 m
.80703 .42271 L
s
.80711 .41837 m
.80711 .41837 L
s
.80718 .41508 m
.80718 .41508 L
s
.80726 .42189 m
.80726 .42189 L
s
.80733 .42541 m
.80733 .42541 L
s
.80741 .42682 m
.80741 .42682 L
s
.80748 .43293 m
.80748 .43293 L
s
.80755 .43586 m
.80755 .43586 L
s
.80762 .43375 m
.80762 .43375 L
s
.8077 .43328 m
.8077 .43328 L
s
.80778 .43398 m
.80778 .43398 L
s
.80785 .42905 m
.80785 .42905 L
s
.80793 .4253 m
.80793 .4253 L
s
.808 .43022 m
.808 .43022 L
s
.80808 .42658 m
.80808 .42658 L
s
.80815 .428 m
.80815 .428 L
s
.80823 .43211 m
.80823 .43211 L
s
.8083 .43034 m
.8083 .43034 L
s
.80837 .42376 m
.80837 .42376 L
s
.80844 .42095 m
.80844 .42095 L
s
.80852 .42376 m
.80852 .42376 L
s
.80859 .42553 m
.80859 .42553 L
s
.80867 .42201 m
.80867 .42201 L
s
.80874 .42318 m
.80874 .42318 L
s
.80882 .42189 m
.80882 .42189 L
s
.80889 .42095 m
.80889 .42095 L
s
.80897 .41954 m
.80897 .41954 L
s
.80904 .42154 m
.80904 .42154 L
s
.80912 .42353 m
.80912 .42353 L
s
.80919 .4314 m
.80919 .4314 L
s
.80926 .42353 m
.80926 .42353 L
s
.80934 .43034 m
.80934 .43034 L
s
.80941 .4334 m
.80941 .4334 L
s
.80949 .43129 m
.80949 .43129 L
s
.80956 .43234 m
.80956 .43234 L
s
.80964 .43129 m
.80964 .43129 L
s
.80971 .43739 m
.80971 .43739 L
s
.80978 .43528 m
.80978 .43528 L
s
.80986 .43598 m
.80986 .43598 L
s
.80994 .43258 m
.80994 .43258 L
s
.81 .42576 m
.81 .42576 L
s
.81008 .42717 m
.81008 .42717 L
s
.81015 .42459 m
.81015 .42459 L
s
.81023 .42494 m
.81023 .42494 L
s
.8103 .42847 m
.8103 .42847 L
s
.81038 .43269 m
.81038 .43269 L
s
.81045 .43152 m
.81045 .43152 L
s
.81052 .43293 m
.81052 .43293 L
s
.8106 .42847 m
.8106 .42847 L
s
.81068 .42072 m
.81068 .42072 L
s
.81075 .41813 m
.81075 .41813 L
s
.81082 .4132 m
.81082 .4132 L
s
.8109 .41766 m
.8109 .41766 L
s
.81097 .42072 m
.81097 .42072 L
s
.81105 .42107 m
.81105 .42107 L
s
.81112 .41625 m
.81112 .41625 L
s
.8112 .41391 m
.8112 .41391 L
s
.81127 .41378 m
.81127 .41378 L
s
.81134 .41813 m
.81134 .41813 L
s
.81141 .42048 m
.81141 .42048 L
s
.81149 .42024 m
.81149 .42024 L
s
.81157 .41872 m
.81157 .41872 L
s
.81164 .4159 m
.81164 .4159 L
s
.81171 .40791 m
.81171 .40791 L
s
.81179 .40944 m
.81179 .40944 L
s
.81186 .40685 m
.81186 .40685 L
s
.81194 .40416 m
.81194 .40416 L
s
.81201 .40615 m
.81201 .40615 L
s
.81209 .4051 m
.81209 .4051 L
s
.81216 .40592 m
.81216 .40592 L
s
.81223 .40533 m
.81223 .40533 L
s
.81231 .39241 m
.81231 .39241 L
s
.81239 .38971 m
.81239 .38971 L
s
.81246 .38959 m
.81246 .38959 L
s
.81253 .38114 m
.81253 .38114 L
s
.81261 .38254 m
.81261 .38254 L
s
.81268 .38678 m
.81268 .38678 L
s
.81276 .38713 m
.81276 .38713 L
s
.81283 .38513 m
.81283 .38513 L
s
.81291 .38454 m
.81291 .38454 L
s
.81297 .38689 m
.81297 .38689 L
s
.81305 .38853 m
.81305 .38853 L
s
.81312 .38337 m
.81312 .38337 L
s
.8132 .38865 m
.8132 .38865 L
s
.81327 .38924 m
.81327 .38924 L
s
.81335 .38489 m
.81335 .38489 L
s
.81342 .38337 m
.81342 .38337 L
s
.8135 .38994 m
.8135 .38994 L
s
.81357 .38842 m
.81357 .38842 L
s
.81365 .38971 m
.81365 .38971 L
s
.81372 .38689 m
.81372 .38689 L
s
.81379 .39441 m
.81379 .39441 L
s
.81386 .38994 m
.81386 .38994 L
s
.81394 .39652 m
.81394 .39652 L
s
.81402 .39617 m
.81402 .39617 L
s
.81409 .39863 m
.81409 .39863 L
s
.81417 .40404 m
.81417 .40404 L
s
.81424 .40368 m
.81424 .40368 L
s
.81432 .39863 m
.81432 .39863 L
s
.81439 .39535 m
.81439 .39535 L
s
.81447 .40099 m
.81447 .40099 L
s
.81454 .40134 m
.81454 .40134 L
s
.81461 .39535 m
.81461 .39535 L
s
.81468 .39323 m
.81468 .39323 L
s
.81476 .39582 m
.81476 .39582 L
s
.81483 .39359 m
.81483 .39359 L
s
.81491 .39311 m
.81491 .39311 L
s
.81498 .39699 m
.81498 .39699 L
s
.81506 .3984 m
.81506 .3984 L
s
.81513 .39464 m
.81513 .39464 L
s
.81521 .39171 m
.81521 .39171 L
s
.81528 .39346 m
.81528 .39346 L
s
.81536 .39934 m
.81536 .39934 L
s
.81542 .39957 m
.81542 .39957 L
s
.8155 .40627 m
.8155 .40627 L
s
.81558 .40474 m
.81558 .40474 L
s
.81565 .40979 m
.81565 .40979 L
s
.81573 .4085 m
.81573 .4085 L
s
.8158 .4152 m
.8158 .4152 L
s
.81588 .41296 m
.81588 .41296 L
s
.81595 .41155 m
.81595 .41155 L
s
.81603 .41002 m
.81603 .41002 L
s
.8161 .4078 m
.8161 .4078 L
s
.81617 .41038 m
.81617 .41038 L
s
.81624 .41602 m
.81624 .41602 L
s
.81632 .41308 m
.81632 .41308 L
s
.81639 .41578 m
.81639 .41578 L
s
.81647 .40967 m
.81647 .40967 L
s
.81654 .41496 m
.81654 .41496 L
s
.81662 .41238 m
.81662 .41238 L
s
.81669 .40709 m
.81669 .40709 L
s
.81677 .4152 m
.81677 .4152 L
s
.81684 .40368 m
.81684 .40368 L
s
.81692 .40991 m
.81692 .40991 L
s
.81699 .41073 m
.81699 .41073 L
s
.81706 .41343 m
.81706 .41343 L
s
.81714 .41355 m
.81714 .41355 L
s
.81721 .40815 m
.81721 .40815 L
s
.81729 .41202 m
.81729 .41202 L
s
.81736 .41073 m
.81736 .41073 L
s
.81744 .40897 m
.81744 .40897 L
s
.81751 .40697 m
.81751 .40697 L
s
.81759 .40122 m
.81759 .40122 L
s
.81766 .40404 m
.81766 .40404 L
s
.81774 .40321 m
.81774 .40321 L
s
.8178 .40568 m
.8178 .40568 L
s
.81788 .40897 m
.81788 .40897 L
s
.81795 .40803 m
.81795 .40803 L
s
.81803 .41014 m
.81803 .41014 L
s
.8181 .4011 m
.8181 .4011 L
s
.81818 .39453 m
.81818 .39453 L
s
.81825 .40263 m
.81825 .40263 L
s
.81833 .39464 m
.81833 .39464 L
s
.8184 .39758 m
.8184 .39758 L
s
.81848 .40075 m
.81848 .40075 L
s
.81855 .40239 m
.81855 .40239 L
s
.81862 .39957 m
.81862 .39957 L
s
.8187 .39182 m
.8187 .39182 L
s
.81877 .3883 m
.81877 .3883 L
s
.81885 .39299 m
.81885 .39299 L
s
.81892 .39511 m
.81892 .39511 L
s
.819 .39299 m
.819 .39299 L
s
.81907 .39124 m
.81907 .39124 L
s
.81914 .38748 m
.81914 .38748 L
s
.81922 .3856 m
.81922 .3856 L
s
.8193 .38701 m
.8193 .38701 L
s
.81937 .38642 m
.81937 .38642 L
s
.81944 .3883 m
.81944 .3883 L
s
.81951 .38959 m
.81951 .38959 L
s
.81959 .38971 m
.81959 .38971 L
s
.81966 .3876 m
.81966 .3876 L
s
.81974 .38384 m
.81974 .38384 L
s
.81981 .37997 m
.81981 .37997 L
s
.81989 .38219 m
.81989 .38219 L
s
.81996 .3708 m
.81996 .3708 L
s
.82003 .37256 m
.82003 .37256 L
s
.82011 .3762 m
.82011 .3762 L
s
.82019 .3775 m
.82019 .3775 L
s
.82026 .37315 m
.82026 .37315 L
s
.82033 .36845 m
.82033 .36845 L
s
.82041 .36892 m
.82041 .36892 L
s
.82048 .36399 m
.82048 .36399 L
s
.82056 .36317 m
.82056 .36317 L
s
.82063 .36234 m
.82063 .36234 L
s
.82071 .35941 m
.82071 .35941 L
s
.82077 .35859 m
.82077 .35859 L
s
.82085 .35483 m
.82085 .35483 L
s
.82093 .35095 m
.82093 .35095 L
s
.821 .3573 m
.821 .3573 L
s
.82107 .35965 m
.82107 .35965 L
s
.82115 .35905 m
.82115 .35905 L
s
.82122 .36329 m
.82122 .36329 L
s
.8213 .35319 m
.8213 .35319 L
s
.82137 .35142 m
.82137 .35142 L
s
.82145 .35259 m
.82145 .35259 L
s
.82152 .35072 m
.82152 .35072 L
s
.82159 .34226 m
.82159 .34226 L
s
.82166 .33768 m
.82166 .33768 L
s
.82174 .34003 m
.82174 .34003 L
s
.82182 .33404 m
.82182 .33404 L
s
.82189 .33381 m
.82189 .33381 L
s
.82197 .33604 m
.82197 .33604 L
s
.82204 .33968 m
.82204 .33968 L
s
.82212 .34449 m
.82212 .34449 L
s
.82219 .34508 m
.82219 .34508 L
s
.82227 .34249 m
.82227 .34249 L
s
.82234 .34414 m
.82234 .34414 L
s
.82241 .34578 m
.82241 .34578 L
s
.82248 .3398 m
.82248 .3398 L
s
.82256 .34344 m
.82256 .34344 L
s
.82263 .34391 m
.82263 .34391 L
s
.82271 .33945 m
.82271 .33945 L
s
.82278 .33885 m
.82278 .33885 L
s
.82286 .34531 m
.82286 .34531 L
s
.82293 .34567 m
.82293 .34567 L
s
.82301 .35048 m
.82301 .35048 L
s
.82308 .35002 m
.82308 .35002 L
s
.82316 .35259 m
.82316 .35259 L
s
.82322 .35424 m
.82322 .35424 L
s
.8233 .35072 m
.8233 .35072 L
s
.82338 .34813 m
.82338 .34813 L
s
.82345 .35048 m
.82345 .35048 L
s
.82353 .35259 m
.82353 .35259 L
s
.8236 .35424 m
.8236 .35424 L
s
.82368 .35459 m
.82368 .35459 L
s
.82375 .3553 m
.82375 .3553 L
s
.82383 .35636 m
.82383 .35636 L
s
.8239 .3607 m
.8239 .3607 L
s
.82397 .35917 m
.82397 .35917 L
s
.82404 .36035 m
.82404 .36035 L
s
.82412 .35952 m
.82412 .35952 L
s
.82419 .36012 m
.82419 .36012 L
s
.82427 .36035 m
.82427 .36035 L
s
.82434 .36012 m
.82434 .36012 L
s
.82442 .35588 m
.82442 .35588 L
s
.82449 .35965 m
.82449 .35965 L
s
.82457 .35259 m
.82457 .35259 L
s
.82464 .34555 m
.82464 .34555 L
s
.82472 .34872 m
.82472 .34872 L
s
.82479 .34813 m
.82479 .34813 L
s
.82486 .34708 m
.82486 .34708 L
s
.82494 .35307 m
.82494 .35307 L
s
.82501 .35905 m
.82501 .35905 L
s
.82509 .35648 m
.82509 .35648 L
s
.82516 .35025 m
.82516 .35025 L
s
.82524 .35013 m
.82524 .35013 L
s
.82531 .35224 m
.82531 .35224 L
s
.82539 .35284 m
.82539 .35284 L
s
.82546 .34638 m
.82546 .34638 L
s
.82554 .34496 m
.82554 .34496 L
s
.8256 .34496 m
.8256 .34496 L
s
.82568 .34907 m
.82568 .34907 L
s
.82575 .34297 m
.82575 .34297 L
s
.82583 .34391 m
.82583 .34391 L
s
.8259 .34626 m
.8259 .34626 L
s
.82598 .33533 m
.82598 .33533 L
s
.82605 .33815 m
.82605 .33815 L
s
.82613 .33357 m
.82613 .33357 L
s
.8262 .33146 m
.8262 .33146 L
s
.82628 .33157 m
.82628 .33157 L
s
.82635 .33334 m
.82635 .33334 L
s
.82642 .33475 m
.82642 .33475 L
s
.8265 .33545 m
.8265 .33545 L
s
.82657 .33628 m
.82657 .33628 L
s
.82665 .3432 m
.82665 .3432 L
s
.82672 .34332 m
.82672 .34332 L
s
.8268 .33838 m
.8268 .33838 L
s
.82687 .33592 m
.82687 .33592 L
s
.82694 .33264 m
.82694 .33264 L
s
.82702 .33005 m
.82702 .33005 L
s
.8271 .33264 m
.8271 .33264 L
s
.82717 .33264 m
.82717 .33264 L
s
.82724 .3378 m
.82724 .3378 L
s
.82731 .34132 m
.82731 .34132 L
s
.82739 .33498 m
.82739 .33498 L
s
.82746 .32993 m
.82746 .32993 L
s
.82754 .33017 m
.82754 .33017 L
s
.82761 .33334 m
.82761 .33334 L
s
.82769 .32946 m
.82769 .32946 L
s
.82776 .32993 m
.82776 .32993 L
s
.82784 .32535 m
.82784 .32535 L
s
.82791 .32182 m
.82791 .32182 L
s
.82799 .32018 m
.82799 .32018 L
s
.82806 .31596 m
.82806 .31596 L
s
.82813 .32112 m
.82813 .32112 L
s
.82821 .32124 m
.82821 .32124 L
s
.82828 .31501 m
.82828 .31501 L
s
.82836 .31561 m
.82836 .31561 L
s
.82843 .31713 m
.82843 .31713 L
s
.82851 .31783 m
.82851 .31783 L
s
.82857 .32254 m
.82857 .32254 L
s
.82865 .32711 m
.82865 .32711 L
s
.82873 .33075 m
.82873 .33075 L
s
.8288 .33275 m
.8288 .33275 L
s
.82887 .33099 m
.82887 .33099 L
s
.82895 .33568 m
.82895 .33568 L
s
.82902 .3351 m
.82902 .3351 L
s
.8291 .32793 m
.8291 .32793 L
s
.82917 .33052 m
.82917 .33052 L
s
.82925 .33533 m
.82925 .33533 L
s
.82932 .33404 m
.82932 .33404 L
s
.82939 .33545 m
.82939 .33545 L
s
.82947 .33439 m
.82947 .33439 L
s
.82955 .33075 m
.82955 .33075 L
s
.82962 .32982 m
.82962 .32982 L
s
.82969 .33581 m
.82969 .33581 L
s
.82977 .34778 m
.82977 .34778 L
s
.82984 .34743 m
.82984 .34743 L
s
.82992 .35259 m
.82992 .35259 L
s
.82999 .35777 m
.82999 .35777 L
s
.83007 .35612 m
.83007 .35612 L
s
.83014 .35588 m
.83014 .35588 L
s
.83021 .35565 m
.83021 .35565 L
s
.83028 .35401 m
.83028 .35401 L
s
.83036 .35471 m
.83036 .35471 L
s
.83043 .35495 m
.83043 .35495 L
s
.83051 .35119 m
.83051 .35119 L
s
.83058 .35354 m
.83058 .35354 L
s
.83066 .35084 m
.83066 .35084 L
s
.83073 .34931 m
.83073 .34931 L
s
.83081 .34214 m
.83081 .34214 L
s
.83088 .34027 m
.83088 .34027 L
s
.83096 .33686 m
.83096 .33686 L
s
.83102 .33698 m
.83102 .33698 L
s
.8311 .33874 m
.8311 .33874 L
s
.83118 .34274 m
.83118 .34274 L
s
.83125 .34907 m
.83125 .34907 L
s
.83133 .35588 m
.83133 .35588 L
s
.8314 .35823 m
.8314 .35823 L
s
.83148 .35894 m
.83148 .35894 L
s
.83155 .36094 m
.83155 .36094 L
s
.83163 .35624 m
.83163 .35624 L
s
.8317 .35741 m
.8317 .35741 L
s
.83177 .36 m
.83177 .36 L
s
.83184 .36376 m
.83184 .36376 L
s
.83192 .36481 m
.83192 .36481 L
s
.83199 .35541 m
.83199 .35541 L
s
.83207 .35142 m
.83207 .35142 L
s
.83214 .34696 m
.83214 .34696 L
s
.83222 .35025 m
.83222 .35025 L
s
.83229 .35366 m
.83229 .35366 L
s
.83237 .34802 m
.83237 .34802 L
s
.83244 .35025 m
.83244 .35025 L
s
.83252 .35694 m
.83252 .35694 L
s
.83259 .35284 m
.83259 .35284 L
s
.83266 .35941 m
.83266 .35941 L
s
.83274 .35823 m
.83274 .35823 L
s
.83281 .35788 m
.83281 .35788 L
s
.83289 .36469 m
.83289 .36469 L
s
.83296 .36293 m
.83296 .36293 L
s
.83304 .36364 m
.83304 .36364 L
s
.83311 .36669 m
.83311 .36669 L
s
.83319 .37045 m
.83319 .37045 L
s
.83326 .36987 m
.83326 .36987 L
s
.83334 .36845 m
.83334 .36845 L
s
.8334 .37538 m
.8334 .37538 L
s
.83348 .37832 m
.83348 .37832 L
s
.83355 .37937 m
.83355 .37937 L
s
.83363 .38008 m
.83363 .38008 L
s
.8337 .37797 m
.8337 .37797 L
s
.83378 .37561 m
.83378 .37561 L
s
.83385 .38043 m
.83385 .38043 L
s
.83393 .37902 m
.83393 .37902 L
s
.834 .37668 m
.834 .37668 L
s
.83408 .38032 m
.83408 .38032 L
s
.83415 .37679 m
.83415 .37679 L
s
.83422 .37643 m
.83422 .37643 L
s
.8343 .37668 m
.8343 .37668 L
s
.83437 .38337 m
.83437 .38337 L
s
.83445 .38654 m
.83445 .38654 L
s
.83452 .3883 m
.83452 .3883 L
s
.8346 .38654 m
.8346 .38654 L
s
.83467 .38924 m
.83467 .38924 L
s
.83475 .39112 m
.83475 .39112 L
s
.83482 .38947 m
.83482 .38947 L
s
.8349 .38571 m
.8349 .38571 L
s
.83497 .39042 m
.83497 .39042 L
s
.83504 .39382 m
.83504 .39382 L
s
.83511 .391 m
.83511 .391 L
s
.83519 .39135 m
.83519 .39135 L
s
.83526 .38912 m
.83526 .38912 L
s
.83534 .39394 m
.83534 .39394 L
s
.83541 .39276 m
.83541 .39276 L
s
.83549 .39241 m
.83549 .39241 L
s
.83556 .39206 m
.83556 .39206 L
s
.83564 .39065 m
.83564 .39065 L
s
.83571 .3863 m
.83571 .3863 L
s
.83579 .38301 m
.83579 .38301 L
s
.83586 .38454 m
.83586 .38454 L
s
.83593 .38771 m
.83593 .38771 L
s
.83601 .38536 m
.83601 .38536 L
s
.83608 .38678 m
.83608 .38678 L
s
.83616 .38689 m
.83616 .38689 L
s
.83623 .38689 m
.83623 .38689 L
s
.83631 .3876 m
.83631 .3876 L
s
.83638 .38771 m
.83638 .38771 L
s
.83646 .38384 m
.83646 .38384 L
s
.83653 .37997 m
.83653 .37997 L
s
.8366 .37808 m
.8366 .37808 L
s
.83667 .37279 m
.83667 .37279 L
s
.83675 .37867 m
.83675 .37867 L
s
.83682 .38125 m
.83682 .38125 L
s
.8369 .37608 m
.8369 .37608 L
s
.83697 .37632 m
.83697 .37632 L
s
.83705 .3775 m
.83705 .3775 L
s
.83712 .37643 m
.83712 .37643 L
s
.83719 .37773 m
.83719 .37773 L
s
.83727 .38971 m
.83727 .38971 L
s
.83735 .39382 m
.83735 .39382 L
s
.83742 .39558 m
.83742 .39558 L
s
.83749 .39406 m
.83749 .39406 L
s
.83757 .39346 m
.83757 .39346 L
s
.83764 .39112 m
.83764 .39112 L
s
.83772 .39182 m
.83772 .39182 L
s
.83779 .38947 m
.83779 .38947 L
s
.83787 .3883 m
.83787 .3883 L
s
.83794 .38454 m
.83794 .38454 L
s
.83801 .38161 m
.83801 .38161 L
s
.83808 .38795 m
.83808 .38795 L
s
.83816 .38489 m
.83816 .38489 L
s
.83823 .38654 m
.83823 .38654 L
s
.83831 .37984 m
.83831 .37984 L
s
.83838 .37867 m
.83838 .37867 L
s
.83846 .3789 m
.83846 .3789 L
s
.83853 .37843 m
.83853 .37843 L
s
.83861 .38289 m
.83861 .38289 L
s
.83868 .38196 m
.83868 .38196 L
s
.83876 .38266 m
.83876 .38266 L
s
.83882 .38713 m
.83882 .38713 L
s
.8389 .38947 m
.8389 .38947 L
s
.83898 .38665 m
.83898 .38665 L
s
.83905 .39135 m
.83905 .39135 L
s
.83913 .39159 m
.83913 .39159 L
s
.8392 .40216 m
.8392 .40216 L
s
.83928 .40451 m
.83928 .40451 L
s
.83935 .4011 m
.83935 .4011 L
s
.83943 .40568 m
.83943 .40568 L
s
.8395 .40556 m
.8395 .40556 L
s
.83957 .40052 m
.83957 .40052 L
s
.83964 .39253 m
.83964 .39253 L
s
.83972 .39229 m
.83972 .39229 L
s
.8398 .39006 m
.8398 .39006 L
s
.83987 .39276 m
.83987 .39276 L
s
.83994 .39441 m
.83994 .39441 L
s
.84002 .3977 m
.84002 .3977 L
s
.84009 .40333 m
.84009 .40333 L
s
.84017 .40239 m
.84017 .40239 L
s
.84024 .39887 m
.84024 .39887 L
s
.84032 .3984 m
.84032 .3984 L
s
.84039 .39441 m
.84039 .39441 L
s
.84046 .38795 m
.84046 .38795 L
s
.84054 .39159 m
.84054 .39159 L
s
.84061 .3876 m
.84061 .3876 L
s
.84069 .38301 m
.84069 .38301 L
s
.84076 .37949 m
.84076 .37949 L
s
.84084 .38079 m
.84084 .38079 L
s
.84091 .38337 m
.84091 .38337 L
s
.84099 .37703 m
.84099 .37703 L
s
.84106 .37656 m
.84106 .37656 L
s
.84114 .37925 m
.84114 .37925 L
s
.8412 .37937 m
.8412 .37937 L
s
.84128 .37386 m
.84128 .37386 L
s
.84135 .37104 m
.84135 .37104 L
s
.84143 .36211 m
.84143 .36211 L
s
.8415 .36258 m
.8415 .36258 L
s
.84158 .3573 m
.84158 .3573 L
s
.84165 .35753 m
.84165 .35753 L
s
.84173 .36129 m
.84173 .36129 L
s
.8418 .3607 m
.8418 .3607 L
s
.84188 .36481 m
.84188 .36481 L
s
.84195 .36646 m
.84195 .36646 L
s
.84202 .36904 m
.84202 .36904 L
s
.8421 .37374 m
.8421 .37374 L
s
.84217 .37351 m
.84217 .37351 L
s
.84225 .3762 m
.84225 .3762 L
s
.84232 .37386 m
.84232 .37386 L
s
.8424 .37479 m
.8424 .37479 L
s
.84247 .37503 m
.84247 .37503 L
s
.84255 .37022 m
.84255 .37022 L
s
.84262 .3674 m
.84262 .3674 L
s
.8427 .36587 m
.8427 .36587 L
s
.84277 .36281 m
.84277 .36281 L
s
.84284 .36469 m
.84284 .36469 L
s
.84291 .36246 m
.84291 .36246 L
s
.84299 .36317 m
.84299 .36317 L
s
.84306 .36681 m
.84306 .36681 L
s
.84314 .36646 m
.84314 .36646 L
s
.84321 .36352 m
.84321 .36352 L
s
.84329 .36059 m
.84329 .36059 L
s
.84336 .36728 m
.84336 .36728 L
s
.84344 .3674 m
.84344 .3674 L
s
.84351 .36575 m
.84351 .36575 L
s
.84359 .37057 m
.84359 .37057 L
s
.84366 .36763 m
.84366 .36763 L
s
.84373 .35753 m
.84373 .35753 L
s
.84381 .36281 m
.84381 .36281 L
s
.84388 .36622 m
.84388 .36622 L
s
.84396 .36505 m
.84396 .36505 L
s
.84403 .36387 m
.84403 .36387 L
s
.84411 .36211 m
.84411 .36211 L
s
.84418 .36176 m
.84418 .36176 L
s
.84426 .35965 m
.84426 .35965 L
s
.84433 .36399 m
.84433 .36399 L
s
.8444 .36341 m
.8444 .36341 L
s
.84447 .36434 m
.84447 .36434 L
s
.84455 .35706 m
.84455 .35706 L
s
.84462 .36693 m
.84462 .36693 L
s
.8447 .36047 m
.8447 .36047 L
s
.84477 .36551 m
.84477 .36551 L
s
.84485 .36117 m
.84485 .36117 L
s
.84492 .36317 m
.84492 .36317 L
s
.84499 .36493 m
.84499 .36493 L
s
.84507 .36892 m
.84507 .36892 L
s
.84515 .37433 m
.84515 .37433 L
s
.84522 .3708 m
.84522 .3708 L
s
.84529 .36775 m
.84529 .36775 L
s
.84537 .36927 m
.84537 .36927 L
s
.84544 .37444 m
.84544 .37444 L
s
.84552 .3762 m
.84552 .3762 L
s
.84559 .37268 m
.84559 .37268 L
s
.84567 .37397 m
.84567 .37397 L
s
.84574 .37479 m
.84574 .37479 L
s
.84581 .37879 m
.84581 .37879 L
s
.84589 .37867 m
.84589 .37867 L
s
.84597 .37503 m
.84597 .37503 L
s
.84603 .37491 m
.84603 .37491 L
s
.84611 .38137 m
.84611 .38137 L
s
.84618 .38008 m
.84618 .38008 L
s
.84626 .38207 m
.84626 .38207 L
s
.84633 .38396 m
.84633 .38396 L
s
.84641 .38172 m
.84641 .38172 L
s
.84648 .38924 m
.84648 .38924 L
s
.84656 .38618 m
.84656 .38618 L
s
.84662 .38571 m
.84662 .38571 L
s
.8467 .37925 m
.8467 .37925 L
s
.84678 .38149 m
.84678 .38149 L
s
.84685 .37691 m
.84685 .37691 L
s
.84693 .3775 m
.84693 .3775 L
s
.847 .36915 m
.847 .36915 L
s
.84708 .37069 m
.84708 .37069 L
s
.84715 .37397 m
.84715 .37397 L
s
.84723 .37162 m
.84723 .37162 L
s
.8473 .37045 m
.8473 .37045 L
s
.84737 .37127 m
.84737 .37127 L
s
.84744 .37374 m
.84744 .37374 L
s
.84752 .3708 m
.84752 .3708 L
s
.8476 .37608 m
.8476 .37608 L
s
.84767 .37643 m
.84767 .37643 L
s
.84774 .37703 m
.84774 .37703 L
s
.84782 .37256 m
.84782 .37256 L
s
.84789 .37162 m
.84789 .37162 L
s
.84797 .3688 m
.84797 .3688 L
s
.84804 .37843 m
.84804 .37843 L
s
.84812 .37397 m
.84812 .37397 L
s
.84819 .38172 m
.84819 .38172 L
s
.84826 .38114 m
.84826 .38114 L
s
.84834 .38231 m
.84834 .38231 L
s
.84841 .37761 m
.84841 .37761 L
s
.84849 .37855 m
.84849 .37855 L
s
.84856 .37855 m
.84856 .37855 L
s
.84864 .3755 m
.84864 .3755 L
s
.84871 .38266 m
.84871 .38266 L
s
.84879 .38525 m
.84879 .38525 L
s
.84886 .38478 m
.84886 .38478 L
s
.84894 .38289 m
.84894 .38289 L
s
.849 .37902 m
.849 .37902 L
s
.84908 .38665 m
.84908 .38665 L
s
.84915 .38959 m
.84915 .38959 L
s
.84923 .38478 m
.84923 .38478 L
s
.8493 .38571 m
.8493 .38571 L
s
.84938 .38583 m
.84938 .38583 L
s
.84945 .38771 m
.84945 .38771 L
s
.84953 .38595 m
.84953 .38595 L
s
.8496 .38982 m
.8496 .38982 L
s
.84968 .39711 m
.84968 .39711 L
s
.84975 .39089 m
.84975 .39089 L
s
.84982 .39699 m
.84982 .39699 L
s
.8499 .39628 m
.8499 .39628 L
s
.84997 .40204 m
.84997 .40204 L
s
.85005 .4004 m
.85005 .4004 L
s
.85012 .40873 m
.85012 .40873 L
s
.8502 .40862 m
.8502 .40862 L
s
.85027 .4078 m
.85027 .4078 L
s
.85035 .40909 m
.85035 .40909 L
s
.85042 .40709 m
.85042 .40709 L
s
.8505 .41014 m
.8505 .41014 L
s
.85057 .40545 m
.85057 .40545 L
s
.85064 .40827 m
.85064 .40827 L
s
.85071 .41402 m
.85071 .41402 L
s
.85079 .4092 m
.85079 .4092 L
s
.85086 .40099 m
.85086 .40099 L
s
.85094 .40381 m
.85094 .40381 L
s
.85101 .4085 m
.85101 .4085 L
s
.85109 .40932 m
.85109 .40932 L
s
.85116 .41226 m
.85116 .41226 L
s
.85124 .41555 m
.85124 .41555 L
s
.85131 .41837 m
.85131 .41837 L
s
.85139 .41837 m
.85139 .41837 L
s
.85146 .41602 m
.85146 .41602 L
s
.85153 .41578 m
.85153 .41578 L
s
.85161 .41308 m
.85161 .41308 L
s
.85168 .41038 m
.85168 .41038 L
s
.85176 .41062 m
.85176 .41062 L
s
.85183 .41026 m
.85183 .41026 L
s
.85191 .4078 m
.85191 .4078 L
s
.85198 .40685 m
.85198 .40685 L
s
.85206 .40451 m
.85206 .40451 L
s
.85213 .40004 m
.85213 .40004 L
s
.8522 .40803 m
.8522 .40803 L
s
.85227 .40157 m
.85227 .40157 L
s
.85235 .40286 m
.85235 .40286 L
s
.85242 .39664 m
.85242 .39664 L
s
.8525 .39957 m
.8525 .39957 L
s
.85257 .40321 m
.85257 .40321 L
s
.85265 .40099 m
.85265 .40099 L
s
.85272 .40263 m
.85272 .40263 L
s
.8528 .39699 m
.8528 .39699 L
s
.85287 .40028 m
.85287 .40028 L
s
.85295 .39793 m
.85295 .39793 L
s
.85302 .39863 m
.85302 .39863 L
s
.85309 .39323 m
.85309 .39323 L
s
.85317 .39159 m
.85317 .39159 L
s
.85324 .39065 m
.85324 .39065 L
s
.85332 .38783 m
.85332 .38783 L
s
.85339 .38924 m
.85339 .38924 L
s
.85347 .38713 m
.85347 .38713 L
s
.85354 .38454 m
.85354 .38454 L
s
.85361 .39159 m
.85361 .39159 L
s
.85369 .38231 m
.85369 .38231 L
s
.85377 .37797 m
.85377 .37797 L
s
.85383 .38548 m
.85383 .38548 L
s
.85391 .38536 m
.85391 .38536 L
s
.85398 .389 m
.85398 .389 L
s
.85406 .38853 m
.85406 .38853 L
s
.85413 .39159 m
.85413 .39159 L
s
.85421 .39264 m
.85421 .39264 L
s
.85428 .39546 m
.85428 .39546 L
s
.85436 .39323 m
.85436 .39323 L
s
.85443 .39981 m
.85443 .39981 L
s
.85451 .39699 m
.85451 .39699 L
s
.85459 .3957 m
.85459 .3957 L
s
.85465 .3977 m
.85465 .3977 L
s
.85473 .39899 m
.85473 .39899 L
s
.8548 .39922 m
.8548 .39922 L
s
.85488 .40016 m
.85488 .40016 L
s
.85495 .40697 m
.85495 .40697 L
s
.85503 .40944 m
.85503 .40944 L
s
.8551 .41014 m
.8551 .41014 L
s
.85517 .41837 m
.85517 .41837 L
s
.85524 .42353 m
.85524 .42353 L
s
.85532 .42588 m
.85532 .42588 L
s
.8554 .42412 m
.8554 .42412 L
s
.85547 .42647 m
.85547 .42647 L
s
.85554 .42765 m
.85554 .42765 L
s
.85562 .42812 m
.85562 .42812 L
s
.85569 .42694 m
.85569 .42694 L
s
.85577 .42095 m
.85577 .42095 L
s
.85584 .41848 m
.85584 .41848 L
s
.85592 .41954 m
.85592 .41954 L
s
.85599 .41907 m
.85599 .41907 L
s
.85606 .41155 m
.85606 .41155 L
s
.85614 .41132 m
.85614 .41132 L
s
.85622 .41473 m
.85622 .41473 L
s
.85629 .41238 m
.85629 .41238 L
s
.85636 .41038 m
.85636 .41038 L
s
.85644 .41002 m
.85644 .41002 L
s
.85651 .40733 m
.85651 .40733 L
s
.85659 .41155 m
.85659 .41155 L
s
.85666 .41343 m
.85666 .41343 L
s
.85674 .40873 m
.85674 .40873 L
s
.8568 .40556 m
.8568 .40556 L
s
.85688 .40122 m
.85688 .40122 L
s
.85695 .39992 m
.85695 .39992 L
s
.85703 .40274 m
.85703 .40274 L
s
.8571 .40404 m
.8571 .40404 L
s
.85718 .40427 m
.85718 .40427 L
s
.85725 .4078 m
.85725 .4078 L
s
.85733 .40709 m
.85733 .40709 L
s
.8574 .4112 m
.8574 .4112 L
s
.85748 .41508 m
.85748 .41508 L
s
.85755 .41813 m
.85755 .41813 L
s
.85762 .41884 m
.85762 .41884 L
s
.8577 .41813 m
.8577 .41813 L
s
.85777 .42024 m
.85777 .42024 L
s
.85785 .41801 m
.85785 .41801 L
s
.85792 .42177 m
.85792 .42177 L
s
.858 .42201 m
.858 .42201 L
s
.85807 .41695 m
.85807 .41695 L
s
.85815 .42236 m
.85815 .42236 L
s
.85822 .42436 m
.85822 .42436 L
s
.8583 .42142 m
.8583 .42142 L
s
.85837 .41837 m
.85837 .41837 L
s
.85844 .41391 m
.85844 .41391 L
s
.85851 .41637 m
.85851 .41637 L
s
.85859 .41684 m
.85859 .41684 L
s
.85866 .41743 m
.85866 .41743 L
s
.85874 .4193 m
.85874 .4193 L
s
.85881 .41755 m
.85881 .41755 L
s
.85889 .41954 m
.85889 .41954 L
s
.85896 .4152 m
.85896 .4152 L
s
.85904 .42483 m
.85904 .42483 L
s
.85911 .42823 m
.85911 .42823 L
s
.85919 .43034 m
.85919 .43034 L
s
.85926 .43481 m
.85926 .43481 L
s
.85933 .43927 m
.85933 .43927 L
s
.85941 .43469 m
.85941 .43469 L
s
.85948 .43422 m
.85948 .43422 L
s
.85956 .43446 m
.85956 .43446 L
s
.85963 .42952 m
.85963 .42952 L
s
.85971 .42917 m
.85971 .42917 L
s
.85978 .43622 m
.85978 .43622 L
s
.85986 .4361 m
.85986 .4361 L
s
.85993 .43915 m
.85993 .43915 L
s
.86 .43551 m
.86 .43551 L
s
.86007 .43692 m
.86007 .43692 L
s
.86015 .43363 m
.86015 .43363 L
s
.86022 .42905 m
.86022 .42905 L
s
.8603 .42999 m
.8603 .42999 L
s
.86037 .42917 m
.86037 .42917 L
s
.86045 .42318 m
.86045 .42318 L
s
.86052 .42483 m
.86052 .42483 L
s
.8606 .426 m
.8606 .426 L
s
.86067 .42917 m
.86067 .42917 L
s
.86075 .42635 m
.86075 .42635 L
s
.86082 .42635 m
.86082 .42635 L
s
.86089 .42612 m
.86089 .42612 L
s
.86097 .42917 m
.86097 .42917 L
s
.86104 .43129 m
.86104 .43129 L
s
.86112 .42506 m
.86112 .42506 L
s
.86119 .42753 m
.86119 .42753 L
s
.86127 .42729 m
.86127 .42729 L
s
.86134 .43034 m
.86134 .43034 L
s
.86142 .43187 m
.86142 .43187 L
s
.86149 .43176 m
.86149 .43176 L
s
.86157 .42894 m
.86157 .42894 L
s
.86164 .42753 m
.86164 .42753 L
s
.86171 .42424 m
.86171 .42424 L
s
.86178 .42376 m
.86178 .42376 L
s
.86186 .42388 m
.86186 .42388 L
s
.86193 .42541 m
.86193 .42541 L
s
.86201 .42541 m
.86201 .42541 L
s
.86208 .43222 m
.86208 .43222 L
s
.86216 .43857 m
.86216 .43857 L
s
.86223 .43715 m
.86223 .43715 L
s
.86231 .44221 m
.86231 .44221 L
s
.86239 .43622 m
.86239 .43622 L
s
.86245 .43269 m
.86245 .43269 L
s
.86253 .43434 m
.86253 .43434 L
s
.8626 .43645 m
.8626 .43645 L
s
.86268 .4375 m
.86268 .4375 L
s
.86275 .44079 m
.86275 .44079 L
s
.86283 .44197 m
.86283 .44197 L
s
.8629 .44456 m
.8629 .44456 L
s
.86297 .44772 m
.86297 .44772 L
s
.86305 .44737 m
.86305 .44737 L
s
.86313 .45124 m
.86313 .45124 L
s
.8632 .44772 m
.8632 .44772 L
s
.86327 .45101 m
.86327 .45101 L
s
.86334 .45196 m
.86334 .45196 L
s
.86342 .45947 m
.86342 .45947 L
s
.86349 .45348 m
.86349 .45348 L
s
.86357 .46346 m
.86357 .46346 L
s
.86364 .459 m
.86364 .459 L
s
.86372 .4577 m
.86372 .4577 L
s
.86379 .4556 m
.86379 .4556 L
s
.86386 .45336 m
.86386 .45336 L
s
.86394 .45665 m
.86394 .45665 L
s
.86402 .45313 m
.86402 .45313 L
s
.86409 .45501 m
.86409 .45501 L
s
.86416 .45595 m
.86416 .45595 L
s
.86424 .45806 m
.86424 .45806 L
s
.86431 .45971 m
.86431 .45971 L
s
.86439 .45782 m
.86439 .45782 L
s
.86446 .46076 m
.86446 .46076 L
s
.86454 .45853 m
.86454 .45853 L
s
.86461 .46111 m
.86461 .46111 L
s
.86468 .46323 m
.86468 .46323 L
s
.86476 .46276 m
.86476 .46276 L
s
.86483 .45077 m
.86483 .45077 L
s
.8649 .45453 m
.8649 .45453 L
s
.86498 .46029 m
.86498 .46029 L
s
.86505 .46194 m
.86505 .46194 L
s
.86513 .46804 m
.86513 .46804 L
s
.8652 .47438 m
.8652 .47438 L
s
.86528 .48061 m
.86528 .48061 L
s
.86535 .48084 m
.86535 .48084 L
s
.86542 .47638 m
.86542 .47638 L
s
.8655 .47156 m
.8655 .47156 L
s
.86557 .4698 m
.86557 .4698 L
s
.86565 .47109 m
.86565 .47109 L
s
.86572 .47145 m
.86572 .47145 L
s
.8658 .4785 m
.8658 .4785 L
s
.86587 .48355 m
.86587 .48355 L
s
.86595 .48037 m
.86595 .48037 L
s
.86602 .48261 m
.86602 .48261 L
s
.8661 .48355 m
.8661 .48355 L
s
.86617 .47756 m
.86617 .47756 L
s
.86624 .47955 m
.86624 .47955 L
s
.86631 .48402 m
.86631 .48402 L
s
.86639 .48343 m
.86639 .48343 L
s
.86647 .48061 m
.86647 .48061 L
s
.86654 .47673 m
.86654 .47673 L
s
.86661 .47802 m
.86661 .47802 L
s
.86669 .47544 m
.86669 .47544 L
s
.86676 .47756 m
.86676 .47756 L
s
.86684 .48084 m
.86684 .48084 L
s
.86691 .48072 m
.86691 .48072 L
s
.86699 .47521 m
.86699 .47521 L
s
.86706 .47662 m
.86706 .47662 L
s
.86713 .47556 m
.86713 .47556 L
s
.86721 .47779 m
.86721 .47779 L
s
.86728 .47709 m
.86728 .47709 L
s
.86736 .48037 m
.86736 .48037 L
s
.86743 .48166 m
.86743 .48166 L
s
.86751 .48108 m
.86751 .48108 L
s
.86758 .47897 m
.86758 .47897 L
s
.86766 .4785 m
.86766 .4785 L
s
.86773 .47391 m
.86773 .47391 L
s
.8678 .46992 m
.8678 .46992 L
s
.86787 .47051 m
.86787 .47051 L
s
.86795 .46687 m
.86795 .46687 L
s
.86802 .46722 m
.86802 .46722 L
s
.8681 .46652 m
.8681 .46652 L
s
.86817 .46217 m
.86817 .46217 L
s
.86825 .46076 m
.86825 .46076 L
s
.86832 .45606 m
.86832 .45606 L
s
.8684 .46264 m
.8684 .46264 L
s
.86847 .46029 m
.86847 .46029 L
s
.86855 .45747 m
.86855 .45747 L
s
.86862 .46346 m
.86862 .46346 L
s
.86869 .46523 m
.86869 .46523 L
s
.86877 .46088 m
.86877 .46088 L
s
.86884 .46182 m
.86884 .46182 L
s
.86892 .45478 m
.86892 .45478 L
s
.86899 .45313 m
.86899 .45313 L
s
.86907 .45489 m
.86907 .45489 L
s
.86914 .45101 m
.86914 .45101 L
s
.86922 .45478 m
.86922 .45478 L
s
.86929 .45172 m
.86929 .45172 L
s
.86937 .4489 m
.86937 .4489 L
s
.86944 .45101 m
.86944 .45101 L
s
.86951 .45266 m
.86951 .45266 L
s
.86958 .45336 m
.86958 .45336 L
s
.86966 .44737 m
.86966 .44737 L
s
.86973 .45971 m
.86973 .45971 L
s
.86981 .46135 m
.86981 .46135 L
s
.86988 .4644 m
.86988 .4644 L
s
.86996 .46217 m
.86996 .46217 L
s
.87003 .46605 m
.87003 .46605 L
s
.87011 .46346 m
.87011 .46346 L
s
.87019 .46828 m
.87019 .46828 L
s
.87025 .47098 m
.87025 .47098 L
s
.87033 .46652 m
.87033 .46652 L
s
.8704 .4644 m
.8704 .4644 L
s
.87048 .46229 m
.87048 .46229 L
s
.87055 .45935 m
.87055 .45935 L
s
.87063 .45723 m
.87063 .45723 L
s
.8707 .46135 m
.8707 .46135 L
s
.87077 .46535 m
.87077 .46535 L
s
.87085 .4637 m
.87085 .4637 L
s
.87093 .461 m
.87093 .461 L
s
.871 .46605 m
.871 .46605 L
s
.87107 .46511 m
.87107 .46511 L
s
.87114 .46546 m
.87114 .46546 L
s
.87122 .4617 m
.87122 .4617 L
s
.87129 .46393 m
.87129 .46393 L
s
.87137 .45453 m
.87137 .45453 L
s
.87144 .45313 m
.87144 .45313 L
s
.87152 .45336 m
.87152 .45336 L
s
.87159 .45912 m
.87159 .45912 L
s
.87167 .45877 m
.87167 .45877 L
s
.87175 .46053 m
.87175 .46053 L
s
.87182 .46147 m
.87182 .46147 L
s
.87189 .45971 m
.87189 .45971 L
s
.87196 .45606 m
.87196 .45606 L
s
.87204 .45595 m
.87204 .45595 L
s
.87211 .45572 m
.87211 .45572 L
s
.87219 .45348 m
.87219 .45348 L
s
.87226 .45935 m
.87226 .45935 L
s
.87234 .45994 m
.87234 .45994 L
s
.87241 .46205 m
.87241 .46205 L
s
.87248 .4617 m
.87248 .4617 L
s
.87256 .46123 m
.87256 .46123 L
s
.87263 .46299 m
.87263 .46299 L
s
.8727 .459 m
.8727 .459 L
s
.87278 .45782 m
.87278 .45782 L
s
.87285 .45618 m
.87285 .45618 L
s
.87293 .46299 m
.87293 .46299 L
s
.873 .46064 m
.873 .46064 L
s
.87308 .45806 m
.87308 .45806 L
s
.87315 .4583 m
.87315 .4583 L
s
.87322 .46006 m
.87322 .46006 L
s
.8733 .46276 m
.8733 .46276 L
s
.87338 .45606 m
.87338 .45606 L
s
.87345 .45712 m
.87345 .45712 L
s
.87352 .45196 m
.87352 .45196 L
s
.8736 .45324 m
.8736 .45324 L
s
.87367 .45313 m
.87367 .45313 L
s
.87375 .45677 m
.87375 .45677 L
s
.87382 .46323 m
.87382 .46323 L
s
.8739 .46699 m
.8739 .46699 L
s
.87397 .46428 m
.87397 .46428 L
s
.87404 .46499 m
.87404 .46499 L
s
.87411 .46875 m
.87411 .46875 L
s
.87419 .47263 m
.87419 .47263 L
s
.87427 .47169 m
.87427 .47169 L
s
.87434 .47051 m
.87434 .47051 L
s
.87441 .4738 m
.87441 .4738 L
s
.87449 .47826 m
.87449 .47826 L
s
.87456 .4799 m
.87456 .4799 L
s
.87464 .47544 m
.87464 .47544 L
s
.87471 .47533 m
.87471 .47533 L
s
.87479 .4745 m
.87479 .4745 L
s
.87486 .47228 m
.87486 .47228 L
s
.87493 .47169 m
.87493 .47169 L
s
.87501 .46945 m
.87501 .46945 L
s
.87508 .46769 m
.87508 .46769 L
s
.87516 .46898 m
.87516 .46898 L
s
.87523 .46393 m
.87523 .46393 L
s
.87531 .46006 m
.87531 .46006 L
s
.87538 .4617 m
.87538 .4617 L
s
.87546 .46463 m
.87546 .46463 L
s
.87553 .45794 m
.87553 .45794 L
s
.8756 .457 m
.8756 .457 L
s
.87567 .45595 m
.87567 .45595 L
s
.87575 .45124 m
.87575 .45124 L
s
.87582 .44749 m
.87582 .44749 L
s
.8759 .44749 m
.8759 .44749 L
s
.87597 .45266 m
.87597 .45266 L
s
.87605 .45723 m
.87605 .45723 L
s
.87612 .45525 m
.87612 .45525 L
s
.8762 .45324 m
.8762 .45324 L
s
.87627 .45336 m
.87627 .45336 L
s
.87635 .45489 m
.87635 .45489 L
s
.87642 .45735 m
.87642 .45735 L
s
.87649 .46017 m
.87649 .46017 L
s
.87657 .46757 m
.87657 .46757 L
s
.87664 .46887 m
.87664 .46887 L
s
.87672 .47309 m
.87672 .47309 L
s
.87679 .47415 m
.87679 .47415 L
s
.87687 .4745 m
.87687 .4745 L
s
.87694 .46969 m
.87694 .46969 L
s
.87702 .4644 m
.87702 .4644 L
s
.87709 .46076 m
.87709 .46076 L
s
.87717 .4583 m
.87717 .4583 L
s
.87724 .45572 m
.87724 .45572 L
s
.87731 .45677 m
.87731 .45677 L
s
.87738 .45077 m
.87738 .45077 L
s
.87746 .45383 m
.87746 .45383 L
s
.87753 .45324 m
.87753 .45324 L
s
.87761 .44984 m
.87761 .44984 L
s
.87768 .44538 m
.87768 .44538 L
s
.87776 .44585 m
.87776 .44585 L
s
.87783 .45008 m
.87783 .45008 L
s
.87791 .44596 m
.87791 .44596 L
s
.87799 .44021 m
.87799 .44021 L
s
.87805 .44162 m
.87805 .44162 L
s
.87813 .43786 m
.87813 .43786 L
s
.8782 .43775 m
.8782 .43775 L
s
.87828 .44314 m
.87828 .44314 L
s
.87835 .44585 m
.87835 .44585 L
s
.87843 .4536 m
.87843 .4536 L
s
.8785 .45525 m
.8785 .45525 L
s
.87858 .45478 m
.87858 .45478 L
s
.87865 .45101 m
.87865 .45101 L
s
.87873 .44902 m
.87873 .44902 L
s
.8788 .44491 m
.8788 .44491 L
s
.87887 .44937 m
.87887 .44937 L
s
.87894 .45501 m
.87894 .45501 L
s
.87902 .45149 m
.87902 .45149 L
s
.87909 .45336 m
.87909 .45336 L
s
.87917 .45266 m
.87917 .45266 L
s
.87924 .45196 m
.87924 .45196 L
s
.87932 .44961 m
.87932 .44961 L
s
.87939 .45595 m
.87939 .45595 L
s
.87947 .45407 m
.87947 .45407 L
s
.87955 .45219 m
.87955 .45219 L
s
.87962 .44961 m
.87962 .44961 L
s
.87969 .44737 m
.87969 .44737 L
s
.87976 .44996 m
.87976 .44996 L
s
.87984 .44867 m
.87984 .44867 L
s
.87991 .44702 m
.87991 .44702 L
s
.87999 .45066 m
.87999 .45066 L
s
.88006 .45101 m
.88006 .45101 L
s
.88014 .45383 m
.88014 .45383 L
s
.88021 .45735 m
.88021 .45735 L
s
.88029 .44937 m
.88029 .44937 L
s
.88036 .45054 m
.88036 .45054 L
s
.88043 .45653 m
.88043 .45653 L
s
.8805 .4583 m
.8805 .4583 L
s
.88058 .46159 m
.88058 .46159 L
s
.88065 .45618 m
.88065 .45618 L
s
.88073 .46523 m
.88073 .46523 L
s
.8808 .46722 m
.8808 .46722 L
s
.88088 .4698 m
.88088 .4698 L
s
.88095 .4738 m
.88095 .4738 L
s
.88102 .48471 m
.88102 .48471 L
s
.8811 .48707 m
.8811 .48707 L
s
.88118 .48812 m
.88118 .48812 L
s
.88125 .48648 m
.88125 .48648 L
s
.88132 .49 m
.88132 .49 L
s
.8814 .49047 m
.8814 .49047 L
s
.88147 .49071 m
.88147 .49071 L
s
.88155 .49329 m
.88155 .49329 L
s
.88162 .48789 m
.88162 .48789 L
s
.8817 .48119 m
.8817 .48119 L
s
.88177 .47533 m
.88177 .47533 L
s
.88184 .48014 m
.88184 .48014 L
s
.88192 .47955 m
.88192 .47955 L
s
.882 .48343 m
.882 .48343 L
s
.88207 .48284 m
.88207 .48284 L
s
.88214 .494 m
.88214 .494 L
s
.88221 .49857 m
.88221 .49857 L
s
.88229 .49811 m
.88229 .49811 L
s
.88236 .49682 m
.88236 .49682 L
s
.88244 .49283 m
.88244 .49283 L
s
.88251 .48518 m
.88251 .48518 L
s
.88259 .48483 m
.88259 .48483 L
s
.88266 .48625 m
.88266 .48625 L
s
.88273 .47638 m
.88273 .47638 L
s
.88281 .47767 m
.88281 .47767 L
s
.88288 .47662 m
.88288 .47662 L
s
.88296 .47591 m
.88296 .47591 L
s
.88303 .47873 m
.88303 .47873 L
s
.88311 .47861 m
.88311 .47861 L
s
.88318 .48084 m
.88318 .48084 L
s
.88326 .48695 m
.88326 .48695 L
s
.88333 .4832 m
.88333 .4832 L
s
.8834 .4839 m
.8834 .4839 L
s
.88347 .48331 m
.88347 .48331 L
s
.88355 .47638 m
.88355 .47638 L
s
.88363 .47744 m
.88363 .47744 L
s
.8837 .47897 m
.8837 .47897 L
s
.88377 .47979 m
.88377 .47979 L
s
.88385 .48695 m
.88385 .48695 L
s
.88392 .48859 m
.88392 .48859 L
s
.884 .48695 m
.884 .48695 L
s
.88407 .48578 m
.88407 .48578 L
s
.88415 .48355 m
.88415 .48355 L
s
.88422 .47685 m
.88422 .47685 L
s
.88429 .47109 m
.88429 .47109 L
s
.88437 .47204 m
.88437 .47204 L
s
.88444 .47321 m
.88444 .47321 L
s
.88452 .47627 m
.88452 .47627 L
s
.88459 .47673 m
.88459 .47673 L
s
.88467 .4792 m
.88467 .4792 L
s
.88474 .47544 m
.88474 .47544 L
s
.88482 .4832 m
.88482 .4832 L
s
.88489 .48742 m
.88489 .48742 L
s
.88497 .49059 m
.88497 .49059 L
s
.88504 .49259 m
.88504 .49259 L
s
.88511 .48919 m
.88511 .48919 L
s
.88518 .49588 m
.88518 .49588 L
s
.88526 .49388 m
.88526 .49388 L
s
.88533 .4893 m
.88533 .4893 L
s
.88541 .49353 m
.88541 .49353 L
s
.88548 .48977 m
.88548 .48977 L
s
.88556 .48178 m
.88556 .48178 L
s
.88563 .47944 m
.88563 .47944 L
s
.88571 .47438 m
.88571 .47438 L
s
.88579 .47263 m
.88579 .47263 L
s
.88585 .4691 m
.88585 .4691 L
s
.88593 .46734 m
.88593 .46734 L
s
.886 .46393 m
.886 .46393 L
s
.88608 .46992 m
.88608 .46992 L
s
.88615 .46945 m
.88615 .46945 L
s
.88623 .47556 m
.88623 .47556 L
s
.8863 .47286 m
.8863 .47286 L
s
.88638 .47216 m
.88638 .47216 L
s
.88645 .47756 m
.88645 .47756 L
s
.88653 .47591 m
.88653 .47591 L
s
.8866 .48471 m
.8866 .48471 L
s
.88667 .48683 m
.88667 .48683 L
s
.88674 .48518 m
.88674 .48518 L
s
.88682 .48273 m
.88682 .48273 L
s
.88689 .47897 m
.88689 .47897 L
s
.88697 .48273 m
.88697 .48273 L
s
.88704 .48695 m
.88704 .48695 L
s
.88712 .48625 m
.88712 .48625 L
s
.88719 .47685 m
.88719 .47685 L
s
.88727 .48084 m
.88727 .48084 L
s
.88735 .48273 m
.88735 .48273 L
s
.88742 .48518 m
.88742 .48518 L
s
.88749 .49082 m
.88749 .49082 L
s
.88756 .49283 m
.88756 .49283 L
s
.88764 .48848 m
.88764 .48848 L
s
.88771 .49 m
.88771 .49 L
s
.88779 .48824 m
.88779 .48824 L
s
.88786 .48518 m
.88786 .48518 L
s
.88794 .48155 m
.88794 .48155 L
s
.88801 .48108 m
.88801 .48108 L
s
.88809 .48131 m
.88809 .48131 L
s
.88816 .48343 m
.88816 .48343 L
s
.88824 .48966 m
.88824 .48966 L
s
.8883 .48812 m
.8883 .48812 L
s
.88838 .48789 m
.88838 .48789 L
s
.88845 .48543 m
.88845 .48543 L
s
.88853 .48707 m
.88853 .48707 L
s
.8886 .4859 m
.8886 .4859 L
s
.88868 .48919 m
.88868 .48919 L
s
.88875 .49236 m
.88875 .49236 L
s
.88883 .49071 m
.88883 .49071 L
s
.88891 .48812 m
.88891 .48812 L
s
.88898 .48296 m
.88898 .48296 L
s
.88905 .48566 m
.88905 .48566 L
s
.88912 .48402 m
.88912 .48402 L
s
.8892 .49224 m
.8892 .49224 L
s
.88927 .49224 m
.88927 .49224 L
s
.88935 .49224 m
.88935 .49224 L
s
.88942 .49705 m
.88942 .49705 L
s
.8895 .4974 m
.8895 .4974 L
s
.88957 .49164 m
.88957 .49164 L
s
.88964 .48977 m
.88964 .48977 L
s
.88972 .48648 m
.88972 .48648 L
s
.8898 .48554 m
.8898 .48554 L
s
.88987 .48754 m
.88987 .48754 L
s
.88994 .49129 m
.88994 .49129 L
s
.89001 .49458 m
.89001 .49458 L
s
.89009 .49611 m
.89009 .49611 L
s
.89016 .49341 m
.89016 .49341 L
s
.89024 .49176 m
.89024 .49176 L
s
.89031 .48672 m
.89031 .48672 L
s
.89039 .48777 m
.89039 .48777 L
s
.89046 .49 m
.89046 .49 L
s
.89054 .49236 m
.89054 .49236 L
s
.89062 .49106 m
.89062 .49106 L
s
.89068 .49118 m
.89068 .49118 L
s
.89076 .49388 m
.89076 .49388 L
s
.89083 .50186 m
.89083 .50186 L
s
.89091 .5048 m
.89091 .5048 L
s
.89098 .50011 m
.89098 .50011 L
s
.89106 .50633 m
.89106 .50633 L
s
.89113 .50163 m
.89113 .50163 L
s
.89121 .50128 m
.89121 .50128 L
s
.89127 .5048 m
.89127 .5048 L
s
.89135 .5048 m
.89135 .5048 L
s
.89143 .49952 m
.89143 .49952 L
s
.8915 .49294 m
.8915 .49294 L
s
.89157 .4859 m
.89157 .4859 L
s
.89165 .4873 m
.89165 .4873 L
s
.89172 .48636 m
.89172 .48636 L
s
.8918 .48613 m
.8918 .48613 L
s
.89187 .48977 m
.89187 .48977 L
s
.89195 .48777 m
.89195 .48777 L
s
.89202 .49188 m
.89202 .49188 L
s
.89209 .49283 m
.89209 .49283 L
s
.89217 .49717 m
.89217 .49717 L
s
.89225 .49576 m
.89225 .49576 L
s
.89232 .49447 m
.89232 .49447 L
s
.89239 .49353 m
.89239 .49353 L
s
.89247 .494 m
.89247 .494 L
s
.89254 .49529 m
.89254 .49529 L
s
.89262 .50433 m
.89262 .50433 L
s
.89269 .50363 m
.89269 .50363 L
s
.89277 .5061 m
.89277 .5061 L
s
.89284 .49564 m
.89284 .49564 L
s
.89291 .49164 m
.89291 .49164 L
s
.89298 .49 m
.89298 .49 L
s
.89306 .49106 m
.89306 .49106 L
s
.89313 .49576 m
.89313 .49576 L
s
.89321 .49 m
.89321 .49 L
s
.89328 .49435 m
.89328 .49435 L
s
.89336 .4994 m
.89336 .4994 L
s
.89343 .5055 m
.89343 .5055 L
s
.89351 .49893 m
.89351 .49893 L
s
.89359 .50246 m
.89359 .50246 L
s
.89365 .50257 m
.89365 .50257 L
s
.89373 .4994 m
.89373 .4994 L
s
.8938 .49376 m
.8938 .49376 L
s
.89388 .48872 m
.89388 .48872 L
s
.89395 .48942 m
.89395 .48942 L
s
.89403 .4866 m
.89403 .4866 L
s
.8941 .48378 m
.8941 .48378 L
s
.89418 .48131 m
.89418 .48131 L
s
.89425 .47802 m
.89425 .47802 L
s
.89433 .47709 m
.89433 .47709 L
s
.8944 .4799 m
.8944 .4799 L
s
.89447 .47591 m
.89447 .47591 L
s
.89454 .47591 m
.89454 .47591 L
s
.89462 .47615 m
.89462 .47615 L
s
.89469 .46934 m
.89469 .46934 L
s
.89477 .47239 m
.89477 .47239 L
s
.89484 .4738 m
.89484 .4738 L
s
.89492 .48143 m
.89492 .48143 L
s
.89499 .48061 m
.89499 .48061 L
s
.89507 .48084 m
.89507 .48084 L
s
.89515 .48178 m
.89515 .48178 L
s
.89522 .48789 m
.89522 .48789 L
s
.89529 .49024 m
.89529 .49024 L
s
.89536 .49365 m
.89536 .49365 L
s
.89544 .49224 m
.89544 .49224 L
s
.89551 .49388 m
.89551 .49388 L
s
.89559 .49764 m
.89559 .49764 L
s
.89566 .49012 m
.89566 .49012 L
s
.89574 .49752 m
.89574 .49752 L
s
.89581 .4947 m
.89581 .4947 L
s
.89589 .4947 m
.89589 .4947 L
s
.89596 .49893 m
.89596 .49893 L
s
.89604 .50034 m
.89604 .50034 L
s
.8961 .49882 m
.8961 .49882 L
s
.89618 .49353 m
.89618 .49353 L
s
.89625 .49458 m
.89625 .49458 L
s
.89633 .48483 m
.89633 .48483 L
s
.8964 .48954 m
.8964 .48954 L
s
.89648 .49318 m
.89648 .49318 L
s
.89655 .49071 m
.89655 .49071 L
s
.89663 .49752 m
.89663 .49752 L
s
.89671 .50293 m
.89671 .50293 L
s
.89678 .51114 m
.89678 .51114 L
s
.89685 .51467 m
.89685 .51467 L
s
.89692 .51114 m
.89692 .51114 L
s
.897 .51678 m
.897 .51678 L
s
.89707 .51467 m
.89707 .51467 L
s
.89715 .51302 m
.89715 .51302 L
s
.89722 .51502 m
.89722 .51502 L
s
.8973 .50962 m
.8973 .50962 L
s
.89737 .50692 m
.89737 .50692 L
s
.89745 .50715 m
.89745 .50715 L
s
.89752 .50903 m
.89752 .50903 L
s
.8976 .50927 m
.8976 .50927 L
s
.89767 .51349 m
.89767 .51349 L
s
.89774 .5075 m
.89774 .5075 L
s
.89781 .50692 m
.89781 .50692 L
s
.89789 .5082 m
.89789 .5082 L
s
.89796 .50222 m
.89796 .50222 L
s
.89804 .5061 m
.89804 .5061 L
s
.89811 .50257 m
.89811 .50257 L
s
.89819 .50492 m
.89819 .50492 L
s
.89826 .50727 m
.89826 .50727 L
s
.89834 .50575 m
.89834 .50575 L
s
.89842 .50962 m
.89842 .50962 L
s
.89848 .5149 m
.89848 .5149 L
s
.89856 .51984 m
.89856 .51984 L
s
.89863 .51714 m
.89863 .51714 L
s
.89871 .5223 m
.89871 .5223 L
s
.89878 .51807 m
.89878 .51807 L
s
.89886 .51737 m
.89886 .51737 L
s
.89893 .51467 m
.89893 .51467 L
s
.89901 .51408 m
.89901 .51408 L
s
.89908 .51513 m
.89908 .51513 L
s
.89916 .51443 m
.89916 .51443 L
s
.89923 .51995 m
.89923 .51995 L
s
.8993 .5122 m
.8993 .5122 L
s
.89937 .50939 m
.89937 .50939 L
s
.89945 .50738 m
.89945 .50738 L
s
.89952 .51244 m
.89952 .51244 L
s
.8996 .51572 m
.8996 .51572 L
s
.89967 .51737 m
.89967 .51737 L
s
.89975 .51502 m
.89975 .51502 L
s
.89982 .52325 m
.89982 .52325 L
s
.89989 .52301 m
.89989 .52301 L
s
.89997 .51513 m
.89997 .51513 L
s
.90005 .51972 m
.90005 .51972 L
s
.90012 .51901 m
.90012 .51901 L
s
.90019 .52007 m
.90019 .52007 L
s
.90027 .51702 m
.90027 .51702 L
s
.90034 .52136 m
.90034 .52136 L
s
.90042 .52124 m
.90042 .52124 L
s
.90049 .52266 m
.90049 .52266 L
s
.90057 .51502 m
.90057 .51502 L
s
.90064 .52077 m
.90064 .52077 L
s
.90071 .5169 m
.90071 .5169 L
s
.90079 .51667 m
.90079 .51667 L
s
.90086 .51326 m
.90086 .51326 L
s
.90093 .51044 m
.90093 .51044 L
s
.90101 .5142 m
.90101 .5142 L
s
.90108 .51244 m
.90108 .51244 L
s
.90116 .50997 m
.90116 .50997 L
s
.90123 .51079 m
.90123 .51079 L
s
.90131 .5095 m
.90131 .5095 L
s
.90139 .50774 m
.90139 .50774 L
s
.90145 .50069 m
.90145 .50069 L
s
.90153 .49494 m
.90153 .49494 L
s
.9016 .50316 m
.9016 .50316 L
s
.90168 .49987 m
.90168 .49987 L
s
.90175 .50504 m
.90175 .50504 L
s
.90183 .50622 m
.90183 .50622 L
s
.9019 .51173 m
.9019 .51173 L
s
.90198 .51925 m
.90198 .51925 L
s
.90205 .5162 m
.90205 .5162 L
s
.90213 .52171 m
.90213 .52171 L
s
.9022 .51843 m
.9022 .51843 L
s
.90227 .51937 m
.90227 .51937 L
s
.90234 .5149 m
.90234 .5149 L
s
.90242 .51196 m
.90242 .51196 L
s
.9025 .5082 m
.9025 .5082 L
s
.90257 .51091 m
.90257 .51091 L
s
.90264 .50832 m
.90264 .50832 L
s
.90272 .50515 m
.90272 .50515 L
s
.90279 .50304 m
.90279 .50304 L
s
.90287 .50304 m
.90287 .50304 L
s
.90295 .50468 m
.90295 .50468 L
s
.90302 .50669 m
.90302 .50669 L
s
.90309 .50915 m
.90309 .50915 L
s
.90316 .51819 m
.90316 .51819 L
s
.90324 .51784 m
.90324 .51784 L
s
.90331 .51256 m
.90331 .51256 L
s
.90339 .51208 m
.90339 .51208 L
s
.90346 .50774 m
.90346 .50774 L
s
.90354 .51056 m
.90354 .51056 L
s
.90361 .51513 m
.90361 .51513 L
s
.90369 .51208 m
.90369 .51208 L
s
.90376 .51302 m
.90376 .51302 L
s
.90384 .51056 m
.90384 .51056 L
s
.9039 .51256 m
.9039 .51256 L
s
.90398 .51056 m
.90398 .51056 L
s
.90405 .51267 m
.90405 .51267 L
s
.90413 .51725 m
.90413 .51725 L
s
.9042 .52348 m
.9042 .52348 L
s
.90428 .52523 m
.90428 .52523 L
s
.90435 .52794 m
.90435 .52794 L
s
.90443 .52759 m
.90443 .52759 L
s
.90451 .53029 m
.90451 .53029 L
s
.90458 .53545 m
.90458 .53545 L
s
.90465 .5425 m
.90465 .5425 L
s
.90472 .54438 m
.90472 .54438 L
s
.9048 .54438 m
.9048 .54438 L
s
.90487 .55225 m
.90487 .55225 L
s
.90495 .55389 m
.90495 .55389 L
s
.90502 .55436 m
.90502 .55436 L
s
.9051 .5499 m
.9051 .5499 L
s
.90517 .5526 m
.90517 .5526 L
s
.90525 .55413 m
.90525 .55413 L
s
.90532 .55624 m
.90532 .55624 L
s
.9054 .54802 m
.9054 .54802 L
s
.90547 .54027 m
.90547 .54027 L
s
.90554 .53909 m
.90554 .53909 L
s
.90561 .54238 m
.90561 .54238 L
s
.90569 .54333 m
.90569 .54333 L
s
.90576 .55014 m
.90576 .55014 L
s
.90584 .54415 m
.90584 .54415 L
s
.90591 .5425 m
.90591 .5425 L
s
.90599 .54191 m
.90599 .54191 L
s
.90606 .54273 m
.90606 .54273 L
s
.90614 .53698 m
.90614 .53698 L
s
.90622 .53933 m
.90622 .53933 L
s
.90628 .53545 m
.90628 .53545 L
s
.90636 .53733 m
.90636 .53733 L
s
.90643 .54191 m
.90643 .54191 L
s
.90651 .54144 m
.90651 .54144 L
s
.90658 .53487 m
.90658 .53487 L
s
.90666 .53651 m
.90666 .53651 L
s
.90673 .53381 m
.90673 .53381 L
s
.90681 .53733 m
.90681 .53733 L
s
.90688 .54238 m
.90688 .54238 L
s
.90696 .53816 m
.90696 .53816 L
s
.90703 .54132 m
.90703 .54132 L
s
.9071 .53557 m
.9071 .53557 L
s
.90717 .54261 m
.90717 .54261 L
s
.90725 .54191 m
.90725 .54191 L
s
.90732 .54179 m
.90732 .54179 L
s
.9074 .53969 m
.9074 .53969 L
s
.90747 .53111 m
.90747 .53111 L
s
.90755 .5297 m
.90755 .5297 L
s
.90762 .52829 m
.90762 .52829 L
s
.90769 .53064 m
.90769 .53064 L
s
.90777 .52888 m
.90777 .52888 L
s
.90785 .52923 m
.90785 .52923 L
s
.90792 .52947 m
.90792 .52947 L
s
.90799 .53064 m
.90799 .53064 L
s
.90807 .52441 m
.90807 .52441 L
s
.90814 .52336 m
.90814 .52336 L
s
.90822 .52348 m
.90822 .52348 L
s
.90829 .52336 m
.90829 .52336 L
s
.90837 .52841 m
.90837 .52841 L
s
.90844 .52371 m
.90844 .52371 L
s
.90851 .52406 m
.90851 .52406 L
s
.90859 .52218 m
.90859 .52218 L
s
.90867 .52594 m
.90867 .52594 L
s
.90873 .52383 m
.90873 .52383 L
s
.90881 .52278 m
.90881 .52278 L
s
.90888 .52523 m
.90888 .52523 L
s
.90896 .52677 m
.90896 .52677 L
s
.90903 .53099 m
.90903 .53099 L
s
.90911 .53017 m
.90911 .53017 L
s
.90919 .52994 m
.90919 .52994 L
s
.90925 .52935 m
.90925 .52935 L
s
.90933 .54039 m
.90933 .54039 L
s
.9094 .54226 m
.9094 .54226 L
s
.90948 .54638 m
.90948 .54638 L
s
.90955 .55014 m
.90955 .55014 L
s
.90963 .5546 m
.90963 .5546 L
s
.9097 .55319 m
.9097 .55319 L
s
.90978 .55119 m
.90978 .55119 L
s
.90985 .54837 m
.90985 .54837 L
s
.90993 .54203 m
.90993 .54203 L
s
.91 .54051 m
.91 .54051 L
s
.91007 .53334 m
.91007 .53334 L
s
.91014 .54074 m
.91014 .54074 L
s
.91022 .54074 m
.91022 .54074 L
s
.9103 .5438 m
.9103 .5438 L
s
.91037 .54415 m
.91037 .54415 L
s
.91044 .54191 m
.91044 .54191 L
s
.91052 .54309 m
.91052 .54309 L
s
.91059 .54884 m
.91059 .54884 L
s
.91067 .54966 m
.91067 .54966 L
s
.91075 .54954 m
.91075 .54954 L
s
.91082 .54979 m
.91082 .54979 L
s
.91089 .54638 m
.91089 .54638 L
s
.91096 .54285 m
.91096 .54285 L
s
.91104 .53898 m
.91104 .53898 L
s
.91111 .53839 m
.91111 .53839 L
s
.91119 .53604 m
.91119 .53604 L
s
.91126 .53839 m
.91126 .53839 L
s
.91134 .52958 m
.91134 .52958 L
s
.91141 .53428 m
.91141 .53428 L
s
.91149 .53698 m
.91149 .53698 L
s
.91156 .53757 m
.91156 .53757 L
s
.91164 .53522 m
.91164 .53522 L
s
.9117 .53005 m
.9117 .53005 L
s
.91178 .52453 m
.91178 .52453 L
s
.91185 .5257 m
.91185 .5257 L
s
.91193 .52453 m
.91193 .52453 L
s
.912 .52806 m
.912 .52806 L
s
.91208 .52899 m
.91208 .52899 L
s
.91215 .52759 m
.91215 .52759 L
s
.91223 .5263 m
.91223 .5263 L
s
.91231 .52253 m
.91231 .52253 L
s
.91238 .51796 m
.91238 .51796 L
s
.91245 .52817 m
.91245 .52817 L
s
.91252 .53111 m
.91252 .53111 L
s
.9126 .53146 m
.9126 .53146 L
s
.91267 .52911 m
.91267 .52911 L
s
.91275 .53111 m
.91275 .53111 L
s
.91282 .54004 m
.91282 .54004 L
s
.9129 .53557 m
.9129 .53557 L
s
.91297 .53886 m
.91297 .53886 L
s
.91305 .5465 m
.91305 .5465 L
s
.91312 .54814 m
.91312 .54814 L
s
.9132 .54344 m
.9132 .54344 L
s
.91327 .54426 m
.91327 .54426 L
s
.91334 .54755 m
.91334 .54755 L
s
.91341 .54861 m
.91341 .54861 L
s
.91349 .54943 m
.91349 .54943 L
s
.91356 .55061 m
.91356 .55061 L
s
.91364 .54825 m
.91364 .54825 L
s
.91371 .5452 m
.91371 .5452 L
s
.91379 .54966 m
.91379 .54966 L
s
.91387 .54872 m
.91387 .54872 L
s
.91394 .54931 m
.91394 .54931 L
s
.91402 .55049 m
.91402 .55049 L
s
.91408 .54954 m
.91408 .54954 L
s
.91416 .55354 m
.91416 .55354 L
s
.91423 .55166 m
.91423 .55166 L
s
.91431 .55037 m
.91431 .55037 L
s
.91438 .54685 m
.91438 .54685 L
s
.91446 .55096 m
.91446 .55096 L
s
.91453 .55037 m
.91453 .55037 L
s
.91461 .55425 m
.91461 .55425 L
s
.91468 .55789 m
.91468 .55789 L
s
.91476 .55483 m
.91476 .55483 L
s
.91483 .55742 m
.91483 .55742 L
s
.9149 .55953 m
.9149 .55953 L
s
.91497 .55518 m
.91497 .55518 L
s
.91505 .54872 m
.91505 .54872 L
s
.91512 .54273 m
.91512 .54273 L
s
.9152 .53733 m
.9152 .53733 L
s
.91527 .53111 m
.91527 .53111 L
s
.91535 .53111 m
.91535 .53111 L
s
.91542 .52735 m
.91542 .52735 L
s
.9155 .53428 m
.9155 .53428 L
s
.91558 .52852 m
.91558 .52852 L
s
.91565 .53041 m
.91565 .53041 L
s
.91572 .53792 m
.91572 .53792 L
s
.91579 .53557 m
.91579 .53557 L
s
.91587 .53487 m
.91587 .53487 L
s
.91594 .53099 m
.91594 .53099 L
s
.91602 .53334 m
.91602 .53334 L
s
.91609 .53275 m
.91609 .53275 L
s
.91617 .53169 m
.91617 .53169 L
s
.91624 .53522 m
.91624 .53522 L
s
.91631 .53745 m
.91631 .53745 L
s
.91639 .53909 m
.91639 .53909 L
s
.91647 .53522 m
.91647 .53522 L
s
.91653 .53134 m
.91653 .53134 L
s
.91661 .52782 m
.91661 .52782 L
s
.91668 .52594 m
.91668 .52594 L
s
.91676 .52806 m
.91676 .52806 L
s
.91683 .52476 m
.91683 .52476 L
s
.91691 .51937 m
.91691 .51937 L
s
.91699 .51749 m
.91699 .51749 L
s
.91705 .51972 m
.91705 .51972 L
s
.91713 .51361 m
.91713 .51361 L
s
.91721 .51396 m
.91721 .51396 L
s
.91728 .51572 m
.91728 .51572 L
s
.91735 .50867 m
.91735 .50867 L
s
.91743 .51196 m
.91743 .51196 L
s
.9175 .51667 m
.9175 .51667 L
s
.91758 .51678 m
.91758 .51678 L
s
.91765 .52183 m
.91765 .52183 L
s
.91773 .5243 m
.91773 .5243 L
s
.9178 .52101 m
.9178 .52101 L
s
.91787 .52253 m
.91787 .52253 L
s
.91794 .52136 m
.91794 .52136 L
s
.91802 .52101 m
.91802 .52101 L
s
.9181 .52289 m
.9181 .52289 L
s
.91817 .52171 m
.91817 .52171 L
s
.91824 .51349 m
.91824 .51349 L
s
.91832 .50598 m
.91832 .50598 L
s
.91839 .51021 m
.91839 .51021 L
s
.91847 .5048 m
.91847 .5048 L
s
.91855 .50879 m
.91855 .50879 L
s
.91862 .50797 m
.91862 .50797 L
s
.91869 .50903 m
.91869 .50903 L
s
.91876 .50351 m
.91876 .50351 L
s
.91884 .50116 m
.91884 .50116 L
s
.91891 .50445 m
.91891 .50445 L
s
.91899 .5041 m
.91899 .5041 L
s
.91906 .51021 m
.91906 .51021 L
s
.91914 .5156 m
.91914 .5156 L
s
.91921 .51443 m
.91921 .51443 L
s
.91929 .51843 m
.91929 .51843 L
s
.91936 .51608 m
.91936 .51608 L
s
.91944 .51761 m
.91944 .51761 L
s
.9195 .52371 m
.9195 .52371 L
s
.91958 .52852 m
.91958 .52852 L
s
.91965 .52782 m
.91965 .52782 L
s
.91973 .53299 m
.91973 .53299 L
s
.9198 .53146 m
.9198 .53146 L
s
.91988 .52712 m
.91988 .52712 L
s
.91995 .52242 m
.91995 .52242 L
s
.92003 .5263 m
.92003 .5263 L
s
.92011 .53358 m
.92011 .53358 L
s
.92018 .53064 m
.92018 .53064 L
s
.92025 .53041 m
.92025 .53041 L
s
.92032 .53064 m
.92032 .53064 L
s
.9204 .53099 m
.9204 .53099 L
s
.92047 .5378 m
.92047 .5378 L
s
.92055 .53921 m
.92055 .53921 L
s
.92062 .53792 m
.92062 .53792 L
s
.9207 .54027 m
.9207 .54027 L
s
.92077 .53981 m
.92077 .53981 L
s
.92085 .53698 m
.92085 .53698 L
s
.92092 .53722 m
.92092 .53722 L
s
.921 .53134 m
.921 .53134 L
s
.92107 .53346 m
.92107 .53346 L
s
.92114 .53111 m
.92114 .53111 L
s
.92121 .53005 m
.92121 .53005 L
s
.92129 .52817 m
.92129 .52817 L
s
.92136 .52724 m
.92136 .52724 L
s
.92144 .52735 m
.92144 .52735 L
s
.92151 .52806 m
.92151 .52806 L
s
.92159 .53005 m
.92159 .53005 L
s
.92167 .53393 m
.92167 .53393 L
s
.92174 .53216 m
.92174 .53216 L
s
.92182 .53499 m
.92182 .53499 L
s
.92188 .53393 m
.92188 .53393 L
s
.92196 .53475 m
.92196 .53475 L
s
.92203 .53698 m
.92203 .53698 L
s
.92211 .53839 m
.92211 .53839 L
s
.92218 .54144 m
.92218 .54144 L
s
.92226 .53804 m
.92226 .53804 L
s
.92233 .5351 m
.92233 .5351 L
s
.92241 .5351 m
.92241 .5351 L
s
.92248 .53181 m
.92248 .53181 L
s
.92256 .53181 m
.92256 .53181 L
s
.92263 .52923 m
.92263 .52923 L
s
.9227 .53628 m
.9227 .53628 L
s
.92277 .54156 m
.92277 .54156 L
s
.92285 .54063 m
.92285 .54063 L
s
.92292 .5425 m
.92292 .5425 L
s
.923 .54238 m
.923 .54238 L
s
.92307 .53862 m
.92307 .53862 L
s
.92315 .54415 m
.92315 .54415 L
s
.92322 .53698 m
.92322 .53698 L
s
.9233 .5351 m
.9233 .5351 L
s
.92338 .53651 m
.92338 .53651 L
s
.92345 .53827 m
.92345 .53827 L
s
.92352 .54039 m
.92352 .54039 L
s
.92359 .53851 m
.92359 .53851 L
s
.92367 .53874 m
.92367 .53874 L
s
.92374 .54051 m
.92374 .54051 L
s
.92382 .53663 m
.92382 .53663 L
s
.92389 .53417 m
.92389 .53417 L
s
.92397 .53428 m
.92397 .53428 L
s
.92404 .5344 m
.92404 .5344 L
s
.92412 .53334 m
.92412 .53334 L
s
.92419 .53064 m
.92419 .53064 L
s
.92427 .53534 m
.92427 .53534 L
s
.92433 .53158 m
.92433 .53158 L
s
.92441 .53041 m
.92441 .53041 L
s
.92448 .52935 m
.92448 .52935 L
s
.92456 .53169 m
.92456 .53169 L
s
.92463 .53181 m
.92463 .53181 L
s
.92471 .52594 m
.92471 .52594 L
s
.92479 .52124 m
.92479 .52124 L
s
.92485 .52371 m
.92485 .52371 L
s
.92493 .52512 m
.92493 .52512 L
s
.92501 .52418 m
.92501 .52418 L
s
.92508 .52958 m
.92508 .52958 L
s
.92515 .53687 m
.92515 .53687 L
s
.92523 .54168 m
.92523 .54168 L
s
.9253 .5445 m
.9253 .5445 L
s
.92538 .54074 m
.92538 .54074 L
s
.92545 .53346 m
.92545 .53346 L
s
.92553 .5351 m
.92553 .5351 L
s
.9256 .53534 m
.9256 .53534 L
s
.92567 .53323 m
.92567 .53323 L
s
.92575 .53839 m
.92575 .53839 L
s
.92583 .54368 m
.92583 .54368 L
s
.9259 .53981 m
.9259 .53981 L
s
.92597 .54109 m
.92597 .54109 L
s
.92604 .54074 m
.92604 .54074 L
s
.92612 .53675 m
.92612 .53675 L
s
.92619 .54051 m
.92619 .54051 L
s
.92627 .53675 m
.92627 .53675 L
s
.92635 .53816 m
.92635 .53816 L
s
.92642 .53687 m
.92642 .53687 L
s
.92649 .53475 m
.92649 .53475 L
s
.92656 .54261 m
.92656 .54261 L
s
.92664 .54779 m
.92664 .54779 L
s
.92671 .54767 m
.92671 .54767 L
s
.92679 .55014 m
.92679 .55014 L
s
.92686 .55719 m
.92686 .55719 L
s
.92694 .556 m
.92694 .556 L
s
.92701 .55647 m
.92701 .55647 L
s
.92709 .55929 m
.92709 .55929 L
s
.92716 .55719 m
.92716 .55719 L
s
.92724 .55413 m
.92724 .55413 L
s
.9273 .54919 m
.9273 .54919 L
s
.92738 .55166 m
.92738 .55166 L
s
.92746 .55143 m
.92746 .55143 L
s
.92753 .5519 m
.92753 .5519 L
s
.9276 .54931 m
.9276 .54931 L
s
.92768 .55271 m
.92768 .55271 L
s
.92775 .54544 m
.92775 .54544 L
s
.92783 .55131 m
.92783 .55131 L
s
.92791 .55331 m
.92791 .55331 L
s
.92798 .55354 m
.92798 .55354 L
s
.92805 .5519 m
.92805 .5519 L
s
.92812 .55271 m
.92812 .55271 L
s
.9282 .54708 m
.9282 .54708 L
s
.92827 .54685 m
.92827 .54685 L
s
.92835 .54743 m
.92835 .54743 L
s
.92842 .54109 m
.92842 .54109 L
s
.9285 .54344 m
.9285 .54344 L
s
.92857 .54333 m
.92857 .54333 L
s
.92865 .54168 m
.92865 .54168 L
s
.92872 .54097 m
.92872 .54097 L
s
.9288 .54473 m
.9288 .54473 L
s
.92887 .54708 m
.92887 .54708 L
s
.92894 .54673 m
.92894 .54673 L
s
.92901 .54614 m
.92901 .54614 L
s
.92909 .54497 m
.92909 .54497 L
s
.92916 .54438 m
.92916 .54438 L
s
.92924 .54368 m
.92924 .54368 L
s
.92931 .54261 m
.92931 .54261 L
s
.92939 .54626 m
.92939 .54626 L
s
.92947 .54849 m
.92947 .54849 L
s
.92954 .55554 m
.92954 .55554 L
s
.92962 .55413 m
.92962 .55413 L
s
.92968 .55507 m
.92968 .55507 L
s
.92976 .55225 m
.92976 .55225 L
s
.92983 .55859 m
.92983 .55859 L
s
.92991 .55448 m
.92991 .55448 L
s
.92998 .55672 m
.92998 .55672 L
s
.93006 .55917 m
.93006 .55917 L
s
.93013 .55953 m
.93013 .55953 L
s
.93021 .56223 m
.93021 .56223 L
s
.93028 .56059 m
.93028 .56059 L
s
.93036 .56235 m
.93036 .56235 L
s
.93043 .56247 m
.93043 .56247 L
s
.9305 .56235 m
.9305 .56235 L
s
.93057 .56305 m
.93057 .56305 L
s
.93065 .57069 m
.93065 .57069 L
s
.93072 .57009 m
.93072 .57009 L
s
.9308 .57022 m
.9308 .57022 L
s
.93087 .56575 m
.93087 .56575 L
s
.93095 .56881 m
.93095 .56881 L
s
.93103 .57057 m
.93103 .57057 L
s
.9311 .56811 m
.9311 .56811 L
s
.93118 .56634 m
.93118 .56634 L
s
.93125 .56634 m
.93125 .56634 L
s
.93132 .56364 m
.93132 .56364 L
s
.93139 .56564 m
.93139 .56564 L
s
.93147 .562 m
.93147 .562 L
s
.93154 .558 m
.93154 .558 L
s
.93162 .558 m
.93162 .558 L
s
.93169 .55307 m
.93169 .55307 L
s
.93177 .54673 m
.93177 .54673 L
s
.93184 .54872 m
.93184 .54872 L
s
.93192 .54837 m
.93192 .54837 L
s
.93199 .55084 m
.93199 .55084 L
s
.93207 .55201 m
.93207 .55201 L
s
.93213 .55131 m
.93213 .55131 L
s
.93221 .55283 m
.93221 .55283 L
s
.93228 .5553 m
.93228 .5553 L
s
.93236 .5526 m
.93236 .5526 L
s
.93243 .54861 m
.93243 .54861 L
s
.93251 .54273 m
.93251 .54273 L
s
.93259 .55061 m
.93259 .55061 L
s
.93266 .55096 m
.93266 .55096 L
s
.93274 .55295 m
.93274 .55295 L
s
.93281 .54602 m
.93281 .54602 L
s
.93288 .54544 m
.93288 .54544 L
s
.93295 .54215 m
.93295 .54215 L
s
.93303 .53839 m
.93303 .53839 L
s
.9331 .53898 m
.9331 .53898 L
s
.93318 .53851 m
.93318 .53851 L
s
.93325 .54179 m
.93325 .54179 L
s
.93333 .53698 m
.93333 .53698 L
s
.9334 .53981 m
.9334 .53981 L
s
.93347 .54121 m
.93347 .54121 L
s
.93355 .54168 m
.93355 .54168 L
s
.93363 .54121 m
.93363 .54121 L
s
.9337 .53205 m
.9337 .53205 L
s
.93377 .53687 m
.93377 .53687 L
s
.93384 .5364 m
.93384 .5364 L
s
.93392 .53076 m
.93392 .53076 L
s
.93399 .5257 m
.93399 .5257 L
s
.93407 .527 m
.93407 .527 L
s
.93415 .52582 m
.93415 .52582 L
s
.93422 .52665 m
.93422 .52665 L
s
.93429 .52054 m
.93429 .52054 L
s
.93437 .51455 m
.93437 .51455 L
s
.93445 .50997 m
.93445 .50997 L
s
.93452 .5082 m
.93452 .5082 L
s
.93459 .51044 m
.93459 .51044 L
s
.93466 .50832 m
.93466 .50832 L
s
.93474 .51443 m
.93474 .51443 L
s
.93481 .51314 m
.93481 .51314 L
s
.93489 .51912 m
.93489 .51912 L
s
.93496 .51901 m
.93496 .51901 L
s
.93504 .52077 m
.93504 .52077 L
s
.9351 .51608 m
.9351 .51608 L
s
.93518 .5257 m
.93518 .5257 L
s
.93526 .52712 m
.93526 .52712 L
s
.93533 .53311 m
.93533 .53311 L
s
.9354 .53463 m
.9354 .53463 L
s
.93548 .53745 m
.93548 .53745 L
s
.93555 .54016 m
.93555 .54016 L
s
.93563 .54614 m
.93563 .54614 L
s
.93571 .55061 m
.93571 .55061 L
s
.93578 .55037 m
.93578 .55037 L
s
.93585 .56388 m
.93585 .56388 L
s
.93592 .56787 m
.93592 .56787 L
s
.936 .56705 m
.936 .56705 L
s
.93608 .56729 m
.93608 .56729 L
s
.93615 .56928 m
.93615 .56928 L
s
.93622 .57457 m
.93622 .57457 L
s
.9363 .57069 m
.9363 .57069 L
s
.93637 .57092 m
.93637 .57092 L
s
.93645 .57503 m
.93645 .57503 L
s
.93652 .58008 m
.93652 .58008 L
s
.9366 .5856 m
.9366 .5856 L
s
.93667 .58713 m
.93667 .58713 L
s
.93674 .58665 m
.93674 .58665 L
s
.93681 .59183 m
.93681 .59183 L
s
.93689 .58889 m
.93689 .58889 L
s
.93696 .5883 m
.93696 .5883 L
s
.93704 .58748 m
.93704 .58748 L
s
.93711 .58866 m
.93711 .58866 L
s
.93719 .58348 m
.93719 .58348 L
s
.93727 .57609 m
.93727 .57609 L
s
.93734 .57468 m
.93734 .57468 L
s
.93742 .5721 m
.93742 .5721 L
s
.93749 .56435 m
.93749 .56435 L
s
.93756 .56634 m
.93756 .56634 L
s
.93763 .57151 m
.93763 .57151 L
s
.93771 .57045 m
.93771 .57045 L
s
.93778 .57292 m
.93778 .57292 L
s
.93786 .57398 m
.93786 .57398 L
s
.93793 .57186 m
.93793 .57186 L
s
.93801 .57034 m
.93801 .57034 L
s
.93808 .56963 m
.93808 .56963 L
s
.93816 .57009 m
.93816 .57009 L
s
.93823 .5748 m
.93823 .5748 L
s
.9383 .57679 m
.9383 .57679 L
s
.93837 .57762 m
.93837 .57762 L
s
.93845 .58278 m
.93845 .58278 L
s
.93852 .58549 m
.93852 .58549 L
s
.9386 .58266 m
.9386 .58266 L
s
.93867 .58208 m
.93867 .58208 L
s
.93875 .58067 m
.93875 .58067 L
s
.93883 .57268 m
.93883 .57268 L
s
.9389 .5721 m
.9389 .5721 L
s
.93898 .57104 m
.93898 .57104 L
s
.93905 .57339 m
.93905 .57339 L
s
.93912 .57151 m
.93912 .57151 L
s
.93919 .56211 m
.93919 .56211 L
s
.93927 .55953 m
.93927 .55953 L
s
.93934 .55295 m
.93934 .55295 L
s
.93942 .55425 m
.93942 .55425 L
s
.93949 .55495 m
.93949 .55495 L
s
.93957 .55448 m
.93957 .55448 L
s
.93964 .55589 m
.93964 .55589 L
s
.93972 .54979 m
.93972 .54979 L
s
.93979 .54814 m
.93979 .54814 L
s
.93987 .55507 m
.93987 .55507 L
s
.93993 .55389 m
.93993 .55389 L
s
.94001 .5553 m
.94001 .5553 L
s
.94008 .56153 m
.94008 .56153 L
s
.94016 .56575 m
.94016 .56575 L
s
.94023 .56564 m
.94023 .56564 L
s
.94031 .56951 m
.94031 .56951 L
s
.94039 .57303 m
.94039 .57303 L
s
.94046 .57386 m
.94046 .57386 L
s
.94054 .57832 m
.94054 .57832 L
s
.94061 .58079 m
.94061 .58079 L
s
.94068 .58137 m
.94068 .58137 L
s
.94075 .57973 m
.94075 .57973 L
s
.94083 .57609 m
.94083 .57609 L
s
.9409 .56904 m
.9409 .56904 L
s
.94098 .56411 m
.94098 .56411 L
s
.94105 .55953 m
.94105 .55953 L
s
.94113 .56165 m
.94113 .56165 L
s
.9412 .56399 m
.9412 .56399 L
s
.94128 .56916 m
.94128 .56916 L
s
.94135 .56834 m
.94135 .56834 L
s
.94143 .57057 m
.94143 .57057 L
s
.9415 .57727 m
.9415 .57727 L
s
.94157 .57973 m
.94157 .57973 L
s
.94164 .57644 m
.94164 .57644 L
s
.94172 .58032 m
.94172 .58032 L
s
.94179 .57903 m
.94179 .57903 L
s
.94187 .58091 m
.94187 .58091 L
s
.94195 .58114 m
.94195 .58114 L
s
.94202 .58642 m
.94202 .58642 L
s
.94209 .59136 m
.94209 .59136 L
s
.94217 .58513 m
.94217 .58513 L
s
.94225 .5849 m
.94225 .5849 L
s
.94232 .58373 m
.94232 .58373 L
s
.94239 .57527 m
.94239 .57527 L
s
.94246 .57691 m
.94246 .57691 L
s
.94254 .5748 m
.94254 .5748 L
s
.94261 .57774 m
.94261 .57774 L
s
.94269 .57667 m
.94269 .57667 L
s
.94276 .57327 m
.94276 .57327 L
s
.94284 .5647 m
.94284 .5647 L
s
.94291 .56646 m
.94291 .56646 L
s
.94299 .56106 m
.94299 .56106 L
s
.94306 .56411 m
.94306 .56411 L
s
.94313 .56188 m
.94313 .56188 L
s
.9432 .56376 m
.9432 .56376 L
s
.94328 .55789 m
.94328 .55789 L
s
.94335 .5553 m
.94335 .5553 L
s
.94343 .5573 m
.94343 .5573 L
s
.94351 .55859 m
.94351 .55859 L
s
.94358 .56024 m
.94358 .56024 L
s
.94365 .5573 m
.94365 .5573 L
s
.94372 .56775 m
.94372 .56775 L
s
.9438 .57363 m
.9438 .57363 L
s
.94388 .57081 m
.94388 .57081 L
s
.94395 .57104 m
.94395 .57104 L
s
.94402 .56353 m
.94402 .56353 L
s
.9441 .55871 m
.9441 .55871 L
s
.94417 .55847 m
.94417 .55847 L
s
.94425 .56036 m
.94425 .56036 L
s
.94432 .56036 m
.94432 .56036 L
s
.9444 .55929 m
.9444 .55929 L
s
.94447 .55565 m
.94447 .55565 L
s
.94454 .55448 m
.94454 .55448 L
s
.94462 .55448 m
.94462 .55448 L
s
.9447 .55131 m
.9447 .55131 L
s
.94476 .55037 m
.94476 .55037 L
s
.94484 .55108 m
.94484 .55108 L
s
.94491 .55518 m
.94491 .55518 L
s
.94499 .55483 m
.94499 .55483 L
s
.94507 .55859 m
.94507 .55859 L
s
.94514 .55742 m
.94514 .55742 L
s
.94522 .56036 m
.94522 .56036 L
s
.94529 .55565 m
.94529 .55565 L
s
.94536 .56247 m
.94536 .56247 L
s
.94543 .56235 m
.94543 .56235 L
s
.94551 .56024 m
.94551 .56024 L
s
.94558 .56118 m
.94558 .56118 L
s
.94566 .55507 m
.94566 .55507 L
s
.94573 .55906 m
.94573 .55906 L
s
.94581 .56411 m
.94581 .56411 L
s
.94588 .56223 m
.94588 .56223 L
s
.94596 .55824 m
.94596 .55824 L
s
.94603 .56071 m
.94603 .56071 L
s
.9461 .55742 m
.9461 .55742 L
s
.94617 .55507 m
.94617 .55507 L
s
.94625 .55624 m
.94625 .55624 L
s
.94633 .55871 m
.94633 .55871 L
s
.9464 .56176 m
.9464 .56176 L
s
.94647 .5647 m
.94647 .5647 L
s
.94655 .56622 m
.94655 .56622 L
s
.94663 .56305 m
.94663 .56305 L
s
.9467 .55483 m
.9467 .55483 L
s
.94678 .55319 m
.94678 .55319 L
s
.94685 .5546 m
.94685 .5546 L
s
.94692 .5452 m
.94692 .5452 L
s
.94699 .54673 m
.94699 .54673 L
s
.94707 .54321 m
.94707 .54321 L
s
.94714 .54297 m
.94714 .54297 L
s
.94722 .53957 m
.94722 .53957 L
s
.94729 .54004 m
.94729 .54004 L
s
.94737 .53698 m
.94737 .53698 L
s
.94744 .54191 m
.94744 .54191 L
s
.94752 .53615 m
.94752 .53615 L
s
.94759 .52947 m
.94759 .52947 L
s
.94767 .53158 m
.94767 .53158 L
s
.94773 .53545 m
.94773 .53545 L
s
.94781 .53123 m
.94781 .53123 L
s
.94788 .53158 m
.94788 .53158 L
s
.94796 .53158 m
.94796 .53158 L
s
.94803 .52677 m
.94803 .52677 L
s
.94811 .52124 m
.94811 .52124 L
s
.94819 .53263 m
.94819 .53263 L
s
.94826 .53334 m
.94826 .53334 L
s
.94834 .5337 m
.94834 .5337 L
s
.94841 .53334 m
.94841 .53334 L
s
.94848 .54097 m
.94848 .54097 L
s
.94855 .53944 m
.94855 .53944 L
s
.94863 .54156 m
.94863 .54156 L
s
.9487 .53393 m
.9487 .53393 L
s
.94878 .53698 m
.94878 .53698 L
s
.94885 .53757 m
.94885 .53757 L
s
.94893 .53323 m
.94893 .53323 L
s
.949 .53134 m
.949 .53134 L
s
.94908 .52641 m
.94908 .52641 L
s
.94915 .52747 m
.94915 .52747 L
s
.94923 .53111 m
.94923 .53111 L
s
.9493 .53134 m
.9493 .53134 L
s
.94937 .52876 m
.94937 .52876 L
s
.94944 .51937 m
.94944 .51937 L
s
.94952 .52171 m
.94952 .52171 L
s
.94959 .51725 m
.94959 .51725 L
s
.94967 .51585 m
.94967 .51585 L
s
.94975 .52183 m
.94975 .52183 L
s
.94982 .51737 m
.94982 .51737 L
s
.9499 .52077 m
.9499 .52077 L
s
.94997 .52042 m
.94997 .52042 L
s
.95005 .51667 m
.95005 .51667 L
s
.95012 .50727 m
.95012 .50727 L
s
.95019 .50433 m
.95019 .50433 L
s
.95026 .49846 m
.95026 .49846 L
s
.95034 .49247 m
.95034 .49247 L
s
.95041 .49752 m
.95041 .49752 L
s
.95049 .49929 m
.95049 .49929 L
s
.95056 .50222 m
.95056 .50222 L
s
.95064 .50433 m
.95064 .50433 L
s
.95071 .49917 m
.95071 .49917 L
s
.95079 .50234 m
.95079 .50234 L
s
.95086 .5061 m
.95086 .5061 L
s
.95093 .50539 m
.95093 .50539 L
s
.951 .50915 m
.951 .50915 L
s
.95108 .50575 m
.95108 .50575 L
s
.95115 .51091 m
.95115 .51091 L
s
.95123 .51725 m
.95123 .51725 L
s
.95131 .52042 m
.95131 .52042 L
s
.95138 .51995 m
.95138 .51995 L
s
.95145 .52253 m
.95145 .52253 L
s
.95153 .51714 m
.95153 .51714 L
s
.9516 .51525 m
.9516 .51525 L
s
.95168 .51655 m
.95168 .51655 L
s
.95175 .51725 m
.95175 .51725 L
s
.95182 .51161 m
.95182 .51161 L
s
.9519 .51232 m
.9519 .51232 L
s
.95197 .5095 m
.95197 .5095 L
s
.95205 .51044 m
.95205 .51044 L
s
.95212 .5142 m
.95212 .5142 L
s
.9522 .51714 m
.9522 .51714 L
s
.95227 .51843 m
.95227 .51843 L
s
.95234 .51596 m
.95234 .51596 L
s
.95242 .5196 m
.95242 .5196 L
s
.9525 .51678 m
.9525 .51678 L
s
.95256 .51901 m
.95256 .51901 L
s
.95264 .52218 m
.95264 .52218 L
s
.95271 .51984 m
.95271 .51984 L
s
.95279 .51373 m
.95279 .51373 L
s
.95287 .51443 m
.95287 .51443 L
s
.95294 .51549 m
.95294 .51549 L
s
.95302 .51338 m
.95302 .51338 L
s
.95309 .51009 m
.95309 .51009 L
s
.95316 .51784 m
.95316 .51784 L
s
.95324 .52476 m
.95324 .52476 L
s
.95331 .52923 m
.95331 .52923 L
s
.95338 .5358 m
.95338 .5358 L
s
.95346 .53933 m
.95346 .53933 L
s
.95353 .52994 m
.95353 .52994 L
s
.95361 .52724 m
.95361 .52724 L
s
.95368 .52007 m
.95368 .52007 L
s
.95376 .52077 m
.95376 .52077 L
s
.95383 .52183 m
.95383 .52183 L
s
.9539 .52019 m
.9539 .52019 L
s
.95397 .51843 m
.95397 .51843 L
s
.95405 .51596 m
.95405 .51596 L
s
.95413 .51126 m
.95413 .51126 L
s
.9542 .51021 m
.9542 .51021 L
s
.95427 .50433 m
.95427 .50433 L
s
.95435 .50527 m
.95435 .50527 L
s
.95443 .50974 m
.95443 .50974 L
s
.9545 .51349 m
.9545 .51349 L
s
.95458 .51443 m
.95458 .51443 L
s
.95465 .51608 m
.95465 .51608 L
s
.95472 .51443 m
.95472 .51443 L
s
.95479 .5142 m
.95479 .5142 L
s
.95487 .51667 m
.95487 .51667 L
s
.95495 .52195 m
.95495 .52195 L
s
.95502 .51819 m
.95502 .51819 L
s
.95509 .51373 m
.95509 .51373 L
s
.95517 .51714 m
.95517 .51714 L
s
.95524 .51608 m
.95524 .51608 L
s
.95532 .5162 m
.95532 .5162 L
s
.95539 .51326 m
.95539 .51326 L
s
.95547 .50598 m
.95547 .50598 L
s
.95553 .5055 m
.95553 .5055 L
s
.95561 .50832 m
.95561 .50832 L
s
.95568 .5041 m
.95568 .5041 L
s
.95576 .50762 m
.95576 .50762 L
s
.95583 .50903 m
.95583 .50903 L
s
.95591 .50457 m
.95591 .50457 L
s
.95599 .49917 m
.95599 .49917 L
s
.95606 .50669 m
.95606 .50669 L
s
.95614 .50527 m
.95614 .50527 L
s
.95621 .50974 m
.95621 .50974 L
s
.95628 .51173 m
.95628 .51173 L
s
.95635 .51021 m
.95635 .51021 L
s
.95643 .50879 m
.95643 .50879 L
s
.9565 .49917 m
.9565 .49917 L
s
.95658 .50386 m
.95658 .50386 L
s
.95665 .5021 m
.95665 .5021 L
s
.95673 .50104 m
.95673 .50104 L
s
.9568 .49553 m
.9568 .49553 L
s
.95688 .49247 m
.95688 .49247 L
s
.95695 .49458 m
.95695 .49458 L
s
.95703 .4994 m
.95703 .4994 L
s
.9571 .50539 m
.9571 .50539 L
s
.95717 .50515 m
.95717 .50515 L
s
.95724 .5048 m
.95724 .5048 L
s
.95732 .50492 m
.95732 .50492 L
s
.95739 .5014 m
.95739 .5014 L
s
.95747 .50069 m
.95747 .50069 L
s
.95755 .49646 m
.95755 .49646 L
s
.95762 .4954 m
.95762 .4954 L
s
0 1 1 0 k
.21472 .13205 m
.21472 .13205 L
s
.21479 .13322 m
.21479 .13322 L
s
.21487 .13275 m
.21487 .13275 L
s
.21495 .13205 m
.21495 .13205 L
s
.21502 .13322 m
.21502 .13322 L
s
.2151 .13415 m
.2151 .13415 L
s
.21517 .13439 m
.21517 .13439 L
s
.21525 .13369 m
.21525 .13369 L
s
.21532 .13415 m
.21532 .13415 L
s
.2154 .13486 m
.2154 .13486 L
s
.21547 .13369 m
.21547 .13369 L
s
.21554 .13509 m
.21554 .13509 L
s
.21561 .13533 m
.21561 .13533 L
s
.21569 .13533 m
.21569 .13533 L
s
.21576 .13651 m
.21576 .13651 L
s
.21584 .13768 m
.21584 .13768 L
s
.21591 .13721 m
.21591 .13721 L
s
.21599 .13815 m
.21599 .13815 L
s
.21606 .13791 m
.21606 .13791 L
s
.21613 .13768 m
.21613 .13768 L
s
.21621 .13909 m
.21621 .13909 L
s
.21629 .13721 m
.21629 .13721 L
s
.21636 .13768 m
.21636 .13768 L
s
.21643 .13627 m
.21643 .13627 L
s
.21651 .13674 m
.21651 .13674 L
s
.21658 .13768 m
.21658 .13768 L
s
.21666 .13721 m
.21666 .13721 L
s
.21673 .13838 m
.21673 .13838 L
s
.21681 .13721 m
.21681 .13721 L
s
.21688 .13909 m
.21688 .13909 L
s
.21695 .13627 m
.21695 .13627 L
s
.21703 .13768 m
.21703 .13768 L
s
.21711 .13627 m
.21711 .13627 L
s
.21717 .13815 m
.21717 .13815 L
s
.21725 .13791 m
.21725 .13791 L
s
.21732 .13768 m
.21732 .13768 L
s
.2174 .13768 m
.2174 .13768 L
s
.21747 .13909 m
.21747 .13909 L
s
.21755 .13861 m
.21755 .13861 L
s
.21762 .13791 m
.21762 .13791 L
s
.21769 .13933 m
.21769 .13933 L
s
.21776 .13956 m
.21776 .13956 L
s
.21784 .14097 m
.21784 .14097 L
s
.21792 .13956 m
.21792 .13956 L
s
.21799 .1405 m
.21799 .1405 L
s
.21807 .13956 m
.21807 .13956 L
s
.21814 .13909 m
.21814 .13909 L
s
.21822 .13956 m
.21822 .13956 L
s
.21829 .1405 m
.21829 .1405 L
s
.21837 .13956 m
.21837 .13956 L
s
.21844 .13956 m
.21844 .13956 L
s
.21851 .13861 m
.21851 .13861 L
s
.21858 .13815 m
.21858 .13815 L
s
.21866 .14073 m
.21866 .14073 L
s
.21874 .13956 m
.21874 .13956 L
s
.21881 .14026 m
.21881 .14026 L
s
.21888 .14003 m
.21888 .14003 L
s
.21896 .14073 m
.21896 .14073 L
s
.21903 .14026 m
.21903 .14026 L
s
.21911 .1405 m
.21911 .1405 L
s
.21918 .14003 m
.21918 .14003 L
s
.21926 .13909 m
.21926 .13909 L
s
.21933 .1405 m
.21933 .1405 L
s
.2194 .13861 m
.2194 .13861 L
s
.21947 .14003 m
.21947 .14003 L
s
.21955 .13674 m
.21955 .13674 L
s
.21963 .13744 m
.21963 .13744 L
s
.2197 .13627 m
.2197 .13627 L
s
.21978 .13768 m
.21978 .13768 L
s
.21985 .13768 m
.21985 .13768 L
s
.21993 .13815 m
.21993 .13815 L
s
.22 .13721 m
.22 .13721 L
s
.22008 .13533 m
.22008 .13533 L
s
.22014 .13697 m
.22014 .13697 L
s
.22022 .13791 m
.22022 .13791 L
s
.22029 .13933 m
.22029 .13933 L
s
.22037 .13979 m
.22037 .13979 L
s
.22044 .1412 m
.22044 .1412 L
s
.22052 .13956 m
.22052 .13956 L
s
.22059 .13933 m
.22059 .13933 L
s
.22067 .13815 m
.22067 .13815 L
s
.22074 .13861 m
.22074 .13861 L
s
.22082 .14003 m
.22082 .14003 L
s
.22089 .14026 m
.22089 .14026 L
s
.22096 .14332 m
.22096 .14332 L
s
.22103 .14214 m
.22103 .14214 L
s
.22111 .14238 m
.22111 .14238 L
s
.22119 .14167 m
.22119 .14167 L
s
.22126 .14167 m
.22126 .14167 L
s
.22134 .14167 m
.22134 .14167 L
s
.22141 .13956 m
.22141 .13956 L
s
.22149 .13791 m
.22149 .13791 L
s
.22156 .13791 m
.22156 .13791 L
s
.22164 .13909 m
.22164 .13909 L
s
.22171 .13768 m
.22171 .13768 L
s
.22178 .13815 m
.22178 .13815 L
s
.22185 .13697 m
.22185 .13697 L
s
.22193 .13861 m
.22193 .13861 L
s
.222 .13838 m
.222 .13838 L
s
.22208 .13861 m
.22208 .13861 L
s
.22215 .13861 m
.22215 .13861 L
s
.22223 .13956 m
.22223 .13956 L
s
.2223 .14003 m
.2223 .14003 L
s
.22238 .14214 m
.22238 .14214 L
s
.22245 .14308 m
.22245 .14308 L
s
.22252 .14379 m
.22252 .14379 L
s
.22259 .14496 m
.22259 .14496 L
s
.22267 .14402 m
.22267 .14402 L
s
.22275 .14402 m
.22275 .14402 L
s
.22282 .14355 m
.22282 .14355 L
s
.2229 .14379 m
.2229 .14379 L
s
.22297 .14402 m
.22297 .14402 L
s
.22305 .14519 m
.22305 .14519 L
s
.22312 .14472 m
.22312 .14472 L
s
.2232 .14402 m
.2232 .14402 L
s
.22327 .14379 m
.22327 .14379 L
s
.22334 .14332 m
.22334 .14332 L
s
.22341 .14379 m
.22341 .14379 L
s
.22349 .14379 m
.22349 .14379 L
s
.22356 .14402 m
.22356 .14402 L
s
.22364 .14449 m
.22364 .14449 L
s
.22371 .14402 m
.22371 .14402 L
s
.22379 .14238 m
.22379 .14238 L
s
.22386 .14167 m
.22386 .14167 L
s
.22394 .14167 m
.22394 .14167 L
s
.22401 .14026 m
.22401 .14026 L
s
.22409 .14003 m
.22409 .14003 L
s
.22416 .13979 m
.22416 .13979 L
s
.22423 .14026 m
.22423 .14026 L
s
.22431 .13886 m
.22431 .13886 L
s
.22438 .14073 m
.22438 .14073 L
s
.22446 .13861 m
.22446 .13861 L
s
.22453 .13861 m
.22453 .13861 L
s
.22461 .13627 m
.22461 .13627 L
s
.22468 .13697 m
.22468 .13697 L
s
.22475 .13744 m
.22475 .13744 L
s
.22483 .13627 m
.22483 .13627 L
s
.22491 .1358 m
.22491 .1358 L
s
.22497 .13604 m
.22497 .13604 L
s
.22505 .13744 m
.22505 .13744 L
s
.22512 .13697 m
.22512 .13697 L
s
.2252 .13791 m
.2252 .13791 L
s
.22527 .13697 m
.22527 .13697 L
s
.22535 .13909 m
.22535 .13909 L
s
.22542 .13861 m
.22542 .13861 L
s
.22549 .13791 m
.22549 .13791 L
s
.22557 .13721 m
.22557 .13721 L
s
.22565 .13768 m
.22565 .13768 L
s
.22572 .13861 m
.22572 .13861 L
s
.22579 .13768 m
.22579 .13768 L
s
.22587 .13815 m
.22587 .13815 L
s
.22594 .13744 m
.22594 .13744 L
s
.22602 .13651 m
.22602 .13651 L
s
.22609 .13557 m
.22609 .13557 L
s
.22617 .13604 m
.22617 .13604 L
s
.22624 .13509 m
.22624 .13509 L
s
.22631 .1358 m
.22631 .1358 L
s
.22638 .13721 m
.22638 .13721 L
s
.22646 .13674 m
.22646 .13674 L
s
.22654 .1358 m
.22654 .1358 L
s
.22661 .13557 m
.22661 .13557 L
s
.22668 .13604 m
.22668 .13604 L
s
.22676 .13439 m
.22676 .13439 L
s
.22683 .1358 m
.22683 .1358 L
s
.22691 .13486 m
.22691 .13486 L
s
.22698 .13674 m
.22698 .13674 L
s
.22706 .13697 m
.22706 .13697 L
s
.22713 .13815 m
.22713 .13815 L
s
.2272 .13768 m
.2272 .13768 L
s
.22728 .13909 m
.22728 .13909 L
s
.22735 .14073 m
.22735 .14073 L
s
.22743 .13933 m
.22743 .13933 L
s
.2275 .14097 m
.2275 .14097 L
s
.22758 .1405 m
.22758 .1405 L
s
.22765 .1412 m
.22765 .1412 L
s
.22773 .13933 m
.22773 .13933 L
s
.2278 .13909 m
.2278 .13909 L
s
.22788 .13838 m
.22788 .13838 L
s
.22794 .13979 m
.22794 .13979 L
s
.22802 .13815 m
.22802 .13815 L
s
.22809 .13744 m
.22809 .13744 L
s
.22817 .13768 m
.22817 .13768 L
s
.22824 .13674 m
.22824 .13674 L
s
.22832 .13861 m
.22832 .13861 L
s
.22839 .13768 m
.22839 .13768 L
s
.22847 .13697 m
.22847 .13697 L
s
.22854 .13651 m
.22854 .13651 L
s
.22862 .13744 m
.22862 .13744 L
s
.22869 .13651 m
.22869 .13651 L
s
.22876 .1358 m
.22876 .1358 L
s
.22883 .13627 m
.22883 .13627 L
s
.22891 .13486 m
.22891 .13486 L
s
.22899 .13415 m
.22899 .13415 L
s
.22906 .13322 m
.22906 .13322 L
s
.22914 .13298 m
.22914 .13298 L
s
.22921 .13357 m
.22921 .13357 L
s
.22929 .13251 m
.22929 .13251 L
s
.22936 .13263 m
.22936 .13263 L
s
.22944 .13228 m
.22944 .13228 L
s
.22951 .13369 m
.22951 .13369 L
s
.22958 .13462 m
.22958 .13462 L
s
.22965 .13369 m
.22965 .13369 L
s
.22973 .1338 m
.22973 .1338 L
s
.2298 .13322 m
.2298 .13322 L
s
.22988 .13345 m
.22988 .13345 L
s
.22995 .13263 m
.22995 .13263 L
s
.23003 .13263 m
.23003 .13263 L
s
.2301 .13298 m
.2301 .13298 L
s
.23018 .13251 m
.23018 .13251 L
s
.23025 .13298 m
.23025 .13298 L
s
.23032 .13228 m
.23032 .13228 L
s
.23039 .13251 m
.23039 .13251 L
s
.23047 .13369 m
.23047 .13369 L
s
.23055 .13345 m
.23055 .13345 L
s
.23062 .13486 m
.23062 .13486 L
s
.2307 .13439 m
.2307 .13439 L
s
.23077 .13533 m
.23077 .13533 L
s
.23085 .13439 m
.23085 .13439 L
s
.23092 .13298 m
.23092 .13298 L
s
.231 .13298 m
.231 .13298 L
s
.23107 .13251 m
.23107 .13251 L
s
.23114 .13228 m
.23114 .13228 L
s
.23121 .13251 m
.23121 .13251 L
s
.23129 .13251 m
.23129 .13251 L
s
.23136 .13263 m
.23136 .13263 L
s
.23144 .13205 m
.23144 .13205 L
s
.23151 .13275 m
.23151 .13275 L
s
.23159 .13205 m
.23159 .13205 L
s
.23166 .13216 m
.23166 .13216 L
s
.23174 .13298 m
.23174 .13298 L
s
.23181 .13251 m
.23181 .13251 L
s
.23189 .13228 m
.23189 .13228 L
s
.23196 .1324 m
.23196 .1324 L
s
.23203 .13345 m
.23203 .13345 L
s
.23211 .13263 m
.23211 .13263 L
s
.23218 .13333 m
.23218 .13333 L
s
.23226 .13228 m
.23226 .13228 L
s
.23233 .13345 m
.23233 .13345 L
s
.23241 .1338 m
.23241 .1338 L
s
.23248 .13263 m
.23248 .13263 L
s
.23256 .13205 m
.23256 .13205 L
s
.23263 .13205 m
.23263 .13205 L
s
.23271 .13345 m
.23271 .13345 L
s
.23277 .13392 m
.23277 .13392 L
s
.23285 .13415 m
.23285 .13415 L
s
.23292 .13462 m
.23292 .13462 L
s
.233 .1358 m
.233 .1358 L
s
.23307 .13815 m
.23307 .13815 L
s
.23315 .13815 m
.23315 .13815 L
s
.23322 .13979 m
.23322 .13979 L
s
.23329 .13744 m
.23329 .13744 L
s
.23337 .13933 m
.23337 .13933 L
s
.23345 .13861 m
.23345 .13861 L
s
.23352 .1405 m
.23352 .1405 L
s
.23359 .14003 m
.23359 .14003 L
s
.23367 .13909 m
.23367 .13909 L
s
.23374 .14097 m
.23374 .14097 L
s
.23382 .14073 m
.23382 .14073 L
s
.23389 .14355 m
.23389 .14355 L
s
.23397 .14261 m
.23397 .14261 L
s
.23404 .14402 m
.23404 .14402 L
s
.23411 .14308 m
.23411 .14308 L
s
.23419 .14332 m
.23419 .14332 L
s
.23427 .1419 m
.23427 .1419 L
s
.23434 .14097 m
.23434 .14097 L
s
.23441 .14097 m
.23441 .14097 L
s
.23448 .13956 m
.23448 .13956 L
s
.23456 .1405 m
.23456 .1405 L
s
.23463 .13886 m
.23463 .13886 L
s
.23471 .13979 m
.23471 .13979 L
s
.23478 .13979 m
.23478 .13979 L
s
.23486 .14003 m
.23486 .14003 L
s
.23493 .14026 m
.23493 .14026 L
s
.235 .14238 m
.235 .14238 L
s
.23508 .14261 m
.23508 .14261 L
s
.23515 .14143 m
.23515 .14143 L
s
.23523 .14003 m
.23523 .14003 L
s
.2353 .13956 m
.2353 .13956 L
s
.23538 .13909 m
.23538 .13909 L
s
.23545 .13791 m
.23545 .13791 L
s
.23553 .14003 m
.23553 .14003 L
s
.2356 .14026 m
.2356 .14026 L
s
.23568 .1405 m
.23568 .1405 L
s
.23574 .14073 m
.23574 .14073 L
s
.23582 .13933 m
.23582 .13933 L
s
.2359 .13886 m
.2359 .13886 L
s
.23597 .13768 m
.23597 .13768 L
s
.23604 .13791 m
.23604 .13791 L
s
.23612 .13533 m
.23612 .13533 L
s
.23619 .1358 m
.23619 .1358 L
s
.23627 .13604 m
.23627 .13604 L
s
.23634 .13861 m
.23634 .13861 L
s
.23642 .13933 m
.23642 .13933 L
s
.23649 .14003 m
.23649 .14003 L
s
.23656 .13886 m
.23656 .13886 L
s
.23663 .13886 m
.23663 .13886 L
s
.23671 .13815 m
.23671 .13815 L
s
.23679 .13979 m
.23679 .13979 L
s
.23686 .13933 m
.23686 .13933 L
s
.23694 .13861 m
.23694 .13861 L
s
.23701 .13886 m
.23701 .13886 L
s
.23709 .13838 m
.23709 .13838 L
s
.23716 .13979 m
.23716 .13979 L
s
.23724 .13768 m
.23724 .13768 L
s
.23731 .13791 m
.23731 .13791 L
s
.23738 .13909 m
.23738 .13909 L
s
.23745 .13909 m
.23745 .13909 L
s
.23753 .1412 m
.23753 .1412 L
s
.2376 .14167 m
.2376 .14167 L
s
.23768 .1419 m
.23768 .1419 L
s
.23775 .14238 m
.23775 .14238 L
s
.23783 .14332 m
.23783 .14332 L
s
.2379 .14238 m
.2379 .14238 L
s
.23798 .14379 m
.23798 .14379 L
s
.23805 .14308 m
.23805 .14308 L
s
.23813 .14355 m
.23813 .14355 L
s
.23819 .14425 m
.23819 .14425 L
s
.23827 .14214 m
.23827 .14214 L
s
.23835 .14332 m
.23835 .14332 L
s
.23842 .1405 m
.23842 .1405 L
s
.2385 .1419 m
.2385 .1419 L
s
.23857 .14003 m
.23857 .14003 L
s
.23865 .13979 m
.23865 .13979 L
s
.23872 .13886 m
.23872 .13886 L
s
.2388 .13933 m
.2388 .13933 L
s
.23887 .13768 m
.23887 .13768 L
s
.23894 .13791 m
.23894 .13791 L
s
.23901 .13861 m
.23901 .13861 L
s
.23909 .14003 m
.23909 .14003 L
s
.23916 .13909 m
.23916 .13909 L
s
.23924 .13909 m
.23924 .13909 L
s
.23931 .1405 m
.23931 .1405 L
s
.23939 .14026 m
.23939 .14026 L
s
.23946 .14167 m
.23946 .14167 L
s
.23954 .13956 m
.23954 .13956 L
s
.23961 .13933 m
.23961 .13933 L
s
.23969 .14003 m
.23969 .14003 L
s
.23976 .14167 m
.23976 .14167 L
s
.23983 .14261 m
.23983 .14261 L
s
.23991 .1419 m
.23991 .1419 L
s
.23998 .14097 m
.23998 .14097 L
s
.24006 .14073 m
.24006 .14073 L
s
.24013 .14143 m
.24013 .14143 L
s
.24021 .13933 m
.24021 .13933 L
s
.24028 .14073 m
.24028 .14073 L
s
.24036 .1405 m
.24036 .1405 L
s
.24043 .14073 m
.24043 .14073 L
s
.24051 .14003 m
.24051 .14003 L
s
.24057 .14143 m
.24057 .14143 L
s
.24065 .13909 m
.24065 .13909 L
s
.24072 .13791 m
.24072 .13791 L
s
.2408 .13768 m
.2408 .13768 L
s
.24087 .13721 m
.24087 .13721 L
s
.24095 .13674 m
.24095 .13674 L
s
.24102 .13557 m
.24102 .13557 L
s
.2411 .13768 m
.2411 .13768 L
s
.24117 .13557 m
.24117 .13557 L
s
.24125 .13604 m
.24125 .13604 L
s
.24132 .13509 m
.24132 .13509 L
s
.24139 .13415 m
.24139 .13415 L
s
.24147 .13509 m
.24147 .13509 L
s
.24154 .13345 m
.24154 .13345 L
s
.24162 .13298 m
.24162 .13298 L
s
.24169 .1324 m
.24169 .1324 L
s
.24177 .13392 m
.24177 .13392 L
s
.24184 .13298 m
.24184 .13298 L
s
.24191 .13228 m
.24191 .13228 L
s
.24199 .13228 m
.24199 .13228 L
s
.24207 .13251 m
.24207 .13251 L
s
.24214 .13439 m
.24214 .13439 L
s
.24221 .13251 m
.24221 .13251 L
s
.24228 .13228 m
.24228 .13228 L
s
.24236 .13205 m
.24236 .13205 L
s
.24243 .1331 m
.24243 .1331 L
s
.24251 .1324 m
.24251 .1324 L
s
.24258 .13228 m
.24258 .13228 L
s
.24266 .1324 m
.24266 .1324 L
s
.24273 .13251 m
.24273 .13251 L
s
.24281 .13322 m
.24281 .13322 L
s
.24288 .13205 m
.24288 .13205 L
s
.24296 .13228 m
.24296 .13228 L
s
.24303 .13251 m
.24303 .13251 L
s
.2431 .13251 m
.2431 .13251 L
s
.24318 .13228 m
.24318 .13228 L
s
.24325 .13322 m
.24325 .13322 L
s
.24333 .13439 m
.24333 .13439 L
s
.2434 .1324 m
.2434 .1324 L
s
.24348 .13205 m
.24348 .13205 L
s
.24354 .13298 m
.24354 .13298 L
s
.24362 .13275 m
.24362 .13275 L
s
.2437 .13275 m
.2437 .13275 L
s
.24377 .13228 m
.24377 .13228 L
s
.24384 .13251 m
.24384 .13251 L
s
.24392 .13287 m
.24392 .13287 L
s
.24399 .13228 m
.24399 .13228 L
s
.24407 .13415 m
.24407 .13415 L
s
.24414 .13298 m
.24414 .13298 L
s
.24422 .13462 m
.24422 .13462 L
s
.24429 .13369 m
.24429 .13369 L
s
.24436 .13533 m
.24436 .13533 L
s
.24444 .13415 m
.24444 .13415 L
s
.24452 .13345 m
.24452 .13345 L
s
.24459 .13298 m
.24459 .13298 L
s
.24466 .13345 m
.24466 .13345 L
s
.24474 .13439 m
.24474 .13439 L
s
.24481 .13439 m
.24481 .13439 L
s
.24489 .13604 m
.24489 .13604 L
s
.24496 .13415 m
.24496 .13415 L
s
.24504 .13439 m
.24504 .13439 L
s
.24511 .13345 m
.24511 .13345 L
s
.24518 .13392 m
.24518 .13392 L
s
.24525 .13462 m
.24525 .13462 L
s
.24533 .13462 m
.24533 .13462 L
s
.2454 .1358 m
.2454 .1358 L
s
.24548 .13697 m
.24548 .13697 L
s
.24555 .13815 m
.24555 .13815 L
s
.24563 .13933 m
.24563 .13933 L
s
.2457 .13886 m
.2457 .13886 L
s
.24578 .13815 m
.24578 .13815 L
s
.24585 .14026 m
.24585 .14026 L
s
.24593 .13861 m
.24593 .13861 L
s
.24599 .13956 m
.24599 .13956 L
s
.24607 .14026 m
.24607 .14026 L
s
.24615 .1412 m
.24615 .1412 L
s
.24622 .14073 m
.24622 .14073 L
s
.2463 .14003 m
.2463 .14003 L
s
.24637 .13979 m
.24637 .13979 L
s
.24645 .14003 m
.24645 .14003 L
s
.24652 .14026 m
.24652 .14026 L
s
.2466 .14167 m
.2466 .14167 L
s
.24667 .14261 m
.24667 .14261 L
s
.24674 .1405 m
.24674 .1405 L
s
.24681 .14214 m
.24681 .14214 L
s
.24689 .14003 m
.24689 .14003 L
s
.24696 .13956 m
.24696 .13956 L
s
.24704 .13861 m
.24704 .13861 L
s
.24711 .13909 m
.24711 .13909 L
s
.24719 .13956 m
.24719 .13956 L
s
.24726 .13909 m
.24726 .13909 L
s
.24734 .13933 m
.24734 .13933 L
s
.24741 .13791 m
.24741 .13791 L
s
.24749 .13979 m
.24749 .13979 L
s
.24756 .13651 m
.24756 .13651 L
s
.24763 .13651 m
.24763 .13651 L
s
.24771 .1358 m
.24771 .1358 L
s
.24778 .13627 m
.24778 .13627 L
s
.24786 .13486 m
.24786 .13486 L
s
.24793 .13439 m
.24793 .13439 L
s
.24801 .13439 m
.24801 .13439 L
s
.24808 .13439 m
.24808 .13439 L
s
.24816 .13486 m
.24816 .13486 L
s
.24823 .13415 m
.24823 .13415 L
s
.24831 .13627 m
.24831 .13627 L
s
.24837 .13439 m
.24837 .13439 L
s
.24845 .13509 m
.24845 .13509 L
s
.24852 .1358 m
.24852 .1358 L
s
.2486 .13768 m
.2486 .13768 L
s
.24867 .13861 m
.24867 .13861 L
s
.24875 .13956 m
.24875 .13956 L
s
.24882 .1405 m
.24882 .1405 L
s
.2489 .14073 m
.2489 .14073 L
s
.24897 .14143 m
.24897 .14143 L
s
.24905 .14003 m
.24905 .14003 L
s
.24912 .14073 m
.24912 .14073 L
s
.24919 .14026 m
.24919 .14026 L
s
.24927 .1412 m
.24927 .1412 L
s
.24934 .13979 m
.24934 .13979 L
s
.24942 .13886 m
.24942 .13886 L
s
.24949 .14026 m
.24949 .14026 L
s
.24957 .13956 m
.24957 .13956 L
s
.24964 .13886 m
.24964 .13886 L
s
.24972 .13838 m
.24972 .13838 L
s
.24979 .13956 m
.24979 .13956 L
s
.24987 .13791 m
.24987 .13791 L
s
.24994 .13933 m
.24994 .13933 L
s
.25001 .14003 m
.25001 .14003 L
s
.25008 .1412 m
.25008 .1412 L
s
.25016 .1419 m
.25016 .1419 L
s
.25023 .14355 m
.25023 .14355 L
s
.25031 .14285 m
.25031 .14285 L
s
.25038 .14332 m
.25038 .14332 L
s
.25046 .14472 m
.25046 .14472 L
s
.25053 .14449 m
.25053 .14449 L
s
.25061 .14449 m
.25061 .14449 L
s
.25068 .14425 m
.25068 .14425 L
s
.25076 .14637 m
.25076 .14637 L
s
.25083 .14567 m
.25083 .14567 L
s
.2509 .14684 m
.2509 .14684 L
s
.25098 .1459 m
.25098 .1459 L
s
.25105 .14614 m
.25105 .14614 L
s
.25113 .14684 m
.25113 .14684 L
s
.2512 .14684 m
.2512 .14684 L
s
.25128 .14848 m
.25128 .14848 L
s
.25135 .14731 m
.25135 .14731 L
s
.25143 .14801 m
.25143 .14801 L
s
.2515 .14707 m
.2515 .14707 L
s
.25157 .14989 m
.25157 .14989 L
s
.25164 .15083 m
.25164 .15083 L
s
.25172 .15154 m
.25172 .15154 L
s
.25179 .15036 m
.25179 .15036 L
s
.25187 .15177 m
.25187 .15177 L
s
.25194 .15177 m
.25194 .15177 L
s
.25202 .15271 m
.25202 .15271 L
s
.25209 .15342 m
.25209 .15342 L
s
.25216 .15271 m
.25216 .15271 L
s
.25224 .15412 m
.25224 .15412 L
s
.25232 .15224 m
.25232 .15224 L
s
.25239 .15389 m
.25239 .15389 L
s
.25246 .15389 m
.25246 .15389 L
s
.25254 .15482 m
.25254 .15482 L
s
.25261 .15459 m
.25261 .15459 L
s
.25269 .15576 m
.25269 .15576 L
s
.25276 .15624 m
.25276 .15624 L
s
.25284 .15576 m
.25284 .15576 L
s
.25291 .15694 m
.25291 .15694 L
s
.25298 .15811 m
.25298 .15811 L
s
.25306 .15788 m
.25306 .15788 L
s
.25313 .15694 m
.25313 .15694 L
s
.2532 .15741 m
.2532 .15741 L
s
.25328 .15741 m
.25328 .15741 L
s
.25335 .15741 m
.25335 .15741 L
s
.25343 .15694 m
.25343 .15694 L
s
.2535 .15694 m
.2535 .15694 L
s
.25358 .15717 m
.25358 .15717 L
s
.25365 .15671 m
.25365 .15671 L
s
.25373 .15741 m
.25373 .15741 L
s
.25379 .15811 m
.25379 .15811 L
s
.25387 .15811 m
.25387 .15811 L
s
.25395 .15811 m
.25395 .15811 L
s
.25402 .15788 m
.25402 .15788 L
s
.2541 .15671 m
.2541 .15671 L
s
.25417 .15624 m
.25417 .15624 L
s
.25425 .15576 m
.25425 .15576 L
s
.25432 .156 m
.25432 .156 L
s
.2544 .15647 m
.2544 .15647 L
s
.25447 .15576 m
.25447 .15576 L
s
.25454 .156 m
.25454 .156 L
s
.25461 .156 m
.25461 .156 L
s
.25469 .15576 m
.25469 .15576 L
s
.25477 .15412 m
.25477 .15412 L
s
.25484 .15342 m
.25484 .15342 L
s
.25491 .15435 m
.25491 .15435 L
s
.25499 .15435 m
.25499 .15435 L
s
.25506 .15435 m
.25506 .15435 L
s
.25514 .15412 m
.25514 .15412 L
s
.25521 .152 m
.25521 .152 L
s
.25529 .1513 m
.25529 .1513 L
s
.25536 .15083 m
.25536 .15083 L
s
.25543 .1506 m
.25543 .1506 L
s
.25551 .15224 m
.25551 .15224 L
s
.25558 .1506 m
.25558 .1506 L
s
.25566 .15271 m
.25566 .15271 L
s
.25573 .1513 m
.25573 .1513 L
s
.25581 .15154 m
.25581 .15154 L
s
.25588 .15177 m
.25588 .15177 L
s
.25596 .15177 m
.25596 .15177 L
s
.25603 .15154 m
.25603 .15154 L
s
.25611 .14989 m
.25611 .14989 L
s
.25617 .15036 m
.25617 .15036 L
s
.25625 .14943 m
.25625 .14943 L
s
.25632 .15013 m
.25632 .15013 L
s
.2564 .14895 m
.2564 .14895 L
s
.25647 .14943 m
.25647 .14943 L
s
.25655 .14801 m
.25655 .14801 L
s
.25662 .14754 m
.25662 .14754 L
s
.2567 .14825 m
.2567 .14825 L
s
.25677 .14707 m
.25677 .14707 L
s
.25685 .14684 m
.25685 .14684 L
s
.25692 .14778 m
.25692 .14778 L
s
.25699 .14848 m
.25699 .14848 L
s
.25707 .14778 m
.25707 .14778 L
s
.25714 .14943 m
.25714 .14943 L
s
.25722 .14895 m
.25722 .14895 L
s
.25729 .14989 m
.25729 .14989 L
s
.25737 .15013 m
.25737 .15013 L
s
.25744 .15036 m
.25744 .15036 L
s
.25752 .14989 m
.25752 .14989 L
s
.25759 .14848 m
.25759 .14848 L
s
.25767 .14848 m
.25767 .14848 L
s
.25774 .14801 m
.25774 .14801 L
s
.25781 .14872 m
.25781 .14872 L
s
.25788 .14801 m
.25788 .14801 L
s
.25796 .14895 m
.25796 .14895 L
s
.25803 .15013 m
.25803 .15013 L
s
.25811 .1513 m
.25811 .1513 L
s
.25818 .15342 m
.25818 .15342 L
s
.25826 .15482 m
.25826 .15482 L
s
.25833 .156 m
.25833 .156 L
s
.25841 .15529 m
.25841 .15529 L
s
.25848 .15553 m
.25848 .15553 L
s
.25856 .15576 m
.25856 .15576 L
s
.25863 .15717 m
.25863 .15717 L
s
.2587 .15671 m
.2587 .15671 L
s
.25878 .15788 m
.25878 .15788 L
s
.25885 .15788 m
.25885 .15788 L
s
.25893 .15788 m
.25893 .15788 L
s
.259 .15694 m
.259 .15694 L
s
.25908 .15788 m
.25908 .15788 L
s
.25915 .15764 m
.25915 .15764 L
s
.25923 .15671 m
.25923 .15671 L
s
.2593 .15835 m
.2593 .15835 L
s
.25937 .15788 m
.25937 .15788 L
s
.25944 .15882 m
.25944 .15882 L
s
.25952 .15835 m
.25952 .15835 L
s
.25959 .15882 m
.25959 .15882 L
s
.25967 .15929 m
.25967 .15929 L
s
.25974 .15858 m
.25974 .15858 L
s
.25982 .15788 m
.25982 .15788 L
s
.25989 .15976 m
.25989 .15976 L
s
.25997 .15929 m
.25997 .15929 L
s
.26004 .15905 m
.26004 .15905 L
s
.26012 .15905 m
.26012 .15905 L
s
.26019 .15788 m
.26019 .15788 L
s
.26026 .15741 m
.26026 .15741 L
s
.26034 .15717 m
.26034 .15717 L
s
.26041 .15905 m
.26041 .15905 L
s
.26049 .15694 m
.26049 .15694 L
s
.26056 .15741 m
.26056 .15741 L
s
.26064 .15835 m
.26064 .15835 L
s
.26071 .15811 m
.26071 .15811 L
s
.26078 .15811 m
.26078 .15811 L
s
.26086 .15835 m
.26086 .15835 L
s
.26094 .16023 m
.26094 .16023 L
s
.261 .15953 m
.261 .15953 L
s
.26108 .16234 m
.26108 .16234 L
s
.26115 .16093 m
.26115 .16093 L
s
.26123 .16187 m
.26123 .16187 L
s
.2613 .16164 m
.2613 .16164 L
s
.26138 .16164 m
.26138 .16164 L
s
.26145 .16305 m
.26145 .16305 L
s
.26153 .16375 m
.26153 .16375 L
s
.2616 .16422 m
.2616 .16422 L
s
.26167 .16281 m
.26167 .16281 L
s
.26175 .16399 m
.26175 .16399 L
s
.26182 .16352 m
.26182 .16352 L
s
.2619 .16399 m
.2619 .16399 L
s
.26197 .16234 m
.26197 .16234 L
s
.26205 .16375 m
.26205 .16375 L
s
.26212 .16399 m
.26212 .16399 L
s
.2622 .16586 m
.2622 .16586 L
s
.26227 .16516 m
.26227 .16516 L
s
.26234 .16539 m
.26234 .16539 L
s
.26241 .16563 m
.26241 .16563 L
s
.26249 .16469 m
.26249 .16469 L
s
.26257 .1661 m
.26257 .1661 L
s
.26264 .16539 m
.26264 .16539 L
s
.26271 .16821 m
.26271 .16821 L
s
.26279 .16422 m
.26279 .16422 L
s
.26286 .16492 m
.26286 .16492 L
s
.26294 .16563 m
.26294 .16563 L
s
.26301 .1661 m
.26301 .1661 L
s
.26309 .1661 m
.26309 .1661 L
s
.26316 .16774 m
.26316 .16774 L
s
.26323 .16774 m
.26323 .16774 L
s
.26331 .16727 m
.26331 .16727 L
s
.26338 .16821 m
.26338 .16821 L
s
.26346 .16657 m
.26346 .16657 L
s
.26353 .16798 m
.26353 .16798 L
s
.26361 .16821 m
.26361 .16821 L
s
.26368 .16868 m
.26368 .16868 L
s
.26376 .16821 m
.26376 .16821 L
s
.26383 .16986 m
.26383 .16986 L
s
.26391 .16868 m
.26391 .16868 L
s
.26397 .16798 m
.26397 .16798 L
s
.26405 .16939 m
.26405 .16939 L
s
.26412 .16845 m
.26412 .16845 L
s
.2642 .16892 m
.2642 .16892 L
s
.26427 .16892 m
.26427 .16892 L
s
.26435 .17033 m
.26435 .17033 L
s
.26442 .17127 m
.26442 .17127 L
s
.2645 .17009 m
.2645 .17009 L
s
.26457 .17033 m
.26457 .17033 L
s
.26465 .16986 m
.26465 .16986 L
s
.26472 .16939 m
.26472 .16939 L
s
.26479 .16915 m
.26479 .16915 L
s
.26487 .16915 m
.26487 .16915 L
s
.26494 .16868 m
.26494 .16868 L
s
.26502 .16774 m
.26502 .16774 L
s
.26509 .16751 m
.26509 .16751 L
s
.26517 .16798 m
.26517 .16798 L
s
.26524 .16727 m
.26524 .16727 L
s
.26532 .16915 m
.26532 .16915 L
s
.26539 .16821 m
.26539 .16821 L
s
.26547 .16751 m
.26547 .16751 L
s
.26554 .16774 m
.26554 .16774 L
s
.26561 .16657 m
.26561 .16657 L
s
.26568 .16751 m
.26568 .16751 L
s
.26576 .1661 m
.26576 .1661 L
s
.26583 .1661 m
.26583 .1661 L
s
.26591 .1661 m
.26591 .1661 L
s
.26598 .16563 m
.26598 .16563 L
s
.26606 .16422 m
.26606 .16422 L
s
.26613 .16399 m
.26613 .16399 L
s
.26621 .16305 m
.26621 .16305 L
s
.26628 .16352 m
.26628 .16352 L
s
.26636 .16375 m
.26636 .16375 L
s
.26643 .16399 m
.26643 .16399 L
s
.2665 .16375 m
.2665 .16375 L
s
.26658 .16352 m
.26658 .16352 L
s
.26665 .16469 m
.26665 .16469 L
s
.26673 .16399 m
.26673 .16399 L
s
.2668 .16445 m
.2668 .16445 L
s
.26688 .16539 m
.26688 .16539 L
s
.26695 .16422 m
.26695 .16422 L
s
.26703 .16586 m
.26703 .16586 L
s
.2671 .16798 m
.2671 .16798 L
s
.26717 .16774 m
.26717 .16774 L
s
.26724 .16681 m
.26724 .16681 L
s
.26732 .16681 m
.26732 .16681 L
s
.26739 .16586 m
.26739 .16586 L
s
.26747 .16634 m
.26747 .16634 L
s
.26754 .16563 m
.26754 .16563 L
s
.26762 .16586 m
.26762 .16586 L
s
.26769 .16563 m
.26769 .16563 L
s
.26777 .16657 m
.26777 .16657 L
s
.26784 .16704 m
.26784 .16704 L
s
.26792 .16634 m
.26792 .16634 L
s
.26799 .16586 m
.26799 .16586 L
s
.26806 .16492 m
.26806 .16492 L
s
.26814 .16516 m
.26814 .16516 L
s
.26821 .16399 m
.26821 .16399 L
s
.26829 .16586 m
.26829 .16586 L
s
.26836 .16469 m
.26836 .16469 L
s
.26844 .16634 m
.26844 .16634 L
s
.26851 .16445 m
.26851 .16445 L
s
.26858 .16492 m
.26858 .16492 L
s
.26866 .16516 m
.26866 .16516 L
s
.26874 .16516 m
.26874 .16516 L
s
.2688 .16681 m
.2688 .16681 L
s
.26888 .16422 m
.26888 .16422 L
s
.26895 .16422 m
.26895 .16422 L
s
.26903 .16352 m
.26903 .16352 L
s
.2691 .16445 m
.2691 .16445 L
s
.26918 .16234 m
.26918 .16234 L
s
.26925 .16164 m
.26925 .16164 L
s
.26933 .16093 m
.26933 .16093 L
s
.2694 .16046 m
.2694 .16046 L
s
.26948 .15835 m
.26948 .15835 L
s
.26956 .15929 m
.26956 .15929 L
s
.26962 .15788 m
.26962 .15788 L
s
.2697 .15459 m
.2697 .15459 L
s
.26977 .15624 m
.26977 .15624 L
s
.26985 .15459 m
.26985 .15459 L
s
.26992 .15482 m
.26992 .15482 L
s
.27 .15295 m
.27 .15295 L
s
.27007 .15412 m
.27007 .15412 L
s
.27014 .15295 m
.27014 .15295 L
s
.27021 .15224 m
.27021 .15224 L
s
.27029 .15154 m
.27029 .15154 L
s
.27037 .15271 m
.27037 .15271 L
s
.27044 .15224 m
.27044 .15224 L
s
.27051 .15107 m
.27051 .15107 L
s
.27059 .152 m
.27059 .152 L
s
.27066 .1506 m
.27066 .1506 L
s
.27074 .15013 m
.27074 .15013 L
s
.27081 .14848 m
.27081 .14848 L
s
.27089 .14989 m
.27089 .14989 L
s
.27096 .14895 m
.27096 .14895 L
s
.27103 .14919 m
.27103 .14919 L
s
.27111 .15013 m
.27111 .15013 L
s
.27119 .14943 m
.27119 .14943 L
s
.27126 .14848 m
.27126 .14848 L
s
.27133 .14919 m
.27133 .14919 L
s
.27141 .15036 m
.27141 .15036 L
s
.27148 .15036 m
.27148 .15036 L
s
.27156 .1513 m
.27156 .1513 L
s
.27163 .15177 m
.27163 .15177 L
s
.27171 .15248 m
.27171 .15248 L
s
.27177 .15271 m
.27177 .15271 L
s
.27185 .15342 m
.27185 .15342 L
s
.27192 .15318 m
.27192 .15318 L
s
.272 .15224 m
.272 .15224 L
s
.27207 .15248 m
.27207 .15248 L
s
.27215 .15318 m
.27215 .15318 L
s
.27222 .15482 m
.27222 .15482 L
s
.2723 .152 m
.2723 .152 L
s
.27237 .15412 m
.27237 .15412 L
s
.27245 .15224 m
.27245 .15224 L
s
.27252 .15318 m
.27252 .15318 L
s
.27259 .15295 m
.27259 .15295 L
s
.27267 .15271 m
.27267 .15271 L
s
.27274 .1506 m
.27274 .1506 L
s
.27282 .1513 m
.27282 .1513 L
s
.27289 .15083 m
.27289 .15083 L
s
.27297 .15248 m
.27297 .15248 L
s
.27304 .152 m
.27304 .152 L
s
.27312 .15154 m
.27312 .15154 L
s
.27319 .152 m
.27319 .152 L
s
.27327 .152 m
.27327 .152 L
s
.27334 .15224 m
.27334 .15224 L
s
.27341 .15248 m
.27341 .15248 L
s
.27348 .152 m
.27348 .152 L
s
.27356 .15435 m
.27356 .15435 L
s
.27363 .15482 m
.27363 .15482 L
s
.27371 .15482 m
.27371 .15482 L
s
.27378 .15342 m
.27378 .15342 L
s
.27386 .15248 m
.27386 .15248 L
s
.27393 .152 m
.27393 .152 L
s
.27401 .1506 m
.27401 .1506 L
s
.27408 .14943 m
.27408 .14943 L
s
.27416 .14943 m
.27416 .14943 L
s
.27423 .15036 m
.27423 .15036 L
s
.2743 .15013 m
.2743 .15013 L
s
.27438 .1513 m
.27438 .1513 L
s
.27445 .14989 m
.27445 .14989 L
s
.27453 .15036 m
.27453 .15036 L
s
.2746 .14989 m
.2746 .14989 L
s
.27468 .14989 m
.27468 .14989 L
s
.27475 .15013 m
.27475 .15013 L
s
.27483 .14919 m
.27483 .14919 L
s
.2749 .14919 m
.2749 .14919 L
s
.27497 .1506 m
.27497 .1506 L
s
.27504 .15013 m
.27504 .15013 L
s
.27512 .15083 m
.27512 .15083 L
s
.27519 .1513 m
.27519 .1513 L
s
.27527 .152 m
.27527 .152 L
s
.27534 .15435 m
.27534 .15435 L
s
.27542 .15506 m
.27542 .15506 L
s
.27549 .15389 m
.27549 .15389 L
s
.27557 .15224 m
.27557 .15224 L
s
.27564 .15154 m
.27564 .15154 L
s
.27572 .15036 m
.27572 .15036 L
s
.27579 .14943 m
.27579 .14943 L
s
.27586 .14825 m
.27586 .14825 L
s
.27594 .14661 m
.27594 .14661 L
s
.27601 .14661 m
.27601 .14661 L
s
.27609 .14778 m
.27609 .14778 L
s
.27616 .14778 m
.27616 .14778 L
s
.27624 .14754 m
.27624 .14754 L
s
.27631 .14848 m
.27631 .14848 L
s
.27639 .14637 m
.27639 .14637 L
s
.27646 .14754 m
.27646 .14754 L
s
.27654 .14567 m
.27654 .14567 L
s
.2766 .14707 m
.2766 .14707 L
s
.27668 .14661 m
.27668 .14661 L
s
.27675 .14614 m
.27675 .14614 L
s
.27683 .14661 m
.27683 .14661 L
s
.2769 .14496 m
.2769 .14496 L
s
.27698 .14684 m
.27698 .14684 L
s
.27705 .14496 m
.27705 .14496 L
s
.27713 .14567 m
.27713 .14567 L
s
.2772 .14567 m
.2772 .14567 L
s
.27728 .14519 m
.27728 .14519 L
s
.27736 .14449 m
.27736 .14449 L
s
.27742 .14355 m
.27742 .14355 L
s
.2775 .14238 m
.2775 .14238 L
s
.27757 .14332 m
.27757 .14332 L
s
.27765 .14355 m
.27765 .14355 L
s
.27772 .14308 m
.27772 .14308 L
s
.2778 .14402 m
.2778 .14402 L
s
.27787 .14261 m
.27787 .14261 L
s
.27794 .14143 m
.27794 .14143 L
s
.27802 .14214 m
.27802 .14214 L
s
.2781 .14402 m
.2781 .14402 L
s
.27817 .14402 m
.27817 .14402 L
s
.27824 .14402 m
.27824 .14402 L
s
.27831 .14425 m
.27831 .14425 L
s
.27839 .14214 m
.27839 .14214 L
s
.27846 .14238 m
.27846 .14238 L
s
.27854 .1419 m
.27854 .1419 L
s
.27861 .14285 m
.27861 .14285 L
s
.27869 .14214 m
.27869 .14214 L
s
.27876 .14238 m
.27876 .14238 L
s
.27883 .13933 m
.27883 .13933 L
s
.27891 .14026 m
.27891 .14026 L
s
.27899 .13979 m
.27899 .13979 L
s
.27906 .14097 m
.27906 .14097 L
s
.27913 .14073 m
.27913 .14073 L
s
.27921 .14003 m
.27921 .14003 L
s
.27928 .14073 m
.27928 .14073 L
s
.27936 .13956 m
.27936 .13956 L
s
.27943 .14073 m
.27943 .14073 L
s
.27951 .14026 m
.27951 .14026 L
s
.27957 .14026 m
.27957 .14026 L
s
.27965 .14214 m
.27965 .14214 L
s
.27973 .14355 m
.27973 .14355 L
s
.2798 .14425 m
.2798 .14425 L
s
.27987 .14379 m
.27987 .14379 L
s
.27995 .14614 m
.27995 .14614 L
s
.28002 .14707 m
.28002 .14707 L
s
.2801 .14848 m
.2801 .14848 L
s
.28017 .14801 m
.28017 .14801 L
s
.28025 .14919 m
.28025 .14919 L
s
.28032 .14919 m
.28032 .14919 L
s
.28039 .15036 m
.28039 .15036 L
s
.28047 .14919 m
.28047 .14919 L
s
.28054 .14848 m
.28054 .14848 L
s
.28062 .14895 m
.28062 .14895 L
s
.28069 .14848 m
.28069 .14848 L
s
.28077 .14943 m
.28077 .14943 L
s
.28084 .14825 m
.28084 .14825 L
s
.28092 .14943 m
.28092 .14943 L
s
.28099 .14872 m
.28099 .14872 L
s
.28107 .15013 m
.28107 .15013 L
s
.28114 .14966 m
.28114 .14966 L
s
.28121 .1513 m
.28121 .1513 L
s
.28128 .15154 m
.28128 .15154 L
s
.28136 .15107 m
.28136 .15107 L
s
.28144 .15083 m
.28144 .15083 L
s
.28151 .1513 m
.28151 .1513 L
s
.28158 .152 m
.28158 .152 L
s
.28166 .14989 m
.28166 .14989 L
s
.28173 .1506 m
.28173 .1506 L
s
.28181 .1506 m
.28181 .1506 L
s
.28188 .1506 m
.28188 .1506 L
s
.28196 .15107 m
.28196 .15107 L
s
.28203 .1513 m
.28203 .1513 L
s
.2821 .1506 m
.2821 .1506 L
s
.28218 .1513 m
.28218 .1513 L
s
.28225 .14943 m
.28225 .14943 L
s
.28233 .14895 m
.28233 .14895 L
s
.2824 .1513 m
.2824 .1513 L
s
.28248 .1506 m
.28248 .1506 L
s
.28255 .15036 m
.28255 .15036 L
s
.28263 .1513 m
.28263 .1513 L
s
.2827 .15389 m
.2827 .15389 L
s
.28277 .15389 m
.28277 .15389 L
s
.28284 .15435 m
.28284 .15435 L
s
.28292 .15318 m
.28292 .15318 L
s
.28299 .15506 m
.28299 .15506 L
s
.28307 .156 m
.28307 .156 L
s
.28314 .15671 m
.28314 .15671 L
s
.28322 .15647 m
.28322 .15647 L
s
.28329 .15624 m
.28329 .15624 L
s
.28337 .15671 m
.28337 .15671 L
s
.28344 .15412 m
.28344 .15412 L
s
.28352 .15389 m
.28352 .15389 L
s
.28359 .15365 m
.28359 .15365 L
s
.28366 .15553 m
.28366 .15553 L
s
.28374 .15553 m
.28374 .15553 L
s
.28381 .15553 m
.28381 .15553 L
s
.28389 .156 m
.28389 .156 L
s
.28396 .15576 m
.28396 .15576 L
s
.28404 .15553 m
.28404 .15553 L
s
.28411 .15553 m
.28411 .15553 L
s
.28419 .15506 m
.28419 .15506 L
s
.28426 .15295 m
.28426 .15295 L
s
.28434 .15365 m
.28434 .15365 L
s
.28441 .15435 m
.28441 .15435 L
s
.28448 .15459 m
.28448 .15459 L
s
.28455 .15318 m
.28455 .15318 L
s
.28463 .15248 m
.28463 .15248 L
s
.2847 .15224 m
.2847 .15224 L
s
.28478 .15224 m
.28478 .15224 L
s
.28485 .15318 m
.28485 .15318 L
s
.28493 .15271 m
.28493 .15271 L
s
.285 .15435 m
.285 .15435 L
s
.28508 .15318 m
.28508 .15318 L
s
.28516 .15342 m
.28516 .15342 L
s
.28522 .15295 m
.28522 .15295 L
s
.2853 .15482 m
.2853 .15482 L
s
.28537 .15459 m
.28537 .15459 L
s
.28545 .15506 m
.28545 .15506 L
s
.28552 .15506 m
.28552 .15506 L
s
.2856 .156 m
.2856 .156 L
s
.28567 .15788 m
.28567 .15788 L
s
.28574 .15764 m
.28574 .15764 L
s
.28582 .15976 m
.28582 .15976 L
s
.2859 .1607 m
.2859 .1607 L
s
.28597 .16117 m
.28597 .16117 L
s
.28604 .15976 m
.28604 .15976 L
s
.28611 .15858 m
.28611 .15858 L
s
.28619 .15835 m
.28619 .15835 L
s
.28626 .15811 m
.28626 .15811 L
s
.28634 .15717 m
.28634 .15717 L
s
.28641 .156 m
.28641 .156 L
s
.28649 .15694 m
.28649 .15694 L
s
.28656 .15553 m
.28656 .15553 L
s
.28664 .156 m
.28664 .156 L
s
.28672 .15553 m
.28672 .15553 L
s
.28679 .15671 m
.28679 .15671 L
s
.28686 .15576 m
.28686 .15576 L
s
.28693 .15694 m
.28693 .15694 L
s
.28701 .15741 m
.28701 .15741 L
s
.28708 .156 m
.28708 .156 L
s
.28716 .15694 m
.28716 .15694 L
s
.28723 .15647 m
.28723 .15647 L
s
.28731 .15694 m
.28731 .15694 L
s
.28738 .15624 m
.28738 .15624 L
s
.28745 .15671 m
.28745 .15671 L
s
.28753 .15647 m
.28753 .15647 L
s
.2876 .15717 m
.2876 .15717 L
s
.28767 .15694 m
.28767 .15694 L
s
.28775 .15717 m
.28775 .15717 L
s
.28782 .156 m
.28782 .156 L
s
.2879 .15553 m
.2879 .15553 L
s
.28797 .15506 m
.28797 .15506 L
s
.28805 .15435 m
.28805 .15435 L
s
.28812 .15506 m
.28812 .15506 L
s
.28819 .15342 m
.28819 .15342 L
s
.28827 .15482 m
.28827 .15482 L
s
.28835 .15459 m
.28835 .15459 L
s
.28842 .15412 m
.28842 .15412 L
s
.28849 .15389 m
.28849 .15389 L
s
.28857 .15412 m
.28857 .15412 L
s
.28864 .15506 m
.28864 .15506 L
s
.28872 .15482 m
.28872 .15482 L
s
.28879 .15576 m
.28879 .15576 L
s
.28887 .15506 m
.28887 .15506 L
s
.28894 .15529 m
.28894 .15529 L
s
.28901 .15482 m
.28901 .15482 L
s
.28908 .15529 m
.28908 .15529 L
s
.28916 .15506 m
.28916 .15506 L
s
.28924 .15553 m
.28924 .15553 L
s
.28931 .15412 m
.28931 .15412 L
s
.28938 .15482 m
.28938 .15482 L
s
.28946 .15624 m
.28946 .15624 L
s
.28953 .15647 m
.28953 .15647 L
s
.28961 .15671 m
.28961 .15671 L
s
.28968 .156 m
.28968 .156 L
s
.28976 .15576 m
.28976 .15576 L
s
.28983 .156 m
.28983 .156 L
s
.2899 .15529 m
.2899 .15529 L
s
.28998 .15529 m
.28998 .15529 L
s
.29005 .15506 m
.29005 .15506 L
s
.29013 .15506 m
.29013 .15506 L
s
.2902 .15553 m
.2902 .15553 L
s
.29028 .15435 m
.29028 .15435 L
s
.29035 .15389 m
.29035 .15389 L
s
.29043 .15576 m
.29043 .15576 L
s
.2905 .15553 m
.2905 .15553 L
s
.29057 .15741 m
.29057 .15741 L
s
.29064 .156 m
.29064 .156 L
s
.29072 .15788 m
.29072 .15788 L
s
.29079 .15953 m
.29079 .15953 L
s
.29087 .15953 m
.29087 .15953 L
s
.29094 .15741 m
.29094 .15741 L
s
.29102 .15764 m
.29102 .15764 L
s
.29109 .15671 m
.29109 .15671 L
s
.29117 .15764 m
.29117 .15764 L
s
.29124 .15671 m
.29124 .15671 L
s
.29132 .15576 m
.29132 .15576 L
s
.29139 .15576 m
.29139 .15576 L
s
.29146 .15506 m
.29146 .15506 L
s
.29154 .15576 m
.29154 .15576 L
s
.29161 .15459 m
.29161 .15459 L
s
.29169 .15412 m
.29169 .15412 L
s
.29176 .15271 m
.29176 .15271 L
s
.29184 .15295 m
.29184 .15295 L
s
.29191 .15389 m
.29191 .15389 L
s
.29199 .15459 m
.29199 .15459 L
s
.29206 .15671 m
.29206 .15671 L
s
.29214 .15647 m
.29214 .15647 L
s
.29221 .15717 m
.29221 .15717 L
s
.29228 .156 m
.29228 .156 L
s
.29235 .15741 m
.29235 .15741 L
s
.29243 .15506 m
.29243 .15506 L
s
.2925 .15435 m
.2925 .15435 L
s
.29258 .15295 m
.29258 .15295 L
s
.29265 .15271 m
.29265 .15271 L
s
.29273 .15177 m
.29273 .15177 L
s
.2928 .15036 m
.2928 .15036 L
s
.29288 .15036 m
.29288 .15036 L
s
.29296 .14966 m
.29296 .14966 L
s
.29302 .14989 m
.29302 .14989 L
s
.2931 .14943 m
.2931 .14943 L
s
.29317 .14943 m
.29317 .14943 L
s
.29325 .14895 m
.29325 .14895 L
s
.29332 .14989 m
.29332 .14989 L
s
.2934 .14943 m
.2934 .14943 L
s
.29347 .14919 m
.29347 .14919 L
s
.29355 .14825 m
.29355 .14825 L
s
.29362 .14872 m
.29362 .14872 L
s
.2937 .14801 m
.2937 .14801 L
s
.29377 .14731 m
.29377 .14731 L
s
.29384 .14943 m
.29384 .14943 L
s
.29391 .15083 m
.29391 .15083 L
s
.29399 .1513 m
.29399 .1513 L
s
.29406 .14989 m
.29406 .14989 L
s
.29414 .14848 m
.29414 .14848 L
s
.29421 .14707 m
.29421 .14707 L
s
.29429 .14731 m
.29429 .14731 L
s
.29436 .14731 m
.29436 .14731 L
s
.29444 .14731 m
.29444 .14731 L
s
.29452 .14895 m
.29452 .14895 L
s
.29459 .14754 m
.29459 .14754 L
s
.29466 .14825 m
.29466 .14825 L
s
.29473 .14731 m
.29473 .14731 L
s
.29481 .14684 m
.29481 .14684 L
s
.29488 .14661 m
.29488 .14661 L
s
.29496 .14707 m
.29496 .14707 L
s
.29503 .14895 m
.29503 .14895 L
s
.29511 .15036 m
.29511 .15036 L
s
.29518 .15107 m
.29518 .15107 L
s
.29526 .1513 m
.29526 .1513 L
s
.29533 .15154 m
.29533 .15154 L
s
.2954 .14943 m
.2954 .14943 L
s
.29547 .15036 m
.29547 .15036 L
s
.29555 .14966 m
.29555 .14966 L
s
.29562 .14989 m
.29562 .14989 L
s
.2957 .14825 m
.2957 .14825 L
s
.29577 .14754 m
.29577 .14754 L
s
.29585 .14614 m
.29585 .14614 L
s
.29592 .14661 m
.29592 .14661 L
s
.29599 .1459 m
.29599 .1459 L
s
.29607 .14472 m
.29607 .14472 L
s
.29615 .14614 m
.29615 .14614 L
s
.29622 .14614 m
.29622 .14614 L
s
.29629 .14684 m
.29629 .14684 L
s
.29637 .14519 m
.29637 .14519 L
s
.29644 .14661 m
.29644 .14661 L
s
.29652 .14567 m
.29652 .14567 L
s
.29659 .14472 m
.29659 .14472 L
s
.29667 .14614 m
.29667 .14614 L
s
.29674 .14614 m
.29674 .14614 L
s
.29681 .14637 m
.29681 .14637 L
s
.29689 .14614 m
.29689 .14614 L
s
.29697 .14778 m
.29697 .14778 L
s
.29704 .14567 m
.29704 .14567 L
s
.29711 .14567 m
.29711 .14567 L
s
.29718 .14496 m
.29718 .14496 L
s
.29726 .1459 m
.29726 .1459 L
s
.29733 .14614 m
.29733 .14614 L
s
.29741 .14543 m
.29741 .14543 L
s
.29748 .14496 m
.29748 .14496 L
s
.29756 .14472 m
.29756 .14472 L
s
.29763 .14496 m
.29763 .14496 L
s
.2977 .14543 m
.2977 .14543 L
s
.29778 .14731 m
.29778 .14731 L
s
.29785 .14567 m
.29785 .14567 L
s
.29793 .14496 m
.29793 .14496 L
s
.298 .14614 m
.298 .14614 L
s
.29808 .14825 m
.29808 .14825 L
s
.29815 .14801 m
.29815 .14801 L
s
.29823 .14848 m
.29823 .14848 L
s
.2983 .14943 m
.2983 .14943 L
s
.29837 .14919 m
.29837 .14919 L
s
.29844 .14895 m
.29844 .14895 L
s
.29852 .14825 m
.29852 .14825 L
s
.2986 .14848 m
.2986 .14848 L
s
.29867 .14707 m
.29867 .14707 L
s
.29874 .14731 m
.29874 .14731 L
s
.29882 .14614 m
.29882 .14614 L
s
.29889 .14637 m
.29889 .14637 L
s
.29897 .14449 m
.29897 .14449 L
s
.29904 .14567 m
.29904 .14567 L
s
.29912 .14519 m
.29912 .14519 L
s
.29919 .14519 m
.29919 .14519 L
s
.29926 .1459 m
.29926 .1459 L
s
.29934 .1459 m
.29934 .1459 L
s
.29941 .14684 m
.29941 .14684 L
s
.29949 .14543 m
.29949 .14543 L
s
.29956 .14614 m
.29956 .14614 L
s
.29964 .14519 m
.29964 .14519 L
s
.29971 .14661 m
.29971 .14661 L
s
.29979 .14614 m
.29979 .14614 L
s
.29986 .14731 m
.29986 .14731 L
s
.29994 .14754 m
.29994 .14754 L
s
.30001 .14684 m
.30001 .14684 L
s
.30008 .14825 m
.30008 .14825 L
s
.30015 .14848 m
.30015 .14848 L
s
.30023 .14943 m
.30023 .14943 L
s
.3003 .15013 m
.3003 .15013 L
s
.30038 .15271 m
.30038 .15271 L
s
.30045 .15224 m
.30045 .15224 L
s
.30053 .15248 m
.30053 .15248 L
s
.3006 .152 m
.3006 .152 L
s
.30068 .15224 m
.30068 .15224 L
s
.30076 .15224 m
.30076 .15224 L
s
.30082 .15154 m
.30082 .15154 L
s
.3009 .15389 m
.3009 .15389 L
s
.30097 .15083 m
.30097 .15083 L
s
.30105 .15013 m
.30105 .15013 L
s
.30112 .14966 m
.30112 .14966 L
s
.3012 .15107 m
.3012 .15107 L
s
.30127 .14895 m
.30127 .14895 L
s
.30135 .15013 m
.30135 .15013 L
s
.30142 .15013 m
.30142 .15013 L
s
.3015 .1513 m
.3015 .1513 L
s
.30157 .15342 m
.30157 .15342 L
s
.30164 .1513 m
.30164 .1513 L
s
.30171 .15177 m
.30171 .15177 L
s
.30179 .15036 m
.30179 .15036 L
s
.30186 .15154 m
.30186 .15154 L
s
.30194 .15083 m
.30194 .15083 L
s
.30201 .15224 m
.30201 .15224 L
s
.30209 .15154 m
.30209 .15154 L
s
.30216 .15154 m
.30216 .15154 L
s
.30224 .15177 m
.30224 .15177 L
s
.30232 .15177 m
.30232 .15177 L
s
.30239 .15295 m
.30239 .15295 L
s
.30246 .15295 m
.30246 .15295 L
s
.30253 .15271 m
.30253 .15271 L
s
.30261 .15248 m
.30261 .15248 L
s
.30268 .15295 m
.30268 .15295 L
s
.30276 .15318 m
.30276 .15318 L
s
.30283 .15318 m
.30283 .15318 L
s
.30291 .15224 m
.30291 .15224 L
s
.30298 .15342 m
.30298 .15342 L
s
.30306 .15224 m
.30306 .15224 L
s
.30313 .15177 m
.30313 .15177 L
s
.3032 .15177 m
.3032 .15177 L
s
.30327 .152 m
.30327 .152 L
s
.30335 .15295 m
.30335 .15295 L
s
.30342 .15459 m
.30342 .15459 L
s
.3035 .15529 m
.3035 .15529 L
s
.30357 .15482 m
.30357 .15482 L
s
.30365 .15459 m
.30365 .15459 L
s
.30372 .15412 m
.30372 .15412 L
s
.3038 .15482 m
.3038 .15482 L
s
.30388 .156 m
.30388 .156 L
s
.30395 .15694 m
.30395 .15694 L
s
.30402 .15624 m
.30402 .15624 L
s
.30409 .15671 m
.30409 .15671 L
s
.30417 .15717 m
.30417 .15717 L
s
.30424 .156 m
.30424 .156 L
s
.30432 .15647 m
.30432 .15647 L
s
.30439 .15647 m
.30439 .15647 L
s
.30447 .15694 m
.30447 .15694 L
s
.30454 .15576 m
.30454 .15576 L
s
.30461 .156 m
.30461 .156 L
s
.30469 .15671 m
.30469 .15671 L
s
.30477 .15647 m
.30477 .15647 L
s
.30484 .15717 m
.30484 .15717 L
s
.30491 .15647 m
.30491 .15647 L
s
.30498 .156 m
.30498 .156 L
s
.30506 .15529 m
.30506 .15529 L
s
.30513 .15741 m
.30513 .15741 L
s
.30521 .15741 m
.30521 .15741 L
s
.30528 .15717 m
.30528 .15717 L
s
.30536 .156 m
.30536 .156 L
s
.30543 .15529 m
.30543 .15529 L
s
.30551 .15647 m
.30551 .15647 L
s
.30559 .15647 m
.30559 .15647 L
s
.30565 .15717 m
.30565 .15717 L
s
.30573 .15459 m
.30573 .15459 L
s
.3058 .15647 m
.3058 .15647 L
s
.30588 .15529 m
.30588 .15529 L
s
.30595 .15482 m
.30595 .15482 L
s
.30603 .15435 m
.30603 .15435 L
s
.3061 .15389 m
.3061 .15389 L
s
.30617 .15506 m
.30617 .15506 L
s
.30624 .15412 m
.30624 .15412 L
s
.30632 .15389 m
.30632 .15389 L
s
.3064 .15506 m
.3064 .15506 L
s
.30647 .15576 m
.30647 .15576 L
s
.30654 .15647 m
.30654 .15647 L
s
.30662 .15647 m
.30662 .15647 L
s
.30669 .15624 m
.30669 .15624 L
s
.30677 .156 m
.30677 .156 L
s
.30684 .15553 m
.30684 .15553 L
s
.30692 .15412 m
.30692 .15412 L
s
.30699 .15295 m
.30699 .15295 L
s
.30706 .15365 m
.30706 .15365 L
s
.30714 .15435 m
.30714 .15435 L
s
.30722 .15506 m
.30722 .15506 L
s
.30729 .15576 m
.30729 .15576 L
s
.30736 .15365 m
.30736 .15365 L
s
.30744 .15435 m
.30744 .15435 L
s
.30751 .15459 m
.30751 .15459 L
s
.30759 .15624 m
.30759 .15624 L
s
.30766 .15624 m
.30766 .15624 L
s
.30774 .15717 m
.30774 .15717 L
s
.30781 .15694 m
.30781 .15694 L
s
.30788 .15741 m
.30788 .15741 L
s
.30795 .15694 m
.30795 .15694 L
s
.30803 .15741 m
.30803 .15741 L
s
.3081 .15835 m
.3081 .15835 L
s
.30818 .15741 m
.30818 .15741 L
s
.30825 .15835 m
.30825 .15835 L
s
.30833 .15858 m
.30833 .15858 L
s
.3084 .15999 m
.3084 .15999 L
s
.30848 .1614 m
.30848 .1614 L
s
.30856 .1614 m
.30856 .1614 L
s
.30862 .1614 m
.30862 .1614 L
s
.3087 .15999 m
.3087 .15999 L
s
.30877 .16023 m
.30877 .16023 L
s
.30885 .15999 m
.30885 .15999 L
s
.30892 .1621 m
.30892 .1621 L
s
.309 .16046 m
.309 .16046 L
s
.30907 .15953 m
.30907 .15953 L
s
.30915 .15835 m
.30915 .15835 L
s
.30922 .15882 m
.30922 .15882 L
s
.3093 .15953 m
.3093 .15953 L
s
.30937 .15882 m
.30937 .15882 L
s
.30944 .15953 m
.30944 .15953 L
s
.30951 .15953 m
.30951 .15953 L
s
.30959 .15905 m
.30959 .15905 L
s
.30966 .15694 m
.30966 .15694 L
s
.30974 .15788 m
.30974 .15788 L
s
.30981 .15717 m
.30981 .15717 L
s
.30989 .15788 m
.30989 .15788 L
s
.30996 .15764 m
.30996 .15764 L
s
.31004 .15529 m
.31004 .15529 L
s
.31012 .15482 m
.31012 .15482 L
s
.31019 .156 m
.31019 .156 L
s
.31026 .15624 m
.31026 .15624 L
s
.31033 .15647 m
.31033 .15647 L
s
.31041 .15741 m
.31041 .15741 L
s
.31048 .15929 m
.31048 .15929 L
s
.31056 .16046 m
.31056 .16046 L
s
.31063 .15953 m
.31063 .15953 L
s
.31071 .16258 m
.31071 .16258 L
s
.31078 .16234 m
.31078 .16234 L
s
.31086 .16258 m
.31086 .16258 L
s
.31093 .16281 m
.31093 .16281 L
s
.311 .16328 m
.311 .16328 L
s
.31107 .16258 m
.31107 .16258 L
s
.31115 .16258 m
.31115 .16258 L
s
.31122 .16445 m
.31122 .16445 L
s
.3113 .16399 m
.3113 .16399 L
s
.31137 .16516 m
.31137 .16516 L
s
.31145 .16586 m
.31145 .16586 L
s
.31152 .16539 m
.31152 .16539 L
s
.3116 .16586 m
.3116 .16586 L
s
.31168 .16586 m
.31168 .16586 L
s
.31175 .16422 m
.31175 .16422 L
s
.31182 .16352 m
.31182 .16352 L
s
.31189 .16305 m
.31189 .16305 L
s
.31197 .16305 m
.31197 .16305 L
s
.31204 .16539 m
.31204 .16539 L
s
.31212 .16422 m
.31212 .16422 L
s
.31219 .16539 m
.31219 .16539 L
s
.31227 .16563 m
.31227 .16563 L
s
.31234 .16634 m
.31234 .16634 L
s
.31242 .16586 m
.31242 .16586 L
s
.31249 .16492 m
.31249 .16492 L
s
.31257 .16586 m
.31257 .16586 L
s
.31264 .16563 m
.31264 .16563 L
s
.31271 .16586 m
.31271 .16586 L
s
.31278 .16681 m
.31278 .16681 L
s
.31286 .16727 m
.31286 .16727 L
s
.31293 .16704 m
.31293 .16704 L
s
.31301 .16939 m
.31301 .16939 L
s
.31308 .16821 m
.31308 .16821 L
s
.31316 .16986 m
.31316 .16986 L
s
.31323 .17009 m
.31323 .17009 L
s
.31331 .16963 m
.31331 .16963 L
s
.31339 .1715 m
.31339 .1715 L
s
.31345 .17174 m
.31345 .17174 L
s
.31353 .17197 m
.31353 .17197 L
s
.3136 .17362 m
.3136 .17362 L
s
.31368 .17385 m
.31368 .17385 L
s
.31375 .17291 m
.31375 .17291 L
s
.31383 .17385 m
.31383 .17385 L
s
.3139 .17291 m
.3139 .17291 L
s
.31397 .17338 m
.31397 .17338 L
s
.31405 .17174 m
.31405 .17174 L
s
.31413 .17315 m
.31413 .17315 L
s
.3142 .17338 m
.3142 .17338 L
s
.31427 .17432 m
.31427 .17432 L
s
.31434 .17409 m
.31434 .17409 L
s
.31442 .17197 m
.31442 .17197 L
s
.31449 .17432 m
.31449 .17432 L
s
.31457 .17291 m
.31457 .17291 L
s
.31464 .17362 m
.31464 .17362 L
s
.31472 .17338 m
.31472 .17338 L
s
.31479 .17338 m
.31479 .17338 L
s
.31486 .17479 m
.31486 .17479 L
s
.31494 .17479 m
.31494 .17479 L
s
.31502 .17526 m
.31502 .17526 L
s
.31509 .1762 m
.31509 .1762 L
s
.31516 .17644 m
.31516 .17644 L
s
.31524 .1762 m
.31524 .1762 L
s
.31531 .17573 m
.31531 .17573 L
s
.31539 .17502 m
.31539 .17502 L
s
.31546 .17667 m
.31546 .17667 L
s
.31554 .1762 m
.31554 .1762 L
s
.31561 .17714 m
.31561 .17714 L
s
.31568 .17691 m
.31568 .17691 L
s
.31576 .17808 m
.31576 .17808 L
s
.31584 .17831 m
.31584 .17831 L
s
.3159 .17644 m
.3159 .17644 L
s
.31598 .17644 m
.31598 .17644 L
s
.31605 .17479 m
.31605 .17479 L
s
.31613 .17549 m
.31613 .17549 L
s
.3162 .17315 m
.3162 .17315 L
s
.31628 .17244 m
.31628 .17244 L
s
.31636 .17291 m
.31636 .17291 L
s
.31642 .17244 m
.31642 .17244 L
s
.3165 .17197 m
.3165 .17197 L
s
.31657 .17267 m
.31657 .17267 L
s
.31665 .17291 m
.31665 .17291 L
s
.31672 .17338 m
.31672 .17338 L
s
.3168 .17432 m
.3168 .17432 L
s
.31687 .17409 m
.31687 .17409 L
s
.31695 .17338 m
.31695 .17338 L
s
.31702 .17197 m
.31702 .17197 L
s
.3171 .17362 m
.3171 .17362 L
s
.31717 .17291 m
.31717 .17291 L
s
.31724 .17267 m
.31724 .17267 L
s
.31731 .17267 m
.31731 .17267 L
s
.31739 .17244 m
.31739 .17244 L
s
.31747 .17291 m
.31747 .17291 L
s
.31754 .17385 m
.31754 .17385 L
s
.31761 .17338 m
.31761 .17338 L
s
.31769 .17267 m
.31769 .17267 L
s
.31776 .17315 m
.31776 .17315 L
s
.31784 .1722 m
.31784 .1722 L
s
.31792 .17315 m
.31792 .17315 L
s
.31799 .17267 m
.31799 .17267 L
s
.31806 .17385 m
.31806 .17385 L
s
.31813 .17338 m
.31813 .17338 L
s
.31821 .17479 m
.31821 .17479 L
s
.31828 .17479 m
.31828 .17479 L
s
.31836 .17479 m
.31836 .17479 L
s
.31843 .17573 m
.31843 .17573 L
s
.31851 .17596 m
.31851 .17596 L
s
.31858 .17738 m
.31858 .17738 L
s
.31866 .17526 m
.31866 .17526 L
s
.31873 .17573 m
.31873 .17573 L
s
.31881 .17338 m
.31881 .17338 L
s
.31887 .17385 m
.31887 .17385 L
s
.31895 .17291 m
.31895 .17291 L
s
.31902 .17432 m
.31902 .17432 L
s
.3191 .17526 m
.3191 .17526 L
s
.31917 .17549 m
.31917 .17549 L
s
.31925 .17409 m
.31925 .17409 L
s
.31932 .1722 m
.31932 .1722 L
s
.3194 .17338 m
.3194 .17338 L
s
.31948 .17291 m
.31948 .17291 L
s
.31955 .17456 m
.31955 .17456 L
s
.31962 .17432 m
.31962 .17432 L
s
.31969 .17526 m
.31969 .17526 L
s
.31977 .17385 m
.31977 .17385 L
s
.31984 .17456 m
.31984 .17456 L
s
.31992 .17479 m
.31992 .17479 L
s
.31999 .17596 m
.31999 .17596 L
s
.32007 .17761 m
.32007 .17761 L
s
.32014 .17573 m
.32014 .17573 L
s
.32022 .17549 m
.32022 .17549 L
s
.32029 .17432 m
.32029 .17432 L
s
.32037 .17502 m
.32037 .17502 L
s
.32044 .17526 m
.32044 .17526 L
s
.32051 .17502 m
.32051 .17502 L
s
.32058 .17526 m
.32058 .17526 L
s
.32066 .17549 m
.32066 .17549 L
s
.32073 .17596 m
.32073 .17596 L
s
.32081 .17573 m
.32081 .17573 L
s
.32088 .17691 m
.32088 .17691 L
s
.32096 .17761 m
.32096 .17761 L
s
.32103 .17738 m
.32103 .17738 L
s
.32111 .17902 m
.32111 .17902 L
s
.32119 .1809 m
.32119 .1809 L
s
.32125 .17948 m
.32125 .17948 L
s
.32133 .1809 m
.32133 .1809 L
s
.3214 .1809 m
.3214 .1809 L
s
.32148 .18137 m
.32148 .18137 L
s
.32155 .18066 m
.32155 .18066 L
s
.32163 .1809 m
.32163 .1809 L
s
.3217 .18277 m
.3217 .18277 L
s
.32178 .1809 m
.32178 .1809 L
s
.32185 .18301 m
.32185 .18301 L
s
.32193 .18277 m
.32193 .18277 L
s
.322 .18419 m
.322 .18419 L
s
.32207 .18348 m
.32207 .18348 L
s
.32214 .18395 m
.32214 .18395 L
s
.32222 .18372 m
.32222 .18372 L
s
.32229 .18277 m
.32229 .18277 L
s
.32237 .18419 m
.32237 .18419 L
s
.32244 .1823 m
.32244 .1823 L
s
.32252 .18254 m
.32252 .18254 L
s
.32259 .18113 m
.32259 .18113 L
s
.32267 .18372 m
.32267 .18372 L
s
.32274 .18137 m
.32274 .18137 L
s
.32282 .18113 m
.32282 .18113 L
s
.32289 .1809 m
.32289 .1809 L
s
.32296 .1816 m
.32296 .1816 L
s
.32304 .18184 m
.32304 .18184 L
s
.32311 .18277 m
.32311 .18277 L
s
.32319 .18325 m
.32319 .18325 L
s
.32326 .1823 m
.32326 .1823 L
s
.32334 .18419 m
.32334 .18419 L
s
.32341 .18395 m
.32341 .18395 L
s
.32348 .18442 m
.32348 .18442 L
s
.32356 .18348 m
.32356 .18348 L
s
.32364 .18372 m
.32364 .18372 L
s
.3237 .18348 m
.3237 .18348 L
s
.32378 .18301 m
.32378 .18301 L
s
.32385 .18348 m
.32385 .18348 L
s
.32393 .18372 m
.32393 .18372 L
s
.324 .18395 m
.324 .18395 L
s
.32408 .18395 m
.32408 .18395 L
s
.32416 .18466 m
.32416 .18466 L
s
.32422 .18395 m
.32422 .18395 L
s
.3243 .18442 m
.3243 .18442 L
s
.32437 .18583 m
.32437 .18583 L
s
.32445 .18583 m
.32445 .18583 L
s
.32452 .18466 m
.32452 .18466 L
s
.3246 .18395 m
.3246 .18395 L
s
.32467 .18466 m
.32467 .18466 L
s
.32475 .18536 m
.32475 .18536 L
s
.32482 .18654 m
.32482 .18654 L
s
.3249 .18654 m
.3249 .18654 L
s
.32497 .18748 m
.32497 .18748 L
s
.32504 .18771 m
.32504 .18771 L
s
.32511 .18888 m
.32511 .18888 L
s
.32519 .18724 m
.32519 .18724 L
s
.32527 .18748 m
.32527 .18748 L
s
.32534 .18701 m
.32534 .18701 L
s
.32541 .18841 m
.32541 .18841 L
s
.32549 .18748 m
.32549 .18748 L
s
.32556 .18748 m
.32556 .18748 L
s
.32564 .18748 m
.32564 .18748 L
s
.32572 .18677 m
.32572 .18677 L
s
.32579 .18701 m
.32579 .18701 L
s
.32586 .18536 m
.32586 .18536 L
s
.32593 .18489 m
.32593 .18489 L
s
.32601 .18466 m
.32601 .18466 L
s
.32608 .18559 m
.32608 .18559 L
s
.32616 .18536 m
.32616 .18536 L
s
.32623 .1823 m
.32623 .1823 L
s
.32631 .18395 m
.32631 .18395 L
s
.32638 .18348 m
.32638 .18348 L
s
.32646 .18512 m
.32646 .18512 L
s
.32653 .18512 m
.32653 .18512 L
s
.32661 .18536 m
.32661 .18536 L
s
.32667 .18348 m
.32667 .18348 L
s
.32675 .18606 m
.32675 .18606 L
s
.32682 .18466 m
.32682 .18466 L
s
.3269 .18559 m
.3269 .18559 L
s
.32697 .18395 m
.32697 .18395 L
s
.32705 .18466 m
.32705 .18466 L
s
.32712 .1823 m
.32712 .1823 L
s
.3272 .18207 m
.3272 .18207 L
s
.32728 .1823 m
.32728 .1823 L
s
.32735 .17973 m
.32735 .17973 L
s
.32742 .17925 m
.32742 .17925 L
s
.32749 .17784 m
.32749 .17784 L
s
.32757 .17948 m
.32757 .17948 L
s
.32764 .17902 m
.32764 .17902 L
s
.32772 .17878 m
.32772 .17878 L
s
.32779 .17855 m
.32779 .17855 L
s
.32787 .17784 m
.32787 .17784 L
s
.32794 .17855 m
.32794 .17855 L
s
.32802 .17738 m
.32802 .17738 L
s
.32809 .17808 m
.32809 .17808 L
s
.32817 .17925 m
.32817 .17925 L
s
.32824 .18207 m
.32824 .18207 L
s
.32831 .1816 m
.32831 .1816 L
s
.32838 .1809 m
.32838 .1809 L
s
.32846 .17996 m
.32846 .17996 L
s
.32853 .18043 m
.32853 .18043 L
s
.32861 .18184 m
.32861 .18184 L
s
.32868 .18489 m
.32868 .18489 L
s
.32876 .18701 m
.32876 .18701 L
s
.32884 .18701 m
.32884 .18701 L
s
.32891 .18794 m
.32891 .18794 L
s
.32899 .18559 m
.32899 .18559 L
s
.32905 .18536 m
.32905 .18536 L
s
.32913 .18277 m
.32913 .18277 L
s
.3292 .18419 m
.3292 .18419 L
s
.32928 .18489 m
.32928 .18489 L
s
.32935 .18442 m
.32935 .18442 L
s
.32943 .18301 m
.32943 .18301 L
s
.3295 .18137 m
.3295 .18137 L
s
.32958 .1823 m
.32958 .1823 L
s
.32965 .17996 m
.32965 .17996 L
s
.32973 .1802 m
.32973 .1802 L
s
.3298 .17925 m
.3298 .17925 L
s
.32987 .17831 m
.32987 .17831 L
s
.32994 .17667 m
.32994 .17667 L
s
.33002 .17667 m
.33002 .17667 L
s
.33009 .17549 m
.33009 .17549 L
s
.33017 .17667 m
.33017 .17667 L
s
.33024 .17784 m
.33024 .17784 L
s
.33032 .17761 m
.33032 .17761 L
s
.33039 .17808 m
.33039 .17808 L
s
.33047 .17738 m
.33047 .17738 L
s
.33055 .17808 m
.33055 .17808 L
s
.33062 .17808 m
.33062 .17808 L
s
.33069 .17878 m
.33069 .17878 L
s
.33076 .17691 m
.33076 .17691 L
s
.33084 .17667 m
.33084 .17667 L
s
.33091 .17714 m
.33091 .17714 L
s
.33099 .17691 m
.33099 .17691 L
s
.33106 .17855 m
.33106 .17855 L
s
.33114 .17831 m
.33114 .17831 L
s
.33121 .17925 m
.33121 .17925 L
s
.33128 .17831 m
.33128 .17831 L
s
.33136 .17808 m
.33136 .17808 L
s
.33144 .17644 m
.33144 .17644 L
s
.3315 .17878 m
.3315 .17878 L
s
.33158 .17831 m
.33158 .17831 L
s
.33165 .17784 m
.33165 .17784 L
s
.33173 .17761 m
.33173 .17761 L
s
.3318 .17902 m
.3318 .17902 L
s
.33188 .17973 m
.33188 .17973 L
s
.33196 .17925 m
.33196 .17925 L
s
.33202 .17902 m
.33202 .17902 L
s
.3321 .17573 m
.3321 .17573 L
s
.33218 .17596 m
.33218 .17596 L
s
.33225 .17526 m
.33225 .17526 L
s
.33232 .17338 m
.33232 .17338 L
s
.3324 .17127 m
.3324 .17127 L
s
.33247 .17056 m
.33247 .17056 L
s
.33255 .17174 m
.33255 .17174 L
s
.33262 .17267 m
.33262 .17267 L
s
.3327 .1722 m
.3327 .1722 L
s
.33277 .17197 m
.33277 .17197 L
s
.33284 .17267 m
.33284 .17267 L
s
.33291 .17174 m
.33291 .17174 L
s
.33299 .17315 m
.33299 .17315 L
s
.33307 .17174 m
.33307 .17174 L
s
.33314 .1722 m
.33314 .1722 L
s
.33321 .17127 m
.33321 .17127 L
s
.33329 .17174 m
.33329 .17174 L
s
.33336 .17338 m
.33336 .17338 L
s
.33344 .17174 m
.33344 .17174 L
s
.33352 .17338 m
.33352 .17338 L
s
.33359 .17385 m
.33359 .17385 L
s
.33366 .17526 m
.33366 .17526 L
s
.33373 .1715 m
.33373 .1715 L
s
.33381 .17174 m
.33381 .17174 L
s
.33388 .1715 m
.33388 .1715 L
s
.33396 .17409 m
.33396 .17409 L
s
.33403 .17315 m
.33403 .17315 L
s
.33411 .17432 m
.33411 .17432 L
s
.33418 .17315 m
.33418 .17315 L
s
.33426 .17432 m
.33426 .17432 L
s
.33433 .17385 m
.33433 .17385 L
s
.33441 .17244 m
.33441 .17244 L
s
.33447 .17197 m
.33447 .17197 L
s
.33455 .17103 m
.33455 .17103 L
s
.33462 .17103 m
.33462 .17103 L
s
.3347 .1708 m
.3347 .1708 L
s
.33477 .16986 m
.33477 .16986 L
s
.33485 .16798 m
.33485 .16798 L
s
.33492 .16751 m
.33492 .16751 L
s
.335 .16868 m
.335 .16868 L
s
.33508 .16774 m
.33508 .16774 L
s
.33515 .16798 m
.33515 .16798 L
s
.33522 .16845 m
.33522 .16845 L
s
.33529 .16892 m
.33529 .16892 L
s
.33537 .16892 m
.33537 .16892 L
s
.33544 .16963 m
.33544 .16963 L
s
.33552 .16821 m
.33552 .16821 L
s
.33559 .16868 m
.33559 .16868 L
s
.33567 .17009 m
.33567 .17009 L
s
.33574 .17174 m
.33574 .17174 L
s
.33582 .1708 m
.33582 .1708 L
s
.33589 .17197 m
.33589 .17197 L
s
.33597 .17315 m
.33597 .17315 L
s
.33604 .17338 m
.33604 .17338 L
s
.33611 .17291 m
.33611 .17291 L
s
.33618 .1722 m
.33618 .1722 L
s
.33626 .17244 m
.33626 .17244 L
s
.33633 .17127 m
.33633 .17127 L
s
.33641 .17009 m
.33641 .17009 L
s
.33648 .16963 m
.33648 .16963 L
s
.33656 .16915 m
.33656 .16915 L
s
.33664 .16939 m
.33664 .16939 L
s
.33671 .17056 m
.33671 .17056 L
s
.33679 .16868 m
.33679 .16868 L
s
.33685 .16704 m
.33685 .16704 L
s
.33693 .16492 m
.33693 .16492 L
s
.337 .16399 m
.337 .16399 L
s
.33708 .16657 m
.33708 .16657 L
s
.33715 .16586 m
.33715 .16586 L
s
.33723 .16704 m
.33723 .16704 L
s
.3373 .16563 m
.3373 .16563 L
s
.33738 .1661 m
.33738 .1661 L
s
.33745 .16634 m
.33745 .16634 L
s
.33753 .16774 m
.33753 .16774 L
s
.3376 .16868 m
.3376 .16868 L
s
.33767 .16774 m
.33767 .16774 L
s
.33774 .16868 m
.33774 .16868 L
s
.33782 .16915 m
.33782 .16915 L
s
.33789 .17103 m
.33789 .17103 L
s
.33797 .17127 m
.33797 .17127 L
s
.33804 .17291 m
.33804 .17291 L
s
.33812 .17362 m
.33812 .17362 L
s
.33819 .1722 m
.33819 .1722 L
s
.33827 .17267 m
.33827 .17267 L
s
.33835 .17244 m
.33835 .17244 L
s
.33842 .17338 m
.33842 .17338 L
s
.33849 .17432 m
.33849 .17432 L
s
.33856 .17644 m
.33856 .17644 L
s
.33864 .17479 m
.33864 .17479 L
s
.33871 .17526 m
.33871 .17526 L
s
.33879 .17409 m
.33879 .17409 L
s
.33886 .17385 m
.33886 .17385 L
s
.33894 .17103 m
.33894 .17103 L
s
.33901 .1708 m
.33901 .1708 L
s
.33909 .17127 m
.33909 .17127 L
s
.33916 .16963 m
.33916 .16963 L
s
.33924 .16963 m
.33924 .16963 L
s
.3393 .17127 m
.3393 .17127 L
s
.33938 .17291 m
.33938 .17291 L
s
.33945 .17174 m
.33945 .17174 L
s
.33953 .17197 m
.33953 .17197 L
s
.3396 .17103 m
.3396 .17103 L
s
.33968 .17362 m
.33968 .17362 L
s
.33976 .17174 m
.33976 .17174 L
s
.33982 .17291 m
.33982 .17291 L
s
.3399 .1715 m
.3399 .1715 L
s
.33998 .17009 m
.33998 .17009 L
s
.34005 .16915 m
.34005 .16915 L
s
.34012 .16681 m
.34012 .16681 L
s
.3402 .16751 m
.3402 .16751 L
s
.34027 .16751 m
.34027 .16751 L
s
.34035 .16657 m
.34035 .16657 L
s
.34042 .16563 m
.34042 .16563 L
s
.3405 .16634 m
.3405 .16634 L
s
.34057 .16539 m
.34057 .16539 L
s
.34064 .16634 m
.34064 .16634 L
s
.34072 .16727 m
.34072 .16727 L
s
.3408 .16539 m
.3408 .16539 L
s
.34087 .16469 m
.34087 .16469 L
s
.34094 .16305 m
.34094 .16305 L
s
.34101 .16399 m
.34101 .16399 L
s
.34109 .16539 m
.34109 .16539 L
s
.34116 .16774 m
.34116 .16774 L
s
.34124 .16634 m
.34124 .16634 L
s
.34132 .16681 m
.34132 .16681 L
s
.34139 .16634 m
.34139 .16634 L
s
.34146 .16634 m
.34146 .16634 L
s
.34153 .16798 m
.34153 .16798 L
s
.34161 .16821 m
.34161 .16821 L
s
.34168 .16963 m
.34168 .16963 L
s
.34176 .16727 m
.34176 .16727 L
s
.34183 .16821 m
.34183 .16821 L
s
.34191 .16704 m
.34191 .16704 L
s
.34198 .16681 m
.34198 .16681 L
s
.34206 .1661 m
.34206 .1661 L
s
.34213 .16492 m
.34213 .16492 L
s
.34221 .16399 m
.34221 .16399 L
s
.34227 .16445 m
.34227 .16445 L
s
.34235 .16657 m
.34235 .16657 L
s
.34243 .16563 m
.34243 .16563 L
s
.3425 .16492 m
.3425 .16492 L
s
.34257 .16399 m
.34257 .16399 L
s
.34265 .16539 m
.34265 .16539 L
s
.34272 .16328 m
.34272 .16328 L
s
.3428 .16422 m
.3428 .16422 L
s
.34288 .16399 m
.34288 .16399 L
s
.34295 .16586 m
.34295 .16586 L
s
.34302 .16586 m
.34302 .16586 L
s
.34309 .16422 m
.34309 .16422 L
s
.34317 .1661 m
.34317 .1661 L
s
.34324 .16586 m
.34324 .16586 L
s
.34332 .16798 m
.34332 .16798 L
s
.34339 .16727 m
.34339 .16727 L
s
.34347 .16586 m
.34347 .16586 L
s
.34354 .16492 m
.34354 .16492 L
s
.34362 .16586 m
.34362 .16586 L
s
.34369 .16563 m
.34369 .16563 L
s
.34377 .16634 m
.34377 .16634 L
s
.34384 .16798 m
.34384 .16798 L
s
.34391 .16892 m
.34391 .16892 L
s
.34398 .17033 m
.34398 .17033 L
s
.34406 .16915 m
.34406 .16915 L
s
.34413 .17056 m
.34413 .17056 L
s
.34421 .17197 m
.34421 .17197 L
s
.34428 .17267 m
.34428 .17267 L
s
.34436 .1708 m
.34436 .1708 L
s
.34444 .17267 m
.34444 .17267 L
s
.34451 .17127 m
.34451 .17127 L
s
.34459 .1715 m
.34459 .1715 L
s
.34465 .17291 m
.34465 .17291 L
s
.34473 .1722 m
.34473 .1722 L
s
.3448 .17127 m
.3448 .17127 L
s
.34488 .16845 m
.34488 .16845 L
s
.34495 .1708 m
.34495 .1708 L
s
.34503 .17009 m
.34503 .17009 L
s
.3451 .17033 m
.3451 .17033 L
s
.34518 .16939 m
.34518 .16939 L
s
.34525 .16986 m
.34525 .16986 L
s
.34533 .16892 m
.34533 .16892 L
s
.3454 .16963 m
.3454 .16963 L
s
.34547 .17056 m
.34547 .17056 L
s
.34554 .17009 m
.34554 .17009 L
s
.34562 .16915 m
.34562 .16915 L
s
.34569 .16939 m
.34569 .16939 L
s
.34577 .16963 m
.34577 .16963 L
s
.34584 .16845 m
.34584 .16845 L
s
.34592 .17009 m
.34592 .17009 L
s
.346 .17009 m
.346 .17009 L
s
.34607 .17056 m
.34607 .17056 L
s
.34615 .17127 m
.34615 .17127 L
s
.34622 .1708 m
.34622 .1708 L
s
.34629 .17174 m
.34629 .17174 L
s
.34636 .1722 m
.34636 .1722 L
s
.34644 .17244 m
.34644 .17244 L
s
.34651 .17315 m
.34651 .17315 L
s
.34659 .17385 m
.34659 .17385 L
s
.34666 .17291 m
.34666 .17291 L
s
.34674 .17291 m
.34674 .17291 L
s
.34681 .1715 m
.34681 .1715 L
s
.34689 .17174 m
.34689 .17174 L
s
.34696 .17291 m
.34696 .17291 L
s
.34704 .17338 m
.34704 .17338 L
s
.3471 .17432 m
.3471 .17432 L
s
.34718 .17385 m
.34718 .17385 L
s
.34725 .17362 m
.34725 .17362 L
s
.34733 .17338 m
.34733 .17338 L
s
.3474 .17456 m
.3474 .17456 L
s
.34748 .17549 m
.34748 .17549 L
s
.34756 .17596 m
.34756 .17596 L
s
.34763 .17596 m
.34763 .17596 L
s
.34771 .17432 m
.34771 .17432 L
s
.34778 .17526 m
.34778 .17526 L
s
.34785 .17432 m
.34785 .17432 L
s
.34792 .17502 m
.34792 .17502 L
s
.348 .17479 m
.348 .17479 L
s
.34807 .17549 m
.34807 .17549 L
s
.34815 .17409 m
.34815 .17409 L
s
.34822 .17573 m
.34822 .17573 L
s
.3483 .17479 m
.3483 .17479 L
s
.34837 .17479 m
.34837 .17479 L
s
.34844 .17385 m
.34844 .17385 L
s
.34852 .17291 m
.34852 .17291 L
s
.3486 .17291 m
.3486 .17291 L
s
.34867 .17338 m
.34867 .17338 L
s
.34874 .17385 m
.34874 .17385 L
s
.34881 .17456 m
.34881 .17456 L
s
.34889 .17526 m
.34889 .17526 L
s
.34896 .17338 m
.34896 .17338 L
s
.34904 .17362 m
.34904 .17362 L
s
.34912 .1722 m
.34912 .1722 L
s
.34919 .17267 m
.34919 .17267 L
s
.34926 .17385 m
.34926 .17385 L
s
.34934 .17338 m
.34934 .17338 L
s
.34942 .17197 m
.34942 .17197 L
s
.34948 .1715 m
.34948 .1715 L
s
.34956 .17127 m
.34956 .17127 L
s
.34963 .17174 m
.34963 .17174 L
s
.34971 .17267 m
.34971 .17267 L
s
.34978 .17174 m
.34978 .17174 L
s
.34986 .17197 m
.34986 .17197 L
s
.34993 .17197 m
.34993 .17197 L
s
.35001 .17291 m
.35001 .17291 L
s
.35007 .17291 m
.35007 .17291 L
s
.35015 .17174 m
.35015 .17174 L
s
.35023 .1715 m
.35023 .1715 L
s
.3503 .17033 m
.3503 .17033 L
s
.35037 .17009 m
.35037 .17009 L
s
.35045 .17127 m
.35045 .17127 L
s
.35052 .1715 m
.35052 .1715 L
s
.3506 .17127 m
.3506 .17127 L
s
.35068 .17197 m
.35068 .17197 L
s
.35075 .1708 m
.35075 .1708 L
s
.35082 .17009 m
.35082 .17009 L
s
.35089 .17009 m
.35089 .17009 L
s
.35097 .17056 m
.35097 .17056 L
s
.35105 .16986 m
.35105 .16986 L
s
.35112 .17056 m
.35112 .17056 L
s
.35119 .1715 m
.35119 .1715 L
s
.35127 .17103 m
.35127 .17103 L
s
.35134 .17197 m
.35134 .17197 L
s
.35142 .17103 m
.35142 .17103 L
s
.35149 .1715 m
.35149 .1715 L
s
.35157 .17197 m
.35157 .17197 L
s
.35164 .17362 m
.35164 .17362 L
s
.35171 .17291 m
.35171 .17291 L
s
.35178 .17315 m
.35178 .17315 L
s
.35186 .17244 m
.35186 .17244 L
s
.35193 .17056 m
.35193 .17056 L
s
.35201 .1715 m
.35201 .1715 L
s
.35208 .1715 m
.35208 .1715 L
s
.35216 .1722 m
.35216 .1722 L
s
.35224 .17267 m
.35224 .17267 L
s
.35231 .17362 m
.35231 .17362 L
s
.35239 .17291 m
.35239 .17291 L
s
.35245 .17338 m
.35245 .17338 L
s
.35253 .17456 m
.35253 .17456 L
s
.3526 .17362 m
.3526 .17362 L
s
.35268 .17526 m
.35268 .17526 L
s
.35275 .17502 m
.35275 .17502 L
s
.35283 .17479 m
.35283 .17479 L
s
.3529 .17362 m
.3529 .17362 L
s
.35298 .17338 m
.35298 .17338 L
s
.35305 .17409 m
.35305 .17409 L
s
.35313 .17714 m
.35313 .17714 L
s
.3532 .17667 m
.3532 .17667 L
s
.35327 .17596 m
.35327 .17596 L
s
.35334 .17456 m
.35334 .17456 L
s
.35342 .17456 m
.35342 .17456 L
s
.35349 .17573 m
.35349 .17573 L
s
.35357 .17479 m
.35357 .17479 L
s
.35364 .17596 m
.35364 .17596 L
s
.35372 .17432 m
.35372 .17432 L
s
.3538 .17456 m
.3538 .17456 L
s
.35387 .17385 m
.35387 .17385 L
s
.35395 .17573 m
.35395 .17573 L
s
.35402 .17526 m
.35402 .17526 L
s
.35409 .17738 m
.35409 .17738 L
s
.35416 .17738 m
.35416 .17738 L
s
.35424 .17667 m
.35424 .17667 L
s
.35431 .17714 m
.35431 .17714 L
s
.35439 .17596 m
.35439 .17596 L
s
.35446 .17761 m
.35446 .17761 L
s
.35454 .17573 m
.35454 .17573 L
s
.35461 .17761 m
.35461 .17761 L
s
.35469 .17714 m
.35469 .17714 L
s
.35476 .17808 m
.35476 .17808 L
s
.35484 .17714 m
.35484 .17714 L
s
.3549 .17808 m
.3549 .17808 L
s
.35498 .17761 m
.35498 .17761 L
s
.35505 .17644 m
.35505 .17644 L
s
.35513 .1762 m
.35513 .1762 L
s
.3552 .17667 m
.3552 .17667 L
s
.35528 .17948 m
.35528 .17948 L
s
.35536 .17738 m
.35536 .17738 L
s
.35543 .17878 m
.35543 .17878 L
s
.35551 .17902 m
.35551 .17902 L
s
.35558 .17973 m
.35558 .17973 L
s
.35565 .17996 m
.35565 .17996 L
s
.35572 .17948 m
.35572 .17948 L
s
.3558 .17761 m
.3558 .17761 L
s
.35587 .17691 m
.35587 .17691 L
s
.35595 .17761 m
.35595 .17761 L
s
.35602 .17667 m
.35602 .17667 L
s
.3561 .17878 m
.3561 .17878 L
s
.35617 .17691 m
.35617 .17691 L
s
.35625 .17808 m
.35625 .17808 L
s
.35632 .17738 m
.35632 .17738 L
s
.3564 .17925 m
.3564 .17925 L
s
.35647 .17855 m
.35647 .17855 L
s
.35654 .17902 m
.35654 .17902 L
s
.35661 .17973 m
.35661 .17973 L
s
.35669 .17948 m
.35669 .17948 L
s
.35676 .1809 m
.35676 .1809 L
s
.35684 .17973 m
.35684 .17973 L
s
.35692 .18066 m
.35692 .18066 L
s
.35699 .17973 m
.35699 .17973 L
s
.35706 .1802 m
.35706 .1802 L
s
.35714 .17925 m
.35714 .17925 L
s
.35722 .18043 m
.35722 .18043 L
s
.35729 .18184 m
.35729 .18184 L
s
.35736 .18066 m
.35736 .18066 L
s
.35743 .18137 m
.35743 .18137 L
s
.35751 .17996 m
.35751 .17996 L
s
.35758 .18113 m
.35758 .18113 L
s
.35766 .1816 m
.35766 .1816 L
s
.35773 .18043 m
.35773 .18043 L
s
.35781 .17996 m
.35781 .17996 L
s
.35788 .1823 m
.35788 .1823 L
s
.35796 .1809 m
.35796 .1809 L
s
.35803 .18137 m
.35803 .18137 L
s
.3581 .18113 m
.3581 .18113 L
s
.35817 .18137 m
.35817 .18137 L
s
.35825 .17902 m
.35825 .17902 L
s
.35832 .17808 m
.35832 .17808 L
s
.3584 .1802 m
.3584 .1802 L
s
.35848 .18043 m
.35848 .18043 L
s
.35855 .18066 m
.35855 .18066 L
s
.35862 .1809 m
.35862 .1809 L
s
.35869 .18254 m
.35869 .18254 L
s
.35877 .18184 m
.35877 .18184 L
s
.35885 .1809 m
.35885 .1809 L
s
.35892 .17996 m
.35892 .17996 L
s
.35899 .18043 m
.35899 .18043 L
s
.35907 .18137 m
.35907 .18137 L
s
.35914 .18184 m
.35914 .18184 L
s
.35922 .18419 m
.35922 .18419 L
s
.35929 .18372 m
.35929 .18372 L
s
.35937 .18348 m
.35937 .18348 L
s
.35944 .18207 m
.35944 .18207 L
s
.35951 .1816 m
.35951 .1816 L
s
.35959 .17878 m
.35959 .17878 L
s
.35967 .17948 m
.35967 .17948 L
s
.35973 .17948 m
.35973 .17948 L
s
.35981 .17996 m
.35981 .17996 L
s
.35988 .1809 m
.35988 .1809 L
s
.35996 .18113 m
.35996 .18113 L
s
.36004 .1823 m
.36004 .1823 L
s
.36011 .1823 m
.36011 .1823 L
s
.36019 .18348 m
.36019 .18348 L
s
.36026 .1823 m
.36026 .1823 L
s
.36033 .18207 m
.36033 .18207 L
s
.3604 .1823 m
.3604 .1823 L
s
.36048 .18184 m
.36048 .18184 L
s
.36055 .18207 m
.36055 .18207 L
s
.36063 .1809 m
.36063 .1809 L
s
.3607 .18277 m
.3607 .18277 L
s
.36078 .18348 m
.36078 .18348 L
s
.36085 .18559 m
.36085 .18559 L
s
.36093 .18559 m
.36093 .18559 L
s
.361 .18771 m
.361 .18771 L
s
.36107 .18818 m
.36107 .18818 L
s
.36114 .18865 m
.36114 .18865 L
s
.36122 .18677 m
.36122 .18677 L
s
.3613 .18701 m
.3613 .18701 L
s
.36137 .18654 m
.36137 .18654 L
s
.36144 .18724 m
.36144 .18724 L
s
.36152 .1863 m
.36152 .1863 L
s
.3616 .18536 m
.3616 .18536 L
s
.36167 .18654 m
.36167 .18654 L
s
.36175 .18583 m
.36175 .18583 L
s
.36182 .18583 m
.36182 .18583 L
s
.36189 .18419 m
.36189 .18419 L
s
.36196 .18818 m
.36196 .18818 L
s
.36204 .18865 m
.36204 .18865 L
s
.36211 .18958 m
.36211 .18958 L
s
.36219 .1903 m
.36219 .1903 L
s
.36226 .18935 m
.36226 .18935 L
s
.36234 .19123 m
.36234 .19123 L
s
.36241 .19076 m
.36241 .19076 L
s
.36249 .19287 m
.36249 .19287 L
s
.36256 .19194 m
.36256 .19194 L
s
.36264 .1924 m
.36264 .1924 L
s
.3627 .1917 m
.3627 .1917 L
s
.36278 .19147 m
.36278 .19147 L
s
.36285 .1917 m
.36285 .1917 L
s
.36293 .19147 m
.36293 .19147 L
s
.363 .19217 m
.363 .19217 L
s
.36308 .1917 m
.36308 .1917 L
s
.36316 .19194 m
.36316 .19194 L
s
.36323 .19053 m
.36323 .19053 L
s
.36331 .19335 m
.36331 .19335 L
s
.36338 .19217 m
.36338 .19217 L
s
.36345 .1924 m
.36345 .1924 L
s
.36352 .19147 m
.36352 .19147 L
s
.3636 .19217 m
.3636 .19217 L
s
.36367 .1924 m
.36367 .1924 L
s
.36375 .1903 m
.36375 .1903 L
s
.36382 .19053 m
.36382 .19053 L
s
.3639 .1903 m
.3639 .1903 L
s
.36397 .191 m
.36397 .191 L
s
.36405 .1903 m
.36405 .1903 L
s
.36412 .18983 m
.36412 .18983 L
s
.3642 .18794 m
.3642 .18794 L
s
.36427 .18841 m
.36427 .18841 L
s
.36434 .18654 m
.36434 .18654 L
s
.36441 .18559 m
.36441 .18559 L
s
.36449 .18701 m
.36449 .18701 L
s
.36456 .18935 m
.36456 .18935 L
s
.36464 .18794 m
.36464 .18794 L
s
.36472 .18701 m
.36472 .18701 L
s
.36479 .18841 m
.36479 .18841 L
s
.36487 .18794 m
.36487 .18794 L
s
.36494 .18912 m
.36494 .18912 L
s
.36502 .18958 m
.36502 .18958 L
s
.36509 .18935 m
.36509 .18935 L
s
.36516 .18701 m
.36516 .18701 L
s
.36523 .18724 m
.36523 .18724 L
s
.36531 .18489 m
.36531 .18489 L
s
.36538 .18442 m
.36538 .18442 L
s
.36546 .18583 m
.36546 .18583 L
s
.36553 .18512 m
.36553 .18512 L
s
.36561 .18701 m
.36561 .18701 L
s
.36568 .18536 m
.36568 .18536 L
s
.36576 .18583 m
.36576 .18583 L
s
.36583 .18583 m
.36583 .18583 L
s
.3659 .18794 m
.3659 .18794 L
s
.36597 .18724 m
.36597 .18724 L
s
.36605 .18724 m
.36605 .18724 L
s
.36612 .18654 m
.36612 .18654 L
s
.3662 .18818 m
.3662 .18818 L
s
.36628 .18701 m
.36628 .18701 L
s
.36635 .18677 m
.36635 .18677 L
s
.36642 .1863 m
.36642 .1863 L
s
.3665 .18536 m
.3665 .18536 L
s
.36658 .18677 m
.36658 .18677 L
s
.36665 .18583 m
.36665 .18583 L
s
.36672 .18512 m
.36672 .18512 L
s
.36679 .18419 m
.36679 .18419 L
s
.36687 .18606 m
.36687 .18606 L
s
.36694 .18865 m
.36694 .18865 L
s
.36702 .18958 m
.36702 .18958 L
s
.36709 .19006 m
.36709 .19006 L
s
.36717 .18865 m
.36717 .18865 L
s
.36724 .18935 m
.36724 .18935 L
s
.36731 .18724 m
.36731 .18724 L
s
.36739 .18841 m
.36739 .18841 L
s
.36747 .18654 m
.36747 .18654 L
s
.36753 .18748 m
.36753 .18748 L
s
.36761 .18748 m
.36761 .18748 L
s
.36768 .18794 m
.36768 .18794 L
s
.36776 .18841 m
.36776 .18841 L
s
.36784 .18958 m
.36784 .18958 L
s
.36791 .18983 m
.36791 .18983 L
s
.36799 .1903 m
.36799 .1903 L
s
.36806 .18912 m
.36806 .18912 L
s
.36813 .18771 m
.36813 .18771 L
s
.36821 .18912 m
.36821 .18912 L
s
.36828 .1903 m
.36828 .1903 L
s
.36835 .18958 m
.36835 .18958 L
s
.36843 .18912 m
.36843 .18912 L
s
.3685 .18888 m
.3685 .18888 L
s
.36858 .18935 m
.36858 .18935 L
s
.36865 .1903 m
.36865 .1903 L
s
.36873 .18935 m
.36873 .18935 L
s
.3688 .18958 m
.3688 .18958 L
s
.36887 .1903 m
.36887 .1903 L
s
.36894 .18888 m
.36894 .18888 L
s
.36902 .18841 m
.36902 .18841 L
s
.3691 .18771 m
.3691 .18771 L
s
.36917 .19006 m
.36917 .19006 L
s
.36924 .18958 m
.36924 .18958 L
s
.36932 .1903 m
.36932 .1903 L
s
.3694 .19006 m
.3694 .19006 L
s
.36947 .18958 m
.36947 .18958 L
s
.36955 .1903 m
.36955 .1903 L
s
.36962 .18958 m
.36962 .18958 L
s
.36969 .19053 m
.36969 .19053 L
s
.36976 .18935 m
.36976 .18935 L
s
.36984 .18865 m
.36984 .18865 L
s
.36992 .18888 m
.36992 .18888 L
s
.36999 .19006 m
.36999 .19006 L
s
.37006 .19053 m
.37006 .19053 L
s
.37014 .19264 m
.37014 .19264 L
s
.37021 .19429 m
.37021 .19429 L
s
.37029 .19382 m
.37029 .19382 L
s
.37036 .19452 m
.37036 .19452 L
s
.37044 .19311 m
.37044 .19311 L
s
.3705 .19522 m
.3705 .19522 L
s
.37058 .19499 m
.37058 .19499 L
s
.37065 .19546 m
.37065 .19546 L
s
.37073 .19546 m
.37073 .19546 L
s
.3708 .19593 m
.3708 .19593 L
s
.37088 .19546 m
.37088 .19546 L
s
.37096 .19664 m
.37096 .19664 L
s
.37103 .19687 m
.37103 .19687 L
s
.37111 .19616 m
.37111 .19616 L
s
.37118 .19569 m
.37118 .19569 L
s
.37125 .19546 m
.37125 .19546 L
s
.37132 .19758 m
.37132 .19758 L
s
.3714 .19664 m
.3714 .19664 L
s
.37147 .1964 m
.37147 .1964 L
s
.37155 .19711 m
.37155 .19711 L
s
.37162 .19804 m
.37162 .19804 L
s
.3717 .19781 m
.3717 .19781 L
s
.37177 .19828 m
.37177 .19828 L
s
.37185 .19851 m
.37185 .19851 L
s
.37192 .19875 m
.37192 .19875 L
s
.372 .19804 m
.372 .19804 L
s
.37207 .1964 m
.37207 .1964 L
s
.37214 .19804 m
.37214 .19804 L
s
.37221 .19664 m
.37221 .19664 L
s
.37229 .19781 m
.37229 .19781 L
s
.37236 .19781 m
.37236 .19781 L
s
.37244 .19851 m
.37244 .19851 L
s
.37252 .19922 m
.37252 .19922 L
s
.37259 .2004 m
.37259 .2004 L
s
.37267 .19968 m
.37267 .19968 L
s
.37274 .19875 m
.37274 .19875 L
s
.37282 .19828 m
.37282 .19828 L
s
.37289 .19711 m
.37289 .19711 L
s
.37296 .19804 m
.37296 .19804 L
s
.37303 .19734 m
.37303 .19734 L
s
.37311 .19781 m
.37311 .19781 L
s
.37318 .19616 m
.37318 .19616 L
s
.37326 .19687 m
.37326 .19687 L
s
.37333 .19429 m
.37333 .19429 L
s
.37341 .19476 m
.37341 .19476 L
s
.37348 .19522 m
.37348 .19522 L
s
.37356 .19522 m
.37356 .19522 L
s
.37363 .19476 m
.37363 .19476 L
s
.3737 .19335 m
.3737 .19335 L
s
.37377 .19452 m
.37377 .19452 L
s
.37385 .19405 m
.37385 .19405 L
s
.37392 .19452 m
.37392 .19452 L
s
.374 .19358 m
.374 .19358 L
s
.37408 .19429 m
.37408 .19429 L
s
.37415 .19522 m
.37415 .19522 L
s
.37422 .19569 m
.37422 .19569 L
s
.3743 .19593 m
.3743 .19593 L
s
.37438 .19569 m
.37438 .19569 L
s
.37445 .19593 m
.37445 .19593 L
s
.37452 .19522 m
.37452 .19522 L
s
.37459 .19546 m
.37459 .19546 L
s
.37467 .19522 m
.37467 .19522 L
s
.37474 .19593 m
.37474 .19593 L
s
.37482 .19499 m
.37482 .19499 L
s
.37489 .19452 m
.37489 .19452 L
s
.37497 .19452 m
.37497 .19452 L
s
.37504 .19499 m
.37504 .19499 L
s
.37512 .1964 m
.37512 .1964 L
s
.37519 .19499 m
.37519 .19499 L
s
.37527 .19664 m
.37527 .19664 L
s
.37533 .19734 m
.37533 .19734 L
s
.37541 .19851 m
.37541 .19851 L
s
.37548 .19828 m
.37548 .19828 L
s
.37556 .19898 m
.37556 .19898 L
s
.37564 .19828 m
.37564 .19828 L
s
.37571 .19734 m
.37571 .19734 L
s
.37579 .19687 m
.37579 .19687 L
s
.37586 .19616 m
.37586 .19616 L
s
.37593 .19734 m
.37593 .19734 L
s
.37601 .19758 m
.37601 .19758 L
s
.37608 .19758 m
.37608 .19758 L
s
.37615 .19711 m
.37615 .19711 L
s
.37623 .19781 m
.37623 .19781 L
s
.3763 .1964 m
.3763 .1964 L
s
.37638 .19664 m
.37638 .19664 L
s
.37645 .19687 m
.37645 .19687 L
s
.37653 .19734 m
.37653 .19734 L
s
.3766 .19734 m
.3766 .19734 L
s
.37667 .1964 m
.37667 .1964 L
s
.37675 .19664 m
.37675 .19664 L
s
.37683 .19546 m
.37683 .19546 L
s
.3769 .19616 m
.3769 .19616 L
s
.37697 .19593 m
.37697 .19593 L
s
.37704 .19664 m
.37704 .19664 L
s
.37712 .19711 m
.37712 .19711 L
s
.3772 .19734 m
.3772 .19734 L
s
.37727 .1964 m
.37727 .1964 L
s
.37735 .19616 m
.37735 .19616 L
s
.37742 .19569 m
.37742 .19569 L
s
.37749 .19546 m
.37749 .19546 L
s
.37756 .19593 m
.37756 .19593 L
s
.37764 .19522 m
.37764 .19522 L
s
.37772 .19593 m
.37772 .19593 L
s
.37779 .1964 m
.37779 .1964 L
s
.37786 .19616 m
.37786 .19616 L
s
.37794 .19546 m
.37794 .19546 L
s
.37801 .1964 m
.37801 .1964 L
s
.37809 .19828 m
.37809 .19828 L
s
.37816 .19922 m
.37816 .19922 L
s
.37824 .2004 m
.37824 .2004 L
s
.3783 .20016 m
.3783 .20016 L
s
.37838 .20133 m
.37838 .20133 L
s
.37846 .20086 m
.37846 .20086 L
s
.37853 .20274 m
.37853 .20274 L
s
.3786 .20274 m
.3786 .20274 L
s
.37868 .2018 m
.37868 .2018 L
s
.37876 .20227 m
.37876 .20227 L
s
.37883 .20016 m
.37883 .20016 L
s
.37891 .19922 m
.37891 .19922 L
s
.37898 .20016 m
.37898 .20016 L
s
.37905 .20227 m
.37905 .20227 L
s
.37912 .20321 m
.37912 .20321 L
s
.3792 .20321 m
.3792 .20321 L
s
.37927 .2011 m
.37927 .2011 L
s
.37935 .20157 m
.37935 .20157 L
s
.37942 .19992 m
.37942 .19992 L
s
.3795 .20204 m
.3795 .20204 L
s
.37957 .20157 m
.37957 .20157 L
s
.37965 .2018 m
.37965 .2018 L
s
.37972 .20274 m
.37972 .20274 L
s
.3798 .2025 m
.3798 .2025 L
s
.37987 .2004 m
.37987 .2004 L
s
.37994 .2025 m
.37994 .2025 L
s
.38001 .2018 m
.38001 .2018 L
s
.38009 .20204 m
.38009 .20204 L
s
.38016 .20392 m
.38016 .20392 L
s
.38024 .20063 m
.38024 .20063 L
s
.38032 .20157 m
.38032 .20157 L
s
.38039 .2011 m
.38039 .2011 L
s
.38047 .2011 m
.38047 .2011 L
s
.38054 .20204 m
.38054 .20204 L
s
.38062 .20297 m
.38062 .20297 L
s
.38069 .2018 m
.38069 .2018 L
s
.38076 .19898 m
.38076 .19898 L
s
.38083 .20086 m
.38083 .20086 L
s
.38091 .19945 m
.38091 .19945 L
s
.38098 .2004 m
.38098 .2004 L
s
.38106 .20133 m
.38106 .20133 L
s
.38113 .20016 m
.38113 .20016 L
s
.38121 .19968 m
.38121 .19968 L
s
.38128 .2011 m
.38128 .2011 L
s
.38136 .20016 m
.38136 .20016 L
s
.38143 .20016 m
.38143 .20016 L
s
.3815 .20086 m
.3815 .20086 L
s
.38157 .19851 m
.38157 .19851 L
s
.38165 .19758 m
.38165 .19758 L
s
.38172 .19476 m
.38172 .19476 L
s
.3818 .19452 m
.3818 .19452 L
s
.38188 .19311 m
.38188 .19311 L
s
.38195 .19452 m
.38195 .19452 L
s
.38202 .19569 m
.38202 .19569 L
s
.3821 .19499 m
.3821 .19499 L
s
.38218 .19499 m
.38218 .19499 L
s
.38225 .19499 m
.38225 .19499 L
s
.38232 .19593 m
.38232 .19593 L
s
.38239 .19452 m
.38239 .19452 L
s
.38247 .19593 m
.38247 .19593 L
s
.38254 .1964 m
.38254 .1964 L
s
.38262 .19781 m
.38262 .19781 L
s
.38269 .19875 m
.38269 .19875 L
s
.38277 .19875 m
.38277 .19875 L
s
.38284 .19804 m
.38284 .19804 L
s
.38292 .19734 m
.38292 .19734 L
s
.38299 .19687 m
.38299 .19687 L
s
.38307 .1964 m
.38307 .1964 L
s
.38313 .19734 m
.38313 .19734 L
s
.38321 .19687 m
.38321 .19687 L
s
.38328 .19687 m
.38328 .19687 L
s
.38336 .19664 m
.38336 .19664 L
s
.38344 .19781 m
.38344 .19781 L
s
.38351 .19546 m
.38351 .19546 L
s
.38359 .19664 m
.38359 .19664 L
s
.38366 .19452 m
.38366 .19452 L
s
.38373 .19569 m
.38373 .19569 L
s
.38381 .19522 m
.38381 .19522 L
s
.38388 .19569 m
.38388 .19569 L
s
.38395 .19522 m
.38395 .19522 L
s
.38403 .19476 m
.38403 .19476 L
s
.3841 .1964 m
.3841 .1964 L
s
.38418 .19546 m
.38418 .19546 L
s
.38425 .1964 m
.38425 .1964 L
s
.38433 .19687 m
.38433 .19687 L
s
.3844 .19828 m
.3844 .19828 L
s
.38447 .19804 m
.38447 .19804 L
s
.38455 .19781 m
.38455 .19781 L
s
.38463 .19875 m
.38463 .19875 L
s
.3847 .19851 m
.3847 .19851 L
s
.38477 .19968 m
.38477 .19968 L
s
.38484 .19992 m
.38484 .19992 L
s
.38492 .19992 m
.38492 .19992 L
s
.385 .19828 m
.385 .19828 L
s
.38507 .19898 m
.38507 .19898 L
s
.38515 .19781 m
.38515 .19781 L
s
.38522 .19828 m
.38522 .19828 L
s
.38529 .19922 m
.38529 .19922 L
s
.38536 .19781 m
.38536 .19781 L
s
.38544 .1964 m
.38544 .1964 L
s
.38552 .19616 m
.38552 .19616 L
s
.38559 .19804 m
.38559 .19804 L
s
.38566 .19616 m
.38566 .19616 L
s
.38574 .19828 m
.38574 .19828 L
s
.38581 .19875 m
.38581 .19875 L
s
.38589 .19992 m
.38589 .19992 L
s
.38596 .19875 m
.38596 .19875 L
s
.38604 .19875 m
.38604 .19875 L
s
.3861 .19968 m
.3861 .19968 L
s
.38618 .19945 m
.38618 .19945 L
s
.38626 .19992 m
.38626 .19992 L
s
.38633 .19992 m
.38633 .19992 L
s
.3864 .19922 m
.3864 .19922 L
s
.38648 .19522 m
.38648 .19522 L
s
.38656 .19593 m
.38656 .19593 L
s
.38663 .19546 m
.38663 .19546 L
s
.38671 .19546 m
.38671 .19546 L
s
.38678 .19546 m
.38678 .19546 L
s
.38685 .19616 m
.38685 .19616 L
s
.38692 .1964 m
.38692 .1964 L
s
.387 .1964 m
.387 .1964 L
s
.38708 .19734 m
.38708 .19734 L
s
.38715 .19522 m
.38715 .19522 L
s
.38722 .19664 m
.38722 .19664 L
s
.3873 .19546 m
.3873 .19546 L
s
.38737 .19616 m
.38737 .19616 L
s
.38745 .19546 m
.38745 .19546 L
s
.38752 .19522 m
.38752 .19522 L
s
.3876 .1964 m
.3876 .1964 L
s
.38767 .19734 m
.38767 .19734 L
s
.38774 .19711 m
.38774 .19711 L
s
.38781 .19664 m
.38781 .19664 L
s
.38789 .19687 m
.38789 .19687 L
s
.38796 .1964 m
.38796 .1964 L
s
.38804 .19664 m
.38804 .19664 L
s
.38812 .19358 m
.38812 .19358 L
s
.38819 .19429 m
.38819 .19429 L
s
.38827 .19358 m
.38827 .19358 L
s
.38834 .19405 m
.38834 .19405 L
s
.38842 .19499 m
.38842 .19499 L
s
.38849 .19546 m
.38849 .19546 L
s
.38856 .19522 m
.38856 .19522 L
s
.38863 .19382 m
.38863 .19382 L
s
.38871 .19429 m
.38871 .19429 L
s
.38878 .19311 m
.38878 .19311 L
s
.38886 .19311 m
.38886 .19311 L
s
.38893 .19429 m
.38893 .19429 L
s
.38901 .19758 m
.38901 .19758 L
s
.38908 .19851 m
.38908 .19851 L
s
.38916 .19968 m
.38916 .19968 L
s
.38923 .19968 m
.38923 .19968 L
s
.3893 .19875 m
.3893 .19875 L
s
.38937 .19898 m
.38937 .19898 L
s
.38945 .19945 m
.38945 .19945 L
s
.38952 .2004 m
.38952 .2004 L
s
.3896 .19851 m
.3896 .19851 L
s
.38968 .19734 m
.38968 .19734 L
s
.38975 .19546 m
.38975 .19546 L
s
.38983 .1964 m
.38983 .1964 L
s
.3899 .19569 m
.3899 .19569 L
s
.38998 .19569 m
.38998 .19569 L
s
.39005 .19452 m
.39005 .19452 L
s
.39012 .19452 m
.39012 .19452 L
s
.39019 .19687 m
.39019 .19687 L
s
.39027 .19593 m
.39027 .19593 L
s
.39034 .19546 m
.39034 .19546 L
s
.39042 .19522 m
.39042 .19522 L
s
.39049 .19828 m
.39049 .19828 L
s
.39057 .19593 m
.39057 .19593 L
s
.39064 .19546 m
.39064 .19546 L
s
.39072 .19429 m
.39072 .19429 L
s
.39079 .19546 m
.39079 .19546 L
s
.39087 .1964 m
.39087 .1964 L
s
.39093 .19781 m
.39093 .19781 L
s
.39101 .19804 m
.39101 .19804 L
s
.39108 .19734 m
.39108 .19734 L
s
.39116 .19569 m
.39116 .19569 L
s
.39124 .19452 m
.39124 .19452 L
s
.39131 .19522 m
.39131 .19522 L
s
.39139 .19476 m
.39139 .19476 L
s
.39146 .19522 m
.39146 .19522 L
s
.39154 .19452 m
.39154 .19452 L
s
.39161 .19499 m
.39161 .19499 L
s
.39169 .19311 m
.39169 .19311 L
s
.39175 .19405 m
.39175 .19405 L
s
.39183 .19358 m
.39183 .19358 L
s
.3919 .19217 m
.3919 .19217 L
s
.39198 .19264 m
.39198 .19264 L
s
.39205 .1917 m
.39205 .1917 L
s
.39213 .1924 m
.39213 .1924 L
s
.3922 .1917 m
.3922 .1917 L
s
.39227 .19123 m
.39227 .19123 L
s
.39235 .18983 m
.39235 .18983 L
s
.39243 .19123 m
.39243 .19123 L
s
.3925 .18958 m
.3925 .18958 L
s
.39257 .18983 m
.39257 .18983 L
s
.39264 .18958 m
.39264 .18958 L
s
.39272 .19006 m
.39272 .19006 L
s
.3928 .1917 m
.3928 .1917 L
s
.39287 .19076 m
.39287 .19076 L
s
.39295 .19358 m
.39295 .19358 L
s
.39302 .19311 m
.39302 .19311 L
s
.39309 .19429 m
.39309 .19429 L
s
.39317 .19452 m
.39317 .19452 L
s
.39325 .19452 m
.39325 .19452 L
s
.39332 .19429 m
.39332 .19429 L
s
.39339 .19405 m
.39339 .19405 L
s
.39346 .19569 m
.39346 .19569 L
s
.39354 .19546 m
.39354 .19546 L
s
.39361 .19616 m
.39361 .19616 L
s
.39369 .19664 m
.39369 .19664 L
s
.39376 .19664 m
.39376 .19664 L
s
.39384 .19546 m
.39384 .19546 L
s
.39391 .19616 m
.39391 .19616 L
s
.39398 .19546 m
.39398 .19546 L
s
.39406 .19452 m
.39406 .19452 L
s
.39413 .19405 m
.39413 .19405 L
s
.3942 .19311 m
.3942 .19311 L
s
.39428 .19335 m
.39428 .19335 L
s
.39436 .19358 m
.39436 .19358 L
s
.39443 .19335 m
.39443 .19335 L
s
.39451 .1924 m
.39451 .1924 L
s
.39458 .19264 m
.39458 .19264 L
s
.39466 .19217 m
.39466 .19217 L
s
.39472 .19194 m
.39472 .19194 L
s
.3948 .19264 m
.3948 .19264 L
s
.39488 .19287 m
.39488 .19287 L
s
.39495 .19429 m
.39495 .19429 L
s
.39502 .19287 m
.39502 .19287 L
s
.3951 .19382 m
.3951 .19382 L
s
.39517 .19382 m
.39517 .19382 L
s
.39525 .19311 m
.39525 .19311 L
s
.39532 .19264 m
.39532 .19264 L
s
.3954 .19522 m
.3954 .19522 L
s
.39547 .19476 m
.39547 .19476 L
s
.39554 .19452 m
.39554 .19452 L
s
.39561 .19358 m
.39561 .19358 L
s
.39569 .19335 m
.39569 .19335 L
s
.39577 .19476 m
.39577 .19476 L
s
.39584 .19358 m
.39584 .19358 L
s
.39592 .19522 m
.39592 .19522 L
s
.39599 .19358 m
.39599 .19358 L
s
.39607 .19311 m
.39607 .19311 L
s
.39614 .19335 m
.39614 .19335 L
s
.39622 .19452 m
.39622 .19452 L
s
.39629 .1924 m
.39629 .1924 L
s
.39636 .19335 m
.39636 .19335 L
s
.39643 .19194 m
.39643 .19194 L
s
.39651 .19147 m
.39651 .19147 L
s
.39658 .19194 m
.39658 .19194 L
s
.39666 .19147 m
.39666 .19147 L
s
.39673 .191 m
.39673 .191 L
s
.39681 .19076 m
.39681 .19076 L
s
.39688 .1917 m
.39688 .1917 L
s
.39696 .1903 m
.39696 .1903 L
s
.39703 .18983 m
.39703 .18983 L
s
.3971 .1903 m
.3971 .1903 L
s
.39717 .19076 m
.39717 .19076 L
s
.39725 .19076 m
.39725 .19076 L
s
.39732 .19287 m
.39732 .19287 L
s
.3974 .1924 m
.3974 .1924 L
s
.39748 .19147 m
.39748 .19147 L
s
.39755 .19311 m
.39755 .19311 L
s
.39763 .19147 m
.39763 .19147 L
s
.3977 .1917 m
.3977 .1917 L
s
.39778 .19053 m
.39778 .19053 L
s
.39785 .1917 m
.39785 .1917 L
s
.39792 .18983 m
.39792 .18983 L
s
.39799 .18935 m
.39799 .18935 L
s
.39807 .18888 m
.39807 .18888 L
s
.39814 .18912 m
.39814 .18912 L
s
.39822 .18771 m
.39822 .18771 L
s
.39829 .18724 m
.39829 .18724 L
s
.39837 .18748 m
.39837 .18748 L
s
.39844 .18654 m
.39844 .18654 L
s
.39852 .18677 m
.39852 .18677 L
s
.39859 .18466 m
.39859 .18466 L
s
.39867 .18536 m
.39867 .18536 L
s
.39874 .18512 m
.39874 .18512 L
s
.39881 .18536 m
.39881 .18536 L
s
.39888 .18583 m
.39888 .18583 L
s
.39896 .18771 m
.39896 .18771 L
s
.39904 .18794 m
.39904 .18794 L
s
.39911 .1863 m
.39911 .1863 L
s
.39919 .18536 m
.39919 .18536 L
s
.39926 .18583 m
.39926 .18583 L
s
.39934 .18701 m
.39934 .18701 L
s
.39941 .18489 m
.39941 .18489 L
s
.39949 .18466 m
.39949 .18466 L
s
.39955 .18325 m
.39955 .18325 L
s
.39963 .18348 m
.39963 .18348 L
s
.3997 .18372 m
.3997 .18372 L
s
.39978 .18512 m
.39978 .18512 L
s
.39985 .18489 m
.39985 .18489 L
s
.39993 .18395 m
.39993 .18395 L
s
.4 .18419 m
.4 .18419 L
s
.40008 .18254 m
.40008 .18254 L
s
.40015 .18301 m
.40015 .18301 L
s
.40023 .18184 m
.40023 .18184 L
s
.4003 .18184 m
.4003 .18184 L
s
.40037 .18137 m
.40037 .18137 L
s
.40044 .18043 m
.40044 .18043 L
s
.40052 .18043 m
.40052 .18043 L
s
.4006 .1809 m
.4006 .1809 L
s
.40067 .18254 m
.40067 .18254 L
s
.40075 .18301 m
.40075 .18301 L
s
.40082 .18512 m
.40082 .18512 L
s
.40089 .18277 m
.40089 .18277 L
s
.40097 .18301 m
.40097 .18301 L
s
.40105 .1823 m
.40105 .1823 L
s
.40112 .18184 m
.40112 .18184 L
s
.40119 .1809 m
.40119 .1809 L
s
.40126 .17996 m
.40126 .17996 L
s
.40134 .18066 m
.40134 .18066 L
s
.40141 .17996 m
.40141 .17996 L
s
.40149 .17902 m
.40149 .17902 L
s
.40156 .17831 m
.40156 .17831 L
s
.40164 .1802 m
.40164 .1802 L
s
.40171 .17996 m
.40171 .17996 L
s
.40179 .18066 m
.40179 .18066 L
s
.40186 .17902 m
.40186 .17902 L
s
.40193 .17948 m
.40193 .17948 L
s
.402 .17831 m
.402 .17831 L
s
.40208 .18043 m
.40208 .18043 L
s
.40216 .17925 m
.40216 .17925 L
s
.40223 .17831 m
.40223 .17831 L
s
.40231 .17996 m
.40231 .17996 L
s
.40238 .17948 m
.40238 .17948 L
s
.40246 .17878 m
.40246 .17878 L
s
.40252 .17691 m
.40252 .17691 L
s
.4026 .17738 m
.4026 .17738 L
s
.40268 .1762 m
.40268 .1762 L
s
.40275 .17644 m
.40275 .17644 L
s
.40282 .17596 m
.40282 .17596 L
s
.4029 .1762 m
.4029 .1762 L
s
.40297 .17784 m
.40297 .17784 L
s
.40305 .17644 m
.40305 .17644 L
s
.40312 .17738 m
.40312 .17738 L
s
.4032 .1762 m
.4032 .1762 L
s
.40327 .17714 m
.40327 .17714 L
s
.40334 .17526 m
.40334 .17526 L
s
.40342 .17573 m
.40342 .17573 L
s
.4035 .17479 m
.4035 .17479 L
s
.40357 .17526 m
.40357 .17526 L
s
.40364 .17573 m
.40364 .17573 L
s
.40372 .17738 m
.40372 .17738 L
s
.40379 .17714 m
.40379 .17714 L
s
.40387 .17714 m
.40387 .17714 L
s
.40394 .17714 m
.40394 .17714 L
s
.40402 .17691 m
.40402 .17691 L
s
.40409 .17784 m
.40409 .17784 L
s
.40416 .17691 m
.40416 .17691 L
s
.40423 .17644 m
.40423 .17644 L
s
.40431 .17526 m
.40431 .17526 L
s
.40438 .17644 m
.40438 .17644 L
s
.40446 .17761 m
.40446 .17761 L
s
.40453 .17738 m
.40453 .17738 L
s
.40461 .17831 m
.40461 .17831 L
s
.40468 .17831 m
.40468 .17831 L
s
.40476 .17855 m
.40476 .17855 L
s
.40483 .17831 m
.40483 .17831 L
s
.4049 .17831 m
.4049 .17831 L
s
.40497 .17784 m
.40497 .17784 L
s
.40505 .17996 m
.40505 .17996 L
s
.40513 .18043 m
.40513 .18043 L
s
.4052 .17996 m
.4052 .17996 L
s
.40528 .17948 m
.40528 .17948 L
s
.40535 .17948 m
.40535 .17948 L
s
.40543 .17996 m
.40543 .17996 L
s
.4055 .17996 m
.4055 .17996 L
s
.40558 .1823 m
.40558 .1823 L
s
.40565 .18137 m
.40565 .18137 L
s
.40572 .18254 m
.40572 .18254 L
s
.40579 .18113 m
.40579 .18113 L
s
.40587 .18137 m
.40587 .18137 L
s
.40594 .17973 m
.40594 .17973 L
s
.40602 .17996 m
.40602 .17996 L
s
.40609 .18043 m
.40609 .18043 L
s
.40617 .1809 m
.40617 .1809 L
s
.40624 .18207 m
.40624 .18207 L
s
.40632 .1809 m
.40632 .1809 L
s
.40639 .18043 m
.40639 .18043 L
s
.40647 .18066 m
.40647 .18066 L
s
.40654 .18113 m
.40654 .18113 L
s
.40661 .18137 m
.40661 .18137 L
s
.40668 .1816 m
.40668 .1816 L
s
.40676 .17996 m
.40676 .17996 L
s
.40684 .1809 m
.40684 .1809 L
s
.40691 .18113 m
.40691 .18113 L
s
.40699 .17973 m
.40699 .17973 L
s
.40706 .1802 m
.40706 .1802 L
s
.40714 .17996 m
.40714 .17996 L
s
.40721 .17831 m
.40721 .17831 L
s
.40729 .17691 m
.40729 .17691 L
s
.40735 .17714 m
.40735 .17714 L
s
.40743 .17738 m
.40743 .17738 L
s
.4075 .17761 m
.4075 .17761 L
s
.40758 .17808 m
.40758 .17808 L
s
.40765 .17996 m
.40765 .17996 L
s
.40773 .17902 m
.40773 .17902 L
s
.4078 .17808 m
.4078 .17808 L
s
.40788 .18043 m
.40788 .18043 L
s
.40795 .1802 m
.40795 .1802 L
s
.40803 .18137 m
.40803 .18137 L
s
.4081 .18184 m
.4081 .18184 L
s
.40817 .18512 m
.40817 .18512 L
s
.40824 .18372 m
.40824 .18372 L
s
.40832 .18372 m
.40832 .18372 L
s
.4084 .18348 m
.4084 .18348 L
s
.40847 .18489 m
.40847 .18489 L
s
.40855 .18606 m
.40855 .18606 L
s
.40862 .18677 m
.40862 .18677 L
s
.4087 .18771 m
.4087 .18771 L
s
.40877 .18583 m
.40877 .18583 L
s
.40885 .18583 m
.40885 .18583 L
s
.40892 .18512 m
.40892 .18512 L
s
.40899 .18536 m
.40899 .18536 L
s
.40906 .18372 m
.40906 .18372 L
s
.40914 .18325 m
.40914 .18325 L
s
.40921 .18254 m
.40921 .18254 L
s
.40929 .18372 m
.40929 .18372 L
s
.40936 .18372 m
.40936 .18372 L
s
.40944 .18301 m
.40944 .18301 L
s
.40951 .18419 m
.40951 .18419 L
s
.40959 .18325 m
.40959 .18325 L
s
.40966 .18419 m
.40966 .18419 L
s
.40973 .18348 m
.40973 .18348 L
s
.4098 .18442 m
.4098 .18442 L
s
.40988 .18254 m
.40988 .18254 L
s
.40996 .1823 m
.40996 .1823 L
s
.41003 .18325 m
.41003 .18325 L
s
.41011 .18325 m
.41011 .18325 L
s
.41018 .18184 m
.41018 .18184 L
s
.41026 .1823 m
.41026 .1823 L
s
.41033 .18325 m
.41033 .18325 L
s
.41041 .18325 m
.41041 .18325 L
s
.41048 .18466 m
.41048 .18466 L
s
.41055 .18184 m
.41055 .18184 L
s
.41062 .18325 m
.41062 .18325 L
s
.4107 .18301 m
.4107 .18301 L
s
.41077 .1823 m
.41077 .1823 L
s
.41085 .18254 m
.41085 .18254 L
s
.41092 .18372 m
.41092 .18372 L
s
.411 .1823 m
.411 .1823 L
s
.41107 .18113 m
.41107 .18113 L
s
.41114 .18254 m
.41114 .18254 L
s
.41122 .1816 m
.41122 .1816 L
s
.4113 .1816 m
.4113 .1816 L
s
.41137 .1802 m
.41137 .1802 L
s
.41144 .18277 m
.41144 .18277 L
s
.41152 .18207 m
.41152 .18207 L
s
.41159 .18277 m
.41159 .18277 L
s
.41167 .18184 m
.41167 .18184 L
s
.41174 .18113 m
.41174 .18113 L
s
.41182 .18254 m
.41182 .18254 L
s
.41189 .1816 m
.41189 .1816 L
s
.41196 .18113 m
.41196 .18113 L
s
.41204 .18277 m
.41204 .18277 L
s
.41212 .18137 m
.41212 .18137 L
s
.41218 .1816 m
.41218 .1816 L
s
.41226 .18137 m
.41226 .18137 L
s
.41233 .18277 m
.41233 .18277 L
s
.41241 .18325 m
.41241 .18325 L
s
.41248 .18301 m
.41248 .18301 L
s
.41256 .18325 m
.41256 .18325 L
s
.41263 .18372 m
.41263 .18372 L
s
.4127 .18277 m
.4127 .18277 L
s
.41277 .18348 m
.41277 .18348 L
s
.41285 .18254 m
.41285 .18254 L
s
.41293 .18466 m
.41293 .18466 L
s
.413 .18348 m
.413 .18348 L
s
.41308 .18559 m
.41308 .18559 L
s
.41315 .18419 m
.41315 .18419 L
s
.41323 .18419 m
.41323 .18419 L
s
.4133 .18325 m
.4133 .18325 L
s
.41338 .1823 m
.41338 .1823 L
s
.41345 .1823 m
.41345 .1823 L
s
.41352 .1823 m
.41352 .1823 L
s
.41359 .18301 m
.41359 .18301 L
s
.41367 .18301 m
.41367 .18301 L
s
.41375 .18395 m
.41375 .18395 L
s
.41382 .18348 m
.41382 .18348 L
s
.41389 .18254 m
.41389 .18254 L
s
.41397 .18137 m
.41397 .18137 L
s
.41404 .18137 m
.41404 .18137 L
s
.41412 .18184 m
.41412 .18184 L
s
.41419 .18043 m
.41419 .18043 L
s
.41427 .1809 m
.41427 .1809 L
s
.41434 .17948 m
.41434 .17948 L
s
.41441 .17902 m
.41441 .17902 L
s
.41448 .17831 m
.41448 .17831 L
s
.41456 .17948 m
.41456 .17948 L
s
.41464 .17855 m
.41464 .17855 L
s
.41471 .17831 m
.41471 .17831 L
s
.41479 .17761 m
.41479 .17761 L
s
.41486 .17714 m
.41486 .17714 L
s
.41494 .17691 m
.41494 .17691 L
s
.41501 .17667 m
.41501 .17667 L
s
.41509 .17596 m
.41509 .17596 L
s
.41515 .17385 m
.41515 .17385 L
s
.41523 .17338 m
.41523 .17338 L
s
.4153 .17033 m
.4153 .17033 L
s
.41538 .17103 m
.41538 .17103 L
s
.41545 .17174 m
.41545 .17174 L
s
.41553 .1715 m
.41553 .1715 L
s
.4156 .16939 m
.4156 .16939 L
s
.41568 .16986 m
.41568 .16986 L
s
.41575 .16845 m
.41575 .16845 L
s
.41583 .16892 m
.41583 .16892 L
s
.4159 .17009 m
.4159 .17009 L
s
.41597 .17009 m
.41597 .17009 L
s
.41604 .17033 m
.41604 .17033 L
s
.41612 .16868 m
.41612 .16868 L
s
.4162 .17033 m
.4162 .17033 L
s
.41627 .16915 m
.41627 .16915 L
s
.41635 .16845 m
.41635 .16845 L
s
.41642 .16821 m
.41642 .16821 L
s
.4165 .16892 m
.4165 .16892 L
s
.41657 .17009 m
.41657 .17009 L
s
.41665 .17056 m
.41665 .17056 L
s
.41672 .17127 m
.41672 .17127 L
s
.41679 .17056 m
.41679 .17056 L
s
.41686 .17127 m
.41686 .17127 L
s
.41694 .1708 m
.41694 .1708 L
s
.41701 .17033 m
.41701 .17033 L
s
.41709 .16915 m
.41709 .16915 L
s
.41716 .16845 m
.41716 .16845 L
s
.41724 .16821 m
.41724 .16821 L
s
.41731 .16704 m
.41731 .16704 L
s
.41739 .16586 m
.41739 .16586 L
s
.41746 .16634 m
.41746 .16634 L
s
.41753 .16704 m
.41753 .16704 L
s
.4176 .16704 m
.4176 .16704 L
s
.41768 .16586 m
.41768 .16586 L
s
.41776 .16469 m
.41776 .16469 L
s
.41783 .16821 m
.41783 .16821 L
s
.41791 .16681 m
.41791 .16681 L
s
.41798 .17009 m
.41798 .17009 L
s
.41806 .16868 m
.41806 .16868 L
s
.41813 .16774 m
.41813 .16774 L
s
.41821 .16727 m
.41821 .16727 L
s
.41828 .16868 m
.41828 .16868 L
s
.41835 .16986 m
.41835 .16986 L
s
.41842 .16868 m
.41842 .16868 L
s
.4185 .16892 m
.4185 .16892 L
s
.41857 .16939 m
.41857 .16939 L
s
.41865 .17009 m
.41865 .17009 L
s
.41872 .16963 m
.41872 .16963 L
s
.4188 .17033 m
.4188 .17033 L
s
.41887 .16963 m
.41887 .16963 L
s
.41895 .17056 m
.41895 .17056 L
s
.41902 .17103 m
.41902 .17103 L
s
.4191 .17197 m
.4191 .17197 L
s
.41917 .17315 m
.41917 .17315 L
s
.41924 .1722 m
.41924 .1722 L
s
.41932 .1722 m
.41932 .1722 L
s
.41939 .17009 m
.41939 .17009 L
s
.41947 .17056 m
.41947 .17056 L
s
.41954 .16939 m
.41954 .16939 L
s
.41962 .16892 m
.41962 .16892 L
s
.41969 .16963 m
.41969 .16963 L
s
.41976 .1708 m
.41976 .1708 L
s
.41984 .17056 m
.41984 .17056 L
s
.41992 .16986 m
.41992 .16986 L
s
.41998 .16892 m
.41998 .16892 L
s
.42006 .16798 m
.42006 .16798 L
s
.42013 .16845 m
.42013 .16845 L
s
.42021 .16727 m
.42021 .16727 L
s
.42028 .16821 m
.42028 .16821 L
s
.42036 .16798 m
.42036 .16798 L
s
.42043 .16939 m
.42043 .16939 L
s
.4205 .16939 m
.4205 .16939 L
s
.42058 .16963 m
.42058 .16963 L
s
.42066 .1708 m
.42066 .1708 L
s
.42073 .16939 m
.42073 .16939 L
s
.4208 .16963 m
.4208 .16963 L
s
.42088 .16939 m
.42088 .16939 L
s
.42095 .16939 m
.42095 .16939 L
s
.42103 .16821 m
.42103 .16821 L
s
.4211 .16986 m
.4211 .16986 L
s
.42118 .17103 m
.42118 .17103 L
s
.42125 .17197 m
.42125 .17197 L
s
.42132 .17174 m
.42132 .17174 L
s
.42139 .17009 m
.42139 .17009 L
s
.42147 .17103 m
.42147 .17103 L
s
.42155 .17009 m
.42155 .17009 L
s
.42162 .17103 m
.42162 .17103 L
s
.42169 .1708 m
.42169 .1708 L
s
.42177 .17244 m
.42177 .17244 L
s
.42184 .17456 m
.42184 .17456 L
s
.42192 .17409 m
.42192 .17409 L
s
.42199 .17291 m
.42199 .17291 L
s
.42207 .17432 m
.42207 .17432 L
s
.42214 .17338 m
.42214 .17338 L
s
.42221 .17174 m
.42221 .17174 L
s
.42229 .17197 m
.42229 .17197 L
s
.42236 .17174 m
.42236 .17174 L
s
.42244 .17267 m
.42244 .17267 L
s
.42251 .17127 m
.42251 .17127 L
s
.42259 .1722 m
.42259 .1722 L
s
.42266 .17197 m
.42266 .17197 L
s
.42274 .17009 m
.42274 .17009 L
s
.42281 .17009 m
.42281 .17009 L
s
.42289 .16915 m
.42289 .16915 L
s
.42295 .16963 m
.42295 .16963 L
s
.42303 .16774 m
.42303 .16774 L
s
.4231 .16774 m
.4231 .16774 L
s
.42318 .16657 m
.42318 .16657 L
s
.42325 .16774 m
.42325 .16774 L
s
.42333 .16681 m
.42333 .16681 L
s
.4234 .16657 m
.4234 .16657 L
s
.42348 .16727 m
.42348 .16727 L
s
.42355 .16821 m
.42355 .16821 L
s
.42363 .16821 m
.42363 .16821 L
s
.4237 .16845 m
.4237 .16845 L
s
.42377 .16915 m
.42377 .16915 L
s
.42384 .17033 m
.42384 .17033 L
s
.42392 .17197 m
.42392 .17197 L
s
.424 .17033 m
.424 .17033 L
s
.42407 .1708 m
.42407 .1708 L
s
.42415 .17033 m
.42415 .17033 L
s
.42422 .17056 m
.42422 .17056 L
s
.4243 .1708 m
.4243 .1708 L
s
.42437 .1715 m
.42437 .1715 L
s
.42445 .17127 m
.42445 .17127 L
s
.42452 .17244 m
.42452 .17244 L
s
.42459 .17338 m
.42459 .17338 L
s
.42466 .17174 m
.42466 .17174 L
s
.42474 .17315 m
.42474 .17315 L
s
.42481 .17315 m
.42481 .17315 L
s
.42489 .17338 m
.42489 .17338 L
s
.42496 .17338 m
.42496 .17338 L
s
.42504 .17526 m
.42504 .17526 L
s
.42511 .17596 m
.42511 .17596 L
s
.42519 .17784 m
.42519 .17784 L
s
.42526 .17808 m
.42526 .17808 L
s
.42533 .17784 m
.42533 .17784 L
s
.4254 .17784 m
.4254 .17784 L
s
.42548 .17714 m
.42548 .17714 L
s
.42556 .17808 m
.42556 .17808 L
s
.42563 .17738 m
.42563 .17738 L
s
.42571 .17761 m
.42571 .17761 L
s
.42578 .1762 m
.42578 .1762 L
s
.42586 .1762 m
.42586 .1762 L
s
.42593 .17691 m
.42593 .17691 L
s
.42601 .1762 m
.42601 .1762 L
s
.42608 .17573 m
.42608 .17573 L
s
.42615 .17644 m
.42615 .17644 L
s
.42622 .17902 m
.42622 .17902 L
s
.4263 .17808 m
.4263 .17808 L
s
.42637 .17831 m
.42637 .17831 L
s
.42645 .17644 m
.42645 .17644 L
s
.42652 .17644 m
.42652 .17644 L
s
.4266 .17691 m
.4266 .17691 L
s
.42667 .17784 m
.42667 .17784 L
s
.42675 .17667 m
.42675 .17667 L
s
.42682 .17479 m
.42682 .17479 L
s
.4269 .17502 m
.4269 .17502 L
s
.42697 .17573 m
.42697 .17573 L
s
.42704 .17691 m
.42704 .17691 L
s
.42712 .17738 m
.42712 .17738 L
s
.42719 .17667 m
.42719 .17667 L
s
.42727 .1762 m
.42727 .1762 L
s
.42734 .17644 m
.42734 .17644 L
s
.42742 .17573 m
.42742 .17573 L
s
.42749 .17644 m
.42749 .17644 L
s
.42757 .17432 m
.42757 .17432 L
s
.42764 .1762 m
.42764 .1762 L
s
.42772 .17667 m
.42772 .17667 L
s
.42778 .17573 m
.42778 .17573 L
s
.42786 .17549 m
.42786 .17549 L
s
.42793 .17432 m
.42793 .17432 L
s
.42801 .17573 m
.42801 .17573 L
s
.42808 .17502 m
.42808 .17502 L
s
.42816 .1762 m
.42816 .1762 L
s
.42823 .17409 m
.42823 .17409 L
s
.4283 .17385 m
.4283 .17385 L
s
.42838 .17338 m
.42838 .17338 L
s
.42846 .17291 m
.42846 .17291 L
s
.42853 .1722 m
.42853 .1722 L
s
.4286 .17291 m
.4286 .17291 L
s
.42868 .17291 m
.42868 .17291 L
s
.42875 .17174 m
.42875 .17174 L
s
.42883 .17338 m
.42883 .17338 L
s
.4289 .17267 m
.4289 .17267 L
s
.42898 .17362 m
.42898 .17362 L
s
.42905 .17197 m
.42905 .17197 L
s
.42912 .1722 m
.42912 .1722 L
s
.4292 .1722 m
.4292 .1722 L
s
.42928 .17244 m
.42928 .17244 L
s
.42935 .1722 m
.42935 .1722 L
s
.42942 .1715 m
.42942 .1715 L
s
.42949 .17267 m
.42949 .17267 L
s
.42957 .1722 m
.42957 .1722 L
s
.42964 .17127 m
.42964 .17127 L
s
.42972 .17197 m
.42972 .17197 L
s
.42979 .17244 m
.42979 .17244 L
s
.42987 .16963 m
.42987 .16963 L
s
.42994 .16939 m
.42994 .16939 L
s
.43001 .17056 m
.43001 .17056 L
s
.43009 .17103 m
.43009 .17103 L
s
.43017 .17197 m
.43017 .17197 L
s
.43024 .17103 m
.43024 .17103 L
s
.43031 .17432 m
.43031 .17432 L
s
.43039 .17385 m
.43039 .17385 L
s
.43046 .17502 m
.43046 .17502 L
s
.43054 .17479 m
.43054 .17479 L
s
.43061 .17526 m
.43061 .17526 L
s
.43069 .17549 m
.43069 .17549 L
s
.43075 .17549 m
.43075 .17549 L
s
.43083 .17526 m
.43083 .17526 L
s
.43091 .17549 m
.43091 .17549 L
s
.43098 .17502 m
.43098 .17502 L
s
.43105 .17456 m
.43105 .17456 L
s
.43113 .17502 m
.43113 .17502 L
s
.4312 .17267 m
.4312 .17267 L
s
.43128 .17197 m
.43128 .17197 L
s
.43135 .17103 m
.43135 .17103 L
s
.43143 .17197 m
.43143 .17197 L
s
.4315 .1708 m
.4315 .1708 L
s
.43157 .17267 m
.43157 .17267 L
s
.43164 .17197 m
.43164 .17197 L
s
.43172 .17267 m
.43172 .17267 L
s
.4318 .17244 m
.4318 .17244 L
s
.43187 .1715 m
.43187 .1715 L
s
.43195 .17291 m
.43195 .17291 L
s
.43202 .17244 m
.43202 .17244 L
s
.4321 .17315 m
.4321 .17315 L
s
.43217 .17362 m
.43217 .17362 L
s
.43225 .17409 m
.43225 .17409 L
s
.43232 .17338 m
.43232 .17338 L
s
.43239 .17338 m
.43239 .17338 L
s
.43246 .17338 m
.43246 .17338 L
s
.43254 .17197 m
.43254 .17197 L
s
.43261 .17385 m
.43261 .17385 L
s
.43269 .17267 m
.43269 .17267 L
s
.43276 .17362 m
.43276 .17362 L
s
.43284 .17362 m
.43284 .17362 L
s
.43291 .17549 m
.43291 .17549 L
s
.43299 .17432 m
.43299 .17432 L
s
.43306 .17432 m
.43306 .17432 L
s
.43314 .17456 m
.43314 .17456 L
s
.4332 .17409 m
.4332 .17409 L
s
.43328 .17385 m
.43328 .17385 L
s
.43336 .17338 m
.43336 .17338 L
s
.43343 .17409 m
.43343 .17409 L
s
.43351 .17456 m
.43351 .17456 L
s
.43358 .17526 m
.43358 .17526 L
s
.43366 .17362 m
.43366 .17362 L
s
.43373 .17502 m
.43373 .17502 L
s
.43381 .17456 m
.43381 .17456 L
s
.43388 .17526 m
.43388 .17526 L
s
.43395 .17409 m
.43395 .17409 L
s
.43402 .17573 m
.43402 .17573 L
s
.4341 .17644 m
.4341 .17644 L
s
.43417 .17573 m
.43417 .17573 L
s
.43425 .17691 m
.43425 .17691 L
s
.43432 .1762 m
.43432 .1762 L
s
.4344 .17526 m
.4344 .17526 L
s
.43447 .17432 m
.43447 .17432 L
s
.43455 .17573 m
.43455 .17573 L
s
.43462 .17456 m
.43462 .17456 L
s
.4347 .17409 m
.4347 .17409 L
s
.43477 .17385 m
.43477 .17385 L
s
.43484 .17291 m
.43484 .17291 L
s
.43492 .17385 m
.43492 .17385 L
s
.43499 .17432 m
.43499 .17432 L
s
.43507 .17432 m
.43507 .17432 L
s
.43514 .17479 m
.43514 .17479 L
s
.43522 .17526 m
.43522 .17526 L
s
.43529 .17385 m
.43529 .17385 L
s
.43537 .17479 m
.43537 .17479 L
s
.43544 .17127 m
.43544 .17127 L
s
.43552 .1708 m
.43552 .1708 L
s
.43558 .17056 m
.43558 .17056 L
s
.43566 .1708 m
.43566 .1708 L
s
.43573 .17174 m
.43573 .17174 L
s
.43581 .17127 m
.43581 .17127 L
s
.43588 .17033 m
.43588 .17033 L
s
.43596 .16915 m
.43596 .16915 L
s
.43603 .16963 m
.43603 .16963 L
s
.43611 .16915 m
.43611 .16915 L
s
.43618 .16963 m
.43618 .16963 L
s
.43626 .16892 m
.43626 .16892 L
s
.43633 .16845 m
.43633 .16845 L
s
.4364 .16939 m
.4364 .16939 L
s
.43648 .16963 m
.43648 .16963 L
s
.43655 .16868 m
.43655 .16868 L
s
.43663 .16681 m
.43663 .16681 L
s
.4367 .16939 m
.4367 .16939 L
s
.43678 .16986 m
.43678 .16986 L
s
.43685 .17033 m
.43685 .17033 L
s
.43692 .16986 m
.43692 .16986 L
s
.437 .17127 m
.437 .17127 L
s
.43708 .16963 m
.43708 .16963 L
s
.43715 .16986 m
.43715 .16986 L
s
.43722 .16939 m
.43722 .16939 L
s
.43729 .17056 m
.43729 .17056 L
s
.43737 .17056 m
.43737 .17056 L
s
.43744 .17056 m
.43744 .17056 L
s
.43752 .16986 m
.43752 .16986 L
s
.43759 .16892 m
.43759 .16892 L
s
.43767 .16963 m
.43767 .16963 L
s
.43774 .16892 m
.43774 .16892 L
s
.43782 .17056 m
.43782 .17056 L
s
.43789 .16963 m
.43789 .16963 L
s
.43797 .17103 m
.43797 .17103 L
s
.43804 .17009 m
.43804 .17009 L
s
.43811 .1708 m
.43811 .1708 L
s
.43819 .17033 m
.43819 .17033 L
s
.43826 .16915 m
.43826 .16915 L
s
.43834 .16657 m
.43834 .16657 L
s
.43841 .16563 m
.43841 .16563 L
s
.43849 .1661 m
.43849 .1661 L
s
.43855 .16492 m
.43855 .16492 L
s
.43863 .16657 m
.43863 .16657 L
s
.43871 .16681 m
.43871 .16681 L
s
.43878 .16751 m
.43878 .16751 L
s
.43885 .16751 m
.43885 .16751 L
s
.43893 .16727 m
.43893 .16727 L
s
.439 .16681 m
.439 .16681 L
s
.43908 .16634 m
.43908 .16634 L
s
.43915 .16751 m
.43915 .16751 L
s
.43923 .16516 m
.43923 .16516 L
s
.4393 .16516 m
.4393 .16516 L
s
.43937 .16469 m
.43937 .16469 L
s
.43945 .16399 m
.43945 .16399 L
s
.43953 .16422 m
.43953 .16422 L
s
.4396 .1621 m
.4396 .1621 L
s
.43967 .1621 m
.43967 .1621 L
s
.43975 .16399 m
.43975 .16399 L
s
.43982 .16492 m
.43982 .16492 L
s
.4399 .16492 m
.4399 .16492 L
s
.43997 .16539 m
.43997 .16539 L
s
.44005 .16352 m
.44005 .16352 L
s
.44012 .16375 m
.44012 .16375 L
s
.44019 .16516 m
.44019 .16516 L
s
.44026 .16563 m
.44026 .16563 L
s
.44034 .16492 m
.44034 .16492 L
s
.44041 .16469 m
.44041 .16469 L
s
.44049 .16422 m
.44049 .16422 L
s
.44056 .16445 m
.44056 .16445 L
s
.44064 .16445 m
.44064 .16445 L
s
.44071 .16375 m
.44071 .16375 L
s
.44079 .16539 m
.44079 .16539 L
s
.44086 .16305 m
.44086 .16305 L
s
.44094 .16375 m
.44094 .16375 L
s
.441 .16281 m
.441 .16281 L
s
.44108 .16164 m
.44108 .16164 L
s
.44116 .16093 m
.44116 .16093 L
s
.44123 .15976 m
.44123 .15976 L
s
.44131 .15953 m
.44131 .15953 L
s
.44138 .15811 m
.44138 .15811 L
s
.44146 .15764 m
.44146 .15764 L
s
.44153 .15835 m
.44153 .15835 L
s
.44161 .15953 m
.44161 .15953 L
s
.44168 .15905 m
.44168 .15905 L
s
.44175 .16023 m
.44175 .16023 L
s
.44182 .16046 m
.44182 .16046 L
s
.4419 .16187 m
.4419 .16187 L
s
.44197 .16117 m
.44197 .16117 L
s
.44205 .16258 m
.44205 .16258 L
s
.44212 .16305 m
.44212 .16305 L
s
.4422 .16399 m
.4422 .16399 L
s
.44227 .16445 m
.44227 .16445 L
s
.44235 .16422 m
.44235 .16422 L
s
.44242 .16516 m
.44242 .16516 L
s
.4425 .16539 m
.4425 .16539 L
s
.44257 .16516 m
.44257 .16516 L
s
.44264 .16375 m
.44264 .16375 L
s
.44272 .16445 m
.44272 .16445 L
s
.44279 .1621 m
.44279 .1621 L
s
.44287 .16375 m
.44287 .16375 L
s
.44294 .16563 m
.44294 .16563 L
s
.44302 .16492 m
.44302 .16492 L
s
.44309 .16586 m
.44309 .16586 L
s
.44317 .16516 m
.44317 .16516 L
s
.44324 .16445 m
.44324 .16445 L
s
.44332 .16281 m
.44332 .16281 L
s
.44338 .16375 m
.44338 .16375 L
s
.44346 .16516 m
.44346 .16516 L
s
.44353 .1661 m
.44353 .1661 L
s
.44361 .16563 m
.44361 .16563 L
s
.44368 .1661 m
.44368 .1661 L
s
.44376 .16634 m
.44376 .16634 L
s
.44383 .16539 m
.44383 .16539 L
s
.44391 .16586 m
.44391 .16586 L
s
.44398 .16586 m
.44398 .16586 L
s
.44406 .16774 m
.44406 .16774 L
s
.44413 .16681 m
.44413 .16681 L
s
.4442 .16774 m
.4442 .16774 L
s
.44428 .16657 m
.44428 .16657 L
s
.44435 .16845 m
.44435 .16845 L
s
.44443 .16774 m
.44443 .16774 L
s
.4445 .16657 m
.4445 .16657 L
s
.44458 .16868 m
.44458 .16868 L
s
.44465 .16821 m
.44465 .16821 L
s
.44473 .16751 m
.44473 .16751 L
s
.4448 .16704 m
.4448 .16704 L
s
.44488 .16774 m
.44488 .16774 L
s
.44495 .16704 m
.44495 .16704 L
s
.44502 .16657 m
.44502 .16657 L
s
.44509 .16469 m
.44509 .16469 L
s
.44517 .16492 m
.44517 .16492 L
s
.44524 .16375 m
.44524 .16375 L
s
.44532 .16492 m
.44532 .16492 L
s
.44539 .16657 m
.44539 .16657 L
s
.44547 .16821 m
.44547 .16821 L
s
.44554 .16915 m
.44554 .16915 L
s
.44562 .16915 m
.44562 .16915 L
s
.44569 .1708 m
.44569 .1708 L
s
.44577 .17103 m
.44577 .17103 L
s
.44584 .1715 m
.44584 .1715 L
s
.44591 .17127 m
.44591 .17127 L
s
.44599 .17338 m
.44599 .17338 L
s
.44606 .17291 m
.44606 .17291 L
s
.44614 .1722 m
.44614 .1722 L
s
.44621 .17127 m
.44621 .17127 L
s
.44629 .17033 m
.44629 .17033 L
s
.44636 .1708 m
.44636 .1708 L
s
.44644 .17127 m
.44644 .17127 L
s
.44651 .17103 m
.44651 .17103 L
s
.44658 .17033 m
.44658 .17033 L
s
.44665 .17244 m
.44665 .17244 L
s
.44673 .17338 m
.44673 .17338 L
s
.4468 .17267 m
.4468 .17267 L
s
.44688 .17573 m
.44688 .17573 L
s
.44695 .1762 m
.44695 .1762 L
s
.44703 .17479 m
.44703 .17479 L
s
.4471 .17409 m
.4471 .17409 L
s
.44717 .17573 m
.44717 .17573 L
s
.44725 .17502 m
.44725 .17502 L
s
.44733 .17573 m
.44733 .17573 L
s
.4474 .17549 m
.4474 .17549 L
s
.44747 .17479 m
.44747 .17479 L
s
.44755 .17315 m
.44755 .17315 L
s
.44762 .17432 m
.44762 .17432 L
s
.4477 .17338 m
.4477 .17338 L
s
.44777 .17338 m
.44777 .17338 L
s
.44785 .17526 m
.44785 .17526 L
s
.44792 .17409 m
.44792 .17409 L
s
.44799 .17549 m
.44799 .17549 L
s
.44807 .17456 m
.44807 .17456 L
s
.44815 .17526 m
.44815 .17526 L
s
.44821 .17409 m
.44821 .17409 L
s
.44829 .17385 m
.44829 .17385 L
s
.44836 .17362 m
.44836 .17362 L
s
.44844 .17502 m
.44844 .17502 L
s
.44851 .17667 m
.44851 .17667 L
s
.44859 .17714 m
.44859 .17714 L
s
.44866 .17714 m
.44866 .17714 L
s
.44874 .17784 m
.44874 .17784 L
s
.4488 .17761 m
.4488 .17761 L
s
.44888 .17738 m
.44888 .17738 L
s
.44896 .17831 m
.44896 .17831 L
s
.44903 .17784 m
.44903 .17784 L
s
.44911 .17902 m
.44911 .17902 L
s
.44918 .17714 m
.44918 .17714 L
s
.44926 .17714 m
.44926 .17714 L
s
.44933 .17738 m
.44933 .17738 L
s
.44941 .17667 m
.44941 .17667 L
s
.44948 .1762 m
.44948 .1762 L
s
.44955 .17644 m
.44955 .17644 L
s
.44962 .17714 m
.44962 .17714 L
s
.4497 .17738 m
.4497 .17738 L
s
.44978 .17761 m
.44978 .17761 L
s
.44985 .17573 m
.44985 .17573 L
s
.44992 .17526 m
.44992 .17526 L
s
.45 .17362 m
.45 .17362 L
s
.45007 .17291 m
.45007 .17291 L
s
.45015 .17362 m
.45015 .17362 L
s
.45022 .17385 m
.45022 .17385 L
s
.4503 .17409 m
.4503 .17409 L
s
.45037 .17338 m
.45037 .17338 L
s
.45044 .17244 m
.45044 .17244 L
s
.45052 .17056 m
.45052 .17056 L
s
.45059 .17127 m
.45059 .17127 L
s
.45067 .17056 m
.45067 .17056 L
s
.45074 .17033 m
.45074 .17033 L
s
.45082 .16986 m
.45082 .16986 L
s
.45089 .16821 m
.45089 .16821 L
s
.45097 .16704 m
.45097 .16704 L
s
.45104 .16563 m
.45104 .16563 L
s
.45112 .16539 m
.45112 .16539 L
s
.45118 .16469 m
.45118 .16469 L
s
.45126 .16657 m
.45126 .16657 L
s
.45133 .16492 m
.45133 .16492 L
s
.45141 .16681 m
.45141 .16681 L
s
.45148 .16681 m
.45148 .16681 L
s
.45156 .16798 m
.45156 .16798 L
s
.45163 .16915 m
.45163 .16915 L
s
.45171 .17009 m
.45171 .17009 L
s
.45178 .16939 m
.45178 .16939 L
s
.45186 .17009 m
.45186 .17009 L
s
.45193 .17103 m
.45193 .17103 L
s
.452 .16915 m
.452 .16915 L
s
.45208 .17056 m
.45208 .17056 L
s
.45215 .16821 m
.45215 .16821 L
s
.45223 .17009 m
.45223 .17009 L
s
.4523 .17033 m
.4523 .17033 L
s
.45238 .17056 m
.45238 .17056 L
s
.45245 .17056 m
.45245 .17056 L
s
.45253 .16892 m
.45253 .16892 L
s
.4526 .16798 m
.4526 .16798 L
s
.45268 .16868 m
.45268 .16868 L
s
.45275 .16939 m
.45275 .16939 L
s
.45282 .16963 m
.45282 .16963 L
s
.45289 .17103 m
.45289 .17103 L
s
.45297 .17127 m
.45297 .17127 L
s
.45304 .17174 m
.45304 .17174 L
s
.45312 .17174 m
.45312 .17174 L
s
.45319 .17103 m
.45319 .17103 L
s
.45327 .1715 m
.45327 .1715 L
s
.45334 .17267 m
.45334 .17267 L
s
.45342 .17315 m
.45342 .17315 L
s
.45349 .17103 m
.45349 .17103 L
s
.45357 .17197 m
.45357 .17197 L
s
.45364 .17174 m
.45364 .17174 L
s
.45371 .17009 m
.45371 .17009 L
s
.45379 .16845 m
.45379 .16845 L
s
.45386 .16892 m
.45386 .16892 L
s
.45394 .16821 m
.45394 .16821 L
s
.45401 .16798 m
.45401 .16798 L
s
.45409 .16821 m
.45409 .16821 L
s
.45416 .16727 m
.45416 .16727 L
s
.45424 .1661 m
.45424 .1661 L
s
.45431 .16634 m
.45431 .16634 L
s
.45438 .16586 m
.45438 .16586 L
s
.45445 .16399 m
.45445 .16399 L
s
.45453 .16539 m
.45453 .16539 L
s
.4546 .16492 m
.4546 .16492 L
s
.45468 .16727 m
.45468 .16727 L
s
.45475 .16774 m
.45475 .16774 L
s
.45483 .17009 m
.45483 .17009 L
s
.4549 .17103 m
.4549 .17103 L
s
.45497 .17009 m
.45497 .17009 L
s
.45505 .17174 m
.45505 .17174 L
s
.45513 .1708 m
.45513 .1708 L
s
.4552 .17127 m
.4552 .17127 L
s
.45527 .17103 m
.45527 .17103 L
s
.45535 .17009 m
.45535 .17009 L
s
.45542 .16892 m
.45542 .16892 L
s
.4555 .16892 m
.4555 .16892 L
s
.45557 .16845 m
.45557 .16845 L
s
.45565 .16892 m
.45565 .16892 L
s
.45572 .16963 m
.45572 .16963 L
s
.45579 .17103 m
.45579 .17103 L
s
.45587 .17291 m
.45587 .17291 L
s
.45595 .1708 m
.45595 .1708 L
s
.45601 .17174 m
.45601 .17174 L
s
.45609 .17127 m
.45609 .17127 L
s
.45616 .17174 m
.45616 .17174 L
s
.45624 .17033 m
.45624 .17033 L
s
.45631 .17127 m
.45631 .17127 L
s
.45639 .1715 m
.45639 .1715 L
s
.45646 .17174 m
.45646 .17174 L
s
.45654 .1715 m
.45654 .1715 L
s
.4566 .17197 m
.4566 .17197 L
s
.45668 .17244 m
.45668 .17244 L
s
.45676 .1708 m
.45676 .1708 L
s
.45683 .17103 m
.45683 .17103 L
s
.45691 .16915 m
.45691 .16915 L
s
.45698 .17009 m
.45698 .17009 L
s
.45706 .16915 m
.45706 .16915 L
s
.45713 .16892 m
.45713 .16892 L
s
.45721 .16963 m
.45721 .16963 L
s
.45728 .16986 m
.45728 .16986 L
s
.45735 .17009 m
.45735 .17009 L
s
.45742 .16892 m
.45742 .16892 L
s
.4575 .17127 m
.4575 .17127 L
s
.45758 .17056 m
.45758 .17056 L
s
.45765 .1708 m
.45765 .1708 L
s
.45772 .17056 m
.45772 .17056 L
s
.4578 .17127 m
.4578 .17127 L
s
.45787 .16986 m
.45787 .16986 L
s
.45795 .16939 m
.45795 .16939 L
s
.45802 .17056 m
.45802 .17056 L
s
.4581 .16915 m
.4581 .16915 L
s
.45817 .17009 m
.45817 .17009 L
s
.45824 .16915 m
.45824 .16915 L
s
.45832 .16845 m
.45832 .16845 L
s
.45839 .16821 m
.45839 .16821 L
s
.45847 .16892 m
.45847 .16892 L
s
.45854 .16751 m
.45854 .16751 L
s
.45862 .16634 m
.45862 .16634 L
s
.45869 .16516 m
.45869 .16516 L
s
.45877 .16657 m
.45877 .16657 L
s
.45884 .16774 m
.45884 .16774 L
s
.45892 .16939 m
.45892 .16939 L
s
.45898 .16868 m
.45898 .16868 L
s
.45906 .16986 m
.45906 .16986 L
s
.45913 .17056 m
.45913 .17056 L
s
.45921 .16774 m
.45921 .16774 L
s
.45928 .1708 m
.45928 .1708 L
s
.45936 .16868 m
.45936 .16868 L
s
.45943 .17127 m
.45943 .17127 L
s
.45951 .1722 m
.45951 .1722 L
s
.45958 .17385 m
.45958 .17385 L
s
.45966 .17456 m
.45966 .17456 L
s
.45973 .17502 m
.45973 .17502 L
s
.4598 .17573 m
.4598 .17573 L
s
.45988 .17691 m
.45988 .17691 L
s
.45995 .17808 m
.45995 .17808 L
s
.46003 .17691 m
.46003 .17691 L
s
.4601 .1762 m
.4601 .1762 L
s
.46018 .17549 m
.46018 .17549 L
s
.46025 .17714 m
.46025 .17714 L
s
.46033 .17667 m
.46033 .17667 L
s
.4604 .17596 m
.4604 .17596 L
s
.46048 .17691 m
.46048 .17691 L
s
.46055 .17714 m
.46055 .17714 L
s
.46062 .17691 m
.46062 .17691 L
s
.46069 .17714 m
.46069 .17714 L
s
.46077 .17996 m
.46077 .17996 L
s
.46084 .17925 m
.46084 .17925 L
s
.46092 .17925 m
.46092 .17925 L
s
.46099 .17761 m
.46099 .17761 L
s
.46107 .17831 m
.46107 .17831 L
s
.46114 .17996 m
.46114 .17996 L
s
.46122 .1802 m
.46122 .1802 L
s
.46129 .18043 m
.46129 .18043 L
s
.46137 .18137 m
.46137 .18137 L
s
.46144 .18254 m
.46144 .18254 L
s
.46151 .18184 m
.46151 .18184 L
s
.46159 .18184 m
.46159 .18184 L
s
.46166 .17973 m
.46166 .17973 L
s
.46174 .17973 m
.46174 .17973 L
s
.46181 .17761 m
.46181 .17761 L
s
.46189 .17667 m
.46189 .17667 L
s
.46196 .17573 m
.46196 .17573 L
s
.46204 .17714 m
.46204 .17714 L
s
.46211 .17691 m
.46211 .17691 L
s
.46218 .17691 m
.46218 .17691 L
s
.46225 .17761 m
.46225 .17761 L
s
.46233 .17456 m
.46233 .17456 L
s
.4624 .17502 m
.4624 .17502 L
s
.46248 .17338 m
.46248 .17338 L
s
.46255 .17362 m
.46255 .17362 L
s
.46263 .1722 m
.46263 .1722 L
s
.4627 .17315 m
.4627 .17315 L
s
.46278 .17244 m
.46278 .17244 L
s
.46285 .17291 m
.46285 .17291 L
s
.46293 .17362 m
.46293 .17362 L
s
.463 .17409 m
.463 .17409 L
s
.46307 .17315 m
.46307 .17315 L
s
.46315 .1708 m
.46315 .1708 L
s
.46322 .17127 m
.46322 .17127 L
s
.4633 .16915 m
.4633 .16915 L
s
.46337 .16868 m
.46337 .16868 L
s
.46345 .16892 m
.46345 .16892 L
s
.46352 .16892 m
.46352 .16892 L
s
.46359 .16868 m
.46359 .16868 L
s
.46367 .16963 m
.46367 .16963 L
s
.46375 .1715 m
.46375 .1715 L
s
.46381 .1708 m
.46381 .1708 L
s
.46389 .17127 m
.46389 .17127 L
s
.46396 .17127 m
.46396 .17127 L
s
.46404 .17127 m
.46404 .17127 L
s
.46411 .17033 m
.46411 .17033 L
s
.46419 .17127 m
.46419 .17127 L
s
.46426 .17056 m
.46426 .17056 L
s
.46434 .16915 m
.46434 .16915 L
s
.46441 .16986 m
.46441 .16986 L
s
.46449 .16915 m
.46449 .16915 L
s
.46457 .16845 m
.46457 .16845 L
s
.46463 .16727 m
.46463 .16727 L
s
.46471 .16774 m
.46471 .16774 L
s
.46478 .16704 m
.46478 .16704 L
s
.46486 .16798 m
.46486 .16798 L
s
.46493 .16774 m
.46493 .16774 L
s
.46501 .16915 m
.46501 .16915 L
s
.46508 .16845 m
.46508 .16845 L
s
.46515 .17056 m
.46515 .17056 L
s
.46522 .17009 m
.46522 .17009 L
s
.4653 .17056 m
.4653 .17056 L
s
.46538 .16892 m
.46538 .16892 L
s
.46545 .16868 m
.46545 .16868 L
s
.46552 .16868 m
.46552 .16868 L
s
.4656 .16821 m
.4656 .16821 L
s
.46567 .16845 m
.46567 .16845 L
s
.46575 .16868 m
.46575 .16868 L
s
.46582 .16963 m
.46582 .16963 L
s
.4659 .16774 m
.4659 .16774 L
s
.46597 .16821 m
.46597 .16821 L
s
.46604 .16774 m
.46604 .16774 L
s
.46612 .16821 m
.46612 .16821 L
s
.4662 .16845 m
.4662 .16845 L
s
.46627 .16727 m
.46627 .16727 L
s
.46634 .16821 m
.46634 .16821 L
s
.46642 .16798 m
.46642 .16798 L
s
.46649 .16868 m
.46649 .16868 L
s
.46657 .16634 m
.46657 .16634 L
s
.46664 .16774 m
.46664 .16774 L
s
.46672 .16704 m
.46672 .16704 L
s
.46678 .16727 m
.46678 .16727 L
s
.46686 .16774 m
.46686 .16774 L
s
.46693 .16727 m
.46693 .16727 L
s
.46701 .16798 m
.46701 .16798 L
s
.46708 .16751 m
.46708 .16751 L
s
.46716 .16774 m
.46716 .16774 L
s
.46723 .16845 m
.46723 .16845 L
s
.46731 .17009 m
.46731 .17009 L
s
.46738 .16915 m
.46738 .16915 L
s
.46746 .16963 m
.46746 .16963 L
s
.46753 .16774 m
.46753 .16774 L
s
.4676 .16986 m
.4676 .16986 L
s
.46768 .16892 m
.46768 .16892 L
s
.46775 .16845 m
.46775 .16845 L
s
.46783 .16986 m
.46783 .16986 L
s
.4679 .16845 m
.4679 .16845 L
s
.46798 .16986 m
.46798 .16986 L
s
.46805 .16939 m
.46805 .16939 L
s
.46813 .17009 m
.46813 .17009 L
s
.4682 .16845 m
.4682 .16845 L
s
.46828 .16963 m
.46828 .16963 L
s
.46835 .16963 m
.46835 .16963 L
s
.46842 .1715 m
.46842 .1715 L
s
.46849 .1715 m
.46849 .1715 L
s
.46857 .16986 m
.46857 .16986 L
s
.46864 .1715 m
.46864 .1715 L
s
.46872 .17174 m
.46872 .17174 L
s
.46879 .1715 m
.46879 .1715 L
s
.46887 .17056 m
.46887 .17056 L
s
.46894 .17197 m
.46894 .17197 L
s
.46902 .17056 m
.46902 .17056 L
s
.46909 .1708 m
.46909 .1708 L
s
.46917 .17056 m
.46917 .17056 L
s
.46924 .17197 m
.46924 .17197 L
s
.46931 .17244 m
.46931 .17244 L
s
.46939 .17197 m
.46939 .17197 L
s
.46946 .17056 m
.46946 .17056 L
s
.46954 .16963 m
.46954 .16963 L
s
.46961 .17103 m
.46961 .17103 L
s
.46969 .16963 m
.46969 .16963 L
s
.46976 .16986 m
.46976 .16986 L
s
.46984 .17009 m
.46984 .17009 L
s
.46991 .16986 m
.46991 .16986 L
s
.46998 .16774 m
.46998 .16774 L
s
.47005 .16774 m
.47005 .16774 L
s
.47013 .16681 m
.47013 .16681 L
s
.4702 .16634 m
.4702 .16634 L
s
.47028 .1661 m
.47028 .1661 L
s
.47035 .16539 m
.47035 .16539 L
s
.47043 .1661 m
.47043 .1661 L
s
.4705 .16516 m
.4705 .16516 L
s
.47058 .16422 m
.47058 .16422 L
s
.47065 .16352 m
.47065 .16352 L
s
.47073 .16399 m
.47073 .16399 L
s
.4708 .16516 m
.4708 .16516 L
s
.47087 .16352 m
.47087 .16352 L
s
.47095 .16281 m
.47095 .16281 L
s
.47102 .1621 m
.47102 .1621 L
s
.4711 .16399 m
.4711 .16399 L
s
.47117 .16305 m
.47117 .16305 L
s
.47125 .16281 m
.47125 .16281 L
s
.47132 .16164 m
.47132 .16164 L
s
.4714 .16281 m
.4714 .16281 L
s
.47147 .16046 m
.47147 .16046 L
s
.47155 .16281 m
.47155 .16281 L
s
.47162 .1621 m
.47162 .1621 L
s
.47169 .16492 m
.47169 .16492 L
s
.47176 .16539 m
.47176 .16539 L
s
.47184 .16634 m
.47184 .16634 L
s
.47191 .1661 m
.47191 .1661 L
s
.47199 .16634 m
.47199 .16634 L
s
.47206 .16774 m
.47206 .16774 L
s
.47214 .16586 m
.47214 .16586 L
s
.47221 .16774 m
.47221 .16774 L
s
.47229 .16634 m
.47229 .16634 L
s
.47237 .16704 m
.47237 .16704 L
s
.47243 .16681 m
.47243 .16681 L
s
.47251 .16727 m
.47251 .16727 L
s
.47258 .16727 m
.47258 .16727 L
s
.47266 .1661 m
.47266 .1661 L
s
.47273 .16774 m
.47273 .16774 L
s
.47281 .16774 m
.47281 .16774 L
s
.47288 .16821 m
.47288 .16821 L
s
.47295 .16657 m
.47295 .16657 L
s
.47303 .16774 m
.47303 .16774 L
s
.47311 .16586 m
.47311 .16586 L
s
.47318 .16704 m
.47318 .16704 L
s
.47325 .16751 m
.47325 .16751 L
s
.47332 .16704 m
.47332 .16704 L
s
.4734 .16657 m
.4734 .16657 L
s
.47347 .16774 m
.47347 .16774 L
s
.47355 .17033 m
.47355 .17033 L
s
.47362 .1722 m
.47362 .1722 L
s
.4737 .17409 m
.4737 .17409 L
s
.47377 .17315 m
.47377 .17315 L
s
.47384 .17385 m
.47384 .17385 L
s
.47392 .17197 m
.47392 .17197 L
s
.474 .1715 m
.474 .1715 L
s
.47407 .17127 m
.47407 .17127 L
s
.47414 .16963 m
.47414 .16963 L
s
.47422 .17009 m
.47422 .17009 L
s
.47429 .16915 m
.47429 .16915 L
s
.47437 .17103 m
.47437 .17103 L
s
.47444 .17009 m
.47444 .17009 L
s
.47452 .17127 m
.47452 .17127 L
s
.47459 .17009 m
.47459 .17009 L
s
.47466 .16939 m
.47466 .16939 L
s
.47474 .17056 m
.47474 .17056 L
s
.47481 .17103 m
.47481 .17103 L
s
.47488 .17009 m
.47488 .17009 L
s
.47496 .17056 m
.47496 .17056 L
s
.47503 .17174 m
.47503 .17174 L
s
.47511 .17127 m
.47511 .17127 L
s
.47518 .17127 m
.47518 .17127 L
s
.47526 .17033 m
.47526 .17033 L
s
.47533 .17315 m
.47533 .17315 L
s
.4754 .17127 m
.4754 .17127 L
s
.47548 .1715 m
.47548 .1715 L
s
.47555 .1722 m
.47555 .1722 L
s
.47563 .17174 m
.47563 .17174 L
s
.4757 .16963 m
.4757 .16963 L
s
.47578 .16963 m
.47578 .16963 L
s
.47585 .17197 m
.47585 .17197 L
s
.47593 .1722 m
.47593 .1722 L
s
.476 .17338 m
.476 .17338 L
s
.47608 .17174 m
.47608 .17174 L
s
.47615 .17174 m
.47615 .17174 L
s
.47622 .17056 m
.47622 .17056 L
s
.47629 .1715 m
.47629 .1715 L
s
.47637 .1708 m
.47637 .1708 L
s
.47645 .1715 m
.47645 .1715 L
s
.47652 .16986 m
.47652 .16986 L
s
.47659 .17009 m
.47659 .17009 L
s
.47667 .17244 m
.47667 .17244 L
s
.47674 .17033 m
.47674 .17033 L
s
.47682 .17174 m
.47682 .17174 L
s
.47689 .17009 m
.47689 .17009 L
s
.47697 .17174 m
.47697 .17174 L
s
.47704 .17197 m
.47704 .17197 L
s
.47711 .17197 m
.47711 .17197 L
s
.47719 .17009 m
.47719 .17009 L
s
.47726 .16986 m
.47726 .16986 L
s
.47734 .17056 m
.47734 .17056 L
s
.47741 .17033 m
.47741 .17033 L
s
.47749 .16939 m
.47749 .16939 L
s
.47756 .16845 m
.47756 .16845 L
s
.47764 .16986 m
.47764 .16986 L
s
.47771 .16798 m
.47771 .16798 L
s
.47778 .1715 m
.47778 .1715 L
s
.47785 .1708 m
.47785 .1708 L
s
.47793 .17103 m
.47793 .17103 L
s
.478 .16868 m
.478 .16868 L
s
.47808 .17056 m
.47808 .17056 L
s
.47815 .1722 m
.47815 .1722 L
s
.47823 .17056 m
.47823 .17056 L
s
.4783 .17009 m
.4783 .17009 L
s
.47838 .16821 m
.47838 .16821 L
s
.47845 .16681 m
.47845 .16681 L
s
.47853 .16704 m
.47853 .16704 L
s
.4786 .16657 m
.4786 .16657 L
s
.47867 .16563 m
.47867 .16563 L
s
.47875 .16657 m
.47875 .16657 L
s
.47882 .16751 m
.47882 .16751 L
s
.4789 .16727 m
.4789 .16727 L
s
.47897 .16539 m
.47897 .16539 L
s
.47905 .16492 m
.47905 .16492 L
s
.47912 .16681 m
.47912 .16681 L
s
.4792 .16492 m
.4792 .16492 L
s
.47927 .16422 m
.47927 .16422 L
s
.47935 .16516 m
.47935 .16516 L
s
.47942 .1661 m
.47942 .1661 L
s
.47949 .16563 m
.47949 .16563 L
s
.47956 .16727 m
.47956 .16727 L
s
.47964 .16563 m
.47964 .16563 L
s
.47971 .16469 m
.47971 .16469 L
s
.47979 .16375 m
.47979 .16375 L
s
.47986 .16539 m
.47986 .16539 L
s
.47994 .16445 m
.47994 .16445 L
s
.48001 .1621 m
.48001 .1621 L
s
.48009 .16305 m
.48009 .16305 L
s
.48017 .16328 m
.48017 .16328 L
s
.48023 .1621 m
.48023 .1621 L
s
.48031 .16117 m
.48031 .16117 L
s
.48038 .16234 m
.48038 .16234 L
s
.48046 .1614 m
.48046 .1614 L
s
.48053 .16117 m
.48053 .16117 L
s
.48061 .16187 m
.48061 .16187 L
s
.48068 .1607 m
.48068 .1607 L
s
.48075 .15976 m
.48075 .15976 L
s
.48083 .15953 m
.48083 .15953 L
s
.48091 .15788 m
.48091 .15788 L
s
.48098 .15788 m
.48098 .15788 L
s
.48105 .15953 m
.48105 .15953 L
s
.48112 .15929 m
.48112 .15929 L
s
.4812 .15929 m
.4812 .15929 L
s
.48127 .15905 m
.48127 .15905 L
s
.48135 .15764 m
.48135 .15764 L
s
.48142 .15835 m
.48142 .15835 L
s
.4815 .15741 m
.4815 .15741 L
s
.48157 .15764 m
.48157 .15764 L
s
.48165 .15764 m
.48165 .15764 L
s
.48173 .156 m
.48173 .156 L
s
.4818 .15506 m
.4818 .15506 L
s
.48187 .15741 m
.48187 .15741 L
s
.48194 .15764 m
.48194 .15764 L
s
.48202 .15882 m
.48202 .15882 L
s
.48209 .15882 m
.48209 .15882 L
s
.48217 .15764 m
.48217 .15764 L
s
.48224 .15858 m
.48224 .15858 L
s
.48232 .15788 m
.48232 .15788 L
s
.48239 .15741 m
.48239 .15741 L
s
.48246 .15764 m
.48246 .15764 L
s
.48254 .15905 m
.48254 .15905 L
s
.48261 .15858 m
.48261 .15858 L
s
.48268 .16023 m
.48268 .16023 L
s
.48276 .16023 m
.48276 .16023 L
s
.48283 .15929 m
.48283 .15929 L
s
.48291 .15999 m
.48291 .15999 L
s
.48298 .16117 m
.48298 .16117 L
s
.48306 .16046 m
.48306 .16046 L
s
.48313 .15858 m
.48313 .15858 L
s
.4832 .15976 m
.4832 .15976 L
s
.48328 .15858 m
.48328 .15858 L
s
.48336 .15858 m
.48336 .15858 L
s
.48343 .15788 m
.48343 .15788 L
s
.4835 .15858 m
.4835 .15858 L
s
.48358 .15741 m
.48358 .15741 L
s
.48365 .15788 m
.48365 .15788 L
s
.48373 .15835 m
.48373 .15835 L
s
.4838 .15976 m
.4838 .15976 L
s
.48388 .16187 m
.48388 .16187 L
s
.48395 .1621 m
.48395 .1621 L
s
.48402 .16469 m
.48402 .16469 L
s
.48409 .16422 m
.48409 .16422 L
s
.48417 .16399 m
.48417 .16399 L
s
.48425 .16399 m
.48425 .16399 L
s
.48432 .16445 m
.48432 .16445 L
s
.48439 .16399 m
.48439 .16399 L
s
.48447 .16375 m
.48447 .16375 L
s
.48454 .16399 m
.48454 .16399 L
s
.48462 .16399 m
.48462 .16399 L
s
.48469 .1661 m
.48469 .1661 L
s
.48477 .16563 m
.48477 .16563 L
s
.48484 .16492 m
.48484 .16492 L
s
.48491 .16586 m
.48491 .16586 L
s
.48499 .16751 m
.48499 .16751 L
s
.48506 .16516 m
.48506 .16516 L
s
.48514 .16586 m
.48514 .16586 L
s
.48521 .16445 m
.48521 .16445 L
s
.48529 .16234 m
.48529 .16234 L
s
.48536 .15953 m
.48536 .15953 L
s
.48544 .15882 m
.48544 .15882 L
s
.48551 .15999 m
.48551 .15999 L
s
.48558 .15858 m
.48558 .15858 L
s
.48565 .15976 m
.48565 .15976 L
s
.48573 .15811 m
.48573 .15811 L
s
.4858 .15976 m
.4858 .15976 L
s
.48588 .15929 m
.48588 .15929 L
s
.48595 .15929 m
.48595 .15929 L
s
.48603 .15929 m
.48603 .15929 L
s
.4861 .15953 m
.4861 .15953 L
s
.48618 .15999 m
.48618 .15999 L
s
.48625 .15835 m
.48625 .15835 L
s
.48633 .15999 m
.48633 .15999 L
s
.4864 .15999 m
.4864 .15999 L
s
.48647 .15929 m
.48647 .15929 L
s
.48655 .15811 m
.48655 .15811 L
s
.48662 .15835 m
.48662 .15835 L
s
.4867 .15671 m
.4867 .15671 L
s
.48677 .15835 m
.48677 .15835 L
s
.48685 .15929 m
.48685 .15929 L
s
.48692 .15976 m
.48692 .15976 L
s
.487 .1614 m
.487 .1614 L
s
.48707 .1607 m
.48707 .1607 L
s
.48715 .1621 m
.48715 .1621 L
s
.48722 .16352 m
.48722 .16352 L
s
.48729 .16469 m
.48729 .16469 L
s
.48736 .16164 m
.48736 .16164 L
s
.48744 .16305 m
.48744 .16305 L
s
.48751 .16117 m
.48751 .16117 L
s
.48759 .16164 m
.48759 .16164 L
s
.48766 .16187 m
.48766 .16187 L
s
.48774 .16281 m
.48774 .16281 L
s
.48781 .16305 m
.48781 .16305 L
s
.48789 .16234 m
.48789 .16234 L
s
.48797 .16305 m
.48797 .16305 L
s
.48803 .16281 m
.48803 .16281 L
s
.48811 .16187 m
.48811 .16187 L
s
.48818 .16187 m
.48818 .16187 L
s
.48826 .16117 m
.48826 .16117 L
s
.48833 .1614 m
.48833 .1614 L
s
.48841 .16117 m
.48841 .16117 L
s
.48848 .16187 m
.48848 .16187 L
s
.48856 .16117 m
.48856 .16117 L
s
.48863 .16164 m
.48863 .16164 L
s
.48871 .15882 m
.48871 .15882 L
s
.48878 .15999 m
.48878 .15999 L
s
.48885 .15671 m
.48885 .15671 L
s
.48892 .15741 m
.48892 .15741 L
s
.489 .15576 m
.489 .15576 L
s
.48907 .15647 m
.48907 .15647 L
s
.48915 .15741 m
.48915 .15741 L
s
.48922 .15717 m
.48922 .15717 L
s
.4893 .15764 m
.4893 .15764 L
s
.48937 .15553 m
.48937 .15553 L
s
.48945 .15624 m
.48945 .15624 L
s
.48953 .15459 m
.48953 .15459 L
s
.4896 .15482 m
.4896 .15482 L
s
.48967 .15342 m
.48967 .15342 L
s
.48974 .15389 m
.48974 .15389 L
s
.48982 .15271 m
.48982 .15271 L
s
.48989 .15083 m
.48989 .15083 L
s
.48997 .14895 m
.48997 .14895 L
s
.49004 .14943 m
.49004 .14943 L
s
.49012 .14895 m
.49012 .14895 L
s
.49019 .14872 m
.49019 .14872 L
s
.49027 .14872 m
.49027 .14872 L
s
.49034 .14943 m
.49034 .14943 L
s
.49041 .14966 m
.49041 .14966 L
s
.49048 .14919 m
.49048 .14919 L
s
.49056 .14989 m
.49056 .14989 L
s
.49063 .15013 m
.49063 .15013 L
s
.49071 .15013 m
.49071 .15013 L
s
.49078 .14872 m
.49078 .14872 L
s
.49086 .14895 m
.49086 .14895 L
s
.49093 .14989 m
.49093 .14989 L
s
.491 .15036 m
.491 .15036 L
s
.49108 .14943 m
.49108 .14943 L
s
.49116 .14825 m
.49116 .14825 L
s
.49123 .14825 m
.49123 .14825 L
s
.4913 .14707 m
.4913 .14707 L
s
.49138 .14707 m
.49138 .14707 L
s
.49145 .14778 m
.49145 .14778 L
s
.49153 .14614 m
.49153 .14614 L
s
.4916 .1459 m
.4916 .1459 L
s
.49168 .14614 m
.49168 .14614 L
s
.49175 .1459 m
.49175 .1459 L
s
.49182 .14496 m
.49182 .14496 L
s
.4919 .14519 m
.4919 .14519 L
s
.49198 .14472 m
.49198 .14472 L
s
.49205 .14355 m
.49205 .14355 L
s
.49212 .14167 m
.49212 .14167 L
s
.49219 .14167 m
.49219 .14167 L
s
.49227 .14026 m
.49227 .14026 L
s
.49234 .14003 m
.49234 .14003 L
s
.49242 .1405 m
.49242 .1405 L
s
.49249 .13956 m
.49249 .13956 L
s
.49257 .14026 m
.49257 .14026 L
s
.49264 .13861 m
.49264 .13861 L
s
.49271 .1405 m
.49271 .1405 L
s
.49279 .1405 m
.49279 .1405 L
s
.49286 .14073 m
.49286 .14073 L
s
.49294 .14073 m
.49294 .14073 L
s
.49301 .14097 m
.49301 .14097 L
s
.49309 .14097 m
.49309 .14097 L
s
.49316 .1412 m
.49316 .1412 L
s
.49324 .14097 m
.49324 .14097 L
s
.49331 .1419 m
.49331 .1419 L
s
.49338 .14379 m
.49338 .14379 L
s
.49345 .14402 m
.49345 .14402 L
s
.49353 .14308 m
.49353 .14308 L
s
.49361 .14285 m
.49361 .14285 L
s
.49368 .14332 m
.49368 .14332 L
s
.49375 .14332 m
.49375 .14332 L
s
.49383 .14425 m
.49383 .14425 L
s
.4939 .14308 m
.4939 .14308 L
s
.49398 .14425 m
.49398 .14425 L
s
.49405 .14425 m
.49405 .14425 L
s
.49413 .14472 m
.49413 .14472 L
s
.4942 .14567 m
.4942 .14567 L
s
.49427 .14496 m
.49427 .14496 L
s
.49435 .14567 m
.49435 .14567 L
s
.49442 .14543 m
.49442 .14543 L
s
.4945 .14825 m
.4945 .14825 L
s
.49457 .14661 m
.49457 .14661 L
s
.49465 .14731 m
.49465 .14731 L
s
.49472 .14707 m
.49472 .14707 L
s
.4948 .14848 m
.4948 .14848 L
s
.49487 .14872 m
.49487 .14872 L
s
.49495 .14707 m
.49495 .14707 L
s
.49502 .14801 m
.49502 .14801 L
s
.49509 .14661 m
.49509 .14661 L
s
.49516 .15036 m
.49516 .15036 L
s
.49524 .15013 m
.49524 .15013 L
s
.49531 .15224 m
.49531 .15224 L
s
.49539 .15318 m
.49539 .15318 L
s
.49546 .15365 m
.49546 .15365 L
s
.49554 .15271 m
.49554 .15271 L
s
.49561 .15365 m
.49561 .15365 L
s
.49569 .15342 m
.49569 .15342 L
s
.49577 .152 m
.49577 .152 L
s
.49583 .15365 m
.49583 .15365 L
s
.49591 .15224 m
.49591 .15224 L
s
.49598 .152 m
.49598 .152 L
s
.49606 .15013 m
.49606 .15013 L
s
.49613 .15107 m
.49613 .15107 L
s
.49621 .15013 m
.49621 .15013 L
s
.49628 .15083 m
.49628 .15083 L
s
.49636 .15036 m
.49636 .15036 L
s
.49643 .14989 m
.49643 .14989 L
s
.49651 .1513 m
.49651 .1513 L
s
.49658 .14966 m
.49658 .14966 L
s
.49665 .1506 m
.49665 .1506 L
s
.49672 .15013 m
.49672 .15013 L
s
.4968 .1506 m
.4968 .1506 L
s
.49687 .14943 m
.49687 .14943 L
s
.49695 .14895 m
.49695 .14895 L
s
.49702 .14872 m
.49702 .14872 L
s
.4971 .14943 m
.4971 .14943 L
s
.49717 .14943 m
.49717 .14943 L
s
.49725 .14989 m
.49725 .14989 L
s
.49733 .15271 m
.49733 .15271 L
s
.4974 .1513 m
.4974 .1513 L
s
.49747 .15224 m
.49747 .15224 L
s
.49754 .14966 m
.49754 .14966 L
s
.49762 .15083 m
.49762 .15083 L
s
.49769 .14989 m
.49769 .14989 L
s
.49777 .14989 m
.49777 .14989 L
s
.49784 .14848 m
.49784 .14848 L
s
.49792 .14895 m
.49792 .14895 L
s
.49799 .14754 m
.49799 .14754 L
s
.49807 .14731 m
.49807 .14731 L
s
.49814 .14637 m
.49814 .14637 L
s
.49821 .14661 m
.49821 .14661 L
s
.49828 .14825 m
.49828 .14825 L
s
.49836 .1459 m
.49836 .1459 L
s
.49843 .14707 m
.49843 .14707 L
s
.49851 .14496 m
.49851 .14496 L
s
.49858 .14449 m
.49858 .14449 L
s
.49866 .14472 m
.49866 .14472 L
s
.49873 .14543 m
.49873 .14543 L
s
.49881 .14472 m
.49881 .14472 L
s
.49889 .14543 m
.49889 .14543 L
s
.49896 .14661 m
.49896 .14661 L
s
.49903 .14567 m
.49903 .14567 L
s
.4991 .14661 m
.4991 .14661 L
s
.49918 .14637 m
.49918 .14637 L
s
.49925 .14825 m
.49925 .14825 L
s
.49933 .14778 m
.49933 .14778 L
s
.4994 .15013 m
.4994 .15013 L
s
.49948 .15107 m
.49948 .15107 L
s
.49955 .15365 m
.49955 .15365 L
s
.49962 .15389 m
.49962 .15389 L
s
.4997 .15271 m
.4997 .15271 L
s
.49978 .15295 m
.49978 .15295 L
s
.49985 .152 m
.49985 .152 L
s
.49992 .15459 m
.49992 .15459 L
s
.49999 .15224 m
.49999 .15224 L
s
.50007 .15318 m
.50007 .15318 L
s
.50014 .15248 m
.50014 .15248 L
s
.50022 .15318 m
.50022 .15318 L
s
.50029 .15342 m
.50029 .15342 L
s
.50037 .15318 m
.50037 .15318 L
s
.50044 .15389 m
.50044 .15389 L
s
.50052 .15342 m
.50052 .15342 L
s
.5006 .15295 m
.5006 .15295 L
s
.50066 .15224 m
.50066 .15224 L
s
.50074 .15365 m
.50074 .15365 L
s
.50081 .15365 m
.50081 .15365 L
s
.50089 .15459 m
.50089 .15459 L
s
.50096 .15177 m
.50096 .15177 L
s
.50104 .15013 m
.50104 .15013 L
s
.50111 .14872 m
.50111 .14872 L
s
.50118 .14943 m
.50118 .14943 L
s
.50125 .15036 m
.50125 .15036 L
s
.50133 .15013 m
.50133 .15013 L
s
.50141 .15083 m
.50141 .15083 L
s
.50148 .14989 m
.50148 .14989 L
s
.50155 .1506 m
.50155 .1506 L
s
.50163 .15036 m
.50163 .15036 L
s
.5017 .15154 m
.5017 .15154 L
s
.50178 .14872 m
.50178 .14872 L
s
.50185 .14919 m
.50185 .14919 L
s
.50193 .14778 m
.50193 .14778 L
s
.502 .14848 m
.502 .14848 L
s
.50207 .14707 m
.50207 .14707 L
s
.50215 .14661 m
.50215 .14661 L
s
.50223 .14778 m
.50223 .14778 L
s
.5023 .14731 m
.5023 .14731 L
s
.50237 .14919 m
.50237 .14919 L
s
.50245 .14778 m
.50245 .14778 L
s
.50252 .14825 m
.50252 .14825 L
s
.5026 .14754 m
.5026 .14754 L
s
.50267 .14731 m
.50267 .14731 L
s
.50275 .1459 m
.50275 .1459 L
s
.50282 .14637 m
.50282 .14637 L
s
.50289 .14449 m
.50289 .14449 L
s
.50296 .1459 m
.50296 .1459 L
s
.50304 .14519 m
.50304 .14519 L
s
.50311 .14449 m
.50311 .14449 L
s
.50319 .14472 m
.50319 .14472 L
s
.50326 .14214 m
.50326 .14214 L
s
.50334 .14214 m
.50334 .14214 L
s
.50341 .1405 m
.50341 .1405 L
s
.50349 .14167 m
.50349 .14167 L
s
.50357 .1405 m
.50357 .1405 L
s
.50363 .1412 m
.50363 .1412 L
s
.50371 .14285 m
.50371 .14285 L
s
.50378 .14214 m
.50378 .14214 L
s
.50386 .14285 m
.50386 .14285 L
s
.50393 .13933 m
.50393 .13933 L
s
.50401 .14026 m
.50401 .14026 L
s
.50408 .14003 m
.50408 .14003 L
s
.50416 .1412 m
.50416 .1412 L
s
.50423 .14167 m
.50423 .14167 L
s
.50431 .14143 m
.50431 .14143 L
s
.50438 .14097 m
.50438 .14097 L
s
.50445 .1405 m
.50445 .1405 L
s
.50452 .14261 m
.50452 .14261 L
s
.5046 .14238 m
.5046 .14238 L
s
.50467 .1419 m
.50467 .1419 L
s
.50475 .1419 m
.50475 .1419 L
s
.50482 .14332 m
.50482 .14332 L
s
.5049 .14167 m
.5049 .14167 L
s
.50497 .14214 m
.50497 .14214 L
s
.50505 .14003 m
.50505 .14003 L
s
.50513 .13979 m
.50513 .13979 L
s
.5052 .13838 m
.5052 .13838 L
s
.50527 .13768 m
.50527 .13768 L
s
.50534 .13815 m
.50534 .13815 L
s
.50542 .13956 m
.50542 .13956 L
s
.50549 .1405 m
.50549 .1405 L
s
.50557 .13861 m
.50557 .13861 L
s
.50564 .13886 m
.50564 .13886 L
s
.50572 .13886 m
.50572 .13886 L
s
.50579 .13721 m
.50579 .13721 L
s
.50587 .13627 m
.50587 .13627 L
s
.50594 .13557 m
.50594 .13557 L
s
.50602 .13462 m
.50602 .13462 L
s
.50608 .13392 m
.50608 .13392 L
s
.50616 .13462 m
.50616 .13462 L
s
.50623 .13533 m
.50623 .13533 L
s
.50631 .13768 m
.50631 .13768 L
s
.50638 .13838 m
.50638 .13838 L
s
.50646 .14026 m
.50646 .14026 L
s
.50653 .14003 m
.50653 .14003 L
s
.50661 .13909 m
.50661 .13909 L
s
.50669 .13721 m
.50669 .13721 L
s
.50676 .13886 m
.50676 .13886 L
s
.50683 .13956 m
.50683 .13956 L
s
.5069 .13838 m
.5069 .13838 L
s
.50698 .13721 m
.50698 .13721 L
s
.50705 .13674 m
.50705 .13674 L
s
.50713 .13744 m
.50713 .13744 L
s
.5072 .13627 m
.5072 .13627 L
s
.50728 .13768 m
.50728 .13768 L
s
.50735 .1358 m
.50735 .1358 L
s
.50743 .1358 m
.50743 .1358 L
s
.5075 .13533 m
.5075 .13533 L
s
.50758 .13533 m
.50758 .13533 L
s
.50765 .13604 m
.50765 .13604 L
s
.50772 .13392 m
.50772 .13392 L
s
.50779 .13322 m
.50779 .13322 L
s
.50787 .13322 m
.50787 .13322 L
s
.50794 .13369 m
.50794 .13369 L
s
.50802 .13251 m
.50802 .13251 L
s
.50809 .13439 m
.50809 .13439 L
s
.50817 .13533 m
.50817 .13533 L
s
.50824 .13604 m
.50824 .13604 L
s
.50832 .13486 m
.50832 .13486 L
s
.5084 .13439 m
.5084 .13439 L
s
.50846 .13345 m
.50846 .13345 L
s
.50854 .13462 m
.50854 .13462 L
s
.50861 .13604 m
.50861 .13604 L
s
.50869 .13721 m
.50869 .13721 L
s
.50876 .1358 m
.50876 .1358 L
s
.50884 .13392 m
.50884 .13392 L
s
.50891 .13462 m
.50891 .13462 L
s
.50899 .13369 m
.50899 .13369 L
s
.50906 .13415 m
.50906 .13415 L
s
.50914 .13345 m
.50914 .13345 L
s
.50921 .13345 m
.50921 .13345 L
s
.50928 .13345 m
.50928 .13345 L
s
.50935 .13345 m
.50935 .13345 L
s
.50943 .1324 m
.50943 .1324 L
s
.5095 .13415 m
.5095 .13415 L
s
.50958 .13744 m
.50958 .13744 L
s
.50965 .13768 m
.50965 .13768 L
s
.50973 .13533 m
.50973 .13533 L
s
.5098 .13345 m
.5098 .13345 L
s
.50987 .13369 m
.50987 .13369 L
s
.50995 .13345 m
.50995 .13345 L
s
.51003 .13369 m
.51003 .13369 L
s
.5101 .13439 m
.5101 .13439 L
s
.51017 .13345 m
.51017 .13345 L
s
.51025 .13439 m
.51025 .13439 L
s
.51032 .13369 m
.51032 .13369 L
s
.5104 .13509 m
.5104 .13509 L
s
.51047 .13557 m
.51047 .13557 L
s
.51055 .13557 m
.51055 .13557 L
s
.51062 .13486 m
.51062 .13486 L
s
.51069 .1358 m
.51069 .1358 L
s
.51077 .13533 m
.51077 .13533 L
s
.51085 .1358 m
.51085 .1358 L
s
.51091 .13674 m
.51091 .13674 L
s
.51099 .13604 m
.51099 .13604 L
s
.51106 .13651 m
.51106 .13651 L
s
.51114 .13604 m
.51114 .13604 L
s
.51121 .13721 m
.51121 .13721 L
s
.51129 .13815 m
.51129 .13815 L
s
.51137 .14026 m
.51137 .14026 L
s
.51143 .13909 m
.51143 .13909 L
s
.51151 .1419 m
.51151 .1419 L
s
.51158 .14214 m
.51158 .14214 L
s
.51166 .14214 m
.51166 .14214 L
s
.51173 .1412 m
.51173 .1412 L
s
.51181 .14238 m
.51181 .14238 L
s
.51188 .14425 m
.51188 .14425 L
s
.51196 .14308 m
.51196 .14308 L
s
.51203 .14543 m
.51203 .14543 L
s
.51211 .14567 m
.51211 .14567 L
s
.51218 .14614 m
.51218 .14614 L
s
.51225 .14684 m
.51225 .14684 L
s
.51232 .14707 m
.51232 .14707 L
s
.5124 .14661 m
.5124 .14661 L
s
.51248 .14731 m
.51248 .14731 L
s
.51255 .14848 m
.51255 .14848 L
s
.51262 .14778 m
.51262 .14778 L
s
.5127 .14614 m
.5127 .14614 L
s
.51277 .14778 m
.51277 .14778 L
s
.51285 .14943 m
.51285 .14943 L
s
.51293 .14966 m
.51293 .14966 L
s
.513 .15224 m
.513 .15224 L
s
.51307 .15224 m
.51307 .15224 L
s
.51314 .15177 m
.51314 .15177 L
s
.51322 .15036 m
.51322 .15036 L
s
.51329 .15036 m
.51329 .15036 L
s
.51337 .15177 m
.51337 .15177 L
s
.51344 .15013 m
.51344 .15013 L
s
.51352 .14989 m
.51352 .14989 L
s
.51359 .14848 m
.51359 .14848 L
s
.51367 .14848 m
.51367 .14848 L
s
.51374 .14919 m
.51374 .14919 L
s
.51382 .14848 m
.51382 .14848 L
s
.51388 .14754 m
.51388 .14754 L
s
.51396 .14754 m
.51396 .14754 L
s
.51403 .14848 m
.51403 .14848 L
s
.51411 .14731 m
.51411 .14731 L
s
.51418 .14661 m
.51418 .14661 L
s
.51426 .1459 m
.51426 .1459 L
s
.51433 .1459 m
.51433 .1459 L
s
.51441 .14379 m
.51441 .14379 L
s
.51449 .14379 m
.51449 .14379 L
s
.51456 .14261 m
.51456 .14261 L
s
.51463 .14425 m
.51463 .14425 L
s
.5147 .14567 m
.5147 .14567 L
s
.51478 .1459 m
.51478 .1459 L
s
.51485 .14614 m
.51485 .14614 L
s
.51493 .14519 m
.51493 .14519 L
s
.515 .14661 m
.515 .14661 L
s
.51508 .14801 m
.51508 .14801 L
s
.51515 .14754 m
.51515 .14754 L
s
.51523 .14848 m
.51523 .14848 L
s
.5153 .14895 m
.5153 .14895 L
s
.51538 .14567 m
.51538 .14567 L
s
.51545 .14519 m
.51545 .14519 L
s
.51552 .14543 m
.51552 .14543 L
s
.51559 .14567 m
.51559 .14567 L
s
.51567 .14661 m
.51567 .14661 L
s
.51574 .14637 m
.51574 .14637 L
s
.51582 .14778 m
.51582 .14778 L
s
.51589 .14707 m
.51589 .14707 L
s
.51597 .14543 m
.51597 .14543 L
s
.51604 .14449 m
.51604 .14449 L
s
.51612 .14567 m
.51612 .14567 L
s
.5162 .14496 m
.5162 .14496 L
s
.51626 .14496 m
.51626 .14496 L
s
.51634 .14519 m
.51634 .14519 L
s
.51641 .14661 m
.51641 .14661 L
s
.51649 .14707 m
.51649 .14707 L
s
.51656 .14661 m
.51656 .14661 L
s
.51664 .14707 m
.51664 .14707 L
s
.51671 .14684 m
.51671 .14684 L
s
.51679 .14707 m
.51679 .14707 L
s
.51686 .14825 m
.51686 .14825 L
s
.51694 .14989 m
.51694 .14989 L
s
.51701 .14872 m
.51701 .14872 L
s
.51708 .14943 m
.51708 .14943 L
s
.51715 .14825 m
.51715 .14825 L
s
.51723 .14989 m
.51723 .14989 L
s
.5173 .14895 m
.5173 .14895 L
s
.51738 .14943 m
.51738 .14943 L
s
.51745 .14895 m
.51745 .14895 L
s
.51753 .14848 m
.51753 .14848 L
s
.5176 .15083 m
.5176 .15083 L
s
.51767 .15013 m
.51767 .15013 L
s
.51775 .15224 m
.51775 .15224 L
s
.51783 .14989 m
.51783 .14989 L
s
.5179 .1513 m
.5179 .1513 L
s
.51797 .15036 m
.51797 .15036 L
s
.51805 .14966 m
.51805 .14966 L
s
.51812 .15083 m
.51812 .15083 L
s
.5182 .14895 m
.5182 .14895 L
s
.51827 .15013 m
.51827 .15013 L
s
.51835 .15036 m
.51835 .15036 L
s
.51842 .15224 m
.51842 .15224 L
s
.51849 .15013 m
.51849 .15013 L
s
.51857 .15013 m
.51857 .15013 L
s
.51865 .14989 m
.51865 .14989 L
s
.51871 .15083 m
.51871 .15083 L
s
.51879 .15154 m
.51879 .15154 L
s
.51886 .14895 m
.51886 .14895 L
s
.51894 .14895 m
.51894 .14895 L
s
.51901 .14801 m
.51901 .14801 L
s
.51909 .14989 m
.51909 .14989 L
s
.51917 .14801 m
.51917 .14801 L
s
.51923 .14872 m
.51923 .14872 L
s
.51931 .14731 m
.51931 .14731 L
s
.51939 .14919 m
.51939 .14919 L
s
.51946 .14731 m
.51946 .14731 L
s
.51953 .14661 m
.51953 .14661 L
s
.51961 .14496 m
.51961 .14496 L
s
.51968 .14355 m
.51968 .14355 L
s
.51976 .14425 m
.51976 .14425 L
s
.51983 .14519 m
.51983 .14519 L
s
.51991 .14519 m
.51991 .14519 L
s
.51998 .14472 m
.51998 .14472 L
s
.52005 .14754 m
.52005 .14754 L
s
.52012 .14567 m
.52012 .14567 L
s
.5202 .14754 m
.5202 .14754 L
s
.52028 .14614 m
.52028 .14614 L
s
.52035 .14825 m
.52035 .14825 L
s
.52042 .14848 m
.52042 .14848 L
s
.5205 .14825 m
.5205 .14825 L
s
.52057 .14966 m
.52057 .14966 L
s
.52065 .14966 m
.52065 .14966 L
s
.52073 .14943 m
.52073 .14943 L
s
.5208 .14778 m
.5208 .14778 L
s
.52087 .14848 m
.52087 .14848 L
s
.52094 .14778 m
.52094 .14778 L
s
.52102 .14943 m
.52102 .14943 L
s
.52109 .14754 m
.52109 .14754 L
s
.52117 .14801 m
.52117 .14801 L
s
.52124 .14614 m
.52124 .14614 L
s
.52132 .14637 m
.52132 .14637 L
s
.52139 .14661 m
.52139 .14661 L
s
.52147 .1459 m
.52147 .1459 L
s
.52154 .14731 m
.52154 .14731 L
s
.52162 .14684 m
.52162 .14684 L
s
.52168 .14825 m
.52168 .14825 L
s
.52176 .14848 m
.52176 .14848 L
s
.52183 .14943 m
.52183 .14943 L
s
.52191 .14895 m
.52191 .14895 L
s
.52198 .15036 m
.52198 .15036 L
s
.52206 .14989 m
.52206 .14989 L
s
.52213 .1506 m
.52213 .1506 L
s
.52221 .15224 m
.52221 .15224 L
s
.52229 .15154 m
.52229 .15154 L
s
.52236 .15435 m
.52236 .15435 L
s
.52243 .15365 m
.52243 .15365 L
s
.5225 .15435 m
.5225 .15435 L
s
.52258 .15482 m
.52258 .15482 L
s
.52265 .15506 m
.52265 .15506 L
s
.52273 .15318 m
.52273 .15318 L
s
.5228 .15271 m
.5228 .15271 L
s
.52288 .15365 m
.52288 .15365 L
s
.52295 .15295 m
.52295 .15295 L
s
.52303 .15342 m
.52303 .15342 L
s
.5231 .152 m
.5231 .152 L
s
.52318 .15459 m
.52318 .15459 L
s
.52325 .15459 m
.52325 .15459 L
s
.52332 .156 m
.52332 .156 L
s
.52339 .15576 m
.52339 .15576 L
s
.52347 .15671 m
.52347 .15671 L
s
.52354 .15858 m
.52354 .15858 L
s
.52362 .15717 m
.52362 .15717 L
s
.52369 .15811 m
.52369 .15811 L
s
.52377 .15647 m
.52377 .15647 L
s
.52385 .15694 m
.52385 .15694 L
s
.52392 .15576 m
.52392 .15576 L
s
.524 .15624 m
.524 .15624 L
s
.52406 .15576 m
.52406 .15576 L
s
.52414 .15647 m
.52414 .15647 L
s
.52421 .15553 m
.52421 .15553 L
s
.52429 .15435 m
.52429 .15435 L
s
.52436 .15412 m
.52436 .15412 L
s
.52444 .15506 m
.52444 .15506 L
s
.52451 .15553 m
.52451 .15553 L
s
.52459 .15529 m
.52459 .15529 L
s
.52466 .15764 m
.52466 .15764 L
s
.52474 .15576 m
.52474 .15576 L
s
.52481 .15741 m
.52481 .15741 L
s
.52488 .15647 m
.52488 .15647 L
s
.52495 .15671 m
.52495 .15671 L
s
.52503 .15694 m
.52503 .15694 L
s
.5251 .15764 m
.5251 .15764 L
s
.52518 .15647 m
.52518 .15647 L
s
.52525 .15671 m
.52525 .15671 L
s
.52533 .15671 m
.52533 .15671 L
s
.5254 .15835 m
.5254 .15835 L
s
.52548 .15905 m
.52548 .15905 L
s
.52556 .15764 m
.52556 .15764 L
s
.52563 .15858 m
.52563 .15858 L
s
.5257 .15764 m
.5257 .15764 L
s
.52577 .15647 m
.52577 .15647 L
s
.52585 .15788 m
.52585 .15788 L
s
.52592 .15764 m
.52592 .15764 L
s
.526 .15835 m
.526 .15835 L
s
.52607 .15835 m
.52607 .15835 L
s
.52615 .15788 m
.52615 .15788 L
s
.52622 .15741 m
.52622 .15741 L
s
.52629 .15717 m
.52629 .15717 L
s
.52637 .15576 m
.52637 .15576 L
s
.52645 .15624 m
.52645 .15624 L
s
.52651 .15482 m
.52651 .15482 L
s
.52659 .15576 m
.52659 .15576 L
s
.52666 .15671 m
.52666 .15671 L
s
.52674 .15624 m
.52674 .15624 L
s
.52681 .15553 m
.52681 .15553 L
s
.52689 .15435 m
.52689 .15435 L
s
.52697 .15506 m
.52697 .15506 L
s
.52703 .15435 m
.52703 .15435 L
s
.52711 .15553 m
.52711 .15553 L
s
.52719 .15506 m
.52719 .15506 L
s
.52726 .15624 m
.52726 .15624 L
s
.52733 .15717 m
.52733 .15717 L
s
.52741 .15835 m
.52741 .15835 L
s
.52748 .15717 m
.52748 .15717 L
s
.52756 .15788 m
.52756 .15788 L
s
.52763 .15811 m
.52763 .15811 L
s
.52771 .15835 m
.52771 .15835 L
s
.52778 .15788 m
.52778 .15788 L
s
.52785 .15671 m
.52785 .15671 L
s
.52792 .15694 m
.52792 .15694 L
s
.528 .15741 m
.528 .15741 L
s
.52808 .15717 m
.52808 .15717 L
s
.52815 .15553 m
.52815 .15553 L
s
.52822 .15835 m
.52822 .15835 L
s
.5283 .15882 m
.5283 .15882 L
s
.52837 .16117 m
.52837 .16117 L
s
.52845 .16023 m
.52845 .16023 L
s
.52853 .16023 m
.52853 .16023 L
s
.5286 .16046 m
.5286 .16046 L
s
.52867 .16023 m
.52867 .16023 L
s
.52874 .1607 m
.52874 .1607 L
s
.52882 .15929 m
.52882 .15929 L
s
.52889 .1607 m
.52889 .1607 L
s
.52897 .16046 m
.52897 .16046 L
s
.52904 .16164 m
.52904 .16164 L
s
.52912 .16258 m
.52912 .16258 L
s
.52919 .1621 m
.52919 .1621 L
s
.52927 .16164 m
.52927 .16164 L
s
.52934 .16093 m
.52934 .16093 L
s
.52942 .16234 m
.52942 .16234 L
s
.52948 .1614 m
.52948 .1614 L
s
.52956 .16093 m
.52956 .16093 L
s
.52963 .1607 m
.52963 .1607 L
s
.52971 .16258 m
.52971 .16258 L
s
.52978 .15882 m
.52978 .15882 L
s
.52986 .16023 m
.52986 .16023 L
s
.52993 .15976 m
.52993 .15976 L
s
.53001 .15976 m
.53001 .15976 L
s
.53009 .15976 m
.53009 .15976 L
s
.53016 .16023 m
.53016 .16023 L
s
.53023 .1621 m
.53023 .1621 L
s
.5303 .16234 m
.5303 .16234 L
s
.53038 .16305 m
.53038 .16305 L
s
.53045 .16093 m
.53045 .16093 L
s
.53053 .1614 m
.53053 .1614 L
s
.5306 .15976 m
.5306 .15976 L
s
.53068 .15953 m
.53068 .15953 L
s
.53075 .15929 m
.53075 .15929 L
s
.53083 .15882 m
.53083 .15882 L
s
.5309 .15811 m
.5309 .15811 L
s
.53098 .15741 m
.53098 .15741 L
s
.53105 .15694 m
.53105 .15694 L
s
.53112 .15694 m
.53112 .15694 L
s
.53119 .15811 m
.53119 .15811 L
s
.53127 .156 m
.53127 .156 L
s
.53134 .15624 m
.53134 .15624 L
s
.53142 .15671 m
.53142 .15671 L
s
.53149 .15835 m
.53149 .15835 L
s
.53157 .15858 m
.53157 .15858 L
s
.53165 .15882 m
.53165 .15882 L
s
.53172 .15835 m
.53172 .15835 L
s
.5318 .15788 m
.5318 .15788 L
s
.53186 .15788 m
.53186 .15788 L
s
.53194 .15694 m
.53194 .15694 L
s
.53201 .15788 m
.53201 .15788 L
s
.53209 .15717 m
.53209 .15717 L
s
.53216 .15788 m
.53216 .15788 L
s
.53224 .15553 m
.53224 .15553 L
s
.53231 .15576 m
.53231 .15576 L
s
.53239 .15647 m
.53239 .15647 L
s
.53246 .15624 m
.53246 .15624 L
s
.53254 .15647 m
.53254 .15647 L
s
.53261 .15694 m
.53261 .15694 L
s
.53268 .15624 m
.53268 .15624 L
s
.53275 .15506 m
.53275 .15506 L
s
.53283 .15576 m
.53283 .15576 L
s
.5329 .15435 m
.5329 .15435 L
s
.53298 .15576 m
.53298 .15576 L
s
.53305 .15435 m
.53305 .15435 L
s
.53313 .15224 m
.53313 .15224 L
s
.5332 .15365 m
.5332 .15365 L
s
.53328 .15412 m
.53328 .15412 L
s
.53336 .15412 m
.53336 .15412 L
s
.53343 .15271 m
.53343 .15271 L
s
.5335 .15271 m
.5335 .15271 L
s
.53357 .152 m
.53357 .152 L
s
.53365 .152 m
.53365 .152 L
s
.53372 .1513 m
.53372 .1513 L
s
.5338 .15248 m
.5338 .15248 L
s
.53387 .15248 m
.53387 .15248 L
s
.53395 .15318 m
.53395 .15318 L
s
.53402 .15318 m
.53402 .15318 L
s
.5341 .15177 m
.5341 .15177 L
s
.53417 .15083 m
.53417 .15083 L
s
.53425 .14966 m
.53425 .14966 L
s
.53431 .15107 m
.53431 .15107 L
s
.53439 .15036 m
.53439 .15036 L
s
.53446 .15013 m
.53446 .15013 L
s
.53454 .14919 m
.53454 .14919 L
s
.53461 .1513 m
.53461 .1513 L
s
.53469 .15224 m
.53469 .15224 L
s
.53477 .152 m
.53477 .152 L
s
.53483 .15224 m
.53483 .15224 L
s
.53491 .15365 m
.53491 .15365 L
s
.53499 .15365 m
.53499 .15365 L
s
.53506 .15459 m
.53506 .15459 L
s
.53513 .15647 m
.53513 .15647 L
s
.53521 .15435 m
.53521 .15435 L
s
.53528 .15624 m
.53528 .15624 L
s
.53536 .15529 m
.53536 .15529 L
s
.53543 .15624 m
.53543 .15624 L
s
.53551 .15459 m
.53551 .15459 L
s
.53558 .15553 m
.53558 .15553 L
s
.53565 .15647 m
.53565 .15647 L
s
.53573 .15694 m
.53573 .15694 L
s
.53581 .15858 m
.53581 .15858 L
s
.53588 .15647 m
.53588 .15647 L
s
.53595 .15717 m
.53595 .15717 L
s
.53602 .15647 m
.53602 .15647 L
s
.5361 .15717 m
.5361 .15717 L
s
.53617 .15671 m
.53617 .15671 L
s
.53625 .15764 m
.53625 .15764 L
s
.53633 .15741 m
.53633 .15741 L
s
.5364 .15811 m
.5364 .15811 L
s
.53647 .15788 m
.53647 .15788 L
s
.53654 .15671 m
.53654 .15671 L
s
.53662 .15671 m
.53662 .15671 L
s
.53669 .15671 m
.53669 .15671 L
s
.53677 .15741 m
.53677 .15741 L
s
.53684 .15624 m
.53684 .15624 L
s
.53692 .15694 m
.53692 .15694 L
s
.53699 .15624 m
.53699 .15624 L
s
.53707 .15482 m
.53707 .15482 L
s
.53714 .152 m
.53714 .152 L
s
.53722 .152 m
.53722 .152 L
s
.53728 .15248 m
.53728 .15248 L
s
.53736 .15248 m
.53736 .15248 L
s
.53744 .15506 m
.53744 .15506 L
s
.53751 .15459 m
.53751 .15459 L
s
.53758 .15482 m
.53758 .15482 L
s
.53766 .15553 m
.53766 .15553 L
s
.53773 .15694 m
.53773 .15694 L
s
.53781 .15717 m
.53781 .15717 L
s
.53789 .15788 m
.53789 .15788 L
s
.53796 .15553 m
.53796 .15553 L
s
.53803 .156 m
.53803 .156 L
s
.5381 .15576 m
.5381 .15576 L
s
.53818 .15553 m
.53818 .15553 L
s
.53825 .15553 m
.53825 .15553 L
s
.53833 .15412 m
.53833 .15412 L
s
.5384 .15506 m
.5384 .15506 L
s
.53848 .15318 m
.53848 .15318 L
s
.53855 .15459 m
.53855 .15459 L
s
.53863 .15459 m
.53863 .15459 L
s
.5387 .15412 m
.5387 .15412 L
s
.53878 .15248 m
.53878 .15248 L
s
.53885 .15318 m
.53885 .15318 L
s
.53892 .15295 m
.53892 .15295 L
s
.53899 .15177 m
.53899 .15177 L
s
.53907 .15271 m
.53907 .15271 L
s
.53914 .15224 m
.53914 .15224 L
s
.53922 .15295 m
.53922 .15295 L
s
.53929 .152 m
.53929 .152 L
s
.53937 .15177 m
.53937 .15177 L
s
.53945 .15154 m
.53945 .15154 L
s
.53952 .1513 m
.53952 .1513 L
s
.5396 .15154 m
.5396 .15154 L
s
.53966 .152 m
.53966 .152 L
s
.53974 .15154 m
.53974 .15154 L
s
.53981 .15083 m
.53981 .15083 L
s
.53989 .1506 m
.53989 .1506 L
s
.53996 .14825 m
.53996 .14825 L
s
.54004 .14943 m
.54004 .14943 L
s
.54011 .14848 m
.54011 .14848 L
s
.54019 .14943 m
.54019 .14943 L
s
.54026 .14989 m
.54026 .14989 L
s
.54034 .15036 m
.54034 .15036 L
s
.54041 .14943 m
.54041 .14943 L
s
.54048 .14943 m
.54048 .14943 L
s
.54055 .14872 m
.54055 .14872 L
s
.54063 .14848 m
.54063 .14848 L
s
.5407 .14943 m
.5407 .14943 L
s
.54078 .14614 m
.54078 .14614 L
s
.54085 .14567 m
.54085 .14567 L
s
.54093 .1459 m
.54093 .1459 L
s
.54101 .14825 m
.54101 .14825 L
s
.54108 .14801 m
.54108 .14801 L
s
.54116 .14754 m
.54116 .14754 L
s
.54123 .1459 m
.54123 .1459 L
s
.5413 .14614 m
.5413 .14614 L
s
.54137 .14637 m
.54137 .14637 L
s
.54145 .14543 m
.54145 .14543 L
s
.54152 .14543 m
.54152 .14543 L
s
.5416 .14519 m
.5416 .14519 L
s
.54167 .1459 m
.54167 .1459 L
s
.54175 .14567 m
.54175 .14567 L
s
.54182 .14614 m
.54182 .14614 L
s
.5419 .14496 m
.5419 .14496 L
s
.54197 .14379 m
.54197 .14379 L
s
.54205 .14285 m
.54205 .14285 L
s
.54211 .14261 m
.54211 .14261 L
s
.54219 .14238 m
.54219 .14238 L
s
.54226 .14238 m
.54226 .14238 L
s
.54234 .14402 m
.54234 .14402 L
s
.54241 .14238 m
.54241 .14238 L
s
.54249 .14425 m
.54249 .14425 L
s
.54257 .14332 m
.54257 .14332 L
s
.54264 .14449 m
.54264 .14449 L
s
.54272 .14472 m
.54272 .14472 L
s
.54279 .14519 m
.54279 .14519 L
s
.54286 .14614 m
.54286 .14614 L
s
.54293 .14519 m
.54293 .14519 L
s
.54301 .14519 m
.54301 .14519 L
s
.54308 .14496 m
.54308 .14496 L
s
.54316 .14519 m
.54316 .14519 L
s
.54323 .14614 m
.54323 .14614 L
s
.54331 .14543 m
.54331 .14543 L
s
.54338 .14402 m
.54338 .14402 L
s
.54345 .14567 m
.54345 .14567 L
s
.54353 .14707 m
.54353 .14707 L
s
.54361 .14754 m
.54361 .14754 L
s
.54368 .14661 m
.54368 .14661 L
s
.54375 .14614 m
.54375 .14614 L
s
.54382 .14567 m
.54382 .14567 L
s
.5439 .14496 m
.5439 .14496 L
s
.54397 .14543 m
.54397 .14543 L
s
.54405 .14543 m
.54405 .14543 L
s
.54413 .14543 m
.54413 .14543 L
s
.5442 .14472 m
.5442 .14472 L
s
.54427 .14637 m
.54427 .14637 L
s
.54435 .14567 m
.54435 .14567 L
s
.54443 .14449 m
.54443 .14449 L
s
.54449 .1459 m
.54449 .1459 L
s
.54457 .14661 m
.54457 .14661 L
s
.54464 .14684 m
.54464 .14684 L
s
.54472 .14496 m
.54472 .14496 L
s
.54479 .14661 m
.54479 .14661 L
s
.54487 .14567 m
.54487 .14567 L
s
.54494 .14754 m
.54494 .14754 L
s
.54502 .14895 m
.54502 .14895 L
s
.54508 .15036 m
.54508 .15036 L
s
.54516 .15036 m
.54516 .15036 L
s
.54524 .15083 m
.54524 .15083 L
s
.54531 .15271 m
.54531 .15271 L
s
.54538 .15083 m
.54538 .15083 L
s
.54546 .15154 m
.54546 .15154 L
s
.54553 .15107 m
.54553 .15107 L
s
.54561 .1513 m
.54561 .1513 L
s
.54569 .15083 m
.54569 .15083 L
s
.54576 .14989 m
.54576 .14989 L
s
.54583 .14966 m
.54583 .14966 L
s
.5459 .15083 m
.5459 .15083 L
s
.54598 .15036 m
.54598 .15036 L
s
.54606 .15013 m
.54606 .15013 L
s
.54613 .14943 m
.54613 .14943 L
s
.5462 .14919 m
.5462 .14919 L
s
.54628 .15036 m
.54628 .15036 L
s
.54635 .15083 m
.54635 .15083 L
s
.54643 .15248 m
.54643 .15248 L
s
.5465 .15224 m
.5465 .15224 L
s
.54658 .15248 m
.54658 .15248 L
s
.54665 .14872 m
.54665 .14872 L
s
.54672 .1506 m
.54672 .1506 L
s
.54679 .14895 m
.54679 .14895 L
s
.54687 .14731 m
.54687 .14731 L
s
.54694 .14801 m
.54694 .14801 L
s
.54702 .14707 m
.54702 .14707 L
s
.54709 .14848 m
.54709 .14848 L
s
.54717 .14801 m
.54717 .14801 L
s
.54725 .1506 m
.54725 .1506 L
s
.54732 .14825 m
.54732 .14825 L
s
.5474 .14989 m
.5474 .14989 L
s
.54746 .14989 m
.54746 .14989 L
s
.54754 .15107 m
.54754 .15107 L
s
.54761 .15013 m
.54761 .15013 L
s
.54769 .15036 m
.54769 .15036 L
s
.54776 .15224 m
.54776 .15224 L
s
.54784 .15154 m
.54784 .15154 L
s
.54791 .1513 m
.54791 .1513 L
s
.54799 .15083 m
.54799 .15083 L
s
.54806 .1506 m
.54806 .1506 L
s
.54814 .1506 m
.54814 .1506 L
s
.54821 .152 m
.54821 .152 L
s
.54828 .1506 m
.54828 .1506 L
s
.54835 .1513 m
.54835 .1513 L
s
.54843 .15083 m
.54843 .15083 L
s
.5485 .15036 m
.5485 .15036 L
s
.54858 .15107 m
.54858 .15107 L
s
.54865 .14943 m
.54865 .14943 L
s
.54873 .14989 m
.54873 .14989 L
s
.54881 .14872 m
.54881 .14872 L
s
.54888 .15013 m
.54888 .15013 L
s
.54896 .15177 m
.54896 .15177 L
s
.54903 .15013 m
.54903 .15013 L
s
.5491 .14989 m
.5491 .14989 L
s
.54917 .14895 m
.54917 .14895 L
s
.54925 .14966 m
.54925 .14966 L
s
.54932 .14895 m
.54932 .14895 L
s
.5494 .14943 m
.5494 .14943 L
s
.54947 .14825 m
.54947 .14825 L
s
.54955 .1506 m
.54955 .1506 L
s
.54962 .1506 m
.54962 .1506 L
s
.5497 .15154 m
.5497 .15154 L
s
.54977 .15318 m
.54977 .15318 L
s
.54985 .15224 m
.54985 .15224 L
s
.54991 .15083 m
.54991 .15083 L
s
.54999 .15177 m
.54999 .15177 L
s
.55006 .15412 m
.55006 .15412 L
s
.55014 .15365 m
.55014 .15365 L
s
.55021 .15482 m
.55021 .15482 L
s
.55029 .15342 m
.55029 .15342 L
s
.55037 .15459 m
.55037 .15459 L
s
.55044 .15365 m
.55044 .15365 L
s
.55052 .15576 m
.55052 .15576 L
s
.55059 .15412 m
.55059 .15412 L
s
.55066 .15553 m
.55066 .15553 L
s
.55073 .156 m
.55073 .156 L
s
.55081 .15506 m
.55081 .15506 L
s
.55088 .15647 m
.55088 .15647 L
s
.55096 .15553 m
.55096 .15553 L
s
.55103 .15553 m
.55103 .15553 L
s
.55111 .15365 m
.55111 .15365 L
s
.55118 .15435 m
.55118 .15435 L
s
.55126 .15389 m
.55126 .15389 L
s
.55133 .15482 m
.55133 .15482 L
s
.55141 .15389 m
.55141 .15389 L
s
.55148 .15224 m
.55148 .15224 L
s
.55155 .152 m
.55155 .152 L
s
.55162 .1506 m
.55162 .1506 L
s
.5517 .152 m
.5517 .152 L
s
.55177 .15365 m
.55177 .15365 L
s
.55185 .15248 m
.55185 .15248 L
s
.55193 .14966 m
.55193 .14966 L
s
.552 .15013 m
.552 .15013 L
s
.55207 .15013 m
.55207 .15013 L
s
.55215 .1506 m
.55215 .1506 L
s
.55223 .15013 m
.55223 .15013 L
s
.5523 .14943 m
.5523 .14943 L
s
.55237 .14895 m
.55237 .14895 L
s
.55244 .14661 m
.55244 .14661 L
s
.55252 .14825 m
.55252 .14825 L
s
.55259 .14731 m
.55259 .14731 L
s
.55267 .14989 m
.55267 .14989 L
s
.55274 .14943 m
.55274 .14943 L
s
.55282 .14895 m
.55282 .14895 L
s
.55289 .14895 m
.55289 .14895 L
s
.55297 .14989 m
.55297 .14989 L
s
.55304 .15154 m
.55304 .15154 L
s
.55311 .15083 m
.55311 .15083 L
s
.55318 .15036 m
.55318 .15036 L
s
.55326 .1506 m
.55326 .1506 L
s
.55333 .15107 m
.55333 .15107 L
s
.55341 .15107 m
.55341 .15107 L
s
.55349 .152 m
.55349 .152 L
s
.55356 .15271 m
.55356 .15271 L
s
.55363 .15248 m
.55363 .15248 L
s
.5537 .1506 m
.5537 .1506 L
s
.55378 .15107 m
.55378 .15107 L
s
.55386 .15013 m
.55386 .15013 L
s
.55393 .15013 m
.55393 .15013 L
s
.554 .14943 m
.554 .14943 L
s
.55408 .14895 m
.55408 .14895 L
s
.55415 .14895 m
.55415 .14895 L
s
.55423 .14966 m
.55423 .14966 L
s
.5543 .14989 m
.5543 .14989 L
s
.55438 .15083 m
.55438 .15083 L
s
.55445 .15177 m
.55445 .15177 L
s
.55452 .14966 m
.55452 .14966 L
s
.5546 .15013 m
.5546 .15013 L
s
.55468 .14848 m
.55468 .14848 L
s
.55474 .14919 m
.55474 .14919 L
s
.55482 .14919 m
.55482 .14919 L
s
.55489 .14848 m
.55489 .14848 L
s
.55497 .14919 m
.55497 .14919 L
s
.55505 .14966 m
.55505 .14966 L
s
.55512 .15036 m
.55512 .15036 L
s
.5552 .14801 m
.5552 .14801 L
s
.55527 .14966 m
.55527 .14966 L
s
.55534 .14943 m
.55534 .14943 L
s
.55541 .14919 m
.55541 .14919 L
s
.55549 .14943 m
.55549 .14943 L
s
.55556 .14989 m
.55556 .14989 L
s
.55564 .15013 m
.55564 .15013 L
s
.55571 .14895 m
.55571 .14895 L
s
.55579 .14966 m
.55579 .14966 L
s
.55586 .14801 m
.55586 .14801 L
s
.55594 .14848 m
.55594 .14848 L
s
.55601 .14801 m
.55601 .14801 L
s
.55608 .14872 m
.55608 .14872 L
s
.55615 .14754 m
.55615 .14754 L
s
.55623 .14754 m
.55623 .14754 L
s
.55631 .14661 m
.55631 .14661 L
s
.55638 .14661 m
.55638 .14661 L
s
.55645 .14661 m
.55645 .14661 L
s
.55653 .1459 m
.55653 .1459 L
s
.55661 .14567 m
.55661 .14567 L
s
.55668 .14519 m
.55668 .14519 L
s
.55676 .14637 m
.55676 .14637 L
s
.55683 .14543 m
.55683 .14543 L
s
.5569 .14754 m
.5569 .14754 L
s
.55697 .14707 m
.55697 .14707 L
s
.55705 .14731 m
.55705 .14731 L
s
.55712 .14637 m
.55712 .14637 L
s
.5572 .14496 m
.5572 .14496 L
s
.55727 .14472 m
.55727 .14472 L
s
.55735 .14355 m
.55735 .14355 L
s
.55742 .14308 m
.55742 .14308 L
s
.5575 .14261 m
.5575 .14261 L
s
.55757 .14543 m
.55757 .14543 L
s
.55765 .14496 m
.55765 .14496 L
s
.55771 .1459 m
.55771 .1459 L
s
.55779 .14614 m
.55779 .14614 L
s
.55786 .14614 m
.55786 .14614 L
s
.55794 .14543 m
.55794 .14543 L
s
.55801 .14496 m
.55801 .14496 L
s
.55809 .14472 m
.55809 .14472 L
s
.55817 .14614 m
.55817 .14614 L
s
.55824 .14707 m
.55824 .14707 L
s
.55832 .14825 m
.55832 .14825 L
s
.55839 .14919 m
.55839 .14919 L
s
.55846 .14943 m
.55846 .14943 L
s
.55853 .1506 m
.55853 .1506 L
s
.55861 .15083 m
.55861 .15083 L
s
.55868 .15224 m
.55868 .15224 L
s
.55876 .1513 m
.55876 .1513 L
s
.55883 .14989 m
.55883 .14989 L
s
.55891 .15083 m
.55891 .15083 L
s
.55898 .14989 m
.55898 .14989 L
s
.55906 .15036 m
.55906 .15036 L
s
.55913 .15013 m
.55913 .15013 L
s
.55921 .14966 m
.55921 .14966 L
s
.55928 .14895 m
.55928 .14895 L
s
.55935 .15013 m
.55935 .15013 L
s
.55942 .14872 m
.55942 .14872 L
s
.5595 .14989 m
.5595 .14989 L
s
.55957 .15036 m
.55957 .15036 L
s
.55965 .15036 m
.55965 .15036 L
s
.55973 .15083 m
.55973 .15083 L
s
.5598 .14895 m
.5598 .14895 L
s
.55988 .14943 m
.55988 .14943 L
s
.55995 .14707 m
.55995 .14707 L
s
.56003 .14754 m
.56003 .14754 L
s
.5601 .1459 m
.5601 .1459 L
s
.56017 .14731 m
.56017 .14731 L
s
.56024 .14754 m
.56024 .14754 L
s
.56032 .14801 m
.56032 .14801 L
s
.56039 .14707 m
.56039 .14707 L
s
.56047 .14684 m
.56047 .14684 L
s
.56054 .14801 m
.56054 .14801 L
s
.56062 .14872 m
.56062 .14872 L
s
.56069 .14989 m
.56069 .14989 L
s
.56077 .14872 m
.56077 .14872 L
s
.56084 .14989 m
.56084 .14989 L
s
.56091 .14872 m
.56091 .14872 L
s
.56098 .14848 m
.56098 .14848 L
s
.56106 .14707 m
.56106 .14707 L
s
.56113 .14661 m
.56113 .14661 L
s
.56121 .14519 m
.56121 .14519 L
s
.56129 .14519 m
.56129 .14519 L
s
.56136 .14519 m
.56136 .14519 L
s
.56143 .14285 m
.56143 .14285 L
s
.56151 .14285 m
.56151 .14285 L
s
.56159 .14143 m
.56159 .14143 L
s
.56166 .14238 m
.56166 .14238 L
s
.56173 .14097 m
.56173 .14097 L
s
.5618 .14214 m
.5618 .14214 L
s
.56188 .14003 m
.56188 .14003 L
s
.56195 .14026 m
.56195 .14026 L
s
.56203 .13956 m
.56203 .13956 L
s
.5621 .1412 m
.5621 .1412 L
s
.56218 .14238 m
.56218 .14238 L
s
.56225 .1419 m
.56225 .1419 L
s
.56232 .14355 m
.56232 .14355 L
s
.5624 .1419 m
.5624 .1419 L
s
.56248 .14238 m
.56248 .14238 L
s
.56254 .1419 m
.56254 .1419 L
s
.56262 .14214 m
.56262 .14214 L
s
.56269 .14214 m
.56269 .14214 L
s
.56277 .14261 m
.56277 .14261 L
s
.56285 .14285 m
.56285 .14285 L
s
.56292 .14355 m
.56292 .14355 L
s
.563 .14379 m
.563 .14379 L
s
.56307 .14355 m
.56307 .14355 L
s
.56314 .14449 m
.56314 .14449 L
s
.56322 .14402 m
.56322 .14402 L
s
.56329 .14472 m
.56329 .14472 L
s
.56336 .14402 m
.56336 .14402 L
s
.56344 .14355 m
.56344 .14355 L
s
.56351 .14261 m
.56351 .14261 L
s
.56359 .14332 m
.56359 .14332 L
s
.56366 .14379 m
.56366 .14379 L
s
.56374 .14238 m
.56374 .14238 L
s
.56381 .14332 m
.56381 .14332 L
s
.56388 .14285 m
.56388 .14285 L
s
.56395 .14425 m
.56395 .14425 L
s
.56403 .14567 m
.56403 .14567 L
s
.56411 .14567 m
.56411 .14567 L
s
.56418 .14402 m
.56418 .14402 L
s
.56425 .14402 m
.56425 .14402 L
s
.56433 .14308 m
.56433 .14308 L
s
.56441 .14238 m
.56441 .14238 L
s
.56448 .14425 m
.56448 .14425 L
s
.56456 .14379 m
.56456 .14379 L
s
.56463 .14379 m
.56463 .14379 L
s
.5647 .14308 m
.5647 .14308 L
s
.56477 .14355 m
.56477 .14355 L
s
.56485 .14097 m
.56485 .14097 L
s
.56493 .14143 m
.56493 .14143 L
s
.565 .1412 m
.565 .1412 L
s
.56507 .14285 m
.56507 .14285 L
s
.56515 .14379 m
.56515 .14379 L
s
.56522 .14214 m
.56522 .14214 L
s
.5653 .14097 m
.5653 .14097 L
s
.56537 .14214 m
.56537 .14214 L
s
.56545 .14355 m
.56545 .14355 L
s
.56551 .14238 m
.56551 .14238 L
s
.56559 .14449 m
.56559 .14449 L
s
.56566 .14355 m
.56566 .14355 L
s
.56574 .14355 m
.56574 .14355 L
s
.56581 .14285 m
.56581 .14285 L
s
.56589 .14214 m
.56589 .14214 L
s
.56597 .1419 m
.56597 .1419 L
s
.56604 .14003 m
.56604 .14003 L
s
.56612 .14097 m
.56612 .14097 L
s
.56619 .14026 m
.56619 .14026 L
s
.56626 .1405 m
.56626 .1405 L
s
.56633 .1412 m
.56633 .1412 L
s
.56641 .1412 m
.56641 .1412 L
s
.56648 .1405 m
.56648 .1405 L
s
.56656 .14167 m
.56656 .14167 L
s
.56663 .14308 m
.56663 .14308 L
s
.56671 .14379 m
.56671 .14379 L
s
.56678 .14472 m
.56678 .14472 L
s
.56686 .14543 m
.56686 .14543 L
s
.56693 .14519 m
.56693 .14519 L
s
.56701 .14308 m
.56701 .14308 L
s
.56708 .14238 m
.56708 .14238 L
s
.56715 .14167 m
.56715 .14167 L
s
.56722 .14143 m
.56722 .14143 L
s
.5673 .13933 m
.5673 .13933 L
s
.56737 .13933 m
.56737 .13933 L
s
.56745 .13815 m
.56745 .13815 L
s
.56753 .13815 m
.56753 .13815 L
s
.5676 .13791 m
.5676 .13791 L
s
.56768 .13861 m
.56768 .13861 L
s
.56775 .13861 m
.56775 .13861 L
s
.56783 .13768 m
.56783 .13768 L
s
.5679 .13933 m
.5679 .13933 L
s
.56797 .13861 m
.56797 .13861 L
s
.56804 .13815 m
.56804 .13815 L
s
.56812 .13768 m
.56812 .13768 L
s
.56819 .13861 m
.56819 .13861 L
s
.56827 .13791 m
.56827 .13791 L
s
.56834 .13956 m
.56834 .13956 L
s
.56842 .14097 m
.56842 .14097 L
s
.56849 .14026 m
.56849 .14026 L
s
.56857 .14143 m
.56857 .14143 L
s
.56864 .14003 m
.56864 .14003 L
s
.56871 .1405 m
.56871 .1405 L
s
.56878 .14003 m
.56878 .14003 L
s
.56886 .14332 m
.56886 .14332 L
s
.56893 .14238 m
.56893 .14238 L
s
.56901 .14261 m
.56901 .14261 L
s
.56909 .14167 m
.56909 .14167 L
s
.56916 .1419 m
.56916 .1419 L
s
.56923 .14167 m
.56923 .14167 L
s
.56931 .1412 m
.56931 .1412 L
s
.56939 .14097 m
.56939 .14097 L
s
.56946 .14026 m
.56946 .14026 L
s
.56953 .14097 m
.56953 .14097 L
s
.5696 .14167 m
.5696 .14167 L
s
.56968 .14214 m
.56968 .14214 L
s
.56975 .1419 m
.56975 .1419 L
s
.56983 .14285 m
.56983 .14285 L
s
.5699 .14261 m
.5699 .14261 L
s
.56998 .14238 m
.56998 .14238 L
s
.57005 .14143 m
.57005 .14143 L
s
.57013 .14214 m
.57013 .14214 L
s
.5702 .14238 m
.5702 .14238 L
s
.57028 .1412 m
.57028 .1412 L
s
.57034 .14261 m
.57034 .14261 L
s
.57042 .14238 m
.57042 .14238 L
s
.57049 .14379 m
.57049 .14379 L
s
.57057 .14355 m
.57057 .14355 L
s
.57065 .14402 m
.57065 .14402 L
s
.57072 .14472 m
.57072 .14472 L
s
.5708 .14567 m
.5708 .14567 L
s
.57087 .14684 m
.57087 .14684 L
s
.57094 .14637 m
.57094 .14637 L
s
.57102 .14801 m
.57102 .14801 L
s
.57109 .14731 m
.57109 .14731 L
s
.57116 .14778 m
.57116 .14778 L
s
.57124 .14637 m
.57124 .14637 L
s
.57131 .14778 m
.57131 .14778 L
s
.57139 .14801 m
.57139 .14801 L
s
.57146 .14895 m
.57146 .14895 L
s
.57154 .14731 m
.57154 .14731 L
s
.57161 .14614 m
.57161 .14614 L
s
.57168 .1459 m
.57168 .1459 L
s
.57176 .14614 m
.57176 .14614 L
s
.57184 .14707 m
.57184 .14707 L
s
.57191 .14637 m
.57191 .14637 L
s
.57198 .14778 m
.57198 .14778 L
s
.57205 .14754 m
.57205 .14754 L
s
.57213 .14614 m
.57213 .14614 L
s
.57221 .14496 m
.57221 .14496 L
s
.57228 .14425 m
.57228 .14425 L
s
.57236 .14379 m
.57236 .14379 L
s
.57243 .14261 m
.57243 .14261 L
s
.5725 .14285 m
.5725 .14285 L
s
.57257 .1405 m
.57257 .1405 L
s
.57265 .1419 m
.57265 .1419 L
s
.57273 .14097 m
.57273 .14097 L
s
.5728 .14402 m
.5728 .14402 L
s
.57287 .14261 m
.57287 .14261 L
s
.57295 .14379 m
.57295 .14379 L
s
.57302 .14379 m
.57302 .14379 L
s
.5731 .14238 m
.5731 .14238 L
s
.57317 .14379 m
.57317 .14379 L
s
.57325 .1419 m
.57325 .1419 L
s
.57331 .14332 m
.57331 .14332 L
s
.57339 .14261 m
.57339 .14261 L
s
.57347 .14261 m
.57347 .14261 L
s
.57354 .1419 m
.57354 .1419 L
s
.57361 .14238 m
.57361 .14238 L
s
.57369 .14238 m
.57369 .14238 L
s
.57377 .14332 m
.57377 .14332 L
s
.57384 .14238 m
.57384 .14238 L
s
.57392 .14332 m
.57392 .14332 L
s
.57399 .14308 m
.57399 .14308 L
s
.57406 .14332 m
.57406 .14332 L
s
.57413 .14402 m
.57413 .14402 L
s
.57421 .14332 m
.57421 .14332 L
s
.57428 .1459 m
.57428 .1459 L
s
.57436 .14496 m
.57436 .14496 L
s
.57443 .14567 m
.57443 .14567 L
s
.57451 .14543 m
.57451 .14543 L
s
.57458 .14425 m
.57458 .14425 L
s
.57466 .14425 m
.57466 .14425 L
s
.57473 .14496 m
.57473 .14496 L
s
.57481 .14402 m
.57481 .14402 L
s
.57488 .14355 m
.57488 .14355 L
s
.57495 .14402 m
.57495 .14402 L
s
.57502 .14402 m
.57502 .14402 L
s
.5751 .14143 m
.5751 .14143 L
s
.57517 .13933 m
.57517 .13933 L
s
.57525 .1405 m
.57525 .1405 L
s
.57533 .14097 m
.57533 .14097 L
s
.5754 .14285 m
.5754 .14285 L
s
.57548 .1419 m
.57548 .1419 L
s
.57555 .1419 m
.57555 .1419 L
s
.57563 .14214 m
.57563 .14214 L
s
.5757 .14143 m
.5757 .14143 L
s
.57577 .1412 m
.57577 .1412 L
s
.57584 .14003 m
.57584 .14003 L
s
.57592 .1412 m
.57592 .1412 L
s
.57599 .14003 m
.57599 .14003 L
s
.57607 .14097 m
.57607 .14097 L
s
.57614 .14073 m
.57614 .14073 L
s
.57622 .14143 m
.57622 .14143 L
s
.57629 .13956 m
.57629 .13956 L
s
.57637 .14026 m
.57637 .14026 L
s
.57644 .13933 m
.57644 .13933 L
s
.57651 .13956 m
.57651 .13956 L
s
.57658 .13886 m
.57658 .13886 L
s
.57666 .13838 m
.57666 .13838 L
s
.57673 .13979 m
.57673 .13979 L
s
.57681 .13791 m
.57681 .13791 L
s
.57689 .13861 m
.57689 .13861 L
s
.57696 .13815 m
.57696 .13815 L
s
.57704 .14003 m
.57704 .14003 L
s
.57711 .13956 m
.57711 .13956 L
s
.57719 .13838 m
.57719 .13838 L
s
.57726 .13886 m
.57726 .13886 L
s
.57733 .13886 m
.57733 .13886 L
s
.5774 .1412 m
.5774 .1412 L
s
.57748 .14097 m
.57748 .14097 L
s
.57755 .14097 m
.57755 .14097 L
s
.57763 .14003 m
.57763 .14003 L
s
.5777 .14214 m
.5777 .14214 L
s
.57778 .14238 m
.57778 .14238 L
s
.57785 .14285 m
.57785 .14285 L
s
.57793 .14355 m
.57793 .14355 L
s
.578 .14214 m
.578 .14214 L
s
.57808 .14355 m
.57808 .14355 L
s
.57814 .14449 m
.57814 .14449 L
s
.57822 .14425 m
.57822 .14425 L
s
.57829 .14355 m
.57829 .14355 L
s
.57837 .14355 m
.57837 .14355 L
s
.57845 .14379 m
.57845 .14379 L
s
.57852 .14543 m
.57852 .14543 L
s
.5786 .1459 m
.5786 .1459 L
s
.57867 .14684 m
.57867 .14684 L
s
.57874 .14567 m
.57874 .14567 L
s
.57882 .14801 m
.57882 .14801 L
s
.5789 .15013 m
.5789 .15013 L
s
.57896 .14778 m
.57896 .14778 L
s
.57904 .14895 m
.57904 .14895 L
s
.57911 .14778 m
.57911 .14778 L
s
.57919 .14848 m
.57919 .14848 L
s
.57926 .14707 m
.57926 .14707 L
s
.57934 .14872 m
.57934 .14872 L
s
.57941 .14801 m
.57941 .14801 L
s
.57948 .14919 m
.57948 .14919 L
s
.57956 .14966 m
.57956 .14966 L
s
.57964 .14661 m
.57964 .14661 L
s
.57971 .14707 m
.57971 .14707 L
s
.57978 .14778 m
.57978 .14778 L
s
.57985 .14684 m
.57985 .14684 L
s
.57993 .14661 m
.57993 .14661 L
s
.58001 .14731 m
.58001 .14731 L
s
.58008 .14707 m
.58008 .14707 L
s
.58016 .14848 m
.58016 .14848 L
s
.58023 .14895 m
.58023 .14895 L
s
.5803 .14872 m
.5803 .14872 L
s
.58038 .14848 m
.58038 .14848 L
s
.58045 .14707 m
.58045 .14707 L
s
.58053 .14801 m
.58053 .14801 L
s
.5806 .14661 m
.5806 .14661 L
s
.58067 .14801 m
.58067 .14801 L
s
.58075 .14567 m
.58075 .14567 L
s
.58082 .14778 m
.58082 .14778 L
s
.5809 .14778 m
.5809 .14778 L
s
.58097 .14943 m
.58097 .14943 L
s
.58105 .14754 m
.58105 .14754 L
s
.58111 .14707 m
.58111 .14707 L
s
.58119 .14661 m
.58119 .14661 L
s
.58127 .14707 m
.58127 .14707 L
s
.58134 .14707 m
.58134 .14707 L
s
.58141 .14754 m
.58141 .14754 L
s
.58149 .14919 m
.58149 .14919 L
s
.58157 .14943 m
.58157 .14943 L
s
.58164 .14989 m
.58164 .14989 L
s
.58172 .14989 m
.58172 .14989 L
s
.58179 .15224 m
.58179 .15224 L
s
.58187 .15248 m
.58187 .15248 L
s
.58193 .152 m
.58193 .152 L
s
.58201 .15177 m
.58201 .15177 L
s
.58209 .1513 m
.58209 .1513 L
s
.58216 .15224 m
.58216 .15224 L
s
.58223 .15177 m
.58223 .15177 L
s
.58231 .15342 m
.58231 .15342 L
s
.58238 .15295 m
.58238 .15295 L
s
.58246 .15318 m
.58246 .15318 L
s
.58253 .15271 m
.58253 .15271 L
s
.58261 .15177 m
.58261 .15177 L
s
.58268 .1513 m
.58268 .1513 L
s
.58275 .15459 m
.58275 .15459 L
s
.58282 .15529 m
.58282 .15529 L
s
.5829 .15459 m
.5829 .15459 L
s
.58297 .15506 m
.58297 .15506 L
s
.58305 .15412 m
.58305 .15412 L
s
.58313 .15412 m
.58313 .15412 L
s
.5832 .15271 m
.5832 .15271 L
s
.58328 .15412 m
.58328 .15412 L
s
.58335 .15271 m
.58335 .15271 L
s
.58343 .15435 m
.58343 .15435 L
s
.5835 .15459 m
.5835 .15459 L
s
.58357 .15647 m
.58357 .15647 L
s
.58364 .15647 m
.58364 .15647 L
s
.58372 .15694 m
.58372 .15694 L
s
.58379 .15529 m
.58379 .15529 L
s
.58387 .15671 m
.58387 .15671 L
s
.58394 .15717 m
.58394 .15717 L
s
.58402 .15553 m
.58402 .15553 L
s
.58409 .15553 m
.58409 .15553 L
s
.58417 .15506 m
.58417 .15506 L
s
.58424 .15553 m
.58424 .15553 L
s
.58431 .15435 m
.58431 .15435 L
s
.58438 .15506 m
.58438 .15506 L
s
.58446 .15506 m
.58446 .15506 L
s
.58453 .15482 m
.58453 .15482 L
s
.58461 .15576 m
.58461 .15576 L
s
.58469 .15435 m
.58469 .15435 L
s
.58476 .15482 m
.58476 .15482 L
s
.58484 .15389 m
.58484 .15389 L
s
.58491 .15389 m
.58491 .15389 L
s
.58499 .15271 m
.58499 .15271 L
s
.58506 .15529 m
.58506 .15529 L
s
.58513 .15624 m
.58513 .15624 L
s
.5852 .15365 m
.5852 .15365 L
s
.58528 .15459 m
.58528 .15459 L
s
.58535 .15412 m
.58535 .15412 L
s
.58543 .15529 m
.58543 .15529 L
s
.5855 .15624 m
.5855 .15624 L
s
.58558 .15741 m
.58558 .15741 L
s
.58565 .15576 m
.58565 .15576 L
s
.58573 .15671 m
.58573 .15671 L
s
.5858 .15576 m
.5858 .15576 L
s
.58588 .156 m
.58588 .156 L
s
.58594 .15647 m
.58594 .15647 L
s
.58602 .15741 m
.58602 .15741 L
s
.58609 .15788 m
.58609 .15788 L
s
.58617 .15811 m
.58617 .15811 L
s
.58625 .15835 m
.58625 .15835 L
s
.58632 .15694 m
.58632 .15694 L
s
.5864 .15741 m
.5864 .15741 L
s
.58647 .15576 m
.58647 .15576 L
s
.58655 .15553 m
.58655 .15553 L
s
.58662 .15412 m
.58662 .15412 L
s
.5867 .15506 m
.5867 .15506 L
s
.58676 .15412 m
.58676 .15412 L
s
.58684 .15342 m
.58684 .15342 L
s
.58691 .15459 m
.58691 .15459 L
s
.58699 .15318 m
.58699 .15318 L
s
.58706 .15459 m
.58706 .15459 L
s
.58714 .15248 m
.58714 .15248 L
s
.58721 .15154 m
.58721 .15154 L
s
.58728 .1506 m
.58728 .1506 L
s
.58736 .15177 m
.58736 .15177 L
s
.58744 .15271 m
.58744 .15271 L
s
.58751 .15248 m
.58751 .15248 L
s
.58758 .15107 m
.58758 .15107 L
s
.58765 .15224 m
.58765 .15224 L
s
.58773 .1506 m
.58773 .1506 L
s
.58781 .15083 m
.58781 .15083 L
s
.58788 .15224 m
.58788 .15224 L
s
.58796 .15271 m
.58796 .15271 L
s
.58803 .15389 m
.58803 .15389 L
s
.5881 .15318 m
.5881 .15318 L
s
.58818 .15318 m
.58818 .15318 L
s
.58826 .15412 m
.58826 .15412 L
s
.58833 .15318 m
.58833 .15318 L
s
.5884 .15459 m
.5884 .15459 L
s
.58847 .15435 m
.58847 .15435 L
s
.58855 .15553 m
.58855 .15553 L
s
.58862 .15459 m
.58862 .15459 L
s
.5887 .156 m
.5887 .156 L
s
.58877 .15459 m
.58877 .15459 L
s
.58885 .15647 m
.58885 .15647 L
s
.58892 .15365 m
.58892 .15365 L
s
.58899 .15389 m
.58899 .15389 L
s
.58907 .15389 m
.58907 .15389 L
s
.58914 .15529 m
.58914 .15529 L
s
.58921 .156 m
.58921 .156 L
s
.58929 .15553 m
.58929 .15553 L
s
.58937 .15694 m
.58937 .15694 L
s
.58944 .15576 m
.58944 .15576 L
s
.58952 .156 m
.58952 .156 L
s
.58959 .15647 m
.58959 .15647 L
s
.58967 .15976 m
.58967 .15976 L
s
.58973 .15953 m
.58973 .15953 L
s
.58981 .15953 m
.58981 .15953 L
s
.58989 .15835 m
.58989 .15835 L
s
.58996 .15835 m
.58996 .15835 L
s
.59003 .15858 m
.59003 .15858 L
s
.59011 .15835 m
.59011 .15835 L
s
.59018 .15929 m
.59018 .15929 L
s
.59026 .15929 m
.59026 .15929 L
s
.59033 .15999 m
.59033 .15999 L
s
.59041 .15976 m
.59041 .15976 L
s
.59048 .15976 m
.59048 .15976 L
s
.59055 .15976 m
.59055 .15976 L
s
.59063 .16093 m
.59063 .16093 L
s
.5907 .16023 m
.5907 .16023 L
s
.59078 .16023 m
.59078 .16023 L
s
.59085 .16046 m
.59085 .16046 L
s
.59093 .15929 m
.59093 .15929 L
s
.591 .15953 m
.591 .15953 L
s
.59108 .15764 m
.59108 .15764 L
s
.59115 .15788 m
.59115 .15788 L
s
.59123 .16023 m
.59123 .16023 L
s
.5913 .16187 m
.5913 .16187 L
s
.59137 .16023 m
.59137 .16023 L
s
.59144 .15905 m
.59144 .15905 L
s
.59152 .15999 m
.59152 .15999 L
s
.59159 .16023 m
.59159 .16023 L
s
.59167 .15976 m
.59167 .15976 L
s
.59174 .15929 m
.59174 .15929 L
s
.59182 .15999 m
.59182 .15999 L
s
.59189 .15858 m
.59189 .15858 L
s
.59197 .16023 m
.59197 .16023 L
s
.59204 .15882 m
.59204 .15882 L
s
.59211 .15858 m
.59211 .15858 L
s
.59218 .15741 m
.59218 .15741 L
s
.59226 .15741 m
.59226 .15741 L
s
.59234 .15741 m
.59234 .15741 L
s
.59241 .15694 m
.59241 .15694 L
s
.59249 .15647 m
.59249 .15647 L
s
.59256 .156 m
.59256 .156 L
s
.59264 .15576 m
.59264 .15576 L
s
.59271 .15435 m
.59271 .15435 L
s
.59279 .15342 m
.59279 .15342 L
s
.59286 .15224 m
.59286 .15224 L
s
.59293 .15248 m
.59293 .15248 L
s
.593 .15412 m
.593 .15412 L
s
.59308 .15435 m
.59308 .15435 L
s
.59315 .15271 m
.59315 .15271 L
s
.59323 .15224 m
.59323 .15224 L
s
.5933 .152 m
.5933 .152 L
s
.59338 .15177 m
.59338 .15177 L
s
.59345 .15083 m
.59345 .15083 L
s
.59353 .15107 m
.59353 .15107 L
s
.5936 .15271 m
.5936 .15271 L
s
.59368 .15342 m
.59368 .15342 L
s
.59375 .15107 m
.59375 .15107 L
s
.59382 .14966 m
.59382 .14966 L
s
.59389 .14943 m
.59389 .14943 L
s
.59397 .15013 m
.59397 .15013 L
s
.59405 .14989 m
.59405 .14989 L
s
.59412 .1506 m
.59412 .1506 L
s
.5942 .14848 m
.5942 .14848 L
s
.59427 .1506 m
.59427 .1506 L
s
.59435 .14825 m
.59435 .14825 L
s
.59442 .14919 m
.59442 .14919 L
s
.5945 .15036 m
.5945 .15036 L
s
.59456 .15177 m
.59456 .15177 L
s
.59464 .1506 m
.59464 .1506 L
s
.59471 .1513 m
.59471 .1513 L
s
.59479 .1506 m
.59479 .1506 L
s
.59486 .14848 m
.59486 .14848 L
s
.59494 .14848 m
.59494 .14848 L
s
.59501 .14825 m
.59501 .14825 L
s
.59509 .14919 m
.59509 .14919 L
s
.59516 .14754 m
.59516 .14754 L
s
.59524 .14754 m
.59524 .14754 L
s
.59531 .14661 m
.59531 .14661 L
s
.59538 .14519 m
.59538 .14519 L
s
.59545 .14567 m
.59545 .14567 L
s
.59553 .14402 m
.59553 .14402 L
s
.59561 .14543 m
.59561 .14543 L
s
.59568 .14519 m
.59568 .14519 L
s
.59576 .14449 m
.59576 .14449 L
s
.59583 .14308 m
.59583 .14308 L
s
.5959 .14355 m
.5959 .14355 L
s
.59598 .14238 m
.59598 .14238 L
s
.59606 .14379 m
.59606 .14379 L
s
.59613 .14355 m
.59613 .14355 L
s
.5962 .14661 m
.5962 .14661 L
s
.59627 .14754 m
.59627 .14754 L
s
.59635 .14848 m
.59635 .14848 L
s
.59642 .14661 m
.59642 .14661 L
s
.5965 .14801 m
.5965 .14801 L
s
.59657 .14801 m
.59657 .14801 L
s
.59665 .14801 m
.59665 .14801 L
s
.59672 .14989 m
.59672 .14989 L
s
.5968 .14895 m
.5968 .14895 L
s
.59687 .1513 m
.59687 .1513 L
s
.59694 .15013 m
.59694 .15013 L
s
.59701 .15083 m
.59701 .15083 L
s
.59709 .15224 m
.59709 .15224 L
s
.59717 .15248 m
.59717 .15248 L
s
.59724 .15295 m
.59724 .15295 L
s
.59732 .15271 m
.59732 .15271 L
s
.59739 .15224 m
.59739 .15224 L
s
.59747 .15083 m
.59747 .15083 L
s
.59753 .15365 m
.59753 .15365 L
s
.59761 .15482 m
.59761 .15482 L
s
.59769 .15529 m
.59769 .15529 L
s
.59776 .15529 m
.59776 .15529 L
s
.59783 .15694 m
.59783 .15694 L
s
.59791 .15576 m
.59791 .15576 L
s
.59798 .15647 m
.59798 .15647 L
s
.59806 .15811 m
.59806 .15811 L
s
.59813 .15717 m
.59813 .15717 L
s
.59821 .15835 m
.59821 .15835 L
s
.59828 .15764 m
.59828 .15764 L
s
.59835 .16023 m
.59835 .16023 L
s
.59843 .16046 m
.59843 .16046 L
s
.59851 .15976 m
.59851 .15976 L
s
.59858 .15788 m
.59858 .15788 L
s
.59865 .15835 m
.59865 .15835 L
s
.59873 .15929 m
.59873 .15929 L
s
.5988 .15976 m
.5988 .15976 L
s
.59888 .15999 m
.59888 .15999 L
s
.59895 .15929 m
.59895 .15929 L
s
.59903 .15999 m
.59903 .15999 L
s
.5991 .15811 m
.5991 .15811 L
s
.59917 .15953 m
.59917 .15953 L
s
.59924 .15835 m
.59924 .15835 L
s
.59932 .15741 m
.59932 .15741 L
s
.59939 .15389 m
.59939 .15389 L
s
.59947 .15435 m
.59947 .15435 L
s
.59954 .15435 m
.59954 .15435 L
s
.59962 .15529 m
.59962 .15529 L
s
.59969 .15647 m
.59969 .15647 L
s
.59977 .15694 m
.59977 .15694 L
s
.59984 .15671 m
.59984 .15671 L
s
.59991 .15624 m
.59991 .15624 L
s
.59998 .15576 m
.59998 .15576 L
s
.60006 .15529 m
.60006 .15529 L
s
.60014 .15576 m
.60014 .15576 L
s
.60021 .15553 m
.60021 .15553 L
s
.60029 .15412 m
.60029 .15412 L
s
.60036 .15459 m
.60036 .15459 L
s
.60044 .15459 m
.60044 .15459 L
s
.60051 .15671 m
.60051 .15671 L
s
.60059 .15647 m
.60059 .15647 L
s
.60066 .15811 m
.60066 .15811 L
s
.60073 .15717 m
.60073 .15717 L
s
.6008 .15529 m
.6008 .15529 L
s
.60088 .15412 m
.60088 .15412 L
s
.60095 .15412 m
.60095 .15412 L
s
.60103 .15412 m
.60103 .15412 L
s
.6011 .15389 m
.6011 .15389 L
s
.60118 .15389 m
.60118 .15389 L
s
.60125 .15248 m
.60125 .15248 L
s
.60133 .15342 m
.60133 .15342 L
s
.6014 .15271 m
.6014 .15271 L
s
.60148 .15389 m
.60148 .15389 L
s
.60155 .15083 m
.60155 .15083 L
s
.60162 .15107 m
.60162 .15107 L
s
.60169 .14966 m
.60169 .14966 L
s
.60177 .15107 m
.60177 .15107 L
s
.60185 .15083 m
.60185 .15083 L
s
.60192 .15154 m
.60192 .15154 L
s
.602 .15177 m
.602 .15177 L
s
.60207 .1513 m
.60207 .1513 L
s
.60215 .152 m
.60215 .152 L
s
.60222 .15107 m
.60222 .15107 L
s
.6023 .15083 m
.6023 .15083 L
s
.60236 .15013 m
.60236 .15013 L
s
.60244 .1506 m
.60244 .1506 L
s
.60251 .1513 m
.60251 .1513 L
s
.60259 .15154 m
.60259 .15154 L
s
.60266 .15177 m
.60266 .15177 L
s
.60274 .15107 m
.60274 .15107 L
s
.60281 .15107 m
.60281 .15107 L
s
.60289 .15083 m
.60289 .15083 L
s
.60296 .15177 m
.60296 .15177 L
s
.60304 .15013 m
.60304 .15013 L
s
.60311 .15177 m
.60311 .15177 L
s
.60318 .15271 m
.60318 .15271 L
s
.60325 .15482 m
.60325 .15482 L
s
.60333 .15365 m
.60333 .15365 L
s
.60341 .15318 m
.60341 .15318 L
s
.60348 .15365 m
.60348 .15365 L
s
.60356 .15365 m
.60356 .15365 L
s
.60363 .15482 m
.60363 .15482 L
s
.60371 .15365 m
.60371 .15365 L
s
.60378 .15459 m
.60378 .15459 L
s
.60386 .1506 m
.60386 .1506 L
s
.60393 .152 m
.60393 .152 L
s
.604 .14989 m
.604 .14989 L
s
.60407 .15154 m
.60407 .15154 L
s
.60415 .14943 m
.60415 .14943 L
s
.60422 .14895 m
.60422 .14895 L
s
.6043 .15036 m
.6043 .15036 L
s
.60437 .14943 m
.60437 .14943 L
s
.60445 .1513 m
.60445 .1513 L
s
.60452 .15013 m
.60452 .15013 L
s
.6046 .15036 m
.6046 .15036 L
s
.60467 .15036 m
.60467 .15036 L
s
.60474 .14943 m
.60474 .14943 L
s
.60481 .15083 m
.60481 .15083 L
s
.60489 .14989 m
.60489 .14989 L
s
.60497 .14778 m
.60497 .14778 L
s
.60504 .14801 m
.60504 .14801 L
s
.60512 .14778 m
.60512 .14778 L
s
.60519 .14778 m
.60519 .14778 L
s
.60527 .14848 m
.60527 .14848 L
s
.60534 .14801 m
.60534 .14801 L
s
.60542 .14848 m
.60542 .14848 L
s
.60549 .14895 m
.60549 .14895 L
s
.60556 .15083 m
.60556 .15083 L
s
.60563 .14966 m
.60563 .14966 L
s
.60571 .14943 m
.60571 .14943 L
s
.60578 .14801 m
.60578 .14801 L
s
.60586 .15013 m
.60586 .15013 L
s
.60593 .14943 m
.60593 .14943 L
s
.60601 .14943 m
.60601 .14943 L
s
.60608 .14943 m
.60608 .14943 L
s
.60615 .15013 m
.60615 .15013 L
s
.60623 .14943 m
.60623 .14943 L
s
.60631 .14801 m
.60631 .14801 L
s
.60638 .14919 m
.60638 .14919 L
s
.60645 .14661 m
.60645 .14661 L
s
.60653 .14731 m
.60653 .14731 L
s
.6066 .14661 m
.6066 .14661 L
s
.60668 .14707 m
.60668 .14707 L
s
.60675 .14754 m
.60675 .14754 L
s
.60683 .1459 m
.60683 .1459 L
s
.6069 .14754 m
.6069 .14754 L
s
.60697 .14707 m
.60697 .14707 L
s
.60705 .14919 m
.60705 .14919 L
s
.60713 .14707 m
.60713 .14707 L
s
.60719 .14801 m
.60719 .14801 L
s
.60727 .14684 m
.60727 .14684 L
s
.60734 .14778 m
.60734 .14778 L
s
.60742 .14848 m
.60742 .14848 L
s
.60749 .14872 m
.60749 .14872 L
s
.60757 .14872 m
.60757 .14872 L
s
.60764 .14848 m
.60764 .14848 L
s
.60771 .14943 m
.60771 .14943 L
s
.60778 .14778 m
.60778 .14778 L
s
.60786 .14707 m
.60786 .14707 L
s
.60794 .14661 m
.60794 .14661 L
s
.60801 .14731 m
.60801 .14731 L
s
.60809 .14496 m
.60809 .14496 L
s
.60816 .14449 m
.60816 .14449 L
s
.60824 .14425 m
.60824 .14425 L
s
.60831 .14402 m
.60831 .14402 L
s
.60839 .14425 m
.60839 .14425 L
s
.60846 .14332 m
.60846 .14332 L
s
.60853 .14425 m
.60853 .14425 L
s
.6086 .14308 m
.6086 .14308 L
s
.60868 .14472 m
.60868 .14472 L
s
.60876 .14449 m
.60876 .14449 L
s
.60883 .14496 m
.60883 .14496 L
s
.6089 .14472 m
.6089 .14472 L
s
.60898 .14614 m
.60898 .14614 L
s
.60905 .14661 m
.60905 .14661 L
s
.60913 .14661 m
.60913 .14661 L
s
.6092 .14707 m
.6092 .14707 L
s
.60928 .14684 m
.60928 .14684 L
s
.60935 .14661 m
.60935 .14661 L
s
.60942 .14637 m
.60942 .14637 L
s
.60949 .14754 m
.60949 .14754 L
s
.60957 .14614 m
.60957 .14614 L
s
.60965 .14801 m
.60965 .14801 L
s
.60972 .14731 m
.60972 .14731 L
s
.6098 .14895 m
.6098 .14895 L
s
.60987 .14825 m
.60987 .14825 L
s
.60995 .14825 m
.60995 .14825 L
s
.61002 .15177 m
.61002 .15177 L
s
.6101 .15177 m
.6101 .15177 L
s
.61016 .15271 m
.61016 .15271 L
s
.61024 .15224 m
.61024 .15224 L
s
.61031 .15295 m
.61031 .15295 L
s
.61039 .15083 m
.61039 .15083 L
s
.61046 .15271 m
.61046 .15271 L
s
.61054 .1513 m
.61054 .1513 L
s
.61061 .152 m
.61061 .152 L
s
.61069 .15271 m
.61069 .15271 L
s
.61076 .15224 m
.61076 .15224 L
s
.61084 .15295 m
.61084 .15295 L
s
.61091 .15224 m
.61091 .15224 L
s
.61098 .15412 m
.61098 .15412 L
s
.61105 .15576 m
.61105 .15576 L
s
.61113 .15647 m
.61113 .15647 L
s
.61121 .15576 m
.61121 .15576 L
s
.61128 .15671 m
.61128 .15671 L
s
.61136 .15694 m
.61136 .15694 L
s
.61143 .15788 m
.61143 .15788 L
s
.61151 .15882 m
.61151 .15882 L
s
.61158 .15835 m
.61158 .15835 L
s
.61166 .15788 m
.61166 .15788 L
s
.61173 .15694 m
.61173 .15694 L
s
.6118 .15624 m
.6118 .15624 L
s
.61187 .15553 m
.61187 .15553 L
s
.61195 .15717 m
.61195 .15717 L
s
.61202 .15624 m
.61202 .15624 L
s
.6121 .15741 m
.6121 .15741 L
s
.61217 .15788 m
.61217 .15788 L
s
.61225 .16023 m
.61225 .16023 L
s
.61232 .15835 m
.61232 .15835 L
s
.6124 .15882 m
.6124 .15882 L
s
.61247 .15905 m
.61247 .15905 L
s
.61254 .15717 m
.61254 .15717 L
s
.61261 .15529 m
.61261 .15529 L
s
.61269 .156 m
.61269 .156 L
s
.61277 .15717 m
.61277 .15717 L
s
.61284 .15482 m
.61284 .15482 L
s
.61292 .15482 m
.61292 .15482 L
s
.61299 .15529 m
.61299 .15529 L
s
.61307 .15717 m
.61307 .15717 L
s
.61314 .15671 m
.61314 .15671 L
s
.61322 .15553 m
.61322 .15553 L
s
.61329 .15694 m
.61329 .15694 L
s
.61336 .15764 m
.61336 .15764 L
s
.61343 .15858 m
.61343 .15858 L
s
.61351 .15929 m
.61351 .15929 L
s
.61358 .15999 m
.61358 .15999 L
s
.61366 .15835 m
.61366 .15835 L
s
.61373 .15764 m
.61373 .15764 L
s
.61381 .15694 m
.61381 .15694 L
s
.61388 .15624 m
.61388 .15624 L
s
.61396 .156 m
.61396 .156 L
s
.61403 .15717 m
.61403 .15717 L
s
.61411 .15835 m
.61411 .15835 L
s
.61418 .15788 m
.61418 .15788 L
s
.61425 .15882 m
.61425 .15882 L
s
.61433 .15788 m
.61433 .15788 L
s
.6144 .15929 m
.6144 .15929 L
s
.61448 .15929 m
.61448 .15929 L
s
.61455 .15999 m
.61455 .15999 L
s
.61463 .16023 m
.61463 .16023 L
s
.6147 .15976 m
.6147 .15976 L
s
.61477 .16164 m
.61477 .16164 L
s
.61485 .16023 m
.61485 .16023 L
s
.61493 .16093 m
.61493 .16093 L
s
.61499 .16023 m
.61499 .16023 L
s
.61507 .1614 m
.61507 .1614 L
s
.61514 .16046 m
.61514 .16046 L
s
.61522 .16305 m
.61522 .16305 L
s
.61529 .1621 m
.61529 .1621 L
s
.61537 .16375 m
.61537 .16375 L
s
.61544 .16258 m
.61544 .16258 L
s
.61551 .16164 m
.61551 .16164 L
s
.61559 .16234 m
.61559 .16234 L
s
.61567 .16164 m
.61567 .16164 L
s
.61574 .16258 m
.61574 .16258 L
s
.61581 .16093 m
.61581 .16093 L
s
.61589 .16187 m
.61589 .16187 L
s
.61596 .16187 m
.61596 .16187 L
s
.61604 .16234 m
.61604 .16234 L
s
.61611 .16305 m
.61611 .16305 L
s
.61619 .16258 m
.61619 .16258 L
s
.61626 .16164 m
.61626 .16164 L
s
.61633 .16258 m
.61633 .16258 L
s
.6164 .16328 m
.6164 .16328 L
s
.61648 .16234 m
.61648 .16234 L
s
.61656 .16281 m
.61656 .16281 L
s
.61663 .16258 m
.61663 .16258 L
s
.6167 .16258 m
.6167 .16258 L
s
.61678 .16164 m
.61678 .16164 L
s
.61685 .16281 m
.61685 .16281 L
s
.61693 .16375 m
.61693 .16375 L
s
.617 .16445 m
.617 .16445 L
s
.61708 .16516 m
.61708 .16516 L
s
.61715 .16469 m
.61715 .16469 L
s
.61722 .16469 m
.61722 .16469 L
s
.6173 .16422 m
.6173 .16422 L
s
.61737 .16516 m
.61737 .16516 L
s
.61745 .16445 m
.61745 .16445 L
s
.61752 .16586 m
.61752 .16586 L
s
.6176 .16563 m
.6176 .16563 L
s
.61767 .16586 m
.61767 .16586 L
s
.61775 .16399 m
.61775 .16399 L
s
.61782 .16305 m
.61782 .16305 L
s
.6179 .16187 m
.6179 .16187 L
s
.61796 .16117 m
.61796 .16117 L
s
.61804 .1621 m
.61804 .1621 L
s
.61811 .1621 m
.61811 .1621 L
s
.61819 .16305 m
.61819 .16305 L
s
.61826 .1621 m
.61826 .1621 L
s
.61834 .16187 m
.61834 .16187 L
s
.61841 .16117 m
.61841 .16117 L
s
.61849 .16164 m
.61849 .16164 L
s
.61856 .1614 m
.61856 .1614 L
s
.61864 .1621 m
.61864 .1621 L
s
.61871 .16352 m
.61871 .16352 L
s
.61878 .16445 m
.61878 .16445 L
s
.61885 .1661 m
.61885 .1661 L
s
.61893 .16516 m
.61893 .16516 L
s
.61901 .1661 m
.61901 .1661 L
s
.61908 .16563 m
.61908 .16563 L
s
.61916 .16704 m
.61916 .16704 L
s
.61923 .16469 m
.61923 .16469 L
s
.61931 .16586 m
.61931 .16586 L
s
.61938 .16375 m
.61938 .16375 L
s
.61946 .16352 m
.61946 .16352 L
s
.61953 .16305 m
.61953 .16305 L
s
.6196 .1621 m
.6196 .1621 L
s
.61967 .16258 m
.61967 .16258 L
s
.61975 .16164 m
.61975 .16164 L
s
.61982 .16328 m
.61982 .16328 L
s
.6199 .16281 m
.6199 .16281 L
s
.61997 .16352 m
.61997 .16352 L
s
.62005 .16234 m
.62005 .16234 L
s
.62012 .16164 m
.62012 .16164 L
s
.6202 .16093 m
.6202 .16093 L
s
.62027 .16117 m
.62027 .16117 L
s
.62034 .16093 m
.62034 .16093 L
s
.62041 .16046 m
.62041 .16046 L
s
.62049 .16117 m
.62049 .16117 L
s
.62057 .1607 m
.62057 .1607 L
s
.62064 .1614 m
.62064 .1614 L
s
.62072 .16093 m
.62072 .16093 L
s
.62079 .16093 m
.62079 .16093 L
s
.62087 .16023 m
.62087 .16023 L
s
.62094 .15905 m
.62094 .15905 L
s
.62102 .15929 m
.62102 .15929 L
s
.62109 .15835 m
.62109 .15835 L
s
.62116 .15905 m
.62116 .15905 L
s
.62123 .15835 m
.62123 .15835 L
s
.62131 .15999 m
.62131 .15999 L
s
.62138 .15976 m
.62138 .15976 L
s
.62146 .15999 m
.62146 .15999 L
s
.62153 .15905 m
.62153 .15905 L
s
.62161 .16046 m
.62161 .16046 L
s
.62168 .16093 m
.62168 .16093 L
s
.62176 .1607 m
.62176 .1607 L
s
.62183 .16117 m
.62183 .16117 L
s
.62191 .16234 m
.62191 .16234 L
s
.62198 .16305 m
.62198 .16305 L
s
.62205 .16258 m
.62205 .16258 L
s
.62213 .16352 m
.62213 .16352 L
s
.6222 .16258 m
.6222 .16258 L
s
.62228 .16422 m
.62228 .16422 L
s
.62235 .16445 m
.62235 .16445 L
s
.62243 .16375 m
.62243 .16375 L
s
.6225 .16328 m
.6225 .16328 L
s
.62258 .16422 m
.62258 .16422 L
s
.62265 .16516 m
.62265 .16516 L
s
.62273 .1661 m
.62273 .1661 L
s
.62279 .16681 m
.62279 .16681 L
s
.62287 .16681 m
.62287 .16681 L
s
.62294 .16868 m
.62294 .16868 L
s
.62302 .16774 m
.62302 .16774 L
s
.62309 .16892 m
.62309 .16892 L
s
.62317 .16798 m
.62317 .16798 L
s
.62324 .16845 m
.62324 .16845 L
s
.62331 .16915 m
.62331 .16915 L
s
.62339 .17009 m
.62339 .17009 L
s
.62347 .17056 m
.62347 .17056 L
s
.62354 .17009 m
.62354 .17009 L
s
.62361 .1715 m
.62361 .1715 L
s
.62369 .17033 m
.62369 .17033 L
s
.62376 .17056 m
.62376 .17056 L
s
.62384 .16963 m
.62384 .16963 L
s
.62391 .16986 m
.62391 .16986 L
s
.62399 .16892 m
.62399 .16892 L
s
.62406 .16868 m
.62406 .16868 L
s
.62413 .16845 m
.62413 .16845 L
s
.62421 .17009 m
.62421 .17009 L
s
.62429 .16939 m
.62429 .16939 L
s
.62436 .16963 m
.62436 .16963 L
s
.62443 .16963 m
.62443 .16963 L
s
.6245 .16821 m
.6245 .16821 L
s
.62458 .17033 m
.62458 .17033 L
s
.62465 .16963 m
.62465 .16963 L
s
.62473 .1708 m
.62473 .1708 L
s
.6248 .16939 m
.6248 .16939 L
s
.62488 .17291 m
.62488 .17291 L
s
.62495 .17315 m
.62495 .17315 L
s
.62502 .17267 m
.62502 .17267 L
s
.6251 .17409 m
.6251 .17409 L
s
.62518 .17409 m
.62518 .17409 L
s
.62525 .1762 m
.62525 .1762 L
s
.62532 .17691 m
.62532 .17691 L
s
.6254 .17878 m
.6254 .17878 L
s
.62547 .17925 m
.62547 .17925 L
s
.62555 .18066 m
.62555 .18066 L
s
.62562 .17644 m
.62562 .17644 L
s
.6257 .17855 m
.6257 .17855 L
s
.62576 .17761 m
.62576 .17761 L
s
.62584 .17714 m
.62584 .17714 L
s
.62592 .17667 m
.62592 .17667 L
s
.62599 .17573 m
.62599 .17573 L
s
.62606 .17667 m
.62606 .17667 L
s
.62614 .17549 m
.62614 .17549 L
s
.62621 .17738 m
.62621 .17738 L
s
.62629 .17479 m
.62629 .17479 L
s
.62636 .17526 m
.62636 .17526 L
s
.62644 .17338 m
.62644 .17338 L
s
.62651 .17456 m
.62651 .17456 L
s
.62658 .17549 m
.62658 .17549 L
s
.62665 .17644 m
.62665 .17644 L
s
.62673 .17573 m
.62673 .17573 L
s
.62681 .17549 m
.62681 .17549 L
s
.62688 .17385 m
.62688 .17385 L
s
.62696 .17409 m
.62696 .17409 L
s
.62703 .17456 m
.62703 .17456 L
s
.62711 .17362 m
.62711 .17362 L
s
.62718 .17502 m
.62718 .17502 L
s
.62726 .17526 m
.62726 .17526 L
s
.62733 .17596 m
.62733 .17596 L
s
.6274 .17432 m
.6274 .17432 L
s
.62747 .17456 m
.62747 .17456 L
s
.62755 .17291 m
.62755 .17291 L
s
.62762 .1722 m
.62762 .1722 L
s
.6277 .17197 m
.6277 .17197 L
s
.62777 .17127 m
.62777 .17127 L
s
.62785 .17432 m
.62785 .17432 L
s
.62792 .17385 m
.62792 .17385 L
s
.628 .17456 m
.628 .17456 L
s
.62807 .17409 m
.62807 .17409 L
s
.62815 .17362 m
.62815 .17362 L
s
.62821 .17244 m
.62821 .17244 L
s
.62829 .17291 m
.62829 .17291 L
s
.62837 .17432 m
.62837 .17432 L
s
.62844 .1762 m
.62844 .1762 L
s
.62852 .17691 m
.62852 .17691 L
s
.62859 .17432 m
.62859 .17432 L
s
.62867 .17432 m
.62867 .17432 L
s
.62874 .17244 m
.62874 .17244 L
s
.62882 .17338 m
.62882 .17338 L
s
.62889 .17244 m
.62889 .17244 L
s
.62896 .1715 m
.62896 .1715 L
s
.62903 .1715 m
.62903 .1715 L
s
.62911 .17244 m
.62911 .17244 L
s
.62918 .17244 m
.62918 .17244 L
s
.62926 .17291 m
.62926 .17291 L
s
.62933 .1722 m
.62933 .1722 L
s
.62941 .1722 m
.62941 .1722 L
s
.62948 .17267 m
.62948 .17267 L
s
.62956 .16963 m
.62956 .16963 L
s
.62963 .17244 m
.62963 .17244 L
s
.62971 .17103 m
.62971 .17103 L
s
.62978 .17267 m
.62978 .17267 L
s
.62985 .17244 m
.62985 .17244 L
s
.62993 .17103 m
.62993 .17103 L
s
.63 .17244 m
.63 .17244 L
s
.63008 .17432 m
.63008 .17432 L
s
.63015 .17338 m
.63015 .17338 L
s
.63023 .17291 m
.63023 .17291 L
s
.6303 .17432 m
.6303 .17432 L
s
.63038 .17338 m
.63038 .17338 L
s
.63045 .17479 m
.63045 .17479 L
s
.63053 .17502 m
.63053 .17502 L
s
.63059 .1762 m
.63059 .1762 L
s
.63067 .17714 m
.63067 .17714 L
s
.63074 .17855 m
.63074 .17855 L
s
.63082 .17831 m
.63082 .17831 L
s
.63089 .1762 m
.63089 .1762 L
s
.63097 .1762 m
.63097 .1762 L
s
.63104 .17738 m
.63104 .17738 L
s
.63112 .17784 m
.63112 .17784 L
s
.63119 .17831 m
.63119 .17831 L
s
.63127 .17855 m
.63127 .17855 L
s
.63134 .17878 m
.63134 .17878 L
s
.63141 .17784 m
.63141 .17784 L
s
.63149 .17878 m
.63149 .17878 L
s
.63156 .17902 m
.63156 .17902 L
s
.63164 .18043 m
.63164 .18043 L
s
.63171 .17878 m
.63171 .17878 L
s
.63179 .1802 m
.63179 .1802 L
s
.63186 .17948 m
.63186 .17948 L
s
.63193 .1809 m
.63193 .1809 L
s
.63201 .18137 m
.63201 .18137 L
s
.63209 .18254 m
.63209 .18254 L
s
.63216 .18184 m
.63216 .18184 L
s
.63223 .1809 m
.63223 .1809 L
s
.6323 .18066 m
.6323 .18066 L
s
.63238 .17996 m
.63238 .17996 L
s
.63245 .18113 m
.63245 .18113 L
s
.63253 .1823 m
.63253 .1823 L
s
.6326 .18419 m
.6326 .18419 L
s
.63268 .18348 m
.63268 .18348 L
s
.63275 .18583 m
.63275 .18583 L
s
.63283 .18536 m
.63283 .18536 L
s
.6329 .18536 m
.6329 .18536 L
s
.63298 .18325 m
.63298 .18325 L
s
.63305 .18372 m
.63305 .18372 L
s
.63312 .18442 m
.63312 .18442 L
s
.6332 .18419 m
.6332 .18419 L
s
.63327 .18419 m
.63327 .18419 L
s
.63335 .18395 m
.63335 .18395 L
s
.63342 .18419 m
.63342 .18419 L
s
.6335 .18137 m
.6335 .18137 L
s
.63356 .18325 m
.63356 .18325 L
s
.63364 .18301 m
.63364 .18301 L
s
.63372 .18512 m
.63372 .18512 L
s
.63379 .18372 m
.63379 .18372 L
s
.63386 .18325 m
.63386 .18325 L
s
.63394 .18348 m
.63394 .18348 L
s
.63401 .18372 m
.63401 .18372 L
s
.63409 .18348 m
.63409 .18348 L
s
.63416 .1823 m
.63416 .1823 L
s
.63424 .18395 m
.63424 .18395 L
s
.63431 .18254 m
.63431 .18254 L
s
.63438 .18254 m
.63438 .18254 L
s
.63446 .18301 m
.63446 .18301 L
s
.63454 .18277 m
.63454 .18277 L
s
.63461 .18277 m
.63461 .18277 L
s
.63468 .1823 m
.63468 .1823 L
s
.63476 .18277 m
.63476 .18277 L
s
.63483 .1823 m
.63483 .1823 L
s
.63491 .18254 m
.63491 .18254 L
s
.63498 .18301 m
.63498 .18301 L
s
.63506 .18442 m
.63506 .18442 L
s
.63513 .18489 m
.63513 .18489 L
s
.6352 .18559 m
.6352 .18559 L
s
.63527 .18583 m
.63527 .18583 L
s
.63535 .18606 m
.63535 .18606 L
s
.63542 .18559 m
.63542 .18559 L
s
.6355 .18419 m
.6355 .18419 L
s
.63557 .18254 m
.63557 .18254 L
s
.63565 .1823 m
.63565 .1823 L
s
.63572 .1823 m
.63572 .1823 L
s
.6358 .18325 m
.6358 .18325 L
s
.63587 .18395 m
.63587 .18395 L
s
.63595 .18277 m
.63595 .18277 L
s
.63601 .18419 m
.63601 .18419 L
s
.63609 .18184 m
.63609 .18184 L
s
.63617 .18184 m
.63617 .18184 L
s
.63624 .18277 m
.63624 .18277 L
s
.63632 .18254 m
.63632 .18254 L
s
.63639 .18442 m
.63639 .18442 L
s
.63647 .18419 m
.63647 .18419 L
s
.63654 .18395 m
.63654 .18395 L
s
.63662 .18395 m
.63662 .18395 L
s
.63669 .18536 m
.63669 .18536 L
s
.63676 .18489 m
.63676 .18489 L
s
.63683 .18724 m
.63683 .18724 L
s
.63691 .18559 m
.63691 .18559 L
s
.63698 .18489 m
.63698 .18489 L
s
.63706 .18536 m
.63706 .18536 L
s
.63713 .18677 m
.63713 .18677 L
s
.63721 .18748 m
.63721 .18748 L
s
.63728 .18865 m
.63728 .18865 L
s
.63736 .18794 m
.63736 .18794 L
s
.63743 .18677 m
.63743 .18677 L
s
.63751 .18701 m
.63751 .18701 L
s
.63758 .18654 m
.63758 .18654 L
s
.63765 .18677 m
.63765 .18677 L
s
.63773 .18559 m
.63773 .18559 L
s
.6378 .18583 m
.6378 .18583 L
s
.63788 .18606 m
.63788 .18606 L
s
.63795 .18536 m
.63795 .18536 L
s
.63803 .18559 m
.63803 .18559 L
s
.6381 .18771 m
.6381 .18771 L
s
.63818 .18818 m
.63818 .18818 L
s
.63825 .18771 m
.63825 .18771 L
s
.63833 .18865 m
.63833 .18865 L
s
.63839 .18794 m
.63839 .18794 L
s
.63847 .18818 m
.63847 .18818 L
s
.63854 .18841 m
.63854 .18841 L
s
.63862 .18654 m
.63862 .18654 L
s
.63869 .18536 m
.63869 .18536 L
s
.63877 .18372 m
.63877 .18372 L
s
.63884 .18512 m
.63884 .18512 L
s
.63892 .18512 m
.63892 .18512 L
s
.63899 .18583 m
.63899 .18583 L
s
.63907 .18512 m
.63907 .18512 L
s
.63914 .18583 m
.63914 .18583 L
s
.63921 .18794 m
.63921 .18794 L
s
.63929 .18818 m
.63929 .18818 L
s
.63936 .18865 m
.63936 .18865 L
s
.63944 .18841 m
.63944 .18841 L
s
.63951 .18724 m
.63951 .18724 L
s
.63959 .18559 m
.63959 .18559 L
s
.63966 .18536 m
.63966 .18536 L
s
.63973 .18466 m
.63973 .18466 L
s
.63981 .18395 m
.63981 .18395 L
s
.63989 .18348 m
.63989 .18348 L
s
.63996 .18325 m
.63996 .18325 L
s
.64003 .18419 m
.64003 .18419 L
s
.6401 .18325 m
.6401 .18325 L
s
.64018 .18395 m
.64018 .18395 L
s
.64025 .18419 m
.64025 .18419 L
s
.64033 .18419 m
.64033 .18419 L
s
.6404 .18677 m
.6404 .18677 L
s
.64048 .18794 m
.64048 .18794 L
s
.64055 .18865 m
.64055 .18865 L
s
.64063 .18958 m
.64063 .18958 L
s
.6407 .18818 m
.6407 .18818 L
s
.64078 .18912 m
.64078 .18912 L
s
.64085 .18794 m
.64085 .18794 L
s
.64092 .18771 m
.64092 .18771 L
s
.641 .18701 m
.641 .18701 L
s
.64107 .18583 m
.64107 .18583 L
s
.64115 .18606 m
.64115 .18606 L
s
.64122 .1863 m
.64122 .1863 L
s
.6413 .18701 m
.6413 .18701 L
s
.64137 .18536 m
.64137 .18536 L
s
.64145 .18606 m
.64145 .18606 L
s
.64152 .18559 m
.64152 .18559 L
s
.64159 .18724 m
.64159 .18724 L
s
.64166 .18606 m
.64166 .18606 L
s
.64174 .18677 m
.64174 .18677 L
s
.64181 .18559 m
.64181 .18559 L
s
.64189 .18466 m
.64189 .18466 L
s
.64196 .18419 m
.64196 .18419 L
s
.64204 .18559 m
.64204 .18559 L
s
.64211 .18489 m
.64211 .18489 L
s
.64218 .18348 m
.64218 .18348 L
s
.64226 .18348 m
.64226 .18348 L
s
.64234 .1823 m
.64234 .1823 L
s
.64241 .18277 m
.64241 .18277 L
s
.64248 .18254 m
.64248 .18254 L
s
.64256 .18207 m
.64256 .18207 L
s
.64263 .18277 m
.64263 .18277 L
s
.64271 .18395 m
.64271 .18395 L
s
.64278 .18466 m
.64278 .18466 L
s
.64286 .18512 m
.64286 .18512 L
s
.64293 .18536 m
.64293 .18536 L
s
.643 .18277 m
.643 .18277 L
s
.64308 .1823 m
.64308 .1823 L
s
.64316 .18066 m
.64316 .18066 L
s
.64322 .1809 m
.64322 .1809 L
s
.6433 .18184 m
.6433 .18184 L
s
.64337 .1823 m
.64337 .1823 L
s
.64345 .17948 m
.64345 .17948 L
s
.64352 .17878 m
.64352 .17878 L
s
.6436 .17925 m
.6436 .17925 L
s
.64367 .17996 m
.64367 .17996 L
s
.64375 .18137 m
.64375 .18137 L
s
.64381 .1809 m
.64381 .1809 L
s
.64389 .1823 m
.64389 .1823 L
s
.64397 .18066 m
.64397 .18066 L
s
.64404 .1823 m
.64404 .1823 L
s
.64412 .18043 m
.64412 .18043 L
s
.64419 .1809 m
.64419 .1809 L
s
.64427 .17878 m
.64427 .17878 L
s
.64434 .17855 m
.64434 .17855 L
s
.64442 .17925 m
.64442 .17925 L
s
.64449 .17902 m
.64449 .17902 L
s
.64456 .1809 m
.64456 .1809 L
s
.64463 .17973 m
.64463 .17973 L
s
.64471 .1802 m
.64471 .1802 L
s
.64479 .17878 m
.64479 .17878 L
s
.64486 .17996 m
.64486 .17996 L
s
.64493 .17808 m
.64493 .17808 L
s
.64501 .17902 m
.64501 .17902 L
s
.64508 .17714 m
.64508 .17714 L
s
.64516 .17738 m
.64516 .17738 L
s
.64523 .17667 m
.64523 .17667 L
s
.64531 .17479 m
.64531 .17479 L
s
.64538 .17549 m
.64538 .17549 L
s
.64545 .17573 m
.64545 .17573 L
s
.64553 .1762 m
.64553 .1762 L
s
.6456 .1762 m
.6456 .1762 L
s
.64568 .17714 m
.64568 .17714 L
s
.64575 .17738 m
.64575 .17738 L
s
.64583 .17878 m
.64583 .17878 L
s
.6459 .18137 m
.6459 .18137 L
s
.64598 .18207 m
.64598 .18207 L
s
.64605 .18419 m
.64605 .18419 L
s
.64613 .18277 m
.64613 .18277 L
s
.64619 .18207 m
.64619 .18207 L
s
.64627 .18207 m
.64627 .18207 L
s
.64634 .18325 m
.64634 .18325 L
s
.64642 .18301 m
.64642 .18301 L
s
.64649 .18348 m
.64649 .18348 L
s
.64657 .18325 m
.64657 .18325 L
s
.64664 .18512 m
.64664 .18512 L
s
.64672 .18442 m
.64672 .18442 L
s
.64679 .18466 m
.64679 .18466 L
s
.64687 .18606 m
.64687 .18606 L
s
.64694 .18442 m
.64694 .18442 L
s
.64701 .18395 m
.64701 .18395 L
s
.64709 .18277 m
.64709 .18277 L
s
.64716 .18395 m
.64716 .18395 L
s
.64724 .18277 m
.64724 .18277 L
s
.64731 .18442 m
.64731 .18442 L
s
.64739 .18489 m
.64739 .18489 L
s
.64746 .18559 m
.64746 .18559 L
s
.64754 .18512 m
.64754 .18512 L
s
.64761 .18466 m
.64761 .18466 L
s
.64769 .18701 m
.64769 .18701 L
s
.64776 .18677 m
.64776 .18677 L
s
.64783 .18958 m
.64783 .18958 L
s
.6479 .19006 m
.6479 .19006 L
s
.64798 .19053 m
.64798 .19053 L
s
.64805 .19006 m
.64805 .19006 L
s
.64813 .18888 m
.64813 .18888 L
s
.6482 .18818 m
.6482 .18818 L
s
.64828 .18888 m
.64828 .18888 L
s
.64835 .18748 m
.64835 .18748 L
s
.64843 .18606 m
.64843 .18606 L
s
.6485 .18841 m
.6485 .18841 L
s
.64858 .18748 m
.64858 .18748 L
s
.64865 .18771 m
.64865 .18771 L
s
.64872 .18771 m
.64872 .18771 L
s
.6488 .18794 m
.6488 .18794 L
s
.64887 .18983 m
.64887 .18983 L
s
.64895 .18888 m
.64895 .18888 L
s
.64902 .18841 m
.64902 .18841 L
s
.6491 .18935 m
.6491 .18935 L
s
.64917 .18983 m
.64917 .18983 L
s
.64925 .18865 m
.64925 .18865 L
s
.64932 .191 m
.64932 .191 L
s
.64939 .191 m
.64939 .191 L
s
.64946 .19264 m
.64946 .19264 L
s
.64954 .1924 m
.64954 .1924 L
s
.64961 .19335 m
.64961 .19335 L
s
.64969 .19264 m
.64969 .19264 L
s
.64976 .19264 m
.64976 .19264 L
s
.64984 .19358 m
.64984 .19358 L
s
.64991 .19217 m
.64991 .19217 L
s
.64998 .19358 m
.64998 .19358 L
s
.65006 .19217 m
.65006 .19217 L
s
.65014 .19287 m
.65014 .19287 L
s
.65021 .19147 m
.65021 .19147 L
s
.65028 .19287 m
.65028 .19287 L
s
.65036 .19264 m
.65036 .19264 L
s
.65043 .19452 m
.65043 .19452 L
s
.65051 .19476 m
.65051 .19476 L
s
.65058 .19546 m
.65058 .19546 L
s
.65066 .19499 m
.65066 .19499 L
s
.65073 .19711 m
.65073 .19711 L
s
.6508 .1964 m
.6508 .1964 L
s
.65088 .19546 m
.65088 .19546 L
s
.65096 .19711 m
.65096 .19711 L
s
.65102 .1964 m
.65102 .1964 L
s
.6511 .19616 m
.6511 .19616 L
s
.65117 .19616 m
.65117 .19616 L
s
.65125 .19734 m
.65125 .19734 L
s
.65132 .1964 m
.65132 .1964 L
s
.6514 .19569 m
.6514 .19569 L
s
.65147 .19711 m
.65147 .19711 L
s
.65155 .19711 m
.65155 .19711 L
s
.65161 .19734 m
.65161 .19734 L
s
.65169 .19687 m
.65169 .19687 L
s
.65177 .19711 m
.65177 .19711 L
s
.65184 .19758 m
.65184 .19758 L
s
.65192 .19593 m
.65192 .19593 L
s
.65199 .19452 m
.65199 .19452 L
s
.65207 .19499 m
.65207 .19499 L
s
.65214 .19405 m
.65214 .19405 L
s
.65222 .19382 m
.65222 .19382 L
s
.65229 .19429 m
.65229 .19429 L
s
.65236 .19264 m
.65236 .19264 L
s
.65243 .19335 m
.65243 .19335 L
s
.65251 .19405 m
.65251 .19405 L
s
.65259 .19499 m
.65259 .19499 L
s
.65266 .19546 m
.65266 .19546 L
s
.65273 .19758 m
.65273 .19758 L
s
.65281 .19546 m
.65281 .19546 L
s
.65288 .19616 m
.65288 .19616 L
s
.65296 .19499 m
.65296 .19499 L
s
.65303 .19429 m
.65303 .19429 L
s
.65311 .19358 m
.65311 .19358 L
s
.65318 .19287 m
.65318 .19287 L
s
.65325 .19311 m
.65325 .19311 L
s
.65333 .1917 m
.65333 .1917 L
s
.6534 .19287 m
.6534 .19287 L
s
.65348 .19311 m
.65348 .19311 L
s
.65355 .19476 m
.65355 .19476 L
s
.65363 .19522 m
.65363 .19522 L
s
.6537 .19593 m
.6537 .19593 L
s
.65378 .19522 m
.65378 .19522 L
s
.65385 .19522 m
.65385 .19522 L
s
.65393 .19593 m
.65393 .19593 L
s
.65399 .19569 m
.65399 .19569 L
s
.65407 .1964 m
.65407 .1964 L
s
.65414 .19569 m
.65414 .19569 L
s
.65422 .19593 m
.65422 .19593 L
s
.65429 .19452 m
.65429 .19452 L
s
.65437 .19452 m
.65437 .19452 L
s
.65444 .19335 m
.65444 .19335 L
s
.65452 .1964 m
.65452 .1964 L
s
.65459 .1964 m
.65459 .1964 L
s
.65467 .19711 m
.65467 .19711 L
s
.65474 .19546 m
.65474 .19546 L
s
.65481 .19499 m
.65481 .19499 L
s
.65489 .1964 m
.65489 .1964 L
s
.65496 .19711 m
.65496 .19711 L
s
.65504 .19758 m
.65504 .19758 L
s
.65511 .1964 m
.65511 .1964 L
s
.65519 .19687 m
.65519 .19687 L
s
.65526 .19593 m
.65526 .19593 L
s
.65534 .19476 m
.65534 .19476 L
s
.65541 .19522 m
.65541 .19522 L
s
.65549 .19452 m
.65549 .19452 L
s
.65556 .19335 m
.65556 .19335 L
s
.65563 .19217 m
.65563 .19217 L
s
.6557 .19452 m
.6557 .19452 L
s
.65578 .19358 m
.65578 .19358 L
s
.65585 .19358 m
.65585 .19358 L
s
.65593 .19287 m
.65593 .19287 L
s
.656 .19499 m
.656 .19499 L
s
.65608 .19335 m
.65608 .19335 L
s
.65615 .19452 m
.65615 .19452 L
s
.65623 .19405 m
.65623 .19405 L
s
.6563 .19405 m
.6563 .19405 L
s
.65638 .19452 m
.65638 .19452 L
s
.65645 .19452 m
.65645 .19452 L
s
.65652 .1964 m
.65652 .1964 L
s
.6566 .19593 m
.6566 .19593 L
s
.65667 .19804 m
.65667 .19804 L
s
.65675 .19758 m
.65675 .19758 L
s
.65682 .19851 m
.65682 .19851 L
s
.6569 .19687 m
.6569 .19687 L
s
.65697 .19804 m
.65697 .19804 L
s
.65705 .19851 m
.65705 .19851 L
s
.65712 .19758 m
.65712 .19758 L
s
.65719 .19593 m
.65719 .19593 L
s
.65726 .19593 m
.65726 .19593 L
s
.65734 .19499 m
.65734 .19499 L
s
.65741 .19452 m
.65741 .19452 L
s
.65749 .19569 m
.65749 .19569 L
s
.65756 .19499 m
.65756 .19499 L
s
.65764 .19499 m
.65764 .19499 L
s
.65771 .19499 m
.65771 .19499 L
s
.65779 .19476 m
.65779 .19476 L
s
.65786 .19452 m
.65786 .19452 L
s
.65794 .19429 m
.65794 .19429 L
s
.65801 .19382 m
.65801 .19382 L
s
.65808 .19358 m
.65808 .19358 L
s
.65816 .19546 m
.65816 .19546 L
s
.65823 .19405 m
.65823 .19405 L
s
.65831 .19358 m
.65831 .19358 L
s
.65838 .19311 m
.65838 .19311 L
s
.65846 .1924 m
.65846 .1924 L
s
.65853 .19123 m
.65853 .19123 L
s
.6586 .19147 m
.6586 .19147 L
s
.65868 .19006 m
.65868 .19006 L
s
.65876 .18935 m
.65876 .18935 L
s
.65882 .19006 m
.65882 .19006 L
s
.6589 .18818 m
.6589 .18818 L
s
.65897 .18724 m
.65897 .18724 L
s
.65905 .18606 m
.65905 .18606 L
s
.65912 .18912 m
.65912 .18912 L
s
.6592 .1863 m
.6592 .1863 L
s
.65927 .18794 m
.65927 .18794 L
s
.65935 .18794 m
.65935 .18794 L
s
.65942 .18818 m
.65942 .18818 L
s
.6595 .18654 m
.6595 .18654 L
s
.65958 .18536 m
.65958 .18536 L
s
.65964 .18536 m
.65964 .18536 L
s
.65972 .18536 m
.65972 .18536 L
s
.65979 .18748 m
.65979 .18748 L
s
.65987 .18654 m
.65987 .18654 L
s
.65994 .18794 m
.65994 .18794 L
s
.66002 .18536 m
.66002 .18536 L
s
.66009 .1863 m
.66009 .1863 L
s
.66016 .18606 m
.66016 .18606 L
s
.66023 .18606 m
.66023 .18606 L
s
.66031 .18701 m
.66031 .18701 L
s
.66039 .18724 m
.66039 .18724 L
s
.66046 .18677 m
.66046 .18677 L
s
.66053 .18489 m
.66053 .18489 L
s
.66061 .18466 m
.66061 .18466 L
s
.66068 .18372 m
.66068 .18372 L
s
.66076 .18372 m
.66076 .18372 L
s
.66083 .18466 m
.66083 .18466 L
s
.66091 .18489 m
.66091 .18489 L
s
.66098 .18489 m
.66098 .18489 L
s
.66105 .18419 m
.66105 .18419 L
s
.66113 .18536 m
.66113 .18536 L
s
.66121 .18724 m
.66121 .18724 L
s
.66128 .18724 m
.66128 .18724 L
s
.66135 .18583 m
.66135 .18583 L
s
.66143 .18489 m
.66143 .18489 L
s
.6615 .18325 m
.6615 .18325 L
s
.66158 .18301 m
.66158 .18301 L
s
.66165 .18325 m
.66165 .18325 L
s
.66173 .18442 m
.66173 .18442 L
s
.66179 .18395 m
.66179 .18395 L
s
.66187 .18419 m
.66187 .18419 L
s
.66194 .18466 m
.66194 .18466 L
s
.66202 .18466 m
.66202 .18466 L
s
.66209 .18559 m
.66209 .18559 L
s
.66217 .1863 m
.66217 .1863 L
s
.66224 .18559 m
.66224 .18559 L
s
.66232 .18512 m
.66232 .18512 L
s
.66239 .18677 m
.66239 .18677 L
s
.66247 .1863 m
.66247 .1863 L
s
.66254 .18583 m
.66254 .18583 L
s
.66261 .18606 m
.66261 .18606 L
s
.66269 .18536 m
.66269 .18536 L
s
.66276 .18771 m
.66276 .18771 L
s
.66284 .18724 m
.66284 .18724 L
s
.66291 .18818 m
.66291 .18818 L
s
.66299 .18771 m
.66299 .18771 L
s
.66306 .18888 m
.66306 .18888 L
s
.66314 .18771 m
.66314 .18771 L
s
.66321 .18888 m
.66321 .18888 L
s
.66329 .18888 m
.66329 .18888 L
s
.66336 .18958 m
.66336 .18958 L
s
.66343 .18935 m
.66343 .18935 L
s
.6635 .18818 m
.6635 .18818 L
s
.66358 .18748 m
.66358 .18748 L
s
.66365 .18748 m
.66365 .18748 L
s
.66373 .18794 m
.66373 .18794 L
s
.6638 .18677 m
.6638 .18677 L
s
.66388 .18701 m
.66388 .18701 L
s
.66395 .18654 m
.66395 .18654 L
s
.66403 .18748 m
.66403 .18748 L
s
.6641 .18748 m
.6641 .18748 L
s
.66418 .18771 m
.66418 .18771 L
s
.66425 .18818 m
.66425 .18818 L
s
.66432 .18841 m
.66432 .18841 L
s
.6644 .191 m
.6644 .191 L
s
.66447 .18935 m
.66447 .18935 L
s
.66455 .18983 m
.66455 .18983 L
s
.66462 .18794 m
.66462 .18794 L
s
.6647 .18888 m
.6647 .18888 L
s
.66477 .18958 m
.66477 .18958 L
s
.66485 .1903 m
.66485 .1903 L
s
.66492 .1903 m
.66492 .1903 L
s
.66499 .19076 m
.66499 .19076 L
s
.66506 .18983 m
.66506 .18983 L
s
.66514 .19053 m
.66514 .19053 L
s
.66521 .19147 m
.66521 .19147 L
s
.66529 .19123 m
.66529 .19123 L
s
.66536 .19217 m
.66536 .19217 L
s
.66544 .19076 m
.66544 .19076 L
s
.66551 .1917 m
.66551 .1917 L
s
.66559 .191 m
.66559 .191 L
s
.66566 .19311 m
.66566 .19311 L
s
.66574 .19405 m
.66574 .19405 L
s
.66581 .19335 m
.66581 .19335 L
s
.66588 .19311 m
.66588 .19311 L
s
.66596 .19217 m
.66596 .19217 L
s
.66603 .19287 m
.66603 .19287 L
s
.66611 .19335 m
.66611 .19335 L
s
.66618 .19429 m
.66618 .19429 L
s
.66626 .19264 m
.66626 .19264 L
s
.66633 .19429 m
.66633 .19429 L
s
.66641 .19429 m
.66641 .19429 L
s
.66648 .19476 m
.66648 .19476 L
s
.66656 .19546 m
.66656 .19546 L
s
.66663 .19664 m
.66663 .19664 L
s
.6667 .19499 m
.6667 .19499 L
s
.66677 .19546 m
.66677 .19546 L
s
.66685 .19522 m
.66685 .19522 L
s
.66692 .19476 m
.66692 .19476 L
s
.667 .19616 m
.667 .19616 L
s
.66707 .19499 m
.66707 .19499 L
s
.66715 .19522 m
.66715 .19522 L
s
.66722 .19499 m
.66722 .19499 L
s
.6673 .19546 m
.6673 .19546 L
s
.66738 .19711 m
.66738 .19711 L
s
.66744 .19781 m
.66744 .19781 L
s
.66752 .19758 m
.66752 .19758 L
s
.66759 .19781 m
.66759 .19781 L
s
.66767 .19828 m
.66767 .19828 L
s
.66774 .19734 m
.66774 .19734 L
s
.66782 .19734 m
.66782 .19734 L
s
.66789 .19711 m
.66789 .19711 L
s
.66796 .19898 m
.66796 .19898 L
s
.66804 .19968 m
.66804 .19968 L
s
.66812 .19992 m
.66812 .19992 L
s
.66819 .20063 m
.66819 .20063 L
s
.66826 .20133 m
.66826 .20133 L
s
.66833 .20063 m
.66833 .20063 L
s
.66841 .20016 m
.66841 .20016 L
s
.66848 .20227 m
.66848 .20227 L
s
.66856 .20157 m
.66856 .20157 L
s
.66863 .2018 m
.66863 .2018 L
s
.66871 .19992 m
.66871 .19992 L
s
.66878 .2011 m
.66878 .2011 L
s
.66885 .2025 m
.66885 .2025 L
s
.66893 .20345 m
.66893 .20345 L
s
.66901 .2025 m
.66901 .2025 L
s
.66908 .20345 m
.66908 .20345 L
s
.66915 .2025 m
.66915 .2025 L
s
.66923 .20227 m
.66923 .20227 L
s
.6693 .20204 m
.6693 .20204 L
s
.66938 .20086 m
.66938 .20086 L
s
.66945 .20157 m
.66945 .20157 L
s
.66953 .2011 m
.66953 .2011 L
s
.6696 .20063 m
.6696 .20063 L
s
.66967 .2011 m
.66967 .2011 L
s
.66975 .20133 m
.66975 .20133 L
s
.66982 .20086 m
.66982 .20086 L
s
.66989 .20086 m
.66989 .20086 L
s
.66997 .20297 m
.66997 .20297 L
s
.67004 .20086 m
.67004 .20086 L
s
.67012 .2025 m
.67012 .2025 L
s
.67019 .2025 m
.67019 .2025 L
s
.67027 .20274 m
.67027 .20274 L
s
.67034 .20133 m
.67034 .20133 L
s
.67041 .20439 m
.67041 .20439 L
s
.67049 .20368 m
.67049 .20368 L
s
.67056 .20462 m
.67056 .20462 L
s
.67064 .20297 m
.67064 .20297 L
s
.67071 .20345 m
.67071 .20345 L
s
.67079 .20439 m
.67079 .20439 L
s
.67086 .2011 m
.67086 .2011 L
s
.67094 .20157 m
.67094 .20157 L
s
.67101 .20297 m
.67101 .20297 L
s
.67109 .20462 m
.67109 .20462 L
s
.67116 .20486 m
.67116 .20486 L
s
.67123 .20674 m
.67123 .20674 L
s
.6713 .20768 m
.6713 .20768 L
s
.67138 .20674 m
.67138 .20674 L
s
.67146 .20697 m
.67146 .20697 L
s
.67153 .2065 m
.67153 .2065 L
s
.6716 .20768 m
.6716 .20768 L
s
.67168 .20838 m
.67168 .20838 L
s
.67175 .20885 m
.67175 .20885 L
s
.67183 .20814 m
.67183 .20814 L
s
.6719 .2112 m
.6719 .2112 L
s
.67198 .20885 m
.67198 .20885 L
s
.67205 .20861 m
.67205 .20861 L
s
.67212 .20861 m
.67212 .20861 L
s
.6722 .20768 m
.6722 .20768 L
s
.67227 .2065 m
.67227 .2065 L
s
.67235 .20626 m
.67235 .20626 L
s
.67242 .20415 m
.67242 .20415 L
s
.6725 .20439 m
.6725 .20439 L
s
.67257 .20509 m
.67257 .20509 L
s
.67265 .20321 m
.67265 .20321 L
s
.67272 .20368 m
.67272 .20368 L
s
.67279 .20133 m
.67279 .20133 L
s
.67286 .20227 m
.67286 .20227 L
s
.67294 .20297 m
.67294 .20297 L
s
.67301 .20297 m
.67301 .20297 L
s
.67309 .20274 m
.67309 .20274 L
s
.67316 .20345 m
.67316 .20345 L
s
.67324 .20415 m
.67324 .20415 L
s
.67331 .20345 m
.67331 .20345 L
s
.67339 .20439 m
.67339 .20439 L
s
.67346 .2025 m
.67346 .2025 L
s
.67354 .20204 m
.67354 .20204 L
s
.67361 .20204 m
.67361 .20204 L
s
.67368 .20321 m
.67368 .20321 L
s
.67376 .20345 m
.67376 .20345 L
s
.67383 .20462 m
.67383 .20462 L
s
.67391 .20532 m
.67391 .20532 L
s
.67398 .2065 m
.67398 .2065 L
s
.67406 .20509 m
.67406 .20509 L
s
.67413 .20556 m
.67413 .20556 L
s
.67421 .20744 m
.67421 .20744 L
s
.67428 .20532 m
.67428 .20532 L
s
.67436 .20626 m
.67436 .20626 L
s
.67443 .20674 m
.67443 .20674 L
s
.6745 .20768 m
.6745 .20768 L
s
.67457 .20908 m
.67457 .20908 L
s
.67465 .20885 m
.67465 .20885 L
s
.67472 .20955 m
.67472 .20955 L
s
.6748 .20885 m
.6748 .20885 L
s
.67487 .21026 m
.67487 .21026 L
s
.67495 .20861 m
.67495 .20861 L
s
.67502 .20814 m
.67502 .20814 L
s
.6751 .20814 m
.6751 .20814 L
s
.67518 .20674 m
.67518 .20674 L
s
.67524 .20556 m
.67524 .20556 L
s
.67532 .20674 m
.67532 .20674 L
s
.67539 .20744 m
.67539 .20744 L
s
.67547 .20674 m
.67547 .20674 L
s
.67554 .20674 m
.67554 .20674 L
s
.67562 .20885 m
.67562 .20885 L
s
.67569 .20932 m
.67569 .20932 L
s
.67576 .20838 m
.67576 .20838 L
s
.67584 .20744 m
.67584 .20744 L
s
.67592 .20814 m
.67592 .20814 L
s
.67599 .20932 m
.67599 .20932 L
s
.67606 .20838 m
.67606 .20838 L
s
.67613 .20979 m
.67613 .20979 L
s
.67621 .20955 m
.67621 .20955 L
s
.67628 .21002 m
.67628 .21002 L
s
.67636 .20861 m
.67636 .20861 L
s
.67643 .20674 m
.67643 .20674 L
s
.67651 .20721 m
.67651 .20721 L
s
.67658 .20768 m
.67658 .20768 L
s
.67666 .20721 m
.67666 .20721 L
s
.67674 .20532 m
.67674 .20532 L
s
.67681 .20768 m
.67681 .20768 L
s
.67688 .20697 m
.67688 .20697 L
s
.67695 .20674 m
.67695 .20674 L
s
.67703 .20814 m
.67703 .20814 L
s
.6771 .20744 m
.6771 .20744 L
s
.67718 .20768 m
.67718 .20768 L
s
.67725 .20579 m
.67725 .20579 L
s
.67733 .20721 m
.67733 .20721 L
s
.6774 .20674 m
.6774 .20674 L
s
.67747 .20744 m
.67747 .20744 L
s
.67755 .20603 m
.67755 .20603 L
s
.67762 .20721 m
.67762 .20721 L
s
.67769 .20532 m
.67769 .20532 L
s
.67777 .20579 m
.67777 .20579 L
s
.67784 .20509 m
.67784 .20509 L
s
.67792 .20579 m
.67792 .20579 L
s
.67799 .20674 m
.67799 .20674 L
s
.67807 .20603 m
.67807 .20603 L
s
.67814 .20721 m
.67814 .20721 L
s
.67821 .20744 m
.67821 .20744 L
s
.67829 .20744 m
.67829 .20744 L
s
.67837 .20697 m
.67837 .20697 L
s
.67844 .20768 m
.67844 .20768 L
s
.67851 .20721 m
.67851 .20721 L
s
.67859 .20814 m
.67859 .20814 L
s
.67866 .20885 m
.67866 .20885 L
s
.67874 .20908 m
.67874 .20908 L
s
.67881 .20979 m
.67881 .20979 L
s
.67889 .21073 m
.67889 .21073 L
s
.67896 .21214 m
.67896 .21214 L
s
.67903 .21096 m
.67903 .21096 L
s
.6791 .21002 m
.6791 .21002 L
s
.67918 .20955 m
.67918 .20955 L
s
.67926 .21237 m
.67926 .21237 L
s
.67933 .21284 m
.67933 .21284 L
s
.6794 .2119 m
.6794 .2119 L
s
.67948 .20979 m
.67948 .20979 L
s
.67955 .21096 m
.67955 .21096 L
s
.67963 .21143 m
.67963 .21143 L
s
.6797 .21073 m
.6797 .21073 L
s
.67978 .21073 m
.67978 .21073 L
s
.67985 .21073 m
.67985 .21073 L
s
.67992 .21167 m
.67992 .21167 L
s
.68 .21143 m
.68 .21143 L
s
.68007 .21355 m
.68007 .21355 L
s
.68015 .21519 m
.68015 .21519 L
s
.68022 .21542 m
.68022 .21542 L
s
.6803 .21613 m
.6803 .21613 L
s
.68037 .21636 m
.68037 .21636 L
s
.68045 .21754 m
.68045 .21754 L
s
.68052 .21707 m
.68052 .21707 L
s
.68059 .21589 m
.68059 .21589 L
s
.68066 .21589 m
.68066 .21589 L
s
.68074 .21566 m
.68074 .21566 L
s
.68081 .21449 m
.68081 .21449 L
s
.68089 .21519 m
.68089 .21519 L
s
.68096 .21425 m
.68096 .21425 L
s
.68104 .21542 m
.68104 .21542 L
s
.68111 .21613 m
.68111 .21613 L
s
.68119 .21589 m
.68119 .21589 L
s
.68126 .21496 m
.68126 .21496 L
s
.68134 .21519 m
.68134 .21519 L
s
.68141 .21519 m
.68141 .21519 L
s
.68148 .21402 m
.68148 .21402 L
s
.68156 .21589 m
.68156 .21589 L
s
.68163 .21472 m
.68163 .21472 L
s
.68171 .21425 m
.68171 .21425 L
s
.68178 .21613 m
.68178 .21613 L
s
.68186 .21778 m
.68186 .21778 L
s
.68193 .21778 m
.68193 .21778 L
s
.68201 .21918 m
.68201 .21918 L
s
.68208 .21895 m
.68208 .21895 L
s
.68216 .21942 m
.68216 .21942 L
s
.68223 .22036 m
.68223 .22036 L
s
.6823 .21965 m
.6823 .21965 L
s
.68237 .21895 m
.68237 .21895 L
s
.68245 .21965 m
.68245 .21965 L
s
.68252 .2213 m
.68252 .2213 L
s
.6826 .222 m
.6826 .222 L
s
.68267 .22177 m
.68267 .22177 L
s
.68275 .222 m
.68275 .222 L
s
.68282 .22271 m
.68282 .22271 L
s
.6829 .22341 m
.6829 .22341 L
s
.68298 .2213 m
.68298 .2213 L
s
.68304 .22271 m
.68304 .22271 L
s
.68312 .2213 m
.68312 .2213 L
s
.68319 .22388 m
.68319 .22388 L
s
.68327 .22341 m
.68327 .22341 L
s
.68334 .22412 m
.68334 .22412 L
s
.68342 .22459 m
.68342 .22459 L
s
.68349 .22271 m
.68349 .22271 L
s
.68357 .22506 m
.68357 .22506 L
s
.68364 .22599 m
.68364 .22599 L
s
.68372 .22623 m
.68372 .22623 L
s
.68379 .22506 m
.68379 .22506 L
s
.68386 .22693 m
.68386 .22693 L
s
.68393 .22623 m
.68393 .22623 L
s
.68401 .22858 m
.68401 .22858 L
s
.68408 .22693 m
.68408 .22693 L
s
.68416 .22717 m
.68416 .22717 L
s
.68423 .22646 m
.68423 .22646 L
s
.68431 .22506 m
.68431 .22506 L
s
.68438 .2267 m
.68438 .2267 L
s
.68446 .22576 m
.68446 .22576 L
s
.68454 .22741 m
.68454 .22741 L
s
.68461 .22599 m
.68461 .22599 L
s
.68468 .22693 m
.68468 .22693 L
s
.68475 .22623 m
.68475 .22623 L
s
.68483 .22646 m
.68483 .22646 L
s
.6849 .22552 m
.6849 .22552 L
s
.68498 .22599 m
.68498 .22599 L
s
.68505 .22646 m
.68505 .22646 L
s
.68513 .22717 m
.68513 .22717 L
s
.6852 .22599 m
.6852 .22599 L
s
.68528 .22623 m
.68528 .22623 L
s
.68535 .22717 m
.68535 .22717 L
s
.68542 .22811 m
.68542 .22811 L
s
.68549 .22788 m
.68549 .22788 L
s
.68557 .22623 m
.68557 .22623 L
s
.68564 .22788 m
.68564 .22788 L
s
.68572 .22717 m
.68572 .22717 L
s
.68579 .22764 m
.68579 .22764 L
s
.68587 .22928 m
.68587 .22928 L
s
.68594 .22999 m
.68594 .22999 L
s
.68601 .2321 m
.68601 .2321 L
s
.68609 .23093 m
.68609 .23093 L
s
.68617 .2321 m
.68617 .2321 L
s
.68624 .2314 m
.68624 .2314 L
s
.68631 .2307 m
.68631 .2307 L
s
.68639 .23093 m
.68639 .23093 L
s
.68646 .23093 m
.68646 .23093 L
s
.68654 .23022 m
.68654 .23022 L
s
.68661 .23093 m
.68661 .23093 L
s
.68669 .23234 m
.68669 .23234 L
s
.68676 .23093 m
.68676 .23093 L
s
.68683 .2314 m
.68683 .2314 L
s
.68691 .23093 m
.68691 .23093 L
s
.68699 .23351 m
.68699 .23351 L
s
.68706 .23257 m
.68706 .23257 L
s
.68713 .23374 m
.68713 .23374 L
s
.6872 .23093 m
.6872 .23093 L
s
.68728 .23022 m
.68728 .23022 L
s
.68735 .23022 m
.68735 .23022 L
s
.68743 .22834 m
.68743 .22834 L
s
.6875 .22811 m
.6875 .22811 L
s
.68758 .22646 m
.68758 .22646 L
s
.68765 .22693 m
.68765 .22693 L
s
.68772 .2267 m
.68772 .2267 L
s
.6878 .22693 m
.6878 .22693 L
s
.68787 .22599 m
.68787 .22599 L
s
.68795 .2267 m
.68795 .2267 L
s
.68802 .22576 m
.68802 .22576 L
s
.6881 .22576 m
.6881 .22576 L
s
.68817 .22623 m
.68817 .22623 L
s
.68825 .22623 m
.68825 .22623 L
s
.68832 .22717 m
.68832 .22717 L
s
.68839 .22741 m
.68839 .22741 L
s
.68846 .22576 m
.68846 .22576 L
s
.68854 .22412 m
.68854 .22412 L
s
.68862 .22435 m
.68862 .22435 L
s
.68869 .22459 m
.68869 .22459 L
s
.68876 .22599 m
.68876 .22599 L
s
.68884 .22623 m
.68884 .22623 L
s
.68891 .22552 m
.68891 .22552 L
s
.68899 .22506 m
.68899 .22506 L
s
.68906 .2267 m
.68906 .2267 L
s
.68914 .22788 m
.68914 .22788 L
s
.68921 .22717 m
.68921 .22717 L
s
.68928 .22788 m
.68928 .22788 L
s
.68936 .22834 m
.68936 .22834 L
s
.68943 .22764 m
.68943 .22764 L
s
.68951 .22576 m
.68951 .22576 L
s
.68958 .22552 m
.68958 .22552 L
s
.68966 .22576 m
.68966 .22576 L
s
.68973 .2267 m
.68973 .2267 L
s
.68981 .22623 m
.68981 .22623 L
s
.68988 .22717 m
.68988 .22717 L
s
.68996 .22905 m
.68996 .22905 L
s
.69003 .23022 m
.69003 .23022 L
s
.6901 .23187 m
.6901 .23187 L
s
.69017 .23327 m
.69017 .23327 L
s
.69025 .23351 m
.69025 .23351 L
s
.69032 .23351 m
.69032 .23351 L
s
.6904 .23539 m
.6904 .23539 L
s
.69047 .23351 m
.69047 .23351 L
s
.69055 .23492 m
.69055 .23492 L
s
.69062 .23492 m
.69062 .23492 L
s
.6907 .23422 m
.6907 .23422 L
s
.69078 .23398 m
.69078 .23398 L
s
.69084 .23234 m
.69084 .23234 L
s
.69092 .23281 m
.69092 .23281 L
s
.69099 .23187 m
.69099 .23187 L
s
.69107 .23234 m
.69107 .23234 L
s
.69114 .23045 m
.69114 .23045 L
s
.69122 .23351 m
.69122 .23351 L
s
.69129 .23327 m
.69129 .23327 L
s
.69137 .23327 m
.69137 .23327 L
s
.69144 .23422 m
.69144 .23422 L
s
.69152 .23422 m
.69152 .23422 L
s
.69159 .23304 m
.69159 .23304 L
s
.69166 .23398 m
.69166 .23398 L
s
.69173 .23492 m
.69173 .23492 L
s
.69181 .23563 m
.69181 .23563 L
s
.69188 .23656 m
.69188 .23656 L
s
.69196 .23633 m
.69196 .23633 L
s
.69203 .23609 m
.69203 .23609 L
s
.69211 .23539 m
.69211 .23539 L
s
.69218 .23492 m
.69218 .23492 L
s
.69226 .23633 m
.69226 .23633 L
s
.69234 .23563 m
.69234 .23563 L
s
.69241 .23422 m
.69241 .23422 L
s
.69248 .23304 m
.69248 .23304 L
s
.69255 .23398 m
.69255 .23398 L
s
.69263 .23351 m
.69263 .23351 L
s
.6927 .23539 m
.6927 .23539 L
s
.69278 .23374 m
.69278 .23374 L
s
.69285 .23539 m
.69285 .23539 L
s
.69293 .23492 m
.69293 .23492 L
s
.693 .23539 m
.693 .23539 L
s
.69308 .23539 m
.69308 .23539 L
s
.69315 .23469 m
.69315 .23469 L
s
.69322 .23469 m
.69322 .23469 L
s
.69329 .23327 m
.69329 .23327 L
s
.69337 .23516 m
.69337 .23516 L
s
.69344 .23398 m
.69344 .23398 L
s
.69352 .23422 m
.69352 .23422 L
s
.69359 .23492 m
.69359 .23492 L
s
.69367 .23516 m
.69367 .23516 L
s
.69374 .23398 m
.69374 .23398 L
s
.69382 .23351 m
.69382 .23351 L
s
.6939 .23703 m
.6939 .23703 L
s
.69397 .23656 m
.69397 .23656 L
s
.69404 .23798 m
.69404 .23798 L
s
.69411 .23609 m
.69411 .23609 L
s
.69419 .23633 m
.69419 .23633 L
s
.69426 .23492 m
.69426 .23492 L
s
.69434 .23586 m
.69434 .23586 L
s
.69441 .23469 m
.69441 .23469 L
s
.69449 .23374 m
.69449 .23374 L
s
.69456 .23304 m
.69456 .23304 L
s
.69463 .23304 m
.69463 .23304 L
s
.69471 .23187 m
.69471 .23187 L
s
.69479 .2314 m
.69479 .2314 L
s
.69486 .23281 m
.69486 .23281 L
s
.69493 .23234 m
.69493 .23234 L
s
.695 .23304 m
.695 .23304 L
s
.69508 .2307 m
.69508 .2307 L
s
.69515 .22811 m
.69515 .22811 L
s
.69523 .22693 m
.69523 .22693 L
s
.6953 .22764 m
.6953 .22764 L
s
.69538 .22552 m
.69538 .22552 L
s
.69545 .22599 m
.69545 .22599 L
s
.69553 .22506 m
.69553 .22506 L
s
.69561 .22412 m
.69561 .22412 L
s
.69567 .22294 m
.69567 .22294 L
s
.69575 .22106 m
.69575 .22106 L
s
.69582 .22224 m
.69582 .22224 L
s
.6959 .22083 m
.6959 .22083 L
s
.69597 .2213 m
.69597 .2213 L
s
.69605 .22036 m
.69605 .22036 L
s
.69612 .222 m
.69612 .222 L
s
.69619 .222 m
.69619 .222 L
s
.69626 .22317 m
.69626 .22317 L
s
.69634 .22364 m
.69634 .22364 L
s
.69642 .22271 m
.69642 .22271 L
s
.69649 .22459 m
.69649 .22459 L
s
.69656 .22459 m
.69656 .22459 L
s
.69664 .22552 m
.69664 .22552 L
s
.69671 .22506 m
.69671 .22506 L
s
.69679 .22741 m
.69679 .22741 L
s
.69686 .22834 m
.69686 .22834 L
s
.69694 .23093 m
.69694 .23093 L
s
.69701 .23163 m
.69701 .23163 L
s
.69708 .2321 m
.69708 .2321 L
s
.69716 .2321 m
.69716 .2321 L
s
.69724 .22975 m
.69724 .22975 L
s
.69731 .23045 m
.69731 .23045 L
s
.69738 .2307 m
.69738 .2307 L
s
.69746 .23163 m
.69746 .23163 L
s
.69753 .2321 m
.69753 .2321 L
s
.69761 .23327 m
.69761 .23327 L
s
.69768 .23163 m
.69768 .23163 L
s
.69776 .2321 m
.69776 .2321 L
s
.69783 .23163 m
.69783 .23163 L
s
.6979 .23163 m
.6979 .23163 L
s
.69797 .2314 m
.69797 .2314 L
s
.69805 .22952 m
.69805 .22952 L
s
.69812 .23045 m
.69812 .23045 L
s
.6982 .22858 m
.6982 .22858 L
s
.69827 .2267 m
.69827 .2267 L
s
.69835 .22529 m
.69835 .22529 L
s
.69842 .22623 m
.69842 .22623 L
s
.6985 .22552 m
.6985 .22552 L
s
.69858 .22623 m
.69858 .22623 L
s
.69864 .22741 m
.69864 .22741 L
s
.69872 .22623 m
.69872 .22623 L
s
.69879 .22717 m
.69879 .22717 L
s
.69887 .22529 m
.69887 .22529 L
s
.69894 .22459 m
.69894 .22459 L
s
.69902 .22294 m
.69902 .22294 L
s
.69909 .22435 m
.69909 .22435 L
s
.69917 .22364 m
.69917 .22364 L
s
.69924 .22412 m
.69924 .22412 L
s
.69932 .22364 m
.69932 .22364 L
s
.69939 .22364 m
.69939 .22364 L
s
.69946 .22294 m
.69946 .22294 L
s
.69953 .22388 m
.69953 .22388 L
s
.69961 .22435 m
.69961 .22435 L
s
.69968 .22388 m
.69968 .22388 L
s
.69976 .22412 m
.69976 .22412 L
s
.69983 .22294 m
.69983 .22294 L
s
.69991 .22412 m
.69991 .22412 L
s
.69998 .222 m
.69998 .222 L
s
.70006 .22224 m
.70006 .22224 L
s
.70014 .22271 m
.70014 .22271 L
s
.70021 .22599 m
.70021 .22599 L
s
.70028 .22482 m
.70028 .22482 L
s
.70035 .22552 m
.70035 .22552 L
s
.70043 .22552 m
.70043 .22552 L
s
.7005 .22529 m
.7005 .22529 L
s
.70058 .22764 m
.70058 .22764 L
s
.70065 .22693 m
.70065 .22693 L
s
.70073 .22834 m
.70073 .22834 L
s
.7008 .22811 m
.7008 .22811 L
s
.70088 .22858 m
.70088 .22858 L
s
.70095 .22834 m
.70095 .22834 L
s
.70103 .22764 m
.70103 .22764 L
s
.70109 .22858 m
.70109 .22858 L
s
.70117 .22834 m
.70117 .22834 L
s
.70124 .22952 m
.70124 .22952 L
s
.70132 .22858 m
.70132 .22858 L
s
.70139 .22811 m
.70139 .22811 L
s
.70147 .22741 m
.70147 .22741 L
s
.70154 .22952 m
.70154 .22952 L
s
.70162 .22975 m
.70162 .22975 L
s
.7017 .22975 m
.7017 .22975 L
s
.70177 .22928 m
.70177 .22928 L
s
.70184 .22952 m
.70184 .22952 L
s
.70191 .22999 m
.70191 .22999 L
s
.70199 .22952 m
.70199 .22952 L
s
.70206 .23022 m
.70206 .23022 L
s
.70214 .22905 m
.70214 .22905 L
s
.70221 .22905 m
.70221 .22905 L
s
.70229 .22834 m
.70229 .22834 L
s
.70236 .23022 m
.70236 .23022 L
s
.70244 .22905 m
.70244 .22905 L
s
.70251 .2307 m
.70251 .2307 L
s
.70259 .23022 m
.70259 .23022 L
s
.70266 .22975 m
.70266 .22975 L
s
.70273 .22834 m
.70273 .22834 L
s
.7028 .22693 m
.7028 .22693 L
s
.70288 .22693 m
.70288 .22693 L
s
.70295 .22529 m
.70295 .22529 L
s
.70303 .2267 m
.70303 .2267 L
s
.7031 .22459 m
.7031 .22459 L
s
.70318 .22412 m
.70318 .22412 L
s
.70325 .22364 m
.70325 .22364 L
s
.70333 .22364 m
.70333 .22364 L
s
.70341 .22412 m
.70341 .22412 L
s
.70347 .22317 m
.70347 .22317 L
s
.70355 .22271 m
.70355 .22271 L
s
.70362 .22177 m
.70362 .22177 L
s
.7037 .22294 m
.7037 .22294 L
s
.70377 .22271 m
.70377 .22271 L
s
.70385 .222 m
.70385 .222 L
s
.70392 .22317 m
.70392 .22317 L
s
.704 .22435 m
.704 .22435 L
s
.70407 .22224 m
.70407 .22224 L
s
.70415 .2213 m
.70415 .2213 L
s
.70422 .22083 m
.70422 .22083 L
s
.70429 .22177 m
.70429 .22177 L
s
.70436 .2213 m
.70436 .2213 L
s
.70444 .22177 m
.70444 .22177 L
s
.70451 .22247 m
.70451 .22247 L
s
.70459 .22294 m
.70459 .22294 L
s
.70466 .22482 m
.70466 .22482 L
s
.70474 .22294 m
.70474 .22294 L
s
.70481 .22317 m
.70481 .22317 L
s
.70488 .22506 m
.70488 .22506 L
s
.70496 .22599 m
.70496 .22599 L
s
.70504 .22459 m
.70504 .22459 L
s
.70511 .22341 m
.70511 .22341 L
s
.70518 .22294 m
.70518 .22294 L
s
.70526 .22224 m
.70526 .22224 L
s
.70533 .22224 m
.70533 .22224 L
s
.70541 .22083 m
.70541 .22083 L
s
.70548 .22177 m
.70548 .22177 L
s
.70556 .22012 m
.70556 .22012 L
s
.70563 .2213 m
.70563 .2213 L
s
.7057 .22153 m
.7057 .22153 L
s
.70578 .22177 m
.70578 .22177 L
s
.70586 .222 m
.70586 .222 L
s
.70592 .22317 m
.70592 .22317 L
s
.706 .22294 m
.706 .22294 L
s
.70607 .22247 m
.70607 .22247 L
s
.70615 .22364 m
.70615 .22364 L
s
.70622 .22341 m
.70622 .22341 L
s
.7063 .22388 m
.7063 .22388 L
s
.70638 .22083 m
.70638 .22083 L
s
.70644 .22294 m
.70644 .22294 L
s
.70652 .22271 m
.70652 .22271 L
s
.70659 .22317 m
.70659 .22317 L
s
.70667 .22224 m
.70667 .22224 L
s
.70674 .2213 m
.70674 .2213 L
s
.70682 .2206 m
.70682 .2206 L
s
.70689 .2206 m
.70689 .2206 L
s
.70697 .22106 m
.70697 .22106 L
s
.70704 .222 m
.70704 .222 L
s
.70712 .22506 m
.70712 .22506 L
s
.70719 .22341 m
.70719 .22341 L
s
.70726 .22271 m
.70726 .22271 L
s
.70733 .22271 m
.70733 .22271 L
s
.70741 .22247 m
.70741 .22247 L
s
.70749 .2213 m
.70749 .2213 L
s
.70756 .21895 m
.70756 .21895 L
s
.70763 .21871 m
.70763 .21871 L
s
.70771 .21566 m
.70771 .21566 L
s
.70778 .21801 m
.70778 .21801 L
s
.70786 .21613 m
.70786 .21613 L
s
.70794 .21778 m
.70794 .21778 L
s
.70801 .21707 m
.70801 .21707 L
s
.70808 .2166 m
.70808 .2166 L
s
.70815 .2166 m
.70815 .2166 L
s
.70823 .21636 m
.70823 .21636 L
s
.7083 .21496 m
.7083 .21496 L
s
.70838 .21472 m
.70838 .21472 L
s
.70845 .21472 m
.70845 .21472 L
s
.70853 .21496 m
.70853 .21496 L
s
.7086 .21519 m
.7086 .21519 L
s
.70868 .21449 m
.70868 .21449 L
s
.70875 .21496 m
.70875 .21496 L
s
.70883 .21496 m
.70883 .21496 L
s
.70889 .21519 m
.70889 .21519 L
s
.70897 .21754 m
.70897 .21754 L
s
.70904 .21589 m
.70904 .21589 L
s
.70912 .21636 m
.70912 .21636 L
s
.70919 .21707 m
.70919 .21707 L
s
.70927 .21731 m
.70927 .21731 L
s
.70934 .21683 m
.70934 .21683 L
s
.70942 .21754 m
.70942 .21754 L
s
.7095 .21683 m
.7095 .21683 L
s
.70957 .21731 m
.70957 .21731 L
s
.70964 .21707 m
.70964 .21707 L
s
.70971 .21754 m
.70971 .21754 L
s
.70979 .21801 m
.70979 .21801 L
s
.70986 .21707 m
.70986 .21707 L
s
.70994 .21824 m
.70994 .21824 L
s
.71001 .21918 m
.71001 .21918 L
s
.71009 .21871 m
.71009 .21871 L
s
.71016 .21801 m
.71016 .21801 L
s
.71024 .21942 m
.71024 .21942 L
s
.71031 .21918 m
.71031 .21918 L
s
.71039 .21965 m
.71039 .21965 L
s
.71046 .21918 m
.71046 .21918 L
s
.71053 .21824 m
.71053 .21824 L
s
.7106 .21895 m
.7106 .21895 L
s
.71068 .21848 m
.71068 .21848 L
s
.71075 .21918 m
.71075 .21918 L
s
.71083 .21754 m
.71083 .21754 L
s
.7109 .21754 m
.7109 .21754 L
s
.71098 .21778 m
.71098 .21778 L
s
.71105 .21942 m
.71105 .21942 L
s
.71113 .21918 m
.71113 .21918 L
s
.71121 .2213 m
.71121 .2213 L
s
.71127 .22294 m
.71127 .22294 L
s
.71135 .22153 m
.71135 .22153 L
s
.71142 .22083 m
.71142 .22083 L
s
.7115 .2213 m
.7115 .2213 L
s
.71157 .22177 m
.71157 .22177 L
s
.71165 .22106 m
.71165 .22106 L
s
.71172 .22294 m
.71172 .22294 L
s
.7118 .22271 m
.7118 .22271 L
s
.71187 .22364 m
.71187 .22364 L
s
.71195 .22247 m
.71195 .22247 L
s
.71202 .22224 m
.71202 .22224 L
s
.71209 .22106 m
.71209 .22106 L
s
.71216 .2213 m
.71216 .2213 L
s
.71224 .22177 m
.71224 .22177 L
s
.71231 .22294 m
.71231 .22294 L
s
.71239 .22364 m
.71239 .22364 L
s
.71246 .2213 m
.71246 .2213 L
s
.71254 .22294 m
.71254 .22294 L
s
.71261 .22317 m
.71261 .22317 L
s
.71268 .22341 m
.71268 .22341 L
s
.71276 .22435 m
.71276 .22435 L
s
.71284 .22599 m
.71284 .22599 L
s
.71291 .22741 m
.71291 .22741 L
s
.71298 .22788 m
.71298 .22788 L
s
.71306 .2267 m
.71306 .2267 L
s
.71313 .22482 m
.71313 .22482 L
s
.71321 .22576 m
.71321 .22576 L
s
.71328 .22435 m
.71328 .22435 L
s
.71336 .22435 m
.71336 .22435 L
s
.71343 .22529 m
.71343 .22529 L
s
.7135 .22529 m
.7135 .22529 L
s
.71358 .22529 m
.71358 .22529 L
s
.71366 .22529 m
.71366 .22529 L
s
.71372 .22388 m
.71372 .22388 L
s
.7138 .22623 m
.7138 .22623 L
s
.71387 .22693 m
.71387 .22693 L
s
.71395 .2267 m
.71395 .2267 L
s
.71402 .22576 m
.71402 .22576 L
s
.7141 .22552 m
.7141 .22552 L
s
.71418 .2267 m
.71418 .2267 L
s
.71424 .22599 m
.71424 .22599 L
s
.71432 .22693 m
.71432 .22693 L
s
.71439 .22623 m
.71439 .22623 L
s
.71447 .22599 m
.71447 .22599 L
s
.71454 .22412 m
.71454 .22412 L
s
.71462 .22459 m
.71462 .22459 L
s
.71469 .22435 m
.71469 .22435 L
s
.71477 .22388 m
.71477 .22388 L
s
.71484 .22317 m
.71484 .22317 L
s
.71492 .22271 m
.71492 .22271 L
s
.71499 .22224 m
.71499 .22224 L
s
.71506 .22247 m
.71506 .22247 L
s
.71513 .22341 m
.71513 .22341 L
s
.71521 .22177 m
.71521 .22177 L
s
.71529 .22271 m
.71529 .22271 L
s
.71536 .22224 m
.71536 .22224 L
s
.71543 .22177 m
.71543 .22177 L
s
.71551 .22153 m
.71551 .22153 L
s
.71558 .22106 m
.71558 .22106 L
s
.71566 .22177 m
.71566 .22177 L
s
.71574 .22036 m
.71574 .22036 L
s
.71581 .2206 m
.71581 .2206 L
s
.71588 .2166 m
.71588 .2166 L
s
.71595 .21778 m
.71595 .21778 L
s
.71603 .21942 m
.71603 .21942 L
s
.7161 .21942 m
.7161 .21942 L
s
.71618 .21754 m
.71618 .21754 L
s
.71625 .21848 m
.71625 .21848 L
s
.71633 .21801 m
.71633 .21801 L
s
.7164 .21683 m
.7164 .21683 L
s
.71648 .21542 m
.71648 .21542 L
s
.71655 .21542 m
.71655 .21542 L
s
.71663 .21472 m
.71663 .21472 L
s
.71669 .21284 m
.71669 .21284 L
s
.71677 .21378 m
.71677 .21378 L
s
.71684 .21284 m
.71684 .21284 L
s
.71692 .21378 m
.71692 .21378 L
s
.71699 .21284 m
.71699 .21284 L
s
.71707 .21355 m
.71707 .21355 L
s
.71714 .21402 m
.71714 .21402 L
s
.71722 .21378 m
.71722 .21378 L
s
.7173 .21613 m
.7173 .21613 L
s
.71737 .21355 m
.71737 .21355 L
s
.71744 .21378 m
.71744 .21378 L
s
.71751 .21496 m
.71751 .21496 L
s
.71759 .21613 m
.71759 .21613 L
s
.71766 .21425 m
.71766 .21425 L
s
.71774 .21378 m
.71774 .21378 L
s
.71781 .21331 m
.71781 .21331 L
s
.71789 .21214 m
.71789 .21214 L
s
.71796 .21143 m
.71796 .21143 L
s
.71804 .21026 m
.71804 .21026 L
s
.71811 .21073 m
.71811 .21073 L
s
.71819 .20885 m
.71819 .20885 L
s
.71826 .20885 m
.71826 .20885 L
s
.71833 .20744 m
.71833 .20744 L
s
.7184 .20697 m
.7184 .20697 L
s
.71848 .2065 m
.71848 .2065 L
s
.71855 .20556 m
.71855 .20556 L
s
.71863 .20674 m
.71863 .20674 L
s
.7187 .20697 m
.7187 .20697 L
s
.71878 .20791 m
.71878 .20791 L
s
.71886 .20556 m
.71886 .20556 L
s
.71893 .20674 m
.71893 .20674 L
s
.71901 .20744 m
.71901 .20744 L
s
.71907 .20814 m
.71907 .20814 L
s
.71915 .2065 m
.71915 .2065 L
s
.71922 .20791 m
.71922 .20791 L
s
.7193 .20626 m
.7193 .20626 L
s
.71937 .20768 m
.71937 .20768 L
s
.71945 .20768 m
.71945 .20768 L
s
.71952 .20861 m
.71952 .20861 L
s
.7196 .20908 m
.7196 .20908 L
s
.71967 .20744 m
.71967 .20744 L
s
.71975 .21002 m
.71975 .21002 L
s
.71982 .20979 m
.71982 .20979 L
s
.71989 .21073 m
.71989 .21073 L
s
.71996 .2105 m
.71996 .2105 L
s
.72004 .2112 m
.72004 .2112 L
s
.72011 .20979 m
.72011 .20979 L
s
.72019 .20885 m
.72019 .20885 L
s
.72026 .20955 m
.72026 .20955 L
s
.72034 .20885 m
.72034 .20885 L
s
.72041 .20932 m
.72041 .20932 L
s
.72049 .20768 m
.72049 .20768 L
s
.72057 .20932 m
.72057 .20932 L
s
.72064 .20908 m
.72064 .20908 L
s
.72071 .21026 m
.72071 .21026 L
s
.72078 .20979 m
.72078 .20979 L
s
.72086 .21073 m
.72086 .21073 L
s
.72093 .21002 m
.72093 .21002 L
s
.72101 .21002 m
.72101 .21002 L
s
.72108 .20791 m
.72108 .20791 L
s
.72116 .20744 m
.72116 .20744 L
s
.72123 .20861 m
.72123 .20861 L
s
.7213 .20791 m
.7213 .20791 L
s
.72138 .20838 m
.72138 .20838 L
s
.72146 .20885 m
.72146 .20885 L
s
.72152 .2112 m
.72152 .2112 L
s
.7216 .20814 m
.7216 .20814 L
s
.72167 .20885 m
.72167 .20885 L
s
.72175 .21026 m
.72175 .21026 L
s
.72182 .21096 m
.72182 .21096 L
s
.7219 .21026 m
.7219 .21026 L
s
.72198 .20768 m
.72198 .20768 L
s
.72204 .20885 m
.72204 .20885 L
s
.72212 .20955 m
.72212 .20955 L
s
.7222 .20908 m
.7222 .20908 L
s
.72227 .20955 m
.72227 .20955 L
s
.72234 .21167 m
.72234 .21167 L
s
.72242 .20932 m
.72242 .20932 L
s
.72249 .20932 m
.72249 .20932 L
s
.72257 .20979 m
.72257 .20979 L
s
.72264 .21143 m
.72264 .21143 L
s
.72272 .2119 m
.72272 .2119 L
s
.72279 .21073 m
.72279 .21073 L
s
.72286 .21214 m
.72286 .21214 L
s
.72293 .21331 m
.72293 .21331 L
s
.72301 .21496 m
.72301 .21496 L
s
.72309 .21519 m
.72309 .21519 L
s
.72316 .21425 m
.72316 .21425 L
s
.72323 .21472 m
.72323 .21472 L
s
.72331 .21542 m
.72331 .21542 L
s
.72338 .21472 m
.72338 .21472 L
s
.72346 .21331 m
.72346 .21331 L
s
.72354 .21331 m
.72354 .21331 L
s
.72361 .21331 m
.72361 .21331 L
s
.72368 .21378 m
.72368 .21378 L
s
.72375 .21355 m
.72375 .21355 L
s
.72383 .21237 m
.72383 .21237 L
s
.7239 .21237 m
.7239 .21237 L
s
.72398 .2119 m
.72398 .2119 L
s
.72405 .21143 m
.72405 .21143 L
s
.72413 .21378 m
.72413 .21378 L
s
.7242 .2119 m
.7242 .2119 L
s
.72428 .21261 m
.72428 .21261 L
s
.72435 .21378 m
.72435 .21378 L
s
.72443 .21378 m
.72443 .21378 L
s
.72449 .21402 m
.72449 .21402 L
s
.72457 .21307 m
.72457 .21307 L
s
.72464 .21542 m
.72464 .21542 L
s
.72472 .21566 m
.72472 .21566 L
s
.72479 .21496 m
.72479 .21496 L
s
.72487 .21307 m
.72487 .21307 L
s
.72494 .21378 m
.72494 .21378 L
s
.72502 .21378 m
.72502 .21378 L
s
.7251 .21425 m
.7251 .21425 L
s
.72517 .21425 m
.72517 .21425 L
s
.72524 .21355 m
.72524 .21355 L
s
.72531 .21519 m
.72531 .21519 L
s
.72539 .21284 m
.72539 .21284 L
s
.72546 .21378 m
.72546 .21378 L
s
.72554 .21307 m
.72554 .21307 L
s
.72561 .21237 m
.72561 .21237 L
s
.72569 .21284 m
.72569 .21284 L
s
.72576 .21237 m
.72576 .21237 L
s
.72584 .21378 m
.72584 .21378 L
s
.72591 .21331 m
.72591 .21331 L
s
.72599 .21237 m
.72599 .21237 L
s
.72606 .21096 m
.72606 .21096 L
s
.72613 .2119 m
.72613 .2119 L
s
.7262 .21096 m
.7262 .21096 L
s
.72628 .21237 m
.72628 .21237 L
s
.72635 .21214 m
.72635 .21214 L
s
.72643 .21284 m
.72643 .21284 L
s
.7265 .21237 m
.7265 .21237 L
s
.72658 .21237 m
.72658 .21237 L
s
.72666 .21167 m
.72666 .21167 L
s
.72673 .21096 m
.72673 .21096 L
s
.72681 .21096 m
.72681 .21096 L
s
.72687 .20955 m
.72687 .20955 L
s
.72695 .20885 m
.72695 .20885 L
s
.72702 .20838 m
.72702 .20838 L
s
.7271 .20908 m
.7271 .20908 L
s
.72717 .20579 m
.72717 .20579 L
s
.72725 .20674 m
.72725 .20674 L
s
.72732 .20486 m
.72732 .20486 L
s
.7274 .2065 m
.7274 .2065 L
s
.72747 .20579 m
.72747 .20579 L
s
.72755 .20579 m
.72755 .20579 L
s
.72762 .20768 m
.72762 .20768 L
s
.72769 .20814 m
.72769 .20814 L
s
.72776 .20814 m
.72776 .20814 L
s
.72784 .20674 m
.72784 .20674 L
s
.72791 .20697 m
.72791 .20697 L
s
.72799 .20486 m
.72799 .20486 L
s
.72806 .20345 m
.72806 .20345 L
s
.72814 .20392 m
.72814 .20392 L
s
.72821 .20439 m
.72821 .20439 L
s
.72829 .20626 m
.72829 .20626 L
s
.72837 .20674 m
.72837 .20674 L
s
.72844 .20908 m
.72844 .20908 L
s
.72851 .20814 m
.72851 .20814 L
s
.72858 .20861 m
.72858 .20861 L
s
.72866 .20721 m
.72866 .20721 L
s
.72873 .20885 m
.72873 .20885 L
s
.72881 .20838 m
.72881 .20838 L
s
.72888 .20885 m
.72888 .20885 L
s
.72896 .20861 m
.72896 .20861 L
s
.72903 .20932 m
.72903 .20932 L
s
.72911 .20908 m
.72911 .20908 L
s
.72918 .20979 m
.72918 .20979 L
s
.72926 .2105 m
.72926 .2105 L
s
.72932 .20814 m
.72932 .20814 L
s
.7294 .20979 m
.7294 .20979 L
s
.72947 .20838 m
.72947 .20838 L
s
.72955 .20979 m
.72955 .20979 L
s
.72962 .20955 m
.72962 .20955 L
s
.7297 .21002 m
.7297 .21002 L
s
.72978 .21143 m
.72978 .21143 L
s
.72984 .21237 m
.72984 .21237 L
s
.72992 .21307 m
.72992 .21307 L
s
.73 .21261 m
.73 .21261 L
s
.73007 .21472 m
.73007 .21472 L
s
.73014 .21402 m
.73014 .21402 L
s
.73022 .21589 m
.73022 .21589 L
s
.73029 .21707 m
.73029 .21707 L
s
.73037 .21754 m
.73037 .21754 L
s
.73044 .21683 m
.73044 .21683 L
s
.73052 .21636 m
.73052 .21636 L
s
.73059 .21895 m
.73059 .21895 L
s
.73066 .2213 m
.73066 .2213 L
s
.73074 .22341 m
.73074 .22341 L
s
.73082 .22341 m
.73082 .22341 L
s
.73089 .22341 m
.73089 .22341 L
s
.73096 .22177 m
.73096 .22177 L
s
.73103 .22294 m
.73103 .22294 L
s
.73111 .22083 m
.73111 .22083 L
s
.73118 .22106 m
.73118 .22106 L
s
.73126 .22106 m
.73126 .22106 L
s
.73134 .22083 m
.73134 .22083 L
s
.73141 .21989 m
.73141 .21989 L
s
.73148 .21989 m
.73148 .21989 L
s
.73155 .21871 m
.73155 .21871 L
s
.73163 .21801 m
.73163 .21801 L
s
.7317 .21778 m
.7317 .21778 L
s
.73178 .21683 m
.73178 .21683 L
s
.73185 .21731 m
.73185 .21731 L
s
.73193 .21683 m
.73193 .21683 L
s
.732 .21801 m
.732 .21801 L
s
.73208 .21801 m
.73208 .21801 L
s
.73215 .21801 m
.73215 .21801 L
s
.73223 .21871 m
.73223 .21871 L
s
.73229 .21589 m
.73229 .21589 L
s
.73237 .21613 m
.73237 .21613 L
s
.73245 .21449 m
.73245 .21449 L
s
.73252 .21496 m
.73252 .21496 L
s
.73259 .21284 m
.73259 .21284 L
s
.73267 .21449 m
.73267 .21449 L
s
.73274 .21331 m
.73274 .21331 L
s
.73282 .21331 m
.73282 .21331 L
s
.7329 .21425 m
.7329 .21425 L
s
.73297 .21566 m
.73297 .21566 L
s
.73304 .21449 m
.73304 .21449 L
s
.73311 .21542 m
.73311 .21542 L
s
.73319 .21683 m
.73319 .21683 L
s
.73326 .21731 m
.73326 .21731 L
s
.73334 .21918 m
.73334 .21918 L
s
.73341 .21801 m
.73341 .21801 L
s
.73349 .21871 m
.73349 .21871 L
s
.73356 .21707 m
.73356 .21707 L
s
.73364 .21801 m
.73364 .21801 L
s
.73371 .21895 m
.73371 .21895 L
s
.73379 .21918 m
.73379 .21918 L
s
.73386 .21895 m
.73386 .21895 L
s
.73393 .21989 m
.73393 .21989 L
s
.734 .222 m
.734 .222 L
s
.73408 .22083 m
.73408 .22083 L
s
.73415 .22083 m
.73415 .22083 L
s
.73423 .22012 m
.73423 .22012 L
s
.7343 .22083 m
.7343 .22083 L
s
.73438 .21918 m
.73438 .21918 L
s
.73446 .22036 m
.73446 .22036 L
s
.73453 .21942 m
.73453 .21942 L
s
.73461 .22036 m
.73461 .22036 L
s
.73467 .21895 m
.73467 .21895 L
s
.73475 .21918 m
.73475 .21918 L
s
.73482 .21871 m
.73482 .21871 L
s
.7349 .21636 m
.7349 .21636 L
s
.73497 .21801 m
.73497 .21801 L
s
.73505 .2166 m
.73505 .2166 L
s
.73512 .22012 m
.73512 .22012 L
s
.7352 .21989 m
.7352 .21989 L
s
.73527 .22106 m
.73527 .22106 L
s
.73535 .22036 m
.73535 .22036 L
s
.73542 .22106 m
.73542 .22106 L
s
.73549 .22036 m
.73549 .22036 L
s
.73556 .22036 m
.73556 .22036 L
s
.73564 .22083 m
.73564 .22083 L
s
.73571 .22106 m
.73571 .22106 L
s
.73579 .22271 m
.73579 .22271 L
s
.73586 .22294 m
.73586 .22294 L
s
.73594 .22435 m
.73594 .22435 L
s
.73602 .22364 m
.73602 .22364 L
s
.73609 .22341 m
.73609 .22341 L
s
.73617 .22341 m
.73617 .22341 L
s
.73624 .22388 m
.73624 .22388 L
s
.73631 .22317 m
.73631 .22317 L
s
.73638 .22224 m
.73638 .22224 L
s
.73646 .22271 m
.73646 .22271 L
s
.73653 .22317 m
.73653 .22317 L
s
.73661 .22412 m
.73661 .22412 L
s
.73668 .222 m
.73668 .222 L
s
.73676 .22388 m
.73676 .22388 L
s
.73683 .22412 m
.73683 .22412 L
s
.73691 .22459 m
.73691 .22459 L
s
.73698 .22412 m
.73698 .22412 L
s
.73706 .22388 m
.73706 .22388 L
s
.73712 .22529 m
.73712 .22529 L
s
.7372 .22341 m
.7372 .22341 L
s
.73727 .22623 m
.73727 .22623 L
s
.73735 .22623 m
.73735 .22623 L
s
.73742 .22599 m
.73742 .22599 L
s
.7375 .22576 m
.7375 .22576 L
s
.73758 .22646 m
.73758 .22646 L
s
.73765 .22599 m
.73765 .22599 L
s
.73773 .22834 m
.73773 .22834 L
s
.7378 .22881 m
.7378 .22881 L
s
.73787 .22764 m
.73787 .22764 L
s
.73794 .22928 m
.73794 .22928 L
s
.73802 .22881 m
.73802 .22881 L
s
.73809 .22905 m
.73809 .22905 L
s
.73817 .22717 m
.73817 .22717 L
s
.73824 .22811 m
.73824 .22811 L
s
.73832 .22834 m
.73832 .22834 L
s
.73839 .22975 m
.73839 .22975 L
s
.73846 .22834 m
.73846 .22834 L
s
.73854 .22975 m
.73854 .22975 L
s
.73862 .23022 m
.73862 .23022 L
s
.73869 .23022 m
.73869 .23022 L
s
.73876 .23117 m
.73876 .23117 L
s
.73883 .23022 m
.73883 .23022 L
s
.73891 .23045 m
.73891 .23045 L
s
.73898 .22858 m
.73898 .22858 L
s
.73906 .22905 m
.73906 .22905 L
s
.73914 .22905 m
.73914 .22905 L
s
.73921 .23022 m
.73921 .23022 L
s
.73928 .22975 m
.73928 .22975 L
s
.73936 .22952 m
.73936 .22952 L
s
.73944 .2314 m
.73944 .2314 L
s
.73951 .2307 m
.73951 .2307 L
s
.73958 .2307 m
.73958 .2307 L
s
.73965 .22975 m
.73965 .22975 L
s
.73973 .23093 m
.73973 .23093 L
s
.7398 .23022 m
.7398 .23022 L
s
.73988 .23187 m
.73988 .23187 L
s
.73995 .23163 m
.73995 .23163 L
s
.74003 .23281 m
.74003 .23281 L
s
.74009 .23304 m
.74009 .23304 L
s
.74017 .23374 m
.74017 .23374 L
s
.74025 .23563 m
.74025 .23563 L
s
.74032 .23656 m
.74032 .23656 L
s
.74039 .23727 m
.74039 .23727 L
s
.74047 .23609 m
.74047 .23609 L
s
.74054 .23751 m
.74054 .23751 L
s
.74062 .23609 m
.74062 .23609 L
s
.7407 .23656 m
.7407 .23656 L
s
.74077 .23586 m
.74077 .23586 L
s
.74084 .23751 m
.74084 .23751 L
s
.74091 .23727 m
.74091 .23727 L
s
.74099 .2368 m
.74099 .2368 L
s
.74107 .23492 m
.74107 .23492 L
s
.74114 .23374 m
.74114 .23374 L
s
.74121 .23492 m
.74121 .23492 L
s
.74129 .23586 m
.74129 .23586 L
s
.74136 .23774 m
.74136 .23774 L
s
.74144 .23633 m
.74144 .23633 L
s
.74151 .23774 m
.74151 .23774 L
s
.74159 .23516 m
.74159 .23516 L
s
.74166 .23539 m
.74166 .23539 L
s
.74173 .23563 m
.74173 .23563 L
s
.7418 .23633 m
.7418 .23633 L
s
.74188 .23656 m
.74188 .23656 L
s
.74195 .23469 m
.74195 .23469 L
s
.74203 .23633 m
.74203 .23633 L
s
.7421 .23563 m
.7421 .23563 L
s
.74218 .23821 m
.74218 .23821 L
s
.74226 .23492 m
.74226 .23492 L
s
.74233 .23492 m
.74233 .23492 L
s
.74241 .23539 m
.74241 .23539 L
s
.74248 .23586 m
.74248 .23586 L
s
.74255 .23539 m
.74255 .23539 L
s
.74262 .23374 m
.74262 .23374 L
s
.7427 .23351 m
.7427 .23351 L
s
.74277 .23304 m
.74277 .23304 L
s
.74285 .23351 m
.74285 .23351 L
s
.74292 .23327 m
.74292 .23327 L
s
.743 .23492 m
.743 .23492 L
s
.74307 .23304 m
.74307 .23304 L
s
.74315 .23327 m
.74315 .23327 L
s
.74322 .23281 m
.74322 .23281 L
s
.74329 .23398 m
.74329 .23398 L
s
.74336 .23327 m
.74336 .23327 L
s
.74344 .23117 m
.74344 .23117 L
s
.74351 .2307 m
.74351 .2307 L
s
.74359 .23045 m
.74359 .23045 L
s
.74366 .23022 m
.74366 .23022 L
s
.74374 .22999 m
.74374 .22999 L
s
.74382 .22952 m
.74382 .22952 L
s
.74389 .22928 m
.74389 .22928 L
s
.74397 .22975 m
.74397 .22975 L
s
.74404 .22717 m
.74404 .22717 L
s
.74411 .22881 m
.74411 .22881 L
s
.74418 .22928 m
.74418 .22928 L
s
.74426 .22834 m
.74426 .22834 L
s
.74433 .22858 m
.74433 .22858 L
s
.74441 .22693 m
.74441 .22693 L
s
.74448 .22741 m
.74448 .22741 L
s
.74456 .22623 m
.74456 .22623 L
s
.74463 .22576 m
.74463 .22576 L
s
.74471 .22693 m
.74471 .22693 L
s
.74478 .22646 m
.74478 .22646 L
s
.74486 .22717 m
.74486 .22717 L
s
.74492 .22646 m
.74492 .22646 L
s
.745 .22646 m
.745 .22646 L
s
.74507 .22599 m
.74507 .22599 L
s
.74515 .22529 m
.74515 .22529 L
s
.74522 .22271 m
.74522 .22271 L
s
.7453 .22341 m
.7453 .22341 L
s
.74538 .22247 m
.74538 .22247 L
s
.74545 .22412 m
.74545 .22412 L
s
.74553 .22271 m
.74553 .22271 L
s
.7456 .22317 m
.7456 .22317 L
s
.74567 .2213 m
.74567 .2213 L
s
.74574 .22153 m
.74574 .22153 L
s
.74582 .2206 m
.74582 .2206 L
s
.74589 .22083 m
.74589 .22083 L
s
.74597 .22294 m
.74597 .22294 L
s
.74604 .22294 m
.74604 .22294 L
s
.74612 .22294 m
.74612 .22294 L
s
.74619 .22388 m
.74619 .22388 L
s
.74627 .22364 m
.74627 .22364 L
s
.74634 .22247 m
.74634 .22247 L
s
.74642 .22388 m
.74642 .22388 L
s
.74649 .22294 m
.74649 .22294 L
s
.74656 .22529 m
.74656 .22529 L
s
.74663 .22294 m
.74663 .22294 L
s
.74671 .22177 m
.74671 .22177 L
s
.74678 .22224 m
.74678 .22224 L
s
.74686 .22247 m
.74686 .22247 L
s
.74694 .22341 m
.74694 .22341 L
s
.74701 .22294 m
.74701 .22294 L
s
.74708 .22271 m
.74708 .22271 L
s
.74716 .22341 m
.74716 .22341 L
s
.74724 .22412 m
.74724 .22412 L
s
.74731 .22506 m
.74731 .22506 L
s
.74738 .22552 m
.74738 .22552 L
s
.74745 .22741 m
.74745 .22741 L
s
.74753 .22693 m
.74753 .22693 L
s
.7476 .22741 m
.7476 .22741 L
s
.74768 .22529 m
.74768 .22529 L
s
.74775 .22506 m
.74775 .22506 L
s
.74783 .22459 m
.74783 .22459 L
s
.7479 .22599 m
.7479 .22599 L
s
.74798 .22294 m
.74798 .22294 L
s
.74805 .22459 m
.74805 .22459 L
s
.74812 .22294 m
.74812 .22294 L
s
.74819 .22412 m
.74819 .22412 L
s
.74827 .22459 m
.74827 .22459 L
s
.74834 .22364 m
.74834 .22364 L
s
.74842 .22341 m
.74842 .22341 L
s
.7485 .22153 m
.7485 .22153 L
s
.74857 .22224 m
.74857 .22224 L
s
.74864 .2213 m
.74864 .2213 L
s
.74871 .22271 m
.74871 .22271 L
s
.74879 .22388 m
.74879 .22388 L
s
.74887 .22459 m
.74887 .22459 L
s
.74894 .22224 m
.74894 .22224 L
s
.74901 .21989 m
.74901 .21989 L
s
.74909 .21871 m
.74909 .21871 L
s
.74916 .21778 m
.74916 .21778 L
s
.74924 .21801 m
.74924 .21801 L
s
.74931 .21731 m
.74931 .21731 L
s
.74939 .21801 m
.74939 .21801 L
s
.74946 .21566 m
.74946 .21566 L
s
.74953 .2166 m
.74953 .2166 L
s
.74961 .21566 m
.74961 .21566 L
s
.74969 .21613 m
.74969 .21613 L
s
.74975 .2166 m
.74975 .2166 L
s
.74983 .2166 m
.74983 .2166 L
s
.7499 .21707 m
.7499 .21707 L
s
.74998 .21589 m
.74998 .21589 L
s
.75006 .2166 m
.75006 .2166 L
s
.75013 .21613 m
.75013 .21613 L
s
.75021 .21754 m
.75021 .21754 L
s
.75028 .21824 m
.75028 .21824 L
s
.75035 .21848 m
.75035 .21848 L
s
.75042 .21895 m
.75042 .21895 L
s
.7505 .21871 m
.7505 .21871 L
s
.75057 .21707 m
.75057 .21707 L
s
.75065 .21731 m
.75065 .21731 L
s
.75072 .21871 m
.75072 .21871 L
s
.7508 .21848 m
.7508 .21848 L
s
.75087 .21989 m
.75087 .21989 L
s
.75095 .21895 m
.75095 .21895 L
s
.75102 .22083 m
.75102 .22083 L
s
.75109 .22083 m
.75109 .22083 L
s
.75116 .22224 m
.75116 .22224 L
s
.75124 .22083 m
.75124 .22083 L
s
.75132 .22271 m
.75132 .22271 L
s
.75139 .22317 m
.75139 .22317 L
s
.75146 .22552 m
.75146 .22552 L
s
.75154 .22552 m
.75154 .22552 L
s
.75162 .22552 m
.75162 .22552 L
s
.75169 .22646 m
.75169 .22646 L
s
.75177 .22506 m
.75177 .22506 L
s
.75184 .22599 m
.75184 .22599 L
s
.75191 .22693 m
.75191 .22693 L
s
.75198 .22858 m
.75198 .22858 L
s
.75206 .22788 m
.75206 .22788 L
s
.75213 .22834 m
.75213 .22834 L
s
.75221 .22811 m
.75221 .22811 L
s
.75228 .22764 m
.75228 .22764 L
s
.75236 .22693 m
.75236 .22693 L
s
.75243 .2267 m
.75243 .2267 L
s
.75251 .22881 m
.75251 .22881 L
s
.75258 .22764 m
.75258 .22764 L
s
.75266 .22717 m
.75266 .22717 L
s
.75272 .22717 m
.75272 .22717 L
s
.7528 .22858 m
.7528 .22858 L
s
.75287 .22788 m
.75287 .22788 L
s
.75295 .22881 m
.75295 .22881 L
s
.75302 .22905 m
.75302 .22905 L
s
.7531 .22952 m
.7531 .22952 L
s
.75318 .23022 m
.75318 .23022 L
s
.75325 .23022 m
.75325 .23022 L
s
.75333 .22999 m
.75333 .22999 L
s
.7534 .23117 m
.7534 .23117 L
s
.75347 .23163 m
.75347 .23163 L
s
.75354 .23022 m
.75354 .23022 L
s
.75362 .22999 m
.75362 .22999 L
s
.75369 .22928 m
.75369 .22928 L
s
.75377 .22928 m
.75377 .22928 L
s
.75384 .22975 m
.75384 .22975 L
s
.75392 .22788 m
.75392 .22788 L
s
.75399 .22788 m
.75399 .22788 L
s
.75407 .22741 m
.75407 .22741 L
s
.75414 .22764 m
.75414 .22764 L
s
.75422 .22576 m
.75422 .22576 L
s
.75429 .22764 m
.75429 .22764 L
s
.75436 .22834 m
.75436 .22834 L
s
.75443 .22881 m
.75443 .22881 L
s
.75451 .22881 m
.75451 .22881 L
s
.75458 .22764 m
.75458 .22764 L
s
.75466 .22764 m
.75466 .22764 L
s
.75474 .22693 m
.75474 .22693 L
s
.75481 .22881 m
.75481 .22881 L
s
.75489 .22741 m
.75489 .22741 L
s
.75496 .22881 m
.75496 .22881 L
s
.75504 .22811 m
.75504 .22811 L
s
.75511 .23022 m
.75511 .23022 L
s
.75518 .22999 m
.75518 .22999 L
s
.75525 .22881 m
.75525 .22881 L
s
.75533 .22975 m
.75533 .22975 L
s
.7554 .22811 m
.7554 .22811 L
s
.75548 .22811 m
.75548 .22811 L
s
.75555 .22552 m
.75555 .22552 L
s
.75563 .22693 m
.75563 .22693 L
s
.7557 .22788 m
.7557 .22788 L
s
.75578 .22881 m
.75578 .22881 L
s
.75585 .23022 m
.75585 .23022 L
s
.75592 .2314 m
.75592 .2314 L
s
.75599 .22905 m
.75599 .22905 L
s
.75607 .22975 m
.75607 .22975 L
s
.75614 .22881 m
.75614 .22881 L
s
.75622 .22788 m
.75622 .22788 L
s
.7563 .22834 m
.7563 .22834 L
s
.75637 .22788 m
.75637 .22788 L
s
.75644 .22858 m
.75644 .22858 L
s
.75652 .22717 m
.75652 .22717 L
s
.7566 .22741 m
.7566 .22741 L
s
.75667 .22741 m
.75667 .22741 L
s
.75674 .22858 m
.75674 .22858 L
s
.75681 .22693 m
.75681 .22693 L
s
.75689 .22717 m
.75689 .22717 L
s
.75696 .22717 m
.75696 .22717 L
s
.75704 .22788 m
.75704 .22788 L
s
.75711 .22834 m
.75711 .22834 L
s
.75719 .22717 m
.75719 .22717 L
s
.75726 .22834 m
.75726 .22834 L
s
.75733 .22928 m
.75733 .22928 L
s
.75741 .2314 m
.75741 .2314 L
s
.75749 .23045 m
.75749 .23045 L
s
.75755 .22999 m
.75755 .22999 L
s
.75763 .22881 m
.75763 .22881 L
s
.7577 .22834 m
.7577 .22834 L
s
.75778 .22952 m
.75778 .22952 L
s
.75786 .22834 m
.75786 .22834 L
s
.75793 .22834 m
.75793 .22834 L
s
.75801 .22858 m
.75801 .22858 L
s
.75808 .22905 m
.75808 .22905 L
s
.75815 .23045 m
.75815 .23045 L
s
.75823 .23022 m
.75823 .23022 L
s
.7583 .22999 m
.7583 .22999 L
s
.75837 .2321 m
.75837 .2321 L
s
.75845 .2321 m
.75845 .2321 L
s
.75852 .2307 m
.75852 .2307 L
s
.7586 .22999 m
.7586 .22999 L
s
.75867 .22905 m
.75867 .22905 L
s
.75875 .22928 m
.75875 .22928 L
s
.75882 .22928 m
.75882 .22928 L
s
.75889 .22905 m
.75889 .22905 L
s
.75896 .22881 m
.75896 .22881 L
s
.75904 .22999 m
.75904 .22999 L
s
.75912 .22717 m
.75912 .22717 L
s
.75919 .22693 m
.75919 .22693 L
s
.75926 .2267 m
.75926 .2267 L
s
.75934 .22646 m
.75934 .22646 L
s
.75942 .22623 m
.75942 .22623 L
s
.75949 .22552 m
.75949 .22552 L
s
.75957 .22599 m
.75957 .22599 L
s
.75964 .22529 m
.75964 .22529 L
s
.75971 .2267 m
.75971 .2267 L
s
.75978 .22599 m
.75978 .22599 L
s
.75986 .22764 m
.75986 .22764 L
s
.75994 .22741 m
.75994 .22741 L
s
.76001 .22928 m
.76001 .22928 L
s
.76008 .22881 m
.76008 .22881 L
s
.76016 .22834 m
.76016 .22834 L
s
.76023 .22928 m
.76023 .22928 L
s
.76031 .22952 m
.76031 .22952 L
s
.76038 .23093 m
.76038 .23093 L
s
.76046 .22999 m
.76046 .22999 L
s
.76052 .23045 m
.76052 .23045 L
s
.7606 .23093 m
.7606 .23093 L
s
.76067 .23117 m
.76067 .23117 L
s
.76075 .23022 m
.76075 .23022 L
s
.76082 .23093 m
.76082 .23093 L
s
.7609 .23022 m
.7609 .23022 L
s
.76098 .22975 m
.76098 .22975 L
s
.76105 .23093 m
.76105 .23093 L
s
.76113 .2321 m
.76113 .2321 L
s
.7612 .23327 m
.7612 .23327 L
s
.76127 .23422 m
.76127 .23422 L
s
.76134 .23422 m
.76134 .23422 L
s
.76142 .23374 m
.76142 .23374 L
s
.76149 .23492 m
.76149 .23492 L
s
.76157 .23351 m
.76157 .23351 L
s
.76164 .23327 m
.76164 .23327 L
s
.76172 .23492 m
.76172 .23492 L
s
.76179 .23374 m
.76179 .23374 L
s
.76187 .23492 m
.76187 .23492 L
s
.76194 .23609 m
.76194 .23609 L
s
.76202 .23633 m
.76202 .23633 L
s
.76209 .23445 m
.76209 .23445 L
s
.76216 .23445 m
.76216 .23445 L
s
.76223 .23093 m
.76223 .23093 L
s
.76231 .2314 m
.76231 .2314 L
s
.76238 .2307 m
.76238 .2307 L
s
.76246 .23093 m
.76246 .23093 L
s
.76254 .2307 m
.76254 .2307 L
s
.76261 .2307 m
.76261 .2307 L
s
.76269 .23187 m
.76269 .23187 L
s
.76276 .23022 m
.76276 .23022 L
s
.76284 .23022 m
.76284 .23022 L
s
.76291 .22788 m
.76291 .22788 L
s
.76298 .22623 m
.76298 .22623 L
s
.76305 .22788 m
.76305 .22788 L
s
.76313 .22764 m
.76313 .22764 L
s
.7632 .2267 m
.7632 .2267 L
s
.76328 .22599 m
.76328 .22599 L
s
.76335 .22506 m
.76335 .22506 L
s
.76343 .22506 m
.76343 .22506 L
s
.7635 .22552 m
.7635 .22552 L
s
.76358 .22506 m
.76358 .22506 L
s
.76365 .22576 m
.76365 .22576 L
s
.76372 .22599 m
.76372 .22599 L
s
.76379 .2267 m
.76379 .2267 L
s
.76387 .22623 m
.76387 .22623 L
s
.76394 .22764 m
.76394 .22764 L
s
.76402 .2267 m
.76402 .2267 L
s
.7641 .22552 m
.7641 .22552 L
s
.76417 .22482 m
.76417 .22482 L
s
.76424 .22364 m
.76424 .22364 L
s
.76432 .22388 m
.76432 .22388 L
s
.7644 .22247 m
.7644 .22247 L
s
.76447 .22247 m
.76447 .22247 L
s
.76454 .22177 m
.76454 .22177 L
s
.76461 .22177 m
.76461 .22177 L
s
.76469 .22036 m
.76469 .22036 L
s
.76476 .22106 m
.76476 .22106 L
s
.76484 .22012 m
.76484 .22012 L
s
.76491 .21895 m
.76491 .21895 L
s
.76499 .22153 m
.76499 .22153 L
s
.76506 .22177 m
.76506 .22177 L
s
.76514 .222 m
.76514 .222 L
s
.76521 .22153 m
.76521 .22153 L
s
.76529 .22106 m
.76529 .22106 L
s
.76535 .21965 m
.76535 .21965 L
s
.76543 .21801 m
.76543 .21801 L
s
.7655 .21683 m
.7655 .21683 L
s
.76558 .21707 m
.76558 .21707 L
s
.76566 .21636 m
.76566 .21636 L
s
.76573 .21754 m
.76573 .21754 L
s
.76581 .21613 m
.76581 .21613 L
s
.76588 .21589 m
.76588 .21589 L
s
.76595 .21683 m
.76595 .21683 L
s
.76603 .21707 m
.76603 .21707 L
s
.7661 .21895 m
.7661 .21895 L
s
.76617 .22012 m
.76617 .22012 L
s
.76625 .22153 m
.76625 .22153 L
s
.76632 .2206 m
.76632 .2206 L
s
.7664 .22271 m
.7664 .22271 L
s
.76647 .22224 m
.76647 .22224 L
s
.76655 .22224 m
.76655 .22224 L
s
.76662 .22247 m
.76662 .22247 L
s
.76669 .22224 m
.76669 .22224 L
s
.76677 .22412 m
.76677 .22412 L
s
.76685 .22412 m
.76685 .22412 L
s
.76692 .22506 m
.76692 .22506 L
s
.76699 .22247 m
.76699 .22247 L
s
.76706 .22388 m
.76706 .22388 L
s
.76714 .22271 m
.76714 .22271 L
s
.76722 .22224 m
.76722 .22224 L
s
.76729 .2213 m
.76729 .2213 L
s
.76737 .2213 m
.76737 .2213 L
s
.76744 .21848 m
.76744 .21848 L
s
.76751 .21848 m
.76751 .21848 L
s
.76758 .21871 m
.76758 .21871 L
s
.76766 .21824 m
.76766 .21824 L
s
.76774 .21918 m
.76774 .21918 L
s
.76781 .21918 m
.76781 .21918 L
s
.76788 .22083 m
.76788 .22083 L
s
.76796 .22036 m
.76796 .22036 L
s
.76803 .22036 m
.76803 .22036 L
s
.76811 .22153 m
.76811 .22153 L
s
.76818 .22271 m
.76818 .22271 L
s
.76826 .22317 m
.76826 .22317 L
s
.76832 .22271 m
.76832 .22271 L
s
.7684 .22364 m
.7684 .22364 L
s
.76847 .22271 m
.76847 .22271 L
s
.76855 .22482 m
.76855 .22482 L
s
.76862 .22341 m
.76862 .22341 L
s
.7687 .22317 m
.7687 .22317 L
s
.76878 .22153 m
.76878 .22153 L
s
.76885 .222 m
.76885 .222 L
s
.76893 .22177 m
.76893 .22177 L
s
.769 .2213 m
.769 .2213 L
s
.76907 .22224 m
.76907 .22224 L
s
.76914 .2213 m
.76914 .2213 L
s
.76922 .22177 m
.76922 .22177 L
s
.76929 .22224 m
.76929 .22224 L
s
.76937 .22271 m
.76937 .22271 L
s
.76944 .22177 m
.76944 .22177 L
s
.76952 .22271 m
.76952 .22271 L
s
.76959 .2213 m
.76959 .2213 L
s
.76967 .222 m
.76967 .222 L
s
.76974 .222 m
.76974 .222 L
s
.76982 .2213 m
.76982 .2213 L
s
.76989 .22083 m
.76989 .22083 L
s
.76996 .21918 m
.76996 .21918 L
s
.77003 .21942 m
.77003 .21942 L
s
.77011 .21778 m
.77011 .21778 L
s
.77018 .21918 m
.77018 .21918 L
s
.77026 .21778 m
.77026 .21778 L
s
.77034 .21895 m
.77034 .21895 L
s
.77041 .21848 m
.77041 .21848 L
s
.77049 .21707 m
.77049 .21707 L
s
.77056 .21754 m
.77056 .21754 L
s
.77064 .21824 m
.77064 .21824 L
s
.77071 .21871 m
.77071 .21871 L
s
.77078 .21848 m
.77078 .21848 L
s
.77085 .21989 m
.77085 .21989 L
s
.77093 .21848 m
.77093 .21848 L
s
.771 .21895 m
.771 .21895 L
s
.77108 .2166 m
.77108 .2166 L
s
.77115 .21754 m
.77115 .21754 L
s
.77123 .21778 m
.77123 .21778 L
s
.7713 .21848 m
.7713 .21848 L
s
.77138 .21848 m
.77138 .21848 L
s
.77145 .21801 m
.77145 .21801 L
s
.77152 .21589 m
.77152 .21589 L
s
.77159 .21425 m
.77159 .21425 L
s
.77167 .21589 m
.77167 .21589 L
s
.77174 .21496 m
.77174 .21496 L
s
.77182 .21731 m
.77182 .21731 L
s
.7719 .21824 m
.7719 .21824 L
s
.77197 .21918 m
.77197 .21918 L
s
.77205 .21801 m
.77205 .21801 L
s
.77212 .21754 m
.77212 .21754 L
s
.7722 .21801 m
.7722 .21801 L
s
.77227 .21801 m
.77227 .21801 L
s
.77234 .21636 m
.77234 .21636 L
s
.77241 .21636 m
.77241 .21636 L
s
.77249 .21636 m
.77249 .21636 L
s
.77256 .21214 m
.77256 .21214 L
s
.77264 .21402 m
.77264 .21402 L
s
.77271 .21402 m
.77271 .21402 L
s
.77279 .21519 m
.77279 .21519 L
s
.77286 .21519 m
.77286 .21519 L
s
.77294 .21425 m
.77294 .21425 L
s
.77301 .21378 m
.77301 .21378 L
s
.77309 .21237 m
.77309 .21237 L
s
.77315 .21284 m
.77315 .21284 L
s
.77323 .2119 m
.77323 .2119 L
s
.7733 .21073 m
.7733 .21073 L
s
.77338 .20908 m
.77338 .20908 L
s
.77346 .21026 m
.77346 .21026 L
s
.77353 .20932 m
.77353 .20932 L
s
.77361 .2119 m
.77361 .2119 L
s
.77368 .21237 m
.77368 .21237 L
s
.77375 .21331 m
.77375 .21331 L
s
.77383 .21331 m
.77383 .21331 L
s
.77391 .21214 m
.77391 .21214 L
s
.77397 .2119 m
.77397 .2119 L
s
.77405 .20955 m
.77405 .20955 L
s
.77412 .21167 m
.77412 .21167 L
s
.7742 .2119 m
.7742 .2119 L
s
.77427 .21307 m
.77427 .21307 L
s
.77435 .21331 m
.77435 .21331 L
s
.77442 .21355 m
.77442 .21355 L
s
.77449 .21378 m
.77449 .21378 L
s
.77457 .21355 m
.77457 .21355 L
s
.77465 .21472 m
.77465 .21472 L
s
.77472 .21472 m
.77472 .21472 L
s
.77479 .21402 m
.77479 .21402 L
s
.77486 .21237 m
.77486 .21237 L
s
.77494 .21143 m
.77494 .21143 L
s
.77502 .21002 m
.77502 .21002 L
s
.77509 .21143 m
.77509 .21143 L
s
.77517 .21002 m
.77517 .21002 L
s
.77524 .21026 m
.77524 .21026 L
s
.77531 .2105 m
.77531 .2105 L
s
.77538 .2119 m
.77538 .2119 L
s
.77546 .2119 m
.77546 .2119 L
s
.77554 .21284 m
.77554 .21284 L
s
.77561 .21307 m
.77561 .21307 L
s
.77568 .2119 m
.77568 .2119 L
s
.77576 .21307 m
.77576 .21307 L
s
.77583 .21284 m
.77583 .21284 L
s
.77591 .21472 m
.77591 .21472 L
s
.77598 .21613 m
.77598 .21613 L
s
.77606 .21519 m
.77606 .21519 L
s
.77612 .21496 m
.77612 .21496 L
s
.7762 .21519 m
.7762 .21519 L
s
.77628 .21636 m
.77628 .21636 L
s
.77635 .21683 m
.77635 .21683 L
s
.77642 .21707 m
.77642 .21707 L
s
.7765 .21472 m
.7765 .21472 L
s
.77658 .21496 m
.77658 .21496 L
s
.77665 .21307 m
.77665 .21307 L
s
.77673 .21378 m
.77673 .21378 L
s
.7768 .21214 m
.7768 .21214 L
s
.77688 .21214 m
.77688 .21214 L
s
.77694 .21143 m
.77694 .21143 L
s
.77702 .21096 m
.77702 .21096 L
s
.7771 .21026 m
.7771 .21026 L
s
.77717 .2112 m
.77717 .2112 L
s
.77724 .21261 m
.77724 .21261 L
s
.77732 .2119 m
.77732 .2119 L
s
.77739 .21143 m
.77739 .21143 L
s
.77747 .21002 m
.77747 .21002 L
s
.77754 .2105 m
.77754 .2105 L
s
.77762 .21002 m
.77762 .21002 L
s
.77769 .20861 m
.77769 .20861 L
s
.77776 .20838 m
.77776 .20838 L
s
.77783 .20791 m
.77783 .20791 L
s
.77791 .20861 m
.77791 .20861 L
s
.77798 .20791 m
.77798 .20791 L
s
.77806 .20861 m
.77806 .20861 L
s
.77814 .20838 m
.77814 .20838 L
s
.77821 .21026 m
.77821 .21026 L
s
.77829 .20838 m
.77829 .20838 L
s
.77836 .20979 m
.77836 .20979 L
s
.77844 .20955 m
.77844 .20955 L
s
.77851 .2112 m
.77851 .2112 L
s
.77858 .21026 m
.77858 .21026 L
s
.77865 .20955 m
.77865 .20955 L
s
.77873 .2105 m
.77873 .2105 L
s
.7788 .21143 m
.7788 .21143 L
s
.77888 .21331 m
.77888 .21331 L
s
.77895 .21214 m
.77895 .21214 L
s
.77903 .21284 m
.77903 .21284 L
s
.7791 .21307 m
.7791 .21307 L
s
.77918 .21284 m
.77918 .21284 L
s
.77925 .21284 m
.77925 .21284 L
s
.77932 .21261 m
.77932 .21261 L
s
.77939 .21378 m
.77939 .21378 L
s
.77947 .21402 m
.77947 .21402 L
s
.77954 .21402 m
.77954 .21402 L
s
.77962 .21214 m
.77962 .21214 L
s
.7797 .2119 m
.7797 .2119 L
s
.77977 .21167 m
.77977 .21167 L
s
.77985 .21307 m
.77985 .21307 L
s
.77992 .21284 m
.77992 .21284 L
s
.78 .2119 m
.78 .2119 L
s
.78007 .21167 m
.78007 .21167 L
s
.78014 .21307 m
.78014 .21307 L
s
.78021 .21261 m
.78021 .21261 L
s
.78029 .21261 m
.78029 .21261 L
s
.78036 .21378 m
.78036 .21378 L
s
.78044 .21378 m
.78044 .21378 L
s
.78051 .21378 m
.78051 .21378 L
s
.78059 .21167 m
.78059 .21167 L
s
.78066 .21261 m
.78066 .21261 L
s
.78074 .21307 m
.78074 .21307 L
s
.78081 .21096 m
.78081 .21096 L
s
.78089 .20979 m
.78089 .20979 L
s
.78095 .21096 m
.78095 .21096 L
s
.78103 .2105 m
.78103 .2105 L
s
.7811 .21002 m
.7811 .21002 L
s
.78118 .2105 m
.78118 .2105 L
s
.78126 .21096 m
.78126 .21096 L
s
.78133 .21143 m
.78133 .21143 L
s
.78141 .21002 m
.78141 .21002 L
s
.78148 .20979 m
.78148 .20979 L
s
.78156 .2105 m
.78156 .2105 L
s
.78163 .20861 m
.78163 .20861 L
s
.78171 .20721 m
.78171 .20721 L
s
.78177 .20768 m
.78177 .20768 L
s
.78185 .20791 m
.78185 .20791 L
s
.78192 .20861 m
.78192 .20861 L
s
.782 .21002 m
.782 .21002 L
s
.78207 .2105 m
.78207 .2105 L
s
.78215 .21026 m
.78215 .21026 L
s
.78222 .20885 m
.78222 .20885 L
s
.78229 .20955 m
.78229 .20955 L
s
.78237 .2105 m
.78237 .2105 L
s
.78245 .21096 m
.78245 .21096 L
s
.78252 .21096 m
.78252 .21096 L
s
.78259 .21096 m
.78259 .21096 L
s
.78266 .21237 m
.78266 .21237 L
s
.78274 .21167 m
.78274 .21167 L
s
.78282 .21355 m
.78282 .21355 L
s
.78289 .2119 m
.78289 .2119 L
s
.78297 .21167 m
.78297 .21167 L
s
.78304 .21002 m
.78304 .21002 L
s
.78311 .21167 m
.78311 .21167 L
s
.78319 .20979 m
.78319 .20979 L
s
.78327 .2112 m
.78327 .2112 L
s
.78334 .2112 m
.78334 .2112 L
s
.78341 .21096 m
.78341 .21096 L
s
.78348 .21002 m
.78348 .21002 L
s
.78356 .2112 m
.78356 .2112 L
s
.78363 .21002 m
.78363 .21002 L
s
.78371 .20861 m
.78371 .20861 L
s
.78378 .20932 m
.78378 .20932 L
s
.78386 .20838 m
.78386 .20838 L
s
.78392 .21073 m
.78392 .21073 L
s
.78401 .21096 m
.78401 .21096 L
s
.78408 .2112 m
.78408 .2112 L
s
.78415 .21002 m
.78415 .21002 L
s
.78422 .21026 m
.78422 .21026 L
s
.7843 .2112 m
.7843 .2112 L
s
.78438 .21026 m
.78438 .21026 L
s
.78445 .21237 m
.78445 .21237 L
s
.78453 .2105 m
.78453 .2105 L
s
.7846 .21096 m
.7846 .21096 L
s
.78468 .21214 m
.78468 .21214 L
s
.78474 .21378 m
.78474 .21378 L
s
.78482 .21355 m
.78482 .21355 L
s
.7849 .21519 m
.7849 .21519 L
s
.78497 .21378 m
.78497 .21378 L
s
.78504 .21284 m
.78504 .21284 L
s
.78512 .21378 m
.78512 .21378 L
s
.78519 .21237 m
.78519 .21237 L
s
.78527 .21261 m
.78527 .21261 L
s
.78534 .21284 m
.78534 .21284 L
s
.78542 .21307 m
.78542 .21307 L
s
.78549 .2105 m
.78549 .2105 L
s
.78556 .21261 m
.78556 .21261 L
s
.78564 .21237 m
.78564 .21237 L
s
.78571 .21237 m
.78571 .21237 L
s
.78579 .21214 m
.78579 .21214 L
s
.78586 .21167 m
.78586 .21167 L
s
.78594 .21143 m
.78594 .21143 L
s
.78601 .2112 m
.78601 .2112 L
s
.78609 .2105 m
.78609 .2105 L
s
.78616 .20861 m
.78616 .20861 L
s
.78624 .20885 m
.78624 .20885 L
s
.78631 .20674 m
.78631 .20674 L
s
.78638 .20603 m
.78638 .20603 L
s
.78645 .20509 m
.78645 .20509 L
s
.78653 .20392 m
.78653 .20392 L
s
.7866 .20345 m
.7866 .20345 L
s
.78668 .20321 m
.78668 .20321 L
s
.78675 .20345 m
.78675 .20345 L
s
.78683 .20086 m
.78683 .20086 L
s
.7869 .20157 m
.7869 .20157 L
s
.78698 .19992 m
.78698 .19992 L
s
.78705 .20086 m
.78705 .20086 L
s
.78712 .20086 m
.78712 .20086 L
s
.78719 .20274 m
.78719 .20274 L
s
.78727 .20345 m
.78727 .20345 L
s
.78734 .2025 m
.78734 .2025 L
s
.78742 .20368 m
.78742 .20368 L
s
.7875 .20274 m
.7875 .20274 L
s
.78757 .2018 m
.78757 .2018 L
s
.78765 .20086 m
.78765 .20086 L
s
.78772 .19945 m
.78772 .19945 L
s
.7878 .19781 m
.7878 .19781 L
s
.78787 .19687 m
.78787 .19687 L
s
.78794 .19734 m
.78794 .19734 L
s
.78801 .19499 m
.78801 .19499 L
s
.78809 .19593 m
.78809 .19593 L
s
.78816 .19734 m
.78816 .19734 L
s
.78824 .19898 m
.78824 .19898 L
s
.78831 .19828 m
.78831 .19828 L
s
.78839 .19781 m
.78839 .19781 L
s
.78846 .19758 m
.78846 .19758 L
s
.78854 .20016 m
.78854 .20016 L
s
.78861 .19968 m
.78861 .19968 L
s
.78869 .19992 m
.78869 .19992 L
s
.78876 .19922 m
.78876 .19922 L
s
.78883 .19875 m
.78883 .19875 L
s
.7889 .19758 m
.7889 .19758 L
s
.78898 .19781 m
.78898 .19781 L
s
.78906 .19922 m
.78906 .19922 L
s
.78913 .19968 m
.78913 .19968 L
s
.78921 .19992 m
.78921 .19992 L
s
.78928 .19898 m
.78928 .19898 L
s
.78936 .19875 m
.78936 .19875 L
s
.78943 .19734 m
.78943 .19734 L
s
.78951 .19781 m
.78951 .19781 L
s
.78957 .19758 m
.78957 .19758 L
s
.78965 .19945 m
.78965 .19945 L
s
.78972 .20016 m
.78972 .20016 L
s
.7898 .19945 m
.7898 .19945 L
s
.78987 .19945 m
.78987 .19945 L
s
.78995 .19828 m
.78995 .19828 L
s
.79002 .20063 m
.79002 .20063 L
s
.7901 .19922 m
.7901 .19922 L
s
.79017 .19851 m
.79017 .19851 L
s
.79025 .19758 m
.79025 .19758 L
s
.79032 .19828 m
.79032 .19828 L
s
.79039 .19804 m
.79039 .19804 L
s
.79046 .19781 m
.79046 .19781 L
s
.79054 .19898 m
.79054 .19898 L
s
.79062 .19875 m
.79062 .19875 L
s
.79069 .19922 m
.79069 .19922 L
s
.79077 .19828 m
.79077 .19828 L
s
.79084 .19898 m
.79084 .19898 L
s
.79091 .19664 m
.79091 .19664 L
s
.79099 .19875 m
.79099 .19875 L
s
.79107 .19711 m
.79107 .19711 L
s
.79114 .19781 m
.79114 .19781 L
s
.79121 .19687 m
.79121 .19687 L
s
.79128 .19804 m
.79128 .19804 L
s
.79136 .19875 m
.79136 .19875 L
s
.79143 .19758 m
.79143 .19758 L
s
.79151 .19875 m
.79151 .19875 L
s
.79158 .19804 m
.79158 .19804 L
s
.79166 .20016 m
.79166 .20016 L
s
.79173 .19828 m
.79173 .19828 L
s
.79181 .19968 m
.79181 .19968 L
s
.79188 .19828 m
.79188 .19828 L
s
.79195 .19828 m
.79195 .19828 L
s
.79202 .19898 m
.79202 .19898 L
s
.7921 .19922 m
.7921 .19922 L
s
.79218 .19945 m
.79218 .19945 L
s
.79225 .2004 m
.79225 .2004 L
s
.79233 .19922 m
.79233 .19922 L
s
.7924 .19922 m
.7924 .19922 L
s
.79248 .19851 m
.79248 .19851 L
s
.79254 .19593 m
.79254 .19593 L
s
.79262 .1964 m
.79262 .1964 L
s
.7927 .19593 m
.7927 .19593 L
s
.79277 .19499 m
.79277 .19499 L
s
.79284 .19382 m
.79284 .19382 L
s
.79292 .19358 m
.79292 .19358 L
s
.79299 .19452 m
.79299 .19452 L
s
.79307 .19452 m
.79307 .19452 L
s
.79314 .19452 m
.79314 .19452 L
s
.79322 .19476 m
.79322 .19476 L
s
.79329 .19616 m
.79329 .19616 L
s
.79336 .19593 m
.79336 .19593 L
s
.79344 .19452 m
.79344 .19452 L
s
.79352 .19429 m
.79352 .19429 L
s
.79359 .19546 m
.79359 .19546 L
s
.79366 .19593 m
.79366 .19593 L
s
.79374 .19569 m
.79374 .19569 L
s
.79381 .19687 m
.79381 .19687 L
s
.79389 .19687 m
.79389 .19687 L
s
.79396 .19804 m
.79396 .19804 L
s
.79404 .19804 m
.79404 .19804 L
s
.79411 .19569 m
.79411 .19569 L
s
.79418 .19405 m
.79418 .19405 L
s
.79425 .19476 m
.79425 .19476 L
s
.79433 .19546 m
.79433 .19546 L
s
.7944 .19593 m
.7944 .19593 L
s
.79448 .19593 m
.79448 .19593 L
s
.79455 .19616 m
.79455 .19616 L
s
.79463 .19499 m
.79463 .19499 L
s
.7947 .19499 m
.7947 .19499 L
s
.79478 .19452 m
.79478 .19452 L
s
.79485 .19429 m
.79485 .19429 L
s
.79492 .19546 m
.79492 .19546 L
s
.79499 .19499 m
.79499 .19499 L
s
.79507 .1964 m
.79507 .1964 L
s
.79515 .19593 m
.79515 .19593 L
s
.79522 .19664 m
.79522 .19664 L
s
.7953 .1964 m
.7953 .1964 L
s
.79537 .19781 m
.79537 .19781 L
s
.79545 .19664 m
.79545 .19664 L
s
.79552 .19499 m
.79552 .19499 L
s
.7956 .1964 m
.7956 .1964 L
s
.79567 .19546 m
.79567 .19546 L
s
.79574 .19664 m
.79574 .19664 L
s
.79581 .19734 m
.79581 .19734 L
s
.79589 .19851 m
.79589 .19851 L
s
.79596 .19734 m
.79596 .19734 L
s
.79604 .19711 m
.79604 .19711 L
s
.79611 .19664 m
.79611 .19664 L
s
.79619 .19664 m
.79619 .19664 L
s
.79626 .19734 m
.79626 .19734 L
s
.79634 .19734 m
.79634 .19734 L
s
.79641 .19875 m
.79641 .19875 L
s
.79649 .19711 m
.79649 .19711 L
s
.79656 .19781 m
.79656 .19781 L
s
.79663 .19758 m
.79663 .19758 L
s
.7967 .19781 m
.7967 .19781 L
s
.79678 .19687 m
.79678 .19687 L
s
.79686 .19664 m
.79686 .19664 L
s
.79693 .19851 m
.79693 .19851 L
s
.79701 .19875 m
.79701 .19875 L
s
.79708 .19922 m
.79708 .19922 L
s
.79716 .19992 m
.79716 .19992 L
s
.79723 .2011 m
.79723 .2011 L
s
.79731 .20086 m
.79731 .20086 L
s
.79737 .2018 m
.79737 .2018 L
s
.79745 .20063 m
.79745 .20063 L
s
.79752 .20086 m
.79752 .20086 L
s
.7976 .19968 m
.7976 .19968 L
s
.79767 .19968 m
.79767 .19968 L
s
.79775 .19922 m
.79775 .19922 L
s
.79782 .19781 m
.79782 .19781 L
s
.7979 .19758 m
.7979 .19758 L
s
.79797 .19968 m
.79797 .19968 L
s
.79805 .20086 m
.79805 .20086 L
s
.79812 .19922 m
.79812 .19922 L
s
.79819 .20016 m
.79819 .20016 L
s
.79826 .19922 m
.79826 .19922 L
s
.79834 .19875 m
.79834 .19875 L
s
.79842 .19992 m
.79842 .19992 L
s
.79849 .19992 m
.79849 .19992 L
s
.79857 .19875 m
.79857 .19875 L
s
.79864 .19758 m
.79864 .19758 L
s
.79872 .19734 m
.79872 .19734 L
s
.79879 .19522 m
.79879 .19522 L
s
.79887 .19711 m
.79887 .19711 L
s
.79894 .19734 m
.79894 .19734 L
s
.79901 .19828 m
.79901 .19828 L
s
.79908 .19734 m
.79908 .19734 L
s
.79916 .19828 m
.79916 .19828 L
s
.79923 .19781 m
.79923 .19781 L
s
.79931 .19781 m
.79931 .19781 L
s
.79938 .19922 m
.79938 .19922 L
s
.79946 .19992 m
.79946 .19992 L
s
.79953 .20133 m
.79953 .20133 L
s
.79961 .2011 m
.79961 .2011 L
s
.79968 .2025 m
.79968 .2025 L
s
.79975 .20227 m
.79975 .20227 L
s
.79982 .20392 m
.79982 .20392 L
s
.7999 .20392 m
.7999 .20392 L
s
.79998 .20415 m
.79998 .20415 L
s
.80005 .2025 m
.80005 .2025 L
s
.80013 .20392 m
.80013 .20392 L
s
.8002 .20345 m
.8002 .20345 L
s
.80028 .20509 m
.80028 .20509 L
s
.80035 .20462 m
.80035 .20462 L
s
.80043 .20392 m
.80043 .20392 L
s
.8005 .20532 m
.8005 .20532 L
s
.80057 .20626 m
.80057 .20626 L
s
.80064 .20791 m
.80064 .20791 L
s
.80072 .20768 m
.80072 .20768 L
s
.80079 .20861 m
.80079 .20861 L
s
.80087 .21002 m
.80087 .21002 L
s
.80094 .21002 m
.80094 .21002 L
s
.80102 .2105 m
.80102 .2105 L
s
.80109 .20955 m
.80109 .20955 L
s
.80116 .21002 m
.80116 .21002 L
s
.80124 .21026 m
.80124 .21026 L
s
.80132 .21237 m
.80132 .21237 L
s
.80139 .2119 m
.80139 .2119 L
s
.80146 .21214 m
.80146 .21214 L
s
.80154 .21143 m
.80154 .21143 L
s
.80161 .21355 m
.80161 .21355 L
s
.80169 .21261 m
.80169 .21261 L
s
.80176 .21378 m
.80176 .21378 L
s
.80184 .21542 m
.80184 .21542 L
s
.80191 .21542 m
.80191 .21542 L
s
.80198 .21589 m
.80198 .21589 L
s
.80206 .21496 m
.80206 .21496 L
s
.80214 .21636 m
.80214 .21636 L
s
.8022 .21519 m
.8022 .21519 L
s
.80228 .21754 m
.80228 .21754 L
s
.80235 .21754 m
.80235 .21754 L
s
.80243 .21778 m
.80243 .21778 L
s
.8025 .21731 m
.8025 .21731 L
s
.80258 .2166 m
.80258 .2166 L
s
.80265 .21707 m
.80265 .21707 L
s
.80272 .21613 m
.80272 .21613 L
s
.80279 .21566 m
.80279 .21566 L
s
.80287 .21566 m
.80287 .21566 L
s
.80295 .2166 m
.80295 .2166 L
s
.80302 .21472 m
.80302 .21472 L
s
.8031 .21472 m
.8031 .21472 L
s
.80317 .21519 m
.80317 .21519 L
s
.80325 .21472 m
.80325 .21472 L
s
.80332 .21331 m
.80332 .21331 L
s
.8034 .21425 m
.8034 .21425 L
s
.80347 .21307 m
.80347 .21307 L
s
.80354 .21284 m
.80354 .21284 L
s
.80361 .21331 m
.80361 .21331 L
s
.80369 .21214 m
.80369 .21214 L
s
.80377 .21214 m
.80377 .21214 L
s
.80384 .2119 m
.80384 .2119 L
s
.80391 .2119 m
.80391 .2119 L
s
.80399 .2119 m
.80399 .2119 L
s
.80406 .21378 m
.80406 .21378 L
s
.80414 .21402 m
.80414 .21402 L
s
.80421 .21402 m
.80421 .21402 L
s
.80429 .21261 m
.80429 .21261 L
s
.80436 .21378 m
.80436 .21378 L
s
.80443 .21636 m
.80443 .21636 L
s
.8045 .21472 m
.8045 .21472 L
s
.80458 .21589 m
.80458 .21589 L
s
.80466 .21402 m
.80466 .21402 L
s
.80473 .21566 m
.80473 .21566 L
s
.80481 .21566 m
.80481 .21566 L
s
.80488 .21707 m
.80488 .21707 L
s
.80496 .21636 m
.80496 .21636 L
s
.80503 .21848 m
.80503 .21848 L
s
.80511 .21778 m
.80511 .21778 L
s
.80517 .21636 m
.80517 .21636 L
s
.80525 .2166 m
.80525 .2166 L
s
.80532 .2166 m
.80532 .2166 L
s
.8054 .21754 m
.8054 .21754 L
s
.80547 .21683 m
.80547 .21683 L
s
.80555 .21824 m
.80555 .21824 L
s
.80562 .21778 m
.80562 .21778 L
s
.8057 .21731 m
.8057 .21731 L
s
.80577 .21683 m
.80577 .21683 L
s
.80585 .21613 m
.80585 .21613 L
s
.80592 .21731 m
.80592 .21731 L
s
.80599 .21754 m
.80599 .21754 L
s
.80606 .21965 m
.80606 .21965 L
s
.80614 .22036 m
.80614 .22036 L
s
.80622 .21989 m
.80622 .21989 L
s
.80629 .21965 m
.80629 .21965 L
s
.80637 .22083 m
.80637 .22083 L
s
.80644 .22036 m
.80644 .22036 L
s
.80652 .21942 m
.80652 .21942 L
s
.80659 .22106 m
.80659 .22106 L
s
.80667 .21918 m
.80667 .21918 L
s
.80674 .21965 m
.80674 .21965 L
s
.80681 .21942 m
.80681 .21942 L
s
.80688 .21942 m
.80688 .21942 L
s
.80696 .21754 m
.80696 .21754 L
s
.80703 .21683 m
.80703 .21683 L
s
.80711 .2166 m
.80711 .2166 L
s
.80718 .21848 m
.80718 .21848 L
s
.80726 .21683 m
.80726 .21683 L
s
.80733 .21707 m
.80733 .21707 L
s
.80741 .21848 m
.80741 .21848 L
s
.80748 .21778 m
.80748 .21778 L
s
.80755 .21824 m
.80755 .21824 L
s
.80762 .21801 m
.80762 .21801 L
s
.8077 .21989 m
.8077 .21989 L
s
.80778 .21989 m
.80778 .21989 L
s
.80785 .21942 m
.80785 .21942 L
s
.80793 .21848 m
.80793 .21848 L
s
.808 .21942 m
.808 .21942 L
s
.80808 .21754 m
.80808 .21754 L
s
.80815 .21778 m
.80815 .21778 L
s
.80823 .21848 m
.80823 .21848 L
s
.8083 .21801 m
.8083 .21801 L
s
.80837 .21801 m
.80837 .21801 L
s
.80844 .21824 m
.80844 .21824 L
s
.80852 .22012 m
.80852 .22012 L
s
.80859 .21918 m
.80859 .21918 L
s
.80867 .21895 m
.80867 .21895 L
s
.80874 .21848 m
.80874 .21848 L
s
.80882 .2206 m
.80882 .2206 L
s
.80889 .22036 m
.80889 .22036 L
s
.80897 .2213 m
.80897 .2213 L
s
.80904 .22224 m
.80904 .22224 L
s
.80912 .22106 m
.80912 .22106 L
s
.80919 .22294 m
.80919 .22294 L
s
.80926 .22177 m
.80926 .22177 L
s
.80934 .222 m
.80934 .222 L
s
.80941 .2206 m
.80941 .2206 L
s
.80949 .22036 m
.80949 .22036 L
s
.80956 .21895 m
.80956 .21895 L
s
.80964 .22106 m
.80964 .22106 L
s
.80971 .2206 m
.80971 .2206 L
s
.80978 .2213 m
.80978 .2213 L
s
.80986 .22083 m
.80986 .22083 L
s
.80994 .2213 m
.80994 .2213 L
s
.81 .22294 m
.81 .22294 L
s
.81008 .22317 m
.81008 .22317 L
s
.81015 .22459 m
.81015 .22459 L
s
.81023 .22388 m
.81023 .22388 L
s
.8103 .22388 m
.8103 .22388 L
s
.81038 .22459 m
.81038 .22459 L
s
.81045 .22459 m
.81045 .22459 L
s
.81052 .22388 m
.81052 .22388 L
s
.8106 .22459 m
.8106 .22459 L
s
.81068 .22412 m
.81068 .22412 L
s
.81075 .22271 m
.81075 .22271 L
s
.81082 .22364 m
.81082 .22364 L
s
.8109 .22341 m
.8109 .22341 L
s
.81097 .22388 m
.81097 .22388 L
s
.81105 .22364 m
.81105 .22364 L
s
.81112 .22506 m
.81112 .22506 L
s
.8112 .22459 m
.8112 .22459 L
s
.81127 .22576 m
.81127 .22576 L
s
.81134 .22552 m
.81134 .22552 L
s
.81141 .22482 m
.81141 .22482 L
s
.81149 .22576 m
.81149 .22576 L
s
.81157 .22646 m
.81157 .22646 L
s
.81164 .22834 m
.81164 .22834 L
s
.81171 .22834 m
.81171 .22834 L
s
.81179 .22881 m
.81179 .22881 L
s
.81186 .22928 m
.81186 .22928 L
s
.81194 .23045 m
.81194 .23045 L
s
.81201 .22928 m
.81201 .22928 L
s
.81209 .23117 m
.81209 .23117 L
s
.81216 .2314 m
.81216 .2314 L
s
.81223 .23163 m
.81223 .23163 L
s
.81231 .23351 m
.81231 .23351 L
s
.81239 .23117 m
.81239 .23117 L
s
.81246 .23187 m
.81246 .23187 L
s
.81253 .23163 m
.81253 .23163 L
s
.81261 .23257 m
.81261 .23257 L
s
.81268 .23117 m
.81268 .23117 L
s
.81276 .2321 m
.81276 .2321 L
s
.81283 .2314 m
.81283 .2314 L
s
.81291 .23187 m
.81291 .23187 L
s
.81297 .23093 m
.81297 .23093 L
s
.81305 .23022 m
.81305 .23022 L
s
.81312 .22975 m
.81312 .22975 L
s
.8132 .23093 m
.8132 .23093 L
s
.81327 .23234 m
.81327 .23234 L
s
.81335 .22975 m
.81335 .22975 L
s
.81342 .22928 m
.81342 .22928 L
s
.8135 .22764 m
.8135 .22764 L
s
.81357 .22881 m
.81357 .22881 L
s
.81365 .22975 m
.81365 .22975 L
s
.81372 .22858 m
.81372 .22858 L
s
.81379 .22788 m
.81379 .22788 L
s
.81386 .22693 m
.81386 .22693 L
s
.81394 .22858 m
.81394 .22858 L
s
.81402 .22741 m
.81402 .22741 L
s
.81409 .22693 m
.81409 .22693 L
s
.81417 .22646 m
.81417 .22646 L
s
.81424 .22623 m
.81424 .22623 L
s
.81432 .22552 m
.81432 .22552 L
s
.81439 .22506 m
.81439 .22506 L
s
.81447 .22529 m
.81447 .22529 L
s
.81454 .22599 m
.81454 .22599 L
s
.81461 .2267 m
.81461 .2267 L
s
.81468 .22623 m
.81468 .22623 L
s
.81476 .22623 m
.81476 .22623 L
s
.81483 .22693 m
.81483 .22693 L
s
.81491 .22576 m
.81491 .22576 L
s
.81498 .22506 m
.81498 .22506 L
s
.81506 .22529 m
.81506 .22529 L
s
.81513 .22623 m
.81513 .22623 L
s
.81521 .22834 m
.81521 .22834 L
s
.81528 .22881 m
.81528 .22881 L
s
.81536 .22788 m
.81536 .22788 L
s
.81542 .22834 m
.81542 .22834 L
s
.8155 .22646 m
.8155 .22646 L
s
.81558 .22811 m
.81558 .22811 L
s
.81565 .22811 m
.81565 .22811 L
s
.81573 .22952 m
.81573 .22952 L
s
.8158 .22834 m
.8158 .22834 L
s
.81588 .22952 m
.81588 .22952 L
s
.81595 .22858 m
.81595 .22858 L
s
.81603 .22741 m
.81603 .22741 L
s
.8161 .22482 m
.8161 .22482 L
s
.81617 .22576 m
.81617 .22576 L
s
.81624 .22552 m
.81624 .22552 L
s
.81632 .22646 m
.81632 .22646 L
s
.81639 .22788 m
.81639 .22788 L
s
.81647 .22834 m
.81647 .22834 L
s
.81654 .22928 m
.81654 .22928 L
s
.81662 .22858 m
.81662 .22858 L
s
.81669 .22905 m
.81669 .22905 L
s
.81677 .22858 m
.81677 .22858 L
s
.81684 .22928 m
.81684 .22928 L
s
.81692 .22881 m
.81692 .22881 L
s
.81699 .22693 m
.81699 .22693 L
s
.81706 .22717 m
.81706 .22717 L
s
.81714 .22459 m
.81714 .22459 L
s
.81721 .22412 m
.81721 .22412 L
s
.81729 .22529 m
.81729 .22529 L
s
.81736 .22552 m
.81736 .22552 L
s
.81744 .22388 m
.81744 .22388 L
s
.81751 .22482 m
.81751 .22482 L
s
.81759 .22459 m
.81759 .22459 L
s
.81766 .22506 m
.81766 .22506 L
s
.81774 .22552 m
.81774 .22552 L
s
.8178 .22552 m
.8178 .22552 L
s
.81788 .22717 m
.81788 .22717 L
s
.81795 .22764 m
.81795 .22764 L
s
.81803 .22834 m
.81803 .22834 L
s
.8181 .22811 m
.8181 .22811 L
s
.81818 .22881 m
.81818 .22881 L
s
.81825 .22788 m
.81825 .22788 L
s
.81833 .22834 m
.81833 .22834 L
s
.8184 .2267 m
.8184 .2267 L
s
.81848 .2267 m
.81848 .2267 L
s
.81855 .22552 m
.81855 .22552 L
s
.81862 .22623 m
.81862 .22623 L
s
.8187 .22693 m
.8187 .22693 L
s
.81877 .2267 m
.81877 .2267 L
s
.81885 .22693 m
.81885 .22693 L
s
.81892 .2267 m
.81892 .2267 L
s
.819 .22811 m
.819 .22811 L
s
.81907 .22905 m
.81907 .22905 L
s
.81914 .22952 m
.81914 .22952 L
s
.81922 .2307 m
.81922 .2307 L
s
.8193 .2321 m
.8193 .2321 L
s
.81937 .23327 m
.81937 .23327 L
s
.81944 .23187 m
.81944 .23187 L
s
.81951 .23187 m
.81951 .23187 L
s
.81959 .23093 m
.81959 .23093 L
s
.81966 .23117 m
.81966 .23117 L
s
.81974 .23093 m
.81974 .23093 L
s
.81981 .2321 m
.81981 .2321 L
s
.81989 .2307 m
.81989 .2307 L
s
.81996 .23234 m
.81996 .23234 L
s
.82003 .23281 m
.82003 .23281 L
s
.82011 .23327 m
.82011 .23327 L
s
.82019 .23422 m
.82019 .23422 L
s
.82026 .23187 m
.82026 .23187 L
s
.82033 .23187 m
.82033 .23187 L
s
.82041 .23117 m
.82041 .23117 L
s
.82048 .23187 m
.82048 .23187 L
s
.82056 .23093 m
.82056 .23093 L
s
.82063 .23304 m
.82063 .23304 L
s
.82071 .23374 m
.82071 .23374 L
s
.82077 .23304 m
.82077 .23304 L
s
.82085 .2321 m
.82085 .2321 L
s
.82093 .23093 m
.82093 .23093 L
s
.821 .2307 m
.821 .2307 L
s
.82107 .22975 m
.82107 .22975 L
s
.82115 .23163 m
.82115 .23163 L
s
.82122 .2321 m
.82122 .2321 L
s
.8213 .23374 m
.8213 .23374 L
s
.82137 .2321 m
.82137 .2321 L
s
.82145 .23234 m
.82145 .23234 L
s
.82152 .23093 m
.82152 .23093 L
s
.82159 .23117 m
.82159 .23117 L
s
.82166 .2307 m
.82166 .2307 L
s
.82174 .23234 m
.82174 .23234 L
s
.82182 .23327 m
.82182 .23327 L
s
.82189 .23257 m
.82189 .23257 L
s
.82197 .23539 m
.82197 .23539 L
s
.82204 .23422 m
.82204 .23422 L
s
.82212 .23327 m
.82212 .23327 L
s
.82219 .23257 m
.82219 .23257 L
s
.82227 .23304 m
.82227 .23304 L
s
.82234 .23163 m
.82234 .23163 L
s
.82241 .2314 m
.82241 .2314 L
s
.82248 .22928 m
.82248 .22928 L
s
.82256 .22928 m
.82256 .22928 L
s
.82263 .22905 m
.82263 .22905 L
s
.82271 .22741 m
.82271 .22741 L
s
.82278 .22693 m
.82278 .22693 L
s
.82286 .22552 m
.82286 .22552 L
s
.82293 .22599 m
.82293 .22599 L
s
.82301 .22576 m
.82301 .22576 L
s
.82308 .22764 m
.82308 .22764 L
s
.82316 .22741 m
.82316 .22741 L
s
.82322 .22905 m
.82322 .22905 L
s
.8233 .22975 m
.8233 .22975 L
s
.82338 .22858 m
.82338 .22858 L
s
.82345 .22905 m
.82345 .22905 L
s
.82353 .22741 m
.82353 .22741 L
s
.8236 .22788 m
.8236 .22788 L
s
.82368 .22741 m
.82368 .22741 L
s
.82375 .22952 m
.82375 .22952 L
s
.82383 .22858 m
.82383 .22858 L
s
.8239 .22717 m
.8239 .22717 L
s
.82397 .22599 m
.82397 .22599 L
s
.82404 .22599 m
.82404 .22599 L
s
.82412 .22646 m
.82412 .22646 L
s
.82419 .22693 m
.82419 .22693 L
s
.82427 .22506 m
.82427 .22506 L
s
.82434 .22435 m
.82434 .22435 L
s
.82442 .22482 m
.82442 .22482 L
s
.82449 .22412 m
.82449 .22412 L
s
.82457 .2267 m
.82457 .2267 L
s
.82464 .22623 m
.82464 .22623 L
s
.82472 .22741 m
.82472 .22741 L
s
.82479 .22834 m
.82479 .22834 L
s
.82486 .22928 m
.82486 .22928 L
s
.82494 .22881 m
.82494 .22881 L
s
.82501 .22764 m
.82501 .22764 L
s
.82509 .22741 m
.82509 .22741 L
s
.82516 .22834 m
.82516 .22834 L
s
.82524 .22811 m
.82524 .22811 L
s
.82531 .22788 m
.82531 .22788 L
s
.82539 .22788 m
.82539 .22788 L
s
.82546 .22788 m
.82546 .22788 L
s
.82554 .22741 m
.82554 .22741 L
s
.8256 .22623 m
.8256 .22623 L
s
.82568 .22693 m
.82568 .22693 L
s
.82575 .22693 m
.82575 .22693 L
s
.82583 .22741 m
.82583 .22741 L
s
.8259 .22788 m
.8259 .22788 L
s
.82598 .2267 m
.82598 .2267 L
s
.82605 .22834 m
.82605 .22834 L
s
.82613 .22764 m
.82613 .22764 L
s
.8262 .22905 m
.8262 .22905 L
s
.82628 .22834 m
.82628 .22834 L
s
.82635 .23045 m
.82635 .23045 L
s
.82642 .22975 m
.82642 .22975 L
s
.8265 .23117 m
.8265 .23117 L
s
.82657 .23093 m
.82657 .23093 L
s
.82665 .2307 m
.82665 .2307 L
s
.82672 .23093 m
.82672 .23093 L
s
.8268 .23093 m
.8268 .23093 L
s
.82687 .23281 m
.82687 .23281 L
s
.82694 .23281 m
.82694 .23281 L
s
.82702 .23327 m
.82702 .23327 L
s
.8271 .23163 m
.8271 .23163 L
s
.82717 .2307 m
.82717 .2307 L
s
.82724 .23093 m
.82724 .23093 L
s
.82731 .2307 m
.82731 .2307 L
s
.82739 .23187 m
.82739 .23187 L
s
.82746 .2307 m
.82746 .2307 L
s
.82754 .2314 m
.82754 .2314 L
s
.82761 .23117 m
.82761 .23117 L
s
.82769 .23045 m
.82769 .23045 L
s
.82776 .22975 m
.82776 .22975 L
s
.82784 .22881 m
.82784 .22881 L
s
.82791 .22975 m
.82791 .22975 L
s
.82799 .22858 m
.82799 .22858 L
s
.82806 .22881 m
.82806 .22881 L
s
.82813 .22975 m
.82813 .22975 L
s
.82821 .2314 m
.82821 .2314 L
s
.82828 .22999 m
.82828 .22999 L
s
.82836 .23045 m
.82836 .23045 L
s
.82843 .22905 m
.82843 .22905 L
s
.82851 .22975 m
.82851 .22975 L
s
.82857 .22788 m
.82857 .22788 L
s
.82865 .23117 m
.82865 .23117 L
s
.82873 .22905 m
.82873 .22905 L
s
.8288 .22858 m
.8288 .22858 L
s
.82887 .22788 m
.82887 .22788 L
s
.82895 .22623 m
.82895 .22623 L
s
.82902 .22576 m
.82902 .22576 L
s
.8291 .22576 m
.8291 .22576 L
s
.82917 .22552 m
.82917 .22552 L
s
.82925 .22459 m
.82925 .22459 L
s
.82932 .22599 m
.82932 .22599 L
s
.82939 .22506 m
.82939 .22506 L
s
.82947 .22529 m
.82947 .22529 L
s
.82955 .22364 m
.82955 .22364 L
s
.82962 .22412 m
.82962 .22412 L
s
.82969 .22412 m
.82969 .22412 L
s
.82977 .22388 m
.82977 .22388 L
s
.82984 .22317 m
.82984 .22317 L
s
.82992 .22247 m
.82992 .22247 L
s
.82999 .2213 m
.82999 .2213 L
s
.83007 .2213 m
.83007 .2213 L
s
.83014 .22177 m
.83014 .22177 L
s
.83021 .22106 m
.83021 .22106 L
s
.83028 .2206 m
.83028 .2206 L
s
.83036 .21989 m
.83036 .21989 L
s
.83043 .21942 m
.83043 .21942 L
s
.83051 .22224 m
.83051 .22224 L
s
.83058 .22317 m
.83058 .22317 L
s
.83066 .22529 m
.83066 .22529 L
s
.83073 .22435 m
.83073 .22435 L
s
.83081 .22459 m
.83081 .22459 L
s
.83088 .22271 m
.83088 .22271 L
s
.83096 .22153 m
.83096 .22153 L
s
.83102 .222 m
.83102 .222 L
s
.8311 .22106 m
.8311 .22106 L
s
.83118 .22083 m
.83118 .22083 L
s
.83125 .22036 m
.83125 .22036 L
s
.83133 .2213 m
.83133 .2213 L
s
.8314 .2206 m
.8314 .2206 L
s
.83148 .21871 m
.83148 .21871 L
s
.83155 .21613 m
.83155 .21613 L
s
.83163 .21778 m
.83163 .21778 L
s
.8317 .21613 m
.8317 .21613 L
s
.83177 .21542 m
.83177 .21542 L
s
.83184 .21425 m
.83184 .21425 L
s
.83192 .21613 m
.83192 .21613 L
s
.83199 .21355 m
.83199 .21355 L
s
.83207 .21449 m
.83207 .21449 L
s
.83214 .21636 m
.83214 .21636 L
s
.83222 .21613 m
.83222 .21613 L
s
.83229 .21707 m
.83229 .21707 L
s
.83237 .21801 m
.83237 .21801 L
s
.83244 .2206 m
.83244 .2206 L
s
.83252 .21895 m
.83252 .21895 L
s
.83259 .21918 m
.83259 .21918 L
s
.83266 .21754 m
.83266 .21754 L
s
.83274 .21989 m
.83274 .21989 L
s
.83281 .22036 m
.83281 .22036 L
s
.83289 .22012 m
.83289 .22012 L
s
.83296 .22036 m
.83296 .22036 L
s
.83304 .22083 m
.83304 .22083 L
s
.83311 .22247 m
.83311 .22247 L
s
.83319 .22177 m
.83319 .22177 L
s
.83326 .22106 m
.83326 .22106 L
s
.83334 .21895 m
.83334 .21895 L
s
.8334 .21965 m
.8334 .21965 L
s
.83348 .21801 m
.83348 .21801 L
s
.83355 .21989 m
.83355 .21989 L
s
.83363 .21942 m
.83363 .21942 L
s
.8337 .21942 m
.8337 .21942 L
s
.83378 .21871 m
.83378 .21871 L
s
.83385 .21895 m
.83385 .21895 L
s
.83393 .21778 m
.83393 .21778 L
s
.834 .21613 m
.834 .21613 L
s
.83408 .21707 m
.83408 .21707 L
s
.83415 .21636 m
.83415 .21636 L
s
.83422 .21731 m
.83422 .21731 L
s
.8343 .21589 m
.8343 .21589 L
s
.83437 .21519 m
.83437 .21519 L
s
.83445 .21425 m
.83445 .21425 L
s
.83452 .21237 m
.83452 .21237 L
s
.8346 .21261 m
.8346 .21261 L
s
.83467 .21214 m
.83467 .21214 L
s
.83475 .2112 m
.83475 .2112 L
s
.83482 .21026 m
.83482 .21026 L
s
.8349 .21143 m
.8349 .21143 L
s
.83497 .20979 m
.83497 .20979 L
s
.83504 .21026 m
.83504 .21026 L
s
.83511 .20814 m
.83511 .20814 L
s
.83519 .20861 m
.83519 .20861 L
s
.83526 .20768 m
.83526 .20768 L
s
.83534 .20838 m
.83534 .20838 L
s
.83541 .20814 m
.83541 .20814 L
s
.83549 .20462 m
.83549 .20462 L
s
.83556 .20486 m
.83556 .20486 L
s
.83564 .20486 m
.83564 .20486 L
s
.83571 .20556 m
.83571 .20556 L
s
.83579 .20509 m
.83579 .20509 L
s
.83586 .20579 m
.83586 .20579 L
s
.83593 .20579 m
.83593 .20579 L
s
.83601 .20674 m
.83601 .20674 L
s
.83608 .20626 m
.83608 .20626 L
s
.83616 .20768 m
.83616 .20768 L
s
.83623 .20744 m
.83623 .20744 L
s
.83631 .20697 m
.83631 .20697 L
s
.83638 .20768 m
.83638 .20768 L
s
.83646 .20791 m
.83646 .20791 L
s
.83653 .20861 m
.83653 .20861 L
s
.8366 .20674 m
.8366 .20674 L
s
.83667 .20721 m
.83667 .20721 L
s
.83675 .20814 m
.83675 .20814 L
s
.83682 .20791 m
.83682 .20791 L
s
.8369 .20674 m
.8369 .20674 L
s
.83697 .20579 m
.83697 .20579 L
s
.83705 .20626 m
.83705 .20626 L
s
.83712 .20462 m
.83712 .20462 L
s
.83719 .20556 m
.83719 .20556 L
s
.83727 .20392 m
.83727 .20392 L
s
.83735 .20509 m
.83735 .20509 L
s
.83742 .20486 m
.83742 .20486 L
s
.83749 .20532 m
.83749 .20532 L
s
.83757 .20603 m
.83757 .20603 L
s
.83764 .20674 m
.83764 .20674 L
s
.83772 .20674 m
.83772 .20674 L
s
.83779 .20697 m
.83779 .20697 L
s
.83787 .20721 m
.83787 .20721 L
s
.83794 .20509 m
.83794 .20509 L
s
.83801 .20556 m
.83801 .20556 L
s
.83808 .20579 m
.83808 .20579 L
s
.83816 .20579 m
.83816 .20579 L
s
.83823 .20579 m
.83823 .20579 L
s
.83831 .2065 m
.83831 .2065 L
s
.83838 .2065 m
.83838 .2065 L
s
.83846 .20626 m
.83846 .20626 L
s
.83853 .20697 m
.83853 .20697 L
s
.83861 .20908 m
.83861 .20908 L
s
.83868 .20885 m
.83868 .20885 L
s
.83876 .20768 m
.83876 .20768 L
s
.83882 .20744 m
.83882 .20744 L
s
.8389 .20603 m
.8389 .20603 L
s
.83898 .20556 m
.83898 .20556 L
s
.83905 .20415 m
.83905 .20415 L
s
.83913 .20415 m
.83913 .20415 L
s
.8392 .20415 m
.8392 .20415 L
s
.83928 .20509 m
.83928 .20509 L
s
.83935 .20532 m
.83935 .20532 L
s
.83943 .20626 m
.83943 .20626 L
s
.8395 .20697 m
.8395 .20697 L
s
.83957 .20603 m
.83957 .20603 L
s
.83964 .20908 m
.83964 .20908 L
s
.83972 .20791 m
.83972 .20791 L
s
.8398 .20908 m
.8398 .20908 L
s
.83987 .20955 m
.83987 .20955 L
s
.83994 .20838 m
.83994 .20838 L
s
.84002 .20908 m
.84002 .20908 L
s
.84009 .20791 m
.84009 .20791 L
s
.84017 .20674 m
.84017 .20674 L
s
.84024 .20532 m
.84024 .20532 L
s
.84032 .20439 m
.84032 .20439 L
s
.84039 .20204 m
.84039 .20204 L
s
.84046 .20086 m
.84046 .20086 L
s
.84054 .19945 m
.84054 .19945 L
s
.84061 .2011 m
.84061 .2011 L
s
.84069 .19945 m
.84069 .19945 L
s
.84076 .20016 m
.84076 .20016 L
s
.84084 .20204 m
.84084 .20204 L
s
.84091 .2025 m
.84091 .2025 L
s
.84099 .20321 m
.84099 .20321 L
s
.84106 .20204 m
.84106 .20204 L
s
.84114 .20274 m
.84114 .20274 L
s
.8412 .20086 m
.8412 .20086 L
s
.84128 .2011 m
.84128 .2011 L
s
.84135 .20063 m
.84135 .20063 L
s
.84143 .20274 m
.84143 .20274 L
s
.8415 .20157 m
.8415 .20157 L
s
.84158 .20297 m
.84158 .20297 L
s
.84165 .20368 m
.84165 .20368 L
s
.84173 .20439 m
.84173 .20439 L
s
.8418 .20486 m
.8418 .20486 L
s
.84188 .20486 m
.84188 .20486 L
s
.84195 .20486 m
.84195 .20486 L
s
.84202 .20532 m
.84202 .20532 L
s
.8421 .20721 m
.8421 .20721 L
s
.84217 .20509 m
.84217 .20509 L
s
.84225 .2065 m
.84225 .2065 L
s
.84232 .20721 m
.84232 .20721 L
s
.8424 .20861 m
.8424 .20861 L
s
.84247 .20791 m
.84247 .20791 L
s
.84255 .20721 m
.84255 .20721 L
s
.84262 .20791 m
.84262 .20791 L
s
.8427 .20861 m
.8427 .20861 L
s
.84277 .20955 m
.84277 .20955 L
s
.84284 .20697 m
.84284 .20697 L
s
.84291 .20674 m
.84291 .20674 L
s
.84299 .20509 m
.84299 .20509 L
s
.84306 .20626 m
.84306 .20626 L
s
.84314 .20603 m
.84314 .20603 L
s
.84321 .20814 m
.84321 .20814 L
s
.84329 .20814 m
.84329 .20814 L
s
.84336 .20979 m
.84336 .20979 L
s
.84344 .21167 m
.84344 .21167 L
s
.84351 .21002 m
.84351 .21002 L
s
.84359 .21096 m
.84359 .21096 L
s
.84366 .2112 m
.84366 .2112 L
s
.84373 .21073 m
.84373 .21073 L
s
.84381 .20955 m
.84381 .20955 L
s
.84388 .21073 m
.84388 .21073 L
s
.84396 .2119 m
.84396 .2119 L
s
.84403 .21307 m
.84403 .21307 L
s
.84411 .2119 m
.84411 .2119 L
s
.84418 .2112 m
.84418 .2112 L
s
.84426 .2119 m
.84426 .2119 L
s
.84433 .21307 m
.84433 .21307 L
s
.8444 .21167 m
.8444 .21167 L
s
.84447 .2112 m
.84447 .2112 L
s
.84455 .21026 m
.84455 .21026 L
s
.84462 .20908 m
.84462 .20908 L
s
.8447 .2105 m
.8447 .2105 L
s
.84477 .20861 m
.84477 .20861 L
s
.84485 .20744 m
.84485 .20744 L
s
.84492 .20509 m
.84492 .20509 L
s
.84499 .20486 m
.84499 .20486 L
s
.84507 .20368 m
.84507 .20368 L
s
.84515 .2025 m
.84515 .2025 L
s
.84522 .20297 m
.84522 .20297 L
s
.84529 .20321 m
.84529 .20321 L
s
.84537 .20297 m
.84537 .20297 L
s
.84544 .20368 m
.84544 .20368 L
s
.84552 .20321 m
.84552 .20321 L
s
.84559 .2018 m
.84559 .2018 L
s
.84567 .20345 m
.84567 .20345 L
s
.84574 .20297 m
.84574 .20297 L
s
.84581 .20274 m
.84581 .20274 L
s
.84589 .20321 m
.84589 .20321 L
s
.84597 .20345 m
.84597 .20345 L
s
.84603 .20297 m
.84603 .20297 L
s
.84611 .20086 m
.84611 .20086 L
s
.84618 .20345 m
.84618 .20345 L
s
.84626 .20321 m
.84626 .20321 L
s
.84633 .20297 m
.84633 .20297 L
s
.84641 .2025 m
.84641 .2025 L
s
.84648 .2011 m
.84648 .2011 L
s
.84656 .20086 m
.84656 .20086 L
s
.84662 .2004 m
.84662 .2004 L
s
.8467 .20063 m
.8467 .20063 L
s
.84678 .19992 m
.84678 .19992 L
s
.84685 .19945 m
.84685 .19945 L
s
.84693 .19922 m
.84693 .19922 L
s
.847 .20227 m
.847 .20227 L
s
.84708 .2025 m
.84708 .2025 L
s
.84715 .20227 m
.84715 .20227 L
s
.84723 .2011 m
.84723 .2011 L
s
.8473 .20063 m
.8473 .20063 L
s
.84737 .19992 m
.84737 .19992 L
s
.84744 .19828 m
.84744 .19828 L
s
.84752 .19875 m
.84752 .19875 L
s
.8476 .19898 m
.8476 .19898 L
s
.84767 .19875 m
.84767 .19875 L
s
.84774 .19781 m
.84774 .19781 L
s
.84782 .19922 m
.84782 .19922 L
s
.84789 .19828 m
.84789 .19828 L
s
.84797 .19922 m
.84797 .19922 L
s
.84804 .19781 m
.84804 .19781 L
s
.84812 .19804 m
.84812 .19804 L
s
.84819 .19945 m
.84819 .19945 L
s
.84826 .19828 m
.84826 .19828 L
s
.84834 .19945 m
.84834 .19945 L
s
.84841 .19945 m
.84841 .19945 L
s
.84849 .19922 m
.84849 .19922 L
s
.84856 .19828 m
.84856 .19828 L
s
.84864 .19968 m
.84864 .19968 L
s
.84871 .19922 m
.84871 .19922 L
s
.84879 .19945 m
.84879 .19945 L
s
.84886 .19992 m
.84886 .19992 L
s
.84894 .20063 m
.84894 .20063 L
s
.849 .20133 m
.849 .20133 L
s
.84908 .20086 m
.84908 .20086 L
s
.84915 .20204 m
.84915 .20204 L
s
.84923 .2004 m
.84923 .2004 L
s
.8493 .2025 m
.8493 .2025 L
s
.84938 .2011 m
.84938 .2011 L
s
.84945 .20204 m
.84945 .20204 L
s
.84953 .2025 m
.84953 .2025 L
s
.8496 .2018 m
.8496 .2018 L
s
.84968 .20157 m
.84968 .20157 L
s
.84975 .2004 m
.84975 .2004 L
s
.84982 .2004 m
.84982 .2004 L
s
.8499 .19922 m
.8499 .19922 L
s
.84997 .20086 m
.84997 .20086 L
s
.85005 .2004 m
.85005 .2004 L
s
.85012 .2025 m
.85012 .2025 L
s
.8502 .20157 m
.8502 .20157 L
s
.85027 .20368 m
.85027 .20368 L
s
.85035 .20297 m
.85035 .20297 L
s
.85042 .2025 m
.85042 .2025 L
s
.8505 .20321 m
.8505 .20321 L
s
.85057 .20368 m
.85057 .20368 L
s
.85064 .20509 m
.85064 .20509 L
s
.85071 .20368 m
.85071 .20368 L
s
.85079 .20415 m
.85079 .20415 L
s
.85086 .20345 m
.85086 .20345 L
s
.85094 .20486 m
.85094 .20486 L
s
.85101 .20439 m
.85101 .20439 L
s
.85109 .20439 m
.85109 .20439 L
s
.85116 .20439 m
.85116 .20439 L
s
.85124 .20439 m
.85124 .20439 L
s
.85131 .2065 m
.85131 .2065 L
s
.85139 .20579 m
.85139 .20579 L
s
.85146 .20744 m
.85146 .20744 L
s
.85153 .20603 m
.85153 .20603 L
s
.85161 .20791 m
.85161 .20791 L
s
.85168 .20838 m
.85168 .20838 L
s
.85176 .21026 m
.85176 .21026 L
s
.85183 .20744 m
.85183 .20744 L
s
.85191 .20979 m
.85191 .20979 L
s
.85198 .21002 m
.85198 .21002 L
s
.85206 .2105 m
.85206 .2105 L
s
.85213 .20908 m
.85213 .20908 L
s
.8522 .2119 m
.8522 .2119 L
s
.85227 .21237 m
.85227 .21237 L
s
.85235 .21307 m
.85235 .21307 L
s
.85242 .21472 m
.85242 .21472 L
s
.8525 .21331 m
.8525 .21331 L
s
.85257 .21331 m
.85257 .21331 L
s
.85265 .2112 m
.85265 .2112 L
s
.85272 .2112 m
.85272 .2112 L
s
.8528 .2112 m
.8528 .2112 L
s
.85287 .21214 m
.85287 .21214 L
s
.85295 .21096 m
.85295 .21096 L
s
.85302 .21096 m
.85302 .21096 L
s
.85309 .21237 m
.85309 .21237 L
s
.85317 .21237 m
.85317 .21237 L
s
.85324 .21261 m
.85324 .21261 L
s
.85332 .2119 m
.85332 .2119 L
s
.85339 .21355 m
.85339 .21355 L
s
.85347 .21284 m
.85347 .21284 L
s
.85354 .21425 m
.85354 .21425 L
s
.85361 .21542 m
.85361 .21542 L
s
.85369 .21542 m
.85369 .21542 L
s
.85377 .21496 m
.85377 .21496 L
s
.85383 .21378 m
.85383 .21378 L
s
.85391 .21613 m
.85391 .21613 L
s
.85398 .21636 m
.85398 .21636 L
s
.85406 .21731 m
.85406 .21731 L
s
.85413 .2166 m
.85413 .2166 L
s
.85421 .21778 m
.85421 .21778 L
s
.85428 .21636 m
.85428 .21636 L
s
.85436 .21801 m
.85436 .21801 L
s
.85443 .21778 m
.85443 .21778 L
s
.85451 .21824 m
.85451 .21824 L
s
.85459 .22036 m
.85459 .22036 L
s
.85465 .21801 m
.85465 .21801 L
s
.85473 .21871 m
.85473 .21871 L
s
.8548 .21871 m
.8548 .21871 L
s
.85488 .21942 m
.85488 .21942 L
s
.85495 .21942 m
.85495 .21942 L
s
.85503 .2206 m
.85503 .2206 L
s
.8551 .21989 m
.8551 .21989 L
s
.85517 .21989 m
.85517 .21989 L
s
.85524 .21965 m
.85524 .21965 L
s
.85532 .21989 m
.85532 .21989 L
s
.8554 .22036 m
.8554 .22036 L
s
.85547 .21965 m
.85547 .21965 L
s
.85554 .2213 m
.85554 .2213 L
s
.85562 .21989 m
.85562 .21989 L
s
.85569 .2206 m
.85569 .2206 L
s
.85577 .22036 m
.85577 .22036 L
s
.85584 .22106 m
.85584 .22106 L
s
.85592 .22177 m
.85592 .22177 L
s
.85599 .22388 m
.85599 .22388 L
s
.85606 .22341 m
.85606 .22341 L
s
.85614 .22317 m
.85614 .22317 L
s
.85622 .22364 m
.85622 .22364 L
s
.85629 .22224 m
.85629 .22224 L
s
.85636 .22224 m
.85636 .22224 L
s
.85644 .222 m
.85644 .222 L
s
.85651 .22153 m
.85651 .22153 L
s
.85659 .21918 m
.85659 .21918 L
s
.85666 .21965 m
.85666 .21965 L
s
.85674 .21942 m
.85674 .21942 L
s
.8568 .21848 m
.8568 .21848 L
s
.85688 .21778 m
.85688 .21778 L
s
.85695 .21942 m
.85695 .21942 L
s
.85703 .22036 m
.85703 .22036 L
s
.8571 .21942 m
.8571 .21942 L
s
.85718 .22012 m
.85718 .22012 L
s
.85725 .22036 m
.85725 .22036 L
s
.85733 .22012 m
.85733 .22012 L
s
.8574 .2166 m
.8574 .2166 L
s
.85748 .21754 m
.85748 .21754 L
s
.85755 .21519 m
.85755 .21519 L
s
.85762 .21519 m
.85762 .21519 L
s
.8577 .21496 m
.8577 .21496 L
s
.85777 .21143 m
.85777 .21143 L
s
.85785 .21284 m
.85785 .21284 L
s
.85792 .21167 m
.85792 .21167 L
s
.858 .21261 m
.858 .21261 L
s
.85807 .2112 m
.85807 .2112 L
s
.85815 .2112 m
.85815 .2112 L
s
.85822 .2112 m
.85822 .2112 L
s
.8583 .21214 m
.8583 .21214 L
s
.85837 .21214 m
.85837 .21214 L
s
.85844 .2119 m
.85844 .2119 L
s
.85851 .21237 m
.85851 .21237 L
s
.85859 .21237 m
.85859 .21237 L
s
.85866 .21143 m
.85866 .21143 L
s
.85874 .20932 m
.85874 .20932 L
s
.85881 .21002 m
.85881 .21002 L
s
.85889 .2105 m
.85889 .2105 L
s
.85896 .21073 m
.85896 .21073 L
s
.85904 .20838 m
.85904 .20838 L
s
.85911 .20979 m
.85911 .20979 L
s
.85919 .20721 m
.85919 .20721 L
s
.85926 .20814 m
.85926 .20814 L
s
.85933 .20908 m
.85933 .20908 L
s
.85941 .20932 m
.85941 .20932 L
s
.85948 .20791 m
.85948 .20791 L
s
.85956 .20744 m
.85956 .20744 L
s
.85963 .20721 m
.85963 .20721 L
s
.85971 .20838 m
.85971 .20838 L
s
.85978 .20932 m
.85978 .20932 L
s
.85986 .20814 m
.85986 .20814 L
s
.85993 .20908 m
.85993 .20908 L
s
.86 .20838 m
.86 .20838 L
s
.86007 .20768 m
.86007 .20768 L
s
.86015 .20908 m
.86015 .20908 L
s
.86022 .20744 m
.86022 .20744 L
s
.8603 .20768 m
.8603 .20768 L
s
.86037 .2065 m
.86037 .2065 L
s
.86045 .2065 m
.86045 .2065 L
s
.86052 .20603 m
.86052 .20603 L
s
.8606 .20579 m
.8606 .20579 L
s
.86067 .20486 m
.86067 .20486 L
s
.86075 .20392 m
.86075 .20392 L
s
.86082 .20345 m
.86082 .20345 L
s
.86089 .20392 m
.86089 .20392 L
s
.86097 .20486 m
.86097 .20486 L
s
.86104 .20462 m
.86104 .20462 L
s
.86112 .2065 m
.86112 .2065 L
s
.86119 .2065 m
.86119 .2065 L
s
.86127 .20814 m
.86127 .20814 L
s
.86134 .20721 m
.86134 .20721 L
s
.86142 .20955 m
.86142 .20955 L
s
.86149 .20861 m
.86149 .20861 L
s
.86157 .20744 m
.86157 .20744 L
s
.86164 .20721 m
.86164 .20721 L
s
.86171 .20955 m
.86171 .20955 L
s
.86178 .21096 m
.86178 .21096 L
s
.86186 .20979 m
.86186 .20979 L
s
.86193 .21307 m
.86193 .21307 L
s
.86201 .21237 m
.86201 .21237 L
s
.86208 .21261 m
.86208 .21261 L
s
.86216 .20932 m
.86216 .20932 L
s
.86223 .20979 m
.86223 .20979 L
s
.86231 .21026 m
.86231 .21026 L
s
.86239 .21237 m
.86239 .21237 L
s
.86245 .21472 m
.86245 .21472 L
s
.86253 .21496 m
.86253 .21496 L
s
.8626 .21683 m
.8626 .21683 L
s
.86268 .21754 m
.86268 .21754 L
s
.86275 .21731 m
.86275 .21731 L
s
.86283 .21566 m
.86283 .21566 L
s
.8629 .21683 m
.8629 .21683 L
s
.86297 .21589 m
.86297 .21589 L
s
.86305 .21683 m
.86305 .21683 L
s
.86313 .21895 m
.86313 .21895 L
s
.8632 .21942 m
.8632 .21942 L
s
.86327 .22036 m
.86327 .22036 L
s
.86334 .22177 m
.86334 .22177 L
s
.86342 .22177 m
.86342 .22177 L
s
.86349 .22224 m
.86349 .22224 L
s
.86357 .22388 m
.86357 .22388 L
s
.86364 .22341 m
.86364 .22341 L
s
.86372 .22646 m
.86372 .22646 L
s
.86379 .22459 m
.86379 .22459 L
s
.86386 .22459 m
.86386 .22459 L
s
.86394 .22412 m
.86394 .22412 L
s
.86402 .22341 m
.86402 .22341 L
s
.86409 .22177 m
.86409 .22177 L
s
.86416 .21918 m
.86416 .21918 L
s
.86424 .22153 m
.86424 .22153 L
s
.86431 .22012 m
.86431 .22012 L
s
.86439 .22036 m
.86439 .22036 L
s
.86446 .21918 m
.86446 .21918 L
s
.86454 .22012 m
.86454 .22012 L
s
.86461 .21918 m
.86461 .21918 L
s
.86468 .21918 m
.86468 .21918 L
s
.86476 .21801 m
.86476 .21801 L
s
.86483 .21895 m
.86483 .21895 L
s
.8649 .21942 m
.8649 .21942 L
s
.86498 .21965 m
.86498 .21965 L
s
.86505 .22012 m
.86505 .22012 L
s
.86513 .21965 m
.86513 .21965 L
s
.8652 .22106 m
.8652 .22106 L
s
.86528 .2213 m
.86528 .2213 L
s
.86535 .22224 m
.86535 .22224 L
s
.86542 .22083 m
.86542 .22083 L
s
.8655 .2213 m
.8655 .2213 L
s
.86557 .22012 m
.86557 .22012 L
s
.86565 .22177 m
.86565 .22177 L
s
.86572 .22317 m
.86572 .22317 L
s
.8658 .22412 m
.8658 .22412 L
s
.86587 .22599 m
.86587 .22599 L
s
.86595 .22646 m
.86595 .22646 L
s
.86602 .22881 m
.86602 .22881 L
s
.8661 .22764 m
.8661 .22764 L
s
.86617 .22741 m
.86617 .22741 L
s
.86624 .2267 m
.86624 .2267 L
s
.86631 .22741 m
.86631 .22741 L
s
.86639 .22717 m
.86639 .22717 L
s
.86647 .22646 m
.86647 .22646 L
s
.86654 .22599 m
.86654 .22599 L
s
.86661 .22693 m
.86661 .22693 L
s
.86669 .22905 m
.86669 .22905 L
s
.86676 .22834 m
.86676 .22834 L
s
.86684 .22858 m
.86684 .22858 L
s
.86691 .22717 m
.86691 .22717 L
s
.86699 .22717 m
.86699 .22717 L
s
.86706 .22646 m
.86706 .22646 L
s
.86713 .22482 m
.86713 .22482 L
s
.86721 .22341 m
.86721 .22341 L
s
.86728 .22341 m
.86728 .22341 L
s
.86736 .22552 m
.86736 .22552 L
s
.86743 .22482 m
.86743 .22482 L
s
.86751 .22412 m
.86751 .22412 L
s
.86758 .22341 m
.86758 .22341 L
s
.86766 .22459 m
.86766 .22459 L
s
.86773 .22599 m
.86773 .22599 L
s
.8678 .22529 m
.8678 .22529 L
s
.86787 .22482 m
.86787 .22482 L
s
.86795 .22482 m
.86795 .22482 L
s
.86802 .22364 m
.86802 .22364 L
s
.8681 .22552 m
.8681 .22552 L
s
.86817 .22506 m
.86817 .22506 L
s
.86825 .22459 m
.86825 .22459 L
s
.86832 .22506 m
.86832 .22506 L
s
.8684 .22482 m
.8684 .22482 L
s
.86847 .22576 m
.86847 .22576 L
s
.86855 .22435 m
.86855 .22435 L
s
.86862 .22717 m
.86862 .22717 L
s
.86869 .22459 m
.86869 .22459 L
s
.86877 .22552 m
.86877 .22552 L
s
.86884 .22576 m
.86884 .22576 L
s
.86892 .22623 m
.86892 .22623 L
s
.86899 .22717 m
.86899 .22717 L
s
.86907 .22599 m
.86907 .22599 L
s
.86914 .22646 m
.86914 .22646 L
s
.86922 .22646 m
.86922 .22646 L
s
.86929 .22693 m
.86929 .22693 L
s
.86937 .22646 m
.86937 .22646 L
s
.86944 .22693 m
.86944 .22693 L
s
.86951 .22741 m
.86951 .22741 L
s
.86958 .22741 m
.86958 .22741 L
s
.86966 .22881 m
.86966 .22881 L
s
.86973 .22834 m
.86973 .22834 L
s
.86981 .22788 m
.86981 .22788 L
s
.86988 .22693 m
.86988 .22693 L
s
.86996 .22646 m
.86996 .22646 L
s
.87003 .22599 m
.87003 .22599 L
s
.87011 .22576 m
.87011 .22576 L
s
.87019 .22529 m
.87019 .22529 L
s
.87025 .22646 m
.87025 .22646 L
s
.87033 .22506 m
.87033 .22506 L
s
.8704 .22623 m
.8704 .22623 L
s
.87048 .22459 m
.87048 .22459 L
s
.87055 .22317 m
.87055 .22317 L
s
.87063 .22388 m
.87063 .22388 L
s
.8707 .222 m
.8707 .222 L
s
.87077 .22317 m
.87077 .22317 L
s
.87085 .22224 m
.87085 .22224 L
s
.87093 .22271 m
.87093 .22271 L
s
.871 .2213 m
.871 .2213 L
s
.87107 .2213 m
.87107 .2213 L
s
.87114 .22012 m
.87114 .22012 L
s
.87122 .2206 m
.87122 .2206 L
s
.87129 .22106 m
.87129 .22106 L
s
.87137 .2213 m
.87137 .2213 L
s
.87144 .22224 m
.87144 .22224 L
s
.87152 .2213 m
.87152 .2213 L
s
.87159 .22224 m
.87159 .22224 L
s
.87167 .2213 m
.87167 .2213 L
s
.87175 .22294 m
.87175 .22294 L
s
.87182 .222 m
.87182 .222 L
s
.87189 .22317 m
.87189 .22317 L
s
.87196 .22317 m
.87196 .22317 L
s
.87204 .22083 m
.87204 .22083 L
s
.87211 .21989 m
.87211 .21989 L
s
.87219 .21989 m
.87219 .21989 L
s
.87226 .21965 m
.87226 .21965 L
s
.87234 .2206 m
.87234 .2206 L
s
.87241 .22271 m
.87241 .22271 L
s
.87248 .22083 m
.87248 .22083 L
s
.87256 .2206 m
.87256 .2206 L
s
.87263 .22036 m
.87263 .22036 L
s
.8727 .21989 m
.8727 .21989 L
s
.87278 .22036 m
.87278 .22036 L
s
.87285 .22036 m
.87285 .22036 L
s
.87293 .21824 m
.87293 .21824 L
s
.873 .2166 m
.873 .2166 L
s
.87308 .21824 m
.87308 .21824 L
s
.87315 .21589 m
.87315 .21589 L
s
.87322 .2166 m
.87322 .2166 L
s
.8733 .21425 m
.8733 .21425 L
s
.87338 .21449 m
.87338 .21449 L
s
.87345 .21331 m
.87345 .21331 L
s
.87352 .21496 m
.87352 .21496 L
s
.8736 .21613 m
.8736 .21613 L
s
.87367 .2166 m
.87367 .2166 L
s
.87375 .21589 m
.87375 .21589 L
s
.87382 .21683 m
.87382 .21683 L
s
.8739 .21801 m
.8739 .21801 L
s
.87397 .21519 m
.87397 .21519 L
s
.87404 .21731 m
.87404 .21731 L
s
.87411 .21636 m
.87411 .21636 L
s
.87419 .21824 m
.87419 .21824 L
s
.87427 .21754 m
.87427 .21754 L
s
.87434 .21778 m
.87434 .21778 L
s
.87441 .21942 m
.87441 .21942 L
s
.87449 .2213 m
.87449 .2213 L
s
.87456 .21942 m
.87456 .21942 L
s
.87464 .22083 m
.87464 .22083 L
s
.87471 .22271 m
.87471 .22271 L
s
.87479 .22247 m
.87479 .22247 L
s
.87486 .22294 m
.87486 .22294 L
s
.87493 .22317 m
.87493 .22317 L
s
.87501 .22247 m
.87501 .22247 L
s
.87508 .22177 m
.87508 .22177 L
s
.87516 .22271 m
.87516 .22271 L
s
.87523 .22247 m
.87523 .22247 L
s
.87531 .22271 m
.87531 .22271 L
s
.87538 .22482 m
.87538 .22482 L
s
.87546 .22506 m
.87546 .22506 L
s
.87553 .22552 m
.87553 .22552 L
s
.8756 .22482 m
.8756 .22482 L
s
.87567 .22599 m
.87567 .22599 L
s
.87575 .22529 m
.87575 .22529 L
s
.87582 .22482 m
.87582 .22482 L
s
.8759 .22435 m
.8759 .22435 L
s
.87597 .22599 m
.87597 .22599 L
s
.87605 .22717 m
.87605 .22717 L
s
.87612 .22788 m
.87612 .22788 L
s
.8762 .22788 m
.8762 .22788 L
s
.87627 .22599 m
.87627 .22599 L
s
.87635 .22599 m
.87635 .22599 L
s
.87642 .22364 m
.87642 .22364 L
s
.87649 .22341 m
.87649 .22341 L
s
.87657 .2206 m
.87657 .2206 L
s
.87664 .222 m
.87664 .222 L
s
.87672 .2206 m
.87672 .2206 L
s
.87679 .2206 m
.87679 .2206 L
s
.87687 .22083 m
.87687 .22083 L
s
.87694 .22012 m
.87694 .22012 L
s
.87702 .2206 m
.87702 .2206 L
s
.87709 .21895 m
.87709 .21895 L
s
.87717 .21942 m
.87717 .21942 L
s
.87724 .21965 m
.87724 .21965 L
s
.87731 .21989 m
.87731 .21989 L
s
.87738 .21871 m
.87738 .21871 L
s
.87746 .21895 m
.87746 .21895 L
s
.87753 .21824 m
.87753 .21824 L
s
.87761 .21989 m
.87761 .21989 L
s
.87768 .21871 m
.87768 .21871 L
s
.87776 .21824 m
.87776 .21824 L
s
.87783 .21754 m
.87783 .21754 L
s
.87791 .2166 m
.87791 .2166 L
s
.87799 .21778 m
.87799 .21778 L
s
.87805 .21613 m
.87805 .21613 L
s
.87813 .21613 m
.87813 .21613 L
s
.8782 .21613 m
.8782 .21613 L
s
.87828 .2166 m
.87828 .2166 L
s
.87835 .21754 m
.87835 .21754 L
s
.87843 .21566 m
.87843 .21566 L
s
.8785 .21449 m
.8785 .21449 L
s
.87858 .21496 m
.87858 .21496 L
s
.87865 .21496 m
.87865 .21496 L
s
.87873 .21425 m
.87873 .21425 L
s
.8788 .21566 m
.8788 .21566 L
s
.87887 .21589 m
.87887 .21589 L
s
.87894 .21731 m
.87894 .21731 L
s
.87902 .21754 m
.87902 .21754 L
s
.87909 .21871 m
.87909 .21871 L
s
.87917 .21848 m
.87917 .21848 L
s
.87924 .21707 m
.87924 .21707 L
s
.87932 .21942 m
.87932 .21942 L
s
.87939 .21918 m
.87939 .21918 L
s
.87947 .22036 m
.87947 .22036 L
s
.87955 .21989 m
.87955 .21989 L
s
.87962 .21965 m
.87962 .21965 L
s
.87969 .21754 m
.87969 .21754 L
s
.87976 .21871 m
.87976 .21871 L
s
.87984 .21707 m
.87984 .21707 L
s
.87991 .21801 m
.87991 .21801 L
s
.87999 .21895 m
.87999 .21895 L
s
.88006 .21824 m
.88006 .21824 L
s
.88014 .21848 m
.88014 .21848 L
s
.88021 .21707 m
.88021 .21707 L
s
.88029 .21824 m
.88029 .21824 L
s
.88036 .21707 m
.88036 .21707 L
s
.88043 .21848 m
.88043 .21848 L
s
.8805 .21707 m
.8805 .21707 L
s
.88058 .21801 m
.88058 .21801 L
s
.88065 .21566 m
.88065 .21566 L
s
.88073 .21754 m
.88073 .21754 L
s
.8808 .21801 m
.8808 .21801 L
s
.88088 .21683 m
.88088 .21683 L
s
.88095 .21707 m
.88095 .21707 L
s
.88102 .21589 m
.88102 .21589 L
s
.8811 .21449 m
.8811 .21449 L
s
.88118 .21284 m
.88118 .21284 L
s
.88125 .21307 m
.88125 .21307 L
s
.88132 .21167 m
.88132 .21167 L
s
.8814 .21143 m
.8814 .21143 L
s
.88147 .2112 m
.88147 .2112 L
s
.88155 .2112 m
.88155 .2112 L
s
.88162 .20979 m
.88162 .20979 L
s
.8817 .20955 m
.8817 .20955 L
s
.88177 .2105 m
.88177 .2105 L
s
.88184 .20932 m
.88184 .20932 L
s
.88192 .20861 m
.88192 .20861 L
s
.882 .20838 m
.882 .20838 L
s
.88207 .20908 m
.88207 .20908 L
s
.88214 .20861 m
.88214 .20861 L
s
.88221 .21002 m
.88221 .21002 L
s
.88229 .20955 m
.88229 .20955 L
s
.88236 .20814 m
.88236 .20814 L
s
.88244 .20814 m
.88244 .20814 L
s
.88251 .20838 m
.88251 .20838 L
s
.88259 .20908 m
.88259 .20908 L
s
.88266 .20721 m
.88266 .20721 L
s
.88273 .20885 m
.88273 .20885 L
s
.88281 .20768 m
.88281 .20768 L
s
.88288 .20861 m
.88288 .20861 L
s
.88296 .20744 m
.88296 .20744 L
s
.88303 .20626 m
.88303 .20626 L
s
.88311 .20439 m
.88311 .20439 L
s
.88318 .20486 m
.88318 .20486 L
s
.88326 .20532 m
.88326 .20532 L
s
.88333 .20509 m
.88333 .20509 L
s
.8834 .20532 m
.8834 .20532 L
s
.88347 .20486 m
.88347 .20486 L
s
.88355 .20697 m
.88355 .20697 L
s
.88363 .20532 m
.88363 .20532 L
s
.8837 .20697 m
.8837 .20697 L
s
.88377 .20791 m
.88377 .20791 L
s
.88385 .20908 m
.88385 .20908 L
s
.88392 .20768 m
.88392 .20768 L
s
.884 .20674 m
.884 .20674 L
s
.88407 .20721 m
.88407 .20721 L
s
.88415 .20768 m
.88415 .20768 L
s
.88422 .20838 m
.88422 .20838 L
s
.88429 .20932 m
.88429 .20932 L
s
.88437 .20861 m
.88437 .20861 L
s
.88444 .20861 m
.88444 .20861 L
s
.88452 .20979 m
.88452 .20979 L
s
.88459 .20979 m
.88459 .20979 L
s
.88467 .2112 m
.88467 .2112 L
s
.88474 .2105 m
.88474 .2105 L
s
.88482 .21026 m
.88482 .21026 L
s
.88489 .21026 m
.88489 .21026 L
s
.88497 .2105 m
.88497 .2105 L
s
.88504 .21002 m
.88504 .21002 L
s
.88511 .20955 m
.88511 .20955 L
s
.88518 .21026 m
.88518 .21026 L
s
.88526 .21002 m
.88526 .21002 L
s
.88533 .21026 m
.88533 .21026 L
s
.88541 .21002 m
.88541 .21002 L
s
.88548 .2105 m
.88548 .2105 L
s
.88556 .21002 m
.88556 .21002 L
s
.88563 .21096 m
.88563 .21096 L
s
.88571 .2105 m
.88571 .2105 L
s
.88579 .2105 m
.88579 .2105 L
s
.88585 .2112 m
.88585 .2112 L
s
.88593 .20885 m
.88593 .20885 L
s
.886 .2112 m
.886 .2112 L
s
.88608 .21096 m
.88608 .21096 L
s
.88615 .21167 m
.88615 .21167 L
s
.88623 .20979 m
.88623 .20979 L
s
.8863 .2112 m
.8863 .2112 L
s
.88638 .21214 m
.88638 .21214 L
s
.88645 .21331 m
.88645 .21331 L
s
.88653 .21378 m
.88653 .21378 L
s
.8866 .21237 m
.8866 .21237 L
s
.88667 .2119 m
.88667 .2119 L
s
.88674 .21237 m
.88674 .21237 L
s
.88682 .21307 m
.88682 .21307 L
s
.88689 .21284 m
.88689 .21284 L
s
.88697 .21355 m
.88697 .21355 L
s
.88704 .21214 m
.88704 .21214 L
s
.88712 .21331 m
.88712 .21331 L
s
.88719 .21425 m
.88719 .21425 L
s
.88727 .21355 m
.88727 .21355 L
s
.88735 .21542 m
.88735 .21542 L
s
.88742 .21378 m
.88742 .21378 L
s
.88749 .21472 m
.88749 .21472 L
s
.88756 .21402 m
.88756 .21402 L
s
.88764 .21331 m
.88764 .21331 L
s
.88771 .21355 m
.88771 .21355 L
s
.88779 .21496 m
.88779 .21496 L
s
.88786 .21636 m
.88786 .21636 L
s
.88794 .21707 m
.88794 .21707 L
s
.88801 .21707 m
.88801 .21707 L
s
.88809 .21871 m
.88809 .21871 L
s
.88816 .21965 m
.88816 .21965 L
s
.88824 .21871 m
.88824 .21871 L
s
.8883 .21989 m
.8883 .21989 L
s
.88838 .21778 m
.88838 .21778 L
s
.88845 .21801 m
.88845 .21801 L
s
.88853 .21519 m
.88853 .21519 L
s
.8886 .21613 m
.8886 .21613 L
s
.88868 .21425 m
.88868 .21425 L
s
.88875 .21425 m
.88875 .21425 L
s
.88883 .21284 m
.88883 .21284 L
s
.88891 .21307 m
.88891 .21307 L
s
.88898 .21284 m
.88898 .21284 L
s
.88905 .21355 m
.88905 .21355 L
s
.88912 .21307 m
.88912 .21307 L
s
.8892 .21284 m
.8892 .21284 L
s
.88927 .21472 m
.88927 .21472 L
s
.88935 .21378 m
.88935 .21378 L
s
.88942 .21261 m
.88942 .21261 L
s
.8895 .2119 m
.8895 .2119 L
s
.88957 .21237 m
.88957 .21237 L
s
.88964 .2112 m
.88964 .2112 L
s
.88972 .21096 m
.88972 .21096 L
s
.8898 .21143 m
.8898 .21143 L
s
.88987 .2105 m
.88987 .2105 L
s
.88994 .21261 m
.88994 .21261 L
s
.89001 .21261 m
.89001 .21261 L
s
.89009 .21378 m
.89009 .21378 L
s
.89016 .21261 m
.89016 .21261 L
s
.89024 .21355 m
.89024 .21355 L
s
.89031 .21307 m
.89031 .21307 L
s
.89039 .21284 m
.89039 .21284 L
s
.89046 .21237 m
.89046 .21237 L
s
.89054 .21143 m
.89054 .21143 L
s
.89062 .21355 m
.89062 .21355 L
s
.89068 .21237 m
.89068 .21237 L
s
.89076 .21449 m
.89076 .21449 L
s
.89083 .21331 m
.89083 .21331 L
s
.89091 .21496 m
.89091 .21496 L
s
.89098 .21472 m
.89098 .21472 L
s
.89106 .21472 m
.89106 .21472 L
s
.89113 .21237 m
.89113 .21237 L
s
.89121 .21378 m
.89121 .21378 L
s
.89127 .21425 m
.89127 .21425 L
s
.89135 .21519 m
.89135 .21519 L
s
.89143 .2166 m
.89143 .2166 L
s
.8915 .21519 m
.8915 .21519 L
s
.89157 .21778 m
.89157 .21778 L
s
.89165 .21613 m
.89165 .21613 L
s
.89172 .21566 m
.89172 .21566 L
s
.8918 .21542 m
.8918 .21542 L
s
.89187 .21707 m
.89187 .21707 L
s
.89195 .21636 m
.89195 .21636 L
s
.89202 .21566 m
.89202 .21566 L
s
.89209 .21613 m
.89209 .21613 L
s
.89217 .21731 m
.89217 .21731 L
s
.89225 .21731 m
.89225 .21731 L
s
.89232 .21683 m
.89232 .21683 L
s
.89239 .21942 m
.89239 .21942 L
s
.89247 .21965 m
.89247 .21965 L
s
.89254 .22036 m
.89254 .22036 L
s
.89262 .21942 m
.89262 .21942 L
s
.89269 .21989 m
.89269 .21989 L
s
.89277 .21965 m
.89277 .21965 L
s
.89284 .21895 m
.89284 .21895 L
s
.89291 .21989 m
.89291 .21989 L
s
.89298 .21848 m
.89298 .21848 L
s
.89306 .21848 m
.89306 .21848 L
s
.89313 .21754 m
.89313 .21754 L
s
.89321 .22012 m
.89321 .22012 L
s
.89328 .21989 m
.89328 .21989 L
s
.89336 .22271 m
.89336 .22271 L
s
.89343 .22106 m
.89343 .22106 L
s
.89351 .21965 m
.89351 .21965 L
s
.89359 .22036 m
.89359 .22036 L
s
.89365 .21895 m
.89365 .21895 L
s
.89373 .21683 m
.89373 .21683 L
s
.8938 .21613 m
.8938 .21613 L
s
.89388 .21683 m
.89388 .21683 L
s
.89395 .2166 m
.89395 .2166 L
s
.89403 .21707 m
.89403 .21707 L
s
.8941 .21519 m
.8941 .21519 L
s
.89418 .21636 m
.89418 .21636 L
s
.89425 .21542 m
.89425 .21542 L
s
.89433 .21566 m
.89433 .21566 L
s
.8944 .21542 m
.8944 .21542 L
s
.89447 .21472 m
.89447 .21472 L
s
.89454 .21425 m
.89454 .21425 L
s
.89462 .21331 m
.89462 .21331 L
s
.89469 .21331 m
.89469 .21331 L
s
.89477 .21402 m
.89477 .21402 L
s
.89484 .21519 m
.89484 .21519 L
s
.89492 .21542 m
.89492 .21542 L
s
.89499 .21566 m
.89499 .21566 L
s
.89507 .21425 m
.89507 .21425 L
s
.89515 .21449 m
.89515 .21449 L
s
.89522 .21496 m
.89522 .21496 L
s
.89529 .21378 m
.89529 .21378 L
s
.89536 .21307 m
.89536 .21307 L
s
.89544 .21237 m
.89544 .21237 L
s
.89551 .21519 m
.89551 .21519 L
s
.89559 .21589 m
.89559 .21589 L
s
.89566 .21731 m
.89566 .21731 L
s
.89574 .21566 m
.89574 .21566 L
s
.89581 .21355 m
.89581 .21355 L
s
.89589 .21143 m
.89589 .21143 L
s
.89596 .21261 m
.89596 .21261 L
s
.89604 .21284 m
.89604 .21284 L
s
.8961 .21331 m
.8961 .21331 L
s
.89618 .21331 m
.89618 .21331 L
s
.89625 .21167 m
.89625 .21167 L
s
.89633 .21307 m
.89633 .21307 L
s
.8964 .21143 m
.8964 .21143 L
s
.89648 .21237 m
.89648 .21237 L
s
.89655 .21096 m
.89655 .21096 L
s
.89663 .21096 m
.89663 .21096 L
s
.89671 .21143 m
.89671 .21143 L
s
.89678 .21143 m
.89678 .21143 L
s
.89685 .21073 m
.89685 .21073 L
s
.89692 .21002 m
.89692 .21002 L
s
.897 .21026 m
.897 .21026 L
s
.89707 .2105 m
.89707 .2105 L
s
.89715 .21096 m
.89715 .21096 L
s
.89722 .21096 m
.89722 .21096 L
s
.8973 .21331 m
.8973 .21331 L
s
.89737 .21237 m
.89737 .21237 L
s
.89745 .21402 m
.89745 .21402 L
s
.89752 .21496 m
.89752 .21496 L
s
.8976 .21566 m
.8976 .21566 L
s
.89767 .21472 m
.89767 .21472 L
s
.89774 .21566 m
.89774 .21566 L
s
.89781 .21613 m
.89781 .21613 L
s
.89789 .21449 m
.89789 .21449 L
s
.89796 .21496 m
.89796 .21496 L
s
.89804 .21143 m
.89804 .21143 L
s
.89811 .2119 m
.89811 .2119 L
s
.89819 .21167 m
.89819 .21167 L
s
.89826 .21237 m
.89826 .21237 L
s
.89834 .21167 m
.89834 .21167 L
s
.89842 .21237 m
.89842 .21237 L
s
.89848 .21237 m
.89848 .21237 L
s
.89856 .21261 m
.89856 .21261 L
s
.89863 .21284 m
.89863 .21284 L
s
.89871 .21261 m
.89871 .21261 L
s
.89878 .21355 m
.89878 .21355 L
s
.89886 .2119 m
.89886 .2119 L
s
.89893 .21402 m
.89893 .21402 L
s
.89901 .21425 m
.89901 .21425 L
s
.89908 .21496 m
.89908 .21496 L
s
.89916 .21542 m
.89916 .21542 L
s
.89923 .21519 m
.89923 .21519 L
s
.8993 .21378 m
.8993 .21378 L
s
.89937 .21425 m
.89937 .21425 L
s
.89945 .21449 m
.89945 .21449 L
s
.89952 .21355 m
.89952 .21355 L
s
.8996 .21472 m
.8996 .21472 L
s
.89967 .21355 m
.89967 .21355 L
s
.89975 .21402 m
.89975 .21402 L
s
.89982 .21449 m
.89982 .21449 L
s
.89989 .21425 m
.89989 .21425 L
s
.89997 .21355 m
.89997 .21355 L
s
.90005 .21378 m
.90005 .21378 L
s
.90012 .21449 m
.90012 .21449 L
s
.90019 .21566 m
.90019 .21566 L
s
.90027 .21425 m
.90027 .21425 L
s
.90034 .21331 m
.90034 .21331 L
s
.90042 .21496 m
.90042 .21496 L
s
.90049 .21402 m
.90049 .21402 L
s
.90057 .21496 m
.90057 .21496 L
s
.90064 .21566 m
.90064 .21566 L
s
.90071 .21519 m
.90071 .21519 L
s
.90079 .2166 m
.90079 .2166 L
s
.90086 .21636 m
.90086 .21636 L
s
.90093 .21519 m
.90093 .21519 L
s
.90101 .21143 m
.90101 .21143 L
s
.90108 .2119 m
.90108 .2119 L
s
.90116 .21214 m
.90116 .21214 L
s
.90123 .21261 m
.90123 .21261 L
s
.90131 .21214 m
.90131 .21214 L
s
.90139 .21167 m
.90139 .21167 L
s
.90145 .21026 m
.90145 .21026 L
s
.90153 .21073 m
.90153 .21073 L
s
.9016 .20979 m
.9016 .20979 L
s
.90168 .20932 m
.90168 .20932 L
s
.90175 .21096 m
.90175 .21096 L
s
.90183 .20955 m
.90183 .20955 L
s
.9019 .21073 m
.9019 .21073 L
s
.90198 .20908 m
.90198 .20908 L
s
.90205 .21002 m
.90205 .21002 L
s
.90213 .20908 m
.90213 .20908 L
s
.9022 .21002 m
.9022 .21002 L
s
.90227 .20932 m
.90227 .20932 L
s
.90234 .20861 m
.90234 .20861 L
s
.90242 .20861 m
.90242 .20861 L
s
.9025 .20814 m
.9025 .20814 L
s
.90257 .20885 m
.90257 .20885 L
s
.90264 .20744 m
.90264 .20744 L
s
.90272 .20838 m
.90272 .20838 L
s
.90279 .20721 m
.90279 .20721 L
s
.90287 .20791 m
.90287 .20791 L
s
.90295 .20674 m
.90295 .20674 L
s
.90302 .2065 m
.90302 .2065 L
s
.90309 .20579 m
.90309 .20579 L
s
.90316 .20392 m
.90316 .20392 L
s
.90324 .20368 m
.90324 .20368 L
s
.90331 .20204 m
.90331 .20204 L
s
.90339 .2004 m
.90339 .2004 L
s
.90346 .20063 m
.90346 .20063 L
s
.90354 .20321 m
.90354 .20321 L
s
.90361 .20227 m
.90361 .20227 L
s
.90369 .20368 m
.90369 .20368 L
s
.90376 .2025 m
.90376 .2025 L
s
.90384 .20297 m
.90384 .20297 L
s
.9039 .20227 m
.9039 .20227 L
s
.90398 .20297 m
.90398 .20297 L
s
.90405 .20509 m
.90405 .20509 L
s
.90413 .20462 m
.90413 .20462 L
s
.9042 .20439 m
.9042 .20439 L
s
.90428 .20321 m
.90428 .20321 L
s
.90435 .20274 m
.90435 .20274 L
s
.90443 .20274 m
.90443 .20274 L
s
.90451 .20415 m
.90451 .20415 L
s
.90458 .2025 m
.90458 .2025 L
s
.90465 .2011 m
.90465 .2011 L
s
.90472 .2011 m
.90472 .2011 L
s
.9048 .20204 m
.9048 .20204 L
s
.90487 .2025 m
.90487 .2025 L
s
.90495 .20439 m
.90495 .20439 L
s
.90502 .20439 m
.90502 .20439 L
s
.9051 .20415 m
.9051 .20415 L
s
.90517 .20462 m
.90517 .20462 L
s
.90525 .20462 m
.90525 .20462 L
s
.90532 .20603 m
.90532 .20603 L
s
.9054 .20509 m
.9054 .20509 L
s
.90547 .20486 m
.90547 .20486 L
s
.90554 .20392 m
.90554 .20392 L
s
.90561 .20392 m
.90561 .20392 L
s
.90569 .20439 m
.90569 .20439 L
s
.90576 .20345 m
.90576 .20345 L
s
.90584 .20368 m
.90584 .20368 L
s
.90591 .20227 m
.90591 .20227 L
s
.90599 .20227 m
.90599 .20227 L
s
.90606 .20227 m
.90606 .20227 L
s
.90614 .2011 m
.90614 .2011 L
s
.90622 .19968 m
.90622 .19968 L
s
.90628 .20016 m
.90628 .20016 L
s
.90636 .2004 m
.90636 .2004 L
s
.90643 .20016 m
.90643 .20016 L
s
.90651 .20227 m
.90651 .20227 L
s
.90658 .20227 m
.90658 .20227 L
s
.90666 .20274 m
.90666 .20274 L
s
.90673 .2011 m
.90673 .2011 L
s
.90681 .19968 m
.90681 .19968 L
s
.90688 .19875 m
.90688 .19875 L
s
.90696 .19945 m
.90696 .19945 L
s
.90703 .19851 m
.90703 .19851 L
s
.9071 .19898 m
.9071 .19898 L
s
.90717 .19898 m
.90717 .19898 L
s
.90725 .19781 m
.90725 .19781 L
s
.90732 .19898 m
.90732 .19898 L
s
.9074 .19781 m
.9074 .19781 L
s
.90747 .20086 m
.90747 .20086 L
s
.90755 .19992 m
.90755 .19992 L
s
.90762 .20133 m
.90762 .20133 L
s
.90769 .2025 m
.90769 .2025 L
s
.90777 .2018 m
.90777 .2018 L
s
.90785 .2025 m
.90785 .2025 L
s
.90792 .20297 m
.90792 .20297 L
s
.90799 .2025 m
.90799 .2025 L
s
.90807 .2018 m
.90807 .2018 L
s
.90814 .20133 m
.90814 .20133 L
s
.90822 .2011 m
.90822 .2011 L
s
.90829 .2025 m
.90829 .2025 L
s
.90837 .2025 m
.90837 .2025 L
s
.90844 .20486 m
.90844 .20486 L
s
.90851 .20415 m
.90851 .20415 L
s
.90859 .20556 m
.90859 .20556 L
s
.90867 .20462 m
.90867 .20462 L
s
.90873 .20674 m
.90873 .20674 L
s
.90881 .20791 m
.90881 .20791 L
s
.90888 .20791 m
.90888 .20791 L
s
.90896 .20814 m
.90896 .20814 L
s
.90903 .2065 m
.90903 .2065 L
s
.90911 .20744 m
.90911 .20744 L
s
.90919 .20814 m
.90919 .20814 L
s
.90925 .20814 m
.90925 .20814 L
s
.90933 .20861 m
.90933 .20861 L
s
.9094 .20908 m
.9094 .20908 L
s
.90948 .20861 m
.90948 .20861 L
s
.90955 .20861 m
.90955 .20861 L
s
.90963 .20791 m
.90963 .20791 L
s
.9097 .20791 m
.9097 .20791 L
s
.90978 .20721 m
.90978 .20721 L
s
.90985 .20721 m
.90985 .20721 L
s
.90993 .20721 m
.90993 .20721 L
s
.91 .20509 m
.91 .20509 L
s
.91007 .20744 m
.91007 .20744 L
s
.91014 .20768 m
.91014 .20768 L
s
.91022 .20721 m
.91022 .20721 L
s
.9103 .20626 m
.9103 .20626 L
s
.91037 .20744 m
.91037 .20744 L
s
.91044 .20626 m
.91044 .20626 L
s
.91052 .20556 m
.91052 .20556 L
s
.91059 .20674 m
.91059 .20674 L
s
.91067 .2065 m
.91067 .2065 L
s
.91075 .20838 m
.91075 .20838 L
s
.91082 .20861 m
.91082 .20861 L
s
.91089 .2105 m
.91089 .2105 L
s
.91096 .21073 m
.91096 .21073 L
s
.91104 .20979 m
.91104 .20979 L
s
.91111 .2119 m
.91111 .2119 L
s
.91119 .21143 m
.91119 .21143 L
s
.91126 .21331 m
.91126 .21331 L
s
.91134 .21284 m
.91134 .21284 L
s
.91141 .21261 m
.91141 .21261 L
s
.91149 .2119 m
.91149 .2119 L
s
.91156 .21167 m
.91156 .21167 L
s
.91164 .21002 m
.91164 .21002 L
s
.9117 .21167 m
.9117 .21167 L
s
.91178 .20814 m
.91178 .20814 L
s
.91185 .20932 m
.91185 .20932 L
s
.91193 .20908 m
.91193 .20908 L
s
.912 .20861 m
.912 .20861 L
s
.91208 .21002 m
.91208 .21002 L
s
.91215 .20721 m
.91215 .20721 L
s
.91223 .20674 m
.91223 .20674 L
s
.91231 .20626 m
.91231 .20626 L
s
.91238 .2065 m
.91238 .2065 L
s
.91245 .20486 m
.91245 .20486 L
s
.91252 .20532 m
.91252 .20532 L
s
.9126 .20462 m
.9126 .20462 L
s
.91267 .20579 m
.91267 .20579 L
s
.91275 .2065 m
.91275 .2065 L
s
.91282 .20768 m
.91282 .20768 L
s
.9129 .20814 m
.9129 .20814 L
s
.91297 .20814 m
.91297 .20814 L
s
.91305 .20791 m
.91305 .20791 L
s
.91312 .20814 m
.91312 .20814 L
s
.9132 .20744 m
.9132 .20744 L
s
.91327 .20721 m
.91327 .20721 L
s
.91334 .20768 m
.91334 .20768 L
s
.91341 .20532 m
.91341 .20532 L
s
.91349 .20721 m
.91349 .20721 L
s
.91356 .20674 m
.91356 .20674 L
s
.91364 .20579 m
.91364 .20579 L
s
.91371 .20532 m
.91371 .20532 L
s
.91379 .20392 m
.91379 .20392 L
s
.91387 .20462 m
.91387 .20462 L
s
.91394 .20297 m
.91394 .20297 L
s
.91402 .20415 m
.91402 .20415 L
s
.91408 .20297 m
.91408 .20297 L
s
.91416 .20345 m
.91416 .20345 L
s
.91423 .20204 m
.91423 .20204 L
s
.91431 .20227 m
.91431 .20227 L
s
.91438 .20063 m
.91438 .20063 L
s
.91446 .2018 m
.91446 .2018 L
s
.91453 .20157 m
.91453 .20157 L
s
.91461 .2004 m
.91461 .2004 L
s
.91468 .20157 m
.91468 .20157 L
s
.91476 .20016 m
.91476 .20016 L
s
.91483 .20204 m
.91483 .20204 L
s
.9149 .2018 m
.9149 .2018 L
s
.91497 .20204 m
.91497 .20204 L
s
.91505 .2004 m
.91505 .2004 L
s
.91512 .20086 m
.91512 .20086 L
s
.9152 .2018 m
.9152 .2018 L
s
.91527 .2004 m
.91527 .2004 L
s
.91535 .20063 m
.91535 .20063 L
s
.91542 .20204 m
.91542 .20204 L
s
.9155 .20274 m
.9155 .20274 L
s
.91558 .20368 m
.91558 .20368 L
s
.91565 .20509 m
.91565 .20509 L
s
.91572 .20509 m
.91572 .20509 L
s
.91579 .20579 m
.91579 .20579 L
s
.91587 .20626 m
.91587 .20626 L
s
.91594 .20674 m
.91594 .20674 L
s
.91602 .20697 m
.91602 .20697 L
s
.91609 .20462 m
.91609 .20462 L
s
.91617 .20368 m
.91617 .20368 L
s
.91624 .20297 m
.91624 .20297 L
s
.91631 .20321 m
.91631 .20321 L
s
.91639 .20274 m
.91639 .20274 L
s
.91647 .20368 m
.91647 .20368 L
s
.91653 .20227 m
.91653 .20227 L
s
.91661 .2011 m
.91661 .2011 L
s
.91668 .2011 m
.91668 .2011 L
s
.91676 .19968 m
.91676 .19968 L
s
.91683 .2011 m
.91683 .2011 L
s
.91691 .19992 m
.91691 .19992 L
s
.91699 .20321 m
.91699 .20321 L
s
.91705 .2025 m
.91705 .2025 L
s
.91713 .20368 m
.91713 .20368 L
s
.91721 .20297 m
.91721 .20297 L
s
.91728 .20274 m
.91728 .20274 L
s
.91735 .20297 m
.91735 .20297 L
s
.91743 .20274 m
.91743 .20274 L
s
.9175 .20297 m
.9175 .20297 L
s
.91758 .2018 m
.91758 .2018 L
s
.91765 .20321 m
.91765 .20321 L
s
.91773 .20157 m
.91773 .20157 L
s
.9178 .2025 m
.9178 .2025 L
s
.91787 .20439 m
.91787 .20439 L
s
.91794 .20532 m
.91794 .20532 L
s
.91802 .20486 m
.91802 .20486 L
s
.9181 .20486 m
.9181 .20486 L
s
.91817 .20392 m
.91817 .20392 L
s
.91824 .20439 m
.91824 .20439 L
s
.91832 .20556 m
.91832 .20556 L
s
.91839 .20509 m
.91839 .20509 L
s
.91847 .20603 m
.91847 .20603 L
s
.91855 .20532 m
.91855 .20532 L
s
.91862 .2065 m
.91862 .2065 L
s
.91869 .20532 m
.91869 .20532 L
s
.91876 .20674 m
.91876 .20674 L
s
.91884 .20626 m
.91884 .20626 L
s
.91891 .20861 m
.91891 .20861 L
s
.91899 .20838 m
.91899 .20838 L
s
.91906 .20955 m
.91906 .20955 L
s
.91914 .20838 m
.91914 .20838 L
s
.91921 .20932 m
.91921 .20932 L
s
.91929 .20908 m
.91929 .20908 L
s
.91936 .20814 m
.91936 .20814 L
s
.91944 .20838 m
.91944 .20838 L
s
.9195 .20791 m
.9195 .20791 L
s
.91958 .21073 m
.91958 .21073 L
s
.91965 .2112 m
.91965 .2112 L
s
.91973 .21237 m
.91973 .21237 L
s
.9198 .2119 m
.9198 .2119 L
s
.91988 .21307 m
.91988 .21307 L
s
.91995 .2119 m
.91995 .2119 L
s
.92003 .21237 m
.92003 .21237 L
s
.92011 .21237 m
.92011 .21237 L
s
.92018 .21167 m
.92018 .21167 L
s
.92025 .21143 m
.92025 .21143 L
s
.92032 .21143 m
.92032 .21143 L
s
.9204 .21167 m
.9204 .21167 L
s
.92047 .21073 m
.92047 .21073 L
s
.92055 .21026 m
.92055 .21026 L
s
.92062 .21002 m
.92062 .21002 L
s
.9207 .2105 m
.9207 .2105 L
s
.92077 .21002 m
.92077 .21002 L
s
.92085 .21002 m
.92085 .21002 L
s
.92092 .21143 m
.92092 .21143 L
s
.921 .20861 m
.921 .20861 L
s
.92107 .20908 m
.92107 .20908 L
s
.92114 .20768 m
.92114 .20768 L
s
.92121 .20908 m
.92121 .20908 L
s
.92129 .20791 m
.92129 .20791 L
s
.92136 .21002 m
.92136 .21002 L
s
.92144 .20838 m
.92144 .20838 L
s
.92151 .20885 m
.92151 .20885 L
s
.92159 .20768 m
.92159 .20768 L
s
.92167 .2065 m
.92167 .2065 L
s
.92174 .2065 m
.92174 .2065 L
s
.92182 .20415 m
.92182 .20415 L
s
.92188 .2065 m
.92188 .2065 L
s
.92196 .20415 m
.92196 .20415 L
s
.92203 .20556 m
.92203 .20556 L
s
.92211 .20415 m
.92211 .20415 L
s
.92218 .20532 m
.92218 .20532 L
s
.92226 .20768 m
.92226 .20768 L
s
.92233 .20861 m
.92233 .20861 L
s
.92241 .20768 m
.92241 .20768 L
s
.92248 .20768 m
.92248 .20768 L
s
.92256 .21002 m
.92256 .21002 L
s
.92263 .20979 m
.92263 .20979 L
s
.9227 .21167 m
.9227 .21167 L
s
.92277 .21002 m
.92277 .21002 L
s
.92285 .21073 m
.92285 .21073 L
s
.92292 .21002 m
.92292 .21002 L
s
.923 .20932 m
.923 .20932 L
s
.92307 .21026 m
.92307 .21026 L
s
.92315 .21096 m
.92315 .21096 L
s
.92322 .21143 m
.92322 .21143 L
s
.9233 .21096 m
.9233 .21096 L
s
.92338 .21167 m
.92338 .21167 L
s
.92345 .21073 m
.92345 .21073 L
s
.92352 .21284 m
.92352 .21284 L
s
.92359 .21143 m
.92359 .21143 L
s
.92367 .21073 m
.92367 .21073 L
s
.92374 .20838 m
.92374 .20838 L
s
.92382 .20791 m
.92382 .20791 L
s
.92389 .20626 m
.92389 .20626 L
s
.92397 .20556 m
.92397 .20556 L
s
.92404 .20556 m
.92404 .20556 L
s
.92412 .20321 m
.92412 .20321 L
s
.92419 .20486 m
.92419 .20486 L
s
.92427 .20556 m
.92427 .20556 L
s
.92433 .20861 m
.92433 .20861 L
s
.92441 .20932 m
.92441 .20932 L
s
.92448 .21167 m
.92448 .21167 L
s
.92456 .20908 m
.92456 .20908 L
s
.92463 .21073 m
.92463 .21073 L
s
.92471 .20908 m
.92471 .20908 L
s
.92479 .2105 m
.92479 .2105 L
s
.92485 .2105 m
.92485 .2105 L
s
.92493 .20861 m
.92493 .20861 L
s
.92501 .21073 m
.92501 .21073 L
s
.92508 .2105 m
.92508 .2105 L
s
.92515 .21237 m
.92515 .21237 L
s
.92523 .21073 m
.92523 .21073 L
s
.9253 .21096 m
.9253 .21096 L
s
.92538 .20885 m
.92538 .20885 L
s
.92545 .20955 m
.92545 .20955 L
s
.92553 .21002 m
.92553 .21002 L
s
.9256 .20932 m
.9256 .20932 L
s
.92567 .20932 m
.92567 .20932 L
s
.92575 .20955 m
.92575 .20955 L
s
.92583 .2112 m
.92583 .2112 L
s
.9259 .20955 m
.9259 .20955 L
s
.92597 .20838 m
.92597 .20838 L
s
.92604 .20674 m
.92604 .20674 L
s
.92612 .20791 m
.92612 .20791 L
s
.92619 .20838 m
.92619 .20838 L
s
.92627 .20721 m
.92627 .20721 L
s
.92635 .20768 m
.92635 .20768 L
s
.92642 .20768 m
.92642 .20768 L
s
.92649 .20744 m
.92649 .20744 L
s
.92656 .20674 m
.92656 .20674 L
s
.92664 .20768 m
.92664 .20768 L
s
.92671 .20744 m
.92671 .20744 L
s
.92679 .20626 m
.92679 .20626 L
s
.92686 .20415 m
.92686 .20415 L
s
.92694 .20579 m
.92694 .20579 L
s
.92701 .20532 m
.92701 .20532 L
s
.92709 .20415 m
.92709 .20415 L
s
.92716 .20392 m
.92716 .20392 L
s
.92724 .20321 m
.92724 .20321 L
s
.9273 .2025 m
.9273 .2025 L
s
.92738 .20227 m
.92738 .20227 L
s
.92746 .20321 m
.92746 .20321 L
s
.92753 .2025 m
.92753 .2025 L
s
.9276 .2018 m
.9276 .2018 L
s
.92768 .2004 m
.92768 .2004 L
s
.92775 .19945 m
.92775 .19945 L
s
.92783 .19875 m
.92783 .19875 L
s
.92791 .19781 m
.92791 .19781 L
s
.92798 .19758 m
.92798 .19758 L
s
.92805 .19734 m
.92805 .19734 L
s
.92812 .19734 m
.92812 .19734 L
s
.9282 .19687 m
.9282 .19687 L
s
.92827 .19898 m
.92827 .19898 L
s
.92835 .19711 m
.92835 .19711 L
s
.92842 .19593 m
.92842 .19593 L
s
.9285 .19546 m
.9285 .19546 L
s
.92857 .19734 m
.92857 .19734 L
s
.92865 .19546 m
.92865 .19546 L
s
.92872 .19711 m
.92872 .19711 L
s
.9288 .19664 m
.9288 .19664 L
s
.92887 .19687 m
.92887 .19687 L
s
.92894 .19828 m
.92894 .19828 L
s
.92901 .19758 m
.92901 .19758 L
s
.92909 .19875 m
.92909 .19875 L
s
.92916 .19851 m
.92916 .19851 L
s
.92924 .20016 m
.92924 .20016 L
s
.92931 .19804 m
.92931 .19804 L
s
.92939 .19898 m
.92939 .19898 L
s
.92947 .19734 m
.92947 .19734 L
s
.92954 .19875 m
.92954 .19875 L
s
.92962 .19828 m
.92962 .19828 L
s
.92968 .19828 m
.92968 .19828 L
s
.92976 .19898 m
.92976 .19898 L
s
.92983 .19664 m
.92983 .19664 L
s
.92991 .19664 m
.92991 .19664 L
s
.92998 .19569 m
.92998 .19569 L
s
.93006 .19804 m
.93006 .19804 L
s
.93013 .19711 m
.93013 .19711 L
s
.93021 .19828 m
.93021 .19828 L
s
.93028 .19945 m
.93028 .19945 L
s
.93036 .19875 m
.93036 .19875 L
s
.93043 .19992 m
.93043 .19992 L
s
.9305 .19992 m
.9305 .19992 L
s
.93057 .20016 m
.93057 .20016 L
s
.93065 .19945 m
.93065 .19945 L
s
.93072 .20016 m
.93072 .20016 L
s
.9308 .1964 m
.9308 .1964 L
s
.93087 .19664 m
.93087 .19664 L
s
.93095 .19569 m
.93095 .19569 L
s
.93103 .19569 m
.93103 .19569 L
s
.9311 .1964 m
.9311 .1964 L
s
.93118 .19687 m
.93118 .19687 L
s
.93125 .19687 m
.93125 .19687 L
s
.93132 .19616 m
.93132 .19616 L
s
.93139 .19616 m
.93139 .19616 L
s
.93147 .19593 m
.93147 .19593 L
s
.93154 .19711 m
.93154 .19711 L
s
.93162 .19711 m
.93162 .19711 L
s
.93169 .19922 m
.93169 .19922 L
s
.93177 .19781 m
.93177 .19781 L
s
.93184 .19828 m
.93184 .19828 L
s
.93192 .19781 m
.93192 .19781 L
s
.93199 .19898 m
.93199 .19898 L
s
.93207 .19922 m
.93207 .19922 L
s
.93213 .19781 m
.93213 .19781 L
s
.93221 .19804 m
.93221 .19804 L
s
.93228 .19711 m
.93228 .19711 L
s
.93236 .19828 m
.93236 .19828 L
s
.93243 .19711 m
.93243 .19711 L
s
.93251 .19781 m
.93251 .19781 L
s
.93259 .19616 m
.93259 .19616 L
s
.93266 .19711 m
.93266 .19711 L
s
.93274 .19687 m
.93274 .19687 L
s
.93281 .19711 m
.93281 .19711 L
s
.93288 .19616 m
.93288 .19616 L
s
.93295 .1964 m
.93295 .1964 L
s
.93303 .1964 m
.93303 .1964 L
s
.9331 .19804 m
.9331 .19804 L
s
.93318 .19851 m
.93318 .19851 L
s
.93325 .19781 m
.93325 .19781 L
s
.93333 .19968 m
.93333 .19968 L
s
.9334 .2011 m
.9334 .2011 L
s
.93347 .20204 m
.93347 .20204 L
s
.93355 .2018 m
.93355 .2018 L
s
.93363 .20157 m
.93363 .20157 L
s
.9337 .20274 m
.9337 .20274 L
s
.93377 .20297 m
.93377 .20297 L
s
.93384 .20321 m
.93384 .20321 L
s
.93392 .20133 m
.93392 .20133 L
s
.93399 .20133 m
.93399 .20133 L
s
.93407 .20016 m
.93407 .20016 L
s
.93415 .2004 m
.93415 .2004 L
s
.93422 .20204 m
.93422 .20204 L
s
.93429 .20297 m
.93429 .20297 L
s
.93437 .20321 m
.93437 .20321 L
s
.93445 .20204 m
.93445 .20204 L
s
.93452 .2025 m
.93452 .2025 L
s
.93459 .20297 m
.93459 .20297 L
s
.93466 .20227 m
.93466 .20227 L
s
.93474 .20133 m
.93474 .20133 L
s
.93481 .2004 m
.93481 .2004 L
s
.93489 .19898 m
.93489 .19898 L
s
.93496 .19758 m
.93496 .19758 L
s
.93504 .19687 m
.93504 .19687 L
s
.9351 .1964 m
.9351 .1964 L
s
.93518 .19593 m
.93518 .19593 L
s
.93526 .19616 m
.93526 .19616 L
s
.93533 .19781 m
.93533 .19781 L
s
.9354 .19851 m
.9354 .19851 L
s
.93548 .19898 m
.93548 .19898 L
s
.93555 .19968 m
.93555 .19968 L
s
.93563 .2011 m
.93563 .2011 L
s
.93571 .20157 m
.93571 .20157 L
s
.93578 .20157 m
.93578 .20157 L
s
.93585 .20016 m
.93585 .20016 L
s
.93592 .2011 m
.93592 .2011 L
s
.936 .20063 m
.936 .20063 L
s
.93608 .19851 m
.93608 .19851 L
s
.93615 .19922 m
.93615 .19922 L
s
.93622 .19968 m
.93622 .19968 L
s
.9363 .20016 m
.9363 .20016 L
s
.93637 .19898 m
.93637 .19898 L
s
.93645 .20086 m
.93645 .20086 L
s
.93652 .2011 m
.93652 .2011 L
s
.9366 .2025 m
.9366 .2025 L
s
.93667 .20063 m
.93667 .20063 L
s
.93674 .20063 m
.93674 .20063 L
s
.93681 .20133 m
.93681 .20133 L
s
.93689 .20086 m
.93689 .20086 L
s
.93696 .2011 m
.93696 .2011 L
s
.93704 .20086 m
.93704 .20086 L
s
.93711 .2004 m
.93711 .2004 L
s
.93719 .19804 m
.93719 .19804 L
s
.93727 .19992 m
.93727 .19992 L
s
.93734 .19804 m
.93734 .19804 L
s
.93742 .19851 m
.93742 .19851 L
s
.93749 .19687 m
.93749 .19687 L
s
.93756 .19968 m
.93756 .19968 L
s
.93763 .19781 m
.93763 .19781 L
s
.93771 .19734 m
.93771 .19734 L
s
.93778 .19758 m
.93778 .19758 L
s
.93786 .19476 m
.93786 .19476 L
s
.93793 .19499 m
.93793 .19499 L
s
.93801 .19382 m
.93801 .19382 L
s
.93808 .19522 m
.93808 .19522 L
s
.93816 .19429 m
.93816 .19429 L
s
.93823 .19405 m
.93823 .19405 L
s
.9383 .19429 m
.9383 .19429 L
s
.93837 .19664 m
.93837 .19664 L
s
.93845 .1964 m
.93845 .1964 L
s
.93852 .19546 m
.93852 .19546 L
s
.9386 .1964 m
.9386 .1964 L
s
.93867 .19781 m
.93867 .19781 L
s
.93875 .19945 m
.93875 .19945 L
s
.93883 .19968 m
.93883 .19968 L
s
.9389 .20016 m
.9389 .20016 L
s
.93898 .19968 m
.93898 .19968 L
s
.93905 .19968 m
.93905 .19968 L
s
.93912 .19875 m
.93912 .19875 L
s
.93919 .19968 m
.93919 .19968 L
s
.93927 .2011 m
.93927 .2011 L
s
.93934 .2011 m
.93934 .2011 L
s
.93942 .20157 m
.93942 .20157 L
s
.93949 .19992 m
.93949 .19992 L
s
.93957 .19968 m
.93957 .19968 L
s
.93964 .20063 m
.93964 .20063 L
s
.93972 .20016 m
.93972 .20016 L
s
.93979 .2011 m
.93979 .2011 L
s
.93987 .2018 m
.93987 .2018 L
s
.93993 .20157 m
.93993 .20157 L
s
.94001 .2004 m
.94001 .2004 L
s
.94008 .20016 m
.94008 .20016 L
s
.94016 .2004 m
.94016 .2004 L
s
.94023 .20086 m
.94023 .20086 L
s
.94031 .19992 m
.94031 .19992 L
s
.94039 .20063 m
.94039 .20063 L
s
.94046 .20063 m
.94046 .20063 L
s
.94054 .20227 m
.94054 .20227 L
s
.94061 .20227 m
.94061 .20227 L
s
.94068 .20157 m
.94068 .20157 L
s
.94075 .20227 m
.94075 .20227 L
s
.94083 .20204 m
.94083 .20204 L
s
.9409 .20016 m
.9409 .20016 L
s
.94098 .19968 m
.94098 .19968 L
s
.94105 .2011 m
.94105 .2011 L
s
.94113 .20086 m
.94113 .20086 L
s
.9412 .20016 m
.9412 .20016 L
s
.94128 .19851 m
.94128 .19851 L
s
.94135 .19968 m
.94135 .19968 L
s
.94143 .19922 m
.94143 .19922 L
s
.9415 .19875 m
.9415 .19875 L
s
.94157 .19968 m
.94157 .19968 L
s
.94164 .19828 m
.94164 .19828 L
s
.94172 .19875 m
.94172 .19875 L
s
.94179 .19804 m
.94179 .19804 L
s
.94187 .19758 m
.94187 .19758 L
s
.94195 .19522 m
.94195 .19522 L
s
.94202 .19734 m
.94202 .19734 L
s
.94209 .19711 m
.94209 .19711 L
s
.94217 .19898 m
.94217 .19898 L
s
.94225 .19804 m
.94225 .19804 L
s
.94232 .19781 m
.94232 .19781 L
s
.94239 .19922 m
.94239 .19922 L
s
.94246 .19898 m
.94246 .19898 L
s
.94254 .20016 m
.94254 .20016 L
s
.94261 .19992 m
.94261 .19992 L
s
.94269 .2011 m
.94269 .2011 L
s
.94276 .19992 m
.94276 .19992 L
s
.94284 .20204 m
.94284 .20204 L
s
.94291 .20157 m
.94291 .20157 L
s
.94299 .20063 m
.94299 .20063 L
s
.94306 .19922 m
.94306 .19922 L
s
.94313 .19828 m
.94313 .19828 L
s
.9432 .19781 m
.9432 .19781 L
s
.94328 .1964 m
.94328 .1964 L
s
.94335 .1964 m
.94335 .1964 L
s
.94343 .19616 m
.94343 .19616 L
s
.94351 .19569 m
.94351 .19569 L
s
.94358 .19452 m
.94358 .19452 L
s
.94365 .19522 m
.94365 .19522 L
s
.94372 .19382 m
.94372 .19382 L
s
.9438 .19476 m
.9438 .19476 L
s
.94388 .19311 m
.94388 .19311 L
s
.94395 .19335 m
.94395 .19335 L
s
.94402 .19429 m
.94402 .19429 L
s
.9441 .19546 m
.9441 .19546 L
s
.94417 .19616 m
.94417 .19616 L
s
.94425 .19569 m
.94425 .19569 L
s
.94432 .19781 m
.94432 .19781 L
s
.9444 .19664 m
.9444 .19664 L
s
.94447 .19758 m
.94447 .19758 L
s
.94454 .19616 m
.94454 .19616 L
s
.94462 .19828 m
.94462 .19828 L
s
.9447 .19758 m
.9447 .19758 L
s
.94476 .19711 m
.94476 .19711 L
s
.94484 .19781 m
.94484 .19781 L
s
.94491 .19664 m
.94491 .19664 L
s
.94499 .19569 m
.94499 .19569 L
s
.94507 .19569 m
.94507 .19569 L
s
.94514 .19711 m
.94514 .19711 L
s
.94522 .19758 m
.94522 .19758 L
s
.94529 .19781 m
.94529 .19781 L
s
.94536 .19734 m
.94536 .19734 L
s
.94543 .19828 m
.94543 .19828 L
s
.94551 .19922 m
.94551 .19922 L
s
.94558 .19968 m
.94558 .19968 L
s
.94566 .19922 m
.94566 .19922 L
s
.94573 .19804 m
.94573 .19804 L
s
.94581 .19828 m
.94581 .19828 L
s
.94588 .19758 m
.94588 .19758 L
s
.94596 .19687 m
.94596 .19687 L
s
.94603 .19569 m
.94603 .19569 L
s
.9461 .19569 m
.9461 .19569 L
s
.94617 .19569 m
.94617 .19569 L
s
.94625 .19593 m
.94625 .19593 L
s
.94633 .19616 m
.94633 .19616 L
s
.9464 .19546 m
.9464 .19546 L
s
.94647 .19429 m
.94647 .19429 L
s
.94655 .19499 m
.94655 .19499 L
s
.94663 .19522 m
.94663 .19522 L
s
.9467 .19522 m
.9467 .19522 L
s
.94678 .19664 m
.94678 .19664 L
s
.94685 .19616 m
.94685 .19616 L
s
.94692 .19687 m
.94692 .19687 L
s
.94699 .19664 m
.94699 .19664 L
s
.94707 .19734 m
.94707 .19734 L
s
.94714 .1964 m
.94714 .1964 L
s
.94722 .19476 m
.94722 .19476 L
s
.94729 .19569 m
.94729 .19569 L
s
.94737 .19452 m
.94737 .19452 L
s
.94744 .19687 m
.94744 .19687 L
s
.94752 .19616 m
.94752 .19616 L
s
.94759 .19734 m
.94759 .19734 L
s
.94767 .19734 m
.94767 .19734 L
s
.94773 .19593 m
.94773 .19593 L
s
.94781 .1964 m
.94781 .1964 L
s
.94788 .19734 m
.94788 .19734 L
s
.94796 .19781 m
.94796 .19781 L
s
.94803 .19828 m
.94803 .19828 L
s
.94811 .19875 m
.94811 .19875 L
s
.94819 .19945 m
.94819 .19945 L
s
.94826 .19992 m
.94826 .19992 L
s
.94834 .19851 m
.94834 .19851 L
s
.94841 .19875 m
.94841 .19875 L
s
.94848 .19922 m
.94848 .19922 L
s
.94855 .2004 m
.94855 .2004 L
s
.94863 .19922 m
.94863 .19922 L
s
.9487 .19968 m
.9487 .19968 L
s
.94878 .20133 m
.94878 .20133 L
s
.94885 .2025 m
.94885 .2025 L
s
.94893 .2004 m
.94893 .2004 L
s
.949 .19945 m
.949 .19945 L
s
.94908 .19851 m
.94908 .19851 L
s
.94915 .19687 m
.94915 .19687 L
s
.94923 .19758 m
.94923 .19758 L
s
.9493 .19804 m
.9493 .19804 L
s
.94937 .19922 m
.94937 .19922 L
s
.94944 .19875 m
.94944 .19875 L
s
.94952 .19992 m
.94952 .19992 L
s
.94959 .20063 m
.94959 .20063 L
s
.94967 .20157 m
.94967 .20157 L
s
.94975 .20297 m
.94975 .20297 L
s
.94982 .2025 m
.94982 .2025 L
s
.9499 .20321 m
.9499 .20321 L
s
.94997 .19992 m
.94997 .19992 L
s
.95005 .20063 m
.95005 .20063 L
s
.95012 .2004 m
.95012 .2004 L
s
.95019 .20063 m
.95019 .20063 L
s
.95026 .2004 m
.95026 .2004 L
s
.95034 .19992 m
.95034 .19992 L
s
.95041 .2004 m
.95041 .2004 L
s
.95049 .19945 m
.95049 .19945 L
s
.95056 .19922 m
.95056 .19922 L
s
.95064 .19851 m
.95064 .19851 L
s
.95071 .19898 m
.95071 .19898 L
s
.95079 .19804 m
.95079 .19804 L
s
.95086 .19687 m
.95086 .19687 L
s
.95093 .19711 m
.95093 .19711 L
s
.951 .19687 m
.951 .19687 L
s
.95108 .19687 m
.95108 .19687 L
s
.95115 .19781 m
.95115 .19781 L
s
.95123 .19781 m
.95123 .19781 L
s
.95131 .19781 m
.95131 .19781 L
s
.95138 .19922 m
.95138 .19922 L
s
.95145 .19687 m
.95145 .19687 L
s
.95153 .19875 m
.95153 .19875 L
s
.9516 .19711 m
.9516 .19711 L
s
.95168 .19804 m
.95168 .19804 L
s
.95175 .19734 m
.95175 .19734 L
s
.95182 .19804 m
.95182 .19804 L
s
.9519 .19781 m
.9519 .19781 L
s
.95197 .19828 m
.95197 .19828 L
s
.95205 .19781 m
.95205 .19781 L
s
.95212 .19781 m
.95212 .19781 L
s
.9522 .19992 m
.9522 .19992 L
s
.95227 .19875 m
.95227 .19875 L
s
.95234 .19875 m
.95234 .19875 L
s
.95242 .19687 m
.95242 .19687 L
s
.9525 .19781 m
.9525 .19781 L
s
.95256 .19851 m
.95256 .19851 L
s
.95264 .20016 m
.95264 .20016 L
s
.95271 .19875 m
.95271 .19875 L
s
.95279 .19851 m
.95279 .19851 L
s
.95287 .19875 m
.95287 .19875 L
s
.95294 .19945 m
.95294 .19945 L
s
.95302 .19804 m
.95302 .19804 L
s
.95309 .19804 m
.95309 .19804 L
s
.95316 .19922 m
.95316 .19922 L
s
.95324 .19804 m
.95324 .19804 L
s
.95331 .19875 m
.95331 .19875 L
s
.95338 .1964 m
.95338 .1964 L
s
.95346 .19781 m
.95346 .19781 L
s
.95353 .19616 m
.95353 .19616 L
s
.95361 .19875 m
.95361 .19875 L
s
.95368 .19828 m
.95368 .19828 L
s
.95376 .19828 m
.95376 .19828 L
s
.95383 .19922 m
.95383 .19922 L
s
.9539 .19898 m
.9539 .19898 L
s
.95397 .19945 m
.95397 .19945 L
s
.95405 .19851 m
.95405 .19851 L
s
.95413 .19851 m
.95413 .19851 L
s
.9542 .19828 m
.9542 .19828 L
s
.95427 .19968 m
.95427 .19968 L
s
.95435 .20063 m
.95435 .20063 L
s
.95443 .20063 m
.95443 .20063 L
s
.9545 .2018 m
.9545 .2018 L
s
.95458 .20063 m
.95458 .20063 L
s
.95465 .2025 m
.95465 .2025 L
s
.95472 .2004 m
.95472 .2004 L
s
.95479 .2011 m
.95479 .2011 L
s
.95487 .20227 m
.95487 .20227 L
s
.95495 .20345 m
.95495 .20345 L
s
.95502 .20274 m
.95502 .20274 L
s
.95509 .20368 m
.95509 .20368 L
s
.95517 .20392 m
.95517 .20392 L
s
.95524 .20321 m
.95524 .20321 L
s
.95532 .2025 m
.95532 .2025 L
s
.95539 .2025 m
.95539 .2025 L
s
.95547 .20297 m
.95547 .20297 L
s
.95553 .20345 m
.95553 .20345 L
s
.95561 .20392 m
.95561 .20392 L
s
.95568 .20486 m
.95568 .20486 L
s
.95576 .20579 m
.95576 .20579 L
s
.95583 .20556 m
.95583 .20556 L
s
.95591 .20579 m
.95591 .20579 L
s
.95599 .20697 m
.95599 .20697 L
s
.95606 .20674 m
.95606 .20674 L
s
.95614 .20768 m
.95614 .20768 L
s
.95621 .20721 m
.95621 .20721 L
s
.95628 .20791 m
.95628 .20791 L
s
.95635 .20674 m
.95635 .20674 L
s
.95643 .20768 m
.95643 .20768 L
s
.9565 .20768 m
.9565 .20768 L
s
.95658 .20932 m
.95658 .20932 L
s
.95665 .20932 m
.95665 .20932 L
s
.95673 .2105 m
.95673 .2105 L
s
.9568 .21096 m
.9568 .21096 L
s
.95688 .21096 m
.95688 .21096 L
s
.95695 .21096 m
.95695 .21096 L
s
.95703 .21096 m
.95703 .21096 L
s
.9571 .21378 m
.9571 .21378 L
s
.95717 .2119 m
.95717 .2119 L
s
.95724 .21167 m
.95724 .21167 L
s
.95732 .2112 m
.95732 .2112 L
s
.95739 .21261 m
.95739 .21261 L
s
.95747 .21026 m
.95747 .21026 L
s
.95755 .21096 m
.95755 .21096 L
s
.95762 .21143 m
.95762 .21143 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[26]:=",
 CellID->1205500931,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {85.7861, -3.38979, 0.805615, \
0.804474}}],

Cell[TextData[{
 "Algorithm 1 for a 15 stage method corresponds to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", 
    RowBox[{
     RowBox[{"15", " ", "\[Cross]", "2", "\[Cross]", 
      SuperscriptBox["10", "6"]}], "=", 
     RowBox[{"3", "\[Cross]", 
      SuperscriptBox["10", "7"]}]}]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->150718008],

Cell[TextData[{
 "In the incremental Algorithm 3 the internal stages are all of the order of \
the step size and the only significant rounding error occurs at the end of \
each integration step; thus ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", 
    RowBox[{"2", "\[Cross]", 
     SuperscriptBox["10", "6"]}]}], TraditionalForm]]],
 "which is in good agreement with the observed improvement."
}], "Text",
 CellID->1707227720],

Cell["\<\
This shows that for Algorithm 3, with sufficiently small step sizes, the \
rounding error growth is independent of the number of stages of the method, \
which is particularly advantageous for high order.\
\>", "Text",
 CellID->131247111]
}, Open  ]],

Cell[CellGroupData[{

Cell["With compensated summation", "Subsection",
 CellID->381647594],

Cell[TextData[{
 "The relative error in the Hamiltonian is displayed below for the increment \
formulation in Algorithm 3 without compensated summation (red) and with \
compensated summation (blue) for the Harmonic oscillator (",
 
 CounterBox["NumberedEquation", "HarmonicOscillator"],
 ")."
}], "Text",
 CellID->1578093406],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.373189 0.00433577 0.0147151 0.00439407 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.25 Mabswid
[ ] 0 Mabsdash
.21472 .11475 m
.21472 .11969 L
s
[(0)] .20009 .0796 -1 -1 Mshowa
.40044 .11475 m
.40044 .11969 L
s
[(20000)] .33378 .0796 -1 -1 Mshowa
.58617 .11475 m
.58617 .11969 L
s
[(40000)] .51951 .0796 -1 -1 Mshowa
.7719 .11475 m
.7719 .11969 L
s
[(60000)] .70524 .0796 -1 -1 Mshowa
.95762 .11475 m
.95762 .11969 L
s
[(80000)] .89096 .0796 -1 -1 Mshowa
.125 Mabswid
.26115 .11475 m
.26115 .11771 L
s
.30759 .11475 m
.30759 .11771 L
s
.35402 .11475 m
.35402 .11771 L
s
.44688 .11475 m
.44688 .11771 L
s
.49331 .11475 m
.49331 .11771 L
s
.53974 .11475 m
.53974 .11771 L
s
.6326 .11475 m
.6326 .11771 L
s
.67903 .11475 m
.67903 .11771 L
s
.72546 .11475 m
.72546 .11771 L
s
.81833 .11475 m
.81833 .11771 L
s
.86476 .11475 m
.86476 .11771 L
s
.91119 .11475 m
.91119 .11771 L
s
.25 Mabswid
.19615 .11475 m
.97619 .11475 L
s
.19615 .12638 m
.20103 .12638 L
s
[(0)] .16364 .11403 -1 -1 Mshowa
.19615 .2191 m
.20103 .2191 L
s
[(2)] .02381 .20043 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .20043 -1 -1 Mshowa
P
[(10)] .07584 .20043 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-14)] .12787 .2235 -1 -1 Mshowa
P
.19615 .31183 m
.20103 .31183 L
s
[(4)] .02381 .29315 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .29315 -1 -1 Mshowa
P
[(10)] .07584 .29315 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-14)] .12787 .31622 -1 -1 Mshowa
P
.19615 .40455 m
.20103 .40455 L
s
[(6)] .02381 .38588 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .38588 -1 -1 Mshowa
P
[(10)] .07584 .38588 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-14)] .12787 .40895 -1 -1 Mshowa
P
.19615 .49728 m
.20103 .49728 L
s
[(8)] .02381 .4786 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .4786 -1 -1 Mshowa
P
[(10)] .07584 .4786 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-14)] .12787 .50167 -1 -1 Mshowa
P
.19615 .59 m
.20103 .59 L
s
[(1)] .02381 .57132 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .57132 -1 -1 Mshowa
P
[(10)] .07584 .57132 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .59439 -1 -1 Mshowa
P
.125 Mabswid
.19615 .14956 m
.19908 .14956 L
s
.19615 .17274 m
.19908 .17274 L
s
.19615 .19593 m
.19908 .19593 L
s
.19615 .24228 m
.19908 .24228 L
s
.19615 .26547 m
.19908 .26547 L
s
.19615 .28865 m
.19908 .28865 L
s
.19615 .33501 m
.19908 .33501 L
s
.19615 .35819 m
.19908 .35819 L
s
.19615 .38137 m
.19908 .38137 L
s
.19615 .42773 m
.19908 .42773 L
s
.19615 .45091 m
.19908 .45091 L
s
.19615 .4741 m
.19908 .4741 L
s
.19615 .52046 m
.19908 .52046 L
s
.19615 .54364 m
.19908 .54364 L
s
.19615 .56682 m
.19908 .56682 L
s
.25 Mabswid
.19615 .11475 m
.19615 .60332 L
s
.21472 .59838 m
.21472 .60332 L
s
.40044 .59838 m
.40044 .60332 L
s
.58617 .59838 m
.58617 .60332 L
s
.7719 .59838 m
.7719 .60332 L
s
.95762 .59838 m
.95762 .60332 L
s
.125 Mabswid
.26115 .60035 m
.26115 .60332 L
s
.30759 .60035 m
.30759 .60332 L
s
.35402 .60035 m
.35402 .60332 L
s
.44688 .60035 m
.44688 .60332 L
s
.49331 .60035 m
.49331 .60332 L
s
.53974 .60035 m
.53974 .60332 L
s
.6326 .60035 m
.6326 .60332 L
s
.67903 .60035 m
.67903 .60332 L
s
.72546 .60035 m
.72546 .60332 L
s
.81833 .60035 m
.81833 .60332 L
s
.86476 .60035 m
.86476 .60332 L
s
.91119 .60035 m
.91119 .60332 L
s
.25 Mabswid
.19615 .60332 m
.97619 .60332 L
s
.97132 .12638 m
.97619 .12638 L
s
.97132 .2191 m
.97619 .2191 L
s
.97132 .31183 m
.97619 .31183 L
s
.97132 .40455 m
.97619 .40455 L
s
.97132 .49728 m
.97619 .49728 L
s
.97132 .59 m
.97619 .59 L
s
.125 Mabswid
.97327 .14956 m
.97619 .14956 L
s
.97327 .17274 m
.97619 .17274 L
s
.97327 .19593 m
.97619 .19593 L
s
.97327 .24228 m
.97619 .24228 L
s
.97327 .26547 m
.97619 .26547 L
s
.97327 .28865 m
.97619 .28865 L
s
.97327 .33501 m
.97619 .33501 L
s
.97327 .35819 m
.97619 .35819 L
s
.97327 .38137 m
.97619 .38137 L
s
.97327 .42773 m
.97619 .42773 L
s
.97327 .45091 m
.97619 .45091 L
s
.97327 .4741 m
.97619 .4741 L
s
.97327 .52046 m
.97619 .52046 L
s
.97327 .54364 m
.97619 .54364 L
s
.97327 .56682 m
.97619 .56682 L
s
.25 Mabswid
.97619 .11475 m
.97619 .60332 L
s
0 1 1 0 k
1.43926 Mabswid
.21472 .12638 m
.21472 .12638 L
s
.21479 .13153 m
.21479 .13153 L
s
.21487 .12947 m
.21487 .12947 L
s
.21495 .12638 m
.21495 .12638 L
s
.21502 .13153 m
.21502 .13153 L
s
.2151 .13565 m
.2151 .13565 L
s
.21517 .13668 m
.21517 .13668 L
s
.21525 .13358 m
.21525 .13358 L
s
.21532 .13565 m
.21532 .13565 L
s
.2154 .13873 m
.2154 .13873 L
s
.21547 .13358 m
.21547 .13358 L
s
.21554 .13976 m
.21554 .13976 L
s
.21561 .14079 m
.21561 .14079 L
s
.21569 .14079 m
.21569 .14079 L
s
.21576 .14594 m
.21576 .14594 L
s
.21584 .15109 m
.21584 .15109 L
s
.21591 .14902 m
.21591 .14902 L
s
.21599 .15314 m
.21599 .15314 L
s
.21606 .15211 m
.21606 .15211 L
s
.21613 .15109 m
.21613 .15109 L
s
.21621 .15726 m
.21621 .15726 L
s
.21629 .14902 m
.21629 .14902 L
s
.21636 .15109 m
.21636 .15109 L
s
.21643 .14491 m
.21643 .14491 L
s
.21651 .14697 m
.21651 .14697 L
s
.21658 .15109 m
.21658 .15109 L
s
.21666 .14902 m
.21666 .14902 L
s
.21673 .15418 m
.21673 .15418 L
s
.21681 .14902 m
.21681 .14902 L
s
.21688 .15726 m
.21688 .15726 L
s
.21695 .14491 m
.21695 .14491 L
s
.21703 .15109 m
.21703 .15109 L
s
.21711 .14491 m
.21711 .14491 L
s
.21717 .15314 m
.21717 .15314 L
s
.21725 .15211 m
.21725 .15211 L
s
.21732 .15109 m
.21732 .15109 L
s
.2174 .15109 m
.2174 .15109 L
s
.21747 .15726 m
.21747 .15726 L
s
.21755 .15521 m
.21755 .15521 L
s
.21762 .15211 m
.21762 .15211 L
s
.21769 .15829 m
.21769 .15829 L
s
.21776 .15932 m
.21776 .15932 L
s
.21784 .1655 m
.21784 .1655 L
s
.21792 .15932 m
.21792 .15932 L
s
.21799 .16344 m
.21799 .16344 L
s
.21807 .15932 m
.21807 .15932 L
s
.21814 .15726 m
.21814 .15726 L
s
.21822 .15932 m
.21822 .15932 L
s
.21829 .16344 m
.21829 .16344 L
s
.21837 .15932 m
.21837 .15932 L
s
.21844 .15932 m
.21844 .15932 L
s
.21851 .15521 m
.21851 .15521 L
s
.21858 .15314 m
.21858 .15314 L
s
.21866 .16447 m
.21866 .16447 L
s
.21874 .15932 m
.21874 .15932 L
s
.21881 .16241 m
.21881 .16241 L
s
.21888 .16138 m
.21888 .16138 L
s
.21896 .16447 m
.21896 .16447 L
s
.21903 .16241 m
.21903 .16241 L
s
.21911 .16344 m
.21911 .16344 L
s
.21918 .16138 m
.21918 .16138 L
s
.21926 .15726 m
.21926 .15726 L
s
.21933 .16344 m
.21933 .16344 L
s
.2194 .15521 m
.2194 .15521 L
s
.21947 .16138 m
.21947 .16138 L
s
.21955 .14697 m
.21955 .14697 L
s
.21963 .15006 m
.21963 .15006 L
s
.2197 .14491 m
.2197 .14491 L
s
.21978 .15109 m
.21978 .15109 L
s
.21985 .15109 m
.21985 .15109 L
s
.21993 .15314 m
.21993 .15314 L
s
.22 .14902 m
.22 .14902 L
s
.22008 .14079 m
.22008 .14079 L
s
.22014 .148 m
.22014 .148 L
s
.22022 .15211 m
.22022 .15211 L
s
.22029 .15829 m
.22029 .15829 L
s
.22037 .16035 m
.22037 .16035 L
s
.22044 .16653 m
.22044 .16653 L
s
.22052 .15932 m
.22052 .15932 L
s
.22059 .15829 m
.22059 .15829 L
s
.22067 .15314 m
.22067 .15314 L
s
.22074 .15521 m
.22074 .15521 L
s
.22082 .16138 m
.22082 .16138 L
s
.22089 .16241 m
.22089 .16241 L
s
.22096 .17579 m
.22096 .17579 L
s
.22103 .17064 m
.22103 .17064 L
s
.22111 .17167 m
.22111 .17167 L
s
.22119 .16859 m
.22119 .16859 L
s
.22126 .16859 m
.22126 .16859 L
s
.22134 .16859 m
.22134 .16859 L
s
.22141 .15932 m
.22141 .15932 L
s
.22149 .15211 m
.22149 .15211 L
s
.22156 .15211 m
.22156 .15211 L
s
.22164 .15726 m
.22164 .15726 L
s
.22171 .15109 m
.22171 .15109 L
s
.22178 .15314 m
.22178 .15314 L
s
.22185 .148 m
.22185 .148 L
s
.22193 .15521 m
.22193 .15521 L
s
.222 .15418 m
.222 .15418 L
s
.22208 .15521 m
.22208 .15521 L
s
.22215 .15521 m
.22215 .15521 L
s
.22223 .15932 m
.22223 .15932 L
s
.2223 .16138 m
.2223 .16138 L
s
.22238 .17064 m
.22238 .17064 L
s
.22245 .17476 m
.22245 .17476 L
s
.22252 .17785 m
.22252 .17785 L
s
.22259 .183 m
.22259 .183 L
s
.22267 .17888 m
.22267 .17888 L
s
.22275 .17888 m
.22275 .17888 L
s
.22282 .17682 m
.22282 .17682 L
s
.2229 .17785 m
.2229 .17785 L
s
.22297 .17888 m
.22297 .17888 L
s
.22305 .18403 m
.22305 .18403 L
s
.22312 .18197 m
.22312 .18197 L
s
.2232 .17888 m
.2232 .17888 L
s
.22327 .17785 m
.22327 .17785 L
s
.22334 .17579 m
.22334 .17579 L
s
.22341 .17785 m
.22341 .17785 L
s
.22349 .17785 m
.22349 .17785 L
s
.22356 .17888 m
.22356 .17888 L
s
.22364 .18094 m
.22364 .18094 L
s
.22371 .17888 m
.22371 .17888 L
s
.22379 .17167 m
.22379 .17167 L
s
.22386 .16859 m
.22386 .16859 L
s
.22394 .16859 m
.22394 .16859 L
s
.22401 .16241 m
.22401 .16241 L
s
.22409 .16138 m
.22409 .16138 L
s
.22416 .16035 m
.22416 .16035 L
s
.22423 .16241 m
.22423 .16241 L
s
.22431 .15623 m
.22431 .15623 L
s
.22438 .16447 m
.22438 .16447 L
s
.22446 .15521 m
.22446 .15521 L
s
.22453 .15521 m
.22453 .15521 L
s
.22461 .14491 m
.22461 .14491 L
s
.22468 .148 m
.22468 .148 L
s
.22475 .15006 m
.22475 .15006 L
s
.22483 .14491 m
.22483 .14491 L
s
.22491 .14285 m
.22491 .14285 L
s
.22497 .14388 m
.22497 .14388 L
s
.22505 .15006 m
.22505 .15006 L
s
.22512 .148 m
.22512 .148 L
s
.2252 .15211 m
.2252 .15211 L
s
.22527 .148 m
.22527 .148 L
s
.22535 .15726 m
.22535 .15726 L
s
.22542 .15521 m
.22542 .15521 L
s
.22549 .15211 m
.22549 .15211 L
s
.22557 .14902 m
.22557 .14902 L
s
.22565 .15109 m
.22565 .15109 L
s
.22572 .15521 m
.22572 .15521 L
s
.22579 .15109 m
.22579 .15109 L
s
.22587 .15314 m
.22587 .15314 L
s
.22594 .15006 m
.22594 .15006 L
s
.22602 .14594 m
.22602 .14594 L
s
.22609 .14182 m
.22609 .14182 L
s
.22617 .14388 m
.22617 .14388 L
s
.22624 .13976 m
.22624 .13976 L
s
.22631 .14285 m
.22631 .14285 L
s
.22638 .14902 m
.22638 .14902 L
s
.22646 .14697 m
.22646 .14697 L
s
.22654 .14285 m
.22654 .14285 L
s
.22661 .14182 m
.22661 .14182 L
s
.22668 .14388 m
.22668 .14388 L
s
.22676 .13668 m
.22676 .13668 L
s
.22683 .14285 m
.22683 .14285 L
s
.22691 .13873 m
.22691 .13873 L
s
.22698 .14697 m
.22698 .14697 L
s
.22706 .148 m
.22706 .148 L
s
.22713 .15314 m
.22713 .15314 L
s
.2272 .15109 m
.2272 .15109 L
s
.22728 .15726 m
.22728 .15726 L
s
.22735 .16447 m
.22735 .16447 L
s
.22743 .15829 m
.22743 .15829 L
s
.2275 .1655 m
.2275 .1655 L
s
.22758 .16344 m
.22758 .16344 L
s
.22765 .16653 m
.22765 .16653 L
s
.22773 .15829 m
.22773 .15829 L
s
.2278 .15726 m
.2278 .15726 L
s
.22788 .15418 m
.22788 .15418 L
s
.22794 .16035 m
.22794 .16035 L
s
.22802 .15314 m
.22802 .15314 L
s
.22809 .15006 m
.22809 .15006 L
s
.22817 .15109 m
.22817 .15109 L
s
.22824 .14697 m
.22824 .14697 L
s
.22832 .15521 m
.22832 .15521 L
s
.22839 .15109 m
.22839 .15109 L
s
.22847 .148 m
.22847 .148 L
s
.22854 .14594 m
.22854 .14594 L
s
.22862 .15006 m
.22862 .15006 L
s
.22869 .14594 m
.22869 .14594 L
s
.22876 .14285 m
.22876 .14285 L
s
.22883 .14491 m
.22883 .14491 L
s
.22891 .13873 m
.22891 .13873 L
s
.22899 .13565 m
.22899 .13565 L
s
.22906 .13153 m
.22906 .13153 L
s
.22914 .13049 m
.22914 .13049 L
s
.22921 .13307 m
.22921 .13307 L
s
.22929 .12844 m
.22929 .12844 L
s
.22936 .12895 m
.22936 .12895 L
s
.22944 .12741 m
.22944 .12741 L
s
.22951 .13358 m
.22951 .13358 L
s
.22958 .1377 m
.22958 .1377 L
s
.22965 .13358 m
.22965 .13358 L
s
.22973 .1341 m
.22973 .1341 L
s
.2298 .13153 m
.2298 .13153 L
s
.22988 .13256 m
.22988 .13256 L
s
.22995 .12895 m
.22995 .12895 L
s
.23003 .12895 m
.23003 .12895 L
s
.2301 .13049 m
.2301 .13049 L
s
.23018 .12844 m
.23018 .12844 L
s
.23025 .13049 m
.23025 .13049 L
s
.23032 .12741 m
.23032 .12741 L
s
.23039 .12844 m
.23039 .12844 L
s
.23047 .13358 m
.23047 .13358 L
s
.23055 .13256 m
.23055 .13256 L
s
.23062 .13873 m
.23062 .13873 L
s
.2307 .13668 m
.2307 .13668 L
s
.23077 .14079 m
.23077 .14079 L
s
.23085 .13668 m
.23085 .13668 L
s
.23092 .13049 m
.23092 .13049 L
s
.231 .13049 m
.231 .13049 L
s
.23107 .12844 m
.23107 .12844 L
s
.23114 .12741 m
.23114 .12741 L
s
.23121 .12844 m
.23121 .12844 L
s
.23129 .12844 m
.23129 .12844 L
s
.23136 .12895 m
.23136 .12895 L
s
.23144 .12638 m
.23144 .12638 L
s
.23151 .12947 m
.23151 .12947 L
s
.23159 .12638 m
.23159 .12638 L
s
.23166 .1269 m
.23166 .1269 L
s
.23174 .13049 m
.23174 .13049 L
s
.23181 .12844 m
.23181 .12844 L
s
.23189 .12741 m
.23189 .12741 L
s
.23196 .12792 m
.23196 .12792 L
s
.23203 .13256 m
.23203 .13256 L
s
.23211 .12895 m
.23211 .12895 L
s
.23218 .13204 m
.23218 .13204 L
s
.23226 .12741 m
.23226 .12741 L
s
.23233 .13256 m
.23233 .13256 L
s
.23241 .1341 m
.23241 .1341 L
s
.23248 .12895 m
.23248 .12895 L
s
.23256 .12638 m
.23256 .12638 L
s
.23263 .12638 m
.23263 .12638 L
s
.23271 .13256 m
.23271 .13256 L
s
.23277 .13461 m
.23277 .13461 L
s
.23285 .13565 m
.23285 .13565 L
s
.23292 .1377 m
.23292 .1377 L
s
.233 .14285 m
.233 .14285 L
s
.23307 .15314 m
.23307 .15314 L
s
.23315 .15314 m
.23315 .15314 L
s
.23322 .16035 m
.23322 .16035 L
s
.23329 .15006 m
.23329 .15006 L
s
.23337 .15829 m
.23337 .15829 L
s
.23345 .15521 m
.23345 .15521 L
s
.23352 .16344 m
.23352 .16344 L
s
.23359 .16138 m
.23359 .16138 L
s
.23367 .15726 m
.23367 .15726 L
s
.23374 .1655 m
.23374 .1655 L
s
.23382 .16447 m
.23382 .16447 L
s
.23389 .17682 m
.23389 .17682 L
s
.23397 .17271 m
.23397 .17271 L
s
.23404 .17888 m
.23404 .17888 L
s
.23411 .17476 m
.23411 .17476 L
s
.23419 .17579 m
.23419 .17579 L
s
.23427 .16962 m
.23427 .16962 L
s
.23434 .1655 m
.23434 .1655 L
s
.23441 .1655 m
.23441 .1655 L
s
.23448 .15932 m
.23448 .15932 L
s
.23456 .16344 m
.23456 .16344 L
s
.23463 .15623 m
.23463 .15623 L
s
.23471 .16035 m
.23471 .16035 L
s
.23478 .16035 m
.23478 .16035 L
s
.23486 .16138 m
.23486 .16138 L
s
.23493 .16241 m
.23493 .16241 L
s
.235 .17167 m
.235 .17167 L
s
.23508 .17271 m
.23508 .17271 L
s
.23515 .16755 m
.23515 .16755 L
s
.23523 .16138 m
.23523 .16138 L
s
.2353 .15932 m
.2353 .15932 L
s
.23538 .15726 m
.23538 .15726 L
s
.23545 .15211 m
.23545 .15211 L
s
.23553 .16138 m
.23553 .16138 L
s
.2356 .16241 m
.2356 .16241 L
s
.23568 .16344 m
.23568 .16344 L
s
.23574 .16447 m
.23574 .16447 L
s
.23582 .15829 m
.23582 .15829 L
s
.2359 .15623 m
.2359 .15623 L
s
.23597 .15109 m
.23597 .15109 L
s
.23604 .15211 m
.23604 .15211 L
s
.23612 .14079 m
.23612 .14079 L
s
.23619 .14285 m
.23619 .14285 L
s
.23627 .14388 m
.23627 .14388 L
s
.23634 .15521 m
.23634 .15521 L
s
.23642 .15829 m
.23642 .15829 L
s
.23649 .16138 m
.23649 .16138 L
s
.23656 .15623 m
.23656 .15623 L
s
.23663 .15623 m
.23663 .15623 L
s
.23671 .15314 m
.23671 .15314 L
s
.23679 .16035 m
.23679 .16035 L
s
.23686 .15829 m
.23686 .15829 L
s
.23694 .15521 m
.23694 .15521 L
s
.23701 .15623 m
.23701 .15623 L
s
.23709 .15418 m
.23709 .15418 L
s
.23716 .16035 m
.23716 .16035 L
s
.23724 .15109 m
.23724 .15109 L
s
.23731 .15211 m
.23731 .15211 L
s
.23738 .15726 m
.23738 .15726 L
s
.23745 .15726 m
.23745 .15726 L
s
.23753 .16653 m
.23753 .16653 L
s
.2376 .16859 m
.2376 .16859 L
s
.23768 .16962 m
.23768 .16962 L
s
.23775 .17167 m
.23775 .17167 L
s
.23783 .17579 m
.23783 .17579 L
s
.2379 .17167 m
.2379 .17167 L
s
.23798 .17785 m
.23798 .17785 L
s
.23805 .17476 m
.23805 .17476 L
s
.23813 .17682 m
.23813 .17682 L
s
.23819 .17991 m
.23819 .17991 L
s
.23827 .17064 m
.23827 .17064 L
s
.23835 .17579 m
.23835 .17579 L
s
.23842 .16344 m
.23842 .16344 L
s
.2385 .16962 m
.2385 .16962 L
s
.23857 .16138 m
.23857 .16138 L
s
.23865 .16035 m
.23865 .16035 L
s
.23872 .15623 m
.23872 .15623 L
s
.2388 .15829 m
.2388 .15829 L
s
.23887 .15109 m
.23887 .15109 L
s
.23894 .15211 m
.23894 .15211 L
s
.23901 .15521 m
.23901 .15521 L
s
.23909 .16138 m
.23909 .16138 L
s
.23916 .15726 m
.23916 .15726 L
s
.23924 .15726 m
.23924 .15726 L
s
.23931 .16344 m
.23931 .16344 L
s
.23939 .16241 m
.23939 .16241 L
s
.23946 .16859 m
.23946 .16859 L
s
.23954 .15932 m
.23954 .15932 L
s
.23961 .15829 m
.23961 .15829 L
s
.23969 .16138 m
.23969 .16138 L
s
.23976 .16859 m
.23976 .16859 L
s
.23983 .17271 m
.23983 .17271 L
s
.23991 .16962 m
.23991 .16962 L
s
.23998 .1655 m
.23998 .1655 L
s
.24006 .16447 m
.24006 .16447 L
s
.24013 .16755 m
.24013 .16755 L
s
.24021 .15829 m
.24021 .15829 L
s
.24028 .16447 m
.24028 .16447 L
s
.24036 .16344 m
.24036 .16344 L
s
.24043 .16447 m
.24043 .16447 L
s
.24051 .16138 m
.24051 .16138 L
s
.24057 .16755 m
.24057 .16755 L
s
.24065 .15726 m
.24065 .15726 L
s
.24072 .15211 m
.24072 .15211 L
s
.2408 .15109 m
.2408 .15109 L
s
.24087 .14902 m
.24087 .14902 L
s
.24095 .14697 m
.24095 .14697 L
s
.24102 .14182 m
.24102 .14182 L
s
.2411 .15109 m
.2411 .15109 L
s
.24117 .14182 m
.24117 .14182 L
s
.24125 .14388 m
.24125 .14388 L
s
.24132 .13976 m
.24132 .13976 L
s
.24139 .13565 m
.24139 .13565 L
s
.24147 .13976 m
.24147 .13976 L
s
.24154 .13256 m
.24154 .13256 L
s
.24162 .13049 m
.24162 .13049 L
s
.24169 .12792 m
.24169 .12792 L
s
.24177 .13461 m
.24177 .13461 L
s
.24184 .13049 m
.24184 .13049 L
s
.24191 .12741 m
.24191 .12741 L
s
.24199 .12741 m
.24199 .12741 L
s
.24207 .12844 m
.24207 .12844 L
s
.24214 .13668 m
.24214 .13668 L
s
.24221 .12844 m
.24221 .12844 L
s
.24228 .12741 m
.24228 .12741 L
s
.24236 .12638 m
.24236 .12638 L
s
.24243 .13102 m
.24243 .13102 L
s
.24251 .12792 m
.24251 .12792 L
s
.24258 .12741 m
.24258 .12741 L
s
.24266 .12792 m
.24266 .12792 L
s
.24273 .12844 m
.24273 .12844 L
s
.24281 .13153 m
.24281 .13153 L
s
.24288 .12638 m
.24288 .12638 L
s
.24296 .12741 m
.24296 .12741 L
s
.24303 .12844 m
.24303 .12844 L
s
.2431 .12844 m
.2431 .12844 L
s
.24318 .12741 m
.24318 .12741 L
s
.24325 .13153 m
.24325 .13153 L
s
.24333 .13668 m
.24333 .13668 L
s
.2434 .12792 m
.2434 .12792 L
s
.24348 .12638 m
.24348 .12638 L
s
.24354 .13049 m
.24354 .13049 L
s
.24362 .12947 m
.24362 .12947 L
s
.2437 .12947 m
.2437 .12947 L
s
.24377 .12741 m
.24377 .12741 L
s
.24384 .12844 m
.24384 .12844 L
s
.24392 .12998 m
.24392 .12998 L
s
.24399 .12741 m
.24399 .12741 L
s
.24407 .13565 m
.24407 .13565 L
s
.24414 .13049 m
.24414 .13049 L
s
.24422 .1377 m
.24422 .1377 L
s
.24429 .13358 m
.24429 .13358 L
s
.24436 .14079 m
.24436 .14079 L
s
.24444 .13565 m
.24444 .13565 L
s
.24452 .13256 m
.24452 .13256 L
s
.24459 .13049 m
.24459 .13049 L
s
.24466 .13256 m
.24466 .13256 L
s
.24474 .13668 m
.24474 .13668 L
s
.24481 .13668 m
.24481 .13668 L
s
.24489 .14388 m
.24489 .14388 L
s
.24496 .13565 m
.24496 .13565 L
s
.24504 .13668 m
.24504 .13668 L
s
.24511 .13256 m
.24511 .13256 L
s
.24518 .13461 m
.24518 .13461 L
s
.24525 .1377 m
.24525 .1377 L
s
.24533 .1377 m
.24533 .1377 L
s
.2454 .14285 m
.2454 .14285 L
s
.24548 .148 m
.24548 .148 L
s
.24555 .15314 m
.24555 .15314 L
s
.24563 .15829 m
.24563 .15829 L
s
.2457 .15623 m
.2457 .15623 L
s
.24578 .15314 m
.24578 .15314 L
s
.24585 .16241 m
.24585 .16241 L
s
.24593 .15521 m
.24593 .15521 L
s
.24599 .15932 m
.24599 .15932 L
s
.24607 .16241 m
.24607 .16241 L
s
.24615 .16653 m
.24615 .16653 L
s
.24622 .16447 m
.24622 .16447 L
s
.2463 .16138 m
.2463 .16138 L
s
.24637 .16035 m
.24637 .16035 L
s
.24645 .16138 m
.24645 .16138 L
s
.24652 .16241 m
.24652 .16241 L
s
.2466 .16859 m
.2466 .16859 L
s
.24667 .17271 m
.24667 .17271 L
s
.24674 .16344 m
.24674 .16344 L
s
.24681 .17064 m
.24681 .17064 L
s
.24689 .16138 m
.24689 .16138 L
s
.24696 .15932 m
.24696 .15932 L
s
.24704 .15521 m
.24704 .15521 L
s
.24711 .15726 m
.24711 .15726 L
s
.24719 .15932 m
.24719 .15932 L
s
.24726 .15726 m
.24726 .15726 L
s
.24734 .15829 m
.24734 .15829 L
s
.24741 .15211 m
.24741 .15211 L
s
.24749 .16035 m
.24749 .16035 L
s
.24756 .14594 m
.24756 .14594 L
s
.24763 .14594 m
.24763 .14594 L
s
.24771 .14285 m
.24771 .14285 L
s
.24778 .14491 m
.24778 .14491 L
s
.24786 .13873 m
.24786 .13873 L
s
.24793 .13668 m
.24793 .13668 L
s
.24801 .13668 m
.24801 .13668 L
s
.24808 .13668 m
.24808 .13668 L
s
.24816 .13873 m
.24816 .13873 L
s
.24823 .13565 m
.24823 .13565 L
s
.24831 .14491 m
.24831 .14491 L
s
.24837 .13668 m
.24837 .13668 L
s
.24845 .13976 m
.24845 .13976 L
s
.24852 .14285 m
.24852 .14285 L
s
.2486 .15109 m
.2486 .15109 L
s
.24867 .15521 m
.24867 .15521 L
s
.24875 .15932 m
.24875 .15932 L
s
.24882 .16344 m
.24882 .16344 L
s
.2489 .16447 m
.2489 .16447 L
s
.24897 .16755 m
.24897 .16755 L
s
.24905 .16138 m
.24905 .16138 L
s
.24912 .16447 m
.24912 .16447 L
s
.24919 .16241 m
.24919 .16241 L
s
.24927 .16653 m
.24927 .16653 L
s
.24934 .16035 m
.24934 .16035 L
s
.24942 .15623 m
.24942 .15623 L
s
.24949 .16241 m
.24949 .16241 L
s
.24957 .15932 m
.24957 .15932 L
s
.24964 .15623 m
.24964 .15623 L
s
.24972 .15418 m
.24972 .15418 L
s
.24979 .15932 m
.24979 .15932 L
s
.24987 .15211 m
.24987 .15211 L
s
.24994 .15829 m
.24994 .15829 L
s
.25001 .16138 m
.25001 .16138 L
s
.25008 .16653 m
.25008 .16653 L
s
.25016 .16962 m
.25016 .16962 L
s
.25023 .17682 m
.25023 .17682 L
s
.25031 .17374 m
.25031 .17374 L
s
.25038 .17579 m
.25038 .17579 L
s
.25046 .18197 m
.25046 .18197 L
s
.25053 .18094 m
.25053 .18094 L
s
.25061 .18094 m
.25061 .18094 L
s
.25068 .17991 m
.25068 .17991 L
s
.25076 .18917 m
.25076 .18917 L
s
.25083 .18608 m
.25083 .18608 L
s
.2509 .19124 m
.2509 .19124 L
s
.25098 .18712 m
.25098 .18712 L
s
.25105 .18815 m
.25105 .18815 L
s
.25113 .19124 m
.25113 .19124 L
s
.2512 .19124 m
.2512 .19124 L
s
.25128 .19844 m
.25128 .19844 L
s
.25135 .19329 m
.25135 .19329 L
s
.25143 .19638 m
.25143 .19638 L
s
.2515 .19227 m
.2515 .19227 L
s
.25157 .20461 m
.25157 .20461 L
s
.25164 .20873 m
.25164 .20873 L
s
.25172 .21182 m
.25172 .21182 L
s
.25179 .20668 m
.25179 .20668 L
s
.25187 .21285 m
.25187 .21285 L
s
.25194 .21285 m
.25194 .21285 L
s
.25202 .21697 m
.25202 .21697 L
s
.25209 .22006 m
.25209 .22006 L
s
.25216 .21697 m
.25216 .21697 L
s
.25224 .22314 m
.25224 .22314 L
s
.25232 .21491 m
.25232 .21491 L
s
.25239 .22212 m
.25239 .22212 L
s
.25246 .22212 m
.25246 .22212 L
s
.25254 .22623 m
.25254 .22623 L
s
.25261 .22521 m
.25261 .22521 L
s
.25269 .23035 m
.25269 .23035 L
s
.25276 .23241 m
.25276 .23241 L
s
.25284 .23035 m
.25284 .23035 L
s
.25291 .2355 m
.25291 .2355 L
s
.25298 .24065 m
.25298 .24065 L
s
.25306 .23962 m
.25306 .23962 L
s
.25313 .2355 m
.25313 .2355 L
s
.2532 .23756 m
.2532 .23756 L
s
.25328 .23756 m
.25328 .23756 L
s
.25335 .23756 m
.25335 .23756 L
s
.25343 .2355 m
.25343 .2355 L
s
.2535 .2355 m
.2535 .2355 L
s
.25358 .23653 m
.25358 .23653 L
s
.25365 .23447 m
.25365 .23447 L
s
.25373 .23756 m
.25373 .23756 L
s
.25379 .24065 m
.25379 .24065 L
s
.25387 .24065 m
.25387 .24065 L
s
.25395 .24065 m
.25395 .24065 L
s
.25402 .23962 m
.25402 .23962 L
s
.2541 .23447 m
.2541 .23447 L
s
.25417 .23241 m
.25417 .23241 L
s
.25425 .23035 m
.25425 .23035 L
s
.25432 .23138 m
.25432 .23138 L
s
.2544 .23344 m
.2544 .23344 L
s
.25447 .23035 m
.25447 .23035 L
s
.25454 .23138 m
.25454 .23138 L
s
.25461 .23138 m
.25461 .23138 L
s
.25469 .23035 m
.25469 .23035 L
s
.25477 .22314 m
.25477 .22314 L
s
.25484 .22006 m
.25484 .22006 L
s
.25491 .22418 m
.25491 .22418 L
s
.25499 .22418 m
.25499 .22418 L
s
.25506 .22418 m
.25506 .22418 L
s
.25514 .22314 m
.25514 .22314 L
s
.25521 .21388 m
.25521 .21388 L
s
.25529 .2108 m
.25529 .2108 L
s
.25536 .20873 m
.25536 .20873 L
s
.25543 .20771 m
.25543 .20771 L
s
.25551 .21491 m
.25551 .21491 L
s
.25558 .20771 m
.25558 .20771 L
s
.25566 .21697 m
.25566 .21697 L
s
.25573 .2108 m
.25573 .2108 L
s
.25581 .21182 m
.25581 .21182 L
s
.25588 .21285 m
.25588 .21285 L
s
.25596 .21285 m
.25596 .21285 L
s
.25603 .21182 m
.25603 .21182 L
s
.25611 .20461 m
.25611 .20461 L
s
.25617 .20668 m
.25617 .20668 L
s
.25625 .20256 m
.25625 .20256 L
s
.25632 .20565 m
.25632 .20565 L
s
.2564 .2005 m
.2564 .2005 L
s
.25647 .20256 m
.25647 .20256 L
s
.25655 .19638 m
.25655 .19638 L
s
.25662 .19432 m
.25662 .19432 L
s
.2567 .19741 m
.2567 .19741 L
s
.25677 .19227 m
.25677 .19227 L
s
.25685 .19124 m
.25685 .19124 L
s
.25692 .19535 m
.25692 .19535 L
s
.25699 .19844 m
.25699 .19844 L
s
.25707 .19535 m
.25707 .19535 L
s
.25714 .20256 m
.25714 .20256 L
s
.25722 .2005 m
.25722 .2005 L
s
.25729 .20461 m
.25729 .20461 L
s
.25737 .20565 m
.25737 .20565 L
s
.25744 .20668 m
.25744 .20668 L
s
.25752 .20461 m
.25752 .20461 L
s
.25759 .19844 m
.25759 .19844 L
s
.25767 .19844 m
.25767 .19844 L
s
.25774 .19638 m
.25774 .19638 L
s
.25781 .19947 m
.25781 .19947 L
s
.25788 .19638 m
.25788 .19638 L
s
.25796 .2005 m
.25796 .2005 L
s
.25803 .20565 m
.25803 .20565 L
s
.25811 .2108 m
.25811 .2108 L
s
.25818 .22006 m
.25818 .22006 L
s
.25826 .22623 m
.25826 .22623 L
s
.25833 .23138 m
.25833 .23138 L
s
.25841 .22829 m
.25841 .22829 L
s
.25848 .22933 m
.25848 .22933 L
s
.25856 .23035 m
.25856 .23035 L
s
.25863 .23653 m
.25863 .23653 L
s
.2587 .23447 m
.2587 .23447 L
s
.25878 .23962 m
.25878 .23962 L
s
.25885 .23962 m
.25885 .23962 L
s
.25893 .23962 m
.25893 .23962 L
s
.259 .2355 m
.259 .2355 L
s
.25908 .23962 m
.25908 .23962 L
s
.25915 .23859 m
.25915 .23859 L
s
.25923 .23447 m
.25923 .23447 L
s
.2593 .24167 m
.2593 .24167 L
s
.25937 .23962 m
.25937 .23962 L
s
.25944 .24374 m
.25944 .24374 L
s
.25952 .24167 m
.25952 .24167 L
s
.25959 .24374 m
.25959 .24374 L
s
.25967 .24579 m
.25967 .24579 L
s
.25974 .24271 m
.25974 .24271 L
s
.25982 .23962 m
.25982 .23962 L
s
.25989 .24786 m
.25989 .24786 L
s
.25997 .24579 m
.25997 .24579 L
s
.26004 .24477 m
.26004 .24477 L
s
.26012 .24477 m
.26012 .24477 L
s
.26019 .23962 m
.26019 .23962 L
s
.26026 .23756 m
.26026 .23756 L
s
.26034 .23653 m
.26034 .23653 L
s
.26041 .24477 m
.26041 .24477 L
s
.26049 .2355 m
.26049 .2355 L
s
.26056 .23756 m
.26056 .23756 L
s
.26064 .24167 m
.26064 .24167 L
s
.26071 .24065 m
.26071 .24065 L
s
.26078 .24065 m
.26078 .24065 L
s
.26086 .24167 m
.26086 .24167 L
s
.26094 .24991 m
.26094 .24991 L
s
.261 .24682 m
.261 .24682 L
s
.26108 .25918 m
.26108 .25918 L
s
.26115 .253 m
.26115 .253 L
s
.26123 .25712 m
.26123 .25712 L
s
.2613 .25609 m
.2613 .25609 L
s
.26138 .25609 m
.26138 .25609 L
s
.26145 .26227 m
.26145 .26227 L
s
.26153 .26535 m
.26153 .26535 L
s
.2616 .26741 m
.2616 .26741 L
s
.26167 .26124 m
.26167 .26124 L
s
.26175 .26639 m
.26175 .26639 L
s
.26182 .26432 m
.26182 .26432 L
s
.2619 .26639 m
.2619 .26639 L
s
.26197 .25918 m
.26197 .25918 L
s
.26205 .26535 m
.26205 .26535 L
s
.26212 .26639 m
.26212 .26639 L
s
.2622 .27462 m
.2622 .27462 L
s
.26227 .27153 m
.26227 .27153 L
s
.26234 .27256 m
.26234 .27256 L
s
.26241 .27359 m
.26241 .27359 L
s
.26249 .26947 m
.26249 .26947 L
s
.26257 .27565 m
.26257 .27565 L
s
.26264 .27256 m
.26264 .27256 L
s
.26271 .28492 m
.26271 .28492 L
s
.26279 .26741 m
.26279 .26741 L
s
.26286 .2705 m
.26286 .2705 L
s
.26294 .27359 m
.26294 .27359 L
s
.26301 .27565 m
.26301 .27565 L
s
.26309 .27565 m
.26309 .27565 L
s
.26316 .28285 m
.26316 .28285 L
s
.26323 .28285 m
.26323 .28285 L
s
.26331 .2808 m
.26331 .2808 L
s
.26338 .28492 m
.26338 .28492 L
s
.26346 .27771 m
.26346 .27771 L
s
.26353 .28388 m
.26353 .28388 L
s
.26361 .28492 m
.26361 .28492 L
s
.26368 .28697 m
.26368 .28697 L
s
.26376 .28492 m
.26376 .28492 L
s
.26383 .29212 m
.26383 .29212 L
s
.26391 .28697 m
.26391 .28697 L
s
.26397 .28388 m
.26397 .28388 L
s
.26405 .29006 m
.26405 .29006 L
s
.26412 .28594 m
.26412 .28594 L
s
.2642 .288 m
.2642 .288 L
s
.26427 .288 m
.26427 .288 L
s
.26435 .29418 m
.26435 .29418 L
s
.26442 .2983 m
.26442 .2983 L
s
.2645 .29315 m
.2645 .29315 L
s
.26457 .29418 m
.26457 .29418 L
s
.26465 .29212 m
.26465 .29212 L
s
.26472 .29006 m
.26472 .29006 L
s
.26479 .28903 m
.26479 .28903 L
s
.26487 .28903 m
.26487 .28903 L
s
.26494 .28697 m
.26494 .28697 L
s
.26502 .28285 m
.26502 .28285 L
s
.26509 .28183 m
.26509 .28183 L
s
.26517 .28388 m
.26517 .28388 L
s
.26524 .2808 m
.26524 .2808 L
s
.26532 .28903 m
.26532 .28903 L
s
.26539 .28492 m
.26539 .28492 L
s
.26547 .28183 m
.26547 .28183 L
s
.26554 .28285 m
.26554 .28285 L
s
.26561 .27771 m
.26561 .27771 L
s
.26568 .28183 m
.26568 .28183 L
s
.26576 .27565 m
.26576 .27565 L
s
.26583 .27565 m
.26583 .27565 L
s
.26591 .27565 m
.26591 .27565 L
s
.26598 .27359 m
.26598 .27359 L
s
.26606 .26741 m
.26606 .26741 L
s
.26613 .26639 m
.26613 .26639 L
s
.26621 .26227 m
.26621 .26227 L
s
.26628 .26432 m
.26628 .26432 L
s
.26636 .26535 m
.26636 .26535 L
s
.26643 .26639 m
.26643 .26639 L
s
.2665 .26535 m
.2665 .26535 L
s
.26658 .26432 m
.26658 .26432 L
s
.26665 .26947 m
.26665 .26947 L
s
.26673 .26639 m
.26673 .26639 L
s
.2668 .26844 m
.2668 .26844 L
s
.26688 .27256 m
.26688 .27256 L
s
.26695 .26741 m
.26695 .26741 L
s
.26703 .27462 m
.26703 .27462 L
s
.2671 .28388 m
.2671 .28388 L
s
.26717 .28285 m
.26717 .28285 L
s
.26724 .27873 m
.26724 .27873 L
s
.26732 .27873 m
.26732 .27873 L
s
.26739 .27462 m
.26739 .27462 L
s
.26747 .27668 m
.26747 .27668 L
s
.26754 .27359 m
.26754 .27359 L
s
.26762 .27462 m
.26762 .27462 L
s
.26769 .27359 m
.26769 .27359 L
s
.26777 .27771 m
.26777 .27771 L
s
.26784 .27977 m
.26784 .27977 L
s
.26792 .27668 m
.26792 .27668 L
s
.26799 .27462 m
.26799 .27462 L
s
.26806 .2705 m
.26806 .2705 L
s
.26814 .27153 m
.26814 .27153 L
s
.26821 .26639 m
.26821 .26639 L
s
.26829 .27462 m
.26829 .27462 L
s
.26836 .26947 m
.26836 .26947 L
s
.26844 .27668 m
.26844 .27668 L
s
.26851 .26844 m
.26851 .26844 L
s
.26858 .2705 m
.26858 .2705 L
s
.26866 .27153 m
.26866 .27153 L
s
.26874 .27153 m
.26874 .27153 L
s
.2688 .27873 m
.2688 .27873 L
s
.26888 .26741 m
.26888 .26741 L
s
.26895 .26741 m
.26895 .26741 L
s
.26903 .26432 m
.26903 .26432 L
s
.2691 .26844 m
.2691 .26844 L
s
.26918 .25918 m
.26918 .25918 L
s
.26925 .25609 m
.26925 .25609 L
s
.26933 .253 m
.26933 .253 L
s
.2694 .25094 m
.2694 .25094 L
s
.26948 .24167 m
.26948 .24167 L
s
.26956 .24579 m
.26956 .24579 L
s
.26962 .23962 m
.26962 .23962 L
s
.2697 .22521 m
.2697 .22521 L
s
.26977 .23241 m
.26977 .23241 L
s
.26985 .22521 m
.26985 .22521 L
s
.26992 .22623 m
.26992 .22623 L
s
.27 .218 m
.27 .218 L
s
.27007 .22314 m
.27007 .22314 L
s
.27014 .218 m
.27014 .218 L
s
.27021 .21491 m
.27021 .21491 L
s
.27029 .21182 m
.27029 .21182 L
s
.27037 .21697 m
.27037 .21697 L
s
.27044 .21491 m
.27044 .21491 L
s
.27051 .20976 m
.27051 .20976 L
s
.27059 .21388 m
.27059 .21388 L
s
.27066 .20771 m
.27066 .20771 L
s
.27074 .20565 m
.27074 .20565 L
s
.27081 .19844 m
.27081 .19844 L
s
.27089 .20461 m
.27089 .20461 L
s
.27096 .2005 m
.27096 .2005 L
s
.27103 .20153 m
.27103 .20153 L
s
.27111 .20565 m
.27111 .20565 L
s
.27119 .20256 m
.27119 .20256 L
s
.27126 .19844 m
.27126 .19844 L
s
.27133 .20153 m
.27133 .20153 L
s
.27141 .20668 m
.27141 .20668 L
s
.27148 .20668 m
.27148 .20668 L
s
.27156 .2108 m
.27156 .2108 L
s
.27163 .21285 m
.27163 .21285 L
s
.27171 .21594 m
.27171 .21594 L
s
.27177 .21697 m
.27177 .21697 L
s
.27185 .22006 m
.27185 .22006 L
s
.27192 .21903 m
.27192 .21903 L
s
.272 .21491 m
.272 .21491 L
s
.27207 .21594 m
.27207 .21594 L
s
.27215 .21903 m
.27215 .21903 L
s
.27222 .22623 m
.27222 .22623 L
s
.2723 .21388 m
.2723 .21388 L
s
.27237 .22314 m
.27237 .22314 L
s
.27245 .21491 m
.27245 .21491 L
s
.27252 .21903 m
.27252 .21903 L
s
.27259 .218 m
.27259 .218 L
s
.27267 .21697 m
.27267 .21697 L
s
.27274 .20771 m
.27274 .20771 L
s
.27282 .2108 m
.27282 .2108 L
s
.27289 .20873 m
.27289 .20873 L
s
.27297 .21594 m
.27297 .21594 L
s
.27304 .21388 m
.27304 .21388 L
s
.27312 .21182 m
.27312 .21182 L
s
.27319 .21388 m
.27319 .21388 L
s
.27327 .21388 m
.27327 .21388 L
s
.27334 .21491 m
.27334 .21491 L
s
.27341 .21594 m
.27341 .21594 L
s
.27348 .21388 m
.27348 .21388 L
s
.27356 .22418 m
.27356 .22418 L
s
.27363 .22623 m
.27363 .22623 L
s
.27371 .22623 m
.27371 .22623 L
s
.27378 .22006 m
.27378 .22006 L
s
.27386 .21594 m
.27386 .21594 L
s
.27393 .21388 m
.27393 .21388 L
s
.27401 .20771 m
.27401 .20771 L
s
.27408 .20256 m
.27408 .20256 L
s
.27416 .20256 m
.27416 .20256 L
s
.27423 .20668 m
.27423 .20668 L
s
.2743 .20565 m
.2743 .20565 L
s
.27438 .2108 m
.27438 .2108 L
s
.27445 .20461 m
.27445 .20461 L
s
.27453 .20668 m
.27453 .20668 L
s
.2746 .20461 m
.2746 .20461 L
s
.27468 .20461 m
.27468 .20461 L
s
.27475 .20565 m
.27475 .20565 L
s
.27483 .20153 m
.27483 .20153 L
s
.2749 .20153 m
.2749 .20153 L
s
.27497 .20771 m
.27497 .20771 L
s
.27504 .20565 m
.27504 .20565 L
s
.27512 .20873 m
.27512 .20873 L
s
.27519 .2108 m
.27519 .2108 L
s
.27527 .21388 m
.27527 .21388 L
s
.27534 .22418 m
.27534 .22418 L
s
.27542 .22726 m
.27542 .22726 L
s
.27549 .22212 m
.27549 .22212 L
s
.27557 .21491 m
.27557 .21491 L
s
.27564 .21182 m
.27564 .21182 L
s
.27572 .20668 m
.27572 .20668 L
s
.27579 .20256 m
.27579 .20256 L
s
.27586 .19741 m
.27586 .19741 L
s
.27594 .1902 m
.27594 .1902 L
s
.27601 .1902 m
.27601 .1902 L
s
.27609 .19535 m
.27609 .19535 L
s
.27616 .19535 m
.27616 .19535 L
s
.27624 .19432 m
.27624 .19432 L
s
.27631 .19844 m
.27631 .19844 L
s
.27639 .18917 m
.27639 .18917 L
s
.27646 .19432 m
.27646 .19432 L
s
.27654 .18608 m
.27654 .18608 L
s
.2766 .19227 m
.2766 .19227 L
s
.27668 .1902 m
.27668 .1902 L
s
.27675 .18815 m
.27675 .18815 L
s
.27683 .1902 m
.27683 .1902 L
s
.2769 .183 m
.2769 .183 L
s
.27698 .19124 m
.27698 .19124 L
s
.27705 .183 m
.27705 .183 L
s
.27713 .18608 m
.27713 .18608 L
s
.2772 .18608 m
.2772 .18608 L
s
.27728 .18403 m
.27728 .18403 L
s
.27736 .18094 m
.27736 .18094 L
s
.27742 .17682 m
.27742 .17682 L
s
.2775 .17167 m
.2775 .17167 L
s
.27757 .17579 m
.27757 .17579 L
s
.27765 .17682 m
.27765 .17682 L
s
.27772 .17476 m
.27772 .17476 L
s
.2778 .17888 m
.2778 .17888 L
s
.27787 .17271 m
.27787 .17271 L
s
.27794 .16755 m
.27794 .16755 L
s
.27802 .17064 m
.27802 .17064 L
s
.2781 .17888 m
.2781 .17888 L
s
.27817 .17888 m
.27817 .17888 L
s
.27824 .17888 m
.27824 .17888 L
s
.27831 .17991 m
.27831 .17991 L
s
.27839 .17064 m
.27839 .17064 L
s
.27846 .17167 m
.27846 .17167 L
s
.27854 .16962 m
.27854 .16962 L
s
.27861 .17374 m
.27861 .17374 L
s
.27869 .17064 m
.27869 .17064 L
s
.27876 .17167 m
.27876 .17167 L
s
.27883 .15829 m
.27883 .15829 L
s
.27891 .16241 m
.27891 .16241 L
s
.27899 .16035 m
.27899 .16035 L
s
.27906 .1655 m
.27906 .1655 L
s
.27913 .16447 m
.27913 .16447 L
s
.27921 .16138 m
.27921 .16138 L
s
.27928 .16447 m
.27928 .16447 L
s
.27936 .15932 m
.27936 .15932 L
s
.27943 .16447 m
.27943 .16447 L
s
.27951 .16241 m
.27951 .16241 L
s
.27957 .16241 m
.27957 .16241 L
s
.27965 .17064 m
.27965 .17064 L
s
.27973 .17682 m
.27973 .17682 L
s
.2798 .17991 m
.2798 .17991 L
s
.27987 .17785 m
.27987 .17785 L
s
.27995 .18815 m
.27995 .18815 L
s
.28002 .19227 m
.28002 .19227 L
s
.2801 .19844 m
.2801 .19844 L
s
.28017 .19638 m
.28017 .19638 L
s
.28025 .20153 m
.28025 .20153 L
s
.28032 .20153 m
.28032 .20153 L
s
.28039 .20668 m
.28039 .20668 L
s
.28047 .20153 m
.28047 .20153 L
s
.28054 .19844 m
.28054 .19844 L
s
.28062 .2005 m
.28062 .2005 L
s
.28069 .19844 m
.28069 .19844 L
s
.28077 .20256 m
.28077 .20256 L
s
.28084 .19741 m
.28084 .19741 L
s
.28092 .20256 m
.28092 .20256 L
s
.28099 .19947 m
.28099 .19947 L
s
.28107 .20565 m
.28107 .20565 L
s
.28114 .20359 m
.28114 .20359 L
s
.28121 .2108 m
.28121 .2108 L
s
.28128 .21182 m
.28128 .21182 L
s
.28136 .20976 m
.28136 .20976 L
s
.28144 .20873 m
.28144 .20873 L
s
.28151 .2108 m
.28151 .2108 L
s
.28158 .21388 m
.28158 .21388 L
s
.28166 .20461 m
.28166 .20461 L
s
.28173 .20771 m
.28173 .20771 L
s
.28181 .20771 m
.28181 .20771 L
s
.28188 .20771 m
.28188 .20771 L
s
.28196 .20976 m
.28196 .20976 L
s
.28203 .2108 m
.28203 .2108 L
s
.2821 .20771 m
.2821 .20771 L
s
.28218 .2108 m
.28218 .2108 L
s
.28225 .20256 m
.28225 .20256 L
s
.28233 .2005 m
.28233 .2005 L
s
.2824 .2108 m
.2824 .2108 L
s
.28248 .20771 m
.28248 .20771 L
s
.28255 .20668 m
.28255 .20668 L
s
.28263 .2108 m
.28263 .2108 L
s
.2827 .22212 m
.2827 .22212 L
s
.28277 .22212 m
.28277 .22212 L
s
.28284 .22418 m
.28284 .22418 L
s
.28292 .21903 m
.28292 .21903 L
s
.28299 .22726 m
.28299 .22726 L
s
.28307 .23138 m
.28307 .23138 L
s
.28314 .23447 m
.28314 .23447 L
s
.28322 .23344 m
.28322 .23344 L
s
.28329 .23241 m
.28329 .23241 L
s
.28337 .23447 m
.28337 .23447 L
s
.28344 .22314 m
.28344 .22314 L
s
.28352 .22212 m
.28352 .22212 L
s
.28359 .22109 m
.28359 .22109 L
s
.28366 .22933 m
.28366 .22933 L
s
.28374 .22933 m
.28374 .22933 L
s
.28381 .22933 m
.28381 .22933 L
s
.28389 .23138 m
.28389 .23138 L
s
.28396 .23035 m
.28396 .23035 L
s
.28404 .22933 m
.28404 .22933 L
s
.28411 .22933 m
.28411 .22933 L
s
.28419 .22726 m
.28419 .22726 L
s
.28426 .218 m
.28426 .218 L
s
.28434 .22109 m
.28434 .22109 L
s
.28441 .22418 m
.28441 .22418 L
s
.28448 .22521 m
.28448 .22521 L
s
.28455 .21903 m
.28455 .21903 L
s
.28463 .21594 m
.28463 .21594 L
s
.2847 .21491 m
.2847 .21491 L
s
.28478 .21491 m
.28478 .21491 L
s
.28485 .21903 m
.28485 .21903 L
s
.28493 .21697 m
.28493 .21697 L
s
.285 .22418 m
.285 .22418 L
s
.28508 .21903 m
.28508 .21903 L
s
.28516 .22006 m
.28516 .22006 L
s
.28522 .218 m
.28522 .218 L
s
.2853 .22623 m
.2853 .22623 L
s
.28537 .22521 m
.28537 .22521 L
s
.28545 .22726 m
.28545 .22726 L
s
.28552 .22726 m
.28552 .22726 L
s
.2856 .23138 m
.2856 .23138 L
s
.28567 .23962 m
.28567 .23962 L
s
.28574 .23859 m
.28574 .23859 L
s
.28582 .24786 m
.28582 .24786 L
s
.2859 .25197 m
.2859 .25197 L
s
.28597 .25403 m
.28597 .25403 L
s
.28604 .24786 m
.28604 .24786 L
s
.28611 .24271 m
.28611 .24271 L
s
.28619 .24167 m
.28619 .24167 L
s
.28626 .24065 m
.28626 .24065 L
s
.28634 .23653 m
.28634 .23653 L
s
.28641 .23138 m
.28641 .23138 L
s
.28649 .2355 m
.28649 .2355 L
s
.28656 .22933 m
.28656 .22933 L
s
.28664 .23138 m
.28664 .23138 L
s
.28672 .22933 m
.28672 .22933 L
s
.28679 .23447 m
.28679 .23447 L
s
.28686 .23035 m
.28686 .23035 L
s
.28693 .2355 m
.28693 .2355 L
s
.28701 .23756 m
.28701 .23756 L
s
.28708 .23138 m
.28708 .23138 L
s
.28716 .2355 m
.28716 .2355 L
s
.28723 .23344 m
.28723 .23344 L
s
.28731 .2355 m
.28731 .2355 L
s
.28738 .23241 m
.28738 .23241 L
s
.28745 .23447 m
.28745 .23447 L
s
.28753 .23344 m
.28753 .23344 L
s
.2876 .23653 m
.2876 .23653 L
s
.28767 .2355 m
.28767 .2355 L
s
.28775 .23653 m
.28775 .23653 L
s
.28782 .23138 m
.28782 .23138 L
s
.2879 .22933 m
.2879 .22933 L
s
.28797 .22726 m
.28797 .22726 L
s
.28805 .22418 m
.28805 .22418 L
s
.28812 .22726 m
.28812 .22726 L
s
.28819 .22006 m
.28819 .22006 L
s
.28827 .22623 m
.28827 .22623 L
s
.28835 .22521 m
.28835 .22521 L
s
.28842 .22314 m
.28842 .22314 L
s
.28849 .22212 m
.28849 .22212 L
s
.28857 .22314 m
.28857 .22314 L
s
.28864 .22726 m
.28864 .22726 L
s
.28872 .22623 m
.28872 .22623 L
s
.28879 .23035 m
.28879 .23035 L
s
.28887 .22726 m
.28887 .22726 L
s
.28894 .22829 m
.28894 .22829 L
s
.28901 .22623 m
.28901 .22623 L
s
.28908 .22829 m
.28908 .22829 L
s
.28916 .22726 m
.28916 .22726 L
s
.28924 .22933 m
.28924 .22933 L
s
.28931 .22314 m
.28931 .22314 L
s
.28938 .22623 m
.28938 .22623 L
s
.28946 .23241 m
.28946 .23241 L
s
.28953 .23344 m
.28953 .23344 L
s
.28961 .23447 m
.28961 .23447 L
s
.28968 .23138 m
.28968 .23138 L
s
.28976 .23035 m
.28976 .23035 L
s
.28983 .23138 m
.28983 .23138 L
s
.2899 .22829 m
.2899 .22829 L
s
.28998 .22829 m
.28998 .22829 L
s
.29005 .22726 m
.29005 .22726 L
s
.29013 .22726 m
.29013 .22726 L
s
.2902 .22933 m
.2902 .22933 L
s
.29028 .22418 m
.29028 .22418 L
s
.29035 .22212 m
.29035 .22212 L
s
.29043 .23035 m
.29043 .23035 L
s
.2905 .22933 m
.2905 .22933 L
s
.29057 .23756 m
.29057 .23756 L
s
.29064 .23138 m
.29064 .23138 L
s
.29072 .23962 m
.29072 .23962 L
s
.29079 .24682 m
.29079 .24682 L
s
.29087 .24682 m
.29087 .24682 L
s
.29094 .23756 m
.29094 .23756 L
s
.29102 .23859 m
.29102 .23859 L
s
.29109 .23447 m
.29109 .23447 L
s
.29117 .23859 m
.29117 .23859 L
s
.29124 .23447 m
.29124 .23447 L
s
.29132 .23035 m
.29132 .23035 L
s
.29139 .23035 m
.29139 .23035 L
s
.29146 .22726 m
.29146 .22726 L
s
.29154 .23035 m
.29154 .23035 L
s
.29161 .22521 m
.29161 .22521 L
s
.29169 .22314 m
.29169 .22314 L
s
.29176 .21697 m
.29176 .21697 L
s
.29184 .218 m
.29184 .218 L
s
.29191 .22212 m
.29191 .22212 L
s
.29199 .22521 m
.29199 .22521 L
s
.29206 .23447 m
.29206 .23447 L
s
.29214 .23344 m
.29214 .23344 L
s
.29221 .23653 m
.29221 .23653 L
s
.29228 .23138 m
.29228 .23138 L
s
.29235 .23756 m
.29235 .23756 L
s
.29243 .22726 m
.29243 .22726 L
s
.2925 .22418 m
.2925 .22418 L
s
.29258 .218 m
.29258 .218 L
s
.29265 .21697 m
.29265 .21697 L
s
.29273 .21285 m
.29273 .21285 L
s
.2928 .20668 m
.2928 .20668 L
s
.29288 .20668 m
.29288 .20668 L
s
.29296 .20359 m
.29296 .20359 L
s
.29302 .20461 m
.29302 .20461 L
s
.2931 .20256 m
.2931 .20256 L
s
.29317 .20256 m
.29317 .20256 L
s
.29325 .2005 m
.29325 .2005 L
s
.29332 .20461 m
.29332 .20461 L
s
.2934 .20256 m
.2934 .20256 L
s
.29347 .20153 m
.29347 .20153 L
s
.29355 .19741 m
.29355 .19741 L
s
.29362 .19947 m
.29362 .19947 L
s
.2937 .19638 m
.2937 .19638 L
s
.29377 .19329 m
.29377 .19329 L
s
.29384 .20256 m
.29384 .20256 L
s
.29391 .20873 m
.29391 .20873 L
s
.29399 .2108 m
.29399 .2108 L
s
.29406 .20461 m
.29406 .20461 L
s
.29414 .19844 m
.29414 .19844 L
s
.29421 .19227 m
.29421 .19227 L
s
.29429 .19329 m
.29429 .19329 L
s
.29436 .19329 m
.29436 .19329 L
s
.29444 .19329 m
.29444 .19329 L
s
.29452 .2005 m
.29452 .2005 L
s
.29459 .19432 m
.29459 .19432 L
s
.29466 .19741 m
.29466 .19741 L
s
.29473 .19329 m
.29473 .19329 L
s
.29481 .19124 m
.29481 .19124 L
s
.29488 .1902 m
.29488 .1902 L
s
.29496 .19227 m
.29496 .19227 L
s
.29503 .2005 m
.29503 .2005 L
s
.29511 .20668 m
.29511 .20668 L
s
.29518 .20976 m
.29518 .20976 L
s
.29526 .2108 m
.29526 .2108 L
s
.29533 .21182 m
.29533 .21182 L
s
.2954 .20256 m
.2954 .20256 L
s
.29547 .20668 m
.29547 .20668 L
s
.29555 .20359 m
.29555 .20359 L
s
.29562 .20461 m
.29562 .20461 L
s
.2957 .19741 m
.2957 .19741 L
s
.29577 .19432 m
.29577 .19432 L
s
.29585 .18815 m
.29585 .18815 L
s
.29592 .1902 m
.29592 .1902 L
s
.29599 .18712 m
.29599 .18712 L
s
.29607 .18197 m
.29607 .18197 L
s
.29615 .18815 m
.29615 .18815 L
s
.29622 .18815 m
.29622 .18815 L
s
.29629 .19124 m
.29629 .19124 L
s
.29637 .18403 m
.29637 .18403 L
s
.29644 .1902 m
.29644 .1902 L
s
.29652 .18608 m
.29652 .18608 L
s
.29659 .18197 m
.29659 .18197 L
s
.29667 .18815 m
.29667 .18815 L
s
.29674 .18815 m
.29674 .18815 L
s
.29681 .18917 m
.29681 .18917 L
s
.29689 .18815 m
.29689 .18815 L
s
.29697 .19535 m
.29697 .19535 L
s
.29704 .18608 m
.29704 .18608 L
s
.29711 .18608 m
.29711 .18608 L
s
.29718 .183 m
.29718 .183 L
s
.29726 .18712 m
.29726 .18712 L
s
.29733 .18815 m
.29733 .18815 L
s
.29741 .18506 m
.29741 .18506 L
s
.29748 .183 m
.29748 .183 L
s
.29756 .18197 m
.29756 .18197 L
s
.29763 .183 m
.29763 .183 L
s
.2977 .18506 m
.2977 .18506 L
s
.29778 .19329 m
.29778 .19329 L
s
.29785 .18608 m
.29785 .18608 L
s
.29793 .183 m
.29793 .183 L
s
.298 .18815 m
.298 .18815 L
s
.29808 .19741 m
.29808 .19741 L
s
.29815 .19638 m
.29815 .19638 L
s
.29823 .19844 m
.29823 .19844 L
s
.2983 .20256 m
.2983 .20256 L
s
.29837 .20153 m
.29837 .20153 L
s
.29844 .2005 m
.29844 .2005 L
s
.29852 .19741 m
.29852 .19741 L
s
.2986 .19844 m
.2986 .19844 L
s
.29867 .19227 m
.29867 .19227 L
s
.29874 .19329 m
.29874 .19329 L
s
.29882 .18815 m
.29882 .18815 L
s
.29889 .18917 m
.29889 .18917 L
s
.29897 .18094 m
.29897 .18094 L
s
.29904 .18608 m
.29904 .18608 L
s
.29912 .18403 m
.29912 .18403 L
s
.29919 .18403 m
.29919 .18403 L
s
.29926 .18712 m
.29926 .18712 L
s
.29934 .18712 m
.29934 .18712 L
s
.29941 .19124 m
.29941 .19124 L
s
.29949 .18506 m
.29949 .18506 L
s
.29956 .18815 m
.29956 .18815 L
s
.29964 .18403 m
.29964 .18403 L
s
.29971 .1902 m
.29971 .1902 L
s
.29979 .18815 m
.29979 .18815 L
s
.29986 .19329 m
.29986 .19329 L
s
.29994 .19432 m
.29994 .19432 L
s
.30001 .19124 m
.30001 .19124 L
s
.30008 .19741 m
.30008 .19741 L
s
.30015 .19844 m
.30015 .19844 L
s
.30023 .20256 m
.30023 .20256 L
s
.3003 .20565 m
.3003 .20565 L
s
.30038 .21697 m
.30038 .21697 L
s
.30045 .21491 m
.30045 .21491 L
s
.30053 .21594 m
.30053 .21594 L
s
.3006 .21388 m
.3006 .21388 L
s
.30068 .21491 m
.30068 .21491 L
s
.30076 .21491 m
.30076 .21491 L
s
.30082 .21182 m
.30082 .21182 L
s
.3009 .22212 m
.3009 .22212 L
s
.30097 .20873 m
.30097 .20873 L
s
.30105 .20565 m
.30105 .20565 L
s
.30112 .20359 m
.30112 .20359 L
s
.3012 .20976 m
.3012 .20976 L
s
.30127 .2005 m
.30127 .2005 L
s
.30135 .20565 m
.30135 .20565 L
s
.30142 .20565 m
.30142 .20565 L
s
.3015 .2108 m
.3015 .2108 L
s
.30157 .22006 m
.30157 .22006 L
s
.30164 .2108 m
.30164 .2108 L
s
.30171 .21285 m
.30171 .21285 L
s
.30179 .20668 m
.30179 .20668 L
s
.30186 .21182 m
.30186 .21182 L
s
.30194 .20873 m
.30194 .20873 L
s
.30201 .21491 m
.30201 .21491 L
s
.30209 .21182 m
.30209 .21182 L
s
.30216 .21182 m
.30216 .21182 L
s
.30224 .21285 m
.30224 .21285 L
s
.30232 .21285 m
.30232 .21285 L
s
.30239 .218 m
.30239 .218 L
s
.30246 .218 m
.30246 .218 L
s
.30253 .21697 m
.30253 .21697 L
s
.30261 .21594 m
.30261 .21594 L
s
.30268 .218 m
.30268 .218 L
s
.30276 .21903 m
.30276 .21903 L
s
.30283 .21903 m
.30283 .21903 L
s
.30291 .21491 m
.30291 .21491 L
s
.30298 .22006 m
.30298 .22006 L
s
.30306 .21491 m
.30306 .21491 L
s
.30313 .21285 m
.30313 .21285 L
s
.3032 .21285 m
.3032 .21285 L
s
.30327 .21388 m
.30327 .21388 L
s
.30335 .218 m
.30335 .218 L
s
.30342 .22521 m
.30342 .22521 L
s
.3035 .22829 m
.3035 .22829 L
s
.30357 .22623 m
.30357 .22623 L
s
.30365 .22521 m
.30365 .22521 L
s
.30372 .22314 m
.30372 .22314 L
s
.3038 .22623 m
.3038 .22623 L
s
.30388 .23138 m
.30388 .23138 L
s
.30395 .2355 m
.30395 .2355 L
s
.30402 .23241 m
.30402 .23241 L
s
.30409 .23447 m
.30409 .23447 L
s
.30417 .23653 m
.30417 .23653 L
s
.30424 .23138 m
.30424 .23138 L
s
.30432 .23344 m
.30432 .23344 L
s
.30439 .23344 m
.30439 .23344 L
s
.30447 .2355 m
.30447 .2355 L
s
.30454 .23035 m
.30454 .23035 L
s
.30461 .23138 m
.30461 .23138 L
s
.30469 .23447 m
.30469 .23447 L
s
.30477 .23344 m
.30477 .23344 L
s
.30484 .23653 m
.30484 .23653 L
s
.30491 .23344 m
.30491 .23344 L
s
.30498 .23138 m
.30498 .23138 L
s
.30506 .22829 m
.30506 .22829 L
s
.30513 .23756 m
.30513 .23756 L
s
.30521 .23756 m
.30521 .23756 L
s
.30528 .23653 m
.30528 .23653 L
s
.30536 .23138 m
.30536 .23138 L
s
.30543 .22829 m
.30543 .22829 L
s
.30551 .23344 m
.30551 .23344 L
s
.30559 .23344 m
.30559 .23344 L
s
.30565 .23653 m
.30565 .23653 L
s
.30573 .22521 m
.30573 .22521 L
s
.3058 .23344 m
.3058 .23344 L
s
.30588 .22829 m
.30588 .22829 L
s
.30595 .22623 m
.30595 .22623 L
s
.30603 .22418 m
.30603 .22418 L
s
.3061 .22212 m
.3061 .22212 L
s
.30617 .22726 m
.30617 .22726 L
s
.30624 .22314 m
.30624 .22314 L
s
.30632 .22212 m
.30632 .22212 L
s
.3064 .22726 m
.3064 .22726 L
s
.30647 .23035 m
.30647 .23035 L
s
.30654 .23344 m
.30654 .23344 L
s
.30662 .23344 m
.30662 .23344 L
s
.30669 .23241 m
.30669 .23241 L
s
.30677 .23138 m
.30677 .23138 L
s
.30684 .22933 m
.30684 .22933 L
s
.30692 .22314 m
.30692 .22314 L
s
.30699 .218 m
.30699 .218 L
s
.30706 .22109 m
.30706 .22109 L
s
.30714 .22418 m
.30714 .22418 L
s
.30722 .22726 m
.30722 .22726 L
s
.30729 .23035 m
.30729 .23035 L
s
.30736 .22109 m
.30736 .22109 L
s
.30744 .22418 m
.30744 .22418 L
s
.30751 .22521 m
.30751 .22521 L
s
.30759 .23241 m
.30759 .23241 L
s
.30766 .23241 m
.30766 .23241 L
s
.30774 .23653 m
.30774 .23653 L
s
.30781 .2355 m
.30781 .2355 L
s
.30788 .23756 m
.30788 .23756 L
s
.30795 .2355 m
.30795 .2355 L
s
.30803 .23756 m
.30803 .23756 L
s
.3081 .24167 m
.3081 .24167 L
s
.30818 .23756 m
.30818 .23756 L
s
.30825 .24167 m
.30825 .24167 L
s
.30833 .24271 m
.30833 .24271 L
s
.3084 .24888 m
.3084 .24888 L
s
.30848 .25506 m
.30848 .25506 L
s
.30856 .25506 m
.30856 .25506 L
s
.30862 .25506 m
.30862 .25506 L
s
.3087 .24888 m
.3087 .24888 L
s
.30877 .24991 m
.30877 .24991 L
s
.30885 .24888 m
.30885 .24888 L
s
.30892 .25815 m
.30892 .25815 L
s
.309 .25094 m
.309 .25094 L
s
.30907 .24682 m
.30907 .24682 L
s
.30915 .24167 m
.30915 .24167 L
s
.30922 .24374 m
.30922 .24374 L
s
.3093 .24682 m
.3093 .24682 L
s
.30937 .24374 m
.30937 .24374 L
s
.30944 .24682 m
.30944 .24682 L
s
.30951 .24682 m
.30951 .24682 L
s
.30959 .24477 m
.30959 .24477 L
s
.30966 .2355 m
.30966 .2355 L
s
.30974 .23962 m
.30974 .23962 L
s
.30981 .23653 m
.30981 .23653 L
s
.30989 .23962 m
.30989 .23962 L
s
.30996 .23859 m
.30996 .23859 L
s
.31004 .22829 m
.31004 .22829 L
s
.31012 .22623 m
.31012 .22623 L
s
.31019 .23138 m
.31019 .23138 L
s
.31026 .23241 m
.31026 .23241 L
s
.31033 .23344 m
.31033 .23344 L
s
.31041 .23756 m
.31041 .23756 L
s
.31048 .24579 m
.31048 .24579 L
s
.31056 .25094 m
.31056 .25094 L
s
.31063 .24682 m
.31063 .24682 L
s
.31071 .2602 m
.31071 .2602 L
s
.31078 .25918 m
.31078 .25918 L
s
.31086 .2602 m
.31086 .2602 L
s
.31093 .26124 m
.31093 .26124 L
s
.311 .26329 m
.311 .26329 L
s
.31107 .2602 m
.31107 .2602 L
s
.31115 .2602 m
.31115 .2602 L
s
.31122 .26844 m
.31122 .26844 L
s
.3113 .26639 m
.3113 .26639 L
s
.31137 .27153 m
.31137 .27153 L
s
.31145 .27462 m
.31145 .27462 L
s
.31152 .27256 m
.31152 .27256 L
s
.3116 .27462 m
.3116 .27462 L
s
.31168 .27462 m
.31168 .27462 L
s
.31175 .26741 m
.31175 .26741 L
s
.31182 .26432 m
.31182 .26432 L
s
.31189 .26227 m
.31189 .26227 L
s
.31197 .26227 m
.31197 .26227 L
s
.31204 .27256 m
.31204 .27256 L
s
.31212 .26741 m
.31212 .26741 L
s
.31219 .27256 m
.31219 .27256 L
s
.31227 .27359 m
.31227 .27359 L
s
.31234 .27668 m
.31234 .27668 L
s
.31242 .27462 m
.31242 .27462 L
s
.31249 .2705 m
.31249 .2705 L
s
.31257 .27462 m
.31257 .27462 L
s
.31264 .27359 m
.31264 .27359 L
s
.31271 .27462 m
.31271 .27462 L
s
.31278 .27873 m
.31278 .27873 L
s
.31286 .2808 m
.31286 .2808 L
s
.31293 .27977 m
.31293 .27977 L
s
.31301 .29006 m
.31301 .29006 L
s
.31308 .28492 m
.31308 .28492 L
s
.31316 .29212 m
.31316 .29212 L
s
.31323 .29315 m
.31323 .29315 L
s
.31331 .29109 m
.31331 .29109 L
s
.31339 .29933 m
.31339 .29933 L
s
.31345 .30035 m
.31345 .30035 L
s
.31353 .30138 m
.31353 .30138 L
s
.3136 .30859 m
.3136 .30859 L
s
.31368 .30962 m
.31368 .30962 L
s
.31375 .3055 m
.31375 .3055 L
s
.31383 .30962 m
.31383 .30962 L
s
.3139 .3055 m
.3139 .3055 L
s
.31397 .30756 m
.31397 .30756 L
s
.31405 .30035 m
.31405 .30035 L
s
.31413 .30653 m
.31413 .30653 L
s
.3142 .30756 m
.3142 .30756 L
s
.31427 .31168 m
.31427 .31168 L
s
.31434 .31065 m
.31434 .31065 L
s
.31442 .30138 m
.31442 .30138 L
s
.31449 .31168 m
.31449 .31168 L
s
.31457 .3055 m
.31457 .3055 L
s
.31464 .30859 m
.31464 .30859 L
s
.31472 .30756 m
.31472 .30756 L
s
.31479 .30756 m
.31479 .30756 L
s
.31486 .31374 m
.31486 .31374 L
s
.31494 .31374 m
.31494 .31374 L
s
.31502 .31579 m
.31502 .31579 L
s
.31509 .31991 m
.31509 .31991 L
s
.31516 .32094 m
.31516 .32094 L
s
.31524 .31991 m
.31524 .31991 L
s
.31531 .31786 m
.31531 .31786 L
s
.31539 .31477 m
.31539 .31477 L
s
.31546 .32198 m
.31546 .32198 L
s
.31554 .31991 m
.31554 .31991 L
s
.31561 .32403 m
.31561 .32403 L
s
.31568 .323 m
.31568 .323 L
s
.31576 .32815 m
.31576 .32815 L
s
.31584 .32918 m
.31584 .32918 L
s
.3159 .32094 m
.3159 .32094 L
s
.31598 .32094 m
.31598 .32094 L
s
.31605 .31374 m
.31605 .31374 L
s
.31613 .31683 m
.31613 .31683 L
s
.3162 .30653 m
.3162 .30653 L
s
.31628 .30345 m
.31628 .30345 L
s
.31636 .3055 m
.31636 .3055 L
s
.31642 .30345 m
.31642 .30345 L
s
.3165 .30138 m
.3165 .30138 L
s
.31657 .30447 m
.31657 .30447 L
s
.31665 .3055 m
.31665 .3055 L
s
.31672 .30756 m
.31672 .30756 L
s
.3168 .31168 m
.3168 .31168 L
s
.31687 .31065 m
.31687 .31065 L
s
.31695 .30756 m
.31695 .30756 L
s
.31702 .30138 m
.31702 .30138 L
s
.3171 .30859 m
.3171 .30859 L
s
.31717 .3055 m
.31717 .3055 L
s
.31724 .30447 m
.31724 .30447 L
s
.31731 .30447 m
.31731 .30447 L
s
.31739 .30345 m
.31739 .30345 L
s
.31747 .3055 m
.31747 .3055 L
s
.31754 .30962 m
.31754 .30962 L
s
.31761 .30756 m
.31761 .30756 L
s
.31769 .30447 m
.31769 .30447 L
s
.31776 .30653 m
.31776 .30653 L
s
.31784 .30241 m
.31784 .30241 L
s
.31792 .30653 m
.31792 .30653 L
s
.31799 .30447 m
.31799 .30447 L
s
.31806 .30962 m
.31806 .30962 L
s
.31813 .30756 m
.31813 .30756 L
s
.31821 .31374 m
.31821 .31374 L
s
.31828 .31374 m
.31828 .31374 L
s
.31836 .31374 m
.31836 .31374 L
s
.31843 .31786 m
.31843 .31786 L
s
.31851 .31888 m
.31851 .31888 L
s
.31858 .32506 m
.31858 .32506 L
s
.31866 .31579 m
.31866 .31579 L
s
.31873 .31786 m
.31873 .31786 L
s
.31881 .30756 m
.31881 .30756 L
s
.31887 .30962 m
.31887 .30962 L
s
.31895 .3055 m
.31895 .3055 L
s
.31902 .31168 m
.31902 .31168 L
s
.3191 .31579 m
.3191 .31579 L
s
.31917 .31683 m
.31917 .31683 L
s
.31925 .31065 m
.31925 .31065 L
s
.31932 .30241 m
.31932 .30241 L
s
.3194 .30756 m
.3194 .30756 L
s
.31948 .3055 m
.31948 .3055 L
s
.31955 .31271 m
.31955 .31271 L
s
.31962 .31168 m
.31962 .31168 L
s
.31969 .31579 m
.31969 .31579 L
s
.31977 .30962 m
.31977 .30962 L
s
.31984 .31271 m
.31984 .31271 L
s
.31992 .31374 m
.31992 .31374 L
s
.31999 .31888 m
.31999 .31888 L
s
.32007 .32609 m
.32007 .32609 L
s
.32014 .31786 m
.32014 .31786 L
s
.32022 .31683 m
.32022 .31683 L
s
.32029 .31168 m
.32029 .31168 L
s
.32037 .31477 m
.32037 .31477 L
s
.32044 .31579 m
.32044 .31579 L
s
.32051 .31477 m
.32051 .31477 L
s
.32058 .31579 m
.32058 .31579 L
s
.32066 .31683 m
.32066 .31683 L
s
.32073 .31888 m
.32073 .31888 L
s
.32081 .31786 m
.32081 .31786 L
s
.32088 .323 m
.32088 .323 L
s
.32096 .32609 m
.32096 .32609 L
s
.32103 .32506 m
.32103 .32506 L
s
.32111 .33227 m
.32111 .33227 L
s
.32119 .34051 m
.32119 .34051 L
s
.32125 .33432 m
.32125 .33432 L
s
.32133 .34051 m
.32133 .34051 L
s
.3214 .34051 m
.3214 .34051 L
s
.32148 .34256 m
.32148 .34256 L
s
.32155 .33947 m
.32155 .33947 L
s
.32163 .34051 m
.32163 .34051 L
s
.3217 .34874 m
.3217 .34874 L
s
.32178 .34051 m
.32178 .34051 L
s
.32185 .34977 m
.32185 .34977 L
s
.32193 .34874 m
.32193 .34874 L
s
.322 .35492 m
.322 .35492 L
s
.32207 .35183 m
.32207 .35183 L
s
.32214 .35389 m
.32214 .35389 L
s
.32222 .35285 m
.32222 .35285 L
s
.32229 .34874 m
.32229 .34874 L
s
.32237 .35492 m
.32237 .35492 L
s
.32244 .34668 m
.32244 .34668 L
s
.32252 .34771 m
.32252 .34771 L
s
.32259 .34153 m
.32259 .34153 L
s
.32267 .35285 m
.32267 .35285 L
s
.32274 .34256 m
.32274 .34256 L
s
.32282 .34153 m
.32282 .34153 L
s
.32289 .34051 m
.32289 .34051 L
s
.32296 .34359 m
.32296 .34359 L
s
.32304 .34462 m
.32304 .34462 L
s
.32311 .34874 m
.32311 .34874 L
s
.32319 .3508 m
.32319 .3508 L
s
.32326 .34668 m
.32326 .34668 L
s
.32334 .35492 m
.32334 .35492 L
s
.32341 .35389 m
.32341 .35389 L
s
.32348 .35594 m
.32348 .35594 L
s
.32356 .35183 m
.32356 .35183 L
s
.32364 .35285 m
.32364 .35285 L
s
.3237 .35183 m
.3237 .35183 L
s
.32378 .34977 m
.32378 .34977 L
s
.32385 .35183 m
.32385 .35183 L
s
.32393 .35285 m
.32393 .35285 L
s
.324 .35389 m
.324 .35389 L
s
.32408 .35389 m
.32408 .35389 L
s
.32416 .35697 m
.32416 .35697 L
s
.32422 .35389 m
.32422 .35389 L
s
.3243 .35594 m
.3243 .35594 L
s
.32437 .36212 m
.32437 .36212 L
s
.32445 .36212 m
.32445 .36212 L
s
.32452 .35697 m
.32452 .35697 L
s
.3246 .35389 m
.3246 .35389 L
s
.32467 .35697 m
.32467 .35697 L
s
.32475 .36006 m
.32475 .36006 L
s
.32482 .36521 m
.32482 .36521 L
s
.3249 .36521 m
.3249 .36521 L
s
.32497 .36933 m
.32497 .36933 L
s
.32504 .37036 m
.32504 .37036 L
s
.32511 .3755 m
.32511 .3755 L
s
.32519 .3683 m
.32519 .3683 L
s
.32527 .36933 m
.32527 .36933 L
s
.32534 .36727 m
.32534 .36727 L
s
.32541 .37345 m
.32541 .37345 L
s
.32549 .36933 m
.32549 .36933 L
s
.32556 .36933 m
.32556 .36933 L
s
.32564 .36933 m
.32564 .36933 L
s
.32572 .36624 m
.32572 .36624 L
s
.32579 .36727 m
.32579 .36727 L
s
.32586 .36006 m
.32586 .36006 L
s
.32593 .358 m
.32593 .358 L
s
.32601 .35697 m
.32601 .35697 L
s
.32608 .36109 m
.32608 .36109 L
s
.32616 .36006 m
.32616 .36006 L
s
.32623 .34668 m
.32623 .34668 L
s
.32631 .35389 m
.32631 .35389 L
s
.32638 .35183 m
.32638 .35183 L
s
.32646 .35904 m
.32646 .35904 L
s
.32653 .35904 m
.32653 .35904 L
s
.32661 .36006 m
.32661 .36006 L
s
.32667 .35183 m
.32667 .35183 L
s
.32675 .36315 m
.32675 .36315 L
s
.32682 .35697 m
.32682 .35697 L
s
.3269 .36109 m
.3269 .36109 L
s
.32697 .35389 m
.32697 .35389 L
s
.32705 .35697 m
.32705 .35697 L
s
.32712 .34668 m
.32712 .34668 L
s
.3272 .34565 m
.3272 .34565 L
s
.32728 .34668 m
.32728 .34668 L
s
.32735 .33536 m
.32735 .33536 L
s
.32742 .3333 m
.32742 .3333 L
s
.32749 .32712 m
.32749 .32712 L
s
.32757 .33432 m
.32757 .33432 L
s
.32764 .33227 m
.32764 .33227 L
s
.32772 .33124 m
.32772 .33124 L
s
.32779 .33021 m
.32779 .33021 L
s
.32787 .32712 m
.32787 .32712 L
s
.32794 .33021 m
.32794 .33021 L
s
.32802 .32506 m
.32802 .32506 L
s
.32809 .32815 m
.32809 .32815 L
s
.32817 .3333 m
.32817 .3333 L
s
.32824 .34565 m
.32824 .34565 L
s
.32831 .34359 m
.32831 .34359 L
s
.32838 .34051 m
.32838 .34051 L
s
.32846 .33639 m
.32846 .33639 L
s
.32853 .33844 m
.32853 .33844 L
s
.32861 .34462 m
.32861 .34462 L
s
.32868 .358 m
.32868 .358 L
s
.32876 .36727 m
.32876 .36727 L
s
.32884 .36727 m
.32884 .36727 L
s
.32891 .37138 m
.32891 .37138 L
s
.32899 .36109 m
.32899 .36109 L
s
.32905 .36006 m
.32905 .36006 L
s
.32913 .34874 m
.32913 .34874 L
s
.3292 .35492 m
.3292 .35492 L
s
.32928 .358 m
.32928 .358 L
s
.32935 .35594 m
.32935 .35594 L
s
.32943 .34977 m
.32943 .34977 L
s
.3295 .34256 m
.3295 .34256 L
s
.32958 .34668 m
.32958 .34668 L
s
.32965 .33639 m
.32965 .33639 L
s
.32973 .33742 m
.32973 .33742 L
s
.3298 .3333 m
.3298 .3333 L
s
.32987 .32918 m
.32987 .32918 L
s
.32994 .32198 m
.32994 .32198 L
s
.33002 .32198 m
.33002 .32198 L
s
.33009 .31683 m
.33009 .31683 L
s
.33017 .32198 m
.33017 .32198 L
s
.33024 .32712 m
.33024 .32712 L
s
.33032 .32609 m
.33032 .32609 L
s
.33039 .32815 m
.33039 .32815 L
s
.33047 .32506 m
.33047 .32506 L
s
.33055 .32815 m
.33055 .32815 L
s
.33062 .32815 m
.33062 .32815 L
s
.33069 .33124 m
.33069 .33124 L
s
.33076 .323 m
.33076 .323 L
s
.33084 .32198 m
.33084 .32198 L
s
.33091 .32403 m
.33091 .32403 L
s
.33099 .323 m
.33099 .323 L
s
.33106 .33021 m
.33106 .33021 L
s
.33114 .32918 m
.33114 .32918 L
s
.33121 .3333 m
.33121 .3333 L
s
.33128 .32918 m
.33128 .32918 L
s
.33136 .32815 m
.33136 .32815 L
s
.33144 .32094 m
.33144 .32094 L
s
.3315 .33124 m
.3315 .33124 L
s
.33158 .32918 m
.33158 .32918 L
s
.33165 .32712 m
.33165 .32712 L
s
.33173 .32609 m
.33173 .32609 L
s
.3318 .33227 m
.3318 .33227 L
s
.33188 .33536 m
.33188 .33536 L
s
.33196 .3333 m
.33196 .3333 L
s
.33202 .33227 m
.33202 .33227 L
s
.3321 .31786 m
.3321 .31786 L
s
.33218 .31888 m
.33218 .31888 L
s
.33225 .31579 m
.33225 .31579 L
s
.33232 .30756 m
.33232 .30756 L
s
.3324 .2983 m
.3324 .2983 L
s
.33247 .29521 m
.33247 .29521 L
s
.33255 .30035 m
.33255 .30035 L
s
.33262 .30447 m
.33262 .30447 L
s
.3327 .30241 m
.3327 .30241 L
s
.33277 .30138 m
.33277 .30138 L
s
.33284 .30447 m
.33284 .30447 L
s
.33291 .30035 m
.33291 .30035 L
s
.33299 .30653 m
.33299 .30653 L
s
.33307 .30035 m
.33307 .30035 L
s
.33314 .30241 m
.33314 .30241 L
s
.33321 .2983 m
.33321 .2983 L
s
.33329 .30035 m
.33329 .30035 L
s
.33336 .30756 m
.33336 .30756 L
s
.33344 .30035 m
.33344 .30035 L
s
.33352 .30756 m
.33352 .30756 L
s
.33359 .30962 m
.33359 .30962 L
s
.33366 .31579 m
.33366 .31579 L
s
.33373 .29933 m
.33373 .29933 L
s
.33381 .30035 m
.33381 .30035 L
s
.33388 .29933 m
.33388 .29933 L
s
.33396 .31065 m
.33396 .31065 L
s
.33403 .30653 m
.33403 .30653 L
s
.33411 .31168 m
.33411 .31168 L
s
.33418 .30653 m
.33418 .30653 L
s
.33426 .31168 m
.33426 .31168 L
s
.33433 .30962 m
.33433 .30962 L
s
.33441 .30345 m
.33441 .30345 L
s
.33447 .30138 m
.33447 .30138 L
s
.33455 .29726 m
.33455 .29726 L
s
.33462 .29726 m
.33462 .29726 L
s
.3347 .29624 m
.3347 .29624 L
s
.33477 .29212 m
.33477 .29212 L
s
.33485 .28388 m
.33485 .28388 L
s
.33492 .28183 m
.33492 .28183 L
s
.335 .28697 m
.335 .28697 L
s
.33508 .28285 m
.33508 .28285 L
s
.33515 .28388 m
.33515 .28388 L
s
.33522 .28594 m
.33522 .28594 L
s
.33529 .288 m
.33529 .288 L
s
.33537 .288 m
.33537 .288 L
s
.33544 .29109 m
.33544 .29109 L
s
.33552 .28492 m
.33552 .28492 L
s
.33559 .28697 m
.33559 .28697 L
s
.33567 .29315 m
.33567 .29315 L
s
.33574 .30035 m
.33574 .30035 L
s
.33582 .29624 m
.33582 .29624 L
s
.33589 .30138 m
.33589 .30138 L
s
.33597 .30653 m
.33597 .30653 L
s
.33604 .30756 m
.33604 .30756 L
s
.33611 .3055 m
.33611 .3055 L
s
.33618 .30241 m
.33618 .30241 L
s
.33626 .30345 m
.33626 .30345 L
s
.33633 .2983 m
.33633 .2983 L
s
.33641 .29315 m
.33641 .29315 L
s
.33648 .29109 m
.33648 .29109 L
s
.33656 .28903 m
.33656 .28903 L
s
.33664 .29006 m
.33664 .29006 L
s
.33671 .29521 m
.33671 .29521 L
s
.33679 .28697 m
.33679 .28697 L
s
.33685 .27977 m
.33685 .27977 L
s
.33693 .2705 m
.33693 .2705 L
s
.337 .26639 m
.337 .26639 L
s
.33708 .27771 m
.33708 .27771 L
s
.33715 .27462 m
.33715 .27462 L
s
.33723 .27977 m
.33723 .27977 L
s
.3373 .27359 m
.3373 .27359 L
s
.33738 .27565 m
.33738 .27565 L
s
.33745 .27668 m
.33745 .27668 L
s
.33753 .28285 m
.33753 .28285 L
s
.3376 .28697 m
.3376 .28697 L
s
.33767 .28285 m
.33767 .28285 L
s
.33774 .28697 m
.33774 .28697 L
s
.33782 .28903 m
.33782 .28903 L
s
.33789 .29726 m
.33789 .29726 L
s
.33797 .2983 m
.33797 .2983 L
s
.33804 .3055 m
.33804 .3055 L
s
.33812 .30859 m
.33812 .30859 L
s
.33819 .30241 m
.33819 .30241 L
s
.33827 .30447 m
.33827 .30447 L
s
.33835 .30345 m
.33835 .30345 L
s
.33842 .30756 m
.33842 .30756 L
s
.33849 .31168 m
.33849 .31168 L
s
.33856 .32094 m
.33856 .32094 L
s
.33864 .31374 m
.33864 .31374 L
s
.33871 .31579 m
.33871 .31579 L
s
.33879 .31065 m
.33879 .31065 L
s
.33886 .30962 m
.33886 .30962 L
s
.33894 .29726 m
.33894 .29726 L
s
.33901 .29624 m
.33901 .29624 L
s
.33909 .2983 m
.33909 .2983 L
s
.33916 .29109 m
.33916 .29109 L
s
.33924 .29109 m
.33924 .29109 L
s
.3393 .2983 m
.3393 .2983 L
s
.33938 .3055 m
.33938 .3055 L
s
.33945 .30035 m
.33945 .30035 L
s
.33953 .30138 m
.33953 .30138 L
s
.3396 .29726 m
.3396 .29726 L
s
.33968 .30859 m
.33968 .30859 L
s
.33976 .30035 m
.33976 .30035 L
s
.33982 .3055 m
.33982 .3055 L
s
.3399 .29933 m
.3399 .29933 L
s
.33998 .29315 m
.33998 .29315 L
s
.34005 .28903 m
.34005 .28903 L
s
.34012 .27873 m
.34012 .27873 L
s
.3402 .28183 m
.3402 .28183 L
s
.34027 .28183 m
.34027 .28183 L
s
.34035 .27771 m
.34035 .27771 L
s
.34042 .27359 m
.34042 .27359 L
s
.3405 .27668 m
.3405 .27668 L
s
.34057 .27256 m
.34057 .27256 L
s
.34064 .27668 m
.34064 .27668 L
s
.34072 .2808 m
.34072 .2808 L
s
.3408 .27256 m
.3408 .27256 L
s
.34087 .26947 m
.34087 .26947 L
s
.34094 .26227 m
.34094 .26227 L
s
.34101 .26639 m
.34101 .26639 L
s
.34109 .27256 m
.34109 .27256 L
s
.34116 .28285 m
.34116 .28285 L
s
.34124 .27668 m
.34124 .27668 L
s
.34132 .27873 m
.34132 .27873 L
s
.34139 .27668 m
.34139 .27668 L
s
.34146 .27668 m
.34146 .27668 L
s
.34153 .28388 m
.34153 .28388 L
s
.34161 .28492 m
.34161 .28492 L
s
.34168 .29109 m
.34168 .29109 L
s
.34176 .2808 m
.34176 .2808 L
s
.34183 .28492 m
.34183 .28492 L
s
.34191 .27977 m
.34191 .27977 L
s
.34198 .27873 m
.34198 .27873 L
s
.34206 .27565 m
.34206 .27565 L
s
.34213 .2705 m
.34213 .2705 L
s
.34221 .26639 m
.34221 .26639 L
s
.34227 .26844 m
.34227 .26844 L
s
.34235 .27771 m
.34235 .27771 L
s
.34243 .27359 m
.34243 .27359 L
s
.3425 .2705 m
.3425 .2705 L
s
.34257 .26639 m
.34257 .26639 L
s
.34265 .27256 m
.34265 .27256 L
s
.34272 .26329 m
.34272 .26329 L
s
.3428 .26741 m
.3428 .26741 L
s
.34288 .26639 m
.34288 .26639 L
s
.34295 .27462 m
.34295 .27462 L
s
.34302 .27462 m
.34302 .27462 L
s
.34309 .26741 m
.34309 .26741 L
s
.34317 .27565 m
.34317 .27565 L
s
.34324 .27462 m
.34324 .27462 L
s
.34332 .28388 m
.34332 .28388 L
s
.34339 .2808 m
.34339 .2808 L
s
.34347 .27462 m
.34347 .27462 L
s
.34354 .2705 m
.34354 .2705 L
s
.34362 .27462 m
.34362 .27462 L
s
.34369 .27359 m
.34369 .27359 L
s
.34377 .27668 m
.34377 .27668 L
s
.34384 .28388 m
.34384 .28388 L
s
.34391 .288 m
.34391 .288 L
s
.34398 .29418 m
.34398 .29418 L
s
.34406 .28903 m
.34406 .28903 L
s
.34413 .29521 m
.34413 .29521 L
s
.34421 .30138 m
.34421 .30138 L
s
.34428 .30447 m
.34428 .30447 L
s
.34436 .29624 m
.34436 .29624 L
s
.34444 .30447 m
.34444 .30447 L
s
.34451 .2983 m
.34451 .2983 L
s
.34459 .29933 m
.34459 .29933 L
s
.34465 .3055 m
.34465 .3055 L
s
.34473 .30241 m
.34473 .30241 L
s
.3448 .2983 m
.3448 .2983 L
s
.34488 .28594 m
.34488 .28594 L
s
.34495 .29624 m
.34495 .29624 L
s
.34503 .29315 m
.34503 .29315 L
s
.3451 .29418 m
.3451 .29418 L
s
.34518 .29006 m
.34518 .29006 L
s
.34525 .29212 m
.34525 .29212 L
s
.34533 .288 m
.34533 .288 L
s
.3454 .29109 m
.3454 .29109 L
s
.34547 .29521 m
.34547 .29521 L
s
.34554 .29315 m
.34554 .29315 L
s
.34562 .28903 m
.34562 .28903 L
s
.34569 .29006 m
.34569 .29006 L
s
.34577 .29109 m
.34577 .29109 L
s
.34584 .28594 m
.34584 .28594 L
s
.34592 .29315 m
.34592 .29315 L
s
.346 .29315 m
.346 .29315 L
s
.34607 .29521 m
.34607 .29521 L
s
.34615 .2983 m
.34615 .2983 L
s
.34622 .29624 m
.34622 .29624 L
s
.34629 .30035 m
.34629 .30035 L
s
.34636 .30241 m
.34636 .30241 L
s
.34644 .30345 m
.34644 .30345 L
s
.34651 .30653 m
.34651 .30653 L
s
.34659 .30962 m
.34659 .30962 L
s
.34666 .3055 m
.34666 .3055 L
s
.34674 .3055 m
.34674 .3055 L
s
.34681 .29933 m
.34681 .29933 L
s
.34689 .30035 m
.34689 .30035 L
s
.34696 .3055 m
.34696 .3055 L
s
.34704 .30756 m
.34704 .30756 L
s
.3471 .31168 m
.3471 .31168 L
s
.34718 .30962 m
.34718 .30962 L
s
.34725 .30859 m
.34725 .30859 L
s
.34733 .30756 m
.34733 .30756 L
s
.3474 .31271 m
.3474 .31271 L
s
.34748 .31683 m
.34748 .31683 L
s
.34756 .31888 m
.34756 .31888 L
s
.34763 .31888 m
.34763 .31888 L
s
.34771 .31168 m
.34771 .31168 L
s
.34778 .31579 m
.34778 .31579 L
s
.34785 .31168 m
.34785 .31168 L
s
.34792 .31477 m
.34792 .31477 L
s
.348 .31374 m
.348 .31374 L
s
.34807 .31683 m
.34807 .31683 L
s
.34815 .31065 m
.34815 .31065 L
s
.34822 .31786 m
.34822 .31786 L
s
.3483 .31374 m
.3483 .31374 L
s
.34837 .31374 m
.34837 .31374 L
s
.34844 .30962 m
.34844 .30962 L
s
.34852 .3055 m
.34852 .3055 L
s
.3486 .3055 m
.3486 .3055 L
s
.34867 .30756 m
.34867 .30756 L
s
.34874 .30962 m
.34874 .30962 L
s
.34881 .31271 m
.34881 .31271 L
s
.34889 .31579 m
.34889 .31579 L
s
.34896 .30756 m
.34896 .30756 L
s
.34904 .30859 m
.34904 .30859 L
s
.34912 .30241 m
.34912 .30241 L
s
.34919 .30447 m
.34919 .30447 L
s
.34926 .30962 m
.34926 .30962 L
s
.34934 .30756 m
.34934 .30756 L
s
.34942 .30138 m
.34942 .30138 L
s
.34948 .29933 m
.34948 .29933 L
s
.34956 .2983 m
.34956 .2983 L
s
.34963 .30035 m
.34963 .30035 L
s
.34971 .30447 m
.34971 .30447 L
s
.34978 .30035 m
.34978 .30035 L
s
.34986 .30138 m
.34986 .30138 L
s
.34993 .30138 m
.34993 .30138 L
s
.35001 .3055 m
.35001 .3055 L
s
.35007 .3055 m
.35007 .3055 L
s
.35015 .30035 m
.35015 .30035 L
s
.35023 .29933 m
.35023 .29933 L
s
.3503 .29418 m
.3503 .29418 L
s
.35037 .29315 m
.35037 .29315 L
s
.35045 .2983 m
.35045 .2983 L
s
.35052 .29933 m
.35052 .29933 L
s
.3506 .2983 m
.3506 .2983 L
s
.35068 .30138 m
.35068 .30138 L
s
.35075 .29624 m
.35075 .29624 L
s
.35082 .29315 m
.35082 .29315 L
s
.35089 .29315 m
.35089 .29315 L
s
.35097 .29521 m
.35097 .29521 L
s
.35105 .29212 m
.35105 .29212 L
s
.35112 .29521 m
.35112 .29521 L
s
.35119 .29933 m
.35119 .29933 L
s
.35127 .29726 m
.35127 .29726 L
s
.35134 .30138 m
.35134 .30138 L
s
.35142 .29726 m
.35142 .29726 L
s
.35149 .29933 m
.35149 .29933 L
s
.35157 .30138 m
.35157 .30138 L
s
.35164 .30859 m
.35164 .30859 L
s
.35171 .3055 m
.35171 .3055 L
s
.35178 .30653 m
.35178 .30653 L
s
.35186 .30345 m
.35186 .30345 L
s
.35193 .29521 m
.35193 .29521 L
s
.35201 .29933 m
.35201 .29933 L
s
.35208 .29933 m
.35208 .29933 L
s
.35216 .30241 m
.35216 .30241 L
s
.35224 .30447 m
.35224 .30447 L
s
.35231 .30859 m
.35231 .30859 L
s
.35239 .3055 m
.35239 .3055 L
s
.35245 .30756 m
.35245 .30756 L
s
.35253 .31271 m
.35253 .31271 L
s
.3526 .30859 m
.3526 .30859 L
s
.35268 .31579 m
.35268 .31579 L
s
.35275 .31477 m
.35275 .31477 L
s
.35283 .31374 m
.35283 .31374 L
s
.3529 .30859 m
.3529 .30859 L
s
.35298 .30756 m
.35298 .30756 L
s
.35305 .31065 m
.35305 .31065 L
s
.35313 .32403 m
.35313 .32403 L
s
.3532 .32198 m
.3532 .32198 L
s
.35327 .31888 m
.35327 .31888 L
s
.35334 .31271 m
.35334 .31271 L
s
.35342 .31271 m
.35342 .31271 L
s
.35349 .31786 m
.35349 .31786 L
s
.35357 .31374 m
.35357 .31374 L
s
.35364 .31888 m
.35364 .31888 L
s
.35372 .31168 m
.35372 .31168 L
s
.3538 .31271 m
.3538 .31271 L
s
.35387 .30962 m
.35387 .30962 L
s
.35395 .31786 m
.35395 .31786 L
s
.35402 .31579 m
.35402 .31579 L
s
.35409 .32506 m
.35409 .32506 L
s
.35416 .32506 m
.35416 .32506 L
s
.35424 .32198 m
.35424 .32198 L
s
.35431 .32403 m
.35431 .32403 L
s
.35439 .31888 m
.35439 .31888 L
s
.35446 .32609 m
.35446 .32609 L
s
.35454 .31786 m
.35454 .31786 L
s
.35461 .32609 m
.35461 .32609 L
s
.35469 .32403 m
.35469 .32403 L
s
.35476 .32815 m
.35476 .32815 L
s
.35484 .32403 m
.35484 .32403 L
s
.3549 .32815 m
.3549 .32815 L
s
.35498 .32609 m
.35498 .32609 L
s
.35505 .32094 m
.35505 .32094 L
s
.35513 .31991 m
.35513 .31991 L
s
.3552 .32198 m
.3552 .32198 L
s
.35528 .33432 m
.35528 .33432 L
s
.35536 .32506 m
.35536 .32506 L
s
.35543 .33124 m
.35543 .33124 L
s
.35551 .33227 m
.35551 .33227 L
s
.35558 .33536 m
.35558 .33536 L
s
.35565 .33639 m
.35565 .33639 L
s
.35572 .33432 m
.35572 .33432 L
s
.3558 .32609 m
.3558 .32609 L
s
.35587 .323 m
.35587 .323 L
s
.35595 .32609 m
.35595 .32609 L
s
.35602 .32198 m
.35602 .32198 L
s
.3561 .33124 m
.3561 .33124 L
s
.35617 .323 m
.35617 .323 L
s
.35625 .32815 m
.35625 .32815 L
s
.35632 .32506 m
.35632 .32506 L
s
.3564 .3333 m
.3564 .3333 L
s
.35647 .33021 m
.35647 .33021 L
s
.35654 .33227 m
.35654 .33227 L
s
.35661 .33536 m
.35661 .33536 L
s
.35669 .33432 m
.35669 .33432 L
s
.35676 .34051 m
.35676 .34051 L
s
.35684 .33536 m
.35684 .33536 L
s
.35692 .33947 m
.35692 .33947 L
s
.35699 .33536 m
.35699 .33536 L
s
.35706 .33742 m
.35706 .33742 L
s
.35714 .3333 m
.35714 .3333 L
s
.35722 .33844 m
.35722 .33844 L
s
.35729 .34462 m
.35729 .34462 L
s
.35736 .33947 m
.35736 .33947 L
s
.35743 .34256 m
.35743 .34256 L
s
.35751 .33639 m
.35751 .33639 L
s
.35758 .34153 m
.35758 .34153 L
s
.35766 .34359 m
.35766 .34359 L
s
.35773 .33844 m
.35773 .33844 L
s
.35781 .33639 m
.35781 .33639 L
s
.35788 .34668 m
.35788 .34668 L
s
.35796 .34051 m
.35796 .34051 L
s
.35803 .34256 m
.35803 .34256 L
s
.3581 .34153 m
.3581 .34153 L
s
.35817 .34256 m
.35817 .34256 L
s
.35825 .33227 m
.35825 .33227 L
s
.35832 .32815 m
.35832 .32815 L
s
.3584 .33742 m
.3584 .33742 L
s
.35848 .33844 m
.35848 .33844 L
s
.35855 .33947 m
.35855 .33947 L
s
.35862 .34051 m
.35862 .34051 L
s
.35869 .34771 m
.35869 .34771 L
s
.35877 .34462 m
.35877 .34462 L
s
.35885 .34051 m
.35885 .34051 L
s
.35892 .33639 m
.35892 .33639 L
s
.35899 .33844 m
.35899 .33844 L
s
.35907 .34256 m
.35907 .34256 L
s
.35914 .34462 m
.35914 .34462 L
s
.35922 .35492 m
.35922 .35492 L
s
.35929 .35285 m
.35929 .35285 L
s
.35937 .35183 m
.35937 .35183 L
s
.35944 .34565 m
.35944 .34565 L
s
.35951 .34359 m
.35951 .34359 L
s
.35959 .33124 m
.35959 .33124 L
s
.35967 .33432 m
.35967 .33432 L
s
.35973 .33432 m
.35973 .33432 L
s
.35981 .33639 m
.35981 .33639 L
s
.35988 .34051 m
.35988 .34051 L
s
.35996 .34153 m
.35996 .34153 L
s
.36004 .34668 m
.36004 .34668 L
s
.36011 .34668 m
.36011 .34668 L
s
.36019 .35183 m
.36019 .35183 L
s
.36026 .34668 m
.36026 .34668 L
s
.36033 .34565 m
.36033 .34565 L
s
.3604 .34668 m
.3604 .34668 L
s
.36048 .34462 m
.36048 .34462 L
s
.36055 .34565 m
.36055 .34565 L
s
.36063 .34051 m
.36063 .34051 L
s
.3607 .34874 m
.3607 .34874 L
s
.36078 .35183 m
.36078 .35183 L
s
.36085 .36109 m
.36085 .36109 L
s
.36093 .36109 m
.36093 .36109 L
s
.361 .37036 m
.361 .37036 L
s
.36107 .37242 m
.36107 .37242 L
s
.36114 .37448 m
.36114 .37448 L
s
.36122 .36624 m
.36122 .36624 L
s
.3613 .36727 m
.3613 .36727 L
s
.36137 .36521 m
.36137 .36521 L
s
.36144 .3683 m
.36144 .3683 L
s
.36152 .36418 m
.36152 .36418 L
s
.3616 .36006 m
.3616 .36006 L
s
.36167 .36521 m
.36167 .36521 L
s
.36175 .36212 m
.36175 .36212 L
s
.36182 .36212 m
.36182 .36212 L
s
.36189 .35492 m
.36189 .35492 L
s
.36196 .37242 m
.36196 .37242 L
s
.36204 .37448 m
.36204 .37448 L
s
.36211 .37859 m
.36211 .37859 L
s
.36219 .38168 m
.36219 .38168 L
s
.36226 .37757 m
.36226 .37757 L
s
.36234 .3858 m
.36234 .3858 L
s
.36241 .38374 m
.36241 .38374 L
s
.36249 .393 m
.36249 .393 L
s
.36256 .38889 m
.36256 .38889 L
s
.36264 .39095 m
.36264 .39095 L
s
.3627 .38786 m
.3627 .38786 L
s
.36278 .38683 m
.36278 .38683 L
s
.36285 .38786 m
.36285 .38786 L
s
.36293 .38683 m
.36293 .38683 L
s
.363 .38991 m
.363 .38991 L
s
.36308 .38786 m
.36308 .38786 L
s
.36316 .38889 m
.36316 .38889 L
s
.36323 .38271 m
.36323 .38271 L
s
.36331 .39506 m
.36331 .39506 L
s
.36338 .38991 m
.36338 .38991 L
s
.36345 .39095 m
.36345 .39095 L
s
.36352 .38683 m
.36352 .38683 L
s
.3636 .38991 m
.3636 .38991 L
s
.36367 .39095 m
.36367 .39095 L
s
.36375 .38168 m
.36375 .38168 L
s
.36382 .38271 m
.36382 .38271 L
s
.3639 .38168 m
.3639 .38168 L
s
.36397 .38477 m
.36397 .38477 L
s
.36405 .38168 m
.36405 .38168 L
s
.36412 .37962 m
.36412 .37962 L
s
.3642 .37138 m
.3642 .37138 L
s
.36427 .37345 m
.36427 .37345 L
s
.36434 .36521 m
.36434 .36521 L
s
.36441 .36109 m
.36441 .36109 L
s
.36449 .36727 m
.36449 .36727 L
s
.36456 .37757 m
.36456 .37757 L
s
.36464 .37138 m
.36464 .37138 L
s
.36472 .36727 m
.36472 .36727 L
s
.36479 .37345 m
.36479 .37345 L
s
.36487 .37138 m
.36487 .37138 L
s
.36494 .37653 m
.36494 .37653 L
s
.36502 .37859 m
.36502 .37859 L
s
.36509 .37757 m
.36509 .37757 L
s
.36516 .36727 m
.36516 .36727 L
s
.36523 .3683 m
.36523 .3683 L
s
.36531 .358 m
.36531 .358 L
s
.36538 .35594 m
.36538 .35594 L
s
.36546 .36212 m
.36546 .36212 L
s
.36553 .35904 m
.36553 .35904 L
s
.36561 .36727 m
.36561 .36727 L
s
.36568 .36006 m
.36568 .36006 L
s
.36576 .36212 m
.36576 .36212 L
s
.36583 .36212 m
.36583 .36212 L
s
.3659 .37138 m
.3659 .37138 L
s
.36597 .3683 m
.36597 .3683 L
s
.36605 .3683 m
.36605 .3683 L
s
.36612 .36521 m
.36612 .36521 L
s
.3662 .37242 m
.3662 .37242 L
s
.36628 .36727 m
.36628 .36727 L
s
.36635 .36624 m
.36635 .36624 L
s
.36642 .36418 m
.36642 .36418 L
s
.3665 .36006 m
.3665 .36006 L
s
.36658 .36624 m
.36658 .36624 L
s
.36665 .36212 m
.36665 .36212 L
s
.36672 .35904 m
.36672 .35904 L
s
.36679 .35492 m
.36679 .35492 L
s
.36687 .36315 m
.36687 .36315 L
s
.36694 .37448 m
.36694 .37448 L
s
.36702 .37859 m
.36702 .37859 L
s
.36709 .38065 m
.36709 .38065 L
s
.36717 .37448 m
.36717 .37448 L
s
.36724 .37757 m
.36724 .37757 L
s
.36731 .3683 m
.36731 .3683 L
s
.36739 .37345 m
.36739 .37345 L
s
.36747 .36521 m
.36747 .36521 L
s
.36753 .36933 m
.36753 .36933 L
s
.36761 .36933 m
.36761 .36933 L
s
.36768 .37138 m
.36768 .37138 L
s
.36776 .37345 m
.36776 .37345 L
s
.36784 .37859 m
.36784 .37859 L
s
.36791 .37962 m
.36791 .37962 L
s
.36799 .38168 m
.36799 .38168 L
s
.36806 .37653 m
.36806 .37653 L
s
.36813 .37036 m
.36813 .37036 L
s
.36821 .37653 m
.36821 .37653 L
s
.36828 .38168 m
.36828 .38168 L
s
.36835 .37859 m
.36835 .37859 L
s
.36843 .37653 m
.36843 .37653 L
s
.3685 .3755 m
.3685 .3755 L
s
.36858 .37757 m
.36858 .37757 L
s
.36865 .38168 m
.36865 .38168 L
s
.36873 .37757 m
.36873 .37757 L
s
.3688 .37859 m
.3688 .37859 L
s
.36887 .38168 m
.36887 .38168 L
s
.36894 .3755 m
.36894 .3755 L
s
.36902 .37345 m
.36902 .37345 L
s
.3691 .37036 m
.3691 .37036 L
s
.36917 .38065 m
.36917 .38065 L
s
.36924 .37859 m
.36924 .37859 L
s
.36932 .38168 m
.36932 .38168 L
s
.3694 .38065 m
.3694 .38065 L
s
.36947 .37859 m
.36947 .37859 L
s
.36955 .38168 m
.36955 .38168 L
s
.36962 .37859 m
.36962 .37859 L
s
.36969 .38271 m
.36969 .38271 L
s
.36976 .37757 m
.36976 .37757 L
s
.36984 .37448 m
.36984 .37448 L
s
.36992 .3755 m
.36992 .3755 L
s
.36999 .38065 m
.36999 .38065 L
s
.37006 .38271 m
.37006 .38271 L
s
.37014 .39198 m
.37014 .39198 L
s
.37021 .39918 m
.37021 .39918 L
s
.37029 .39712 m
.37029 .39712 L
s
.37036 .40021 m
.37036 .40021 L
s
.37044 .39403 m
.37044 .39403 L
s
.3705 .4033 m
.3705 .4033 L
s
.37058 .40227 m
.37058 .40227 L
s
.37065 .40433 m
.37065 .40433 L
s
.37073 .40433 m
.37073 .40433 L
s
.3708 .40639 m
.3708 .40639 L
s
.37088 .40433 m
.37088 .40433 L
s
.37096 .40948 m
.37096 .40948 L
s
.37103 .41051 m
.37103 .41051 L
s
.37111 .40742 m
.37111 .40742 L
s
.37118 .40536 m
.37118 .40536 L
s
.37125 .40433 m
.37125 .40433 L
s
.37132 .41359 m
.37132 .41359 L
s
.3714 .40948 m
.3714 .40948 L
s
.37147 .40844 m
.37147 .40844 L
s
.37155 .41154 m
.37155 .41154 L
s
.37162 .41565 m
.37162 .41565 L
s
.3717 .41463 m
.3717 .41463 L
s
.37177 .41668 m
.37177 .41668 L
s
.37185 .41771 m
.37185 .41771 L
s
.37192 .41874 m
.37192 .41874 L
s
.372 .41565 m
.372 .41565 L
s
.37207 .40844 m
.37207 .40844 L
s
.37214 .41565 m
.37214 .41565 L
s
.37221 .40948 m
.37221 .40948 L
s
.37229 .41463 m
.37229 .41463 L
s
.37236 .41463 m
.37236 .41463 L
s
.37244 .41771 m
.37244 .41771 L
s
.37252 .4208 m
.37252 .4208 L
s
.37259 .42595 m
.37259 .42595 L
s
.37267 .42286 m
.37267 .42286 L
s
.37274 .41874 m
.37274 .41874 L
s
.37282 .41668 m
.37282 .41668 L
s
.37289 .41154 m
.37289 .41154 L
s
.37296 .41565 m
.37296 .41565 L
s
.37303 .41256 m
.37303 .41256 L
s
.37311 .41463 m
.37311 .41463 L
s
.37318 .40742 m
.37318 .40742 L
s
.37326 .41051 m
.37326 .41051 L
s
.37333 .39918 m
.37333 .39918 L
s
.37341 .40124 m
.37341 .40124 L
s
.37348 .4033 m
.37348 .4033 L
s
.37356 .4033 m
.37356 .4033 L
s
.37363 .40124 m
.37363 .40124 L
s
.3737 .39506 m
.3737 .39506 L
s
.37377 .40021 m
.37377 .40021 L
s
.37385 .39815 m
.37385 .39815 L
s
.37392 .40021 m
.37392 .40021 L
s
.374 .3961 m
.374 .3961 L
s
.37408 .39918 m
.37408 .39918 L
s
.37415 .4033 m
.37415 .4033 L
s
.37422 .40536 m
.37422 .40536 L
s
.3743 .40639 m
.3743 .40639 L
s
.37438 .40536 m
.37438 .40536 L
s
.37445 .40639 m
.37445 .40639 L
s
.37452 .4033 m
.37452 .4033 L
s
.37459 .40433 m
.37459 .40433 L
s
.37467 .4033 m
.37467 .4033 L
s
.37474 .40639 m
.37474 .40639 L
s
.37482 .40227 m
.37482 .40227 L
s
.37489 .40021 m
.37489 .40021 L
s
.37497 .40021 m
.37497 .40021 L
s
.37504 .40227 m
.37504 .40227 L
s
.37512 .40844 m
.37512 .40844 L
s
.37519 .40227 m
.37519 .40227 L
s
.37527 .40948 m
.37527 .40948 L
s
.37533 .41256 m
.37533 .41256 L
s
.37541 .41771 m
.37541 .41771 L
s
.37548 .41668 m
.37548 .41668 L
s
.37556 .41977 m
.37556 .41977 L
s
.37564 .41668 m
.37564 .41668 L
s
.37571 .41256 m
.37571 .41256 L
s
.37579 .41051 m
.37579 .41051 L
s
.37586 .40742 m
.37586 .40742 L
s
.37593 .41256 m
.37593 .41256 L
s
.37601 .41359 m
.37601 .41359 L
s
.37608 .41359 m
.37608 .41359 L
s
.37615 .41154 m
.37615 .41154 L
s
.37623 .41463 m
.37623 .41463 L
s
.3763 .40844 m
.3763 .40844 L
s
.37638 .40948 m
.37638 .40948 L
s
.37645 .41051 m
.37645 .41051 L
s
.37653 .41256 m
.37653 .41256 L
s
.3766 .41256 m
.3766 .41256 L
s
.37667 .40844 m
.37667 .40844 L
s
.37675 .40948 m
.37675 .40948 L
s
.37683 .40433 m
.37683 .40433 L
s
.3769 .40742 m
.3769 .40742 L
s
.37697 .40639 m
.37697 .40639 L
s
.37704 .40948 m
.37704 .40948 L
s
.37712 .41154 m
.37712 .41154 L
s
.3772 .41256 m
.3772 .41256 L
s
.37727 .40844 m
.37727 .40844 L
s
.37735 .40742 m
.37735 .40742 L
s
.37742 .40536 m
.37742 .40536 L
s
.37749 .40433 m
.37749 .40433 L
s
.37756 .40639 m
.37756 .40639 L
s
.37764 .4033 m
.37764 .4033 L
s
.37772 .40639 m
.37772 .40639 L
s
.37779 .40844 m
.37779 .40844 L
s
.37786 .40742 m
.37786 .40742 L
s
.37794 .40433 m
.37794 .40433 L
s
.37801 .40844 m
.37801 .40844 L
s
.37809 .41668 m
.37809 .41668 L
s
.37816 .4208 m
.37816 .4208 L
s
.37824 .42595 m
.37824 .42595 L
s
.3783 .42492 m
.3783 .42492 L
s
.37838 .43006 m
.37838 .43006 L
s
.37846 .42801 m
.37846 .42801 L
s
.37853 .43624 m
.37853 .43624 L
s
.3786 .43624 m
.3786 .43624 L
s
.37868 .43212 m
.37868 .43212 L
s
.37876 .43418 m
.37876 .43418 L
s
.37883 .42492 m
.37883 .42492 L
s
.37891 .4208 m
.37891 .4208 L
s
.37898 .42492 m
.37898 .42492 L
s
.37905 .43418 m
.37905 .43418 L
s
.37912 .4383 m
.37912 .4383 L
s
.3792 .4383 m
.3792 .4383 L
s
.37927 .42904 m
.37927 .42904 L
s
.37935 .43109 m
.37935 .43109 L
s
.37942 .42389 m
.37942 .42389 L
s
.3795 .43316 m
.3795 .43316 L
s
.37957 .43109 m
.37957 .43109 L
s
.37965 .43212 m
.37965 .43212 L
s
.37972 .43624 m
.37972 .43624 L
s
.3798 .43521 m
.3798 .43521 L
s
.37987 .42595 m
.37987 .42595 L
s
.37994 .43521 m
.37994 .43521 L
s
.38001 .43212 m
.38001 .43212 L
s
.38009 .43316 m
.38009 .43316 L
s
.38016 .44139 m
.38016 .44139 L
s
.38024 .42697 m
.38024 .42697 L
s
.38032 .43109 m
.38032 .43109 L
s
.38039 .42904 m
.38039 .42904 L
s
.38047 .42904 m
.38047 .42904 L
s
.38054 .43316 m
.38054 .43316 L
s
.38062 .43727 m
.38062 .43727 L
s
.38069 .43212 m
.38069 .43212 L
s
.38076 .41977 m
.38076 .41977 L
s
.38083 .42801 m
.38083 .42801 L
s
.38091 .42183 m
.38091 .42183 L
s
.38098 .42595 m
.38098 .42595 L
s
.38106 .43006 m
.38106 .43006 L
s
.38113 .42492 m
.38113 .42492 L
s
.38121 .42286 m
.38121 .42286 L
s
.38128 .42904 m
.38128 .42904 L
s
.38136 .42492 m
.38136 .42492 L
s
.38143 .42492 m
.38143 .42492 L
s
.3815 .42801 m
.3815 .42801 L
s
.38157 .41771 m
.38157 .41771 L
s
.38165 .41359 m
.38165 .41359 L
s
.38172 .40124 m
.38172 .40124 L
s
.3818 .40021 m
.3818 .40021 L
s
.38188 .39403 m
.38188 .39403 L
s
.38195 .40021 m
.38195 .40021 L
s
.38202 .40536 m
.38202 .40536 L
s
.3821 .40227 m
.3821 .40227 L
s
.38218 .40227 m
.38218 .40227 L
s
.38225 .40227 m
.38225 .40227 L
s
.38232 .40639 m
.38232 .40639 L
s
.38239 .40021 m
.38239 .40021 L
s
.38247 .40639 m
.38247 .40639 L
s
.38254 .40844 m
.38254 .40844 L
s
.38262 .41463 m
.38262 .41463 L
s
.38269 .41874 m
.38269 .41874 L
s
.38277 .41874 m
.38277 .41874 L
s
.38284 .41565 m
.38284 .41565 L
s
.38292 .41256 m
.38292 .41256 L
s
.38299 .41051 m
.38299 .41051 L
s
.38307 .40844 m
.38307 .40844 L
s
.38313 .41256 m
.38313 .41256 L
s
.38321 .41051 m
.38321 .41051 L
s
.38328 .41051 m
.38328 .41051 L
s
.38336 .40948 m
.38336 .40948 L
s
.38344 .41463 m
.38344 .41463 L
s
.38351 .40433 m
.38351 .40433 L
s
.38359 .40948 m
.38359 .40948 L
s
.38366 .40021 m
.38366 .40021 L
s
.38373 .40536 m
.38373 .40536 L
s
.38381 .4033 m
.38381 .4033 L
s
.38388 .40536 m
.38388 .40536 L
s
.38395 .4033 m
.38395 .4033 L
s
.38403 .40124 m
.38403 .40124 L
s
.3841 .40844 m
.3841 .40844 L
s
.38418 .40433 m
.38418 .40433 L
s
.38425 .40844 m
.38425 .40844 L
s
.38433 .41051 m
.38433 .41051 L
s
.3844 .41668 m
.3844 .41668 L
s
.38447 .41565 m
.38447 .41565 L
s
.38455 .41463 m
.38455 .41463 L
s
.38463 .41874 m
.38463 .41874 L
s
.3847 .41771 m
.3847 .41771 L
s
.38477 .42286 m
.38477 .42286 L
s
.38484 .42389 m
.38484 .42389 L
s
.38492 .42389 m
.38492 .42389 L
s
.385 .41668 m
.385 .41668 L
s
.38507 .41977 m
.38507 .41977 L
s
.38515 .41463 m
.38515 .41463 L
s
.38522 .41668 m
.38522 .41668 L
s
.38529 .4208 m
.38529 .4208 L
s
.38536 .41463 m
.38536 .41463 L
s
.38544 .40844 m
.38544 .40844 L
s
.38552 .40742 m
.38552 .40742 L
s
.38559 .41565 m
.38559 .41565 L
s
.38566 .40742 m
.38566 .40742 L
s
.38574 .41668 m
.38574 .41668 L
s
.38581 .41874 m
.38581 .41874 L
s
.38589 .42389 m
.38589 .42389 L
s
.38596 .41874 m
.38596 .41874 L
s
.38604 .41874 m
.38604 .41874 L
s
.3861 .42286 m
.3861 .42286 L
s
.38618 .42183 m
.38618 .42183 L
s
.38626 .42389 m
.38626 .42389 L
s
.38633 .42389 m
.38633 .42389 L
s
.3864 .4208 m
.3864 .4208 L
s
.38648 .4033 m
.38648 .4033 L
s
.38656 .40639 m
.38656 .40639 L
s
.38663 .40433 m
.38663 .40433 L
s
.38671 .40433 m
.38671 .40433 L
s
.38678 .40433 m
.38678 .40433 L
s
.38685 .40742 m
.38685 .40742 L
s
.38692 .40844 m
.38692 .40844 L
s
.387 .40844 m
.387 .40844 L
s
.38708 .41256 m
.38708 .41256 L
s
.38715 .4033 m
.38715 .4033 L
s
.38722 .40948 m
.38722 .40948 L
s
.3873 .40433 m
.3873 .40433 L
s
.38737 .40742 m
.38737 .40742 L
s
.38745 .40433 m
.38745 .40433 L
s
.38752 .4033 m
.38752 .4033 L
s
.3876 .40844 m
.3876 .40844 L
s
.38767 .41256 m
.38767 .41256 L
s
.38774 .41154 m
.38774 .41154 L
s
.38781 .40948 m
.38781 .40948 L
s
.38789 .41051 m
.38789 .41051 L
s
.38796 .40844 m
.38796 .40844 L
s
.38804 .40948 m
.38804 .40948 L
s
.38812 .3961 m
.38812 .3961 L
s
.38819 .39918 m
.38819 .39918 L
s
.38827 .3961 m
.38827 .3961 L
s
.38834 .39815 m
.38834 .39815 L
s
.38842 .40227 m
.38842 .40227 L
s
.38849 .40433 m
.38849 .40433 L
s
.38856 .4033 m
.38856 .4033 L
s
.38863 .39712 m
.38863 .39712 L
s
.38871 .39918 m
.38871 .39918 L
s
.38878 .39403 m
.38878 .39403 L
s
.38886 .39403 m
.38886 .39403 L
s
.38893 .39918 m
.38893 .39918 L
s
.38901 .41359 m
.38901 .41359 L
s
.38908 .41771 m
.38908 .41771 L
s
.38916 .42286 m
.38916 .42286 L
s
.38923 .42286 m
.38923 .42286 L
s
.3893 .41874 m
.3893 .41874 L
s
.38937 .41977 m
.38937 .41977 L
s
.38945 .42183 m
.38945 .42183 L
s
.38952 .42595 m
.38952 .42595 L
s
.3896 .41771 m
.3896 .41771 L
s
.38968 .41256 m
.38968 .41256 L
s
.38975 .40433 m
.38975 .40433 L
s
.38983 .40844 m
.38983 .40844 L
s
.3899 .40536 m
.3899 .40536 L
s
.38998 .40536 m
.38998 .40536 L
s
.39005 .40021 m
.39005 .40021 L
s
.39012 .40021 m
.39012 .40021 L
s
.39019 .41051 m
.39019 .41051 L
s
.39027 .40639 m
.39027 .40639 L
s
.39034 .40433 m
.39034 .40433 L
s
.39042 .4033 m
.39042 .4033 L
s
.39049 .41668 m
.39049 .41668 L
s
.39057 .40639 m
.39057 .40639 L
s
.39064 .40433 m
.39064 .40433 L
s
.39072 .39918 m
.39072 .39918 L
s
.39079 .40433 m
.39079 .40433 L
s
.39087 .40844 m
.39087 .40844 L
s
.39093 .41463 m
.39093 .41463 L
s
.39101 .41565 m
.39101 .41565 L
s
.39108 .41256 m
.39108 .41256 L
s
.39116 .40536 m
.39116 .40536 L
s
.39124 .40021 m
.39124 .40021 L
s
.39131 .4033 m
.39131 .4033 L
s
.39139 .40124 m
.39139 .40124 L
s
.39146 .4033 m
.39146 .4033 L
s
.39154 .40021 m
.39154 .40021 L
s
.39161 .40227 m
.39161 .40227 L
s
.39169 .39403 m
.39169 .39403 L
s
.39175 .39815 m
.39175 .39815 L
s
.39183 .3961 m
.39183 .3961 L
s
.3919 .38991 m
.3919 .38991 L
s
.39198 .39198 m
.39198 .39198 L
s
.39205 .38786 m
.39205 .38786 L
s
.39213 .39095 m
.39213 .39095 L
s
.3922 .38786 m
.3922 .38786 L
s
.39227 .3858 m
.39227 .3858 L
s
.39235 .37962 m
.39235 .37962 L
s
.39243 .3858 m
.39243 .3858 L
s
.3925 .37859 m
.3925 .37859 L
s
.39257 .37962 m
.39257 .37962 L
s
.39264 .37859 m
.39264 .37859 L
s
.39272 .38065 m
.39272 .38065 L
s
.3928 .38786 m
.3928 .38786 L
s
.39287 .38374 m
.39287 .38374 L
s
.39295 .3961 m
.39295 .3961 L
s
.39302 .39403 m
.39302 .39403 L
s
.39309 .39918 m
.39309 .39918 L
s
.39317 .40021 m
.39317 .40021 L
s
.39325 .40021 m
.39325 .40021 L
s
.39332 .39918 m
.39332 .39918 L
s
.39339 .39815 m
.39339 .39815 L
s
.39346 .40536 m
.39346 .40536 L
s
.39354 .40433 m
.39354 .40433 L
s
.39361 .40742 m
.39361 .40742 L
s
.39369 .40948 m
.39369 .40948 L
s
.39376 .40948 m
.39376 .40948 L
s
.39384 .40433 m
.39384 .40433 L
s
.39391 .40742 m
.39391 .40742 L
s
.39398 .40433 m
.39398 .40433 L
s
.39406 .40021 m
.39406 .40021 L
s
.39413 .39815 m
.39413 .39815 L
s
.3942 .39403 m
.3942 .39403 L
s
.39428 .39506 m
.39428 .39506 L
s
.39436 .3961 m
.39436 .3961 L
s
.39443 .39506 m
.39443 .39506 L
s
.39451 .39095 m
.39451 .39095 L
s
.39458 .39198 m
.39458 .39198 L
s
.39466 .38991 m
.39466 .38991 L
s
.39472 .38889 m
.39472 .38889 L
s
.3948 .39198 m
.3948 .39198 L
s
.39488 .393 m
.39488 .393 L
s
.39495 .39918 m
.39495 .39918 L
s
.39502 .393 m
.39502 .393 L
s
.3951 .39712 m
.3951 .39712 L
s
.39517 .39712 m
.39517 .39712 L
s
.39525 .39403 m
.39525 .39403 L
s
.39532 .39198 m
.39532 .39198 L
s
.3954 .4033 m
.3954 .4033 L
s
.39547 .40124 m
.39547 .40124 L
s
.39554 .40021 m
.39554 .40021 L
s
.39561 .3961 m
.39561 .3961 L
s
.39569 .39506 m
.39569 .39506 L
s
.39577 .40124 m
.39577 .40124 L
s
.39584 .3961 m
.39584 .3961 L
s
.39592 .4033 m
.39592 .4033 L
s
.39599 .3961 m
.39599 .3961 L
s
.39607 .39403 m
.39607 .39403 L
s
.39614 .39506 m
.39614 .39506 L
s
.39622 .40021 m
.39622 .40021 L
s
.39629 .39095 m
.39629 .39095 L
s
.39636 .39506 m
.39636 .39506 L
s
.39643 .38889 m
.39643 .38889 L
s
.39651 .38683 m
.39651 .38683 L
s
.39658 .38889 m
.39658 .38889 L
s
.39666 .38683 m
.39666 .38683 L
s
.39673 .38477 m
.39673 .38477 L
s
.39681 .38374 m
.39681 .38374 L
s
.39688 .38786 m
.39688 .38786 L
s
.39696 .38168 m
.39696 .38168 L
s
.39703 .37962 m
.39703 .37962 L
s
.3971 .38168 m
.3971 .38168 L
s
.39717 .38374 m
.39717 .38374 L
s
.39725 .38374 m
.39725 .38374 L
s
.39732 .393 m
.39732 .393 L
s
.3974 .39095 m
.3974 .39095 L
s
.39748 .38683 m
.39748 .38683 L
s
.39755 .39403 m
.39755 .39403 L
s
.39763 .38683 m
.39763 .38683 L
s
.3977 .38786 m
.3977 .38786 L
s
.39778 .38271 m
.39778 .38271 L
s
.39785 .38786 m
.39785 .38786 L
s
.39792 .37962 m
.39792 .37962 L
s
.39799 .37757 m
.39799 .37757 L
s
.39807 .3755 m
.39807 .3755 L
s
.39814 .37653 m
.39814 .37653 L
s
.39822 .37036 m
.39822 .37036 L
s
.39829 .3683 m
.39829 .3683 L
s
.39837 .36933 m
.39837 .36933 L
s
.39844 .36521 m
.39844 .36521 L
s
.39852 .36624 m
.39852 .36624 L
s
.39859 .35697 m
.39859 .35697 L
s
.39867 .36006 m
.39867 .36006 L
s
.39874 .35904 m
.39874 .35904 L
s
.39881 .36006 m
.39881 .36006 L
s
.39888 .36212 m
.39888 .36212 L
s
.39896 .37036 m
.39896 .37036 L
s
.39904 .37138 m
.39904 .37138 L
s
.39911 .36418 m
.39911 .36418 L
s
.39919 .36006 m
.39919 .36006 L
s
.39926 .36212 m
.39926 .36212 L
s
.39934 .36727 m
.39934 .36727 L
s
.39941 .358 m
.39941 .358 L
s
.39949 .35697 m
.39949 .35697 L
s
.39955 .3508 m
.39955 .3508 L
s
.39963 .35183 m
.39963 .35183 L
s
.3997 .35285 m
.3997 .35285 L
s
.39978 .35904 m
.39978 .35904 L
s
.39985 .358 m
.39985 .358 L
s
.39993 .35389 m
.39993 .35389 L
s
.4 .35492 m
.4 .35492 L
s
.40008 .34771 m
.40008 .34771 L
s
.40015 .34977 m
.40015 .34977 L
s
.40023 .34462 m
.40023 .34462 L
s
.4003 .34462 m
.4003 .34462 L
s
.40037 .34256 m
.40037 .34256 L
s
.40044 .33844 m
.40044 .33844 L
s
.40052 .33844 m
.40052 .33844 L
s
.4006 .34051 m
.4006 .34051 L
s
.40067 .34771 m
.40067 .34771 L
s
.40075 .34977 m
.40075 .34977 L
s
.40082 .35904 m
.40082 .35904 L
s
.40089 .34874 m
.40089 .34874 L
s
.40097 .34977 m
.40097 .34977 L
s
.40105 .34668 m
.40105 .34668 L
s
.40112 .34462 m
.40112 .34462 L
s
.40119 .34051 m
.40119 .34051 L
s
.40126 .33639 m
.40126 .33639 L
s
.40134 .33947 m
.40134 .33947 L
s
.40141 .33639 m
.40141 .33639 L
s
.40149 .33227 m
.40149 .33227 L
s
.40156 .32918 m
.40156 .32918 L
s
.40164 .33742 m
.40164 .33742 L
s
.40171 .33639 m
.40171 .33639 L
s
.40179 .33947 m
.40179 .33947 L
s
.40186 .33227 m
.40186 .33227 L
s
.40193 .33432 m
.40193 .33432 L
s
.402 .32918 m
.402 .32918 L
s
.40208 .33844 m
.40208 .33844 L
s
.40216 .3333 m
.40216 .3333 L
s
.40223 .32918 m
.40223 .32918 L
s
.40231 .33639 m
.40231 .33639 L
s
.40238 .33432 m
.40238 .33432 L
s
.40246 .33124 m
.40246 .33124 L
s
.40252 .323 m
.40252 .323 L
s
.4026 .32506 m
.4026 .32506 L
s
.40268 .31991 m
.40268 .31991 L
s
.40275 .32094 m
.40275 .32094 L
s
.40282 .31888 m
.40282 .31888 L
s
.4029 .31991 m
.4029 .31991 L
s
.40297 .32712 m
.40297 .32712 L
s
.40305 .32094 m
.40305 .32094 L
s
.40312 .32506 m
.40312 .32506 L
s
.4032 .31991 m
.4032 .31991 L
s
.40327 .32403 m
.40327 .32403 L
s
.40334 .31579 m
.40334 .31579 L
s
.40342 .31786 m
.40342 .31786 L
s
.4035 .31374 m
.4035 .31374 L
s
.40357 .31579 m
.40357 .31579 L
s
.40364 .31786 m
.40364 .31786 L
s
.40372 .32506 m
.40372 .32506 L
s
.40379 .32403 m
.40379 .32403 L
s
.40387 .32403 m
.40387 .32403 L
s
.40394 .32403 m
.40394 .32403 L
s
.40402 .323 m
.40402 .323 L
s
.40409 .32712 m
.40409 .32712 L
s
.40416 .323 m
.40416 .323 L
s
.40423 .32094 m
.40423 .32094 L
s
.40431 .31579 m
.40431 .31579 L
s
.40438 .32094 m
.40438 .32094 L
s
.40446 .32609 m
.40446 .32609 L
s
.40453 .32506 m
.40453 .32506 L
s
.40461 .32918 m
.40461 .32918 L
s
.40468 .32918 m
.40468 .32918 L
s
.40476 .33021 m
.40476 .33021 L
s
.40483 .32918 m
.40483 .32918 L
s
.4049 .32918 m
.4049 .32918 L
s
.40497 .32712 m
.40497 .32712 L
s
.40505 .33639 m
.40505 .33639 L
s
.40513 .33844 m
.40513 .33844 L
s
.4052 .33639 m
.4052 .33639 L
s
.40528 .33432 m
.40528 .33432 L
s
.40535 .33432 m
.40535 .33432 L
s
.40543 .33639 m
.40543 .33639 L
s
.4055 .33639 m
.4055 .33639 L
s
.40558 .34668 m
.40558 .34668 L
s
.40565 .34256 m
.40565 .34256 L
s
.40572 .34771 m
.40572 .34771 L
s
.40579 .34153 m
.40579 .34153 L
s
.40587 .34256 m
.40587 .34256 L
s
.40594 .33536 m
.40594 .33536 L
s
.40602 .33639 m
.40602 .33639 L
s
.40609 .33844 m
.40609 .33844 L
s
.40617 .34051 m
.40617 .34051 L
s
.40624 .34565 m
.40624 .34565 L
s
.40632 .34051 m
.40632 .34051 L
s
.40639 .33844 m
.40639 .33844 L
s
.40647 .33947 m
.40647 .33947 L
s
.40654 .34153 m
.40654 .34153 L
s
.40661 .34256 m
.40661 .34256 L
s
.40668 .34359 m
.40668 .34359 L
s
.40676 .33639 m
.40676 .33639 L
s
.40684 .34051 m
.40684 .34051 L
s
.40691 .34153 m
.40691 .34153 L
s
.40699 .33536 m
.40699 .33536 L
s
.40706 .33742 m
.40706 .33742 L
s
.40714 .33639 m
.40714 .33639 L
s
.40721 .32918 m
.40721 .32918 L
s
.40729 .323 m
.40729 .323 L
s
.40735 .32403 m
.40735 .32403 L
s
.40743 .32506 m
.40743 .32506 L
s
.4075 .32609 m
.4075 .32609 L
s
.40758 .32815 m
.40758 .32815 L
s
.40765 .33639 m
.40765 .33639 L
s
.40773 .33227 m
.40773 .33227 L
s
.4078 .32815 m
.4078 .32815 L
s
.40788 .33844 m
.40788 .33844 L
s
.40795 .33742 m
.40795 .33742 L
s
.40803 .34256 m
.40803 .34256 L
s
.4081 .34462 m
.4081 .34462 L
s
.40817 .35904 m
.40817 .35904 L
s
.40824 .35285 m
.40824 .35285 L
s
.40832 .35285 m
.40832 .35285 L
s
.4084 .35183 m
.4084 .35183 L
s
.40847 .358 m
.40847 .358 L
s
.40855 .36315 m
.40855 .36315 L
s
.40862 .36624 m
.40862 .36624 L
s
.4087 .37036 m
.4087 .37036 L
s
.40877 .36212 m
.40877 .36212 L
s
.40885 .36212 m
.40885 .36212 L
s
.40892 .35904 m
.40892 .35904 L
s
.40899 .36006 m
.40899 .36006 L
s
.40906 .35285 m
.40906 .35285 L
s
.40914 .3508 m
.40914 .3508 L
s
.40921 .34771 m
.40921 .34771 L
s
.40929 .35285 m
.40929 .35285 L
s
.40936 .35285 m
.40936 .35285 L
s
.40944 .34977 m
.40944 .34977 L
s
.40951 .35492 m
.40951 .35492 L
s
.40959 .3508 m
.40959 .3508 L
s
.40966 .35492 m
.40966 .35492 L
s
.40973 .35183 m
.40973 .35183 L
s
.4098 .35594 m
.4098 .35594 L
s
.40988 .34771 m
.40988 .34771 L
s
.40996 .34668 m
.40996 .34668 L
s
.41003 .3508 m
.41003 .3508 L
s
.41011 .3508 m
.41011 .3508 L
s
.41018 .34462 m
.41018 .34462 L
s
.41026 .34668 m
.41026 .34668 L
s
.41033 .3508 m
.41033 .3508 L
s
.41041 .3508 m
.41041 .3508 L
s
.41048 .35697 m
.41048 .35697 L
s
.41055 .34462 m
.41055 .34462 L
s
.41062 .3508 m
.41062 .3508 L
s
.4107 .34977 m
.4107 .34977 L
s
.41077 .34668 m
.41077 .34668 L
s
.41085 .34771 m
.41085 .34771 L
s
.41092 .35285 m
.41092 .35285 L
s
.411 .34668 m
.411 .34668 L
s
.41107 .34153 m
.41107 .34153 L
s
.41114 .34771 m
.41114 .34771 L
s
.41122 .34359 m
.41122 .34359 L
s
.4113 .34359 m
.4113 .34359 L
s
.41137 .33742 m
.41137 .33742 L
s
.41144 .34874 m
.41144 .34874 L
s
.41152 .34565 m
.41152 .34565 L
s
.41159 .34874 m
.41159 .34874 L
s
.41167 .34462 m
.41167 .34462 L
s
.41174 .34153 m
.41174 .34153 L
s
.41182 .34771 m
.41182 .34771 L
s
.41189 .34359 m
.41189 .34359 L
s
.41196 .34153 m
.41196 .34153 L
s
.41204 .34874 m
.41204 .34874 L
s
.41212 .34256 m
.41212 .34256 L
s
.41218 .34359 m
.41218 .34359 L
s
.41226 .34256 m
.41226 .34256 L
s
.41233 .34874 m
.41233 .34874 L
s
.41241 .3508 m
.41241 .3508 L
s
.41248 .34977 m
.41248 .34977 L
s
.41256 .3508 m
.41256 .3508 L
s
.41263 .35285 m
.41263 .35285 L
s
.4127 .34874 m
.4127 .34874 L
s
.41277 .35183 m
.41277 .35183 L
s
.41285 .34771 m
.41285 .34771 L
s
.41293 .35697 m
.41293 .35697 L
s
.413 .35183 m
.413 .35183 L
s
.41308 .36109 m
.41308 .36109 L
s
.41315 .35492 m
.41315 .35492 L
s
.41323 .35492 m
.41323 .35492 L
s
.4133 .3508 m
.4133 .3508 L
s
.41338 .34668 m
.41338 .34668 L
s
.41345 .34668 m
.41345 .34668 L
s
.41352 .34668 m
.41352 .34668 L
s
.41359 .34977 m
.41359 .34977 L
s
.41367 .34977 m
.41367 .34977 L
s
.41375 .35389 m
.41375 .35389 L
s
.41382 .35183 m
.41382 .35183 L
s
.41389 .34771 m
.41389 .34771 L
s
.41397 .34256 m
.41397 .34256 L
s
.41404 .34256 m
.41404 .34256 L
s
.41412 .34462 m
.41412 .34462 L
s
.41419 .33844 m
.41419 .33844 L
s
.41427 .34051 m
.41427 .34051 L
s
.41434 .33432 m
.41434 .33432 L
s
.41441 .33227 m
.41441 .33227 L
s
.41448 .32918 m
.41448 .32918 L
s
.41456 .33432 m
.41456 .33432 L
s
.41464 .33021 m
.41464 .33021 L
s
.41471 .32918 m
.41471 .32918 L
s
.41479 .32609 m
.41479 .32609 L
s
.41486 .32403 m
.41486 .32403 L
s
.41494 .323 m
.41494 .323 L
s
.41501 .32198 m
.41501 .32198 L
s
.41509 .31888 m
.41509 .31888 L
s
.41515 .30962 m
.41515 .30962 L
s
.41523 .30756 m
.41523 .30756 L
s
.4153 .29418 m
.4153 .29418 L
s
.41538 .29726 m
.41538 .29726 L
s
.41545 .30035 m
.41545 .30035 L
s
.41553 .29933 m
.41553 .29933 L
s
.4156 .29006 m
.4156 .29006 L
s
.41568 .29212 m
.41568 .29212 L
s
.41575 .28594 m
.41575 .28594 L
s
.41583 .288 m
.41583 .288 L
s
.4159 .29315 m
.4159 .29315 L
s
.41597 .29315 m
.41597 .29315 L
s
.41604 .29418 m
.41604 .29418 L
s
.41612 .28697 m
.41612 .28697 L
s
.4162 .29418 m
.4162 .29418 L
s
.41627 .28903 m
.41627 .28903 L
s
.41635 .28594 m
.41635 .28594 L
s
.41642 .28492 m
.41642 .28492 L
s
.4165 .288 m
.4165 .288 L
s
.41657 .29315 m
.41657 .29315 L
s
.41665 .29521 m
.41665 .29521 L
s
.41672 .2983 m
.41672 .2983 L
s
.41679 .29521 m
.41679 .29521 L
s
.41686 .2983 m
.41686 .2983 L
s
.41694 .29624 m
.41694 .29624 L
s
.41701 .29418 m
.41701 .29418 L
s
.41709 .28903 m
.41709 .28903 L
s
.41716 .28594 m
.41716 .28594 L
s
.41724 .28492 m
.41724 .28492 L
s
.41731 .27977 m
.41731 .27977 L
s
.41739 .27462 m
.41739 .27462 L
s
.41746 .27668 m
.41746 .27668 L
s
.41753 .27977 m
.41753 .27977 L
s
.4176 .27977 m
.4176 .27977 L
s
.41768 .27462 m
.41768 .27462 L
s
.41776 .26947 m
.41776 .26947 L
s
.41783 .28492 m
.41783 .28492 L
s
.41791 .27873 m
.41791 .27873 L
s
.41798 .29315 m
.41798 .29315 L
s
.41806 .28697 m
.41806 .28697 L
s
.41813 .28285 m
.41813 .28285 L
s
.41821 .2808 m
.41821 .2808 L
s
.41828 .28697 m
.41828 .28697 L
s
.41835 .29212 m
.41835 .29212 L
s
.41842 .28697 m
.41842 .28697 L
s
.4185 .288 m
.4185 .288 L
s
.41857 .29006 m
.41857 .29006 L
s
.41865 .29315 m
.41865 .29315 L
s
.41872 .29109 m
.41872 .29109 L
s
.4188 .29418 m
.4188 .29418 L
s
.41887 .29109 m
.41887 .29109 L
s
.41895 .29521 m
.41895 .29521 L
s
.41902 .29726 m
.41902 .29726 L
s
.4191 .30138 m
.4191 .30138 L
s
.41917 .30653 m
.41917 .30653 L
s
.41924 .30241 m
.41924 .30241 L
s
.41932 .30241 m
.41932 .30241 L
s
.41939 .29315 m
.41939 .29315 L
s
.41947 .29521 m
.41947 .29521 L
s
.41954 .29006 m
.41954 .29006 L
s
.41962 .288 m
.41962 .288 L
s
.41969 .29109 m
.41969 .29109 L
s
.41976 .29624 m
.41976 .29624 L
s
.41984 .29521 m
.41984 .29521 L
s
.41992 .29212 m
.41992 .29212 L
s
.41998 .288 m
.41998 .288 L
s
.42006 .28388 m
.42006 .28388 L
s
.42013 .28594 m
.42013 .28594 L
s
.42021 .2808 m
.42021 .2808 L
s
.42028 .28492 m
.42028 .28492 L
s
.42036 .28388 m
.42036 .28388 L
s
.42043 .29006 m
.42043 .29006 L
s
.4205 .29006 m
.4205 .29006 L
s
.42058 .29109 m
.42058 .29109 L
s
.42066 .29624 m
.42066 .29624 L
s
.42073 .29006 m
.42073 .29006 L
s
.4208 .29109 m
.4208 .29109 L
s
.42088 .29006 m
.42088 .29006 L
s
.42095 .29006 m
.42095 .29006 L
s
.42103 .28492 m
.42103 .28492 L
s
.4211 .29212 m
.4211 .29212 L
s
.42118 .29726 m
.42118 .29726 L
s
.42125 .30138 m
.42125 .30138 L
s
.42132 .30035 m
.42132 .30035 L
s
.42139 .29315 m
.42139 .29315 L
s
.42147 .29726 m
.42147 .29726 L
s
.42155 .29315 m
.42155 .29315 L
s
.42162 .29726 m
.42162 .29726 L
s
.42169 .29624 m
.42169 .29624 L
s
.42177 .30345 m
.42177 .30345 L
s
.42184 .31271 m
.42184 .31271 L
s
.42192 .31065 m
.42192 .31065 L
s
.42199 .3055 m
.42199 .3055 L
s
.42207 .31168 m
.42207 .31168 L
s
.42214 .30756 m
.42214 .30756 L
s
.42221 .30035 m
.42221 .30035 L
s
.42229 .30138 m
.42229 .30138 L
s
.42236 .30035 m
.42236 .30035 L
s
.42244 .30447 m
.42244 .30447 L
s
.42251 .2983 m
.42251 .2983 L
s
.42259 .30241 m
.42259 .30241 L
s
.42266 .30138 m
.42266 .30138 L
s
.42274 .29315 m
.42274 .29315 L
s
.42281 .29315 m
.42281 .29315 L
s
.42289 .28903 m
.42289 .28903 L
s
.42295 .29109 m
.42295 .29109 L
s
.42303 .28285 m
.42303 .28285 L
s
.4231 .28285 m
.4231 .28285 L
s
.42318 .27771 m
.42318 .27771 L
s
.42325 .28285 m
.42325 .28285 L
s
.42333 .27873 m
.42333 .27873 L
s
.4234 .27771 m
.4234 .27771 L
s
.42348 .2808 m
.42348 .2808 L
s
.42355 .28492 m
.42355 .28492 L
s
.42363 .28492 m
.42363 .28492 L
s
.4237 .28594 m
.4237 .28594 L
s
.42377 .28903 m
.42377 .28903 L
s
.42384 .29418 m
.42384 .29418 L
s
.42392 .30138 m
.42392 .30138 L
s
.424 .29418 m
.424 .29418 L
s
.42407 .29624 m
.42407 .29624 L
s
.42415 .29418 m
.42415 .29418 L
s
.42422 .29521 m
.42422 .29521 L
s
.4243 .29624 m
.4243 .29624 L
s
.42437 .29933 m
.42437 .29933 L
s
.42445 .2983 m
.42445 .2983 L
s
.42452 .30345 m
.42452 .30345 L
s
.42459 .30756 m
.42459 .30756 L
s
.42466 .30035 m
.42466 .30035 L
s
.42474 .30653 m
.42474 .30653 L
s
.42481 .30653 m
.42481 .30653 L
s
.42489 .30756 m
.42489 .30756 L
s
.42496 .30756 m
.42496 .30756 L
s
.42504 .31579 m
.42504 .31579 L
s
.42511 .31888 m
.42511 .31888 L
s
.42519 .32712 m
.42519 .32712 L
s
.42526 .32815 m
.42526 .32815 L
s
.42533 .32712 m
.42533 .32712 L
s
.4254 .32712 m
.4254 .32712 L
s
.42548 .32403 m
.42548 .32403 L
s
.42556 .32815 m
.42556 .32815 L
s
.42563 .32506 m
.42563 .32506 L
s
.42571 .32609 m
.42571 .32609 L
s
.42578 .31991 m
.42578 .31991 L
s
.42586 .31991 m
.42586 .31991 L
s
.42593 .323 m
.42593 .323 L
s
.42601 .31991 m
.42601 .31991 L
s
.42608 .31786 m
.42608 .31786 L
s
.42615 .32094 m
.42615 .32094 L
s
.42622 .33227 m
.42622 .33227 L
s
.4263 .32815 m
.4263 .32815 L
s
.42637 .32918 m
.42637 .32918 L
s
.42645 .32094 m
.42645 .32094 L
s
.42652 .32094 m
.42652 .32094 L
s
.4266 .323 m
.4266 .323 L
s
.42667 .32712 m
.42667 .32712 L
s
.42675 .32198 m
.42675 .32198 L
s
.42682 .31374 m
.42682 .31374 L
s
.4269 .31477 m
.4269 .31477 L
s
.42697 .31786 m
.42697 .31786 L
s
.42704 .323 m
.42704 .323 L
s
.42712 .32506 m
.42712 .32506 L
s
.42719 .32198 m
.42719 .32198 L
s
.42727 .31991 m
.42727 .31991 L
s
.42734 .32094 m
.42734 .32094 L
s
.42742 .31786 m
.42742 .31786 L
s
.42749 .32094 m
.42749 .32094 L
s
.42757 .31168 m
.42757 .31168 L
s
.42764 .31991 m
.42764 .31991 L
s
.42772 .32198 m
.42772 .32198 L
s
.42778 .31786 m
.42778 .31786 L
s
.42786 .31683 m
.42786 .31683 L
s
.42793 .31168 m
.42793 .31168 L
s
.42801 .31786 m
.42801 .31786 L
s
.42808 .31477 m
.42808 .31477 L
s
.42816 .31991 m
.42816 .31991 L
s
.42823 .31065 m
.42823 .31065 L
s
.4283 .30962 m
.4283 .30962 L
s
.42838 .30756 m
.42838 .30756 L
s
.42846 .3055 m
.42846 .3055 L
s
.42853 .30241 m
.42853 .30241 L
s
.4286 .3055 m
.4286 .3055 L
s
.42868 .3055 m
.42868 .3055 L
s
.42875 .30035 m
.42875 .30035 L
s
.42883 .30756 m
.42883 .30756 L
s
.4289 .30447 m
.4289 .30447 L
s
.42898 .30859 m
.42898 .30859 L
s
.42905 .30138 m
.42905 .30138 L
s
.42912 .30241 m
.42912 .30241 L
s
.4292 .30241 m
.4292 .30241 L
s
.42928 .30345 m
.42928 .30345 L
s
.42935 .30241 m
.42935 .30241 L
s
.42942 .29933 m
.42942 .29933 L
s
.42949 .30447 m
.42949 .30447 L
s
.42957 .30241 m
.42957 .30241 L
s
.42964 .2983 m
.42964 .2983 L
s
.42972 .30138 m
.42972 .30138 L
s
.42979 .30345 m
.42979 .30345 L
s
.42987 .29109 m
.42987 .29109 L
s
.42994 .29006 m
.42994 .29006 L
s
.43001 .29521 m
.43001 .29521 L
s
.43009 .29726 m
.43009 .29726 L
s
.43017 .30138 m
.43017 .30138 L
s
.43024 .29726 m
.43024 .29726 L
s
.43031 .31168 m
.43031 .31168 L
s
.43039 .30962 m
.43039 .30962 L
s
.43046 .31477 m
.43046 .31477 L
s
.43054 .31374 m
.43054 .31374 L
s
.43061 .31579 m
.43061 .31579 L
s
.43069 .31683 m
.43069 .31683 L
s
.43075 .31683 m
.43075 .31683 L
s
.43083 .31579 m
.43083 .31579 L
s
.43091 .31683 m
.43091 .31683 L
s
.43098 .31477 m
.43098 .31477 L
s
.43105 .31271 m
.43105 .31271 L
s
.43113 .31477 m
.43113 .31477 L
s
.4312 .30447 m
.4312 .30447 L
s
.43128 .30138 m
.43128 .30138 L
s
.43135 .29726 m
.43135 .29726 L
s
.43143 .30138 m
.43143 .30138 L
s
.4315 .29624 m
.4315 .29624 L
s
.43157 .30447 m
.43157 .30447 L
s
.43164 .30138 m
.43164 .30138 L
s
.43172 .30447 m
.43172 .30447 L
s
.4318 .30345 m
.4318 .30345 L
s
.43187 .29933 m
.43187 .29933 L
s
.43195 .3055 m
.43195 .3055 L
s
.43202 .30345 m
.43202 .30345 L
s
.4321 .30653 m
.4321 .30653 L
s
.43217 .30859 m
.43217 .30859 L
s
.43225 .31065 m
.43225 .31065 L
s
.43232 .30756 m
.43232 .30756 L
s
.43239 .30756 m
.43239 .30756 L
s
.43246 .30756 m
.43246 .30756 L
s
.43254 .30138 m
.43254 .30138 L
s
.43261 .30962 m
.43261 .30962 L
s
.43269 .30447 m
.43269 .30447 L
s
.43276 .30859 m
.43276 .30859 L
s
.43284 .30859 m
.43284 .30859 L
s
.43291 .31683 m
.43291 .31683 L
s
.43299 .31168 m
.43299 .31168 L
s
.43306 .31168 m
.43306 .31168 L
s
.43314 .31271 m
.43314 .31271 L
s
.4332 .31065 m
.4332 .31065 L
s
.43328 .30962 m
.43328 .30962 L
s
.43336 .30756 m
.43336 .30756 L
s
.43343 .31065 m
.43343 .31065 L
s
.43351 .31271 m
.43351 .31271 L
s
.43358 .31579 m
.43358 .31579 L
s
.43366 .30859 m
.43366 .30859 L
s
.43373 .31477 m
.43373 .31477 L
s
.43381 .31271 m
.43381 .31271 L
s
.43388 .31579 m
.43388 .31579 L
s
.43395 .31065 m
.43395 .31065 L
s
.43402 .31786 m
.43402 .31786 L
s
.4341 .32094 m
.4341 .32094 L
s
.43417 .31786 m
.43417 .31786 L
s
.43425 .323 m
.43425 .323 L
s
.43432 .31991 m
.43432 .31991 L
s
.4344 .31579 m
.4344 .31579 L
s
.43447 .31168 m
.43447 .31168 L
s
.43455 .31786 m
.43455 .31786 L
s
.43462 .31271 m
.43462 .31271 L
s
.4347 .31065 m
.4347 .31065 L
s
.43477 .30962 m
.43477 .30962 L
s
.43484 .3055 m
.43484 .3055 L
s
.43492 .30962 m
.43492 .30962 L
s
.43499 .31168 m
.43499 .31168 L
s
.43507 .31168 m
.43507 .31168 L
s
.43514 .31374 m
.43514 .31374 L
s
.43522 .31579 m
.43522 .31579 L
s
.43529 .30962 m
.43529 .30962 L
s
.43537 .31374 m
.43537 .31374 L
s
.43544 .2983 m
.43544 .2983 L
s
.43552 .29624 m
.43552 .29624 L
s
.43558 .29521 m
.43558 .29521 L
s
.43566 .29624 m
.43566 .29624 L
s
.43573 .30035 m
.43573 .30035 L
s
.43581 .2983 m
.43581 .2983 L
s
.43588 .29418 m
.43588 .29418 L
s
.43596 .28903 m
.43596 .28903 L
s
.43603 .29109 m
.43603 .29109 L
s
.43611 .28903 m
.43611 .28903 L
s
.43618 .29109 m
.43618 .29109 L
s
.43626 .288 m
.43626 .288 L
s
.43633 .28594 m
.43633 .28594 L
s
.4364 .29006 m
.4364 .29006 L
s
.43648 .29109 m
.43648 .29109 L
s
.43655 .28697 m
.43655 .28697 L
s
.43663 .27873 m
.43663 .27873 L
s
.4367 .29006 m
.4367 .29006 L
s
.43678 .29212 m
.43678 .29212 L
s
.43685 .29418 m
.43685 .29418 L
s
.43692 .29212 m
.43692 .29212 L
s
.437 .2983 m
.437 .2983 L
s
.43708 .29109 m
.43708 .29109 L
s
.43715 .29212 m
.43715 .29212 L
s
.43722 .29006 m
.43722 .29006 L
s
.43729 .29521 m
.43729 .29521 L
s
.43737 .29521 m
.43737 .29521 L
s
.43744 .29521 m
.43744 .29521 L
s
.43752 .29212 m
.43752 .29212 L
s
.43759 .288 m
.43759 .288 L
s
.43767 .29109 m
.43767 .29109 L
s
.43774 .288 m
.43774 .288 L
s
.43782 .29521 m
.43782 .29521 L
s
.43789 .29109 m
.43789 .29109 L
s
.43797 .29726 m
.43797 .29726 L
s
.43804 .29315 m
.43804 .29315 L
s
.43811 .29624 m
.43811 .29624 L
s
.43819 .29418 m
.43819 .29418 L
s
.43826 .28903 m
.43826 .28903 L
s
.43834 .27771 m
.43834 .27771 L
s
.43841 .27359 m
.43841 .27359 L
s
.43849 .27565 m
.43849 .27565 L
s
.43855 .2705 m
.43855 .2705 L
s
.43863 .27771 m
.43863 .27771 L
s
.43871 .27873 m
.43871 .27873 L
s
.43878 .28183 m
.43878 .28183 L
s
.43885 .28183 m
.43885 .28183 L
s
.43893 .2808 m
.43893 .2808 L
s
.439 .27873 m
.439 .27873 L
s
.43908 .27668 m
.43908 .27668 L
s
.43915 .28183 m
.43915 .28183 L
s
.43923 .27153 m
.43923 .27153 L
s
.4393 .27153 m
.4393 .27153 L
s
.43937 .26947 m
.43937 .26947 L
s
.43945 .26639 m
.43945 .26639 L
s
.43953 .26741 m
.43953 .26741 L
s
.4396 .25815 m
.4396 .25815 L
s
.43967 .25815 m
.43967 .25815 L
s
.43975 .26639 m
.43975 .26639 L
s
.43982 .2705 m
.43982 .2705 L
s
.4399 .2705 m
.4399 .2705 L
s
.43997 .27256 m
.43997 .27256 L
s
.44005 .26432 m
.44005 .26432 L
s
.44012 .26535 m
.44012 .26535 L
s
.44019 .27153 m
.44019 .27153 L
s
.44026 .27359 m
.44026 .27359 L
s
.44034 .2705 m
.44034 .2705 L
s
.44041 .26947 m
.44041 .26947 L
s
.44049 .26741 m
.44049 .26741 L
s
.44056 .26844 m
.44056 .26844 L
s
.44064 .26844 m
.44064 .26844 L
s
.44071 .26535 m
.44071 .26535 L
s
.44079 .27256 m
.44079 .27256 L
s
.44086 .26227 m
.44086 .26227 L
s
.44094 .26535 m
.44094 .26535 L
s
.441 .26124 m
.441 .26124 L
s
.44108 .25609 m
.44108 .25609 L
s
.44116 .253 m
.44116 .253 L
s
.44123 .24786 m
.44123 .24786 L
s
.44131 .24682 m
.44131 .24682 L
s
.44138 .24065 m
.44138 .24065 L
s
.44146 .23859 m
.44146 .23859 L
s
.44153 .24167 m
.44153 .24167 L
s
.44161 .24682 m
.44161 .24682 L
s
.44168 .24477 m
.44168 .24477 L
s
.44175 .24991 m
.44175 .24991 L
s
.44182 .25094 m
.44182 .25094 L
s
.4419 .25712 m
.4419 .25712 L
s
.44197 .25403 m
.44197 .25403 L
s
.44205 .2602 m
.44205 .2602 L
s
.44212 .26227 m
.44212 .26227 L
s
.4422 .26639 m
.4422 .26639 L
s
.44227 .26844 m
.44227 .26844 L
s
.44235 .26741 m
.44235 .26741 L
s
.44242 .27153 m
.44242 .27153 L
s
.4425 .27256 m
.4425 .27256 L
s
.44257 .27153 m
.44257 .27153 L
s
.44264 .26535 m
.44264 .26535 L
s
.44272 .26844 m
.44272 .26844 L
s
.44279 .25815 m
.44279 .25815 L
s
.44287 .26535 m
.44287 .26535 L
s
.44294 .27359 m
.44294 .27359 L
s
.44302 .2705 m
.44302 .2705 L
s
.44309 .27462 m
.44309 .27462 L
s
.44317 .27153 m
.44317 .27153 L
s
.44324 .26844 m
.44324 .26844 L
s
.44332 .26124 m
.44332 .26124 L
s
.44338 .26535 m
.44338 .26535 L
s
.44346 .27153 m
.44346 .27153 L
s
.44353 .27565 m
.44353 .27565 L
s
.44361 .27359 m
.44361 .27359 L
s
.44368 .27565 m
.44368 .27565 L
s
.44376 .27668 m
.44376 .27668 L
s
.44383 .27256 m
.44383 .27256 L
s
.44391 .27462 m
.44391 .27462 L
s
.44398 .27462 m
.44398 .27462 L
s
.44406 .28285 m
.44406 .28285 L
s
.44413 .27873 m
.44413 .27873 L
s
.4442 .28285 m
.4442 .28285 L
s
.44428 .27771 m
.44428 .27771 L
s
.44435 .28594 m
.44435 .28594 L
s
.44443 .28285 m
.44443 .28285 L
s
.4445 .27771 m
.4445 .27771 L
s
.44458 .28697 m
.44458 .28697 L
s
.44465 .28492 m
.44465 .28492 L
s
.44473 .28183 m
.44473 .28183 L
s
.4448 .27977 m
.4448 .27977 L
s
.44488 .28285 m
.44488 .28285 L
s
.44495 .27977 m
.44495 .27977 L
s
.44502 .27771 m
.44502 .27771 L
s
.44509 .26947 m
.44509 .26947 L
s
.44517 .2705 m
.44517 .2705 L
s
.44524 .26535 m
.44524 .26535 L
s
.44532 .2705 m
.44532 .2705 L
s
.44539 .27771 m
.44539 .27771 L
s
.44547 .28492 m
.44547 .28492 L
s
.44554 .28903 m
.44554 .28903 L
s
.44562 .28903 m
.44562 .28903 L
s
.44569 .29624 m
.44569 .29624 L
s
.44577 .29726 m
.44577 .29726 L
s
.44584 .29933 m
.44584 .29933 L
s
.44591 .2983 m
.44591 .2983 L
s
.44599 .30756 m
.44599 .30756 L
s
.44606 .3055 m
.44606 .3055 L
s
.44614 .30241 m
.44614 .30241 L
s
.44621 .2983 m
.44621 .2983 L
s
.44629 .29418 m
.44629 .29418 L
s
.44636 .29624 m
.44636 .29624 L
s
.44644 .2983 m
.44644 .2983 L
s
.44651 .29726 m
.44651 .29726 L
s
.44658 .29418 m
.44658 .29418 L
s
.44665 .30345 m
.44665 .30345 L
s
.44673 .30756 m
.44673 .30756 L
s
.4468 .30447 m
.4468 .30447 L
s
.44688 .31786 m
.44688 .31786 L
s
.44695 .31991 m
.44695 .31991 L
s
.44703 .31374 m
.44703 .31374 L
s
.4471 .31065 m
.4471 .31065 L
s
.44717 .31786 m
.44717 .31786 L
s
.44725 .31477 m
.44725 .31477 L
s
.44733 .31786 m
.44733 .31786 L
s
.4474 .31683 m
.4474 .31683 L
s
.44747 .31374 m
.44747 .31374 L
s
.44755 .30653 m
.44755 .30653 L
s
.44762 .31168 m
.44762 .31168 L
s
.4477 .30756 m
.4477 .30756 L
s
.44777 .30756 m
.44777 .30756 L
s
.44785 .31579 m
.44785 .31579 L
s
.44792 .31065 m
.44792 .31065 L
s
.44799 .31683 m
.44799 .31683 L
s
.44807 .31271 m
.44807 .31271 L
s
.44815 .31579 m
.44815 .31579 L
s
.44821 .31065 m
.44821 .31065 L
s
.44829 .30962 m
.44829 .30962 L
s
.44836 .30859 m
.44836 .30859 L
s
.44844 .31477 m
.44844 .31477 L
s
.44851 .32198 m
.44851 .32198 L
s
.44859 .32403 m
.44859 .32403 L
s
.44866 .32403 m
.44866 .32403 L
s
.44874 .32712 m
.44874 .32712 L
s
.4488 .32609 m
.4488 .32609 L
s
.44888 .32506 m
.44888 .32506 L
s
.44896 .32918 m
.44896 .32918 L
s
.44903 .32712 m
.44903 .32712 L
s
.44911 .33227 m
.44911 .33227 L
s
.44918 .32403 m
.44918 .32403 L
s
.44926 .32403 m
.44926 .32403 L
s
.44933 .32506 m
.44933 .32506 L
s
.44941 .32198 m
.44941 .32198 L
s
.44948 .31991 m
.44948 .31991 L
s
.44955 .32094 m
.44955 .32094 L
s
.44962 .32403 m
.44962 .32403 L
s
.4497 .32506 m
.4497 .32506 L
s
.44978 .32609 m
.44978 .32609 L
s
.44985 .31786 m
.44985 .31786 L
s
.44992 .31579 m
.44992 .31579 L
s
.45 .30859 m
.45 .30859 L
s
.45007 .3055 m
.45007 .3055 L
s
.45015 .30859 m
.45015 .30859 L
s
.45022 .30962 m
.45022 .30962 L
s
.4503 .31065 m
.4503 .31065 L
s
.45037 .30756 m
.45037 .30756 L
s
.45044 .30345 m
.45044 .30345 L
s
.45052 .29521 m
.45052 .29521 L
s
.45059 .2983 m
.45059 .2983 L
s
.45067 .29521 m
.45067 .29521 L
s
.45074 .29418 m
.45074 .29418 L
s
.45082 .29212 m
.45082 .29212 L
s
.45089 .28492 m
.45089 .28492 L
s
.45097 .27977 m
.45097 .27977 L
s
.45104 .27359 m
.45104 .27359 L
s
.45112 .27256 m
.45112 .27256 L
s
.45118 .26947 m
.45118 .26947 L
s
.45126 .27771 m
.45126 .27771 L
s
.45133 .2705 m
.45133 .2705 L
s
.45141 .27873 m
.45141 .27873 L
s
.45148 .27873 m
.45148 .27873 L
s
.45156 .28388 m
.45156 .28388 L
s
.45163 .28903 m
.45163 .28903 L
s
.45171 .29315 m
.45171 .29315 L
s
.45178 .29006 m
.45178 .29006 L
s
.45186 .29315 m
.45186 .29315 L
s
.45193 .29726 m
.45193 .29726 L
s
.452 .28903 m
.452 .28903 L
s
.45208 .29521 m
.45208 .29521 L
s
.45215 .28492 m
.45215 .28492 L
s
.45223 .29315 m
.45223 .29315 L
s
.4523 .29418 m
.4523 .29418 L
s
.45238 .29521 m
.45238 .29521 L
s
.45245 .29521 m
.45245 .29521 L
s
.45253 .288 m
.45253 .288 L
s
.4526 .28388 m
.4526 .28388 L
s
.45268 .28697 m
.45268 .28697 L
s
.45275 .29006 m
.45275 .29006 L
s
.45282 .29109 m
.45282 .29109 L
s
.45289 .29726 m
.45289 .29726 L
s
.45297 .2983 m
.45297 .2983 L
s
.45304 .30035 m
.45304 .30035 L
s
.45312 .30035 m
.45312 .30035 L
s
.45319 .29726 m
.45319 .29726 L
s
.45327 .29933 m
.45327 .29933 L
s
.45334 .30447 m
.45334 .30447 L
s
.45342 .30653 m
.45342 .30653 L
s
.45349 .29726 m
.45349 .29726 L
s
.45357 .30138 m
.45357 .30138 L
s
.45364 .30035 m
.45364 .30035 L
s
.45371 .29315 m
.45371 .29315 L
s
.45379 .28594 m
.45379 .28594 L
s
.45386 .288 m
.45386 .288 L
s
.45394 .28492 m
.45394 .28492 L
s
.45401 .28388 m
.45401 .28388 L
s
.45409 .28492 m
.45409 .28492 L
s
.45416 .2808 m
.45416 .2808 L
s
.45424 .27565 m
.45424 .27565 L
s
.45431 .27668 m
.45431 .27668 L
s
.45438 .27462 m
.45438 .27462 L
s
.45445 .26639 m
.45445 .26639 L
s
.45453 .27256 m
.45453 .27256 L
s
.4546 .2705 m
.4546 .2705 L
s
.45468 .2808 m
.45468 .2808 L
s
.45475 .28285 m
.45475 .28285 L
s
.45483 .29315 m
.45483 .29315 L
s
.4549 .29726 m
.4549 .29726 L
s
.45497 .29315 m
.45497 .29315 L
s
.45505 .30035 m
.45505 .30035 L
s
.45513 .29624 m
.45513 .29624 L
s
.4552 .2983 m
.4552 .2983 L
s
.45527 .29726 m
.45527 .29726 L
s
.45535 .29315 m
.45535 .29315 L
s
.45542 .288 m
.45542 .288 L
s
.4555 .288 m
.4555 .288 L
s
.45557 .28594 m
.45557 .28594 L
s
.45565 .288 m
.45565 .288 L
s
.45572 .29109 m
.45572 .29109 L
s
.45579 .29726 m
.45579 .29726 L
s
.45587 .3055 m
.45587 .3055 L
s
.45595 .29624 m
.45595 .29624 L
s
.45601 .30035 m
.45601 .30035 L
s
.45609 .2983 m
.45609 .2983 L
s
.45616 .30035 m
.45616 .30035 L
s
.45624 .29418 m
.45624 .29418 L
s
.45631 .2983 m
.45631 .2983 L
s
.45639 .29933 m
.45639 .29933 L
s
.45646 .30035 m
.45646 .30035 L
s
.45654 .29933 m
.45654 .29933 L
s
.4566 .30138 m
.4566 .30138 L
s
.45668 .30345 m
.45668 .30345 L
s
.45676 .29624 m
.45676 .29624 L
s
.45683 .29726 m
.45683 .29726 L
s
.45691 .28903 m
.45691 .28903 L
s
.45698 .29315 m
.45698 .29315 L
s
.45706 .28903 m
.45706 .28903 L
s
.45713 .288 m
.45713 .288 L
s
.45721 .29109 m
.45721 .29109 L
s
.45728 .29212 m
.45728 .29212 L
s
.45735 .29315 m
.45735 .29315 L
s
.45742 .288 m
.45742 .288 L
s
.4575 .2983 m
.4575 .2983 L
s
.45758 .29521 m
.45758 .29521 L
s
.45765 .29624 m
.45765 .29624 L
s
.45772 .29521 m
.45772 .29521 L
s
.4578 .2983 m
.4578 .2983 L
s
.45787 .29212 m
.45787 .29212 L
s
.45795 .29006 m
.45795 .29006 L
s
.45802 .29521 m
.45802 .29521 L
s
.4581 .28903 m
.4581 .28903 L
s
.45817 .29315 m
.45817 .29315 L
s
.45824 .28903 m
.45824 .28903 L
s
.45832 .28594 m
.45832 .28594 L
s
.45839 .28492 m
.45839 .28492 L
s
.45847 .288 m
.45847 .288 L
s
.45854 .28183 m
.45854 .28183 L
s
.45862 .27668 m
.45862 .27668 L
s
.45869 .27153 m
.45869 .27153 L
s
.45877 .27771 m
.45877 .27771 L
s
.45884 .28285 m
.45884 .28285 L
s
.45892 .29006 m
.45892 .29006 L
s
.45898 .28697 m
.45898 .28697 L
s
.45906 .29212 m
.45906 .29212 L
s
.45913 .29521 m
.45913 .29521 L
s
.45921 .28285 m
.45921 .28285 L
s
.45928 .29624 m
.45928 .29624 L
s
.45936 .28697 m
.45936 .28697 L
s
.45943 .2983 m
.45943 .2983 L
s
.45951 .30241 m
.45951 .30241 L
s
.45958 .30962 m
.45958 .30962 L
s
.45966 .31271 m
.45966 .31271 L
s
.45973 .31477 m
.45973 .31477 L
s
.4598 .31786 m
.4598 .31786 L
s
.45988 .323 m
.45988 .323 L
s
.45995 .32815 m
.45995 .32815 L
s
.46003 .323 m
.46003 .323 L
s
.4601 .31991 m
.4601 .31991 L
s
.46018 .31683 m
.46018 .31683 L
s
.46025 .32403 m
.46025 .32403 L
s
.46033 .32198 m
.46033 .32198 L
s
.4604 .31888 m
.4604 .31888 L
s
.46048 .323 m
.46048 .323 L
s
.46055 .32403 m
.46055 .32403 L
s
.46062 .323 m
.46062 .323 L
s
.46069 .32403 m
.46069 .32403 L
s
.46077 .33639 m
.46077 .33639 L
s
.46084 .3333 m
.46084 .3333 L
s
.46092 .3333 m
.46092 .3333 L
s
.46099 .32609 m
.46099 .32609 L
s
.46107 .32918 m
.46107 .32918 L
s
.46114 .33639 m
.46114 .33639 L
s
.46122 .33742 m
.46122 .33742 L
s
.46129 .33844 m
.46129 .33844 L
s
.46137 .34256 m
.46137 .34256 L
s
.46144 .34771 m
.46144 .34771 L
s
.46151 .34462 m
.46151 .34462 L
s
.46159 .34462 m
.46159 .34462 L
s
.46166 .33536 m
.46166 .33536 L
s
.46174 .33536 m
.46174 .33536 L
s
.46181 .32609 m
.46181 .32609 L
s
.46189 .32198 m
.46189 .32198 L
s
.46196 .31786 m
.46196 .31786 L
s
.46204 .32403 m
.46204 .32403 L
s
.46211 .323 m
.46211 .323 L
s
.46218 .323 m
.46218 .323 L
s
.46225 .32609 m
.46225 .32609 L
s
.46233 .31271 m
.46233 .31271 L
s
.4624 .31477 m
.4624 .31477 L
s
.46248 .30756 m
.46248 .30756 L
s
.46255 .30859 m
.46255 .30859 L
s
.46263 .30241 m
.46263 .30241 L
s
.4627 .30653 m
.4627 .30653 L
s
.46278 .30345 m
.46278 .30345 L
s
.46285 .3055 m
.46285 .3055 L
s
.46293 .30859 m
.46293 .30859 L
s
.463 .31065 m
.463 .31065 L
s
.46307 .30653 m
.46307 .30653 L
s
.46315 .29624 m
.46315 .29624 L
s
.46322 .2983 m
.46322 .2983 L
s
.4633 .28903 m
.4633 .28903 L
s
.46337 .28697 m
.46337 .28697 L
s
.46345 .288 m
.46345 .288 L
s
.46352 .288 m
.46352 .288 L
s
.46359 .28697 m
.46359 .28697 L
s
.46367 .29109 m
.46367 .29109 L
s
.46375 .29933 m
.46375 .29933 L
s
.46381 .29624 m
.46381 .29624 L
s
.46389 .2983 m
.46389 .2983 L
s
.46396 .2983 m
.46396 .2983 L
s
.46404 .2983 m
.46404 .2983 L
s
.46411 .29418 m
.46411 .29418 L
s
.46419 .2983 m
.46419 .2983 L
s
.46426 .29521 m
.46426 .29521 L
s
.46434 .28903 m
.46434 .28903 L
s
.46441 .29212 m
.46441 .29212 L
s
.46449 .28903 m
.46449 .28903 L
s
.46457 .28594 m
.46457 .28594 L
s
.46463 .2808 m
.46463 .2808 L
s
.46471 .28285 m
.46471 .28285 L
s
.46478 .27977 m
.46478 .27977 L
s
.46486 .28388 m
.46486 .28388 L
s
.46493 .28285 m
.46493 .28285 L
s
.46501 .28903 m
.46501 .28903 L
s
.46508 .28594 m
.46508 .28594 L
s
.46515 .29521 m
.46515 .29521 L
s
.46522 .29315 m
.46522 .29315 L
s
.4653 .29521 m
.4653 .29521 L
s
.46538 .288 m
.46538 .288 L
s
.46545 .28697 m
.46545 .28697 L
s
.46552 .28697 m
.46552 .28697 L
s
.4656 .28492 m
.4656 .28492 L
s
.46567 .28594 m
.46567 .28594 L
s
.46575 .28697 m
.46575 .28697 L
s
.46582 .29109 m
.46582 .29109 L
s
.4659 .28285 m
.4659 .28285 L
s
.46597 .28492 m
.46597 .28492 L
s
.46604 .28285 m
.46604 .28285 L
s
.46612 .28492 m
.46612 .28492 L
s
.4662 .28594 m
.4662 .28594 L
s
.46627 .2808 m
.46627 .2808 L
s
.46634 .28492 m
.46634 .28492 L
s
.46642 .28388 m
.46642 .28388 L
s
.46649 .28697 m
.46649 .28697 L
s
.46657 .27668 m
.46657 .27668 L
s
.46664 .28285 m
.46664 .28285 L
s
.46672 .27977 m
.46672 .27977 L
s
.46678 .2808 m
.46678 .2808 L
s
.46686 .28285 m
.46686 .28285 L
s
.46693 .2808 m
.46693 .2808 L
s
.46701 .28388 m
.46701 .28388 L
s
.46708 .28183 m
.46708 .28183 L
s
.46716 .28285 m
.46716 .28285 L
s
.46723 .28594 m
.46723 .28594 L
s
.46731 .29315 m
.46731 .29315 L
s
.46738 .28903 m
.46738 .28903 L
s
.46746 .29109 m
.46746 .29109 L
s
.46753 .28285 m
.46753 .28285 L
s
.4676 .29212 m
.4676 .29212 L
s
.46768 .288 m
.46768 .288 L
s
.46775 .28594 m
.46775 .28594 L
s
.46783 .29212 m
.46783 .29212 L
s
.4679 .28594 m
.4679 .28594 L
s
.46798 .29212 m
.46798 .29212 L
s
.46805 .29006 m
.46805 .29006 L
s
.46813 .29315 m
.46813 .29315 L
s
.4682 .28594 m
.4682 .28594 L
s
.46828 .29109 m
.46828 .29109 L
s
.46835 .29109 m
.46835 .29109 L
s
.46842 .29933 m
.46842 .29933 L
s
.46849 .29933 m
.46849 .29933 L
s
.46857 .29212 m
.46857 .29212 L
s
.46864 .29933 m
.46864 .29933 L
s
.46872 .30035 m
.46872 .30035 L
s
.46879 .29933 m
.46879 .29933 L
s
.46887 .29521 m
.46887 .29521 L
s
.46894 .30138 m
.46894 .30138 L
s
.46902 .29521 m
.46902 .29521 L
s
.46909 .29624 m
.46909 .29624 L
s
.46917 .29521 m
.46917 .29521 L
s
.46924 .30138 m
.46924 .30138 L
s
.46931 .30345 m
.46931 .30345 L
s
.46939 .30138 m
.46939 .30138 L
s
.46946 .29521 m
.46946 .29521 L
s
.46954 .29109 m
.46954 .29109 L
s
.46961 .29726 m
.46961 .29726 L
s
.46969 .29109 m
.46969 .29109 L
s
.46976 .29212 m
.46976 .29212 L
s
.46984 .29315 m
.46984 .29315 L
s
.46991 .29212 m
.46991 .29212 L
s
.46998 .28285 m
.46998 .28285 L
s
.47005 .28285 m
.47005 .28285 L
s
.47013 .27873 m
.47013 .27873 L
s
.4702 .27668 m
.4702 .27668 L
s
.47028 .27565 m
.47028 .27565 L
s
.47035 .27256 m
.47035 .27256 L
s
.47043 .27565 m
.47043 .27565 L
s
.4705 .27153 m
.4705 .27153 L
s
.47058 .26741 m
.47058 .26741 L
s
.47065 .26432 m
.47065 .26432 L
s
.47073 .26639 m
.47073 .26639 L
s
.4708 .27153 m
.4708 .27153 L
s
.47087 .26432 m
.47087 .26432 L
s
.47095 .26124 m
.47095 .26124 L
s
.47102 .25815 m
.47102 .25815 L
s
.4711 .26639 m
.4711 .26639 L
s
.47117 .26227 m
.47117 .26227 L
s
.47125 .26124 m
.47125 .26124 L
s
.47132 .25609 m
.47132 .25609 L
s
.4714 .26124 m
.4714 .26124 L
s
.47147 .25094 m
.47147 .25094 L
s
.47155 .26124 m
.47155 .26124 L
s
.47162 .25815 m
.47162 .25815 L
s
.47169 .2705 m
.47169 .2705 L
s
.47176 .27256 m
.47176 .27256 L
s
.47184 .27668 m
.47184 .27668 L
s
.47191 .27565 m
.47191 .27565 L
s
.47199 .27668 m
.47199 .27668 L
s
.47206 .28285 m
.47206 .28285 L
s
.47214 .27462 m
.47214 .27462 L
s
.47221 .28285 m
.47221 .28285 L
s
.47229 .27668 m
.47229 .27668 L
s
.47237 .27977 m
.47237 .27977 L
s
.47243 .27873 m
.47243 .27873 L
s
.47251 .2808 m
.47251 .2808 L
s
.47258 .2808 m
.47258 .2808 L
s
.47266 .27565 m
.47266 .27565 L
s
.47273 .28285 m
.47273 .28285 L
s
.47281 .28285 m
.47281 .28285 L
s
.47288 .28492 m
.47288 .28492 L
s
.47295 .27771 m
.47295 .27771 L
s
.47303 .28285 m
.47303 .28285 L
s
.47311 .27462 m
.47311 .27462 L
s
.47318 .27977 m
.47318 .27977 L
s
.47325 .28183 m
.47325 .28183 L
s
.47332 .27977 m
.47332 .27977 L
s
.4734 .27771 m
.4734 .27771 L
s
.47347 .28285 m
.47347 .28285 L
s
.47355 .29418 m
.47355 .29418 L
s
.47362 .30241 m
.47362 .30241 L
s
.4737 .31065 m
.4737 .31065 L
s
.47377 .30653 m
.47377 .30653 L
s
.47384 .30962 m
.47384 .30962 L
s
.47392 .30138 m
.47392 .30138 L
s
.474 .29933 m
.474 .29933 L
s
.47407 .2983 m
.47407 .2983 L
s
.47414 .29109 m
.47414 .29109 L
s
.47422 .29315 m
.47422 .29315 L
s
.47429 .28903 m
.47429 .28903 L
s
.47437 .29726 m
.47437 .29726 L
s
.47444 .29315 m
.47444 .29315 L
s
.47452 .2983 m
.47452 .2983 L
s
.47459 .29315 m
.47459 .29315 L
s
.47466 .29006 m
.47466 .29006 L
s
.47474 .29521 m
.47474 .29521 L
s
.47481 .29726 m
.47481 .29726 L
s
.47488 .29315 m
.47488 .29315 L
s
.47496 .29521 m
.47496 .29521 L
s
.47503 .30035 m
.47503 .30035 L
s
.47511 .2983 m
.47511 .2983 L
s
.47518 .2983 m
.47518 .2983 L
s
.47526 .29418 m
.47526 .29418 L
s
.47533 .30653 m
.47533 .30653 L
s
.4754 .2983 m
.4754 .2983 L
s
.47548 .29933 m
.47548 .29933 L
s
.47555 .30241 m
.47555 .30241 L
s
.47563 .30035 m
.47563 .30035 L
s
.4757 .29109 m
.4757 .29109 L
s
.47578 .29109 m
.47578 .29109 L
s
.47585 .30138 m
.47585 .30138 L
s
.47593 .30241 m
.47593 .30241 L
s
.476 .30756 m
.476 .30756 L
s
.47608 .30035 m
.47608 .30035 L
s
.47615 .30035 m
.47615 .30035 L
s
.47622 .29521 m
.47622 .29521 L
s
.47629 .29933 m
.47629 .29933 L
s
.47637 .29624 m
.47637 .29624 L
s
.47645 .29933 m
.47645 .29933 L
s
.47652 .29212 m
.47652 .29212 L
s
.47659 .29315 m
.47659 .29315 L
s
.47667 .30345 m
.47667 .30345 L
s
.47674 .29418 m
.47674 .29418 L
s
.47682 .30035 m
.47682 .30035 L
s
.47689 .29315 m
.47689 .29315 L
s
.47697 .30035 m
.47697 .30035 L
s
.47704 .30138 m
.47704 .30138 L
s
.47711 .30138 m
.47711 .30138 L
s
.47719 .29315 m
.47719 .29315 L
s
.47726 .29212 m
.47726 .29212 L
s
.47734 .29521 m
.47734 .29521 L
s
.47741 .29418 m
.47741 .29418 L
s
.47749 .29006 m
.47749 .29006 L
s
.47756 .28594 m
.47756 .28594 L
s
.47764 .29212 m
.47764 .29212 L
s
.47771 .28388 m
.47771 .28388 L
s
.47778 .29933 m
.47778 .29933 L
s
.47785 .29624 m
.47785 .29624 L
s
.47793 .29726 m
.47793 .29726 L
s
.478 .28697 m
.478 .28697 L
s
.47808 .29521 m
.47808 .29521 L
s
.47815 .30241 m
.47815 .30241 L
s
.47823 .29521 m
.47823 .29521 L
s
.4783 .29315 m
.4783 .29315 L
s
.47838 .28492 m
.47838 .28492 L
s
.47845 .27873 m
.47845 .27873 L
s
.47853 .27977 m
.47853 .27977 L
s
.4786 .27771 m
.4786 .27771 L
s
.47867 .27359 m
.47867 .27359 L
s
.47875 .27771 m
.47875 .27771 L
s
.47882 .28183 m
.47882 .28183 L
s
.4789 .2808 m
.4789 .2808 L
s
.47897 .27256 m
.47897 .27256 L
s
.47905 .2705 m
.47905 .2705 L
s
.47912 .27873 m
.47912 .27873 L
s
.4792 .2705 m
.4792 .2705 L
s
.47927 .26741 m
.47927 .26741 L
s
.47935 .27153 m
.47935 .27153 L
s
.47942 .27565 m
.47942 .27565 L
s
.47949 .27359 m
.47949 .27359 L
s
.47956 .2808 m
.47956 .2808 L
s
.47964 .27359 m
.47964 .27359 L
s
.47971 .26947 m
.47971 .26947 L
s
.47979 .26535 m
.47979 .26535 L
s
.47986 .27256 m
.47986 .27256 L
s
.47994 .26844 m
.47994 .26844 L
s
.48001 .25815 m
.48001 .25815 L
s
.48009 .26227 m
.48009 .26227 L
s
.48017 .26329 m
.48017 .26329 L
s
.48023 .25815 m
.48023 .25815 L
s
.48031 .25403 m
.48031 .25403 L
s
.48038 .25918 m
.48038 .25918 L
s
.48046 .25506 m
.48046 .25506 L
s
.48053 .25403 m
.48053 .25403 L
s
.48061 .25712 m
.48061 .25712 L
s
.48068 .25197 m
.48068 .25197 L
s
.48075 .24786 m
.48075 .24786 L
s
.48083 .24682 m
.48083 .24682 L
s
.48091 .23962 m
.48091 .23962 L
s
.48098 .23962 m
.48098 .23962 L
s
.48105 .24682 m
.48105 .24682 L
s
.48112 .24579 m
.48112 .24579 L
s
.4812 .24579 m
.4812 .24579 L
s
.48127 .24477 m
.48127 .24477 L
s
.48135 .23859 m
.48135 .23859 L
s
.48142 .24167 m
.48142 .24167 L
s
.4815 .23756 m
.4815 .23756 L
s
.48157 .23859 m
.48157 .23859 L
s
.48165 .23859 m
.48165 .23859 L
s
.48173 .23138 m
.48173 .23138 L
s
.4818 .22726 m
.4818 .22726 L
s
.48187 .23756 m
.48187 .23756 L
s
.48194 .23859 m
.48194 .23859 L
s
.48202 .24374 m
.48202 .24374 L
s
.48209 .24374 m
.48209 .24374 L
s
.48217 .23859 m
.48217 .23859 L
s
.48224 .24271 m
.48224 .24271 L
s
.48232 .23962 m
.48232 .23962 L
s
.48239 .23756 m
.48239 .23756 L
s
.48246 .23859 m
.48246 .23859 L
s
.48254 .24477 m
.48254 .24477 L
s
.48261 .24271 m
.48261 .24271 L
s
.48268 .24991 m
.48268 .24991 L
s
.48276 .24991 m
.48276 .24991 L
s
.48283 .24579 m
.48283 .24579 L
s
.48291 .24888 m
.48291 .24888 L
s
.48298 .25403 m
.48298 .25403 L
s
.48306 .25094 m
.48306 .25094 L
s
.48313 .24271 m
.48313 .24271 L
s
.4832 .24786 m
.4832 .24786 L
s
.48328 .24271 m
.48328 .24271 L
s
.48336 .24271 m
.48336 .24271 L
s
.48343 .23962 m
.48343 .23962 L
s
.4835 .24271 m
.4835 .24271 L
s
.48358 .23756 m
.48358 .23756 L
s
.48365 .23962 m
.48365 .23962 L
s
.48373 .24167 m
.48373 .24167 L
s
.4838 .24786 m
.4838 .24786 L
s
.48388 .25712 m
.48388 .25712 L
s
.48395 .25815 m
.48395 .25815 L
s
.48402 .26947 m
.48402 .26947 L
s
.48409 .26741 m
.48409 .26741 L
s
.48417 .26639 m
.48417 .26639 L
s
.48425 .26639 m
.48425 .26639 L
s
.48432 .26844 m
.48432 .26844 L
s
.48439 .26639 m
.48439 .26639 L
s
.48447 .26535 m
.48447 .26535 L
s
.48454 .26639 m
.48454 .26639 L
s
.48462 .26639 m
.48462 .26639 L
s
.48469 .27565 m
.48469 .27565 L
s
.48477 .27359 m
.48477 .27359 L
s
.48484 .2705 m
.48484 .2705 L
s
.48491 .27462 m
.48491 .27462 L
s
.48499 .28183 m
.48499 .28183 L
s
.48506 .27153 m
.48506 .27153 L
s
.48514 .27462 m
.48514 .27462 L
s
.48521 .26844 m
.48521 .26844 L
s
.48529 .25918 m
.48529 .25918 L
s
.48536 .24682 m
.48536 .24682 L
s
.48544 .24374 m
.48544 .24374 L
s
.48551 .24888 m
.48551 .24888 L
s
.48558 .24271 m
.48558 .24271 L
s
.48565 .24786 m
.48565 .24786 L
s
.48573 .24065 m
.48573 .24065 L
s
.4858 .24786 m
.4858 .24786 L
s
.48588 .24579 m
.48588 .24579 L
s
.48595 .24579 m
.48595 .24579 L
s
.48603 .24579 m
.48603 .24579 L
s
.4861 .24682 m
.4861 .24682 L
s
.48618 .24888 m
.48618 .24888 L
s
.48625 .24167 m
.48625 .24167 L
s
.48633 .24888 m
.48633 .24888 L
s
.4864 .24888 m
.4864 .24888 L
s
.48647 .24579 m
.48647 .24579 L
s
.48655 .24065 m
.48655 .24065 L
s
.48662 .24167 m
.48662 .24167 L
s
.4867 .23447 m
.4867 .23447 L
s
.48677 .24167 m
.48677 .24167 L
s
.48685 .24579 m
.48685 .24579 L
s
.48692 .24786 m
.48692 .24786 L
s
.487 .25506 m
.487 .25506 L
s
.48707 .25197 m
.48707 .25197 L
s
.48715 .25815 m
.48715 .25815 L
s
.48722 .26432 m
.48722 .26432 L
s
.48729 .26947 m
.48729 .26947 L
s
.48736 .25609 m
.48736 .25609 L
s
.48744 .26227 m
.48744 .26227 L
s
.48751 .25403 m
.48751 .25403 L
s
.48759 .25609 m
.48759 .25609 L
s
.48766 .25712 m
.48766 .25712 L
s
.48774 .26124 m
.48774 .26124 L
s
.48781 .26227 m
.48781 .26227 L
s
.48789 .25918 m
.48789 .25918 L
s
.48797 .26227 m
.48797 .26227 L
s
.48803 .26124 m
.48803 .26124 L
s
.48811 .25712 m
.48811 .25712 L
s
.48818 .25712 m
.48818 .25712 L
s
.48826 .25403 m
.48826 .25403 L
s
.48833 .25506 m
.48833 .25506 L
s
.48841 .25403 m
.48841 .25403 L
s
.48848 .25712 m
.48848 .25712 L
s
.48856 .25403 m
.48856 .25403 L
s
.48863 .25609 m
.48863 .25609 L
s
.48871 .24374 m
.48871 .24374 L
s
.48878 .24888 m
.48878 .24888 L
s
.48885 .23447 m
.48885 .23447 L
s
.48892 .23756 m
.48892 .23756 L
s
.489 .23035 m
.489 .23035 L
s
.48907 .23344 m
.48907 .23344 L
s
.48915 .23756 m
.48915 .23756 L
s
.48922 .23653 m
.48922 .23653 L
s
.4893 .23859 m
.4893 .23859 L
s
.48937 .22933 m
.48937 .22933 L
s
.48945 .23241 m
.48945 .23241 L
s
.48953 .22521 m
.48953 .22521 L
s
.4896 .22623 m
.4896 .22623 L
s
.48967 .22006 m
.48967 .22006 L
s
.48974 .22212 m
.48974 .22212 L
s
.48982 .21697 m
.48982 .21697 L
s
.48989 .20873 m
.48989 .20873 L
s
.48997 .2005 m
.48997 .2005 L
s
.49004 .20256 m
.49004 .20256 L
s
.49012 .2005 m
.49012 .2005 L
s
.49019 .19947 m
.49019 .19947 L
s
.49027 .19947 m
.49027 .19947 L
s
.49034 .20256 m
.49034 .20256 L
s
.49041 .20359 m
.49041 .20359 L
s
.49048 .20153 m
.49048 .20153 L
s
.49056 .20461 m
.49056 .20461 L
s
.49063 .20565 m
.49063 .20565 L
s
.49071 .20565 m
.49071 .20565 L
s
.49078 .19947 m
.49078 .19947 L
s
.49086 .2005 m
.49086 .2005 L
s
.49093 .20461 m
.49093 .20461 L
s
.491 .20668 m
.491 .20668 L
s
.49108 .20256 m
.49108 .20256 L
s
.49116 .19741 m
.49116 .19741 L
s
.49123 .19741 m
.49123 .19741 L
s
.4913 .19227 m
.4913 .19227 L
s
.49138 .19227 m
.49138 .19227 L
s
.49145 .19535 m
.49145 .19535 L
s
.49153 .18815 m
.49153 .18815 L
s
.4916 .18712 m
.4916 .18712 L
s
.49168 .18815 m
.49168 .18815 L
s
.49175 .18712 m
.49175 .18712 L
s
.49182 .183 m
.49182 .183 L
s
.4919 .18403 m
.4919 .18403 L
s
.49198 .18197 m
.49198 .18197 L
s
.49205 .17682 m
.49205 .17682 L
s
.49212 .16859 m
.49212 .16859 L
s
.49219 .16859 m
.49219 .16859 L
s
.49227 .16241 m
.49227 .16241 L
s
.49234 .16138 m
.49234 .16138 L
s
.49242 .16344 m
.49242 .16344 L
s
.49249 .15932 m
.49249 .15932 L
s
.49257 .16241 m
.49257 .16241 L
s
.49264 .15521 m
.49264 .15521 L
s
.49271 .16344 m
.49271 .16344 L
s
.49279 .16344 m
.49279 .16344 L
s
.49286 .16447 m
.49286 .16447 L
s
.49294 .16447 m
.49294 .16447 L
s
.49301 .1655 m
.49301 .1655 L
s
.49309 .1655 m
.49309 .1655 L
s
.49316 .16653 m
.49316 .16653 L
s
.49324 .1655 m
.49324 .1655 L
s
.49331 .16962 m
.49331 .16962 L
s
.49338 .17785 m
.49338 .17785 L
s
.49345 .17888 m
.49345 .17888 L
s
.49353 .17476 m
.49353 .17476 L
s
.49361 .17374 m
.49361 .17374 L
s
.49368 .17579 m
.49368 .17579 L
s
.49375 .17579 m
.49375 .17579 L
s
.49383 .17991 m
.49383 .17991 L
s
.4939 .17476 m
.4939 .17476 L
s
.49398 .17991 m
.49398 .17991 L
s
.49405 .17991 m
.49405 .17991 L
s
.49413 .18197 m
.49413 .18197 L
s
.4942 .18608 m
.4942 .18608 L
s
.49427 .183 m
.49427 .183 L
s
.49435 .18608 m
.49435 .18608 L
s
.49442 .18506 m
.49442 .18506 L
s
.4945 .19741 m
.4945 .19741 L
s
.49457 .1902 m
.49457 .1902 L
s
.49465 .19329 m
.49465 .19329 L
s
.49472 .19227 m
.49472 .19227 L
s
.4948 .19844 m
.4948 .19844 L
s
.49487 .19947 m
.49487 .19947 L
s
.49495 .19227 m
.49495 .19227 L
s
.49502 .19638 m
.49502 .19638 L
s
.49509 .1902 m
.49509 .1902 L
s
.49516 .20668 m
.49516 .20668 L
s
.49524 .20565 m
.49524 .20565 L
s
.49531 .21491 m
.49531 .21491 L
s
.49539 .21903 m
.49539 .21903 L
s
.49546 .22109 m
.49546 .22109 L
s
.49554 .21697 m
.49554 .21697 L
s
.49561 .22109 m
.49561 .22109 L
s
.49569 .22006 m
.49569 .22006 L
s
.49577 .21388 m
.49577 .21388 L
s
.49583 .22109 m
.49583 .22109 L
s
.49591 .21491 m
.49591 .21491 L
s
.49598 .21388 m
.49598 .21388 L
s
.49606 .20565 m
.49606 .20565 L
s
.49613 .20976 m
.49613 .20976 L
s
.49621 .20565 m
.49621 .20565 L
s
.49628 .20873 m
.49628 .20873 L
s
.49636 .20668 m
.49636 .20668 L
s
.49643 .20461 m
.49643 .20461 L
s
.49651 .2108 m
.49651 .2108 L
s
.49658 .20359 m
.49658 .20359 L
s
.49665 .20771 m
.49665 .20771 L
s
.49672 .20565 m
.49672 .20565 L
s
.4968 .20771 m
.4968 .20771 L
s
.49687 .20256 m
.49687 .20256 L
s
.49695 .2005 m
.49695 .2005 L
s
.49702 .19947 m
.49702 .19947 L
s
.4971 .20256 m
.4971 .20256 L
s
.49717 .20256 m
.49717 .20256 L
s
.49725 .20461 m
.49725 .20461 L
s
.49733 .21697 m
.49733 .21697 L
s
.4974 .2108 m
.4974 .2108 L
s
.49747 .21491 m
.49747 .21491 L
s
.49754 .20359 m
.49754 .20359 L
s
.49762 .20873 m
.49762 .20873 L
s
.49769 .20461 m
.49769 .20461 L
s
.49777 .20461 m
.49777 .20461 L
s
.49784 .19844 m
.49784 .19844 L
s
.49792 .2005 m
.49792 .2005 L
s
.49799 .19432 m
.49799 .19432 L
s
.49807 .19329 m
.49807 .19329 L
s
.49814 .18917 m
.49814 .18917 L
s
.49821 .1902 m
.49821 .1902 L
s
.49828 .19741 m
.49828 .19741 L
s
.49836 .18712 m
.49836 .18712 L
s
.49843 .19227 m
.49843 .19227 L
s
.49851 .183 m
.49851 .183 L
s
.49858 .18094 m
.49858 .18094 L
s
.49866 .18197 m
.49866 .18197 L
s
.49873 .18506 m
.49873 .18506 L
s
.49881 .18197 m
.49881 .18197 L
s
.49889 .18506 m
.49889 .18506 L
s
.49896 .1902 m
.49896 .1902 L
s
.49903 .18608 m
.49903 .18608 L
s
.4991 .1902 m
.4991 .1902 L
s
.49918 .18917 m
.49918 .18917 L
s
.49925 .19741 m
.49925 .19741 L
s
.49933 .19535 m
.49933 .19535 L
s
.4994 .20565 m
.4994 .20565 L
s
.49948 .20976 m
.49948 .20976 L
s
.49955 .22109 m
.49955 .22109 L
s
.49962 .22212 m
.49962 .22212 L
s
.4997 .21697 m
.4997 .21697 L
s
.49978 .218 m
.49978 .218 L
s
.49985 .21388 m
.49985 .21388 L
s
.49992 .22521 m
.49992 .22521 L
s
.49999 .21491 m
.49999 .21491 L
s
.50007 .21903 m
.50007 .21903 L
s
.50014 .21594 m
.50014 .21594 L
s
.50022 .21903 m
.50022 .21903 L
s
.50029 .22006 m
.50029 .22006 L
s
.50037 .21903 m
.50037 .21903 L
s
.50044 .22212 m
.50044 .22212 L
s
.50052 .22006 m
.50052 .22006 L
s
.5006 .218 m
.5006 .218 L
s
.50066 .21491 m
.50066 .21491 L
s
.50074 .22109 m
.50074 .22109 L
s
.50081 .22109 m
.50081 .22109 L
s
.50089 .22521 m
.50089 .22521 L
s
.50096 .21285 m
.50096 .21285 L
s
.50104 .20565 m
.50104 .20565 L
s
.50111 .19947 m
.50111 .19947 L
s
.50118 .20256 m
.50118 .20256 L
s
.50125 .20668 m
.50125 .20668 L
s
.50133 .20565 m
.50133 .20565 L
s
.50141 .20873 m
.50141 .20873 L
s
.50148 .20461 m
.50148 .20461 L
s
.50155 .20771 m
.50155 .20771 L
s
.50163 .20668 m
.50163 .20668 L
s
.5017 .21182 m
.5017 .21182 L
s
.50178 .19947 m
.50178 .19947 L
s
.50185 .20153 m
.50185 .20153 L
s
.50193 .19535 m
.50193 .19535 L
s
.502 .19844 m
.502 .19844 L
s
.50207 .19227 m
.50207 .19227 L
s
.50215 .1902 m
.50215 .1902 L
s
.50223 .19535 m
.50223 .19535 L
s
.5023 .19329 m
.5023 .19329 L
s
.50237 .20153 m
.50237 .20153 L
s
.50245 .19535 m
.50245 .19535 L
s
.50252 .19741 m
.50252 .19741 L
s
.5026 .19432 m
.5026 .19432 L
s
.50267 .19329 m
.50267 .19329 L
s
.50275 .18712 m
.50275 .18712 L
s
.50282 .18917 m
.50282 .18917 L
s
.50289 .18094 m
.50289 .18094 L
s
.50296 .18712 m
.50296 .18712 L
s
.50304 .18403 m
.50304 .18403 L
s
.50311 .18094 m
.50311 .18094 L
s
.50319 .18197 m
.50319 .18197 L
s
.50326 .17064 m
.50326 .17064 L
s
.50334 .17064 m
.50334 .17064 L
s
.50341 .16344 m
.50341 .16344 L
s
.50349 .16859 m
.50349 .16859 L
s
.50357 .16344 m
.50357 .16344 L
s
.50363 .16653 m
.50363 .16653 L
s
.50371 .17374 m
.50371 .17374 L
s
.50378 .17064 m
.50378 .17064 L
s
.50386 .17374 m
.50386 .17374 L
s
.50393 .15829 m
.50393 .15829 L
s
.50401 .16241 m
.50401 .16241 L
s
.50408 .16138 m
.50408 .16138 L
s
.50416 .16653 m
.50416 .16653 L
s
.50423 .16859 m
.50423 .16859 L
s
.50431 .16755 m
.50431 .16755 L
s
.50438 .1655 m
.50438 .1655 L
s
.50445 .16344 m
.50445 .16344 L
s
.50452 .17271 m
.50452 .17271 L
s
.5046 .17167 m
.5046 .17167 L
s
.50467 .16962 m
.50467 .16962 L
s
.50475 .16962 m
.50475 .16962 L
s
.50482 .17579 m
.50482 .17579 L
s
.5049 .16859 m
.5049 .16859 L
s
.50497 .17064 m
.50497 .17064 L
s
.50505 .16138 m
.50505 .16138 L
s
.50513 .16035 m
.50513 .16035 L
s
.5052 .15418 m
.5052 .15418 L
s
.50527 .15109 m
.50527 .15109 L
s
.50534 .15314 m
.50534 .15314 L
s
.50542 .15932 m
.50542 .15932 L
s
.50549 .16344 m
.50549 .16344 L
s
.50557 .15521 m
.50557 .15521 L
s
.50564 .15623 m
.50564 .15623 L
s
.50572 .15623 m
.50572 .15623 L
s
.50579 .14902 m
.50579 .14902 L
s
.50587 .14491 m
.50587 .14491 L
s
.50594 .14182 m
.50594 .14182 L
s
.50602 .1377 m
.50602 .1377 L
s
.50608 .13461 m
.50608 .13461 L
s
.50616 .1377 m
.50616 .1377 L
s
.50623 .14079 m
.50623 .14079 L
s
.50631 .15109 m
.50631 .15109 L
s
.50638 .15418 m
.50638 .15418 L
s
.50646 .16241 m
.50646 .16241 L
s
.50653 .16138 m
.50653 .16138 L
s
.50661 .15726 m
.50661 .15726 L
s
.50669 .14902 m
.50669 .14902 L
s
.50676 .15623 m
.50676 .15623 L
s
.50683 .15932 m
.50683 .15932 L
s
.5069 .15418 m
.5069 .15418 L
s
.50698 .14902 m
.50698 .14902 L
s
.50705 .14697 m
.50705 .14697 L
s
.50713 .15006 m
.50713 .15006 L
s
.5072 .14491 m
.5072 .14491 L
s
.50728 .15109 m
.50728 .15109 L
s
.50735 .14285 m
.50735 .14285 L
s
.50743 .14285 m
.50743 .14285 L
s
.5075 .14079 m
.5075 .14079 L
s
.50758 .14079 m
.50758 .14079 L
s
.50765 .14388 m
.50765 .14388 L
s
.50772 .13461 m
.50772 .13461 L
s
.50779 .13153 m
.50779 .13153 L
s
.50787 .13153 m
.50787 .13153 L
s
.50794 .13358 m
.50794 .13358 L
s
.50802 .12844 m
.50802 .12844 L
s
.50809 .13668 m
.50809 .13668 L
s
.50817 .14079 m
.50817 .14079 L
s
.50824 .14388 m
.50824 .14388 L
s
.50832 .13873 m
.50832 .13873 L
s
.5084 .13668 m
.5084 .13668 L
s
.50846 .13256 m
.50846 .13256 L
s
.50854 .1377 m
.50854 .1377 L
s
.50861 .14388 m
.50861 .14388 L
s
.50869 .14902 m
.50869 .14902 L
s
.50876 .14285 m
.50876 .14285 L
s
.50884 .13461 m
.50884 .13461 L
s
.50891 .1377 m
.50891 .1377 L
s
.50899 .13358 m
.50899 .13358 L
s
.50906 .13565 m
.50906 .13565 L
s
.50914 .13256 m
.50914 .13256 L
s
.50921 .13256 m
.50921 .13256 L
s
.50928 .13256 m
.50928 .13256 L
s
.50935 .13256 m
.50935 .13256 L
s
.50943 .12792 m
.50943 .12792 L
s
.5095 .13565 m
.5095 .13565 L
s
.50958 .15006 m
.50958 .15006 L
s
.50965 .15109 m
.50965 .15109 L
s
.50973 .14079 m
.50973 .14079 L
s
.5098 .13256 m
.5098 .13256 L
s
.50987 .13358 m
.50987 .13358 L
s
.50995 .13256 m
.50995 .13256 L
s
.51003 .13358 m
.51003 .13358 L
s
.5101 .13668 m
.5101 .13668 L
s
.51017 .13256 m
.51017 .13256 L
s
.51025 .13668 m
.51025 .13668 L
s
.51032 .13358 m
.51032 .13358 L
s
.5104 .13976 m
.5104 .13976 L
s
.51047 .14182 m
.51047 .14182 L
s
.51055 .14182 m
.51055 .14182 L
s
.51062 .13873 m
.51062 .13873 L
s
.51069 .14285 m
.51069 .14285 L
s
.51077 .14079 m
.51077 .14079 L
s
.51085 .14285 m
.51085 .14285 L
s
.51091 .14697 m
.51091 .14697 L
s
.51099 .14388 m
.51099 .14388 L
s
.51106 .14594 m
.51106 .14594 L
s
.51114 .14388 m
.51114 .14388 L
s
.51121 .14902 m
.51121 .14902 L
s
.51129 .15314 m
.51129 .15314 L
s
.51137 .16241 m
.51137 .16241 L
s
.51143 .15726 m
.51143 .15726 L
s
.51151 .16962 m
.51151 .16962 L
s
.51158 .17064 m
.51158 .17064 L
s
.51166 .17064 m
.51166 .17064 L
s
.51173 .16653 m
.51173 .16653 L
s
.51181 .17167 m
.51181 .17167 L
s
.51188 .17991 m
.51188 .17991 L
s
.51196 .17476 m
.51196 .17476 L
s
.51203 .18506 m
.51203 .18506 L
s
.51211 .18608 m
.51211 .18608 L
s
.51218 .18815 m
.51218 .18815 L
s
.51225 .19124 m
.51225 .19124 L
s
.51232 .19227 m
.51232 .19227 L
s
.5124 .1902 m
.5124 .1902 L
s
.51248 .19329 m
.51248 .19329 L
s
.51255 .19844 m
.51255 .19844 L
s
.51262 .19535 m
.51262 .19535 L
s
.5127 .18815 m
.5127 .18815 L
s
.51277 .19535 m
.51277 .19535 L
s
.51285 .20256 m
.51285 .20256 L
s
.51293 .20359 m
.51293 .20359 L
s
.513 .21491 m
.513 .21491 L
s
.51307 .21491 m
.51307 .21491 L
s
.51314 .21285 m
.51314 .21285 L
s
.51322 .20668 m
.51322 .20668 L
s
.51329 .20668 m
.51329 .20668 L
s
.51337 .21285 m
.51337 .21285 L
s
.51344 .20565 m
.51344 .20565 L
s
.51352 .20461 m
.51352 .20461 L
s
.51359 .19844 m
.51359 .19844 L
s
.51367 .19844 m
.51367 .19844 L
s
.51374 .20153 m
.51374 .20153 L
s
.51382 .19844 m
.51382 .19844 L
s
.51388 .19432 m
.51388 .19432 L
s
.51396 .19432 m
.51396 .19432 L
s
.51403 .19844 m
.51403 .19844 L
s
.51411 .19329 m
.51411 .19329 L
s
.51418 .1902 m
.51418 .1902 L
s
.51426 .18712 m
.51426 .18712 L
s
.51433 .18712 m
.51433 .18712 L
s
.51441 .17785 m
.51441 .17785 L
s
.51449 .17785 m
.51449 .17785 L
s
.51456 .17271 m
.51456 .17271 L
s
.51463 .17991 m
.51463 .17991 L
s
.5147 .18608 m
.5147 .18608 L
s
.51478 .18712 m
.51478 .18712 L
s
.51485 .18815 m
.51485 .18815 L
s
.51493 .18403 m
.51493 .18403 L
s
.515 .1902 m
.515 .1902 L
s
.51508 .19638 m
.51508 .19638 L
s
.51515 .19432 m
.51515 .19432 L
s
.51523 .19844 m
.51523 .19844 L
s
.5153 .2005 m
.5153 .2005 L
s
.51538 .18608 m
.51538 .18608 L
s
.51545 .18403 m
.51545 .18403 L
s
.51552 .18506 m
.51552 .18506 L
s
.51559 .18608 m
.51559 .18608 L
s
.51567 .1902 m
.51567 .1902 L
s
.51574 .18917 m
.51574 .18917 L
s
.51582 .19535 m
.51582 .19535 L
s
.51589 .19227 m
.51589 .19227 L
s
.51597 .18506 m
.51597 .18506 L
s
.51604 .18094 m
.51604 .18094 L
s
.51612 .18608 m
.51612 .18608 L
s
.5162 .183 m
.5162 .183 L
s
.51626 .183 m
.51626 .183 L
s
.51634 .18403 m
.51634 .18403 L
s
.51641 .1902 m
.51641 .1902 L
s
.51649 .19227 m
.51649 .19227 L
s
.51656 .1902 m
.51656 .1902 L
s
.51664 .19227 m
.51664 .19227 L
s
.51671 .19124 m
.51671 .19124 L
s
.51679 .19227 m
.51679 .19227 L
s
.51686 .19741 m
.51686 .19741 L
s
.51694 .20461 m
.51694 .20461 L
s
.51701 .19947 m
.51701 .19947 L
s
.51708 .20256 m
.51708 .20256 L
s
.51715 .19741 m
.51715 .19741 L
s
.51723 .20461 m
.51723 .20461 L
s
.5173 .2005 m
.5173 .2005 L
s
.51738 .20256 m
.51738 .20256 L
s
.51745 .2005 m
.51745 .2005 L
s
.51753 .19844 m
.51753 .19844 L
s
.5176 .20873 m
.5176 .20873 L
s
.51767 .20565 m
.51767 .20565 L
s
.51775 .21491 m
.51775 .21491 L
s
.51783 .20461 m
.51783 .20461 L
s
.5179 .2108 m
.5179 .2108 L
s
.51797 .20668 m
.51797 .20668 L
s
.51805 .20359 m
.51805 .20359 L
s
.51812 .20873 m
.51812 .20873 L
s
.5182 .2005 m
.5182 .2005 L
s
.51827 .20565 m
.51827 .20565 L
s
.51835 .20668 m
.51835 .20668 L
s
.51842 .21491 m
.51842 .21491 L
s
.51849 .20565 m
.51849 .20565 L
s
.51857 .20565 m
.51857 .20565 L
s
.51865 .20461 m
.51865 .20461 L
s
.51871 .20873 m
.51871 .20873 L
s
.51879 .21182 m
.51879 .21182 L
s
.51886 .2005 m
.51886 .2005 L
s
.51894 .2005 m
.51894 .2005 L
s
.51901 .19638 m
.51901 .19638 L
s
.51909 .20461 m
.51909 .20461 L
s
.51917 .19638 m
.51917 .19638 L
s
.51923 .19947 m
.51923 .19947 L
s
.51931 .19329 m
.51931 .19329 L
s
.51939 .20153 m
.51939 .20153 L
s
.51946 .19329 m
.51946 .19329 L
s
.51953 .1902 m
.51953 .1902 L
s
.51961 .183 m
.51961 .183 L
s
.51968 .17682 m
.51968 .17682 L
s
.51976 .17991 m
.51976 .17991 L
s
.51983 .18403 m
.51983 .18403 L
s
.51991 .18403 m
.51991 .18403 L
s
.51998 .18197 m
.51998 .18197 L
s
.52005 .19432 m
.52005 .19432 L
s
.52012 .18608 m
.52012 .18608 L
s
.5202 .19432 m
.5202 .19432 L
s
.52028 .18815 m
.52028 .18815 L
s
.52035 .19741 m
.52035 .19741 L
s
.52042 .19844 m
.52042 .19844 L
s
.5205 .19741 m
.5205 .19741 L
s
.52057 .20359 m
.52057 .20359 L
s
.52065 .20359 m
.52065 .20359 L
s
.52073 .20256 m
.52073 .20256 L
s
.5208 .19535 m
.5208 .19535 L
s
.52087 .19844 m
.52087 .19844 L
s
.52094 .19535 m
.52094 .19535 L
s
.52102 .20256 m
.52102 .20256 L
s
.52109 .19432 m
.52109 .19432 L
s
.52117 .19638 m
.52117 .19638 L
s
.52124 .18815 m
.52124 .18815 L
s
.52132 .18917 m
.52132 .18917 L
s
.52139 .1902 m
.52139 .1902 L
s
.52147 .18712 m
.52147 .18712 L
s
.52154 .19329 m
.52154 .19329 L
s
.52162 .19124 m
.52162 .19124 L
s
.52168 .19741 m
.52168 .19741 L
s
.52176 .19844 m
.52176 .19844 L
s
.52183 .20256 m
.52183 .20256 L
s
.52191 .2005 m
.52191 .2005 L
s
.52198 .20668 m
.52198 .20668 L
s
.52206 .20461 m
.52206 .20461 L
s
.52213 .20771 m
.52213 .20771 L
s
.52221 .21491 m
.52221 .21491 L
s
.52229 .21182 m
.52229 .21182 L
s
.52236 .22418 m
.52236 .22418 L
s
.52243 .22109 m
.52243 .22109 L
s
.5225 .22418 m
.5225 .22418 L
s
.52258 .22623 m
.52258 .22623 L
s
.52265 .22726 m
.52265 .22726 L
s
.52273 .21903 m
.52273 .21903 L
s
.5228 .21697 m
.5228 .21697 L
s
.52288 .22109 m
.52288 .22109 L
s
.52295 .218 m
.52295 .218 L
s
.52303 .22006 m
.52303 .22006 L
s
.5231 .21388 m
.5231 .21388 L
s
.52318 .22521 m
.52318 .22521 L
s
.52325 .22521 m
.52325 .22521 L
s
.52332 .23138 m
.52332 .23138 L
s
.52339 .23035 m
.52339 .23035 L
s
.52347 .23447 m
.52347 .23447 L
s
.52354 .24271 m
.52354 .24271 L
s
.52362 .23653 m
.52362 .23653 L
s
.52369 .24065 m
.52369 .24065 L
s
.52377 .23344 m
.52377 .23344 L
s
.52385 .2355 m
.52385 .2355 L
s
.52392 .23035 m
.52392 .23035 L
s
.524 .23241 m
.524 .23241 L
s
.52406 .23035 m
.52406 .23035 L
s
.52414 .23344 m
.52414 .23344 L
s
.52421 .22933 m
.52421 .22933 L
s
.52429 .22418 m
.52429 .22418 L
s
.52436 .22314 m
.52436 .22314 L
s
.52444 .22726 m
.52444 .22726 L
s
.52451 .22933 m
.52451 .22933 L
s
.52459 .22829 m
.52459 .22829 L
s
.52466 .23859 m
.52466 .23859 L
s
.52474 .23035 m
.52474 .23035 L
s
.52481 .23756 m
.52481 .23756 L
s
.52488 .23344 m
.52488 .23344 L
s
.52495 .23447 m
.52495 .23447 L
s
.52503 .2355 m
.52503 .2355 L
s
.5251 .23859 m
.5251 .23859 L
s
.52518 .23344 m
.52518 .23344 L
s
.52525 .23447 m
.52525 .23447 L
s
.52533 .23447 m
.52533 .23447 L
s
.5254 .24167 m
.5254 .24167 L
s
.52548 .24477 m
.52548 .24477 L
s
.52556 .23859 m
.52556 .23859 L
s
.52563 .24271 m
.52563 .24271 L
s
.5257 .23859 m
.5257 .23859 L
s
.52577 .23344 m
.52577 .23344 L
s
.52585 .23962 m
.52585 .23962 L
s
.52592 .23859 m
.52592 .23859 L
s
.526 .24167 m
.526 .24167 L
s
.52607 .24167 m
.52607 .24167 L
s
.52615 .23962 m
.52615 .23962 L
s
.52622 .23756 m
.52622 .23756 L
s
.52629 .23653 m
.52629 .23653 L
s
.52637 .23035 m
.52637 .23035 L
s
.52645 .23241 m
.52645 .23241 L
s
.52651 .22623 m
.52651 .22623 L
s
.52659 .23035 m
.52659 .23035 L
s
.52666 .23447 m
.52666 .23447 L
s
.52674 .23241 m
.52674 .23241 L
s
.52681 .22933 m
.52681 .22933 L
s
.52689 .22418 m
.52689 .22418 L
s
.52697 .22726 m
.52697 .22726 L
s
.52703 .22418 m
.52703 .22418 L
s
.52711 .22933 m
.52711 .22933 L
s
.52719 .22726 m
.52719 .22726 L
s
.52726 .23241 m
.52726 .23241 L
s
.52733 .23653 m
.52733 .23653 L
s
.52741 .24167 m
.52741 .24167 L
s
.52748 .23653 m
.52748 .23653 L
s
.52756 .23962 m
.52756 .23962 L
s
.52763 .24065 m
.52763 .24065 L
s
.52771 .24167 m
.52771 .24167 L
s
.52778 .23962 m
.52778 .23962 L
s
.52785 .23447 m
.52785 .23447 L
s
.52792 .2355 m
.52792 .2355 L
s
.528 .23756 m
.528 .23756 L
s
.52808 .23653 m
.52808 .23653 L
s
.52815 .22933 m
.52815 .22933 L
s
.52822 .24167 m
.52822 .24167 L
s
.5283 .24374 m
.5283 .24374 L
s
.52837 .25403 m
.52837 .25403 L
s
.52845 .24991 m
.52845 .24991 L
s
.52853 .24991 m
.52853 .24991 L
s
.5286 .25094 m
.5286 .25094 L
s
.52867 .24991 m
.52867 .24991 L
s
.52874 .25197 m
.52874 .25197 L
s
.52882 .24579 m
.52882 .24579 L
s
.52889 .25197 m
.52889 .25197 L
s
.52897 .25094 m
.52897 .25094 L
s
.52904 .25609 m
.52904 .25609 L
s
.52912 .2602 m
.52912 .2602 L
s
.52919 .25815 m
.52919 .25815 L
s
.52927 .25609 m
.52927 .25609 L
s
.52934 .253 m
.52934 .253 L
s
.52942 .25918 m
.52942 .25918 L
s
.52948 .25506 m
.52948 .25506 L
s
.52956 .253 m
.52956 .253 L
s
.52963 .25197 m
.52963 .25197 L
s
.52971 .2602 m
.52971 .2602 L
s
.52978 .24374 m
.52978 .24374 L
s
.52986 .24991 m
.52986 .24991 L
s
.52993 .24786 m
.52993 .24786 L
s
.53001 .24786 m
.53001 .24786 L
s
.53009 .24786 m
.53009 .24786 L
s
.53016 .24991 m
.53016 .24991 L
s
.53023 .25815 m
.53023 .25815 L
s
.5303 .25918 m
.5303 .25918 L
s
.53038 .26227 m
.53038 .26227 L
s
.53045 .253 m
.53045 .253 L
s
.53053 .25506 m
.53053 .25506 L
s
.5306 .24786 m
.5306 .24786 L
s
.53068 .24682 m
.53068 .24682 L
s
.53075 .24579 m
.53075 .24579 L
s
.53083 .24374 m
.53083 .24374 L
s
.5309 .24065 m
.5309 .24065 L
s
.53098 .23756 m
.53098 .23756 L
s
.53105 .2355 m
.53105 .2355 L
s
.53112 .2355 m
.53112 .2355 L
s
.53119 .24065 m
.53119 .24065 L
s
.53127 .23138 m
.53127 .23138 L
s
.53134 .23241 m
.53134 .23241 L
s
.53142 .23447 m
.53142 .23447 L
s
.53149 .24167 m
.53149 .24167 L
s
.53157 .24271 m
.53157 .24271 L
s
.53165 .24374 m
.53165 .24374 L
s
.53172 .24167 m
.53172 .24167 L
s
.5318 .23962 m
.5318 .23962 L
s
.53186 .23962 m
.53186 .23962 L
s
.53194 .2355 m
.53194 .2355 L
s
.53201 .23962 m
.53201 .23962 L
s
.53209 .23653 m
.53209 .23653 L
s
.53216 .23962 m
.53216 .23962 L
s
.53224 .22933 m
.53224 .22933 L
s
.53231 .23035 m
.53231 .23035 L
s
.53239 .23344 m
.53239 .23344 L
s
.53246 .23241 m
.53246 .23241 L
s
.53254 .23344 m
.53254 .23344 L
s
.53261 .2355 m
.53261 .2355 L
s
.53268 .23241 m
.53268 .23241 L
s
.53275 .22726 m
.53275 .22726 L
s
.53283 .23035 m
.53283 .23035 L
s
.5329 .22418 m
.5329 .22418 L
s
.53298 .23035 m
.53298 .23035 L
s
.53305 .22418 m
.53305 .22418 L
s
.53313 .21491 m
.53313 .21491 L
s
.5332 .22109 m
.5332 .22109 L
s
.53328 .22314 m
.53328 .22314 L
s
.53336 .22314 m
.53336 .22314 L
s
.53343 .21697 m
.53343 .21697 L
s
.5335 .21697 m
.5335 .21697 L
s
.53357 .21388 m
.53357 .21388 L
s
.53365 .21388 m
.53365 .21388 L
s
.53372 .2108 m
.53372 .2108 L
s
.5338 .21594 m
.5338 .21594 L
s
.53387 .21594 m
.53387 .21594 L
s
.53395 .21903 m
.53395 .21903 L
s
.53402 .21903 m
.53402 .21903 L
s
.5341 .21285 m
.5341 .21285 L
s
.53417 .20873 m
.53417 .20873 L
s
.53425 .20359 m
.53425 .20359 L
s
.53431 .20976 m
.53431 .20976 L
s
.53439 .20668 m
.53439 .20668 L
s
.53446 .20565 m
.53446 .20565 L
s
.53454 .20153 m
.53454 .20153 L
s
.53461 .2108 m
.53461 .2108 L
s
.53469 .21491 m
.53469 .21491 L
s
.53477 .21388 m
.53477 .21388 L
s
.53483 .21491 m
.53483 .21491 L
s
.53491 .22109 m
.53491 .22109 L
s
.53499 .22109 m
.53499 .22109 L
s
.53506 .22521 m
.53506 .22521 L
s
.53513 .23344 m
.53513 .23344 L
s
.53521 .22418 m
.53521 .22418 L
s
.53528 .23241 m
.53528 .23241 L
s
.53536 .22829 m
.53536 .22829 L
s
.53543 .23241 m
.53543 .23241 L
s
.53551 .22521 m
.53551 .22521 L
s
.53558 .22933 m
.53558 .22933 L
s
.53565 .23344 m
.53565 .23344 L
s
.53573 .2355 m
.53573 .2355 L
s
.53581 .24271 m
.53581 .24271 L
s
.53588 .23344 m
.53588 .23344 L
s
.53595 .23653 m
.53595 .23653 L
s
.53602 .23344 m
.53602 .23344 L
s
.5361 .23653 m
.5361 .23653 L
s
.53617 .23447 m
.53617 .23447 L
s
.53625 .23859 m
.53625 .23859 L
s
.53633 .23756 m
.53633 .23756 L
s
.5364 .24065 m
.5364 .24065 L
s
.53647 .23962 m
.53647 .23962 L
s
.53654 .23447 m
.53654 .23447 L
s
.53662 .23447 m
.53662 .23447 L
s
.53669 .23447 m
.53669 .23447 L
s
.53677 .23756 m
.53677 .23756 L
s
.53684 .23241 m
.53684 .23241 L
s
.53692 .2355 m
.53692 .2355 L
s
.53699 .23241 m
.53699 .23241 L
s
.53707 .22623 m
.53707 .22623 L
s
.53714 .21388 m
.53714 .21388 L
s
.53722 .21388 m
.53722 .21388 L
s
.53728 .21594 m
.53728 .21594 L
s
.53736 .21594 m
.53736 .21594 L
s
.53744 .22726 m
.53744 .22726 L
s
.53751 .22521 m
.53751 .22521 L
s
.53758 .22623 m
.53758 .22623 L
s
.53766 .22933 m
.53766 .22933 L
s
.53773 .2355 m
.53773 .2355 L
s
.53781 .23653 m
.53781 .23653 L
s
.53789 .23962 m
.53789 .23962 L
s
.53796 .22933 m
.53796 .22933 L
s
.53803 .23138 m
.53803 .23138 L
s
.5381 .23035 m
.5381 .23035 L
s
.53818 .22933 m
.53818 .22933 L
s
.53825 .22933 m
.53825 .22933 L
s
.53833 .22314 m
.53833 .22314 L
s
.5384 .22726 m
.5384 .22726 L
s
.53848 .21903 m
.53848 .21903 L
s
.53855 .22521 m
.53855 .22521 L
s
.53863 .22521 m
.53863 .22521 L
s
.5387 .22314 m
.5387 .22314 L
s
.53878 .21594 m
.53878 .21594 L
s
.53885 .21903 m
.53885 .21903 L
s
.53892 .218 m
.53892 .218 L
s
.53899 .21285 m
.53899 .21285 L
s
.53907 .21697 m
.53907 .21697 L
s
.53914 .21491 m
.53914 .21491 L
s
.53922 .218 m
.53922 .218 L
s
.53929 .21388 m
.53929 .21388 L
s
.53937 .21285 m
.53937 .21285 L
s
.53945 .21182 m
.53945 .21182 L
s
.53952 .2108 m
.53952 .2108 L
s
.5396 .21182 m
.5396 .21182 L
s
.53966 .21388 m
.53966 .21388 L
s
.53974 .21182 m
.53974 .21182 L
s
.53981 .20873 m
.53981 .20873 L
s
.53989 .20771 m
.53989 .20771 L
s
.53996 .19741 m
.53996 .19741 L
s
.54004 .20256 m
.54004 .20256 L
s
.54011 .19844 m
.54011 .19844 L
s
.54019 .20256 m
.54019 .20256 L
s
.54026 .20461 m
.54026 .20461 L
s
.54034 .20668 m
.54034 .20668 L
s
.54041 .20256 m
.54041 .20256 L
s
.54048 .20256 m
.54048 .20256 L
s
.54055 .19947 m
.54055 .19947 L
s
.54063 .19844 m
.54063 .19844 L
s
.5407 .20256 m
.5407 .20256 L
s
.54078 .18815 m
.54078 .18815 L
s
.54085 .18608 m
.54085 .18608 L
s
.54093 .18712 m
.54093 .18712 L
s
.54101 .19741 m
.54101 .19741 L
s
.54108 .19638 m
.54108 .19638 L
s
.54116 .19432 m
.54116 .19432 L
s
.54123 .18712 m
.54123 .18712 L
s
.5413 .18815 m
.5413 .18815 L
s
.54137 .18917 m
.54137 .18917 L
s
.54145 .18506 m
.54145 .18506 L
s
.54152 .18506 m
.54152 .18506 L
s
.5416 .18403 m
.5416 .18403 L
s
.54167 .18712 m
.54167 .18712 L
s
.54175 .18608 m
.54175 .18608 L
s
.54182 .18815 m
.54182 .18815 L
s
.5419 .183 m
.5419 .183 L
s
.54197 .17785 m
.54197 .17785 L
s
.54205 .17374 m
.54205 .17374 L
s
.54211 .17271 m
.54211 .17271 L
s
.54219 .17167 m
.54219 .17167 L
s
.54226 .17167 m
.54226 .17167 L
s
.54234 .17888 m
.54234 .17888 L
s
.54241 .17167 m
.54241 .17167 L
s
.54249 .17991 m
.54249 .17991 L
s
.54257 .17579 m
.54257 .17579 L
s
.54264 .18094 m
.54264 .18094 L
s
.54272 .18197 m
.54272 .18197 L
s
.54279 .18403 m
.54279 .18403 L
s
.54286 .18815 m
.54286 .18815 L
s
.54293 .18403 m
.54293 .18403 L
s
.54301 .18403 m
.54301 .18403 L
s
.54308 .183 m
.54308 .183 L
s
.54316 .18403 m
.54316 .18403 L
s
.54323 .18815 m
.54323 .18815 L
s
.54331 .18506 m
.54331 .18506 L
s
.54338 .17888 m
.54338 .17888 L
s
.54345 .18608 m
.54345 .18608 L
s
.54353 .19227 m
.54353 .19227 L
s
.54361 .19432 m
.54361 .19432 L
s
.54368 .1902 m
.54368 .1902 L
s
.54375 .18815 m
.54375 .18815 L
s
.54382 .18608 m
.54382 .18608 L
s
.5439 .183 m
.5439 .183 L
s
.54397 .18506 m
.54397 .18506 L
s
.54405 .18506 m
.54405 .18506 L
s
.54413 .18506 m
.54413 .18506 L
s
.5442 .18197 m
.5442 .18197 L
s
.54427 .18917 m
.54427 .18917 L
s
.54435 .18608 m
.54435 .18608 L
s
.54443 .18094 m
.54443 .18094 L
s
.54449 .18712 m
.54449 .18712 L
s
.54457 .1902 m
.54457 .1902 L
s
.54464 .19124 m
.54464 .19124 L
s
.54472 .183 m
.54472 .183 L
s
.54479 .1902 m
.54479 .1902 L
s
.54487 .18608 m
.54487 .18608 L
s
.54494 .19432 m
.54494 .19432 L
s
.54502 .2005 m
.54502 .2005 L
s
.54508 .20668 m
.54508 .20668 L
s
.54516 .20668 m
.54516 .20668 L
s
.54524 .20873 m
.54524 .20873 L
s
.54531 .21697 m
.54531 .21697 L
s
.54538 .20873 m
.54538 .20873 L
s
.54546 .21182 m
.54546 .21182 L
s
.54553 .20976 m
.54553 .20976 L
s
.54561 .2108 m
.54561 .2108 L
s
.54569 .20873 m
.54569 .20873 L
s
.54576 .20461 m
.54576 .20461 L
s
.54583 .20359 m
.54583 .20359 L
s
.5459 .20873 m
.5459 .20873 L
s
.54598 .20668 m
.54598 .20668 L
s
.54606 .20565 m
.54606 .20565 L
s
.54613 .20256 m
.54613 .20256 L
s
.5462 .20153 m
.5462 .20153 L
s
.54628 .20668 m
.54628 .20668 L
s
.54635 .20873 m
.54635 .20873 L
s
.54643 .21594 m
.54643 .21594 L
s
.5465 .21491 m
.5465 .21491 L
s
.54658 .21594 m
.54658 .21594 L
s
.54665 .19947 m
.54665 .19947 L
s
.54672 .20771 m
.54672 .20771 L
s
.54679 .2005 m
.54679 .2005 L
s
.54687 .19329 m
.54687 .19329 L
s
.54694 .19638 m
.54694 .19638 L
s
.54702 .19227 m
.54702 .19227 L
s
.54709 .19844 m
.54709 .19844 L
s
.54717 .19638 m
.54717 .19638 L
s
.54725 .20771 m
.54725 .20771 L
s
.54732 .19741 m
.54732 .19741 L
s
.5474 .20461 m
.5474 .20461 L
s
.54746 .20461 m
.54746 .20461 L
s
.54754 .20976 m
.54754 .20976 L
s
.54761 .20565 m
.54761 .20565 L
s
.54769 .20668 m
.54769 .20668 L
s
.54776 .21491 m
.54776 .21491 L
s
.54784 .21182 m
.54784 .21182 L
s
.54791 .2108 m
.54791 .2108 L
s
.54799 .20873 m
.54799 .20873 L
s
.54806 .20771 m
.54806 .20771 L
s
.54814 .20771 m
.54814 .20771 L
s
.54821 .21388 m
.54821 .21388 L
s
.54828 .20771 m
.54828 .20771 L
s
.54835 .2108 m
.54835 .2108 L
s
.54843 .20873 m
.54843 .20873 L
s
.5485 .20668 m
.5485 .20668 L
s
.54858 .20976 m
.54858 .20976 L
s
.54865 .20256 m
.54865 .20256 L
s
.54873 .20461 m
.54873 .20461 L
s
.54881 .19947 m
.54881 .19947 L
s
.54888 .20565 m
.54888 .20565 L
s
.54896 .21285 m
.54896 .21285 L
s
.54903 .20565 m
.54903 .20565 L
s
.5491 .20461 m
.5491 .20461 L
s
.54917 .2005 m
.54917 .2005 L
s
.54925 .20359 m
.54925 .20359 L
s
.54932 .2005 m
.54932 .2005 L
s
.5494 .20256 m
.5494 .20256 L
s
.54947 .19741 m
.54947 .19741 L
s
.54955 .20771 m
.54955 .20771 L
s
.54962 .20771 m
.54962 .20771 L
s
.5497 .21182 m
.5497 .21182 L
s
.54977 .21903 m
.54977 .21903 L
s
.54985 .21491 m
.54985 .21491 L
s
.54991 .20873 m
.54991 .20873 L
s
.54999 .21285 m
.54999 .21285 L
s
.55006 .22314 m
.55006 .22314 L
s
.55014 .22109 m
.55014 .22109 L
s
.55021 .22623 m
.55021 .22623 L
s
.55029 .22006 m
.55029 .22006 L
s
.55037 .22521 m
.55037 .22521 L
s
.55044 .22109 m
.55044 .22109 L
s
.55052 .23035 m
.55052 .23035 L
s
.55059 .22314 m
.55059 .22314 L
s
.55066 .22933 m
.55066 .22933 L
s
.55073 .23138 m
.55073 .23138 L
s
.55081 .22726 m
.55081 .22726 L
s
.55088 .23344 m
.55088 .23344 L
s
.55096 .22933 m
.55096 .22933 L
s
.55103 .22933 m
.55103 .22933 L
s
.55111 .22109 m
.55111 .22109 L
s
.55118 .22418 m
.55118 .22418 L
s
.55126 .22212 m
.55126 .22212 L
s
.55133 .22623 m
.55133 .22623 L
s
.55141 .22212 m
.55141 .22212 L
s
.55148 .21491 m
.55148 .21491 L
s
.55155 .21388 m
.55155 .21388 L
s
.55162 .20771 m
.55162 .20771 L
s
.5517 .21388 m
.5517 .21388 L
s
.55177 .22109 m
.55177 .22109 L
s
.55185 .21594 m
.55185 .21594 L
s
.55193 .20359 m
.55193 .20359 L
s
.552 .20565 m
.552 .20565 L
s
.55207 .20565 m
.55207 .20565 L
s
.55215 .20771 m
.55215 .20771 L
s
.55223 .20565 m
.55223 .20565 L
s
.5523 .20256 m
.5523 .20256 L
s
.55237 .2005 m
.55237 .2005 L
s
.55244 .1902 m
.55244 .1902 L
s
.55252 .19741 m
.55252 .19741 L
s
.55259 .19329 m
.55259 .19329 L
s
.55267 .20461 m
.55267 .20461 L
s
.55274 .20256 m
.55274 .20256 L
s
.55282 .2005 m
.55282 .2005 L
s
.55289 .2005 m
.55289 .2005 L
s
.55297 .20461 m
.55297 .20461 L
s
.55304 .21182 m
.55304 .21182 L
s
.55311 .20873 m
.55311 .20873 L
s
.55318 .20668 m
.55318 .20668 L
s
.55326 .20771 m
.55326 .20771 L
s
.55333 .20976 m
.55333 .20976 L
s
.55341 .20976 m
.55341 .20976 L
s
.55349 .21388 m
.55349 .21388 L
s
.55356 .21697 m
.55356 .21697 L
s
.55363 .21594 m
.55363 .21594 L
s
.5537 .20771 m
.5537 .20771 L
s
.55378 .20976 m
.55378 .20976 L
s
.55386 .20565 m
.55386 .20565 L
s
.55393 .20565 m
.55393 .20565 L
s
.554 .20256 m
.554 .20256 L
s
.55408 .2005 m
.55408 .2005 L
s
.55415 .2005 m
.55415 .2005 L
s
.55423 .20359 m
.55423 .20359 L
s
.5543 .20461 m
.5543 .20461 L
s
.55438 .20873 m
.55438 .20873 L
s
.55445 .21285 m
.55445 .21285 L
s
.55452 .20359 m
.55452 .20359 L
s
.5546 .20565 m
.5546 .20565 L
s
.55468 .19844 m
.55468 .19844 L
s
.55474 .20153 m
.55474 .20153 L
s
.55482 .20153 m
.55482 .20153 L
s
.55489 .19844 m
.55489 .19844 L
s
.55497 .20153 m
.55497 .20153 L
s
.55505 .20359 m
.55505 .20359 L
s
.55512 .20668 m
.55512 .20668 L
s
.5552 .19638 m
.5552 .19638 L
s
.55527 .20359 m
.55527 .20359 L
s
.55534 .20256 m
.55534 .20256 L
s
.55541 .20153 m
.55541 .20153 L
s
.55549 .20256 m
.55549 .20256 L
s
.55556 .20461 m
.55556 .20461 L
s
.55564 .20565 m
.55564 .20565 L
s
.55571 .2005 m
.55571 .2005 L
s
.55579 .20359 m
.55579 .20359 L
s
.55586 .19638 m
.55586 .19638 L
s
.55594 .19844 m
.55594 .19844 L
s
.55601 .19638 m
.55601 .19638 L
s
.55608 .19947 m
.55608 .19947 L
s
.55615 .19432 m
.55615 .19432 L
s
.55623 .19432 m
.55623 .19432 L
s
.55631 .1902 m
.55631 .1902 L
s
.55638 .1902 m
.55638 .1902 L
s
.55645 .1902 m
.55645 .1902 L
s
.55653 .18712 m
.55653 .18712 L
s
.55661 .18608 m
.55661 .18608 L
s
.55668 .18403 m
.55668 .18403 L
s
.55676 .18917 m
.55676 .18917 L
s
.55683 .18506 m
.55683 .18506 L
s
.5569 .19432 m
.5569 .19432 L
s
.55697 .19227 m
.55697 .19227 L
s
.55705 .19329 m
.55705 .19329 L
s
.55712 .18917 m
.55712 .18917 L
s
.5572 .183 m
.5572 .183 L
s
.55727 .18197 m
.55727 .18197 L
s
.55735 .17682 m
.55735 .17682 L
s
.55742 .17476 m
.55742 .17476 L
s
.5575 .17271 m
.5575 .17271 L
s
.55757 .18506 m
.55757 .18506 L
s
.55765 .183 m
.55765 .183 L
s
.55771 .18712 m
.55771 .18712 L
s
.55779 .18815 m
.55779 .18815 L
s
.55786 .18815 m
.55786 .18815 L
s
.55794 .18506 m
.55794 .18506 L
s
.55801 .183 m
.55801 .183 L
s
.55809 .18197 m
.55809 .18197 L
s
.55817 .18815 m
.55817 .18815 L
s
.55824 .19227 m
.55824 .19227 L
s
.55832 .19741 m
.55832 .19741 L
s
.55839 .20153 m
.55839 .20153 L
s
.55846 .20256 m
.55846 .20256 L
s
.55853 .20771 m
.55853 .20771 L
s
.55861 .20873 m
.55861 .20873 L
s
.55868 .21491 m
.55868 .21491 L
s
.55876 .2108 m
.55876 .2108 L
s
.55883 .20461 m
.55883 .20461 L
s
.55891 .20873 m
.55891 .20873 L
s
.55898 .20461 m
.55898 .20461 L
s
.55906 .20668 m
.55906 .20668 L
s
.55913 .20565 m
.55913 .20565 L
s
.55921 .20359 m
.55921 .20359 L
s
.55928 .2005 m
.55928 .2005 L
s
.55935 .20565 m
.55935 .20565 L
s
.55942 .19947 m
.55942 .19947 L
s
.5595 .20461 m
.5595 .20461 L
s
.55957 .20668 m
.55957 .20668 L
s
.55965 .20668 m
.55965 .20668 L
s
.55973 .20873 m
.55973 .20873 L
s
.5598 .2005 m
.5598 .2005 L
s
.55988 .20256 m
.55988 .20256 L
s
.55995 .19227 m
.55995 .19227 L
s
.56003 .19432 m
.56003 .19432 L
s
.5601 .18712 m
.5601 .18712 L
s
.56017 .19329 m
.56017 .19329 L
s
.56024 .19432 m
.56024 .19432 L
s
.56032 .19638 m
.56032 .19638 L
s
.56039 .19227 m
.56039 .19227 L
s
.56047 .19124 m
.56047 .19124 L
s
.56054 .19638 m
.56054 .19638 L
s
.56062 .19947 m
.56062 .19947 L
s
.56069 .20461 m
.56069 .20461 L
s
.56077 .19947 m
.56077 .19947 L
s
.56084 .20461 m
.56084 .20461 L
s
.56091 .19947 m
.56091 .19947 L
s
.56098 .19844 m
.56098 .19844 L
s
.56106 .19227 m
.56106 .19227 L
s
.56113 .1902 m
.56113 .1902 L
s
.56121 .18403 m
.56121 .18403 L
s
.56129 .18403 m
.56129 .18403 L
s
.56136 .18403 m
.56136 .18403 L
s
.56143 .17374 m
.56143 .17374 L
s
.56151 .17374 m
.56151 .17374 L
s
.56159 .16755 m
.56159 .16755 L
s
.56166 .17167 m
.56166 .17167 L
s
.56173 .1655 m
.56173 .1655 L
s
.5618 .17064 m
.5618 .17064 L
s
.56188 .16138 m
.56188 .16138 L
s
.56195 .16241 m
.56195 .16241 L
s
.56203 .15932 m
.56203 .15932 L
s
.5621 .16653 m
.5621 .16653 L
s
.56218 .17167 m
.56218 .17167 L
s
.56225 .16962 m
.56225 .16962 L
s
.56232 .17682 m
.56232 .17682 L
s
.5624 .16962 m
.5624 .16962 L
s
.56248 .17167 m
.56248 .17167 L
s
.56254 .16962 m
.56254 .16962 L
s
.56262 .17064 m
.56262 .17064 L
s
.56269 .17064 m
.56269 .17064 L
s
.56277 .17271 m
.56277 .17271 L
s
.56285 .17374 m
.56285 .17374 L
s
.56292 .17682 m
.56292 .17682 L
s
.563 .17785 m
.563 .17785 L
s
.56307 .17682 m
.56307 .17682 L
s
.56314 .18094 m
.56314 .18094 L
s
.56322 .17888 m
.56322 .17888 L
s
.56329 .18197 m
.56329 .18197 L
s
.56336 .17888 m
.56336 .17888 L
s
.56344 .17682 m
.56344 .17682 L
s
.56351 .17271 m
.56351 .17271 L
s
.56359 .17579 m
.56359 .17579 L
s
.56366 .17785 m
.56366 .17785 L
s
.56374 .17167 m
.56374 .17167 L
s
.56381 .17579 m
.56381 .17579 L
s
.56388 .17374 m
.56388 .17374 L
s
.56395 .17991 m
.56395 .17991 L
s
.56403 .18608 m
.56403 .18608 L
s
.56411 .18608 m
.56411 .18608 L
s
.56418 .17888 m
.56418 .17888 L
s
.56425 .17888 m
.56425 .17888 L
s
.56433 .17476 m
.56433 .17476 L
s
.56441 .17167 m
.56441 .17167 L
s
.56448 .17991 m
.56448 .17991 L
s
.56456 .17785 m
.56456 .17785 L
s
.56463 .17785 m
.56463 .17785 L
s
.5647 .17476 m
.5647 .17476 L
s
.56477 .17682 m
.56477 .17682 L
s
.56485 .1655 m
.56485 .1655 L
s
.56493 .16755 m
.56493 .16755 L
s
.565 .16653 m
.565 .16653 L
s
.56507 .17374 m
.56507 .17374 L
s
.56515 .17785 m
.56515 .17785 L
s
.56522 .17064 m
.56522 .17064 L
s
.5653 .1655 m
.5653 .1655 L
s
.56537 .17064 m
.56537 .17064 L
s
.56545 .17682 m
.56545 .17682 L
s
.56551 .17167 m
.56551 .17167 L
s
.56559 .18094 m
.56559 .18094 L
s
.56566 .17682 m
.56566 .17682 L
s
.56574 .17682 m
.56574 .17682 L
s
.56581 .17374 m
.56581 .17374 L
s
.56589 .17064 m
.56589 .17064 L
s
.56597 .16962 m
.56597 .16962 L
s
.56604 .16138 m
.56604 .16138 L
s
.56612 .1655 m
.56612 .1655 L
s
.56619 .16241 m
.56619 .16241 L
s
.56626 .16344 m
.56626 .16344 L
s
.56633 .16653 m
.56633 .16653 L
s
.56641 .16653 m
.56641 .16653 L
s
.56648 .16344 m
.56648 .16344 L
s
.56656 .16859 m
.56656 .16859 L
s
.56663 .17476 m
.56663 .17476 L
s
.56671 .17785 m
.56671 .17785 L
s
.56678 .18197 m
.56678 .18197 L
s
.56686 .18506 m
.56686 .18506 L
s
.56693 .18403 m
.56693 .18403 L
s
.56701 .17476 m
.56701 .17476 L
s
.56708 .17167 m
.56708 .17167 L
s
.56715 .16859 m
.56715 .16859 L
s
.56722 .16755 m
.56722 .16755 L
s
.5673 .15829 m
.5673 .15829 L
s
.56737 .15829 m
.56737 .15829 L
s
.56745 .15314 m
.56745 .15314 L
s
.56753 .15314 m
.56753 .15314 L
s
.5676 .15211 m
.5676 .15211 L
s
.56768 .15521 m
.56768 .15521 L
s
.56775 .15521 m
.56775 .15521 L
s
.56783 .15109 m
.56783 .15109 L
s
.5679 .15829 m
.5679 .15829 L
s
.56797 .15521 m
.56797 .15521 L
s
.56804 .15314 m
.56804 .15314 L
s
.56812 .15109 m
.56812 .15109 L
s
.56819 .15521 m
.56819 .15521 L
s
.56827 .15211 m
.56827 .15211 L
s
.56834 .15932 m
.56834 .15932 L
s
.56842 .1655 m
.56842 .1655 L
s
.56849 .16241 m
.56849 .16241 L
s
.56857 .16755 m
.56857 .16755 L
s
.56864 .16138 m
.56864 .16138 L
s
.56871 .16344 m
.56871 .16344 L
s
.56878 .16138 m
.56878 .16138 L
s
.56886 .17579 m
.56886 .17579 L
s
.56893 .17167 m
.56893 .17167 L
s
.56901 .17271 m
.56901 .17271 L
s
.56909 .16859 m
.56909 .16859 L
s
.56916 .16962 m
.56916 .16962 L
s
.56923 .16859 m
.56923 .16859 L
s
.56931 .16653 m
.56931 .16653 L
s
.56939 .1655 m
.56939 .1655 L
s
.56946 .16241 m
.56946 .16241 L
s
.56953 .1655 m
.56953 .1655 L
s
.5696 .16859 m
.5696 .16859 L
s
.56968 .17064 m
.56968 .17064 L
s
.56975 .16962 m
.56975 .16962 L
s
.56983 .17374 m
.56983 .17374 L
s
.5699 .17271 m
.5699 .17271 L
s
.56998 .17167 m
.56998 .17167 L
s
.57005 .16755 m
.57005 .16755 L
s
.57013 .17064 m
.57013 .17064 L
s
.5702 .17167 m
.5702 .17167 L
s
.57028 .16653 m
.57028 .16653 L
s
.57034 .17271 m
.57034 .17271 L
s
.57042 .17167 m
.57042 .17167 L
s
.57049 .17785 m
.57049 .17785 L
s
.57057 .17682 m
.57057 .17682 L
s
.57065 .17888 m
.57065 .17888 L
s
.57072 .18197 m
.57072 .18197 L
s
.5708 .18608 m
.5708 .18608 L
s
.57087 .19124 m
.57087 .19124 L
s
.57094 .18917 m
.57094 .18917 L
s
.57102 .19638 m
.57102 .19638 L
s
.57109 .19329 m
.57109 .19329 L
s
.57116 .19535 m
.57116 .19535 L
s
.57124 .18917 m
.57124 .18917 L
s
.57131 .19535 m
.57131 .19535 L
s
.57139 .19638 m
.57139 .19638 L
s
.57146 .2005 m
.57146 .2005 L
s
.57154 .19329 m
.57154 .19329 L
s
.57161 .18815 m
.57161 .18815 L
s
.57168 .18712 m
.57168 .18712 L
s
.57176 .18815 m
.57176 .18815 L
s
.57184 .19227 m
.57184 .19227 L
s
.57191 .18917 m
.57191 .18917 L
s
.57198 .19535 m
.57198 .19535 L
s
.57205 .19432 m
.57205 .19432 L
s
.57213 .18815 m
.57213 .18815 L
s
.57221 .183 m
.57221 .183 L
s
.57228 .17991 m
.57228 .17991 L
s
.57236 .17785 m
.57236 .17785 L
s
.57243 .17271 m
.57243 .17271 L
s
.5725 .17374 m
.5725 .17374 L
s
.57257 .16344 m
.57257 .16344 L
s
.57265 .16962 m
.57265 .16962 L
s
.57273 .1655 m
.57273 .1655 L
s
.5728 .17888 m
.5728 .17888 L
s
.57287 .17271 m
.57287 .17271 L
s
.57295 .17785 m
.57295 .17785 L
s
.57302 .17785 m
.57302 .17785 L
s
.5731 .17167 m
.5731 .17167 L
s
.57317 .17785 m
.57317 .17785 L
s
.57325 .16962 m
.57325 .16962 L
s
.57331 .17579 m
.57331 .17579 L
s
.57339 .17271 m
.57339 .17271 L
s
.57347 .17271 m
.57347 .17271 L
s
.57354 .16962 m
.57354 .16962 L
s
.57361 .17167 m
.57361 .17167 L
s
.57369 .17167 m
.57369 .17167 L
s
.57377 .17579 m
.57377 .17579 L
s
.57384 .17167 m
.57384 .17167 L
s
.57392 .17579 m
.57392 .17579 L
s
.57399 .17476 m
.57399 .17476 L
s
.57406 .17579 m
.57406 .17579 L
s
.57413 .17888 m
.57413 .17888 L
s
.57421 .17579 m
.57421 .17579 L
s
.57428 .18712 m
.57428 .18712 L
s
.57436 .183 m
.57436 .183 L
s
.57443 .18608 m
.57443 .18608 L
s
.57451 .18506 m
.57451 .18506 L
s
.57458 .17991 m
.57458 .17991 L
s
.57466 .17991 m
.57466 .17991 L
s
.57473 .183 m
.57473 .183 L
s
.57481 .17888 m
.57481 .17888 L
s
.57488 .17682 m
.57488 .17682 L
s
.57495 .17888 m
.57495 .17888 L
s
.57502 .17888 m
.57502 .17888 L
s
.5751 .16755 m
.5751 .16755 L
s
.57517 .15829 m
.57517 .15829 L
s
.57525 .16344 m
.57525 .16344 L
s
.57533 .1655 m
.57533 .1655 L
s
.5754 .17374 m
.5754 .17374 L
s
.57548 .16962 m
.57548 .16962 L
s
.57555 .16962 m
.57555 .16962 L
s
.57563 .17064 m
.57563 .17064 L
s
.5757 .16755 m
.5757 .16755 L
s
.57577 .16653 m
.57577 .16653 L
s
.57584 .16138 m
.57584 .16138 L
s
.57592 .16653 m
.57592 .16653 L
s
.57599 .16138 m
.57599 .16138 L
s
.57607 .1655 m
.57607 .1655 L
s
.57614 .16447 m
.57614 .16447 L
s
.57622 .16755 m
.57622 .16755 L
s
.57629 .15932 m
.57629 .15932 L
s
.57637 .16241 m
.57637 .16241 L
s
.57644 .15829 m
.57644 .15829 L
s
.57651 .15932 m
.57651 .15932 L
s
.57658 .15623 m
.57658 .15623 L
s
.57666 .15418 m
.57666 .15418 L
s
.57673 .16035 m
.57673 .16035 L
s
.57681 .15211 m
.57681 .15211 L
s
.57689 .15521 m
.57689 .15521 L
s
.57696 .15314 m
.57696 .15314 L
s
.57704 .16138 m
.57704 .16138 L
s
.57711 .15932 m
.57711 .15932 L
s
.57719 .15418 m
.57719 .15418 L
s
.57726 .15623 m
.57726 .15623 L
s
.57733 .15623 m
.57733 .15623 L
s
.5774 .16653 m
.5774 .16653 L
s
.57748 .1655 m
.57748 .1655 L
s
.57755 .1655 m
.57755 .1655 L
s
.57763 .16138 m
.57763 .16138 L
s
.5777 .17064 m
.5777 .17064 L
s
.57778 .17167 m
.57778 .17167 L
s
.57785 .17374 m
.57785 .17374 L
s
.57793 .17682 m
.57793 .17682 L
s
.578 .17064 m
.578 .17064 L
s
.57808 .17682 m
.57808 .17682 L
s
.57814 .18094 m
.57814 .18094 L
s
.57822 .17991 m
.57822 .17991 L
s
.57829 .17682 m
.57829 .17682 L
s
.57837 .17682 m
.57837 .17682 L
s
.57845 .17785 m
.57845 .17785 L
s
.57852 .18506 m
.57852 .18506 L
s
.5786 .18712 m
.5786 .18712 L
s
.57867 .19124 m
.57867 .19124 L
s
.57874 .18608 m
.57874 .18608 L
s
.57882 .19638 m
.57882 .19638 L
s
.5789 .20565 m
.5789 .20565 L
s
.57896 .19535 m
.57896 .19535 L
s
.57904 .2005 m
.57904 .2005 L
s
.57911 .19535 m
.57911 .19535 L
s
.57919 .19844 m
.57919 .19844 L
s
.57926 .19227 m
.57926 .19227 L
s
.57934 .19947 m
.57934 .19947 L
s
.57941 .19638 m
.57941 .19638 L
s
.57948 .20153 m
.57948 .20153 L
s
.57956 .20359 m
.57956 .20359 L
s
.57964 .1902 m
.57964 .1902 L
s
.57971 .19227 m
.57971 .19227 L
s
.57978 .19535 m
.57978 .19535 L
s
.57985 .19124 m
.57985 .19124 L
s
.57993 .1902 m
.57993 .1902 L
s
.58001 .19329 m
.58001 .19329 L
s
.58008 .19227 m
.58008 .19227 L
s
.58016 .19844 m
.58016 .19844 L
s
.58023 .2005 m
.58023 .2005 L
s
.5803 .19947 m
.5803 .19947 L
s
.58038 .19844 m
.58038 .19844 L
s
.58045 .19227 m
.58045 .19227 L
s
.58053 .19638 m
.58053 .19638 L
s
.5806 .1902 m
.5806 .1902 L
s
.58067 .19638 m
.58067 .19638 L
s
.58075 .18608 m
.58075 .18608 L
s
.58082 .19535 m
.58082 .19535 L
s
.5809 .19535 m
.5809 .19535 L
s
.58097 .20256 m
.58097 .20256 L
s
.58105 .19432 m
.58105 .19432 L
s
.58111 .19227 m
.58111 .19227 L
s
.58119 .1902 m
.58119 .1902 L
s
.58127 .19227 m
.58127 .19227 L
s
.58134 .19227 m
.58134 .19227 L
s
.58141 .19432 m
.58141 .19432 L
s
.58149 .20153 m
.58149 .20153 L
s
.58157 .20256 m
.58157 .20256 L
s
.58164 .20461 m
.58164 .20461 L
s
.58172 .20461 m
.58172 .20461 L
s
.58179 .21491 m
.58179 .21491 L
s
.58187 .21594 m
.58187 .21594 L
s
.58193 .21388 m
.58193 .21388 L
s
.58201 .21285 m
.58201 .21285 L
s
.58209 .2108 m
.58209 .2108 L
s
.58216 .21491 m
.58216 .21491 L
s
.58223 .21285 m
.58223 .21285 L
s
.58231 .22006 m
.58231 .22006 L
s
.58238 .218 m
.58238 .218 L
s
.58246 .21903 m
.58246 .21903 L
s
.58253 .21697 m
.58253 .21697 L
s
.58261 .21285 m
.58261 .21285 L
s
.58268 .2108 m
.58268 .2108 L
s
.58275 .22521 m
.58275 .22521 L
s
.58282 .22829 m
.58282 .22829 L
s
.5829 .22521 m
.5829 .22521 L
s
.58297 .22726 m
.58297 .22726 L
s
.58305 .22314 m
.58305 .22314 L
s
.58313 .22314 m
.58313 .22314 L
s
.5832 .21697 m
.5832 .21697 L
s
.58328 .22314 m
.58328 .22314 L
s
.58335 .21697 m
.58335 .21697 L
s
.58343 .22418 m
.58343 .22418 L
s
.5835 .22521 m
.5835 .22521 L
s
.58357 .23344 m
.58357 .23344 L
s
.58364 .23344 m
.58364 .23344 L
s
.58372 .2355 m
.58372 .2355 L
s
.58379 .22829 m
.58379 .22829 L
s
.58387 .23447 m
.58387 .23447 L
s
.58394 .23653 m
.58394 .23653 L
s
.58402 .22933 m
.58402 .22933 L
s
.58409 .22933 m
.58409 .22933 L
s
.58417 .22726 m
.58417 .22726 L
s
.58424 .22933 m
.58424 .22933 L
s
.58431 .22418 m
.58431 .22418 L
s
.58438 .22726 m
.58438 .22726 L
s
.58446 .22726 m
.58446 .22726 L
s
.58453 .22623 m
.58453 .22623 L
s
.58461 .23035 m
.58461 .23035 L
s
.58469 .22418 m
.58469 .22418 L
s
.58476 .22623 m
.58476 .22623 L
s
.58484 .22212 m
.58484 .22212 L
s
.58491 .22212 m
.58491 .22212 L
s
.58499 .21697 m
.58499 .21697 L
s
.58506 .22829 m
.58506 .22829 L
s
.58513 .23241 m
.58513 .23241 L
s
.5852 .22109 m
.5852 .22109 L
s
.58528 .22521 m
.58528 .22521 L
s
.58535 .22314 m
.58535 .22314 L
s
.58543 .22829 m
.58543 .22829 L
s
.5855 .23241 m
.5855 .23241 L
s
.58558 .23756 m
.58558 .23756 L
s
.58565 .23035 m
.58565 .23035 L
s
.58573 .23447 m
.58573 .23447 L
s
.5858 .23035 m
.5858 .23035 L
s
.58588 .23138 m
.58588 .23138 L
s
.58594 .23344 m
.58594 .23344 L
s
.58602 .23756 m
.58602 .23756 L
s
.58609 .23962 m
.58609 .23962 L
s
.58617 .24065 m
.58617 .24065 L
s
.58625 .24167 m
.58625 .24167 L
s
.58632 .2355 m
.58632 .2355 L
s
.5864 .23756 m
.5864 .23756 L
s
.58647 .23035 m
.58647 .23035 L
s
.58655 .22933 m
.58655 .22933 L
s
.58662 .22314 m
.58662 .22314 L
s
.5867 .22726 m
.5867 .22726 L
s
.58676 .22314 m
.58676 .22314 L
s
.58684 .22006 m
.58684 .22006 L
s
.58691 .22521 m
.58691 .22521 L
s
.58699 .21903 m
.58699 .21903 L
s
.58706 .22521 m
.58706 .22521 L
s
.58714 .21594 m
.58714 .21594 L
s
.58721 .21182 m
.58721 .21182 L
s
.58728 .20771 m
.58728 .20771 L
s
.58736 .21285 m
.58736 .21285 L
s
.58744 .21697 m
.58744 .21697 L
s
.58751 .21594 m
.58751 .21594 L
s
.58758 .20976 m
.58758 .20976 L
s
.58765 .21491 m
.58765 .21491 L
s
.58773 .20771 m
.58773 .20771 L
s
.58781 .20873 m
.58781 .20873 L
s
.58788 .21491 m
.58788 .21491 L
s
.58796 .21697 m
.58796 .21697 L
s
.58803 .22212 m
.58803 .22212 L
s
.5881 .21903 m
.5881 .21903 L
s
.58818 .21903 m
.58818 .21903 L
s
.58826 .22314 m
.58826 .22314 L
s
.58833 .21903 m
.58833 .21903 L
s
.5884 .22521 m
.5884 .22521 L
s
.58847 .22418 m
.58847 .22418 L
s
.58855 .22933 m
.58855 .22933 L
s
.58862 .22521 m
.58862 .22521 L
s
.5887 .23138 m
.5887 .23138 L
s
.58877 .22521 m
.58877 .22521 L
s
.58885 .23344 m
.58885 .23344 L
s
.58892 .22109 m
.58892 .22109 L
s
.58899 .22212 m
.58899 .22212 L
s
.58907 .22212 m
.58907 .22212 L
s
.58914 .22829 m
.58914 .22829 L
s
.58921 .23138 m
.58921 .23138 L
s
.58929 .22933 m
.58929 .22933 L
s
.58937 .2355 m
.58937 .2355 L
s
.58944 .23035 m
.58944 .23035 L
s
.58952 .23138 m
.58952 .23138 L
s
.58959 .23344 m
.58959 .23344 L
s
.58967 .24786 m
.58967 .24786 L
s
.58973 .24682 m
.58973 .24682 L
s
.58981 .24682 m
.58981 .24682 L
s
.58989 .24167 m
.58989 .24167 L
s
.58996 .24167 m
.58996 .24167 L
s
.59003 .24271 m
.59003 .24271 L
s
.59011 .24167 m
.59011 .24167 L
s
.59018 .24579 m
.59018 .24579 L
s
.59026 .24579 m
.59026 .24579 L
s
.59033 .24888 m
.59033 .24888 L
s
.59041 .24786 m
.59041 .24786 L
s
.59048 .24786 m
.59048 .24786 L
s
.59055 .24786 m
.59055 .24786 L
s
.59063 .253 m
.59063 .253 L
s
.5907 .24991 m
.5907 .24991 L
s
.59078 .24991 m
.59078 .24991 L
s
.59085 .25094 m
.59085 .25094 L
s
.59093 .24579 m
.59093 .24579 L
s
.591 .24682 m
.591 .24682 L
s
.59108 .23859 m
.59108 .23859 L
s
.59115 .23962 m
.59115 .23962 L
s
.59123 .24991 m
.59123 .24991 L
s
.5913 .25712 m
.5913 .25712 L
s
.59137 .24991 m
.59137 .24991 L
s
.59144 .24477 m
.59144 .24477 L
s
.59152 .24888 m
.59152 .24888 L
s
.59159 .24991 m
.59159 .24991 L
s
.59167 .24786 m
.59167 .24786 L
s
.59174 .24579 m
.59174 .24579 L
s
.59182 .24888 m
.59182 .24888 L
s
.59189 .24271 m
.59189 .24271 L
s
.59197 .24991 m
.59197 .24991 L
s
.59204 .24374 m
.59204 .24374 L
s
.59211 