(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    101693,       2911]
NotebookOptionsPosition[     88216,       2486]
NotebookOutlinePosition[     93528,       2627]
CellTagsIndexPosition[     93079,       2608]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"scaled norm" :> 
         Documentation`HelpLookup["paclet:tutorial/NDSolveVectorNorm"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"scaled norm\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NDSolve`StateData", "Title",
 CellID->2067145919],

Cell[CellGroupData[{

Cell["Creating NDSolve`StateData Objects", "Section",
 CellTags->"c:1",
 CellID->1145816549],

Cell[CellGroupData[{

Cell["ProcessEquations", "Subsection",
 CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"},
 CellID->1805463009],

Cell[TextData[{
 "The first stage of any solution using ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is processing the equations specified into a form that can be efficiently \
accessed by the actual integration algorithms. This stage minimally involves \
determining the differential order of each variable, making substitutions \
needed to get a first-order system, solving for the time derivatives of the \
functions in terms of the functions, and forming the result into a ",
 StyleBox["NumericalFunction", "MR"],
 " object. If you want to save the time of repeating this process for the \
same set of equations or if you want more control over the numerical \
integration process, the processing stage can be executed separately with ",
 StyleBox["NDSolve`ProcessEquations", "MR"],
 "."
}], "Text",
 CellID->130707200],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{"NDSolve`ProcessEquations", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["eqn", "MR",
            FontSlant->"Italic"], "1"], ",", " ", 
          SubscriptBox[
           StyleBox[
            FormBox["eqn",
             TextForm], "MR",
            FontSlant->"Italic"], "2"], ",", " ", "..."}], "}"}], ",", " ", 
        StyleBox[
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["u", "MR",
             FontSlant->"Italic"], 
            StyleBox["1",
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontVariations->{"CompatibilityType"->0,
             "Masked"->False,
             "Outline"->False,
             "RotationAngle"->0,
             "Shadow"->False,
             "StrikeThrough"->False,
             "Underline"->False}]], ",", " ", 
           SubscriptBox[
            StyleBox["u", "MR",
             FontSlant->"Italic"], 
            StyleBox["2",
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontVariations->{"CompatibilityType"->0,
             "Masked"->False,
             "Outline"->False,
             "RotationAngle"->0,
             "Shadow"->False,
             "StrikeThrough"->False,
             "Underline"->False}]], ",", " ", "..."}], "}"}],
         FontSlant->"Italic"], ",", " ", 
        StyleBox["t",
         FontSlant->"Italic"]}], 
       StyleBox["]",
        FontSlant->"Italic"]}], "MR"], Cell[TextData[{
      "process the differential equations ",
      Cell[BoxData[
       StyleBox[
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["eqn", "MR",
            FontSlant->"Italic"], "1"], ",", " ", 
          SubscriptBox[
           StyleBox[
            FormBox["eqn",
             TextForm], "MR",
            FontSlant->"Italic"], "2"], ",", " ", "..."}], "}"}], "MR"]]],
      "for the functions ",
      Cell[BoxData[
       StyleBox[
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "MR",
            FontSlant->"Italic"], 
           StyleBox["1",
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            FontVariations->{"CompatibilityType"->0,
            "Masked"->False,
            "Outline"->False,
            "RotationAngle"->0,
            "Shadow"->False,
            "StrikeThrough"->False,
            "Underline"->False}]], ",", " ", 
          SubscriptBox[
           StyleBox["u", "MR",
            FontSlant->"Italic"], 
           StyleBox["2",
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            FontVariations->{"CompatibilityType"->0,
            "Masked"->False,
            "Outline"->False,
            "RotationAngle"->0,
            "Shadow"->False,
            "StrikeThrough"->False,
            "Underline"->False}]], ",", " ", "..."}], "}"}], "MR",
        FontSlant->"Italic"]]],
      "into a normal form; return a list of ",
      StyleBox["NDSolve`StateData", "MR"],
      " objects containing the solution and data associated with each \
solution for the time derivatives of the functions in terms of the functions; \
",
      StyleBox["t", "TI"],
      " may be specified in a list with a range of values as in ",
      StyleBox["NDSolve", "MR"]
     }], "Text"]},
    {
     RowBox[{
      StyleBox["NDSolve`ProcessEquations", "MR"], 
      StyleBox["[", "MR"], 
      RowBox[{
       StyleBox[
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["eqn", "MR",
            FontSlant->"Italic"], "1"], ",", " ", 
          SubscriptBox[
           StyleBox[
            FormBox["eqn",
             TextForm], "MR",
            FontSlant->"Italic"], "2"], ",", " ", "..."}], "}"}], "MR"], 
       StyleBox[",", "MR"], 
       StyleBox[" ", "MR"], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "MR",
            FontSlant->"Italic"], 
           StyleBox["1",
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            FontVariations->{"CompatibilityType"->0,
            "Masked"->False,
            "Outline"->False,
            "RotationAngle"->0,
            "Shadow"->False,
            "StrikeThrough"->False,
            "Underline"->False}]], ",", " ", 
          SubscriptBox[
           StyleBox["u", "MR",
            FontSlant->"Italic"], 
           StyleBox["2",
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            FontVariations->{"CompatibilityType"->0,
            "Masked"->False,
            "Outline"->False,
            "RotationAngle"->0,
            "Shadow"->False,
            "StrikeThrough"->False,
            "Underline"->False}]], ",", " ", "..."}], "}"}], "MR",
        FontSlant->"Italic"], 
       StyleBox[",", "MR"], 
       StyleBox[" ", "MR"], 
       RowBox[{
        StyleBox["{", "MR"], 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "MR",
           FontSlant->"Italic"], "1"], 
         StyleBox[",", "MR"], 
         StyleBox[" ", "MR"], 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "MR",
            FontSlant->"Italic"], "1"], 
          StyleBox["min", "MR",
           FontSlant->"Italic"]}], 
         StyleBox[",", "MR"], 
         StyleBox[" ", "MR"], 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "MR",
            FontSlant->"Italic"], "1"], 
          StyleBox["max", "MR",
           FontSlant->"Italic"]}]}], 
        StyleBox["}", "MR"]}], 
       StyleBox[",", "MR"], 
       StyleBox[" ", "MR"], 
       RowBox[{
        StyleBox["{", "MR"], 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "MR",
           FontSlant->"Italic"], "2"], 
         StyleBox[",", "MR"], 
         StyleBox[" ", "MR"], 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "MR",
            FontSlant->"Italic"], "2"], 
          StyleBox["min", "MR",
           FontSlant->"Italic"]}], 
         StyleBox[",", "MR"], 
         StyleBox[" ", "MR"], 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "MR",
            FontSlant->"Italic"], "2"], 
          StyleBox["max", "MR",
           FontSlant->"Italic"]}]}], 
        StyleBox["}", "MR",
         FontSlant->"Italic"]}], 
       StyleBox[",", "MR",
        FontSlant->"Italic"], 
       StyleBox[" ", "MR",
        FontSlant->"Italic"], 
       StyleBox["...", "MR",
        FontSlant->"Italic"]}], 
      StyleBox["]", "MR",
       FontSlant->"Italic"]}], Cell[TextData[{
      "process the partial differential equations ",
      Cell[BoxData[
       StyleBox[
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["eqn", "MR",
            FontSlant->"Italic"], "1"], ",", " ", 
          SubscriptBox[
           StyleBox[
            FormBox["eqn",
             TextForm], "MR",
            FontSlant->"Italic"], "2"], ",", " ", "..."}], "}"}], "MR"]]],
      "for the functions ",
      Cell[BoxData[
       StyleBox[
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "MR",
            FontSlant->"Italic"], "1"], ",", " ", 
          SubscriptBox[
           StyleBox["u", "MR",
            FontSlant->"Italic"], "2"], ",", " ", "..."}], "}"}], "MR",
        FontSlant->"Italic"]]],
      "into a normal form; return a list of ",
      StyleBox["NDSolve`StateData", "MR"],
      " objects containing the solution and data associated with each \
solution for the time derivatives of the functions in terms of the functions; \
if ",
      Cell[BoxData[
       FormBox[
        SubscriptBox["x", "j"], TraditionalForm]]],
      " is the temporal variable, it need not be specified with the \
boundaries ",
      Cell[BoxData[
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["x", "MR",
           FontSlant->"Italic"], "j"], 
         StyleBox["min", "MR",
          FontSlant->"Italic"]}], 
        StyleBox[",", "MR"], 
        StyleBox[" ", "MR"], 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "MR",
           FontSlant->"Italic"], "j"], 
         StyleBox["max", "MR",
          FontSlant->"Italic"]}]}]]]
     }], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellID->1453851528],

Cell[TextData[{
 "Processing equations for ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->1763655663],

Cell[TextData[{
 "This creates a list of two ",
 StyleBox["NDSolve`StateData", "MR"],
 " objects because there are two possible solutions for the ",
 StyleBox["y",
  FontSlant->"Italic"],
 "' in terms of ",
 StyleBox["y",
  FontSlant->"Italic"],
 "."
}], "MathCaption",
 CellID->511472398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve`ProcessEquations", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], " ", "\[Equal]", " ",
       
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], " ", "+", " ", "x"}]}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], "}"}], ",",
    "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367321040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"NDSolve`StateData", "[", 
     InterpretationBox[
      RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
       "\[InvisibleSpace]", "\<\">\"\>"}],
      SequenceForm["<", 0., ">"],
      Editable->False], "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"NDSolve`StateData", "[", 
     InterpretationBox[
      RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
       "\[InvisibleSpace]", "\<\">\"\>"}],
      SequenceForm["<", 0., ">"],
      Editable->False], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1744138074]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reinitialize", "Subsection",
 CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"},
 CellID->568926686],

Cell["\<\
It is not uncommon that the solution to a more sophisticated problem involves \
solving the same differential equation repeatedly, but with different initial \
conditions. In some cases, processing equations may be as time-consuming as \
numerically integrating the differential equations. In these situations, it \
is a significant advantage to be able to simply give new initial values.\
\>", "Text",
 CellID->2018038233],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["NDSolve`Reinitialize", "MR"], 
      StyleBox["[", "MR"], 
      RowBox[{
       StyleBox["state", "TI"], 
       StyleBox[",", "MR"], 
       StyleBox[" ", "MR"], 
       StyleBox["conditions", "TI"]}], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "assuming the equations and variables are the same as the ones used to \
create the ",
      StyleBox["NDSolve`StateData", "MR"],
      " object state, form a list of new ",
      StyleBox["NDSolve`StateData", "MR"],
      " objects, one for each of the possible solutions for the initial \
values of the functions of the equations ",
      StyleBox["conditions", "TI"]
     }], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellID->1847010470],

Cell["Reusing processed equations.", "Caption",
 CellID->1559317389],

Cell[TextData[{
 "This creates an ",
 StyleBox["NDSolve`StateData", "MR"],
 " object for the harmonic oscillator."
}], "MathCaption",
 CellID->133982286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"state", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve`ProcessEquations", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
         RowBox[{"x", "[", "t", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", 
       " ", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], 
      "}"}], ",", "x", ",", "t"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->274049713],

Cell[BoxData[
 TagBox[
  RowBox[{"NDSolve`StateData", "[", 
   InterpretationBox[
    RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
     "\[InvisibleSpace]", "\<\">\"\>"}],
    SequenceForm["<", 0., ">"],
    Editable->False], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2042816248]
}, Open  ]],

Cell[TextData[{
 "This creates three new ",
 StyleBox["NDSolve`StateData", "MR"],
 " objects, each with a different initial condition."
}], "MathCaption",
 CellID->856338147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newstate", " ", "=", " ", 
  RowBox[{"NDSolve`Reinitialize", "[", 
   RowBox[{"state", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], "^", "3"}], " ", "\[Equal]", " ", "1"}],
       ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "1", "]"}], " ", "\[Equal]", " ", "0"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1576087022],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1OwzAM9pqEsW5jEuOABIc+DZx4iGpC2g4INHaCCzx5SFqny1ynPxuT
YEultbXzOba/JG7TPeWb5fNLvlkt8uxxnb8tV4v37OF1bVRiAJBcAsDsFsy9
NnfFzx2p+QFIexaVHj7MKTFihldF2r8ObBeFV0G0n0TOGCvb2/cv4WjWyTYq
6XNkISW4OMyNdArElQ0SsbYHBXVWBVqOapaKWApPtkAkrDgcnxTnZN/jBZEd
JmGio1ja7mKMTEQmmBVDtb5sI/TyK+N2PvmWpv78dmDwY79nVekZdCW3oi74
KHm7IdEG4qR5SR2ulk6fuFgYu2HkPfJ+JrzXqxDLmqqiwZh4jgLZHjAmM9aP
auWe9l3lW7NqH23KwhbFMcjN5InmnwvTyG3k9h9ySyvNoOiX5exoI8D3Y7VW
OQ16kQGWVCOnnJXU3ttqh3qcar4OH3emRp7Ojaceu4uObPp7oW7VpGu9SrFn
bj+3b3Xr43+/ekkZp3Np1ILvM5Mj95H7U+G+e2Vq2OHtaIbIo9pt0bUvS9if
QO5pVKEvPuHRD6FplR4T+ZrI05jtyWZ76HwPr2iLp97njWjuawd9m9j1ThGT
ntmHxzrm9Rfz4mdr7QnlFgiuPAXbL0xOb88j1N1QewZ7r8s33zuPKXud4/VK
45o/E7/8/3xulqQ9JRj8AGuSZ3E=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{520, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->40067037]
}, Open  ]],

Cell[TextData[{
 "Using ",
 StyleBox["NDSolve`Reinitialize", "MR"],
 " may save computation time when you need to solve the same differential \
equation for many different initial conditions, as you might in a shooting \
method for boundary value problems."
}], "Text",
 CellID->1707616266],

Cell[TextData[{
 "A subset of ",
 StyleBox["NDSolve", "MR"],
 " options can be specified as options to ",
 StyleBox["NDSolve`Reinitialize", "MR"],
 "."
}], "Text",
 CellID->943409721],

Cell[TextData[{
 "This creates a new ",
 StyleBox["NDSolve`StateData", "MR"],
 " object, specifying a starting step size."
}], "MathCaption",
 CellID->105273539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newstate", " ", "=", " ", 
  RowBox[{"NDSolve`Reinitialize", "[", 
   RowBox[{"state", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], 
     "}"}], ",", " ", 
    RowBox[{"StartingStepSize", "\[Rule]", 
     RowBox[{"1", "/", "10"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->162204847],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"NDSolve`StateData", "[", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 0., ">"],
     Editable->False], "]"}],
   False,
   Editable->False], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->166948878]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Iterating Solutions", "Section",
 CellTags->{"c:4", "b:13", "ndsg:5.1"},
 CellID->1408385626],

Cell[TextData[{
 "One important use of ",
 StyleBox["NDSolve`StateData", "MR"],
 " objects is to have more control of the integration. For some problems, it \
is appropriate to check the solution and start over or change parameters \
depending on certain conditions."
}], "Text",
 CellID->1525198860],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["NDSolve`Iterate", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       RowBox[{"state", ",", " ", "t"}], "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "compute the solution of the differential equation in a ",
      StyleBox["NDSolve`StateData", "MR"],
      " object that has been assigned as the value of the variable ",
      StyleBox["state",
       FontSlant->"Italic"],
      " from the current time up to time ",
      StyleBox["t", "MR",
       FontSlant->"Italic"]
     }], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellID->48628243],

Cell["Iterating solutions to differential equations. ", "Caption",
 CellID->1906707359],

Cell[TextData[{
 "This creates an ",
 StyleBox["NDSolve`StateData", "MR"],
 " object that contains the information needed to solve the equation for an \
oscillator with a varying coefficient using an explicit Runge-Kutta method."
}], "MathCaption",
 CellID->451286613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"state", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve`ProcessEquations", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", " ", "+", " ", 
            RowBox[{"4", " ", 
             RowBox[{"UnitStep", "[", 
              RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}], 
          RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", " ", "0"}], ",", 
       " ", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
      "}"}], ",", "x", ",", "t", ",", " ", 
     RowBox[{"Method", "\[Rule]", "\"\<ExplicitRungeKutta\>\""}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->528006918],

Cell[BoxData[
 TagBox[
  RowBox[{"NDSolve`StateData", "[", 
   InterpretationBox[
    RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
     "\[InvisibleSpace]", "\<\">\"\>"}],
    SequenceForm["<", 0., ">"],
    Editable->False], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->604915837]
}, Open  ]],

Cell[TextData[{
 "Note that when you use ",
 StyleBox["NDSolve`ProcessEquations", "MR"],
 ", you do not need to give the range of the ",
 StyleBox["t",
  FontSlant->"Italic"],
 " variable explicitly because that information is not needed to set up the \
equations in a form ready to solve. (For PDEs, you do have to give the ranges \
of all spatial variables, however, since that information is essential for \
determining an appropriate discretization.)"
}], "Text",
 CellID->1058810558],

Cell[TextData[{
 "This computes the solution out to time ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = 1."
}], "MathCaption",
 CellID->741629634],

Cell[BoxData[
 RowBox[{"NDSolve`Iterate", "[", 
  RowBox[{"state", ",", " ", "1"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->411852762],

Cell[TextData[{
 StyleBox["NDSolve`Iterate", "MR"],
 " does not return a value because it modifies the ",
 StyleBox["NDSolve`StateData", "MR"],
 " object assigned to the variable state. Thus, the command affects the value \
of the variable in a manner similar to setting parts of a list, as described \
in \"",
 ButtonBox["Manipulating Lists by Their Indices",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices#32425"],
 "\". You can see that the value of ",
 StyleBox["state",
  FontSlant->"Italic"],
 " has changed since it now displays the current time to which it is \
integrated."
}], "Text",
 CellID->933147957],

Cell[TextData[{
 "The output form of ",
 StyleBox["state", "Text",
  FontSlant->"Italic"],
 " shows the range of times over which the solution has been integrated."
}], "MathCaption",
 CellID->661291906],

Cell[CellGroupData[{

Cell[BoxData["state"], "Input",
 CellLabel->"In[6]:=",
 CellID->1557669311],

Cell[BoxData[
 TagBox[
  RowBox[{"NDSolve`StateData", "[", 
   InterpretationBox[
    RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
     "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "1.`", 
     "\[InvisibleSpace]", "\<\">\"\>"}],
    SequenceForm["<", 0., ",", 1., ">"],
    Editable->False], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1180256086]
}, Open  ]],

Cell[TextData[{
 "If you want to integrate further, you can call ",
 StyleBox["NDSolve`Iterate", "MR"],
 " again, but with a larger value for time. "
}], "Text",
 CellID->791999106],

Cell[TextData[{
 "This computes the solution out to time ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = 3."
}], "MathCaption",
 CellID->864037192],

Cell[BoxData[
 RowBox[{"NDSolve`Iterate", "[", 
  RowBox[{"state", ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->207299333],

Cell["\<\
You can specify a time that is earlier than the first current time, in which \
case the integration proceeds backwards with respect to time.\
\>", "Text",
 CellID->1303471504],

Cell[TextData[{
 "This computes the solution from the initial condition backwards to ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = -",
 StyleBox["Pi/2",
  FontSlant->"Italic"],
 "."
}], "MathCaption",
 CellID->1231358232],

Cell[BoxData[
 RowBox[{"NDSolve`Iterate", "[", 
  RowBox[{"state", ",", " ", 
   RowBox[{
    RowBox[{"-", "Pi"}], "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1648635289],

Cell[TextData[{
 StyleBox["NDSolve`Iterate", "MR"],
 StyleBox[" allows you to specify intermediate times at which to stop.", 
  "MathCaption"],
 " ",
 StyleBox["This can be useful, for example, to avoid discontinuities.", 
  "MathCaption"],
 " ",
 StyleBox["Typically, this strategy is more effective with so-called one-step \
methods, such as the explicit Runge-Kutta method used in this example.", 
  "MathCaption"],
 " ",
 StyleBox["However, it generally works with the default ", "MathCaption"],
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 StyleBox[" method as well.", "MathCaption"]
}], "Text",
 CellID->1872398191],

Cell[TextData[{
 "This computes the solution out to ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = 10\[Pi], making sure that the solution does not have problems with the \
points of discontinuity in the coefficients at ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = \[Pi], 2 \[Pi], ...."
}], "MathCaption",
 CellID->1101912818],

Cell[BoxData[
 RowBox[{"NDSolve`Iterate", "[", 
  RowBox[{"state", ",", 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"Range", "[", "10", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1348162111]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting Solution Functions", "Section",
 CellTags->{"c:5", "b:14", "ndsg:5.2"},
 CellID->1284231932],

Cell[TextData[{
 "Once you have integrated a system up to a certain time, typically you want \
to be able to look at the current solution values and to generate an \
approximate function representing the solution computed so far. The command",
 " ",
 StyleBox["NDSolve`ProcessSolutions", "MR"],
 " allows you to do both."
}], "Text",
 CellID->1235895104],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["NDSolve`ProcessSolutions", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox["state", "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "give the solutions that have been computed in ",
      StyleBox["state",
       FontSlant->"Italic"],
      " as a list of rules with ",
      StyleBox["InterpolatingFunction", "MR"],
      " objects"
     }], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellID->1622211825],

Cell[TextData[{
 "Getting solutions as ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects. "
}], "Caption",
 CellID->728041182],

Cell[TextData[{
 "This extracts the solution computed in the previous section as an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object."
}], "MathCaption",
 CellID->2092233252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NDSolve`ProcessSolutions", "[", "state", "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1050815199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5707963267948966`"}], ",", "31.41592653589793`"}], 
        "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1315937581]
}, Open  ]],

Cell["This plots the solution.", "MathCaption",
 CellID->1652365870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], " ", "/.", " ", "sol"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", " ", 
     RowBox[{"10", " ", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->311717177],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->387069508]
}, Open  ]],

Cell[TextData[{
 "Just as when using ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " directly, there will be a rule for each function you specified in the \
second argument to ",
 StyleBox["NDSolve`ProcessEquations", "MR"],
 ". Only the specified components of the solutions are saved in such a way \
that an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object can be created."
}], "Text",
 CellID->1700994113],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["NDSolve`ProcessSolutions", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       RowBox[{"state", ",", " ", "dir"}], "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "give the solutions that have been most recently computed in direction \
",
      StyleBox["dir",
       FontSlant->"Italic"],
      " in ",
      StyleBox["state",
       FontSlant->"Italic"],
      " as a list of rules with values for both the functions and their \
derivatives"
     }], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellID->70940889],

Cell["Obtaining the current solution values.", "Caption",
 CellID->2059349822],

Cell["\<\
This gives the current solution values and derivatives in the forward \
direction.\
\>", "MathCaption",
 CellID->81517383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NDSolve`ProcessSolutions", "[", 
   RowBox[{"state", ",", "\"\<Forward\>\""}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->857264579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "31.41592653589793`", "]"}], "\[Rule]", 
    "0.843755291984822`"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "31.41592653589793`", "]"}], "\[Rule]", 
    RowBox[{"-", "1.2001604116281777`"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "31.41592653589793`", "]"}], "\[Rule]", 
    RowBox[{"-", "0.843755291984822`"}]}]}], "}"}]], "Output",
 ImageSize->{485, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->2097088476]
}, Open  ]],

Cell[TextData[{
 "The choices you can give for the direction ",
 StyleBox["dir",
  FontSlant->"Italic"],
 " are ",
 StyleBox["\"Forward\"", "MR"],
 " and ",
 StyleBox["\"Backward\"", "MR"],
 ", which refer to the integration forward and backward from the initial \
condition. "
}], "Text",
 CellID->823147017],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox["Forward", "MR"], Cell["\<\
integration in the direction of increasing values of the temporal variable \
\>", "Text"]},
    {
     StyleBox["Backward", "MR"], Cell["\<\
integration in the direction of decreasing values of the temporal variables\
\>", "Text"]},
    {
     StyleBox["Active", "MR"], Cell["\<\
integration in the direction that is currently being integrated; typically, \
this value should only be called from method initialization that is used \
during an active integration\
\>", "Text"]}
   }], TextForm]], "DefinitionBox",
 CellTags->"Integration directions",
 CellID->1269117341],

Cell["Integration direction specifications. ", "Caption",
 CellID->1903824689],

Cell[TextData[{
 "The output given by ",
 StyleBox["NDSolve`ProcessSolution", "MR"],
 " is always given in terms of the dependent variables, either at a specific \
value of the independent variable, or interpolated over all of the saved \
values. This means that when a partial differential equation is being \
integrated, you will get results representing the dependent variables over \
the spatial variables."
}], "Text",
 CellID->1484438923],

Cell[TextData[{
 "This computes the solution to the heat equation from time ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = -1/4 to ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = 2."
}], "MathCaption",
 CellID->679303005],

Cell[BoxData[{
 RowBox[{
  RowBox[{"state", " ", "=", " ", 
   RowBox[{"First", "[", 
    RowBox[{"NDSolve`ProcessEquations", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], " ", 
         "\[Equal]", " ", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}]}], 
        ",", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"0", ",", "x"}], "]"}], " ", "\[Equal]", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], " ", "x"}], "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "0"}], "]"}], " ", "\[Equal]", " ", "1"}], " ", 
        ",", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", " ", "1"}], "]"}], " ", "\[Equal]", " ", "0"}]}], 
       "}"}], ",", "u", ",", "t", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"NDSolve`Iterate", "[", 
  RowBox[{"state", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "4"}], ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[13]:=",
 CellID->347468359],

Cell[TextData[{
 "This gives the solution at ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = 2."
}], "MathCaption",
 CellID->128954382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve`ProcessSolutions", "[", 
  RowBox[{"state", ",", " ", "\"\<Forward\>\""}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1543340197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"2.`", ",", "x"}], "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"2.`", ",", "x"}], "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{388, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->2081964807]
}, Open  ]],

Cell[TextData[{
 "The solution is given as an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object that interpolates over the spatial variable ",
 StyleBox["x",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->1432425886],

Cell[TextData[{
 "This gives the solution at ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = -1/4."
}], "MathCaption",
 CellID->627214781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve`ProcessSolutions", "[", 
  RowBox[{"state", ",", " ", "\"\<Backward\>\""}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->55919334],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"eerr\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Warning: Scaled local spatial error \
estimate of \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(638.6378240455119`\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" at \
\\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(t\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" = \
\\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(-0.25`\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" in \
the direction of independent variable \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(x\\)\
\\!\\(\\*StyleBox[\\\"\\\\\\\" is much greater than prescribed error \
tolerance. Grid spacing with \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(15\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" points may be too \
large to achieve the desired accuracy or precision.  A singularity may have \
formed or you may want to specify a smaller grid spacing using the \
MaxStepSize or MinPoints method options.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NDSolve/eerr\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[16]:=",
 CellID->2026435548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{
      RowBox[{"-", "0.25`"}], ",", "x"}], "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{
      RowBox[{"-", "0.25`"}], ",", "x"}], "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{409, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->611317836]
}, Open  ]],

Cell[TextData[{
 "When you process the current solution for partial differential equations, \
the ",
 ButtonBox["spatial error estimate",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolvePDE#2081642391"],
 " is checked. (It is not generally checked except when solutions are \
produced because doing so would be quite time consuming.) Since it is \
excessive, the ",
 StyleBox["NDSolve::eerr", "MR"],
 " message is issued. The typical association of the word \"backward\" with \
the heat equation as implying instability should gives a clue to what is \
wrong in this example. "
}], "Text",
 CellID->1404081445],

Cell[TextData[{
 "Here is a plot of the solution at ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = 1/4"
}], "MathCaption",
 CellID->294088714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{
       RowBox[{"-", "0.25"}], ",", " ", "x"}], "]"}], " ", "/.", " ", "%"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->817539056],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->221762371]
}, Open  ]],

Cell["\<\
The plot of the solution shows that instability is indeed the problem. \
\>", "Text",
 CellID->1022129896],

Cell[TextData[{
 "Even though the heat equation example is simple enough to know that the \
solution backward in time is problematic, using ",
 StyleBox["NDSolve`Iterate", "MR"],
 " and ",
 StyleBox["NDSolve`ProcessSolutions", "MR"],
 " to monitor the solution of a PDE can be used to save computing a solution \
which turns out not to be as accurate as desired. Another simple form of \
monitoring follows."
}], "Text",
 CellID->762288660],

Cell["\<\
Entering the following commands generates a sequence of plots showing the \
solution of a generalization of the sine-Gordon equation as it is being \
computed. \
\>", "MathCaption",
 CellID->1929624822],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", " ", "=", 
   RowBox[{"-", "10"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"state", " ", "=", " ", 
   RowBox[{"First", "[", 
    RowBox[{"NDSolve`ProcessEquations", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t", ",", "t"}], 
          "]"}], " ", "\[Equal]", " ", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x", ",", "x"}], 
           "]"}], " ", "+", " ", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y", ",", "y"}], 
           "]"}], " ", "-", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"0", ",", "x", ",", "y"}], "]"}], " ", "\[Equal]", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", 
            RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "u", "]"}], "[", 
          RowBox[{"0", ",", "x", ",", "y"}], "]"}], " ", "\[Equal]", " ", 
         "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", 
           RowBox[{"-", "L"}], ",", "y"}], "]"}], " ", "\[Equal]", " ", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "L", ",", " ", "y"}], "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", 
           RowBox[{"-", "L"}]}], "]"}], " ", "\[Equal]", " ", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "L"}], "]"}]}]}], "}"}], ",", "u", ",", 
      "t", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "L"}], ",", "L"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "L"}], ",", "L"}], "}"}], ",", " ", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
         RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
            RowBox[{
            "\"\<DifferenceOrder\>\"", "->", "\"\<Pseudospectral\>\""}]}], 
           "}"}]}]}], "}"}]}]}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"NDSolve`Iterate", "[", 
        RowBox[{"state", ",", " ", "\[Tau]"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot3D", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"\[Tau]", ",", " ", "x", ",", " ", "y"}], "]"}], " ", "/.",
            " ", 
           RowBox[{"NDSolve`ProcessSolutions", "[", 
            RowBox[{"state", ",", " ", "\"\<Forward\>\""}], "]"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "L"}], ",", "L"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "L"}], ",", "L"}], "}"}], ",", " ", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "/", "4"}], ",", 
            RowBox[{"1", "/", "4"}]}], "}"}]}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"\[Tau]", ",", " ", "0.", ",", " ", "20.", ",", "5."}], 
       "}"}]}], "]"}], ",", "2"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[58]:=",
 CellID->1104994245],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->478474889]
}, Open  ]],

Cell[TextData[{
 "When you monitor a solution in this way, it is usually possible to \
interrupt the computation if you see that the solution found is sufficient. \
You can still use the ",
 StyleBox["NDSolve`StateData", "MR"],
 " object to get the solutions that have been computed."
}], "Text",
 CellID->267170882]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`StateData Methods", "Section",
 CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"},
 CellID->93858351],

Cell[TextData[{
 "An ",
 StyleBox["NDSolve`StateData", "MR"],
 " object contains a lot of information, but it is arranged in a manner which \
makes it easy to iterate solutions, and not in a manner which makes it easy \
to understand where the information is kept. However, sometimes you will want \
to get information from the state data object: for this reason several method \
functions have been defined to make accessing the information easy."
}], "Text",
 CellID->565573805],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"TemporalVariable\"", "MR"]
     }]], 
     RowBox[{
     "give", " ", "the", " ", "independent", " ", "variable", " ", "that", 
      " ", "the", " ", "dependent", " ", "variables", " ", 
      RowBox[{"(", "functions", ")"}], " ", "depend", " ", "on"}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"DependentVariables\"", "MR"]
     }]], 
     RowBox[{
     "give", " ", "a", " ", "list", " ", "of", " ", "the", " ", "dependent", 
      " ", "variables", " ", 
      RowBox[{"(", "functions", ")"}], " ", "to", " ", "be", " ", "solved", 
      " ", "for"}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"VariableDimensions\"", "MR"]
     }]], 
     RowBox[{
     "give", " ", "the", " ", "dimensions", " ", "of", " ", "each", " ", "of",
       " ", "the", " ", "dependent", " ", "variables", " ", 
      RowBox[{"(", "functions", ")"}]}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"VariablePositions\"", "MR"]
     }]], 
     RowBox[{
     "give", " ", "the", " ", "positions", " ", "in", " ", "the", " ", 
      "solution", " ", "vector", " ", "for", " ", "each", " ", "of", " ", 
      "the", " ", "dependent", " ", "variables"}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"VariableTransformation\"", "MR"]
     }]], 
     RowBox[{
     "give", " ", "the", " ", "transformation", " ", "of", " ", "variables", 
      " ", "from", " ", "the", " ", "original", " ", "problem", " ", 
      "variables", " ", "to", " ", "the", " ", "working", " ", 
      "variables"}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"NumericalFunction\"", "MR"]
     }]], Cell[TextData[{
      "give the ",
      StyleBox["NumericalFunction", "MR"],
      " object used to evaluate the derivatives of the solution vector with \
respect to the temporal variable"
     }]]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"ProcessExpression\"[", "MR"],
      StyleBox["args", "MR",
       FontSlant->"Italic"],
      StyleBox[", ", "MR"],
      StyleBox["expr", "MR",
       FontSlant->"Italic"],
      StyleBox[", ", "MR"],
      StyleBox["dims", "MR",
       FontSlant->"Italic"],
      StyleBox["]", "MR"]
     }]], Cell[TextData[{
      "process the expression ",
      StyleBox["expr", "MR",
       FontSlant->"Italic"],
      " using the same variable transformations that ",
      StyleBox["NDSolve", "MR"],
      " used to generate ",
      StyleBox["state",
       FontSlant->"Italic"],
      " to give a ",
      StyleBox["NumericalFunction", "MR"],
      " object for numerically evaluating ",
      StyleBox["expr", "MR",
       FontSlant->"Italic"],
      "; ",
      StyleBox["args", "MR",
       FontSlant->"Italic"],
      " is the arguments for the numerical function and should either be ",
      StyleBox["All", "MR"],
      " or a list of arguments that are dependent variables of the system; ",
      StyleBox["dims", "MR",
       FontSlant->"Italic"],
      " should be ",
      StyleBox["Automatic", "MR"],
      " or an explicit list giving the expected dimensions of the numerical \
function result"
     }]]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"SystemSize\"", "MR"]
     }]], Cell["\<\
give the effective number of first-order ordinary differential equations \
being solved\
\>"]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"MaxSteps\"", "MR"]
     }]], 
     RowBox[{
     "give", " ", "the", " ", "maximum", " ", "number", " ", "of", " ", 
      "steps", " ", "allowed", " ", "for", " ", "iterating", " ", "the", " ", 
      "differential", " ", "equations"}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"WorkingPrecision\"", "MR"]
     }]], 
     RowBox[{
     "give", " ", "the", " ", "working", " ", "precision", " ", "used", " ", 
      "to", " ", "solve", " ", "the", " ", "equations"}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"Norm\"", "MR"]
     }]], Cell[TextData[{
      "the ",
      ButtonBox["scaled norm",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/NDSolveVectorNorm"],
      " to use for guaging error"
     }]]}
   }], TextForm]], "DefinitionBox",
 CellID->1968164995],

Cell[TextData[{
 "General method functions for an ",
 StyleBox["NDSolve`StateData", "MR"],
 " object ",
 StyleBox["state", "TI"],
 "."
}], "Caption",
 CellID->164799240],

Cell[TextData[{
 "Much of the available information depends on the current solution values. \
Each ",
 StyleBox["NDSolve`StateData", "MR"],
 " object keeps solution information for solutions in both the forward and \
backward direction. At the initial condition these are the same, but once the \
problem has been iterated in either direction, these will be different."
}], "Text",
 CellID->477439979],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"CurrentTime\"[", "MR"],
      StyleBox["dir",
       FontSlant->"Italic"],
      StyleBox["]", "MR"]
     }]], Cell[TextData[{
      "give the current value of the temporal variable in the integration \
direction ",
      StyleBox["dir", "TI"]
     }]]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"SolutionVector\"[", "MR"],
      StyleBox["dir",
       FontSlant->"Italic"],
      StyleBox["]", "MR"]
     }]], 
     RowBox[{
     "give", " ", "the", " ", "current", " ", "value", " ", "of", " ", "the", 
      " ", "solution", " ", "vector", " ", "in", " ", "the", " ", 
      "integration", " ", "direction", " ", 
      StyleBox["dir", "TI"]}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"SolutionDerivativeVector\"[", "MR"],
      StyleBox["dir",
       FontSlant->"Italic"],
      StyleBox["]", "MR"]
     }]], Cell[TextData[{
      "give the current value of the derivative with respect to the temporal \
variable of the solution vector in the integration direction ",
      StyleBox["dir", "TI"]
     }]]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"TimeStep\"[", "MR"],
      StyleBox["dir",
       FontSlant->"Italic"],
      StyleBox["]", "MR"]
     }]], 
     RowBox[{
     "give", " ", "the", " ", "time", " ", "step", " ", "size", " ", "for", 
      " ", "the", " ", "next", " ", "step", " ", "in", " ", "the", " ", 
      "integration", " ", "direction", " ", 
      StyleBox["dir", "TI"]}]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"TimeStepsUsed\"[", "MR"],
      StyleBox["dir",
       FontSlant->"Italic"],
      StyleBox["]", "MR"]
     }]], Cell[TextData[{
      "give the number of time steps used to get to the current time in the \
integration direction ",
      StyleBox["dir", "TI"]
     }]]},
    {Cell[TextData[{
      StyleBox["state",
       FontSlant->"Italic"],
      StyleBox["@\"MethodData\"[", "MR"],
      StyleBox["dir",
       FontSlant->"Italic"],
      StyleBox["]", "MR"]
     }]], Cell[TextData[{
      "give the method data object used in the integration direction ",
      StyleBox["dir", "TI"]
     }]]}
   }], TextForm]], "DefinitionBox",
 CellID->2049682378],

Cell[TextData[{
 "Directional method functions for an ",
 StyleBox["NDSolve`StateData", "MR"],
 " object ",
 StyleBox["state", "TI"],
 "."
}], "Caption",
 CellID->1022063819],

Cell[TextData[{
 "If the direction argument is omitted, the functions will return a list with \
the data for both directions (a list with a single element at the initial \
condition).",
 " ",
 "Otherwise, the direction can be ",
 StyleBox["Forward", "MR"],
 ", ",
 StyleBox["Backward", "MR"],
 ", or ",
 StyleBox["Active", "MR"],
 " as ",
 ButtonBox["specified",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveStateData#1269117341"],
 " in the previous subsection."
}], "Text",
 CellID->1448116711],

Cell[TextData[{
 "Here is an ",
 StyleBox["NDSolve`StateData", "MR"],
 " object for a solution of the nonlinear Schrodinger equation that has been \
computed up to ",
 StyleBox["t",
  FontSlant->"Italic"],
 " = 1."
}], "MathCaption",
 CellID->725345747],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"state", " ", "=", " ", 
   RowBox[{"First", "[", 
    RowBox[{"NDSolve`ProcessEquations", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"I", " ", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}]}], " ", 
         "\[Equal]", " ", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}], " ",
           "+", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{"u", "[", 
              RowBox[{"t", ",", "x"}], "]"}], "]"}], "^", "2"}], "  ", 
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}]}]}]}], ",", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"0", ",", "x"}], "]"}], " ", "\[Equal]", " ", 
         RowBox[{
          RowBox[{"Sech", "[", "x", "]"}], " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[Pi]", " ", "I", " ", "x"}], "]"}]}]}], ",", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", 
           RowBox[{"-", "15"}]}], "]"}], " ", "\[Equal]", " ", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "15"}], "]"}]}]}], "}"}], ",", "u", ",", "t", ",",
       
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", " ", 
      RowBox[{"Method", "\[Rule]", "StiffnessSwitching"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"NDSolve`Iterate", "[", 
   RowBox[{"state", ",", " ", "1"}], "]"}], ";"}], "\n", "state"}], "Input",
 CellLabel->"In[24]:=",
 CellID->143697513],

Cell[BoxData[
 TagBox[
  RowBox[{"NDSolve`StateData", "[", 
   InterpretationBox[
    RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
     "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "1.`", 
     "\[InvisibleSpace]", "\<\">\"\>"}],
    SequenceForm["<", 0., ",", 1., ">"],
    Editable->False], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->235494843]
}, Open  ]],

Cell["\<\
\[OpenCurlyDoubleQuote]Current\[CloseCurlyDoubleQuote] refers to the most \
recent point reached in the integration. \
\>", "Text",
 CellID->62301023],

Cell["\<\
This gives the current time in both the forward and backward directions.\
\>", "MathCaption",
 CellID->823000518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"state", "@", "\"\<CurrentTime\>\""}]], "Input",
 CellLabel->"In[27]:=",
 CellID->1551926111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->1420630176]
}, Open  ]],

Cell["\<\
This gives the size of the system of ordinary differential equations being \
solved.\
\>", "MathCaption",
 CellID->218857067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"state", "@", "\"\<SystemSize\>\""}]], "Input",
 CellLabel->"In[28]:=",
 CellID->2106693804],

Cell[BoxData["400"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->1232677424]
}, Open  ]],

Cell[TextData[{
 "The method functions are relatively low-level hooks into the data \
structure, they do little processing on the data returned to you. Thus, \
unlike ",
 StyleBox["NDSolve`ProcessSolutions", "MR"],
 ", the solutions given are simply vectors of data points relating to the \
system of ordinary differential equations ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is solving."
}], "Text",
 CellID->846071848],

Cell["\<\
This makes a plot of the modulus of current solution in the forward \
direction.\
\>", "MathCaption",
 CellID->15129490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"state", "@", 
    RowBox[{"SolutionVector", "[", "\"\<Forward\>\"", "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->633538073],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->443416914]
}, Open  ]],

Cell[TextData[{
 "This plot does not show the correspondence with the x-grid values \
correctly. To get the correspondence with the spatial grid correctly, you \
must use ",
 StyleBox["NDSolve`ProcessSolutions", "MR"],
 ". "
}], "Text",
 CellID->1419210935],

Cell["\<\
There is a tremendous amount of control provided by these methods, but an \
exhaustive set of examples is beyond the scope of this documentation.\
\>", "Text",
 CellID->927626787],

Cell[TextData[{
 "One of the most important uses of the information from an ",
 StyleBox["NDSolve`StateData", "MR"],
 " object is to initialize integration methods. Examples are shown in \"",
 ButtonBox["The NDSolve Method Plug-in Framework\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolvePlugIns"],
 "."
}], "Text",
 CellID->1245254856]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve`StateData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 40, 23.1190848}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The first stage of any solution using NDSolve is processing the \
equations specified into a form that can be efficiently accessed by the \
actual integration algorithms. This stage minimally involves determining the \
differential order of each variable, making substitutions needed to get a \
first-order system, solving for the time derivatives of the functions in \
terms of the functions, and forming the result into a NumericalFunction \
object. If you want to save the time of repeating this process for the same \
set of equations or if you want more control over the numerical integration \
process, the processing stage can be executed separately with \
NDSolve`ProcessEquations. process the differential equations {eqn_1, eqn_2, \
...}for the functions {u_1, u_2, ...}into a normal form; return a list of \
NDSolve`StateData objects containing the solution and data associated with \
each solution for the time derivatives of the functions in terms of the \
functions; t may be specified in a list with a range of values as in NDSolve \
process the partial differential equations {eqn_1, eqn_2, ...}for the \
functions {u_1, u_2, ...}into a normal form; return a list of \
NDSolve`StateData objects containing the solution and data associated with \
each solution for the time derivatives of the functions in terms of the \
functions; if x_j is the temporal variable, it need not be specified with the \
boundaries x_jmin, x_jmax", "synonyms" -> {}, "title" -> "NDSolve`StateData", 
    "type" -> "Tutorial", "uri" -> "tutorial/NDSolveStateData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:1"->{
  Cell[1286, 47, 92, 2, 70, "Section",
   CellTags->"c:1",
   CellID->1145816549]},
 "c:2"->{
  Cell[1403, 53, 103, 2, 70, "Subsection",
   CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"},
   CellID->1805463009]},
 "b:12.0"->{
  Cell[1403, 53, 103, 2, 70, "Subsection",
   CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"},
   CellID->1805463009]},
 "ndsg:5.0.0"->{
  Cell[1403, 53, 103, 2, 70, "Subsection",
   CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"},
   CellID->1805463009]},
 "c:3"->{
  Cell[12818, 423, 98, 2, 70, "Subsection",
   CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"},
   CellID->568926686]},
 "b:12.1"->{
  Cell[12818, 423, 98, 2, 70, "Subsection",
   CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"},
   CellID->568926686]},
 "ndsg:5.0.1"->{
  Cell[12818, 423, 98, 2, 70, "Subsection",
   CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"},
   CellID->568926686]},
 "c:4"->{
  Cell[18753, 625, 99, 2, 70, "Section",
   CellTags->{"c:4", "b:13", "ndsg:5.1"},
   CellID->1408385626]},
 "b:13"->{
  Cell[18753, 625, 99, 2, 70, "Section",
   CellTags->{"c:4", "b:13", "ndsg:5.1"},
   CellID->1408385626]},
 "ndsg:5.1"->{
  Cell[18753, 625, 99, 2, 70, "Section",
   CellTags->{"c:4", "b:13", "ndsg:5.1"},
   CellID->1408385626]},
 "c:5"->{
  Cell[26179, 886, 106, 2, 70, "Section",
   CellTags->{"c:5", "b:14", "ndsg:5.2"},
   CellID->1284231932],
  Cell[70721, 1955, 119, 2, 70, "Section",
   CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"},
   CellID->93858351]},
 "b:14"->{
  Cell[26179, 886, 106, 2, 70, "Section",
   CellTags->{"c:5", "b:14", "ndsg:5.2"},
   CellID->1284231932],
  Cell[70721, 1955, 119, 2, 70, "Section",
   CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"},
   CellID->93858351]},
 "ndsg:5.2"->{
  Cell[26179, 886, 106, 2, 70, "Section",
   CellTags->{"c:5", "b:14", "ndsg:5.2"},
   CellID->1284231932],
  Cell[70721, 1955, 119, 2, 70, "Section",
   CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"},
   CellID->93858351]},
 "Integration directions"->{
  Cell[40647, 1236, 651, 18, 70, "DefinitionBox",
   CellTags->"Integration directions",
   CellID->1269117341]},
 "statemethods"->{
  Cell[70721, 1955, 119, 2, 70, "Section",
   CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"},
   CellID->93858351]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:1", 90830, 2536},
 {"c:2", 90924, 2540},
 {"b:12.0", 91051, 2544},
 {"ndsg:5.0.0", 91182, 2548},
 {"c:3", 91306, 2552},
 {"b:12.1", 91433, 2556},
 {"ndsg:5.0.1", 91564, 2560},
 {"c:4", 91688, 2564},
 {"b:13", 91807, 2568},
 {"ndsg:5.1", 91930, 2572},
 {"c:5", 92048, 2576},
 {"b:14", 92291, 2583},
 {"ndsg:5.2", 92538, 2590},
 {"Integration directions", 92799, 2597},
 {"statemethods", 92932, 2601}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 581, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1206, 42, 55, 1, 70, "Title",
 CellID->2067145919],
Cell[CellGroupData[{
Cell[1286, 47, 92, 2, 70, "Section",
 CellTags->"c:1",
 CellID->1145816549],
Cell[CellGroupData[{
Cell[1403, 53, 103, 2, 70, "Subsection",
 CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"},
 CellID->1805463009],
Cell[1509, 57, 901, 18, 70, "Text",
 CellID->130707200],
Cell[2413, 77, 8601, 270, 70, "DefinitionBox",
 CellID->1453851528],
Cell[11017, 349, 203, 8, 70, "Caption",
 CellID->1763655663],
Cell[11223, 359, 289, 11, 70, "MathCaption",
 CellID->511472398],
Cell[CellGroupData[{
Cell[11537, 374, 490, 16, 28, "Input",
 CellID->367321040],
Cell[12030, 392, 739, 25, 36, "Output",
 CellID->1744138074]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12818, 423, 98, 2, 70, "Subsection",
 CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"},
 CellID->568926686],
Cell[12919, 427, 433, 7, 70, "Text",
 CellID->2018038233],
Cell[13355, 436, 769, 22, 70, "DefinitionBox",
 CellID->1847010470],
Cell[14127, 460, 68, 1, 70, "Caption",
 CellID->1559317389],
Cell[14198, 463, 153, 5, 70, "MathCaption",
 CellID->133982286],
Cell[CellGroupData[{
Cell[14376, 472, 677, 20, 70, "Input",
 CellID->274049713],
Cell[15056, 494, 409, 14, 36, "Output",
 CellID->2042816248]
}, Open  ]],
Cell[15480, 511, 174, 5, 70, "MathCaption",
 CellID->856338147],
Cell[CellGroupData[{
Cell[15679, 520, 466, 15, 28, "Input",
 CellID->1576087022],
Cell[16148, 537, 910, 19, 36, "Output",
 Evaluatable->False,
 CellID->40067037]
}, Open  ]],
Cell[17073, 559, 290, 7, 70, "Text",
 CellID->1707616266],
Cell[17366, 568, 183, 7, 70, "Text",
 CellID->943409721],
Cell[17552, 577, 161, 5, 70, "MathCaption",
 CellID->105273539],
Cell[CellGroupData[{
Cell[17738, 586, 512, 15, 70, "Input",
 CellID->162204847],
Cell[18253, 603, 439, 15, 36, "Output",
 CellID->166948878]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18753, 625, 99, 2, 70, "Section",
 CellTags->{"c:4", "b:13", "ndsg:5.1"},
 CellID->1408385626],
Cell[18855, 629, 300, 7, 70, "Text",
 CellID->1525198860],
Cell[19158, 638, 634, 19, 70, "DefinitionBox",
 CellID->48628243],
Cell[19795, 659, 87, 1, 70, "Caption",
 CellID->1906707359],
Cell[19885, 662, 268, 6, 70, "MathCaption",
 CellID->451286613],
Cell[CellGroupData[{
Cell[20178, 672, 978, 28, 70, "Input",
 CellID->528006918],
Cell[21159, 702, 408, 14, 36, "Output",
 CellID->604915837]
}, Open  ]],
Cell[21582, 719, 488, 11, 70, "Text",
 CellID->1058810558],
Cell[22073, 732, 146, 6, 70, "MathCaption",
 CellID->741629634],
Cell[22222, 740, 143, 4, 70, "Input",
 CellID->411852762],
Cell[22368, 746, 651, 16, 70, "Text",
 CellID->933147957],
Cell[23022, 764, 203, 6, 70, "MathCaption",
 CellID->661291906],
Cell[CellGroupData[{
Cell[23250, 774, 75, 2, 70, "Input",
 CellID->1557669311],
Cell[23328, 778, 486, 15, 36, "Output",
 CellID->1180256086]
}, Open  ]],
Cell[23829, 796, 181, 5, 70, "Text",
 CellID->791999106],
Cell[24013, 803, 146, 6, 70, "MathCaption",
 CellID->864037192],
Cell[24162, 811, 143, 4, 70, "Input",
 CellID->207299333],
Cell[24308, 817, 185, 4, 70, "Text",
 CellID->1303471504],
Cell[24496, 823, 222, 9, 70, "MathCaption",
 CellID->1231358232],
Cell[24721, 834, 189, 6, 70, "Input",
 CellID->1648635289],
Cell[24913, 842, 694, 19, 70, "Text",
 CellID->1872398191],
Cell[25610, 863, 327, 10, 70, "MathCaption",
 CellID->1101912818],
Cell[25940, 875, 202, 6, 70, "Input",
 CellID->1348162111]
}, Open  ]],
Cell[CellGroupData[{
Cell[26179, 886, 106, 2, 70, "Section",
 CellTags->{"c:5", "b:14", "ndsg:5.2"},
 CellID->1284231932],
Cell[26288, 890, 354, 8, 70, "Text",
 CellID->1235895104],
Cell[26645, 900, 491, 16, 70, "DefinitionBox",
 CellID->1622211825],
Cell[27139, 918, 235, 8, 70, "Caption",
 CellID->728041182],
Cell[27377, 928, 283, 8, 70, "MathCaption",
 CellID->2092233252],
Cell[CellGroupData[{
Cell[27685, 940, 161, 4, 70, "Input",
 CellID->1050815199],
Cell[27849, 946, 494, 17, 36, "Output",
 CellID->1315937581]
}, Open  ]],
Cell[28358, 966, 68, 1, 70, "MathCaption",
 CellID->1652365870],
Cell[CellGroupData[{
Cell[28451, 971, 321, 10, 28, "Input",
 CellID->311717177],
Cell[28775, 983, 9209, 155, 239, "Output",
 Evaluatable->False,
 CellID->387069508]
}, Open  ]],
Cell[37999, 1141, 591, 17, 70, "Text",
 CellID->1700994113],
Cell[38593, 1160, 603, 20, 70, "DefinitionBox",
 CellID->70940889],
Cell[39199, 1182, 78, 1, 70, "Caption",
 CellID->2059349822],
Cell[39280, 1185, 132, 4, 70, "MathCaption",
 CellID->81517383],
Cell[CellGroupData[{
Cell[39437, 1193, 198, 5, 70, "Input",
 CellID->857264579],
Cell[39638, 1200, 682, 20, 36, "Output",
 CellID->2097088476]
}, Open  ]],
Cell[40335, 1223, 309, 11, 70, "Text",
 CellID->823147017],
Cell[40647, 1236, 651, 18, 70, "DefinitionBox",
 CellTags->"Integration directions",
 CellID->1269117341],
Cell[41301, 1256, 78, 1, 70, "Caption",
 CellID->1903824689],
Cell[41382, 1259, 444, 9, 70, "Text",
 CellID->1484438923],
Cell[41829, 1270, 220, 9, 70, "MathCaption",
 CellID->679303005],
Cell[42052, 1281, 1407, 43, 70, "Input",
 CellID->347468359],
Cell[43462, 1326, 134, 6, 70, "MathCaption",
 CellID->128954382],
Cell[CellGroupData[{
Cell[43621, 1336, 168, 4, 70, "Input",
 CellID->1543340197],
Cell[43792, 1342, 1073, 39, 58, "Output",
 CellID->2081964807]
}, Open  ]],
Cell[44880, 1384, 327, 11, 70, "Text",
 CellID->1432425886],
Cell[45210, 1397, 137, 6, 70, "MathCaption",
 CellID->627214781],
Cell[CellGroupData[{
Cell[45372, 1407, 167, 4, 70, "Input",
 CellID->55919334],
Cell[45542, 1413, 1150, 20, 70, "Message",
 CellID->2026435548],
Cell[46695, 1435, 1120, 41, 58, "Output",
 CellID->611317836]
}, Open  ]],
Cell[47830, 1479, 621, 14, 70, "Text",
 CellID->1404081445],
Cell[48454, 1495, 142, 6, 70, "MathCaption",
 CellID->294088714],
Cell[CellGroupData[{
Cell[48621, 1505, 349, 12, 28, "Input",
 CellID->817539056],
Cell[48973, 1519, 8022, 136, 216, "Output",
 Evaluatable->False,
 CellID->221762371]
}, Open  ]],
Cell[57010, 1658, 116, 3, 70, "Text",
 CellID->1022129896],
Cell[57129, 1663, 440, 10, 70, "Text",
 CellID->762288660],
Cell[57572, 1675, 212, 5, 70, "MathCaption",
 CellID->1929624822],
Cell[CellGroupData[{
Cell[57809, 1684, 4125, 112, 232, "Input",
 CellID->1104994245],
Cell[61937, 1798, 8416, 142, 201, "Output",
 Evaluatable->False,
 CellID->478474889]
}, Open  ]],
Cell[70368, 1943, 316, 7, 70, "Text",
 CellID->267170882]
}, Open  ]],
Cell[CellGroupData[{
Cell[70721, 1955, 119, 2, 70, "Section",
 CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"},
 CellID->93858351],
Cell[70843, 1959, 480, 9, 70, "Text",
 CellID->565573805],
Cell[71326, 1970, 4638, 136, 70, "DefinitionBox",
 CellID->1968164995],
Cell[75967, 2108, 169, 7, 70, "Caption",
 CellID->164799240],
Cell[76139, 2117, 401, 8, 70, "Text",
 CellID->477439979],
Cell[76543, 2127, 2433, 76, 70, "DefinitionBox",
 CellID->2049682378],
Cell[78979, 2205, 174, 7, 70, "Caption",
 CellID->1022063819],
Cell[79156, 2214, 510, 17, 70, "Text",
 CellID->1448116711],
Cell[79669, 2233, 253, 9, 70, "MathCaption",
 CellID->725345747],
Cell[CellGroupData[{
Cell[79947, 2246, 1770, 51, 70, "Input",
 CellID->143697513],
Cell[81720, 2299, 486, 15, 36, "Output",
 CellID->235494843]
}, Open  ]],
Cell[82221, 2317, 160, 4, 70, "Text",
 CellID->62301023],
Cell[82384, 2323, 123, 3, 70, "MathCaption",
 CellID->823000518],
Cell[CellGroupData[{
Cell[82532, 2330, 116, 3, 70, "Input",
 CellID->1551926111],
Cell[82651, 2335, 209, 7, 36, "Output",
 CellID->1420630176]
}, Open  ]],
Cell[82875, 2345, 135, 4, 70, "MathCaption",
 CellID->218857067],
Cell[CellGroupData[{
Cell[83035, 2353, 115, 3, 70, "Input",
 CellID->2106693804],
Cell[83153, 2358, 162, 5, 36, "Output",
 CellID->1232677424]
}, Open  ]],
Cell[83330, 2366, 500, 13, 70, "Text",
 CellID->846071848],
Cell[83833, 2381, 130, 4, 70, "MathCaption",
 CellID->15129490],
Cell[CellGroupData[{
Cell[83988, 2389, 223, 7, 28, "Input",
 CellID->633538073],
Cell[84214, 2398, 3129, 55, 249, "Output",
 Evaluatable->False,
 CellID->443416914]
}, Open  ]],
Cell[87358, 2456, 257, 7, 70, "Text",
 CellID->1419210935],
Cell[87618, 2465, 189, 4, 70, "Text",
 CellID->927626787],
Cell[87810, 2471, 352, 9, 70, "Text",
 CellID->1245254856]
}, Open  ]]
}, Open  ]],
Cell[88189, 2484, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

