(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34115,        900]
NotebookOptionsPosition[     28687,        728]
NotebookOutlinePosition[     31695,        810]
CellTagsIndexPosition[     31563,        802]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StiffnessSwitching Method for NDSolve", "Title",
 CellTags->"c:1",
 CellID->1204298976],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->"s:1",
 CellID->871747416],

Cell[TextData[{
 "The basic idea behind the ",
 Cell[BoxData["StiffnessSwitching"], "InlineFormula"],
 " method is to provide an automatic means of switching between a nonstiff \
and a stiff solver."
}], "Text",
 CellID->1067359010],

Cell[TextData[{
 "The ",
 Cell[BoxData["StiffnessTest"], "InlineFormula"],
 " option (described within \"",
 ButtonBox["StiffnessTest Method Option for NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveStiffnessTest"],
 "\") provides a useful means of detecting when a problem appears to be \
stiff."
}], "Text",
 CellID->1642908392],

Cell[TextData[{
 "The ",
 Cell[BoxData["StiffnessSwitching"], "InlineFormula"],
 " method traps any failure code generated by ",
 Cell[BoxData["StiffnessTest"], "InlineFormula"],
 " and switches to an alternative solver."
}], "Text",
 CellID->1615044195],

Cell[TextData[{
 Cell[BoxData["Extrapolation"], "InlineFormula"],
 " provides a powerful technique for computing highly accurate solutions \
using dynamic order and step size selection (see \"",
 ButtonBox["Extrapolation Method for NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveExtrapolation"],
 "\" for more details) and are therefore used as the default choice in ",
 Cell[BoxData["StiffnessSwitching"], "InlineFormula"],
 "."
}], "Text",
 CellID->932498069]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
 CellTags->"s:2",
 CellID->617886039],

Cell["This loads some useful packages.", "MathCaption",
 CellID->1885966829],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveProblems`\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveUtilities`\>\"", "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",
 CellID->1471412733],

Cell[TextData[{
 "This selects a stiff problem and specifies a longer integration time \
interval than the default specified by ",
 Cell[BoxData["NDSolveProblem"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1164827354],

Cell[BoxData[{
 RowBox[{
  RowBox[{"system", " ", "=", " ", 
   RowBox[{"GetNDSolveProblem", "[", "\"\<VanderPol\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"time", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"T", ",", " ", "0", ",", " ", "10"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->2086283403],

Cell[TextData[{
 "The default ",
 Cell[BoxData["Extrapolation"], "InlineFormula"],
 " base method is not appropriate for stiff problems and gives up quite \
quickly."
}], "MathCaption",
 CellID->911801351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"system", ",", "time", ",", 
   RowBox[{"Method", "\[Rule]", "Extrapolation"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1651229464],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndstf\"\>"}], ":", 
  " ", "\<\"At \\!\\(T\\) == \\!\\(0.088817413072354`\\), system appears to \
be stiff. Methods Automatic, BDF or StiffnessSwitching may be more \
appropriate.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[7]:=",
 CellID->84948582],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "1"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "0.088817413072354`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False], "[", "T", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "2"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "0.088817413072354`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{405, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->39360596]
}, Open  ]],

Cell[TextData[{
 "Instead of giving up, the ",
 Cell[BoxData["StiffnessSwitching"], "InlineFormula"],
 " method continues the integration with a stiff solver."
}], "MathCaption",
 CellID->1119904115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"system", ",", "time", ",", 
   RowBox[{"Method", "\[Rule]", "StiffnessSwitching"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1250650088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "1"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "2"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{363, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->155787059]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["StiffnessSwitching"], "InlineFormula"],
 " method uses a pair of extrapolation methods as the default. The nonstiff \
solver uses the ",
 Cell[BoxData["ExplicitModifiedMidpoint"], "InlineFormula"],
 " base method, and the stiff solver uses the ",
 Cell[BoxData["LinearlyImplicitEuler"], "InlineFormula"],
 " base method."
}], "Text",
 CellID->597255327],

Cell[TextData[{
 "For small values of the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " tolerances, it is sometimes preferable to use an explicit \
Runge\[Dash]Kutta method for the nonstiff solver."
}], "Text",
 CellID->1890887445],

Cell[TextData[{
 "The ",
 Cell[BoxData["ExplicitRungeKutta"], "InlineFormula"],
 " method eventually gives up when the problem is considered to be stiff."
}], "MathCaption",
 CellID->2018532584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"system", ",", "time", ",", 
   RowBox[{"Method", "\[Rule]", "ExplicitRungeKutta"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "5"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->837283372],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndstf\"\>"}], ":", 
  " ", "\<\"At \\!\\(T\\) == \\!\\(1.7661778980028666`\\), system appears to \
be stiff. Methods Automatic, BDF or StiffnessSwitching may be more \
appropriate.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1874648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "1"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "1.7661778980028666`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False], "[", "T", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "2"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "1.7661778980028666`"}], "}"}], "}"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{391, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->254006165]
}, Open  ]],

Cell[TextData[{
 "This sets the ",
 Cell[BoxData["ExplicitRungeKutta"], "InlineFormula"],
 " method as a submethod of ",
 Cell[BoxData["StiffnessSwitching"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1292306739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{"system", ",", "time", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"StiffnessSwitching", ",", " ", 
       RowBox[{"Method", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"ExplicitRungeKutta", ",", " ", "Automatic"}], "}"}]}]}], 
      "}"}]}], ",", " ", 
    RowBox[{"AccuracyGoal", "\[Rule]", "5"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "4"}]}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->296727177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "1"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "2"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{363, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->520918236]
}, Open  ]],

Cell[TextData[{
 "A switch to the stiff solver occurs at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"T", " ", "\[TildeTilde]", "  ", "1.77"}], TraditionalForm]], 
  "InlineMath"],
 ", and a plot of the step sizes used shows that the stiff solver takes much \
larger steps."
}], "MathCaption",
 CellID->690380726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StepDataPlot", "[", "sol", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1295350832],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->562911183]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option Summary", "Section",
 CellTags->"s:3",
 CellID->1317606863],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell["\<\
specifies the methods to use for the nonstiff and stiff solvers respectively\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->1253785758],

Cell[TextData[{
 "Options of the method ",
 Cell[BoxData["StiffnessSwitching"], "InlineFormula"],
 ". "
}], "Caption",
 CellID->277414890]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StiffnessSwitching Method for NDSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Advanced Numerical Differential Equation Solving in Mathematica", 
         "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NDSolveOverview"]], "Text", FontFamily -> "Verdana"],
     "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NDSolveProjection"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NDSolveExtrapolation#1712532361"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 40, 24.0722342}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The basic idea behind the StiffnessSwitching method is to provide an \
automatic means of switching between a nonstiff and a stiff solver. The \
StiffnessTest option (described within \"StiffnessTest Method Option for \
NDSolve\") provides a useful means of detecting when a problem appears to be \
stiff. The StiffnessSwitching method traps any failure code generated by \
StiffnessTest and switches to an alternative solver.", "synonyms" -> {}, 
    "title" -> "StiffnessSwitching Method for NDSolve", "type" -> "Tutorial", 
    "uri" -> "tutorial/NDSolveStiffnessSwitching"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:1"->{
  Cell[728, 29, 93, 2, 70, "Title",
   CellTags->"c:1",
   CellID->1204298976]},
 "s:1"->{
  Cell[846, 35, 69, 2, 70, "Section",
   CellTags->"s:1",
   CellID->871747416]},
 "s:2"->{
  Cell[2285, 84, 65, 2, 70, "Section",
   CellTags->"s:2",
   CellID->617886039]},
 "s:3"->{
  Cell[27635, 689, 72, 2, 70, "Section",
   CellTags->"s:3",
   CellID->1317606863]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:1", 31178, 783},
 {"s:1", 31269, 787},
 {"s:2", 31361, 791},
 {"s:3", 31454, 795}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 93, 2, 70, "Title",
 CellTags->"c:1",
 CellID->1204298976],
Cell[CellGroupData[{
Cell[846, 35, 69, 2, 70, "Section",
 CellTags->"s:1",
 CellID->871747416],
Cell[918, 39, 232, 6, 70, "Text",
 CellID->1067359010],
Cell[1153, 47, 352, 10, 70, "Text",
 CellID->1642908392],
Cell[1508, 59, 254, 7, 70, "Text",
 CellID->1615044195],
Cell[1765, 68, 483, 11, 70, "Text",
 CellID->932498069]
}, Open  ]],
Cell[CellGroupData[{
Cell[2285, 84, 65, 2, 70, "Section",
 CellTags->"s:2",
 CellID->617886039],
Cell[2353, 88, 76, 1, 70, "MathCaption",
 CellID->1885966829],
Cell[2432, 91, 312, 11, 70, "Input",
 InitializationCell->True,
 CellID->1471412733],
Cell[2747, 104, 226, 6, 70, "MathCaption",
 CellID->1164827354],
Cell[2976, 112, 326, 10, 70, "Input",
 CellID->2086283403],
Cell[3305, 124, 205, 6, 70, "MathCaption",
 CellID->911801351],
Cell[CellGroupData[{
Cell[3535, 134, 192, 5, 70, "Input",
 CellID->1651229464],
Cell[3730, 141, 325, 7, 70, "Message",
 CellID->84948582],
Cell[4058, 150, 997, 34, 54, "Output",
 CellID->39360596]
}, Open  ]],
Cell[5070, 187, 199, 5, 70, "MathCaption",
 CellID->1119904115],
Cell[CellGroupData[{
Cell[5294, 196, 197, 5, 70, "Input",
 CellID->1250650088],
Cell[5494, 203, 968, 34, 54, "Output",
 CellID->155787059]
}, Open  ]],
Cell[6477, 240, 393, 10, 70, "Text",
 CellID->597255327],
Cell[6873, 252, 457, 14, 70, "Text",
 CellID->1890887445],
Cell[7333, 268, 194, 5, 70, "MathCaption",
 CellID->2018532584],
Cell[CellGroupData[{
Cell[7552, 277, 299, 7, 70, "Input",
 CellID->837283372],
Cell[7854, 286, 325, 7, 70, "Message",
 CellID->1874648],
Cell[8182, 295, 1000, 34, 54, "Output",
 CellID->254006165]
}, Open  ]],
Cell[9197, 332, 220, 7, 70, "MathCaption",
 CellID->1292306739],
Cell[CellGroupData[{
Cell[9442, 343, 537, 14, 70, "Input",
 CellID->296727177],
Cell[9982, 359, 969, 34, 54, "Output",
 CellID->520918236]
}, Open  ]],
Cell[10966, 396, 309, 9, 70, "MathCaption",
 CellID->690380726],
Cell[CellGroupData[{
Cell[11300, 409, 112, 3, 28, "Input",
 CellID->1295350832],
Cell[11415, 414, 16171, 269, 246, "Output",
 Evaluatable->False,
 CellID->562911183]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27635, 689, 72, 2, 70, "Section",
 CellTags->"s:3",
 CellID->1317606863],
Cell[27710, 693, 782, 22, 70, "DefinitionBox3Col",
 CellID->1253785758],
Cell[28495, 717, 138, 5, 70, "Caption",
 CellID->277414890]
}, Open  ]]
}, Open  ]],
Cell[28660, 726, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

