(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15467,        560]
NotebookOptionsPosition[     11058,        417]
NotebookOutlinePosition[     13361,        482]
CellTagsIndexPosition[     13219,        474]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StiffnessTest Method Option for NDSolve", "Title",
 CellID->278248124],

Cell[CellGroupData[{

Cell["Overview", "Section",
 CellTags->"s:1",
 CellID->1146107183],

Cell[TextData[{
 "The methods ",
 StyleBox["DoubleStep", "MR"],
 ", ",
 StyleBox["Extrapolation", "MR"],
 ", and ",
 StyleBox["ExplicitRungeKutta", "MR"],
 " have the option ",
 StyleBox["StiffnessTest", "MR"],
 ", which can be used to identify whether the method applied with the \
specified ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " tolerances to a given problem is stiff."
}], "Text",
 CellID->1881882119],

Cell[TextData[{
 "A convenient way of detecting stiffness is to directly estimate the \
dominant eigenvalue of the Jacobian ",
 Cell[BoxData[
  FormBox["J", TraditionalForm]]],
 " of the problem (see [",
 ButtonBox["S84",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#23832"],
 "] and [",
 ButtonBox["R87",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#28770"],
 "])."
}], "Text",
 CellID->2037451941],

Cell["\<\
Such an estimate is often available as a by-product of the numerical \
integration and so it is reasonably inexpensive.\
\>", "Text",
 CellID->1317843955],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 " denotes an approximation to the eigenvector corresponding to dominant \
eigenvalue of the Jacobian, with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftDoubleBracketingBar]", "v", "\[RightDoubleBracketingBar]"}],
    TraditionalForm]]],
 " sufficiently small, then by the mean value theorem a good approximation to \
the leading eigenvalue is:"
}], "Text",
 CellID->1028016778],

Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["\[Lambda]", "\[Tilde]"], "=", 
   FormBox[
    FractionBox[
     RowBox[{"\[LeftDoubleBracketingBar]", 
      RowBox[{
       RowBox[{"f", "(", 
        RowBox[{"t", ",", " ", 
         RowBox[{"y", " ", "+", " ", "v"}]}], ")"}], " ", "-", " ", 
       RowBox[{"f", "(", 
        RowBox[{"t", ",", " ", "y"}], ")"}]}], 
      "\[RightDoubleBracketingBar]"}], 
     RowBox[{
     "\[LeftDoubleBracketingBar]", "v", "\[RightDoubleBracketingBar]"}]],
    TraditionalForm]}], TraditionalForm]], "DisplayMath",
 CellID->1019063083],

Cell["\<\
Richardson's extrapolation provides a sequence of refinements that yield a \
quantity of this form as do certain explicit Runge-Kutta methods.\
\>", "Text",
 CellID->1476321693],

Cell["\<\
Let LSB denote the linear stability boundary\[LongDash]the intersection of \
the linear stability region with the negative real axis.\
\>", "Text",
 CellID->933808981],

Cell[TextData[{
 "The product",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "  ", 
    OverscriptBox["\[Lambda]", "\[Tilde]"]}], TraditionalForm]]],
 " gives an estimate that can be compared to the linear stability boundary of \
a method in order to detect stiffness."
}], "Text",
 CellID->1572378610],

Cell[BoxData[
 FormBox[
  RowBox[{"|", 
   RowBox[{"h", "  ", 
    OverscriptBox["\[Lambda]", "\[Tilde]"]}], "|", " ", 
   RowBox[{"\[LessEqual]", 
    RowBox[{"|", " ", "LSB", "|"}]}]}], TraditionalForm]], "NumberedEquation",\

 CellTags->"StiffnessTest",
 CellID->1371300874],

Cell[TextData[{
 "The method option ",
 StyleBox["StiffnessTest", "MR"],
 " itself accepts a number of options that are now illustrated."
}], "Text",
 CellID->1468132137]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
 CellTags->"s:2",
 CellID->719449362],

Cell[TextData[{
 "The default values for the stiffness test implement a weak form of ",
 "(",
 
 CounterBox["NumberedEquation", "StiffnessTest"],
 ")",
 " where the test incorporates a safety factor and is allowed to fail a \
specified number of times."
}], "Text",
 CellID->557859093],

Cell["\<\
The reason for this is that some problems can be only mildly stiff in a \
certain region and an explicit integration method may still be efficient.\
\>", "Text",
 CellID->1494805771],

Cell["\<\
This loads a package with some predefined examples and selects one of the \
examples.\
\>", "Text",
 CellID->1839873683],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveProblems`\>\"", "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1614224522],

Cell[BoxData[
 RowBox[{
  RowBox[{"system", " ", "=", " ", 
   RowBox[{"GetNDSolveProblem", "[", "\"\<VanderPol\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1527543738],

Cell[TextData[{
 "The problem is integrated successfully with the given method and the \
default option settings for ",
 StyleBox["StiffnessTest", "MR"],
 "."
}], "Text",
 CellID->1248612540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"system", ",", " ", 
   RowBox[{"Method", " ", "\[Rule]", " ", "\"\<ExplicitRungeKutta\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1988131214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "1"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "2.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "2"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "2.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{363, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1379603245]
}, Open  ]],

Cell["\<\
A longer integration is aborted and a message is issued when the stiffness \
test condition is not satisfied. \
\>", "Text",
 CellID->1826292789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"system", ",", " ", 
   RowBox[{"{", 
    RowBox[{"T", ",", " ", "0", ",", " ", "10"}], "}"}], ",", " ", 
   RowBox[{"Method", " ", "\[Rule]", " ", "\"\<ExplicitRungeKutta\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1297795699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "1"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "2"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{363, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->102991773]
}, Open  ]],

Cell["\<\
Using a unit safety factor and specifying that only one stiffness failure is \
allowed effectively gives a strict test. The specification uses the nested \
method option syntax.\
\>", "Text",
 CellID->1590060811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"system", ",", 
   RowBox[{"Method", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<ExplicitRungeKutta\>\"", ",", " ", 
      RowBox[{"StiffnessTest", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"True", ",", " ", 
         RowBox[{
         "\"\<MaxStiffnessTestFailures\>\"", " ", "\[Rule]", " ", "1"}], ",", 
         " ", 
         RowBox[{"\"\<StiffnessTestSafetyFactor\>\"", "\[Rule]", "1"}]}], 
        "}"}]}]}], " ", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1551890040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "1"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "2.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "2"], "[", "T", "]"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.`", ",", "2.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
        "]"}],
       False,
       Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{363, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->599312380]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option summary", "Section",
 CellTags->"s:3",
 CellID->1423778488],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"MaxStiffnessTestFailures", "3", Cell["\<\
Specifies the maximum number of times that the stiffness test (1) is allowed \
to fail.\
\>", "TableText"]},
   {"StiffnessTestSafetyFactor", 
    FractionBox["9", "10"], Cell["\<\
Specifies the safety factor to use in the left hand side of the stiffness \
test (1).\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->1851206519],

Cell[TextData[{
 "Options of the method option ",
 Cell[BoxData["StiffnessTest"], "InlineFormula"],
 ". "
}], "Caption",
 CellID->224965992]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StiffnessTest Method Option for NDSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 40, 24.3378660}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The methods DoubleStep, Extrapolation, and ExplicitRungeKutta have the \
option StiffnessTest, which can be used to identify whether the method \
applied with the specified AccuracyGoal and PrecisionGoal tolerances to a \
given problem is stiff. A convenient way of detecting stiffness is to \
directly estimate the dominant eigenvalue of the Jacobian J of the problem \
(see [S84] and [R87]). Such an estimate is often available as a by-product of \
the numerical integration and so it is reasonably inexpensive.", 
    "synonyms" -> {}, "title" -> "StiffnessTest Method Option for NDSolve", 
    "type" -> "Tutorial", "uri" -> "tutorial/NDSolveStiffnessTest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "s:1"->{
  Cell[829, 34, 66, 2, 70, "Section",
   CellTags->"s:1",
   CellID->1146107183]},
 "StiffnessTest"->{
  Cell[3875, 143, 277, 9, 70, "NumberedEquation",
   CellTags->"StiffnessTest",
   CellID->1371300874]},
 "s:2"->{
  Cell[4362, 164, 65, 2, 70, "Section",
   CellTags->"s:2",
   CellID->719449362]},
 "s:3"->{
  Cell[10116, 383, 72, 2, 70, "Section",
   CellTags->"s:3",
   CellID->1423778488]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"s:1", 12798, 455},
 {"StiffnessTest", 12901, 459},
 {"s:2", 13016, 463},
 {"s:3", 13110, 467}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 76, 1, 70, "Title",
 CellID->278248124],
Cell[CellGroupData[{
Cell[829, 34, 66, 2, 70, "Section",
 CellTags->"s:1",
 CellID->1146107183],
Cell[898, 38, 638, 22, 70, "Text",
 CellID->1881882119],
Cell[1539, 62, 449, 15, 70, "Text",
 CellID->2037451941],
Cell[1991, 79, 164, 4, 70, "Text",
 CellID->1317843955],
Cell[2158, 85, 454, 13, 70, "Text",
 CellID->1028016778],
Cell[2615, 100, 579, 17, 70, "DisplayMath",
 CellID->1019063083],
Cell[3197, 119, 187, 4, 70, "Text",
 CellID->1476321693],
Cell[3387, 125, 177, 4, 70, "Text",
 CellID->933808981],
Cell[3567, 131, 305, 10, 70, "Text",
 CellID->1572378610],
Cell[3875, 143, 277, 9, 70, "NumberedEquation",
 CellTags->"StiffnessTest",
 CellID->1371300874],
Cell[4155, 154, 170, 5, 70, "Text",
 CellID->1468132137]
}, Open  ]],
Cell[CellGroupData[{
Cell[4362, 164, 65, 2, 70, "Section",
 CellTags->"s:2",
 CellID->719449362],
Cell[4430, 168, 285, 9, 70, "Text",
 CellID->557859093],
Cell[4718, 179, 192, 4, 70, "Text",
 CellID->1494805771],
Cell[4913, 185, 130, 4, 70, "Text",
 CellID->1839873683],
Cell[5046, 191, 171, 6, 70, "Input",
 CellID->1614224522],
Cell[5220, 199, 190, 6, 70, "Input",
 CellID->1527543738],
Cell[5413, 207, 191, 6, 70, "Text",
 CellID->1248612540],
Cell[CellGroupData[{
Cell[5629, 217, 210, 6, 70, "Input",
 CellID->1988131214],
Cell[5842, 225, 969, 34, 54, "Output",
 CellID->1379603245]
}, Open  ]],
Cell[6826, 262, 155, 4, 70, "Text",
 CellID->1826292789],
Cell[CellGroupData[{
Cell[7006, 270, 295, 8, 70, "Input",
 CellID->1297795699],
Cell[7304, 280, 968, 34, 54, "Output",
 CellID->102991773]
}, Open  ]],
Cell[8287, 317, 222, 5, 70, "Text",
 CellID->1590060811],
Cell[CellGroupData[{
Cell[8534, 326, 562, 15, 70, "Input",
 CellID->1551890040],
Cell[9099, 343, 968, 34, 54, "Output",
 CellID->599312380]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10116, 383, 72, 2, 70, "Section",
 CellTags->"s:3",
 CellID->1423778488],
Cell[10191, 387, 670, 17, 70, "DefinitionBox3Col",
 CellID->1851206519],
Cell[10864, 406, 140, 5, 70, "Caption",
 CellID->224965992]
}, Open  ]]
}, Open  ]],
Cell[11031, 415, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

