(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34088,       1182]
NotebookOptionsPosition[     27686,        980]
NotebookOutlinePosition[     30283,       1046]
CellTagsIndexPosition[     30166,       1039]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"1" :> Documentation`HelpLookup["paclet:scaling"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"1\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Norms in NDSolve", "Title",
 CellID->114241363],

Cell[TextData[{
 StyleBox["NDSolve", "MR"],
 " uses norms of error estimates to determine when solutions satisfy error \
tolerances. In nearly all cases a norm which has been weighted, or scaled, \
such that it is less than 1 if error tolerances have been satisfied and \
greater than one if error tolerances are not satisfied. One significant \
advantage of such a scaled norm is that a given method can be written without \
explicit reference to tolerances:",
 " ",
 "the satisfaction of tolerances however specified is found by comparing the \
scaled norm to 1, thus simplifying the code required for checking error \
estimates within methods."
}], "Text",
 CellID->956934756],

Cell[TextData[{
 "Suppose that ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 " is vector and ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]]],
 " is a reference vector to compute weights with (typically ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]]],
 " is an approximate solution vector).",
 " ",
 "Then the scaled vector, ",
 Cell[BoxData[
  FormBox["w", TraditionalForm]]],
 " to which the norm is applied has components:"
}], "Text",
 CellID->391554682],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["w", "i"], "=", 
   FractionBox[
    RowBox[{"|", 
     SubscriptBox["v", "i"], "|"}], 
    RowBox[{
     RowBox[{
      SubscriptBox["t", "a"], "+", 
      SubscriptBox["t", "r"]}], "|", " ", 
     SubscriptBox["u", "i"], "|"}]]}], TraditionalForm]], "NumberedEquation",
 CellTags->"scaling",
 CellID->828692595],

Cell[TextData[{
 "where absolute and relative tolerances, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "a"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "r"], TraditionalForm]]],
 " are derived respectively from the ",
 StyleBox["AccuracyGoal->ag", "MR"],
 " and ",
 StyleBox["PrecisionGoal->pg", "MR"],
 " options by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "a"], " ", "=", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "ag"}]]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "r"], " ", "=", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "pg"}]]}], TraditionalForm]]],
 "."
}], "Text",
 CellID->1378675378],

Cell[TextData[{
 "The actual norm used is determined by the setting for the ",
 StyleBox["NormFunction", "MR"],
 " option given to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1679523494],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"NormFunction", "Automatic", Cell[TextData[{
     "A function to use to compute norms of error estimates in ",
     Cell[BoxData[
      ButtonBox["NDSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->1490674363],

Cell[TextData[{
 "NormFunction option to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->578199448],

Cell[TextData[{
 "The setting for the ",
 StyleBox["NormFunction", "MR"],
 " option can be any function which returns a scalar for a vector argument \
and satisfies the properties of a norm. If you specify a function that does \
not satisfy the required properties of a norm, ",
 StyleBox["NDSolve", "MR"],
 " will almost surely run into problems and give an answer, if any, which is \
incorrect."
}], "Text",
 CellID->2036440012],

Cell[TextData[{
 "The default value of ",
 StyleBox["Automatic", "MR"],
 " means that ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " may use different norms for different methods. Most methods use an \
infinity-norm, but the IDA method for ",
 ButtonBox["DAE",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveIntroductoryTutorialDAEs"],
 "s uses a 2-norm because that helps maintain smoothness in the merit \
function for finding roots of the residual. It is strongly recommended that \
you use ",
 ButtonBox["Norm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Norm"],
 " with a particular value of ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 ". For this reason, you can also use the shorthand ",
 StyleBox["NormFunction->p", "MR"],
 " in place of ",
 StyleBox["NormFunction->(Norm[#, ", "MR"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "]"}], "/", 
    SuperscriptBox[
     RowBox[{
      StyleBox["Length", "MR"], "[", "#", "]"}], 
     RowBox[{"1", "/", "p"}]]}], TraditionalForm]]],
 StyleBox["&).", "MR"],
 " ",
 "The most commonly used implementations for p = 1, p = 2, and p = \
\[Infinity] have been specially optimized for speed."
}], "Text",
 CellID->316987793],

Cell["\<\
This compares the overall error for computing the solution to the simple \
harmonic oscillator over 100 cycles with different norms specified.\
\>", "MathCaption",
 CellID->1992181047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", " ", "-", " ", 
        RowBox[{"x", "[", 
         RowBox[{"100", " ", "\[Pi]"}], "]"}]}], ")"}], " ", "/.", " ", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
            RowBox[{"x", "[", "t", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", 
          " ", 
          RowBox[{
           RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", 
          " ", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", 
           "0"}]}], "}"}], ",", " ", "x", ",", " ", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"100", " ", "\[Pi]"}]}], "}"}], ",", " ", 
        RowBox[{"Method", "\[Rule]", "ExplicitRungeKutta"}], ",", " ", 
        RowBox[{"NormFunction", "\[Rule]", "#"}]}], "]"}]}], "]"}], "&"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2", ",", " ", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105085353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.62652234090433`*^-8", ",", "7.50564106422047`*^-8", ",", 
   "5.815472725601012`*^-8"}], "}"}]], "Output",
 ImageSize->{295, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108472827]
}, Open  ]],

Cell[TextData[{
 "The reason that error decreases with increasing ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 " is because the norms are normalized by multiplying with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SuperscriptBox["n", 
     RowBox[{"1", "/", "p"}]]}], TraditionalForm]]],
 ", where ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " is the length of the vector.",
 " ",
 "This is often important in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " because in many cases, an attempt is being made to check the approximation \
to a function, where more points should give a better approximation, or less \
error."
}], "Text",
 CellID->131449927],

Cell[TextData[{
 "Consider a ",
 ButtonBox["finite difference",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolvePDE#1788968576"],
 " approximation to the first derivative of a periodic function ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]]],
 " given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["u", "i", "'"], " ", "=", " ", 
    FractionBox[
     RowBox[{
      SubscriptBox["u", 
       RowBox[{"i", "+", "1"}]], " ", "-", " ", 
      SubscriptBox["u", "i"]}], 
     RowBox[{" ", "h"}]]}], TraditionalForm]]],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "i"], " ", "=", " ", 
    RowBox[{"u", "(", 
     SubscriptBox["x", "i"], ")"}]}], TraditionalForm]]],
 " on a grid with uniform spacing ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", " ", "=", " ", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"i", "+", "1"}]], "-", " ", 
     SubscriptBox["x", "i"]}]}], TraditionalForm]]],
 ". In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", this can easily be computed using ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1360199505],

Cell["\<\
This computes the error of the first derivative approximation for the cosine \
function on a grid with 16 points covering the interval [0, 2\[Pi]]\
\>", "MathCaption",
 CellID->774735355],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"h", " ", "=", " ", 
   RowBox[{"2", 
    RowBox[{"\[Pi]", "/", "16."}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"grid", " ", "=", " ", 
   RowBox[{"h", " ", 
    RowBox[{"Range", "[", "16", "]"}]}]}], ";"}], "\n", 
 RowBox[{"err16", " ", "=", " ", 
  RowBox[{
   RowBox[{"Sin", "[", "grid", "]"}], " ", "-", " ", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}], "/", "h"}], ",", " ", 
     RowBox[{"Cos", "[", "grid", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->370269244],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.16932384605030953`"}], ",", 
   RowBox[{"-", "0.11903049272323196`"}], ",", 
   RowBox[{"-", "0.05061582589314606`"}], ",", "0.025504641595567312`", ",", 
   "0.0977422586015072`", ",", "0.15509950277114803`", ",", 
   "0.188844253624376`", ",", "0.193839178740714`", ",", 
   "0.16932384605030942`", ",", "0.11903049272323096`", ",", 
   "0.05061582589314717`", ",", 
   RowBox[{"-", "0.025504641595566313`"}], ",", 
   RowBox[{"-", "0.09774225860150798`"}], ",", 
   RowBox[{"-", "0.1550995027711488`"}], ",", 
   RowBox[{"-", "0.18884425362437562`"}], ",", 
   RowBox[{"-", "0.19383917874071413`"}]}], "}"}]], "Output",
 ImageSize->{583, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1745739701]
}, Open  ]],

Cell["\<\
This computes the error of the first derivative approximation for the cosine \
function on a grid with 32 points covering the interval [0, 2\[Pi]]\
\>", "MathCaption",
 CellID->1020168079],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"h", " ", "=", " ", 
   RowBox[{"2", 
    RowBox[{"\[Pi]", "/", "32."}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"grid", " ", "=", " ", 
   RowBox[{"h", " ", 
    RowBox[{"Range", "[", "32", "]"}]}]}], ";"}], "\n", 
 RowBox[{"err32", " ", "=", " ", 
  RowBox[{
   RowBox[{"Sin", "[", "grid", "]"}], " ", "-", " ", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}], "/", "h"}], ",", " ", 
     RowBox[{"Cos", "[", "grid", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->59147252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.09472827213888085`"}], ",", 
   RowBox[{"-", "0.08795642657727393`"}], ",", 
   RowBox[{"-", "0.07780446486883275`"}], ",", 
   RowBox[{"-", "0.06466252120873017`"}], ",", 
   RowBox[{"-", "0.04903563312173598`"}], ",", 
   RowBox[{"-", "0.031524333153372885`"}], ",", 
   RowBox[{"-", "0.012801570740975432`"}], ",", "0.006413148855794248`", ",", 
   "0.025381414738570696`", ",", "0.043374287087006635`", ",", 
   "0.05970030990726649`", ",", "0.07373208329811132`", ",", 
   "0.08493037407723936`", ",", "0.09286483821008079`", ",", 
   "0.09723055868970995`", ",", "0.09785976332641878`", ",", 
   "0.09472827213888074`", ",", "0.08795642657727226`", ",", 
   "0.0778044648688343`", ",", "0.0646625212087315`", ",", 
   "0.04903563312173265`", ",", "0.031524333153373885`", ",", 
   "0.012801570740976653`", ",", 
   RowBox[{"-", "0.006413148855793138`"}], ",", 
   RowBox[{"-", "0.02538141473856992`"}], ",", 
   RowBox[{"-", "0.043374287087008745`"}], ",", 
   RowBox[{"-", "0.05970030990726605`"}], ",", 
   RowBox[{"-", "0.07373208329811187`"}], ",", 
   RowBox[{"-", "0.08493037407724024`"}], ",", 
   RowBox[{"-", "0.0928648382100804`"}], ",", 
   RowBox[{"-", "0.09723055868970917`"}], ",", 
   RowBox[{"-", "0.09785976332641891`"}]}], "}"}]], "Output",
 ImageSize->{541, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1247629233]
}, Open  ]],

Cell["\<\
It is quite apparent that the pointwise error is significantly less with a \
larger number of points.\
\>", "Text",
 CellID->1310165860],

Cell["\<\
The 2 norms of the vectors are of the same order of magnitude\
\>", "MathCaption",
 CellID->863887120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"err16", ",", "2"}], "]"}], ",", " ", 
   RowBox[{"Norm", "[", 
    RowBox[{"err32", ",", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1752075622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5529854533912648`", ",", "0.392278712275836`"}], "}"}]], "Output",\

 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1410794407]
}, Open  ]],

Cell[TextData[{
 "The reason the norms of the vectors are comparable is because the number of \
components in the vector has increased, so the usual linear algebra norm does \
not properly reflect the convergence.",
 " ",
 "Normalizing by multiplying by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SuperscriptBox["n", 
     RowBox[{"1", "/", "p"}]]}], TraditionalForm]]],
 "reflects the convergence in the function space properly."
}], "Text",
 CellID->1861653299],

Cell["\<\
The normalized 2 norms of the vectors reflect the convergence to the actual \
function. Since the approximation is first order, doubling the number of grid \
points should approximately halve the error.\
\>", "MathCaption",
 CellID->1667244511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{"err16", ",", "2"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "16", "]"}]}], ",", " ", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{"err32", ",", "2"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "32", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->533319899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1382463633478162`", ",", "0.06934573439134255`"}], 
  "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1580721047]
}, Open  ]],

Cell["\<\
Note that if you specify a function an option value, and you intend to use it \
for PDE or function approximation solutions, you should be sure to include a \
proper normalization in the function.\
\>", "Text",
 CellID->348738585],

Cell[CellGroupData[{

Cell["ScaledVectorNorm", "Section",
 CellTags->{"s:2", "svn"},
 CellID->87309426],

Cell[TextData[{
 "Methods which have error control need to determine whether a step satisfies \
local error tolerances or not. To simplify the process of checking this, a \
utility function ScaledVectorNorm does the scaling (",
 ButtonBox["1",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveVectorNorm#828692595"],
 ") and computes the norm.",
 " ",
 "The table below includes the formulas for specific values of ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 " for reference."
}], "Text",
 CellID->675670517],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{"ScaledVectorNorm", "[", 
      RowBox[{
       StyleBox["p", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["r", "TI"]], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["a", "TI"]]}], "}"}]}], "]"}], "[", 
     RowBox[{
      StyleBox["v", "TI"], ",", 
      StyleBox["u", "TI"]}], "]"}], Cell[TextData[{
     "Compute the normalized p-norm of the vector ",
     StyleBox["v", "TI"],
     " scaling using scaling (",
     ButtonBox["1",
      BaseStyle->"Hyperlink",
      ButtonData:>"scaling"],
     ") with reference vector ",
     StyleBox["u", "TI"],
     " and relative and absolute tolerances ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["t", "a"], " ", "and", " ", 
        SubscriptBox["t", "r"]}], TraditionalForm]]],
     "."
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{"ScaledVectorNorm", "[", 
      RowBox[{
       StyleBox["fun", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["r", "TI"]], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["a", "TI"]]}], "}"}]}], "]"}], "[", 
     RowBox[{
      StyleBox["v", "TI"], ",", 
      StyleBox["u", "TI"]}], "]"}], Cell[TextData[{
     "Compute the norm of",
     " ",
     "the vector ",
     StyleBox["v", "TI"],
     " using scaling (",
     ButtonBox["1",
      BaseStyle->"Hyperlink",
      ButtonData:>"scaling"],
     ") with reference vector ",
     StyleBox["u", "TI"],
     " and relative and absolute tolerances ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["t", "a"], " ", "and", " ", 
        SubscriptBox["t", "r"]}], TraditionalForm]]],
     " and the norm function ",
     StyleBox["fun", "TI"],
     "."
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{"ScaledVectorNorm", "[", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["r", "TI"]], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["a", "TI"]]}], "}"}]}], "]"}], "[", 
     RowBox[{
      StyleBox["v", "TI"], ",", 
      StyleBox["u", "TI"]}], "]"}], Cell[TextData[{
     "Compute ",
     Cell[BoxData[
      FormBox[
       SqrtBox[
        RowBox[{
         FractionBox["1", "n"], 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"i", "=", "1"}], "n"], 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"|", 
              SubscriptBox["v", "i"], "|"}], 
             RowBox[{
              RowBox[{
               SubscriptBox["t", "a"], "+", 
               SubscriptBox["t", "r"]}], "|", " ", 
              SubscriptBox["u", "i"], "|"}]], ")"}], "2"]}]}]], 
       TraditionalForm]]],
     "where",
     StyleBox[" n", "TI"],
     " is the length of vectors",
     " ",
     StyleBox["v", "TI"],
     " and",
     StyleBox[" u", "TI"],
     "."
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{"ScaledVectorNorm", "[", 
      RowBox[{
       StyleBox["\[Infinity]", "TR"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["t", 
          StyleBox["r", "TI"]], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["a", "TI"]]}], "}"}]}], "]"}], "[", 
     RowBox[{
      StyleBox["v", "TI"], ",", 
      StyleBox["u", "TI"]}], "]"}], Cell[TextData[{
     "Compute ",
     Cell[BoxData[
      FormBox[
       RowBox[{"max", "(", 
        FractionBox[
         RowBox[{"|", 
          SubscriptBox["v", "i"], "|"}], 
         RowBox[{
          RowBox[{
           SubscriptBox["t", "a"], "+", 
           SubscriptBox["t", "r"]}], " ", "|", 
          SubscriptBox["u", "i"], "|"}]], ")"}], TraditionalForm]]],
     " , 1 \[LessEqual]",
     StyleBox[" ", "TI"],
     "i \[LessEqual] ",
     StyleBox["n", "TI"],
     " where ",
     StyleBox["n", "TI"],
     " is the length of vectors",
     " ",
     StyleBox["v", "TI"],
     " and",
     StyleBox[" u", "TI"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.45], {
      Scaled[0.55]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1305673341],

Cell[TextData[{
 Cell[BoxData["ScaledVectorNorm"], "InlineFormula"],
 ". "
}], "Caption",
 CellID->478864108],

Cell["", "Text",
 CellID->857641478],

Cell[TextData[{
 "This sets up a scaled vector norm object with the default machine precision \
tolerances used in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1504363112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"svn", " ", "=", " ", 
  RowBox[{"NDSolve`ScaledVectorNorm", "[", 
   RowBox[{"2", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["10.", 
       RowBox[{"-", "8"}]], ",", " ", 
      SuperscriptBox["10.", 
       RowBox[{"-", "8"}]]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->536865071],

Cell[BoxData[
 RowBox[{"NDSolve`ScaledVectorNorm", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"1.`*^-8", ",", "1.`*^-8"}], "}"}]}], "]"}]], "Output",
 ImageSize->{329, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1410145176]
}, Open  ]],

Cell["\<\
This applies the scaled norm object with a sample error and solution \
reference vector.\
\>", "MathCaption",
 CellID->847553828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"svn", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"9.", " ", 
      SuperscriptBox["10.", 
       RowBox[{"-", "9"}]]}], ",", " ", 
     SuperscriptBox["10.", 
      RowBox[{"-", "8"}]]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"2.", ",", "1."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1115064520],

Cell[BoxData["0.412310562561766`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->517824966]
}, Open  ]],

Cell["\<\
Because of the absolute tolerance term, the value comes out reasonably even \
if some of the components of the reference solution are zero.\
\>", "MathCaption",
 CellID->1164541621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"svn", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"9.", " ", 
      SuperscriptBox["10.", 
       RowBox[{"-", "9"}]]}], ",", " ", 
     SuperscriptBox["10.", 
      RowBox[{"-", "8"}]], ",", " ", 
     RowBox[{"2", " ", 
      SuperscriptBox["10", 
       RowBox[{"-", "8"}]]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1.", ",", "0.", ",", " ", "0."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->959761919],

Cell[BoxData["1.3168776202315333`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1270126337]
}, Open  ]],

Cell[TextData[{
 "When setting up a method for ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", you can get the appropriate ",
 StyleBox["ScaledVectorNorm", "MR"],
 " object to use using the ",
 StyleBox["\"Norm\"", "MR"],
 " ",
 ButtonBox["method function",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveStateData#93858351"],
 " of the",
 StyleBox[" ", "MR"],
 StyleBox[ButtonBox["NDSolve`StateData",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveStateData"], "MR"],
 " ",
 "object."
}], "Text",
 CellID->1130152219],

Cell["Here is an NDSolve`StateData object.", "MathCaption",
 CellID->1091211846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"state", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve`ProcessEquations", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
         RowBox[{"x", "[", "t", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", 
       " ", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
      "}"}], ",", "x", ",", "t"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1365145178],

Cell[BoxData[
 TagBox[
  RowBox[{"NDSolve`StateData", "[", 
   InterpretationBox[
    RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
     "\[InvisibleSpace]", "\<\">\"\>"}],
    SequenceForm["<", 0., ">"],
    Editable->False], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->403841813]
}, Open  ]],

Cell["\<\
This gets the appropriate scaled norm to use from the state data.\
\>", "MathCaption",
 CellID->1461481090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"svn", " ", "=", " ", 
  RowBox[{"state", "[", "\"\<Norm\>\"", "]"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->1454278190],

Cell[BoxData[
 RowBox[{"NDSolve`ScaledVectorNorm", "[", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"{", 
    RowBox[{"1.0536712127723497`*^-8", ",", "1.0536712127723497`*^-8"}], 
    "}"}], ",", "NDSolve"}], "]"}]], "Output",
 ImageSize->{461, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->879152758]
}, Open  ]],

Cell["\<\
This applies it to a sample error vector using the initial condition as \
reference vector.\
\>", "MathCaption",
 CellID->1520628343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"svn", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["10.", 
      RowBox[{"-", "9"}]], ",", " ", 
     SuperscriptBox["10.", 
      RowBox[{"-", "8"}]]}], "}"}], ",", " ", 
   RowBox[{"state", "@", 
    RowBox[{"\"\<SolutionVector\>\"", "[", "\"\<Forward\>\"", "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->545655820],

Cell[BoxData["0.9490626562425165`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1252009645]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Norms in NDSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 40, 24.5409962}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "NDSolve uses norms of error estimates to determine when solutions \
satisfy error tolerances. In nearly all cases a norm which has been weighted, \
or scaled, such that it is less than 1 if error tolerances have been \
satisfied and greater than one if error tolerances are not satisfied. One \
significant advantage of such a scaled norm is that a given method can be \
written without explicit reference to tolerances: the satisfaction of \
tolerances however specified is found by comparing the scaled norm to 1, thus \
simplifying the code required for checking error estimates within methods. \
Suppose that v is vector and u is a reference vector to compute weights with \
(typically u is an approximate solution vector). Then the scaled vector, w to \
which the norm is applied has components: where absolute and relative \
tolerances, t_a and t_r are derived respectively from the AccuracyGoal->ag \
and PrecisionGoal->pg options by t_a = 10^-ag and t_r = 10^-pg.", 
    "synonyms" -> {}, "title" -> "Norms in NDSolve", "type" -> "Tutorial", 
    "uri" -> "tutorial/NDSolveVectorNorm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "scaling"->{
  Cell[2363, 77, 364, 13, 70, "NumberedEquation",
   CellTags->"scaling",
   CellID->828692595]},
 "s:2"->{
  Cell[16619, 559, 81, 2, 70, "Section",
   CellTags->{"s:2", "svn"},
   CellID->87309426]},
 "svn"->{
  Cell[16619, 559, 81, 2, 70, "Section",
   CellTags->{"s:2", "svn"},
   CellID->87309426]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"scaling", 29839, 1024},
 {"s:2", 29947, 1028},
 {"svn", 30050, 1032}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 524, 13, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1149, 40, 53, 1, 70, "Title",
 CellID->114241363],
Cell[1205, 43, 679, 13, 70, "Text",
 CellID->956934756],
Cell[1887, 58, 473, 17, 70, "Text",
 CellID->391554682],
Cell[2363, 77, 364, 13, 70, "NumberedEquation",
 CellTags->"scaling",
 CellID->828692595],
Cell[2730, 92, 720, 29, 70, "Text",
 CellID->1378675378],
Cell[3453, 123, 288, 10, 70, "Text",
 CellID->1679523494],
Cell[3744, 135, 615, 16, 70, "DefinitionBox3Col",
 CellID->1490674363],
Cell[4362, 153, 200, 8, 70, "Caption",
 CellID->578199448],
Cell[4565, 163, 430, 10, 70, "Text",
 CellID->2036440012],
Cell[4998, 175, 1284, 39, 70, "Text",
 CellID->316987793],
Cell[6285, 216, 194, 4, 70, "MathCaption",
 CellID->1992181047],
Cell[CellGroupData[{
Cell[6504, 224, 1270, 37, 70, "Input",
 CellID->105085353],
Cell[7777, 263, 282, 9, 39, "Output",
 CellID->108472827]
}, Open  ]],
Cell[8074, 275, 757, 24, 70, "Text",
 CellID->131449927],
Cell[8834, 301, 1220, 44, 70, "Text",
 CellID->1360199505],
Cell[10057, 347, 197, 4, 70, "MathCaption",
 CellID->774735355],
Cell[CellGroupData[{
Cell[10279, 355, 689, 22, 70, "Input",
 CellID->370269244],
Cell[10971, 379, 813, 19, 54, "Output",
 CellID->1745739701]
}, Open  ]],
Cell[11799, 401, 198, 4, 70, "MathCaption",
 CellID->1020168079],
Cell[CellGroupData[{
Cell[12022, 409, 688, 22, 70, "Input",
 CellID->59147252],
Cell[12713, 433, 1455, 31, 105, "Output",
 CellID->1247629233]
}, Open  ]],
Cell[14183, 467, 146, 4, 70, "Text",
 CellID->1310165860],
Cell[14332, 473, 112, 3, 70, "MathCaption",
 CellID->863887120],
Cell[CellGroupData[{
Cell[14469, 480, 243, 8, 70, "Input",
 CellID->1752075622],
Cell[14715, 490, 242, 8, 36, "Output",
 CellID->1410794407]
}, Open  ]],
Cell[14972, 501, 475, 13, 70, "Text",
 CellID->1861653299],
Cell[15450, 516, 254, 5, 70, "MathCaption",
 CellID->1667244511],
Cell[CellGroupData[{
Cell[15729, 525, 362, 12, 70, "Input",
 CellID->533319899],
Cell[16094, 539, 245, 8, 36, "Output",
 CellID->1580721047]
}, Open  ]],
Cell[16354, 550, 240, 5, 70, "Text",
 CellID->348738585],
Cell[CellGroupData[{
Cell[16619, 559, 81, 2, 70, "Section",
 CellTags->{"s:2", "svn"},
 CellID->87309426],
Cell[16703, 563, 528, 14, 70, "Text",
 CellID->675670517],
Cell[17234, 579, 4433, 158, 70, "DefinitionBox",
 CellID->1305673341],
Cell[21670, 739, 109, 4, 70, "Caption",
 CellID->478864108],
Cell[21782, 745, 36, 1, 70, "Text",
 CellID->857641478],
Cell[21821, 748, 279, 9, 70, "MathCaption",
 CellID->1504363112],
Cell[CellGroupData[{
Cell[22125, 761, 347, 11, 70, "Input",
 CellID->536865071],
Cell[22475, 774, 295, 9, 39, "Output",
 CellID->1410145176]
}, Open  ]],
Cell[22785, 786, 139, 4, 70, "MathCaption",
 CellID->847553828],
Cell[CellGroupData[{
Cell[22949, 794, 365, 13, 70, "Input",
 CellID->1115064520],
Cell[23317, 809, 176, 5, 36, "Output",
 CellID->517824966]
}, Open  ]],
Cell[23508, 817, 191, 4, 70, "MathCaption",
 CellID->1164541621],
Cell[CellGroupData[{
Cell[23724, 825, 473, 16, 70, "Input",
 CellID->959761919],
Cell[24200, 843, 178, 5, 36, "Output",
 CellID->1270126337]
}, Open  ]],
Cell[24393, 851, 618, 22, 70, "Text",
 CellID->1130152219],
Cell[25014, 875, 80, 1, 70, "MathCaption",
 CellID->1091211846],
Cell[CellGroupData[{
Cell[25119, 880, 679, 20, 70, "Input",
 CellID->1365145178],
Cell[25801, 902, 409, 14, 36, "Output",
 CellID->403841813]
}, Open  ]],
Cell[26225, 919, 117, 3, 70, "MathCaption",
 CellID->1461481090],
Cell[CellGroupData[{
Cell[26367, 926, 149, 4, 70, "Input",
 CellID->1454278190],
Cell[26519, 932, 357, 10, 39, "Output",
 CellID->879152758]
}, Open  ]],
Cell[26891, 945, 143, 4, 70, "MathCaption",
 CellID->1520628343],
Cell[CellGroupData[{
Cell[27059, 953, 380, 13, 70, "Input",
 CellID->545655820],
Cell[27442, 968, 178, 5, 36, "Output",
 CellID->1252009645]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[27659, 978, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

