(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     92900,       2654]
NotebookOptionsPosition[     77677,       2165]
NotebookOutlinePosition[     83943,       2339]
CellTagsIndexPosition[     83747,       2329]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Numerical Integration in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/NIntegrateOverview"], 
          "NIntegrate Integration Strategies" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NIntegrateIntegrationStrategies"], 
          "NIntegrate Integration Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NIntegrateIntegrationRules"], 
          "NIntegrate References" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NIntegrateReferences"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Numerical Integration in Mathematica\"\>", 
       2->"\<\"NIntegrate Integration Strategies\"\>", 
       3->"\<\"NIntegrate Integration Rules\"\>", 
       4->"\<\"NIntegrate References\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], "Calculus" :> 
          Documentation`HelpLookup["paclet:guide/Calculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Evaluation & Precision\"\>", 
       2->"\<\"Calculus\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "NIntegrate" :> 
          Documentation`HelpLookup["paclet:ref/NIntegrate"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"NIntegrate\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NIntegrate Introduction", "Title",
 CellID->686479909],

Cell[CellGroupData[{

Cell["Overview", "Section",
 CellID->32344101],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " is a general numerical integrator. It can handle a wide range of ",
 "one-dimensional",
 " and multidimensional integrals. "
}], "Text",
 CellID->90230020],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["n", "TI"]]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["n", "TI"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["n", "TI"]], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["n", "TI"]]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find a numerical integral for the function ",
     StyleBox["f", "TI"],
     " over the region ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"[", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["b", "TI"], 
          StyleBox["2", "TR"]]}], "]"}], "\[Times]", 
       RowBox[{"[", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["b", "TI"], 
          StyleBox["2", "TR"]]}], "]"}], "\[Times]", 
       StyleBox["\[Ellipsis]", "TR"], "\[Times]", 
       RowBox[{"[", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["n", "TI"]], ",", 
         SubscriptBox[
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"]]}], "]"}]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->129413633],

Cell["Finding a numerical integral of a function over a region. ", "Caption",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->276966420],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " estimates the integral through sampling of the integrand value over the \
integration region. The various numerical integration methods prescribe how \
this sampling is done: what are its initial steps, and how it evolves."
}], "Text",
 CellID->1014951362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " uses algorithms called ",
 ButtonBox["integration strategies",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateIntegrationStrategies"],
 " that attempt to compute integral estimates that satisfy user-specified \
precision or accuracy goals. The ",
 ButtonBox["integration strategies",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateIntegrationStrategies"],
 " use ",
 ButtonBox["integration rules",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateIntegrationRules"],
 " that compute integral estimates using weighted sums."
}], "Text",
 CellID->210900632],

Cell[TextData[{
 "This ",
 "numerically ",
 "computes the integral ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    StyleBox["0", "TR"], 
    StyleBox["1", "TR"]], 
   RowBox[{
    FractionBox[
     StyleBox["1", "TR"], 
     SqrtBox[
      StyleBox["x", "TI"]]], 
    StyleBox[
     RowBox[{"\[DifferentialD]", "x"}], "TI"]}]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->322833310],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["x"]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], 
  TraditionalForm]]]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[25]:=",
 CellID->1918162],

Cell[BoxData["2.000000000000003`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[25]=",
 CellID->122012434]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " uses symbolic preprocessing that simplifies integrals with piecewise \
functions and even or odd functions. Part of the symbolic preprocessing is \
the detection of ",
 "one-dimensional",
 " oscillatory integrals of the types ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " can handle efficiently."
}], "Text",
 CellID->124473726],

Cell[TextData[{
 "This integrates a piecewise function over the interval ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    StyleBox["0", "TR"], ",", 
    StyleBox["2", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->485008965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"Abs", "[", 
      RowBox[{"x", "-", "1"}], "]"}]]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"In[26]:=",
 CellID->55895970],

Cell[BoxData["3.9999999999999725`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellLabel->"Out[26]=",
 CellID->540228606]
}, Open  ]],

Cell[TextData[{
 "This integrates a highly oscillatory function over the interval ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    StyleBox["2", "TR"], ",", 
    StyleBox["3", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->374698639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"4000", " ", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->238926897],

Cell[BoxData[
 RowBox[{"-", "0.00015862464665268567`"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->116637154]
}, Open  ]],

Cell[TextData[{
 "This is a plot of the previous oscillatory integrand over ",
 Cell[BoxData[
  FractionBox[
   StyleBox["1", "TR"], 
   StyleBox["50", "TR"]]], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[Null]", TraditionalForm]]],
 " of the integration region."
}], "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->201867952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"4000", " ", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"2", "+", 
      FractionBox["2", "50"]}], ",", 
     RowBox[{"2", "+", 
      FractionBox["3", "50"]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->119048880],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->229607086]
}, Open  ]],

Cell["\<\
This integrates a piecewise combination of a piecewise function and an \
oscillatory function.\
\>", "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->328867472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", 
         SqrtBox[
          RowBox[{"Abs", "[", 
           RowBox[{"x", "-", "1"}], "]"}]]], ",", 
        RowBox[{"x", "<", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", "2"}], ")"}], "2"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"4000", " ", "x"}], "]"}]}], ",", 
        RowBox[{"2", "<", "x", "<", "3"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->251150889],

Cell[BoxData["3.99984137535332`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->790839221]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " oscillatory algorithms are only for one-dimensional integrals. The \
oscillatory algorithms for finite regions are different from the oscillatory \
algorithms for infinite regions."
}], "Text",
 CellID->21381496],

Cell[TextData[{
 "One-dimensional numerical integration is much simpler, and better \
understood, than multidimensional numerical integration. This is the reason a \
distinction between the two is made. All ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " strategies except the oscillatory strategies can be used for \
multidimensional integration."
}], "Text",
 CellID->259063148],

Cell[TextData[{
 "Here is a two-dimensional function: a cone with base in the square ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["1", "TR"]}], ",", 
    StyleBox["1", "TR"]}], "]"}]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["1", "TR"]}], ",", 
    StyleBox["1", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->223512106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "<", "1"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->361728051],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->408207039]
}, Open  ]],

Cell["Here is the integral of the cone function above.", "MathCaption",
 CellID->713070890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "<", "1"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->112694592],

Cell[BoxData["1.047197482348112`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->49046290]
}, Open  ]],

Cell[TextData[{
 "Here are the sampling points used by ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". Note that the sampling points are only in a quarter of the integration \
region."
}], "MathCaption",
 CellID->382861055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{
       RowBox[{"Reap", "[", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Boole", "[", 
            RowBox[{
             RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}], "<", "1"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["x", "2"], "+", 
               SuperscriptBox["y", "2"]}]]}], ")"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
           RowBox[{"Sow", "[", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->12503716],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWktPFEEQbnb2wUthAXnDLkEkIfFxMPFgYmKImiAe1YNRsyEmcDAa9R/5
Bzz4/9rpmenp6q+qu3dAFCPJzmzNVFdV1+OrmmFfjL6dfvg4+nZ2Mho++zL6
fHp28nX49NOX/FI2oZT6mX9+rKr8u86/FZ+fWudnfnyeH7OcoWUo80UXf6qV
f31fcBzDncwc2o5W6l1xepIfzeVsTP603E5l26sG/JTjYuuMZ4wXuuTMud5c
4lWj9fWla/l/7HS5dFUsulp22oynFawMNgSz/0hjLfWAD9GgXGexoiw9slxc
bzhfXkgfX9fRsaqW+SlfHDN61Vnm+r+q7l+x8/KtN1kR6rUDHa69HeAfRngH
ER0Fv5qEO7wfbrErWGXbQA+SK7aSWlvlKas2U+0nPU2s6BIhWn/R6qvt0/NY
Z/FxpzoPgxzDS7YCMz/uI1wxGNM6i9h22htoH8lR8xDub8P6Mo3/LF5N58fv
Nk8KKtaxmtLYKS8qz9A9VblM2T9dg4DxomqXtIuU9bmHbSSmpRTKoWxWuKhX
cqw8o6St+CzQEf14C+i9/NBVHLlw3bwukXmP7qKMZI/mozu2iNRiA1qeWQon
dejulOIdANECfOJZlBHv2PMS48eIzklxIfS05n3L+dl2WzsTunygfqh35sXb
2tg0h9cJbeRcqy1pg862IB33h3l5E6R3K886P0t5swFS1pjfF30rXY2QiIXs
rBeQ+9eAXqrkYDy70fyQa6xDuJplT0F3eWU479FscUeKG+UlrCNr8Txo5L0B
M7UPNO6B1LSXn7zWaAykmGC3xOmgsIzV/LTTj/gQeUYSdxHQLdmKVeXyJFYt
SKNVqepCrQtAm/wxUZ4UrelrkrVJ7NyvuGdqWTTzAxXoZUCfXCkvYvZhxJdq
XVmFTEHsj9BdcX/XE750+1STvALLI/poo7JwcXwLfkulpLJRrBy5ZiPZBthA
o+FZK2mve56306lar9QT69xib0jsbISojTRi1Zynr9fYz5ifqG83EFHc2Q0h
XsYivB6a9pzfYj3uXOji+WMAHIiSs7UdWVXftN+J0xarggUvJmE84f1MzOJI
VaxIXoTZjHsVY4xem0ncX9AEg9nu3bTVpE+gTrQR+8CsRuxmaBGtg0nGgTW+
JGgM+DZaGWCLlusctR/U0qM4QuYfORe3tFxvNO8Nn8MRyoUdZUbUkcIUvI81
53qiNNPFsgSfxtBejBn6kfSrSNVJ7zikiRxjiutSb7Ud9sS8Z5+3psRY8BkF
O/ea523emb0nQ8g5Q66Ieh3mxap2XsvTBGZEP+wJz1b0uOQrdp/ZjnFaLq4f
6/D7WLT3uigXMQfzxb4zKGbG4r8M8TeDUtWHnsbFp6CIp2Z97ZWUfgPLMiXN
H3YOuMnubDTcNUZpDWhx2mV5z/XZ3o4xxcklNSlhri1H9DXLatwJzoDljGbz
1b67xAjbbMN9FfXMag25NpmV2+K61MSCCI0TlesF8Wd2tA99gnY41KNXVyVP
R6cC3A/Wn/Nmq0LFGqsjubPvreKYLPYtQj8Qd7cL9D2RK4TRaDPbef51XZSY
6p+eBoaaWB9y5FDHIOEhWQpmEUpFKeiDTVGqODWNHX2K7stanjRS737c9Ig1
YqStiX7fi6459GwMTw1HHh9GHj2Bnro9vj8bT6G7ouxNoMWJQZbC0ZDw3ff8
cDBWfLASU1gq1zPvwZhvD8V1KB1jhbSdgu+I0hCPxWcCb069G94NizX2fmdD
cDoj9CNRk/9LHVzzJOyzRhMpQWo+DSURXZ4zD0VezKbHBdexDv+SgFe1RepS
wwtYw9+stzWZAwnncYP1Em40We9+V5Tmf9uIz05YdqYtf/HIf32pJn4Bip3T
WQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->198865519]
}, Open  ]],

Cell[TextData[{
 "Here are the sampling points used by ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " without symbolic preprocessing. (The reason that ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " gives the ",
 StyleBox["slwcon", "InlineCode"],
 " message is because no symbolic preprocessing is applied.) Note that the \
sampling points are in the whole integration region and that they are denser \
around the circumference of the cone base and around the cone apex."
}], "MathCaption",
 CellID->346148087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.005", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{
        RowBox[{"Reap", "[", 
         RowBox[{"NIntegrate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Boole", "[", 
             RowBox[{
              RowBox[{
               SuperscriptBox["x", "2"], "+", 
               SuperscriptBox["y", "2"]}], "<", "1"}], "]"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["x", "2"], "+", 
                SuperscriptBox["y", "2"]}]]}], ")"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"y", ",", 
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"Method", "->", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", 
              RowBox[{"\"\<SymbolicProcessing\>\"", "\[Rule]", "0"}]}], 
             "}"}]}], ",", 
           RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
            RowBox[{"Sow", "[", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellTags->"BooleX2Y2",
 CellLabel->"In[9]:=",
 CellID->219501012],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"BooleX2Y2",
 CellLabel->"During evaluation of In[9]:=",
 CellID->98270957],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"BooleX2Y2",
 CellLabel->"Out[9]=",
 CellID->644422723]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " has several ways to deal with singular integrands. The deterministic \
adaptive strategies ",
 Cell[BoxData["\"\<GlobalAdaptive\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<LocalAdaptive\>\""], "InlineFormula"],
 " use singularity handling techniques (based on variable transformations) to \
speed up the convergence of the integration process. The strategy ",
 Cell[BoxData["\"\<DoubleExponential\>\""], "InlineFormula"],
 " employs trapezoidal quadrature with a special variable transformation on \
the integrand. This rule-transformation combination achieves optimal \
convergence for integrands analytic on an open set in the complex plane \
containing the interval of integration. The strategy ",
 Cell[BoxData["\"\<DuffyCoordinates\>\""], "InlineFormula"],
 " simplifies or eliminates certain types of singularities in \
multidimensional integrals. "
}], "Text",
 CellID->24293703],

Cell["\<\
Here is a one-dimensional integration with singularity handling.\
\>", "MathCaption",
 CellID->144292604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["x"]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "10"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->504042034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.006998999999999968`", ",", "2.0000000000000018`"}], 
  "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->945116226]
}, Open  ]],

Cell["\<\
Without singularity handling the previous integral is computed more slowly.\
\>", "MathCaption",
 CellID->348884733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["x"]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<GlobalAdaptive\>\"", ",", 
       RowBox[{"\"\<SingularityDepth\>\"", "\[Rule]", "\[Infinity]"}]}], 
      "}"}]}], ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "100"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "10"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->131330598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.008999000000000009`", ",", "1.9999999999794231`"}], 
  "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->34655149]
}, Open  ]],

Cell[TextData[{
 "For multidimensional integrands that have certain spherical symmetry the \
strategy ",
 Cell[BoxData["\"\<DuffyCoordinates\>\""], "InlineFormula"],
 " converges quite fast."
}], "Text",
 CellID->155384238],

Cell[TextData[{
 "Here is a ",
 Cell[BoxData["\"\<DuffyCoordinates\>\""], "InlineFormula"],
 " integration."
}], "MathCaption",
 CellID->82802821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<DuffyCoordinates\>\""}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->34404064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.031`", ",", "1.19003862099665`"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->15924765]
}, Open  ]],

Cell["\<\
Here is a computation of the previous integral with the default settings; it \
is approximately 5 times slower.\
\>", "MathCaption",
 CellID->3224213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->293725387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.203`", ",", "1.1900386685414717`"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->223664577]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Trapezoidal\>\""], "InlineFormula"],
 " strategy gives optimal convergence for analytic periodic integrands when \
the integration interval is exactly one period."
}], "Text",
 CellID->153060388],

Cell[TextData[{
 "Here is a calculation of an integral computed with the ",
 ButtonBox["trapezoidal strategy",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateIntegrationStrategies#403370786"],
 ". The result is compared with the exact value. The result computed with ",
 Cell[BoxData["\"\<Trapezoidal\>\""], "InlineFormula"],
 " is obtained faster and it is more precise than the one with default ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " settings."
}], "MathCaption",
 CellID->91040756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exact", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"20", "x"}], "]"}], "4"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", 
       FractionBox["\[Pi]", "20"]}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->317348873],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "\[Pi]"}], "80"]], "Output",
 ImageSize->{27, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->88656254]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"resTrap", "=", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"20", "x"}], "]"}], "4"], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", 
         FractionBox["\[Pi]", "20"]}]}], "}"}], ",", 
      RowBox[{"PrecisionGoal", "\[Rule]", "150"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "200"}], ",", 
      RowBox[{"Method", "\[Rule]", "\"\<Trapezoidal\>\""}]}], "]"}]}], ";"}], 
  "//", "Timing"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->43925617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.015000000000001734`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->218010199]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"exact", "-", "resTrap"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->543522880],

Cell[BoxData["0``200.92881885957814"], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->559824289]
}, Open  ]],

Cell[TextData[{
 "Here is a (slower) computation of the integral above with the default ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " settings for ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->404436011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"resDef", "=", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"20", "x"}], "]"}], "4"], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", 
         FractionBox["\[Pi]", "20"]}]}], "}"}], ",", 
      RowBox[{"PrecisionGoal", "\[Rule]", "150"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "200"}]}], "]"}]}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->281663249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.21899999999999883`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->299213834]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"exact", "-", "resDef"}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->599569902],

Cell[BoxData["0``200.92881885957814"], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->78049895]
}, Open  ]],

Cell[TextData[{
 "For multidimensional integrals, or in cases when only a rough integral \
estimate is needed, Monte Carlo methods are useful. ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " has both crude and adaptive Monte Carlo and quasi Monte Carlo strategies."
}], "Text",
 CellID->126525694],

Cell["\<\
Here is a multidimensional integral done quickly with a Monte Carlo \
algorithm. \
\>", "MathCaption",
 CellID->25958205],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"x", ",", "30"}], "]"}]}], ";"}], "\n", 
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Total", "@", "X"}]], ",", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"Sequence", "@@", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", "0", ",", "1"}], "}"}], "&"}], ",", "X"}], "]"}]}],
     "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<AdaptiveMonteCarlo\>\""}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "3"}]}], "]"}]}], "Input",
 CellLabel->"In[19]:=",
 CellID->187654289],

Cell[BoxData["0.06741028722557996`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->78026056]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Design", "Section",
 CellID->951840905],

Cell[CellGroupData[{

Cell["Features", "Subsection",
 CellID->540272418],

Cell[TextData[{
 "The principal features of the ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " framework are:"
}], "Text",
 CellID->189906959],

Cell["Code reuse (common code base).", "BulletedText",
 CellID->62529729],

Cell["\<\
Object orientation (method property specification and communication).\
\>", "BulletedText",
 CellID->495852763],

Cell["Data hiding.", "BulletedText",
 CellID->30012610],

Cell["\<\
Separation of method initialization phase and run-time computation.\
\>", "BulletedText",
 CellID->13690217],

Cell["Heirarchical and reentrant numerical methods.", "BulletedText",
 CellID->794844331],

Cell["Type- and precision-dynamic methods.", "BulletedText",
 CellID->20659180],

Cell["\<\
User extensibility and prototyping through plug-in capabilities.\
\>", "BulletedText",
 CellID->313584622],

Cell["Specialized data structures.", "BulletedText",
 CellID->493886017]
}, Open  ]],

Cell[CellGroupData[{

Cell["Strategies, rules, and preprocessors", "Subsection",
 CellID->118305364],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " strategies can be divided into two general groups: deterministic and Monte \
Carlo. Each group can be divided further into adaptive, non-adaptive, and \
specialized strategies. Adaptive strategies try to improve the integral \
estimate by concentrating their efforts around the problematic areas. \
Non-adaptive strategies try to improve the integral estimate just by \
increasing the number of sampling points in the integration region. \
Specialized strategies are made for certain types of integrals (e.g., a \
product of an oscillatory and a non-oscillatory function)."
}], "Text",
 CellID->22394998],

Cell[BoxData[GridBox[{
   {
    StyleBox["Strategies", "TableHeader"], 
    StyleBox["Deterministic", "TableHeader"], 
    StyleBox[
     RowBox[{"Monte", " ", "Carlo"}], "TableHeader"]},
   {Cell["adaptive", "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<GlobalAdaptive\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#137878679"]], 
     "InlineFormula"]], "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<AdaptiveMonteCarlo\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#65285686"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<LocalAdaptive\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#19475523"]], 
     "InlineFormula"]], "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<AdaptiveQuasiMonteCarlo\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#65285686"]], 
     "InlineFormula"]], "TableText"]},
   {Cell["non-adaptive", "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<DoubleExponential\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#526196975"]], 
     "InlineFormula"]], "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<MonteCarlo\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#20795380"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<Trapezoidal\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#403370786"]], 
     "InlineFormula"]], "TableText"], ""},
   {"specialized", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<DuffyCoordinates\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#66551248"]], 
     "InlineFormula"]], "TableText"], ""},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<Oscillatory\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#775797877"]], 
     "InlineFormula"]], "TableText"], ""},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<PrincipalValue\>\"",
      BaseStyle->"Link",
      ButtonData->
       "paclet:tutorial/NIntegrateIntegrationStrategies#295594003"]], 
     "InlineFormula"]], "TableText"], ""}
  },
  GridBoxDividers->{
   "Columns" -> {{True}}, 
    "Rows" -> {
     True, True, False, True, False, True, False, False, True}}]], "Text",
 CellID->28300356],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " built-in integration strategies."
}], "Caption",
 CellID->45889112],

Cell[TextData[{
 "The strategies ",
 Cell[BoxData["\"\<GlobalAdaptive\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<LocalAdaptive\>\""], "InlineFormula"],
 " can have specifications of what integration rules to use."
}], "Text",
 CellID->159671742],

Cell[TextData[{
 "Here is an example of ",
 Cell[BoxData["\"\<GlobalAdaptive\>\""], "InlineFormula"],
 " with an integration rule specification."
}], "MathCaption",
 CellID->156138199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     SqrtBox["x"]], 
    RowBox[{"Log", "[", 
     FractionBox["1", "x"], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<GlobalAdaptive\>\"", ",", 
      RowBox[{"Method", "\[Rule]", "\"\<ClenshawCurtisRule\>\""}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->71462595],

Cell[BoxData["3.999999999996562`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->46185729]
}, Open  ]],

Cell[TextData[{
 "Both ",
 Cell[BoxData["\"\<GlobalAdaptive\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<LocalAdaptive\>\""], "InlineFormula"],
 " adaptive strategies can be used with one-dimensional and multidimensional \
integration rules. "
}], "Text",
 CellID->52297163],

Cell[BoxData[GridBox[{
   {
    StyleBox["-", "TableHeader"], 
    StyleBox["Rules", "TableHeader"]},
   {Cell["one-dimensional", "TableText"], Cell[TextData[Cell[BoxData[
    "\"\<BooleRule\>\""], "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<ClenshawCurtisRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#486402291"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<GaussBerntsenEspelidRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#141675390"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<GaussKronrodRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#381359375"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<LobattoKronrodRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#210486704"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
    "\"\<LobattoPeanoRule\>\""], "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<MultiPanelRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#106389821"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<NewtonCotesRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#81663330"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
    "\"\<PattersonRule\>\""], "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
    "\"\<SimpsonThreeEightsRule\>\""], "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<TrapezoidalRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#618158740"]], 
     "InlineFormula"]], "TableText"]},
   {Cell["multidimensional", "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<CartesianRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#650745857"]], 
     "InlineFormula"]], "TableText"]},
   {"\[SpanFromAbove]", Cell[TextData[Cell[BoxData[
     ButtonBox["\"\<MultiDimensionalRule\>\"",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NIntegrateIntegrationRules#89177434"]], 
     "InlineFormula"]], "TableText"]}
  },
  GridBoxDividers->{
   "Columns" -> {{True}}, 
    "Rows" -> {
     True, True, False, False, False, False, False, False, False, False, 
      False, False, True, False, True}}]], "Text",
 CellID->190637714],

Cell[TextData[{
 "Built-in integration rules that can be used by ",
 Cell[BoxData["\"\<GlobalAdaptive\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<LocalAdaptive\>\""], "InlineFormula"],
 "."
}], "Caption",
 CellID->77126155],

Cell["\<\
The capabilities of all strategies are extended through integral \
preprocessing. The preprocessors can be seen as strategies that delegate \
integration to other strategies (preprocessors included). \
\>", "Text",
 CellID->342948775],

Cell["\<\
Here is an example of the preprocessing of an integrand which is even with \
respect to each of its variables.\
\>", "MathCaption",
 CellID->143763040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "<", "1"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<EvenOddSubdivision\>\"", ",", 
      RowBox[{"Method", "\[Rule]", "\"\<LocalAdaptive\>\""}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->129667777],

Cell[BoxData["1.0471982131248494`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->34375458]
}, Open  ]],

Cell[TextData[{
 "Here are the sampling points of the previous integration. If no \
preprocessing was done the plot would have been in the region ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["1", "TR"]}], ",", 
    StyleBox["1", "TR"]}], "]"}]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["1", "TR"]}], ",", 
    StyleBox["1", "TR"]}], "]"}]], "InlineFormula"],
 " with a symmetry along both the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis and the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " axis. "
}], "MathCaption",
 CellID->178487198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.005", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{
       RowBox[{"Reap", "[", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Boole", "[", 
            RowBox[{
             RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}], "<", "1"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["x", "2"], "+", 
               SuperscriptBox["y", "2"]}]]}], ")"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"Method", "->", 
           RowBox[{"{", 
            RowBox[{"\"\<EvenOddSubdivision\>\"", ",", 
             RowBox[{"Method", "\[Rule]", "\"\<LocalAdaptive\>\""}]}], 
            "}"}]}], ",", 
          RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
           RowBox[{"Sow", "[", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->407133930],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->281735531]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    StyleBox["Preprocessors", "TableHeader"]},
   {Cell[TextData[Cell[BoxData[
    "\"\<SymbolicPiecewiseSubdivision\>\""], "InlineFormula"]], 
     "TableText"]},
   {Cell[TextData[Cell[BoxData[
    "\"\<EvenOddSubdivision\>\""], "InlineFormula"]], "TableText"]},
   {Cell[TextData[Cell[BoxData[
    "\"\<OscillatorySelection\>\""], "InlineFormula"]], "TableText"]},
   {Cell[TextData[Cell[BoxData[
    "\"\<UnitCubeRescaling\>\""], "InlineFormula"]], "TableText"]}
  },
  GridBoxDividers->{
   "Columns" -> {{True}}, 
    "Rows" -> {True, True, False, False, False, True}}]], "Text",
 CellID->88362486],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " preprocessors."
}], "Caption",
 CellID->377176834]
}, Open  ]],

Cell[CellGroupData[{

Cell["User extensibility", "Subsection",
 CellTags->"s:2.5",
 CellID->2713904],

Cell["\<\
Built-in methods can be used as building blocks for the efficient \
construction of special-purpose integrators. User-defined integration rules \
and strategies can also be added.\
\>", "Text",
 CellID->54506735]
}, Open  ]],

Cell[CellGroupData[{

Cell["Acknowledgements", "Subsection",
 CellID->425413732],

Cell["Special thanks to:", "Text",
 CellID->1807101602],

Cell[TextData[{
 "Robert Knapp for the advice and numerous discussions of the design and \
implementation of the ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " framework."
}], "Text",
 CellID->14901408],

Cell["\<\
Darren Glosemeyer for discussions on Monte Carlo algorithms, interface \
design, and documentation-writing.\
\>", "Text",
 CellID->246628823],

Cell[TextData[{
 "Adam Berry for implementing the ",
 ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/NIntegrateExplorer"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/NIntegrateExplorer"],
 ButtonBox["Explorer",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/NIntegrateExplorer"],
 " and documentation reading and comments."
}], "Text",
 CellID->200026667],

Cell[TextData[{
 "Michael Trott, Eric Weisstein, and Bhuvanesh Bhatt for improvements, \
suggestions, and the use of the early versions of the ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " framework."
}], "Text",
 CellID->180611356],

Cell["Lisa Byrge for documentation reading and comments.", "Text",
 CellID->81165815],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->171462907],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"]], "TutorialMoreAbout",
 CellID->341702418],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "TutorialMoreAbout",
 CellID->168618367]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->289585108],

Cell[TextData[{
 ButtonBox["Advanced Numerical Integration in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->655978384],

Cell[TextData[ButtonBox["NIntegrate Integration Strategies",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies"]], "RelatedTutorials",
 CellID->129348187],

Cell[TextData[ButtonBox["NIntegrate Integration Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules"]], "RelatedTutorials",
 CellID->314773658],

Cell[TextData[ButtonBox["NIntegrate References",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NIntegrateReferences"]], "RelatedTutorials",
 CellID->20913699]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate Introduction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 3.5888708}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The Mathematica function NIntegrate is a general numerical integrator. \
It can handle a wide range of one-dimensional and multidimensional integrals. \
Finding a numerical integral of a function over a region. In general, \
NIntegrate estimates the integral through sampling of the integrand value \
over the integration region. The various numerical integration methods \
prescribe how this sampling is done: what are its initial steps, and how it \
evolves.", "synonyms" -> {}, "title" -> "NIntegrate Introduction", "type" -> 
    "Tutorial", "uri" -> "tutorial/NIntegrateIntroduction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.7"->{
  Cell[6232, 201, 137, 2, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->276966420],
  Cell[7533, 239, 460, 19, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->322833310],
  Cell[8018, 262, 316, 11, 37, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1918162],
  Cell[8337, 275, 266, 8, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->122012434],
  Cell[9174, 304, 293, 10, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->485008965],
  Cell[9492, 318, 324, 11, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->55895970],
  Cell[9819, 331, 217, 6, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->540228606],
  Cell[10051, 340, 302, 10, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->374698639],
  Cell[10947, 377, 351, 11, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->201867952],
  Cell[18096, 520, 192, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->328867472]},
 "b:1"->{
  Cell[6232, 201, 137, 2, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->276966420],
  Cell[7533, 239, 460, 19, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->322833310],
  Cell[8018, 262, 316, 11, 37, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1918162],
  Cell[8337, 275, 266, 8, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->122012434],
  Cell[9174, 304, 293, 10, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->485008965],
  Cell[9492, 318, 324, 11, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->55895970],
  Cell[9819, 331, 217, 6, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->540228606],
  Cell[10051, 340, 302, 10, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->374698639],
  Cell[10947, 377, 351, 11, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->201867952],
  Cell[18096, 520, 192, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->328867472]},
 "ndsg:0"->{
  Cell[6232, 201, 137, 2, 70, "Caption",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->276966420],
  Cell[7533, 239, 460, 19, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->322833310],
  Cell[8018, 262, 316, 11, 37, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->1918162],
  Cell[8337, 275, 266, 8, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->122012434],
  Cell[9174, 304, 293, 10, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->485008965],
  Cell[9492, 318, 324, 11, 70, "Input",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->55895970],
  Cell[9819, 331, 217, 6, 36, "Output",
   CellTags->{"S3.9.7", "b:1", "ndsg:0"},
   CellID->540228606],
  Cell[10051, 340, 302, 10, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->374698639],
  Cell[10947, 377, 351, 11, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->201867952],
  Cell[18096, 520, 192, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->328867472]},
 "7.5"->{
  Cell[7533, 239, 460, 19, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->322833310],
  Cell[9174, 304, 293, 10, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->485008965],
  Cell[10051, 340, 302, 10, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->374698639],
  Cell[10947, 377, 351, 11, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->201867952],
  Cell[18096, 520, 192, 5, 70, "MathCaption",
   CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
   CellID->328867472]},
 "BooleX2Y2"->{
  Cell[39505, 1009, 1730, 49, 70, "Input",
   CellTags->"BooleX2Y2",
   CellID->219501012],
  Cell[41238, 1060, 589, 11, 48, "Message",
   CellTags->"BooleX2Y2",
   CellID->98270957],
  Cell[41830, 1073, 5458, 94, 193, "Output",
   Evaluatable->False,
   CellTags->"BooleX2Y2",
   CellID->644422723]},
 "s:2.5"->{
  Cell[74474, 2043, 78, 2, 70, "Subsection",
   CellTags->"s:2.5",
   CellID->2713904]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.7", 79331, 2202},
 {"b:1", 80457, 2233},
 {"ndsg:0", 81586, 2264},
 {"7.5", 82712, 2295},
 {"BooleX2Y2", 83321, 2311},
 {"s:2.5", 83635, 2322}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2533, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3158, 89, 60, 1, 70, "Title",
 CellID->686479909],
Cell[CellGroupData[{
Cell[3243, 94, 46, 1, 70, "Section",
 CellID->32344101],
Cell[3292, 97, 370, 13, 70, "Text",
 CellID->90230020],
Cell[3665, 112, 2564, 87, 70, "DefinitionBox",
 CellID->129413633],
Cell[6232, 201, 137, 2, 70, "Caption",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->276966420],
Cell[6372, 205, 415, 10, 70, "Text",
 CellID->1014951362],
Cell[6790, 217, 740, 20, 70, "Text",
 CellID->210900632],
Cell[7533, 239, 460, 19, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->322833310],
Cell[CellGroupData[{
Cell[8018, 262, 316, 11, 37, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->1918162],
Cell[8337, 275, 266, 8, 36, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->122012434]
}, Open  ]],
Cell[8618, 286, 553, 16, 70, "Text",
 CellID->124473726],
Cell[9174, 304, 293, 10, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->485008965],
Cell[CellGroupData[{
Cell[9492, 318, 324, 11, 70, "Input",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->55895970],
Cell[9819, 331, 217, 6, 36, "Output",
 CellTags->{"S3.9.7", "b:1", "ndsg:0"},
 CellID->540228606]
}, Open  ]],
Cell[10051, 340, 302, 10, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->374698639],
Cell[CellGroupData[{
Cell[10378, 354, 353, 12, 70, "Input",
 CellID->238926897],
Cell[10734, 368, 198, 6, 36, "Output",
 CellID->116637154]
}, Open  ]],
Cell[10947, 377, 351, 11, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->201867952],
Cell[CellGroupData[{
Cell[11323, 392, 451, 16, 42, "Input",
 CellID->119048880],
Cell[11777, 410, 6304, 107, 109, "Output",
 Evaluatable->False,
 CellID->229607086]
}, Open  ]],
Cell[18096, 520, 192, 5, 70, "MathCaption",
 CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"},
 CellID->328867472],
Cell[CellGroupData[{
Cell[18313, 529, 765, 25, 70, "Input",
 CellID->251150889],
Cell[19081, 556, 175, 5, 36, "Output",
 CellID->790839221]
}, Open  ]],
Cell[19271, 564, 354, 9, 70, "Text",
 CellID->21381496],
Cell[19628, 575, 461, 11, 70, "Text",
 CellID->259063148],
Cell[20092, 588, 440, 17, 70, "MathCaption",
 CellID->223512106],
Cell[CellGroupData[{
Cell[20557, 609, 670, 23, 43, "Input",
 CellID->361728051],
Cell[21230, 634, 12641, 211, 160, "Output",
 Evaluatable->False,
 CellID->408207039]
}, Open  ]],
Cell[33886, 848, 91, 1, 70, "MathCaption",
 CellID->713070890],
Cell[CellGroupData[{
Cell[34002, 853, 623, 22, 70, "Input",
 CellID->112694592],
Cell[34628, 877, 174, 5, 36, "Output",
 CellID->49046290]
}, Open  ]],
Cell[34817, 885, 305, 9, 70, "MathCaption",
 CellID->382861055],
Cell[CellGroupData[{
Cell[35147, 898, 1534, 46, 112, "Input",
 CellID->12503716],
Cell[36684, 946, 2108, 39, 197, "Output",
 Evaluatable->False,
 CellID->198865519]
}, Open  ]],
Cell[38807, 988, 673, 17, 70, "MathCaption",
 CellID->346148087],
Cell[CellGroupData[{
Cell[39505, 1009, 1730, 49, 70, "Input",
 CellTags->"BooleX2Y2",
 CellID->219501012],
Cell[41238, 1060, 589, 11, 48, "Message",
 CellTags->"BooleX2Y2",
 CellID->98270957],
Cell[41830, 1073, 5458, 94, 193, "Output",
 Evaluatable->False,
 CellTags->"BooleX2Y2",
 CellID->644422723]
}, Open  ]],
Cell[47303, 1170, 1038, 21, 70, "Text",
 CellID->24293703],
Cell[48344, 1193, 115, 3, 70, "MathCaption",
 CellID->144292604],
Cell[CellGroupData[{
Cell[48484, 1200, 315, 11, 70, "Input",
 CellID->504042034],
Cell[48802, 1213, 245, 8, 36, "Output",
 CellID->945116226]
}, Open  ]],
Cell[49062, 1224, 126, 3, 70, "MathCaption",
 CellID->348884733],
Cell[CellGroupData[{
Cell[49213, 1231, 563, 17, 70, "Input",
 CellID->131330598],
Cell[49779, 1250, 244, 8, 36, "Output",
 CellID->34655149]
}, Open  ]],
Cell[50038, 1261, 223, 6, 70, "Text",
 CellID->155384238],
Cell[50264, 1269, 146, 5, 70, "MathCaption",
 CellID->82802821],
Cell[CellGroupData[{
Cell[50435, 1278, 596, 19, 70, "Input",
 CellID->34404064],
Cell[51034, 1299, 225, 7, 36, "Output",
 CellID->15924765]
}, Open  ]],
Cell[51274, 1309, 160, 4, 70, "MathCaption",
 CellID->3224213],
Cell[CellGroupData[{
Cell[51459, 1317, 528, 18, 70, "Input",
 CellID->293725387],
Cell[51990, 1337, 228, 7, 36, "Output",
 CellID->223664577]
}, Open  ]],
Cell[52233, 1347, 239, 6, 70, "Text",
 CellID->153060388],
Cell[52475, 1355, 589, 14, 70, "MathCaption",
 CellID->91040756],
Cell[CellGroupData[{
Cell[53089, 1373, 352, 12, 70, "Input",
 CellID->317348873],
Cell[53444, 1387, 205, 7, 51, "Output",
 CellID->88656254]
}, Open  ]],
Cell[CellGroupData[{
Cell[53686, 1399, 607, 18, 70, "Input",
 CellID->43925617],
Cell[54296, 1419, 227, 7, 36, "Output",
 CellID->218010199]
}, Open  ]],
Cell[CellGroupData[{
Cell[54560, 1431, 133, 4, 70, "Input",
 CellID->543522880],
Cell[54696, 1437, 179, 5, 36, "Output",
 CellID->559824289]
}, Open  ]],
Cell[54890, 1445, 391, 13, 70, "MathCaption",
 CellID->404436011],
Cell[CellGroupData[{
Cell[55306, 1462, 541, 17, 70, "Input",
 CellID->281663249],
Cell[55850, 1481, 226, 7, 36, "Output",
 CellID->299213834]
}, Open  ]],
Cell[CellGroupData[{
Cell[56113, 1493, 132, 4, 70, "Input",
 CellID->599569902],
Cell[56248, 1499, 178, 5, 36, "Output",
 CellID->78049895]
}, Open  ]],
Cell[56441, 1507, 378, 9, 70, "Text",
 CellID->126525694],
Cell[56822, 1518, 131, 4, 70, "MathCaption",
 CellID->25958205],
Cell[CellGroupData[{
Cell[56978, 1526, 641, 20, 70, "Input",
 CellID->187654289],
Cell[57622, 1548, 177, 5, 36, "Output",
 CellID->78026056]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57848, 1559, 45, 1, 70, "Section",
 CellID->951840905],
Cell[CellGroupData[{
Cell[57918, 1564, 50, 1, 70, "Subsection",
 CellID->540272418],
Cell[57971, 1567, 224, 8, 70, "Text",
 CellID->189906959],
Cell[58198, 1577, 73, 1, 70, "BulletedText",
 CellID->62529729],
Cell[58274, 1580, 121, 3, 70, "BulletedText",
 CellID->495852763],
Cell[58398, 1585, 55, 1, 70, "BulletedText",
 CellID->30012610],
Cell[58456, 1588, 118, 3, 70, "BulletedText",
 CellID->13690217],
Cell[58577, 1593, 89, 1, 70, "BulletedText",
 CellID->794844331],
Cell[58669, 1596, 79, 1, 70, "BulletedText",
 CellID->20659180],
Cell[58751, 1599, 116, 3, 70, "BulletedText",
 CellID->313584622],
Cell[58870, 1604, 72, 1, 70, "BulletedText",
 CellID->493886017]
}, Open  ]],
Cell[CellGroupData[{
Cell[58979, 1610, 78, 1, 70, "Subsection",
 CellID->118305364],
Cell[59060, 1613, 746, 14, 70, "Text",
 CellID->22394998],
Cell[59809, 1629, 2783, 68, 70, "Text",
 CellID->28300356],
Cell[62595, 1699, 209, 7, 70, "Caption",
 CellID->45889112],
Cell[62807, 1708, 256, 7, 70, "Text",
 CellID->159671742],
Cell[63066, 1717, 184, 5, 70, "MathCaption",
 CellID->156138199],
Cell[CellGroupData[{
Cell[63275, 1726, 487, 16, 70, "Input",
 CellID->71462595],
Cell[63765, 1744, 175, 5, 36, "Output",
 CellID->46185729]
}, Open  ]],
Cell[63955, 1752, 283, 8, 70, "Text",
 CellID->52297163],
Cell[64241, 1762, 2954, 63, 70, "Text",
 CellID->190637714],
Cell[67198, 1827, 233, 7, 70, "Caption",
 CellID->77126155],
Cell[67434, 1836, 244, 5, 70, "Text",
 CellID->342948775],
Cell[67681, 1843, 161, 4, 70, "MathCaption",
 CellID->143763040],
Cell[CellGroupData[{
Cell[67867, 1851, 801, 27, 70, "Input",
 CellID->129667777],
Cell[68671, 1880, 176, 5, 36, "Output",
 CellID->34375458]
}, Open  ]],
Cell[68862, 1888, 677, 24, 70, "MathCaption",
 CellID->178487198],
Cell[CellGroupData[{
Cell[69564, 1916, 1757, 51, 130, "Input",
 CellID->407133930],
Cell[71324, 1969, 2271, 41, 197, "Output",
 Evaluatable->False,
 CellID->281735531]
}, Open  ]],
Cell[73610, 2013, 632, 16, 70, "Text",
 CellID->88362486],
Cell[74245, 2031, 192, 7, 70, "Caption",
 CellID->377176834]
}, Open  ]],
Cell[CellGroupData[{
Cell[74474, 2043, 78, 2, 70, "Subsection",
 CellTags->"s:2.5",
 CellID->2713904],
Cell[74555, 2047, 222, 5, 70, "Text",
 CellID->54506735]
}, Open  ]],
Cell[CellGroupData[{
Cell[74814, 2057, 58, 1, 70, "Subsection",
 CellID->425413732],
Cell[74875, 2060, 55, 1, 70, "Text",
 CellID->1807101602],
Cell[74933, 2063, 284, 9, 70, "Text",
 CellID->14901408],
Cell[75220, 2074, 151, 4, 70, "Text",
 CellID->246628823],
Cell[75374, 2080, 435, 13, 70, "Text",
 CellID->200026667],
Cell[75812, 2095, 315, 9, 70, "Text",
 CellID->180611356],
Cell[76130, 2106, 85, 1, 70, "Text",
 CellID->81165815],
Cell[CellGroupData[{
Cell[76240, 2111, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->171462907],
Cell[76309, 2114, 186, 4, 70, "TutorialMoreAbout",
 CellID->341702418],
Cell[76498, 2120, 136, 3, 70, "TutorialMoreAbout",
 CellID->168618367]
}, Open  ]],
Cell[CellGroupData[{
Cell[76671, 2128, 72, 1, 70, "RelatedTutorialsSection",
 CellID->289585108],
Cell[76746, 2131, 314, 9, 70, "RelatedTutorials",
 CellID->655978384],
Cell[77063, 2142, 189, 4, 70, "RelatedTutorials",
 CellID->129348187],
Cell[77255, 2148, 179, 4, 70, "RelatedTutorials",
 CellID->314773658],
Cell[77437, 2154, 162, 3, 70, "RelatedTutorials",
 CellID->20913699]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[77650, 2163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

