(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27949,        923]
NotebookOptionsPosition[     22896,        775]
NotebookOutlinePosition[     26022,        852]
CellTagsIndexPosition[     25930,        846]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Mathematical and Other Notation" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/MathematicalAndOtherNotationOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Mathematical and Other Notation\"\>"}, "\<\"related tutorials\"\
\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Names of Symbols and Mathematical Objects", "Title",
 CellTags->{"S3.10.2", "2.1"},
 CellID->10302],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default interprets any sequence of letters or letter\[Hyphen]like forms \
as the name of a symbol. "
}], "Text",
 CellID->16234],

Cell[TextData[{
 "All these are treated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as symbols. "
}], "MathCaption",
 CellID->21115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Xi]", ",", "\[CapitalSigma]\[Alpha]", ",", "R\[Infinity]", ",", 
   "\[ScriptCapitalH]", ",", "\[Aleph]", ",", "\[Angle]ABC", ",", 
   "\[FilledSquare]X", ",", "m\[Ellipsis]n"}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Xi]", ",", "\[CapitalSigma]\[Alpha]", ",", "R\[Infinity]", ",", 
   "\[ScriptCapitalH]", ",", "\[Aleph]", ",", "\[Angle]ABC", ",", 
   "\[FilledSquare]X", ",", "m\[Ellipsis]n"}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1044150107]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["form", "TableHeader"], Cell["character name", "TableHeader"], Cell[
    "alias", "TableHeader"], Cell["interpretation", "TableHeader"]},
   {Cell[BoxData[
     FormBox["\[Pi]", TraditionalForm]], "InlineMath"], Cell[BoxData[
     ButtonBox["\\[Pi]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Pi"]], "InlineCharacterName"], Cell[
    TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]p\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"],
     ", ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]pi\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "equivalent to ",
     Cell[BoxData[
      ButtonBox["Pi",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Pi"]], "InlineFormula"]
    }], "TableText"]},
   {Cell[BoxData[
     FormBox["\[Infinity]", TraditionalForm]], "InlineMath"], Cell[BoxData[
     ButtonBox["\\[Infinity]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Infinity"]], "InlineCharacterName"], 
    Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]inf", "InlineCode"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "equivalent to ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell[BoxData[
     FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"], Cell[
    BoxData[
     ButtonBox["\\[ExponentialE]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/ExponentialE"]], 
     "InlineCharacterName"], Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]ee", "InlineCode"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "equivalent to ",
     Cell[BoxData[
      ButtonBox["E",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/E"]], "InlineFormula"]
    }], "TableText"]},
   {Cell[BoxData[
     FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"], Cell[BoxData[
     ButtonBox["\\[ImaginaryI]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/ImaginaryI"]], "InlineCharacterName"],
     Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "equivalent to ",
     Cell[BoxData[
      ButtonBox["I",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/I"]], "InlineFormula"]
    }], "TableText"]},
   {Cell[BoxData[
     FormBox["\[ImaginaryJ]", TraditionalForm]], "InlineMath"], Cell[BoxData[
     ButtonBox["\\[ImaginaryJ]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/ImaginaryJ"]], "InlineCharacterName"],
     Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]jj", "InlineCode"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "equivalent to ",
     Cell[BoxData[
      ButtonBox["I",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/I"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.1], 
     Scaled[0.3], 
     Scaled[0.25], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31074],

Cell["\<\
Symbols with built\[Hyphen]in meanings whose names do not start with capital \
English letters. \
\>", "Caption",
 CellID->22092],

Cell[TextData[{
 "Essentially all symbols with built\[Hyphen]in meanings in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have names that start with capital English letters. Among the exceptions \
are ",
 Cell[BoxData["\[ExponentialE]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[ImaginaryI]"], "InlineMath"],
 ", which correspond to ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " respectively. "
}], "Text",
 CellID->21984],

Cell[TextData[{
 "Forms such as ",
 Cell[BoxData["\[ExponentialE]"], "InlineMath"],
 " are used for both input and output in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[ExponentialE]", "^", 
    RowBox[{"(", 
     RowBox[{"2", " ", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}], ",", 
   RowBox[{"\[ExponentialE]", "^", "\[Pi]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "}"}]], "Output",
 ImageSize->{50, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91350179]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " ",
 Cell[BoxData["\[ExponentialE]"], "InlineMath"],
 " is output as ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21301],

Cell[OutputFormData["\<\
{1, E^Pi}\
\>", "\<\
     Pi
{1, E  }\
\>"], "Output",
 ImageSize->{56, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//OutputForm=",
 CellID->736543054]
}, Open  ]],

Cell[TextData[{
 "In written material, it is standard to use very short names\[LongDash]often \
single letters\[LongDash]for most of the mathematical objects that one \
considers. But in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it is usually better to use longer and more explicit names. "
}], "Text",
 CellID->30702],

Cell[TextData[{
 "In written material you can always explain that a particular \
single\[Hyphen]letter name means one thing in one place and another in \
another place. But in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", unless you use different contexts, a global symbol with a particular name \
will always be assumed to mean the same thing. "
}], "Text",
 CellID->30293],

Cell["\<\
As a result, it is typically better to use longer names, which are more \
likely to be unique, and which describe more explicitly what they mean. \
\>", "Text",
 CellID->25896],

Cell["\<\
For variables to which no value will be assigned, or for local symbols, it is \
nevertheless convenient and appropriate to use short, often \
single\[Hyphen]letter, names. \
\>", "Text",
 CellID->14020],

Cell[TextData[{
 "It is sensible to give the global function ",
 Cell[BoxData["LagrangianL"], "InlineFormula"],
 " a long and explicit name. The local variables can be given short names. "
}], "MathCaption",
 CellID->4901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LagrangianL", "[", 
   RowBox[{"\[Phi]_", ",", "\[Mu]_"}], "]"}], "=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Square]", "\[Phi]"}], ")"}], "2"], "+", 
   RowBox[{
    SuperscriptBox["\[Mu]", "2"], 
    SuperscriptBox["\[Phi]", "2"]}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18455],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[Mu]", "2"], " ", 
   SuperscriptBox["\[Phi]", "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"\[Square]", "\[Phi]"}], ")"}], "2"]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1214926069]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["form", "TableHeader"], Cell["input", "TableHeader"], Cell[
    "interpretation", "TableHeader"]},
   {
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["n", "TI"]], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["Subscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subscript"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["n", "TI"], "]"}]},
   {
    SubscriptBox[
     StyleBox["x", "TI"], "+"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " + ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["SubPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubPlus"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SubscriptBox[
     StyleBox["x", "TI"], "-"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " - ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["SubMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubMinus"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SubscriptBox[
     StyleBox["x", "TI"], "*"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " * ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["SubStar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubStar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SuperscriptBox[
     StyleBox["x", "TI"], "+"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " + ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["SuperPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperPlus"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SuperscriptBox[
     StyleBox["x", "TI"], "-"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " - ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["SuperMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperMinus"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SuperscriptBox[
     StyleBox["x", "TI"], "*"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " * ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["SuperStar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperStar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SuperscriptBox[
     StyleBox["x", "TI"], "\[Dagger]"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]dg\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["SuperDagger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperDagger"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "_"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " _ ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["OverBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverBar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "\[RightVector]"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]vec\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["OverVector",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverVector"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "~"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ~ ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["OverTilde",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverTilde"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "^"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ^ ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["OverHat",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverHat"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "."], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " . ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["OverDot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverDot"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    UnderscriptBox[
     StyleBox["x", "TI"], "_"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["+", "KeyEvent"],
     " _ ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["UnderBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderBar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    StyleBox["x", "TBI"], 
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Style"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      ButtonBox["Bold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Bold"]}], "]"}], 
    StyleBox["x", "TI",
     FontWeight->"Bold"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, True, False, False, False, True, False, 
     False, False, False, True, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.1], 
     Scaled[0.55], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25978],

Cell["Creating objects with annotated names. ", "Caption",
 CellID->22014],

Cell["\<\
Note that with a notebook front end, you can change the style of text using \
menu items.\
\>", "Text",
 CellID->2007],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["SingleLetterItalics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SingleLetterItalics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to use italics for single\[Hyphen]letter symbol names\
\>", "TableText"]},
   {"MultiLetterItalics", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to use italics for multi-letter symbol names", "TableText"]},
   {"SingleLetterStyle", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
the style name or directives to use for single-letter symbol names\
\>", "TableText"]},
   {"MultiLetterStyle", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
the style name or directives to use for multi-letter symbol names\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, True}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6673],

Cell["Options for cells in a notebook. ", "Caption",
 CellID->5699],

Cell[TextData[{
 "It is conventional in traditional mathematical notation that names \
consisting of single ordinary English letters are normally shown in italics, \
while other names are not. If you use ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will by default follow this convention. You can explicitly specify whether \
you want the convention followed by setting the ",
 Cell[BoxData[
  ButtonBox["SingleLetterItalics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingleLetterItalics"]], "InlineFormula"],
 " option for particular cells or cell styles. You can further specify styles \
for names using single English letters or multiple English letters by \
specifying values for the options ",
 Cell[BoxData["SingleLetterStyle"], "InlineFormula"],
 " and ",
 Cell[BoxData["MultiLetterStyle"], "InlineFormula"],
 "."
}], "Text",
 CellID->19066],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->404641663],

Cell[TextData[ButtonBox["Mathematical and Other Notation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "RelatedTutorials",\

 CellID->5715683]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Names of Symbols and Mathematical Objects - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical and Other Notation", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/LettersAndLetterLikeForms"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 38.0710566}", "context" -> "", 
    "keywords" -> {
     "annotated names", "\\bar (TeX)", "\\ddot (TeX)", "\\ddots (TeX)", "dd", 
      "ee", "ExponentialE", "\\hat (TeX)", "ii", "ImaginaryI", "ImaginaryJ", 
      "jj", "modified names", "OverBar", "OverHat", "\\overline (TeX)", 
      "OverTilde", "OverVector", "SingleLetterItalics", "SubMinus", "SubPlus",
       "subscript", "SubStar", "SuperDagger", "SuperMinus", "SuperPlus", 
      "SuperStar", "symbol names", "UnderBar", "\\underline (TeX)", 
      "\\vec (TeX)"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica by default interprets any sequence of letters or letter-like \
forms as the name of a symbol. All these are treated by Mathematica as \
symbols. Symbols with built-in meanings whose names do not start with capital \
English letters. ", "synonyms" -> {"3.10.2"}, "title" -> 
    "Names of Symbols and Mathematical Objects", "type" -> "Tutorial", "uri" -> 
    "tutorial/NamesOfSymbolsAndMathematicalObjects"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.10.2"->{
  Cell[1293, 44, 105, 2, 70, "Title",
   CellTags->{"S3.10.2", "2.1"},
   CellID->10302]},
 "2.1"->{
  Cell[1293, 44, 105, 2, 70, "Title",
   CellTags->{"S3.10.2", "2.1"},
   CellID->10302]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.10.2", 25715, 835},
 {"2.1", 25816, 839}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 668, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1293, 44, 105, 2, 70, "Title",
 CellTags->{"S3.10.2", "2.1"},
 CellID->10302],
Cell[1401, 48, 199, 6, 70, "Text",
 CellID->16234],
Cell[1603, 56, 146, 6, 70, "MathCaption",
 CellID->21115],
Cell[CellGroupData[{
Cell[1774, 66, 278, 7, 28, "Input",
 CellID->4410],
Cell[2055, 75, 373, 10, 36, "Output",
 CellID->1044150107]
}, Open  ]],
Cell[2443, 88, 3869, 106, 70, "DefinitionBox4Col",
 CellID->31074],
Cell[6315, 196, 139, 4, 70, "Caption",
 CellID->22092],
Cell[6457, 202, 612, 21, 70, "Text",
 CellID->21984],
Cell[7072, 225, 295, 10, 70, "MathCaption",
 CellID->14881],
Cell[CellGroupData[{
Cell[7392, 239, 268, 8, 28, "Input",
 CellID->12948],
Cell[7663, 249, 245, 8, 39, "Output",
 CellID->91350179]
}, Open  ]],
Cell[7923, 260, 366, 15, 70, "MathCaption",
 CellID->18424],
Cell[CellGroupData[{
Cell[8314, 279, 102, 3, 70, "Input",
 CellID->21301],
Cell[8419, 284, 221, 10, 65, "Output",
 CellID->736543054]
}, Open  ]],
Cell[8655, 297, 332, 8, 70, "Text",
 CellID->30702],
Cell[8990, 307, 384, 9, 70, "Text",
 CellID->30293],
Cell[9377, 318, 186, 4, 70, "Text",
 CellID->25896],
Cell[9566, 324, 212, 5, 70, "Text",
 CellID->14020],
Cell[9781, 331, 222, 5, 70, "MathCaption",
 CellID->4901],
Cell[CellGroupData[{
Cell[10028, 340, 348, 12, 70, "Input",
 CellID->18455],
Cell[10379, 354, 344, 12, 36, "Output",
 CellID->1214926069]
}, Open  ]],
Cell[10738, 369, 9169, 310, 70, "DefinitionBox3Col",
 CellID->25978],
Cell[19910, 681, 74, 1, 70, "Caption",
 CellID->22014],
Cell[19987, 684, 128, 4, 70, "Text",
 CellID->2007],
Cell[20118, 690, 1348, 37, 70, "DefinitionBox3Col",
 CellID->6673],
Cell[21469, 729, 67, 1, 70, "Caption",
 CellID->5699],
Cell[21539, 732, 1011, 25, 70, "Text",
 CellID->19066],
Cell[CellGroupData[{
Cell[22575, 761, 72, 1, 70, "RelatedTutorialsSection",
 CellID->404641663],
Cell[22650, 764, 192, 5, 70, "RelatedTutorials",
 CellID->5715683]
}, Open  ]]
}, Open  ]],
Cell[22869, 773, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

