(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37469,       1180]
NotebookOptionsPosition[     29830,        956]
NotebookOutlinePosition[     33856,       1045]
CellTagsIndexPosition[     33762,       1039]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup["paclet:tutorial/FilesAndStreamsOverview"],
           "Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Files and Streams\"\>", 
       2->"\<\"Mathematica File Organization\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directory" :> Documentation`HelpLookup["paclet:ref/Directory"],
           "DirectoryName" :> 
          Documentation`HelpLookup["paclet:ref/DirectoryName"], "FileNames" :> 
          Documentation`HelpLookup["paclet:ref/FileNames"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "Infinity" :> 
          Documentation`HelpLookup["paclet:ref/Infinity"], "ParentDirectory" :> 
          Documentation`HelpLookup["paclet:ref/ParentDirectory"], "Path" :> 
          Documentation`HelpLookup["paclet:ref/Path"], "ResetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/ResetDirectory"], 
          "SetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/SetDirectory"], "ToFileName" :> 
          Documentation`HelpLookup["paclet:ref/ToFileName"], "$BaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$BaseDirectory"], 
          "$HomeDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$HomeDirectory"], 
          "$InitialDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InitialDirectory"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"], 
          "$InstallationDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InstallationDirectory"], 
          "$Path" :> Documentation`HelpLookup["paclet:ref/$Path"], 
          "$UserBaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$UserBaseDirectory"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Directory\"\>", 
       2->"\<\"DirectoryName\"\>", 3->"\<\"FileNames\"\>", 4->"\<\"Get\"\>", 
       5->"\<\"Infinity\"\>", 6->"\<\"ParentDirectory\"\>", 7->"\<\"Path\"\>",
        8->"\<\"ResetDirectory\"\>", 9->"\<\"SetDirectory\"\>", 
       10->"\<\"ToFileName\"\>", 11->"\<\"$BaseDirectory\"\>", 
       12->"\<\"$HomeDirectory\"\>", 13->"\<\"$InitialDirectory\"\>", 
       14->"\<\"$Input\"\>", 15->"\<\"$InstallationDirectory\"\>", 
       16->"\<\"$Path\"\>", 
       17->"\<\"$UserBaseDirectory\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Naming and Finding Files", "Title",
 CellTags->{"S2.12.4", "4.1"},
 CellID->12068],

Cell[TextData[{
 "The precise details of the naming of files differ from one computer system \
to another. Nevertheless, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides some fairly general mechanisms that work on all systems. "
}], "Text",
 CellID->18985],

Cell[TextData[{
 "As mentioned in \"",
 ButtonBox["Finding and Manipulating Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that all your files are arranged in a hierarchy of ",
 StyleBox["directories",
  FontSlant->"Italic"],
 ". To find a particular file, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " must know both what the name of the file is, and what sequence of \
directories it is in. "
}], "Text",
 CellID->30524],

Cell[TextData[{
 "At any given time, however, you have a ",
 StyleBox["current working directory",
  FontSlant->"Italic"],
 ", and you can refer to files or other directories by specifying where they \
are relative to this directory. Typically you can refer to files or \
directories that are actually ",
 StyleBox["in",
  FontSlant->"Italic"],
 " this directory simply by giving their names, with no directory \
information. "
}], "Text",
 CellID->10764],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Directory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Directory"], "[", "]"}], Cell[
    "your current working directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetDirectory"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}], Cell[
    "set your current working directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["ResetDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ResetDirectory"], "[", "]"}], Cell[
    "revert to your previous working directory", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1587],

Cell["Manipulating directories. ", "Caption",
 CellID->27629],

Cell["\<\
This gives a string representing your current working directory. \
\>", "MathCaption",
 CellID->1118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Directory", "[", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[1]:= ",
 CellID->30111],

Cell["/users/sw", "Output", "ConversionLockdown",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27602]
}, Open  ]],

Cell[TextData[{
 "This sets your current working directory to be the ",
 Cell[BoxData["Packages"], "InlineFormula"],
 " subdirectory. "
}], "MathCaption",
 CellID->32322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "\"\<Packages\>\"", "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[2]:= ",
 CellID->12042],

Cell["/users/sw/Packages", "Output", "ConversionLockdown",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->20187]
}, Open  ]],

Cell["Now your current working directory is different. ", "MathCaption",
 CellID->22942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Directory", "[", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[3]:= ",
 CellID->14497],

Cell["/users/sw/Packages", "Output", "ConversionLockdown",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->9188]
}, Open  ]],

Cell["This reverts to your previous working directory. ", "MathCaption",
 CellID->30372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResetDirectory", "[", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[4]:= ",
 CellID->30838],

Cell["/users/sw", "Output", "ConversionLockdown",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->7613]
}, Open  ]],

Cell[TextData[{
 "When you call ",
 Cell[BoxData[
  ButtonBox["SetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDirectory"]], "InlineFormula"],
 ", you can give any directory name that is recognized by your operating \
system. Thus, for example, on Unix\[Hyphen]based systems, you can specify a \
directory one level up in the directory hierarchy using the notation ",
 Cell[BoxData[".."], "InlineFormula"],
 ", and you can specify your \[OpenCurlyDoubleQuote]home\
\[CloseCurlyDoubleQuote] directory as ",
 Cell[BoxData["~"], "InlineFormula"],
 ". "
}], "Text",
 CellID->8933],

Cell[TextData[{
 "Whenever you go to a new directory using ",
 Cell[BoxData[
  ButtonBox["SetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDirectory"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always remembers what the previous directory was. You can return to this \
previous directory using ",
 Cell[BoxData[
  ButtonBox["ResetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ResetDirectory"]], "InlineFormula"],
 ". In general, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " maintains a stack of directories, given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryStack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], "InlineFormula"],
 ". Every time you call ",
 Cell[BoxData[
  ButtonBox["SetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDirectory"]], "InlineFormula"],
 ", it adds a new directory to the stack, and every time you call ",
 Cell[BoxData[
  ButtonBox["ResetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ResetDirectory"]], "InlineFormula"],
 " it removes a directory from the stack. "
}], "Text",
 CellID->5348],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ParentDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParentDirectory"], "[", "]"}], Cell[
    "the parent of your current working directory", "TableText"]},
   {
    ButtonBox["$InitialDirectory",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$InitialDirectory"], Cell[TextData[{
     "the initial directory when ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " was started"
    }], "TableText"]},
   {
    ButtonBox["$HomeDirectory",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$HomeDirectory"], Cell[
    "your home directory, if this is defined", "TableText"]},
   {
    ButtonBox["$BaseDirectory",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$BaseDirectory"], Cell[TextData[{
     "the base directory for systemwide files to be loaded by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    ButtonBox["$UserBaseDirectory",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$UserBaseDirectory"], Cell[TextData[{
     "the base directory for user\[Hyphen]specific files to be loaded by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    ButtonBox["$InstallationDirectory",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$InstallationDirectory"], Cell[TextData[{
     "the top\[Hyphen]level directory in which your ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " installation resides"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22831],

Cell["Special directories. ", "Caption",
 CellID->8550],

Cell[TextData[{
 "Whenever you ask for a particular file, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in general goes through several steps to try and find the file you want. \
The first step is to use whatever standard mechanisms exist in your operating \
system or shell. "
}], "Text",
 CellID->7596],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scans the full name you give for a file, and looks to see whether it \
contains any of the \"metacharacters\" ",
 Cell[BoxData["*"], "InlineFormula"],
 ", ",
 Cell[BoxData["$"], "InlineFormula"],
 ", ",
 Cell[BoxData["~"], "InlineFormula"],
 ", ",
 Cell[BoxData["?"], "InlineFormula"],
 ", ",
 Cell[BoxData["["], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<\>"], "InlineFormula"],
 ", \[Backslash] and ",
 Cell[BoxData["'"], "InlineFormula"],
 ". If it finds such characters, then it passes the full name to your \
operating system or shell for interpretation. This means that if you are \
using a Unix\[Hyphen]based system, then constructions like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], "*"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"$", 
    StyleBox["VAR", "TI"]}]]], "InlineFormula"],
 " will be expanded at this point. But in general, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes whatever was returned by your operating system or shell, and treats \
this as the full file name. "
}], "Text",
 CellID->11659],

Cell[TextData[{
 "For output files, this is the end of the processing that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does. If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot find a unique file with the name you specified, then it will \
proceed to create the file. "
}], "Text",
 CellID->9609],

Cell[TextData[{
 "If you are trying to get input from a file, however, then there is another \
round of processing that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does. What happens is that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " looks at the value of the ",
 Cell[BoxData[
  ButtonBox["Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Path"]], "InlineFormula"],
 " option for the function you are using to determine the names of \
directories relative to which it should search for the file. The default \
setting for the ",
 Cell[BoxData[
  ButtonBox["Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Path"]], "InlineFormula"],
 " option is the global variable ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26029],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Get",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Get"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
      RowBox[{
       ButtonBox["Path",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Path"], "->", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "get a file, searching for it relative to the directories ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dir", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["$Path",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Path"], Cell["\<\
default list of directories relative to which to search for input files\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4117],

Cell["Search path for files. ", "Caption",
 CellID->26324],

Cell[TextData[{
 "In general, the global variable ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " is defined to be a list of strings, with each string representing a \
directory. Every time you ask for an input file, what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively does is temporarily to make each of these directories in turn \
your current working directory, and then from that directory to try and find \
the file you have requested. "
}], "Text",
 CellID->23906],

Cell[TextData[{
 "Here is a typical setting for ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 ". The current directory (",
 Cell[BoxData["."], "InlineFormula"],
 ") and your home directory (",
 Cell[BoxData["~"], "InlineFormula"],
 ") are listed first. "
}], "MathCaption",
 CellID->21321],

Cell[CellGroupData[{

Cell[BoxData["$Path"], "Input", "ConversionLockdown",
 CellLabel->"In[5]:= ",
 CellID->18189],

Cell["{., ~, /users/math/bin, /users/math/Packages}", "Output", "ConversionLockdown",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->1225]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", "]"}], Cell[
    "list all files in your current working directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "list all files in your current working directory whose names match the \
string pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[
RowBox[{\"2\", \"]\"}], \"TI\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "list all files whose names match any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", 
     RowBox[{
      StyleBox["forms", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the full names of all files whose names match ",
     Cell[BoxData[
      StyleBox["forms", "TI"]], "InlineFormula"],
     " in any of the directories ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dir", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", 
     StyleBox["forms", "TI"], ",", 
     StyleBox["dirs", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "include files that are in subdirectories up to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " levels down"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", 
     StyleBox["forms", "TI"], ",", 
     StyleBox["dirs", "TI"], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["include files in all subdirectories", "TableText"]},
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", 
     StyleBox["forms", "TI"], ",", 
     ButtonBox["$Path",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$Path"], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give all files whose names match ",
     Cell[BoxData[
      StyleBox["forms", "TI"]], "InlineFormula"],
     " in any subdirectory of the directories in ",
     Cell[BoxData[
      ButtonBox["$Path",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Path"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29738],

Cell["Getting lists of files in particular directories. ", "Caption",
 CellID->4409],

Cell[TextData[{
 "Here is a list of all files in the current working directory whose names \
end with ",
 Cell[BoxData[
  RowBox[{".", "m"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "\"\<*.m\>\"", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[6]:= ",
 CellID->15881],

Cell["{alpha.m, control.m, signals.m, test.m}", "Output", "ConversionLockdown",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->25239]
}, Open  ]],

Cell[TextData[{
 "This lists files whose names start with ",
 Cell[BoxData["a"], "InlineFormula"],
 " in the current directory, and in subdirectories with names that start with \
",
 Cell[BoxData["P"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<a*\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<.\>\"", ",", "\"\<P*\>\""}], "}"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[7]:= ",
 CellID->22629],

Cell["\<\
{alpha.m, Packages/astrodata, Packages/astro.m,

  Previous/atmp}\
\>", "Output", "ConversionLockdown",
 ImageSize->{329, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->19913]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FileNames",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNames"]], "InlineFormula"],
 " returns a list of strings corresponding to file names. When it returns a \
file that is not in your current directory, it gives the name of the file \
relative to the current directory. Note that all names are given in the \
format appropriate for the particular computer system on which they were \
generated. "
}], "Text",
 CellID->154],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DirectoryName",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DirectoryName"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "extract the directory name from a file name", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToFileName",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToFileName"], "[", "\"\<\!\(\*
StyleBox[\"directory\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell["\<\
assemble a full file name from a directory name and a file name\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ParentDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParentDirectory"], "[", "\"\<\!\(\*
StyleBox[\"directory\", \"TI\"]\)\>\"", "]"}], Cell[
    "give the parent of a directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToFileName",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToFileName"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
assemble a full file name from a hierarchy of directory names\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToFileName",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToFileName"], "[", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell["\<\
assemble a single directory name from a hierarchy of directory names\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6685],

Cell["Manipulating file names. ", "Caption",
 CellID->14050],

Cell[TextData[{
 "You should realize that different computer systems may give file names in \
different ways. Thus, for example, Windows systems typically give names in \
the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["dir", "TI"], ":", 
   RowBox[{"\[Backslash]", 
    StyleBox["dir", "TI"], "\[Backslash]", 
    StyleBox["dir", "TI"], "\[Backslash]", 
    StyleBox["name", "TI"]}]}]], "InlineFormula"],
 " and Unix systems give names in the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["dir", "TI"], "/", 
    StyleBox["dir", "TI"]}], "/", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 ". The function ",
 Cell[BoxData[
  ButtonBox["ToFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToFileName"]], "InlineFormula"],
 " assembles file names in the appropriate way for the particular computer \
system you are using."
}], "Text",
 CellID->26393],

Cell["This gives the directory portion of the file name. ", "MathCaption",
 CellID->15249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryName", "[", "\"\<Packages/Math/test.m\>\"", "]"}]], "Input",\
 "ConversionLockdown",
 CellLabel->"In[8]:= ",
 CellID->25794],

Cell[BoxData["\<\"Packages/Math/\"\>"], "Output", "ConversionLockdown",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->13202]
}, Open  ]],

Cell[TextData[{
 "This constructs the full name of another file in the same directory as ",
 Cell[BoxData[
  RowBox[{"test", ".", "m"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToFileName", "[", 
  RowBox[{"%", ",", "\"\<abc.m\>\""}], "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[9]:= ",
 CellID->31934],

Cell[BoxData["\<\"Packages/Math/abc.m\"\>"], "Output", "ConversionLockdown",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->18727]
}, Open  ]],

Cell[TextData[{
 "If you want to set up a collection of related files, it is often convenient \
to be able to refer to one file when you are reading another one. The global \
variable ",
 Cell[BoxData[
  ButtonBox["$Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Input"]], "InlineFormula"],
 " gives the name of the file from which input is currently being taken. \
Using ",
 Cell[BoxData[
  ButtonBox["DirectoryName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectoryName"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToFileName"]], "InlineFormula"],
 " you can then conveniently specify the names of other related files. "
}], "Text",
 CellID->8672],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$Input",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Input"], Cell["\<\
the name of the file or stream from which input is currently being taken\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5707],

Cell[TextData[{
 "Finding out how to refer to a file currently being read by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellID->21496],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->14123630],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "RelatedTutorials",
 CellID->752136823]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Naming and Finding Files - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/StreamsAndLowLevelInputAndOutput"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FilesForPackages"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 38.6491964}", "context" -> "", 
    "keywords" -> {
     "~", "..", "application directory", "bin directory", "cd", 
      "change directory", "dir", "directories", "directory", "DirectoryName", 
      "directory name", "DirectoryStack", "directory stack", "file", 
      "file names", "FileNames", "files", "find in Unix", "folders", 
      "directories", "history", "home directory", "input", 
      "library directory", "ls", "machine dependence", "main directory", 
      "meta characters", "names", "packages", "parent directory", 
      "ParentDirectory", "path", "patterns", "portability", 
      "preferences directory", "pwd", "ResetDirectory", "return to directory",
       "search", "search path", "SetDirectory", "share directory", "source", 
      "stack", "startup directory", "system dependence", "ToFileName", 
      "users directory", "BaseDirectory", "HomeDirectory", "InitialDirectory",
       "input", "InstallationDirectory", "LaunchDirectory", "path", 
      "UserBaseDirectory"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The precise details of the naming of files differ from one computer \
system to another. Nevertheless, Mathematica provides some fairly general \
mechanisms that work on all systems. As mentioned in \"Finding and \
Manipulating Files\", Mathematica assumes that all your files are arranged in \
a hierarchy of directories. To find a particular file, Mathematica must know \
both what the name of the file is, and what sequence of directories it is in. \
At any given time, however, you have a current working directory, and you can \
refer to files or other directories by specifying where they are relative to \
this directory. Typically you can refer to files or directories that are \
actually in this directory simply by giving their names, with no directory \
information. ", "synonyms" -> {"2.12.4"}, "title" -> 
    "Naming and Finding Files", "type" -> "Tutorial", "uri" -> 
    "tutorial/NamingAndFindingFiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.4"->{
  Cell[3824, 90, 88, 2, 70, "Title",
   CellTags->{"S2.12.4", "4.1"},
   CellID->12068]},
 "4.1"->{
  Cell[3824, 90, 88, 2, 70, "Title",
   CellTags->{"S2.12.4", "4.1"},
   CellID->12068]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.4", 33549, 1028},
 {"4.1", 33649, 1032}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3199, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3824, 90, 88, 2, 70, "Title",
 CellTags->{"S2.12.4", "4.1"},
 CellID->12068],
Cell[3915, 94, 271, 7, 70, "Text",
 CellID->18985],
Cell[4189, 103, 544, 17, 70, "Text",
 CellID->30524],
Cell[4736, 122, 455, 12, 70, "Text",
 CellID->10764],
Cell[5194, 136, 987, 28, 70, "DefinitionBox",
 CellID->1587],
Cell[6184, 166, 61, 1, 70, "Caption",
 CellID->27629],
Cell[6248, 169, 111, 3, 70, "MathCaption",
 CellID->1118],
Cell[CellGroupData[{
Cell[6384, 176, 119, 3, 28, "Input",
 CellID->30111],
Cell[6506, 181, 176, 5, 36, "Output",
 CellID->27602]
}, Open  ]],
Cell[6697, 189, 170, 5, 70, "MathCaption",
 CellID->32322],
Cell[CellGroupData[{
Cell[6892, 198, 144, 4, 70, "Input",
 CellID->12042],
Cell[7039, 204, 186, 5, 36, "Output",
 CellID->20187]
}, Open  ]],
Cell[7240, 212, 88, 1, 70, "MathCaption",
 CellID->22942],
Cell[CellGroupData[{
Cell[7353, 217, 119, 3, 70, "Input",
 CellID->14497],
Cell[7475, 222, 185, 5, 36, "Output",
 CellID->9188]
}, Open  ]],
Cell[7675, 230, 88, 1, 70, "MathCaption",
 CellID->30372],
Cell[CellGroupData[{
Cell[7788, 235, 124, 3, 70, "Input",
 CellID->30838],
Cell[7915, 240, 175, 5, 36, "Output",
 CellID->7613]
}, Open  ]],
Cell[8105, 248, 595, 15, 70, "Text",
 CellID->8933],
Cell[8703, 265, 1180, 36, 70, "Text",
 CellID->5348],
Cell[9886, 303, 1893, 55, 70, "DefinitionBox",
 CellID->22831],
Cell[11782, 360, 55, 1, 70, "Caption",
 CellID->8550],
Cell[11840, 363, 313, 8, 70, "Text",
 CellID->7596],
Cell[12156, 373, 1141, 35, 70, "Text",
 CellID->11659],
Cell[13300, 410, 320, 10, 70, "Text",
 CellID->9609],
Cell[13623, 422, 853, 27, 70, "Text",
 CellID->26029],
Cell[14479, 451, 1499, 44, 70, "DefinitionBox",
 CellID->4117],
Cell[15981, 497, 58, 1, 70, "Caption",
 CellID->26324],
Cell[16042, 500, 561, 14, 70, "Text",
 CellID->23906],
Cell[16606, 516, 360, 12, 70, "MathCaption",
 CellID->21321],
Cell[CellGroupData[{
Cell[16991, 532, 93, 2, 70, "Input",
 CellID->18189],
Cell[17087, 536, 212, 5, 36, "Output",
 CellID->1225]
}, Open  ]],
Cell[17314, 544, 4037, 120, 70, "DefinitionBox",
 CellID->29738],
Cell[21354, 666, 84, 1, 70, "Caption",
 CellID->4409],
Cell[21441, 669, 200, 7, 70, "MathCaption",
 CellID->2469],
Cell[CellGroupData[{
Cell[21666, 680, 134, 3, 70, "Input",
 CellID->15881],
Cell[21803, 685, 207, 5, 36, "Output",
 CellID->25239]
}, Open  ]],
Cell[22025, 693, 259, 8, 70, "MathCaption",
 CellID->8107],
Cell[CellGroupData[{
Cell[22309, 705, 224, 7, 70, "Input",
 CellID->22629],
Cell[22536, 714, 241, 9, 68, "Output",
 CellID->19913]
}, Open  ]],
Cell[22792, 726, 478, 11, 70, "Text",
 CellID->154],
Cell[23273, 739, 2432, 68, 70, "DefinitionBox",
 CellID->6685],
Cell[25708, 809, 60, 1, 70, "Caption",
 CellID->14050],
Cell[25771, 812, 878, 26, 70, "Text",
 CellID->26393],
Cell[26652, 840, 90, 1, 70, "MathCaption",
 CellID->15249],
Cell[CellGroupData[{
Cell[26767, 845, 157, 4, 70, "Input",
 CellID->25794],
Cell[26927, 851, 199, 5, 36, "Output",
 CellID->13202]
}, Open  ]],
Cell[27141, 859, 196, 6, 70, "MathCaption",
 CellID->28008],
Cell[CellGroupData[{
Cell[27362, 869, 160, 4, 70, "Input",
 CellID->31934],
Cell[27525, 875, 204, 5, 36, "Output",
 CellID->18727]
}, Open  ]],
Cell[27744, 883, 747, 21, 70, "Text",
 CellID->8672],
Cell[28494, 906, 535, 15, 70, "DefinitionBox",
 CellID->5707],
Cell[29032, 923, 164, 6, 70, "Caption",
 CellID->21496],
Cell[CellGroupData[{
Cell[29221, 933, 71, 1, 70, "RelatedTutorialsSection",
 CellID->14123630],
Cell[29295, 936, 162, 3, 70, "RelatedTutorials",
 CellID->107813958],
Cell[29460, 941, 316, 9, 70, "RelatedTutorials",
 CellID->752136823]
}, Open  ]]
}, Open  ]],
Cell[29803, 954, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

