(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14228,        504]
NotebookOptionsPosition[      9441,        363]
NotebookOutlinePosition[     12541,        439]
CellTagsIndexPosition[     12450,        433]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Patterns" :> 
         Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Naming Pieces of Patterns", "Title",
 CellTags->{"S2.3.3", "3.1"},
 CellID->5819],

Cell[TextData[{
 "Particularly when you use transformation rules, you often need to name \
pieces of patterns. An object like ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_"}]]], "InlineFormula"],
 " stands for any expression, but gives the expression the name ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". You can then, for example, use this name on the right\[Hyphen]hand side \
of a transformation rule. "
}], "Text",
 CellID->5621],

Cell[TextData[{
 "An important point is that when you use ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_"}]]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " requires that all occurrences of blanks with the same name ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a particular expression must stand for the same expression. "
}], "Text",
 CellID->19483],

Cell[TextData[{
 "Thus ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "x_"}], "]"}]], "InlineFormula"],
 " can only stand for expressions in which the two arguments of ",
 Cell[BoxData["f"], "InlineFormula"],
 " are exactly the same. ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"_", ",", "_"}], "]"}]], "InlineFormula"],
 ", on the other hand, can stand for any expression of the form ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " need not be the same. "
}], "Text",
 CellID->727],

Cell[TextData[{
 "The transformation rule applies only to cases where the two arguments of ",
 Cell[BoxData["f"], "InlineFormula"],
 " are identical. "
}], "MathCaption",
 CellID->13573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "a"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "x_"}], "]"}], "->", 
   RowBox[{"p", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->13705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->24644]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to give names not just to single blanks, but to any piece of a \
pattern. The object ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ":", 
   StyleBox["pattern", "TI"]}]], "InlineFormula"],
 " in general represents a pattern which is assigned the name ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". In transformation rules, you can use this mechanism to name exactly those \
pieces of a pattern that you need to refer to on the right\[Hyphen]hand side \
of the rule. "
}], "Text",
 CellID->18158],

Cell[BoxData[GridBox[{
   {"_", Cell["any expression", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"]}], Cell[TextData[{
     "any expression, to be named ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], ":", 
     StyleBox["pattern", "TI"]}], Cell[TextData[{
     "an expression to be named ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", matching ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23375],

Cell["Patterns with names. ", "Caption",
 CellID->3644],

Cell[TextData[{
 "This gives a name to the complete form ",
 Cell[BoxData[
  RowBox[{"_", "^", "_"}]], "InlineFormula"],
 " so you can refer to it as a whole on the right\[Hyphen]hand side of the \
transformation rule. "
}], "MathCaption",
 CellID->2491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", "^", "b"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ":", 
     RowBox[{"_", "^", "_"}]}], "]"}], "->", 
   RowBox[{"p", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->27934],

Cell[BoxData[
 RowBox[{"p", "[", 
  SuperscriptBox["a", "b"], "]"}]], "Output",
 ImageSize->{38, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->18752]
}, Open  ]],

Cell[TextData[{
 "Here the exponent is named ",
 Cell[BoxData["n"], "InlineFormula"],
 ", while the whole object is ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", "^", "b"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ":", 
     RowBox[{"_", "^", "n_"}]}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "n"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->20224],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{
   SuperscriptBox["a", "b"], ",", "b"}], "]"}]], "Output",
 ImageSize->{56, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->4986]
}, Open  ]],

Cell["\<\
When you give the same name to two pieces of a pattern, you constrain the \
pattern to match only those expressions in which the corresponding pieces are \
identical. \
\>", "Text",
 CellID->20463],

Cell["Here the pattern matches both cases. ", "MathCaption",
 CellID->13331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"h", "[", "4", "]"}], ",", 
      RowBox[{"h", "[", "4", "]"}]}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"h", "[", "4", "]"}], ",", 
      RowBox[{"h", "[", "5", "]"}]}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"h", "[", "_", "]"}], ",", 
     RowBox[{"h", "[", "_", "]"}]}], "]"}], "->", "q"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"q", ",", "q"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->30753]
}, Open  ]],

Cell[TextData[{
 "Now both arguments of ",
 Cell[BoxData["f"], "InlineFormula"],
 " are constrained to be the same, and only the first case matches. "
}], "MathCaption",
 CellID->26955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"h", "[", "4", "]"}], ",", 
      RowBox[{"h", "[", "4", "]"}]}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"h", "[", "4", "]"}], ",", 
      RowBox[{"h", "[", "5", "]"}]}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"h", "[", "_", "]"}]}], ",", "x_"}], "]"}], "->", 
   RowBox[{"r", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->326],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"r", "[", 
    RowBox[{"h", "[", "4", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"h", "[", "4", "]"}], ",", 
     RowBox[{"h", "[", "5", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->21596]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->335846667],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Naming Pieces of Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FindingExpressionsThatMatchAPattern"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 40.2742380}", "context" -> "", 
    "keywords" -> {
     ":", "pattern name", "pattern label", "colon operator", "names", 
      "pattern", "pattern variables", "scoping"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Particularly when you use transformation rules, you often need to name \
pieces of patterns. An object like x_ stands for any expression, but gives \
the expression the name x. You can then, for example, use this name on the \
right-hand side of a transformation rule. An important point is that when you \
use x_, Mathematica requires that all occurrences of blanks with the same \
name x in a particular expression must stand for the same expression. Thus \
f[x_,x_] can only stand for expressions in which the two arguments of f are \
exactly the same. f[_,_], on the other hand, can stand for any expression of \
the form f[x,y], where x and y need not be the same. ", 
    "synonyms" -> {"2.3.3"}, "title" -> "Naming Pieces of Patterns", "type" -> 
    "Tutorial", "uri" -> "tutorial/NamingPiecesOfPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.3"->{
  Cell[1215, 42, 87, 2, 70, "Title",
   CellTags->{"S2.3.3", "3.1"},
   CellID->5819]},
 "3.1"->{
  Cell[1215, 42, 87, 2, 70, "Title",
   CellTags->{"S2.3.3", "3.1"},
   CellID->5819]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.3", 12241, 422},
 {"3.1", 12339, 426}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 590, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1215, 42, 87, 2, 70, "Title",
 CellTags->{"S2.3.3", "3.1"},
 CellID->5819],
Cell[1305, 46, 476, 13, 70, "Text",
 CellID->5621],
Cell[1784, 61, 425, 14, 70, "Text",
 CellID->19483],
Cell[2212, 77, 729, 25, 70, "Text",
 CellID->727],
Cell[2944, 104, 186, 5, 70, "MathCaption",
 CellID->13573],
Cell[CellGroupData[{
Cell[3155, 113, 358, 13, 28, "Input",
 CellID->13705],
Cell[3516, 128, 284, 10, 36, "Output",
 CellID->24644]
}, Open  ]],
Cell[3815, 141, 597, 16, 70, "Text",
 CellID->18158],
Cell[4415, 159, 929, 29, 70, "DefinitionBox",
 CellID->23375],
Cell[5347, 190, 55, 1, 70, "Caption",
 CellID->3644],
Cell[5405, 193, 254, 7, 70, "MathCaption",
 CellID->2491],
Cell[CellGroupData[{
Cell[5684, 204, 275, 10, 70, "Input",
 CellID->27934],
Cell[5962, 216, 206, 7, 39, "Output",
 CellID->18752]
}, Open  ]],
Cell[6183, 226, 197, 7, 70, "MathCaption",
 CellID->18983],
Cell[CellGroupData[{
Cell[6405, 237, 301, 11, 70, "Input",
 CellID->20224],
Cell[6709, 250, 229, 8, 39, "Output",
 CellID->4986]
}, Open  ]],
Cell[6953, 261, 207, 5, 70, "Text",
 CellID->20463],
Cell[7163, 268, 76, 1, 70, "MathCaption",
 CellID->13331],
Cell[CellGroupData[{
Cell[7264, 273, 517, 18, 70, "Input",
 CellID->21901],
Cell[7784, 293, 200, 7, 36, "Output",
 CellID->30753]
}, Open  ]],
Cell[7999, 303, 185, 5, 70, "MathCaption",
 CellID->26955],
Cell[CellGroupData[{
Cell[8209, 312, 541, 19, 70, "Input",
 CellID->326],
Cell[8753, 333, 376, 13, 36, "Output",
 CellID->21596]
}, Open  ]],
Cell[CellGroupData[{
Cell[9166, 351, 72, 1, 70, "RelatedTutorialsSection",
 CellID->335846667],
Cell[9241, 354, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[9414, 361, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

