(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44775,       1543]
NotebookOptionsPosition[     37245,       1293]
NotebookOutlinePosition[     40045,       1365]
CellTagsIndexPosition[     39952,       1359]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Manipulating Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apply" :> Documentation`HelpLookup["paclet:ref/Apply"], 
          "Array" :> Documentation`HelpLookup["paclet:ref/Array"], 
          "ArrayDepth" :> Documentation`HelpLookup["paclet:ref/ArrayDepth"], 
          "ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"], "ArrayQ" :> 
          Documentation`HelpLookup["paclet:ref/ArrayQ"], "Dimensions" :> 
          Documentation`HelpLookup["paclet:ref/Dimensions"], "Flatten" :> 
          Documentation`HelpLookup["paclet:ref/Flatten"], "Map" :> 
          Documentation`HelpLookup["paclet:ref/Map"], "MapIndexed" :> 
          Documentation`HelpLookup["paclet:ref/MapIndexed"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"], "Outer" :> 
          Documentation`HelpLookup["paclet:ref/Outer"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"], "PadRight" :> 
          Documentation`HelpLookup["paclet:ref/PadRight"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"], "RotateLeft" :> 
          Documentation`HelpLookup["paclet:ref/RotateLeft"], "RotateRight" :> 
          Documentation`HelpLookup["paclet:ref/RotateRight"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "Transpose" :> 
          Documentation`HelpLookup["paclet:ref/Transpose"], "Tuples" :> 
          Documentation`HelpLookup["paclet:ref/Tuples"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Apply\"\>", 2->"\<\"Array\"\>", 
       3->"\<\"ArrayDepth\"\>", 4->"\<\"ArrayFlatten\"\>", 
       5->"\<\"ArrayQ\"\>", 6->"\<\"Dimensions\"\>", 7->"\<\"Flatten\"\>", 
       8->"\<\"Map\"\>", 9->"\<\"MapIndexed\"\>", 10->"\<\"Normal\"\>", 
       11->"\<\"Outer\"\>", 12->"\<\"PadLeft\"\>", 13->"\<\"PadRight\"\>", 
       14->"\<\"Partition\"\>", 15->"\<\"RotateLeft\"\>", 
       16->"\<\"RotateRight\"\>", 17->"\<\"SparseArray\"\>", 
       18->"\<\"Table\"\>", 19->"\<\"Transpose\"\>", 
       20->"\<\"Tuples\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nested Lists", "Title",
 CellTags->{"S2.4.3", "3.1"},
 CellID->15721],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["list", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "list of lists", "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["m", "TI"], "}", ",", "{", 
     StyleBox["j", "TI"], ",", 
     StyleBox["n", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"m", "\[Cross]", "n", "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " table of values of ",
     StyleBox["expr", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"m", "\[Cross]", "n", "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array of values ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", 
        RowBox[{"i", ",", "j", ",", "\[Ellipsis]"}], "]"}], TraditionalForm]],
       "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     RowBox[{
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"], "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["n", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"m", "\[Cross]", "n", "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array with element ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["i", "s"], ",", 
         SubscriptBox["j", "s"], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " being ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["v", "s"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Outer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Outer"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "generalized outer product with elements combined using ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Tuples",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tuples"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "all possible ",
     Cell[BoxData[
      FormBox[
       RowBox[{"m", "\[Cross]", "n", "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " arrays of elements from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16587],

Cell["Ways to construct nested lists. ", "Caption",
 CellID->14377],

Cell["This generates a table corresponding to a 2x3 nested list. ", \
"MathCaption",
 CellID->23924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "+", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", 
     RowBox[{"2", "+", "x"}], ",", 
     RowBox[{"3", "+", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ",", 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "2"]}], ",", 
     RowBox[{"3", "+", 
      SuperscriptBox["x", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{279, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->9914]
}, Open  ]],

Cell["\<\
This generates an array corresponding to the same nested list. \
\>", "MathCaption",
 CellID->1662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "#1"}], "+", "#2"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->11855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", 
     RowBox[{"2", "+", "x"}], ",", 
     RowBox[{"3", "+", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ",", 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "2"]}], ",", 
     RowBox[{"3", "+", 
      SuperscriptBox["x", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{279, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->177]
}, Open  ]],

Cell[TextData[{
 "Elements not explicitly specified in the sparse array are taken to be ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "->", 
      RowBox[{"3", "+", "x"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->28419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"3", "+", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->9643]
}, Open  ]],

Cell["\<\
Each element in the final list contains one element from each input list. \
\>", "MathCaption",
 CellID->22302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->26612],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "c"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "d"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "c"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "d"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->5521]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " always generate ",
 StyleBox["full arrays",
  FontSlant->"Italic"],
 ", in which all sublists at a particular level are the same length. "
}], "Text",
 CellID->15692],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "the dimensions of a full array", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayQ"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["\<\
test whether all sublists at a given level are the same length\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayDepth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayDepth"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "the depth to which all sublists are the same length", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->407],

Cell["Functions for full arrays. ", "Caption",
 CellID->23218],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can handle arbitrary nested lists. There is no need for the lists to form \
a full array. You can easily generate ragged arrays using ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 "."
}], "Text",
 CellID->5144],

Cell["This generates a triangular array. ", "MathCaption",
 CellID->13748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "+", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->21415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", "+", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ",", 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      SuperscriptBox["x", "3"]}], ",", 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "3"]}], ",", 
     RowBox[{"3", "+", 
      SuperscriptBox["x", "3"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{304, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->27879]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "flatten out all levels of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "flatten out the top ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " levels"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayFlatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayFlatten"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["rank", "TI"]}], "]"}], Cell[
    "creates a flattened array from an array of arrays", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5448],

Cell["Flattening out sublists and subarrays. ", "Caption",
 CellID->25651],

Cell["This generates a 2x3 array. ", "MathCaption",
 CellID->7087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->7475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->8879]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " in effect puts elements in lexicographic order of their indices. "
}], "MathCaption",
 CellID->11858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->18583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "3"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->19946]
}, Open  ]],

Cell["This creates a matrix from a block matrix.", "MathCaption",
 CellID->41846064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayFlatten", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", "1", "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "4", "}"}], ",", 
        RowBox[{"{", "7", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"8", ",", "9"}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->104298318],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->49659322]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "transpose the top two levels of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "put the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " level in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " at level ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "k"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24187],

Cell["Transposing levels in nested lists. ", "Caption",
 CellID->13407],

Cell["This generates a 2x2x2 array. ", "MathCaption",
 CellID->8288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->17925],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMFOAjEQ7VIWFCOiB8MRf0ZP/oEeNsQEDkaD/D9uC+jymO1Mu92CZkkW
OmU6M2863bbvuVgv3t6L9XJezJ5WxediOf+aPX6syi6dKZW9KKUepqpsb8qW
fczntXy2zW3rynzr/b8b1Qd5VH711LHeDSEbvRz6Jw3HYzxoJ1V8k5rxGB/K
2mZ5FIhq7/WWsEr1c+Oo6Cj0bcVz55k9lHuibJpo8lLUxGjTj/oDz36Uh4n9
oXz5T/APhf7iVInVyn9kO+bYd72WqWfMvKuf0hu2GIPMdl1kmL0Y2aqPKHXO
3JFcBGeOr0oOpRb5xpU2ARl3Lxx/HcXLGGTcG1FG/TCs1M4cHyvnhcPKVUO2
kbyjTFR9Qe1Rpx2X/rgluyhj1s4ND1c7p9x5uNUTZ41zXqgZ9JnxMKyIDaOK
g5WrBg5rvNOqETG6AYXRc02E2MUzfI/xQ2VN4hfjxzhC8XCzyuGJM6t4g6LX
ge977j7Iqmx1cPMqQ0T7ioOLtj0OQiebZSk7Yvr1Dmf1vpvvfqcOPa1+T55Y
23hfpvxV7bn8aYE/GZthmsgj+bd8Z6Rjog71wubOd0/rmCl3fP2grP5VhqZj
qGIyVL5VIztL1/EmabgqX++nYKn8EabLUypmqrdfDd7nYRlr0/RGH3Zm5e6N
7TBU1E3FdZKOg5Xz4stQ2doK2snOidHpGKpD2b61Eu00p1njaRgqzkochorz
0pShCquGOkYnxpoIsdsWQ4Xj0E8oQ8XZbcpQhc0qx2005aY4e+2wUrJ11xRL
m0zUdjZ9R1WZoeq91sVEoZ6u9PswUdXxLiaqqufLRNmTvhUk3JLKvgH2GvYA
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->90998670]
}, Open  ]],

Cell["This permutes levels so that level 3 appears at level 1. ", \
"MathCaption",
 CellID->22860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->24320],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1OwkAQ3v4AigGLB8MRX0ZPvoEeGmICB6NB3r92F2vgY9rZnU4bNCUB
drazO//d2e8532/e3vP9dp2vnnb552a7/lo9fuzKqSQyJnoxxjwsTTkuypH7
2s9r+T0MD6Mb+5tUTwuTAj0tf2JzzndL0JZvBPNZy/WoD+7Tl35ZzXrUD+nE
eXkqtKqSuiB2pea5dZR2lPVd6XMX6D2kYy9vWm1GJZkQq+088o8D55Ge9CwP
6et/Yv/EU55Oljiu0S/t1vjJtpk8qV1tn2JEwnfx01RHE0oz9F6X3vLzQn8+
uxLbymclF49EJHsOdMbwz7ykYD1TZ2KTFDwrUUsdW1ErlNqNrSgltC+ICp93
lNUq9fAJ1e1wPuxiX6TRa5dmD5fBl3TyoK5YB7Iax7xFD3FSOC11bEWtsFp1
bKWytZ9u1ZLcGwR76xnDP6/Zd8x4gdvXp8Yl9qAesZI9ZEZ2HlXuXk1nLPee
u6d0OdtFtjcXV5lFfpXZxq65lwRZlH3RkapztD5LfnxdoQX2f3nEVz2n+DC3
8b7cJC85mq+TlwGfDM2wQ8SRwkehERmQqFM+WexCz7QBmWrWLxV59a8iNANC
pYlQhWZNOwyGQh76xqra6ECt00Wp6rTrH5+q00QPmYqragjuh2WoTeiNXoba
cPdG7kaog1Bxd2gdhIqzNRShcrklOskuCdEZEKpT2r1JejppuqlxrkbbRlzH
Vg470rGV6m67zwZfREdSE9S+iOggIqVR4xJ70PtShArtwbtH6IksiyqHbYRG
0w/D0X5fh1qhiUeR53zr7uwQTSk6UvV2Gfw3IVEUnwSJOkakUkbeoghDolyn
7wgfbMlE3/Ya9gA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->226772609]
}, Open  ]],

Cell["This restores the original array. ", "MathCaption",
 CellID->14767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->25656],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMFOAjEQ7VIWFCOiB8MRf0ZP/oEeNsQEDkaD/D9uC+jymO1Mu92CZkkW
OmU6M2863bbvuVgv3t6L9XJezJ5WxediOf+aPX6syi6dKZW9KKUepqpsb8qW
fczntXy2zW3rynzr/b8b1Qd5VH711LHeDSEbvRz6Jw3HYzxoJ1V8k5rxGB/K
2mZ5FIhq7/WWsEr1c+Oo6Cj0bcVz55k9lHuibJpo8lLUxGjTj/oDz36Uh4n9
oXz5T/APhf7iVInVyn9kO+bYd72WqWfMvKuf0hu2GIPMdl1kmL0Y2aqPKHXO
3JFcBGeOr0oOpRb5xpU2ARl3Lxx/HcXLGGTcG1FG/TCs1M4cHyvnhcPKVUO2
kbyjTFR9Qe1Rpx2X/rgluyhj1s4ND1c7p9x5uNUTZ41zXqgZ9JnxMKyIDaOK
g5WrBg5rvNOqETG6AYXRc02E2MUzfI/xQ2VN4hfjxzhC8XCzyuGJM6t4g6LX
ge977j7Iqmx1cPMqQ0T7ioOLtj0OQiebZSk7Yvr1Dmf1vpvvfqcOPa1+T55Y
23hfpvxV7bn8aYE/GZthmsgj+bd8Z6Rjog71wubOd0/rmCl3fP2grP5VhqZj
qGIyVL5VIztL1/EmabgqX++nYKn8EabLUypmqrdfDd7nYRlr0/RGH3Zm5e6N
7TBU1E3FdZKOg5Xz4stQ2doK2snOidHpGKpD2b61Eu00p1njaRgqzkochorz
0pShCquGOkYnxpoIsdsWQ4Xj0E8oQ8XZbcpQhc0qx2005aY4e+2wUrJ11xRL
m0zUdjZ9R1WZoeq91sVEoZ6u9PswUdXxLiaqqufLRNmTvhUk3JLKvgH2GvYA
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->329681615]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Map",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Map"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["list", "TI"], ",", "{", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "map ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " across elements at level ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Apply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Apply"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["list", "TI"], ",", "{", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " to the elements at level ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MapIndexed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapIndexed"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["list", "TI"], ",", "{", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "map ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " onto parts at level ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and their indices"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->672],

Cell["Applying functions in nested lists. ", "Caption",
 CellID->18446],

Cell["Here is a nested list. ", "MathCaption",
 CellID->25156],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}], ",", 
       RowBox[{"{", "i", "}"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->20879],

Cell[TextData[{
 "This maps a function ",
 Cell[BoxData["f"], "InlineFormula"],
 " at level 2. "
}], "MathCaption",
 CellID->4500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "m", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->4293],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"g", ",", "h"}], "}"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"{", "i", "}"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->23203]
}, Open  ]],

Cell["This applies the function at level 2. ", "MathCaption",
 CellID->22309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", "m", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"c", ",", "d"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"e", ",", "f"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"g", ",", "h"}], "]"}], ",", 
     RowBox[{"f", "[", "i", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->21585]
}, Open  ]],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to both parts and their indices. "
}], "MathCaption",
 CellID->2289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", "m", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->15271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", "i", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->30580]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "partition into ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " blocks"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadLeft"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "pad on the left to make an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadRight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadRight"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "pad on the right to make an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RotateLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RotateLeft"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "rotate ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "k"], TraditionalForm]], "InlineMath"],
     " places to the left at level ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RotateRight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RotateRight"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "rotate ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "k"], TraditionalForm]], "InlineMath"],
     " places to the right at level ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14127],

Cell["Operations on nested lists. ", "Caption",
 CellID->4550],

Cell["Here is a nested list. ", "MathCaption",
 CellID->6941],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", "h", "}"}], ",", 
       RowBox[{"{", "i", "}"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->16502],

Cell["This rotates different amounts at each level. ", "MathCaption",
 CellID->9793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->25994],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "h", "}"}], ",", 
     RowBox[{"{", "i", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "f"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->16157]
}, Open  ]],

Cell["This pads with zeros to make a 2x3x3 array. ", "MathCaption",
 CellID->28621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->23156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "d", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"h", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "f", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->17803]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->271978270],

Cell[TextData[ButtonBox["Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsOverview"]], "RelatedTutorials",\

 CellID->30468725]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nested Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Lists", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/ManipulatingListsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingListsByTheirIndices"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PartitioningAndPaddingLists"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 40, 24.8535042}", "context" -> "", 
    "keywords" -> {
     "array", "ArrayDepth", "array depth", "array rank", "ArrayQ", "cycle", 
      "dimensions", "flatten", "full arrays", "left shift", "levels", "lists",
       "nested lists", "outer", "PadLeft", "PadRight", "partition", 
      "ragged arrays", "Right shift", "RotateLeft", "RotateRight", "shift", 
      "testing", "transpose", "triangular matrices", "Tuples"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Ways to construct nested lists. This generates a table corresponding to \
a 2x3 nested list. This generates an array corresponding to the same nested \
list. ", "synonyms" -> {"2.4.3"}, "title" -> "Nested Lists", "type" -> 
    "Tutorial", "uri" -> "tutorial/NestedLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.4.3"->{
  Cell[3705, 85, 75, 2, 70, "Title",
   CellTags->{"S2.4.3", "3.1"},
   CellID->15721]},
 "3.1"->{
  Cell[3705, 85, 75, 2, 70, "Title",
   CellTags->{"S2.4.3", "3.1"},
   CellID->15721]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.4.3", 39741, 1348},
 {"3.1", 39840, 1352}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3080, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3705, 85, 75, 2, 70, "Title",
 CellTags->{"S2.4.3", "3.1"},
 CellID->15721],
Cell[3783, 89, 4530, 143, 70, "DefinitionBox",
 CellID->16587],
Cell[8316, 234, 67, 1, 70, "Caption",
 CellID->14377],
Cell[8386, 237, 100, 2, 70, "MathCaption",
 CellID->23924],
Cell[CellGroupData[{
Cell[8511, 243, 278, 10, 28, "Input",
 CellID->23438],
Cell[8792, 255, 558, 20, 39, "Output",
 CellID->9914]
}, Open  ]],
Cell[9365, 278, 109, 3, 70, "MathCaption",
 CellID->1662],
Cell[CellGroupData[{
Cell[9499, 285, 242, 9, 28, "Input",
 CellID->11855],
Cell[9744, 296, 557, 20, 39, "Output",
 CellID->177]
}, Open  ]],
Cell[10316, 319, 168, 5, 70, "MathCaption",
 CellID->3706],
Cell[CellGroupData[{
Cell[10509, 328, 346, 12, 28, "Input",
 CellID->28419],
Cell[10858, 342, 344, 12, 36, "Output",
 CellID->9643]
}, Open  ]],
Cell[11217, 357, 121, 3, 70, "MathCaption",
 CellID->22302],
Cell[CellGroupData[{
Cell[11363, 364, 229, 8, 70, "Input",
 CellID->26612],
Cell[11595, 374, 530, 19, 36, "Output",
 CellID->5521]
}, Open  ]],
Cell[12140, 396, 573, 21, 70, "Text",
 CellID->15692],
Cell[12716, 419, 1053, 31, 70, "DefinitionBox",
 CellID->407],
Cell[13772, 452, 62, 1, 70, "Caption",
 CellID->23218],
Cell[13837, 455, 349, 11, 70, "Text",
 CellID->5144],
Cell[14189, 468, 74, 1, 70, "MathCaption",
 CellID->13748],
Cell[CellGroupData[{
Cell[14288, 473, 278, 10, 70, "Input",
 CellID->21415],
Cell[14569, 485, 638, 23, 39, "Output",
 CellID->27879]
}, Open  ]],
Cell[15222, 511, 1259, 40, 70, "DefinitionBox",
 CellID->5448],
Cell[16484, 553, 74, 1, 70, "Caption",
 CellID->25651],
Cell[16561, 556, 66, 1, 70, "MathCaption",
 CellID->7087],
Cell[CellGroupData[{
Cell[16652, 561, 169, 6, 70, "Input",
 CellID->7475],
Cell[16824, 569, 666, 23, 36, "Output",
 CellID->8879]
}, Open  ]],
Cell[17505, 595, 237, 7, 70, "MathCaption",
 CellID->11858],
Cell[CellGroupData[{
Cell[17767, 606, 100, 3, 70, "Input",
 CellID->18583],
Cell[17870, 611, 565, 19, 36, "Output",
 CellID->19946]
}, Open  ]],
Cell[18450, 633, 84, 1, 70, "MathCaption",
 CellID->41846064],
Cell[CellGroupData[{
Cell[18559, 638, 685, 25, 70, "Input",
 CellID->104298318],
Cell[19247, 665, 390, 13, 36, "Output",
 CellID->49659322]
}, Open  ]],
Cell[19652, 681, 1388, 44, 70, "DefinitionBox",
 CellID->24187],
Cell[21043, 727, 71, 1, 70, "Caption",
 CellID->13407],
Cell[21117, 730, 68, 1, 70, "MathCaption",
 CellID->8288],
Cell[CellGroupData[{
Cell[21210, 735, 180, 6, 28, "Input",
 CellID->17925],
Cell[21393, 743, 1066, 22, 54, "Output",
 Evaluatable->False,
 CellID->90998670]
}, Open  ]],
Cell[22474, 768, 98, 2, 70, "MathCaption",
 CellID->22860],
Cell[CellGroupData[{
Cell[22597, 774, 184, 6, 28, "Input",
 CellID->24320],
Cell[22784, 782, 1083, 22, 54, "Output",
 Evaluatable->False,
 CellID->226772609]
}, Open  ]],
Cell[23882, 807, 73, 1, 70, "MathCaption",
 CellID->14767],
Cell[CellGroupData[{
Cell[23980, 812, 185, 6, 28, "Input",
 CellID->25656],
Cell[24168, 820, 1068, 22, 54, "Output",
 Evaluatable->False,
 CellID->329681615]
}, Open  ]],
Cell[25251, 845, 1740, 55, 70, "DefinitionBox",
 CellID->672],
Cell[26994, 902, 71, 1, 70, "Caption",
 CellID->18446],
Cell[27068, 905, 62, 1, 70, "MathCaption",
 CellID->25156],
Cell[27133, 908, 529, 19, 70, "Input",
 CellID->20879],
Cell[27665, 929, 130, 5, 70, "MathCaption",
 CellID->4500],
Cell[CellGroupData[{
Cell[27820, 938, 153, 5, 70, "Input",
 CellID->4293],
Cell[27976, 945, 712, 25, 36, "Output",
 CellID->23203]
}, Open  ]],
Cell[28703, 973, 77, 1, 70, "MathCaption",
 CellID->22309],
Cell[CellGroupData[{
Cell[28805, 978, 154, 5, 70, "Input",
 CellID->508],
Cell[28962, 985, 573, 20, 36, "Output",
 CellID->21585]
}, Open  ]],
Cell[29550, 1008, 143, 5, 70, "MathCaption",
 CellID->2289],
Cell[CellGroupData[{
Cell[29718, 1017, 161, 5, 70, "Input",
 CellID->15271],
Cell[29882, 1024, 1141, 40, 54, "Output",
 CellID->30580]
}, Open  ]],
Cell[31038, 1067, 3372, 108, 70, "DefinitionBox",
 CellID->14127],
Cell[34413, 1177, 62, 1, 70, "Caption",
 CellID->4550],
Cell[34478, 1180, 61, 1, 70, "MathCaption",
 CellID->6941],
Cell[34542, 1183, 510, 18, 70, "Input",
 CellID->16502],
Cell[35055, 1203, 84, 1, 70, "MathCaption",
 CellID->9793],
Cell[CellGroupData[{
Cell[35164, 1208, 207, 7, 70, "Input",
 CellID->25994],
Cell[35374, 1217, 531, 19, 36, "Output",
 CellID->16157]
}, Open  ]],
Cell[35920, 1239, 83, 1, 70, "MathCaption",
 CellID->28621],
Cell[CellGroupData[{
Cell[36028, 1244, 184, 6, 70, "Input",
 CellID->23156],
Cell[36215, 1252, 698, 23, 36, "Output",
 CellID->17803]
}, Open  ]],
Cell[CellGroupData[{
Cell[36950, 1280, 72, 1, 70, "RelatedTutorialsSection",
 CellID->271978270],
Cell[37025, 1283, 166, 4, 70, "RelatedTutorials",
 CellID->30468725]
}, Open  ]]
}, Open  ]],
Cell[37218, 1291, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

