(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12537,        458]
NotebookOptionsPosition[      7864,        308]
NotebookOutlinePosition[     10440,        377]
CellTagsIndexPosition[     10349,        371]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Strings and Characters" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Newlines and Tabs in Strings", "Title",
 CellTags->{"S2.8.7", "7.1"},
 CellID->21585],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", "n"}], Cell[
    "a newline (line feed) to be included in a string", "TableText"]},
   {
    RowBox[{"\[Backslash]", "t"}], Cell[
    "a tab to be included in a string", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18771],

Cell["Explicit representations of newlines and tabs in strings. ", "Caption",
 CellID->23392],

Cell["This prints on two lines. ", "MathCaption",
 CellID->4012],

Cell[CellGroupData[{

Cell[BoxData["\"\<First line.\\nSecond line.\>\""], "Input",
 CellLabel->"In[1]:= ",
 CellID->14938],

Cell[BoxData["\<\"First line.\\nSecond line.\"\>"], "Output",
 ImageSize->{88, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->3789]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " there is an explicit ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "n"}]], "InlineFormula"],
 " to represent the newline. "
}], "MathCaption",
 CellID->21101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->18769],

Cell["\"First line.\\nSecond line.\"", "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm= ",
 CellID->20809]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " keeps line breaks entered within a string."
}], "MathCaption",
 CellID->19774],

Cell[CellGroupData[{

Cell[BoxData["\"\<A string on \ntwo lines.\>\""], "Input",
 CellLabel->"In[6]:=",
 CellID->31774],

Cell[BoxData["\<\"A string on \\ntwo lines.\"\>"], "Output",
 ImageSize->{88, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->223099998]
}, Open  ]],

Cell["There is a newline in the string. ", "MathCaption",
 CellID->2838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->20456],

Cell["\"A string on \\ntwo lines.\"", "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//InputForm=",
 CellID->215514714]
}, Open  ]],

Cell[TextData[{
 "With a single backslash at the end of a line, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ignores the line break. "
}], "MathCaption",
 CellID->368843934],

Cell[CellGroupData[{

Cell[BoxData["\"\<A string on \\\none line.\>\""], "Input",
 CellLabel->"In[8]:=",
 CellID->113326149],

Cell[BoxData["\<\"A string on one line.\"\>"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->605437864]
}, Open  ]],

Cell[TextData[{
 "You should realize that even though it is possible to achieve some \
formatting of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output by creating strings which contain raw tabs and newlines, this is \
rarely a good idea. Typically a much better approach is to use the \
higher-level ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " formatting primitives discussed in \"",
 ButtonBox["String-Oriented Output Formats",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StringOrientedOutputFormats"],
 "\", \"",
 ButtonBox["Output Formats for Numbers",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/OutputFormatsForNumbers"],
 "\", and \"",
 ButtonBox["Tables and Matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TablesAndMatrices"],
 "\". These primitives will always yield consistent output, independent of \
such issues as the positions of tab settings on a particular device. "
}], "Text",
 CellID->29007],

Cell["\<\
In strings with newlines, text is always aligned on the left. \
\>", "MathCaption",
 CellID->8418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\"\<Here is\\na string\\non several lines.\>\"", ",", 
   "\"\<Here is\\nanother\>\""}], "}"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->10900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Here is\\na string\\non several lines.\"\>", 
   ",", "\<\"Here is\\nanother\"\>"}], "}"}]], "Output",
 ImageSize->{184, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->31728]
}, Open  ]],

Cell[TextData[{
 "The front end formatting construct ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " gives more control. Here text is aligned on the right. "
}], "MathCaption",
 CellID->21878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<First line\>\"", ",", "\"\<Second\>\"", ",", "\"\<Third\>\""}], 
    "}"}], ",", "Right"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->21827],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"First line\"\>"},
    {"\<\"Second\"\>"},
    {"\<\"Third\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Right}}}],
  "Column"]], "Output",
 ImageSize->{74, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->375510893]
}, Open  ]],

Cell["And here the text is centered. ", "MathCaption",
 CellID->18955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<First line\>\"", ",", "\"\<Second\>\"", ",", "\"\<Third\>\""}], 
    "}"}], ",", "Center"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->15739],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"First line\"\>"},
    {"\<\"Second\"\>"},
    {"\<\"Third\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Center}}}],
  "Column"]], "Output",
 ImageSize->{74, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->7263494]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->640641513],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Newlines and Tabs in Strings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CharacterCodes"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 40, 25.3691424}", "context" -> "", 
    "keywords" -> {
     "breaks", "ColumnForm", "line breaks", "newlines", "tabs", 
      "tab settings", "\\n", "\\t"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Explicit representations of newlines and tabs in strings. This prints on \
two lines. In InputForm there is an explicit \\n to represent the newline. ", 
    "synonyms" -> {"2.8.7"}, "title" -> "Newlines and Tabs in Strings", 
    "type" -> "Tutorial", "uri" -> "tutorial/NewlinesAndTabsInStrings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.7"->{
  Cell[1265, 43, 91, 2, 70, "Title",
   CellTags->{"S2.8.7", "7.1"},
   CellID->21585]},
 "7.1"->{
  Cell[1265, 43, 91, 2, 70, "Title",
   CellTags->{"S2.8.7", "7.1"},
   CellID->21585]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.7", 10138, 360},
 {"7.1", 10237, 364}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 640, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1265, 43, 91, 2, 70, "Title",
 CellTags->{"S2.8.7", "7.1"},
 CellID->21585],
Cell[1359, 47, 553, 15, 70, "DefinitionBox",
 CellID->18771],
Cell[1915, 64, 93, 1, 70, "Caption",
 CellID->23392],
Cell[2011, 67, 64, 1, 70, "MathCaption",
 CellID->4012],
Cell[CellGroupData[{
Cell[2100, 72, 100, 2, 28, "Input",
 CellID->14938],
Cell[2203, 76, 187, 5, 54, "Output",
 CellID->3789]
}, Open  ]],
Cell[2405, 84, 304, 11, 70, "MathCaption",
 CellID->21101],
Cell[CellGroupData[{
Cell[2734, 99, 102, 3, 28, "Input",
 CellID->18769],
Cell[2839, 104, 187, 5, 50, "Output",
 CellID->20809]
}, Open  ]],
Cell[3041, 112, 146, 5, 70, "MathCaption",
 CellID->19774],
Cell[CellGroupData[{
Cell[3212, 121, 97, 2, 47, "Input",
 CellID->31774],
Cell[3312, 125, 190, 5, 54, "Output",
 CellID->223099998]
}, Open  ]],
Cell[3517, 133, 72, 1, 70, "MathCaption",
 CellID->2838],
Cell[CellGroupData[{
Cell[3614, 138, 101, 3, 70, "Input",
 CellID->20456],
Cell[3718, 143, 189, 5, 50, "Output",
 CellID->215514714]
}, Open  ]],
Cell[3922, 151, 183, 6, 70, "MathCaption",
 CellID->368843934],
Cell[CellGroupData[{
Cell[4130, 161, 102, 2, 70, "Input",
 CellID->113326149],
Cell[4235, 165, 187, 5, 36, "Output",
 CellID->605437864]
}, Open  ]],
Cell[4437, 173, 963, 25, 70, "Text",
 CellID->29007],
Cell[5403, 200, 108, 3, 70, "MathCaption",
 CellID->8418],
Cell[CellGroupData[{
Cell[5536, 207, 188, 6, 70, "Input",
 CellID->10900],
Cell[5727, 215, 274, 8, 88, "Output",
 CellID->31728]
}, Open  ]],
Cell[6016, 226, 265, 8, 70, "MathCaption",
 CellID->21878],
Cell[CellGroupData[{
Cell[6306, 238, 237, 8, 70, "Input",
 CellID->21827],
Cell[6546, 248, 314, 12, 64, "Output",
 CellID->375510893]
}, Open  ]],
Cell[6875, 263, 70, 1, 70, "MathCaption",
 CellID->18955],
Cell[CellGroupData[{
Cell[6970, 268, 238, 8, 70, "Input",
 CellID->15739],
Cell[7211, 278, 313, 12, 64, "Output",
 CellID->7263494]
}, Open  ]],
Cell[CellGroupData[{
Cell[7561, 295, 72, 1, 70, "RelatedTutorialsSection",
 CellID->640641513],
Cell[7636, 298, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[7837, 306, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

