(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     91285,       1911]
NotebookOptionsPosition[     85224,       1725]
NotebookOutlinePosition[     88132,       1800]
CellTagsIndexPosition[     88038,       1794]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebook" :> Documentation`HelpLookup["paclet:ref/Notebook"], 
          "NotebookGet" :> Documentation`HelpLookup["paclet:ref/NotebookGet"],
           "NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], "NotebookPut" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPut"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Notebook\"\>", 
       2->"\<\"NotebookGet\"\>", 3->"\<\"NotebookOpen\"\>", 
       4->"\<\"NotebookPut\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Notebooks as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Expressions"
}], "Title",
 CellTags->{"S2.11.2", "2.1"},
 CellID->31306],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Notebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Notebook"], "[", "{", 
     SubscriptBox[
      StyleBox["cell", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["cell", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "a notebook containing a sequence of cells", "TableText"]},
   {
    RowBox[{
     ButtonBox["Notebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Notebook"], "[", 
     StyleBox["cells", "TI"], ",", 
     StyleBox["options", "TI"], "]"}], Cell[
    "a notebook with options specified", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18847],

Cell["Expressions corresponding to notebooks. ", "Caption",
 CellID->4806],

Cell[TextData[{
 "Here is a simple ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "MathCaption",
 CellID->21452],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 142},
 ImageMargins->0,
 CellID->1899751230],

Cell["Here is the expression that corresponds to this notebook.", \
"MathCaption",
 CellID->29571],

Cell["\<\
Notebook[{
    Cell[\"Section heading\", \"Section\"],
    Cell[\"Some text.\", \"Text\"],
    Cell[\"More text.\", \"Text\"]}]\
\>", "Program",
 CellID->23500],

Cell[TextData[{
 "Just like individual cells, notebooks in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can also have options. You can look at and modify these options using the \
option inspector in the standard notebook front end. "
}], "Text",
 CellID->6377],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["default value", "TableHeader"], ""},
   {
    ButtonBox["WindowSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowSize"], 
    RowBox[{"{", 
     StyleBox["nx", "TI"], ",", 
     StyleBox["ny", "TI"], "}"}], Cell["\<\
the size in pixels of the window used to display the notebook\
\>", "TableText"]},
   {
    ButtonBox["WindowFloating",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowFloating"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the window should float on top of others", "TableText"]},
   {
    ButtonBox["WindowToolbars",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowToolbars"], 
    RowBox[{"{", "}"}], Cell[
    "what toolbars to include at the top of the window", "TableText"]},
   {
    ButtonBox["ShowPageBreaks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowPageBreaks"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to show where page breaks would occur if the notebook were printed\
\>", "TableText"]},
   {
    ButtonBox["CellGrouping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellGrouping"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to group cells in the notebook", "TableText"]},
   {
    ButtonBox["Evaluator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluator"], "\"\<Local\>\"", Cell[
    "what kernel should be used to do evaluations in the notebook", 
     "TableText"]},
   {
    ButtonBox["Saveable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Saveable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether a notebook can be saved", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->10456],

Cell["\<\
A few of the large number of possible options for notebooks. \
\>", "Caption",
 CellID->26535],

Cell[TextData[{
 "A notebook with the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Saveable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Saveable"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " can always be saved using the ",
 StyleBox[ButtonBox["Save As",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SaveAs"], "MenuName"],
 " menu item, but does not respond to ",
 StyleBox[ButtonBox["Save",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Save"], "MenuName"],
 " and does not prompt for saving when it is closed."
}], "Text",
 CellID->186661439],

Cell[TextData[{
 "In addition to notebook options, you can also set any cell option at the \
notebook level. Doing this tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use that option setting as the default for all the cells in the \
notebook. You can override the default by explicitly setting the options \
within a particular cell or by using a named style which explicitly overrides \
the option."
}], "Text",
 CellID->21011],

Cell["\<\
Here is the expression corresponding to a notebook with a ruler displayed in \
the toolbar at the top of the window. \
\>", "MathCaption",
 CellID->1587],

Cell["\<\
Notebook[{
    Cell[\"Section heading\", \"Section\"],
    Cell[\"Some text.\", \"Text\"]},
       WindowToolbars->{\"RulerBar\"}]\
\>", "Program",
 CellID->6102],

Cell["This is what the notebook looks like in the front end.", "MathCaption",
 CellID->84],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{540, 191},
 CellID->1467726637],

Cell["\<\
This sets the default background color for all cells in the notebook.\
\>", "MathCaption",
 CellID->7883],

Cell["\<\
Notebook[{
    Cell[\"Section heading\", \"Section\"],
    Cell[\"Some text.\", \"Text\"]},
       Background->GrayLevel[.7]]\
\>", "Program",
 CellID->22313],

Cell["Now each cell has a gray background. ", "MathCaption",
 CellID->25932],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 142},
 ImageMargins->0,
 CellID->423695495],

Cell[TextData[{
 "If you go outside of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and look at the raw text of the file that corresponds to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, you will find that what is in the file is just the textual form \
of the expression that represents the notebook. One way to create a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook is therefore to construct an appropriate expression and put it in \
a file."
}], "Text",
 CellID->12582],

Cell[TextData[{
 "In notebook files that are written out by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", some additional information is typically included to make it faster for \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to read the file in again. The information is enclosed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " comments indicated by ",
 Cell[BoxData[
  RowBox[{"(*", 
   StyleBox["\[Ellipsis]", "TR"], "*)"}]], "InlineFormula"],
 " so that it does not affect the actual expression stored in the file. "
}], "Text",
 CellID->16000],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NotebookOpen",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookOpen"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", "]"}], Cell[
    "open a notebook file in the front end", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookPut",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookPut"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "create a notebook corresponding to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in the front end"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookGet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookGet"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell["\<\
get the expression corresponding to an open notebook in the front end\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1616],

Cell["Setting up notebooks in the front end from the kernel. ", "Caption",
 CellID->26358],

Cell[TextData[{
 "This writes a notebook expression out to the file ",
 Cell[BoxData[
  RowBox[{"sample", ".", "nb"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17843],

Cell[BoxData[
 RowBox[{
  RowBox[{"Notebook", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cell", "[", 
      RowBox[{"\"\<Section heading\>\"", ",", "\"\<Section\>\""}], "]"}], ",",
      
     RowBox[{"Cell", "[", 
      RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
   "]"}], ">>", "\"\<sample.nb\>\""}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27807],

Cell["This reads the notebook expression back from the file. ", "MathCaption",
 CellID->7909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "sample.nb"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->415],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cell", "[", 
     RowBox[{"\<\"Section heading\"\>", ",", "\<\"Section\"\>"}], "]"}], ",", 
    
    RowBox[{"Cell", "[", 
     RowBox[{"\<\"Some text.\"\>", ",", "\<\"Text\"\>"}], "]"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24765]
}, Open  ]],

Cell[TextData[{
 "This opens ",
 Cell[BoxData[
  RowBox[{"sample", ".", "nb"}]], "InlineFormula"],
 " as a notebook in the front end. "
}], "MathCaption",
 CellID->4530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookOpen", "[", "\"\<sample.nb\>\"", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->10072],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 122},
 ImageMargins->0,
 CellID->2100206548]
}, Open  ]],

Cell[TextData[{
 "Once you have set up a notebook in the front end using ",
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 ", you can then manipulate the notebook interactively just as you would any \
other notebook. But in order to use ",
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 ", you have to explicitly have a notebook expression in a file. With ",
 Cell[BoxData[
  ButtonBox["NotebookPut",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPut"]], "InlineFormula"],
 ", however, you can take a notebook expression that you have created in the \
kernel, and immediately display it as a notebook in the front end."
}], "Text",
 CellID->7058],

Cell["Here is a notebook expression in the kernel. ", "MathCaption",
 CellID->13281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cell", "[", 
     RowBox[{"\"\<Section heading\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
    
    RowBox[{"Cell", "[", 
     RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->22272],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cell", "[", 
     RowBox[{"\<\"Section heading\"\>", ",", "\<\"Section\"\>"}], "]"}], ",", 
    
    RowBox[{"Cell", "[", 
     RowBox[{"\<\"Some text.\"\>", ",", "\<\"Text\"\>"}], "]"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->30257]
}, Open  ]],

Cell["\<\
This uses the expression to set up a notebook in the front end. \
\>", "MathCaption",
 CellID->22757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookPut", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->8740],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 122},
 ImageMargins->0,
 CellID->7107]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["NotebookGet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookGet"]], "InlineFormula"],
 " to get the notebook corresponding to a particular ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " back into the kernel."
}], "MathCaption",
 CellID->29311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookGet", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->6257],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{"{", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"TextData", "[", "\<\"Section heading\"\>", "]"}], 
          ",", "\<\"Section\"\>"}], "]"}], ",", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"TextData", "[", "\<\"Some text.\"\>", "]"}], 
          ",", "\<\"Text\"\>"}], "]"}]}], "}"}], ",", "Open"}], "]"}], "]"}], 
   "}"}], "]"}]], "Output",
 ImageSize->{499, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->2393]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->575001242],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->151131554],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->568237900],

Cell[TextData[{
 ButtonBox["M195: Authoring in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m195.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m195.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->217076654]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notebooks as Mathematica Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CellsAsMathematicaExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 7.3858430}", "context" -> "", 
    "keywords" -> {
     "caches", "CellGrouping", "default options", "display", "evaluator", 
      "expressions", "file format", "format", "Get", "Notebook", 
      "notebook commands", "NotebookGet", "NotebookOpen", "NotebookPut", 
      "notebooks", "Open", "options", "Put", "sending", "ShowPageBreaks", 
      "transferring", "transmitting", "WindowFloating", "WindowSize", 
      "WindowToolbars"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Expressions corresponding to notebooks. Here is a simple Mathematica \
notebook. Here is the expression that corresponds to this notebook.", 
    "synonyms" -> {"2.11.2"}, "title" -> 
    "Notebooks as Mathematica Expressions", "type" -> "Tutorial", "uri" -> 
    "tutorial/NotebooksAsMathematicaExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.2"->{
  Cell[2151, 63, 158, 7, 70, "Title",
   CellTags->{"S2.11.2", "2.1"},
   CellID->31306]},
 "2.1"->{
  Cell[2151, 63, 158, 7, 70, "Title",
   CellTags->{"S2.11.2", "2.1"},
   CellID->31306]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.2", 87823, 1783},
 {"2.1", 87924, 1787}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1526, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2151, 63, 158, 7, 70, "Title",
 CellTags->{"S2.11.2", "2.1"},
 CellID->31306],
Cell[2312, 72, 953, 28, 70, "DefinitionBox",
 CellID->18847],
Cell[3268, 102, 74, 1, 70, "Caption",
 CellID->4806],
Cell[3345, 105, 135, 6, 70, "MathCaption",
 CellID->21452],
Cell[3483, 113, 6195, 104, 70, "Picture",
 CellID->1899751230],
Cell[9681, 219, 98, 2, 70, "MathCaption",
 CellID->29571],
Cell[9782, 223, 170, 6, 70, "Program",
 CellID->23500],
Cell[9955, 231, 271, 7, 70, "Text",
 CellID->6377],
Cell[10229, 240, 2273, 66, 70, "DefinitionBox3Col",
 CellID->10456],
Cell[12505, 308, 104, 3, 70, "Caption",
 CellID->26535],
Cell[12612, 313, 657, 20, 70, "Text",
 CellID->186661439],
Cell[13272, 335, 445, 10, 70, "Text",
 CellID->21011],
Cell[13720, 347, 163, 4, 70, "MathCaption",
 CellID->1587],
Cell[13886, 353, 172, 6, 70, "Program",
 CellID->6102],
Cell[14061, 361, 90, 1, 70, "MathCaption",
 CellID->84],
Cell[14154, 364, 46417, 763, 70, "Picture",
 CellID->1467726637],
Cell[60574, 1129, 115, 3, 70, "MathCaption",
 CellID->7883],
Cell[60692, 1134, 168, 6, 70, "Program",
 CellID->22313],
Cell[60863, 1142, 76, 1, 70, "MathCaption",
 CellID->25932],
Cell[60942, 1145, 5059, 85, 70, "Picture",
 CellID->423695495],
Cell[66004, 1232, 520, 14, 70, "Text",
 CellID->12582],
Cell[66527, 1248, 577, 17, 70, "Text",
 CellID->16000],
Cell[67107, 1267, 1198, 35, 70, "DefinitionBox",
 CellID->1616],
Cell[68308, 1304, 90, 1, 70, "Caption",
 CellID->26358],
Cell[68401, 1307, 178, 6, 70, "MathCaption",
 CellID->17843],
Cell[68582, 1315, 386, 12, 70, "Input",
 CellID->27807],
Cell[68971, 1329, 93, 1, 70, "MathCaption",
 CellID->7909],
Cell[CellGroupData[{
Cell[69089, 1334, 91, 3, 70, "Input",
 CellID->415],
Cell[69183, 1339, 427, 14, 36, "Output",
 CellID->24765]
}, Open  ]],
Cell[69625, 1356, 169, 6, 70, "MathCaption",
 CellID->4530],
Cell[CellGroupData[{
Cell[69819, 1366, 121, 3, 70, "Input",
 CellID->10072],
Cell[69943, 1371, 5390, 91, 70, "Picture",
 CellID->2100206548]
}, Open  ]],
Cell[75348, 1465, 819, 20, 70, "Text",
 CellID->7058],
Cell[76170, 1487, 84, 1, 70, "MathCaption",
 CellID->13281],
Cell[CellGroupData[{
Cell[76279, 1492, 338, 11, 70, "Input",
 CellID->22272],
Cell[76620, 1505, 427, 14, 36, "Output",
 CellID->30257]
}, Open  ]],
Cell[77062, 1522, 111, 3, 70, "MathCaption",
 CellID->22757],
Cell[CellGroupData[{
Cell[77198, 1529, 103, 3, 70, "Input",
 CellID->8740],
Cell[77304, 1534, 5384, 91, 70, "Picture",
 CellID->7107]
}, Open  ]],
Cell[82703, 1628, 405, 13, 70, "MathCaption",
 CellID->29311],
Cell[CellGroupData[{
Cell[83133, 1645, 103, 3, 70, "Input",
 CellID->6257],
Cell[83239, 1650, 680, 21, 54, "Output",
 CellID->2393]
}, Open  ]],
Cell[CellGroupData[{
Cell[83956, 1676, 72, 1, 70, "RelatedTutorialsSection",
 CellID->575001242],
Cell[84031, 1679, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]],
Cell[CellGroupData[{
Cell[84243, 1688, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->151131554],
Cell[84344, 1691, 414, 13, 70, "TutorialRelatedLinks",
 CellID->568237900],
Cell[84761, 1706, 409, 13, 70, "TutorialRelatedLinks",
 CellID->217076654]
}, Open  ]]
}, Open  ]],
Cell[85197, 1723, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

