(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22870,        737]
NotebookOptionsPosition[     18188,        595]
NotebookOutlinePosition[     20986,        667]
CellTagsIndexPosition[     20895,        661]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematicsOverview"], 
          "Advanced Numerical Differential Equation Solving in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/NDSolveOverview"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Numerical Mathematics\"\>", 
       2->"\<\"Advanced Numerical Differential Equation Solving in \
Mathematica\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluate" :> Documentation`HelpLookup["paclet:ref/Evaluate"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"], 
          "NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluate\"\>", 
       2->"\<\"InterpolatingFunction\"\>", 3->"\<\"NDSolve\"\>", 
       4->"\<\"Plot\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Differential Equations", "Title",
 CellTags->{"S1.6.4", "4.1"},
 CellID->17230],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["y", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "solve numerically for the function ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", with the independent variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " in the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", 
     StyleBox["eqns", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "solve a system of equations for the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7614],

Cell["Numerical solution of differential equations. ", "Caption",
 CellID->26598],

Cell[TextData[{
 "This generates a numerical solution to the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]"], "(", "x", ")"}], "=", 
    RowBox[{"y", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "<", "x", "<", "2"}], TraditionalForm]], "InlineMath"],
 ". The result is given in terms of an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"y", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4762]
}, Open  ]],

Cell[TextData[{
 "Here is the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", 
    RowBox[{"(", "1.5", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "1.5", "]"}], "/.", "%"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->26854],

Cell[BoxData[
 RowBox[{"{", "4.481685650645397`", "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->28448]
}, Open  ]],

Cell[TextData[{
 "With an algebraic equation such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", "3", "x", "+", "1", "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", each solution for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is simply a single number. For a differential equation, however, the \
solution is a ",
 StyleBox["function",
  FontSlant->"Italic"],
 ", rather than a single number. For example, in the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]"], "(", "x", ")"}], "=", 
    RowBox[{"y", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ", you want to get an approximation to the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " as the independent variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " varies over some range. "
}], "Text",
 CellID->23828],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents numerical approximations to functions as ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects. These objects are functions which, when applied to a particular \
",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", return the approximate value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " at that point. The ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " effectively stores a table of values for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", 
    SubscriptBox["x", "i"], ")"}], TraditionalForm]], "InlineMath"],
 ", then interpolates this table to find an approximation to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " at the particular ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " you request. "
}], "Text",
 CellID->22530],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["y", "TI"], "[", 
     StyleBox["x", "TI"], "]", "/.", 
     StyleBox["solution", "TI"]}], Cell[TextData[{
     "use the list of rules for the function ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " to get values for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["y", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InterpolatingFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InterpolatingFunction"], "[", 
     StyleBox["data", "TI"], "]", "[", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "evaluate an interpolated function at the point ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Plot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot"], "[", 
     ButtonBox["Evaluate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Evaluate"], "[", 
     StyleBox["y", "TI"], "[", 
     StyleBox["x", "TI"], "]", "/.", 
     StyleBox["solution", "TI"], "]", ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["plot the solution to a differential equation", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1224],

Cell[TextData[{
 "Using results from ",
 StyleBox["NDSolve", "MR"],
 ". "
}], "Caption",
 CellID->8692],

Cell["This solves a system of two coupled differential equations. ", \
"MathCaption",
 CellID->11114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"z", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"-", 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"z", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->18887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "3.141592653589793`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"z", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "3.141592653589793`"}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->25960]
}, Open  ]],

Cell[TextData[{
 "Here is the value of ",
 Cell[BoxData[
  RowBox[{"z", "[", "2", "]"}]], "InlineFormula"],
 " found from the solution. "
}], "MathCaption",
 CellID->31114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "[", "2", "]"}], "/.", "%"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->26245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "0.4161465105807504`"}], "}"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->18464]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the solution for ",
 Cell[BoxData[
  RowBox[{"z", "[", "x", "]"}]], "InlineFormula"],
 " found on line 3. ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " is discussed in \"",
 ButtonBox["Basic Plotting",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/BasicPlotting"],
 "\". "
}], "MathCaption",
 CellID->31643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"z", "[", "x", "]"}], "/.", "%3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->8819],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWUtsW1UQvfFzHAe1iRGfBvEztICpIKTlFwjQ8FEboEUR3/ApxA1tnbYQ
y02Ryy+CCgIqwhJdRKqEIsEiy2wqZZlllllmmWWWWWb5ODPzrv3efWM7z0h8
KsV+43vueTNzZ+bOvT1RnC2d/qw4Oz1VzB+rFMul6amL+aMzFfzkdRljbuDv
3IDBs48n/rvh+/iOf/bg0wMgRRI9+PzPpPD4JyOyzohHH+mGbEy3g7guP3vy
Rf9SVkzE8xvLa2trq6uri4uLJj03N9eVQCcC/EJi787ODjgwfWxsLJ/P4/fh
4eHR0dHJycnErGHEz/SRhYbgAGM2mwUpnldWVjY3N3s7ZP2RPjJQuFQqDQwM
gBiUeElffcXIn5nQd3j2FZ69sbFRLpcxGwotLCxsbW3dzLP3BbO+J6l7eXkZ
44VCoVarAWJurWPCjN8yFj4ECt4bHx+HboKKYb+OYqEDHGHuULFfxrCkw50q
9jJ7bWlpCcoK8O6IPVUeh5PgrYmJCbz0XpXnEuO2t7ex9IBiwn0qbpZlRB3e
R7G3X0VVmA3KIK5AiIcDEa0qIRbEhHlQZZmJskC5h1Tc5yxjzQK2h1XUBWaD
V0GFpQLbQRV3nmXEydDQEFn4SERzGUXkYBQY86jKUbLvgssRrHgYjMRoOOdt
HXDj9WxID6yvGWJsJpYlPc48t56csd7BspLGh3ytCkmyhWjb8p5mGRkozjSH
E+hH4hQL4iOwmCeazO/29Xw+xTICGnaRf55sMT88z5WLflBNwbO+vm6eiqyU
/XZnTbKM96JOUHY+HYkSGZ2fn4dtsNAMq1Fy0noAEVmtVs2zKuojluFh+Jni
cURFfWi9AX0oB55TUR+wDCuBIlufj2gto5iNUapOL6gcE9byYN2PqKic3zzS
+/3me2ufMmbn7fGD3INX6bdWHOkmHJbfjWYaS6uW9Mciyo3ovY4c38n6HIQb
y7wX9iALUCzqkwKt0y3ZtEx135aKMXj/mqXCiICHsXWGloz9bRiTWEurnPsH
rJRqIbWNctYdj+uYUxka8h4/VIc6WktbR903tbcu7TdqIVuFzKeK6/qtvVXe
rnVIYlUMkdi6uOdR2bAfUCWNezyekXvb6uVavNuctHXU7kN9frTL7XPGxRrZ
B6jCu11xv4Mnzb3QeKMGkjTusI2pOr7BMsbRqdC+8Sqjsn58B2DLFe+cYBnd
M95De8przNCzC8+7q3ecZawbekZier1jJp5JPSqYaA8/nojpd1OvzAnfG9vR
/mPybfSRERlFHI3L/9OOTmS6RKAzsZyLO1nd2x35MZYb++FgG7y06Ta3bNa6
+XTMsiJ86ZHzuJ7VR3kUMY3Ipt3pzfpomOMVlpFDQFEdfEtFvWxRyFw6/b6t
ol7ygzqCCkF15B0V9aLv17tTqiPvRrSWUfTpweh7KscRluX8Tvk/oaK4s6VO
EjsZ5fb7Koq7Yw8BLl2Z9Mcx1Ij1JtyNjl/69brWI9Y/Qfd+UuV4hmWcI4Lu
/WMVNWz9E5xUPlFRfBIJain5aTKij4xKVSP/FFUOPkt55XIZNpF/TkWiTuvp
3Qh8PGR3rVYzn/p6xqg9REg+bCMH1mBV5dTZAc8h65UgAs8k4CGRT98eLAni
6myT+bbLcv0xaP2BjhB+NdMt5rfqTvi+gW4FglPvucjKRLuAxiy+w6AzW3Br
cV5ddb4PoVsLxLscXC9EYudg6N3IHbl3ibEUbIQFnp5RUXzjk5b4kCArq7gH
WEZOFAoFWv9KRKMDlgUUCGgk0EWV5X6rUz6fpyy8pKLyzAb75AYUtF+ouHvs
W1EaYCSCqqri+CYuDU9Bd1QG2Hg5ov1dPC73VnA5tP9K5eFbwrRkNNwFBb9R
cftCOCnHcyqObzO7ob+oFlTu7yK63cIYVFsoBqfhk+LmisrHPXcGOQojwSfR
Afof6rHZ7KSunXJMBlEDJngWL4aL8eKfmKnXQcd7ezfu5VwN68AHz+VyObCC
kuLyagec5KcUfdyEXJLmR+6JMYwHiFhNWP5rAm72DSabbrkIg6p4A3n7WodW
X/9b89ze4g/+Nf4/JKbrL2sHP1g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->90748013]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", 
     StyleBox["eqn", "TI"], ",", 
     StyleBox["u", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["t", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["max", "TI"]], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["solve a partial differential equation", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4948],

Cell["Numerical solution of partial differential equations. ", "Caption",
 CellID->24544],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->340267303],

Cell[TextData[ButtonBox["Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematicsOverview"]], "RelatedTutorials",
 CellID->432952818],

Cell[TextData[{
 ButtonBox["Advanced Numerical Differential Equation Solving in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->1373056497]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Differential Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalMathematicsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalEquationSolving"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ManipulatingNumericalData"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 9.0265100}", "context" -> "", 
    "keywords" -> {
     "differential equations", "InterpolatingFunction", "NDSolve", 
      "numerical differential equations", "ODE", 
      "ordinary differential equations", "partial differential equations", 
      "PDE", "phase plots", "solving differential equations"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Numerical solution of differential equations. This generates a numerical \
solution to the equation y^,(x)=y(x) with 0<x<2. The result is given in terms \
of an InterpolatingFunction. Here is the value of y(1.5). ", 
    "synonyms" -> {"1.6.4"}, "title" -> "Numerical Differential Equations", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalDifferentialEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.6.4"->{
  Cell[2375, 66, 95, 2, 70, "Title",
   CellTags->{"S1.6.4", "4.1"},
   CellID->17230]},
 "4.1"->{
  Cell[2375, 66, 95, 2, 70, "Title",
   CellTags->{"S1.6.4", "4.1"},
   CellID->17230]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.6.4", 20684, 650},
 {"4.1", 20783, 654}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1750, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2375, 66, 95, 2, 70, "Title",
 CellTags->{"S1.6.4", "4.1"},
 CellID->17230],
Cell[2473, 70, 2190, 69, 70, "DefinitionBox",
 CellID->7614],
Cell[4666, 141, 81, 1, 70, "Caption",
 CellID->26598],
Cell[4750, 144, 591, 19, 70, "MathCaption",
 CellID->17139],
Cell[CellGroupData[{
Cell[5366, 167, 414, 14, 28, "Input",
 CellID->29546],
Cell[5783, 183, 462, 17, 36, "Output",
 CellID->4762]
}, Open  ]],
Cell[6260, 203, 190, 8, 70, "MathCaption",
 CellID->767],
Cell[CellGroupData[{
Cell[6475, 215, 120, 4, 28, "Input",
 CellID->26854],
Cell[6598, 221, 194, 6, 36, "Output",
 CellID->28448]
}, Open  ]],
Cell[6807, 230, 975, 30, 70, "Text",
 CellID->23828],
Cell[7785, 262, 1169, 35, 70, "Text",
 CellID->22530],
Cell[8957, 299, 1958, 58, 70, "DefinitionBox",
 CellID->1224],
Cell[10918, 359, 103, 5, 70, "Caption",
 CellID->8692],
Cell[11024, 366, 101, 2, 70, "MathCaption",
 CellID->11114],
Cell[CellGroupData[{
Cell[11150, 372, 680, 23, 70, "Input",
 CellID->18887],
Cell[11833, 397, 801, 28, 54, "Output",
 CellID->25960]
}, Open  ]],
Cell[12649, 428, 172, 6, 70, "MathCaption",
 CellID->31114],
Cell[CellGroupData[{
Cell[12846, 438, 118, 4, 70, "Input",
 CellID->26245],
Cell[12967, 444, 213, 7, 36, "Output",
 CellID->18464]
}, Open  ]],
Cell[13195, 454, 420, 15, 70, "MathCaption",
 CellID->31643],
Cell[CellGroupData[{
Cell[13640, 473, 273, 9, 28, "Input",
 CellID->8819],
Cell[13916, 484, 2315, 42, 127, "Output",
 Evaluatable->False,
 CellID->90748013]
}, Open  ]],
Cell[16246, 529, 1192, 35, 70, "DefinitionBox",
 CellID->4948],
Cell[17441, 566, 89, 1, 70, "Caption",
 CellID->24544],
Cell[CellGroupData[{
Cell[17555, 571, 72, 1, 70, "RelatedTutorialsSection",
 CellID->340267303],
Cell[17630, 574, 174, 4, 70, "RelatedTutorials",
 CellID->432952818],
Cell[17807, 580, 327, 9, 70, "RelatedTutorials",
 CellID->1373056497]
}, Open  ]]
}, Open  ]],
Cell[18161, 593, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

