(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41305,       1461]
NotebookOptionsPosition[     33811,       1217]
NotebookOutlinePosition[     36862,       1293]
CellTagsIndexPosition[     36769,       1287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Functions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindMaximum" :> 
          Documentation`HelpLookup["paclet:ref/FindMaximum"], "FindMinimum" :> 
          Documentation`HelpLookup["paclet:ref/FindMinimum"], 
          "LinearProgramming" :> 
          Documentation`HelpLookup["paclet:ref/LinearProgramming"], 
          "NMaximize" :> Documentation`HelpLookup["paclet:ref/NMaximize"], 
          "NMinimize" :> Documentation`HelpLookup["paclet:ref/NMinimize"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"FindMaximum\"\>", 
       2->"\<\"FindMinimum\"\>", 3->"\<\"LinearProgramming\"\>", 
       4->"\<\"NMaximize\"\>", 5->"\<\"NMinimize\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Optimization", "Title",
 CellTags->{"S3.9.8", "8.1"},
 CellID->24524],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindMinimum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindMinimum"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", "]"}], Cell[TextData[{
     "search for a local minimum of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", starting at ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "="}]], "InlineFormula"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindMinimum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindMinimum"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "search for a local minimum of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindMinimum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindMinimum"], "[", 
     StyleBox["f", "TI"], ",", "{", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "0"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "search for a local minimum in several variables", "TableText"]},
   {
    RowBox[{
     ButtonBox["FindMinimum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindMinimum"], "[", 
     RowBox[{
      RowBox[{"{", 
       StyleBox[
        RowBox[{"f", ",", "cons"}], "TI"], 
       StyleBox["}", "TI"]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], "0"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], "0"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "search for a local minimum subject to the constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"],
     " starting at ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "=", 
         SubscriptBox["x", "0"]}], ",", 
        RowBox[{"y", "=", 
         SubscriptBox["y", "0"]}], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindMinimum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindMinimum"], "[", 
     RowBox[{
      RowBox[{"{", 
       StyleBox[
        RowBox[{"f", ",", "cons"}], "TI"], 
       StyleBox["}", "TI"]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "search for a local minimum subject to the constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["FindMaximum",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindMaximum"], "[", 
      RowBox[{
       StyleBox["f", "TI"], ",", 
       StyleBox["x", "TI"]}], "]"}], Cell[", etc.", "TableText"]}], Cell[
    "search for a local maximum", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18811],

Cell["Searching for local minima and maxima. ", "Caption",
 CellID->21154],

Cell[TextData[{
 "This finds the value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " which minimizes ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalGamma]", "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ", starting at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "2"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->19217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->12940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8856031944108887`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.461632144845406`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->32112]
}, Open  ]],

Cell["\<\
The last element of the list gives the value at which the minimum is \
achieved. \
\>", "MathCaption",
 CellID->32184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", "x", "]"}], "/.", 
  RowBox[{"Last", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->27449],

Cell[BoxData["0.8856031944108887`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->25628]
}, Open  ]],

Cell[TextData[{
 "Like ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 " work by starting from a point, then progressively searching for a minimum \
or maximum. But since they return a result as soon as they find anything, \
they may give only a local minimum or maximum of your function, not a global \
one. "
}], "Text",
 CellID->20463],

Cell["This curve has two local minima. ", "MathCaption",
 CellID->30963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->10397],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12922508]
}, Open  ]],

Cell[TextData[{
 "Starting at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", you get the local minimum on the right. "
}], "MathCaption",
 CellID->3000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"3", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->786],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.0702301817761541`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.1309011226994201`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->7443]
}, Open  ]],

Cell["\<\
This gives the local minimum on the left, which in this case is also the \
global minimum. \
\>", "MathCaption",
 CellID->4438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"3", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->26218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.513905038934789`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.300839565915079`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->10120]
}, Open  ]],

Cell["You can specify variables without initial values.", "MathCaption",
 CellID->226690612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"3", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62635168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.0702301817761541`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.1309011226994201`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334895056]
}, Open  ]],

Cell["You can specify a constraint.", "MathCaption",
 CellID->44828578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", 
     RowBox[{"x", "<", "0"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27285896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.5139050389347575`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.3008396322487403`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->465208143]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NMinimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMinimize"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "try to find the global minimum of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NMinimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMinimize"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "try to find the global minimum over several variables", "TableText"]},
   {
    RowBox[{
     ButtonBox["NMaximize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMaximize"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "try to find the global maximum of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NMaximize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMaximize"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "try to find the global maximum over several variables", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24912],

Cell["Finding global minima and maxima. ", "Caption",
 CellID->16897],

Cell["This immediately finds the global minimum. ", "MathCaption",
 CellID->9605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->6946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.513905038934789`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.3008395660257432`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->1789]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " are numerical analogs of ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 ". But unlike ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " they usually cannot guarantee to find absolute global minima and maxima. \
Nevertheless, they typically work well when the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is fairly smooth, and has a limited number of local minima and maxima. "
}], "Text",
 CellID->5570],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NMinimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMinimize"], "[", "{", 
     StyleBox["f", "TI"], ",", 
     StyleBox["cons", "TI"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "try to find the global minimum of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " subject to constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NMaximize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMaximize"], "[", "{", 
     StyleBox["f", "TI"], ",", 
     StyleBox["cons", "TI"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "try to find the global maximum of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " subject to constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2337],

Cell["Finding global minima and maxima subject to constraints. ", "Caption",
 CellID->19435],

Cell[TextData[{
 "With the constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " will give the local minimum on the right. "
}], "MathCaption",
 CellID->30990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"3", 
       RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", 
     RowBox[{"x", ">", "0"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->27797],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.0702301817761544`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.1309011226931176`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->20192]
}, Open  ]],

Cell[TextData[{
 "This finds the minimum of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", 
    RowBox[{"2", " ", "y"}]}], TraditionalForm]], "InlineMath"],
 " within the unit circle. "
}], "MathCaption",
 CellID->10317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->13903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.2360679786638626`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.4472135967416372`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8944271909611128`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{285, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->11230]
}, Open  ]],

Cell[TextData[{
 "In this case ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " can give an exact result. "
}], "MathCaption",
 CellID->24865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->24952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox["5"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["4", 
        SqrtBox["5"]], "-", 
       SqrtBox["5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["2", 
        SqrtBox["5"]]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{233, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->6719]
}, Open  ]],

Cell["But in this case it cannot. ", "MathCaption",
 CellID->13297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->1654],

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "+", 
       RowBox[{"2", " ", "y"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 ImageSize->{280, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->11528]
}, Open  ]],

Cell[TextData[{
 "This gives a numerical approximation, effectively using ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->20183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.617272877177728`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.4472135960188023`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8944271911984297`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->9561]
}, Open  ]],

Cell[TextData[{
 "If both the objective function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and the constraints ",
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " are linear in all variables, then minimization and maximization correspond \
to a ",
 StyleBox["linear programming problem",
  FontSlant->"Italic"],
 ". Sometimes it is convenient to state such problems not in terms of \
explicit equations, but instead in terms of matrices and vectors. "
}], "Text",
 CellID->18913],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LinearProgramming",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinearProgramming"], "[", 
     StyleBox["c", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "find the vector ",
     Cell[BoxData[
      FormBox[
       StyleBox["x", "TB"], TraditionalForm]], "InlineMath"],
     " which minimizes ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["c", "TB"], ".", 
        StyleBox["x", "TB"]}], TraditionalForm]], "InlineMath"],
     " subject to the constraints ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["m", "TB"], ".", 
        StyleBox["x", "TB"], "\[GreaterEqual]", 
        StyleBox["b", "TB"]}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["x", "TB"], "\[GreaterEqual]", "0"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LinearProgramming",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinearProgramming"], "[", 
     StyleBox["c", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["l", "TI"], "]"}], Cell[TextData[{
     "use the constraints ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["m", "TB"], ".", 
        StyleBox["x", "TB"], "\[GreaterEqual]", 
        StyleBox["b", "TB"]}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["x", "TB"], "\[GreaterEqual]", "l"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->3154],

Cell["Linear programming in matrix form. ", "Caption",
 CellID->31824],

Cell["Here is a linear programming problem in equation form. ", "MathCaption",
 CellID->28698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], ",", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"5", "y"}]}], ">=", "10"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], ">=", "2"}], ",", 
     RowBox[{"x", ">=", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->19550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["32", "3"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["10", "3"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["4", "3"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{148, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->18390]
}, Open  ]],

Cell["Here is the corresponding problem in matrix form. ", "MathCaption",
 CellID->16148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->3356],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["10", "3"], ",", 
   FractionBox["4", "3"]}], "}"}]], "Output",
 ImageSize->{59, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->30124]
}, Open  ]],

Cell[TextData[{
 "You can specify a mixture of equality and inequality constraints by making \
the list ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " be a sequence of pairs ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["b", "i"], ",", 
     SubscriptBox["s", "i"]}], "}"}], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", then the ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " constraint is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "i"], 
    RowBox[{".", "x"}], "\[GreaterEqual]", 
    SubscriptBox["b", "i"]}], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " then it is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "i"], 
    RowBox[{
     RowBox[{".", "x"}], "=="}], 
    SubscriptBox["b", "i"]}], TraditionalForm]], "InlineMath"],
 ", and if ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " then it is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "i"], ".", "x", "\[LessEqual]", 
    SubscriptBox["b", "i"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->14901],

Cell[TextData[{
 "This makes the first inequality use ",
 Cell[BoxData[
  FormBox["\[LessEqual]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->20318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->3905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->6768]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearProgramming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearProgramming"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
 ", you can make ",
 Cell[BoxData[
  FormBox["l", TraditionalForm]], "InlineMath"],
 " be a list of pairs ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["l", "1"], ",", 
       SubscriptBox["u", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["l", "2"], ",", 
       SubscriptBox["u", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 " representing lower and upper bounds on the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->32140],

Cell[TextData[{
 "In doing large linear programming problems, it is often convenient to give \
the matrix ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " as a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object. "
}], "Text",
 CellID->22187],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->29353288],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Optimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalSolutionOfDifferentialEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ControllingThePrecisionOfResults"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 17.1829688}", "context" -> "", 
    "keywords" -> {
     "constrained optimization", "cost function", "extremization", 
      "FindMinimum", "global minimization", "goal functions", "inequalities", 
      "linear programming", "LinearProgramming", "local minimization", 
      "LP (linear programming)", "matrices", "maximization", "minimization", 
      "NMaximize", "NMinimize", "numerical maximization", 
      "numerical minimization", "objective functions", "operations research", 
      "optimization", "payoff functions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Searching for local minima and maxima. This finds the value of x which \
minimizes \\[CapitalGamma](x), starting at x=2. The last element of the list \
gives the value at which the minimum is achieved. ", 
    "synonyms" -> {"1.6.5", "3.9.8"}, "title" -> "Numerical Optimization", 
    "type" -> "Tutorial", "uri" -> "tutorial/NumericalOptimization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.8"->{
  Cell[2315, 66, 85, 2, 70, "Title",
   CellTags->{"S3.9.8", "8.1"},
   CellID->24524]},
 "8.1"->{
  Cell[2315, 66, 85, 2, 70, "Title",
   CellTags->{"S3.9.8", "8.1"},
   CellID->24524]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.8", 36558, 1276},
 {"8.1", 36657, 1280}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1690, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2315, 66, 85, 2, 70, "Title",
 CellTags->{"S3.9.8", "8.1"},
 CellID->24524],
Cell[2403, 70, 3993, 127, 70, "DefinitionBox",
 CellID->18811],
Cell[6399, 199, 74, 1, 70, "Caption",
 CellID->21154],
Cell[6476, 202, 388, 15, 70, "MathCaption",
 CellID->19217],
Cell[CellGroupData[{
Cell[6889, 221, 209, 7, 28, "Input",
 CellID->12940],
Cell[7101, 230, 293, 10, 36, "Output",
 CellID->32112]
}, Open  ]],
Cell[7409, 243, 128, 4, 70, "MathCaption",
 CellID->32184],
Cell[CellGroupData[{
Cell[7562, 251, 153, 5, 28, "Input",
 CellID->27449],
Cell[7718, 258, 173, 5, 36, "Output",
 CellID->25628]
}, Open  ]],
Cell[7906, 266, 680, 21, 70, "Text",
 CellID->20463],
Cell[8589, 289, 72, 1, 70, "MathCaption",
 CellID->30963],
Cell[CellGroupData[{
Cell[8686, 294, 305, 11, 28, "Input",
 CellID->10397],
Cell[8994, 307, 2612, 47, 128, "Output",
 Evaluatable->False,
 CellID->12922508]
}, Open  ]],
Cell[11621, 357, 200, 7, 70, "MathCaption",
 CellID->3000],
Cell[CellGroupData[{
Cell[11846, 368, 284, 10, 70, "Input",
 CellID->786],
Cell[12133, 380, 312, 11, 36, "Output",
 CellID->7443]
}, Open  ]],
Cell[12460, 394, 137, 4, 70, "MathCaption",
 CellID->4438],
Cell[CellGroupData[{
Cell[12622, 402, 307, 11, 70, "Input",
 CellID->26218],
Cell[12932, 415, 330, 11, 36, "Output",
 CellID->10120]
}, Open  ]],
Cell[13277, 429, 92, 1, 70, "MathCaption",
 CellID->226690612],
Cell[CellGroupData[{
Cell[13394, 434, 239, 8, 70, "Input",
 CellID->62635168],
Cell[13636, 444, 316, 11, 36, "Output",
 CellID->334895056]
}, Open  ]],
Cell[13967, 458, 71, 1, 70, "MathCaption",
 CellID->44828578],
Cell[CellGroupData[{
Cell[14063, 463, 322, 11, 70, "Input",
 CellID->27285896],
Cell[14388, 476, 335, 11, 36, "Output",
 CellID->465208143]
}, Open  ]],
Cell[14738, 490, 1727, 51, 70, "DefinitionBox",
 CellID->24912],
Cell[16468, 543, 69, 1, 70, "Caption",
 CellID->16897],
Cell[16540, 546, 81, 1, 70, "MathCaption",
 CellID->9605],
Cell[CellGroupData[{
Cell[16646, 551, 229, 8, 70, "Input",
 CellID->6946],
Cell[16878, 561, 330, 11, 36, "Output",
 CellID->1789]
}, Open  ]],
Cell[17223, 575, 1110, 36, 70, "Text",
 CellID->5570],
Cell[18336, 613, 1456, 43, 70, "DefinitionBox",
 CellID->2337],
Cell[19795, 658, 92, 1, 70, "Caption",
 CellID->19435],
Cell[19890, 661, 338, 12, 70, "MathCaption",
 CellID->30990],
Cell[CellGroupData[{
Cell[20253, 677, 313, 11, 70, "Input",
 CellID->27797],
Cell[20569, 690, 313, 11, 36, "Output",
 CellID->20192]
}, Open  ]],
Cell[20897, 704, 223, 8, 70, "MathCaption",
 CellID->10317],
Cell[CellGroupData[{
Cell[21145, 716, 381, 14, 70, "Input",
 CellID->13903],
Cell[21529, 732, 431, 14, 36, "Output",
 CellID->11230]
}, Open  ]],
Cell[21975, 749, 218, 8, 70, "MathCaption",
 CellID->24865],
Cell[CellGroupData[{
Cell[22218, 761, 380, 14, 70, "Input",
 CellID->24952],
Cell[22601, 777, 500, 20, 55, "Output",
 CellID->6719]
}, Open  ]],
Cell[23116, 800, 67, 1, 70, "MathCaption",
 CellID->13297],
Cell[CellGroupData[{
Cell[23208, 805, 415, 15, 70, "Input",
 CellID->1654],
Cell[23626, 822, 522, 18, 39, "Output",
 CellID->11528]
}, Open  ]],
Cell[24163, 843, 238, 8, 70, "MathCaption",
 CellID->10274],
Cell[CellGroupData[{
Cell[24426, 855, 95, 3, 70, "Input",
 CellID->20183],
Cell[24524, 860, 389, 13, 36, "Output",
 CellID->9561]
}, Open  ]],
Cell[24928, 876, 514, 14, 70, "Text",
 CellID->18913],
Cell[25445, 892, 2021, 65, 70, "DefinitionBox",
 CellID->3154],
Cell[27469, 959, 70, 1, 70, "Caption",
 CellID->31824],
Cell[27542, 962, 94, 1, 70, "MathCaption",
 CellID->28698],
Cell[CellGroupData[{
Cell[27661, 967, 472, 17, 70, "Input",
 CellID->19550],
Cell[28136, 986, 389, 14, 51, "Output",
 CellID->18390]
}, Open  ]],
Cell[28540, 1003, 89, 1, 70, "MathCaption",
 CellID->16148],
Cell[CellGroupData[{
Cell[28654, 1008, 493, 17, 70, "Input",
 CellID->3356],
Cell[29150, 1027, 246, 9, 51, "Output",
 CellID->30124]
}, Open  ]],
Cell[29411, 1039, 1655, 63, 70, "Text",
 CellID->14901],
Cell[31069, 1104, 172, 6, 70, "MathCaption",
 CellID->20318],
Cell[CellGroupData[{
Cell[31266, 1114, 675, 24, 70, "Input",
 CellID->3905],
Cell[31944, 1140, 200, 7, 36, "Output",
 CellID->6768]
}, Open  ]],
Cell[32159, 1150, 949, 35, 70, "Text",
 CellID->32140],
Cell[33111, 1187, 349, 12, 70, "Text",
 CellID->22187],
Cell[CellGroupData[{
Cell[33485, 1203, 71, 1, 70, "RelatedTutorialsSection",
 CellID->29353288],
Cell[33559, 1206, 198, 5, 70, "RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],
Cell[33784, 1215, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

