(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24549,        819]
NotebookOptionsPosition[     19023,        649]
NotebookOutlinePosition[     22055,        725]
CellTagsIndexPosition[     21964,        719]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Functions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindRoot\"\>"}, "\<\"functions\"\>",
        
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Root Finding", "Title",
 CellTags->{"S3.9.6", "6.1"},
 CellID->17120],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " gives you a general way to find numerical approximations to the solutions \
of polynomial equations. Finding numerical solutions to more general \
equations, however, can be much more difficult, as discussed in \"",
 ButtonBox["Equations in One Variable",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EquationsInOneVariable"],
 "\". ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " gives you a way to search for a numerical root of a function or a \
numerical solution to an arbitrary equation, or set of equations."
}], "Text",
 CellID->28899],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindRoot"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]]}], "}"}]}], "]"}], Cell[TextData[{
     "search for a numerical root of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     ", starting with ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "\[LongEqual]", 
        SubscriptBox["x", "0"]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindRoot"], "[", 
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", "]"}], Cell[TextData[{
     "search for a numerical solution to the equation ",
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "==", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     ", starting with ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "\[LongEqual]", 
        SubscriptBox["x", "0"]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["FindRoot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindRoot"], "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], "0"], "}", ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["y", "TI"], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], "0"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}]}], "]"}], 
    "\[SpanFromLeft]"},
   {" ", Cell[TextData[{
     "search for a simultaneous numerical root of all the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindRoot"], "[", "{", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "0"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {" ", Cell[TextData[{
     "search for a numerical solution to the simultaneous equations ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["eqn", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->16834],

Cell["Numerical root finding. ", "Caption",
 CellID->24804],

Cell[TextData[{
 "The curves for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " intersect at one point. "
}], "MathCaption",
 CellID->9969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8283],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59096174]
}, Open  ]],

Cell[TextData[{
 "This finds a numerical approximation to the value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " at which the intersection occurs. The ",
 Cell[BoxData["0"], "InlineFormula"],
 " tells ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " what value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " to try first. "
}], "MathCaption",
 CellID->13538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->796207867]
}, Open  ]],

Cell[TextData[{
 "In trying to find a solution to your equation, ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " starts at the point you specify, and then progressively tries to get \
closer and closer to a solution. Even if your equations have several \
solutions, ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " always returns the first solution it finds. Which solution this is will \
depend on what starting point you chose. If you start sufficiently close to a \
particular solution, ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " will usually return that solution. "
}], "Text",
 CellID->29017],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " has an infinite number of roots of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "n", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". If you start sufficiently close to a particular root, ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " will give you that root. "
}], "MathCaption",
 CellID->24200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "3.141592653589793`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1493705160]
}, Open  ]],

Cell[TextData[{
 "If you start with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "6"}], TraditionalForm]], "InlineMath"],
 ", you get a numerical approximation to the root ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "2", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->16448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "6.283185307179586`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->468437053]
}, Open  ]],

Cell[TextData[{
 "If you want ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to search for complex solutions, then you have to give a complex starting \
value. "
}], "MathCaption",
 CellID->29009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "==", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "I"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->24546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.3169578969248168`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1458776703]
}, Open  ]],

Cell["This finds a zero of the Riemann zeta function. ", "MathCaption",
 CellID->25270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "+", 
     RowBox[{"I", " ", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->14241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", "\[Rule]", 
   RowBox[{"14.134725141734693`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.5483929136770888`*^-15", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{204, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->480637581]
}, Open  ]],

Cell["This finds a solution to a set of simultaneous equations. ", \
"MathCaption",
 CellID->14293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "==", 
      RowBox[{"Cos", "[", "y", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->7196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "1.856194490192345`"}]}], ",", 
   RowBox[{"y", "\[Rule]", "2.856194490192345`"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->127609108]
}, Open  ]],

Cell[TextData[{
 "The variables used by ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " can have values that are lists. This allows you to find roots of functions \
that take vectors as arguments. "
}], "Text",
 CellID->15031],

Cell[TextData[{
 "This is a way to solve a linear equation for the variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ".", "x"}], "==", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->14972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4.`"}], ",", "4.5`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1227581060]
}, Open  ]],

Cell[TextData[{
 "This finds a normalized eigenvector ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and eigenvalue ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->18328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ".", "x"}], "==", 
      RowBox[{"a", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{"x", ".", "x"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->23288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4159735579192843`", ",", "0.9093767091321241`"}], "}"}]}], 
   ",", 
   RowBox[{"a", "\[Rule]", "5.372281323269015`"}]}], "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1127996631]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->421426840],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Root Finding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalSolutionOfPolynomialEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalSolutionOfDifferentialEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 22.5112302}", "context" -> "", 
    "keywords" -> {
     "FindRoot", "numerical root finding", "numerical solution of equations", 
      "Riemann hypothesis", "Root finding", "solution of equations", 
      "solving equations", "zero finding"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "NSolve gives you a general way to find numerical approximations to the \
solutions of polynomial equations. Finding numerical solutions to more \
general equations, however, can be much more difficult, as discussed in \
\"Equations in One Variable\". FindRoot gives you a way to search for a \
numerical root of a function or a numerical solution to an arbitrary \
equation, or set of equations. Numerical root finding. The curves for cos(x) \
and x intersect at one point. ", "synonyms" -> {"3.9.6"}, "title" -> 
    "Numerical Root Finding", "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalRootFinding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.6"->{
  Cell[1856, 60, 85, 2, 70, "Title",
   CellTags->{"S3.9.6", "6.1"},
   CellID->17120]},
 "6.1"->{
  Cell[1856, 60, 85, 2, 70, "Title",
   CellTags->{"S3.9.6", "6.1"},
   CellID->17120]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.6", 21753, 708},
 {"6.1", 21852, 712}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1231, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1856, 60, 85, 2, 70, "Title",
 CellTags->{"S3.9.6", "6.1"},
 CellID->17120],
Cell[1944, 64, 761, 19, 70, "Text",
 CellID->28899],
Cell[2708, 85, 3485, 110, 70, "DefinitionBox",
 CellID->16834],
Cell[6196, 197, 59, 1, 70, "Caption",
 CellID->24804],
Cell[6258, 200, 282, 11, 70, "MathCaption",
 CellID->9969],
Cell[CellGroupData[{
Cell[6565, 215, 280, 10, 28, "Input",
 CellID->8283],
Cell[6848, 227, 2997, 53, 134, "Output",
 Evaluatable->False,
 CellID->59096174]
}, Open  ]],
Cell[9860, 283, 488, 16, 70, "MathCaption",
 CellID->13538],
Cell[CellGroupData[{
Cell[10373, 303, 229, 8, 28, "Input",
 CellID->23474],
Cell[10605, 313, 227, 7, 36, "Output",
 CellID->796207867]
}, Open  ]],
Cell[10847, 323, 832, 22, 70, "Text",
 CellID->29017],
Cell[11682, 347, 520, 16, 70, "MathCaption",
 CellID->24200],
Cell[CellGroupData[{
Cell[12227, 367, 203, 7, 70, "Input",
 CellID->32579],
Cell[12433, 376, 227, 7, 36, "Output",
 CellID->1493705160]
}, Open  ]],
Cell[12675, 386, 317, 11, 70, "MathCaption",
 CellID->16448],
Cell[CellGroupData[{
Cell[13017, 401, 203, 7, 70, "Input",
 CellID->13047],
Cell[13223, 410, 226, 7, 36, "Output",
 CellID->468437053]
}, Open  ]],
Cell[13464, 420, 274, 9, 70, "MathCaption",
 CellID->29009],
Cell[CellGroupData[{
Cell[13763, 433, 229, 8, 70, "Input",
 CellID->24546],
Cell[13995, 443, 332, 10, 36, "Output",
 CellID->1458776703]
}, Open  ]],
Cell[14342, 456, 87, 1, 70, "MathCaption",
 CellID->25270],
Cell[CellGroupData[{
Cell[14454, 461, 282, 10, 70, "Input",
 CellID->14241],
Cell[14739, 473, 336, 10, 39, "Output",
 CellID->480637581]
}, Open  ]],
Cell[15090, 486, 99, 2, 70, "MathCaption",
 CellID->14293],
Cell[CellGroupData[{
Cell[15214, 492, 475, 17, 70, "Input",
 CellID->7196],
Cell[15692, 511, 318, 10, 36, "Output",
 CellID->127609108]
}, Open  ]],
Cell[16025, 524, 303, 9, 70, "Text",
 CellID->15031],
Cell[16331, 535, 176, 6, 70, "MathCaption",
 CellID->11121],
Cell[CellGroupData[{
Cell[16532, 545, 493, 18, 70, "Input",
 CellID->14972],
Cell[17028, 565, 286, 10, 36, "Output",
 CellID->1227581060]
}, Open  ]],
Cell[17329, 578, 231, 9, 70, "MathCaption",
 CellID->18328],
Cell[CellGroupData[{
Cell[17585, 591, 698, 25, 70, "Input",
 CellID->23288],
Cell[18286, 618, 373, 12, 36, "Output",
 CellID->1127996631]
}, Open  ]],
Cell[CellGroupData[{
Cell[18696, 635, 72, 1, 70, "RelatedTutorialsSection",
 CellID->421426840],
Cell[18771, 638, 198, 5, 70, "RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],
Cell[18996, 647, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

