(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    267294,       6073]
NotebookOptionsPosition[    253356,       5616]
NotebookOutlinePosition[    257507,       5706]
CellTagsIndexPosition[    257412,       5700]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnFunctionsOverview"], 
          "Advanced Numerical Differential Equation Solving in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/NDSolveOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Functions\"\>", 
       2->"\<\"Advanced Numerical Differential Equation Solving in \
Mathematica\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"NDSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Solution of Differential Equations", "Title",
 CellTags->{"S3.9.7", "7.1"},
 CellID->8415],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " discussed in \"",
 ButtonBox["Numerical Differential Equations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalDifferentialEquations"],
 "\" allows you to find numerical solutions to differential equations. ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " handles both single differential equations, and sets of simultaneous \
differential equations. It can handle a wide range of ",
 StyleBox["ordinary differential equations",
  FontSlant->"Italic"],
 " as well as some ",
 StyleBox["partial differential equations",
  FontSlant->"Italic"],
 ". In a system of ordinary differential equations there can be any number of \
unknown functions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "i"], TraditionalForm]], "InlineMath"],
 ", but all of these functions must depend on a single \
\[OpenCurlyDoubleQuote]independent variable\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", which is the same for each function. Partial differential equations \
involve two or more independent variables. ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " can also handle ",
 StyleBox["differential\[Hyphen]algebraic equations",
  FontSlant->"Italic"],
 " that mix differential equations with algebraic ones. "
}], "Text",
 CellID->1399],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", "{", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["y", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find a numerical solution for the function ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " with ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find numerical solutions for several functions ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["y", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23755],

Cell["\<\
Finding numerical solutions to ordinary differential equations. \
\>", "Caption",
 CellID->6184],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " represents solutions for the functions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "i"], TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects. The",
 " ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects provide approximations to the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "i"], TraditionalForm]], "InlineMath"],
 " over the range of values ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 " for the independent variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->28658],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " finds solutions iteratively. It starts at a particular value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", then takes a sequence of steps, trying eventually to cover the whole \
range ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->8484],

Cell[TextData[{
 "In order to get started, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " has to be given appropriate initial or boundary conditions for the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "i"], TraditionalForm]], "InlineMath"],
 " and their derivatives. These conditions specify values for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "i"], "[", "x", "]"}], TraditionalForm]], 
  "InlineMath"],
 ", and perhaps derivatives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["y", "i"], "'"}], "[", "x", "]"}], TraditionalForm]], 
  "InlineMath"],
 ", at particular points ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". In general, at least for ordinary differential equations, the conditions \
you give can be at any ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ": ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " will automatically cover the range ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->8525],

Cell[TextData[{
 "This finds a solution for ",
 Cell[BoxData["y"], "InlineFormula"],
 " with ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the range ",
 Cell[BoxData["0"], "InlineFormula"],
 " to ",
 Cell[BoxData["2"], "InlineFormula"],
 ", using an initial condition for ",
 Cell[BoxData[
  RowBox[{"y", "[", "0", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"y", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19689],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->10371]
}, Open  ]],

Cell[TextData[{
 "This still finds a solution with ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the range ",
 Cell[BoxData["0"], "InlineFormula"],
 " to ",
 Cell[BoxData["2"], "InlineFormula"],
 ", but now the initial condition is for ",
 Cell[BoxData[
  RowBox[{"y", "[", "3", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"y", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "3", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->14385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->944]
}, Open  ]],

Cell["Here is a simple boundary value problem. ", "MathCaption",
 CellID->29920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->14775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->10161]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", the initial or boundary conditions you give must be sufficient to \
determine the solutions for the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "i"], TraditionalForm]], "InlineMath"],
 " completely. When you use ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to find symbolic solutions to differential equations, you can get away \
with specifying fewer initial conditions. The reason is that ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " automatically inserts arbitrary constants ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " to represent degrees of freedom associated with initial conditions that \
you have not specified explicitly. Since ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " must give a numerical solution, it cannot represent these kinds of \
additional degrees of freedom. As a result, you must explicitly give all the \
initial or boundary conditions that are needed to determine the solution. "
}], "Text",
 CellID->22324],

Cell[TextData[{
 "In a typical case, if you have differential equations with up to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " derivatives, then you need to give initial conditions for up to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " derivatives, or give boundary conditions at ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " points. "
}], "Text",
 CellID->3971],

Cell["\<\
With a third\[Hyphen]order equation, you need to give initial conditions for \
up to second derivatives. \
\>", "MathCaption",
 CellID->14466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'''"}], "[", "x", "]"}], "+", 
       RowBox[{"8", " ", 
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"17", " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{"10", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "6"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", 
      RowBox[{"-", "20"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "0", "]"}], "==", "84"}]}], "}"}], ",", "y", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->5235],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->21959]
}, Open  ]],

Cell["This plots the solution obtained.", "MathCaption",
 CellID->17540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->2443],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmFtoXFUUhnfnkkyNbaM16RRFphYx4i2KYBSRgJcGRQ0KEkU0ISoJpTS2
tQSLxnvEW6y3oVKNt5rWl/hQyGMe85jHPOYxj3nM4/itvc6eOWeffTKnpQEH
crIva/373/9aa5898+zYqYk3j42dmhwfqx05MTY1MTl+svbU8RMMFXcZYy7z
N101tBu07N/lRoP/6edhngUMitIriqWMGtvsjc+VdU4/YnEg4CnNQo45GSoE
5qy9uU2epdaMMWWPXU/KosNDuyllUUqNpFHSNgc83GLKopDBOR+jUk4eO8u1
0/PcH14tFoHeq+IscZQ4V3eQqVsjzLCYk/vVa3klOqSZlL11r2XcXa13RP9d
lfqa9sTGHcuQn+tr1cZPlWjIfvwdXYq2kZVd29lccGzb+Ptr+n2/NtvZX2v/
/zufcg6Nb23T9zF7r3B+T5t+Ho5RHnnZKDn7jx2qBO2zR3fC85ztr6+vLy8v
Ly0tmcLMzIwpjYyMDA4O9vf3NzPe9zsrj67V1VX8Zmdn8RoaGsKnu7sbo1qt
RpsRxSsuLCxgh7XiNDl9Ib19cZTh4eEmCuvTnp6eZhxu2GxubpobYmK7j6/8
R/LYu7a2hg/OU1NTAEHKA11cXFTQgxbMvxP494czNhEwx2lubg6Apkh9fX20
GWGcWfQ0h3JhnrY64jI/P6+A1WqV7dOANSORbn2ZaNKdsigbGxvIpCJCiHFQ
RkdHFYVZc28uTkflUWqiEcYCpEyJhoqGsA/mQnpLHtdtbW1pfOFFEMBSJOBZ
5OHMKhmXod1oSfpMTEygdKVS0eBBQjR+LJibr9k+0GjK9k1BIl8kp+v1umj5
eNDrFXlUiK6uhoAQxR0QljqSyNsR6XWCxS4GBgaIl6IjjHkmiP6i9UAJ0AEF
mu3gvbKyYp4PegxbD3YBLsKxddaAjMTxhQSb56TXoZaaQPBHoZeCuE9ba/YJ
FnFQa+LzctB6SB5lSLM424S6nBKvBm2ftLZoAKBKgp953dqWoioVvk84TKRD
ZlhLXY8l6jrWia0waD3ZKcpBnBVEvzdy5aLNlTIxU/lBECVthqa/KUR19ait
BKSEKfFCsclM+3j/EeeHE7GD5NFG+/fFQNILqscya+Mha0vYYKa2x4MxsXVa
YlqPZ5i8HbR7oBHVPOqwPEE+mcix++08+UsZU04o8U4Q5z5rhzuBpU5xOB20
u8etRwyhRoVNB+3utn2WA0+y6d0Eq7scChAQJ43OBFHujKFI/r4XtLrDogEC
J0V7P7GanS8iIQIJlw80F0z6lnm77fMuIDpyTn2YK2sO2z6SsT6Hv/l429y0
d395c7OGsPkkmCtxz0Mx/nIOftrIUzc1px3pI3X6WSYr0UitiTwCshMzm6mR
3tgwI6Ok+XkwJrc4TYgwHPTGkLK62fZhB0eJ75eJuMVn5bz4KohxMGYl6nwd
tKp6Vt8kVtJZ8jFSeC6I0ethfBu06nE7j1ifTazUnKX4Zcff5Yql/RWgqAez
NPN57XcxjSL1vfVyJ7oY3uhyhHBK84coF5sHeSr69hZXhDn8JU9+bJu93bbP
24V8lzz8qa3HPqczHvJmrmfuVhRVfOhwAEuzHozKXrHm3XEuOKvfEgAARpot
K1lhj8sOTiHZwc9BjOttn6BzuEszbNUV8TifWKHLWuGIuzTPB313O13gIe/A
X7ax0guQNMNW2tf7gTR/bcTrXThV3K6pCVltvpF1fsT7nV408nl1ePr/lunV
OpHIPl5owuz3thmlfc5mjnZpJj1aFi0PfcdT5exemn80XA4WYjci9dJDo2Xl
a637YGkISPPPoFXBi+5fiQwpejtozZrOJgYf6gU6UpkXWhYdcQuNzd+t2dZv
tJS1fPdbSKxsl47OxdaMuxFpBl1MjjdDczEYGUVVMWRGUTPuWFGMt/39Jzrf
smzEROdC77Pkt/1QLlxKxP5f20v/Jm52/Qdlzwwx\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->708041973]
}, Open  ]],

Cell["\<\
With a third\[Hyphen]order equation, you can also give boundary conditions at \
three points. \
\>", "MathCaption",
 CellID->19654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'''"}], "[", "x", "]"}], "+", 
       RowBox[{"Sin", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "4"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "7"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "2", "]"}], "==", "0"}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->22497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->7339]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to use any appropriate linear combination of function values \
and derivatives as boundary conditions. "
}], "MathCaption",
 CellID->1709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"y", "[", "x", "]"}]}], "==", 
      RowBox[{"12", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"y", "[", "0", "]"}]}], "-", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}]}], "==", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"y", "[", "1", "]"}]}], "+", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "1", "]"}]}], "==", "9"}]}], "}"}], ",", "y",
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->8057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->4302]
}, Open  ]],

Cell[TextData[{
 "In most cases, all the initial conditions you give must involve the same \
value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", say ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 ". As a result, you can avoid giving both ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 " explicitly. If you specify your range of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", 
     SubscriptBox["x", "1"]}], "}"}], TraditionalForm]], "InlineMath"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically generate a solution over the range ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->2323],

Cell["This generates a solution over the range 0 to 2. ", "MathCaption",
 CellID->32037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"y", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->1338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->3916]
}, Open  ]],

Cell[TextData[{
 "You can give initial conditions as equations of any kind. In some cases, \
these equations may have multiple solutions. In such cases, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " will correspondingly generate multiple solutions. "
}], "Text",
 CellID->23697],

Cell["\<\
The initial conditions in this case lead to multiple solutions. \
\>", "MathCaption",
 CellID->31491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], "-", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "^", "2"}], "==", "4"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->29402],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtu1DAQ9eaybSkSFFWlIFWUD0BCSPQBiSek9okvgJdVhdQ+IFDp/4c4
G28nk4k9djar3fZE2vV1LrZPJuPzfXF/8+v34v72enF+dbf4e3N7/e/88s9d
3ZXPjJn9MMZ8OzV1vaprzc8+P+vfsrqsHdr/wo3axzbKuszMctSWF3WZ1+XH
tvza9s+tdL6SNgVrv2Ttk8B83j4hdqg/ZUAub9b2LNLaIWt/Zu1PrP0lUv9R
6/2pwnvNPO5vyH6m35UOIqwvWVvy2VybPZnSuCNyj5tkV+bKotVatmXRanfj
JStzMl/WnhGtOUFxC4fmsf3LRbiHzqY2qM2+VB65905bUclvzpxY1bxZ4jk8
nFpd2R91rulYkt7PrOcdn8GxzNffaCip96tT2GO97diecAJ9DbJecbWydbk3
KOvRyH2mugYlN+VhEk5ED2hcPxDWrX0LnLxDsUYujEcd/rnfdJYRtPrWdSBg
Ng0lktUJkO+xOBrzStks4McYv8ScIpRz9LTwjOd5QIsdtwjZr3RxeQhRITzP
Gv94/G7W0HkvtPZGxG+mvRzoH3NuxYSYXbW3ELNp0ZljNpRnvqjiom9qjiPn
HBFxzBvxuV4pFg9/f0ux1620oLIdL8Rv8Vrir2zPjdBMXEaXx9/efN13q6PV
s+bNoPaotzYxY54ga2C5ejV4v1Bn68fi7M69p+reahwyiVVByt3HpIyC3tMy
rpXp4H30xDkyZK9sB78x8lsbt5J0OqNxdSaNT3zv4j7x9jFrc/n3gfE34s68
ZrPebs9+R8jLO8yl7I5QBsruqHX9A2nT+Zb5mtfNd6z/VaW/oeTtbtj5obzx
jOiNZ8pslTOD8TVwicOo23UukWYy4BANOETFuYJDVFoHh5iQJ+wmh+juXuAO
hyyCO3RatoU7bL4C4ArXgNFVewsxuttcYRNNwQ0qsQtu0K9lE9wgQSy4QBIf
wQXGxThwf8PjIfnljj5Wrq85yaYBbk+WA7dH9YDbA7enPVdwe0rr4PYS8gBw
ew9y4PbivQW3B24P3J4/Wq3/NgZuz/WC2xvU6lkzuL2q8mfd4PbA7fXw4Ill
4PbA7YVrYYbn8XB9sbzM0+L+knYHXCC4wPD3QLUL4AY1suAGd5kbjLn1GEE7
uEJwhX4t03KFqjWAOwzaAHdI29NyhyHMgksEl5iC2s1xiSKCwS2S+AlucVwM
BNeo3xt5hzX37qfHPZrZfzjMw6w=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{347, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->93960060]
}, Open  ]],

Cell["Here is a plot of all the solutions. ", "MathCaption",
 CellID->28687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->30997],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmX9sXmUVxx/ee9+37dYxhbH5EwhR/iCGGEg0auZM5iTV4Ei0CjbDtAXp
RMY2C5riSI3QYSg6O8DVLq3Zj5KWEUtWK4MamjZbqGla07Rx6RZrF2aH2dLY
MmNlyfw859z36b33fdp1ISYut3f3+fH9nnO+5zzPfe+9d1fW1jz4SGXt1urK
m+/aWbm9Zmv1D2/+yqM76QquMcZ08/fQhwzXl7mSv+7Ll/l/tT0Hti3/zAHX
m6HzNzI6+8/p8T93nX9nwuS8mBftKXfu72OD/fs6WivaW8oH3mgE5J/dZE9F
l96bP/2X3r7XGg7+enPX4ZqRwUMzF6ZMiRfxS0EwPjrU2fNK7f49G3u760+O
9Vx894IpTfjbmOeePNWPD3iCPyfebDrz17fMB7zczwiC2Bz3sa46osV9c70X
8ZQgGMcD9f/IgarIxjovot6eiuf/PadeqURANYSPeDE/EQyRQIusmGjbW6au
IcSNiajrxKOzZ4aHjrce7dhGDESCojZjt3jZa5PsgJob13OGAJpbBVOcwoSp
9vZYVIRPEp1hOG5bFscPhAMtqQWUcVGSDMrpduEwgf5n/9lo0+0sTUtZI1yY
xgEoyAsqUyhauncIKBezb/G5lD/V9lRCUogprgvX9Nh6+4wgiyLl0/j7BY+u
zg18wBMuVBbzhSXx3xG8gnGdSkFTZ9/W5IZl6VouPEhI8KqriwOl7Ur7cqKC
7rGtFeRSTVObpBMIZ+CqYJm3kr4aQ1I9GjFJVGNUOE583YvcJEhgTNLCRShF
0tRwv+FFigYriYLqVZsIpQHiudawzdW9iRg/LyhIFYW8GiNYqlZNWmXu99q8
U9DIoGjs6EojWkWjK6GaB7zoT9nTKq0LDReQZoWzEtDPKHPMVi+HrMpSPNQc
aXkimVaIBo5zuLjdi79JfCB+8KwvlVx9QALNlxap1e7xhHYfFizxafRqW7EI
wDUbgOpu95xdXvuy/14Lt9NARSQErTSVQV2A5im3YsNolcfZZAWsVjakd2y4
AxucThPV1cb0rFt78T1AmK9zzATpBFJKLS6lpGocJVLu9e5QgWd12qYpatmz
pfX56lc7dne/8islsRXXIvCSFEpYsrRHhs8ePjTS1jq0t+mEyTy67Whmw/pm
k91a08X1c40DjDBuMswzwfT0bIRvWpw11pYdKDs+dg70q13jcDXvGxQrJvh2
eTuWrDFtY59xZkW25ubmI5ZnXK5MuMBdmDVbA4p9uXMULryPuL9W1oYhztoO
NS6Ogf5JRczPX4pYdrk8+vZQqdUQ30BpUBloTO6JumMwc2zauF9NqaXHantS
lqamZiKunYlV8Mkk8+BbZ4Q5dMxbKjokNyEX2oNkOucPPScVdWrifI13fXxa
2LGt8xBIkbsb+pSruupIAHtgvc46fdRxk/b8Xq+NdVEk8SqQWyp/a+JjOR1T
V7hGxcAfaxYhtYfjp/W9RuchjoI5fGvC9t3g8SY/tjZaMxnPWOCNbe2S1Wej
vL5gRrp2ZFfJugxz/LH3tEZUTJ1okEzXlcFFPh9WL02GXgALUutxZYH1sKBn
rW+1JmZkEhW57ooRXee1Gkb5lv3FjQjUep2OhrRq1bkdIVqrIb2hrC6rk2xV
Wi+EXej71US3dGaLUjM+6Nc2lvsblqG+7pUu+7KmNDpb18bE0x+igNSi7F5u
NRpZswHLJcYRr4K05/9LDbJRlfhjz6/5RVRhu9VUagR6b1iIkIgjOdL3CrtH
mRybrNsVILEVZHFZlIibW3a0hdkqXM2Lx5u+DxViC/ll5eRUBlfXdl1fRRz5
/TYX8yzjyd2aWH8mthfncWtT7YUd0LYOem0fuOpe+yx9eNH9Na3hldrpZ5Kr
xb/f9v+l/QJVP5Zqf/x9jvutXKkWFq8i+24ne3b4FL+/5v4Vj8z/liM4N/Y3
ZltARlCne4eHWl/jMAGn7NFtL5hg/8bHmtfv4DABJ+1j8pLsj0j70vx7cfbs
aGefsnP01h8woXB11eyJ+DNihDb9digj48yM+yR+whxZWp1QxT4NBmLrZM9g
wlYgXB0VuxO2iC1uK3uiqcuh0MKEYg2VImuf8EZ7NyeZGY4c6lXwsbpWtXik
qjFmUfqyfQ0vJayIx8HM1DsR32e9VjaI3LPTF1TTyf7RjBUlO7ivW2PgwJpk
SZQNGVEjzFUb5yfejtju8tq4Yxk20EzVC9vLf6ZdRKvziF+RHNha5HetPBuH
Fy/M6kRSJeiQPCnfwc1PLscCVWAeTORf1leO2tcJ413HAeG8ZDd0lWb5pcdl
gjToCsCryEv/c7nct62O+cq2XuUGGl924sDfVlantUs/4/gcra+FSpI3hnIH
CVO/f+yl3HGKXRxaVioPKdba5SJfu6IewTpZ9Akv/t7J5K3YX4vqvi72vDoB
Tqvr0VrQ6mFSlEt9evY9ocrTcrBl7/frW55uaPu5ybzR93p8B5L30mZFCpnJ
ezM3/+7w2XGOQyO/ax3qzPBgklnf/C1TVNP1BNf7Btvp7Z/8EzOmZ/9hnl+c
La1g6di5Ccdbd+xZ2MrbH4a76sjjjjnDjOdcNhb/Xep2m3Di/GTCW1MM5cb9
FVzW9jTQ2Tn6e3X2aZeH/LvPgt9N185f+g+TeQAD2HTitykf42xPJmr9Jtta
pb6koBUdO7imR6EIbH7krWZ5Ri6dmnmbWcxVjrK2Sjjk8XAPxL2njzO6w4uX
N2UrGWYSUwEAA4wb6nvPyTcZNQ8vvtuUEphG0ND3YhxNdrrGX2cIgR5IRP45
sao4stA40MJ09N988HuKwyqZN9/1Wv2ioC9cnFE0Vqkz1VsDpp9Rc58XLW9i
V6C6Row9rKKYM8zQN71IeSO7Qotd7WIRu1jnWjO12YuU3hIigl5TpO46mL7X
dfro+2Qc8c63ymxadC3H2/cleVQmLSyip2rMl5bFo+/ZtcSQmOpEMF0pmt7Y
e3bfblgleJTTRaLJJh4ST4XgX3TH9L0rtM2HbLuYecwGAxI89skC9u9cco1K
5ZbgI7ZJsGqJEmjAlmTr5PYl8frdBc2JnR2IYiF8nEBAwLctSz/9/oPe+I9+
KY5bvTXz4yUxC9+ZrM+7CuYikQZI4Dd6+eX3YxGaalwIiigIarPxUS9Cv8Sh
BDLCjxVsUVl2T/d/idstCNzFaWqXbYEY8MtW/JpEBPolkQjwRncw5bb58X9J
/IUgqCnl1pjxzK6OVV5EUz5ioiRWtQHa7q7+L6EvxGwwV3cJPLQVn0v4r19u
iYvorAf+b7FLPReYa/4LHDIn/w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->37435673]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " to solve systems of coupled differential equations. "
}], "Text",
 CellID->567],

Cell["\<\
This finds a numerical solution to a pair of coupled equations. \
\>", "MathCaption",
 CellID->25949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"y", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "^", "2"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"x", "[", "t", "]"}]}], "-", 
        RowBox[{"y", "[", "t", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "==", 
       RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->12926],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{316, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->570461192]
}, Open  ]],

Cell[TextData[{
 "This plots the solution for ",
 Cell[BoxData["y"], "InlineFormula"],
 " from these equations. "
}], "MathCaption",
 CellID->21591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->12848],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->36022582]
}, Open  ]],

Cell[TextData[{
 "This generates a parametric plot using both ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "sol"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->6744],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1001430587]
}, Open  ]],

Cell[TextData[{
 "Unknown functions in differential equations do not necessarily have to be \
represented by single symbols. If you have a large number of unknown \
functions, you will often find it more convenient, for example, to give the \
functions names like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "i", "]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->5512],

Cell["\<\
This constructs a set of five coupled differential equations and initial \
conditions. \
\>", "MathCaption",
 CellID->24098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "i", "]"}], "'"}], "[", "x", "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"i", "-", "1"}], "]"}], "[", "x", "]"}], "-", 
        RowBox[{
         RowBox[{"y", "[", "i", "]"}], "[", "x", "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "1", "]"}], "'"}], "[", "x", "]"}], "==", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{"y", "[", "1", "]"}], "[", "x", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "5", "]"}], "'"}], "[", "x", "]"}], "==", 
       RowBox[{
        RowBox[{"y", "[", "4", "]"}], "[", "x", "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "1", "]"}], "[", "0", "]"}], "==", "1"}]}], "}"}], 
    ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "i", "]"}], "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "5"}], "}"}]}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[13]:=",
 CellID->4772],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW9tu1DAQdZO9tYVe6IWqpagPXF/5CHji8oJ4Q1pVSO0DApV+A1/FN8Bn
8Blp4iRdd9b2zNjjNI260u5mHHtuHtuTObvv55dn377PL89P5yfvLuY/z85P
f528/XFRNuUrSq38VUq9OVDldVFe6Xf1+le+68v6alZ+jsqb4/I7K7/Xm+8J
oI+r3nnLpVDTgY97rb2zBlpHgF5n3j9qpN3zTcP3CaBfFZRZzMqPcUnCdkjn
5UfexJLZvuMYP0ssd9fRjsl18Ustd9yMywdi7yK6MgJ3jM60i65pzXs5Nlof
1jfa16qFd9a023SjyZLUcOocOwQ9JzYNojWcWDWc9M6TXD2X15AZv6qztbQH
6A1EC7hvYVrStNix9sJ0SRNxYbpUvCcK39eH4g8o+2VxHcOjRSu+uro8ETZ6
pZ19l8V1TDPLsjr2Zae9LW/GnwazIA+mORMekkZhJ4Xk7kPTqM0HUp5RNE20
L1g7Tzc6UZ4IYjSxx/a0sK0OLF7SxPYDki5dnqx3VSOTl2s1dqtRl7mqPdK3
EYlpYno/iIukN/qnQZfRCWX3Iw4ztXhCbivBE6M9N+7vN98Hjvu+cRX9OHJc
2y8PkDdijIPeqive1SXECPhXLlRhFdB7jn6wOr9N7Aejy1X9h3ocC/NfK8Ls
tOaR7Cr5FLkP90yMH3Yf2+m5/NoIlrYbYjy3pSesV6een1bPOmHAtHVV6bV3
F3l8wzMzeTNs8GbgZClY5HkRB7IUSIfiOjwPYtHqRY+S2eaatxlLKhYdaeZN
5xZOvAZ7qoC7S3ZTFwfH5Ux95pAfkSd6tWjzH5GKqVdSm2G4MAjMFikPbwXK
l7eYNqdwzeFy3TXfbme6zk8w9MaFD8D5NjNXs30X4c+1zyWn4jsG7Rx7qHIw
LIO7TlxybL9LCJEnZRc2T3AdhMZD7PzoeCbgObTVTZ0t+14GcgYLf6no3xKy
lxUtUYhUnGc3o+XLWSq1MuznAsjNks9svX5oKA6ODvCzAlp1yKwHxZ2Gm0KW
8iXTsSDZvOtIRG4qe73PKAkiKcXM1muIjxbZ9OM9dz4iySSdOmSZGyJ28mTy
kR0bzfPtoYjMFHZidXre8z0thmTns14xvoqQTQaMW0hjvzAOOzkh14MQz3j4
+RAgG831wjMmf66+WDRC/WB/bNZi/buINRtiY/OuWeV/avTL1TJC1PY7dPCH
/UykykS4MD1eOMb5+I88duaF3U5Mf+1d9Rxw+wPo34D+qkdVl6Eo1fL+cpcw
q9R6fNQ+4p5N91jUsOz+VIREgQwCgvlIBgHBPNcvnOUuelAG64P0h8IVmeGV
+NQYj/wTsQvdSYUmtf6NQzyGhqWl9nZ9Fvsqu8oyGsuipfAXblTH4i/c35Sl
wiuk/CdlD9V/UojBZ83fWkm4xbo+jphIxSuOmEhJikcQhuPTtNFL/8eQbwWn
xCxk8wcadhH0/xYh5ML1jJzCv/J20vzrspMvz4jqG5n18prmVvRToAikeBZG
EWSRC5l/rAwFoZGVad+hYaWCtmPH1vljK9ywwi+DG4T916SfmIcM1zpmYK/2
N59Ve64WFW+sQm5W6n0V8kMHf18lPVQPH3+qHl+0l7CK+3/dq7p019DVyhVL
YY2F\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{462, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->17683107]
}, Open  ]],

Cell["This solves the equations. ", "MathCaption",
 CellID->22771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"y", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->5409],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmttu1DAQhr05bLssomyFSkFClAdAQkhwgcQtXJUrXmBVIbUXCFT6/iGO
MxtnMvFMkj0lnZWK49N4bP/x4SPX64fbX7/XD3c366vv9+u/t3c3/66+/bnP
k+KZMbNrY8zPS5M/Z/lT8Wd/P/I/9+iezvJ/kzwzzcMoD5dl+DkP4zz8UIZf
y/S5rRWDtcwkKP4cxd8w5XH8omwnZcrFhfcrptQSxT+h+EcU/9LR21Xp7VuB
t7bcZUf7kaiXcTlHeMyeoLjNTw0UhB8UAis2tIqIytJRGU+8/BSFsVeeth55
VsFXOyLlRBY/m+46Bz+/tN+G32azVtxxlMFaktEan6NW28px7RTzkVRxY057
64F6R4rcdBMvh4R7J3AvaCvFmJ6g1DLvhBjPpgWZd4HW6VS2bsAi9tm31Vpz
Xx5yWpCPHGjVhovOtTgfwGo04M1wuvb3DkPom1Qqsrog9NhPAbj1Hak60OJg
PQvr4nHEfgzxi9y3uX29YeVC5MFTxrbNt+o8zSq1hvqJ82fZRqW1VRyX43Q6
YAVGI5W2pA+ZnWSHymxfKQ+vzH7rq0yZeMaxbXsKH75+non6KT0tUqto+66Y
kqmwjyR+3dq7Q+6QW1k56fYgxz/t0ooJ+NsoL9txalaZfexQSlw1etzvjPos
k5zMuXl8UfcmI+4MWf1sDorz2iVqwV2G2uP9O06ErSIbOM2fSTzjtFc2Ad+2
8I0Ht8LtU/vUS9f7vVMHvgeLdBBYq94x+a/Ivr1EpV5PYlx9VYFu7fhZF957
cb+2PdPMTZNjnGey/QhU69ObWNhLOe2xj5hfdX8aC/EqNDx6wgXpS1FvQDd4
PVCSJZut4yVZi838U1rf4Y1JmVXYnjKrQD2b7tZhjk1Zn+Ytb6wyqe7eKpNy
+YXuBMxp5+wfjYeSp+3p75jJk9OfnCyFVaqMqbKvjKnqMT49OtXJGJJvnVKl
MqSxMSQ3+6FvJVrnObDWTJ8RVePmn57HwoDOC+9tkjKeenxajEe/VnqcjGfn
NxQlPWF7SnoC9eSkR79C6qjbI7xxT4H46FdGbX63r3iHV95UWA/Y0K+I4JSp
hKeKb5fwcCudEp5pEB7ZCqqcp855QKWgNOU8ynno+H45D6xV3P8BKedpnwX/
vVbOo5xHZE85T6CenPNwtwPlPP28Vc7j8qWch4sr5zlG5U2F83CrovKeyr7y
nqrHynuqNOU9ynu2M3qPnfeQs1JbCcZDg7rygHHToqG9VZo0bZok6Q/1Lu3w
dqScKWxPOVOgXsWZupzTTQ+FK4fq561yKJfvTpciD5VTKafaO6filLmdfirH
quwrx6p6THMsUpO1e+jwE7tSrnFSLm6eOavKv+hxlazg/moLt+9p8TEz+w/9
/HPZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{333, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->539117062]
}, Open  ]],

Cell["Here is a plot of the solutions. ", "MathCaption",
 CellID->21448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "i", "]"}], "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->5745],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->108275004]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " can handle functions whose values are lists or arrays. If you give initial \
conditions like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["y", "TI"], "[", "0", "]"}], "==", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " will assume that ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " is a function whose values are lists of length ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->14512],

Cell["\<\
This solves a system of four coupled differential equations. \
\>", "MathCaption",
 CellID->23916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "==", 
      RowBox[{"-", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "]"}], ".", 
        RowBox[{"y", "[", "x", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", 
      RowBox[{"Table", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", "4", "}"}]}], "]"}]}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->13855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "8.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->540273562]
}, Open  ]],

Cell["Here are the solutions. ", "MathCaption",
 CellID->6762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", 
      RowBox[{"First", "[", "%", "]"}]}]}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"s", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"s", "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", 
       RowBox[{"s", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "8"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->20157],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->100814069]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["MaxSteps",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxSteps"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "maximum number of steps in ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " to take"
    }], "TableText"]},
   {
    ButtonBox["StartingStepSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StartingStepSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "starting size of step in ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " to use"
    }], "TableText"]},
   {
    ButtonBox["MaxStepSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxStepSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "maximum size of step in ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " to use"
    }], "TableText"]},
   {
    ButtonBox["NormFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NormFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the norm to use for error estimation", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->19418],

Cell[TextData[{
 "Special options for ",
 StyleBox["NDSolve", "MR"],
 ". "
}], "Caption",
 CellID->9164],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " has many methods for solving equations, but essentially all of them at \
some level work by taking a sequence of steps in the independent variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", and using an adaptive procedure to determine the size of these steps. In \
general, if the solution appears to be varying rapidly in a particular \
region, then ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " will reduce the step size or change the method so as to be able to track \
the solution better. "
}], "Text",
 CellID->6704],

Cell["\<\
This solves a differential equation in which the derivative has a \
discontinuity. \
\>", "MathCaption",
 CellID->13318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"x", "<", "0"}], ",", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}]}], ",", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}]}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"-", "5"}], "]"}], "==", "5"}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->18545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5.`"}], ",", "5.`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->171825674]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " reduced the step size around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 " so as to reproduce the kink accurately. "
}], "MathCaption",
 CellID->5695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->11154],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->158368893]
}, Open  ]],

Cell[TextData[{
 "Through its adaptive procedure, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is able to solve \[OpenCurlyDoubleQuote]stiff\[CloseCurlyDoubleQuote] \
differential equations in which there are several components which vary with \
",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " at very different rates. "
}], "Text",
 CellID->18254],

Cell[TextData[{
 "In these equations, ",
 Cell[BoxData["y"], "InlineFormula"],
 " varies much more rapidly than ",
 Cell[BoxData["z"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
       RowBox[{
        RowBox[{"-", "40"}], " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"z", "'"}], "[", "x", "]"}], "==", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"z", "[", "x", "]"}]}], "/", "10"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", 
       RowBox[{"z", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->16800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"z", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->154412798]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " nevertheless tracks both components successfully. "
}], "MathCaption",
 CellID->7561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"z", "[", "x", "]"}]}], "}"}], "/.", "sol"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->23932],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WM1rVUcUH+9HilpLqRq7aKnLduVfIEWkLSIiCtKFuEhDIVlU2zTZpFCU
FnXRbqq2eRpfEqOCbRcWQ1rhFYpCMSAJtZWWKkgESYUGIcHCQyH+zpy59849
M/M+Gn3Mmzf3zPma3zlnZu7b0dXf8/4HXf293V0b3+nr+rCnt/vjjW8f6AMp
XqGUmsB34GWF8RJG+juxtIRft38DfQSGmJ5i4iSq0sP19lzKc/xRcjbOZ1XU
ZK4TAyJFnjnNr16nPilmlEqFd+scjg6h7SWHI3Eoa1vg6RR6Y4cjCvgsPfJb
S1r049n6+lxr6DWMQCs+UxwpzhueoaeZDb+HcYu+/38sXV2uvbCPqbD7NOOe
1XqH+e00vxLTtRY989Inlz1z1fJ+8qLQNbZsKkd4dvbBzPQ9tJ9rtz8fqV5X
8a2//zUcGhG1Bv14ho+jZTV1HYuL9WNf/bpr5/iRw79AEVSsFnwSf/m8Rjyv
a8L/Spv6n/fNO6tZpZcN97vf+/67b2/U64+PeflW6meg1ttzcW5uQZ3IuShu
PAtkMQtk1NdeHZwdMLFv7wXS8U0DLoALd2jo5+I9cX7+4bt7zkOjGmrAVegq
uLKs0/4gjOR1xauDcf1x8i9EmoaNuA7svwSIwly898HW9m0jNDzZgKuwWHBF
eV0fOlhD2jXTAXAAdMFlCkx/fOd0IrQwD1RAEQ1PMW/DE9Wvo1iNT4c84Ugm
zn388ourP1y8GZKVe468DbAOJObNP/5Zno63tg4jWUI63N1UIsFaudZoOOzE
JNsHZS2zJAKOsBeSWUawd5WhqXNnZ8qzro5PBi9fvXKnGRcKFMXcjOvNzRXz
bHF15Fz4cOZUS96yLMoExULD0wFZhByBrwZmebWhWa6O0CxXqc8rbATYUoRX
xX0V0UcOqBEnbv57bVqmMhiZdNP8tyQZLK9kdvPLbiR2llQD/Ha1Ch+xT2K3
9FrKbhpCggPRjgQHx4OirEKBAofNyGVx00yoJ1SVNWNJcUjtucJHJPCoQwc3
ZFw6CgJlMSqsF3nsWuBIuJo4s106LiNoLh0bJ7ZPaZmpfssD/ZNT1+6OOgj7
3qJSS44hHg3lTZDC50zrcpypXGpLjTI1mLsInbnl+bXnO6ipWR+v3GVz/aZS
x7wZGtme8GZu3Tc5NpwSIjbEz8egvJ/6qaYWBZWTxLHIFxyPRU4TqYUTRFJN
hUndfBR4dHPYpRbcbeg25aIXzD6i8WESjGkgE9qWIqFQLpT8MTeeNv0xJ3ub
UmYHcRFz7gMlzixCZ5yIl3kaUJFKrVDJylE9+7j+6N70LTQVURfPnK1dr/6E
piLq0trBM5f2n+B2Ye8RlVQ2f6RisJpVi3cqs4MN6OeH8wuW7lTruzxYLemL
tb7hrQNMUhF18dTQRMmL27Vp1oT2YPY+v7M5Vrv1c33xP2OV3Ey0/GR/Jbd6
fs9nxur4zk8tq+zfnSs3SpZeLVsyd63dnvUlXrzY0si2QWMpRsecd6/9mVta
mJtXm0rR2RJci40gVuBdS+JFbUt5LebNZpOwxHkAHEoRsBEkq1FwXTaCQIix
yl6+zcf3D18q/HoNXaJ9wTosXxIyl8AyPEDDQFNi4FLy2MaX/NDZ4X8T8Fex
edN6gboUEcq1YYUqJhtxHgtGHe6wL8gC22O9CiBsbPS14wndfH6v/VZYTjIM
UlQNY4Cms1pTcxzQND/kDrdhkc9yqGJFeqW8AuwVhvN4u1gaytiy5Fp5s2JO
999steIJ4BUwyw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->85330767]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " follows the general procedure of reducing step size until it tracks \
solutions accurately. There is a problem, however, when the true solution has \
a singularity. In this case, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " might go on reducing the step size forever, and never terminate. To avoid \
this problem, the option ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " specifies the maximum number of steps that ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " will ever take in attempting to find a solution. For ordinary differential \
equations the default setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxSteps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxSteps"], "->", "10000"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7546],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " stops after taking 10000 steps. "
}], "MathCaption",
 CellID->21260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{
       RowBox[{"-", "1"}], "/", 
       RowBox[{"x", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"-", "1"}], "]"}], "==", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->28943],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxst\"\>"}], ":", 
  " ", "\<\"Maximum number of \\!\\(10000\\) steps reached at the point \
\\!\\(x\\) == \\!\\(-1.0041321646111756`*^-172\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/mxst\\\", ButtonNote -> \
\\\"NDSolve::mxst\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[22]:=",
 CellID->700840964],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", 
           RowBox[{"-", "1.0041321646111756`*^-172"}]}], "}"}], "}"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{447, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->77888502]
}, Open  ]],

Cell[TextData[{
 "There is in fact a singularity in the solution at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->22712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->13906],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmVtoHUUYx6fZPY1NahNtbCNqjIo+iaIiItqKeEOqSEHpQxCMUUyQ2tCk
iNZbFVMvrdZeNLGXPGgFax8qlopQQSyIBbEgFkQFqSD1wSJYfAgI62/m2zlz
dnZ2zmkCYkn2zM785//9v8t8uye9d3B8+NHVg+MjQ4P9d60dHB0eGRrrv3PN
WqaSeUqpg/yO9SrGGSPzezDL+Cxf27kmANr0nR5k5p9qY7iUgf5MAmtLImuF
fbX6mrEX3qnn9bDfjM/yOA0ydfdKnVeaSUszPS1gyjzzPduLS4iap1s0i0j5
F4pL2YcuPlIb+SY6LVaMNyxEsGHeNMrme3/xrPNRy7PcSqYqMA0xLiPaPU19
s1baauUkee226ud/q7Dm8c4tI1LT7fmO+fnnUu/enuT2wH2jlh5v3/neupTh
tF499u1vnXms3axKtm396qN93+lhR+Velax/+rMjX/7SDPXgwIcnTvxZjdLq
99UPdBAzh3v/hM2V739hP6+dkyf/WvXAB2krO0pxvci77zvD9S5zT/mseeIT
PewMWt1jZj899MPGiS+aoaYmj+59/1gz1IYXDn9++GeLslVuV0eGDxz//vdm
HCvunj59eqYatdvMAgGohwsjqJ9+/GPo4f0W5c7Rbs/zGIfzPIZypy2Gcqct
jNplZmdm/rnjNjM8uxBFM5XWfcrcu0pboOc1MjpPy8/B0rtOkGcqs09JaT31
7VVP7Aol68YPHf3619aVuJzt8qpjtp7sNLOnTv298r73zHBOPCSd1FuUfdep
zofscjW1qJDhnV6MFkU4XCTCqHfNLOVG0WX1nhBGufqIoYAAtCinWlZpdrS8
ao4pMytdUQ+7IyinJ4ZyeroLlSKrHBKOSjXHpFcHHdG8CfrjA8c3bzqihwtK
VROu+klPqa6O6vdR58Okl+O4unfMrOv3HS2qk32uGs9sn8u47fZhdW976hYX
qkdWCSvBtatVHKSKhFWjdniWeiIol5Oegp7tZpUeTPC5yhtiiWO7Vw8xlKvE
MGqbmeXIc/D1cEkE5Z4z9v1SVG/Niqe9O5oRQbv3yK4W8/5Wlp8ZUq9jo+sl
8q2tYr+z2x3c507BFoN3T/FzGldL7Fu8CJ3rocKa3jSzro/bagij37DVgSKi
rS4oZEGvtk3v+ebC4N7NNkfs1dGLody7Uhi1Kbfkv/nJ6uteRfUVVL5mVjm6
GCGX8r22xPGq9ZSzhBT5FlSBcu99YdQrWfGMX1LI8sbcl8uCeycqPPX/piDo
l7P8bLPDet5810vWV2qApqB6M1fXaWUtvNgQR+qnEEeVe+e83GBzApqKNjGo
PqHP62uKIpozSSRNl0bxz5lZ8kRt0czV5S35/YyxwiMGK8iiNK8saF5vdpFa
uopmvSrI8pRhwTYUVAJarw7injQ44kWUpb6vCeLWGRwxgoxGQ2ivyxrrd8ys
M01gcBd51wd5Rs0QOXQbeLBK9NUNQexqfZ1PvGEDyIOGLoXUG4Pox80QBRQa
jwl06vzfHMQ+pq/twixwKTLdAZYX/HrEIPGbUHPo+A4AMUjyo24Ncj9kd+Ah
rHATD3LJE1Ati9bugL4uQANQzBFJ2YzXuOJbVJU8qwwPJCjAOxiQjXhEEGzN
s7xCR1KotJX62kHARY9Q3bJsCiokEQScvMdjCL+Xr9DXTooL+zQBQkitwUQF
iC4hE4tN2W7X14XgxUW2Q0J1QAgtYcMEicXc/aYqmz8DbzKzVCWMuh51b1Md
MEFMDiDGc3GbQAACOpC5s+/q5VpDimlANFZ4kKfa2KtqIpErd3CLFd19wOqs
jAS1XWF8oA2AkkTIPoIIjyZOYFU1XOeGfs6q7gv6L1XGp5xtNMjea4aS47oB
lcCRaOpUNPNDtzFepPjDqoRY23g2yCt/PRHVljFtiIL8kH+VFFm1ZU/5RMSC
JF/H2Fjwdu4o5GZ/kEf+l0HN+xdgkaRn\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->94949504]
}, Open  ]],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " should be sufficient for most equations with smooth solutions. When \
solutions have a complicated structure, however, you may occasionally have to \
choose larger settings for ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 ". With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxSteps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxSteps"], "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " there is no upper limit on the number of steps used. "
}], "Text",
 CellID->28039],

Cell[TextData[{
 "To take the solution to the Lorenz equations this far, you need to remove \
the default bound on ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "-", 
         RowBox[{"y", "[", "t", "]"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"x", "[", "t", "]"}]}], " ", 
        RowBox[{"z", "[", "t", "]"}]}], "+", 
       RowBox[{"26.5", " ", 
        RowBox[{"x", "[", "t", "]"}]}], "-", 
       RowBox[{"y", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], " ", 
        RowBox[{"y", "[", "t", "]"}]}], "-", 
       RowBox[{"z", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "==", 
      RowBox[{"z", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "200"}], "}"}], ",", 
   RowBox[{"MaxSteps", "->", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->30730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "200.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "200.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"z", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "200.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{323, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->232956]
}, Open  ]],

Cell["\<\
Here is a parametric plot of the solution in three dimensions. \
\>", "MathCaption",
 CellID->12337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}], ",", 
       RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "200"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "10000"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->9721],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{146, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->4669918]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " solves a particular set of differential equations, it always tries to \
choose a step size appropriate for those equations. In some cases, the very \
first step that ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " makes may be too large, and it may miss an important feature in the \
solution. To avoid this problem, you can explicitly set the option ",
 Cell[BoxData[
  ButtonBox["StartingStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartingStepSize"]], "InlineFormula"],
 " to specify the size to use for the first step. "
}], "Text",
 CellID->19274],

Cell[TextData[{
 "The equations you give to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " do not necessarily all have to involve derivatives; they can also just be \
algebraic. You can use ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " to solve many such ",
 StyleBox["differential\[Hyphen]algebraic equations",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->3257],

Cell["\<\
This solves a system of differential\[Hyphen]algebraic equations. \
\>", "MathCaption",
 CellID->30465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], "^", "2"}], "+", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], " ", 
        RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], "^", "2"}]}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->8643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "5.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "5.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->883301985]
}, Open  ]],

Cell["Here is the solution. ", "MathCaption",
 CellID->10450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->17621],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->310943102]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", "{", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["u", "TI"], ",", "{", 
     StyleBox["t", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "solve a system of partial differential equations for ",
     Cell[BoxData[
      FormBox["u", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NDSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NDSolve"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["max", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "solve a system of partial differential equations for several functions \
",
     Cell[BoxData[
      FormBox[
       SubscriptBox["u", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->14956],

Cell["\<\
Finding numerical solutions to partial differential equations. \
\>", "Caption",
 CellID->1134],

Cell["\<\
This finds a numerical solution to the wave equation. The result is a two\
\[Hyphen]dimensional interpolating function. \
\>", "MathCaption",
 CellID->17274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t", ",", "t"}], "]"}], "==", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"0", ",", "x"}], "]"}], "==", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "[", 
       RowBox[{"0", ",", "x"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", 
        RowBox[{"-", "6"}]}], "]"}], "==", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "6"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->9747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "6.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"...\"\>", ",", 
           RowBox[{"-", "6.`"}], ",", "6.`", ",", "\<\"...\"\>"}], "}"}]}], 
        "}"}], ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->309174521]
}, Open  ]],

Cell["This generates a plot of the result. ", "MathCaption",
 CellID->861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x"}], "]"}], "/.", 
     RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[30]:= ",
 CellID->13463],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]= ",
 CellID->33672717]
}, Open  ]],

Cell["\<\
This finds a numerical solution to a nonlinear wave equation. \
\>", "MathCaption",
 CellID->24814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], "^", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", 
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}]}]}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"0", ",", "x"}], "]"}], "==", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "[", 
       RowBox[{"0", ",", "x"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", 
        RowBox[{"-", "10"}]}], "]"}], "==", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "10"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"...\"\>", ",", 
           RowBox[{"-", "10.`"}], ",", "10.`", ",", "\<\"...\"\>"}], "}"}]}], 
        "}"}], ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143498832]
}, Open  ]],

Cell["Here is a 3D plot of the result. ", "MathCaption",
 CellID->24017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x"}], "]"}], "/.", 
     RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->419173266],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41757677]
}, Open  ]],

Cell["\<\
This is a higher\[Hyphen]resolution density plot of the solution. \
\>", "MathCaption",
 CellID->21270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{
       RowBox[{"10", "-", "t"}], ",", "x"}], "]"}], "/.", 
     RowBox[{"First", "[", "%%", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "200"}], ",", 
   RowBox[{"Mesh", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[33]:= ",
 CellID->27894],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->218134034]
}, Open  ]],

Cell["Here is a version of the equation in 2+1 dimensions. ", "MathCaption",
 CellID->19292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t", ",", "t"}], "]"}], "==",
    
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x", ",", "x"}], "]"}], 
    "+", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y", ",", "y"}], "]"}],
      "/", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "^", "2"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}]}]}]}]}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->29984],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["u", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "x", ",", "y"}], "]"}], "2"]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["u", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]], "Output",
 ImageSize->{575, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->95896271]
}, Open  ]],

Cell["This solves the equation. ", "MathCaption",
 CellID->3461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eqn", ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"0", ",", "x", ",", "y"}], "]"}], "==", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", 
        RowBox[{"-", "5"}], ",", "y"}], "]"}], "==", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "5", ",", "y"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x", ",", 
        RowBox[{"-", "5"}]}], "]"}], "==", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x", ",", "5"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "u", "]"}], "[", 
       RowBox[{"0", ",", "x", ",", "y"}], "]"}], "==", "0"}]}], "}"}], ",", 
   "u", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->12102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"...\"\>", ",", 
           RowBox[{"-", "5.`"}], ",", "5.`", ",", "\<\"...\"\>"}], "}"}], ",",
          
         RowBox[{"{", 
          RowBox[{"\<\"...\"\>", ",", 
           RowBox[{"-", "5.`"}], ",", "5.`", ",", "\<\"...\"\>"}], "}"}]}], 
        "}"}], ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{582, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->253838765]
}, Open  ]],

Cell["This generates a list of plots of the solution. ", "MathCaption",
 CellID->16109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "x", ",", "y"}], "]"}], "/.", 
       RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", "All"}], ",", 
     RowBox[{"PlotPoints", "->", "100"}], ",", 
     RowBox[{"Mesh", "->", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->20231971],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 308},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->580762293]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->272107340],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772],

Cell[TextData[{
 ButtonBox["Advanced Numerical Differential Equation Solving in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->1373056497]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Solution of Differential Equations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalRootFinding"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalOptimization"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 24.5269068}", "context" -> "", 
    "keywords" -> {
     "adaptive procedure", "boundary conditions", "BVP", "chaotic attractor", 
      "DAE", "differential-algebraic equations", "differential equations", 
      "equations", "initial conditions", "InterpolatingFunction", 
      "Lorenz equations", "MaxSteps", "MaxStepSize", "NDSolve", 
      "nonlinear PDE", "NormFunction", "numerical differential equations", 
      "numerical solution of differential equations", "ODE", 
      "ordinary differential equations", "ParametricPlot3D", 
      "partial differential equations", "PDE", "RungeKutta methods", 
      "singularities", "solving differential equations", "StartingStepSize", 
      "stiff differential equations", "strange attractors", "Wave equation"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "The function NDSolve discussed in \"Numerical Differential Equations\" \
allows you to find numerical solutions to differential equations. NDSolve \
handles both single differential equations, and sets of simultaneous \
differential equations. It can handle a wide range of ordinary differential \
equations as well as some partial differential equations. In a system of \
ordinary differential equations there can be any number of unknown functions \
y_i, but all of these functions must depend on a single 'independent \
variable' x, which is the same for each function. Partial differential \
equations involve two or more independent variables. NDSolve can also handle \
differential-algebraic equations that mix differential equations with \
algebraic ones. Finding numerical solutions to ordinary differential \
equations. NDSolve represents solutions for the functions y_i as \
InterpolatingFunction objects. The InterpolatingFunction objects provide \
approximations to the y_i over the range of values x_min to x_max for the \
independent variable x. ", "synonyms" -> {"3.9.7"}, "title" -> 
    "Numerical Solution of Differential Equations", "type" -> "Tutorial", 
    "uri" -> "tutorial/NumericalSolutionOfDifferentialEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.7"->{
  Cell[2081, 62, 106, 2, 70, "Title",
   CellTags->{"S3.9.7", "7.1"},
   CellID->8415]},
 "7.1"->{
  Cell[2081, 62, 106, 2, 70, "Title",
   CellTags->{"S3.9.7", "7.1"},
   CellID->8415]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.7", 257201, 5689},
 {"7.1", 257300, 5693}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1456, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2081, 62, 106, 2, 70, "Title",
 CellTags->{"S3.9.7", "7.1"},
 CellID->8415],
Cell[2190, 66, 1587, 42, 70, "Text",
 CellID->1399],
Cell[3780, 110, 2575, 84, 70, "DefinitionBox",
 CellID->23755],
Cell[6358, 196, 106, 3, 70, "Caption",
 CellID->6184],
Cell[6467, 201, 1111, 39, 70, "Text",
 CellID->28658],
Cell[7581, 242, 612, 21, 70, "Text",
 CellID->8484],
Cell[8196, 265, 1366, 47, 70, "Text",
 CellID->8525],
Cell[9565, 314, 382, 14, 70, "MathCaption",
 CellID->27975],
Cell[CellGroupData[{
Cell[9972, 332, 414, 14, 28, "Input",
 CellID->19689],
Cell[10389, 348, 463, 17, 36, "Output",
 CellID->10371]
}, Open  ]],
Cell[10867, 368, 345, 12, 70, "MathCaption",
 CellID->5794],
Cell[CellGroupData[{
Cell[11237, 384, 414, 14, 70, "Input",
 CellID->14385],
Cell[11654, 400, 461, 17, 36, "Output",
 CellID->944]
}, Open  ]],
Cell[12130, 420, 80, 1, 70, "MathCaption",
 CellID->29920],
Cell[CellGroupData[{
Cell[12235, 425, 565, 19, 70, "Input",
 CellID->14775],
Cell[12803, 446, 463, 17, 36, "Output",
 CellID->10161]
}, Open  ]],
Cell[13281, 466, 1442, 39, 70, "Text",
 CellID->22324],
Cell[14726, 507, 650, 20, 70, "Text",
 CellID->3971],
Cell[15379, 529, 152, 4, 70, "MathCaption",
 CellID->14466],
Cell[CellGroupData[{
Cell[15556, 537, 884, 30, 70, "Input",
 CellID->5235],
Cell[16443, 569, 463, 17, 36, "Output",
 CellID->21959]
}, Open  ]],
Cell[16921, 589, 72, 1, 70, "MathCaption",
 CellID->17540],
Cell[CellGroupData[{
Cell[17018, 594, 271, 9, 28, "Input",
 CellID->2443],
Cell[17292, 605, 2206, 40, 141, "Output",
 Evaluatable->False,
 CellID->708041973]
}, Open  ]],
Cell[19513, 648, 141, 4, 70, "MathCaption",
 CellID->19654],
Cell[CellGroupData[{
Cell[19679, 656, 586, 19, 70, "Input",
 CellID->22497],
Cell[20268, 677, 462, 17, 36, "Output",
 CellID->7339]
}, Open  ]],
Cell[20745, 697, 217, 6, 70, "MathCaption",
 CellID->1709],
Cell[CellGroupData[{
Cell[20987, 707, 795, 28, 70, "Input",
 CellID->8057],
Cell[21785, 737, 462, 17, 36, "Output",
 CellID->4302]
}, Open  ]],
Cell[22262, 757, 1137, 41, 70, "Text",
 CellID->2323],
Cell[23402, 800, 88, 1, 70, "MathCaption",
 CellID->32037],
Cell[CellGroupData[{
Cell[23515, 805, 403, 14, 70, "Input",
 CellID->1338],
Cell[23921, 821, 462, 17, 36, "Output",
 CellID->3916]
}, Open  ]],
Cell[24398, 841, 355, 9, 70, "Text",
 CellID->23697],
Cell[24756, 852, 111, 3, 70, "MathCaption",
 CellID->31491],
Cell[CellGroupData[{
Cell[24892, 859, 549, 19, 28, "Input",
 CellID->29402],
Cell[25444, 880, 1459, 28, 88, "Output",
 Evaluatable->False,
 CellID->93960060]
}, Open  ]],
Cell[26918, 911, 76, 1, 70, "MathCaption",
 CellID->28687],
Cell[CellGroupData[{
Cell[27019, 916, 271, 9, 28, "Input",
 CellID->30997],
Cell[27293, 927, 3534, 62, 124, "Output",
 Evaluatable->False,
 CellID->37435673]
}, Open  ]],
Cell[30842, 992, 232, 8, 70, "Text",
 CellID->567],
Cell[31077, 1002, 111, 3, 70, "MathCaption",
 CellID->25949],
Cell[CellGroupData[{
Cell[31213, 1009, 874, 29, 70, "Input",
 CellID->12926],
Cell[32090, 1040, 774, 28, 54, "Output",
 CellID->570461192]
}, Open  ]],
Cell[32879, 1071, 148, 5, 70, "MathCaption",
 CellID->21591],
Cell[CellGroupData[{
Cell[33052, 1080, 325, 10, 28, "Input",
 CellID->12848],
Cell[33380, 1092, 2249, 41, 119, "Output",
 Evaluatable->False,
 CellID->36022582]
}, Open  ]],
Cell[35644, 1136, 191, 7, 70, "MathCaption",
 CellID->17691],
Cell[CellGroupData[{
Cell[35860, 1147, 417, 13, 28, "Input",
 CellID->6744],
Cell[36280, 1162, 3940, 69, 218, "Output",
 Evaluatable->False,
 CellID->1001430587]
}, Open  ]],
Cell[40235, 1234, 392, 10, 70, "Text",
 CellID->5512],
Cell[40630, 1246, 134, 4, 70, "MathCaption",
 CellID->24098],
Cell[CellGroupData[{
Cell[40789, 1254, 1380, 46, 65, "Input",
 CellID->4772],
Cell[42172, 1302, 1863, 35, 71, "Output",
 Evaluatable->False,
 CellID->17683107]
}, Open  ]],
Cell[44050, 1340, 66, 1, 70, "MathCaption",
 CellID->22771],
Cell[CellGroupData[{
Cell[44141, 1345, 327, 11, 28, "Input",
 CellID->5409],
Cell[44471, 1358, 1620, 31, 105, "Output",
 Evaluatable->False,
 CellID->539117062]
}, Open  ]],
Cell[46106, 1392, 72, 1, 70, "MathCaption",
 CellID->21448],
Cell[CellGroupData[{
Cell[46203, 1397, 427, 14, 28, "Input",
 CellID->5745],
Cell[46633, 1413, 5626, 96, 141, "Output",
 Evaluatable->False,
 CellID->108275004]
}, Open  ]],
Cell[52274, 1512, 1024, 36, 70, "Text",
 CellID->14512],
Cell[53301, 1550, 108, 3, 70, "MathCaption",
 CellID->23916],
Cell[CellGroupData[{
Cell[53434, 1557, 825, 27, 70, "Input",
 CellID->13855],
Cell[54262, 1586, 467, 17, 36, "Output",
 CellID->540273562]
}, Open  ]],
Cell[54744, 1606, 62, 1, 70, "MathCaption",
 CellID->6762],
Cell[CellGroupData[{
Cell[54831, 1611, 752, 24, 47, "Input",
 CellID->20157],
Cell[55586, 1637, 4195, 73, 122, "Output",
 Evaluatable->False,
 CellID->100814069]
}, Open  ]],
Cell[59796, 1713, 1834, 57, 70, "DefinitionBox3Col",
 CellID->19418],
Cell[61633, 1772, 104, 5, 70, "Caption",
 CellID->9164],
Cell[61740, 1779, 762, 19, 70, "Text",
 CellID->6704],
Cell[62505, 1800, 130, 4, 70, "MathCaption",
 CellID->13318],
Cell[CellGroupData[{
Cell[62660, 1808, 706, 24, 70, "Input",
 CellID->18545],
Cell[63369, 1834, 494, 18, 36, "Output",
 CellID->171825674]
}, Open  ]],
Cell[63878, 1855, 334, 11, 70, "MathCaption",
 CellID->5695],
Cell[CellGroupData[{
Cell[64237, 1870, 293, 10, 28, "Input",
 CellID->11154],
Cell[64533, 1882, 2719, 49, 136, "Output",
 Evaluatable->False,
 CellID->158368893]
}, Open  ]],
Cell[67267, 1934, 448, 13, 70, "Text",
 CellID->18254],
Cell[67718, 1949, 191, 7, 70, "MathCaption",
 CellID->618],
Cell[CellGroupData[{
Cell[67934, 1960, 782, 26, 70, "Input",
 CellID->16800],
Cell[68719, 1988, 773, 28, 54, "Output",
 CellID->154412798]
}, Open  ]],
Cell[69507, 2019, 221, 7, 70, "MathCaption",
 CellID->7561],
Cell[CellGroupData[{
Cell[69753, 2030, 407, 13, 28, "Input",
 CellID->23932],
Cell[70163, 2045, 1998, 37, 138, "Output",
 Evaluatable->False,
 CellID->85330767]
}, Open  ]],
Cell[72176, 2085, 1125, 32, 70, "Text",
 CellID->7546],
Cell[73304, 2119, 204, 7, 70, "MathCaption",
 CellID->21260],
Cell[CellGroupData[{
Cell[73533, 2130, 555, 20, 70, "Input",
 CellID->28943],
Cell[74091, 2152, 481, 9, 70, "Message",
 CellID->700840964],
Cell[74575, 2163, 612, 21, 39, "Output",
 CellID->77888502]
}, Open  ]],
Cell[75202, 2187, 199, 7, 70, "MathCaption",
 CellID->22712],
Cell[CellGroupData[{
Cell[75426, 2198, 293, 10, 28, "Input",
 CellID->13906],
Cell[75722, 2210, 2197, 40, 136, "Output",
 Evaluatable->False,
 CellID->94949504]
}, Open  ]],
Cell[77934, 2253, 805, 24, 70, "Text",
 CellID->28039],
Cell[78742, 2279, 277, 9, 70, "MathCaption",
 CellID->27109],
Cell[CellGroupData[{
Cell[79044, 2292, 1377, 44, 70, "Input",
 CellID->30730],
Cell[80424, 2338, 1058, 38, 71, "Output",
 CellID->232956]
}, Open  ]],
Cell[81497, 2379, 110, 3, 70, "MathCaption",
 CellID->12337],
Cell[CellGroupData[{
Cell[81632, 2386, 464, 14, 28, "Input",
 CellID->9721],
Cell[82099, 2402, 4994, 86, 237, "Output",
 Evaluatable->False,
 CellID->4669918]
}, Open  ]],
Cell[87108, 2491, 789, 21, 70, "Text",
 CellID->19274],
Cell[87900, 2514, 521, 17, 70, "Text",
 CellID->3257],
Cell[88424, 2533, 113, 3, 70, "MathCaption",
 CellID->30465],
Cell[CellGroupData[{
Cell[88562, 2540, 902, 30, 70, "Input",
 CellID->8643],
Cell[89467, 2572, 773, 28, 54, "Output",
 CellID->883301985]
}, Open  ]],
Cell[90255, 2603, 61, 1, 70, "MathCaption",
 CellID->10450],
Cell[CellGroupData[{
Cell[90341, 2608, 360, 12, 28, "Input",
 CellID->17621],
Cell[90704, 2622, 2666, 48, 124, "Output",
 Evaluatable->False,
 CellID->310943102]
}, Open  ]],
Cell[93385, 2673, 2841, 91, 70, "DefinitionBox",
 CellID->14956],
Cell[96229, 2766, 105, 3, 70, "Caption",
 CellID->1134],
Cell[96337, 2771, 167, 4, 70, "MathCaption",
 CellID->17274],
Cell[CellGroupData[{
Cell[96529, 2779, 1182, 38, 70, "Input",
 CellID->9747],
Cell[97714, 2819, 632, 21, 36, "Output",
 CellID->309174521]
}, Open  ]],
Cell[98361, 2843, 74, 1, 70, "MathCaption",
 CellID->861],
Cell[CellGroupData[{
Cell[98460, 2848, 472, 15, 28, "Input",
 CellID->13463],
Cell[98935, 2865, 21202, 352, 169, "Output",
 Evaluatable->False,
 CellID->33672717]
}, Open  ]],
Cell[120152, 3220, 109, 3, 70, "MathCaption",
 CellID->24814],
Cell[CellGroupData[{
Cell[120286, 3227, 1556, 50, 70, "Input",
 CellID->22050],
Cell[121845, 3279, 634, 21, 36, "Output",
 CellID->143498832]
}, Open  ]],
Cell[122494, 3303, 72, 1, 70, "MathCaption",
 CellID->24017],
Cell[CellGroupData[{
Cell[122591, 3308, 432, 14, 28, "Input",
 CellID->419173266],
Cell[123026, 3324, 23526, 390, 169, "Output",
 Evaluatable->False,
 CellID->41757677]
}, Open  ]],
Cell[146567, 3717, 113, 3, 70, "MathCaption",
 CellID->21270],
Cell[CellGroupData[{
Cell[146705, 3724, 553, 17, 47, "Input",
 CellID->27894],
Cell[147261, 3743, 29846, 493, 204, "Output",
 Evaluatable->False,
 CellID->218134034]
}, Open  ]],
Cell[177122, 4239, 92, 1, 70, "MathCaption",
 CellID->19292],
Cell[CellGroupData[{
Cell[177239, 4244, 923, 33, 70, "Input",
 CellID->29984],
Cell[178165, 4279, 1243, 44, 51, "Output",
 CellID->95896271]
}, Open  ]],
Cell[179423, 4326, 64, 1, 70, "MathCaption",
 CellID->3461],
Cell[CellGroupData[{
Cell[179512, 4331, 1326, 42, 70, "Input",
 CellID->12102],
Cell[180841, 4375, 783, 25, 36, "Output",
 CellID->253838765]
}, Open  ]],
Cell[181639, 4403, 87, 1, 70, "MathCaption",
 CellID->16109],
Cell[CellGroupData[{
Cell[181751, 4408, 737, 22, 47, "Input",
 CellID->20231971],
Cell[182491, 4432, 70171, 1154, 329, "Output",
 Evaluatable->False,
 CellID->580762293]
}, Open  ]],
Cell[CellGroupData[{
Cell[252699, 5591, 72, 1, 70, "RelatedTutorialsSection",
 CellID->272107340],
Cell[252774, 5594, 198, 5, 70, "RelatedTutorials",
 CellID->163046772],
Cell[252975, 5601, 327, 9, 70, "RelatedTutorials",
 CellID->1373056497]
}, Open  ]]
}, Open  ]],
Cell[253329, 5614, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

