(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19172,        615]
NotebookOptionsPosition[     14670,        481]
NotebookOutlinePosition[     17594,        555]
CellTagsIndexPosition[     17503,        549]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Functions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NSolve" :> Documentation`HelpLookup["paclet:ref/NSolve"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"NSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Solution of Polynomial Equations", "Title",
 CellTags->{"S3.9.5", "5.1"},
 CellID->20638],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " cannot find solutions in terms of radicals to polynomial equations, it \
returns a symbolic form of the result in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. "
}], "MathCaption",
 CellID->944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "+", 
     RowBox[{"7", "x"}], "+", "1"}], "==", "0"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:= ",
 CellID->31966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{591, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->7770]
}, Open  ]],

Cell[TextData[{
 "You can get numerical solutions by applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->20255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.14284864552500443`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.1130779765477108`"}], "-", 
      RowBox[{"1.1517343621516742`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.1130779765477108`"}], "+", 
      RowBox[{"1.1517343621516742`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.184502299310213`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.1513900754088373`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.184502299310213`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.1513900754088373`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{510, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->437]
}, Open  ]],

Cell["\<\
This gives the numerical solutions to 25\[Hyphen]digit precision. \
\>", "MathCaption",
 CellID->21922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%%", ",", "25"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->7487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.14284864552500443411341155094667154925`25."}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
      "-", "1.11307797654771073560039789931908355606`24.99246011186423"}], 
      "-", 
      RowBox[{
      "1.15173436215167430504677021966075575906`25.007286846279968", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
      "-", "1.11307797654771073560039789931908355606`24.99246011186423"}], 
      "+", 
      RowBox[{
      "1.15173436215167430504677021966075575906`25.007286846279968", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "1.18450229931021295265710367479241933069`25.006069445147862", "-", 
      RowBox[{
      "1.15139007540883707469914666565451123998`24.993756018716955", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "1.18450229931021295265710367479241933069`25.006069445147862", "+", 
      RowBox[{
      "1.15139007540883707469914666565451123998`24.993756018716955", " ", 
       "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{451, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->10477]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " to get numerical solutions to polynomial equations directly, without first \
trying to find exact results. "
}], "MathCaption",
 CellID->6209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "7"}], "+", "x", "+", "1"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->9563],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.7965443541284568`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.7052980879371502`"}], "-", 
      RowBox[{"0.6376237698062315`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.7052980879371502`"}], "+", 
      RowBox[{"0.6376237698062315`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.12376188051147742`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.0566500111970736`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.12376188051147742`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.0566500111970736`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.9798083844899013`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.516676883839912`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.9798083844899013`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.516676883839912`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{502, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->30273]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSolve"], "[", 
     StyleBox["poly", "TI"], "==", "0", ",", 
     StyleBox["x", "TI"], "]"}], Cell[
    "get approximate numerical solutions to a polynomial equation", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["NSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSolve"], "[", 
     StyleBox["poly", "TI"], "==", "0", ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "get solutions using ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "\[Hyphen]digit precision arithmetic"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSolve"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["var", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["var", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["get solutions to a polynomial system", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16031],

Cell["Numerical solution of polynomial equations and systems. ", "Caption",
 CellID->2372],

Cell["", "Text",
 CellID->396614672],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will give you the complete set of numerical solutions to any polynomial \
equation or system of polynomial equations."
}], "Text",
 CellID->32586],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " can find solutions to sets of simultaneous polynomial equations."
}], "MathCaption",
 CellID->24879340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "+", 
       RowBox[{"y", "^", "3"}]}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->473135809],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM9u3DYQxmVLu45rO7bbHFL0sijQYy+9FH2B9tSHMIIAySFpkORxemiK
HtqnVEWJtLmfPpJD/aUtLuCVSEnD4Wg4HP5s+ve7z29ev7v7/PbV3eG3j3cf
3rx99enw6x8fm6rypChO3hVF8fpl0ZzXzVn7oz7vm5/utDu7UN+luVoX/0L5
rPmqmuKfUF9BuWylfQW1/zVfp0W/PiTt9EFadV+rZZ06ZF41X6pY6evquNP3
q2Opr+/1Uavcfkrr+jOQuwe5e6Ira6eCo3ruzDRrPY/t4RupLLm+fmF7oX7s
dHnn6Y8tz3X/ztEvzzvF2od33JxcMnvsbC8oLGuwt9G/m9fue22XvAZ62yuL
taM2EWobU3tmtVPod6b0OdfHq0CvbF+bQ7+w1mHbct1kFsb+cln47k+hzKwc
HgHn5C7jK+days5pI4wOqCPacG8kee4pdYvc3jgesUVajhmBDj9U16+hbGyE
z2FUQctjj/E6m83cFjmntSyOBnXwxhos271m1sNenLT3oW3M+MEYwOMsm416
Onl7gXbwvfP7crQXjomsIi/0zlHYB5HVIvxRZiOZXzIvq/R7q5w2Qinoi7LY
F5790XKXVBu8i409k7scy3fNdJgtDfNC94zlzTPqfsamnnsu6jv6EurIYpvJ
/+yjzAIyH/PMpwI7YI9G+Jpz9fCt3LbB7Co0mq+oFIy/NE5KstOeZPUmd7qF
dqVT6Qvt5xumXUQsCpV5b7nfUMtJ+uydcbyzeXSMOlDN0VN41PStHooiLju+
jrDr9OsM7MlPUOZ6zLVSiLHFXDpE6xv0PPQp5Xml9jV7xa6eroqHyI0E4FYf
lSfb5GBXc1Jg5OEM8IN+7tLzHGv3Qh/L2k8oKrgP25eM666AVCv+LA0OdrS2
XYl/3YKcx8K7UO/Mt4bwLT57Z541pJbPUo+LX5n5JXMruzZzK18MieVW7YyQ
PKfikXHbXCpmrbcOh2p1SZg73dB2njJn4j1OkStZvpM5UlFkjlRzjsRjzIFq
mrkRsV3mRkJu1Hla5kT9cdnLqtvC9FzoLygbLvQP1Mu40JeasxyUNoYLmXVZ
LE+5qZflKSEu9Fj41lRcCPVah2Hw3DBthuEjQ5m2hWun5ULID6ZmHmacps08
XETIpt1bp2bjuBA+PTXr4ERgTdYR5j+Zlbli2FAuhKNpKAWJWYksS0FkNGhL
fGwIF3oBz0xNR2Ki0bJ0hNOiLXAyWYz5jt21cj6fLgH5mdZunaLdQJlzITXm
YriMWfFPxWV+tOStwaUyF5qDC/XWHPUxT3kqnGjpfYBPixvRfDxzJKnlNrMr
kZGjzJWOR2+QAUBunLlS3ya9GSQZroTl9PZ2pcuZ0t87mBp3ku2xzhwK7Zji
/sDMpTKXsmoyl8pcymu3zKW69rfEpb5AWbqPrdMJY8Tfddw+tosHKWIudemw
rs1tXHO5ek7KpyqQi/VT8aix/bmeWX9889IMFXMdnMf8bCe0cgldn+J/BXlW
Q9IczTNvxxKlZe035O+6lrcX+ul9vBDvRqPeHcxEQ9ZE3U1rMaupwdmvR89Y
OkQzw9msw71qPetgG621xFwIy7wfhrwwG1XEP8esz2GlUPuYz1wkaB6rxKwO
5rcCXm+z3gFM57nIVtFRVxhja6d3qZ6YDOKex9O27HxjGp6zvE24XvPYwOM5
zvx4zLo8nrDGrCfFZGJCXrOsNUbEnYmtIYs534+wTkwtapnuvqpfVrJIujwL
95R1nsT2lDFGw9iLuu/r+pjRhJiOj83EtIt7yYa2i+PwtrWKOh3PZELMfByj
CUWQYcyGSl2M4bj2nj0WZsPyrDn7wxmO6PecCTGdIf8vZ8sMh/41SfL2czMd
fJrFzcx4MuMZz3gkWfdyzGfEmqt+OoxHFs3SYj7xM+z6vIN727aYj8zXlmRA
cfl2ZkK6ufaTmVBXL4tJmRFhbWZEWMsZUYhjHOrMjLqChAoVJ/8DmQbw6w==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{365, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->371208385]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->1000576873],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Solution of Polynomial Equations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalEvaluationOfSumsAndProducts"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalRootFinding"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 29.5739110}", "context" -> "", 
    "keywords" -> {
     "equations", "NSolve", "numerical solution of equations", 
      "numerical solution of polynomial equations", "polynomial equations", 
      "polynomial root finding", "roots of polynomials", 
      "solution of polynomial equations", "solve", "solving equations"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "When Solve cannot find solutions in terms of radicals to polynomial \
equations, it returns a symbolic form of the result in terms of Root objects. \
You can get numerical solutions by applying N. This gives the numerical \
solutions to 25-digit precision. ", "synonyms" -> {"3.9.5"}, "title" -> 
    "Numerical Solution of Polynomial Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalSolutionOfPolynomialEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.5"->{
  Cell[1840, 59, 105, 2, 70, "Title",
   CellTags->{"S3.9.5", "5.1"},
   CellID->20638]},
 "5.1"->{
  Cell[1840, 59, 105, 2, 70, "Title",
   CellTags->{"S3.9.5", "5.1"},
   CellID->20638]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.5", 17290, 538},
 {"5.1", 17390, 542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1215, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1840, 59, 105, 2, 70, "Title",
 CellTags->{"S3.9.5", "5.1"},
 CellID->20638],
Cell[1948, 63, 425, 14, 70, "MathCaption",
 CellID->944],
Cell[CellGroupData[{
Cell[2398, 81, 230, 9, 28, "Input",
 CellID->31966],
Cell[2631, 92, 1454, 52, 58, "Output",
 CellID->7770]
}, Open  ]],
Cell[4100, 147, 209, 8, 70, "MathCaption",
 CellID->1603],
Cell[CellGroupData[{
Cell[4334, 159, 94, 3, 28, "Input",
 CellID->20255],
Cell[4431, 164, 1035, 29, 54, "Output",
 CellID->437]
}, Open  ]],
Cell[5481, 196, 113, 3, 70, "MathCaption",
 CellID->21922],
Cell[CellGroupData[{
Cell[5619, 203, 118, 4, 28, "Input",
 CellID->7487],
Cell[5740, 209, 1440, 43, 105, "Output",
 CellID->10477]
}, Open  ]],
Cell[7195, 255, 293, 9, 70, "MathCaption",
 CellID->6209],
Cell[CellGroupData[{
Cell[7513, 268, 210, 8, 70, "Input",
 CellID->9563],
Cell[7726, 278, 1412, 37, 71, "Output",
 CellID->30273]
}, Open  ]],
Cell[9153, 318, 1798, 56, 70, "DefinitionBox",
 CellID->16031],
Cell[10954, 376, 90, 1, 70, "Caption",
 CellID->2372],
Cell[11047, 379, 36, 1, 70, "Text",
 CellID->396614672],
Cell[11086, 382, 280, 8, 70, "Text",
 CellID->32586],
Cell[11369, 392, 237, 7, 70, "MathCaption",
 CellID->24879340],
Cell[CellGroupData[{
Cell[11631, 403, 444, 16, 28, "Input",
 CellID->473135809],
Cell[12078, 421, 2227, 41, 122, "Output",
 Evaluatable->False,
 CellID->371208385]
}, Open  ]],
Cell[CellGroupData[{
Cell[14342, 467, 73, 1, 70, "RelatedTutorialsSection",
 CellID->1000576873],
Cell[14418, 470, 198, 5, 70, "RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],
Cell[14643, 479, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

