(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14579,        495]
NotebookOptionsPosition[     10308,        367]
NotebookOutlinePosition[     13118,        440]
CellTagsIndexPosition[     13027,        434]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Infinity" :> Documentation`HelpLookup["paclet:ref/Infinity"], 
          "NIntegrate" :> Documentation`HelpLookup["paclet:ref/NIntegrate"], 
          "NProduct" :> Documentation`HelpLookup["paclet:ref/NProduct"], 
          "NSum" :> Documentation`HelpLookup["paclet:ref/NSum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Infinity\"\>", 
       2->"\<\"NIntegrate\"\>", 3->"\<\"NProduct\"\>", 
       4->"\<\"NSum\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Sums, Products and Integrals", "Title",
 CellTags->{"S1.6.2", "2.1"},
 CellID->3848],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NSum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSum"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], "}", "]"}], Cell[TextData[{
     "numerical approximation to ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         SubscriptBox["i", 
          StyleBox["min",
           FontSlant->"Italic"]], "\[Infinity]",
         LimitsPositioning->True], " ", "f"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NProduct",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NProduct"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], "}", "]"}], Cell[TextData[{
     "numerical approximation to ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Product]", 
         SubscriptBox["i", 
          StyleBox["min",
           FontSlant->"Italic"]], "\[Infinity]",
         LimitsPositioning->True], " ", "f"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "numerical approximation to ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox["x", 
          StyleBox["min",
           FontSlant->"Italic"]], 
         SubscriptBox["x", 
          StyleBox["max",
           FontSlant->"Italic"]]], " ", 
        RowBox[{"f", " ", "d", "\[InvisibleSpace]", "x"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multiple integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox["x", 
          StyleBox["min",
           FontSlant->"Italic"]], 
         SubscriptBox["x", 
          StyleBox["max",
           FontSlant->"Italic"]]], 
        RowBox[{"d", "x", 
         RowBox[{
          SubsuperscriptBox["\[Integral]", 
           SubscriptBox["y", 
            StyleBox["min",
             FontSlant->"Italic"]], 
           SubscriptBox["y", 
            StyleBox["max",
             FontSlant->"Italic"]]], 
          RowBox[{"d", "y", " ", "f"}]}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12535],

Cell["Numerical sums, products and integrals. ", "Caption",
 CellID->27397],

Cell[TextData[{
 "Here is a numerical approximation to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "\[Infinity]",
     LimitsPositioning->True], 
    FractionBox["1", 
     SuperscriptBox["i", "3"]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->9025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"i", "^", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13707],

Cell[BoxData["1.2020569031403265`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2044187149]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " can handle singularities in the integration region. "
}], "MathCaption",
 CellID->11444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23022],

Cell[BoxData["3.141592653589809`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->648911044]
}, Open  ]],

Cell["You can do numerical integrals over infinite regions. ", "MathCaption",
 CellID->29994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20873],

Cell[BoxData["1.7724538504129481`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1707159142]
}, Open  ]],

Cell["\<\
Here is a double integral over a triangular domain. Note the order in which \
the variables are given.\
\>", "MathCaption",
 CellID->26559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18929],

Cell[BoxData["0.11990587168081979`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1105662955]
}, Open  ]],

Cell["Here is a double integral over a more complicated domain.", \
"MathCaption",
 CellID->7013831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", " ", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "3"}], "+", "3"}], "]"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->125164068],

Cell[BoxData["0.7273318592040042`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->428215173]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->116181292],

Cell[TextData[ButtonBox["Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematicsOverview"]], "RelatedTutorials",
 CellID->432952818]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Sums, Products and Integrals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalMathematicsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalMathematics-BasicOperations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalEquationSolving"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 29.8864190}", "context" -> "", 
    "keywords" -> {
     "integration", "N", "NIntegrate", "NProduct", "NSum", 
      "numerical integration", "numerical products", "numerical summation", 
      "products", "quadrature", "sums"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Numerical sums, products and integrals. Here is a numerical \
approximation to UnderoverscriptBox[\\[Sum], RowBox[{i, =, 1}], Infinity, \
LimitsPositioning -> True]FractionBox[1, SuperscriptBox[i, 3]]. NIntegrate \
can handle singularities in the integration region. ", 
    "synonyms" -> {"1.6.2"}, "title" -> 
    "Numerical Sums, Products and Integrals", "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalSumsProductsAndIntegrals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.6.2"->{
  Cell[2101, 62, 100, 2, 70, "Title",
   CellTags->{"S1.6.2", "2.1"},
   CellID->3848]},
 "2.1"->{
  Cell[2101, 62, 100, 2, 70, "Title",
   CellTags->{"S1.6.2", "2.1"},
   CellID->3848]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.6.2", 12816, 423},
 {"2.1", 12915, 427}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1476, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2101, 62, 100, 2, 70, "Title",
 CellTags->{"S1.6.2", "2.1"},
 CellID->3848],
Cell[2204, 66, 4092, 132, 70, "DefinitionBox",
 CellID->12535],
Cell[6299, 200, 75, 1, 70, "Caption",
 CellID->27397],
Cell[6377, 203, 336, 12, 70, "MathCaption",
 CellID->9025],
Cell[CellGroupData[{
Cell[6738, 219, 234, 8, 28, "Input",
 CellID->13707],
Cell[6975, 229, 177, 5, 36, "Output",
 CellID->2044187149]
}, Open  ]],
Cell[7167, 237, 230, 7, 70, "MathCaption",
 CellID->11444],
Cell[CellGroupData[{
Cell[7422, 248, 322, 11, 28, "Input",
 CellID->23022],
Cell[7747, 261, 175, 5, 36, "Output",
 CellID->648911044]
}, Open  ]],
Cell[7937, 269, 93, 1, 70, "MathCaption",
 CellID->29994],
Cell[CellGroupData[{
Cell[8055, 274, 296, 10, 28, "Input",
 CellID->20873],
Cell[8354, 286, 177, 5, 36, "Output",
 CellID->1707159142]
}, Open  ]],
Cell[8546, 294, 149, 4, 70, "MathCaption",
 CellID->26559],
Cell[CellGroupData[{
Cell[8720, 302, 309, 10, 70, "Input",
 CellID->18929],
Cell[9032, 314, 178, 5, 36, "Output",
 CellID->1105662955]
}, Open  ]],
Cell[9225, 322, 100, 2, 70, "MathCaption",
 CellID->7013831],
Cell[CellGroupData[{
Cell[9350, 328, 439, 14, 70, "Input",
 CellID->125164068],
Cell[9792, 344, 176, 5, 36, "Output",
 CellID->428215173]
}, Open  ]],
Cell[CellGroupData[{
Cell[10005, 354, 72, 1, 70, "RelatedTutorialsSection",
 CellID->116181292],
Cell[10080, 357, 174, 4, 70, "RelatedTutorials",
 CellID->432952818]
}, Open  ]]
}, Open  ]],
Cell[10281, 365, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

