(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24443,        923]
NotebookOptionsPosition[     18433,        727]
NotebookOutlinePosition[     21173,        798]
CellTagsIndexPosition[     21082,        792]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Series, Limits and Residues" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>", 
      
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Operations on Power Series", "Title",
 CellTags->{"S3.6.3", "3.1"},
 CellID->16500],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to perform many operations on power series. In all cases, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives results only to as many terms as can be justified from the accuracy \
of your input. "
}], "Text",
 CellID->18880],

Cell[TextData[{
 "Here is a power series accurate to fourth order in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->9487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1341],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{166, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1875906922]
}, Open  ]],

Cell["\<\
When you square the power series, you get another power series, also accurate \
to fourth order. \
\>", "MathCaption",
 CellID->28241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "^", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12798],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["x", "3"]}], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "4"]}], "3"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 2, 2, 
    Rational[4, 3], 
    Rational[2, 3]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{201, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2064151000]
}, Open  ]],

Cell[TextData[{
 "Taking the logarithm gives you the result ",
 Cell[BoxData[
  RowBox[{"2", "x"}]], "InlineFormula"],
 ", but only to order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "4"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->25573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3908],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2}, 1, 5, 1],
  Editable->False]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1678760398]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " keeps track of the orders of power series in much the same way as it keeps \
track of the precision of approximate real numbers. Just as with numerical \
calculations, there are operations on power series which can increase, or \
decrease, the precision (or order) of your results. "
}], "Text",
 CellID->3950],

Cell[TextData[{
 "Here is a power series accurate to order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "10"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->27308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28941],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "720"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "40320"], "-", 
   FractionBox[
    SuperscriptBox["x", "10"], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[1, 24], 0, 
    Rational[-1, 720], 0, 
    Rational[1, 40320], 0, 
    Rational[-1, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{284, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1610306094]
}, Open  ]],

Cell[TextData[{
 "This gives a power series that is accurate only to order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "6"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->3425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", "%"}], ")"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->15450],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["2", 
    SuperscriptBox["x", "2"]], "+", 
   FractionBox["1", "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "120"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "3024"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "86400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"],
    SeriesData[$CellContext`x, 0, {}, -2, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, 0, 
    Rational[1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[1, 3024], 0, 
    Rational[1, 86400]}, -2, 7, 1],
  Editable->False]], "Output",
 ImageSize->{227, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->997226445]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also allows you to do calculus with power series."
}], "Text",
 CellID->16736],

Cell[TextData[{
 "Here is a power series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"tan", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->25067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->30054],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "15"], "+", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "7"]}], "315"], "+", 
   FractionBox[
    RowBox[{"62", " ", 
     SuperscriptBox["x", "9"]}], "2835"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 3], 0, 
    Rational[2, 15], 0, 
    Rational[17, 315], 0, 
    Rational[62, 2835]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{224, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1489077296]
}, Open  ]],

Cell[TextData[{
 "Here is its derivative with respect to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->16921],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "4"]}], "3"], "+", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "6"]}], "45"], "+", 
   FractionBox[
    RowBox[{"62", " ", 
     SuperscriptBox["x", "8"]}], "315"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 1, 0, 
    Rational[2, 3], 0, 
    Rational[17, 45], 0, 
    Rational[62, 315]}, 0, 10, 1],
  Editable->False]], "Output",
 ImageSize->{219, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->521723648]
}, Open  ]],

Cell[TextData[{
 "Integrating with respect to ",
 Cell[BoxData["x"], "InlineFormula"],
 " gives back the original power series. "
}], "MathCaption",
 CellID->27935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->32215],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "15"], "+", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "7"]}], "315"], "+", 
   FractionBox[
    RowBox[{"62", " ", 
     SuperscriptBox["x", "9"]}], "2835"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 3], 0, 
    Rational[2, 15], 0, 
    Rational[17, 315], 0, 
    Rational[62, 2835]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{224, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->379159490]
}, Open  ]],

Cell[TextData[{
 "When you perform an operation that involves both a normal expression and a \
power series, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \[OpenCurlyDoubleQuote]absorbs\[CloseCurlyDoubleQuote] the normal \
expression into the power series whenever possible. "
}], "Text",
 CellID->21244],

Cell[TextData[{
 "The ",
 Cell[BoxData["1"], "InlineFormula"],
 " is automatically absorbed into the power series. "
}], "MathCaption",
 CellID->5050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->4655],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{166, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1277921256]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"x", "^", "2"}]], "InlineFormula"],
 " is also absorbed into the power series. "
}], "MathCaption",
 CellID->19881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "+", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->13619],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "+", "x", "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, 1, 
    Rational[3, 2], 
    Rational[1, 6], 
    Rational[1, 24]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{176, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->17098109]
}, Open  ]],

Cell[TextData[{
 "If you add ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", "x", "]"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " generates the appropriate power series for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", "x", "]"}]], "InlineFormula"],
 ", and combines it with the power series you have. "
}], "MathCaption",
 CellID->12656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "+", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->5631],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "+", 
   RowBox[{"2", " ", "x"}], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, 2, 
    Rational[3, 2], 0, 
    Rational[1, 24]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{157, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->2095767565]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also absorbs expressions that multiply power series. The symbol ",
 Cell[BoxData["a"], "InlineFormula"],
 " is assumed to be independent of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "x"}], ")"}], " ", 
  RowBox[{"%", "^", "2"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->13273],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"4", " ", "a"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"8", " ", "a"}]}], ")"}], " ", "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"8", "+", 
      RowBox[{"10", " ", "a"}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"10", "+", 
      RowBox[{"6", " ", "a"}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"6", "+", 
      FractionBox[
       RowBox[{"29", " ", "a"}], "12"]}], ")"}], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   4 $CellContext`a, 4 + 8 $CellContext`a, 8 + 10 $CellContext`a, 10 + 
    6 $CellContext`a, 6 + Rational[29, 12] $CellContext`a}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{402, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->2030215143]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows how to apply a wide variety of functions to power series. However, \
if you apply an arbitrary function to a power series, it is impossible for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to give you anything but a symbolic result."
}], "Text",
 CellID->4497],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know how to apply the function ",
 Cell[BoxData["f"], "InlineFormula"],
 " to a power series, so it just leaves the symbolic result. "
}], "MathCaption",
 CellID->25338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->25576],

Cell[BoxData[
 RowBox[{"f", "[", 
  InterpretationBox[
   RowBox[{"1", "+", "x", "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["x", "3"], "6"], "+", 
    InterpretationBox[
     SuperscriptBox[
      RowBox[{"O", "[", "x", "]"}], "4"],
     SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
     Editable->False]}],
   SeriesData[$CellContext`x, 0, {1, 1, 
     Rational[1, 2], 
     Rational[1, 6]}, 0, 4, 1],
   Editable->False], "]"}]], "Output",
 ImageSize->{157, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->2051593836]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->152573911],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Operations on Power Series - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfPowerSeries"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CompositionAndInversionOfPowerSeries"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 30.4176826}", "context" -> "", 
    "keywords" -> {"differentiation", "integration", "power series"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica allows you to perform many operations on power series. In \
all cases, Mathematica gives results only to as many terms as can be \
justified from the accuracy of your input. Here is a power series accurate to \
fourth order in x. When you square the power series, you get another power \
series, also accurate to fourth order. ", "synonyms" -> {"3.6.3"}, "title" -> 
    "Operations on Power Series", "type" -> "Tutorial", "uri" -> 
    "tutorial/OperationsOnPowerSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.3"->{
  Cell[1285, 44, 89, 2, 70, "Title",
   CellTags->{"S3.6.3", "3.1"},
   CellID->16500]},
 "3.1"->{
  Cell[1285, 44, 89, 2, 70, "Title",
   CellTags->{"S3.6.3", "3.1"},
   CellID->16500]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.3", 20871, 781},
 {"3.1", 20970, 785}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 660, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1285, 44, 89, 2, 70, "Title",
 CellTags->{"S3.6.3", "3.1"},
 CellID->16500],
Cell[1377, 48, 312, 9, 70, "Text",
 CellID->18880],
Cell[1692, 59, 175, 6, 70, "MathCaption",
 CellID->9487],
Cell[CellGroupData[{
Cell[1892, 69, 210, 7, 28, "Input",
 CellID->1341],
Cell[2105, 78, 671, 23, 54, "Output",
 CellID->1875906922]
}, Open  ]],
Cell[2791, 104, 144, 4, 70, "MathCaption",
 CellID->28241],
Cell[CellGroupData[{
Cell[2960, 112, 88, 3, 28, "Input",
 CellID->12798],
Cell[3051, 117, 729, 25, 54, "Output",
 CellID->2064151000]
}, Open  ]],
Cell[3795, 145, 273, 10, 70, "MathCaption",
 CellID->25573],
Cell[CellGroupData[{
Cell[4093, 159, 94, 3, 28, "Input",
 CellID->3908],
Cell[4190, 164, 442, 15, 36, "Output",
 CellID->1678760398]
}, Open  ]],
Cell[4647, 182, 378, 8, 70, "Text",
 CellID->3950],
Cell[5028, 192, 192, 7, 70, "MathCaption",
 CellID->27308],
Cell[CellGroupData[{
Cell[5245, 203, 212, 7, 70, "Input",
 CellID->28941],
Cell[5460, 212, 862, 29, 54, "Output",
 CellID->1610306094]
}, Open  ]],
Cell[6337, 244, 206, 7, 70, "MathCaption",
 CellID->3425],
Cell[CellGroupData[{
Cell[6568, 255, 135, 5, 70, "Input",
 CellID->15450],
Cell[6706, 262, 788, 27, 55, "Output",
 CellID->997226445]
}, Open  ]],
Cell[7509, 292, 146, 5, 70, "Text",
 CellID->16736],
Cell[7658, 299, 198, 8, 70, "MathCaption",
 CellID->25067],
Cell[CellGroupData[{
Cell[7881, 311, 212, 7, 70, "Input",
 CellID->30054],
Cell[8096, 320, 844, 29, 54, "Output",
 CellID->1489077296]
}, Open  ]],
Cell[8955, 352, 138, 5, 70, "MathCaption",
 CellID->32085],
Cell[CellGroupData[{
Cell[9118, 361, 116, 4, 70, "Input",
 CellID->16921],
Cell[9237, 367, 796, 27, 54, "Output",
 CellID->521723648]
}, Open  ]],
Cell[10048, 397, 164, 5, 70, "MathCaption",
 CellID->27935],
Cell[CellGroupData[{
Cell[10237, 406, 124, 4, 70, "Input",
 CellID->32215],
Cell[10364, 412, 843, 29, 54, "Output",
 CellID->379159490]
}, Open  ]],
Cell[11222, 444, 313, 8, 70, "Text",
 CellID->21244],
Cell[11538, 454, 150, 5, 70, "MathCaption",
 CellID->5050],
Cell[CellGroupData[{
Cell[11713, 463, 237, 8, 70, "Input",
 CellID->4655],
Cell[11953, 473, 671, 23, 54, "Output",
 CellID->1277921256]
}, Open  ]],
Cell[12639, 499, 165, 6, 70, "MathCaption",
 CellID->19881],
Cell[CellGroupData[{
Cell[12829, 509, 112, 4, 70, "Input",
 CellID->13619],
Cell[12944, 515, 696, 24, 54, "Output",
 CellID->17098109]
}, Open  ]],
Cell[13655, 542, 505, 18, 70, "MathCaption",
 CellID->12656],
Cell[CellGroupData[{
Cell[14185, 564, 118, 4, 70, "Input",
 CellID->5631],
Cell[14306, 570, 646, 22, 54, "Output",
 CellID->2095767565]
}, Open  ]],
Cell[14967, 595, 289, 9, 70, "MathCaption",
 CellID->22178],
Cell[CellGroupData[{
Cell[15281, 608, 159, 6, 70, "Input",
 CellID->13273],
Cell[15443, 616, 1129, 37, 51, "Output",
 CellID->2030215143]
}, Open  ]],
Cell[16587, 656, 344, 9, 70, "Text",
 CellID->4497],
Cell[16934, 667, 246, 7, 70, "MathCaption",
 CellID->25338],
Cell[CellGroupData[{
Cell[17205, 678, 244, 8, 70, "Input",
 CellID->25576],
Cell[17452, 688, 633, 21, 54, "Output",
 CellID->2051593836]
}, Open  ]],
Cell[CellGroupData[{
Cell[18122, 714, 72, 1, 70, "RelatedTutorialsSection",
 CellID->152573911],
Cell[18197, 717, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[18406, 725, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

