(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14690,        584]
NotebookOptionsPosition[     10126,        428]
NotebookOutlinePosition[     12100,        483]
CellTagsIndexPosition[     12009,        477]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Operations on Scalars, Vectors and Matrices", "Title",
 CellTags->{"S3.7.4", "4.1"},
 CellID->20325],

Cell[TextData[{
 "Most mathematical functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are set up to apply themselves separately to each element in a list. This \
is true in particular of all functions that carry the attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->31465],

Cell["\<\
A consequence is that most mathematical functions are applied element by \
element to matrices and vectors. \
\>", "Text",
 CellID->23829],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " applies itself separately to each element in the vector. "
}], "MathCaption",
 CellID->2650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], ",", 
   RowBox[{"Log", "[", "b", "]"}], ",", 
   RowBox[{"Log", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28384776]
}, Open  ]],

Cell["\<\
The same is true for a matrix, or, for that matter, for any nested list. \
\>", "MathCaption",
 CellID->28298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Log", "[", "a", "]"}], ",", 
     RowBox[{"Log", "[", "b", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Log", "[", "c", "]"}], ",", 
     RowBox[{"Log", "[", "d", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->373375967]
}, Open  ]],

Cell[TextData[{
 "The differentiation function ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " also applies separately to each element in a list. "
}], "MathCaption",
 CellID->18421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}]}], "}"}]], "Output",
 ImageSize->{87, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10283234]
}, Open  ]],

Cell["The sum of two vectors is carried out element by element. ", \
"MathCaption",
 CellID->22734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"ap", ",", "bp"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "ap"}], ",", 
   RowBox[{"b", "+", "bp"}]}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->32537018]
}, Open  ]],

Cell["\<\
If you try to add two vectors with different lengths, you get an error. \
\>", "MathCaption",
 CellID->24022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"ap", ",", "bp"}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->24787],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"Objects of unequal length in \\!\\(\\(\\({a, b, c}\\)\\) + \
\\(\\({ap, bp}\\)\\)\\) cannot be combined. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Thread/tdlen\\\", ButtonNote -> \
\\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[5]:=",
 CellID->94403439],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ap", ",", "bp"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->14352816]
}, Open  ]],

Cell[TextData[{
 "This adds the scalar ",
 Cell[BoxData["1"], "InlineFormula"],
 " to each element of the vector. "
}], "MathCaption",
 CellID->26022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->18316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "a"}], ",", 
   RowBox[{"1", "+", "b"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->392179697]
}, Open  ]],

Cell[TextData[{
 "Any object that is not manifestly a list is treated as a scalar. Here ",
 Cell[BoxData["c"], "InlineFormula"],
 " is treated as a scalar, and added separately to each element in the \
vector. "
}], "MathCaption",
 CellID->15925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "+", "c"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->16179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "c"}], ",", 
   RowBox[{"b", "+", "c"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->73186825]
}, Open  ]],

Cell[TextData[{
 "This multiplies each element in the vector by the scalar ",
 Cell[BoxData["k"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->26271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", " ", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->3871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", "k"}], ",", 
   RowBox[{"b", " ", "k"}]}], "}"}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->466581031]
}, Open  ]],

Cell[TextData[{
 "It is important to realize that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats an object as a vector in a particular operation only if the object \
is explicitly a list at the time when the operation is done. If the object is \
not explicitly a list, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always treats it as a scalar. This means that you can get different \
results, depending on whether you assign a particular object to be a list \
before or after you do a particular operation. "
}], "Text",
 CellID->28493],

Cell[TextData[{
 "The object ",
 Cell[BoxData["p"], "InlineFormula"],
 " is treated as a scalar, and added separately to each element in the \
vector. "
}], "MathCaption",
 CellID->100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "+", "p"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "p"}], ",", 
   RowBox[{"b", "+", "p"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->156359306]
}, Open  ]],

Cell[TextData[{
 "This is what happens if you now replace ",
 Cell[BoxData["p"], "InlineFormula"],
 " by the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"c", ",", "d"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"p", "->", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->32289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ",", 
     RowBox[{"a", "+", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ",", 
     RowBox[{"b", "+", "d"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->678065208]
}, Open  ]],

Cell[TextData[{
 "You would have got a different result if you had replaced ",
 Cell[BoxData["p"], "InlineFormula"],
 " by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"c", ",", "d"}], "}"}]], "InlineFormula"],
 " before you did the first operation. "
}], "MathCaption",
 CellID->16391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->19018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "c"}], ",", 
   RowBox[{"b", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->794763737]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Operations on Scalars, Vectors and Matrices - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 30.6364382}", "context" -> "", 
    "keywords" -> {"listable", "matrices", "vectors"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Most mathematical functions in Mathematica are set up to apply \
themselves separately to each element in a list. This is true in particular \
of all functions that carry the attribute Listable. A consequence is that \
most mathematical functions are applied element by element to matrices and \
vectors. The Log applies itself separately to each element in the vector. ", 
    "synonyms" -> {"3.7.4"}, "title" -> 
    "Operations on Scalars, Vectors and Matrices", "type" -> "Tutorial", 
    "uri" -> "tutorial/OperationsOnScalarsVectorsAndMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.4"->{
  Cell[728, 29, 106, 2, 70, "Title",
   CellTags->{"S3.7.4", "4.1"},
   CellID->20325]},
 "4.1"->{
  Cell[728, 29, 106, 2, 70, "Title",
   CellTags->{"S3.7.4", "4.1"},
   CellID->20325]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.4", 11798, 466},
 {"4.1", 11897, 470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 106, 2, 70, "Title",
 CellTags->{"S3.7.4", "4.1"},
 CellID->20325],
Cell[837, 33, 399, 12, 70, "Text",
 CellID->31465],
Cell[1239, 47, 148, 4, 70, "Text",
 CellID->23829],
Cell[1390, 53, 229, 8, 70, "MathCaption",
 CellID->2650],
Cell[CellGroupData[{
Cell[1644, 65, 152, 5, 28, "Input",
 CellID->16736],
Cell[1799, 72, 306, 10, 36, "Output",
 CellID->28384776]
}, Open  ]],
Cell[2120, 85, 120, 3, 70, "MathCaption",
 CellID->28298],
Cell[CellGroupData[{
Cell[2265, 92, 244, 9, 28, "Input",
 CellID->27883],
Cell[2512, 103, 434, 15, 36, "Output",
 CellID->373375967]
}, Open  ]],
Cell[2961, 121, 245, 8, 70, "MathCaption",
 CellID->18421],
Cell[CellGroupData[{
Cell[3231, 133, 227, 8, 28, "Input",
 CellID->14039],
Cell[3461, 143, 286, 10, 39, "Output",
 CellID->10283234]
}, Open  ]],
Cell[3762, 156, 99, 2, 70, "MathCaption",
 CellID->22734],
Cell[CellGroupData[{
Cell[3886, 162, 184, 7, 70, "Input",
 CellID->13384],
Cell[4073, 171, 252, 9, 36, "Output",
 CellID->32537018]
}, Open  ]],
Cell[4340, 183, 119, 3, 70, "MathCaption",
 CellID->24022],
Cell[CellGroupData[{
Cell[4484, 190, 194, 7, 70, "Input",
 CellID->24787],
Cell[4681, 199, 471, 9, 70, "Message",
 CellID->94403439],
Cell[5155, 210, 286, 10, 36, "Output",
 CellID->14352816]
}, Open  ]],
Cell[5456, 223, 150, 5, 70, "MathCaption",
 CellID->26022],
Cell[CellGroupData[{
Cell[5631, 232, 135, 5, 70, "Input",
 CellID->18316],
Cell[5769, 239, 251, 9, 36, "Output",
 CellID->392179697]
}, Open  ]],
Cell[6035, 251, 246, 6, 70, "MathCaption",
 CellID->15925],
Cell[CellGroupData[{
Cell[6306, 261, 135, 5, 70, "Input",
 CellID->16179],
Cell[6444, 268, 250, 9, 36, "Output",
 CellID->73186825]
}, Open  ]],
Cell[6709, 280, 155, 5, 70, "MathCaption",
 CellID->26271],
Cell[CellGroupData[{
Cell[6889, 289, 134, 5, 70, "Input",
 CellID->3871],
Cell[7026, 296, 251, 9, 36, "Output",
 CellID->466581031]
}, Open  ]],
Cell[7292, 308, 561, 13, 70, "Text",
 CellID->28493],
Cell[7856, 323, 185, 6, 70, "MathCaption",
 CellID->100],
Cell[CellGroupData[{
Cell[8066, 333, 133, 5, 70, "Input",
 CellID->462],
Cell[8202, 340, 251, 9, 36, "Output",
 CellID->156359306]
}, Open  ]],
Cell[8468, 352, 242, 9, 70, "MathCaption",
 CellID->26890],
Cell[CellGroupData[{
Cell[8735, 365, 163, 6, 70, "Input",
 CellID->32289],
Cell[8901, 373, 407, 15, 36, "Output",
 CellID->678065208]
}, Open  ]],
Cell[9323, 391, 286, 9, 70, "MathCaption",
 CellID->16391],
Cell[CellGroupData[{
Cell[9634, 404, 183, 7, 70, "Input",
 CellID->19018],
Cell[9820, 413, 252, 9, 36, "Output",
 CellID->794763737]
}, Open  ]]
}, Open  ]],
Cell[10099, 426, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

