(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    115451,       3047]
NotebookOptionsPosition[    102541,       2731]
NotebookOutlinePosition[    110973,       2882]
CellTagsIndexPosition[    110877,       2876]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical and Other Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalAndOtherNotationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical and Other Notation\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AngleBracket" :> 
          Documentation`HelpLookup["paclet:ref/AngleBracket"], 
          "BracketingBar" :> 
          Documentation`HelpLookup["paclet:ref/BracketingBar"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"], 
          "DoubleBracketingBar" :> 
          Documentation`HelpLookup["paclet:ref/DoubleBracketingBar"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AngleBracket\"\>", 2->"\<\"BracketingBar\"\>", 
       3->"\<\"Ceiling\"\>", 4->"\<\"DoubleBracketingBar\"\>", 
       5->"\<\"Floor\"\>", 6->"\<\"Part\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Operators", "Title",
 CellTags->{"S3.10.4", "4.1"},
 CellID->41],

Cell[CellGroupData[{

Cell["Basic Mathematical Operators", "Section",
 CellID->18467],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Times]", Cell[BoxData[
         ButtonBox["\\[Times]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["*\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Divide]", Cell[BoxData[
         ButtonBox["\\[Divide]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Divide"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["div\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Sqrt]", Cell[BoxData[
         ButtonBox["\\[Sqrt]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sqrt"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sqrt\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Cross]", Cell[BoxData[
         ButtonBox["\\[Cross]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cross\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[PlusMinus]", Cell[BoxData[
         ButtonBox["\\[PlusMinus]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/PlusMinus"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["+-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[MinusPlus]", Cell[BoxData[
         ButtonBox["\\[MinusPlus]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/MinusPlus"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["-+\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->6334],

Cell["Some operators used in basic arithmetic and algebra. ", "Caption",
 CellID->26500],

Cell[TextData[{
 "Note that the ",
 Cell[BoxData["\[Cross]"], "InlineMath"],
 " for ",
 ButtonBox["\[Backslash][Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cross"],
 " is distinguished by being drawn slightly smaller than the ",
 Cell[BoxData["\[Times]"], "InlineMath"],
 " for ",
 ButtonBox["\[Backslash][Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"],
 ". "
}], "Text",
 CellID->19169],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "\[Times]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell["multiplication", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[Divide]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["Divide",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Divide"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell["division", "TableText"]},
   {
    RowBox[{"\[Sqrt]", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     ButtonBox["Sqrt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sqrt"], "[", 
     StyleBox["x", "TI"], "]"}], Cell["square root", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[Cross]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["Cross",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cross"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell["vector cross product", "TableText"]},
   {
    RowBox[{"\[PlusMinus]", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     ButtonBox["PlusMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlusMinus"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[
    "(no built\[Hyphen]in meaning)", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[PlusMinus]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["PlusMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlusMinus"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell[
    "(no built\[Hyphen]in meaning)", "TableText"]},
   {
    RowBox[{"\[MinusPlus]", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     ButtonBox["MinusPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MinusPlus"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[
    "(no built\[Hyphen]in meaning)", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[MinusPlus]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["MinusPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MinusPlus"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell[
    "(no built\[Hyphen]in meaning)", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, False, False, {False}, False},
    "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15724],

Cell["\<\
Interpretation of some operators in basic arithmetic and algebra. \
\>", "Caption",
 CellID->11478]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operators in Calculus and Algebra", "Section",
 CellID->29358],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Del]", Cell[BoxData[
         ButtonBox["\\[Del]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Del"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["del\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[PartialD]", Cell[BoxData[
         ButtonBox["\\[PartialD]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/PartialD"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["pd\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DifferentialD]", Cell[BoxData[
         ButtonBox["\\[DifferentialD]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DifferentialD"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dd\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Sum]", Cell[BoxData[
         ButtonBox["\\[Sum]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sum"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sum\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Product]", Cell[BoxData[
         ButtonBox["\\[Product]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Product"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["prod\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Integral]", Cell[BoxData[
         ButtonBox["\\[Integral]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Integral"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["int\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ContourIntegral]", Cell[BoxData[
         ButtonBox["\\[ContourIntegral]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ContourIntegral"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cint\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleContourIntegral]", Cell[BoxData[
         ButtonBox["\\[DoubleContourIntegral]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleContourIntegral"]], 
         "InlineCharacterName"], ""},
       {"\[CounterClockwiseContourIntegral]", Cell[BoxData[
         ButtonBox["\\[CounterClockwiseContourIntegral]",
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:ref/character/CounterClockwiseContourIntegral"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cccint\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ClockwiseContourIntegral]", Cell[BoxData[
         ButtonBox["\\[ClockwiseContourIntegral]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ClockwiseContourIntegral"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ccint\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->26962],

Cell["Operators used in calculus. ", "Caption",
 CellID->24464],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "aliases", "TableHeader"]},
       {"\[Conjugate]", Cell[BoxData[
         ButtonBox["\\[Conjugate]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Conjugate"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["co\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["conj\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Transpose]", Cell[BoxData[
         ButtonBox["\\[Transpose]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Transpose"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["tr\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[ConjugateTranspose]", Cell[BoxData[
         ButtonBox["\\[ConjugateTranspose]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ConjugateTranspose"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ct\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[HermitianConjugate]", Cell[BoxData[
         ButtonBox["\\[HermitianConjugate]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HermitianConjugate"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["hc\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->5705],

Cell["Operators for complex numbers and matrices. ", "Caption",
 CellID->28145]
}, Open  ]],

Cell[CellGroupData[{

Cell["Logical and Other Connectives", "Section",
 CellID->23281],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "aliases", "TableHeader"]},
       {"\[And]", Cell[BoxData[
         ButtonBox["\\[And]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData[
          RowBox[{"&&", "\[AliasIndicator]"}]], "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["and\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Or]", Cell[BoxData[
         ButtonBox["\\[Or]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Or"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData[
          RowBox[{"||", "\[AliasIndicator]"}]], "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["or\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Not]", Cell[BoxData[
         ButtonBox["\\[Not]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Not"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData[
          RowBox[{"!", "\[AliasIndicator]"}]], "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["not\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Element]", Cell[BoxData[
         ButtonBox["\\[Element]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Element"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["el\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ForAll]", Cell[BoxData[
         ButtonBox["\\[ForAll]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ForAll"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["fa\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Exists]", Cell[BoxData[
         ButtonBox["\\[Exists]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Exists"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ex\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotExists]", Cell[BoxData[
         ButtonBox["\\[NotExists]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotExists"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!ex\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Xor]", Cell[BoxData[
         ButtonBox["\\[Xor]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Xor"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["xor\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Nand]", Cell[BoxData[
         ButtonBox["\\[Nand]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Nand"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["nand\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Nor]", Cell[BoxData[
         ButtonBox["\\[Nor]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Nor"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["nor\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Implies]", Cell[BoxData[
         ButtonBox["\\[Implies]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Implies"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["=>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RoundImplies]", Cell[BoxData[
         ButtonBox["\\[RoundImplies]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RoundImplies"]], 
         "InlineCharacterName"], ""},
       {"\[Therefore]", Cell[BoxData[
         ButtonBox["\\[Therefore]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Therefore"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["tf\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Because]", Cell[BoxData[
         ButtonBox["\\[Because]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Because"]], 
         "InlineCharacterName"], ""},
       {"\[RightTee]", Cell[BoxData[
         ButtonBox["\\[RightTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTee"]], 
         "InlineCharacterName"], ""},
       {"\[LeftTee]", Cell[BoxData[
         ButtonBox["\\[LeftTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftTee"]], 
         "InlineCharacterName"], ""},
       {"\[DoubleRightTee]", Cell[BoxData[
         ButtonBox["\\[DoubleRightTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleRightTee"]], 
         "InlineCharacterName"], ""},
       {"\[DoubleLeftTee]", Cell[BoxData[
         ButtonBox["\\[DoubleLeftTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleLeftTee"]], 
         "InlineCharacterName"], ""},
       {"\[SuchThat]", Cell[BoxData[
         ButtonBox["\\[SuchThat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SuchThat"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["st\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[VerticalSeparator]", Cell[BoxData[
         ButtonBox["\\[VerticalSeparator]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalSeparator"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["|\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Colon]", Cell[BoxData[
         ButtonBox["\\[Colon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Colon"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[":\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->16827],

Cell["Operators used as logical connectives. ", "Caption",
 CellID->9961],

Cell[TextData[{
 "The operators ",
 Cell[BoxData["\[And]"], "InlineMath"],
 ", ",
 Cell[BoxData["\[Or]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[Not]"], "InlineMath"],
 " are interpreted as corresponding to the built\[Hyphen]in functions ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ", and are equivalent to the keyboard operators ",
 Cell[BoxData["&&"], "InlineFormula"],
 ", ",
 Cell[BoxData["||"], "InlineFormula"],
 " and ",
 Cell[BoxData["!"], "InlineFormula"],
 ". The operators ",
 Cell[BoxData["\[Xor]"], "InlineMath"],
 ", ",
 Cell[BoxData["\[Nand]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[Nor]"], "InlineMath"],
 " correspond to the built\[Hyphen]in functions ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 ". Note that ",
 Cell[BoxData["\[Not]"], "InlineMath"],
 " is a prefix operator. "
}], "Text",
 CellID->491],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 Cell[BoxData["\[Implies]"], "InlineMath"],
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 Cell[BoxData["\[RoundImplies]"], "InlineMath"],
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " are both taken to give the built\[Hyphen]in function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Implies",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Implies"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 Cell[BoxData["\[Element]"], "InlineMath"],
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " gives the built\[Hyphen]in function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->2995],

Cell[TextData[{
 "This is interpreted using the built\[Hyphen]in functions ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Implies",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Implies"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"3", "<", "4"}], " ", "\[And]", " ", 
   RowBox[{"x", ">", "5"}]}], " ", "\[Implies]", " ", 
  RowBox[{"y", "<", "7"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4827],

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{
   RowBox[{"x", ">", "5"}], ",", 
   RowBox[{"y", "<", "7"}]}], "]"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->972575766]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports most of the standard syntax used in mathematical logic. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", however, the variables that appear in the quantifiers ",
 Cell[BoxData["\[ForAll]"], "InlineMath"],
 ", ",
 Cell[BoxData["\[Exists]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[NotExists]"], "InlineMath"],
 " must appear as subscripts. If they appeared directly after the quantifier \
symbols then there could be a conflict with multiplication operations. "
}], "Text",
 CellID->32391],

Cell[TextData[{
 Cell[BoxData["\[ForAll]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[Exists]"], "InlineMath"],
 " are essentially prefix operators like ",
 Cell[BoxData["\[PartialD]"], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->14604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ForAll]", "x"], 
   RowBox[{
    SubscriptBox["\[Exists]", "y"], 
    RowBox[{"\[Phi]", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3902],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"y", ",", 
       RowBox[{"\\[Phi]", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->1582861845]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operators Used to Represent Actions", "Section",
 CellID->292],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[SmallCircle]", Cell[BoxData[
         ButtonBox["\\[SmallCircle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SmallCircle"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sc\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CirclePlus]", Cell[BoxData[
         ButtonBox["\\[CirclePlus]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CirclePlus"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c+\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CircleMinus]", Cell[BoxData[
         ButtonBox["\\[CircleMinus]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CircleMinus"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CircleTimes]", Cell[BoxData[
         ButtonBox["\\[CircleTimes]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CircleTimes"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c*\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CircleDot]", Cell[BoxData[
         ButtonBox["\\[CircleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CircleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c.\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Diamond]", Cell[BoxData[
         ButtonBox["\\[Diamond]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Diamond"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dia\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CenterDot]", Cell[BoxData[
         ButtonBox["\\[CenterDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CenterDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[".\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Star]", Cell[BoxData[
         ButtonBox["\\[Star]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Star"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["star\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[VerticalTilde]", Cell[BoxData[
         ButtonBox["\\[VerticalTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalTilde"]], 
         "InlineCharacterName"], ""},
       {"\[Backslash]", Cell[BoxData[
         ButtonBox["\\[Backslash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Backslash"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["\\\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Wedge]", Cell[BoxData[
         ButtonBox["\\[Wedge]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Vee]", Cell[BoxData[
         ButtonBox["\\[Vee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["v\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Union]", Cell[BoxData[
         ButtonBox["\\[Union]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Union"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["un\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UnionPlus]", Cell[BoxData[
         ButtonBox["\\[UnionPlus]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UnionPlus"]], 
         "InlineCharacterName"], ""},
       {"\[Intersection]", Cell[BoxData[
         ButtonBox["\\[Intersection]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Intersection"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["inter\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SquareIntersection]", Cell[BoxData[
         ButtonBox["\\[SquareIntersection]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SquareIntersection"]], 
         "InlineCharacterName"], ""},
       {"\[SquareUnion]", Cell[BoxData[
         ButtonBox["\\[SquareUnion]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SquareUnion"]], 
         "InlineCharacterName"], ""},
       {"\[Coproduct]", Cell[BoxData[
         ButtonBox["\\[Coproduct]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Coproduct"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["coprod\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Cap]", Cell[BoxData[
         ButtonBox["\\[Cap]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Cap"]], "InlineCharacterName"], 
        ""},
       {"\[Cup]", Cell[BoxData[
         ButtonBox["\\[Cup]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Cup"]], "InlineCharacterName"], 
        ""},
       {"\[Square]", Cell[BoxData[
         ButtonBox["\\[Square]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Square"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sq\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->12382],

Cell[TextData[{
 "Operators typically used to represent actions. All the operators except \
\[Backslash]",
 StyleBox["[Square]", "InlineCode"],
 " are infix. "
}], "Caption",
 CellID->17421],

Cell[TextData[{
 "Following ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s usual convention, all the operators in the table above \
are interpreted to give functions whose names are exactly the names of the \
characters that appear in the operators. "
}], "Text",
 CellID->18716],

Cell["\<\
The operators are interpreted as functions with corresponding names. \
\>", "MathCaption",
 CellID->19718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "\[CirclePlus]", " ", 
   RowBox[{"y", " ", "\[Cap]", " ", "z"}]}], "//", "FullForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19895],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"CirclePlus", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Cap", "[", 
      RowBox[{"y", ",", "z"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->131609879]
}, Open  ]],

Cell[TextData[{
 "All the operators in the table above, except for ",
 Cell[BoxData["\[Square]"], "InlineMath"],
 ", are infix, so that they must appear in between their operands. "
}], "Text",
 CellID->21726]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bracketing Operators", "Section",
 CellID->14771],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[LeftFloor]", Cell[BoxData[
         ButtonBox["\\[LeftFloor]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftFloor"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["lf\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RightFloor]", Cell[BoxData[
         ButtonBox["\\[RightFloor]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightFloor"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["rf\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftCeiling]", Cell[BoxData[
         ButtonBox["\\[LeftCeiling]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftCeiling"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["lc\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RightCeiling]", Cell[BoxData[
         ButtonBox["\\[RightCeiling]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightCeiling"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["rc\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftDoubleBracket]", Cell[BoxData[
         ButtonBox["\\[LeftDoubleBracket]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftDoubleBracket"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["[[\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RightDoubleBracket]", Cell[BoxData[
         ButtonBox["\\[RightDoubleBracket]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightDoubleBracket"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["]]\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[LeftAngleBracket]", Cell[BoxData[
         ButtonBox["\\[LeftAngleBracket]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftAngleBracket"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RightAngleBracket]", Cell[BoxData[
         ButtonBox["\\[RightAngleBracket]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightAngleBracket"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[">\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftBracketingBar]", Cell[BoxData[
         ButtonBox["\\[LeftBracketingBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftBracketingBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["l|\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RightBracketingBar]", Cell[BoxData[
         ButtonBox["\\[RightBracketingBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightBracketingBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["r|\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftDoubleBracketingBar]", Cell[BoxData[
         ButtonBox["\\[LeftDoubleBracketingBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftDoubleBracketingBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["l||\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RightDoubleBracketingBar]", Cell[BoxData[
         ButtonBox["\\[RightDoubleBracketingBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightDoubleBracketingBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["r||\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->11538],

Cell["Characters used as bracketing operators. ", "Caption",
 CellID->1869],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[LeftFloor]", 
     StyleBox["x", "TI"], "\[RightFloor]"}], 
    RowBox[{
     ButtonBox["Floor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Floor"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    RowBox[{"\[LeftCeiling]", 
     StyleBox["x", "TI"], "\[RightCeiling]"}], 
    RowBox[{
     ButtonBox["Ceiling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ceiling"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    RowBox[{
     StyleBox["m", "TI"], "\[LeftDoubleBracket]", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "\[RightDoubleBracket]"}], 
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{"\[LeftAngleBracket]", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "\[RightAngleBracket]"}], 
    RowBox[{
     ButtonBox["AngleBracket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AngleBracket"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{"\[LeftBracketingBar]", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "\[RightBracketingBar]"}], 
    RowBox[{
     ButtonBox["BracketingBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BracketingBar"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{"\[LeftDoubleBracketingBar]", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "\[RightDoubleBracketingBar]"}], 
    RowBox[{
     ButtonBox["DoubleBracketingBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DoubleBracketingBar"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19912],

Cell["Interpretations of bracketing operators. ", "Caption",
 CellID->25667]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operators Used to Represent Relations", "Section",
 CellID->26299],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Equal]", Cell[BoxData[
         ButtonBox["\\[Equal]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Equal"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["==\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LongEqual]", Cell[BoxData[
         ButtonBox["\\[LongEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LongEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["l=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Congruent]", Cell[BoxData[
         ButtonBox["\\[Congruent]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Congruent"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["===\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Tilde]", Cell[BoxData[
         ButtonBox["\\[Tilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Tilde"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[TildeTilde]", Cell[BoxData[
         ButtonBox["\\[TildeTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/TildeTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["~"], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[TildeEqual]", Cell[BoxData[
         ButtonBox["\\[TildeEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/TildeEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["~"], "InlineFormula"],
         StyleBox["=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[TildeFullEqual]", Cell[BoxData[
         ButtonBox["\\[TildeFullEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/TildeFullEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["~"], "InlineFormula"],
         StyleBox["==\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EqualTilde]", Cell[BoxData[
         ButtonBox["\\[EqualTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EqualTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["="], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[HumpEqual]", Cell[BoxData[
         ButtonBox["\\[HumpEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HumpEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["h=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[HumpDownHump]", Cell[BoxData[
         ButtonBox["\\[HumpDownHump]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HumpDownHump"]], 
         "InlineCharacterName"], ""},
       {"\[CupCap]", Cell[BoxData[
         ButtonBox["\\[CupCap]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CupCap"]], "InlineCharacterName"],
         ""},
       {"\[DotEqual]", Cell[BoxData[
         ButtonBox["\\[DotEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DotEqual"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[NotEqual]", Cell[BoxData[
         ButtonBox["\\[NotEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotCongruent]", Cell[BoxData[
         ButtonBox["\\[NotCongruent]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotCongruent"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!===\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotTilde]", Cell[BoxData[
         ButtonBox["\\[NotTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["!"], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[NotTildeTilde]", Cell[BoxData[
         ButtonBox["\\[NotTildeTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotTildeTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["!"], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[NotTildeEqual]", Cell[BoxData[
         ButtonBox["\\[NotTildeEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotTildeEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["!"], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "=\[AliasIndicator]"
        }], "TableText"]},
       {"\[NotTildeFullEqual]", Cell[BoxData[
         ButtonBox["\\[NotTildeFullEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotTildeFullEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["!"], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "==\[AliasIndicator]"
        }], "TableText"]},
       {"\[NotEqualTilde]", Cell[BoxData[
         ButtonBox["\\[NotEqualTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotEqualTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["!="], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[NotHumpEqual]", Cell[BoxData[
         ButtonBox["\\[NotHumpEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotHumpEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!h=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotHumpDownHump]", Cell[BoxData[
         ButtonBox["\\[NotHumpDownHump]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotHumpDownHump"]], 
         "InlineCharacterName"], ""},
       {"\[NotCupCap]", Cell[BoxData[
         ButtonBox["\\[NotCupCap]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotCupCap"]], 
         "InlineCharacterName"], ""},
       {"\[Proportional]", Cell[BoxData[
         ButtonBox["\\[Proportional]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Proportional"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["prop\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Proportion]", Cell[BoxData[
         ButtonBox["\\[Proportion]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Proportion"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->17035],

Cell["\<\
Operators usually used to represent similarity or equivalence. \
\>", "Caption",
 CellID->9894],

Cell[TextData[{
 "The special character ",
 Cell[BoxData["\[Equal]"], "InlineMath"],
 " (or ",
 ButtonBox["\[Backslash][Equal]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Equal"],
 ") is an alternative input form for ",
 Cell[BoxData["=="], "InlineFormula"],
 ". ",
 Cell[BoxData["\[NotEqual]"], "InlineMath"],
 "\[NonBreakingSpace]is used both for input and output. "
}], "MathCaption",
 CellID->28703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "==", "b"}], ",", 
   RowBox[{"a", " ", "\[Equal]", " ", "b"}], ",", 
   RowBox[{"a", "!=", "b"}], ",", 
   RowBox[{"a", " ", "\[NotEqual]", " ", "b"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23811],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Equal]", "b"}], ",", 
   RowBox[{"a", "\[Equal]", "b"}], ",", 
   RowBox[{"a", "\[NotEqual]", "b"}], ",", 
   RowBox[{"a", "\[NotEqual]", "b"}]}], "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->59079943]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[GreaterEqual]", Cell[BoxData[
         ButtonBox["\\[GreaterEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[">=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LessEqual]", Cell[BoxData[
         ButtonBox["\\[LessEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GreaterSlantEqual]", Cell[BoxData[
         ButtonBox["\\[GreaterSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterSlantEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[">/\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LessSlantEqual]", Cell[BoxData[
         ButtonBox["\\[LessSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessSlantEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["</\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GreaterFullEqual]", Cell[BoxData[
         ButtonBox["\\[GreaterFullEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterFullEqual"]], 
         "InlineCharacterName"], ""},
       {"\[LessFullEqual]", Cell[BoxData[
         ButtonBox["\\[LessFullEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessFullEqual"]], 
         "InlineCharacterName"], ""},
       {"\[GreaterTilde]", Cell[BoxData[
         ButtonBox["\\[GreaterTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData[">"], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[LessTilde]", Cell[BoxData[
         ButtonBox["\\[LessTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData["<"], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[GreaterGreater]", Cell[BoxData[
         ButtonBox["\\[GreaterGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterGreater"]], 
         "InlineCharacterName"], ""},
       {"\[LessLess]", Cell[BoxData[
         ButtonBox["\\[LessLess]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessLess"]], 
         "InlineCharacterName"], ""},
       {"\[NestedGreaterGreater]", Cell[BoxData[
         ButtonBox["\\[NestedGreaterGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NestedGreaterGreater"]], 
         "InlineCharacterName"], ""},
       {"\[NestedLessLess]", Cell[BoxData[
         ButtonBox["\\[NestedLessLess]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NestedLessLess"]], 
         "InlineCharacterName"], ""},
       {"\[GreaterLess]", Cell[BoxData[
         ButtonBox["\\[GreaterLess]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterLess"]], 
         "InlineCharacterName"], ""},
       {"\[LessGreater]", Cell[BoxData[
         ButtonBox["\\[LessGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessGreater"]], 
         "InlineCharacterName"], ""},
       {"\[GreaterEqualLess]", Cell[BoxData[
         ButtonBox["\\[GreaterEqualLess]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterEqualLess"]], 
         "InlineCharacterName"], ""},
       {"\[LessEqualGreater]", Cell[BoxData[
         ButtonBox["\\[LessEqualGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessEqualGreater"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[NotGreaterEqual]", Cell[BoxData[
         ButtonBox["\\[NotGreaterEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotGreaterEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!>=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotLessEqual]", Cell[BoxData[
         ButtonBox["\\[NotLessEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLessEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!<=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotGreaterSlantEqual]", Cell[BoxData[
         ButtonBox["\\[NotGreaterSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotGreaterSlantEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!>/\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotLessSlantEqual]", Cell[BoxData[
         ButtonBox["\\[NotLessSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLessSlantEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!</\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotGreaterFullEqual]", Cell[BoxData[
         ButtonBox["\\[NotGreaterFullEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotGreaterFullEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotLessFullEqual]", Cell[BoxData[
         ButtonBox["\\[NotLessFullEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLessFullEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotGreaterTilde]", Cell[BoxData[
         ButtonBox["\\[NotGreaterTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotGreaterTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData[
          RowBox[{"!", ">"}]], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[NotLessTilde]", Cell[BoxData[
         ButtonBox["\\[NotLessTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLessTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData[
          RowBox[{"!", "<"}]], "InlineFormula"],
         Cell[BoxData["~"], "InlineFormula"],
         "\[AliasIndicator]"
        }], "TableText"]},
       {"\[NotGreaterGreater]", Cell[BoxData[
         ButtonBox["\\[NotGreaterGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotGreaterGreater"]], 
         "InlineCharacterName"], ""},
       {"\[NotLessLess]", Cell[BoxData[
         ButtonBox["\\[NotLessLess]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLessLess"]], 
         "InlineCharacterName"], ""},
       {"\[NotNestedGreaterGreater]", Cell[BoxData[
         ButtonBox["\\[NotNestedGreaterGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotNestedGreaterGreater"]], 
         "InlineCharacterName"], ""},
       {"\[NotNestedLessLess]", Cell[BoxData[
         ButtonBox["\\[NotNestedLessLess]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotNestedLessLess"]], 
         "InlineCharacterName"], ""},
       {"\[NotGreaterLess]", Cell[BoxData[
         ButtonBox["\\[NotGreaterLess]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotGreaterLess"]], 
         "InlineCharacterName"], ""},
       {"\[NotLessGreater]", Cell[BoxData[
         ButtonBox["\\[NotLessGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLessGreater"]], 
         "InlineCharacterName"], ""},
       {"\[NotGreater]", Cell[BoxData[
         ButtonBox["\\[NotGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotGreater"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotLess]", Cell[BoxData[
         ButtonBox["\\[NotLess]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLess"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!<\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->30333],

Cell["Operators usually used for ordering by magnitude. ", "Caption",
 CellID->17673],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Subset]", Cell[BoxData[
         ButtonBox["\\[Subset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Subset"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sub\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Superset]", Cell[BoxData[
         ButtonBox["\\[Superset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Superset"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sup\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SubsetEqual]", Cell[BoxData[
         ButtonBox["\\[SubsetEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SubsetEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sub=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SupersetEqual]", Cell[BoxData[
         ButtonBox["\\[SupersetEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SupersetEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sup=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Element]", Cell[BoxData[
         ButtonBox["\\[Element]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Element"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["el\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ReverseElement]", Cell[BoxData[
         ButtonBox["\\[ReverseElement]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ReverseElement"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["mem\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[NotSubset]", Cell[BoxData[
         ButtonBox["\\[NotSubset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSubset"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!sub\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotSuperset]", Cell[BoxData[
         ButtonBox["\\[NotSuperset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSuperset"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!sup\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotSubsetEqual]", Cell[BoxData[
         ButtonBox["\\[NotSubsetEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSubsetEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!sub=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotSupersetEqual]", Cell[BoxData[
         ButtonBox["\\[NotSupersetEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSupersetEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!sup=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotElement]", Cell[BoxData[
         ButtonBox["\\[NotElement]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotElement"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!el\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotReverseElement]", Cell[BoxData[
         ButtonBox["\\[NotReverseElement]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotReverseElement"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!mem\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->4664],

Cell["Operators used for relations in sets. ", "Caption",
 CellID->15141],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[Succeeds]", Cell[BoxData[
         ButtonBox["\\[Succeeds]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Succeeds"]], 
         "InlineCharacterName"], ""},
       {"\[Precedes]", Cell[BoxData[
         ButtonBox["\\[Precedes]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Precedes"]], 
         "InlineCharacterName"], ""},
       {"\[SucceedsEqual]", Cell[BoxData[
         ButtonBox["\\[SucceedsEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SucceedsEqual"]], 
         "InlineCharacterName"], ""},
       {"\[PrecedesEqual]", Cell[BoxData[
         ButtonBox["\\[PrecedesEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/PrecedesEqual"]], 
         "InlineCharacterName"], ""},
       {"\[SucceedsSlantEqual]", Cell[BoxData[
         ButtonBox["\\[SucceedsSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SucceedsSlantEqual"]], 
         "InlineCharacterName"], ""},
       {"\[PrecedesSlantEqual]", Cell[BoxData[
         ButtonBox["\\[PrecedesSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/PrecedesSlantEqual"]], 
         "InlineCharacterName"], ""},
       {"\[SucceedsTilde]", Cell[BoxData[
         ButtonBox["\\[SucceedsTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SucceedsTilde"]], 
         "InlineCharacterName"], ""},
       {"\[PrecedesTilde]", Cell[BoxData[
         ButtonBox["\\[PrecedesTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/PrecedesTilde"]], 
         "InlineCharacterName"], ""},
       {"\[RightTriangle]", Cell[BoxData[
         ButtonBox["\\[RightTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[LeftTriangle]", Cell[BoxData[
         ButtonBox["\\[LeftTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[RightTriangleEqual]", Cell[BoxData[
         ButtonBox["\\[RightTriangleEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTriangleEqual"]], 
         "InlineCharacterName"], ""},
       {"\[LeftTriangleEqual]", Cell[BoxData[
         ButtonBox["\\[LeftTriangleEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftTriangleEqual"]], 
         "InlineCharacterName"], ""},
       {"\[RightTriangleBar]", Cell[BoxData[
         ButtonBox["\\[RightTriangleBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTriangleBar"]], 
         "InlineCharacterName"], ""},
       {"\[LeftTriangleBar]", Cell[BoxData[
         ButtonBox["\\[LeftTriangleBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftTriangleBar"]], 
         "InlineCharacterName"], ""},
       {"\[SquareSuperset]", Cell[BoxData[
         ButtonBox["\\[SquareSuperset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SquareSuperset"]], 
         "InlineCharacterName"], ""},
       {"\[SquareSubset]", Cell[BoxData[
         ButtonBox["\\[SquareSubset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SquareSubset"]], 
         "InlineCharacterName"], ""},
       {"\[SquareSupersetEqual]", Cell[BoxData[
         ButtonBox["\\[SquareSupersetEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SquareSupersetEqual"]], 
         "InlineCharacterName"], ""},
       {"\[SquareSubsetEqual]", Cell[BoxData[
         ButtonBox["\\[SquareSubsetEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SquareSubsetEqual"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[NotSucceeds]", Cell[BoxData[
         ButtonBox["\\[NotSucceeds]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSucceeds"]], 
         "InlineCharacterName"], ""},
       {"\[NotPrecedes]", Cell[BoxData[
         ButtonBox["\\[NotPrecedes]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotPrecedes"]], 
         "InlineCharacterName"], ""},
       {"\[NotSucceedsEqual]", Cell[BoxData[
         ButtonBox["\\[NotSucceedsEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSucceedsEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotPrecedesTilde]", Cell[BoxData[
         ButtonBox["\\[NotPrecedesTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotPrecedesTilde"]], 
         "InlineCharacterName"], ""},
       {"\[NotSucceedsSlantEqual]", Cell[BoxData[
         ButtonBox["\\[NotSucceedsSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSucceedsSlantEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotPrecedesSlantEqual]", Cell[BoxData[
         ButtonBox["\\[NotPrecedesSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotPrecedesSlantEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotSucceedsTilde]", Cell[BoxData[
         ButtonBox["\\[NotSucceedsTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSucceedsTilde"]], 
         "InlineCharacterName"], ""},
       {"\[NotPrecedesEqual]", Cell[BoxData[
         ButtonBox["\\[NotPrecedesEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotPrecedesEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotRightTriangle]", Cell[BoxData[
         ButtonBox["\\[NotRightTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotRightTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[NotLeftTriangle]", Cell[BoxData[
         ButtonBox["\\[NotLeftTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLeftTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[NotRightTriangleEqual]", Cell[BoxData[
         ButtonBox["\\[NotRightTriangleEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotRightTriangleEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotLeftTriangleEqual]", Cell[BoxData[
         ButtonBox["\\[NotLeftTriangleEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLeftTriangleEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotRightTriangleBar]", Cell[BoxData[
         ButtonBox["\\[NotRightTriangleBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotRightTriangleBar"]], 
         "InlineCharacterName"], ""},
       {"\[NotLeftTriangleBar]", Cell[BoxData[
         ButtonBox["\\[NotLeftTriangleBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotLeftTriangleBar"]], 
         "InlineCharacterName"], ""},
       {"\[NotSquareSuperset]", Cell[BoxData[
         ButtonBox["\\[NotSquareSuperset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSquareSuperset"]], 
         "InlineCharacterName"], ""},
       {"\[NotSquareSubset]", Cell[BoxData[
         ButtonBox["\\[NotSquareSubset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSquareSubset"]], 
         "InlineCharacterName"], ""},
       {"\[NotSquareSupersetEqual]", Cell[BoxData[
         ButtonBox["\\[NotSquareSupersetEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSquareSupersetEqual"]], 
         "InlineCharacterName"], ""},
       {"\[NotSquareSubsetEqual]", Cell[BoxData[
         ButtonBox["\\[NotSquareSubsetEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotSquareSubsetEqual"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->7711],

Cell["Operators usually used for other kinds of orderings. ", "Caption",
 CellID->28253],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[VerticalBar]", Cell[BoxData[
         ButtonBox["\\[VerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         "\[SpaceIndicator]",
         StyleBox["|\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleVerticalBar]", Cell[BoxData[
         ButtonBox["\\[DoubleVerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleVerticalBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         "\[SpaceIndicator]",
         StyleBox["||\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[NotVerticalBar]", Cell[BoxData[
         ButtonBox["\\[NotVerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotVerticalBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!|\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotDoubleVerticalBar]", Cell[BoxData[
         ButtonBox["\\[NotDoubleVerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotDoubleVerticalBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!||\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->6868],

Cell["Relational operators based on vertical bars. ", "Caption",
 CellID->25547]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operators Based on Arrows and Vectors", "Section",
 CellID->27644],

Cell["\<\
Operators based on arrows are often used in pure mathematics and elsewhere to \
represent various kinds of transformations or changes. \
\>", "Text",
 CellID->32662],

Cell[TextData[{
 Cell[BoxData["\[Rule]"], "InlineMath"],
 " is equivalent to ",
 Cell[BoxData["->"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "/.", 
  RowBox[{"x", " ", "\[Rule]", " ", "3"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->20037],

Cell[BoxData[
 RowBox[{"3", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->819157087]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Rule]", Cell[BoxData[
         ButtonBox["\\[Rule]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["->\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RuleDelayed]", Cell[BoxData[
         ButtonBox["\\[RuleDelayed]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RuleDelayed"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[":>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Implies]", Cell[BoxData[
         ButtonBox["\\[Implies]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Implies"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["=>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RoundImplies]", Cell[BoxData[
         ButtonBox["\\[RoundImplies]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RoundImplies"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->8723],

Cell[TextData[{
 "Arrow\[Hyphen]like operators with built\[Hyphen]in meanings in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->9741],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[RightArrow]", Cell[BoxData[
         ButtonBox["\\[RightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         "\[SpaceIndicator]",
         StyleBox["->\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftArrow]", Cell[BoxData[
         ButtonBox["\\[LeftArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftRightArrow]", Cell[BoxData[
         ButtonBox["\\[LeftRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<->\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LongRightArrow]", Cell[BoxData[
         ButtonBox["\\[LongRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LongRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["-->\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LongLeftArrow]", Cell[BoxData[
         ButtonBox["\\[LongLeftArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LongLeftArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<--\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LongLeftRightArrow]", Cell[BoxData[
         ButtonBox["\\[LongLeftRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LongLeftRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<-->\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ShortRightArrow]", Cell[BoxData[
         ButtonBox["\\[ShortRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ShortRightArrow"]], 
         "InlineCharacterName"], ""},
       {"\[ShortLeftArrow]", Cell[BoxData[
         ButtonBox["\\[ShortLeftArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ShortLeftArrow"]], 
         "InlineCharacterName"], ""},
       {"\[RightTeeArrow]", Cell[BoxData[
         ButtonBox["\\[RightTeeArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTeeArrow"]], 
         "InlineCharacterName"], ""},
       {"\[LeftTeeArrow]", Cell[BoxData[
         ButtonBox["\\[LeftTeeArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftTeeArrow"]], 
         "InlineCharacterName"], ""},
       {"\[RightArrowBar]", Cell[BoxData[
         ButtonBox["\\[RightArrowBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightArrowBar"]], 
         "InlineCharacterName"], ""},
       {"\[LeftArrowBar]", Cell[BoxData[
         ButtonBox["\\[LeftArrowBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftArrowBar"]], 
         "InlineCharacterName"], ""},
       {"\[DoubleRightArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         "\[SpaceIndicator]",
         StyleBox["=>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleLeftArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleLeftArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleLeftArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         "\[SpaceIndicator]",
         StyleBox["<=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleLeftRightArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleLeftRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleLeftRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<=>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleLongRightArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleLongRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleLongRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["==>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleLongLeftArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleLongLeftArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleLongLeftArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<==\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleLongLeftRightArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleLongLeftRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleLongLeftRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<==>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[UpArrow]", Cell[BoxData[
         ButtonBox["\\[UpArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpArrow"]], 
         "InlineCharacterName"], ""},
       {"\[DownArrow]", Cell[BoxData[
         ButtonBox["\\[DownArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownArrow"]], 
         "InlineCharacterName"], ""},
       {"\[UpDownArrow]", Cell[BoxData[
         ButtonBox["\\[UpDownArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpDownArrow"]], 
         "InlineCharacterName"], ""},
       {"\[UpTeeArrow]", Cell[BoxData[
         ButtonBox["\\[UpTeeArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpTeeArrow"]], 
         "InlineCharacterName"], ""},
       {"\[DownTeeArrow]", Cell[BoxData[
         ButtonBox["\\[DownTeeArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownTeeArrow"]], 
         "InlineCharacterName"], ""},
       {"\[UpArrowBar]", Cell[BoxData[
         ButtonBox["\\[UpArrowBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpArrowBar"]], 
         "InlineCharacterName"], ""},
       {"\[DownArrowBar]", Cell[BoxData[
         ButtonBox["\\[DownArrowBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownArrowBar"]], 
         "InlineCharacterName"], ""},
       {"\[DoubleUpArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleUpArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleUpArrow"]], 
         "InlineCharacterName"], ""},
       {"\[DoubleDownArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleDownArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleDownArrow"]], 
         "InlineCharacterName"], ""},
       {"\[DoubleUpDownArrow]", Cell[BoxData[
         ButtonBox["\\[DoubleUpDownArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleUpDownArrow"]], 
         "InlineCharacterName"], ""},
       {"\[RightArrowLeftArrow]", Cell[BoxData[
         ButtonBox["\\[RightArrowLeftArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightArrowLeftArrow"]], 
         "InlineCharacterName"], ""},
       {"\[LeftArrowRightArrow]", Cell[BoxData[
         ButtonBox["\\[LeftArrowRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftArrowRightArrow"]], 
         "InlineCharacterName"], ""},
       {"\[UpArrowDownArrow]", Cell[BoxData[
         ButtonBox["\\[UpArrowDownArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpArrowDownArrow"]], 
         "InlineCharacterName"], ""},
       {"\[DownArrowUpArrow]", Cell[BoxData[
         ButtonBox["\\[DownArrowUpArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownArrowUpArrow"]], 
         "InlineCharacterName"], ""},
       {"\[LowerRightArrow]", Cell[BoxData[
         ButtonBox["\\[LowerRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LowerRightArrow"]], 
         "InlineCharacterName"], ""},
       {"\[LowerLeftArrow]", Cell[BoxData[
         ButtonBox["\\[LowerLeftArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LowerLeftArrow"]], 
         "InlineCharacterName"], ""},
       {"\[UpperLeftArrow]", Cell[BoxData[
         ButtonBox["\\[UpperLeftArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpperLeftArrow"]], 
         "InlineCharacterName"], ""},
       {"\[UpperRightArrow]", Cell[BoxData[
         ButtonBox["\\[UpperRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpperRightArrow"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->27529],

Cell["Ordinary arrows. ", "Caption",
 CellID->778],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[RightVector]", Cell[BoxData[
         ButtonBox["\\[RightVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightVector"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["vec\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftVector]", Cell[BoxData[
         ButtonBox["\\[LeftVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftVector"]], 
         "InlineCharacterName"], ""},
       {"\[LeftRightVector]", Cell[BoxData[
         ButtonBox["\\[LeftRightVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftRightVector"]], 
         "InlineCharacterName"], ""},
       {"\[DownRightVector]", Cell[BoxData[
         ButtonBox["\\[DownRightVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownRightVector"]], 
         "InlineCharacterName"], ""},
       {"\[DownLeftVector]", Cell[BoxData[
         ButtonBox["\\[DownLeftVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownLeftVector"]], 
         "InlineCharacterName"], ""},
       {"\[DownLeftRightVector]", Cell[BoxData[
         ButtonBox["\\[DownLeftRightVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownLeftRightVector"]], 
         "InlineCharacterName"], ""},
       {"\[RightTeeVector]", Cell[BoxData[
         ButtonBox["\\[RightTeeVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTeeVector"]], 
         "InlineCharacterName"], ""},
       {"\[LeftTeeVector]", Cell[BoxData[
         ButtonBox["\\[LeftTeeVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftTeeVector"]], 
         "InlineCharacterName"], ""},
       {"\[DownRightTeeVector]", Cell[BoxData[
         ButtonBox["\\[DownRightTeeVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownRightTeeVector"]], 
         "InlineCharacterName"], ""},
       {"\[DownLeftTeeVector]", Cell[BoxData[
         ButtonBox["\\[DownLeftTeeVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownLeftTeeVector"]], 
         "InlineCharacterName"], ""},
       {"\[RightVectorBar]", Cell[BoxData[
         ButtonBox["\\[RightVectorBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightVectorBar"]], 
         "InlineCharacterName"], ""},
       {"\[LeftVectorBar]", Cell[BoxData[
         ButtonBox["\\[LeftVectorBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftVectorBar"]], 
         "InlineCharacterName"], ""},
       {"\[DownRightVectorBar]", Cell[BoxData[
         ButtonBox["\\[DownRightVectorBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownRightVectorBar"]], 
         "InlineCharacterName"], ""},
       {"\[DownLeftVectorBar]", Cell[BoxData[
         ButtonBox["\\[DownLeftVectorBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownLeftVectorBar"]], 
         "InlineCharacterName"], ""},
       {"\[Equilibrium]", Cell[BoxData[
         ButtonBox["\\[Equilibrium]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Equilibrium"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["equi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ReverseEquilibrium]", Cell[BoxData[
         ButtonBox["\\[ReverseEquilibrium]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ReverseEquilibrium"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[LeftUpVector]", Cell[BoxData[
         ButtonBox["\\[LeftUpVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftUpVector"]], 
         "InlineCharacterName"], ""},
       {"\[LeftDownVector]", Cell[BoxData[
         ButtonBox["\\[LeftDownVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftDownVector"]], 
         "InlineCharacterName"], ""},
       {"\[LeftUpDownVector]", Cell[BoxData[
         ButtonBox["\\[LeftUpDownVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftUpDownVector"]], 
         "InlineCharacterName"], ""},
       {"\[RightUpVector]", Cell[BoxData[
         ButtonBox["\\[RightUpVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightUpVector"]], 
         "InlineCharacterName"], ""},
       {"\[RightDownVector]", Cell[BoxData[
         ButtonBox["\\[RightDownVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightDownVector"]], 
         "InlineCharacterName"], ""},
       {"\[RightUpDownVector]", Cell[BoxData[
         ButtonBox["\\[RightUpDownVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightUpDownVector"]], 
         "InlineCharacterName"], ""},
       {"\[LeftUpTeeVector]", Cell[BoxData[
         ButtonBox["\\[LeftUpTeeVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftUpTeeVector"]], 
         "InlineCharacterName"], ""},
       {"\[LeftDownTeeVector]", Cell[BoxData[
         ButtonBox["\\[LeftDownTeeVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftDownTeeVector"]], 
         "InlineCharacterName"], ""},
       {"\[RightUpTeeVector]", Cell[BoxData[
         ButtonBox["\\[RightUpTeeVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightUpTeeVector"]], 
         "InlineCharacterName"], ""},
       {"\[RightDownTeeVector]", Cell[BoxData[
         ButtonBox["\\[RightDownTeeVector]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightDownTeeVector"]], 
         "InlineCharacterName"], ""},
       {"\[LeftUpVectorBar]", Cell[BoxData[
         ButtonBox["\\[LeftUpVectorBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftUpVectorBar"]], 
         "InlineCharacterName"], ""},
       {"\[LeftDownVectorBar]", Cell[BoxData[
         ButtonBox["\\[LeftDownVectorBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftDownVectorBar"]], 
         "InlineCharacterName"], ""},
       {"\[RightUpVectorBar]", Cell[BoxData[
         ButtonBox["\\[RightUpVectorBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightUpVectorBar"]], 
         "InlineCharacterName"], ""},
       {"\[RightDownVectorBar]", Cell[BoxData[
         ButtonBox["\\[RightDownVectorBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightDownVectorBar"]], 
         "InlineCharacterName"], ""},
       {"\[UpEquilibrium]", Cell[BoxData[
         ButtonBox["\\[UpEquilibrium]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpEquilibrium"]], 
         "InlineCharacterName"], ""},
       {"\[ReverseUpEquilibrium]", Cell[BoxData[
         ButtonBox["\\[ReverseUpEquilibrium]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ReverseUpEquilibrium"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->12316],

Cell["Vectors and related arrows. ", "Caption",
 CellID->3035],

Cell[TextData[{
 "All the arrow and vector\[Hyphen]like operators in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are infix. "
}], "MathCaption",
 CellID->22190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "\[Equilibrium]", " ", 
  RowBox[{"y", " ", "\[UpEquilibrium]", " ", "z"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1842],

Cell[BoxData[
 RowBox[{"x", "\[Equilibrium]", 
  RowBox[{"y", "\[UpEquilibrium]", "z"}]}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->55500292]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[RightTee]", Cell[BoxData[
         ButtonBox["\\[RightTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTee"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["rT\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftTee]", Cell[BoxData[
         ButtonBox["\\[LeftTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftTee"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["lT\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UpTee]", Cell[BoxData[
         ButtonBox["\\[UpTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpTee"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["uT\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DownTee]", Cell[BoxData[
         ButtonBox["\\[DownTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownTee"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dT\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[DoubleRightTee]", Cell[BoxData[
         ButtonBox["\\[DoubleRightTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleRightTee"]], 
         "InlineCharacterName"], ""},
       {"\[DoubleLeftTee]", Cell[BoxData[
         ButtonBox["\\[DoubleLeftTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleLeftTee"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->30106],

Cell["Tees. ", "Caption",
 CellID->9040],

Cell[TextData[ButtonBox["Mathematical and Other Notation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "RelatedTutorials",\

 CellID->5715683]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Operators - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical and Other Notation", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LettersAndLetterLikeForms#6089"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Operators#29358"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 32.2927306}", "context" -> "", 
    "keywords" -> {
     "absolute value", "and bar", "angle bracket", "approximately equal", 
      "\\approx (TeX)", "arrow characters", "\\asymp (TeX)", "asymptotic", 
      "asymptotically equal", "backslash", "\\backslash (TeX)", 
      "backtab indicator", "backtab character", "bar", "barbed arrow", 
      "because", "bent brackets", "\\bigcap (TeX)", "\\bigcup (TeX)", 
      "\\biguplus (TeX)", "\\bot (TeX)", "bra", "Bullseye", "\\bumpeq (TeX)", 
      "cap", "cap product", "cap symbol", "\\cap (TeX)", "caret", 
      "\\cdot (TeX)", "CenterDot", "\\centerdot (TeX)", "CircleDot", 
      "CircleMinus", "CirclePlus", "CircleTimes", "composition", "congruent", 
      "\\cong (TeX)", "ContourIntegral", "convolution", "\\coprod (TeX)", 
      "Coproduct", "corner bracket", "cup", "CupCap", "cup product", 
      "cup symbol", "\\cup (TeX)", "dagger", "d'Alembertian", "dAlembertian", 
      "d'Alembert", "\\dashv (TeX)", "delimiter characters", "determinants", 
      "\\diagdown (TeX)", "diamond", "direct product", "direct sum", 
      "divisible", "\\div (TeX)", "dominates", "\\doteq (TeX)", "DotEqual", 
      "DoubleDownArrow", "DoubleLeftArrow", "DoubleLeftRightArrow", 
      "DoubleLongLeftArrow", "DoubleLongLeftRightArrow", 
      "DoubleLongRightArrow", "DoubleRightArrow", "DoubleRightTee", 
      "DoubleUpArrow", "DoubleUpDownArrow", "DoubleVerticalBar", "DownArrow", 
      "\\downarrow (TeX)", "\\Downarrow (TeX)", "empty bracket", 
      "equivalence", "\\equiv (TeX)", "expected value", "exterior product", 
      "fence", "\\frown (TeX)", "gatepost", "\\geq (TeX)", "\\ge (TeX)", 
      "\\gets (TeX)", "\\gg (TeX)", "grad", "GreaterGreater", "GreaterTilde", 
      "\\gtrsim (TeX)", "harpoon", "hence", "homeomorphism", "homotopy", 
      "hook", "HumpEqual", "\\iff (TeX)", "image of", "implies", "integral", 
      "\\in (TeX)", "\\intop (TeX)", "\\int (TeX)", "Ket", "\\land (TeX)", 
      "\\langle (TeX)", "Laplacian", "lattice bottom", "lazy S", 
      "\\lceil (TeX)", "LeftArrow", "LeftArrowBar", "\\leftarrow (TeX)", 
      "\\Leftarrow (TeX)", "LeftBracketingBar", "LeftCeiling", 
      "LeftDoubleBracket", "LeftDoubleBracketingBar", "LeftFloor", 
      "\\leftharpoonup (TeX)", "LeftRightArrow", "\\leftrightarrow (TeX)", 
      "\\Leftrightarrow (TeX)", "LeftTee", "LeftTriangle", 
      "LeftTriangleEqual", "LeftVector", "\\leq (TeX)", "LessLess", 
      "\\lesssim (TeX)", "LessTilde", "\\le (TeX)", "\\lfloor (TeX)", 
      "\\ll (TeX)", "\\lnot (TeX)", "logical and", "logical or", 
      "logic expressions", "LongLeftArrow", "\\longleftarrow (TeX)", 
      "\\Longleftarrow (TeX)", "LongLeftRightArrow", 
      "\\longleftrightarrow (TeX)", "\\Longleftrightarrow (TeX)", 
      "LongRightArrow", "\\longrightarrow (TeX)", "\\Longrightarrow (TeX)", 
      "\\lor (TeX)", "LowerLeftArrow", "LowerRightArrow", "lozenge", 
      "magnitude", "\\mapsto (TeX)", "matching characters", "\\mid (TeX)", 
      "MinusPlus", "models", "\\models (TeX)", "\\mp (TeX)", "Nabla", 
      "\\nabla (TeX)", "\\nearrow (TeX)", "negation", "\\neg (TeX)", 
      "\\neq (TeX)", "\\ne (TeX)", "\\nexists (TeX)", "\\ngeq (TeX)", 
      "\\ngtr (TeX)", "\\ni (TeX)", "\\nleq (TeX)", "\\nless (TeX)", 
      "Nontheorem", "norm", "NotElement", "NotEqual", "NotExists", 
      "NotGreater", "NotGreaterEqual", "\\notin (TeX)", "NotLess", 
      "NotLessEqual", "NotPrecedes", "NotSubsetEqual", "NotSucceeds", 
      "NotSupersetEqual", "\\not (TeX)", "NotTilde", "\\nprec (TeX)", 
      "\\nsim (TeX)", "\\nsubseteq (TeX)", "\\nsucc (TeX)", 
      "\\nsupseteq (TeX)", "\\odot (TeX)", "\\oint (TeX)", "\\ominus (TeX)", 
      "\\oplus (TeX)", "or bar", "ordering", "or underline", "\\otimes (TeX)",
       "\\owns (TeX)", "parallel", "\\partial (TeX)", "perpendicular", 
      "\\perp (TeX)", "PlusMinus", "\\pm (TeX)", "precedes", "PrecedesEqual", 
      "PrecedesTilde", "\\preceq (TeX)", "\\precsim (TeX)", "\\prec (TeX)", 
      "product", "proportional", "\\propto (TeX)", "proves", "quantifiers", 
      "\\rangle (TeX)", "\\rceil (TeX)", "restriction", "ReverseElement", 
      "\\rfloor (TeX)", "RightAngleBracket", "RightArrow", "RightArrowBar", 
      "\\rightarrow (TeX)", "\\Rightarrow (TeX)", "RightCeiling", 
      "RightFloor", "\\rightharpoonup (TeX)", "RightTee", "RightTeeArrow", 
      "RightTriangle", "RightTriangleEqual", "RightVector", "ring", 
      "satisfies", "\\searrow (TeX)", "separator", "sequent", 
      "set difference", "\\setminus (TeX)", "set operations", 
      "Sheffer stroke", "\\simeq (TeX)", "similarity", "\\sim (TeX)", "since",
       "SmallCircle", "\\smile (TeX)", "\\sqcap (TeX)", "\\sqcup (TeX)", 
      "\\sqsubseteq (TeX)", "\\sqsubset (TeX)", "\\sqsupseteq (TeX)", 
      "\\sqsupset (TeX)", "square", "SquareIntersection", "SquareSubset", 
      "SquareSubsetEqual", "SquareSuperset", "SquareSupersetEqual", 
      "SquareUnion", "squiggle", "star", "stile", "stroke", 
      "\\subseteq (TeX)", "SubsetEqual", "succeeds", "SucceedsEqual", 
      "SucceedsTilde", "\\succeq (TeX)", "\\succsim (TeX)", "\\succ (TeX)", 
      "SupersetEqual", "\\supseteq (TeX)", "\\swarrow (TeX)", "tab indicator",
       "tack", "tautology", "tensor product", "therefore", "tilde", 
      "TildeEqual", "TildeFullEqual", "TildeTilde", "\\times (TeX)", 
      "\\to (TeX)", "\\trianglelefteq (TeX)", "\\triangleleft (TeX)", 
      "\\trianglerighteq (TeX)", "\\triangleright (TeX)", "turnstile", 
      "twiddle", "UnionPlus", "UpArrow", "\\uparrow (TeX)", "\\Uparrow (TeX)",
       "UpDownArrow", "\\updownarrow (TeX)", "\\Updownarrow (TeX)", 
      "\\uplus (TeX)", "UpperLeftArrow", "UpperRightArrow", "UpTee", 
      "varies as", "varies with", "\\vdash (TeX)", "vector characters", "Vee",
       "VerticalBar", "VerticalSeparator", "VerticalTilde", "\\vert (TeX)", 
      "\\Vert (TeX)", "wedge", "White bracket", "wiggle", "wreath product", 
      "\\wr (TeX)", "yields"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Some operators used in basic arithmetic and algebra. Note that the x for \
\\[Cross] is distinguished by being drawn slightly smaller than the x for \
\\[Times]. Interpretation of some operators in basic arithmetic and algebra. \
", "synonyms" -> {"3.10.4"}, "title" -> "Operators", "type" -> "Tutorial", 
    "uri" -> "tutorial/Operators"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.10.4"->{
  Cell[2400, 68, 70, 2, 70, "Title",
   CellTags->{"S3.10.4", "4.1"},
   CellID->41]},
 "4.1"->{
  Cell[2400, 68, 70, 2, 70, "Title",
   CellTags->{"S3.10.4", "4.1"},
   CellID->41]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.10.4", 110670, 2865},
 {"4.1", 110767, 2869}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1775, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2400, 68, 70, 2, 70, "Title",
 CellTags->{"S3.10.4", "4.1"},
 CellID->41],
Cell[CellGroupData[{
Cell[2495, 74, 63, 1, 70, "Section",
 CellID->18467],
Cell[2561, 77, 2616, 65, 70, "DoubleBox",
 CellID->6334],
Cell[5180, 144, 88, 1, 70, "Caption",
 CellID->26500],
Cell[5271, 147, 436, 15, 70, "Text",
 CellID->19169],
Cell[5710, 164, 2714, 88, 70, "DefinitionBox3Col",
 CellID->15724],
Cell[8427, 254, 109, 3, 70, "Caption",
 CellID->11478]
}, Open  ]],
Cell[CellGroupData[{
Cell[8573, 262, 68, 1, 70, "Section",
 CellID->29358],
Cell[8644, 265, 3997, 96, 70, "DoubleBox",
 CellID->26962],
Cell[12644, 363, 63, 1, 70, "Caption",
 CellID->24464],
Cell[12710, 366, 2163, 51, 70, "DoubleBox",
 CellID->5705],
Cell[14876, 419, 79, 1, 70, "Caption",
 CellID->28145]
}, Open  ]],
Cell[CellGroupData[{
Cell[14992, 425, 64, 1, 70, "Section",
 CellID->23281],
Cell[15059, 428, 7014, 176, 70, "DoubleBox",
 CellID->16827],
Cell[22076, 606, 73, 1, 70, "Caption",
 CellID->9961],
Cell[22152, 609, 1436, 53, 70, "Text",
 CellID->491],
Cell[23591, 664, 1072, 38, 70, "Text",
 CellID->2995],
Cell[24666, 704, 354, 13, 70, "MathCaption",
 CellID->11942],
Cell[CellGroupData[{
Cell[25045, 721, 215, 7, 70, "Input",
 CellID->4827],
Cell[25263, 730, 263, 9, 36, "Output",
 CellID->972575766]
}, Open  ]],
Cell[25541, 742, 577, 15, 70, "Text",
 CellID->32391],
Cell[26121, 759, 241, 8, 70, "MathCaption",
 CellID->14604],
Cell[CellGroupData[{
Cell[26387, 771, 256, 9, 70, "Input",
 CellID->3902],
Cell[26646, 782, 481, 17, 50, "Output",
 CellID->1582861845]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27176, 805, 68, 1, 70, "Section",
 CellID->292],
Cell[27247, 808, 6738, 167, 70, "DoubleBox",
 CellID->12382],
Cell[33988, 977, 190, 6, 70, "Caption",
 CellID->17421],
Cell[34181, 985, 306, 8, 70, "Text",
 CellID->18716],
Cell[34490, 995, 116, 3, 70, "MathCaption",
 CellID->19718],
Cell[CellGroupData[{
Cell[34631, 1002, 180, 5, 70, "Input",
 CellID->19895],
Cell[34814, 1009, 413, 15, 50, "Output",
 CellID->131609879]
}, Open  ]],
Cell[35242, 1027, 209, 5, 70, "Text",
 CellID->21726]
}, Open  ]],
Cell[CellGroupData[{
Cell[35488, 1037, 55, 1, 70, "Section",
 CellID->14771],
Cell[35546, 1040, 4854, 113, 70, "DoubleBox",
 CellID->11538],
Cell[40403, 1155, 75, 1, 70, "Caption",
 CellID->1869],
Cell[40481, 1158, 2496, 76, 70, "DefinitionBox",
 CellID->19912],
Cell[42980, 1236, 76, 1, 70, "Caption",
 CellID->25667]
}, Open  ]],
Cell[CellGroupData[{
Cell[43093, 1242, 72, 1, 70, "Section",
 CellID->26299],
Cell[43168, 1245, 8465, 209, 70, "DoubleBox",
 CellID->17035],
Cell[51636, 1456, 105, 3, 70, "Caption",
 CellID->9894],
Cell[51744, 1461, 418, 13, 70, "MathCaption",
 CellID->28703],
Cell[CellGroupData[{
Cell[52187, 1478, 266, 8, 70, "Input",
 CellID->23811],
Cell[52456, 1488, 353, 11, 36, "Output",
 CellID->59079943]
}, Open  ]],
Cell[52824, 1502, 9657, 229, 70, "DoubleBox",
 CellID->30333],
Cell[62484, 1733, 85, 1, 70, "Caption",
 CellID->17673],
Cell[62572, 1736, 4704, 113, 70, "DoubleBox",
 CellID->4664],
Cell[67279, 1851, 73, 1, 70, "Caption",
 CellID->15141],
Cell[67355, 1854, 8587, 195, 70, "DoubleBox",
 CellID->7711],
Cell[75945, 2051, 88, 1, 70, "Caption",
 CellID->28253],
Cell[76036, 2054, 2155, 51, 70, "DoubleBox",
 CellID->6868],
Cell[78194, 2107, 80, 1, 70, "Caption",
 CellID->25547]
}, Open  ]],
Cell[CellGroupData[{
Cell[78311, 2113, 72, 1, 70, "Section",
 CellID->27644],
Cell[78386, 2116, 175, 4, 70, "Text",
 CellID->32662],
Cell[78564, 2122, 159, 6, 70, "MathCaption",
 CellID->32757],
Cell[CellGroupData[{
Cell[78748, 2132, 151, 5, 70, "Input",
 CellID->20037],
Cell[78902, 2139, 180, 6, 36, "Output",
 CellID->819157087]
}, Open  ]],
Cell[79097, 2148, 1887, 46, 70, "DoubleBox",
 CellID->8723],
Cell[80987, 2196, 168, 6, 70, "Caption",
 CellID->9741],
Cell[81158, 2204, 10040, 235, 70, "DoubleBox",
 CellID->27529],
Cell[91201, 2441, 50, 1, 70, "Caption",
 CellID->778],
Cell[91254, 2444, 7943, 182, 70, "DoubleBox",
 CellID->12316],
Cell[99200, 2628, 62, 1, 70, "Caption",
 CellID->3035],
Cell[99265, 2631, 171, 6, 70, "MathCaption",
 CellID->22190],
Cell[CellGroupData[{
Cell[99461, 2641, 158, 4, 70, "Input",
 CellID->1842],
Cell[99622, 2647, 230, 7, 36, "Output",
 CellID->55500292]
}, Open  ]],
Cell[99867, 2657, 2382, 58, 70, "DoubleBox",
 CellID->30106],
Cell[102252, 2717, 40, 1, 70, "Caption",
 CellID->9040],
Cell[102295, 2720, 192, 5, 70, "RelatedTutorials",
 CellID->5715683]
}, Open  ]]
}, Open  ]],
Cell[102514, 2729, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

