(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29292,       1024]
NotebookOptionsPosition[     22782,        826]
NotebookOutlinePosition[     26213,        907]
CellTagsIndexPosition[     26120,        901]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AngleBracket" :> 
          Documentation`HelpLookup["paclet:ref/AngleBracket"], "CirclePlus" :> 
          Documentation`HelpLookup["paclet:ref/CirclePlus"], "Del" :> 
          Documentation`HelpLookup["paclet:ref/Del"], "Left" :> 
          Documentation`HelpLookup["paclet:ref/Left"], "LeftRightArrow" :> 
          Documentation`HelpLookup["paclet:ref/LeftRightArrow"], "OverBar" :> 
          Documentation`HelpLookup["paclet:ref/OverBar"], "OverDot" :> 
          Documentation`HelpLookup["paclet:ref/OverDot"], "OverHat" :> 
          Documentation`HelpLookup["paclet:ref/OverHat"], "Overscript" :> 
          Documentation`HelpLookup["paclet:ref/Overscript"], "OverTilde" :> 
          Documentation`HelpLookup["paclet:ref/OverTilde"], "OverVector" :> 
          Documentation`HelpLookup["paclet:ref/OverVector"], "Right" :> 
          Documentation`HelpLookup["paclet:ref/Right"], "Square" :> 
          Documentation`HelpLookup["paclet:ref/Square"], "SubMinus" :> 
          Documentation`HelpLookup["paclet:ref/SubMinus"], "SubPlus" :> 
          Documentation`HelpLookup["paclet:ref/SubPlus"], "Subscript" :> 
          Documentation`HelpLookup["paclet:ref/Subscript"], "SubStar" :> 
          Documentation`HelpLookup["paclet:ref/SubStar"], "SuperDagger" :> 
          Documentation`HelpLookup["paclet:ref/SuperDagger"], "SuperMinus" :> 
          Documentation`HelpLookup["paclet:ref/SuperMinus"], "SuperPlus" :> 
          Documentation`HelpLookup["paclet:ref/SuperPlus"], "SuperStar" :> 
          Documentation`HelpLookup["paclet:ref/SuperStar"], "Therefore" :> 
          Documentation`HelpLookup["paclet:ref/Therefore"], "TildeTilde" :> 
          Documentation`HelpLookup["paclet:ref/TildeTilde"], "UnderBar" :> 
          Documentation`HelpLookup["paclet:ref/UnderBar"], "Underscript" :> 
          Documentation`HelpLookup["paclet:ref/Underscript"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AngleBracket\"\>", 
       2->"\<\"CirclePlus\"\>", 3->"\<\"Del\"\>", 4->"\<\"Left\"\>", 
       5->"\<\"LeftRightArrow\"\>", 6->"\<\"OverBar\"\>", 
       7->"\<\"OverDot\"\>", 8->"\<\"OverHat\"\>", 9->"\<\"Overscript\"\>", 
       10->"\<\"OverTilde\"\>", 11->"\<\"OverVector\"\>", 12->"\<\"Right\"\>",
        13->"\<\"Square\"\>", 14->"\<\"SubMinus\"\>", 15->"\<\"SubPlus\"\>", 
       16->"\<\"Subscript\"\>", 17->"\<\"SubStar\"\>", 
       18->"\<\"SuperDagger\"\>", 19->"\<\"SuperMinus\"\>", 
       20->"\<\"SuperPlus\"\>", 21->"\<\"SuperStar\"\>", 
       22->"\<\"Therefore\"\>", 23->"\<\"TildeTilde\"\>", 
       24->"\<\"UnderBar\"\>", 
       25->"\<\"Underscript\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Operators without Built\[Hyphen]in Meanings\
\>", "Title",
 CellTags->{"S2.9.15", "15.1"},
 CellID->41],

Cell[TextData[{
 "When you enter a piece of input such as ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " first recognizes the ",
 Cell[BoxData["+"], "InlineFormula"],
 " as an operator and constructs the expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"], "[", 
   RowBox[{"2", ",", "2"}], "]"}]], "InlineFormula"],
 ", then uses the built\[Hyphen]in rules for ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " to evaluate the expression and get the result ",
 Cell[BoxData["4"], "InlineFormula"],
 ". "
}], "Text",
 CellID->18467],

Cell[TextData[{
 "But not all operators recognized by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are associated with functions that have built\[Hyphen]in meanings. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also supports several hundred additional operators that can be used in \
constructing expressions, but for which no evaluation rules are initially \
defined. "
}], "Text",
 CellID->6334],

Cell[TextData[{
 "You can use these operators as a way to build up your own notation within \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. "
}], "Text",
 CellID->26500],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " is recognized as an infix operator, but has no predefined value. "
}], "MathCaption",
 CellID->19169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "\[CirclePlus]", "3"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->15724],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"CirclePlus", "[", 
    RowBox[{"2", ",", "3"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm= ",
 CellID->11478]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " prints as an infix operator. "
}], "MathCaption",
 CellID->29358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "\[CirclePlus]", "3"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->26962],

Cell[BoxData[
 RowBox[{"2", "\[CirclePlus]", "3"}]], "Output",
 ImageSize->{30, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24464]
}, Open  ]],

Cell[TextData[{
 "You can define a value for ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->5705],

Cell[BoxData[
 RowBox[{
  RowBox[{"x_", " ", "\[CirclePlus]", " ", "y_"}], ":=", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->28145],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " is not only recognized as an operator, but can also be evaluated. "
}], "MathCaption",
 CellID->23281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", "\[CirclePlus]", " ", "3"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->16827],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->9961]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "\[CirclePlus]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["CirclePlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CirclePlus"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[TildeTilde]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["TildeTilde",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TildeTilde"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[Therefore]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["Therefore",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Therefore"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[LeftRightArrow]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["LeftRightArrow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LeftRightArrow"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    RowBox[{"\[Del]", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     ButtonBox["Del",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Del"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    RowBox[{"\[Square]", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     ButtonBox["Square",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Square"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    RowBox[{"\[LeftAngleBracket]", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "\[RightAngleBracket]"}], 
    RowBox[{
     ButtonBox["AngleBracket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AngleBracket"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->491],

Cell[TextData[{
 "A few ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operators corresponding to functions without predefined values. "
}], "Caption",
 CellID->2995],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows the general convention that the function associated with a \
particular operator should have the same name as the special character that \
represents that operator."
}], "Text",
 CellID->11942],

Cell[TextData[{
 ButtonBox["\[Backslash][Congruent]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Congruent"],
 " is displayed as ",
 Cell[BoxData[
  FormBox["\[Congruent]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->4827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "\[Congruent]", " ", "y"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->5436],

Cell[BoxData[
 RowBox[{"x", "\[Congruent]", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->32391]
}, Open  ]],

Cell[TextData[{
 "It corresponds to the function ",
 Cell[BoxData[
  ButtonBox["Congruent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Congruent"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->3902],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Congruent", "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//FullForm= ",
 CellID->153]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], " ", 
     RowBox[{"\\[", 
      StyleBox["name", "TI"], "]"}], " ", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     StyleBox["name", "TI"],
     "[",
     StyleBox["x", "TI"],
     ",",
     StyleBox["y", "TI"],
     "]"
    }], "TableText"]},
   {Cell[TextData[{
     "\[Backslash]",
     Cell[BoxData[
      RowBox[{"[", 
       StyleBox["name", "TI"], "]", " ", 
       StyleBox["x", "TI"]}]], "InlineFormula"]
    }], "TableText"], Cell[TextData[{
     StyleBox["name", "TI"],
     "[",
     StyleBox["x", "TI"],
     "]"
    }], "TableText"]},
   {
    StyleBox[Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{"\[Backslash]", 
         RowBox[{"[", 
          RowBox[{
           ButtonBox["Left",
            BaseStyle->"Link",
            ButtonData->"paclet:ref/Left"], 
           StyleBox["name", "TI"]}], "]"}]}], " ", 
        StyleBox["x", "TI"]}], ",", 
       StyleBox["y", "TI"], ",", 
       RowBox[{
        StyleBox["\[Ellipsis]", "TR"], " ", "\[Backslash]", 
        RowBox[{"[", 
         RowBox[{
          ButtonBox["Right",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/Right"], " ", 
          StyleBox["name", "TI"]}], "]"}]}]}]]]], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[TextData[{
     StyleBox["name", "TI"],
     "[",
     StyleBox["x", "TI"],
     ",",
     StyleBox["y", "TI"],
     ",",
     StyleBox["\[Ellipsis]", "TR"],
     "]"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->292],

Cell[TextData[{
 "The conventional correspondence in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " between operator names and function names. "
}], "Caption",
 CellID->12382],

Cell[TextData[{
 "You should realize that even though the functions ",
 Cell[BoxData[
  ButtonBox["CirclePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CirclePlus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CircleTimes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CircleTimes"]], "InlineFormula"],
 " do not have built\[Hyphen]in evaluation rules, the operators ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[CircleTimes]", TraditionalForm]], "InlineMath"],
 " do have built\[Hyphen]in precedences.\[NonBreakingSpace]\"",
 ButtonBox["Operator Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#23301"],
 "\" lists all the operators recognized by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", in order of their precedence. "
}], "Text",
 CellID->17421],

Cell[TextData[{
 "The operators ",
 Cell[BoxData[
  FormBox["\[CircleTimes]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " have definite precedences\[LongDash]with ",
 Cell[BoxData[
  FormBox["\[CircleTimes]", TraditionalForm]], "InlineMath"],
 " higher than ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->18716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", " ", "\[CircleTimes]", " ", "y"}], " ", "\[CirclePlus]", " ", 
   "z"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->19718],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Plus", "[", 
      RowBox[{"z", ",", 
       RowBox[{"CircleTimes", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", "2"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//FullForm= ",
 CellID->19895]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["y", "TI"]], 
    RowBox[{
     ButtonBox["Subscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subscript"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    SubscriptBox[
     StyleBox["x", "TI"], "+"], 
    RowBox[{
     ButtonBox["SubPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubPlus"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SubscriptBox[
     StyleBox["x", "TI"], "-"], 
    RowBox[{
     ButtonBox["SubMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubMinus"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SubscriptBox[
     StyleBox["x", "TI"], "*"], 
    RowBox[{
     ButtonBox["SubStar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubStar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SuperscriptBox[
     StyleBox["x", "TI"], "+"], 
    RowBox[{
     ButtonBox["SuperPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperPlus"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SuperscriptBox[
     StyleBox["x", "TI"], "-"], 
    RowBox[{
     ButtonBox["SuperMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperMinus"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SuperscriptBox[
     StyleBox["x", "TI"], "*"], 
    RowBox[{
     ButtonBox["SuperStar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperStar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    SuperscriptBox[
     StyleBox["x", "TI"], "\[Dagger]"], 
    RowBox[{
     ButtonBox["SuperDagger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperDagger"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["y", "TI"]], 
    RowBox[{
     ButtonBox["Overscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Overscript"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    UnderscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["y", "TI"]], 
    RowBox[{
     ButtonBox["Underscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Underscript"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "_"], 
    RowBox[{
     ButtonBox["OverBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverBar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "\[RightVector]"], 
    RowBox[{
     ButtonBox["OverVector",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverVector"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "~"], 
    RowBox[{
     ButtonBox["OverTilde",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverTilde"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "^"], 
    RowBox[{
     ButtonBox["OverHat",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverHat"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    OverscriptBox[
     StyleBox["x", "TI"], "."], 
    RowBox[{
     ButtonBox["OverDot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverDot"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {
    UnderscriptBox[
     StyleBox["x", "TI"], "_"], 
    RowBox[{
     ButtonBox["UnderBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderBar"], "[", 
     StyleBox["x", "TI"], "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.1], {
      Scaled[0.9]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->5447],

Cell["\<\
Some two\[Hyphen]dimensional forms without built\[Hyphen]in meanings. \
\>", "Caption",
 CellID->21726],

Cell[TextData[{
 "Subscripts have no built\[Hyphen]in meaning in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->14771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "2"], "+", 
   SubscriptBox["y", "2"]}], "//", "InputForm"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->11538],

Cell["Subscript[x, 2] + Subscript[y, 2]", "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//InputForm= ",
 CellID->1869]
}, Open  ]],

Cell["\<\
Most superscripts are however interpreted as powers by default. \
\>", "MathCaption",
 CellID->19912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}], "//", "InputForm"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->25667],

Cell["x^2 + y^2", "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//InputForm= ",
 CellID->26299]
}, Open  ]],

Cell["A few special superscripts are not interpreted as powers. ", \
"MathCaption",
 CellID->17035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "\[Dagger]"], "+", 
   SuperscriptBox["y", "+"]}], "//", "InputForm"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->9894],

Cell["SuperDagger[x] + SuperPlus[y]", "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//InputForm= ",
 CellID->28703]
}, Open  ]],

Cell[TextData[{
 "Bar and hat are interpreted as ",
 Cell[BoxData[
  ButtonBox["OverBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OverBar"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OverHat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OverHat"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["x", "_"], "+", 
   OverscriptBox["y", "^"]}], "//", "InputForm"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->31322],

Cell["OverBar[x] + OverHat[y]", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//InputForm= ",
 CellID->30333]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->526582037],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Operators without Built-in Meanings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheSyntaxOfTheMathematicaLanguage"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningOutputFormats"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 35.3396836}", "context" -> "", 
    "keywords" -> {
     "\\bar (TeX)", "\\ddot (TeX)", "\\ddots (TeX)", "\\hat (TeX)", 
      "notations", "operators", "OverBar", "OverDot", "OverHat", 
      "\\overline (TeX)", "Overscript", "OverTilde", "OverVector", 
      "special characters", "SubMinus", "SubPlus", "subscript", "SubStar", 
      "SuperDagger", "SuperMinus", "SuperPlus", "SuperStar", 
      "symbolic operators", "UnderBar", "underline", "\\underline (TeX)", 
      "Underscript", "\\vec (TeX)", "vectors"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "When you enter a piece of input such as 2+2, Mathematica first \
recognizes the + as an operator and constructs the expression Plus[2,2], then \
uses the built-in rules for Plus to evaluate the expression and get the \
result 4. But not all operators recognized by Mathematica are associated with \
functions that have built-in meanings. Mathematica also supports several \
hundred additional operators that can be used in constructing expressions, \
but for which no evaluation rules are initially defined. You can use these \
operators as a way to build up your own notation within the Mathematica \
language. ", "synonyms" -> {"2.9.15"}, "title" -> 
    "Operators without Built-in Meanings", "type" -> "Tutorial", "uri" -> 
    "tutorial/OperatorsWithoutBuiltInMeanings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.15"->{
  Cell[4286, 93, 113, 4, 70, "Title",
   CellTags->{"S2.9.15", "15.1"},
   CellID->41]},
 "15.1"->{
  Cell[4286, 93, 113, 4, 70, "Title",
   CellTags->{"S2.9.15", "15.1"},
   CellID->41]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.15", 25908, 890},
 {"15.1", 26008, 894}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3661, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4286, 93, 113, 4, 70, "Title",
 CellTags->{"S2.9.15", "15.1"},
 CellID->41],
Cell[4402, 99, 742, 25, 70, "Text",
 CellID->18467],
Cell[5147, 126, 417, 11, 70, "Text",
 CellID->6334],
Cell[5567, 139, 192, 7, 70, "Text",
 CellID->26500],
Cell[5762, 148, 205, 6, 70, "MathCaption",
 CellID->19169],
Cell[CellGroupData[{
Cell[5992, 158, 132, 4, 28, "Input",
 CellID->15724],
Cell[6127, 164, 350, 13, 50, "Output",
 CellID->11478]
}, Open  ]],
Cell[6492, 180, 302, 11, 70, "MathCaption",
 CellID->29358],
Cell[CellGroupData[{
Cell[6819, 195, 101, 3, 28, "Input",
 CellID->26962],
Cell[6923, 200, 189, 6, 36, "Output",
 CellID->24464]
}, Open  ]],
Cell[7127, 209, 163, 6, 70, "MathCaption",
 CellID->5705],
Cell[7293, 217, 216, 7, 70, "Input",
 CellID->28145],
Cell[7512, 226, 206, 6, 70, "MathCaption",
 CellID->23281],
Cell[CellGroupData[{
Cell[7743, 236, 111, 3, 70, "Input",
 CellID->16827],
Cell[7857, 241, 154, 5, 36, "Output",
 CellID->9961]
}, Open  ]],
Cell[8026, 249, 2285, 78, 70, "DefinitionBox",
 CellID->491],
Cell[10314, 329, 174, 6, 70, "Caption",
 CellID->2995],
Cell[10491, 337, 269, 7, 70, "Text",
 CellID->11942],
Cell[10763, 346, 260, 9, 70, "MathCaption",
 CellID->4827],
Cell[CellGroupData[{
Cell[11048, 359, 109, 3, 70, "Input",
 CellID->5436],
Cell[11160, 364, 188, 6, 36, "Output",
 CellID->32391]
}, Open  ]],
Cell[11363, 373, 213, 8, 70, "MathCaption",
 CellID->14604],
Cell[CellGroupData[{
Cell[11601, 385, 100, 3, 70, "Input",
 CellID->3902],
Cell[11704, 390, 347, 13, 50, "Output",
 CellID->153]
}, Open  ]],
Cell[12066, 406, 2043, 69, 70, "DefinitionBox",
 CellID->292],
Cell[14112, 477, 183, 6, 70, "Caption",
 CellID->12382],
Cell[14298, 485, 889, 26, 70, "Text",
 CellID->17421],
Cell[15190, 513, 456, 15, 70, "MathCaption",
 CellID->18716],
Cell[CellGroupData[{
Cell[15671, 532, 193, 6, 70, "Input",
 CellID->19718],
Cell[15867, 540, 476, 17, 50, "Output",
 CellID->19895]
}, Open  ]],
Cell[16358, 560, 3692, 140, 70, "DefinitionBox",
 CellID->5447],
Cell[20053, 702, 113, 3, 70, "Caption",
 CellID->21726],
Cell[20169, 707, 157, 6, 70, "MathCaption",
 CellID->14771],
Cell[CellGroupData[{
Cell[20351, 717, 167, 6, 70, "Input",
 CellID->11538],
Cell[20521, 725, 189, 5, 50, "Output",
 CellID->1869]
}, Open  ]],
Cell[20725, 733, 111, 3, 70, "MathCaption",
 CellID->19912],
Cell[CellGroupData[{
Cell[20861, 740, 171, 6, 70, "Input",
 CellID->25667],
Cell[21035, 748, 165, 5, 50, "Output",
 CellID->26299]
}, Open  ]],
Cell[21215, 756, 99, 2, 70, "MathCaption",
 CellID->17035],
Cell[CellGroupData[{
Cell[21339, 762, 179, 6, 70, "Input",
 CellID->9894],
Cell[21521, 770, 187, 5, 50, "Output",
 CellID->28703]
}, Open  ]],
Cell[21723, 778, 336, 13, 70, "MathCaption",
 CellID->23811],
Cell[CellGroupData[{
Cell[22084, 795, 170, 6, 70, "Input",
 CellID->31322],
Cell[22257, 803, 181, 5, 50, "Output",
 CellID->30333]
}, Open  ]],
Cell[CellGroupData[{
Cell[22475, 813, 72, 1, 70, "RelatedTutorialsSection",
 CellID->526582037],
Cell[22550, 816, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[22755, 824, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

