(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65063,       1607]
NotebookOptionsPosition[     57750,       1405]
NotebookOutlinePosition[     61907,       1496]
CellTagsIndexPosition[     61813,       1490]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Manipulating Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Options for Cells", "Title",
 CellTags->{"S2.11.9", "9.1"},
 CellID->3548],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a large number of options for cells. All of these options can be \
accessed through the ",
 StyleBox[ButtonBox["Option Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/OptionInspector"], "MenuName"],
 " menu item in the front end. They can be set either directly at the level \
of individual cells or at a higher level, to be inherited by individual \
cells. "
}], "Text",
 CellID->19629],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["CellDingbat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellDingbat"], "None", Cell[
    "a dingbat to use to emphasize the cell", "TableText"]},
   {
    ButtonBox["CellFrame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellFrame"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw a frame around the cell", "TableText"]},
   {
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the background color for the cell", "TableText"]},
   {
    ButtonBox["ShowCellBracket",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowCellBracket"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to display the cell bracket", "TableText"]},
   {
    ButtonBox["Magnification",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Magnification"], "1.", Cell[
    "the magnification at which to display the cell", "TableText"]},
   {
    ButtonBox["CellOpen",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellOpen"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to display the contents of the cell", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->12623],

Cell["Some basic cell display options. ", "Caption",
 CellID->24084],

Cell[TextData[{
 "This creates a cell in ",
 Cell[BoxData["Section"], "InlineFormula"],
 " style with default settings for all options. "
}], "MathCaption",
 CellID->19954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<A Heading\>\"", ",", "\"\<Section\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->18756],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWnlsTWkUv333LZ6W1NKU2FVtscS+JNYJgpDYlxEUlfqjIaYdQkhssY9Y
YwsjWrEEERHbWCO2qGoZIraMtaMMHdVS5cx3zv3O13vr9Xm9fcVM5kvufe99
y9l+55xve/1iEuJi42MSJo2Pqd1rasyUuEnjf6rdc/JUUaWHaJojQtO0H2pr
+B3EV/kqKJH40jTd+EVt4lUJXyGyRldNGrf763T//n3RvnfvXnqVx5eDKnWq
ZDo80FXAWBTRD27evKkZ3/AVSmOdWMutcOjQIYdv5vhRMDbcD1/rGIcxhksY
vvxJ7bZIzbKR0myesjTAqdSSHfwIXpihoQwXD/12FTYV9taCShQfYeHgEvUp
qadIK1q9tEwRUpaK6kElatKpuERnSlJI4vDhw3Dw4EG4c+cO5OfnG7SnyQ4b
tl6AUbHJ9IwcnwQLlv4mnC9A5fxDMIMadTh58iQ0adKE6nT59ng8MHv2bPj4
8aMxOFHyfJ2VC08zsuj54+FfMPDHXwOX58t2mU5vD8nq9Xo5NKFcuXLQvHlz
lMsgKcYNHTqUkTH4/iwVyvjzb2GrZPrl9SGbzDL2ZCsDGzduhEaNGtEzefJk
xIzGZmRkQL169Vg8hNMiXmKA4tk0XU9J6sOHD6ThgQMHIDU1Fd69e2fkYZGu
Pn36RHVHjx6FV69eeaVEjx8/pqpHjx5p1WVXgTyLDwsXLmSt9u3bF0St/Dto
XSnK/v37lSM0bdrULakfOXJEVYeHh5Oibjlkzpw5qm3+/Pmsf7Vq1VT1s2fP
HFL2PXv2QM2aNYkpK4oRsHTpUjSZ5pBemZmZCe3bt1ckHA4H9O7dG1JSUuQ4
FzRs2BDy8vJIodevX0O/fv1kVHmgc+fOcPz4cTV+3rx5rLgc74Rhw4Ypuw8Y
MMAhh6JzmUuVKlU4MAzfEH0Q3WXLllEwu1wuaNWqFbHYunWrUmv9+vVf1Svr
SFLv37+HChUqKNVv3bqlvDIuLk7VT5gwweMPQ3dhDEmCpKQkXdofceNmfKZM
maLwGzNmjKqPiIiA1q1bQ0hICJQtW1bZH7liQWN26NCBjCC4Vq9e3RdsJUZN
NwslHcVJTsTc1qxZQ2OnBQiUzWUDB9vEiRMV61mzZjnh7du3gkN2djZUrVpV
NYlJQ/MLVORnQL148UK5QPny5eHYsWOUrK5cuUK5FOvdbjc8fPiQpI2KiqI6
p9OpDImZqkGDBsqdMUKx7Ny5U0VgnTp14MKFC/Dy5UvYvHkzhoLqH6SIY4c6
d+6cUhHFnD59OmzatAnatGmjplLGz1bE2Zim6kryZ86cUX5VRsqCkMjE7j9V
uj5DT2RbZeG5c+daTCPynGh78OCBIPrmzRuqE7FDYzERianQIXkuX75ckcVc
hWX48OFM2WQsKn369Ckd7JwQGxtr1luX1T169Ahu6Pmf46IkaUw3PAUxWgkJ
CcpzionWypUrld3Gjh1LphaPIIBvHc6ePUt0Fy9erGwp4opsfOrUKUyoPJxR
atmypXKA69evW+y7YsWK0oKpW7duSjPBlmFat26dbZhsTmVRkjUGObPu2rWr
g7R3kWdjDuCmq1evamWKh5ropnmliXH1zWXGjBlQuXJlmVLcljmO4RGTPqMj
VnYWs4r1kx10eHL1hw6uyVkSkd8ZnW3btn0rdNA1mXWLFi1Y0PPnz6tqMdl4
fQAjVnYuiI+PF/KEhoZagBHhoHx/yJAhNK3wM2jQINnmJR8wF8y1ly9fhrVr
19IqxzCdNa5wgci0cRtoLkuWLLGD3MWLFy1kKlas+Bly/fv3VyqK2ZKRi4mJ
sYVckXth/+kvmhrdFj+6d+8e9U1MTCysO9Csa0hjgk4FDWJ17do1Rapdu3Zy
neWGtm3bqvrbt28TMUpzmNiccOnSJWWvBQsWMGeRSKlq5syZCqXRo0errllZ
WVCjRo3io+TE1ZWqfvLkCVdjUuAiuvhiimqKxZhiWqIlhk3EhGsqc4pZhPqK
FRuLxCAWIGYNtrCwMBdERkYKSriLMgcbFhEUTKljx46waNEi6NKli7Io1nG5
e/cuV+OKUWBHoaVkccKJEyeoJ043Xq+XCYvcTXNjpUqV1GKtGPCh2Lh2R4bN
mjVjnLp3727BSTDUzKqMGDGCTjGCsjy0kSfrSVJir68sj6GRnp6u5MS1G8vk
dwrz+NyNoWTR0dGGvIKc2LPTwt0QydAOjcrR65TTWqdOnSA3N1eZb8OGDTij
crN5JRDoFkynuGFGXId7PtyHmwXCjbGu66Z+LtqNmJeJIo2bT+dK7aQpWtrc
rPG4ceNY/NWrVwcGTxEHHh7c01H6QQa1atWCXr160YIDF/KM7JYtW2Dw4MGE
nsijuJGGXbt20X6QDr4FJKdPn4aRI0dC48aNoW/fvrBjxw7YvXt34WQospvQ
U3QUA03Cw6pVqyiGBCU8H8CDNZyWcCGKn4I6b/pxr4iRgxtjPEXB0yqR6A2i
OoP51YIoWpLH+b+wc6HDPn/+3MQyUHRqSmWFBT9z9Pz8fAeSFQxwyrEo+0tJ
lPWf7etL0riklKtOpSiefLEcwVNURbRujuggKPplVOtLUgMHDlRi4bN9+3Yt
9LtS0OYZDyt448YNCjZ+srOzlYIpKSmqPjU1lRVMTk5W1Tk5Oayg2PPj8SI9
aWlpJEFmZqYDbePrtLg4CNq9psoriREDuLX6ULpeSB3eSbPz9c+IcUkwaNS2
IN60WNjwrU7670+RVWE2Jbjoog65kp75Mqv/sC34GazLrLrAzWmgyYvnQtdV
+OTk5AXzugpUKepaNOh3rV/vavS7u8D9/0L8O3elAA8BTLHxn1H968a7b3sG
3ZUkQN9Cyn95rJcK6tb/JZntaVRqtv+XVPCXrjBiqwc65dv5O5a9MVzC6bfV
N7/0ZzY6/TT2viZK8t9xWsg/2glhlA==\
\>"], "Picture",
 ImageSize->{533, 67},
 ImageMargins->0,
 CellID->1904122165]
}, Open  ]],

Cell["\<\
This creates a cell with dingbat and background options modified. \
\>", "MathCaption",
 CellID->4966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<A Heading\>\"", ",", "\"\<Section\>\"", ",", 
    RowBox[{"CellDingbat", "->", "\"\<\[FilledCircle]\>\""}], ",", 
    RowBox[{"Background", "->", 
     RowBox[{"GrayLevel", "[", ".7", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->7376],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 160},
 ImageMargins->0,
 CellID->13931]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["CellMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellMargins"], 
    RowBox[{"{", "{", "7", ",", "0", "}", ",", "{", "4", ",", "4", "}", "}"}],
     Cell["\<\
outer margins in printer\[CloseCurlyQuote]s points to leave around the \
contents of the cell\
\>", "TableText"]},
   {
    ButtonBox["CellFrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellFrameMargins"], "8", Cell[
    "margins to leave inside the cell frame", "TableText"]},
   {"CellElementSpacings", Cell["list of rules", "TableText"], Cell[
    "details of the layout of cell elements", "TableText"]},
   {
    ButtonBox["CellBaseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellBaseline"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell["\<\
how to align the baseline of an inline cell with text around it\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {True}, False}, 
   "RowsIndexed" -> {}}},
 CellID->26308],

Cell["Options for cell positioning. ", "Caption",
 CellID->16944],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["CellMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellMargins"]], "InlineFormula"],
 " allows you to specify both horizontal and vertical margins to put around a \
cell. You can set the horizontal margins interactively by using the margin \
stops in the ruler displayed when you choose the ",
 StyleBox[ButtonBox["Show Ruler",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowRuler"], "MenuName"],
 " menu item in the front end."
}], "Text",
 CellID->32439],

Cell[TextData[{
 "Whenever an option can refer to all four edges of a cell, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows the convention that the setting for the option takes the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["left", "TI"], ",", 
      StyleBox["right", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["bottom", "TI"], ",", 
      StyleBox["top", "TI"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". By giving non\[Hyphen]zero values for the ",
 Cell[BoxData[
  StyleBox["top", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["bottom", "TI"]], "InlineFormula"],
 " elements, ",
 Cell[BoxData[
  ButtonBox["CellMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellMargins"]], "InlineFormula"],
 " can specify gaps to leave above and below a particular cell. The values \
are always taken to be in printer\[CloseCurlyQuote]s points."
}], "Text",
 CellID->24626],

Cell["\<\
This leaves 50 points of space on the left of the cell, and 20 points above \
and below. \
\>", "MathCaption",
 CellID->11323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<First text\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellMargins", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"50", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "20"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[3]:= ",
 CellID->5537],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 181},
 ImageMargins->0,
 CellID->1371407198]
}, Open  ]],

Cell[TextData[{
 "Almost every aspect of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks can be controlled by some option or another. More detailed \
aspects are typically handled by \[OpenCurlyDoubleQuote]aggregate options\
\[CloseCurlyDoubleQuote] such as ",
 Cell[BoxData["CellElementSpacings"], "InlineFormula"],
 ". The settings for these options are lists of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rules, which effectively give values for a sequence of suboptions. The \
names of these suboptions are usually strings rather than symbols. "
}], "Text",
 CellID->16118],

Cell[TextData[{
 "This shows the settings for all the suboptions associated with ",
 Cell[BoxData["CellElementSpacings"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{
   RowBox[{"SelectedNotebook", "[", "]"}], ",", "CellElementSpacings"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->22929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CellElementSpacings", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"CellMinHeight\"\>", "\[Rule]", "12.`"}], ",", 
     RowBox[{"\<\"ClosedCellHeight\"\>", "\[Rule]", "19.`"}], ",", 
     RowBox[{"\<\"ClosedGroupTopMargin\"\>", "\[Rule]", "4.`"}], ",", 
     RowBox[{"\<\"GroupIconTopMargin\"\>", "\[Rule]", "3.`"}], ",", 
     RowBox[{"\<\"GroupIconBottomMargin\"\>", "\[Rule]", "12.`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{572, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->16541]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to embed cells inside pieces of text. The option ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition",
   ButtonNote->"ObsLink: CellBaseline -> BaselinePosition"]], 
  "InlineFormula"],
 " determines how such \[OpenCurlyDoubleQuote]inline cells\
\[CloseCurlyDoubleQuote] will be aligned vertically with respect to the text \
around them. In direct analogy with the option ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 " for a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", the option ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition",
   ButtonNote->"ObsLink: CellBaseline -> BaselinePosition"]], 
  "InlineFormula"],
 " specifies what aspect of the cell should be considered its baseline. "
}], "Text",
 CellID->4833],

Cell["\<\
Here is a cell containing an inline formula. The baseline of the formula is \
aligned with the baseline of the text around it.\
\>", "MathCaption",
 CellID->31115],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 75},
 ImageMargins->0,
 CellID->1741256638],

Cell["\<\
Here is a cell in which the bottom of the formula is aligned with the \
baseline of the text around it.\
\>", "MathCaption",
 CellID->29658],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 75},
 ImageMargins->0,
 CellID->1959771513],

Cell[TextData[{
 "This alignment is specified using the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BaselinePosition",
    ButtonData->"paclet:ref/BaselinePosition",
    ButtonNote->"ObsLink: CellBaseline -> BaselinePosition"], "->", 
   ButtonBox["Bottom",
    ButtonData->"paclet:ref/Bottom"]}]], "InlineFormula"],
 " setting. "
}], "MathCaption",
 CellID->9930],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 143},
 ImageMargins->0,
 CellID->1552816151],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["CellLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellLabel"], "\"\<\>\"", Cell[
    "a label for a cell", "TableText"]},
   {
    ButtonBox["ShowCellLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowCellLabel"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to show the label for a cell", "TableText"]},
   {
    ButtonBox["CellLabelAutoDelete",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellLabelAutoDelete"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to delete the label if the cell is modified", "TableText"]},
   {
    ButtonBox["CellTags",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellTags"], 
    RowBox[{"{", "}"}], Cell["tags for a cell", "TableText"]},
   {
    ButtonBox["ShowCellTags",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowCellTags"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to show tags for a cell", "TableText"]},
   {
    ButtonBox["ConversionRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ConversionRules"], 
    RowBox[{"{", "}"}], Cell["rules for external conversions", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->2306],

Cell["Options for ancillary data associated with cells. ", "Caption",
 CellID->31673],

Cell["\<\
In addition to the actual contents of a cell, it is often useful to associate \
various kinds of ancillary data with cells. \
\>", "Text",
 CellID->22386],

Cell[TextData[{
 "In a standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, cells containing successive lines of kernel input and output are \
given labels of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["In",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/In"], "[", 
    StyleBox["n", "TI"], "]"}], ":="}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Out",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Out"], "[", 
    StyleBox["n", "TI"], "]"}], "="}]], "InlineFormula"],
 ". The option ",
 Cell[BoxData[
  ButtonBox["ShowCellLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowCellLabel"]], "InlineFormula"],
 " determines whether such labels should be displayed. ",
 Cell[BoxData[
  ButtonBox["CellLabelAutoDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellLabelAutoDelete"]], "InlineFormula"],
 " determines whether the label on a cell should be removed if the contents \
of the cell are modified. Doing this ensures that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["In",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/In"], "[", 
    StyleBox["n", "TI"], "]"}], ":="}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Out",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Out"], "[", 
    StyleBox["n", "TI"], "]"}], "="}]], "InlineFormula"],
 " labels are only associated with unmodified pieces of kernel input and \
output."
}], "Text",
 CellID->5021],

Cell[TextData[{
 "Cell tags are typically used to associate keywords or other attributes with \
cells, that can be searched for using functions like ",
 Cell[BoxData[
  ButtonBox["NotebookFind",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookFind"]], "InlineFormula"],
 ". Destinations for hyperlinks in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks are usually implemented using cell tags. "
}], "Text",
 CellID->28745],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["ConversionRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConversionRules"]], "InlineFormula"],
 " allows you to give a list containing entries such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["\"\<TeX\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/TeX"], "->", 
   StyleBox["data", "TI"]}]], "InlineFormula"],
 " which specify how the contents of a cell should be converted to external \
formats. This is particularly relevant if you want to keep a copy of the \
original form of a cell that has been converted in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook format from some external format. "
}], "Text",
 CellID->26924],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["Deletable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deletable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to allow a cell to be deleted interactively with the front end\
\>", "TableText"]},
   {
    ButtonBox["Copyable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Copyable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow a cell to be copied", "TableText"]},
   {
    ButtonBox["Selectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Selectable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow the contents of a cell to be selected", "TableText"]},
   {
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow the contents of a cell to be edited", "TableText"]},
   {
    ButtonBox["Deployed",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deployed"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the user interface in the cell is active", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {True}, False}, 
   "RowsIndexed" -> {}}},
 CellID->19072],

Cell["Options for controlling interactive operations on cells. ", "Caption",
 CellID->6270],

Cell[TextData[{
 "The options ",
 Cell[BoxData[
  ButtonBox["Deletable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deletable"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Copyable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Copyable"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Selectable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Selectable"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Editable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Editable"]], "InlineFormula"],
 " allow you to control what interactive operations should be allowed on \
cells. By setting these options to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " at the notebook level, you can protect all the cells in a notebook. "
}], "Text",
 CellID->147896217],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Deployed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deployed"]], "InlineFormula"],
 " allows you to treat the contents of a cell as if they were a user \
interface. In a user interface, labels are typically not selectable and \
controls such as buttons can be used, but not modified. ",
 Cell[BoxData[
  ButtonBox["Deployed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deployed"]], "InlineFormula"],
 " can also be set on specific elements inside a cell so that, for example, \
the output of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is always deployed even if the cell it is in has the ",
 Cell[BoxData[
  ButtonBox["Deployed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deployed"]], "InlineFormula"],
 " option set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->317600427],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["Evaluator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluator"], "\"\<Local\>\"", Cell[
    "the name of the kernel to use for evaluations", "TableText"]},
   {
    ButtonBox["Evaluatable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluatable"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to allow the contents of a cell to be evaluated", "TableText"]},
   {
    ButtonBox["CellAutoOverwrite",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellAutoOverwrite"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to overwrite previous output when new output is generated\
\>", "TableText"]},
   {
    ButtonBox["GeneratedCell",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GeneratedCell"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether this cell was generated from the kernel", "TableText"]},
   {
    ButtonBox["InitializationCell",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InitializationCell"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether this cell should automatically be evaluated when the notebook is \
opened\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->15573],

Cell["Options for evaluation. ", "Caption",
 CellID->5097],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes it possible to specify a different evaluator for each cell in a \
notebook. But most often, the ",
 Cell[BoxData[
  ButtonBox["Evaluator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluator"]], "InlineFormula"],
 " option is set only at the notebook or global level, typically using the ",
 StyleBox[ButtonBox["Kernel Configuration Options",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/KernelConfigurationOptions"], "MenuName"],
 " menu item in the front end. "
}], "Text",
 CellID->16512],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["CellAutoOverwrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellAutoOverwrite"]], "InlineFormula"],
 " is typically set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for styles that represent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. Doing this means that when you re\[Hyphen]evaluate a particular \
piece of input, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically delete the output that was previously generated from \
that input, and will overwrite it with new output. "
}], "Text",
 CellID->23986],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["GeneratedCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedCell"]], "InlineFormula"],
 " is set whenever a cell is generated by an external request to the front \
end rather than by an interactive operation within the front end. Thus, for \
example, any cell obtained as an output or side effect from a kernel \
evaluation will have ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedCell"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". Cells generated by low-level functions designed to manipulate notebooks \
directly such as ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NotebookApply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookApply"]], "InlineFormula"],
 " do not have the ",
 Cell[BoxData[
  ButtonBox["GeneratedCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedCell"]], "InlineFormula"],
 " option set."
}], "Text",
 CellID->13290],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["PageBreakAbove",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageBreakAbove"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to put a page break just above a particular cell", 
     "TableText"]},
   {
    ButtonBox["PageBreakWithin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageBreakWithin"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to allow a page break within a particular cell", "TableText"]},
   {
    ButtonBox["PageBreakBelow",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageBreakBelow"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to put a page break just below a particular cell", 
     "TableText"]},
   {
    ButtonBox["GroupPageBreakWithin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GroupPageBreakWithin"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to allow a page break within a particular group of cells\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->9161],

Cell["Options for controlling page breaks when cells are printed. ", "Caption",
 CellID->18636],

Cell[TextData[{
 "When you display a notebook on the screen, you can scroll continuously \
through it. But if you print the notebook out, you have to decide where page \
breaks will occur. A setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " for a page break option tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to make a page break if necessary; ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " specifies that a page break should always be made, while ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " specifies that it should never be. "
}], "Text",
 CellID->22355],

Cell[TextData[{
 "Page breaks set using the ",
 Cell[BoxData[
  ButtonBox["PageBreakAbove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageBreakAbove"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PageBreakBelow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageBreakBelow"]], "InlineFormula"],
 " options also determine the breaks between slides in a slide show. When \
creating a slide show, you will typically use a cell with a special named \
style to determine where each slide begins. This named style will have one of \
the page-breaking options set on it."
}], "Text",
 CellID->95911523],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->79478304],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Options for Cells - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TextAndFontOptions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 37.9803762}", "context" -> "", 
    "keywords" -> {
     "active", "alignment", "attributes", "automatic evaluation", 
      "background", "baseline", "boxes", "brackets", "breaking", 
      "CellAutoOverwrite", "CellBaseline", "cell brackets", "CellDingbat", 
      "CellEditDuplicate", "CellElementSpacings", "CellEvaluationDuplicate", 
      "CellFrame", "CellFrameMargins", "CellLabel", "CellLabelAutoDelete", 
      "CellMargins", "CellOpen", "CellTags", "ConversionRules", 
      "conversion rules", "copyable", "CopyOnEdit", "copy on edit", 
      "CopyOnEvaluation", "copy on evaluation", "deletable", 
      "delete old output", "DuplicationOnEdit", "duplicate on edit", 
      "dingbats", "edges", "Editable", "element spacings", "enclosures", 
      "Evaluatable", "evaluator", "external conversions", "forcing", "frames",
       "GeneratedCell", "GroupPageBreakWithin", "hidden data", 
      "highlighting cells", "immediate evaluation", "inhibiting", 
      "InitializationCell", "initialization cell", "inline cells", 
      "input cell", "kernel menu item", "labels", "leading", "length", 
      "line numbers", "locking cells", "magnification", "margins", 
      "numbering", "open cell", "overwrite old output", "PageBreakAbove", 
      "PageBreakBelow", "page breaks", "PageBreakWithin", "positioning", 
      "printing", "protection", "selectable", "ShowCellBracket", 
      "ShowCellLabel", "ShowCellTags", "show ruler menu item", "spacing", 
      "startup cells", "tags", "write protection"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides a large number of options for cells. All of these \
options can be accessed through the Option Inspector menu item in the front \
end. They can be set either directly at the level of individual cells or at a \
higher level, to be inherited by individual cells. Some basic cell display \
options. This creates a cell in Section style with default settings for all \
options. ", "synonyms" -> {"2.11.9"}, "title" -> "Options for Cells", "type" -> 
    "Tutorial", "uri" -> "tutorial/OptionsForCells"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.9"->{
  Cell[1266, 43, 80, 2, 70, "Title",
   CellTags->{"S2.11.9", "9.1"},
   CellID->3548]},
 "9.1"->{
  Cell[1266, 43, 80, 2, 70, "Title",
   CellTags->{"S2.11.9", "9.1"},
   CellID->3548]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.9", 61602, 1479},
 {"9.1", 61701, 1483}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 80, 2, 70, "Title",
 CellTags->{"S2.11.9", "9.1"},
 CellID->3548],
Cell[1349, 47, 484, 12, 70, "Text",
 CellID->19629],
Cell[1836, 61, 1717, 51, 70, "DefinitionBox3Col",
 CellID->12623],
Cell[3556, 114, 68, 1, 70, "Caption",
 CellID->24084],
Cell[3627, 117, 172, 5, 70, "MathCaption",
 CellID->19954],
Cell[CellGroupData[{
Cell[3824, 126, 190, 6, 70, "Input",
 CellID->18756],
Cell[4017, 134, 3083, 53, 70, "Picture",
 CellID->1904122165]
}, Open  ]],
Cell[7115, 190, 112, 3, 70, "MathCaption",
 CellID->4966],
Cell[CellGroupData[{
Cell[7252, 197, 339, 8, 70, "Input",
 CellID->7376],
Cell[7594, 207, 5621, 95, 70, "Picture",
 CellID->13931]
}, Open  ]],
Cell[13230, 305, 1247, 34, 70, "DefinitionBox3Col",
 CellID->26308],
Cell[14480, 341, 65, 1, 70, "Caption",
 CellID->16944],
Cell[14548, 344, 541, 14, 70, "Text",
 CellID->32439],
Cell[15092, 360, 984, 30, 70, "Text",
 CellID->24626],
Cell[16079, 392, 136, 4, 70, "MathCaption",
 CellID->11323],
Cell[CellGroupData[{
Cell[16240, 400, 402, 13, 70, "Input",
 CellID->5537],
Cell[16645, 415, 6707, 112, 70, "Picture",
 CellID->1371407198]
}, Open  ]],
Cell[23367, 530, 606, 14, 70, "Text",
 CellID->16118],
Cell[23976, 546, 179, 5, 70, "MathCaption",
 CellID->2082],
Cell[CellGroupData[{
Cell[24180, 555, 183, 6, 70, "Input",
 CellID->22929],
Cell[24366, 563, 603, 15, 54, "Output",
 CellID->16541]
}, Open  ]],
Cell[24984, 581, 1092, 31, 70, "Text",
 CellID->4833],
Cell[26079, 614, 173, 4, 70, "MathCaption",
 CellID->31115],
Cell[26255, 620, 3193, 55, 70, "Picture",
 CellID->1741256638],
Cell[29451, 677, 150, 4, 70, "MathCaption",
 CellID->29658],
Cell[29604, 683, 2908, 50, 70, "Picture",
 CellID->1959771513],
Cell[32515, 735, 363, 11, 70, "MathCaption",
 CellID->9930],
Cell[32881, 748, 8997, 150, 70, "Picture",
 CellID->1552816151],
Cell[41881, 900, 1637, 48, 70, "DefinitionBox3Col",
 CellID->2306],
Cell[43521, 950, 85, 1, 70, "Caption",
 CellID->31673],
Cell[43609, 953, 164, 4, 70, "Text",
 CellID->22386],
Cell[43776, 959, 1528, 51, 70, "Text",
 CellID->5021],
Cell[45307, 1012, 449, 12, 70, "Text",
 CellID->28745],
Cell[45759, 1026, 729, 20, 70, "Text",
 CellID->26924],
Cell[46491, 1048, 1660, 50, 70, "DefinitionBox3Col",
 CellID->19072],
Cell[48154, 1100, 91, 1, 70, "Caption",
 CellID->6270],
Cell[48248, 1103, 869, 29, 70, "Text",
 CellID->147896217],
Cell[49120, 1134, 1023, 30, 70, "Text",
 CellID->317600427],
Cell[50146, 1166, 1686, 49, 70, "DefinitionBox3Col",
 CellID->15573],
Cell[51835, 1217, 58, 1, 70, "Caption",
 CellID->5097],
Cell[51896, 1220, 583, 15, 70, "Text",
 CellID->16512],
Cell[52482, 1237, 689, 21, 70, "Text",
 CellID->23986],
Cell[53174, 1260, 1203, 36, 70, "Text",
 CellID->13290],
Cell[54380, 1298, 1513, 44, 70, "DefinitionBox3Col",
 CellID->9161],
Cell[55896, 1344, 95, 1, 70, "Caption",
 CellID->18636],
Cell[55994, 1347, 806, 23, 70, "Text",
 CellID->22355],
Cell[56803, 1372, 619, 16, 70, "Text",
 CellID->95911523],
Cell[CellGroupData[{
Cell[57447, 1392, 71, 1, 70, "RelatedTutorialsSection",
 CellID->79478304],
Cell[57521, 1395, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[57723, 1403, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

