(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83100,       1752]
NotebookOptionsPosition[     76832,       1586]
NotebookOutlinePosition[     80865,       1676]
CellTagsIndexPosition[     80769,       1670]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StatusArea" :> 
          Documentation`HelpLookup["paclet:ref/StatusArea"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"StatusArea\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Options for Notebooks", "Title",
 CellTags->{"S2.11.13", "13.1"},
 CellID->6483],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Use the ",
     StyleBox["Option Inspector", "SR"],
     " menu to change options interactively."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Use ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetOptions"], "[", 
       StyleBox["obj", "TI"], ",", 
       StyleBox["options", "TI"], "]"}]], "InlineFormula"],
     " from the kernel."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Use ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDocument",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDocument",
        ButtonNote->
         "ObsLink: NotebookCreate -> CreateDocument (CreatePalette)"], "[", 
       StyleBox["options", "TI"], "]"}]], "InlineFormula"],
     " to create a new notebook with specified options."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27595],

Cell["Ways to change the overall options for a notebook. ", "Caption",
 CellID->4041],

Cell["\<\
This creates a notebook displayed in a 40x30 window with a thin frame. \
\>", "MathCaption",
 CellID->3602],

Cell[BoxData[
 RowBox[{"NotebookCreate", "[", 
  RowBox[{
   RowBox[{"WindowFrame", "->", "\"\<ThinFrame\>\""}], ",", 
   RowBox[{"WindowSize", "->", 
    RowBox[{"{", 
     RowBox[{"40", ",", "30"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->24350],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["StyleDefinitions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StyleDefinitions"], "\"\<Default.nb\>\"", Cell[
    "the basic stylesheet to use for the notebook", "TableText"]},
   {
    ButtonBox["ScreenStyleEnvironment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ScreenStyleEnvironment"], "\"\<Working\>\"", 
    Cell["the style environment to use for screen display", "TableText"]},
   {
    ButtonBox["PrintingStyleEnvironment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrintingStyleEnvironment"], "\"\<Printout\>\"", 
    Cell["the style environment to use for printing", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10291],

Cell["Style options for a notebook. ", "Caption",
 CellID->30836],

Cell[TextData[{
 "In giving style definitions for a particular notebook, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you either to reference another notebook, or explicitly to include \
the ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression that defines the styles. "
}], "Text",
 CellID->9374],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["CellGrouping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellGrouping"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to group cells in the notebook", "TableText"]},
   {
    ButtonBox["ShowPageBreaks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowPageBreaks"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to show where page breaks would occur if the notebook were printed\
\>", "TableText"]},
   {
    ButtonBox["NotebookAutoSave",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NotebookAutoSave"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to automatically save the notebook after each piece of output\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11020],

Cell["General options for notebooks. ", "Caption",
 CellID->4596],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellGrouping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGrouping"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", cells are automatically grouped based on their style."
}], "MathCaption",
 CellID->24021],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 131},
 ImageMargins->0,
 CellID->1818405755],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellGrouping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGrouping"], "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 ", you have to group cells by hand. "
}], "MathCaption",
 CellID->23199],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXAd0VEUXfmxLQggJAUQgh4RqQcGGiigJCT/YQAWUjgQEiUdawA6iRmzY
sGOhaDgooqKiov7HiqICFhSsqKBgQKWpIAjOf7/75k5mw27Y3ewi+GfOeZvd
92bu3Da3zbx0Kxw/YtjIwvFFQwtzuhYXjhlRNHRcTpfRxXTLW8NxPPUdxynJ
cfBd0Vf9Ud4a4MNxvO4vfkYfdfFRQ9/xmkeOPK+s07fffkvPn3rqKf6ojQ8P
3/TyTYEjA/3lE1OjfmrlypWO+w0fqTzWh7vyVL3wwgue0JPjT/nYjErmDR7j
ccdIq4WPyrAOBGEtuDHRwp6aPMBnyNIdKkG84oQuMdKS+Le/IqvQ24krUFzE
4fgCDYlpUlguBmtpchgsE0J6XIFaNO0DTPc7furFup8L6cDiZyxY7tSwps1Y
rAYMm81Xv6GlavKU/zrxRn6Hhrd5y3a1rmwLX6vXbFQ9+s+M51y5+PSonTt3
0oMdO3aon3/+mR949Sc9Ub/99lvQPfTTjYC69zZs2GDGpuh727Zt405//fWX
66A8+CojNm/erHbv3s2/kvW97du3G8i+Smazx8psGstyFl6sH5St30pims2/
4mhZmHVOc/XOO++oY489Vt16663q4YcfVgMHDlSff/45j3/55ZdVrVq11HHH
HafGjx+vdu3axTQOHjxY1alTR1100UXq+++/5779+/dXt99+uyotLVXjxo3j
e/Pnz+f5XnvtNfX++++rGjVqqNmzZ6utW7cyjKOPPlpdf/31KisrS82aNUtL
KFP9+eef6qijjlKXXHKJWr9+vRo9erTy+/3qnHPOYfjg6ZgxY9QzzzzD85x5
5pkqNzdX/fTTT+rtt99WLVu2VNOnT3fB1QuLckWwIG/y5MmqZs2aatmyZeqD
Dz5Qqamp6oYbbuBnr7zyijrkkEN47KgIpBOjScnjh3XVY489pp599lnRCnXH
HXeooUOH8vfOnTuztNDAzYULF6qnn36aJfXjjz8yugsWLGCut2/fXmueT/Xp
00d9+umnzBKayqPVt0GDBqqsrEw9+uijKj8/n4f//fffKj09HeBdRtZRX3/9
tWratCnP+ssvv6iDDjpIrVq1in9jptWrV/PQyy+/nJlcr149tWbNGn4OJl52
2WV6XaSFxDYczC+++AKM1+j61ZFHHqmWL1/OfYAmrVyn6lKJdM2kqCVLlii7
QblOPPFE5ip0mXAy1gbP7rrrLg3TZXdxcbEaO3asGX/11VerSZMmBUvFpw4+
+GCWyqBBg9RNN90k1gNc/eOPPyyIfuZQq1atGNoTTzwBNXdtFvX/8MMP1aGH
HgoJGAt03XXXqQkTJuhf4TD1CiyrX0CkYbC3pTE2QgHEGBN00iiQHWaDhPsP
Pvggj+vYsaNH3XPPPcQ42KFPPvlE3XjjjerFF1/0araDaDyS1qtXLyY4DNvv
vPNO9cADD9hs//3338OyHdbirLPOclwkAmxQxSFAkZOTk2H4bQlcddVVQRLQ
+AbpigYLoHwJWC0FAWcJweXymAglEeNSyNPM+uGHH1S7du3Yjk6bNs1FJ0td
c801bMXRmjVrxh4F1oMsAN9btGiRGjlyJFMxZMgQvgerjtWzbt06tWXLFvYW
sCLww02aNGErAWyxHNB+/fVX5fP5IBSXgWkMDsYfDYbhyiuv5O+w5uAQGhwv
MCZsoQ1BS0L3dwReKJTDwQ02UvGWSOUuo5MG3bZtW16atOQ1DT52oDA2AwYM
gFhc9NKFfPYor776KoOdOnUqa/3w4cPVvffey/fgGOGLyZ+yvb722muN+qMv
bBdYB6dJMYyeNl3dfPPNqm7duqzTkCyc56WXXsq+GnEFxHDLLbeo5s2bs48o
LCxkb0fSJPh5eXna+uim56wVEu+KsC1x/FPrI5c/A2rTpk0qLS1Nbdy4kcfA
tRFLGuvZwSH473IK3UgQ0Y1Lr3vv448/VnfffTf/qq1BY03ZdviII45gq4c2
WgtfYv2+Q0pVzwGzQoXeMZYP8jQo6An8PVY87BQZVKeRxnrx4sUcQBHxTjPN
YUTkiPkEcywrhBmEuROEuqQOy1esA/rhsoaYvYjPhLNoZKxEJjDyeKQ4PnZn
hU2ShuidbJIdcQQnVd17T8ffkIlOVYo1oZIqXNu27QybVFXXcKprOHGSenUN
p7pmGx1QMViRVJyqusDiUnGqXE+680MvR4BwEAhVJHS3Sz98L27FIokc7LEI
rZEDGeolbE1oNONTzz//POcxBQUFiI1dFDMYFUpQVSAQ4HzlkUce4aG8FUIN
lQxE7a+//jrHCWh71GniXPZJDVn2QYWhTZs2qn79+hxBQsQ0nIju3LkzcWzt
2rVBJSC0YcOGIVd2mSgJW4IS3DwNvnXr1ibe82rwX331FUfLaMiPMjMztZIk
cfUEkRXqAsj1Uc8MrrjEs3qTEbJ6g8gcotK1CfXkk0/yX6vWUDEqR+iry6z7
RI/ztGpAy+677z4lTa9NZlGLFi2CWCxlj88++4xD7NNOO80my6exS1QFBkUK
rBtbE0Jw1GXNpKqwL5IUc0/WIc8LxzrRTmhJRkYG1zugpcI++u2E4l9CSimp
bFdgflBGQao7d+5cW5JxZmek2liPWdqlSxdeeF27dkXyy2NXrFhhWPrNN9+w
LYQRQAGXbIsqKSnhZ5pOqWBIhTW+xZCMkMUQmF2ggoZnGBeGpVFxtEpJaWZI
JQWpqBXCd6HNmDFDdejQgYsJOTk57H3QD2YX7oK8u1uHqGvXIQy4+Nc29qzJ
QGrwRijf9OvXz2ShcVHYmL1TMmuP1IfQ4P+l7kI419RY2EULWZeRFTf8KDMZ
EnWhw0V/IneIvbIRyd5LCgc6iBHOPvtsliQqFrDEqHZB9/Pz85223DfA4Qc2
TYBuxeqGYBthMSMGle+imQhdQUUUv9pq8PDMiASkkf64803QHaKpWsSaWcRS
tajOCg/ErHC/42d1Fej/sQq0PwlpvgaDAgBOWuA+quKbNm1yB/xHd0jwoRzO
w3WB4cILL1QpKSnklRweC2+OUNMwIF+QjrCUEqNauDgF1Pnnn8/35EKmlJWV
5dHoYQMBCYFBr7OmJUFR+TwNCkENDsYcdthh6vDDDweLzBYxEhJBF/tq5ZJM
SO7VXHMKWoToHfcR9CP2o4gjYGGMoQg1P/roI0S0jjxDYIIMFkNxfIEUQT/z
ceiAggCKARRCpOgh0BXsJ82bN4+zLkSvLSuZyq/B4RwVoleMJdDJ+jbAvffe
e+rdd99F9yxNk6TegAhRgweo0FSZpXuXdI4Gj+EI0X0+n1kUDRs2xOY/QigT
u6KggY1o9BDtTEpKUlOmTAk68oGECMUTux9KYzjA4/ZwCQEnNDy+evbsyTif
d955elzAHMVCg5xuu+02zOnVYLFHjjwM/JcNX9RgBGRZWZlghWMNuJWWlqaZ
6GMRSdcRI0YIBATjcpvi/Ejpl3QfaQwKaAICvMDJIkpr9Dg/lwSloZ5Xu3Zt
8wzpPXLzU089lcd7vV6z8og3Bi7xxhM5ze69FE5jkagBK5QG+/bty+qNZA19
aYxtmhOWq2Zr8DhBgVKcw2YAnz6ufEorLS31asaA2balpETK7MUjB4U2yDP6
7sg4JFN2o1zSEQ0C+cFK5wtSuqKiIq/WRRs8LtReSe5RyCA6vRPSUPu15yU2
aPQzJJdkqeIwiCZdHX/88bIGjS6ifqI3dtVLL72Efj5NMYbiEJxWt6prmxRS
kNuSbmtmu5NlZmZycilrIxplizGaz9bKjzKTYI4Ta8jav/vuOxbIQw89BHS0
FtTm2g7cAhYJ+oMMaBks9dKlS9kx4j5Mm9SJ27Vr59GaPHHiRHZYb7zxhsrO
zuauAAVTJYxEnQb3PR4PGOneTqvIdoYMDNEN9yApnCmFUwODCROju48//rjR
XZKTYIMDXXaLWCvrVNRKHh4NX8jUGewuvpiP9bIakjuQ23B8aHCGrVu3ltuo
wGEjBDw45ZRT5DYpqKGDWBVq1UZIuVhsHCcVEk844QRWhVGjRuHwr7H0oqlK
4rCCCFU2hlwxW4MBSylUNeyk6MQUjFHfE5xREFu4cKHxIFKGlEZ6SM9I0cmK
oQIFpspYHE+zrBgcLIquuEiqso5FU+GnZEcglJqSMxYkdEnatJkzZxo9QL0o
nloaCKmlxJK9c8TPHIEhkOGDBw82Ww3advExcDQKOQ2XYcPsRlG6E4uOplRG
N/9eu3atmRW+Uhe6uFFaVXUdjTGCbKJlgg0PFG5xzZkzx69nQN1WmIooberU
qQZV7PUgjaDLTSio/1tvvcVBoYyhMMW8HxCpAtJSFk7B8tqNIg0jH8S3ewgi
7gpIBIenN43pBevE88K+4/0DBIfYjUTaZSvfc889pwlINsGyNJhOOFYndg/u
30Pv3nzzTSMwa0Lj3XXcxm6TnyQ4Y2mh0YeYwCTEsUysiyLeCECs53LIVQJU
rLF/KNT26dMnap2ifu4UqRyt2g2OTOIrWGjkKFqnHFEqFMijUarhw4dXplRE
YYpFHBrKF4j4SIFM5gRlQsRnKxClssIrK8Q24sTxWSf6hIPoC6dAlNoYBRLf
b8+I/fioFagKBa6mGjw0Aptc5OVcwJp6bMZTuG2M7bnnnstaJRctAvMMnhLx
jbCBBGByUBx7xTYlrg0bNkTrRXv16iWz4H0hu1GqZowY7IM0y4ihymA3MQvh
9I2CVkHGLuwg/UcjfuydHcnMDrshRETGDM/boUMH0QJRxWXLlpmhKDPZDbYM
/aK3ZUS6qKJFNQPFmXChA7vMdiNjmyAfWnmcJxUYWBEcHnaxcz9hVVCVEetB
gb7BHzGq3aB6su6//PLLIGeApJnmFW7hNI9wa+7cudFqJimIIIEdWbuRMTKa
CcSlGc30cU4kjWIaYXnjxo0NyyV2sBVUp0faagRU7969zTMkx5o9e+eO33AH
ZwyOOeYYvHyhwdbkIxbQFkdnamg4oSMROGI6c+rLfctGsIhOS4kNkurhwJXc
FjYgHhWfgrlRt0SDb6HV9I9Fe9n8mcJnSARnXCge4CTBFVdcwWVZHA73aVF1
69bN9DvppJP4mFxubq4oBG5JIwMilOE1GASPJ598siOeF74Mm7lI1/HiBbgF
qKiW4bccwwhVyMGRdor4xEBCf3AIpqioyOTUcN6rVq0yKaEtL/RBlR5nEdq0
aWMEYGUxWm+TgvQWF879gJSCggJTALENNDFIwFn8cSQzsBmESjtAor6DshXq
jOU1RR9SZNO3uLhYwCJNwTtGJCKDQTTpia8i/aGSOCJR5sPJEKBK3slU2aqU
PMdc7/Ez+0QSkAJF2+YQKcDjfJBLjGs8sReE01rScCjm9NNPD2gy7r//fr69
YMECEzbgWESw3vmD+IjSCFkT0x+Kpt/Zc0IZh0GDBkkRHoLW7/iYjQxbv9q3
b8/nzAT7M844Q9lNU+gPQxw24tLT0+UxlrEcLUXDPgaZSCkR4khHo0aNYjB3
hqKATZGZg1yPzAGrLEmPZNcJTimyNcKyEQHDS47Ap29jTcHSwCKZI3dJfMYT
zqxTp05c3ENAgWAcZQW/lheKSD169GDGwdXgDfFFixa5IFJYs/GiuORQ0Av8
njVrFiONF4k8XKpOZS9hNySHF1xwAR9BxctDOJcJi7B06VJteVP4ICUWLS7s
PUHnunfvzujgL2XHeinUrJjSsseBYFEEAgdwpIdiFF8E1EsfoIgIGyLFuUak
j4gu8Z6ToIhoG3DQB3te6I/UTlTAzkNADiIOXBw6RE6lTAcvAB/VsWNHngIb
wfD5QB1gifI4ZLGRRHw+zlyF44Sz5A14y1BuE9caakT2jM7cmgv8IS6Sjehx
BVG20hBCsbQCBMZ3YKJJT+IQwd5KQfUDmkQLwfgLeakZIxpUwoQK1icGJoQK
cqvEhMj3XeWVgXIH5OUoR2f1jkgfiT+KqSUlJfsJ4TF65aYaIEBgISKdxC4M
Thni8C9GNNXo4YQ9zA4uSiWFQCTWc+bM4WvJkiVCIPwWDrTiv2h4QkPYF5Ll
DrsSt4T45u59QMNOzcPEvT8bNE3i3nXlDqHew4r6JdUIdmz48UrlOCaL3f8O
ff5bTpaVA6w+/ncA87P6uO9+rEph13sw6dba+NeQvm/Xe2h+xl2VtID+CSwP
8LWeEKkH//9Um5/uTSfm/59a/q9na/G03khdtzsLPiL/t7GxjZGWwb+DdXPP
MY4whD94Y8MN8y1I+r/4OjX+B1iBkgU=\
\>"], "Picture",
 ImageSize->{533, 131},
 ImageMargins->0,
 CellID->1610645197],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["DefaultNewCellStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DefaultNewCellStyle"], "\"\<Input\>\"", Cell[
    "the default style for new cells created in the notebook", "TableText"]},
   {
    ButtonBox["DefaultDuplicateCellStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DefaultDuplicateCellStyle"], "\"\<Input\>\"", 
    Cell["\<\
the default style for cells created by automatic duplication of existing \
cells\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24484],

Cell["\<\
Options specifying default styles for cells created in a notebook. \
\>", "Caption",
 CellID->8281],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to take any cell option and set it at the notebook level, \
thereby specifying a global default for that option throughout the notebook. \
"
}], "Text",
 CellID->4734],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow cells in the notebook to be edited", "TableText"]},
   {
    ButtonBox["Selectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Selectable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow cells to be selected", "TableText"]},
   {
    ButtonBox["Deletable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deletable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow cells to be deleted", "TableText"]},
   {
    ButtonBox["ShowSelection",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowSelection"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to show the current selection highlighted", "TableText"]},
   {
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}], Cell[
    "what background color to use for the notebook", "TableText"]},
   {
    ButtonBox["Magnification",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Magnification"], "1", Cell[
    "at what magnification to display the notebook", "TableText"]},
   {
    ButtonBox["PageWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageWidth"], "WindowWidth", Cell[
    "how wide to allow the contents of cells to be", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, False, {False}, False},
    "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->53],

Cell["\<\
A few cell options that are often set at the notebook level. \
\>", "Caption",
 CellID->1999],

Cell[TextData[{
 "Here is a notebook with the ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " option set at the notebook level. "
}], "MathCaption",
 CellID->26418],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWVlTVEcUvszisNeAgCCrBAGBAIpCAUWBxeZGYQm4FBQybMUiEIwKBEKK
nVLjBoq4gSxWXnhK8Vd49C8kVfkBJ/2d6b5zIcwEZSSaqZq+vZw+/fV3lr7T
U+W409HW47jT2eJIqLzt+KGjs+XHhIq+26LL7KNppnBN0/ISNNRJVGXh+hxB
oWlmZ4vHRHEYhY/sMetDmhr3JPTx40cxvrGxwUUwChN3mrlT6VETra6FxUfI
0dbWluasoQjguRb0qlHa3Nw07b44Hq65dg/rbp9jcs5Rn0AUnlAf2oZaYeNN
nz17lgt/FAK42pYU8ADcuCC0fPjwQQyIkgsbt61O/S6qIK15VSm+gmHvKt0V
qc0ti6DOpdDXDcovsnWvKjXs6QCQeuZzgNWYaX19nVXri/x6UPTK2P0qbFbv
jo3fvMN2tzv9i97bQ6u7NZa+hVzxh0Q/NbtO/Xce4yuERRnqnfzxvdT/5s0b
Wltb49Yh2beyskLv3r3jlq+BRciiZTH0Ya6QFS1X39OnT+n9+/dakOx79eqV
bgGrLJeXl1WfWk/zQ8tEq6urJjlTonDRMiQHQIkasHvPZxK5PEJDQ0Pk7+9P
ycnJ9PDhQ17q1q1bPPfMmTP0/PlzOnfuHJnNZjp9+jR1dXXR69evKT8/n2Ji
YujBgwc8Z3BwkGw2Gx07dowuXrwItiRTvjQ5OUm+vr5UU1PDzCYmJlJ/fz/V
1tbSixcvnGJRrLqoqIhGRkZYFGqfPHlCaWlpDLO6upqngURAOnr0KM3NzVF7
ezv5+PjQ6Ogozc7OMozm5mZaXFyk2NhYCgwMpJKSEkCVBg2jy5cvs96JiYnd
oNPAwAAVFxczhs7OTvLz82P9wtgUHx9Ply5dooWFBcYVFRXFFhv+shb7Tqo/
fvw4Xb16lVtO7/GnoKAg6unp4S0HBwfT48dOCOPj4/Ts2TNqa2uj0tJSk0ST
kZHBXRB5+/YtdiuZsVFcXBxNTU3R0tISMwOZCxcuUFNTkzSone7evctWgAys
8PLlS2auoaFBd3OwhDpkT506xXWEh91uN8mlMBUR1NLSwr4FdRDr6+uTcOys
Bv6D/l1gc72xsZEd4cSJE2x49D169IjCw8NVeCFYgVIPr5/2YKx9nNrKWIB0
/fp1g7EsFBISgi1Sb28vlZeXW2RGkjZiNMgZoaGhgG2TZIGI6elpHgZRiBSY
XZhaUyru37/PQZmVlcVyUDE2NmbkGyJGkyAehUl0cMomubm5CESV7BFHiC0D
MN1jYG2YD/EjEyynksjISCfXv+wnMDwn96Q98IwYz8nJMbELW6i+vp63sSMm
UlNTIcBf+LHYrc6rkfvMzEx2REGS8tH5+XnOoUgqIANiMAP6UUfSsFqtnEuN
3MMhd4QD3Bi5BfkPSODawk8kkkC2w8zMDE9XiG/evKkQ69GHnNTR0aHcX5rD
5f6jB5OrYJakpCQqKysTcihDONXCLAhJpHQsj4SDraF+7do1znHwTOQxUAEG
MRYREWFI4zaKjo5mw8DtUlJS+IlsIVKzpo4VMF5XV8fz7927x0+cPCp7DA8P
81zUEZIJCQlMIdJ9QEAAp3kEHOqqHzohX1VVBV16tjKaZxfcXIeb4vS8cuWK
7i3KPp8SLZ/5Fu0+M9n1iMGyONngiSdPnuRzAOY4f/48VVZWcn7BE9Sgr7Cw
ENu1GM57OKdiorW1lZnNzs7GEaAMg83fuHGD/VfkQRbFqwVIhd/n5eWxcSEH
gyE5wpCIE+Hb5HA42LnkztihcDACUUFBAcJNOsFhhgQDVlRUcJzsQK4fltCN
94nu7m7ePQwPjHiHgGMKLM4A+vlgAgiOuf2wN/MBj8MerVDD+aZgqJwIXqUJ
tADZh9dMvDt5JxF4zs3OPfixJ+HMSE9P14MA/OKdCoEg0qS+j7CwME6TOr7f
vyzPRVI9XpyU+k9adz8/p/5EYXH3U2c/v6n+2g/6PVzHMHKrJ+Tf8J3M9v0b
Uu3/5jrqYC9hdufT69d70kD/Bcqv7k7l4G+K/6F0+9W4kc/9Xo27/lUI5GXN
e/2h9jn/CHzeHPWxc9vpm2r03/5PCUVhco65NMk/aDSfvwGyBxZ1\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->772684806],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["Visible",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Visible"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the window should be visible on the screen", "TableText"]},
   {
    ButtonBox["WindowSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowSize"], 
    RowBox[{"{", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], "}"}], Cell["\<\
the width and height of the window in printer\[CloseCurlyQuote]s points\
\>", "TableText"]},
   {
    ButtonBox["WindowMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the margins to leave around the window when it is displayed on the screen\
\>", "TableText"]},
   {
    ButtonBox["WindowFrame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowFrame"], "\"\<Normal\>\"", Cell[
    "the type of frame to draw around the window", "TableText"]},
   {
    ButtonBox["WindowElements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowElements"], 
    RowBox[{"{", "\"\<StatusArea\>\"", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "elements to include in the window", "TableText"]},
   {
    ButtonBox["WindowTitle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowTitle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what title should be displayed for the window", "TableText"]},
   {
    ButtonBox["WindowMovable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowMovable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow the window to be moved around on the screen", 
     "TableText"]},
   {
    ButtonBox["WindowFloating",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowFloating"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the window should always float on top of other windows\
\>", "TableText"]},
   {
    ButtonBox["WindowClickSelect",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowClickSelect"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the window should become selected if you click in it", 
     "TableText"]},
   {
    ButtonBox["DockedCells",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DockedCells"], 
    RowBox[{"{", "}"}], Cell["\<\
a list of cells specifying the content of a docked area at the top of the \
window\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, False, False, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6900],

Cell["Characteristics of the notebook window. ", "Caption",
 CellID->3788],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WindowSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowSize"]], "InlineFormula"],
 " allows you to specify how large you want a window to be; ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " allows you to specify where you want the window to be placed on your \
screen. The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowMargins"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["left", "TI"], ",", 
       StyleBox["right", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["bottom", "TI"], ",", 
       StyleBox["top", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " gives the margins in pixels to leave around your window on the screen. \
Often only two of the margins will be set explicitly; the others will be ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", indicating that these margins will be determined from the particular size \
of screen that you use."
}], "Text",
 CellID->18127],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WindowClickSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowClickSelect"]], "InlineFormula"],
 " is the principal option that determines whether a window acts like a \
palette. Palettes are generally windows with content that acts upon other \
windows, rather than windows which need to be selected for their own ends. \
Palettes also generally have a collection of other option settings such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFrame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFrame"], "->", "\"\<Palette\>\""}]], 
  "InlineFormula"],
 "."
}], "Text",
 CellID->402027597],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DockedCells",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DockedCells"]], "InlineFormula"],
 " allows you to specify any content that you want to stay at the top of a \
window and never scroll offscreen. A typical use of the ",
 Cell[BoxData[
  ButtonBox["DockedCells",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DockedCells"]], "InlineFormula"],
 " option is to define a custom toolbar. Many default stylesheets have the ",
 Cell[BoxData[
  ButtonBox["DockedCells",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DockedCells"]], "InlineFormula"],
 " option defined in certain environments to create toolbars for purposes \
such as presenting slideshows and editing package files."
}], "Text",
 CellID->29208453],

Cell[BoxData[GridBox[{
   {"\"\<Normal\>\"", Cell["an ordinary window", "TableText"]},
   {"\"\<Palette\>\"", Cell["a palette window", "TableText"]},
   {"\"\<ModelessDialog\>\"", Cell[
    "a modeless dialog box window", "TableText"]},
   {"\"\<ModalDialog\>\"", Cell["a modal dialog box window", "TableText"]},
   {"\"\<MovableModalDialog\>\"", Cell["\<\
a modal dialog box window that can be moved around the screen\
\>", "TableText"]},
   {"\"\<ThinFrame\>\"", Cell[
    "an ordinary window with a thin frame", "TableText"]},
   {"\"\<Frameless\>\"", Cell[
    "an ordinary window with no frame at all", "TableText"]},
   {"\"\<Generic\>\"", Cell["a window with a generic border", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->467],

Cell[TextData[{
 "Typical possible settings for ",
 Cell[BoxData[
  ButtonBox["WindowFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowFrame"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->3728],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows many different types of windows. The details of how particular \
windows are rendered may differ slightly from one computer system to another, \
but their general form is always the same. ",
 Cell[BoxData[
  ButtonBox["WindowFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowFrame"]], "InlineFormula"],
 " specifies the type of frame to draw around the window. ",
 Cell[BoxData[
  ButtonBox["WindowElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowElements"]], "InlineFormula"],
 " gives a list of specific elements to include in the window. "
}], "Text",
 CellID->14893],

Cell[BoxData[GridBox[{
   {"\"\<StatusArea\>\"", Cell[TextData[{
     "an area used to display status messages, such as those created by ",
     Cell[BoxData[
      ButtonBox["StatusArea",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<MagnificationPopUp\>\"", Cell[
    "a popup menu of common magnifications", "TableText"]},
   {"\"\<HorizontalScrollBar\>\"", Cell[
    "a scroll bar for horizontal motion", "TableText"]},
   {"\"\<VerticalScrollBar\>\"", Cell[
    "a scroll bar for vertical motion", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24648],

Cell[TextData[{
 "Some typical possible entries in the ",
 Cell[BoxData[
  ButtonBox["WindowElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowElements"]], "InlineFormula"],
 " list."
}], "Caption",
 CellID->22483],

Cell["\<\
Here is a window with a status area and horizontal scroll bar, but no \
magnification popup or vertical scroll bar. \
\>", "MathCaption",
 CellID->17807],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{540, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->2421],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->49759293],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Options for Notebooks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/OptionsForExpressionInputAndOutput"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GlobalOptionsForTheFrontEnd"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 39.7929226}", "context" -> "", 
    "keywords" -> {
     "automatic grouping", "background", "CellGrouping", "checkpointing", 
      "click to type", "DefaultDuplicateCellStyle", "DefaultNewCellStyle", 
      "deletable", "dialog boxes", "Editable", "EditBar toolbar element", 
      "evaluation", "flicker", "floating window", "window frame", 
      "frameless window frame option", "generic window frame option", 
      "cell grouping", "hierarchy", "highlighting", 
      "HorizontalScrollBar window element", "invisible selection", 
      "invisible windows", "label", "locking", "locking notebooks", 
      "magnification", "MagnificationPopup window element", "margins", 
      "ModalDialog window frame option", "ModelessDialog window frame option",
       "MovableModalDialog window frame option", "moving", 
      "normal window frame option", "NotebookAutoSave", "Page breaks", 
      "PageWidth", "palette window frame option", "palette windows", 
      "positioning", "PrintingStyleEnvironment", "protection", 
      "RulerBar toolbar element", "screen sizes", "ScreenStyleEnvironment", 
      "selectability", "selectable", "selection", "ShowPageBreaks", 
      "ShowSelection", "StatusArea window element", "StyleDefinitions", 
      "styles", "templates", "ThinFrame window frame option", "title", 
      "toolbars", "VerticalScrollBar window element", "visible", 
      "visible selection", "WindowClickSelect", "WindowElements", 
      "WindowFloating", "WindowFrame", "WindowMargins", "WindowMovable", 
      "WindowSize", "WindowTitle", "WindowToolbars", "write protection"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Ways to change the overall options for a notebook. This creates a \
notebook displayed in a 40x30 window with a thin frame. Style options for a \
notebook. ", "synonyms" -> {"2.11.13"}, "title" -> "Options for Notebooks", 
    "type" -> "Tutorial", "uri" -> "tutorial/OptionsForNotebooks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.13"->{
  Cell[1828, 59, 86, 2, 70, "Title",
   CellTags->{"S2.11.13", "13.1"},
   CellID->6483]},
 "13.1"->{
  Cell[1828, 59, 86, 2, 70, "Title",
   CellTags->{"S2.11.13", "13.1"},
   CellID->6483]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.13", 80553, 1659},
 {"13.1", 80655, 1663}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1203, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1828, 59, 86, 2, 70, "Title",
 CellTags->{"S2.11.13", "13.1"},
 CellID->6483],
Cell[1917, 63, 1299, 37, 70, "FramedBox",
 CellID->27595],
Cell[3219, 102, 85, 1, 70, "Caption",
 CellID->4041],
Cell[3307, 105, 117, 3, 70, "MathCaption",
 CellID->3602],
Cell[3427, 110, 268, 8, 70, "Input",
 CellID->24350],
Cell[3698, 120, 1101, 26, 70, "DefinitionBox3Col",
 CellID->10291],
Cell[4802, 148, 65, 1, 70, "Caption",
 CellID->30836],
Cell[4870, 151, 397, 12, 70, "Text",
 CellID->9374],
Cell[5270, 165, 1317, 37, 70, "DefinitionBox3Col",
 CellID->11020],
Cell[6590, 204, 65, 1, 70, "Caption",
 CellID->4596],
Cell[6658, 207, 359, 12, 70, "MathCaption",
 CellID->24021],
Cell[7020, 221, 6565, 110, 70, "Picture",
 CellID->1818405755],
Cell[13588, 333, 333, 12, 70, "MathCaption",
 CellID->23199],
Cell[13924, 347, 6439, 108, 70, "Picture",
 CellID->1610645197],
Cell[20366, 457, 933, 24, 70, "DefinitionBox3Col",
 CellID->24484],
Cell[21302, 483, 109, 3, 70, "Caption",
 CellID->8281],
Cell[21414, 488, 246, 7, 70, "Text",
 CellID->4734],
Cell[21663, 497, 2184, 63, 70, "DefinitionBox3Col",
 CellID->53],
Cell[23850, 562, 103, 3, 70, "Caption",
 CellID->1999],
Cell[23956, 567, 245, 8, 70, "MathCaption",
 CellID->26418],
Cell[24204, 577, 2248, 39, 70, "Picture",
 CellID->772684806],
Cell[26455, 618, 3333, 98, 70, "DefinitionBox3Col",
 CellID->6900],
Cell[29791, 718, 74, 1, 70, "Caption",
 CellID->3788],
Cell[29868, 721, 1254, 36, 70, "Text",
 CellID->18127],
Cell[31125, 759, 907, 26, 70, "Text",
 CellID->402027597],
Cell[32035, 787, 769, 19, 70, "Text",
 CellID->29208453],
Cell[32807, 808, 1075, 24, 70, "DefinitionBox",
 CellID->467],
Cell[33885, 834, 211, 8, 70, "Caption",
 CellID->3728],
Cell[34099, 844, 675, 17, 70, "Text",
 CellID->14893],
Cell[34777, 863, 933, 22, 70, "DefinitionBox",
 CellID->24648],
Cell[35713, 887, 229, 8, 70, "Caption",
 CellID->22483],
Cell[35945, 897, 163, 4, 70, "MathCaption",
 CellID->17807],
Cell[36111, 903, 40393, 666, 70, "Picture",
 Evaluatable->False,
 CellID->2421],
Cell[CellGroupData[{
Cell[76529, 1573, 71, 1, 70, "RelatedTutorialsSection",
 CellID->49759293],
Cell[76603, 1576, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[76805, 1584, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

