(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12270,        432]
NotebookOptionsPosition[      8255,        309]
NotebookOutlinePosition[     10830,        377]
CellTagsIndexPosition[     10737,        371]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Max" :> Documentation`HelpLookup["paclet:ref/Max"], "Min" :> 
          Documentation`HelpLookup["paclet:ref/Min"], "Ordering" :> 
          Documentation`HelpLookup["paclet:ref/Ordering"], "Permutations" :> 
          Documentation`HelpLookup["paclet:ref/Permutations"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Max\"\>", 2->"\<\"Min\"\>", 
       3->"\<\"Ordering\"\>", 4->"\<\"Permutations\"\>", 
       5->"\<\"Sort\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Ordering in Lists", "Title",
 CellTags->{"S1.8.11", "11.1"},
 CellID->6191],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sort"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "sort the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into order"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Ordering",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ordering"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "the positions in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " of the elements in ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sort"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Ordering",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ordering"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Ordering",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Ordering"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Ordering",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ordering"], "[", 
     StyleBox["list", "TI"], ",", "-", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the last ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Ordering",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Ordering"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Permutations",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Permutations"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "all possible orderings of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Min",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Min"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "the smallest element in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Max",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Max"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "the largest element in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}}},
 CellID->19815],

Cell["Ordering in lists. ", "Caption",
 CellID->22888],

Cell["Here is a list of numbers. ", "MathCaption",
 CellID->19156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"{", 
   RowBox[{"17", ",", "21", ",", "14", ",", "9", ",", "18"}], 
   "}"}]}]], "Input",
 CellLabel->"In[50]:=",
 CellID->11511],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"17", ",", "21", ",", "14", ",", "9", ",", "18"}], "}"}]], "Output",\

 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->136194468]
}, Open  ]],

Cell[TextData[{
 "This gives the elements of ",
 Cell[BoxData["t"], "InlineFormula"],
 " in sorted order."
}], "MathCaption",
 CellID->9043775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", "t", "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->16371501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "14", ",", "17", ",", "18", ",", "21"}], "}"}]], "Output",\

 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]=",
 CellID->72494927]
}, Open  ]],

Cell[TextData[{
 "This gives the positions of the elements of ",
 Cell[BoxData["t"], "InlineFormula"],
 ", from the position of the smallest to that of the largest. "
}], "MathCaption",
 CellID->20328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", "t", "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->22646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3", ",", "1", ",", "5", ",", "2"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->514357352]
}, Open  ]],

Cell[TextData[{
 "This is the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", "t", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->18875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "14", ",", "17", ",", "18", ",", "21"}], "}"}]], "Output",\

 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->63876334]
}, Open  ]],

Cell["This gives the smallest element in the list. ", "MathCaption",
 CellID->2634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->24272],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->20055]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->398007354],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ordering in Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GroupingAndCombiningElementsOfLists"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RearrangingNestedLists"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 42.6679962}", "context" -> "", 
    "keywords" -> {
     "canonical order", "grade", "largest", "lists", "maximal element", "Min",
       "minimal element", "order", "ordering", "order statistics", 
      "permutations", "positions", "ranking", "smallest", "sort", "sorting"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Ordering in lists. Here is a list of numbers. This gives the elements of \
t in sorted order.", "synonyms" -> {"1.8.11"}, "title" -> "Ordering in Lists",
     "type" -> "Tutorial", "uri" -> "tutorial/OrderingInLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.11"->{
  Cell[2115, 62, 81, 2, 70, "Title",
   CellTags->{"S1.8.11", "11.1"},
   CellID->6191]},
 "11.1"->{
  Cell[2115, 62, 81, 2, 70, "Title",
   CellTags->{"S1.8.11", "11.1"},
   CellID->6191]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.11", 10523, 360},
 {"11.1", 10624, 364}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1490, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2115, 62, 81, 2, 70, "Title",
 CellTags->{"S1.8.11", "11.1"},
 CellID->6191],
Cell[2199, 66, 3078, 103, 70, "DefinitionBox",
 CellID->19815],
Cell[5280, 171, 54, 1, 70, "Caption",
 CellID->22888],
Cell[5337, 174, 66, 1, 70, "MathCaption",
 CellID->19156],
Cell[CellGroupData[{
Cell[5428, 179, 174, 6, 28, "Input",
 CellID->11511],
Cell[5605, 187, 241, 8, 36, "Output",
 CellID->136194468]
}, Open  ]],
Cell[5861, 198, 143, 5, 70, "MathCaption",
 CellID->9043775],
Cell[CellGroupData[{
Cell[6029, 207, 100, 3, 28, "Input",
 CellID->16371501],
Cell[6132, 212, 240, 8, 36, "Output",
 CellID->72494927]
}, Open  ]],
Cell[6387, 223, 201, 5, 70, "MathCaption",
 CellID->20328],
Cell[CellGroupData[{
Cell[6613, 232, 101, 3, 28, "Input",
 CellID->22646],
Cell[6717, 237, 234, 7, 36, "Output",
 CellID->514357352]
}, Open  ]],
Cell[6966, 247, 222, 9, 70, "MathCaption",
 CellID->4886],
Cell[CellGroupData[{
Cell[7213, 260, 117, 4, 70, "Input",
 CellID->18875],
Cell[7333, 266, 240, 8, 36, "Output",
 CellID->63876334]
}, Open  ]],
Cell[7588, 277, 83, 1, 70, "MathCaption",
 CellID->2634],
Cell[CellGroupData[{
Cell[7696, 282, 96, 3, 70, "Input",
 CellID->24272],
Cell[7795, 287, 155, 5, 36, "Output",
 CellID->20055]
}, Open  ]],
Cell[CellGroupData[{
Cell[7987, 297, 72, 1, 70, "RelatedTutorialsSection",
 CellID->398007354],
Cell[8062, 300, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[8228, 307, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

