(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50171,       1788]
NotebookOptionsPosition[     39773,       1449]
NotebookOutlinePosition[     43349,       1532]
CellTagsIndexPosition[     43256,       1526]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AccountingForm" :> 
          Documentation`HelpLookup["paclet:ref/AccountingForm"], "BaseForm" :> 
          Documentation`HelpLookup["paclet:ref/BaseForm"], "Column" :> 
          Documentation`HelpLookup["paclet:ref/Column"], "EngineeringForm" :> 
          Documentation`HelpLookup["paclet:ref/EngineeringForm"], 
          "NumberForm" :> Documentation`HelpLookup["paclet:ref/NumberForm"], 
          "PaddedForm" :> Documentation`HelpLookup["paclet:ref/PaddedForm"], 
          "ScientificForm" :> 
          Documentation`HelpLookup["paclet:ref/ScientificForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AccountingForm\"\>", 
       2->"\<\"BaseForm\"\>", 3->"\<\"Column\"\>", 
       4->"\<\"EngineeringForm\"\>", 5->"\<\"NumberForm\"\>", 
       6->"\<\"PaddedForm\"\>", 
       7->"\<\"ScientificForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Output Formats for Numbers", "Title",
 CellTags->{"S2.9.7", "7.1"},
 CellID->20024],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ScientificForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ScientificForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "print all numbers in scientific notation", "TableText"]},
   {
    RowBox[{
     ButtonBox["EngineeringForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EngineeringForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["\<\
print all numbers in engineering notation (exponents divisible by 3)\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["AccountingForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AccountingForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "print all numbers in standard accounting format", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26154],

Cell["Output formats for numbers. ", "Caption",
 CellID->29510],

Cell["\<\
These numbers are given in the default output format. Large numbers are given \
in scientific notation. \
\>", "MathCaption",
 CellID->4745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"6.7", "^", 
    RowBox[{"-", "4"}]}], ",", 
   RowBox[{"6.7", "^", "6"}], ",", 
   RowBox[{"6.7", "^", "8"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0004962503078612847`", ",", "90458.38216900002`", ",", 
   "4.0606767755664103`*^6"}], "}"}]], "Output",
 ImageSize->{242, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->826158805]
}, Open  ]],

Cell["This gives all numbers in scientific notation. ", "MathCaption",
 CellID->8313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScientificForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4474],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"4.9625\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"-4\"\>"]}],
     0.0004962503078612847,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"9.04584\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"4\"\>"]}],
     90458.38216900002,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"4.06068\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"6\"\>"]}],
     4.0606767755664103`*^6,
     AutoDelete->True]}], "}"}],
  ScientificForm]], "Output",
 ImageSize->{278, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//ScientificForm=",
 CellID->1769257780]
}, Open  ]],

Cell["\<\
This gives the numbers in engineering notation, with exponents arranged to be \
multiples of three. \
\>", "MathCaption",
 CellID->2168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EngineeringForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14018],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"496.25\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"-6\"\>"]}],
     0.0004962503078612847,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"90.4584\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"3\"\>"]}],
     90458.38216900002,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"4.06068\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"6\"\>"]}],
     4.0606767755664103`*^6,
     AutoDelete->True]}], "}"}],
  EngineeringForm]], "Output",
 ImageSize->{278, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//EngineeringForm=",
 CellID->1856932098]
}, Open  ]],

Cell["\<\
In accounting form, negative numbers are given in parentheses, and scientific \
notation is never used. \
\>", "MathCaption",
 CellID->9905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AccountingForm", "[", 
  RowBox[{"{", 
   RowBox[{"5.6", ",", 
    RowBox[{"-", "6.7"}], ",", 
    RowBox[{"10.", "^", "7"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17958],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"5.6\"\>",
     5.6,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"(6.7)\"\>",
     -6.7,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"10000000.\"\>",
     1.*^7,
     AutoDelete->True]}], "}"}],
  AccountingForm]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//AccountingForm=",
 CellID->77929235]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NumberForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["tot", "TI"], "]"}], Cell[TextData[{
     "print at most ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " digits of all approximate real numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ScientificForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ScientificForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["tot", "TI"], "]"}], Cell[TextData[{
     "use scientific notation with at most ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " digits"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EngineeringForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EngineeringForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["tot", "TI"], "]"}], Cell[TextData[{
     "use engineering notation with at most ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " digits"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10202],

Cell["Controlling the printed precision of real numbers. ", "Caption",
 CellID->3625],

Cell[TextData[{
 "Here is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Pi]", "9"], TraditionalForm]], "InlineMath"],
 " to 30 decimal places. "
}], "MathCaption",
 CellID->26477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Pi", "^", "9"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4414],

Cell[BoxData["29809.09933344621166650940240123965536386825`30."], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1939111622]
}, Open  ]],

Cell[TextData[{
 "This prints just 10 digits of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Pi]", "9"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->25824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"%", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->29334],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"29809.09933\"\>",
   29809.09933344621166650940240124`30.,
   AutoDelete->True],
  NumberForm[#, 10]& ]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//NumberForm=",
 CellID->437204082]
}, Open  ]],

Cell["This gives 12 digits, in engineering notation. ", "MathCaption",
 CellID->24372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EngineeringForm", "[", 
  RowBox[{"%", ",", "12"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->20159],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"29.8090993334\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"3\"\>"]}],
   29809.09933344621166650940240124`30.,
   AutoDelete->True],
  EngineeringForm[#, 12]& ]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//EngineeringForm=",
 CellID->1547449787]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["DigitBlock",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitBlock"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "maximum length of blocks of digits between breaks", "TableText"]},
   {
    ButtonBox["NumberSeparator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSeparator"], 
    RowBox[{"{", "\"\<,\>\"", ",", "\"\< \>\"", "}"}], Cell["\<\
strings to insert at breaks between blocks of digits to the left and right of \
a decimal point\
\>", "TableText"]},
   {
    ButtonBox["NumberPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPoint"], "\"\<.\>\"", Cell[
    "string to use for a decimal point", "TableText"]},
   {
    ButtonBox["NumberMultiplier",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberMultiplier"], 
    "\"\<\[Backslash][Times]\>\"", Cell["\<\
string to use for the multiplication sign in scientific notation\
\>", "TableText"]},
   {
    ButtonBox["NumberSigns",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSigns"], 
    RowBox[{"{", "\"\<-\>\"", ",", "\"\<\>\"", "}"}], Cell[
    "strings to use for signs of negative and positive numbers", 
     "TableText"]},
   {
    ButtonBox["NumberPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPadding"], 
    RowBox[{"{", "\"\<\>\"", ",", "\"\<\>\"", "}"}], Cell[
    "strings to use for padding on the left and right", "TableText"]},
   {
    ButtonBox["SignPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SignPadding"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to insert padding after the sign", "TableText"]},
   {
    ButtonBox["NumberFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberFormat"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to generate final format of number", "TableText"]},
   {
    ButtonBox["ExponentFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to determine the exponent to use", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28070],

Cell["Options for number formatting. ", "Caption",
 CellID->7487],

Cell["\<\
All the options in the table except the last one apply to both integers and \
approximate real numbers. \
\>", "Text",
 CellID->28297],

Cell[TextData[{
 "All the options can be used in any of the functions ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ScientificForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScientificForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EngineeringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EngineeringForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 ". In fact, you can in principle reproduce the behavior of any one of these \
functions simply by giving appropriate option settings in one of the others. \
The default option settings listed in the table are those for ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7518],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DigitBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitBlock"], "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " breaks digits into blocks of length ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->8177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", 
   RowBox[{"DigitBlock", "->", "3"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->17773],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"265,252,859,812,191,058,636,308,480,000,000\"\>",
   265252859812191058636308480000000,
   Editable->False],
  NumberForm[#, DigitBlock -> 3]& ]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//NumberForm=",
 CellID->1961604939]
}, Open  ]],

Cell["\<\
You can specify any string to use as a separator between blocks of digits. \
\>", "MathCaption",
 CellID->1763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", 
   RowBox[{"DigitBlock", "->", "5"}], ",", 
   RowBox[{"NumberSeparator", "->", "\"\< \>\""}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->2668],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"265 25285 98121 91058 63630 84800 00000\"\>",
   265252859812191058636308480000000,
   Editable->False],
  NumberForm[#, DigitBlock -> 5, NumberSeparator -> " "]& ]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//NumberForm=",
 CellID->525261029]
}, Open  ]],

Cell[TextData[{
 "This gives an explicit plus sign for positive numbers, and uses ",
 Cell[BoxData["|"], "InlineFormula"],
 " in place of a decimal point. "
}], "MathCaption",
 CellID->13985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.5", ",", 
     RowBox[{"-", "6.8"}]}], "}"}], ",", 
   RowBox[{"NumberSigns", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<+\>\""}], "}"}]}], ",", 
   RowBox[{"NumberPoint", "->", "\"\<|\>\""}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->3102],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"+4|5\"\>",
     4.5,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"-6|8\"\>",
     -6.8,
     AutoDelete->True]}], "}"}],
  NumberForm[#, NumberSigns -> {"-", "+"}, NumberPoint -> "|"]& ]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//NumberForm=",
 CellID->1904325233]
}, Open  ]],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints an approximate real number, it has to choose whether scientific \
notation should be used, and if so, how many digits should appear to the left \
of the decimal point. What ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does is first to find out what the exponent would be if scientific \
notation were used, and one digit were given to the left of the decimal \
point. Then it takes this exponent, and applies any function given as the \
setting for the option ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 ". This function should return the actual exponent to be used, or ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if scientific notation should not be used. "
}], "Text",
 CellID->29213],

Cell[TextData[{
 "The default is to use scientific notation for all numbers with exponents \
outside the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "5"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["5", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->7627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8.", "^", "5"}], ",", 
   RowBox[{"11.", "^", "7"}], ",", 
   RowBox[{"13.", "^", "9"}]}], "}"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->4802],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"32768.`", ",", "1.9487171`*^7", ",", "1.0604499373`*^10"}], 
  "}"}]], "Output",
 ImageSize->{249, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->2045399790]
}, Open  ]],

Cell["\<\
This uses scientific notation only for numbers with exponents of 10 or more. \
\
\>", "MathCaption",
 CellID->30527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"ExponentFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "10"}], "<", "#", "<", "10"}], ",", "Null", ",", "#"}], 
       "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->2625],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"32768.\"\>",
     32768.,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"19487171.\"\>",
     1.9487171*^7,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"1.06045\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"10\"\>"]}],
     1.0604499373*^10,
     AutoDelete->True]}], "}"}],
  NumberForm[#, 
   ExponentFunction -> (If[-10 < # < 10, Null, #]& )]& ]], "Output",
 ImageSize->{231, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//NumberForm=",
 CellID->116049354]
}, Open  ]],

Cell["This forces all exponents to be multiples of 3. ", "MathCaption",
 CellID->1924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"ExponentFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"Quotient", "[", 
        RowBox[{"#", ",", "3"}], "]"}]}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->11023],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"32.768\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"3\"\>"]}],
     32768.,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"19.4872\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"6\"\>"]}],
     1.9487171*^7,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"10.6045\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"9\"\>"]}],
     1.0604499373*^10,
     AutoDelete->True]}], "}"}],
  NumberForm[#, ExponentFunction -> (3 Quotient[#, 3]& )]& ]], "Output",
 ImageSize->{273, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//NumberForm=",
 CellID->526341202]
}, Open  ]],

Cell[TextData[{
 "Having determined what the mantissa and exponent for a number should be, \
the final step is to assemble these into the object to print. The option ",
 Cell[BoxData[
  ButtonBox["NumberFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFormat"]], "InlineFormula"],
 " allows you to give an arbitrary function which specifies the print form \
for the number. The function takes as arguments three strings: the mantissa, \
the base, and the exponent for the number. If there is no exponent, it is \
given as ",
 Cell[BoxData["\"\<\>\""], "InlineFormula"],
 ". "
}], "Text",
 CellID->13061],

Cell["\<\
This gives the exponents in Fortran\[Hyphen]like \[OpenCurlyDoubleQuote]e\
\[CloseCurlyDoubleQuote] format. \
\>", "MathCaption",
 CellID->14181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5.6", "^", "10"}], ",", 
     RowBox[{"7.8", "^", "20"}]}], "}"}], ",", 
   RowBox[{"NumberFormat", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SequenceForm", "[", 
       RowBox[{"#1", ",", "\"\<e\>\"", ",", "#3"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->31003],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVstOwzAQdPxoaHn0yrG/Agc4gfiFqEJqD6io9H/yqcZ2bWIm4ySUVIqd
Xe+uZ8e7Tl+a0+79ozntt83m+dh87vbbr83T4ehUqhJCtO5Z3wv3bt1beFpr
3az9qLwcfuIB5FeQVfBSoH10g3TiG+gltfayF3X0Mpk8NmvRx4xyDfGTf9JL
iOvxmDjruG4m7MOzC1rzIwebs1XC0l/lPjNpM2wLkpGMzJQx1+BlgmsnRw7+
rLka4ZfzjTkhOp4Ly5zgG7RYgsUN3ekWOU9UnlU9/LwiDEZhZzDAVWVZbWKU
WbnK0ZEMOFsr2/Xc1KpGfMhoqX8REe1cmpuMSPtY8jtMJmZoJ6niKmNKF3fk
nZXfZ4uy3wBrl7Eza0VRv3Rz5/7XTKZnk6zK1YQZ1b+xRQRj/chqcOq3YUm1
/7/9cXdeT3eTrC7jkp8qnh6PxW9/plUx5pT/Dp5rv9U66le265nUv7m9yuKn
77cpZSrawiiqb8ry8rI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//NumberForm=",
 CellID->256523929]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 " to print individual numbers in Fortran format. "
}], "MathCaption",
 CellID->17505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"7.8", "^", "20"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->27593],

Cell["6.94851587086215e17", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//FortranForm=",
 CellID->1116037519]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PaddedForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PaddedForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["tot", "TI"], "]"}], Cell[TextData[{
     "print with all numbers having room for ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " digits, padding with leading spaces if necessary"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PaddedForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PaddedForm"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["tot", "TI"], ",", 
     StyleBox["frac", "TI"], "}", "]"}], Cell[TextData[{
     "print with all numbers having room for ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " digits, with exactly ",
     Cell[BoxData[
      StyleBox["frac", "TI"]], "InlineFormula"],
     " digits to the right of the decimal point"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberForm"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["tot", "TI"], ",", 
     StyleBox["frac", "TI"], "}", "]"}], Cell[TextData[{
     "print with all numbers having at most ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " digits, exactly ",
     Cell[BoxData[
      StyleBox["frac", "TI"]], "InlineFormula"],
     " of them to the right of the decimal point"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column",
      ButtonNote->"ObsLink: ColumnForm -> Column"], "[", "{", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "print with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " left aligned in a column"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13031],

Cell["Controlling the alignment of numbers in output. ", "Caption",
 CellID->8492],

Cell["\<\
Whenever you print a collection of numbers in a column or some other definite \
arrangement, you typically need to be able to align the numbers in a definite \
way. Usually you want all the numbers to be set up so that the digit \
corresponding to a particular power of 10 always appears at the same position \
within the region used to print a number. \
\>", "Text",
 CellID->142],

Cell["\<\
You can change the positions of digits in the printed form of a number by \
\[OpenCurlyDoubleQuote]padding\[CloseCurlyDoubleQuote] it in various ways. \
You can pad on the right, typically adding zeros somewhere after the decimal. \
Or you can pad on the left, typically inserting spaces in place of leading \
zeros. \
\>", "Text",
 CellID->17222],

Cell["\<\
This pads with spaces to make room for up to 7 digits in each integer. \
\>", "MathCaption",
 CellID->31286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"456", ",", "12345", ",", "12"}], "}"}], ",", "7"}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->13064],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"     456\"\>",
     456,
     Editable->False], ",", 
    InterpretationBox["\<\"   12345\"\>",
     12345,
     Editable->False], ",", 
    InterpretationBox["\<\"      12\"\>",
     12,
     Editable->False]}], "}"}],
  PaddedForm[#, 7]& ]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]//PaddedForm=",
 CellID->1120408935]
}, Open  ]],

Cell["This creates a column of integers. ", "MathCaption",
 CellID->19187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"ColumnForm", "[", 
    RowBox[{"{", 
     RowBox[{"456", ",", "12345", ",", "12"}], "}"}], "]"}], ",", "7"}], 
  "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->8360],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {"\<\"     456\"\>"},
     {"\<\"   12345\"\>"},
     {"\<\"      12\"\>"}
    },
    BaselinePosition->{Baseline, {1, 1}},
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   ColumnForm[{456, 12345, 12}],
   Editable->False],
  PaddedForm[#, 7]& ]], "Output",
 ImageSize->{60, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//PaddedForm=",
 CellID->1576353649]
}, Open  ]],

Cell["\<\
This prints each number with room for a total of 7 digits, and with 4 digits \
to the right of the decimal point. \
\>", "MathCaption",
 CellID->30974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.7"}], ",", "6.888", ",", "6.99999"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->14270],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"  -6.7000\"\>",
     -6.7,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"   6.8880\"\>",
     6.888,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"   7.0000\"\>",
     6.99999,
     AutoDelete->True]}], "}"}],
  PaddedForm[#, {7, 4}]& ]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]//PaddedForm=",
 CellID->270025704]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 ", the 7 specifies the maximum precision, but does not make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pad with spaces. "
}], "MathCaption",
 CellID->235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.7"}], ",", "6.888", ",", "6.99999"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->30833],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"-6.7000\"\>",
     -6.7,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"6.8880\"\>",
     6.888,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"7.0000\"\>",
     6.99999,
     AutoDelete->True]}], "}"}],
  NumberForm[#, {7, 4}]& ]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]//NumberForm=",
 CellID->689061017]
}, Open  ]],

Cell[TextData[{
 "If you set the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SignPadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SignPadding"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will insert leading spaces ",
 StyleBox["after",
  FontSlant->"Italic"],
 " the sign. "
}], "MathCaption",
 CellID->25760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.7"}], ",", "6.888", ",", "6.99999"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4"}], "}"}], ",", 
   RowBox[{"SignPadding", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->18896],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"-  6.7000\"\>",
     -6.7,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"   6.8880\"\>",
     6.888,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"   7.0000\"\>",
     6.99999,
     AutoDelete->True]}], "}"}],
  PaddedForm[#, {7, 4}, SignPadding -> True]& ]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]//PaddedForm=",
 CellID->1816688095]
}, Open  ]],

Cell["\<\
Only the mantissa portion is aligned when scientific notation is used. \
\>", "MathCaption",
 CellID->7285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"ColumnForm", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"6.7", " ", 
       RowBox[{"10", "^", "8"}]}], ",", "48.7", ",", 
      RowBox[{
       RowBox[{"-", "2.3"}], " ", 
       RowBox[{"10", "^", 
        RowBox[{"-", "16"}]}]}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->12550],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      RowBox[{"\<\"  6.70\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"8\"\>"]}]},
     {"\<\" 48.70\"\>"},
     {
      RowBox[{"\<\" -2.30\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-16\"\>"]}]}
    },
    BaselinePosition->{Baseline, {1, 1}},
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   ColumnForm[{6.7*^8, 48.7, -2.3*^-16}],
   Editable->False],
  PaddedForm[#, {4, 2}]& ]], "Output",
 ImageSize->{87, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]//PaddedForm=",
 CellID->154319619]
}, Open  ]],

Cell[TextData[{
 "With the default setting for the option ",
 Cell[BoxData[
  ButtonBox["NumberPadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberPadding"]], "InlineFormula"],
 ", both ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 " insert trailing zeros when they pad a number on the right. You can use \
spaces for padding on both the left and the right by setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberPadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberPadding"], "->", 
   RowBox[{"{", 
    RowBox[{"\"\< \>\"", ",", "\"\< \>\""}], "}"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13694],

Cell["This uses spaces instead of zeros for padding on the right. ", \
"MathCaption",
 CellID->2695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.7"}], ",", "6.888", ",", "6.99999"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4"}], "}"}], ",", 
   RowBox[{"NumberPadding", "->", 
    RowBox[{"{", 
     RowBox[{"\"\< \>\"", ",", "\"\< \>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->21624],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"  -6.7   \"\>",
     -6.7,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"   6.888 \"\>",
     6.888,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"   7.    \"\>",
     6.99999,
     AutoDelete->True]}], "}"}],
  PaddedForm[#, {7, 4}, NumberPadding -> {" ", " "}]& ]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]//PaddedForm=",
 CellID->1637074604]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BaseForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BaseForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "print with all numbers given in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2125],

Cell["Printing numbers in other bases. ", "Caption",
 CellID->26576],

Cell["This prints a number in base 2. ", "MathCaption",
 CellID->21694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"2342424", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->22658],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"1000111011111000011000\"\>", "\<\"2\"\>"],
   2342424,
   Editable->False],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]//BaseForm=",
 CellID->752384064]
}, Open  ]],

Cell["\<\
In bases higher than 10, letters are used for the extra digits. \
\>", "MathCaption",
 CellID->17371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"242345341", ",", "16"}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->22466],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"e71e57d\"\>", "\<\"16\"\>"],
   242345341,
   Editable->False],
  BaseForm[#, 16]& ]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]//BaseForm=",
 CellID->935250112]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " also works with approximate real numbers. "
}], "MathCaption",
 CellID->22593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"2.3", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->23851],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"10.010011001100110011\"\>", "2"],
   2.3,
   AutoDelete->True],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]//BaseForm=",
 CellID->1315819991]
}, Open  ]],

Cell[TextData[{
 "You can even use ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " for numbers printed in scientific notation. "
}], "MathCaption",
 CellID->1018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"2.3", " ", 
    RowBox[{"10", "^", "8"}]}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->28464],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{
    SubscriptBox["\<\"1.1011011010110000101\"\>", "2"], "\[Times]", 
    SuperscriptBox["2", "\<\"27\"\>"]}],
   2.2999999999999997`*^8,
   AutoDelete->True],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]//BaseForm=",
 CellID->199991931]
}, Open  ]],

Cell[TextData[{
 "\"",
 ButtonBox["Digits in Numbers",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DigitsInNumbers"],
 "\" discusses how to enter numbers in arbitrary bases, and also how to get \
lists of the digits in a number. "
}], "Text",
 CellID->23152],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->73848238],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Output Formats for Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/StringOrientedOutputFormats"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TablesAndMatrices"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 43.8086504}", "context" -> "", 
    "keywords" -> {
     "AccountingForm", "alignment", "BaseForm", "number bases", "base 2", 
      "base 8", "base 16", "base 10", "binary numbers", "ColumnForm", 
      "columns", "commas", "conversion", "currency output", "number formats", 
      "decimal places", "DigitBlock", "digits", "EngineeringForm", 
      "engineering form", "ExponentFunction", "exponent function", 
      "exponential notation", "exponents", "fixed point notation", 
      "format of numbers", "Fortran", "hexadecimal numbers", "hex numbers", 
      "integers", "leading digits", "mantissa", "NumberForm", "number form", 
      "NumberFormat", "number format", "NumberMultiplier", 
      "number multiplier", "NumberPadding", "number padding", "NumberPoint", 
      "number point", "numbers", "NumberSeparator", "NumberSigns", 
      "number signs", "octal numbers", "output forms", "PaddedForm", 
      "padded form", "precision", "radix", "ScientificForm", 
      "scientific form", "scientific notation", "separators", 
      "significant figures", "SignPadding", "sign padding", "standard form", 
      "ternary numbers"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Output formats for numbers. These numbers are given in the default \
output format. Large numbers are given in scientific notation. This gives all \
numbers in scientific notation. ", "synonyms" -> {"2.9.7"}, "title" -> 
    "Output Formats for Numbers", "type" -> "Tutorial", "uri" -> 
    "tutorial/OutputFormatsForNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.7"->{
  Cell[2506, 69, 89, 2, 70, "Title",
   CellTags->{"S2.9.7", "7.1"},
   CellID->20024]},
 "7.1"->{
  Cell[2506, 69, 89, 2, 70, "Title",
   CellTags->{"S2.9.7", "7.1"},
   CellID->20024]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.7", 43045, 1515},
 {"7.1", 43144, 1519}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1881, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2506, 69, 89, 2, 70, "Title",
 CellTags->{"S2.9.7", "7.1"},
 CellID->20024],
Cell[2598, 73, 1101, 31, 70, "DefinitionBox",
 CellID->26154],
Cell[3702, 106, 63, 1, 70, "Caption",
 CellID->29510],
Cell[3768, 109, 150, 4, 70, "MathCaption",
 CellID->4745],
Cell[CellGroupData[{
Cell[3943, 117, 219, 8, 28, "Input",
 CellID->20649],
Cell[4165, 127, 280, 9, 39, "Output",
 CellID->826158805]
}, Open  ]],
Cell[4460, 139, 85, 1, 70, "MathCaption",
 CellID->8313],
Cell[CellGroupData[{
Cell[4570, 144, 105, 3, 28, "Input",
 CellID->4474],
Cell[4678, 149, 735, 24, 53, "Output",
 CellID->1769257780]
}, Open  ]],
Cell[5428, 176, 146, 4, 70, "MathCaption",
 CellID->2168],
Cell[CellGroupData[{
Cell[5599, 184, 107, 3, 28, "Input",
 CellID->14018],
Cell[5709, 189, 737, 24, 53, "Output",
 CellID->1856932098]
}, Open  ]],
Cell[6461, 216, 150, 4, 70, "MathCaption",
 CellID->9905],
Cell[CellGroupData[{
Cell[6636, 224, 214, 7, 70, "Input",
 CellID->17958],
Cell[6853, 233, 471, 18, 50, "Output",
 CellID->77929235]
}, Open  ]],
Cell[7339, 254, 1533, 47, 70, "DefinitionBox",
 CellID->10202],
Cell[8875, 303, 85, 1, 70, "Caption",
 CellID->3625],
Cell[8963, 306, 183, 7, 70, "MathCaption",
 CellID->26477],
Cell[CellGroupData[{
Cell[9171, 317, 141, 5, 70, "Input",
 CellID->4414],
Cell[9315, 324, 207, 5, 36, "Output",
 CellID->1939111622]
}, Open  ]],
Cell[9537, 332, 184, 7, 70, "MathCaption",
 CellID->25824],
Cell[CellGroupData[{
Cell[9746, 343, 126, 4, 70, "Input",
 CellID->29334],
Cell[9875, 349, 305, 10, 50, "Output",
 CellID->437204082]
}, Open  ]],
Cell[10195, 362, 86, 1, 70, "MathCaption",
 CellID->24372],
Cell[CellGroupData[{
Cell[10306, 367, 131, 4, 70, "Input",
 CellID->20159],
Cell[10440, 373, 385, 12, 50, "Output",
 CellID->1547449787]
}, Open  ]],
Cell[10840, 388, 2780, 78, 70, "DefinitionBox3Col",
 CellID->28070],
Cell[13623, 468, 65, 1, 70, "Caption",
 CellID->7487],
Cell[13691, 471, 144, 4, 70, "Text",
 CellID->28297],
Cell[13838, 477, 993, 30, 70, "Text",
 CellID->7518],
Cell[14834, 509, 344, 13, 70, "MathCaption",
 CellID->8177],
Cell[CellGroupData[{
Cell[15203, 526, 179, 6, 70, "Input",
 CellID->17773],
Cell[15385, 534, 348, 10, 50, "Output",
 CellID->1961604939]
}, Open  ]],
Cell[15748, 547, 121, 3, 70, "MathCaption",
 CellID->1763],
Cell[CellGroupData[{
Cell[15894, 554, 235, 7, 70, "Input",
 CellID->2668],
Cell[16132, 563, 367, 10, 50, "Output",
 CellID->525261029]
}, Open  ]],
Cell[16514, 576, 191, 5, 70, "MathCaption",
 CellID->13985],
Cell[CellGroupData[{
Cell[16730, 585, 354, 11, 70, "Input",
 CellID->3102],
Cell[17087, 598, 432, 15, 50, "Output",
 CellID->1904325233]
}, Open  ]],
Cell[17534, 616, 949, 24, 70, "Text",
 CellID->29213],
Cell[18486, 642, 309, 11, 70, "MathCaption",
 CellID->7627],
Cell[CellGroupData[{
Cell[18820, 657, 198, 7, 70, "Input",
 CellID->4802],
Cell[19021, 666, 253, 8, 39, "Output",
 CellID->2045399790]
}, Open  ]],
Cell[19289, 677, 126, 4, 70, "MathCaption",
 CellID->30527],
Cell[CellGroupData[{
Cell[19440, 685, 359, 12, 70, "Input",
 CellID->2625],
Cell[19802, 699, 623, 21, 53, "Output",
 CellID->116049354]
}, Open  ]],
Cell[20440, 723, 86, 1, 70, "MathCaption",
 CellID->1924],
Cell[CellGroupData[{
Cell[20551, 728, 308, 10, 70, "Input",
 CellID->11023],
Cell[20862, 740, 747, 24, 53, "Output",
 CellID->526341202]
}, Open  ]],
Cell[21624, 767, 618, 14, 70, "Text",
 CellID->13061],
Cell[22245, 783, 155, 4, 70, "MathCaption",
 CellID->14181],
Cell[CellGroupData[{
Cell[22425, 791, 409, 14, 28, "Input",
 CellID->31003],
Cell[22837, 807, 733, 16, 50, "Output",
 Evaluatable->False,
 CellID->256523929]
}, Open  ]],
Cell[23585, 826, 244, 8, 70, "MathCaption",
 CellID->17505],
Cell[CellGroupData[{
Cell[23854, 838, 130, 4, 70, "Input",
 CellID->27593],
Cell[23987, 844, 183, 5, 50, "Output",
 CellID->1116037519]
}, Open  ]],
Cell[24185, 852, 2394, 71, 70, "DefinitionBox",
 CellID->13031],
Cell[26582, 925, 82, 1, 70, "Caption",
 CellID->8492],
Cell[26667, 928, 391, 7, 70, "Text",
 CellID->142],
Cell[27061, 937, 357, 7, 70, "Text",
 CellID->17222],
Cell[27421, 946, 118, 3, 70, "MathCaption",
 CellID->31286],
Cell[CellGroupData[{
Cell[27564, 953, 195, 7, 70, "Input",
 CellID->13064],
Cell[27762, 962, 476, 18, 50, "Output",
 CellID->1120408935]
}, Open  ]],
Cell[28253, 983, 74, 1, 70, "MathCaption",
 CellID->19187],
Cell[CellGroupData[{
Cell[28352, 988, 234, 8, 70, "Input",
 CellID->8360],
Cell[28589, 998, 543, 18, 80, "Output",
 CellID->1576353649]
}, Open  ]],
Cell[29147, 1019, 161, 4, 70, "MathCaption",
 CellID->30974],
Cell[CellGroupData[{
Cell[29333, 1027, 267, 9, 70, "Input",
 CellID->14270],
Cell[29603, 1038, 492, 18, 50, "Output",
 CellID->270025704]
}, Open  ]],
Cell[30110, 1059, 314, 11, 70, "MathCaption",
 CellID->235],
Cell[CellGroupData[{
Cell[30449, 1074, 267, 9, 70, "Input",
 CellID->30833],
Cell[30719, 1085, 484, 18, 50, "Output",
 CellID->689061017]
}, Open  ]],
Cell[31218, 1106, 452, 18, 70, "MathCaption",
 CellID->25760],
Cell[CellGroupData[{
Cell[31695, 1128, 315, 10, 70, "Input",
 CellID->18896],
Cell[32013, 1140, 514, 18, 50, "Output",
 CellID->1816688095]
}, Open  ]],
Cell[32542, 1161, 117, 3, 70, "MathCaption",
 CellID->7285],
Cell[CellGroupData[{
Cell[32684, 1168, 441, 15, 70, "Input",
 CellID->12550],
Cell[33128, 1185, 696, 22, 83, "Output",
 CellID->154319619]
}, Open  ]],
Cell[33839, 1210, 852, 27, 70, "Text",
 CellID->13694],
Cell[34694, 1239, 100, 2, 70, "MathCaption",
 CellID->2695],
Cell[CellGroupData[{
Cell[34819, 1245, 381, 12, 70, "Input",
 CellID->21624],
Cell[35203, 1259, 522, 18, 50, "Output",
 CellID->1637074604]
}, Open  ]],
Cell[35740, 1280, 681, 20, 70, "DefinitionBox",
 CellID->2125],
Cell[36424, 1302, 68, 1, 70, "Caption",
 CellID->26576],
Cell[36495, 1305, 71, 1, 70, "MathCaption",
 CellID->21694],
Cell[CellGroupData[{
Cell[36591, 1310, 130, 4, 70, "Input",
 CellID->22658],
Cell[36724, 1316, 314, 11, 50, "Output",
 CellID->752384064]
}, Open  ]],
Cell[37053, 1330, 111, 3, 70, "MathCaption",
 CellID->17371],
Cell[CellGroupData[{
Cell[37189, 1337, 133, 4, 70, "Input",
 CellID->22466],
Cell[37325, 1343, 302, 11, 50, "Output",
 CellID->935250112]
}, Open  ]],
Cell[37642, 1357, 216, 7, 70, "MathCaption",
 CellID->22593],
Cell[CellGroupData[{
Cell[37883, 1368, 126, 4, 70, "Input",
 CellID->23851],
Cell[38012, 1374, 303, 11, 50, "Output",
 CellID->1315819991]
}, Open  ]],
Cell[38330, 1388, 239, 8, 70, "MathCaption",
 CellID->1018],
Cell[CellGroupData[{
Cell[38594, 1400, 176, 6, 70, "Input",
 CellID->28464],
Cell[38773, 1408, 388, 13, 50, "Output",
 CellID->199991931]
}, Open  ]],
Cell[39176, 1424, 266, 8, 70, "Text",
 CellID->23152],
Cell[CellGroupData[{
Cell[39467, 1436, 71, 1, 70, "RelatedTutorialsSection",
 CellID->73848238],
Cell[39541, 1439, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[39746, 1447, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

