(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19290,        657]
NotebookOptionsPosition[     14757,        516]
NotebookOutlinePosition[     17146,        576]
CellTagsIndexPosition[     17053,        570]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica Packages\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cartesian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Cartesian"], 
          "Curl" :> Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Curl"], "Cylindrical" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Cylindrical"], 
          "Div" :> Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], 
          "Grad" :> Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Grad"], "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
          "Quaternion" :> 
          Documentation`HelpLookup["paclet:Quaternions/ref/Quaternion"], 
          "SetCoordinates" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/SetCoordinates"], "Spherical" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Spherical"], 
          "VariationalD" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/ref/VariationalD"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cartesian\"\>", 2->"\<\"Curl\"\>", 
       3->"\<\"Cylindrical\"\>", 4->"\<\"Div\"\>", 5->"\<\"Grad\"\>", 
       6->"\<\"Laplacian\"\>", 7->"\<\"Quaternion\"\>", 
       8->"\<\"SetCoordinates\"\>", 9->"\<\"Spherical\"\>", 
       10->"\<\"VariationalD\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Packages for Symbolic Mathematics", "Title",
 CellTags->{"S1.5.14", "14.1"},
 CellID->9010],

Cell[TextData[{
 "There are many ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages which implement symbolic mathematical operations. Here are a few \
examples drawn from the standard set of packages distributed with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". As discussed in \"",
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
 "\", some copies of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may be set up so that the functions described here are automatically \
loaded into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " if they are ever needed. "
}], "Text",
 CellID->4757],

Cell[CellGroupData[{

Cell["Vector Analysis", "Section",
 CellID->32170],

Cell[BoxData[GridBox[{
   {
    RowBox[{"<<", "VectorAnalysis`"}], Cell[
    "load the vector analysis package", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetCoordinates",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"], "[", 
     RowBox[{
      StyleBox["system", "TI"], "[", 
      StyleBox["names", "TI"], "]"}], "]"}], Cell[TextData[{
     "specify the coordinate system to be used (",
     Cell[BoxData[
      ButtonBox["Cartesian",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Cylindrical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Cylindrical"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Spherical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Spherical"]], "InlineFormula"],
     ", etc.), giving the names of the coordinates in that system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Grad",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Grad"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "evaluate the gradient ",
     Cell[BoxData[
      RowBox[{"\[Del]", 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the coordinate system chosen"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Div",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Div"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "evaluate the divergence ",
     Cell[BoxData[
      RowBox[{"\[Del]", "\[CenterDot]", 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     " of the list ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Curl",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Curl"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "evaluate the curl ",
     Cell[BoxData[
      RowBox[{"\[Del]", "\[Cross]", 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     " of the list ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Laplacian",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Laplacian"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "evaluate the Laplacian ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox["\[Del]", "2"], 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20315],

Cell["Vector analysis. ", "Caption",
 CellID->9576],

Cell[TextData[{
 "This loads the vector analysis package. In some versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you may not need to load the package explicitly. "
}], "MathCaption",
 CellID->30227],

Cell[BoxData[
 RowBox[{"<<", "VectorAnalysis`"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12043],

Cell[TextData[{
 "This specifies that a spherical coordinate system with coordinate names ",
 Cell[BoxData["r"], "InlineFormula"],
 ", ",
 Cell[BoxData["theta"], "InlineFormula"],
 " and ",
 Cell[BoxData["phi"], "InlineFormula"],
 " should be used. "
}], "MathCaption",
 CellID->22758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", 
  RowBox[{"Spherical", "[", 
   RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7164],

Cell[BoxData[
 RowBox[{"Spherical", "[", 
  RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->447983380]
}, Open  ]],

Cell[TextData[{
 "This evaluates the gradient of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["r", "2"], "sin", 
    RowBox[{"(", "\[Theta]", ")"}]}], TraditionalForm]], "InlineMath"],
 " in the spherical coordinate system. "
}], "MathCaption",
 CellID->7882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grad", "[", 
  RowBox[{
   RowBox[{"r", "^", "2"}], " ", 
   RowBox[{"Sin", "[", "theta", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "r", " ", 
    RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
   RowBox[{"r", " ", 
    RowBox[{"Cos", "[", "theta", "]"}]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{218, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->179001278]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variational Methods", "Section",
 CellID->3487],

Cell[BoxData[GridBox[{
   {
    RowBox[{"<<", "VariationalMethods`"}], "\[SpanFromLeft]"},
   {"", Cell["load the variational methods package", "TableText"]},
   {
    RowBox[{
     ButtonBox["VariationalD",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/VariationalD"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{
       StyleBox["y", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "find the variational derivative of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29577],

Cell["Variational methods. ", "Caption",
 CellID->14474],

Cell["This loads the variational methods package. ", "MathCaption",
 CellID->2625],

Cell[BoxData[
 RowBox[{"<<", "VariationalMethods`"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->25627],

Cell[TextData[{
 "This finds the functional derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", 
    RowBox[{"(", "x", ")"}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["y", "\[Prime]"], 
      RowBox[{"(", "x", ")"}]}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->5629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VariationalD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], " ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->31928],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "x", "]"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], " ", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}]}], 
  RowBox[{"4", " ", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], 
    RowBox[{"3", "/", "2"}]]}]]], "Output",
 ImageSize->{134, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1997373546]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quaternions", "Section",
 CellID->28520],

Cell[BoxData[GridBox[{
   {
    RowBox[{"<<", "Quaternions`"}], Cell[
    "load the quaternions package", "TableText"]},
   {
    RowBox[{
     ButtonBox["Quaternion",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/Quaternion"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"], ",", 
      StyleBox["d", "TI"]}], "]"}], Cell[TextData[{
     "the quaternion ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "+", 
       StyleBox["b", "TI"], 
       StyleBox["i", "TI"], "+", 
       StyleBox["c", "TI"], 
       StyleBox["j", "TI"], "+", 
       StyleBox["d", "TI"], 
       StyleBox["k", "TI"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6902],

Cell["Quaternions. ", "Caption",
 CellID->14962],

Cell["This loads the quaternions package. ", "MathCaption",
 CellID->123],

Cell[BoxData[
 RowBox[{"<<", "Quaternions`"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->24596],

Cell["This finds the principal square root of a quaternion. ", "MathCaption",
 CellID->3737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->13261],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]], " ", 
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"ArcTan", "[", 
       SqrtBox["2"], "]"}], "2"], "]"}]}], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["3", 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"ArcTan", "[", 
        SqrtBox["2"], "]"}], "2"], "]"}]}], 
    SqrtBox["2"]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["3", 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"ArcTan", "[", 
        SqrtBox["2"], "]"}], "2"], "]"}]}], 
    SqrtBox["2"]], ",", "0"}], "]"}]], "Output",
 ImageSize->{532, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->392817718]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->70753489],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "RelatedTutorials",
 CellID->369732296]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Packages for Symbolic Mathematics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 44.5742950}", "context" -> "", 
    "keywords" -> {
     "application packages", "Cartesian coordinates", "coordinate systems", 
      "curl", "cylindrical coordinates", "Del", "Div", 
      "functional derivative", "grad", "Nabla", "packages", "quaternions", 
      "rot", "spherical coordinates", "symbolic mathematics", "VariationalD", 
      "variational methods", "vector analysis"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "There are many Mathematica packages which implement symbolic \
mathematical operations. Here are a few examples drawn from the standard set \
of packages distributed with Mathematica. As discussed in \"Mathematica \
Packages\", some copies of Mathematica may be set up so that the functions \
described here are automatically loaded into Mathematica if they are ever \
needed. Vector analysis. This loads the vector analysis package. In some \
versions of Mathematica, you may not need to load the package explicitly. ", 
    "synonyms" -> {}, "title" -> "Packages for Symbolic Mathematics", "type" -> 
    "Tutorial", "uri" -> "tutorial/PackagesForSymbolicMathematics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.14"->{
  Cell[2942, 77, 97, 2, 70, "Title",
   CellTags->{"S1.5.14", "14.1"},
   CellID->9010]},
 "14.1"->{
  Cell[2942, 77, 97, 2, 70, "Title",
   CellTags->{"S1.5.14", "14.1"},
   CellID->9010]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.14", 16839, 559},
 {"14.1", 16940, 563}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2317, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2942, 77, 97, 2, 70, "Title",
 CellTags->{"S1.5.14", "14.1"},
 CellID->9010],
Cell[3042, 81, 807, 25, 70, "Text",
 CellID->4757],
Cell[CellGroupData[{
Cell[3874, 110, 50, 1, 70, "Section",
 CellID->32170],
Cell[3927, 113, 3088, 97, 70, "DefinitionBox",
 CellID->20315],
Cell[7018, 212, 51, 1, 70, "Caption",
 CellID->9576],
Cell[7072, 215, 219, 6, 70, "MathCaption",
 CellID->30227],
Cell[7294, 223, 98, 3, 70, "Input",
 CellID->12043],
Cell[7395, 228, 285, 9, 70, "MathCaption",
 CellID->22758],
Cell[CellGroupData[{
Cell[7705, 241, 181, 5, 28, "Input",
 CellID->7164],
Cell[7889, 248, 233, 7, 36, "Output",
 CellID->447983380]
}, Open  ]],
Cell[8137, 258, 274, 9, 70, "MathCaption",
 CellID->7882],
Cell[CellGroupData[{
Cell[8436, 271, 178, 6, 70, "Input",
 CellID->17086],
Cell[8617, 279, 344, 11, 36, "Output",
 CellID->179001278]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9010, 296, 53, 1, 70, "Section",
 CellID->3487],
Cell[9066, 299, 1084, 30, 70, "DefinitionBox",
 CellID->29577],
Cell[10153, 331, 56, 1, 70, "Caption",
 CellID->14474],
Cell[10212, 334, 82, 1, 70, "MathCaption",
 CellID->2625],
Cell[10297, 337, 102, 3, 70, "Input",
 CellID->25627],
Cell[10402, 342, 310, 12, 70, "MathCaption",
 CellID->5629],
Cell[CellGroupData[{
Cell[10737, 358, 306, 10, 70, "Input",
 CellID->31928],
Cell[11046, 370, 676, 23, 57, "Output",
 CellID->1997373546]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11771, 399, 46, 1, 70, "Section",
 CellID->28520],
Cell[11820, 402, 1062, 33, 70, "DefinitionBox",
 CellID->6902],
Cell[12885, 437, 48, 1, 70, "Caption",
 CellID->14962],
Cell[12936, 440, 73, 1, 70, "MathCaption",
 CellID->123],
Cell[13012, 443, 95, 3, 70, "Input",
 CellID->24596],
Cell[13110, 448, 92, 1, 70, "MathCaption",
 CellID->3737],
Cell[CellGroupData[{
Cell[13227, 453, 177, 5, 70, "Input",
 CellID->13261],
Cell[13407, 460, 882, 32, 73, "Output",
 CellID->392817718]
}, Open  ]],
Cell[CellGroupData[{
Cell[14326, 497, 71, 1, 70, "RelatedTutorialsSection",
 CellID->70753489],
Cell[14400, 500, 291, 9, 70, "RelatedTutorials",
 CellID->369732296]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[14730, 514, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

