(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21781,        722]
NotebookOptionsPosition[     17621,        601]
NotebookOutlinePosition[     19886,        651]
CellTagsIndexPosition[     19843,        648]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PadeApproximant" :> 
         Documentation`HelpLookup["paclet:ref/PadeApproximant"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"PadeApproximant\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pad\[EAcute] Approximation", "Title",
 CellID->509267359],

Cell["\<\
The Pad\[EAcute] approximation is a rational function that can be thought of \
as a generalization of a Taylor polynomial. A rational function is the ratio \
of polynomials. Because these functions only use the elementary arithmetic \
operations, they are very easy to evaluate numerically. The polynomial in the \
denominator allows one to approximate functions that have rational \
singularities.\
\>", "Text",
 CellID->5364],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PadeApproximant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadeApproximant"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["n", "TI"], ",", 
          StyleBox["m", "TI"]}], "}"}]}], "}"}]}], "]"}], Cell[TextData[{
     "give the Pad\[EAcute] approximation to ",
     Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
        StyleBox["f", "TI"]], "InlineFormula"]], "InlineFormula"], 
       TraditionalForm]], "InlineMath"],
     " centered at ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " of order ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], ")"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadeApproximant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadeApproximant"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "give the diagonal Pad\[EAcute] approximation to ",
     Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
        StyleBox["f", "TI"]], "InlineFormula"]], "InlineFormula"], 
       TraditionalForm]], "InlineMath"],
     " centered at ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " of order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2096742444],

Cell["Pad\[EAcute] approximations.", "Caption",
 CellID->1891092685],

Cell[TextData[{
 "More precisely, a Pad\[EAcute] approximation of order ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"n", ",", "m"}], ")"}], TraditionalForm]], "InlineMath"],
 " to an analytic function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " at a regular point or pole ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 " is the rational function ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"p", 
     RowBox[{"(", "x", ")"}]}], 
    RowBox[{"q", 
     RowBox[{"(", "x", ")"}]}]], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " is a polynomial of degree ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " is a polynomial of degree ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", and the formal power series of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", "x", ")"}], 
     RowBox[{"q", "(", "x", ")"}]}], "-", 
    RowBox[{"p", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " about the point ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 " begins with the term ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["x", "0"]}], ")"}], 
    RowBox[{"n", "+", "m", "+", "1"}]], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is equal to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", the approximation is called a diagonal Pad\[EAcute] approximation of \
order ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->8929],

Cell[TextData[{
 "Here is the Pad\[EAcute] approximation of order ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "4"}], ")"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->10583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadeApproximant", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[104]:=",
 CellID->11191],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"61", " ", 
     SuperscriptBox["x", "2"]}], "150"]}], 
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "2"]}], "75"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "200"]}]]], "Output",
 ImageSize->{82, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[104]=",
 CellID->203496035]
}, Open  ]],

Cell["\<\
This gives another Pad\[EAcute] approximation of the same order. \
\>", "MathCaption",
 CellID->29214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pd", "=", 
  RowBox[{"PadeApproximant", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[105]:=",
 CellID->5072],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ExponentialE]", "+", 
   RowBox[{
    FractionBox["1", "3"], " ", "\[ExponentialE]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "30"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "30"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]}]}]]], "Output",
 ImageSize->{341, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[105]=",
 CellID->210887440]
}, Open  ]],

Cell["\<\
The initial terms of this series vanish. This is the property that \
characterizes the Pad\[EAcute] approximation. \
\>", "MathCaption",
 CellID->20632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], " ", 
     RowBox[{"Denominator", "[", "pd", "]"}]}], "-", 
    RowBox[{"Numerator", "[", "pd", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[108]:=",
 CellID->22797],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "7"]}], "75600"], "+", 
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "8"]}], "120960"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "9"],
    SeriesData[$CellContext`x, 1, {}, 7, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {Rational[1, 75600] E, Rational[1, 120960] E},
    7, 9, 1],
  Editable->False]], "Output",
 ImageSize->{203, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[108]=",
 CellID->290985695]
}, Open  ]],

Cell["\<\
This plots the difference between the approximation and the true function. \
Notice that the approximation is very good near the center of expansion, but \
the error increases rapidly as you move away. \
\>", "MathCaption",
 CellID->16282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"pd", "-", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[109]:=",
 CellID->16050],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[109]=",
 CellID->17488795]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["PadeApproximant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadeApproximant"]], "InlineFormula"],
 " is generalized to allow expansion about branch points."
}], "Text",
 CellID->117171130],

Cell[TextData[{
 "This gives the diagonal Pad\[EAcute] approximation of order ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to a generalized rational function at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->459460530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadeApproximant", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sqrt", "[", "x", "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Sqrt", "[", "x", "]"}]}], ")"}], "^", "3"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[119]:=",
 CellID->84506177],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["x"], "-", 
   FractionBox["x", "3"]}], 
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"8", " ", 
     SqrtBox["x"]}], "3"], "+", 
   RowBox[{"2", " ", "x"}]}]]], "Output",
 ImageSize->{89, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[119]=",
 CellID->18252460]
}, Open  ]],

Cell[TextData[{
 "This gives the diagonal Pad\[EAcute] approximation of order ",
 Cell[BoxData[
  FormBox["5", TraditionalForm]], "InlineMath"],
 " to the logarithm of a rational function at the branch point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->116342356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadeApproximant", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    FractionBox["x", 
     RowBox[{"1", "+", "x"}]], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[157]:=",
 CellID->136485213],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"-", "x"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    FractionBox[
     RowBox[{"47", " ", 
      SuperscriptBox["x", "3"]}], "36"], "-", 
    FractionBox[
     RowBox[{"11", " ", 
      SuperscriptBox["x", "4"]}], "36"], "-", 
    FractionBox[
     RowBox[{"137", " ", 
      SuperscriptBox["x", "5"]}], "7560"]}], 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"5", " ", "x"}], "2"], "+", 
    FractionBox[
     RowBox[{"20", " ", 
      SuperscriptBox["x", "2"]}], "9"], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["x", "3"]}], "6"], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["x", "4"]}], "42"], "+", 
    FractionBox[
     SuperscriptBox["x", "5"], "252"]}]], "+", 
  RowBox[{"Log", "[", "x", "]"}]}]], "Output",
 ImageSize->{238, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[157]=",
 CellID->280426383]
}, Open  ]],

Cell[TextData[{
 "The series expansion of the function agrees with the diagonal Pad\[EAcute] \
approximation up to order ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->58120263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"%", "-", 
    RowBox[{"Log", "[", 
     FractionBox["x", 
      RowBox[{"1", "+", "x"}]], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[158]:=",
 CellID->89403194],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "11"], "698544"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "12"],
    SeriesData[$CellContext`x, 0, {}, 11, 12, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 698544]}, 11, 12, 1],
  Editable->False]], "Output",
 ImageSize->{104, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[158]=",
 CellID->295524256]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pad\[EAcute] Approximation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 46.0430826}", "context" -> "", 
    "keywords" -> {
     "PadeApproximant", "Pade' approximation", "Pade approximant", 
      "Pade method", "rational approximation"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The Pade' approximation is a rational function that can be thought of as \
a generalization of a Taylor polynomial. A rational function is the ratio of \
polynomials. Because these functions only use the elementary arithmetic \
operations, they are very easy to evaluate numerically. The polynomial in the \
denominator allows one to approximate functions that have rational \
singularities. Pade' approximations. More precisely, a Pade' approximation of \
order (n,m) to an analytic function f(x) at a regular point or pole x_0 is \
the rational function FractionBox[RowBox[{p, RowBox[{(, x, )}]}], RowBox[{q, \
RowBox[{(, x, )}]}]] where p(x) is a polynomial of degree n, q(x) is a \
polynomial of degree m, and the formal power series of f(x)q(x)-p(x) about \
the point x_0 begins with the term (x-x_0)^n+m+1. If m is equal to n, the \
approximation is called a diagonal Pade' approximation of order n.", 
    "synonyms" -> {}, "title" -> "Pade' Approximation", "type" -> "Tutorial", 
    "uri" -> "tutorial/PadeApproximation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 581, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1206, 42, 63, 1, 70, "Title",
 CellID->509267359],
Cell[1272, 45, 437, 8, 70, "Text",
 CellID->5364],
Cell[1712, 55, 1975, 64, 70, "DefinitionBox",
 CellID->2096742444],
Cell[3690, 121, 68, 1, 70, "Caption",
 CellID->1891092685],
Cell[3761, 124, 1947, 68, 70, "Text",
 CellID->8929],
Cell[5711, 194, 423, 16, 70, "MathCaption",
 CellID->10583],
Cell[CellGroupData[{
Cell[6159, 214, 275, 9, 28, "Input",
 CellID->11191],
Cell[6437, 225, 438, 16, 74, "Output",
 CellID->203496035]
}, Open  ]],
Cell[6890, 244, 112, 3, 70, "MathCaption",
 CellID->29214],
Cell[CellGroupData[{
Cell[7027, 251, 312, 10, 70, "Input",
 CellID->5072],
Cell[7342, 263, 1169, 42, 68, "Output",
 CellID->210887440]
}, Open  ]],
Cell[8526, 308, 162, 4, 70, "MathCaption",
 CellID->20632],
Cell[CellGroupData[{
Cell[8713, 316, 353, 11, 70, "Input",
 CellID->22797],
Cell[9069, 329, 798, 26, 54, "Output",
 CellID->290985695]
}, Open  ]],
Cell[9882, 358, 249, 5, 70, "MathCaption",
 CellID->16282],
Cell[CellGroupData[{
Cell[10156, 367, 245, 8, 28, "Input",
 CellID->16050],
Cell[10404, 377, 3048, 54, 218, "Output",
 Evaluatable->False,
 CellID->17488795]
}, Open  ]],
Cell[13467, 434, 302, 11, 70, "Text",
 CellID->117171130],
Cell[13772, 447, 321, 10, 70, "MathCaption",
 CellID->459460530],
Cell[CellGroupData[{
Cell[14118, 461, 363, 12, 70, "Input",
 CellID->84506177],
Cell[14484, 475, 356, 14, 79, "Output",
 CellID->18252460]
}, Open  ]],
Cell[14855, 492, 342, 10, 70, "MathCaption",
 CellID->116342356],
Cell[CellGroupData[{
Cell[15222, 506, 275, 9, 70, "Input",
 CellID->136485213],
Cell[15500, 517, 998, 35, 74, "Output",
 CellID->280426383]
}, Open  ]],
Cell[16513, 555, 231, 7, 70, "MathCaption",
 CellID->58120263],
Cell[CellGroupData[{
Cell[16769, 566, 293, 10, 70, "Input",
 CellID->89403194],
Cell[17065, 578, 502, 17, 54, "Output",
 CellID->295524256]
}, Open  ]]
}, Open  ]],
Cell[17594, 599, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

