(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    176440,       3443]
NotebookOptionsPosition[    170426,       3260]
NotebookOutlinePosition[    173462,       3334]
CellTagsIndexPosition[    173367,       3328]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"], 
          "ParametricPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ParametricPlot\"\>", 
       2->"\<\"ParametricPlot3D\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Parametric Plots", "Title",
 CellTags->{"S1.9.9", "9.1"},
 CellID->1264],

Cell[TextData[{
 "\"",
 ButtonBox["Basic Plotting",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/BasicPlotting"],
 "\" described how to plot curves in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in which you give the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate of each point as a function of the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinate. You can also use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to make ",
 StyleBox["parametric",
  FontSlant->"Italic"],
 " plots. In a parametric plot, you give both the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates of each point as a function of a third parameter, say ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->8260],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ParametricPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParametricPlot"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["y", "TI"]], "}", ",", "{", 
     StyleBox["t", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["make a parametric plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["ParametricPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParametricPlot"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["y", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["y", "TI"]], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["t", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["plot several parametric curves together", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6202],

Cell["Functions for generating parametric plots. ", "Caption",
 CellID->8116],

Cell[TextData[{
 "Here is the curve made by taking the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinate of each point to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", "t", "]"}]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   RowBox[{"2", "t"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->20326],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNW02MlVcZ/ph77zAMM8P/zMAM3AGmMAwzIHSAUn4GaMtAARsX1kXjAokJ
LLSm4kY3utGNbnQjibELfxKrC4xNG5OaGJsYmxibGJsYNTE1MXVhY2LjgsTk
+pzznvM97zz3cGcAYyRw+c73ved5/99zvnPOd+367Zuf/NT127duXJ9aeun6
Z27euvHZqYsvvoRbjTVVVb2Kf3fHK1x3cBX/vdrp4H//+0L4bYRn8U/1fLx7
Bb/hZp887cNlf7HHVbnbCD9NtquqVezXjnffffcf3/vu2y9/+9dVX/hp/Pju
O7gVHu3CT4BpPDD+Qmy//Zu/ApHIP3vjT++//6/waEfstjPivP7a72984kcf
f+EHd775ViPQtb721TfRxF+Icu/ev6u9q+IfCI7EJ++998+vfPnnVy6//OKn
f9IMiM0vffGNjzz3HdyEZttjl4lI+cEH927dvIv7f/zD39fGOyAA+4999PsQ
ds8D6304/LSAahhQDddVRG6gAZV++Mpvq/HYOdqgAca4+87v/latj+gwEIT9
3O3XcDH1wPwPxTZEN+NVQ7H9ja//EiqGy9HYbXvmDPuATTUS22/96i/o9eYv
/hz9nqOtFHVzUQ54BlpCWECMZA0heLjcFvlEPRvwBvjgt9oY27DIFz7/0+CW
ecE9mJ/DJ0H6TbGNK/AJl1sj6li8C+5ADXbbEtvAS1QHBXU2S4Eog86JHsGG
qA+XWxwqLAUH1bwC72S5WUE9kG0IWYNuW7NUaNdczN4NSIm7tf2DnRLqAUGd
yaiQNaCOOi4hEzY7VFMnXI4J6kzy24zYf1x0jPY1XzVwCw/CpUUHjAMThcv9
IuM+5yVkS6JHG9EToslQa3sgDcLdmG8NuAgmJQpRH8v0iCDUjURPqTY6VN6d
jG10QfASRVERo0iJcDkhUnlU3IKRiEpfKuq0RNBOaW+IqBZnyCdEe7jc5eIw
VIVpQd1bpIeUECz43qOCBIThsi29tFZaDYOfwDWgTIlFYuZaXAVeqJLhcrdo
pJVwd7YQUEMMWBt+Q6QpKiPJUEACwowS4tTuI3gRwqSDKGm0GHZoCLI0Ou3J
MuNWsOdukXFKsmKv6GSoVmOYodPSS2twO3sRXIM9p6W/RyUvjcO2oO7K9kw1
bZ9E5JBDZd4bKjOvhBpG3v0ijaFtzJGB3p06z+nDXYJmUc5apPQelRlqNYg1
Z2cRFZBQm1IAH+4PXvWojPqZTAXZQ2VT1EmJvAPSf71DxTwBjEhFXwaUADoh
OTQrOhrahmwfUIVLG4dY8SZExgnJhlnp71HJqx4jk88VdYfE75zoOOhQaQ+j
QnAiRIlCVKvx4AfZAtd56W+oI+I7m42wOm8votJC86KrR2WcHhJvKOq4ePGQ
2NWj0k6HJUfGBbWedaQx4XBuw7RBCo9KjWqqNN6UUanxhyQb1jlU5r1RseaP
pTgdzV5KI0acDbvc82iLZ+4kGY5IHI6KjNZmdTZ6zsoMdVi8dFSsrqjb5PlR
8ZpHpaaPi0bbiqiMuKM5W+Cl5aihLi5IVCvaVuG+IH4YcDKS54L4dGsRlShG
z1zyqBztFiT+mh0bO/27WRXeGgvz9S0i0bHYZnU0jkOZwzNPfStcHo9tKJXm
9PF9dNnbx1rho++JmyX6j4s9PV9GQqAKbOzlxrEr8guUOtoeF0TPh9xPhJ9W
TZXtJzz0DUt13JRjKOXcCYk4z5sWfyLakjnVzbfRKb97GT/2jEiuvq91/FiH
jB+lLPPrpfdGsenJ2Gal8nxZS4yK+dqXvNhXeHc1Dswj68s5k+fAvDgp9t8o
qBvE609KrHhUBD4gSlQbiqjMYaPnaGKocQQPc0XIFi5PdZbng6JaZWaeGj0z
0KOyUp6WXiPJviPC7bR40KPRPqel14jIOCyWOS3x7lE5RpyR9rCgDokXz4o/
+h0qo+mseGGoiMoIMnrOqj0qM+qsWERR14sdFyXmPSqjeVFkXV9E5SiwKFJ5
VKIsiqyKOiiynhPveVS+b50TWQaLqHwe6MN46n3P+cU5kWEwxafKdl5ixGQb
zPGYRqULwnudyLZOnp8XC3lUZuYFkUVRB+S50fPdx6OS6imJ14EiKmW9IFJ5
VPIyVOaKoq4tSlFG5Yz/aZFVx1prs94bKvPeo7IOPi2yKmq/eOcZiZ1WjRri
66LIqGOjtZkdhsaxsYRG2RStJbIZPasH0bxMKmOr48dxytYLjVmvMuqY2RQZ
l2KbtaiMuiQyNouolLUXKu8uiayK2hBZLxVRQ4SETvlJnpMFG7Y795/zTohO
xT0Lp9OOHljtjuzAJLvV9JZzaS5scnbPjnd23dHoHxeLqcx9YrEdKyJGnmvr
Nv6Y17MVw9bUmvC/dW8kpZPefn/BZljdWoV3zWa2TU9ZtotH+rpkk9Xh/6Jm
3j+WYw/jn3rVI/knYvR7GWzWNfl/IX2uNPaktnu6G9OxNni3xLn31PInHauV
y2n7HlHKrpW6Vm3jTse9hck6f0+c9qrlzu8fMdxN8Pptq53+zzRR/gHGcASr
rbhLqHO7kbm7/LJLq5ms+ldiXPj3sjqoqmsJxY+snBHHPd9+kwzdaplKvTie
XnXWRq/E6cM9+1zL8YQOxmMV9CFrQB96PbeMOtjqFbGHjrkP3y6P4Q/fjmNY
00xsLvpfS7DqNixct7vsqrttcS+kZUFjbgo6lvfkytgSU/0plKqqDuZSJHIu
ZpHPESAyTXKUekrODLA2xJ4116s9+z7r9E4vO3W1YZZfWQVGzX8ZBjO5N8bl
2Kb2oXcjl4lkhainm7W1eiDRGt2jLGV6tgciZ/aXRLbyrIRrWZd7oHJ2d0nk
LKOS6+pQl6RXec5Jrpd6oHKdYEl6lVHJtTyTLc/l2as8lyfXXrNuruxdlF5l
VHI1VK6fld6JSN2f4rIlXO7/9kIUUpdrIrkYPdcfvKZEsXdJ7nyV3yVJf/93
ye431Pu/9/aLrL1QOVNf3Ts6Za3p0/67rxpc6VvdegLfcXqtJ+jaB2Utr31Q
t15rH9TggshaXqehrOV1mvJaEmUdTPG5TnqfFy97NEbtOZGxvM7FDCytcxFt
UWR7lLU48lwUGR9l3VBXQinro6xx6nos2+X1WMpq9Bx5PCrHF1s75n7v6taO
OdPwqIyIMyKLog6LLmckEj0qc8FWw5mxy9fiKaPRMQfL+wVGxRzRtfgRkfGU
cPd7G5Tc9iqYK+VdCO6KnhLLeVTWbNuHkZNVXTsmrHhBipBLfn+MkXBSqMto
5PakRL2XkVH/RNYsnRjaJKh6dsWk4Bo+UYPkXXtbnfuvKJX3uij/SbGml59r
tLa3yBM4K6/B6C7fJvH9iSxHWl333mAcGRVzZXV8Q3OzRLDtzPKUgOfHtWSj
YlZ1n3tdSc/NglDeeR4Wqx8TacvnbUv+1FN5x1KM+FMMrJ4L4tdmkU/3LE75
8RSaSc749/oxQh+XqMvne/P6hXKxkwocoUxuZqnnwn0b48IsKp+qoBSGypUN
j8oYtJMcrKDl8ySsUkcl0rwnGGlHxULlsy+MiCMSR73O53D0HCuiUrcjYmeP
yuplqKxGY8lr4+J7pfNo9MphicHyySSOAobKUdWj6lkr+rZ8NoteOpTjOI14
co4sna06JF4qnyNjXM4LF3/mjVk4l72Uqmn5zBufz4udiRoyfV5iQNF2iA5z
Qu9l5I7/QfFa+bQf7V2fDkzx7c8Q8u5szo00o5oU1AmRYlai3p+epD0PSHuy
49ZQnd0OSJtowY72lNWkfLKTb4FGz1m4l40ZuD/HWaqX5bOtzIb90t+fv2UO
7BONFdXazOB94k2PSns8JlTtIiotoFJ4VPpwWnw+JajGhSOm0fN9zp9r5gnP
vbmdTqWVz2Az6veKd/3Jbq5p7JF2GZWnpQ2V+e9RWZt2SxTv6fjT5zyXvztb
Ko0cdpbdRlyum7SlV/ncPbmpJTwqfV2fA0/2LH0jELKknen8SaKExruGxlmJ
ok1L5OwU7xiqzgImpV3+OgI2AXDQwVBZ6Twqx/MJsVd5LZrfsii9fcmxTay8
PUc1soBn1nVdXMcAyupRORaO516QJfh+RlCNC3IPsgXUcbGrfSEzKndHBTVU
tgA6I2j1Kd/0FmPfBI2JL7cKWvn7JftiK6CajqxVHpWa19+0JNTyt1aQFfYM
z7dkLmkktq+ixkUjqyoIJ7RDrzlBPZh1SV9wbRKv2Xdh5mur4eFu/R4LDRGt
aRZB1LkcUUAJW7H1+f2km33DVp+nh2zBAkO5DetDg5jXjaoqfq2ps/g4Rwjf
zcEaEAqVpD6Tmnja93n1+Ju+4otzrSY0g/7oCsKVv0zUuXyc7zUNExhQ2/Zv
7VtJSAPU6G3L7+H6G0aYDr2s6iG2IAXuo/zDyqUKtbIkcbY7BAsCHKaH2wFr
ozcuoC+Q7dtJ+1IzVrF1IAAl5IT8i2fuwF4gAzFHwJVkCDfifH8AYwK0AgTY
GBZUgmLR7mn/8kE0ev6R+sUdq4pfW5a/1e3+erha8x8uXAF1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->18552354]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ParametricPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParametricPlot3D"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["y", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["z", "TI"]], "}", ",", "{", 
     StyleBox["t", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
make a parametric plot of a three\[Hyphen]dimensional curve\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ParametricPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParametricPlot3D"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["y", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["z", "TI"]], "}", ",", "{", 
     StyleBox["t", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["u", "TI"], ",", 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
make a parametric plot of a three\[Hyphen]dimensional surface\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ParametricPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParametricPlot3D"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["y", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["z", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["y", "TI"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["z", "TI"]], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["plot several objects together", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14924],

Cell["\<\
Three\[Hyphen]dimensional parametric plots. \
\>", "Caption",
 CellID->30188],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParametricPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot3D"], "[", "{"}]], 
  "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "x"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "y"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "z"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["t", "TI"], ","}]}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", "]"}]], "InlineFormula"],
 " is the direct analog in three dimensions of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"], "[", "{"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "x"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "y"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["t", "TI"], ","}]}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", "]"}]], "InlineFormula"],
 " in two dimensions. In both cases, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively generates a sequence of points by varying the parameter ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ", then forms a curve by joining these points. With ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 ", the curve is in two dimensions; with ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 ", it is in three dimensions. "
}], "Text",
 CellID->21763],

Cell[TextData[{
 "This makes a parametric plot of a helical curve. Varying ",
 Cell[BoxData["t"], "InlineFormula"],
 " produces circular motion in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " plane, and linear motion in the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " direction. "
}], "MathCaption",
 CellID->4940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"Cos", "[", "t", "]"}], ",", 
     RowBox[{"t", "/", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->20851],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{134, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->434180956]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParametricPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot3D"], "[", "{"}]], 
  "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "x"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "y"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "z"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["t", "TI"], ","}]}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["u", "TI"], ","}]}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", "]"}]], "InlineFormula"],
 " creates a surface, rather than a curve. The surface is formed from a \
collection of quadrilaterals. The corners of the quadrilaterals have \
coordinates corresponding to the values of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
 " when ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " take on values in a regular grid. "
}], "Text",
 CellID->13829],

Cell[TextData[{
 "Here the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates for the quadrilaterals are given simply by ",
 Cell[BoxData["t"], "InlineFormula"],
 " and ",
 Cell[BoxData["u"], "InlineFormula"],
 ". The result is a surface plot of the kind that can be produced by ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", "u"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->17713],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVfXmcVdWV7kkNTDIqOAQVjVGTTiqdzhzz8tLdea+T9OtbVcwCVVBVVDFp
IiKDgOAAiApOiDOIgBjUCKIIiIDMiHMcmWeqqHm4NUDd2r/31rT32Wefc4vS
l3+6fljee+sOZ31rrW99a+19zo3lTxxT9Of8iWNH5l/1hwn548eMHXnbVf9x
ywR4KPVbnuethf8+utSD2/8XbtF/a5VS8IfQ7/HwOxWekIL38IaiHy8Fbt5A
z7jV+Usq/krz73ver/9bPA8tRavayf9vSILIIPl7qvW+HiIE/12uHysqKsKb
P6e/DQx9YnvnmC4WlOlNi+inza/tKceTYj2T36Kt79BDPr0dPc6HjkfwsySv
T5dPvND+ZOv90r7G+9iv6ybvdwE9k1/Pb/HTAPLt5f+dbdTEEZ3wV7p5rRzB
T+gJN8nrurfynLHyHPs9u1n24M0U5/4/01NHydH0bNOz/6cKR5GSvLo84hjc
d0117v+InvrbEMZpoUculeO8zHmHNOd+Rpvf8eKI4/32eY637e+u4zvNQerS
8xz/D9v8CRj/+MBVzjukO/d/0OZ31JH83Ta9o44FzTxdI/C8xnllO+f+P9FT
+4tvv9emZ/eN+Bz3le2d+9+np2bK52Q4f+3g3Kd3865XyRmzd8QxUP73fO9F
9cFK9dFL+Oinr6rPV6kvX1P71qgDb6hDa9WRderoenX8LXVyozq9SRVvVmfe
UWVbVcV2VblDdW3TcV0X8lsUL+PREav02bxIvfOc2va82rFU7Vqu9rygAsf4
NzrG1YFjPGYdY4l1jFU7VPUuVbNb1b2r4nsJjY7OMbr3r6dDxBhNc9g++tgv
UmF2pPi7/o0n1JtPqvVPq43PqE2L1BawaQnZtAxt2vuiev+vrdq0QZ0Am94m
m7aoUrBpG9m0E22q3YM21b+HL2/8QJ39SJ37WDV/Eo79aPvO75Me4hPyacYr
j6hVC9RrC9Xrj6u1YNRT6i02arHaukRtX6p2slEr0KgPW3UUGHXKMqo8iVFN
H2qj/q5aPlXqM6W+CLN8J+f+dUms07VU12DbW8QrP10+T734oFr5kHr5EfXq
ArX6MTL1CbWOTH37WW3q82jqbsvUj1/BN0pm6smgqZVkKgQkmAoBGTD1E5Vg
Uz9HU9WXSn1FFbOLY+O1rdhoe1DzG3nwF4vvU8/fr5bNUyvmq7+SlX97FK1c
s1C9QVZueBqt3LxYkg+tXK7eNVa+HLTy9WDmGSu3kpU7AlZyiIKVHKJo5Wfa
yq+U2odWqgOqc6SdmtVsNWKs+s2Ts9Uzc9SiuWrJ/WrpA+qF+ejElx5Wrzwq
8cpJCLZtBNsWuba916ptR5PY5lCKnX4JjtTPxX1qP9l2UKlDSh1W6kg4Yql2
eb+RuCSrfvfoXWrhPeqJWerpOerZe9Vz4LoHFAToinCAEsFwLhrS9G1bGW3b
4VZtq92dPAtNaO6zbCPD1FGljil1PMw4VFNJ/ado/v39vDvUgzPVI3eqx+5W
j89ST4Eb71WL50aE6CoI0cclRDERNedwcWA7P9B2fvZqRHwy4WDp2uKXrki2
iQxOsfOQZedxpU4odZLqiVu52VrNM1H93OXyN0Ki99xp6oE71PwZ6uE7Ffsd
Yvppjun7ksa0yVdDwKZSet3wsHrbpGozjYnTFjtOwcwDCnyJdli+RDNPEU8W
hzXKd8jSCx0Lw32fVsIU+ZfcNUXNul3dO1XdN11JFNzlRwFEOxOVE+1YeaxM
9tqhjd1QFGi/f+H4fYPld5ID/JqL7Ww1dcVkq4uC5Wl1WgEKqkS5Ko9xQOvS
IvRzGA/dhbL+umOiunOyumeKmj1VQSzcH4oFw2+QGC9QYkAs/I0IAN/W+zbT
GhcmFhZGLJ0fF119kdAoUNLxPbuHcx2ROUTI2MFxUoIjBXABU88oVapMTbUw
urqNsaLVlNuvUexdePsENX2imjFJ3TU5OoiEMuciZULqLKfUoXp/zRqrmm+y
C4Eu5a0htlEQkyKuyxvSx16XPuiwwVQrqwLAheJJUCtTqly56u2qNuKm1Zqt
a6iedp84Xk2+VU29TXGg3R0KtAU2A9/HaH1/JdCNTrwA92oRa2sDA9tXr/mw
Hd/g63EDm6mcPuvaZZPCjTgSRM8BKZoIRijeDGzAsGUISLlSFT423wBB3UvS
1KLb+L+oCbeoSbcqCLlpt4VCboZ6yMpQPuIfYYo+ICkaZi3D1XbhSgbeMQPe
lgB4Tsly67KuV3Q83YHCBLtWQw5xq1SqSrk528dUMrtr7qLCCpr6wK433YT3
b/2Lus0KuZmTKORuV1znIFMh5Oj4fveUFjdLNWovaVEKysZXbabCLQug9mnr
qG0NoOYoNb/KB4kfws2jqSIaFhVuBjKIu0oMoyqlqrmyR6J3naCGvOZ1GT22
Zew4dfPN+K4QXpCaUyi8pAbcruZQeHE8/VJUoFYDXBR9KUC6iPWf0bZQBLi7
BB3go7QKUdqfBCXTJRuUbDLzyyMXAaNkj1JsHZdj7dR6ZKUARtCe1CjzgxBz
Zn5XEKLJ2x8LRrcUjWkZM1aNo2CCNLxNp+F0K5jgTyiaZgb4i4MJUnBFMAXf
CNK+KZSI0UrpVFvBSCYJOwOaP4K5bL4/LEoRMaIwSmGpGIUPRE4VRhKEUQ3+
C9XOKwinqyXvUD14F+SNahk5umUUQDVOmbyzqZ798m9zDF/NRL56jOKJif55
ro8sJ4JZJ0RvAWUUdjKgzoSAimYpO990JAFFobUWReENjRLgU4H4UCRhIKUg
SKmqVqm6yMxjvPpIXNH88rs5I1uGF7bkj2opBNSishBuz7CoyqmOT1saDGVp
MAN9dof2a5nqgchfYoMQQTp2Ommp6YOgU4m9mBadSwwA/IuHqx6tkBASqRqD
qwbnJ4YWtAASI4paCgCJMS2jg3kGN6ZOUEaQOrHDtc5hbE6yNQsRBlKOPaC2
7bXi5fPzks9OMAdf2cvRAW42HROIAnXMBAn1WhYj12Bc1GIyEUCIkReKFB8l
lAKX4L2OA/MSDFRuYUseAIWEpCTLyBs9DG2jKuBuxgoYo0IXW5RNUsPrjV2b
llHbtQx4XzcxBqqDlu4UqECmg+gE9bQnQED8vj0jUwqIR9CKrF/wOCFF2dRO
gkkDpepb3IjqTVh1Vcn7Wnv+hJ9MeHbqOzzRf0QCUL0xPzGMslC4a6yCLCRE
u06wON6NPUPwlIKs5Q1jSQU00nSp2gltMMv5cPitV8d45LFZlXDrQ5jWAqk7
XKXTVDzuBCEkKeISCkKToxyNNZindpLSo/Ut8GhDIlAJOQ67nVejOisg8NJe
+MhlsZxEVm6CkR6UnxhS0IJIFxHfjcEX+lkOsXtrUNFqXfYIpThb/D2T434H
bsTGIrX5OaQ6LA6kx7hz8qF+058u+V3mTlW924Jazzud4kmf3tnulBBpJ4AJ
ZlM1EY5azPY6zHYdvvAvBWB2o5jWy2jKluaFu8ww4qF1Q+f9qK+4JDas2bhg
APEHuCCnEIkW5STwx1hdpSHSxwfUDEc6cAcj/8MweaAqZiHzpFpnJDGVGizO
Wg/boc74S5cPSni7qiT8oSIZGSx0azoHQyBH2AsXAv4shpPJOpEstQR5neFY
Rh6ga2hOgtplbYz3VGWvSfqvx57E+0NsaLMBvh9RzOD8lqEjEXIgbpZHptBD
eTPayAQ+PG4C39S2ZVpk44zFqEfdh+ygiYGR17xcZkDn0Yq0H5YWskH3hZDR
AIZbTkgUdPRRD0HuGcZGqCzG9lFvhH/nQqhd+jVQT7bPAG/SO/SK3XguNuSc
8UH2cPHBjQXogFxN89DyjBsn5DNRkw9EPtv5q7lBkufIF+YxstTW73r4sFeL
dxz5RnnAVqOmZPoqzBbslgQz+ktKp4550hZpdswj35AN6cg2QOj4D6EH/zSe
+0dh786DqNMeAH8n+Jtt+IH74fEbmftZ61InxcQzQRMP3OZek0WLE/9LiHRY
2K3SHYHfOoWhX+0yjoHeaSldug9Fvi19Bf0oriGeby/lFJ7T0BJEHiBsOqea
zhp8LfRIkZh1MT3RcCe27nyX1t96xAaddWDPzEXAnZILwrrI0A6plUunaqWI
gzcr3oHpnzEtKzEO96umo5CGXgvqDvhuVzC+ZrBhGgyXWWwxSLMzWwmicSSa
HVbpaHQgUwoBnFCNCRfdlqazIV5gdC930HRXDWgqeV1sYJMLaE4z3LU1DBdQ
lorMIdzjTuHqyQOTYBCzSHxeK5dXiD+Awdc/pdojeu2dkAW2AIHt0d96C4if
hUC0dJ+ASNWQQbS1tN+VWWqvI9IyPKNReNkAmGhqCuU3dfestS0M3RU1Wkm5
Jta/MTagyUdyCCKJN3IwNFGKEJLSymDriwfl0wGXw2BkcgNjc8GLD0mX0Qto
gIXHThrEfRDFAUi/emoCMWqqHxAAZ8MlbvprqedxW1digWvJ6Shkqd510NAG
cG1uanKzuFcksu5qLCF9daxfQxhc/B3SeZz0IvKM1gjGqCHaR3WNg5zn+nc5
J/0anfRAs6AxDL7cQht8jzDHMr7bUNIFapvWc4Rz90D221MFKmloscWrhGgd
EqbJfEQ3BdMekyOIbeO5psYQS/r46lX6EK5XROIakHHDRUIMK0RQC0arUWOw
TRTlTBFruJRlMyQ+R9bVIJg57VE2kHBbT6Osd5aIVIau0Eb0oI3oOxrRPdKh
RFKqJ8o4HLGkEhxUjUSz9FknX58hrAFMzzY1uGzZMzJqXXSxn0kBcL1UAy8f
aU8HX+JWX58Vkj4zjDBZizNowCFo6R2uw0IVpAORBqTKoBnhWcZu6kS46f5i
td8G4giDe0DoQXZZ8JpGO8QH5M2uhma540NjozhW43qBwRViFR53cCXybxO2
7m4betX/ivWtx+DV8YuRG4zfzBwMXhRg+daIbTQKMCaFiaS+uPuAuxi8NFYT
1Uv9tlEBa0B3cdNBQw2WANxm++Bu0OByr0GDDHhCo5a5Aa11yBdahG8nv7eo
JHCDyPJcxhZXNsPC32xkGxvr3Z1/F0Vi6+4XJA65NJYdR3j7CryIaoge+pLW
GpzXAtVsOMBL+paFluEGOuY/YEtNIw0QWY+xrKVeWjoKPcjgYrZNy6sPg9jy
mBIXfLfikAikliljiK0hBbuKBfWBLV/R4FDUArZUuhJBbJtQFXiewbahsb6+
MR5SADR3kN2/Pr7dnWeRurg4lhW3IUZYQwyMQjY3MWhEYgjUtIJEDmtZmpWP
u4mR/dMUPZ+bRWphPokuU9C4bQDqFQULPcNiv5hxw4D4rtH4vk0rw4yvlgk+
6XLgHggErlPDjHyNwJcDt5GFVwBcCFz8IA1uvDFe01DXCr56B767BzolllUH
/KqBRSSRGhodydA3JzFgeGLwiMSNeaBpUS+wpgVeIFR/L7zAsyBQCro7gMBd
RK3wiw8i44qODUkEj5ZkENW1GlVLfLE4QFSZDoyqdUI2OGrAR6oJ1ShIURP4
iqDJVwS8VmEwrayvc9VVj8ioddGlru37sczaWGYdgMwQI6DCvj7EmUPOZQ9r
7p/bDBAPhNJG0oFLG/zV5oZpLMaCgfsMFTUgBiZdaHahT4C+y+uKllzGWzuE
S+18TxKPtl5Fa+w+yqipzrrsNznlqb6xvq4xXt1QV1Ff69b37pG4XeQ8K4Wi
MrPW62iAQ9S4cmng2EuXZQ1tBuT65jT344YrD9sEVFyjcGrG42KWsdwgcJ/1
EHUHT83GcrVM5zurr67QrO5YiiqLg/LzVbiJhpsCoFJIddBXVTuxZZU1CyfD
nfZKlyZT9NHOQMXvYBMnPG7wpONJq22MVxGYpfFW8EQ0SLn658HIo4RkH0xy
wJCzXMOIjwym+BvanDmsOSsnkZ0r45ehOr9H67o/iUUVjRznkmKFog+tP1Ql
Rq4XpzaofyhIDOH7kRBuwR0NphSZbtUTva9T2pelpXp0aAknmawIht0Fw0a3
sHNVx8rjeQBjeX3tmXjN6boaVx3RRIt2siU788DdlUxot7PRjsWqNd6XI7Sm
XNlyYDBTqj/uQjlAM4I8GnRxsoOInUIiiwfroAL0bpPeS7QEkEwnJoX6z32B
CzfRaPn2ANwODXiyVnEiGLVMApaaAlOla2hI2HAneAIQrkWeV1ZfWxKvOVVX
c6K2OhpxYtZW9++7K3Q0WbjavE8sVsW4I+z426da0Qj9G8Maod/wlkGswQpl
0sVUAUVsKnUOEOSMS58FTBRzhSheIWEAohYasq2kuqJRf4dQ15XLF1u2ij1u
9oiZIDdEoSsWGioKSyZXaUqPBiC+6fUdGnzORdiL4zUn66qP11a7Z6KRbqWq
38o5IenmEYl+4ut0F3GeGdvVjTIFQe/uYA6/gVgGkCjLHZlg0QsNm0eTsMmi
eP8VAn0e9cHIKvei1l2hJQMIMejQoAHeuRzbM3j2ZxpvEAvQ90JjxvqLu7Jz
n+iWzMiEY75GwN9lQULRNY7g1tJAwpuhbjpLbMLljamEoT5RV32stupQTZWr
Wru0FuFpNsopGmV5dSxWCUjGqrz2JrbxH3M4aAhCuYuNcuaQ5qxhCZC+oNCG
6gVqlGfjJMauYz6553YcN0D9W3iPr3eBTKARfoPELnTBO0CTvSgzsX1a5iLG
pHGh8/Vo3RNYW6SYURPHAxRCn9sNMWYKseQXminyy4/ls1p7deCax+wB9wHh
ozVVB6sre7QRYX2WjDsRd89hTEGgUxFo/iHubm9wjvXTtVLrjQ5QKUFsDByO
LcaN+Qkuk0DbvEuJ6QM6C+RsDmVSv8seII2xAIcN66lh274U15y5WwOMD7+J
85vTm7CP4OFNgKq/soL4hBa6FmF4tHSMgy9pyTCC0UytKXyAPS/eiLRY2VAH
goKZAu4erqnaX135RWVlSMV2bgXj0BqQdZ/iub3FGhUINuCquSNVGLtvHHCH
oP53v05SSIOu65fT3F+Pf3NoQRREnWENLI+kRR6kDhnCGWojdBlA0WsexxXm
TYulMLo4bxacedBw9mPdqe2LDmS7FnpmEKYHCoTzWdPu8j7C2sb66gZkxDPx
WpAbJwjkg9VVX1UhBq7iZYy1+tBnCLmI0hSigzBEZrmFKBIyvQJZuI9f+gY0
GX2XnYOzBxZ30FkUUOfm0Xry7STrZpuQnYXVDjQGUK8pdYLjStnjdDmLYJYU
QrZfahF8NDpIAyxQnzAqAgxiCjC1DMCrrI+XUy07RYUMwhOB6OXgRmceSFb7
ONHKTSeNUxlARSBV+lIhqy4lll3nXSadhZnmsjjDNRyEaQA1E5jfo0WWgQae
boJuJgYdtF7Q2q58SNZe0r56DfkSYqx4M+8j6yr5myyurGovu52Numo6CzZw
5nqkq2ob4tCMQtoyLlh1qqs4lz4qL3+vtExJN4UQcUxdKrHUx6rhsSzBhPiP
dkEh5V3sBZosXb6HynLWIKoqeSSWPFKo0O5L3NyBvcBTc8QC6KVAmL71DK77
GX1kAwPyH3p6w3Ck+y+KCBsLG0Nsdl0Gc0zNaG/AgXSD+0dqqg5UVwrTfFBa
vucModND0Ik8/1LOEfcjiVC7UqNWCsFEkaTzLqvGM7oz0Fn52EFPxboHyzGK
HlGZEEbQjXLfBAUCivBLlG3QuG9xUFsrqFVsx6bT5ysuvIelvl8mUVVuyfZg
PbCqbSN3T/FGHEdUUE8EIh3yDFmySqO290zZ9tN4GgxpdQTLXeWLRo32Q3fh
j4hlnyGMygA1oarMahs15v7rETkaRzNsfWmGN6wAtWKBzr4pt+Lv2aQSQZUD
3y+lugqNEOhDIPudy6Jg26Fp6mPSK1xLORcJ/56ShjX2jMjPQaqeWDrBoDrN
6lw3j9ZW0QwgdXdJ6ZaTZ7QiQYDcOXI0UnQ2UUdGSmzPCvAVe6Ir6uu+PKDT
1E4BljWseUAuTuQAKSB1rUN+ASIEoguEHnSNT85GlbdiPpZFkB9vP4u9+XtB
mKBHhGpYR61KM0uOfULlwlelsjlVEjKEkt0Bgj2QiWWkj5m791HV+7Cs/N0z
mEFvHS/pLDhdkBQntOQajQ9LDsKn1KSgwacLkDkmoBmwDWhkfPoCPsObcWhJ
PM7Pvn7SeJQOEEfzZ6IMfpbT72EUDUBaUOn2kvr9ktA58Rb2coCO0BULBUo8
YfMSonJKOs8WBxY0ZqrYrqYhDuacIQoH/j4o/J0G5L2zGE1be7Skk2DjrjJE
x5CNUax/sY+RUQgpmuF/EsvS9U4jJGPHPKR0aMrGcKJNQA0L4QOsDlkGjRhk
2eqFOGuAFgx0q0dLj8DnJzZiV1C1S2hJ8utgMHCs9PKkAQhAY5CBig92sFba
X1XJyOwpKYPcglurDxV3EGTcPoCRucRB5lrrWbGBpznb02JZgAtnGGP/K2hg
PVP6NDCQWvB7YF4ih/oojyretIm4ZgBh8/gsHB1CewrcAwJpM1D2C4IKSEzo
/0FfVu8WcYTpZAeMzdK1AonHq/8CCeZSPZEzZFFxXQ3YAP0ld9x7zpRzCsHv
lftP09pTqt5B665UhzC5znkWYZIey9ask0n8TJ90Q6CmcUEb1pw9HLcLDC9q
YSUOMhxCBeTQIyQAIJGAZqCTBMkIrXoAEV30kWBYKx618kcHiWcXepM8nleH
mlAEIfAuc+YHZeXbTiOjvHGkWPd7aJx7rRcfC3wWXc2jh/9XJAzKm+wgt2Am
1QZGeDwpAxSgKxlSgGKIRTTwLTTWIJ8XzsIeBLjkAnzm5cKixyy3BzIhYUoM
G1nbUA85wE0vONzTp3BtOoEJ8Oqh0x5PbXDI27tN/v6epfvE1kGn2OupzBB4
U6oMmhqXNSDmzxwkz9yRCc4A0C0zJuEInV5/werHkC+hk+WiC26GBhZUinDB
5xJdnZAGmCFDlidE9XeEsgqhztINdZvnvV9aDoe97liJPndEX6YKfvq0yXa6
9kxgHk7V+juxbJ8ByO16hYEbfRD+Oc1D8lB68E4j3mwIWQ+dEXTyEOBAhNuW
BMyu3EGh/QlVh4Pocll5rqA0D1nNlRKshlIASuKIZHfqzuIy8TqxNtz4Tpts
/aeQrazFYwMpsvsa4SphLYRnLM5Fi0FC0Ku+DV6eOw3ZH5TDyodxqr91CZ2S
r82tonqI04mv5FxDdrJHgwjPFECylaKgAxgKYuAg+RaU5eaTmGwvHziNNl6b
1EY8nh86fzUT4djgUyZ6fwAuZVlOBtaJdRTGYB385k3sQFh3T8HmDQobiCKo
apsXS8E/RKYxSWEl268ZqlSCl6ma7Womkq5riFeQzgFKkqzCiOUft8dwr8nE
VnZQya/s5c6v3OsnpeqY7uDnsrEeKGvQWcLm4sH5OOWGW9Nuw7IO1QuUM7Rp
bz2Lq69o+lqUytxecAR7zMzlEr5co43dUKxLKXBNjYb/rT5c7IX3uEdb7cxA
vairYrmI/Mh5J3pFJyKr05THHOSVNgR0fFdk52InzxULyhXUqsVzsWlf9xTu
92H7QQNLBpuQLiO6lnjGEGKVW9UQB4o+VqvnWO+cKhWPu3vJ3Ot5dfjGtv+z
807pPpsZtzOJUT5Dv55bKOEOxRkq8wvzMY13LJNAB9UGN7CN3K+LU4UJ8WYj
6Cvr49AYHtbs5Me2uwfpH2fpj513In2DH3k5xbiMatG7ZCkotPxRvl9Bq0JK
g0pFqlqHogPf+XPt0XKt0hs4h0V7suTkn1cPYjC5+yj+/+zDT/lJhF1ed0+z
GDZ+duhSMzw0P1FIQQs1F/o4qDzpDP4+7bRKTbagIjgXS4mP4Gfb6VJ8xO2w
/nGeci3C96Brk6QZA3IKEhSlacA08L9jG7CTSmUbKnRqkQCqaajD6s9x9ubR
Ev6Y0A7B6KPXHKp3wrtH+rOIV0k3wJjj8fJ6e0eA+tl7kRngztH1UgsYba1E
aGMe8D7UM3yNu8oWfYy9nGP6ufOsjnLsXjeR4iDFaImeExk6+VWPWcfEEVAl
GiuVO0r8Mdd+aNMR4bN/6fxVXwHGa8/jeI+GLsvn4yceWScodJBqT/s/Wbet
PYr8764fuLW9fSQaSY+hHc874AdIjA9ArtpAn6wtdq932bZP/VWUD+AuT3Wg
z4H/rVrAs92Lv9En/Np5FvI23tVrsF7qsnky2vDMGc7n/ZSezqf8xnkWCkG0
BY/bXfNK/o6I428FAZr4eXrn49c9nv/hPKuLWIvHgsfmdqFte5fOYlFPwdA9
K8Y9tnZtetdO+u+xjMKsjEI+RyBtEtzyvLn0W08/z1fz2vZ5hns69M0oHEAf
MDyjcGRG4diMwlsyCuGD8Qj0DMhl78jrep73MzUvQs9HH4g/ncjOuzIK79UP
6dh0+cztQPgzL3I+87fOs0yEd4XPzM4o7J9ROIg+KSejcAQZPCqjcFxG4V8y
CidkFE7OKJzKlmN8uOtjV3+jI9CV10vNpCMgG+lXbkZhHh3CaDoEehRf6KXO
o6fhq11G+RrHEO45u3Fw9SUYBmgkhmYUDtdHUpRROCaj8CbCQ45lKj0JPCRV
cb45NhefqyKPTa+CR+1mSpMotI9X2BRDJDXLxAnH6kDLe3DM+dqBfKTjyYfm
2al3ZhTew4GF992jdbt3Ptqw3ojejfI7bY2Ecoo+5o7s5TDGnkQVTxpuJoj5
iCfqwLsjo3CmHK2OAfxxa5l75Olf68h/K5inaoSzbczgoAHkwdr7nUZolIso
TMdScPyZOOLWjELSWakQG7MyCueYCHkko1A+zlUAV36dIw888ludRRf43OF5
gDXczaSoBjP6EegSt0MyCocJ6pT/9tE70E8h9KfTsyFoWF8B6z6gP+qb2hEV
+3jz1/qZxph0uJWq8//CQewCipscnZ7GD6MoSccFXTGBectrZ8y4W7uFvfKQ
yVt3on/F17DG3ROH7/0rK6JkpgfHST80O/J6cyqY7GXX5GrDCpIYxl4C227T
jrrdOIpVy+yMQnDT/ZIzrl2XR9qlfaL3N7g7+1ARt9PW4NFfmxXMaDZDNnAd
wikyXijY88q340LE/tfx9q7luAP11QW4Xe+p2Yq9xCF3G1VXY8w0nfZ3aY+J
vofgm6+jw9216Oohtsy9KttPQ1GWpm1CAQN9Z0vTWZwF8pi7TjT1tXgdOLh/
jEaIX+ApGmjdNrTuAFm3eznu9lzzOG5zeXYuNrygzKfdhn8qGqNyCltuzEv0
p2kX7gzr3wgGzsgo5JAERp5NpHwfHdSDYq/bYblXYo+28Cd25KFduB88Ttts
LetozTlOc98qa0fYEZqtUVdVuwf3U5/ciJcbhrt7XsDLD619EveeLLkfB1Vy
ptpkWvstGN0yfGRicF4iO8e3Udb8aNPWPTrzODhT22AfZRvv6Lfs+5egB+E3
VhCvx8m6ami1qhrivDzj29rYLKs4tWRrhT535ricddquZjcuCp3Qlu5dwb18
F2js7p2Gu9M92ulfMKplWAHuGcgc5puIT0zB+Q6eJRrLrOExCLuSoxVRcs9S
SG4pPvvH2uIYUTk9keP/WG01NHSl8drqhjixSjfLxoTYWE0z0TIl2XiUFnS+
oISknTC9ti/F7YSrF2KoLpqLe2Xun4Gr0nyNqlFjcUH2xgI82Yy3mPA4B0/t
wWXuuFw/QgbWsfJYVjk4FEozxO3DnFXujCbyGwpCns2w7DY8+et3aVWNf07U
VRfHa8rr62oa0Mdnmxr5XBvcTReGoNz3NC7x7cOFj7OUuFW7cFvq8bfE4+//
FddKNj6L6fvSIzipenI27sScQ96/bTw+p3AMnvYxKB/PcTSwYIz3I1iy4xjm
GplKHOhnATI09+xbAsg8wsi4uw8iv/sghAx9u8CvPVp+4J+tp3Dd6cMynDAe
qK48VovOOBOvqaivq2002DRheNBMxPCZZHwFrf8WWxHyJW5dafoIH6nYqYq3
4JWMBJ6VOJ18exFuUoDsXz4PCe6xu3Fz0d1T5IIPmB+j8QIFA/IQIeGG2KCz
LkS0zZD2exFImeWyJj4A7WGQ3G7ukjZhhGtKrHI8XIQ9s6O4lPXbDYdqqo7X
VhfTJKSqoY731pyz8PFjJ64CGWTC5xDx4hd08VWgxndxC/npzbijnNn/g5W4
xWUTEeTfHsXl5+fukyACCpkxSTFLjh6r8ka1DKH9kn1zE7yS7YBEx9wulskg
0dacrLJYdql0iTRQVyp8DQl3ChKNEnbixJe4p+z1IzgW2nyydHdJ2cfl5RxK
R2urgEpLMM1wcFWv0UoE0QJO5V34ElDlwYA6KPnGMgAYFmrJ6U0+YB++hNf5
2PIcjvNWPYa7GJY+gFv2FlBY3TMFSycmHu9AG1zQMjCvpV9uItsgNkAQ4wIj
62bEvzI4zCzDZQdBjVaR8Se9Tah1lxp6jY4pTNvHPjoBD605XLyeZu3bTpfu
PVPOcX6ougqo+WRdDVSgCmSneENy2Ewe8uqYz9THafMTp+JnIjEYuVOM3Bt4
EUl48N0VuOoHYuq1hZKQQONQkTna7pwsOTlunBo5Gs9fGVLQMnhEYkBuc1YQ
Pk/v84K87ExA1mhW58wsk+XJfiWxAach9M6HXqpBz911RjVMUPW6rjtawgvn
u4rLmMP20+rjCapvDGItgcjr+haIqF18EC2u5yuhoEI7rJP1U7weEoK4C89X
PB0CcfvzSPpvPIEpC7UQZA3o0kfvwgjkNeJJlLVjxqr8UbhrH8r/oBGJfrnN
UgAIR2L4etIAXXHrqv7xOY4KgWxh4G1Ag0+5a3HuHpFoJK9Q/oySVihePXT6
jSPFG4+XQDTupqW+v1cgkAcxINGTkMcgFyrr47UNjGU33s8QhNPiPrs8lIhC
uohzmckvvhdPWWI8jzGeq0U2QREFDfzmk3heyMqHMaM5fzvPnYb6YuptcgnI
UWNw0TN3ZMuQfDx1NSsHAeW9orhDk5mQtIZdVy+wq4ZnNlP1xWSMDTyNizXu
3DHyu5ZCqOrZp+6CvPQ1tF665eSZXSWl75UKi1y5r6ryMJWSU7QoBfxYVV9X
p6utyXWPZu/RuOqyIkSpM570ZseqnT6sBzWs772IuwJ5OtZ78Vzc6fDwXXim
5KypWFdYs427SRWNwWtJQgEelEfKbVizXKoFg1QLlX6MqaZL3O+PCZ/OsEqp
AVgNa8YGnVIqfHU1d24UjevFytpx2f7lA6dfO1zM60fbkTsh88v5k757oLoK
yg6oO1a3Hu6/iECWI9bjZbV6n0gF2XIdtB5dWfmoLtukbJhO695VHcmX7zyH
O2Qw9Rfo1J+DxWf+THXvdAzWaRPxQkCY/cSiw4uQRUXc0GmCLrZa4fAOHKzf
maYUlWM1yiqVLbfEpl8DU72Kgn+kTqL96kPFa4+W8E6zPSWl75eWfVIuWPYA
tXNMl/Cy+lremhX3sWwKkamotRsEzGrNAOFI5apOMoiZFZrEyh3YPUGFOrYB
o/bL1aKood1/ZwnyK0iiVcQHyx7A9bvHQwE84RbWRkQK0CjT4g7K7GE20QZw
9uSMIKpaUPVRLVUGCpcmB2DcyCsqnjd6uytrt347YNkNx0s203bHvaVlH5Vx
5e/AO6KIE2pYM1HkxrkTYJEZBpzO12bMazXgkQF8mPTAV6Kk8BJHUM324M5p
6F9OvR3C/AU883HjItz5uJq0wQvzUYn6sT1NYnvSeIs3aJUeWpt+IxKoSnM0
7IN92FkqkFLoIuyRVSsbxo2S5034hpZd3N29oYy7e8W6LsLGNLnqse4YKgWo
brw/+ZNyZCkgYhPlrBegJQRlX8e6i5D9eXOQNUR+MWvE9QI3i4dWYx2lGInY
+Hu4cRSEf8k7uGvy6HofepD/uwn6twl6lmXQBEAnKRF/px/xIM6Msu0GrfbQ
AuTsASPwHMG+Oc1ZwZBneUHUEseziOpM9y24W+WQ+eW8uKdE4q7XtejZaSAp
oMXk8kdHehlEOlc/phYGvbohXtdQb8SuRxtxXMwbNOZasMl5jwh6snj/wuLs
vbiNGVQw9KQnNuJ1i0FzfPmaj/u257HzWvc0tu+g5KCXWDYPtxGBmIOof3Am
7piDRnX6RNaI3aALg141F3UxnikIkg5ESL+c5kwLeY83Y0N/QWdupVHRpO41
s5pqZicr7AOEo2g3pMsx0Zi3F8yJ+7sDu0DTCoH+QVm5CfSDXBpJdDCjVzDs
oo3bE8c08qYgA7vnX7nM4G7VSXrldwLhzqXyK9F5wu7v4qaQ0m24A81BHvq3
d0nwbV6Mw6TXn8DBLnA88A3U0qfn4PZ9CHqtpLtAO2coB+RfPjE96Omh+Xhe
bP9cvFYEFlVRHnq0QuegpODQ6QKjranL80cIpsBiH1Oqv3c1edxLiyc/UVeZ
1itwes8ydzl7KBc+0nX2qv2UDxYJ1fAp3tD88XmcrFyaHVmIKeEykVRdm4lK
OFavwIxgJvoS57LNduHdiYUXXfOWuOYrcs1HL+GuyZ3LsLsGjbOW5Djz0VKq
wE/o2W03KAfQagsn3SJznEJyz4jClpyCxJC8xMDh2PFg5yjMA/lhT7761ZuS
bNVkcZDVTKICwixh/0T7xvVG61cvxU/ESkEztO+zoDR549GJZizWi6kJqqDa
7AXEUKNVJc6KtmxMBNzjiCJdo9VpnTxHhcsvZtIyddpoo2QuAoUEbfzbz2LJ
WLMQqYu6rUseI9K6fzquINw1GXlr8q3q1lukFS0c3ZJfhN3o0AKct/en61Tg
mZF8/UDtHToTnc7gSvd4REJnqrOXQPh39J3j+0ecE1rb+zre4Qx2Zr9dQaLy
hMmjXp+30HO7b3SqpZyuYKlqiScz5qaVi3q3pPgKyq7kJ+m8bIvd+Bu6Ojl+
OWj88jLupabn9H5Jk9kzUMGJzObNQP10z+2YMNDLTqThwE3AZ2PxTDjoEIaO
bBlM177L1uLVdgrgDm5J98dW0tvS9XQMr3n25EB4zfGGu/L1db1Da4Dd/16B
mfJVVSUU9iNIZPjRTGTY2TbU1eCo1B9kpeD+4qvD7nCTxaEzky/FuszzhOag
tGZ2vYnvpT3etP/lut3LsbBDeREOW4hfF/UicdiiuXj2Ptd2kFWYJlTeTS8B
LFaki4yHO1FbQNpCR5E5DIt8pp0pAxqNyErhSo+pItki1UhXG8ycCnhGZjlj
WhQ+E6ytvkhT/rUlmIv3k6iFWm8GDKUosdATtbioFW/U61qUwy3gjY6tuILZ
+v/43GVnR4nOjuO6TT7gq10gMHYHNMvVu/C0EcmVjaJ5IVc+e5VmE3/FIe52
7SWkMa3Als+TvgN1wF2UOtMxdWZOxtSZBHz2F2muC+kEFlwgxSEvzi6g3IAa
6zv0XBY7arA4ytOaLJYtvTaeH0b5k2brArp2RDq4SumfoojvOG2rp9o5FYdW
Izpz3rAAOFEn3Z9He0+ZxuqFybrS9IJHbo4yFnFsJhn0bSI/82jzqC8Gwtlz
RGeP0cm65IDHQCpDiwLd4ekoj0GPCIIZZBtoA2jN1z2F54ODcmOy43ZFUos6
ljnUL95BbTo0LTyNHzkaVwiHIdnhtVRBIAzMbe4PHhvmNy8en+vpt+z1ZtKc
LmXIMJ49g/L95WbWtywBwD9675zeY0yeuRAE8xHdp5zWTbknEyVZHD7b1GDV
flTOKeAXvHoa6eb2kYTGGfVjYTS7xhzXvYtRakRq0L40aiXgu2UTFh10y1p0
y+erxC17VuAiG05MFmErA4J6Fak2ZrzF95GmnoX7CubPwBMHZlEugazmCeu4
cYqnqigMRuIM5cY8UNbNA4drzww5x2vIhvS0PmjPzaVub4D3aoxKSGXiM/li
+cPd/8j+cXfZUmfTU/JEizFTYjzamdAQ9Akty0mVIc+IVzpFl5lAT/PDiFw5
5PeUoqA/lna+hkR0GXX0pzbhejCKAfDLGvEL9Jfvar9Aa7/+aTyBEiuR5rgl
VsY8RO3OHLmqbbepE3CAON7QnK5HoKqH5aOwhr5H8mboOX3NJqsm6e4He086
fYToLsx27kqCu9eA/XKxw2LUn/Y6ZmWJXW08uqiF4xSn9FOMoF+6uA2+7Rej
AM6ISr4+kC2GxKyy4ztmG5764zvmDT9hsP18Ec9j3Uq9/waSCK+Rhl6pqWwR
TQCg/uD1mwnfSyFp7pwsSoH7HZBvo8cqZrQRhXhCpThneDOfm5bpKGsaysiV
kLWMI14jz6T6rOaulbl7ItgvdLa9F92H2lxH/sI9LsWk0GgMgJWGpUErzuIr
k/UUh3n6jOZ6FeGvioBEkA5HruZ7tUgEJjer5qBos931tu+ufWt8d0G/YyrP
W8+KVsDKQxS37AG6Yjl9Um9WdXOm4tCGpTb0PyzshOaoBYIONVcPEDw6IzYz
pLllhsb+8vQozfIXkx2C6/rL3anB/upyXr3gepJ6qfZMeabJETlHe+1Q0aXZ
LpNryVkSgVeZk2aYoxLsinSIe8pLuRwZlQAyO+CxDREee0977J3nNPk9wStV
VwPnPTkbt4BgV3QHztdMZt1u0R7LcEiuvCJkPr7+5wAaMmfmNEuHdKPrrVg/
2VUlwzda3q/ji1K5yJ/XX+jVtn1nsu6OyF+deHGvRmuGRumCGlh+pyQc9R0S
dHx2Z+uEaOcY1qooVqRv5OgYzitew8brddOermtt7uMOibU364X7pken0003
4/dGFY5R+aNUbhE+Av3rgLyWvsMTmdDCso+GuD5i7+jpglEP3DWFdu+499ua
R+7OWnpFmt2Xsp6x558pOGe7IMIp9YEeVb4ZIaI3CqeRrSE0/fGUh6tV/Xt4
ci73SWVbeXXxcmiM9ryA67Zbl+CKOPZGT6LSXrVAJN0yao+eoVmcSAfqkDiN
QG/fzk3SLTIyHS3Xcu6RW8hTBlwvyGYvCen5XsLfnEn9G/wZajYuH5CXoryC
978Fd9E7bfWQPv+TVsjSanHuKZUoBU+ib6fXbZtYyGlma2/lit2vomP+jdPF
s3sgO12MtLNFRLgw6WkCCu+dfgfrMJ3k0Mt4uQBw185l6C5uZbExegLnpo7S
Q9bjpJqp7iOxdzfr8InSISHx8cSb6xTICt6AMygfL/GGLssJukyUn2E/e+4t
PkuSSe2+gc86OM8gtdjRlhDu2DoFvUfvoRNKvgUs6Lk0m+hkbdPklN0s2brc
4jqQ5naN4lEQOK+cnFcSdt5q13k8LYKulisVMyI0tiuIERfPxQ7q8Vn4FSmc
bthE0eSISZF3JoEeBEYs4laKmtwbC7DJZd/FfN+d0/vxNCnSdC/N37ySHXc7
pPSQvzqr4Nmx4Ws5sr+Mc7wUXGVL9TvXFKMXSNtJVvF3QBq+k6Si73VNNYnF
kfeLQGYFpUOA83Tr5GgI7moDybXW98/H5B/oodg/PHUA/7Ba9+WfpkOTX6wB
edxKx3kJCwseGzEj4iScWipueHF4NAKvk81eQhYccs4tXeSlVOOlUBcb9pH+
VmTyREcjs+35gaW06QrstO5G3Oa0rPQNWO1dMVDmd0f/4meIowaChafxAz2g
00KOJz4nkzmBGtldy/GrPrawnKOWCTU4jRmY5Lhr4jzhsjRvhsTJtzlRppF6
4N7p5pvxi3NG2QpPz4R43IrI63RxHJEiXZR7DkBaCP9rHMaic1QwC9KT4U/8
RNEfqPk4XbsgQouVBeUY6eUfRBOUXV3ew2uUAvwVO0hH64HbsSD8n76q5wi0
3oP9D40SNuhx6SqqMUa4mTTgeOhjkgBlAanrSUa83YTfB8VUxWUGBDYqgzy9
f8ZiK1dm89jbnbGlhtD/rkQ/nzenu5RQxLdzp5lxJd/25E/P8JT4zklruhX3
5IFrMOJJAgfKAqFetQtRL2XUNwnqh3Vl+HK1DDs/0F3nDqrsmxZj47mOisPq
hbjxC4qD+ebki+yQn0trb6CXZ1LETwlTD6+REury/fQAO8jmZLCn4AJQKsBu
q1lnGh1E/jon7nkO3Rr2vpiS7sNU5GQRX6wbEEfrctjv427vMlOReY7pB3xy
6Ll93MPQP49XYWPe532M1/KAhksyKGBuJKFPuX+6uneqFsETpVVhsvkzk83Y
FmZ9eARqM+mqFuwopWGJDvjInQAabRxJBWdj1Hmk2d0d4Zzu4AzvEke31OnN
REb94LU/ernUEgpzv8YaiiEBK60FrYKl23SCe43o0cveJOZeraljhaYOVqjQ
9j1KFfQBas1NJHN3Pmm8tBXMH3KFsTze4IxyB3cj9TfdhenTNaRRO1t8LL9n
KRpAzCx28MptitYmqQ4vX8ui39X9VkcWEaiO+jca0mrNWKaYHgD6aAjakxsl
Dq82wcoiZRctZvG4gwn69SBVcB9gl0g/bmkGcpcdt1Y3gHuOinRD4CqWENC8
bzndYKx4RYQR7qOSnzuuJ4ZayVDcppq49VxdyKFLquSPHLvihFZil/WhUx61
RLS5Ohn8dpHcb3HGR7YbaOrErTP0YiznX10gSgXpg9ZEnqHZu1GMkfFOdbQL
08doTR+mLeN62U+re9CHw5ppVu5fKcDE9pUhdd4+wgeMe1iDW1inCyEHlfi/
nifWQ1zBatBumYCga3apqh0+3qdouenYerzUI3B0K3hz72vkuS1NVugBLfDL
U7NxN0Rk5POEwi6WQDFGIeZrhuFmeAAt9XK5DJwF50c6Pvp1vg2DuihEPU1Q
J+CJXzr6ui/EL1z/b4gOb4ddNDvbiFfvwn0+5dtU6TuBCOeqyIh/vspFfIdG
/O1n8Uweng8Bo3PPylxj5DjWSDvIp8v3p0uZnCBlcrwGfYxmGyPLoYsdREMj
qJS056CNUa0ZXu+Hi8C2y3lEhglpysSfRxe/IIGYDicC4c0U0wbhtXh2+Zd6
XYjnAXtX4L4EQHjbEjxpWRAmNndoZKkd1kTocsaZCeoZWgFC3Zyglci4cSIC
WXr7EIP07n0edO1z7SNWDtJsuiC26OYjmwRcm5w5mjMkcG2qCFFz7e4AstzD
I1sYdraQhSYSuhjW06aZT0bQIEiAMKBU8tH05Midd4cMou+Z4gu8Kbf6dHHz
TQGNxyR9ZUBfROPp9oeBHYKMKmthilTqRHq0FqmRQu2gWHMtEIFDvXapq9wh
7biP5/qISGU8WSQDnqw7GM/1T6m1T/gEzJ96yWLdGQaExx2afq2K55KBXoVB
2YzRmSbn4vlaQl/3IXC1NmzaLvFT+nyBF1GoNHPyrjv8tjtbEJRtDaB01NSo
1/11XhulXRolIE15x5ecPKZVD24obLI0IRedzNTRUbVBycXXvPmZE1UURVe0
noYRkePUEYfouJQA0X0brbkyUAl0Nq18iMqvFp7PzPEV/kNWBZ59uy96jPyU
rLpZ9RKv87dy/Dyo0YOmAAuVKO8/I5x7NNq5NruEedt39RZ09UlaxRJXr/Vd
/enfAkJ8t66Pwt4Wx6xaIKLElMjFQQJ/5E5xvHCNxeJmenKh+Jq/6eyXjq+J
Uf6rNecakWBaEFPFLJ1g00P8Xb+QMSDSi0QB8sUqmRs5gDika0hCNIPOhCX3
+bJBImVmRKQA//aQuODvKf6VxQLeH/wMPxUVBEli2pZHEVXGasHOazZWcV1r
mBs3PiPiVKSSXW4oQRbP1Rx5T3Qo0BkYZs84iL6I2vHvaHDYz0kC389jtllz
XPXOVm1+w7X5oyibWZAzKZgS+8ojVvgb/aJ5z3i7i8Q47fala2tEXXVJn+9g
rkf6G5e2gpEdmep1e/zaZ+vgZF62+4+9VgW0BTEn/JqFfnwbpneYkFZR0Kd0
HTi+JvV5rpeqLab550/FqXYgW/lrE5pYub0NVlpdFusmqWAWrdlZzMrfDmdg
NmPZtW22TK8k0S6GHyRLS79VZHrWyvr81tj12JC0LVwoOV97TAKVYgqj8Ptt
tkBrEXuWEbl3t0/D+0ooxik1pCrElg1JbTHawjRkNtGY8xB/1OYj19eJdafq
fGYvfzTe7Cnv/JM2v3N4XdBdt7pWcP5FINt1NOhdZu7ewO/IkdBVSr3/7XCD
u6PmSnk2XefP+w9lVQvnfA88kt/Ts/7ovKe7y0orE3oeXR0z2WxL789x36G7
fN5/0XN/ExlPyb611PPCZ0vqnOvbxvfzz3nhv+P8opO8x8A2voc+48xdi0G7
hiR5D91HdtTvJWe94ecOb+U19ufqq+oWBNDXGfhnenSt9ftPKvluxXx6xn9G
oBM8hrz/Fs/7kwpmUH4IC/7tfev/AWAd7VA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->603658190]
}, Open  ]],

Cell[TextData[{
 "This shows the same surface as before, but with the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates distorted by a quadratic transformation. "
}], "MathCaption",
 CellID->17578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "^", "2"}], " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", "u"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->8365],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->37404338]
}, Open  ]],

Cell["\<\
This produces a helicoid surface by taking the helical curve shown above, and \
at each section of the curve drawing a quadrilateral. \
\>", "MathCaption",
 CellID->11477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"t", "/", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->1200],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{134, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->87122451]
}, Open  ]],

Cell[TextData[{
 "In general, it is possible to construct many complicated surfaces using ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 ". In each case, you can think of the surfaces as being formed by \
\[OpenCurlyDoubleQuote]distorting\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]rolling up\[CloseCurlyDoubleQuote] the ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " coordinate grid in a certain way. "
}], "Text",
 CellID->6439],

Cell[TextData[{
 "This produces a cylinder. Varying the ",
 Cell[BoxData["t"], "InlineFormula"],
 " parameter yields a circle in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " plane, while varying ",
 Cell[BoxData["u"], "InlineFormula"],
 " moves the circles in the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " direction. "
}], "MathCaption",
 CellID->2303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"Cos", "[", "t", "]"}], ",", "u"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->12760],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->85708954]
}, Open  ]],

Cell[TextData[{
 "This produces a torus. Varying ",
 Cell[BoxData["u"], "InlineFormula"],
 " yields a circle, while varying ",
 Cell[BoxData["t"], "InlineFormula"],
 " rotates the circle around the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis to form the torus. "
}], "MathCaption",
 CellID->2324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->6477],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydfAdYHEeaNqdk2bK99tre9dnrTXf/7e3dNUi2nNfeXVs+e70elK1gyUqD
BEISKCCQhIQAIUCInHPOOeecc2ZIw8CQc04z8z7/31Xdg/AIb/h5hpkOVdVV
b3315WrBmRvaWpfP3NA5d+bXX147o6+tc+76r/9X7xp7afO/qKmppbD/pq+r
scf/lz2i/ykA2Bvrvm+T783sPdA/tff/xlUj9nsLe/GDtTNlGfZb7UP6e4v9
3vQjZ6qtvqhy/h+0lM2GV835Z2/if39Hr1qr9OE/6a+JSgvb+V5wd0/wLfyC
/SWF1DZraWnxTfyw5EmV1t/g76pt5i6Qb3L+3IY9/l7l6s/4520hJ6QD7GO5
dt6mP6dUyr/CP207Lc8V5srv2rD8S3z7O+j1tcb50ieUT11r5Sd8+Refan/n
2ug38fdJuZdU2iX3NOjxRb4E6bHa1rWW+HJcmQt8mZ+ta4XipzKK/6Gltfhn
q959VaX2ZpX7/01rf87Xfot/5pv/UK3PnkLoDb7+Wxv0mVz/nx+p93P+vmrv
VfuxVeX+73+kvVf59v7t/7P+T/E03aq2tU2lrWfBrZI3f6RNJfX8p0o7z2zQ
zvo19OYPZkhJW/+1QW/I/a18L1Rn7A3ayj6+NqNSe7tKadX1+a+0toCvvVOl
9rP48RE8qf2ffM9+xff0nb/TyranEOSQ+L0KPkqu9O4GY9rMc4NNfDmOIjbC
51/50u+rtLJDpRylAo7+1119ja+t2qpqn1Rx3bi1n/Ktffp3+vLbNVw3pl7V
1UQ4yVZK1acY4XlGeIkRqm27zAif4emKsLQX+Lr/tob1Jp6TbV63TtWeOcQI
v2OEZxjhBUZ4hREaMMI7bGsvkKe6MMJNruzJZgdG+JgRmpJD9jqlUPYJW/7O
qH5Dn/whnl6BSv6utmUfI/yWEXKjoCN6xZI+i30ie+LOCL0YoS8j9GOEAYww
iBGGMMJQRhiuLoxUF0ZpCGM0hLEawvidwgQNoRqtvzWM1mSrWdED2sFtKj19
XqWnv6Zde4/H5DXlPAgY4X5GeJwRUqTeYKG5xQjvMUJzRrjWSxYfT0bLlyFi
NERdK0xDO3LXxeh3dGLf1Y5/Vzth94Wk3RdSdp9P262VsVsrc7cwe7cwd7cw
b7dwU8G7bJfz3xPmvy/Me1eYt1OYqy7kBPKWCEboz/VeTe3v9f1XtO/vrO/7
Zq7vh/j5UvutDiPUZ4SGjPAu3/nzNoy2PaPjzOi6M5e9mCv+jG7wzsvhb+uz
pWPfvZnwgWHyR4apfzBM++Rmxh8Nsv5kkPPZjbzPbxR8cb1wz7XiPddK91wt
33O1Yo9+1R696s+v1Hx2qeazi1zf2RaqPhKWfygseY/DbXOgBj8Utb9HMdxY
XlG5+iZPLWRs2+h4zjJCdkh6jPAmIzRmLpgxupaM3mPmqgNz3YUx8GAMfdRv
Buw0CnnndsS7d2PeN0n40JStlvbpg8w/W+Tsscj74kHB/z4o+sq85C9mpV+b
lX9jWqlpWr33fu1+k/oDJg2H7jUdutty6C4dz3NtB66L9uu377vEtiASXGj7
6/nWr4TNXwgbPxPWfSLkKDt+l9Cbp7YN+AQp8+sNR/b6+ln7HTdrHFJrq1Kb
rMrzN5iLt5nL95mrFoyBDWPkyBi7MSZeGvf9dpkF7rYIfd8y4iPrmE9s4v9k
m/y5fdr/OrEt5Hzjkq/pUrjPtfiAS+lB5/JDzpXfOlUfcaw96lh/3KHxO/vm
E3at39txFPeS+NyjnnNWkrMWvWfN+s6Y9J0xZpvo+/5m73c3JMeu9hzREx/S
FR/Q7tQUtn4pbPgjN+4tUTuF3GDYNlQ12rfoiAm1blm3+snfJp7/bMTZXlaW
/7dDFIrTjNZ5RvsSc+kao2/EXL/LGJozt62Ze/bqZi7qDz3fsfF93y7gI4eQ
T5zC/+Qavcc97kvPpK+9UwW+mfsCcg4GsS0UHQsp/S6k/GRI5amQ6tPBtWeC
6s8FNQoDm7UCWi8EiLT91QgvU/uZ+JKv5LJP3xVvqZ7XgJ77oJ7rkJ7zsJ7D
iJ4d28roZcuxS2ajF01GtO+MaBkNnzMYPKUvPa4rOXy+e69Q9Bdh02c8LYSq
C3lFUXWlbuHH/HMKxcvr7qrxNPADzvzbw4zwGAVByFy5yFzVZwxuMkZ3GGNT
5v5D9Qc26tYO6rau7zh5feDm/4lX8J/9wvYERH0VFPvXkETNsJT9kRmHo7OP
xuSdiCs6lcA2Uq6VVHUhuUYnuU43ueFSUtPlxBa9xDb9BDr/b/TcjOs1jJUa
xQzcjhm6Ez1iHDVqHD5mHDpuHDRpHDBl7Me2MH3HfeaW84yR/cxNmxmDh7M3
zKb1705cMhq9cH3o7OWBkzrSo0LxfmHH1zwSP77ONyk5LH/O68Zr8k4pN9fL
jNeUMuO3+ylrY8XGUUbnFKPHXrrC3L7O3LulbnZP/aG5uo2Vhr2thovjbg+3
D329Pw0M+Dws9KuoyG9iY/bGxx9MTP42Oe14aubJ9JwzmQXCrGLtnDLdPLaR
av382msF9TcKGg0Kmg0LKC6/7jLOFd/NkZhk993P7jfLGjTPGnmQOfYwc9wy
fdIydcoyecYycdYqfs4qhm1hwTJs4WHwwgP/BXOvRTO3xftOi/dsF+48nDe6
P3v99tQVg3Ed/VGh7vCpCwPHhZKDhE6UNtSazvE3UHmJ/12zxd44wAgPMsLD
jM4xRu8MY6DDkFVroG59W8PWRMPpgYab9U5vu3f9nT8M8fg0wufzmMCvEkI1
UyIPZsQeyU74LjflVH762cKs88V5OiWFl8q28ZP2HG17wqFsyrFkxrFo1qlg
3ilvwSlnySmLvbHilLLimLjqELdqH7VqF7ZqG7T6yGfF0m3lgcOyqfXyPfPF
O3fnbhrNXL0+eenK+AWd0bNa/DgpFWxdGx9P9xvaOU9xyh08X/hX5dhf20uF
8wHm4iFG7zvG4BxjfFHdXF/Dhr1nvNPDdKfvw52Bj94Ns/8oyuWPcR57knz+
khagmRl6MDfyWGHs9yVqz1D6KrvVUmncWm3SxvHBF1qt2kXW7R027V2PRWI7
kcS+rc+hrd+pddC5ddilZdStZdy9ZdKzWW071VVkPkVy7zy5d7bCK13hmaLw
SIR7DFzCFI7+cjtPuY2zzOqxzOLhqtn95Xu3F24ZzF2/On1ZlzxoDY8fzPfG
WCj1bKr3vspJCU1Gax9zcT+jd5gxOMkYC9XNL2rY6Gs4G+70ZguY7YqwfC/G
5uME+z+lOH+R4fF1js++gsBvSyhn3Z5yuSVdvzXruijnZnv+rY4i464Sk+5y
sx7KB3/Olmh8LG2xk7Y59Lc7STudpd2ufT1ufb3uvVLP3gEvyZCPZMS3Z8yv
ZyKgZypQPBMkng3ung/uXAxpXw4VrYS2ysKa6bDUfqoIKVEEFyqC8hCYCf8U
+MbDKxLuwXDxgaMb7BxgY62wMpdb3F0xMVw01Gc7MHJWqOpX+HEqUVoMv1BS
xUssNALmoiajv48xOMLcOaluLtSwuajhrL/T++bOYONd0Wwhyz+k2XyW5fBl
nss3RbSfz0YIm2J02hKutCdf60q72ZN5S5Jt3JdnIi0wHeDo4q1q29Fah3G2
bJPrRIv7pMhzssNrostnQuw7LvEb7wsY6w8cGwwaGwoZHQkdHQsbmQgfmYoc
nokano0amo8eWIzpX4rpW4ntlcX2sI0oYjsUsW2KWB6nlxFZiPBchKYjKBEB
MfALg3cAPDzh6gynx7CzgPVdthtLRrpTl7T6jlMd4Rk8sbSfSBWl9fNLcvYS
Ryv0c0nAGOxn7hxRNz+pYXNOw1lHw1tvZ7DBzmjj3UmmH2ewJR9/VUx57nM+
JxoDTreEaInCL3ZGXxHHX+9NMpSm3hnMMBnJNhujePx7qe10ucNslfNcjdtC
veciW63Zd6nVf1kUuNwRvNQVsiQOXZSELfZFLPZHLgxGLQxFz4/Ezo/FzU3E
z00lzM4kzc4mzcwnTy0mTy6njK+kjMlSR9lG5KkDitQ+RWqPIqVLkdKBlDYk
N9Fe/QSxBYjKREQKwuIREonAYPj5wNsVbrZq1KG0YqI/f0N79DxFR9UGfZ2i
o5StVM98UYmOloDREzBG+9TNv1W3OaHufEbD+4JG8OWd0Td2J935IPP+H/M5
XFyONnmcaPM+0+5/viv4Yk+YXl/U9YFYw+EE47GU+xMUl//Kt1ssdFwucVkp
c1ut9JRV+8hq/WUNgXK2fkuYoi1cLoqUd0TJO6Pl3THynlh5b7xMmiAbSJQN
JclGUmRjqbLxNNlkhmw6UzabtTqftbKQvbyUvbiSvUDQyZmR50wpcsYVOSOK
7EFFdj+ye5HVjcx2ZLQgvZ6ugReRXIyEbMSlISYRUTEID0WwL4HC4xHbx1VL
g4U7l2f0tXpPCFVR4mhoOzb24ZDWlTrMhv6dF5SIXhAwVwWM8V7G6pC683F1
79Pqwed3Rl9+J+nG+5m3/1BAW1J77tH+RrsjreyR+1mx1/leP93+IL3BsBsj
kUbjMcZTFM/tGbar2Y6reS6yAndZkZes1Ede7i+vCpK/Qlp4dSpfPl0gny2Q
zxfKF4tky0Uy9qqseFVevCwvXlQUzSmKphVFkygaReEgCqTI70FeJ3LbkMNR
1fNIzUNKJhKTEUckOEK8iNbibi63M1o2158z0un9XqjqU+FQUsXuaem9WcmV
1mlCa5zqOZZNCZgbAsZEk3l8kPE4qh78vUa01jtJl97LvP5RIVfGXNBoebD1
8fFOx9MS9txLd9hXfyzQYDLk1nTE3TnKr7ckWK8m266mOcoyXeRUpr1SHY3a
ONTFkz40JaM5Ba1paEtHewY6M9GVBXE2enLQmwdpPvoLMFiI4WKMloCTiS+t
VMpXK2WySpm8clVRuaKoXEbFPCqmUT6OsmGU9qNEguJuFLWjsAUFDbSvO5CV
j3TCR5AQiSg/MmRfS7gZr9pcX7in03tKSDkWKfv6E3jUuD8lZf2jeIJaHGt0
t0NNaTkJGEMBY67J2B9gfI6oR5zcmSh8N/PSh4UcxT175y8N9/e2Wnzb+eiE
xP7cgLMO4Tk+BrMBtxc4Pr852no1zlZGH0K+fp0TgLxgFIShOBIl0SiLRUU8
KhNRnYzaVNKphkw0ZqE5By25aMtDez46CtBVCHEReorRWwppGfrLMViBoUqM
VGG8GhPVmKrBTC3majkvzovyermiXoa6VdStoHYRNbOonkT1KKoGUdmHCjHK
O1DWhlKOap9FZipSY5AQTFAIegzv+3Ing2WzC5LTwqc8gK/9k9TKrewnFEt9
fs/SZX1ZwNwWMJYCxvkA439EI+rkrpSzu/M4bLff+KLh1l9b7x3oND8msTo1
8Pj8iOOlSbfrcxyuIZaydXOt9vtET6T4Ii0AmcHIDkdeFPJjUBCHogQUJ6E0
BWVpqMhAZRbpWk0e6vJRX4jGIjQXo6UEbaVoL0NHOboqIK5ETxV6q9FXA2kt
BmoxVIeReow1YKIRU02khbkmLDRjqRkrzRwMai+gWY5mGZpW0bSMxnk0TKN+
HHXDqO1HjQTVXahqQ0UjTznIy0RmAlLDCTARjgh4oHC7sWpxXnxa+JTf959F
XNVnQPnLdoo4K5eMBYyNgHHfzwQf2Rl74u102p9nLv+54dpXrYaancaHJaYn
Bh6eHbXRmeRoeLevmRJrNbUIJ0S7IdYTCb5ICkBqCNLDkRmN7FjkJCA3CXnJ
yE9FYTqKMlGcjdJclOWTzlUWo7oENaWoK0N9BRor0VyFlmq01UBUg/ZadNSh
qx7d9RA3QNKI3kZImzDYjOEWUn28FVNtmGnDnAiLIiyLsCqCXMTZ9q+hbRVt
y2hdRMssWibRPIqmQTT0EnRqW1FVSw6KctjOEVRSAhHrghALhaeB3FrYdepp
xDltcL1G9APdUU3JXpQVlLEowkGpjfUTyjsuUrQfCxjvfeph3+5KOP42MXiE
H9foft5y9a+dNw9I7hwduH9qlOcVLrdXPU3la0/YHeKMcHdEeiHGD3GBSAxB
cgRSo5Eeh4xEZCYjKw3ZGcjJRF428nNRkI/CAhQVoaSEdK2sAhWVqKxCVTWq
a1Bbi7pa1NehoR5NDWhuQEsjWpsgakZ7Mzpa0NUCcSskrehrI9WH2jHSjrEO
THZguhNznVjownIXVrsg78ImdPFyB50ydK6gYwkd82ifRtsYgaVZgoZ21HG8
fDuK0wnwmSFIcEX4Q4WPwfJDwl63Yp2/6gd+fY7atq2jaPL7jAplE0uWChkB
c17A3KRYE83kgEYKh+HW0x/Vae9pu/KN+MbhgVsnRjnfzGZr/SU7w5U1pF/x
tUOAE4LdyWMj/BAVhJhQxEUgMQbJ8UhJRGoK0tKQnomMbGTlITsfOYXILWbX
Jqn/cpsI7e3obEd3B2mitxPSLgx2Ybgbo92YEGNajNkeLPRguQerPZD3EJ9F
D4fgT9EjQ88KxEvoniejbx9GWx9aOtHUjPoacqU8m4w5KwjJboiyVHhfmzMV
qtIswYiA9/yG0pALcK1jFhyWT/gH1kVI1yFMvUpbKe/QFzAPBYyPgIniV8C3
uytPftQo3NOuK5BQCn7V7PKS1Y0V7qmulvCwgbcDfF0Q4MlqjBTcUERFIiYG
8fFISEJiKpLSkZyFlBzOE/tCdiVyqpFbg9xa5NaRKrn1yGtAPvtpREEjCptQ
xLLgTcUs491W2oKyVlS0oVKEapbcOvhWusWQ9KCvBwMSDEkwKsFEL6Z7MduH
hT4s90EmhUJK5kDKzcHL6CM8Dr1L6JlB1xg6BiASo7UNzfVqXHi5OAHZgUhx
QdQDhcflNQRVOfI6PvH8U1TN3dgY+WdVkP8JlZOUtnVZrU7AuLHIC5g0Qt5v
Vx/7uJnnGganpu9cWLyvt8LNyov25nCygqstPBzh7QY/LwT4IzgEYRHk2VEJ
iElGbCriMjjeuT2pGMmlSClHaiXSqpBeg/RapNdhU3o9KzrSG0it9Cawn4xm
ZDYjqwXZLchpRW4r8thPG/LbUCBCYTuK21HWgYpOVHWhpptqM2I093CDVdvR
24f+PgxJMSrFeD+m+jE7gIUBLA9gdRCKQTIfg9x8/AQDMvQvo28ekkmIh9Ap
ISusrZGfjBJW3LDSxxkRJjJXnad0FNVo244fmYmtPPaquqLqXFBf9DYBo82a
dQLGXsCECZhUNT7d4WUtzQHdI2NXT88aai/e1V9lr1vdw2MLODyCsz0xuT08
4O0D30AEhCE4itibXGzpmZh8xBYithhxpYgvR3wlEqpZFBJq2acn1CGe/bCT
sCmenYQdcY2kx3FNYD/xzUhoRmILklqQ3IqUVqSyPHtTWhs7a+zB8xkiZIuQ
24H8ThR1UWHQjUoxasSo60GjBC29nD/0eWk/BvsxMoDxAUwOYmYQ80NYGoJs
GIoRyjBGwFuBgysYWIB0Gr2j6JGiqwOiBn46SqOR54dUB4TfXse1VePgz/2N
WVCdvc1qSp+NSqSKi6Ox1qCVgAmg+G878FEbe/Hs3iHtIxNXTrM2+xJnQViY
4JElbB/DwQHOrF3vBU9/+ITAPxJBcQhN5jW35yLzEFWA6CJElyCmHLGViK1G
bA1i6xDDroModgq2RNYjooF8whuwKYydCsJoQpsQStXBsGaEN2NzRDM2Rbaw
NViV5aXoFsS2IK4VCa1IphI1ox3ZncjvQlE3SsWo6EG1BPUSNPcSfk/7sn1g
EMNDGBvC5DBmhrEwgtVRjp2PcR4GjKxieBGDc+gfR68U3e1orycY1WejjNV6
fZFiI/O98vdWBDcXSgtK9e5GEesdKrNBz39OlXhTLfpHZ6Zq/wet335OnFJa
R6d1T89f1SYLwvgWTO/D0hKP7WDvDCcPuPrCIwje4fCL4efhxfAchFNdMaIE
kWWIqkBUFaKqEVULdg64GWChD20E9ZZu9m6EZz08yPR41GEH5fzRrYhrQ5II
qe3I6EBOFwrFKJOgUoLaXjSyYlWK9gHwHoOBYQwNY2wEUxTk5THIx6GYANjP
OEf3z2N0GSPzGBhDXx/EInTW8TlO5ZHI90KsyZrUfML5Vb0ZP0b5W566ovS+
vaiCNuFIlNpfETDhFOjyfe82Hfqz+Ng3w2eOzLBXrugQ1fGWEUzuw8IKj+xh
6wpHb7gEwD0UXlH8mF8IzkBIDkLzEFaIsBKEl5PHhlcjvAbhdYS8OYi5OXne
txEszF4s0o3waIRbI5zr4UgF8+MaPKqGdRU2W1dik1UF+1+OTdZse9seV8C+
Ck7VcK0lJb3qeW4T0QJ2ghLY2elAVhfyxCiWoKIX1X2ok6K5HyKe/28foBMy
MYbZcSyNY2UC8kkoJlm9c5JlBASx8RWMzmFoFFIJJG3oqiVgNaSiIhxZ9gjR
V9K2EtEX/uk5+InKHGxVzsFz1CPFWlGBnBjY+3bdwU87jn49cOLw9LlTi9wI
DG/hrinMrGDlgMdusPeBcxDcIrjx7fBLQ2AWgvMQXICQYoSUIaQCIVUIoYCF
NPwQfxZ8twa4NMCxAXb1sKmFZRXMK3C/DMYloPGVF/SyoE8/17NhmIs7BTAp
Im09LMWjcthVwKkKbjU8FexgZyJWhKQOpHchR4yCHpT2olJKjFXWchIN8+Ve
HRrH2DimJzA/iaVJrE5BPg2wnykqHCZWMTaL4RH0S9Dbiu4aOglJKPJCsvnT
WL/0T88BrfEko46fAcqbfkmFsbeAiWfLae6sOvBx25Ev+47vnzh1kviPr1wl
7dw2w31rWDjgkTtsfeEYDJdISpIp8M2Afw4CCxBUhKBSBJUjqBJBNQiq43mx
XzN8muHVDPdmuDbBuQn2jXhUR7kPWfFcHHqv55Ia98fNu24qrmbAKAd382Fe
hEelcKiAWzVvLUWy/EmE5A5kdCFXjCIW9H7UDZIudYxyZV4ZmcDkJGansDCN
pWnIZoAZgjnBZ3IF4zMYGcYgq9+28JyoKgw59tMuF57yEfzzNP8yjzCVyT+l
jObhGsfZ/0HT4c/FRwSj3x0j7uOLerhqBENTUt/cEVYeeOwH+xBuFM96pMA7
E3558C+CfwkCyhBQiUAW3nqetp4JaoV/K3xaSX33Vjg3w6GJp/vN+rlzaipx
2h2a1rNqyj+dJNzIxN08mBfCuoRA7KGk7WejWhHfjrRO5PaQpqsG0DCE1hGi
1vO20PgUpqcxN4OlWchmid7JfpFlhKllTM5gdAhDYkibeHyLPWRxt34cWxX7
iv+m43jKS0D4OmeDgvocySGt+iaFmNXxEwVMyb536w78sfPQV4NHDpIha13C
pZu4boJbVrjvQBp85A/bEHLgHA+3FHhmwiefolyOwCoE1j5BeVtQGwJF8BPB
RwSPNri0UB/hW8ouaprNHnDmbYdtF5NgkIG7uTAvgE0JnCo5Gn89oxv5EpT3
o3YQTSNoH0PPBHn62DSmZjA3i6U5yOaAeWCOjnd6CVPTGB/EUAd6q8jyrQpW
ZFk9u166ceP+UXtfVfdYo0rVjFfO1xJIxvJ29b6P2/bvkR4UTB77ntihF67h
yh0YWMDYDmbusPTnUfmJYwJcU+GRDZ8C+JcqSZMaO0EtYDELakdgB/w64Cni
62y2b1y1qKQkSHPgiG2maTLP9fx0FHQTcTMT9/MJPXKz/3pMG5I7kd2Doj7i
eq0fRusoujnoZjA1i7k5LM1DxuK2QNAjI55dxPQkMVn7G8lAm+NR7Kqa77Dj
KfzwxLJUibA8x2NH6fe3KhnFAiZawBQJ3mve+6eefX8Z+/Yo4Zxn9aBtBD1T
3LTBXRc88CMlbaPJt0s6PHLhw65oltCqCatcD1hQJ/w74dvJe9Wdm5f5yf2d
cpVs3mf1A7/tZtN8PC6DazWP8c/Iwu1GXi+JCtQOo0UJ1+gspuYwN4+lBcgW
gUWCGIVrHhOszixCXwUZW3XAP4XVD65s55GiK/vVNaQEjDNFqlLwUbvmnqED
+wkJnNDFuRu4eBdXLWHkgPtepAGbaDgkwiWD54D+FeuIqhVBIgR1IKQbwWIl
RXm2LfII0UzP35Dn3FjYa0M0uVNhuJyA21l4UAD7MnhSxSCK1W1ZgpKghINn
DF0cPHOYnMfsApYWIVsC2M+igjQ9M4ExMQbq0VPIMbO1DLLnfwQXpU2s9Llt
4VGhnqDXOFQEjA+FpEHwSY/g60n2+Fstxff6EN6Crjmu28KYutIeRcEuEU7p
cMuDVzH8Kvh18SxLLiEdCO1GeA/CJKRoQOeyXwcBg8tx/xVp/taSpgMZhDAS
15JxLxtWhXCuIKUj12AYQM0IgaFzksIwj8kFsoIWKQyKJYrB/BymBjDSCmmZ
GrVXn8qkUrVA/+VvYKOad7SWV8Rzc+rL/Bl7JGBIuphgZ5vgzwOCvYRojuoq
ThngvAn0HsHQBSZ0YT2Oh0MqXHLgUQSfCgTQeQ5u5WhoW4QEUb1UQ++Vh/YQ
U4rucPglafnyosCMXDkRBN1Y3M7AwwI4UXU+ohWJXU/waWbxofraCMVnbhHL
LDjLCsWSnC6hMYx3Y7CWA+cfx2ajmK5yXwnVvNnWaGzuddJbjXLyvYd4hw+c
kx+/irPGuPgQ1xxwmy4e61jYJcMpC24F8CqDXw25GNqG8E5E9iC6FzG8r25z
bN8Kv2reWcNCe0FwT6bpQupcjMHtdDzMh1OZEotOZPWimMNiHJ1UlRpdwNQi
5pewukywIC0uzGJaitFm9nilxGEDLJQ7Zuion/JvbByReSr2RbNpd1UJ3pdw
XOC1Q9ry725CaIrLj2HgRupZRMImEfYZcM6Dewl8qqiToQ2RnYjuQWwf4vrJ
laRBefIAJ7tpPvkvBbtLBGfnBHdkAidyXycat9JgkQdHikQ4h4SEIFE9SuIk
3TM0trKImSUsLUO+opAvU5KYG8E4y1ILVis9OMpWzZ9R9XVu/gcRUc3YfX0N
kXdqBR9JOUR+fuCy4uRtnH8IPUdS6X4oLONgmwbHHLgWwbuSwtGKqC7E9CBO
ioQBciVtWJE5TMRLqahATYkJ0eoEn3QKTs0JbskE9mSedaIoLLkEFs4Dz8KS
3YuyIdSNQ0SpY3gRE0uYW8bKCoGFvaJYmMREB6RFq7W+HCYbUcemfwILymmV
a4RisJtlqIM8VRy8hlMm0H6Eq5QkzKJgnQz7LLgUwqsC/lTyRnUiToIEKRIp
AFmjirxReeHwXIW0nbaym++R2puCnSQlUXBhlRCHHUUhErdS8TAPzpRlRLNG
OWsH9qNqFI2T6KCUMbqE6WUsrkC2SiFYnFZMdaO/VE3t6bjucz8c3z+JhWpk
h3LRrRSTOsGfRtgDTS05h8zLF+1JjTshMI/F43Q458OT5ReUb0Z2IK4HSVKk
UJMqd0xRNC4vG1+hTVFu8RaNZdwWMEmC90SkWb1VTTNC82cCcTUOJpmwKYJH
NamdQNlGyRBqx9FCqWJwCePLmF3B8ipkK4TUFNM9GCx/siJ+uHtno/0k//IP
IqIaiaExSRrreqda8NkoZXqKw4Y485DXJl40DodFIuyy4VbMs4xwEWLFBI70
IWSPkSslE/KKSTlnsUjEhCbYP6kpzXHapaSWNwTMA45Jke+zq5qGMs1HlGbC
YJTMrxw1qo2ksMpaPypG0TAJ0SxdOazqv4LFVXblUIBmep942H+IDjml876m
cyj1f1XPL83eJGa34O1ywZ+GybRdxLe3cMYKuq6cBN7hmAfP8ifrIl6CtEHk
UDdS6aSiclrB61yS4dahHjpw7lxqqNxNwPAzpvYLAUNytFmRJfiI5Mlo6sr3
msgPUF6kH4N76bAphDtFOK4DmaxoGUK1kkYGKI3MrWBphZCVYlYqowSiioBS
r1JdR5wh+YbKVRrppHkpu0oEHw9wCBy9g9OPyDMNgnA/Fo8yOHantrVxVtE+
S5TvoZGWyd4C3hadsL2opvz7b+Vcb1mX6OLGcR7Be93kyjmF5g3Fvod03kNg
lIgH2XAs5dWv5G7k9qN8DI1UsZAuYWQZ0ytYWOVX6eblvvx1I/3BnsENdtBw
hvKbPEek8/1bwc4CwYd9ZKjaOHobZ2zIk26GwDQeNiwfLIZvDb/mE3uRMYQC
SuHVs2icQzs1pganhybG2hakheyxrMJtNYnkM0891B64RMacsIt8E9uE27lE
OYOOGu/z8KVgl/N2ieD7Vc2rir1mBI1zfrgaDZN0PC6EJ6WC+C5kSVE6inqq
hkoWMbSMiRXMUba5MtOrxu+/U9phT438LZWrL3G8Sj1X8IGYdOSC4ogRzliT
1g3DYJaEx9lwLeG5XkwXUqTIGUYxNQYa5iCah5jaR2OzI3PjotX+EkKKtQHy
XBt57G3eCzKqT8Zf+gdhtDpdAtSq5XPuOCpZh4gJawYJmFABkyN4p4ZQCJ8f
e0Wx7x6O2pJn6UXgXips8uFOBXRsJzJ6UTSMmgm0UtbQv8whvWV+tGmN1W20
BlR5H4fRL1WuUv8s1S3f6yTfWopvbxKWwGFkmggbFiNKsOFtiBcjvR/5oyij
U9Qyj64F9C2S4+m50eXJdj4TrDkK5V7IsOY9IvMPdKau82gUvS2MUqfZxG8p
uTeXDcutLy5Krkuv3iUchENZoF4oeK+RI2TBsWXu6vPH6Lq9HAbjZFjnwZWT
we1IlaBgCFUTaJ7l1+fICstPCSeZ7C3caOWoSk4Oq19thNVbgt3N3Mo+fANn
LCnnCIVJIqyz4UxzRiLakCBGxgAKRlFOgRItgCVnVvCxx4vzJGNZMdoISk+o
C0WxJ5Kt+BW/+FB35sb5EaGQPy/YLUx8WxiswZ0r92xvYmHaxP/SKJqAuUK/
7wsYW9aw5HyDgp1lgvfbiDbE3jqxuk8Xh2/zceQtVjlwpvInUsTvWmR7OMwu
uOVVtY2kx8a85tcqV19UcsTfCM7ID1/H9xbkEddDcS8BVllwKubxSRQjcwCF
o6iknK+DpaIljK5gdpkwXMXcgGKiHUPVBJ/WRFSHkoPERwglcaJlS72F2xen
LmnxI8naRXYc+jFCF2634nr/DS1AR3eQER6hmxN4Pr6XT8G+IGAuKXm4uYBx
oMkZ4ZyvVLCzXvBhF68nnJEf1MNRY5ykRHclBLcTeCyfS+5B7iBJxKyf4TkX
CyThG6MtampPxfxU/W8ckr/huTalMZJIK/hu5aA+vjOj8jIYxvF4mAlHVimh
3IoFMGsARWOopgB2LYKIzBVlTE4xP0aUqpEmSCsIEk2J5DvXC4n2CH3ArakV
E5KAMaGl1X9M2KUp5MbySixlW96M0JkR2jDCh3SHqTHdp3iN3rpIv7UY4TlG
eJoRnqQb4tgDrv7Ww3T3yz4S5b8kYK4p1y8RBizr86fpF3xe0euCXSLBh1LB
l8T3ITivYOnlO1OctiMDuhaGu4mwYpdUKU+kLMh5Qygbp+tp/sl6kvYWP/8P
Iay6w/x5Ja3+RPMSjpqQti4F4nYcLDLgUPQE5+wBFI+hhuol4kWl332BV+Zn
FLODGO/CUCN6K5RZQmURyPVHoitCH8HbjK+xZHRl+vLl0XM6/ce1uvcKmz8X
1nwk5HSNzZZKYUEXs9oz5+j2W/boGHP+W+biQebKPiWWvxIwFnSpuwuYIAET
w2WzCNSrBDtJ2jZPrSdW917EEUOctMA5asYaRsI0BTZ5cKNcMqYDab3IH0HZ
xBNA+xdlamtRvr+BJ2eP/PsGeHJa5AkqyW5G4wFF0ptqGIndyO5HyRhqp3kM
Xx5YJiS7sMoah8QFg/kJTA9gtAv9jeihdFubitJY5IQg0QvhTvC14VbvW3MG
BhOXrg6fvdx37GLXPrL5k71a/rGw8D1h1tvClJ3CeA1hJCMMppuU2Vuu9HuN
nu8yQiNGeJ05f4XR0WHIJtLTzLWTzE1eruxjLPYxdnsZN4pzmICJFzCZaiRE
Wa35frPgQ7Hgz8NcZE9wTrb/Co4Z4zTVKvQDcCcWFumwK+CVmrguZEifCIL2
BfRQcdnema0aGX1Kw6Mo/x+VqzuUVLtZ84qCpxlKQ691L6Cf8oB51q5apR6I
xQXMTWJyAMNEtqObmCKoyUJJEnKikByMKOKChJst7Cw5ZH8+oWs4dPZ673Ei
Tlq/0a7/QrviU52ij7RzP9BOf4/sm455+3y4xnn2rg8jdGeETsyFx2Sn7xUz
5upd5oYRc/Mac4tra9sZDZvv1B0Oq7sdYvwOqIftV4/hZPzed+oO/KF17x/F
gs8HBX+d4vMHNXXBqh4nTHHOVilUqdBYz/OI0BhDxRQvVLupevaDN4H8OJL/
sQGSXMTotEzzNmlIOxBG8bDMhgtnmbUjRYL8IVSOo3mG19DHqFmyQmiWQjy/
gBnCvzDYTYK3XXXK3OSSDOQmIpXsbUKwH7w94Owit7FfMX/E5S290PHtzea9
hrXfGJZ/fbPoS4OczwzSPjFI/OAGey/s7WuBO294MwZujBHHEf5NX8Phkobb
BQ3v0+qBx9XDj6rHHtFIOaiRTUm0cu/uhoOftB/aI9n/5bCmYFpwmIRT9+sQ
AjlhgrPW0HYm/b8VAfNkPM6Bq1L0J/Uge5DIEfa0cR5t85yF9/JGCD6F6O94
mUX57y/YapqXFfupxL8SDpNU2BbAq3oD1Z7VGFlDZ2oZCyuQrUDBu8tIOJRE
DQd6IelARxOaa/jskTyy+hAXh/BIBITCI0Dh4LNi5b5w33nmlgN7a/iyzQu0
pMc7Ns677Gw1nKw0XM12erKXjHYGXtsZfmlnzIVdiWffTj25K5vLVzr4QcvB
TzuPfCU9/M3YwQOz+44RxeOwjuIoq7Tc5fjYizeDYRILq3Q4sMuZquPRHUju
fWIkNM4p2uYIyK+o4KOqi3N4/V7lKtWx3hKcXNlrRBrRCsDNeFgoZR5LfmkS
FK63ihcxtsS7GRXLCnCe+ZlFEm0dGUN/P3rEaBehuQm1tRwd/gYZOUjMQFQK
ghPgGwPXiFXbkEVLEumbvO0zfMNLesVdrO0mEro1nXKtOe5aftilcJ8Lezft
L24JX3lEfeEZ+pmX/6c+Xn8IcPko2P6DMOv3oti7JrsTb+9ONXg3S++9fO5J
b539uP7Upy0n/kxYzbGvB4/vnzhyZP7oSeJmPn4JJ67jtDHOW0DXDvo0sHE3
Cg9TYJcL9zLe4xDXzZsX7HHNLBpmKYPjvFjrY25r8d6n3tNC7ULqyz4n32tK
ql8Ox13WnmInkFIi8eizlDiCugm00TU9tIiJRcwtEXc+gZOLiE2zomkew1OQ
DkMsJWmsTe2obaF08QskFyE2D2HZCEhXeKXIXIh2NWcZO2kaPXInUnozQnw1
vP1SeJN2WO25sPLvQ4uOh7EF0g9FJO6PihHEhH0dG/BVgvf/Jrt+kWb/Odmd
Y/EZt5tt+7U9jVe+aNX9qlP7G4nWXqK3nz4yc+rEApcVcfYqzhlC6x50HuKy
La5xMEZw+vsW1oRP6kXWMIomnrzZ6Edw+++NcCNp2ILz8r0PyHJkjfP7GbCl
2S8RrdRVIUX5KBomeLfm8AIJg7AHK4tQLNLAK8/5WBodmoN0EuJRtBMvC2q7
UCFCUQunI76mCClS+BWwR4vOOTO2WROWGcNm6X330rtvpYlupDXppdXqplZo
E7Um90xG+veZicezY47khB3OCzhY6H2ghI9/We5rNNvXendfh9H+boODvdcO
D+odG7t8YubiqXk+S0v7CnQMcPEOdM1wxZpESW56kB6bRMAiAY8zqRu4kktD
VNtcPq2onlwlQNC9Hk/yZZQxc+79Sqqo0R2LF2WHrQlq12Jhmgm7Et7Bk9qN
/H5UjqJpEl0zfGbK1DzL6rC8APk8MKvMSWGNH5YSpfMQT5PTpiGSzFUpQUk3
8jqQ2YbkZl43HLMrG7AulTwo7bxf2mZc0mhYUnOjlNv7vMPn+1b3k8Qja3tC
bHmyz/zkwP1TI3dPT9w6O2OotXBDe5nD7lX9W7hqgmsPcf0xCaLd8SZ9eBAJ
KxaWDOoMplpiWBtiuonrM5umsZZMKsonZG88hQ6nXzO8NKBc7XkqDYhWdy4Q
1+Nhlg2HUt5FniZGYT8JnnAeo5E5THJR6TmsztI0nSmell7CIFUMWbW7fRbN
U2QzUNUISum2wSyJIlWsSOgiJBjevhDUNuPbSlF4qfR2a4FhW9YNUerV9kS9
zpgr3eGXewJ1+3wu9rO3nXRG7XQmHunOWF5aeHB5yVRvmfNO3TLCLWMqJS1w
6xFuO5AA7H0aXrSKwWMaN3Au+IF/NKGPOIXZ44JxefHY6ps/goyGCt1QzwzJ
fNh3lSIUBINEmOfwsbaYdn70z1fTSFsX1XaGZzAxi9lZLMxgZQbyKWASGONo
6t/RK0P3CjqW0bqEhgWyV618SlE4rsgZVWQQV+9y/MB8lHQmrG8iqG/Ev3fA
q1fiJulykrTZSRofEfds+YO+QlNp7r3+DOOBlDtDCbdHom+NhRtNBhkSevQw
WHA1XHYyWrG/JeNsJou7MLsPMwuYWcOMKmxmbjD3hkUgOX4cD/tUOLGKBg20
8H6g6C4k9q1FFeS5Q/NvrUOGcCcOL9U3YBG8tnMtiKizXIqKITSw3GWCz3Qc
n8H0DOamsDhJ0xyplYhhjsLeQrsMLatoXEUt2TipKFmUF5CUk6V0stt5Om5y
InpyJHxiIGSiN2C822dc5DHe5EK8NJX2kyWPpwoeTedYzaQ/nEu2WIh7sBRl
vhJqthJouspxs+1OlrC3wuNHsLGFjSMeueKRJ6x9uWe/YJcIx3S4sFKuWBlz
o4sqvg9JXLxphO5W+hXWvb+Je0eeauYq5VJX43E/i3IYzoZKoMHIkgHUjqB1
DGIuk2EaE1OsXoqFCaxQLBTDZG+AQgqFhPda/FxeJ1+tlq2WkwDDYr5sLnt1
On11PGV1OGFlIHalN3K5O2y5PWi5xZ9oRtVeq+Ueq8Wuq3nOsixHWZqDLNFe
HmMr57O//e3gYw9PR7g5wdkZjq5wcIeDN+z9YR/MI+GUApcsuOfDqxS+VBiH
ixDdjbg+ZehxiKa1/GYjXYqL2G/Ie2+SNaQdReLVVgVwreTXEMtlCvpQNcTn
WnErangC4xSPuVHMDWNhCEsDWJZiRYKVbqx0QNYGut/22dFs+VC6XJoi70mQ
d8XK26PlrRFkompD+B25O2I8EEnFSbAn/L3g4w1PH7j7wT0AbsFwDVPmpzgn
wiUVbllK34yvMj8hTITIbhKIjqeB6ATpitoTPxBHB+/wZ2tW35bTIbiWBLNc
OPBx121JncjpQYkU1YNoHIaI56svjYxgbJikj7H233Q/Zvow14P5bix0YF6E
ObojcKYOU9WYqCAbjZ+ltSqjURaJonDkhpKtZmkhSA5BfAhighEZTEcbAv9Q
+IXDNwo+MVwfnvFMhmc6PLPhnQ/fEpCknVrl+EPbESFGdB/nlCN0vkXpgX3q
DW5PZvUeAUMnBsaZsC6CO6WX6DaS9JktRjE7sQNoHOIiTf/eP4iBAQz1Y0SK
sV6M9xCHzHgHxuiOgdEmsvF0qAaDVZBWkN2/4mJ0FqA9F63ZaMokZapTUZ6M
4kQUxCM3DllxyIhDahyS4hAfh5g4Ol1xCEngZVZAJvyz4ZcLPy7zjSYp8eMN
bkNoJ7VLle982KyUivRtZqoWAJ+rmYh7OSRfkFtRz3ADJTyon+QTN/ajpZ9f
uW9J+0iqcL8Y/V3op5vlpK3obYKkAT11ENegqxodlWgrI7tyGwvJPl3C4bNR
konCDOSlIycNmWlIT0NKGhLTEJ+GmDT+ydvDaGJ7ME3pDViXc8rnm9IktVAx
ImjKkT+Xb/QmnrzfbuO3/HFeV70kmOTCpnQtl/fZxHaSPU2yeCUo70VVL+p6
0dhLNtdwdvIrXZ1kU2BHG9lhKWpCawNa6tBci8ZqNFShthxVVLEoLSa7NgsK
kVtAthZm5PH1n42iow8vIon6oWUILkdgBcm7C6xbl0PLjim4CyEUcS6hjOaZ
bFHmbHHvmFXxdnF+c6tikuNJDrn1Hd+O1E7yAoh8llB7UN6Dqh7U9JBNQw09
eJXyjuRSJJQgrgQxpYguJ7s0ImhOVmgVgmvo2uGogkt3C+jkzv+VpyVup+eH
eOIx5tA1yIBJHiyLSSYv934Okp7OssIOZHUitxMFXSimO5lKu1DWSfaZlYlQ
2oaSFpCtgJvIpsCXCxtR0ID8elIupw5ZdcioJdvZUmuQVE32VsXVILYW0bWI
qkNEHcLqlTGFgFb4i+DbDi/R2luztihzM9Q+VkHwSb/1UmGciwdFsC3jMN0R
R/OZU0RIFSFdhAwRMkXIYj9tRBXOZO9uymAZ2PPpzWRPXSrd1ZXYQDZ6xdYj
ph7R9WS3C9nq0sDxiK2+TSQPnT3yaoN7K4fnz/j+ce+u/INK/9beerbVKAdm
RbAug30l3Gr5+PC26BbEtCC6mXyimhDZxHHQrZ6NcG+EWxNcm+HUzGHzGv8k
7o1zn2zwpB/4rygG1yhnMiuGZRlsKmBbCYcqOFaTHSHONXCp4eXQ9vX7Slwa
4NQAB7rBYQs/A6Rh6qt96o2Xqn4zwpPpDqDNd4thUgrTMk5NfZ3vPfeO4z/y
dKdaexdfint77Z9V7qr6lNX5nnFv4/1sg9W1/vy/+La5NxN/vgF/WX/+H3xp
ym3V9mzAc9ef/5Yv/REt/QXWWTHrSv2K7y/FUO1Llbuq8UMlP6QoqH21Ac6q
7xYgpb+gpf+iclfV+/4q3xNaTu1rVdrZYI5J29/Q0n/Fxm8JfZ4vtY+WEmAj
z4Eyf/wQLaMJVVvnGb6NI/T+3nVP0OJT9cnd7+hd8hzyAPrOaDW1f/l/p/2l
wA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->92445893]
}, Open  ]],

Cell["This produces a sphere. ", "MathCaption",
 CellID->21113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[46]:=",
 CellID->14887],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]=",
 CellID->15806817]
}, Open  ]],

Cell[TextData[{
 "You should realize that when you draw surfaces with ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 ", the exact choice of parametrization is often crucial. You should be \
careful, for example, to avoid parametrizations in which all or part of your \
surface is covered more than once. Such multiple coverings often lead to \
discontinuities in the mesh drawn on the surface, and may make ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " take much longer to render the surface. "
}], "Text",
 CellID->22850],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->657075917],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->151800574]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->95923701],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->507104541],

Cell[TextData[ButtonBox["M205: Visualization and Dynamic Interactivity",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://www.wolfram.com/services/education/minicourses/m205.html"], 
   None}]], "TutorialRelatedLinks",
 CellID->879822171]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Parametric Plots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Graphics and Sound", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/GraphicsAndSoundOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PlottingListsOfData"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SomeSpecialPlots"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 46.5430954}", "context" -> "", 
    "keywords" -> {
     "Argand diagrams", "aspect ratio", "covering", "curves", "cylinder", 
      "developable surfaces", "double covering", "helix", "Lissajous figures",
       "ParametricPlot", "ParametricPlot3D", "parametric surfaces", 
      "parametric plot", "shape", "space curves", "sphere", "surfaces", 
      "torus"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "\"Basic Plotting\" described how to plot curves in Mathematica in which \
you give the y coordinate of each point as a function of the x coordinate. \
You can also use Mathematica to make parametric plots. In a parametric plot, \
you give both the x and y coordinates of each point as a function of a third \
parameter, say t. Functions for generating parametric plots. Here is the \
curve made by taking the x coordinate of each point to be Sin[t] and the y \
coordinate to be Sin[2t]. ", "synonyms" -> {}, "title" -> "Parametric Plots", 
    "type" -> "Tutorial", "uri" -> "tutorial/ParametricPlots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.9"->{
  Cell[1959, 61, 78, 2, 70, "Title",
   CellTags->{"S1.9.9", "9.1"},
   CellID->1264]},
 "9.1"->{
  Cell[1959, 61, 78, 2, 70, "Title",
   CellTags->{"S1.9.9", "9.1"},
   CellID->1264]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.9", 173158, 3317},
 {"9.1", 173256, 3321}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1334, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1959, 61, 78, 2, 70, "Title",
 CellTags->{"S1.9.9", "9.1"},
 CellID->1264],
Cell[2040, 65, 922, 31, 70, "Text",
 CellID->8260],
Cell[2965, 98, 1919, 58, 70, "DefinitionBox",
 CellID->6202],
Cell[4887, 158, 77, 1, 70, "Caption",
 CellID->8116],
Cell[4967, 161, 598, 22, 70, "MathCaption",
 CellID->5030],
Cell[CellGroupData[{
Cell[5590, 187, 348, 12, 28, "Input",
 CellID->20326],
Cell[5941, 201, 4775, 82, 197, "Output",
 Evaluatable->False,
 CellID->18552354]
}, Open  ]],
Cell[10731, 286, 2984, 95, 70, "DefinitionBox",
 CellID->14924],
Cell[13718, 383, 87, 3, 70, "Caption",
 CellID->30188],
Cell[13808, 388, 2496, 88, 70, "Text",
 CellID->21763],
Cell[16307, 478, 440, 14, 70, "MathCaption",
 CellID->4940],
Cell[CellGroupData[{
Cell[16772, 496, 343, 11, 28, "Input",
 CellID->20851],
Cell[17118, 509, 3386, 60, 237, "Output",
 Evaluatable->False,
 CellID->434180956]
}, Open  ]],
Cell[20519, 572, 1852, 68, 70, "Text",
 CellID->13829],
Cell[22374, 642, 542, 18, 70, "MathCaption",
 CellID->30900],
Cell[CellGroupData[{
Cell[22941, 664, 482, 16, 28, "Input",
 CellID->17713],
Cell[23426, 682, 20563, 341, 227, "Output",
 Evaluatable->False,
 CellID->603658190]
}, Open  ]],
Cell[44004, 1026, 229, 6, 70, "MathCaption",
 CellID->17578],
Cell[CellGroupData[{
Cell[44258, 1036, 508, 17, 28, "Input",
 CellID->8365],
Cell[44769, 1055, 30948, 511, 227, "Output",
 Evaluatable->False,
 CellID->37404338]
}, Open  ]],
Cell[75732, 1569, 181, 4, 70, "MathCaption",
 CellID->11477],
Cell[CellGroupData[{
Cell[75938, 1577, 486, 16, 28, "Input",
 CellID->1200],
Cell[76427, 1595, 20513, 340, 237, "Output",
 Evaluatable->False,
 CellID->87122451]
}, Open  ]],
Cell[96955, 1938, 625, 16, 70, "Text",
 CellID->6439],
Cell[97583, 1956, 480, 16, 70, "MathCaption",
 CellID->2303],
Cell[CellGroupData[{
Cell[98088, 1976, 407, 13, 28, "Input",
 CellID->12760],
Cell[98498, 1991, 17793, 296, 227, "Output",
 Evaluatable->False,
 CellID->85708954]
}, Open  ]],
Cell[116306, 2290, 327, 10, 70, "MathCaption",
 CellID->2324],
Cell[CellGroupData[{
Cell[116658, 2304, 697, 23, 47, "Input",
 CellID->6477],
Cell[117358, 2329, 19188, 319, 150, "Output",
 Evaluatable->False,
 CellID->92445893]
}, Open  ]],
Cell[136561, 2651, 63, 1, 70, "MathCaption",
 CellID->21113],
Cell[CellGroupData[{
Cell[136649, 2656, 638, 21, 47, "Input",
 CellID->14887],
Cell[137290, 2679, 31294, 517, 227, "Output",
 Evaluatable->False,
 CellID->15806817]
}, Open  ]],
Cell[168599, 3199, 709, 16, 70, "Text",
 CellID->22850],
Cell[CellGroupData[{
Cell[169333, 3219, 72, 1, 70, "RelatedTutorialsSection",
 CellID->657075917],
Cell[169408, 3222, 166, 4, 70, "RelatedTutorials",
 CellID->151800574]
}, Open  ]],
Cell[CellGroupData[{
Cell[169611, 3231, 97, 1, 70, "TutorialRelatedLinksSection",
 CellID->95923701],
Cell[169711, 3234, 414, 13, 70, "TutorialRelatedLinks",
 CellID->507104541],
Cell[170128, 3249, 244, 5, 70, "TutorialRelatedLinks",
 CellID->879822171]
}, Open  ]]
}, Open  ]],
Cell[170399, 3258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

