(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45379,       1665]
NotebookOptionsPosition[     36556,       1362]
NotebookOutlinePosition[     39370,       1434]
CellTagsIndexPosition[     39277,       1428]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Manipulating Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadLeft" :> Documentation`HelpLookup["paclet:ref/PadLeft"], 
          "PadRight" :> Documentation`HelpLookup["paclet:ref/PadRight"], 
          "Partition" :> Documentation`HelpLookup["paclet:ref/Partition"], 
          "Split" :> Documentation`HelpLookup["paclet:ref/Split"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PadLeft\"\>", 2->"\<\"PadRight\"\>",
        3->"\<\"Partition\"\>", 4->"\<\"Split\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Partitioning and Padding Lists", "Title",
 CellTags->{"S2.4.4", "4.1"},
 CellID->14460],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "partition ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into sublists of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "partition into sublists with offset ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Split",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Split"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "split ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into runs of identical elements"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Split",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Split"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["test", "TI"], "]"}], Cell[TextData[{
     "split into runs with adjacent elements satisfying ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22428],

Cell["Partitioning elements in a list. ", "Caption",
 CellID->12993],

Cell["This partitions in blocks of 3. ", "MathCaption",
 CellID->27384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->6540]
}, Open  ]],

Cell["This partitions in blocks of 3 with offset 1. ", "MathCaption",
 CellID->31111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "3", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->28704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->12835]
}, Open  ]],

Cell["The offset can be larger than the block size. ", "MathCaption",
 CellID->32356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6072],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->29350]
}, Open  ]],

Cell["This splits into runs of identical elements. ", "MathCaption",
 CellID->18823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "4", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "3", 
    ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->14485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{241, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->20556]
}, Open  ]],

Cell["This splits into runs where adjacent elements are unequal. ", \
"MathCaption",
 CellID->23216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "4", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "3",
      ",", "3"}], "}"}], ",", "Unequal"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->1626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 ImageSize->{241, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->9357]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " in effect goes through a list, grouping successive elements into sublists. \
By default it does not include any sublists that would \"overhang\" the \
original list. "
}], "Text",
 CellID->8526],

Cell["This stops before any overhang occurs. ", "MathCaption",
 CellID->13357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->29337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->23271]
}, Open  ]],

Cell["The same is true here. ", "MathCaption",
 CellID->23869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "3", 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->12896]
}, Open  ]],

Cell[TextData[{
 "You can tell ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " to include sublists that overhang the ends of the original list. By \
default, it fills in additional elements by treating the original list as \
cyclic. It can also treat it as being padded with elements that you specify. \
"
}], "Text",
 CellID->13022],

Cell["\<\
This includes additional sublists, treating the original list as cyclic. \
\>", "MathCaption",
 CellID->29617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "3", 
   ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->10112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "a", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->12717]
}, Open  ]],

Cell[TextData[{
 "Now the original list is treated as being padded with the element ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "3", 
   ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->11585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->24041]
}, Open  ]],

Cell[TextData[{
 "This pads cyclically with elements ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "3", 
   ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->24129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "y", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->24229]
}, Open  ]],

Cell["\<\
This introduces no padding, yielding sublists of differing lengths. \
\>", "MathCaption",
 CellID->4565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "3", 
   ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->6559],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", "e", "}"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->8932]
}, Open  ]],

Cell[TextData[{
 "You can think of ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " as extracting sublists by sliding a template along and picking out \
elements from the original list. You can tell ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " where to start and stop this process. "
}], "Text",
 CellID->22296],

Cell["This gives all sublists that overlap the original list. ", "MathCaption",
 CellID->29855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3", ",", "1", 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->12053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->16962]
}, Open  ]],

Cell["This allows overlaps only at the beginning. ", "MathCaption",
 CellID->3584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3", ",", "1", 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->29734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->6654]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", "{", "1", ",", "-", "1", "}", "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["keep only sublists with no overhangs", "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", "{", "1", ",", "1", "}", "]"}], Cell[
    "allow an overhang at the end", "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", "{", "-", "1", ",", "-", "1", "}", "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["allow an overhang at the beginning", "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", "{", "-", "1", ",", "1", "}", "]"}], Cell[
    "allow overhangs at both the beginning and end", "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["k", "TI"], 
      StyleBox["L", "TI"]], ",", 
     SubscriptBox[
      StyleBox["k", "TI"], 
      StyleBox["R", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["specify alignments of first and last sublists", "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", 
     StyleBox["spec", "TI"], "]"}], Cell[TextData[{
     "pad by cyclically repeating elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", 
     StyleBox["spec", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "pad by repeating the element ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", 
     StyleBox["spec", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "pad by cyclically repeating the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], ",", 
     StyleBox["spec", "TI"], ",", "{", "}", "]"}], Cell[
    "use no padding", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, True, False, 
     False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->16972],

Cell["Specifying alignment and padding. ", "Caption",
 CellID->21457],

Cell[TextData[{
 "An alignment specification ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["L", "TI"]], ",", 
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["R", "TI"]]}], "}"}]], "InlineFormula"],
 " tells ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " to give the sequence of sublists in which the first element of the \
original list appears at position ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["k", "L"], TraditionalForm]], "InlineMath"],
 " in the first sublist, and the last element of the original list appears at \
position ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["k", "R"], TraditionalForm]], "InlineMath"],
 " in the last sublist. "
}], "Text",
 CellID->14369],

Cell[TextData[{
 "This makes ",
 Cell[BoxData["a"], "InlineFormula"],
 " appear at position 1 in the first sublist. "
}], "MathCaption",
 CellID->22532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3", ",", "1", 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->2963],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->2607]
}, Open  ]],

Cell[TextData[{
 "This makes ",
 Cell[BoxData["a"], "InlineFormula"],
 " appear at position 2 in the first sublist. "
}], "MathCaption",
 CellID->2483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3", ",", "1", 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->911],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->11635]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData["a"], "InlineFormula"],
 " is in effect made to appear first at position 4. "
}], "MathCaption",
 CellID->10067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3", ",", "1", 
   ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->22848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->4675]
}, Open  ]],

Cell["This fills in padding cyclically from the list given. ", "MathCaption",
 CellID->12938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3", ",", "1", 
   ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->2223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", ",", "x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "x", ",", "y"}], "}"}]}], "}"}]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->22142]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " use the same alignment and padding specifications as ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->23754],

Cell[TextData[{
 "In some cases it may be convenient to insert explicit padding into a list. \
You can do this using ",
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6511],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PadLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadLeft"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "pad to length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " by inserting zeros on the left"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadLeft"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "pad by repeating the element ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadLeft"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "pad by cyclically repeating the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadLeft"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "pad by cyclically repeating ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadLeft"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["padding", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "leave a margin of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " elements on the right"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadRight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadRight"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[
    "pad by inserting zeros on the right", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {True}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22741],

Cell["Padding a list. ", "Caption",
 CellID->20175],

Cell["This pads the list to make it length 6. ", "MathCaption",
 CellID->21459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "6"}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->17825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "a", ",", "b", ",", "c"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->3221]
}, Open  ]],

Cell[TextData[{
 "This cyclically inserts ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]], "InlineFormula"],
 " as the padding. "
}], "MathCaption",
 CellID->17870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "6", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->31934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "x", ",", "a", ",", "b", ",", "c"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->15205]
}, Open  ]],

Cell["This also leaves a margin of 3 on the right. ", "MathCaption",
 CellID->31783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->23850],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "y", ",", "x", ",", "y", ",", "x", ",", "a", ",", "b", ",", "c", ",", "x", 
   ",", "y", ",", "x"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->17398]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " can all be used on nested lists. "
}], "Text",
 CellID->22279],

Cell["This creates a 3x3 array. ", "MathCaption",
 CellID->22701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "e", "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->12193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->12734]
}, Open  ]],

Cell["This partitions the array into 2x2 blocks with offset 1. ", \
"MathCaption",
 CellID->1637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->26534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "a"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "e"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{494, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->5556]
}, Open  ]],

Cell["\<\
If you give a nested list as a padding specification, its elements are picked \
up cyclically at each level. \
\>", "Text",
 CellID->1993],

Cell["This cyclically fills in copies of the padding list. ", "MathCaption",
 CellID->10176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "e", "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "w"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->25705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "w", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "x", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "w", ",", "z", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->6962]
}, Open  ]],

Cell["Here is a list containing only padding. ", "MathCaption",
 CellID->10548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "w"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->15881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "w", ",", "z", ",", "w"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "w", ",", "z", ",", "w"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->300]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->21534481],

Cell[TextData[ButtonBox["Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsOverview"]], "RelatedTutorials",\

 CellID->30468725]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Partitioning and Padding Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Lists", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/ManipulatingListsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NestedLists"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SparseArrays-ManipulatingLists"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 48.8400292}", "context" -> "", 
    "keywords" -> {
     "Beck parameters", "blocking lists", "circular partitioning", 
      "cyclic partitioning", "encoding", "gathering elements in lists", 
      "handles", "hot spots", "knobs", "lists", "overhangs", "padding", 
      "PadLeft", "PadRight", "partition", "reshape in APL", 
      "Runlength encoding", "run length encoding", "split", "Sublists", 
      "Unflatten", "wraparound partitioning"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Partitioning elements in a list. This partitions in blocks of 3. This \
partitions in blocks of 3 with offset 1. ", "synonyms" -> {"2.4.4"}, "title" -> 
    "Partitioning and Padding Lists", "type" -> "Tutorial", "uri" -> 
    "tutorial/PartitioningAndPaddingLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.4.4"->{
  Cell[2081, 61, 93, 2, 70, "Title",
   CellTags->{"S2.4.4", "4.1"},
   CellID->14460]},
 "4.1"->{
  Cell[2081, 61, 93, 2, 70, "Title",
   CellTags->{"S2.4.4", "4.1"},
   CellID->14460]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.4.4", 39066, 1417},
 {"4.1", 39165, 1421}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1456, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2081, 61, 93, 2, 70, "Title",
 CellTags->{"S2.4.4", "4.1"},
 CellID->14460],
Cell[2177, 65, 1800, 57, 70, "DefinitionBox",
 CellID->22428],
Cell[3980, 124, 68, 1, 70, "Caption",
 CellID->12993],
Cell[4051, 127, 71, 1, 70, "MathCaption",
 CellID->27384],
Cell[CellGroupData[{
Cell[4147, 132, 218, 7, 28, "Input",
 CellID->19405],
Cell[4368, 141, 318, 11, 36, "Output",
 CellID->6540]
}, Open  ]],
Cell[4701, 155, 85, 1, 70, "MathCaption",
 CellID->31111],
Cell[CellGroupData[{
Cell[4811, 160, 228, 7, 28, "Input",
 CellID->28704],
Cell[5042, 169, 457, 15, 36, "Output",
 CellID->12835]
}, Open  ]],
Cell[5514, 187, 85, 1, 70, "MathCaption",
 CellID->32356],
Cell[CellGroupData[{
Cell[5624, 192, 227, 7, 28, "Input",
 CellID->6072],
Cell[5854, 201, 299, 11, 36, "Output",
 CellID->29350]
}, Open  ]],
Cell[6168, 215, 84, 1, 70, "MathCaption",
 CellID->18823],
Cell[CellGroupData[{
Cell[6277, 220, 224, 7, 70, "Input",
 CellID->14485],
Cell[6504, 229, 436, 15, 36, "Output",
 CellID->20556]
}, Open  ]],
Cell[6955, 247, 100, 2, 70, "MathCaption",
 CellID->23216],
Cell[CellGroupData[{
Cell[7080, 253, 256, 8, 70, "Input",
 CellID->1626],
Cell[7339, 263, 435, 15, 36, "Output",
 CellID->9357]
}, Open  ]],
Cell[7789, 281, 334, 9, 70, "Text",
 CellID->8526],
Cell[8126, 292, 78, 1, 70, "MathCaption",
 CellID->13357],
Cell[CellGroupData[{
Cell[8229, 297, 207, 7, 70, "Input",
 CellID->29337],
Cell[8439, 306, 299, 11, 36, "Output",
 CellID->23271]
}, Open  ]],
Cell[8753, 320, 62, 1, 70, "MathCaption",
 CellID->23869],
Cell[CellGroupData[{
Cell[8840, 325, 218, 7, 70, "Input",
 CellID->29361],
Cell[9061, 334, 388, 13, 36, "Output",
 CellID->12896]
}, Open  ]],
Cell[9464, 350, 412, 11, 70, "Text",
 CellID->13022],
Cell[9879, 363, 120, 3, 70, "MathCaption",
 CellID->29617],
Cell[CellGroupData[{
Cell[10024, 370, 277, 9, 70, "Input",
 CellID->10112],
Cell[10304, 381, 526, 17, 36, "Output",
 CellID->12717]
}, Open  ]],
Cell[10845, 401, 165, 5, 70, "MathCaption",
 CellID->18696],
Cell[CellGroupData[{
Cell[11035, 410, 287, 9, 70, "Input",
 CellID->11585],
Cell[11325, 421, 526, 17, 36, "Output",
 CellID->24041]
}, Open  ]],
Cell[11866, 441, 182, 7, 70, "MathCaption",
 CellID->24423],
Cell[CellGroupData[{
Cell[12073, 452, 337, 11, 70, "Input",
 CellID->24129],
Cell[12413, 465, 527, 17, 36, "Output",
 CellID->24229]
}, Open  ]],
Cell[12955, 485, 114, 3, 70, "MathCaption",
 CellID->4565],
Cell[CellGroupData[{
Cell[13094, 492, 306, 10, 70, "Input",
 CellID->6559],
Cell[13403, 504, 481, 16, 36, "Output",
 CellID->8932]
}, Open  ]],
Cell[13899, 523, 471, 14, 70, "Text",
 CellID->22296],
Cell[14373, 539, 95, 1, 70, "MathCaption",
 CellID->29855],
Cell[CellGroupData[{
Cell[14493, 544, 299, 10, 70, "Input",
 CellID->12053],
Cell[14795, 556, 596, 19, 36, "Output",
 CellID->16962]
}, Open  ]],
Cell[15406, 578, 82, 1, 70, "MathCaption",
 CellID->3584],
Cell[CellGroupData[{
Cell[15513, 583, 320, 11, 70, "Input",
 CellID->29734],
Cell[15836, 596, 457, 15, 36, "Output",
 CellID->6654]
}, Open  ]],
Cell[16308, 614, 4475, 133, 70, "DefinitionBox",
 CellID->16972],
Cell[20786, 749, 69, 1, 70, "Caption",
 CellID->21457],
Cell[20858, 752, 830, 28, 70, "Text",
 CellID->14369],
Cell[21691, 782, 152, 5, 70, "MathCaption",
 CellID->22532],
Cell[CellGroupData[{
Cell[21868, 791, 277, 9, 70, "Input",
 CellID->2963],
Cell[22148, 802, 457, 15, 36, "Output",
 CellID->2607]
}, Open  ]],
Cell[22620, 820, 151, 5, 70, "MathCaption",
 CellID->2483],
Cell[CellGroupData[{
Cell[22796, 829, 276, 9, 70, "Input",
 CellID->911],
Cell[23075, 840, 527, 17, 36, "Output",
 CellID->11635]
}, Open  ]],
Cell[23617, 860, 152, 5, 70, "MathCaption",
 CellID->10067],
Cell[CellGroupData[{
Cell[23794, 869, 278, 9, 70, "Input",
 CellID->22848],
Cell[24075, 880, 664, 21, 36, "Output",
 CellID->4675]
}, Open  ]],
Cell[24754, 904, 93, 1, 70, "MathCaption",
 CellID->12938],
Cell[CellGroupData[{
Cell[24872, 909, 326, 11, 70, "Input",
 CellID->2223],
Cell[25201, 922, 665, 21, 36, "Output",
 CellID->22142]
}, Open  ]],
Cell[25881, 946, 376, 13, 70, "Text",
 CellID->23754],
Cell[26260, 961, 398, 14, 70, "Text",
 CellID->6511],
Cell[26661, 977, 2661, 86, 70, "DefinitionBox",
 CellID->22741],
Cell[29325, 1065, 51, 1, 70, "Caption",
 CellID->20175],
Cell[29379, 1068, 79, 1, 70, "MathCaption",
 CellID->21459],
Cell[CellGroupData[{
Cell[29483, 1073, 183, 6, 70, "Input",
 CellID->17825],
Cell[29669, 1081, 244, 8, 36, "Output",
 CellID->3221]
}, Open  ]],
Cell[29928, 1092, 185, 7, 70, "MathCaption",
 CellID->17870],
Cell[CellGroupData[{
Cell[30138, 1103, 242, 8, 70, "Input",
 CellID->31934],
Cell[30383, 1113, 245, 8, 36, "Output",
 CellID->15205]
}, Open  ]],
Cell[30643, 1124, 84, 1, 70, "MathCaption",
 CellID->31783],
Cell[CellGroupData[{
Cell[30752, 1129, 253, 8, 70, "Input",
 CellID->23850],
Cell[31008, 1139, 289, 9, 36, "Output",
 CellID->17398]
}, Open  ]],
Cell[31312, 1151, 455, 17, 70, "Text",
 CellID->22279],
Cell[31770, 1170, 65, 1, 70, "MathCaption",
 CellID->22701],
Cell[CellGroupData[{
Cell[31860, 1175, 347, 12, 70, "Input",
 CellID->12193],
Cell[32210, 1189, 389, 13, 36, "Output",
 CellID->12734]
}, Open  ]],
Cell[32614, 1205, 97, 2, 70, "MathCaption",
 CellID->1637],
Cell[CellGroupData[{
Cell[32736, 1211, 234, 8, 70, "Input",
 CellID->26534],
Cell[32973, 1221, 967, 35, 36, "Output",
 CellID->5556]
}, Open  ]],
Cell[33955, 1259, 148, 4, 70, "Text",
 CellID->1993],
Cell[34106, 1265, 92, 1, 70, "MathCaption",
 CellID->10176],
Cell[CellGroupData[{
Cell[34223, 1270, 502, 18, 70, "Input",
 CellID->25705],
Cell[34728, 1290, 497, 15, 36, "Output",
 CellID->6962]
}, Open  ]],
Cell[35240, 1308, 79, 1, 70, "MathCaption",
 CellID->10548],
Cell[CellGroupData[{
Cell[35344, 1313, 382, 14, 70, "Input",
 CellID->15881],
Cell[35729, 1329, 496, 15, 36, "Output",
 CellID->300]
}, Open  ]],
Cell[CellGroupData[{
Cell[36262, 1349, 71, 1, 70, "RelatedTutorialsSection",
 CellID->21534481],
Cell[36336, 1352, 166, 4, 70, "RelatedTutorials",
 CellID->30468725]
}, Open  ]]
}, Open  ]],
Cell[36529, 1360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

