(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    115155,       3052]
NotebookOptionsPosition[    106921,       2775]
NotebookOutlinePosition[    108703,       2818]
CellTagsIndexPosition[    108660,       2815]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BrayCurtisDistance" :> 
         Documentation`HelpLookup["paclet:ref/BrayCurtisDistance"], 
         "CanberraDistance" :> 
         Documentation`HelpLookup["paclet:ref/CanberraDistance"], 
         "ChebyshevDistance" :> 
         Documentation`HelpLookup["paclet:ref/ChebyshevDistance"], 
         "CorrelationDistance" :> 
         Documentation`HelpLookup["paclet:ref/CorrelationDistance"], 
         "CosineDistance" :> 
         Documentation`HelpLookup["paclet:ref/CosineDistance"], 
         "DiceDissimilarity" :> 
         Documentation`HelpLookup["paclet:ref/DiceDissimilarity"], 
         "EditDistance" :> 
         Documentation`HelpLookup["paclet:ref/EditDistance"], 
         "EuclideanDistance" :> 
         Documentation`HelpLookup["paclet:ref/EuclideanDistance"], 
         "FindClusters" :> 
         Documentation`HelpLookup["paclet:ref/FindClusters"], 
         "HammingDistance" :> 
         Documentation`HelpLookup["paclet:ref/HammingDistance"], 
         "JaccardDissimilarity" :> 
         Documentation`HelpLookup["paclet:ref/JaccardDissimilarity"], 
         "Length" :> Documentation`HelpLookup["paclet:ref/Length"], 
         "ManhattanDistance" :> 
         Documentation`HelpLookup["paclet:ref/ManhattanDistance"], 
         "MatchingDissimilarity" :> 
         Documentation`HelpLookup["paclet:ref/MatchingDissimilarity"], "Mean" :> 
         Documentation`HelpLookup["paclet:ref/Mean"], 
         "RogersTanimotoDissimilarity" :> 
         Documentation`HelpLookup["paclet:ref/RogersTanimotoDissimilarity"], 
         "RussellRaoDissimilarity" :> 
         Documentation`HelpLookup["paclet:ref/RussellRaoDissimilarity"], 
         "SokalSneathDissimilarity" :> 
         Documentation`HelpLookup["paclet:ref/SokalSneathDissimilarity"], 
         "SquaredEuclideanDistance" :> 
         Documentation`HelpLookup["paclet:ref/SquaredEuclideanDistance"], 
         "YuleDissimilarity" :> 
         Documentation`HelpLookup["paclet:ref/YuleDissimilarity"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"BrayCurtisDistance\"\>", 
      2->"\<\"CanberraDistance\"\>", 3->"\<\"ChebyshevDistance\"\>", 
      4->"\<\"CorrelationDistance\"\>", 5->"\<\"CosineDistance\"\>", 
      6->"\<\"DiceDissimilarity\"\>", 7->"\<\"EditDistance\"\>", 
      8->"\<\"EuclideanDistance\"\>", 9->"\<\"FindClusters\"\>", 
      10->"\<\"HammingDistance\"\>", 11->"\<\"JaccardDissimilarity\"\>", 
      12->"\<\"Length\"\>", 13->"\<\"ManhattanDistance\"\>", 
      14->"\<\"MatchingDissimilarity\"\>", 15->"\<\"Mean\"\>", 
      16->"\<\"RogersTanimotoDissimilarity\"\>", 
      17->"\<\"RussellRaoDissimilarity\"\>", 
      18->"\<\"SokalSneathDissimilarity\"\>", 
      19->"\<\"SquaredEuclideanDistance\"\>", 
      20->"\<\"YuleDissimilarity\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Partitioning Data into Clusters", "Title",
 CellID->2948],

Cell["\<\
Cluster analysis is an unsupervised learning technique used for \
classification of data. Data elements are partitioned into groups called \
clusters that represent proximate collections of data elements based on a \
distance or dissimilarity function. Identical element pairs have zero \
distance or dissimilarity, and all others have positive distance or \
dissimilarity.\
\>", "Text",
 CellID->6916],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindClusters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindClusters"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "partition ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " into lists of similar elements"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindClusters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindClusters"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "partition ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " into exactly ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " lists of similar elements"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->7047],

Cell[TextData[StyleBox["General clustering function.",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}]], "Caption",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24103],

Cell[TextData[{
 "The data argument of ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " can be a list of data elements or rules indexing elements and labels."
}], "Text",
 CellID->5694],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "data specified as a list of data elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], "\[Rule]", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], "\[Rule]", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "data specified as a list of rules between data elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " and labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[TextData[{
     "data specified as a rule mapping data elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->18627],

Cell[TextData[{
 "Ways of specifying data in ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->20674],

Cell[TextData[{
 "The data elements ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be numeric lists, matrices, tensors, lists of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " elements, or lists of strings. All data elements ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must have the same dimensions."
}], "Text",
 CellID->2634],

Cell["Here is a list of numbers.", "MathCaption",
 CellID->5105],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"data", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
     "1.2", ",", " ", "9.1", ",", " ", "2.3", ",", " ", "15.4", ",", " ", 
      "71.8"}], "}"}]}], ";"}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->27731],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " clusters the numbers based on their proximity."
}], "MathCaption",
 CellID->3587],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"FindClusters", "[", "data", "]"}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[3]:=",
 CellID->24863],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.2`", ",", "2.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.1`", ",", "15.4`"}], "}"}], ",", 
   RowBox[{"{", "71.8`", "}"}]}], "}"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->183508394]
}, Open  ]],

Cell["\<\
The rule-based data syntax allows for clustering data elements and returning \
labels for those elements.\
\>", "Text",
 CellID->12005],

Cell["\<\
Here two-dimensional points are clustered and labeled with their positions in \
the data list.\
\>", "MathCaption",
 CellID->17774],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", "7"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", "1"}], "}"}]}], "}"}]}], " ", ";"}], "\n", 
 StyleBox[
  RowBox[{"FindClusters", "[", 
   RowBox[{"data1", "->", " ", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", "data1", "]"}], "]"}]}], "]"}],
  FormatType->StandardForm]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->13354556]
}, Open  ]],

Cell["\<\
The rule-based data syntax can also be used to cluster data based on parts of \
each data entry. For instance, you might want to cluster data in a data table \
while ignoring particular columns in the table. \
\>", "Text",
 CellID->4251],

Cell["Here is a list of data entries.", "MathCaption",
 CellID->29398],

Cell[BoxData[
 RowBox[{
  RowBox[{"datarecords", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\"\<Joe\>\"", ",", " ", "\"\<Smith\>\"", ",", "158", ",", "64.4"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Mary\>\"", ",", " ", "\"\<Davis\>\"", ",", "137", ",", "64.4"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Bob\>\"", ",", " ", "\"\<Lewis\>\"", ",", "141", ",", "62.8"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<John\>\"", ",", " ", "\"\<Thompson\>\"", ",", "235", ",", "71.1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Lewis\>\"", ",", " ", "\"\<Black\>\"", ",", "225", ",", "71.4"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Sally\>\"", ",", " ", "\"\<Jones\>\"", ",", "168", ",", "62."}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Tom\>\"", ",", " ", "\"\<Smith\>\"", ",", "243", ",", "70.9"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Jane\>\"", ",", " ", "\"\<Doe\>\"", ",", "225", ",", "71.4"}], 
      "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->13347],

Cell["\<\
This clusters the data while ignoring the first two elements in each data \
entry.\
\>", "MathCaption",
 CellID->29745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"Drop", "[", 
    RowBox[{"datarecords", ",", "None", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[Rule]", "datarecords"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->13399],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"Joe\"\>", ",", "\<\"Smith\"\>", ",", "158", ",", "64.4`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Sally\"\>", ",", "\<\"Jones\"\>", ",", "168", ",", 
       "62.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"Mary\"\>", ",", "\<\"Davis\"\>", ",", "137", ",", 
       "64.4`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Bob\"\>", ",", "\<\"Lewis\"\>", ",", "141", ",", "62.8`"}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"John\"\>", ",", "\<\"Thompson\"\>", ",", "235", ",", 
       "71.1`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Lewis\"\>", ",", "\<\"Black\"\>", ",", "225", ",", 
       "71.4`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Tom\"\>", ",", "\<\"Smith\"\>", ",", "243", ",", "70.9`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Jane\"\>", ",", "\<\"Doe\"\>", ",", "225", ",", "71.4`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{555, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->9193610]
}, Open  ]],

Cell["\<\
In principle, it is possible to cluster points given in an arbitrary number \
of dimensions. However, it is difficult at best to visualize the clusters \
above two or three dimensions. To compare optional methods in this \
documentation, an easily visualizable set of two-dimensional data will be \
used.\
\>", "Text",
 CellID->7785],

Cell["\<\
The following commands define a set of 300 two-dimensional data points chosen \
to group into four somewhat nebulous clusters.\
\>", "MathCaption",
 CellID->2750],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GaussianRandomData", "[", 
    RowBox[{"n_Integer", ",", "p_", ",", "sigma_"}], "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"p", "+", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}]}], "&"}], "[", 
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "sigma"}], "]"}], "]"}], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}], "]"}]}]]}], "]"}], ",", 
     RowBox[{"{", "n", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"datapairs", "=", 
   RowBox[{"BlockRandom", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1234", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"GaussianRandomData", "[", 
        RowBox[{"100", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], ",", ".3"}], "]"}], ",", 
       RowBox[{"GaussianRandomData", "[", 
        RowBox[{"100", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1.5"}], "}"}], ",", ".2"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"GaussianRandomData", "[", 
        RowBox[{"100", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1.1"}], "}"}], ",", ".4"}], "]"}], ",", 
       RowBox[{"GaussianRandomData", "[", 
        RowBox[{"100", ",", 
         RowBox[{"{", 
          RowBox[{"1.75", ",", "1.75"}], "}"}], ",", "0.1"}], "]"}]}], 
      "]"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->9395],

Cell["This clusters the data based on the proximity of points.", "MathCaption",
 CellID->20616],

Cell[BoxData[
 RowBox[{
  RowBox[{"cl", "=", 
   RowBox[{"FindClusters", "[", "datapairs", "]"}]}], ";"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->31811],

Cell["Here is a plot of the clusters.", "MathCaption",
 CellID->7166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "cl", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->4348],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->49281050]
}, Open  ]],

Cell[TextData[{
 "With the default settings, ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " has found the four clusters of points. "
}], "Text",
 CellID->13388],

Cell[TextData[{
 "You can also direct ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " to find a specific number of clusters."
}], "Text",
 CellID->10808],

Cell["This shows the effect of choosing 3 clusters.", "MathCaption",
 CellID->2959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"FindClusters", "[", 
   RowBox[{"datapairs", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->1638],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->199305626]
}, Open  ]],

Cell["This shows the effect of choosing 5 clusters.", "MathCaption",
 CellID->15053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"FindClusters", "[", 
   RowBox[{"datapairs", ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->5203],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->11098344]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["DistanceFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DistanceFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the distance or dissimilarity measure to use", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the clustering method to use", "TableText"]},
   {"RandomSeed", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "starting value for the random number generator", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->26498],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->27277],

Cell[TextData[{
 "Randomness is used in clustering in two different ways. Some of the methods \
use a random assignment of some points to a specific number of clusters as a \
starting point. Randomness may also be used to help determine what seems to \
be the best number of clusters to use. Changing the random seed for \
generating the randomness by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindClusters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindClusters"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"RandomSeed", "->", 
     StyleBox["s", "TI"]}]}], "]"}]], "InlineFormula"],
 " may lead to different results for some cases."
}], "Text",
 CellID->18726],

Cell["\<\
In principle, clustering techniques can be applied to any set of data. All \
that is needed is a measure of how far apart each element in the set is from \
other elements, that is, a function giving the distance between elements.\
\>", "Text",
 CellID->11362],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindClusters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindClusters"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{
     ButtonBox["DistanceFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DistanceFunction"], "->", 
     StyleBox["f", "TI"]}]}], "]"}]], "InlineFormula"],
 " treats pairs of elements as being less similar when their distances ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["j", "TI"]]}], "]"}]], "InlineFormula"],
 " are larger. The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " can be any appropriate distance or dissimilarity function. A dissimilarity \
function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " satisfies the following:"
}], "Text",
 CellID->8964],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"f", "(", 
    RowBox[{
     SubscriptBox["e", "i"], ",", 
     SubscriptBox["e", "i"]}], ")"}], "=", "0"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"f", "(", 
    RowBox[{
     SubscriptBox["e", "i"], ",", 
     SubscriptBox["e", "j"]}], ")"}], "\[GreaterEqual]", "0"}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"f", "(", 
    RowBox[{
     SubscriptBox["e", "i"], ",", 
     SubscriptBox["e", "j"]}], ")"}], "=", 
   RowBox[{"f", "(", 
    RowBox[{
     SubscriptBox["e", "j"], ",", 
     SubscriptBox["e", "i"]}], ")"}]}], TraditionalForm]}], "DisplayMath",
 CellID->17867],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are vectors of numbers, ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " by default uses a squared Euclidean distance. If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are lists of Boolean ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " (or 0 and 1) elements, ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " by default uses a dissimilarity based on the normalized fraction of \
elements that disagree. If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are strings, ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " by default uses a distance function based on the number of point changes \
needed to get from one string to another."
}], "Text",
 CellID->21088],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EuclideanDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EuclideanDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Euclidean norm ",
     Cell[BoxData[
      FormBox[
       SqrtBox[
        RowBox[{"\[Sum]", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"u", "-", "v"}], ")"}], "2"]}]], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SquaredEuclideanDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SquaredEuclideanDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "squared Euclidean norm ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Sum]", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"u", "-", "v"}], ")"}], "2"]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ManhattanDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ManhattanDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Manhattan distance ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Sum]", 
        RowBox[{"\[LeftBracketingBar]", 
         RowBox[{"u", "-", "v"}], "\[RightBracketingBar]"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ChebyshevDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChebyshevDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Chebyshev distance ",
     Cell[BoxData[
      FormBox[
       RowBox[{"max", "(", 
        RowBox[{"\[LeftBracketingBar]", 
         RowBox[{"u", "-", "v"}], "\[RightBracketingBar]"}], ")"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CanberraDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CanberraDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Canberra distance ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Sum]", 
        RowBox[{
         RowBox[{"\[LeftBracketingBar]", 
          RowBox[{"u", "-", "v"}], "\[RightBracketingBar]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[LeftBracketingBar]", "u", "\[RightBracketingBar]"}], 
           "+", 
           RowBox[{"\[LeftBracketingBar]", "v", "\[RightBracketingBar]"}]}], 
          ")"}]}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CosineDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CosineDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the cosine distance ",
     Cell[BoxData[
      FormBox[
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"u", ".", "v"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
           "\[LeftDoubleBracketingBar]", "u", "\[RightDoubleBracketingBar]"}],
            " ", 
           RowBox[{
           "\[LeftDoubleBracketingBar]", "v", 
            "\[RightDoubleBracketingBar]"}]}], ")"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CorrelationDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CorrelationDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the correlation distance ",
     Cell[BoxData[
      RowBox[{
       StyleBox["1", "TR"], "-", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           StyleBox["u", "TI"], "-", 
           RowBox[{
            ButtonBox["Mean",
             BaseStyle->"Link",
             ButtonData->"paclet:ref/Mean"], "[", 
            StyleBox["u", "TI"], "]"}]}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["v", "TI"], "-", 
           RowBox[{
            ButtonBox["Mean",
             BaseStyle->"Link",
             ButtonData->"paclet:ref/Mean"], "[", 
            StyleBox["v", "TI"], "]"}]}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[LeftDoubleBracketingBar]", 
           RowBox[{
            StyleBox["u", "TI"], "-", 
            RowBox[{
             ButtonBox["Mean",
              BaseStyle->"Link",
              ButtonData->"paclet:ref/Mean"], "[", 
             StyleBox["u", "TI"], "]"}]}], "\[RightDoubleBracketingBar]"}], 
          RowBox[{"\[LeftDoubleBracketingBar]", 
           RowBox[{
            StyleBox["v", "TI"], "-", 
            RowBox[{
             ButtonBox["Mean",
              BaseStyle->"Link",
              ButtonData->"paclet:ref/Mean"], "[", 
             StyleBox["v", "TI"], "]"}]}], "\[RightDoubleBracketingBar]"}]}], 
         ")"}]}]}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BrayCurtisDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BrayCurtisDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Bray\[Dash]Curtis distance ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Sum]", 
        RowBox[{
         RowBox[{"\[LeftBracketingBar]", 
          RowBox[{"u", "-", "v"}], "\[RightBracketingBar]"}], "/", 
         RowBox[{"\[Sum]", 
          RowBox[{"\[LeftBracketingBar]", 
           RowBox[{"u", "+", "v"}], "\[RightBracketingBar]"}]}]}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->29465],

Cell["Distance functions for numerical data.", "Caption",
 CellID->3568],

Cell[TextData[{
 "This shows the clusters in ",
 Cell[BoxData[
  StyleBox["datapairs", "TI"]], "InlineFormula"],
 " found using a Manhattan distance."
}], "MathCaption",
 CellID->5392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"FindClusters", "[", 
   RowBox[{"datapairs", ",", 
    RowBox[{"DistanceFunction", "\[Rule]", "ManhattanDistance"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->19636],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->65321041]
}, Open  ]],

Cell[TextData[{
 "Dissimilarities for Boolean vectors are typically calculated by comparing \
the elements of two Boolean vectors ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " pairwise. It is convenient to summarize each dissimilarity function in \
terms of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", 
    RowBox[{"i", "\[InvisibleComma]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", 
    RowBox[{"i", "\[InvisibleComma]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is the number of corresponding pairs of elements in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " respectively equal to ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". The number ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", 
    RowBox[{"i", "\[InvisibleComma]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " counts the pairs ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"i", ",", "j"}], "}"}], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["u", "1"], ",", 
      SubscriptBox["v", "1"]}], "}"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["u", "2"], ",", 
       SubscriptBox["v", "2"]}], "}"}], "\[Ellipsis]"}]}], TraditionalForm]], 
  "InlineMath"],
 ", with ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " being either 0 or 1. If the Boolean values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " is equivalent to 1 and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " is equivalent to 0."
}], "Text",
 CellID->253171052],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MatchingDissimilarity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatchingDissimilarity"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "simple matching ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["10", "TR"]], "+", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["01", "TR"]]}], ")"}], "/", 
       RowBox[{
        ButtonBox["Length",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Length"], "[", 
        StyleBox["u", "TI"], "]"}]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JaccardDissimilarity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JaccardDissimilarity"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Jaccard dissimilarity",
     " ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["n", "10"], "+", 
          SubscriptBox["n", "01"]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["n", "11"], "+", 
          SubscriptBox["n", "10"], "+", 
          SubscriptBox["n", "01"]}], ")"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RussellRaoDissimilarity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RussellRaoDissimilarity"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Russell\[Dash]Rao dissimilarity ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["10", "TR"]], "+", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["01", "TR"]], "+", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["00", "TR"]]}], ")"}], "/", 
       RowBox[{
        ButtonBox["Length",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Length"], "[", 
        StyleBox["u", "TI"], "]"}]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SokalSneathDissimilarity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SokalSneathDissimilarity"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Sokal\[Dash]Sneath dissimilarity",
     " ",
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["n", "10"], "+", 
           SubscriptBox["n", "01"]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["n", "11"], "+", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["n", "10"], "+", 
              SubscriptBox["n", "01"]}], ")"}]}]}], ")"}]}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RogersTanimotoDissimilarity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RogersTanimotoDissimilarity"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Rogers\[Dash]Tanimoto dissimilarity",
     " ",
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["n", "10"], "+", 
           SubscriptBox["n", "01"]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["n", "11"], "+", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["n", "10"], "+", 
              SubscriptBox["n", "01"]}], ")"}]}], "+", 
           SubscriptBox["n", "00"]}], ")"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DiceDissimilarity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiceDissimilarity"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the dice dissimilarity ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["n", "10"], "+", 
          SubscriptBox["n", "01"]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["n", "11"]}], "+", 
          SubscriptBox["n", "10"], "+", 
          SubscriptBox["n", "01"]}], ")"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["YuleDissimilarity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/YuleDissimilarity"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the Yule dissimilarity",
     " ",
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SubscriptBox["n", "10"], " ", 
        RowBox[{
         SubscriptBox["n", "01"], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubscriptBox["n", "11"], " ", 
            SubscriptBox["n", "00"]}], "+", 
           RowBox[{
            SubscriptBox["n", "10"], " ", 
            SubscriptBox["n", "01"]}]}], ")"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->200871894],

Cell["Dissimilarity functions for Boolean data.", "Caption",
 CellID->200359058],

Cell["Here is some Boolean data.", "MathCaption",
 CellID->22356],

Cell[BoxData[
 RowBox[{
  RowBox[{"bdata", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
       "True", ",", "False", ",", "False", ",", "True", ",", "True"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
       "False", ",", "False", ",", "False", ",", "False", ",", "True"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
       "False", ",", "True", ",", "False", ",", "True", ",", "True"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
       "False", ",", "False", ",", "False", ",", "True", ",", "True"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
       "True", ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[17]:=",
 CellID->9569],

Cell["\<\
These are the clusters found using the default dissimilarity for Boolean \
data.\
\>", "MathCaption",
 CellID->18655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "bdata", "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->28516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "False", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
      "True", ",", "False", ",", "False", ",", "True", ",", "True"}], "}"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "True", ",", "False", ",", "False", ",", "False", ",", "False", ",", 
       "False", ",", "False", ",", "False", ",", "False", ",", "True"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "False", ",", "False", ",", "True", ",", "False", ",", 
       "False", ",", "True", ",", "False", ",", "True", ",", "True"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
       "False", ",", "False", ",", "False", ",", "True", ",", "True"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", 
       "True", ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{476, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->57133344]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EditDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EditDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the number of edits to transform ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " into string ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HammingDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HammingDistance"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "the number of elements whose values disagree in ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1012],

Cell["Dissimilarity functions for string data.", "Caption",
 CellID->26974],

Cell["\<\
The edit distance is determined by counting the number of deletions, \
insertions, and substitutions required to transform one string into another \
while preserving the ordering of characters. In contrast, the Hamming \
distance counts only the number of substitutions. \
\>", "Text",
 CellID->28032],

Cell["Here is some string data.", "MathCaption",
 CellID->1326],

Cell[BoxData[
 RowBox[{
  RowBox[{"sdata", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<The\>\"", ",", "\"\<quick\>\"", ",", "\"\<brown\>\"", ",", 
     "\"\<fox\>\"", ",", "\"\<jumps\>\"", ",", "\"\<over\>\"", ",", 
     "\"\<the\>\"", ",", "\"\<lazy\>\"", ",", "\"\<dog\>\""}], "}"}]}], 
  ";"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[19]:=",
 CellID->20053],

Cell["This clusters the string data using the edit distance.", "MathCaption",
 CellID->3320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "sdata", "]"}]], "Input",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellLabel->"In[20]:=",
 CellID->25274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"The\"\>", ",", "\<\"fox\"\>", ",", "\<\"over\"\>", 
     ",", "\<\"the\"\>", ",", "\<\"lazy\"\>", ",", "\<\"dog\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"quick\"\>", ",", "\<\"brown\"\>", ",", "\<\"jumps\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->306266215]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option can be used to specify different methods of clustering."
}], "Text",
 CellID->11453],

Cell[BoxData[GridBox[{
   {"\"\<Agglomerate\>\"", Cell[
    "find clustering hierarchically", "TableText"]},
   {"\"\<Optimize\>\"", Cell[
    "find clustering by local optimization", "TableText"]}
  }]], "DefinitionBox",
 CellID->21650],

Cell[TextData[{
 "Explicit settings for the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option."
}], "Caption",
 CellID->24500],

Cell[TextData[{
 "The methods ",
 Cell[BoxData["\"\<Agglomerate\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Optimize\>\""], "InlineFormula"],
 " determine how to cluster the data for a particular number of clusters ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData["\"\<Agglomerate\>\""], "InlineFormula"],
 " uses an agglomerative hierarchical method starting with each member of the \
set in a cluster of its own and fusing nearest clusters until there are ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " remaining. ",
 Cell[BoxData["\"\<Optimize\>\""], "InlineFormula"],
 " starts by building a set of ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " representative objects and clustering around those, iterating until a \
(locally) optimal clustering is found. The default ",
 Cell[BoxData["\"\<Optimize\>\""], "InlineFormula"],
 " method is based on partitioning around medoids."
}], "Text",
 CellID->26008],

Cell[TextData[{
 "Additional ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " suboptions are available to allow for more control over the clustering. \
Available suboptions depend on the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " chosen."
}], "Text",
 CellID->4224],

Cell[BoxData[GridBox[{
   {"\"\<SignificanceTest\>\"", Cell[
    "test for identifying the best number of clusters", "TableText"]}
  }]], "DefinitionBox",
 CellID->703],

Cell["Suboption for all methods.", "Caption",
 CellID->6408],

Cell[TextData[{
 "For a given set of data and distance function, the choice of the best \
number of clusters ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " may be unclear. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["methodname", "TI"], ",", 
     RowBox[{"\"\<SignificanceTest\>\"", "->", "\"\<\!\(\*
StyleBox[\"stest\", \"TI\"]\)\>\""}]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"stest\", \"TI\"]\)\>\""], "InlineFormula"],
 " is used to determine statistically significant clusters to help choose an \
appropriate number. Possible values of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"stest\", \"TI\"]\)\>\""], "InlineFormula"],
 " are ",
 Cell[BoxData["\"\<Silhouette\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Gap\>\""], "InlineFormula"],
 ". The ",
 Cell[BoxData["\"\<Silhouette\>\""], "InlineFormula"],
 " test uses the silhouette statistic to test how well the data is clustered. \
The ",
 Cell[BoxData["\"\<Gap\>\""], "InlineFormula"],
 " test uses the gap statistic to determine how well the data is clustered."
}], "Text",
 CellID->32077],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Silhouette\>\""], "InlineFormula"],
 " test subdivides the data into successively more clusters looking for the \
first minimum of the silhouette statistic."
}], "Text",
 CellID->20627],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Gap\>\""], "InlineFormula"],
 " test compares the dispersion of clusters generated from the data to that \
derived from a sample of null hypothesis sets. The null hypothesis sets are \
uniformly randomly distributed data in the box defined by the principal \
components of the input data. The ",
 Cell[BoxData["\"\<Gap\>\""], "InlineFormula"],
 " method takes two suboptions: ",
 Cell[BoxData["\"\<NullSets\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Tolerance\>\""], "InlineFormula"],
 ". The suboption ",
 Cell[BoxData["\"\<NullSets\>\""], "InlineFormula"],
 " sets the number of null hypothesis sets to compare with the input data. \
The option ",
 Cell[BoxData["\"\<Tolerance\>\""], "InlineFormula"],
 " sets the sensitivity. Typically larger values of ",
 Cell[BoxData["\"\<Tolerance\>\""], "InlineFormula"],
 " will favor fewer clusters being chosen. The default settings are ",
 Cell[BoxData[
  RowBox[{"\"\<NullSets\>\"", "->", "5"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\"\<Tolerance\>\"", "->", "1"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->13876],

Cell[TextData[{
 "This shows the result of clustering ",
 Cell[BoxData[
  StyleBox["datapairs", "TI"]], "InlineFormula"],
 " using the ",
 Cell[BoxData["\"\<Silhouette\>\""], "InlineFormula"],
 " test."
}], "MathCaption",
 CellID->2021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"FindClusters", "[", 
   RowBox[{"datapairs", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", " ", 
       RowBox[{"\"\<SignificanceTest\>\"", "->", "\"\<Silhouette\>\""}]}], 
      "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->26691],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->156755385]
}, Open  ]],

Cell[TextData[{
 "Here are the clusters found using the ",
 Cell[BoxData["\"\<Gap\>\""], "InlineFormula"],
 " test with the tolerance parameter set to 3. The larger value leads to \
fewer clusters being selected."
}], "MathCaption",
 CellID->10365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"FindClusters", "[", 
   RowBox[{"datapairs", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", " ", 
       RowBox[{"\"\<SignificanceTest\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Gap\>\"", ",", 
          RowBox[{"\"\<Tolerance\>\"", "\[Rule]", "3"}]}], "}"}]}]}], 
      "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->32249],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->302472430]
}, Open  ]],

Cell["\<\
Note that the clusters found in these two examples are identical. The only \
difference is how the number of clusters is chosen.\
\>", "Text",
 CellID->28007],

Cell[BoxData[GridBox[{
   {"\"\<Linkage\>\"", Cell["the clustering linkage to use", "TableText"]}
  }]], "DefinitionBox",
 CellID->17646],

Cell[TextData[{
 "Suboption for the ",
 Cell[BoxData["\"\<Agglomerate\>\""], "InlineFormula"],
 " method."
}], "Caption",
 CellID->12436],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   RowBox[{"{", 
    RowBox[{"\"\<Agglomerate\>\"", ",", 
     RowBox[{"\"\<Linkage\>\"", "->", 
      StyleBox["f", "TI"]}]}], "}"}]}]], "InlineFormula"],
 ", the specified linkage function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is used for agglomerative clustering. "
}], "Text",
 CellID->25126],

Cell[BoxData[GridBox[{
   {"\"\<Single\>\"", Cell[
    "smallest intercluster dissimilarity", "TableText"]},
   {"\"\<Average\>\"", Cell[
    "average intercluster dissimilarity", "TableText"]},
   {"\"\<Complete\>\"", Cell[
    "largest intercluster dissimilarity", "TableText"]},
   {"\"\<Weighted\>\"", Cell[
    "weighted average intercluster dissimilarity", "TableText"]},
   {"\"\<Centroid\>\"", Cell[
    "distance from cluster centroids", "TableText"]},
   {"\"\<Median\>\"", Cell["distance from cluster medians ", "TableText"]},
   {"\"\<Ward\>\"", Cell[
    "Ward's minimum variance dissimilarity", "TableText"]},
   {
    StyleBox["f", "TI"], Cell["a pure function", "TableText"]}
  }]], "DefinitionBox",
 CellID->10233],

Cell[TextData[{
 "Possible values for the ",
 Cell[BoxData["\"\<Linkage\>\""], "InlineFormula"],
 " suboption."
}], "Caption",
 CellID->29004],

Cell["\<\
Linkage methods determine this intercluster dissimilarity, or fusion level, \
given the dissimilarities between member elements. \
\>", "Text",
 CellID->5680],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Linkage", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is a pure function that defines the linkage algorithm. Distances or \
dissimilarities between clusters are determined recursively using information \
about the distances or dissimilarities between unmerged clusters to determine \
the distances or dissimilarities for the newly merged cluster. The function \
",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " defines a distance from a cluster ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " to the new cluster formed by fusing clusters ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 ". The arguments supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["d", "TI"], 
   StyleBox["ik", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["d", "TI"], 
   StyleBox["jk", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["d", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is the distance between clusters and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the number of elements in a cluster."
}], "Text",
 CellID->13404],

Cell["\<\
These are the clusters found using complete linkage hierarchical clustering.\
\>", "MathCaption",
 CellID->20049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"FindClusters", "[", 
   RowBox[{"datapairs", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Agglomerate\>\"", ",", 
       RowBox[{"\"\<Linkage\>\"", "\[Rule]", "\"\<Complete\>\""}]}], 
      "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->11227],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->9968418]
}, Open  ]],

Cell[BoxData[GridBox[{
   {"\"\<Iterations\>\"", Cell[
    "the maximum number of iterations to use", "TableText"]}
  }]], "DefinitionBox",
 CellID->3144],

Cell[TextData[{
 "Suboption for the ",
 Cell[BoxData["\"\<Optimize\>\""], "InlineFormula"],
 " method."
}], "Caption",
 CellID->12705],

Cell[TextData[{
 "Here are the clusters determined from a single iteration of the ",
 Cell[BoxData["\"\<Optimize\>\""], "InlineFormula"],
 " method."
}], "MathCaption",
 CellID->30220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"FindClusters", "[", 
   RowBox[{"datapairs", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Optimize\>\"", ",", 
       RowBox[{"\"\<Iterations\>\"", "\[Rule]", "1"}]}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->30809],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->101681904]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Partitioning Data into Clusters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 49.5119214}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Cluster analysis is an unsupervised learning technique used for \
classification of data. Data elements are partitioned into groups called \
clusters that represent proximate collections of data elements based on a \
distance or dissimilarity function. Identical element pairs have zero \
distance or dissimilarity, and all others have positive distance or \
dissimilarity. General clustering function. The data argument of FindClusters \
can be a list of data elements or rules indexing elements and labels.", 
    "synonyms" -> {}, "title" -> "Partitioning Data into Clusters", "type" -> 
    "Tutorial", "uri" -> "tutorial/PartitioningDataIntoClusters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3182, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3807, 89, 63, 1, 70, "Title",
 CellID->2948],
Cell[3873, 92, 412, 8, 70, "Text",
 CellID->6916],
Cell[4288, 102, 847, 29, 70, "DefinitionBox",
 CellID->7047],
Cell[5138, 133, 919, 23, 70, "Caption",
 CellID->24103],
Cell[6060, 158, 269, 8, 70, "Text",
 CellID->5694],
Cell[6332, 168, 2238, 78, 70, "DefinitionBox",
 CellID->18627],
Cell[8573, 248, 210, 8, 70, "Caption",
 CellID->20674],
Cell[8786, 258, 645, 23, 70, "Text",
 CellID->2634],
Cell[9434, 283, 64, 1, 70, "MathCaption",
 CellID->5105],
Cell[9501, 286, 287, 10, 70, "Input",
 CellID->27731],
Cell[9791, 298, 227, 7, 70, "MathCaption",
 CellID->3587],
Cell[CellGroupData[{
Cell[10043, 309, 148, 5, 70, "Input",
 CellID->24863],
Cell[10194, 316, 353, 12, 36, "Output",
 CellID->183508394]
}, Open  ]],
Cell[10562, 331, 145, 4, 70, "Text",
 CellID->12005],
Cell[10710, 337, 141, 4, 70, "MathCaption",
 CellID->17774],
Cell[CellGroupData[{
Cell[10876, 345, 630, 20, 70, "Input",
 CellID->1723],
Cell[11509, 367, 286, 10, 36, "Output",
 CellID->13354556]
}, Open  ]],
Cell[11810, 380, 247, 5, 70, "Text",
 CellID->4251],
Cell[12060, 387, 70, 1, 70, "MathCaption",
 CellID->29398],
Cell[12133, 390, 1184, 38, 70, "Input",
 CellID->13347],
Cell[13320, 430, 129, 4, 70, "MathCaption",
 CellID->29745],
Cell[CellGroupData[{
Cell[13474, 438, 279, 9, 70, "Input",
 CellID->13399],
Cell[13756, 449, 1254, 37, 71, "Output",
 CellID->9193610]
}, Open  ]],
Cell[15025, 489, 343, 7, 70, "Text",
 CellID->7785],
Cell[15371, 498, 172, 4, 70, "MathCaption",
 CellID->2750],
Cell[15546, 504, 1827, 51, 70, "Input",
 CellID->9395],
Cell[17376, 557, 95, 1, 70, "MathCaption",
 CellID->20616],
Cell[17474, 560, 156, 5, 70, "Input",
 CellID->31811],
Cell[17633, 567, 69, 1, 70, "MathCaption",
 CellID->7166],
Cell[CellGroupData[{
Cell[17727, 572, 101, 3, 28, "Input",
 CellID->4348],
Cell[17831, 577, 6500, 111, 157, "Output",
 Evaluatable->False,
 CellID->49281050]
}, Open  ]],
Cell[24346, 691, 246, 8, 70, "Text",
 CellID->13388],
Cell[24595, 701, 238, 8, 70, "Text",
 CellID->10808],
Cell[24836, 711, 83, 1, 70, "MathCaption",
 CellID->2959],
Cell[CellGroupData[{
Cell[24944, 716, 171, 5, 28, "Input",
 CellID->1638],
Cell[25118, 723, 6175, 105, 157, "Output",
 Evaluatable->False,
 CellID->199305626]
}, Open  ]],
Cell[31308, 831, 84, 1, 70, "MathCaption",
 CellID->15053],
Cell[CellGroupData[{
Cell[31417, 836, 171, 5, 28, "Input",
 CellID->5203],
Cell[31591, 843, 6654, 113, 157, "Output",
 Evaluatable->False,
 CellID->11098344]
}, Open  ]],
Cell[38260, 959, 1040, 29, 70, "DefinitionBox3Col",
 CellID->26498],
Cell[39303, 990, 195, 8, 70, "Caption",
 CellID->27277],
Cell[39501, 1000, 919, 25, 70, "Text",
 CellID->18726],
Cell[40423, 1027, 269, 5, 70, "Text",
 CellID->11362],
Cell[40695, 1034, 1199, 41, 70, "Text",
 CellID->8964],
Cell[41897, 1077, 659, 24, 70, "DisplayMath",
 CellID->17867],
Cell[42559, 1103, 1362, 45, 70, "Text",
 CellID->21088],
Cell[43924, 1150, 5863, 186, 70, "DefinitionBox",
 CellID->29465],
Cell[49790, 1338, 72, 1, 70, "Caption",
 CellID->3568],
Cell[49865, 1341, 184, 6, 70, "MathCaption",
 CellID->5392],
Cell[CellGroupData[{
Cell[50074, 1351, 237, 7, 28, "Input",
 CellID->19636],
Cell[50314, 1360, 6479, 110, 157, "Output",
 Evaluatable->False,
 CellID->65321041]
}, Open  ]],
Cell[56808, 1473, 2373, 86, 70, "Text",
 CellID->253171052],
Cell[59184, 1561, 5545, 186, 70, "DefinitionBox",
 CellID->200871894],
Cell[64732, 1749, 80, 1, 70, "Caption",
 CellID->200359058],
Cell[64815, 1752, 65, 1, 70, "MathCaption",
 CellID->22356],
Cell[64883, 1755, 1554, 42, 70, "Input",
 CellID->9569],
Cell[66440, 1799, 127, 4, 70, "MathCaption",
 CellID->18655],
Cell[CellGroupData[{
Cell[66592, 1807, 109, 3, 70, "Input",
 CellID->28516],
Cell[66704, 1812, 1239, 35, 105, "Output",
 CellID->57133344]
}, Open  ]],
Cell[67958, 1850, 955, 32, 70, "DefinitionBox",
 CellID->1012],
Cell[68916, 1884, 75, 1, 70, "Caption",
 CellID->26974],
Cell[68994, 1887, 311, 6, 70, "Text",
 CellID->28032],
Cell[69308, 1895, 63, 1, 70, "MathCaption",
 CellID->1326],
Cell[69374, 1898, 766, 21, 70, "Input",
 CellID->20053],
Cell[70143, 1921, 92, 1, 70, "MathCaption",
 CellID->3320],
Cell[CellGroupData[{
Cell[70260, 1926, 527, 14, 70, "Input",
 CellID->25274],
Cell[70790, 1942, 466, 14, 36, "Output",
 CellID->306266215]
}, Open  ]],
Cell[71271, 1959, 234, 8, 70, "Text",
 CellID->11453],
Cell[71508, 1969, 237, 6, 70, "DefinitionBox",
 CellID->21650],
Cell[71748, 1977, 204, 8, 70, "Caption",
 CellID->24500],
Cell[71955, 1987, 982, 24, 70, "Text",
 CellID->26008],
Cell[72940, 2013, 415, 14, 70, "Text",
 CellID->4224],
Cell[73358, 2029, 168, 4, 70, "DefinitionBox",
 CellID->703],
Cell[73529, 2035, 60, 1, 70, "Caption",
 CellID->6408],
Cell[73592, 2038, 1229, 34, 70, "Text",
 CellID->32077],
Cell[74824, 2074, 229, 6, 70, "Text",
 CellID->20627],
Cell[75056, 2082, 1136, 27, 70, "Text",
 CellID->13876],
Cell[76195, 2111, 236, 8, 70, "MathCaption",
 CellID->2021],
Cell[CellGroupData[{
Cell[76456, 2123, 350, 10, 47, "Input",
 CellID->26691],
Cell[76809, 2135, 6175, 105, 157, "Output",
 Evaluatable->False,
 CellID->156755385]
}, Open  ]],
Cell[82999, 2243, 248, 6, 70, "MathCaption",
 CellID->10365],
Cell[CellGroupData[{
Cell[83272, 2253, 460, 13, 47, "Input",
 CellID->32249],
Cell[83735, 2268, 6175, 105, 157, "Output",
 Evaluatable->False,
 CellID->302472430]
}, Open  ]],
Cell[89925, 2376, 168, 4, 70, "Text",
 CellID->28007],
Cell[90096, 2382, 137, 3, 70, "DefinitionBox",
 CellID->17646],
Cell[90236, 2387, 137, 5, 70, "Caption",
 CellID->12436],
Cell[90376, 2394, 464, 16, 70, "Text",
 CellID->25126],
Cell[90843, 2412, 731, 17, 70, "DefinitionBox",
 CellID->10233],
Cell[91577, 2431, 142, 5, 70, "Caption",
 CellID->29004],
Cell[91722, 2438, 168, 4, 70, "Text",
 CellID->5680],
Cell[91893, 2444, 1804, 65, 70, "Text",
 CellID->13404],
Cell[93700, 2511, 123, 3, 70, "MathCaption",
 CellID->20049],
Cell[CellGroupData[{
Cell[93848, 2518, 349, 10, 28, "Input",
 CellID->11227],
Cell[94200, 2530, 5913, 101, 157, "Output",
 Evaluatable->False,
 CellID->9968418]
}, Open  ]],
Cell[100128, 2634, 154, 4, 70, "DefinitionBox",
 CellID->3144],
Cell[100285, 2640, 134, 5, 70, "Caption",
 CellID->12705],
Cell[100422, 2647, 184, 5, 70, "MathCaption",
 CellID->30220],
Cell[CellGroupData[{
Cell[100631, 2656, 330, 10, 28, "Input",
 CellID->30809],
Cell[100964, 2668, 5903, 101, 157, "Output",
 Evaluatable->False,
 CellID->101681904]
}, Open  ]]
}, Open  ]],
Cell[106894, 2773, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

