(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26502,       1031]
NotebookOptionsPosition[     19121,        782]
NotebookOutlinePosition[     21918,        854]
CellTagsIndexPosition[     21827,        848]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/ExpressionsOverview"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Part" :> Documentation`HelpLookup["paclet:ref/Part"], 
          "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Part\"\>", 
       2->"\<\"ReplacePart\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Parts of Expressions", "Title",
 CellTags->{"S2.1.4", "4.1"},
 CellID->24855],

Cell["\<\
Since lists are just a particular kind of expression, it will come as no \
surprise that you can refer to parts of any expression much as you refer to \
parts of a list. \
\>", "Text",
 CellID->13142],

Cell[TextData[{
 "This gets the second element in the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27611],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->30877]
}, Open  ]],

Cell[TextData[{
 "You can use the same method to get the second element in the sum ",
 Cell[BoxData[
  RowBox[{"x", "+", "y", "+", "z"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "+", "y", "+", "z"}], ")"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->32678],

Cell[BoxData["y"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->1752]
}, Open  ]],

Cell["This gives the last element in the sum. ", "MathCaption",
 CellID->18443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "+", "y", "+", "z"}], ")"}], "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->28296],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12673]
}, Open  ]],

Cell[TextData[{
 "Part ",
 Cell[BoxData["0"], "InlineFormula"],
 " is the head. "
}], "MathCaption",
 CellID->10040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "+", "y", "+", "z"}], ")"}], "[", 
  RowBox[{"[", "0", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->9313],

Cell[BoxData["Plus"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->875]
}, Open  ]],

Cell[TextData[{
 "You can refer to parts of an expression such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["g", "TI"], "[", 
     StyleBox["a", "TI"], "]"}], ",", 
    RowBox[{
     StyleBox["g", "TI"], "[", 
     StyleBox["b", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " just as you refer to parts of nested lists. "
}], "Text",
 CellID->20072],

Cell[TextData[{
 "This is part ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"g", "[", "a", "]"}], ",", 
    RowBox[{"g", "[", "b", "]"}]}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->610],

Cell[BoxData[
 RowBox[{"g", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->1017]
}, Open  ]],

Cell[TextData[{
 "This is part ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"g", "[", "a", "]"}], ",", 
    RowBox[{"g", "[", "b", "]"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->28112],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->30695]
}, Open  ]],

Cell[TextData[{
 "This extracts part ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}]], "InlineFormula"],
 " of the expression ",
 Cell[BoxData[
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}]}], ")"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->23831],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->20040]
}, Open  ]],

Cell[TextData[{
 "To see what part is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}]], "InlineFormula"],
 ", you can look at the full form of the expression. "
}], "MathCaption",
 CellID->26488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->28685],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//FullForm= ",
 CellID->19090]
}, Open  ]],

Cell[TextData[{
 "You should realize that the assignment of indices to parts of expressions \
is done on the basis of the internal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " forms of the expression, as shown by ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ". These forms do not always correspond directly with what you see printed \
out. This is particularly true for algebraic expressions, where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a standard internal form, but prints the expressions in special ways. \
"
}], "Text",
 CellID->19497],

Cell[TextData[{
 "Here is the internal form of ",
 Cell[BoxData[
  RowBox[{"x", "/", "y"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"x", "/", "y"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->25990],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Power", "[", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//FullForm= ",
 CellID->15145]
}, Open  ]],

Cell["It is the internal form that is used in specifying parts. ", \
"MathCaption",
 CellID->19353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/", "y"}], ")"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->19314],

Cell[BoxData[
 FractionBox["1", "y"]], "Output",
 ImageSize->{16, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->18651]
}, Open  ]],

Cell["\<\
You can manipulate parts of expressions just as you manipulate parts of \
lists. \
\>", "Text",
 CellID->26740],

Cell[TextData[{
 "This replaces the third part of ",
 Cell[BoxData[
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "InlineFormula"],
 " by ",
 Cell[BoxData[
  RowBox[{"x", "^", "2"}]], "InlineFormula"],
 ". Note that the sum is automatically rearranged when the replacement is \
done. "
}], "MathCaption",
 CellID->22044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}], ",", 
   RowBox[{"3", "->", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->11258],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "d", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->511577338]
}, Open  ]],

Cell["Here is an expression. ", "MathCaption",
 CellID->8759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "+", "x"}], ")"}], "^", "2"}], "/", "y"}]}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->11192],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}], "2"], "y"]}]], "Output",
 ImageSize->{74, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->7605]
}, Open  ]],

Cell[TextData[{
 "This is the full form of ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "t", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->12181],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"Power", "[", 
        RowBox[{
         RowBox[{"Plus", "[", 
          RowBox[{"3", ",", "x"}], "]"}], ",", "2"}], "]"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{341, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//FullForm= ",
 CellID->28503]
}, Open  ]],

Cell[TextData[{
 "This resets a part of the expression ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->23775],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->20608]
}, Open  ]],

Cell[TextData[{
 "Now the form of ",
 Cell[BoxData["t"], "InlineFormula"],
 " has been changed. "
}], "MathCaption",
 CellID->29292],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[15]:= ",
 CellID->5997],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "y"]}]], "Output",
 ImageSize->{41, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->17549]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["expr", "TI"], "[", "[", 
     StyleBox["n", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["expr", "TI"], "[", "[", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", "]"}], "\[SpanFromLeft]"},
   {"", Cell["a combination of parts of an expression", "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["1", "TR"]], ";;", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["2", "TR"]]}]}], "]"}], Cell[TextData[{
     "parts ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "2"], TraditionalForm]], "InlineMath"],
     " of an expression"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplacePart"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{
       StyleBox["n", "TI"], "->", 
       StyleBox["elem", "TI"]}]}], "]"}], Cell[TextData[{
     "replace the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.600000000000001]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29556],

Cell["Functions for manipulating parts of expressions. ", "Caption",
 CellID->25561],

Cell[TextData[{
 "\"",
 ButtonBox["Manipulating Elements of Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingElementsOfLists"],
 "\" discussed how you can use lists of indices to pick out several elements \
of a list at a time. You can use the same procedure to pick out several parts \
in an expression at a time. "
}], "Text",
 CellID->31627],

Cell["\<\
This picks out elements 2 and 4 in the list, and gives a list of these \
elements. \
\>", "MathCaption",
 CellID->6467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->29541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->26129]
}, Open  ]],

Cell[TextData[{
 "This picks out parts 2 and 4 of the sum, and gives a ",
 StyleBox["sum",
  FontSlant->"Italic"],
 " of these elements. "
}], "MathCaption",
 CellID->31240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d", "+", "e"}], ")"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->27813],

Cell[BoxData[
 RowBox[{"b", "+", "d"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->29174]
}, Open  ]],

Cell["\<\
Any part in an expression can be viewed as being an argument of some \
function. When you pick out several parts by giving a list of indices, the \
parts are combined using the same function as in the expression. \
\>", "Text",
 CellID->20601],

Cell["This picks out parts 2 through 4 of the list.", "MathCaption",
 CellID->410231035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->83670433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->173251486]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->7650638],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsOverview"]], "RelatedTutorials",
 CellID->323659647]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->216483597],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->220603565]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Parts of Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Expressions", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/ExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SpecialWaysToInputExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingExpressionsLikeLists"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 50.1213120}", "context" -> "", 
    "keywords" -> {
     "algebraic expressions", "elements of expressions", "expressions", 
      "FullForm", "indices of elements", "internal form", "lists", 
      "multiple parts", "numbering", "part", "parts", "ReplacePart"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Since lists are just a particular kind of expression, it will come as no \
surprise that you can refer to parts of any expression much as you refer to \
parts of a list. This gets the second element in the list {a,b,c}. You can \
use the same method to get the second element in the sum x+y+z. ", 
    "synonyms" -> {"2.1.4"}, "title" -> "Parts of Expressions", "type" -> 
    "Tutorial", "uri" -> "tutorial/PartsOfExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.1.4"->{
  Cell[1873, 59, 83, 2, 70, "Title",
   CellTags->{"S2.1.4", "4.1"},
   CellID->24855]},
 "4.1"->{
  Cell[1873, 59, 83, 2, 70, "Title",
   CellTags->{"S2.1.4", "4.1"},
   CellID->24855]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.1.4", 21616, 837},
 {"4.1", 21715, 841}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1248, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1873, 59, 83, 2, 70, "Title",
 CellTags->{"S2.1.4", "4.1"},
 CellID->24855],
Cell[1959, 63, 210, 5, 70, "Text",
 CellID->13142],
Cell[2172, 70, 197, 7, 70, "MathCaption",
 CellID->11462],
Cell[CellGroupData[{
Cell[2394, 81, 174, 6, 28, "Input",
 CellID->27611],
Cell[2571, 89, 155, 5, 36, "Output",
 CellID->30877]
}, Open  ]],
Cell[2741, 97, 197, 6, 70, "MathCaption",
 CellID->20424],
Cell[CellGroupData[{
Cell[2963, 107, 174, 6, 28, "Input",
 CellID->32678],
Cell[3140, 115, 154, 5, 36, "Output",
 CellID->1752]
}, Open  ]],
Cell[3309, 123, 79, 1, 70, "MathCaption",
 CellID->18443],
Cell[CellGroupData[{
Cell[3413, 128, 193, 7, 28, "Input",
 CellID->28296],
Cell[3609, 137, 155, 5, 36, "Output",
 CellID->12673]
}, Open  ]],
Cell[3779, 145, 116, 5, 70, "MathCaption",
 CellID->10040],
Cell[CellGroupData[{
Cell[3920, 154, 173, 6, 70, "Input",
 CellID->9313],
Cell[4096, 162, 156, 5, 36, "Output",
 CellID->875]
}, Open  ]],
Cell[4267, 170, 403, 14, 70, "Text",
 CellID->20072],
Cell[4673, 186, 112, 5, 70, "MathCaption",
 CellID->12818],
Cell[CellGroupData[{
Cell[4810, 195, 227, 8, 70, "Input",
 CellID->610],
Cell[5040, 205, 181, 6, 36, "Output",
 CellID->1017]
}, Open  ]],
Cell[5236, 214, 159, 7, 70, "MathCaption",
 CellID->14932],
Cell[CellGroupData[{
Cell[5420, 225, 253, 9, 70, "Input",
 CellID->28112],
Cell[5676, 236, 155, 5, 36, "Output",
 CellID->30695]
}, Open  ]],
Cell[5846, 244, 274, 11, 70, "MathCaption",
 CellID->13169],
Cell[CellGroupData[{
Cell[6145, 259, 213, 8, 70, "Input",
 CellID->23831],
Cell[6361, 269, 155, 5, 36, "Output",
 CellID->20040]
}, Open  ]],
Cell[6531, 277, 215, 7, 70, "MathCaption",
 CellID->26488],
Cell[CellGroupData[{
Cell[6771, 288, 148, 5, 70, "Input",
 CellID->28685],
Cell[6922, 295, 406, 15, 50, "Output",
 CellID->19090]
}, Open  ]],
Cell[7343, 313, 648, 17, 70, "Text",
 CellID->19497],
Cell[7994, 332, 150, 6, 70, "MathCaption",
 CellID->2589],
Cell[CellGroupData[{
Cell[8169, 342, 124, 4, 70, "Input",
 CellID->25990],
Cell[8296, 348, 430, 16, 50, "Output",
 CellID->15145]
}, Open  ]],
Cell[8741, 367, 99, 2, 70, "MathCaption",
 CellID->19353],
Cell[CellGroupData[{
Cell[8865, 373, 165, 6, 70, "Input",
 CellID->19314],
Cell[9033, 381, 176, 6, 53, "Output",
 CellID->18651]
}, Open  ]],
Cell[9224, 390, 121, 4, 70, "Text",
 CellID->26740],
Cell[9348, 396, 322, 10, 70, "MathCaption",
 CellID->22044],
Cell[CellGroupData[{
Cell[9695, 410, 220, 7, 70, "Input",
 CellID->11258],
Cell[9918, 419, 224, 7, 36, "Output",
 CellID->511577338]
}, Open  ]],
Cell[10157, 429, 61, 1, 70, "MathCaption",
 CellID->8759],
Cell[CellGroupData[{
Cell[10243, 434, 215, 8, 70, "Input",
 CellID->11192],
Cell[10461, 444, 274, 10, 56, "Output",
 CellID->7605]
}, Open  ]],
Cell[10750, 457, 124, 5, 70, "MathCaption",
 CellID->25264],
Cell[CellGroupData[{
Cell[10899, 466, 102, 3, 70, "Input",
 CellID->12181],
Cell[11004, 471, 633, 22, 50, "Output",
 CellID->28503]
}, Open  ]],
Cell[11652, 496, 135, 5, 70, "MathCaption",
 CellID->3829],
Cell[CellGroupData[{
Cell[11812, 505, 177, 6, 70, "Input",
 CellID->23775],
Cell[11992, 513, 156, 5, 36, "Output",
 CellID->20608]
}, Open  ]],
Cell[12163, 521, 132, 5, 70, "MathCaption",
 CellID->29292],
Cell[CellGroupData[{
Cell[12320, 530, 67, 2, 70, "Input",
 CellID->5997],
Cell[12390, 534, 224, 8, 56, "Output",
 CellID->17549]
}, Open  ]],
Cell[12629, 545, 3103, 98, 70, "DefinitionBox",
 CellID->29556],
Cell[15735, 645, 84, 1, 70, "Caption",
 CellID->25561],
Cell[15822, 648, 367, 9, 70, "Text",
 CellID->31627],
Cell[16192, 659, 129, 4, 70, "MathCaption",
 CellID->6467],
Cell[CellGroupData[{
Cell[16346, 667, 244, 8, 70, "Input",
 CellID->29541],
Cell[16593, 677, 201, 7, 36, "Output",
 CellID->26129]
}, Open  ]],
Cell[16809, 687, 173, 6, 70, "MathCaption",
 CellID->31240],
Cell[CellGroupData[{
Cell[17007, 697, 244, 8, 70, "Input",
 CellID->27813],
Cell[17254, 707, 178, 6, 36, "Output",
 CellID->29174]
}, Open  ]],
Cell[17447, 716, 253, 5, 70, "Text",
 CellID->20601],
Cell[17703, 723, 88, 1, 70, "MathCaption",
 CellID->410231035],
Cell[CellGroupData[{
Cell[17816, 728, 221, 7, 70, "Input",
 CellID->83670433],
Cell[18040, 737, 213, 7, 36, "Output",
 CellID->173251486]
}, Open  ]],
Cell[CellGroupData[{
Cell[18290, 749, 70, 1, 70, "RelatedTutorialsSection",
 CellID->7650638],
Cell[18363, 752, 152, 3, 70, "RelatedTutorials",
 CellID->323659647]
}, Open  ]],
Cell[CellGroupData[{
Cell[18552, 760, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->216483597],
Cell[18653, 763, 414, 13, 70, "TutorialRelatedLinks",
 CellID->220603565]
}, Open  ]]
}, Open  ]],
Cell[19094, 780, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

