(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43987,       1468]
NotebookOptionsPosition[     37642,       1265]
NotebookOutlinePosition[     41184,       1367]
CellTagsIndexPosition[     40895,       1353]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Attributes" :> 
         Documentation`HelpLookup["paclet:ref/Attributes"], "Clear" :> 
         Documentation`HelpLookup["paclet:ref/Clear"], "ClearAll" :> 
         Documentation`HelpLookup["paclet:ref/ClearAll"], "Default" :> 
         Documentation`HelpLookup["paclet:ref/Default"], "DownValues" :> 
         Documentation`HelpLookup["paclet:ref/DownValues"], "Except" :> 
         Documentation`HelpLookup["paclet:ref/Except"], "Flat" :> 
         Documentation`HelpLookup["paclet:ref/Flat"], "HoldPattern" :> 
         Documentation`HelpLookup["paclet:ref/HoldPattern"], "Longest" :> 
         Documentation`HelpLookup["paclet:ref/Longest"], "Messages" :> 
         Documentation`HelpLookup["paclet:ref/Messages"], "OneIdentity" :> 
         Documentation`HelpLookup["paclet:ref/OneIdentity"], "Optional" :> 
         Documentation`HelpLookup["paclet:ref/Optional"], "Options" :> 
         Documentation`HelpLookup["paclet:ref/Options"], "OptionsPattern" :> 
         Documentation`HelpLookup["paclet:ref/OptionsPattern"], "Orderless" :> 
         Documentation`HelpLookup["paclet:ref/Orderless"], "OwnValues" :> 
         Documentation`HelpLookup["paclet:ref/OwnValues"], "PatternSequence" :> 
         Documentation`HelpLookup["paclet:ref/PatternSequence"], "Remove" :> 
         Documentation`HelpLookup["paclet:ref/Remove"], "Repeated" :> 
         Documentation`HelpLookup["paclet:ref/Repeated"], "Shortest" :> 
         Documentation`HelpLookup["paclet:ref/Shortest"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"], "UpValues" :> 
         Documentation`HelpLookup["paclet:ref/UpValues"], "Verbatim" :> 
         Documentation`HelpLookup["paclet:ref/Verbatim"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Attributes\"\>", 2->"\<\"Clear\"\>", 
      3->"\<\"ClearAll\"\>", 4->"\<\"Default\"\>", 5->"\<\"DownValues\"\>", 
      6->"\<\"Except\"\>", 7->"\<\"Flat\"\>", 8->"\<\"HoldPattern\"\>", 
      9->"\<\"Longest\"\>", 10->"\<\"Messages\"\>", 11->"\<\"OneIdentity\"\>",
       12->"\<\"Optional\"\>", 13->"\<\"Options\"\>", 
      14->"\<\"OptionsPattern\"\>", 15->"\<\"Orderless\"\>", 
      16->"\<\"OwnValues\"\>", 17->"\<\"PatternSequence\"\>", 
      18->"\<\"Remove\"\>", 19->"\<\"Repeated\"\>", 20->"\<\"Shortest\"\>", 
      21->"\<\"True\"\>", 22->"\<\"UpValues\"\>", 
      23->"\<\"Verbatim\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Patterns and Transformation Rules", "Title",
 CellID->1292728359],

Cell[CellGroupData[{

Cell["Patterns", "Section",
 CellTags->{"SA.5.1", "1.1"},
 CellID->8519],

Cell[TextData[{
 StyleBox["Patterns",
  FontSlant->"Italic"],
 " stand for classes of expressions. They contain ",
 StyleBox["pattern objects",
  FontSlant->"Italic"],
 " which represent sets of possible expressions."
}], "Text",
 CellID->13985],

Cell[BoxData[GridBox[{
   {"_", Cell["any expression", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"]}], Cell[TextData[{
     "any expression, given the name ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], ":", 
     StyleBox["pattern", "TI"]}], Cell[TextData[{
     "a pattern, given the name ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], "?", 
     StyleBox["test", "TI"]}], Cell[TextData[{
     "a pattern that yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " is applied to its value"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["_", "MR"], 
     StyleBox["h", "TI"]}], Cell[TextData[{
     "any expression with head ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], 
     StyleBox["h", "TI"]}], Cell[TextData[{
     "any expression with head ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     ", given the name ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {"__", Cell["any sequence of one or more expressions", "TableText"]},
   {"___", Cell["any sequence of zero or more expressions", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["__", "MR"], Cell[" \[ThinSpace]and \[ThinSpace]", "TableText"],
      
     StyleBox["x", "TI"], 
     StyleBox["___", "MR"]}], Cell[TextData[{
     "sequences of expressions, given the name ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["__", "MR"], 
     StyleBox["h", "TI"], Cell[" \[ThinSpace]and \[ThinSpace]", "TableText"], 
     
     StyleBox["___", "MR"], 
     StyleBox["h", "TI"]}], Cell[TextData[{
     "sequences of expressions, each with head ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["__", "MR"], 
     StyleBox["h", "TI"], Cell[" \[ThinSpace]and \[ThinSpace]", "TableText"], 
     
     StyleBox["x", "TI"], 
     StyleBox["___", "MR"], 
     StyleBox["h", "TI"]}], Cell[TextData[{
     "sequences of expressions with head ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     ", given the name ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PatternSequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PatternSequence"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "a sequence of patterns", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], 
     StyleBox[":", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "an expression with default value ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], 
     StyleBox["h", "TI"], 
     StyleBox[":", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "an expression with head ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     " and default value ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_.", "MR"]}], Cell[
    "an expression with a globally defined default value", "TableText"]},
   {
    RowBox[{
     ButtonBox["Optional",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Optional"], "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], 
     StyleBox["h", "TI"], "]"}], Cell[TextData[{
     "an expression that must have head ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     ", and has a globally defined default value"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     StyleBox["c", "TI"], "]"}], Cell[TextData[{
     "any expression except one that matches ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     StyleBox["c", "TI"], ",", 
     StyleBox["pattern", "TI"], "]"}], Cell[TextData[{
     "any expression matching ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"],
     ", except one that matches ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], ".."}], Cell[
    "a pattern repeated one or more times", "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], "..."}], Cell[
    "a pattern repeated zero or more times", "TableText"]},
   {
    RowBox[{
     ButtonBox["Repeated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Repeated"], "[", 
     RowBox[{
      StyleBox["pattern", "TI"], ",", " ", 
      StyleBox["spec", "TI"]}], "]"}], Cell[TextData[{
     "a pattern repeated according to ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["pattern", "TI"], "1"], "|", 
     SubscriptBox[
      StyleBox["pattern", "TI"], "2"], "|", 
     StyleBox["\[Ellipsis]", "TR"], " "}], Cell[TextData[{
     "a pattern which matches at least one of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pattern", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], "/;", 
     StyleBox["cond", "TI"]}], Cell[TextData[{
     "a pattern for which ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     " evaluates to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HoldPattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldPattern"], "[", 
     StyleBox["pattern", "TI"], "]"}], Cell[
    "a pattern not evaluated", "TableText"]},
   {
    RowBox[{
     ButtonBox["Verbatim",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Verbatim"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "an expression to be matched verbatim", "TableText"]},
   {
    RowBox[{
     ButtonBox["OptionsPattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OptionsPattern"], "[", "]"}], Cell[
    "a sequence of options", "TableText"]},
   {
    RowBox[{
     ButtonBox["Longest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Longest"], "[", 
     StyleBox["pattern", "TI"], "]"}], Cell[TextData[{
     "the longest sequence consistent with ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Shortest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Shortest"], "[", 
     StyleBox["pattern", "TI"], "]"}], Cell[TextData[{
     "the shortest sequence consistent with ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->28289],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"]], "InlineFormula"],
 " objects. "
}], "Caption",
 CellID->15944],

Cell[TextData[{
 "When several pattern objects with the same name occur in a single pattern, \
all the objects must stand for the same expression. Thus ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "x_"}], "]"}]], "InlineFormula"],
 " can stand for ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"2", ",", "2"}], "]"}]], "InlineFormula"],
 " but not ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"2", ",", "3"}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->2865],

Cell[TextData[{
 "In a pattern object such as ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"_", 
    StyleBox["h", "TI"]}]]], "InlineFormula"],
 ", the head ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " can be any expression, but cannot itself be a pattern. "
}], "Text",
 CellID->18540],

Cell[TextData[{
 "A pattern object such as ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "__"}]]], "InlineFormula"],
 " stands for a ",
 StyleBox["sequence",
  FontSlant->"Italic"],
 " of expressions. So, for example, ",
 Cell[BoxData[
  RowBox[{"f", "[", "x__", "]"}]], "InlineFormula"],
 " can stand for ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData["x"], "InlineFormula"],
 " being ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"], "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "InlineFormula"],
 ". If you use ",
 Cell[BoxData["x"], "InlineFormula"],
 ", say in the result of a transformation rule, the sequence will be spliced \
into the function in which ",
 Cell[BoxData["x"], "InlineFormula"],
 " appears. Thus ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{"u", ",", "x", ",", "u"}], "]"}]], "InlineFormula"],
 " would become ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{"u", ",", "a", ",", "b", ",", "c", ",", "u"}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->23245],

Cell[TextData[{
 "When the pattern objects ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["x", "TI"], "_:"}]], 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_."}]]], "InlineFormula"],
 " appear as arguments of functions, they represent arguments which may be \
omitted. When the argument corresponding to ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["x", "TI"], "_:"}]], 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " is omitted, ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is taken to have value ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 ". When the argument corresponding to ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_."}]]], "InlineFormula"],
 " is omitted, ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is taken to have a ",
 StyleBox["default value",
  FontSlant->"Italic"],
 " that is associated with the function in which it appears. You can specify \
this default value by making assignments for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Default",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Default"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " and so on. "
}], "Text",
 CellID->25508],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Default",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Default"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "default value for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["_.", "MR"]}]], "InlineFormula"],
     " when it appears as any argument of the function ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Default",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Default"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "default value for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["_.", "MR"]}]], "InlineFormula"],
     " when it appears as the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " argument (negative ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " count from the end)"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Default",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Default"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["tot", "TI"], "]"}], Cell[TextData[{
     "default value for the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " argument when there are a total of ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " arguments"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28318],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Default",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Default"]], "InlineFormula"],
 " values. "
}], "Caption",
 CellID->27870],

Cell[TextData[{
 "A pattern like ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x__", ",", "y__", ",", "z__"}], "]"}]], "InlineFormula"],
 " can match an expression like ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}]], 
  "InlineFormula"],
 " with several different choices of ",
 Cell[BoxData["x"], "InlineFormula"],
 ", ",
 Cell[BoxData["y"], "InlineFormula"],
 " and ",
 Cell[BoxData["z"], "InlineFormula"],
 ". The choices with ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " of minimum length are tried first. In general, when there are multiple ",
 Cell[BoxData["__"], "InlineFormula"],
 " or ",
 Cell[BoxData["___"], "InlineFormula"],
 " in a single function, the case that is tried first takes all the ",
 Cell[BoxData["__"], "InlineFormula"],
 " and ",
 Cell[BoxData["___"], "InlineFormula"],
 " to stand for sequences of minimum length, except the last one, which \
stands for \[OpenCurlyDoubleQuote]the rest\[CloseCurlyDoubleQuote] of the \
arguments."
}], "Text",
 CellID->9601],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["x", "TI"], "_:"}]], 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_."}]]], "InlineFormula"],
 " are present, the case that is tried first is the one in which none of them \
correspond to omitted arguments. Cases in which later arguments are dropped \
are tried next."
}], "Text",
 CellID->28323],

Cell[TextData[{
 "The order in which the different cases are tried can be changed using ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->358929610],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Orderless",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Orderless"], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "y"}], "]"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", 
        RowBox[{"y", ",", "x"}], "]"}], TraditionalForm]], "InlineMath"],
     " are equivalent"
    }], "TableText"]},
   {
    ButtonBox["Flat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Flat"], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", "y"}], "]"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "y"}], "]"}], TraditionalForm]], "InlineMath"],
     " are equivalent"
    }], "TableText"]},
   {
    ButtonBox["OneIdentity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/OneIdentity"], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " are equivalent"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21132],

Cell["Attributes used in matching patterns. ", "Caption",
 CellID->24472],

Cell[TextData[{
 "Pattern objects like ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_"}]]], "InlineFormula"],
 " can represent any sequence of arguments in a function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " with attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". The value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " in this case is ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " applied to the sequence of arguments. If ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 " is used instead of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "[", "e", "]"}], TraditionalForm]], "InlineMath"],
 " when ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " corresponds to a sequence of just one argument. "
}], "Text",
 CellID->27152]
}, Open  ]],

Cell[CellGroupData[{

Cell["Assignments", "Section",
 CellTags->{"SA.5.2", "2.1"},
 CellID->4182],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["lhs", "TI"], "=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "immediate assignment: ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " is evaluated at the time of assignment"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "delayed assignment: ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " is evaluated when the value of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " is requested"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25391],

Cell[TextData[{
 "The two basic types of assignment in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->15495],

Cell[TextData[{
 "Assignments in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " specify transformation rules for expressions. Every assignment that you \
make must be associated with a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbol."
}], "Text",
 CellID->5764],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", "=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "assignment is associated with ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " (downvalue)"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["t", "TI"], "/:", 
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", "=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "assignment is associated with ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " (upvalue)"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["g", "TI"], "[", 
     StyleBox["args", "TI"], "]", "]", "^=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "assignment is associated with ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " (upvalue)"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->874],

Cell["Assignments associated with different symbols. ", "Caption",
 CellID->1364],

Cell[TextData[{
 "In the case of an assignment like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["args", "TI"], "]"}], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " looks at ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", then the head of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", then the head of that, and so on, until it finds a symbol with which to \
associate the assignment. "
}], "Text",
 CellID->14902],

Cell[TextData[{
 "When you make an assignment like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "^=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will set up transformation rules associated with each distinct symbol that \
occurs either as an argument of ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", or as the head of an argument of ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28255],

Cell[TextData[{
 "The transformation rules associated with a particular symbol ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " are always stored in a definite order, and are tested in that order when \
they are used. Each time you make an assignment, the corresponding \
transformation rule is inserted at the end of the list of transformation \
rules associated with ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 ", except in the following cases: "
}], "Text",
 CellID->4460],

Cell[TextData[{
 "The left\[Hyphen]hand side of the transformation rule is identical to a \
transformation rule that has already been stored, and any ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions on the right\[Hyphen]hand side are also identical. In this \
case, the new transformation rule is inserted in place of the old one."
}], "Notes",
 CellID->474],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " determines that the new transformation rule is more specific than a rule \
already present, and would never be used if it were placed after this rule. \
In this case, the new rule is placed before the old one. Note that in many \
cases it is not possible to determine whether one rule is more specific than \
another; in such cases, the new rule is always inserted at the end."
}], "Notes",
 CellID->193657617]
}, Open  ]],

Cell[CellGroupData[{

Cell["Types of Values", "Section",
 CellTags->{"SA.5.3", "3.1"},
 CellID->6025],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Attributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Attributes"], "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "attributes of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"DefaultValues", "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "default values for arguments of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DownValues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DownValues"], "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "values for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]", "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
     ", etc."
    }], "TableText"]},
   {
    RowBox[{"FormatValues", "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "print forms associated with ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Messages",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Messages"], "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "messages associated with ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"NValues", "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "numerical values associated with ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "defaults for options associated with ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OwnValues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OwnValues"], "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "values for ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " itself"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UpValues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UpValues"], "[", 
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "]"}], Cell[
    TextData[{
     "values for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Ellipsis]", "TR"], "[", 
       RowBox[{
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{
         StyleBox["f", "TI"], "[", 
         StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1534],

Cell["Types of values associated with symbols. ", "Caption",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clearing and Removing Objects", "Section",
 CellTags->{"SA.5.4", "4.1"},
 CellID->26819],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "=."}], Cell[TextData[{
     "clear a value defined for ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "/:", 
     StyleBox["expr", "TI"], "=."}], Cell[TextData[{
     "clear a value associated with ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " defined for ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", 
     SubscriptBox[
      StyleBox["s", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "clear all values for the symbols ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     ", except for attributes, messages and defaults"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ClearAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ClearAll"], "[", 
     SubscriptBox[
      StyleBox["s", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "clear all values for the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     ", including attributes, messages and defaults"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Remove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Remove"], "[", 
     SubscriptBox[
      StyleBox["s", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "clear all values, and then remove the names of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7975],

Cell["Ways to clear and remove objects. ", "Caption",
 CellID->10556],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ClearAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAll"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 ", each argument can be either a symbol or the name of a symbol as a string. \
String arguments can contain the metacharacters * and @ to specify action on \
all symbols whose names match the pattern."
}], "Text",
 CellID->7531],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ClearAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAll"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 " do nothing to symbols with the attribute ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->31495]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformation Rules", "Section",
 CellTags->{"SA.5.5", "5.1"},
 CellID->24290],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "immediate rule: ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " is evaluated when the rule is first given"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":>", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "delayed rule: ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " is evaluated when the rule is used"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29059],

Cell[TextData[{
 "The two basic types of transformation rules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->31684],

Cell[TextData[{
 "Replacements for pattern variables that appear in transformation rules are \
effectively done using ",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " (the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator). "
}], "Text",
 CellID->4546],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->254838056],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->31396215]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Patterns and Transformation Rules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 50.4650708}", "context" -> "", 
    "keywords" -> {
     "arguments", "assignments", "attributes", "blanks", "clear", "ClearAll", 
      "clearing symbols", "clearing values", "default", "DefaultValues", 
      "deleting objects", "DownValues", "erasing objects", "erasing values", 
      "flat", "FormatValues", "functions", "killing", "matches", "matching", 
      "messages", "NValues", "OneIdentity", "options", "orderless", 
      "patterns", "protected", "remove", "removing objects", "sequences", 
      "set", "SetDelayed", "symbols", "TagSet", "TagUnset", 
      "transformation rules", "Undefining objects", "unset", "UpSet", 
      "UpValues", "values"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Patterns stand for classes of expressions. They contain pattern objects \
which represent sets of possible expressions. Pattern objects. When several \
pattern objects with the same name occur in a single pattern, all the objects \
must stand for the same expression. Thus f[x_,x_] can stand for f[2,2] but \
not f[2,3]. ", "synonyms" -> {"A.5.1", "A.5.2", "A.5.3", "A.5.4", "A.5.5"}, 
    "title" -> "Patterns and Transformation Rules", "type" -> "Tutorial", 
    "uri" -> "tutorial/PatternsAndTransformationRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.5.1"->{
  Cell[3484, 77, 72, 2, 70, "Section",
   CellTags->{"SA.5.1", "1.1"},
   CellID->8519]},
 "1.1"->{
  Cell[3484, 77, 72, 2, 70, "Section",
   CellTags->{"SA.5.1", "1.1"},
   CellID->8519]},
 "SA.5.2"->{
  Cell[22285, 733, 75, 2, 70, "Section",
   CellTags->{"SA.5.2", "2.1"},
   CellID->4182]},
 "2.1"->{
  Cell[22285, 733, 75, 2, 70, "Section",
   CellTags->{"SA.5.2", "2.1"},
   CellID->4182]},
 "SA.5.3"->{
  Cell[27637, 914, 79, 2, 70, "Section",
   CellTags->{"SA.5.3", "3.1"},
   CellID->6025]},
 "3.1"->{
  Cell[27637, 914, 79, 2, 70, "Section",
   CellTags->{"SA.5.3", "3.1"},
   CellID->6025]},
 "SA.5.4"->{
  Cell[31522, 1044, 94, 2, 70, "Section",
   CellTags->{"SA.5.4", "4.1"},
   CellID->26819]},
 "4.1"->{
  Cell[31522, 1044, 94, 2, 70, "Section",
   CellTags->{"SA.5.4", "4.1"},
   CellID->26819]},
 "SA.5.5"->{
  Cell[35305, 1177, 85, 2, 70, "Section",
   CellTags->{"SA.5.5", "5.1"},
   CellID->24290]},
 "5.1"->{
  Cell[35305, 1177, 85, 2, 70, "Section",
   CellTags->{"SA.5.5", "5.1"},
   CellID->24290]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.5.1", 39846, 1310},
 {"1.1", 39946, 1314},
 {"SA.5.2", 40049, 1318},
 {"2.1", 40151, 1322},
 {"SA.5.3", 40256, 1326},
 {"3.1", 40358, 1330},
 {"SA.5.4", 40463, 1334},
 {"4.1", 40567, 1338},
 {"SA.5.5", 40674, 1342},
 {"5.1", 40778, 1346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2763, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3388, 72, 71, 1, 70, "Title",
 CellID->1292728359],
Cell[CellGroupData[{
Cell[3484, 77, 72, 2, 70, "Section",
 CellTags->{"SA.5.1", "1.1"},
 CellID->8519],
Cell[3559, 81, 245, 8, 70, "Text",
 CellID->13985],
Cell[3807, 91, 7873, 259, 70, "DefinitionBox",
 CellID->28289],
Cell[11683, 352, 177, 7, 70, "Caption",
 CellID->15944],
Cell[11863, 361, 493, 16, 70, "Text",
 CellID->2865],
Cell[12359, 379, 307, 11, 70, "Text",
 CellID->18540],
Cell[12669, 392, 1174, 41, 70, "Text",
 CellID->23245],
Cell[13846, 435, 1343, 48, 70, "Text",
 CellID->25508],
Cell[15192, 485, 2061, 66, 70, "DefinitionBox",
 CellID->28318],
Cell[17256, 553, 176, 7, 70, "Caption",
 CellID->27870],
Cell[17435, 562, 1094, 32, 70, "Text",
 CellID->9601],
Cell[18532, 596, 462, 17, 70, "Text",
 CellID->28323],
Cell[18997, 615, 374, 13, 70, "Text",
 CellID->358929610],
Cell[19374, 630, 1627, 53, 70, "DefinitionBox",
 CellID->21132],
Cell[21004, 685, 73, 1, 70, "Caption",
 CellID->24472],
Cell[21080, 688, 1168, 40, 70, "Text",
 CellID->27152]
}, Open  ]],
Cell[CellGroupData[{
Cell[22285, 733, 75, 2, 70, "Section",
 CellTags->{"SA.5.2", "2.1"},
 CellID->4182],
Cell[22363, 737, 948, 30, 70, "DefinitionBox",
 CellID->25391],
Cell[23314, 769, 143, 6, 70, "Caption",
 CellID->15495],
Cell[23460, 777, 294, 10, 70, "Text",
 CellID->5764],
Cell[23757, 789, 1291, 41, 70, "DefinitionBox",
 CellID->874],
Cell[25051, 832, 81, 1, 70, "Caption",
 CellID->1364],
Cell[25135, 835, 568, 20, 70, "Text",
 CellID->14902],
Cell[25706, 857, 522, 18, 70, "Text",
 CellID->28255],
Cell[26231, 877, 520, 12, 70, "Text",
 CellID->4460],
Cell[26754, 891, 365, 7, 70, "Notes",
 CellID->474],
Cell[27122, 900, 478, 9, 70, "Notes",
 CellID->193657617]
}, Open  ]],
Cell[CellGroupData[{
Cell[27637, 914, 79, 2, 70, "Section",
 CellTags->{"SA.5.3", "3.1"},
 CellID->6025],
Cell[27719, 918, 3688, 118, 70, "DefinitionBox",
 CellID->1534],
Cell[31410, 1038, 75, 1, 70, "Caption",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[31522, 1044, 94, 2, 70, "Section",
 CellTags->{"SA.5.4", "4.1"},
 CellID->26819],
Cell[31619, 1048, 2373, 75, 70, "DefinitionBox",
 CellID->7975],
Cell[33995, 1125, 69, 1, 70, "Caption",
 CellID->10556],
Cell[34067, 1128, 617, 20, 70, "Text",
 CellID->7531],
Cell[34687, 1150, 581, 22, 70, "Text",
 CellID->31495]
}, Open  ]],
Cell[CellGroupData[{
Cell[35305, 1177, 85, 2, 70, "Section",
 CellTags->{"SA.5.5", "5.1"},
 CellID->24290],
Cell[35393, 1181, 854, 27, 70, "DefinitionBox",
 CellID->29059],
Cell[36250, 1210, 153, 6, 70, "Caption",
 CellID->31684],
Cell[36406, 1218, 336, 11, 70, "Text",
 CellID->4546],
Cell[36745, 1231, 414, 13, 70, "TutorialRelatedLinks",
 CellID->254838056],
Cell[37162, 1246, 426, 13, 70, "TutorialRelatedLinks",
 CellID->31396215]
}, Open  ]]
}, Open  ]],
Cell[37615, 1263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

