(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10889,        393]
NotebookOptionsPosition[      6970,        271]
NotebookOutlinePosition[      9507,        340]
CellTagsIndexPosition[      9418,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Patterns" :> 
         Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Patterns Involving Alternatives", "Title",
 CellTags->{"S2.3.6", "6.1"},
 CellID->4975],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     SubscriptBox[
      StyleBox["patt", "TI"], "1"], "|", 
     SubscriptBox[
      StyleBox["patt", "TI"], "2"], "|", 
     StyleBox["\[Ellipsis]", "TR"], "  "}], Cell[
    "a pattern that can have one of several forms", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1539],

Cell["Specifying patterns that involve alternatives. ", "Caption",
 CellID->303],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["h"], "InlineFormula"],
 " to give ",
 Cell[BoxData["p"], "InlineFormula"],
 " when its argument is either ",
 Cell[BoxData["a"], "InlineFormula"],
 " or ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11422],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"a", "|", "b"}], "]"}], ":=", "p"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->21098],

Cell[TextData[{
 "The first two cases give ",
 Cell[BoxData["p"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"h", "[", "a", "]"}], ",", 
   RowBox[{"h", "[", "b", "]"}], ",", 
   RowBox[{"h", "[", "c", "]"}], ",", 
   RowBox[{"h", "[", "d", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->13584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", ",", "p", ",", 
   RowBox[{"h", "[", "c", "]"}], ",", 
   RowBox[{"h", "[", "d", "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->13648]
}, Open  ]],

Cell["You can also use alternatives in transformation rules. ", "MathCaption",
 CellID->2971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "|", "b"}], ")"}], "->", "p"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->17864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", ",", "p", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->22913]
}, Open  ]],

Cell["\<\
Here is another example, in which one of the alternatives is itself a \
pattern.\
\>", "MathCaption",
 CellID->11075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "x", ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", "^", "3"}], ",", 
    RowBox[{"y", "^", "2"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "|", 
     RowBox[{"x", "^", "_"}]}], ")"}], "->", "q"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "q", ",", "q", ",", "q", ",", 
   SuperscriptBox["y", "2"]}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->28712]
}, Open  ]],

Cell[TextData[{
 "When you use alternatives in patterns, you should make sure that the same \
set of names appear in each alternative. When a pattern like ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "[", "x_", "]"}], "|", 
    RowBox[{"b", "[", "x_", "]"}]}], ")"}]], "InlineFormula"],
 " matches an expression, there will always be a definite expression that \
corresponds to the object ",
 Cell[BoxData["x"], "InlineFormula"],
 ". If you try to match a pattern like ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "[", "x_", "]"}], "|", 
    RowBox[{"b", "[", "y_", "]"}]}], ")"}]], "InlineFormula"],
 ", then there still will be definite expressions corresponding to ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ", but the unmatched one will be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"], "[", " ", "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17546],

Cell[TextData[{
 "Here ",
 Cell[BoxData["f"], "InlineFormula"],
 " is used to name the head, which can be either ",
 Cell[BoxData["a"], "InlineFormula"],
 " or ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], ",", 
    RowBox[{"b", "[", "3", "]"}], ",", 
    RowBox[{"c", "[", "4", "]"}], ",", 
    RowBox[{"a", "[", "5", "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", ":", 
      RowBox[{"(", 
       RowBox[{"a", "|", "b"}], ")"}]}], ")"}], "[", "x_", "]"}], "->", 
   RowBox[{"r", "[", 
    RowBox[{"f", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->1769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"r", "[", 
    RowBox[{"a", ",", "2"}], "]"}], ",", 
   RowBox[{"r", "[", 
    RowBox[{"b", ",", "3"}], "]"}], ",", 
   RowBox[{"c", "[", "4", "]"}], ",", 
   RowBox[{"r", "[", 
    RowBox[{"a", ",", "5"}], "]"}]}], "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->15262]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->149223606],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Patterns Involving Alternatives - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PuttingConstraintsOnPatterns"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PatternSequences"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 51.6682266}", "context" -> "", 
    "keywords" -> {
     "|", "alternation", "alternatives", "alternatives", "Bar", "or", 
      "patterns", "vertical bar"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Specifying patterns that involve alternatives. This defines h to give p \
when its argument is either a or b. The first two cases give p. ", 
    "synonyms" -> {"2.3.6"}, "title" -> "Patterns Involving Alternatives", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/PatternsInvolvingAlternatives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.6"->{
  Cell[1215, 42, 93, 2, 70, "Title",
   CellTags->{"S2.3.6", "6.1"},
   CellID->4975]},
 "6.1"->{
  Cell[1215, 42, 93, 2, 70, "Title",
   CellTags->{"S2.3.6", "6.1"},
   CellID->4975]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.6", 9209, 323},
 {"6.1", 9307, 327}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 590, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1215, 42, 93, 2, 70, "Title",
 CellTags->{"S2.3.6", "6.1"},
 CellID->4975],
Cell[1311, 46, 596, 17, 70, "DefinitionBox",
 CellID->1539],
Cell[1910, 65, 80, 1, 70, "Caption",
 CellID->303],
Cell[1993, 68, 283, 11, 70, "MathCaption",
 CellID->11422],
Cell[2279, 81, 142, 5, 70, "Input",
 CellID->21098],
Cell[2424, 88, 124, 5, 70, "MathCaption",
 CellID->11247],
Cell[CellGroupData[{
Cell[2573, 97, 248, 8, 28, "Input",
 CellID->13584],
Cell[2824, 107, 279, 9, 36, "Output",
 CellID->13648]
}, Open  ]],
Cell[3118, 119, 93, 1, 70, "MathCaption",
 CellID->2971],
Cell[CellGroupData[{
Cell[3236, 124, 230, 8, 28, "Input",
 CellID->17864],
Cell[3469, 134, 220, 7, 36, "Output",
 CellID->22913]
}, Open  ]],
Cell[3704, 144, 127, 4, 70, "MathCaption",
 CellID->11075],
Cell[CellGroupData[{
Cell[3856, 152, 341, 12, 70, "Input",
 CellID->21545],
Cell[4200, 166, 256, 8, 39, "Output",
 CellID->28712]
}, Open  ]],
Cell[4471, 177, 1013, 29, 70, "Text",
 CellID->17546],
Cell[5487, 208, 241, 9, 70, "MathCaption",
 CellID->18678],
Cell[CellGroupData[{
Cell[5753, 221, 490, 17, 70, "Input",
 CellID->1769],
Cell[6246, 240, 412, 14, 36, "Output",
 CellID->15262]
}, Open  ]],
Cell[CellGroupData[{
Cell[6695, 259, 72, 1, 70, "RelatedTutorialsSection",
 CellID->149223606],
Cell[6770, 262, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[6943, 269, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

