(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17644,        631]
NotebookOptionsPosition[     12619,        473]
NotebookOutlinePosition[     15436,        546]
CellTagsIndexPosition[     15345,        540]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Coefficient" :> 
          Documentation`HelpLookup["paclet:ref/Coefficient"], "Denominator" :> 
          Documentation`HelpLookup["paclet:ref/Denominator"], "Exponent" :> 
          Documentation`HelpLookup["paclet:ref/Exponent"], "Numerator" :> 
          Documentation`HelpLookup["paclet:ref/Numerator"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Coefficient\"\>", 2->"\<\"Denominator\"\>", 
       3->"\<\"Exponent\"\>", 4->"\<\"Numerator\"\>", 
       5->"\<\"Part\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Picking Out Pieces of Algebraic Expressions", "Title",
 CellTags->{"S1.4.7", "7.1"},
 CellID->25087],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Coefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Coefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "coefficient of ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Exponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exponent"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "maximum power of ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Part",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Part"], "[", 
      RowBox[{
       StyleBox["expr", "TI"], ",", 
       StyleBox["n", "TI"]}], "]"}], Cell[" or ", "TableText"], 
     RowBox[{
      StyleBox["expr", "TI"], "[", 
      RowBox[{"[", 
       StyleBox["n", "TI"], "]"}], "]"}]}], Cell[TextData[{
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]],
      GridBoxOptions->{
      GridBoxDividers->{
       "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}}],
     " term of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28570],

Cell["Functions to pick out pieces of polynomials. ", "Caption",
 CellID->29763],

Cell["Here is an algebraic expression. ", "MathCaption",
 CellID->29901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}]}], ")"}], "^", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->17103],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"6", " ", "x"}], "+", 
  RowBox[{"9", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"24", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["y", "4"]}]}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->14423]
}, Open  ]],

Cell[TextData[{
 "This gives the coefficient of ",
 Cell[BoxData["x"], "InlineFormula"],
 " in ",
 Cell[BoxData["e"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"e", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->11600],

Cell[BoxData[
 RowBox[{"6", "+", 
  RowBox[{"24", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->26969]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exponent"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " gives the highest power of ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " that appears in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{"e", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->5565],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->28]
}, Open  ]],

Cell[TextData[{
 "This gives the fourth term in ",
 Cell[BoxData["e"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"e", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->25347],

Cell[BoxData[
 RowBox[{"8", " ", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->2088]
}, Open  ]],

Cell[TextData[{
 "You may notice that the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " used to pick out the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " term in a sum is the same as the function described in \"",
 ButtonBox["Manipulating Elements of Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingElementsOfLists"],
 "\" for picking out elements in lists. This is no coincidence. In fact, as \
discussed in \"",
 ButtonBox["Manipulating Expressions like Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingExpressionsLikeLists"],
 "\", every ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression can be manipulated structurally much like a list. However, as \
discussed in \"",
 ButtonBox["Manipulating Expressions like Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingExpressionsLikeLists"],
 "\", you must be careful, because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " often shows algebraic expressions in a form that is different from the way \
it treats them internally. "
}], "Text",
 CellID->2943],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " works even with polynomials that are not explicitly expanded out. "
}], "MathCaption",
 CellID->12637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}]}], ")"}], "^", "2"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->22409],

Cell[BoxData[
 RowBox[{"6", "+", 
  RowBox[{"24", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->26463]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Numerator",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Numerator"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "numerator of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Denominator",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Denominator"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "denominator of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5049],

Cell["Functions to pick out pieces of rational expressions. ", "Caption",
 CellID->4681],

Cell["Here is a rational expression. ", "MathCaption",
 CellID->1588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", "y"}], ")"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->11342],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "x"}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", "y"}], ")"}]}]]], "Output",
 ImageSize->{59, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->608]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " picks out the denominator. "
}], "MathCaption",
 CellID->32060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->21221],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"2", "-", "y"}], ")"}]}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->1758]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " gives ",
 Cell[BoxData["1"], "InlineFormula"],
 " for expressions that are not explicit quotients. "
}], "MathCaption",
 CellID->29954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], "+", 
   RowBox[{"2", "/", "y"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->20888],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->14146]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->172646486],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Picking Out Pieces of Algebraic Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SimplifyingWithAssumptions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ControllingTheDisplayOfLargeExpressions"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 54.3714208}", "context" -> "", 
    "keywords" -> {
     "algebraic expressions", "bottom of fraction", "coefficient", "degree", 
      "denominator", "exponent", "expressions", "numerator", "part", "parts", 
      "polynomial degree", "polynomials", "power", "Powers", 
      "rational expressions", "terms in expressions", "top of fraction", 
      "variables"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Functions to pick out pieces of polynomials. Here is an algebraic \
expression. This gives the coefficient of x in e. ", "synonyms" -> {"1.4.7"}, 
    "title" -> "Picking Out Pieces of Algebraic Expressions", "type" -> 
    "Tutorial", "uri" -> "tutorial/PickingOutPiecesOfAlgebraicExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.7"->{
  Cell[2227, 64, 106, 2, 70, "Title",
   CellTags->{"S1.4.7", "7.1"},
   CellID->25087]},
 "7.1"->{
  Cell[2227, 64, 106, 2, 70, "Title",
   CellTags->{"S1.4.7", "7.1"},
   CellID->25087]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.7", 15132, 529},
 {"7.1", 15232, 533}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1602, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2227, 64, 106, 2, 70, "Title",
 CellTags->{"S1.4.7", "7.1"},
 CellID->25087],
Cell[2336, 68, 2142, 66, 70, "DefinitionBox",
 CellID->28570],
Cell[4481, 136, 80, 1, 70, "Caption",
 CellID->29763],
Cell[4564, 139, 72, 1, 70, "MathCaption",
 CellID->29901],
Cell[CellGroupData[{
Cell[4661, 144, 279, 10, 28, "Input",
 CellID->17103],
Cell[4943, 156, 445, 15, 36, "Output",
 CellID->14423]
}, Open  ]],
Cell[5403, 174, 175, 7, 70, "MathCaption",
 CellID->3527],
Cell[CellGroupData[{
Cell[5603, 185, 127, 4, 28, "Input",
 CellID->11600],
Cell[5733, 191, 226, 8, 36, "Output",
 CellID->26969]
}, Open  ]],
Cell[5974, 202, 447, 17, 70, "MathCaption",
 CellID->14015],
Cell[CellGroupData[{
Cell[6446, 223, 123, 4, 28, "Input",
 CellID->5565],
Cell[6572, 229, 152, 5, 36, "Output",
 CellID->28]
}, Open  ]],
Cell[6739, 237, 129, 5, 70, "MathCaption",
 CellID->21543],
Cell[CellGroupData[{
Cell[6893, 246, 120, 4, 70, "Input",
 CellID->25347],
Cell[7016, 252, 200, 7, 36, "Output",
 CellID->2088]
}, Open  ]],
Cell[7231, 262, 1383, 39, 70, "Text",
 CellID->2943],
Cell[8617, 303, 246, 7, 70, "MathCaption",
 CellID->12637],
Cell[CellGroupData[{
Cell[8888, 314, 287, 11, 70, "Input",
 CellID->22409],
Cell[9178, 327, 226, 8, 36, "Output",
 CellID->26463]
}, Open  ]],
Cell[9419, 338, 908, 29, 70, "DefinitionBox",
 CellID->5049],
Cell[10330, 369, 88, 1, 70, "Caption",
 CellID->4681],
Cell[10421, 372, 69, 1, 70, "MathCaption",
 CellID->1588],
Cell[CellGroupData[{
Cell[10515, 377, 263, 10, 70, "Input",
 CellID->11342],
Cell[10781, 389, 268, 10, 53, "Output",
 CellID->608]
}, Open  ]],
Cell[11064, 402, 207, 7, 70, "MathCaption",
 CellID->32060],
Cell[CellGroupData[{
Cell[11296, 413, 104, 3, 70, "Input",
 CellID->21221],
Cell[11403, 418, 223, 8, 36, "Output",
 CellID->1758]
}, Open  ]],
Cell[11641, 429, 279, 9, 70, "MathCaption",
 CellID->29954],
Cell[CellGroupData[{
Cell[11945, 442, 175, 6, 70, "Input",
 CellID->20888],
Cell[12123, 450, 155, 5, 36, "Output",
 CellID->14146]
}, Open  ]],
Cell[CellGroupData[{
Cell[12315, 460, 72, 1, 70, "RelatedTutorialsSection",
 CellID->172646486],
Cell[12390, 463, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[12592, 471, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

