(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18268,        569]
NotebookOptionsPosition[     13770,        436]
NotebookOutlinePosition[     16693,        510]
CellTagsIndexPosition[     16602,        504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Boole" :> Documentation`HelpLookup["paclet:ref/Boole"], 
          "False" :> Documentation`HelpLookup["paclet:ref/False"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"], 
          "True" :> Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Boole\"\>", 2->"\<\"False\"\>", 
       3->"\<\"Piecewise\"\>", 4->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Piecewise Functions", "Title",
 CellTags->{"S3.2.3", "3.1"},
 CellID->690],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Boole",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Boole"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give 1 if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and 0 if it is ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7949],

Cell["Turning conditions into numbers. ", "Caption",
 CellID->12843],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is a basic function that turns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " into ",
 Cell[BoxData["1"], "InlineFormula"],
 " and ",
 Cell[BoxData["0"], "InlineFormula"],
 ". It is sometimes known as the ",
 StyleBox["characteristic function", "TB"],
 " or ",
 StyleBox["indicator function", "TB"],
 ". "
}], "Text",
 CellID->21430],

Cell["This gives the area of a unit disk. ", "MathCaption",
 CellID->25620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<=", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->748],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27067]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Piecewise",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Piecewise"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["val", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["cond", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["val", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["cond", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the first ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["cond", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Piecewise",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Piecewise"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["val", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["cond", "TI"], "1"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["val", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " if all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["cond", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4536],

Cell["Piecewise functions. ", "Caption",
 CellID->20783],

Cell[TextData[{
 "It is often convenient to have functions with different forms in different \
regions. You can do this using ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 "."
}], "Text",
 CellID->18035],

Cell["This plots a piecewise function. ", "MathCaption",
 CellID->32226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "^", "2"}], ",", 
        RowBox[{"x", "<", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "-", "x"}], ",", 
        RowBox[{"x", ">", "0"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->15185],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->332691210]
}, Open  ]],

Cell[TextData[{
 "Piecewise functions appear in systems where there is discrete switching \
between different domains. They are also at the core of many computational \
methods, including splines and finite elements. Special cases include such \
functions as ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Clip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handles piecewise functions in both symbolic and numerical situations. "
}], "Text",
 CellID->9853],

Cell["This generates a square wave.", "MathCaption",
 CellID->759906541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162955838],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1OwzAQdvPXhUJ/oO3YjcJTdIKJd2hUIbUDApUObH2UCiQG9u6MHTv2
cYLt2Il/rrYDhLQSkWrn8913Pt+dnTR38WJ6/xAvZpN4cDuPn6azyfPg5nGO
h/waQmiNfy99hO8TfEd/6yTBvd5e4tbHCl3We7j3cH/OMAqoGrvaGASCFsey
VodxfablU+E1aclwQi86AwpynFoVNdoK9hXcJE2Y4qzVrDQFnLkqyDuKnPBJ
EGukL8nzltVCy2KhCq/bwJwmPrQmj/N0T9CQyXtunuYajHdR1D/O0eaSIzlU
eF03/0LRP74vUCTyYPaZ1T60UtnnKyEmfA/yfe2xXcB3sCjvAHJ9L4snSFPx
7dUw2sDte5ZvVUddpVp/mfyTXsgjjQH7HG+3W8g+iPO4bzYb2wwURxnGjDQh
IWQ5z3xqnOiZ7aUmgTPr1yJjisQevNvtcr5qX/RPy29PwX2LvKg+PKupHsko
qeq3bzGPbxYWInqJNUQxUGeMJZ1FocJz4URQpiycuqJDapBAV12bfeq3PmKM
WcRirO7v48h+RTWmPQfh6P28Ykj+AtbvqxQxx66+hMasF9IVYqPWLLzCw8lr
tScUuXXNgfPOLo1lqj6/QCWJOvbTqZ7k727Hl/n/+rKdJ8YzrTx/Cj3/DiPL
f1RL0lcP7Z15b5zA/zkOmSiX16JbYrVasdEGVR2Px2x9p6B8uVxKcowlOdaX
5NieUT4ajZj8pJJYQdX+QYf0b2eo9gUHkO8I\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->944662526]
}, Open  ]],

Cell["Here is the integral of the square wave.", "MathCaption",
 CellID->215131028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->94115734],

Cell[BoxData[
 RowBox[{"5", " ", "\[Pi]"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->343176075]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->486145913],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Piecewise Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PseudorandomNumbers"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 54.7933066}", "context" -> "", 
    "keywords" -> {
     "Boole", "boxcar function", "box function", "characteristic function", 
      "discontinuous functions", "FEM", "finite elements", "hybrid systems", 
      "indicator function", "interval defined functions", 
      "Iverson convention", "piecewise", "ramp function", 
      "saturation function", "sawtooth function", 
      "sectionally defined functions", "square wave", "step function", 
      "switching", "triangle wave"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Turning conditions into numbers. Boole[expr] is a basic function that \
turns True and False into 1 and 0. It is sometimes known as the \
characteristic function or indicator function. This gives the area of a unit \
disk. ", "synonyms" -> {"3.2.3"}, "title" -> "Piecewise Functions", "type" -> 
    "Tutorial", "uri" -> "tutorial/PiecewiseFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.3"->{
  Cell[2075, 61, 80, 2, 70, "Title",
   CellTags->{"S3.2.3", "3.1"},
   CellID->690]},
 "3.1"->{
  Cell[2075, 61, 80, 2, 70, "Title",
   CellTags->{"S3.2.3", "3.1"},
   CellID->690]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.3", 16395, 493},
 {"3.1", 16492, 497}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1450, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2075, 61, 80, 2, 70, "Title",
 CellTags->{"S3.2.3", "3.1"},
 CellID->690],
Cell[2158, 65, 907, 29, 70, "DefinitionBox",
 CellID->7949],
Cell[3068, 96, 68, 1, 70, "Caption",
 CellID->12843],
Cell[3139, 99, 712, 27, 70, "Text",
 CellID->21430],
Cell[3854, 128, 75, 1, 70, "MathCaption",
 CellID->25620],
Cell[CellGroupData[{
Cell[3954, 133, 432, 15, 28, "Input",
 CellID->748],
Cell[4389, 150, 159, 5, 36, "Output",
 CellID->27067]
}, Open  ]],
Cell[4563, 158, 2148, 68, 70, "DefinitionBox",
 CellID->4536],
Cell[6714, 228, 56, 1, 70, "Caption",
 CellID->20783],
Cell[6773, 231, 282, 9, 70, "Text",
 CellID->18035],
Cell[7058, 242, 72, 1, 70, "MathCaption",
 CellID->32226],
Cell[CellGroupData[{
Cell[7155, 247, 514, 18, 28, "Input",
 CellID->15185],
Cell[7672, 267, 2682, 48, 139, "Output",
 Evaluatable->False,
 CellID->332691210]
}, Open  ]],
Cell[10369, 318, 1130, 39, 70, "Text",
 CellID->9853],
Cell[11502, 359, 72, 1, 70, "MathCaption",
 CellID->759906541],
Cell[CellGroupData[{
Cell[11599, 364, 266, 8, 28, "Input",
 CellID->162955838],
Cell[11868, 374, 981, 20, 141, "Output",
 Evaluatable->False,
 CellID->944662526]
}, Open  ]],
Cell[12864, 397, 83, 1, 70, "MathCaption",
 CellID->215131028],
Cell[CellGroupData[{
Cell[12972, 402, 270, 8, 70, "Input",
 CellID->94115734],
Cell[13245, 412, 184, 6, 36, "Output",
 CellID->343176075]
}, Open  ]],
Cell[CellGroupData[{
Cell[13466, 423, 72, 1, 70, "RelatedTutorialsSection",
 CellID->486145913],
Cell[13541, 426, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[13743, 434, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

