(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64475,       1469]
NotebookOptionsPosition[     58795,       1297]
NotebookOutlinePosition[     61826,       1372]
CellTagsIndexPosition[     61733,       1366]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListContourPlot"], 
          "ListDensityPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListDensityPlot"], 
          "ListLinePlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLinePlot"], "ListPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot"], "ListPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListContourPlot\"\>", 
       2->"\<\"ListDensityPlot\"\>", 3->"\<\"ListLinePlot\"\>", 
       4->"\<\"ListPlot\"\>", 5->"\<\"ListPlot3D\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Plotting Lists of Data", "Title",
 CellTags->{"S1.9.8", "8.1"},
 CellID->11224],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be used to make plots of ",
 StyleBox["functions",
  FontSlant->"Italic"],
 ". You give ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a function, and it builds up a curve or surface by evaluating the function \
at many different points."
}], "Text",
 CellID->15748],

Cell[TextData[{
 "Here we describe how you can make plots from lists of data, instead of \
functions. (\"",
 ButtonBox["Importing and Exporting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ImportingAndExportingData"],
 "\" discusses how to read data from external files and programs.) The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands for plotting lists of data are direct analogs of the ones for \
plotting functions. "
}], "Text",
 CellID->19923],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ListPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListPlot"], "[", "{", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "plot ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["y", "1"], ",", 
        SubscriptBox["y", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     " at ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " values ",
     Cell[BoxData[
      FormBox[
       RowBox[{"1", ",", "2", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["ListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListPlot"], "[", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], "}", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}], Cell[TextData[{
     "plot points ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["x", "1"], ",", 
          SubscriptBox["y", "1"]}], ")"}], ",", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListLinePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListLinePlot"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "join the points with lines", "TableText"]},
   {
    RowBox[{
     ButtonBox["ListPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListPlot3D"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["z", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["z", "TI"], 
          StyleBox["12", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["z", "TI"], 
          StyleBox["21", "TR"]], ",", 
         SubscriptBox[
          StyleBox["z", "TI"], 
          StyleBox["22", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "make a three\[Hyphen]dimensional plot of the array of heights ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["z", 
        RowBox[{"y", "\[InvisibleSpace]", "x"}]], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListPlot3D"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["z", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["z", "TI"], 
          StyleBox["2", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "make a three-dimensional plot with heights ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["z", "i"], TraditionalForm]], "InlineMath"],
     " at positions ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "i"], ",", 
         SubscriptBox["y", "i"]}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListContourPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListContourPlot"], "[", 
     StyleBox["array", "TI"], "]"}], Cell[
    "make a contour plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["ListDensityPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListDensityPlot"], "[", 
     StyleBox["array", "TI"], "]"}], Cell[
    "make a density plot", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->3359],

Cell["Functions for plotting lists of data. ", "Caption",
 CellID->32257],

Cell["Here is a list of values. ", "MathCaption",
 CellID->24766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320595876]
}, Open  ]],

Cell["This plots the values. ", "MathCaption",
 CellID->23318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "t", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->32726],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 4.}, {3., 9.}, {4., 16.}, {5., 25.}, {6., 36.}, {
     7., 49.}, {8., 64.}, {9., 81.}, {10., 100.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 100.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->107216536]
}, Open  ]],

Cell["This joins the points with lines. ", "MathCaption",
 CellID->21025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "t", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20355],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 4.}, {3., 9.}, {4., 16.}, {5., 25.}, {6., 36.}, {
     7., 49.}, {8., 64.}, {9., 81.}, {10., 100.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 100.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->131311881]
}, Open  ]],

Cell[TextData[{
 "When plotting multiple data sets, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " chooses a different color for each data set automatically."
}], "MathCaption",
 CellID->493100766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{"t", ",", " ", 
    RowBox[{"2", "t"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->40484278],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 4.}, {3., 9.}, {4., 16.}, {5., 25.}, {6., 36.}, {
     7., 49.}, {8., 64.}, {9., 81.}, {10., 100.}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    PointBox[{{1., 2.}, {2., 8.}, {3., 18.}, {4., 32.}, {5., 50.}, {6., 
     72.}, {7., 98.}, {8., 128.}, {9., 162.}, {10., 200.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 200.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->48834636]
}, Open  ]],

Cell[TextData[{
 "This gives a list of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " pairs. "
}], "MathCaption",
 CellID->22549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i", "^", "2"}], ",", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"i", "^", "2"}]}], "+", 
      RowBox[{"i", "^", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->9496],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "63"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "128"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "225"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "360"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "539"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64", ",", "768"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "1053"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "1400"}], "}"}]}], "}"}]], "Output",
 ImageSize->{385, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->141518008]
}, Open  ]],

Cell["This plots the points. ", "MathCaption",
 CellID->9515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->17964],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 5.}, {4., 24.}, {9., 63.}, {16., 128.}, {25., 225.}, {36., 
     360.}, {49., 539.}, {64., 768.}, {81., 1053.}, {100., 1400.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {0., 1400.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->273460515]
}, Open  ]],

Cell["\<\
This gives a rectangular array of values. The array is quite large, so we end \
the input with a semicolon to stop the result from being printed out. \
\>", "MathCaption",
 CellID->8075],

Cell[BoxData[
 RowBox[{
  RowBox[{"t3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "20"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->17913],

Cell["\<\
This makes a three\[Hyphen]dimensional plot of the array of values. \
\>", "MathCaption",
 CellID->16142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", "t3", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->31196],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1XQmYVMW17vQywy4Ibomo2fPilpjE+PJiTMziZxITY4wxUVGkMYpGFFAx
bqBsKtvMwLDMwAwMszEMMDMMszD7vsMsDPsXo4nbU6N5Cm7/916dU1X33q6+
3X2H915/TfetunXvrfrrnP8sVT3cMH3evTP/PH3efTOmX3TdnOkP3XvfjLkX
/Wz2HFEV+IzP59sj/qWe6xPH/y2O+N8eAOJE1OeD4jMoGvjFt198/4BrZ9Nn
SBS5pD65jS8gy3T4H1z/EH0G7dpY7R521Ma+m7dW1GtfkvOZ8Z48W40tEDFG
Jwp/Ma77Ltc+prD5dy7dJD6piS+ousav89U9fSGrHzNnzqSKq7jit8adA0b5
bHXXoEZRXC3v9F1P109R1ydzvXWxx6snqavH8NPtq32+K+3r7blVY3VexYiE
5JXWZPi+Y18dcl5N5yaqu5hzFVJ38+cXyHrVHbPdt6zZ8Cvc6Huso09UTuK7
WP2KussVfJcZevYCthQlq1lPNu5gYvdNvuQu9dzR6jugey++6TCk76Lu7n6X
aY67+K1nG3cJOlGmk3IMtxk9kF3gSxUKsXsTNHpzOd/xO3omVG+mGr0Lud7V
Lgc9PeXKSNlykYhzHP1w1gdVvStKcfoRMu5zmcd+aB3TCPsTPJdRD1pl8ZYy
Jnoip8aXZDzhUo89OVPNQKSUx+4JlYNWj+3nh9T1XmfiDAcCtm7Efi6JYEBL
SlA+Vz7aHPklHnswHrFZg3nAAxLOst9FV/1RvU02nnaxpR9OezLekA8vs2Kh
Yz4/ZD0/hqzIPlyHaOZK8iifoSj5dOWNkLMFaZGFlwN707o4eeMi7tpPMDL2
cPbOxy/XuU3YO20ZkhLK1lSuvjYGoiORd3PmDSYQ3Qx6wNBLby9UqE410HW3
P/Hm3u9VYkLOcejbjDJ65/fY/y8YtecopEd51KGgYjZPeh+ypEn5Zolm4XRH
cRZsr8ScVTecE/Xer0bpxdL5tQ7r2THGyHoQ5Y1Fj/RC15GdacyPJ9wjtHjk
khmwpoorxbhC+dHzFnDorD602eciVZqsvmNZMHM8wRganZDLFfpmT00W/4rV
O9POapQ9a7OThyyg4/l/8eWLVMTsvWkHv8y9/zxs+6ex9aq7bvbvNC1BHNTN
fn+J+32pgfLpaqXXccZsN6JeX2ygnKiXzvOs6f+f8qRGElDIaGSlnHxN6xyi
I5R4vdZlt4jIbfSeZcrhCUegovA2bRpzIY/FaWndevp/rZsBl5HHHJGJaNzR
fBGx/Uev3Jho7pznRySBLr6pPb6kBOP7vMWsrCXGWe2bmv1INJv+fIeFjSG7
Xr3CWFFawJhJc6SjjbFIC3dBnJn0MkNBFzRcrzs9r9GFN00dTDbGmaxGJCX1
c2os2vNIxNZuM+dFqmMxyOlIdSDBCM2ZlD7XeTFm0i1qSjhqDzIerWsj8TVN
qTbHPCrBmC/gQZ7tmF0vfllEZiFBL93ig8QYJOLp6CyBlpyxriOcEmdWE/Uu
avQJ+hYLLa9erBfPJ3LsWrssrXTMNo1QSvYkROqwF8/Ji9S76WIiVnLjh5hy
n+xj30a+8q3YKmIMasRjjNk/n0euM3VWzlJLQyhrF3J2IKeYOp5b5IVzvfic
sWY8FvMnlDi6nxh1ID86i2mymjsCrPcREaaVA1cZfgLZN/qFBqRUY91eZJRi
cym1yy5Bzk7kbVdyF8gvdMq9m7x60Z/T8fYT+WFks/0KJesZkZnEBFj5EbkO
NykGdvo8n7IWbJ4ox4IqLK7Fi01Y1SrZ3zdqZS1Sq5FegQ0V1GjTHmTvJoHz
k7gFcndQJaE7Epnxnv93IOjzZos0gl58BJNrOY+RcMVyQhxUWQyhX/ZamD+j
F75JG3qwrgtrOrGmg2o392JFLVJqcMOlYVHcWAGJ7hYB8C5qIARXsjUNVAiu
lF1XhBNaYK/+t4stsxKjUm/cbE4ir1MzWMgdNY/o6ny5b5SF7PpuZPdj835k
9mFjj7S7yUVDyN+P7V3Y3QwJbGa5RpLIoFiB6WfBjY+RF36LngFPNjbotAux
9CeRF2jKsHNtcKTSa2cdbcllXh2zuRsZbdjSgIIqbK/ArkrGvhLNHejqkVyS
JGR22w4IWsgrguSFkMG4I815eGJVls6RsbNzTc/5vPGnhaWWbXNVlpEcbSH5
wHY8vBOPleHJCjy7D0vrFcOeKYhVGCkhijtKUFpLTRu66bO/B8e6cKyTzm7Z
RVZsW7FiW8KRYB1RbtQbT1j6HyWZ3hjbRjXgi86KjI2DaGyEzzBqmUXOsJBd
2Yy0dmJWYbUErM9UU2VaAzY1IKcKhRXYrbEe196NA13Y34bhZmQy324uQ3Yp
csqgxHcHWzYvlsyJp5yBkfhBJkN4todq9cFk2LGIjBD0oe0HTFClUZEMmt6J
1a1YVo8F1Zi/B0l88zKWwOb9qGlHVQM6auHvFqIZ7Kmj+gMNONTC0uMLSJWP
6FE8bU3QTvtAmilGuiJroapQihcz0/nzLGR0ZEFPJxfAN+pP+dTkuSqkCFFq
RUEXdvUhpVGhnFuD8krU7xXjahCe0ei2Wo26z5dVxjq7G1t34Xibkr0A6W2h
g9Pd5YS1wIXDXH10h68zssyE7VVa+m55Lfz0X18W9oVuvCx84+Xq7aadZzN6
Oh4z+Y+902Q5ETNyIPhv9g48WEQHap4yOrG+GWvrVHlUbiVKdmNvKWqEZaln
SWvDoXYETrQLAT/WhqNtCmTBhMrWWKD67Bg6YUTrkLDTzSW6aK5LJp48Ozn7
N1xGEN78jbAvSB9Ra2jn8PfYKLs8XlsRcbykFqtaIFyerf3Y0o+sA8jsVdgl
pZYhpUihU1SLsgopp8H2Dqoc6sSRDvgFhL7A0VYcacXhFu3hb2XbkuNA1MdG
xmuc44xZvEhhXL12YkhUJACU3rH8DNx6Rdj/B/HPRRrPioEg25CQRFCitqlP
NvGFhOytLceaHUjbhnTNH6MqmlDXhpYuurq3Bz0dGGjEoND8wSYxF0NNVC8g
zCq11VxZZ4m5RFGKpiuCLv51pPZ7yroZ3BrXs0qAa+iOb4fdfJgpMTBlizxF
kSy/ljdjZStWtyGlhRqsLsfqIqTkY00OFbdVo6gNe9pR3Y2GPmRWqvxFayO6
atBVC2FderWVDhxvxwl++1jzx8g+bouUUOVWFsLdY/Gys+l/tbqlENXI+4IR
eE6/MsytqP8uuE6G9sLdJPkMzZyW5ygM83O1eKFJITR+VTVS9iK9lDyYbWyT
d/eyMS/H4hw8shpbq+WIGoWnHmrdx1zKE3NEUECS6BXfZ4zqHvczj+kjz8Gp
br716WQOvbBChAegH5NkASo+77yKDoL3XOURWfc9p74JFq7CCxduz4pmpLZz
wkM4ja3Y0ITNdchtQ9EBxfQLc3D/87j1Yc0ZnU3oa8Ug8+px8RkkNI9LRIMs
tNs4+rHzOYWnvSYw0tUR27O0Lby9r0OAOO27bMmDs74XgaK5wnUmnJGNM+vM
ZxzxIWNy1ppO2/vJ60N2Lxn21HKkcg7uhW2Y9zweXUHHtfVoakJ7C3ra0c9X
HRQYBoQ/6SeTFDjCE6F135JAofwUU/LYghYBiHfCFdN873mpeHGk3tHg17p+
+5WE5IPfDwdmfz/MMCjOio5qpEzqHQ5c+qwzg7G+Bxt6sLEXGazEOf3I7Maa
Fizfi0W5eD6XCTUPqbl4ejkdV7SjoR2tXRR7tzSis17NkvDL+8W7UfPokTan
HLJsjpb9lPSfq313qfGMlZ8P4ui0i1R62UVgaUDUTjYL0duuDM+5lkD1z71a
eEhzfxB2gholo5MsVKOwtqObubuwuIZiQ2H5sw/IZ521rAoLCjF/Pea8gAVr
qFlKFjJysYkVr64HIvARBw1NaG2AJM/OWrJS4uBAoxT/ZJJO3XNp/YXaS9zF
KZWtc0PTcyydOKMUvSswJLnyj98JP3St9Nkfu0Zo+vxrFJY+P6uWjaJpeyYy
bn5E7sLU+yDZx0qy0H2mkvLFLzRiHD1qVG4xispQwqanpgk1teTI1+yVNo7E
MDjQjOFWHOUJ1VYoWfdI2SAKlNx2Ptt5JC/7M6iYYJ3OwOwP3w7P/hFjFnjy
R9JDP2E5Ij5f1P4+ttKx9lpG1JxrcCaPZ6KATVigv5RT1SM7MScPs9IRXoZ5
aVSzIgcbtmNLCfIrUFyDsiZlsUvLYfk5whL1tqC/DQfbcZi5NCjo0/Kh1IwT
zpqflJQKrQ9qSEcU+8TNGEWj+vtvhR/8YXjRDRLVBT8OB7R+KIWNXKlIvG/V
r9GcYqG5aB8WVuPxPZRdu4/V475czMrFjHTct5aKS/KRthOb92JbDQobsa1W
WpUxOTuwfTs6utHRjp5OygsNdpNZH2TW9JObT/7HwWaKlUTkJHudrH2ngFB6
JRxSp/K01x+F6+mum4U0jhb+rETMOrd8K/zna8LP/ZKjosU/9SCvEzzL62eh
IiZZvCML07LFKO/aIu3HHZswLRN3ZuKOdMzeSi1eLMP6ahVXrxHmavLGImWh
i3egvQfdfRBxVG8XettJYsWp/fUqkSRCquFmCkhVryNZQVooMlJ2rr4wbnbJ
y04nRnCUsUf+/mvCz0o0n7/OBU1z76VmSJ1jC4xAgglfv/ZsFtVIP5ZnVQSn
4mtrB3KbpJSOF+GlqNmYi/QspGZgPeMtRXf3TlSUQHj4Pdrijzk5QKd76iDw
FTGrIbuseCGLGRyIszRLcmA3kdAm2+WMhjRznW5syteZqM/6QXjhLxj1lddb
HqmbnTL9fKd0+xTO9LPFz9C3Z0mfCjtHpXID+8kLE+6YTGVP3FqFvFLkC3TY
/GRuwfosrMnEWuExbLWFvKIMTfvQ16xY+r1BOtXdSDX9LRhqpTTW0Q4ck/6h
Zung8TZbxDSzcDwhRJ7mwMtqSaz9V/5IvIkYrw4/8/Nw+u/Zx0r9RVy8TW8r
mBBv5wqd83uqtn7ieGmdOpySwmNeV4eMSmSVYOtO5BRhMzv2QsbTN5Gwb9jG
uYPtKCpG+V7Uc6B7qE+tXR9nnu4TYUQHhrowLN4dONRKqWmVhxFHQvyPtoKi
M4eXoaMLv5J+1r2QgNzKihCBn250y7gnO3F/+vrwmlukN7bul2GzF1EoR2dj
3SXZN86YI9orweiOvTMbDxSRb7G0HssbObStRXo1aI25DBklar9EML8EJVXs
33aCs95Jvd040IuBHgx0YqAdAy0qUzPQZFM1pRFNPP0OL0PKc0jzikKVEyTU
QuUXItnFlGyvbBON9lPXh9MU2hm/Soy26QtH4Rwp5fo3op9THO53SLfF4wEr
o8CGxBdM3Y41eVibjQ35UtrOq2Qz+Gga7voLFq+n4317ics7ONw43orXuvBu
H0s4m0rJ5oe0OEuIxYFeXwgY8xHSZYW+nz6o7LCnss5KpHn+vQJjPtqJeerv
wgV3E+ZZN0pfT2mVtUctIXuYK4PnKllmnh9n4Us5b17pX9etdlGsbsbKOpQN
S1wn51Qjcyey9yC3AQX12FyFVeyLzFqC3z+E1CyO8PbSZ389jjbjlQ681YsP
+hVnJA9Itm7DEYFtB0F9zFrBEUeSsKPQdpb1+NmQyglQsm+l1vO9Z9dNxmFG
l1ik3BzOn86Z0ZuY0XnafYbf4kRee4+RPov+1bl86ea6zdlqHjijNsbyCVNa
sXVA59J9vuw+7OiXMzBuN8fJ2VXkaec0oWAv8sqRzpMwbyWmPY4HF6kdAy1V
6K3FcCP+2obXu/HeAc01gtA7idAPi3eHzvoIKj/cqujHxD+afZIN+WefL8mi
HkKU5T7hr/L4Oon56t+G8+4iqAtu5kgmqJ9qsbXMV8Ha+jPGsoxRvkwEz0xR
13I2w/4N/dzdcj32HIFmbhkKi1HAG4Py2lFQhoKdKCjG5nys3ESV9y6gJOVz
HPPU7yUi6W/A0Ra80om3+3BySElxaKgHB7txUNT24n3hb/oFr7DcDLO3eLSN
hF5KcNCWaJ3btDEOKgvK2CfJHR+CWU5o99KOggrjrkgGHAxOt2CEiyWDW7Mo
A96I3Sl0ODo2vobPPVEhzJHmhRbCaztpPW01bxx4mi1hejMya5BTDmEbC3jP
W0E1CvYgfxeycrA2k2rmL8P0+XhwMR1Xl6NlH3obiDNe6sEbmknGv9aNv3fi
bx00AW/24L39ODXAyTkRU7YQkytLqj2RqHWPOPzCuCTJsgo6mVgsnz1oZUvE
myZX5oukHOfcGa5+IByRe4mwiJ7wjVpjo8s4P2TvzFjVgiV1eLoCj5RgXgnV
rGlBVjPyapDPLFHQIAiNBnTu4o1UbqxDVwsGO3F8P473sWfHXp6QyyMteKmd
rKIU2wNN5JuIU8KxFlR9jHE6rny5gO1Xm1LrZiuDDlmX5pHlmvzvuLl7iWbV
/dKwJnnH0tXDo0vHKBx5X8J4C8f7C/Hn7bRwPoNX0xZWILUZW7uQ14b8DiVv
ZyzZiidTMW8xFq2mRs+txoKVWMZ0UNOItnbs70UJZ5vSVp9S+2FEAC60/kQb
SaqQUVH14QAGGPLhTqLfo52yf5SWp16Lb0kQQUMiQy6Yav/alywFVL7s5TvX
fBPlHSpmkfZX38YcoDMCodh4Rq2mmwyQrHCd6rgH6xF9TMlowLoqpJVhFZPY
7I2Y9gTCjxOWorhsDVaux4ZsbM5FcxcKeUnjRjbt9057R8Yig43EtFI+Rfn9
fgx0Yahb9UVQb7KwQcOs9YdYao9K3Y9AKZG+J8u9dZa+CwhZoolHXTNOUj47
50j5jJoxVzyd+4d01tdZxx6duIh/IXWJhaRwBrIP2PswiUcbkL4X6TuQlotl
LLbh1bjlEdyzkI6fFaCKIDoHGYXIZpv260vDN10afvhFDgtTT/rkNiMWTnH8
n73kHgjhJDB9PsGkJ/shYCbZpFX54EG9uun0Do470EvAASFHvsmeActfiMrk
W/touh+VsYZPWsKIe0fYIxtp3oHlunubGvEvNcc6OVRYqHTeNJzKWKTsRYpe
CxvzwFrcugS3L8QDvLy2NAupeVi/QyEqZ2/1FirOnP6u1PrJg7yD4W+deL0H
7+zHB4NqB/I/9+Mddufe3U8e8UAzDnLiguSVXWE5Sgo5GN22yEjDAxMElI1y
y9xpL0u+nDGkFyQZd3Hia0o+2aoE1pZjfQk2lWvf5zcLcTfjtGALVqhu+FMz
1L7hWxkF8Trchr924R99eGsAMnIaLdlRvN7oIZD+6wDR5FA75RzkXQQtBo5F
IqNHnhzpnVr23nKVeJy8oz6YpzfxiBo7Ry8GNDTPkjPTavtjoyIq+e/CTJDY
vthIvk56FwlTCgvT+lZkNiKrFnkd2L4f2zrkLwgEJvwE8U2HVJYIZmSzA9NF
5vmVAZUtpDPjhDy92g1S1P2knDIlI9VVfArvSDBfgNd4Rc2x6DjKF42UL9rr
NKWLdU5ZarYDcqAnDM2Pi9RYo5b/nswkeSMZ5QhWk5v3fbxtX3zm9mFtE1aW
II3tQUYp0gXJBVxw416tYxd9sBdHBWdxNDh6mGN5Ufv3LlhCNdTLkEmfQByM
GmqmuJ9CfxH7tKmg3+QZBzZ+Fw3U0XhQR6XSisicevDXl9NyoUTOzOoEPeE3
zg0/R06EcyCjN3ZiVSOWlmKBcFTW0UiWZyM9H2mZcJU331minJYBKXGi12Wc
Cm+pVWx1uE2xmJC6t7TUSWH7ZEhmGT4eFFZzUMDXQsuO8oLjHXFZiiUmKop2
jTcp5vntN2lLxb1Xh+f+OPz09WHr100n7Ny6va/KxG28G24qGy085ifKaWVL
BCYrdEYz+Yl8zF2DWc/ioUV0/yVpWK3RGpvKoYkEMJXzp1LuRNSSvx27SnVc
srHQ9sX+2gElffvxPq8dfDpEVpbRI/MaFHbgYBuG2ykQV77AENlYpjr+kHlY
SxcNZnOuPspnusWRvK60/KbwulvDW6eFd4SVOKprgsZ9Y0viBCfnTZRICr+E
9oZzKPIU/3Dh0WLMzcP9a/CnpVR8ei2WZSAlG/7UbNmT1M0aRJY9IaEZ2+iH
dhLBCb+bTbVZHK4eZhV+uRuv9+Ftlj+Bx8tCl6VvIkyqLyiOD3I+Q2t1UIqp
uFa82bcOHdMoOsYcj/fM8yaTSgk9MF+t+1tguuZtI/xnQk36ghMNjC829Jq9
5+QZaZjFmygWbsHyfKRsR0qBDE59yalbsS6PfdU99Hn3k7j7MbWPauzfevEq
g9TfQMGdOBBa/CaT69t95O1JP41ZUOIlQpVhzoEe1lFIPLbz4vXJLIfT7wjF
wWOSGx6jratn78AfN+F2TjHesQl3blJZ9lBKsRL9jcVYs1WNf5Twyp5m3G5+
EHOew3oWtaPdStLbq9FXR/6v0vxXupQb7OPwQuio0FSJTpJUW0oqMMkdHQmT
eYnj9JxbchgDnzPd8LFzhhk9cIYJpEId0vOaVMSJltIyVJRi3x5U7UFmMdYX
085c4eoWFNKi2xLeF3HXY5gxH8+uVCiOa66kHaTHWQtPDZ4U5uAfHHYJc/qv
A2QRhA0glCSKB9uUPytexzqVd+KjfdFMY45dE/ZuPl+UjTCjNZv3bJws3rNA
khhNVgx1iQMrupT1ZcLmfdi6h36gVsgRXskulJegqgzVewiZbGav4h10VuqQ
EJ25i5C6gXnnICpL6RcJvZxaeb3n1MnBf8koIfmtPgif3pIbMpGDCsEARfnS
USNuCnKkf9TKdHuMTSN8toCbzLhgcZYhL1+nj8kWJo+VYXEdnm/ESmaHtfuw
rgIby5C9E3mcTCrR8lJZRjiptRchLcLqLU5R5XOfW6VQ27Mb9eUySvzo1Z73
hRfxZs/70n8ggTmAf/Xj5CA+HsJHvHz7Qb9StkM9BJeWIj9F8AGiILnCY+5h
isU1QcVLIY2OA097F7CNBv8FH/kbCxMje2+wsGkrmpEmvHn1VN/oVTVYW4FM
XuMoqMLuClSUkwBV7tWZop0l2F6E7BysXIcnOeC+hS1aGufgSnaijtXxUOvJ
l3vfl/FP0kud+DuHQG8P4L1BfHBQrcIK2yb07F3eMHdygJCT8sXIMHdbvEQ6
12EvXiUZchQ3g+TAy30Hm4nbOW64mZmfwOp9WF8r7S19jKnktbaSKhSVYmM2
NmRhaSobrvm452m1Zr+L0xXt9R8OtJ/kJZ6JrdWfvNKL11lc3h3Ge0PCjJ0S
Z4QZE4QtQ+oPWPekY0qSxLIZOtIBAYm17OxgIstdisM2ppdle0x6v4o9fi7z
qhqxz8WRUiR8zHXdlLchWpbzmtWNza3Iq0dxFcoaUd2D2k5Ut6HC8kWXZWJJ
CiXEpYKJEdAOX9mzisqPmxo+stYdJ+5mC/jyAbzKmjXc/MlLHR++2fuBvE74
n28xSEKY5A4WtmuhT9mTP9RJm9sERckFNfLPjvA60FHpBVjupysXuXqbakXB
kpYonD5r1P6bwo0tn/TLl9UzL7HcTMgRjL2THlc3gPJaVFahuhKFTNd/ehKP
6JzsgpVyzZUuKq36RM47yy95OHtL0FCJVw+ip+7T4eaPXuo49UbPBxLP13pY
kvZr7D8cJGTA70+ZzA8JEkvSa7zSRVK7II47zL/e7eDmM1mZPoWMuwR9LpZe
KWmVz3ymin6yQKSt9iYnFfG6dmkzyuuxq5Z+5CX3sckcq0KCeyAOnJpNilrD
tN1d+8lQ00cn2k75NFuOF7beEh4Rv5waJHNvYSKOJZPLXGcScxp7Wbxg4LIr
JJ6Fj/Z63GXnfDeE1Ar243soqpu7C/ezfV9cjXVt2NKMgibsaFNIpbegoBxb
OEq7aR7ufEqtaby4CStz7OeEdhd90lgp/eeP9dT5aCPua8zT/2Q6OimM2UH2
jQZItaRJ06vyvuTDcldSBy11i5fUJWYhyvIljuXMHLK55iERmeqGSEgiMmc3
HqvAU3WaOZ6txNoW5PbIXB/LSPI9K3DLU5i5FHNS6LnPZ2N5ntJcmpNalo6+
+k9YoKCyqm8ewDsDOpNCdcJMvcfb6+y/9qV4ha8JSXMuScUXgzn81tX2aMzY
Xo75AifTRkQYVMsZp9CvnsLtSzGLB7Uox/Hr1KYq2Bz+Rj/eHsJ7w7DW5M3M
Mfcg6XALrGcc4+go5iqium600XPTksqRXOTChc7y+UZvpEy8MYS3hrlMXp6U
YEvt7NVli5xoXGYeyb0/nzdqv2aUr2Y9sNLWJNydfIJDcxlny88zEjxPboz4
glH7VaPM/xNA4Ajvv9az4T/aau9rDllt4eAN+dfzRDHG/brhmF3rdyMx7vVl
4x5fMsp/BOD42+/iQF73FaPdF43ybY6y/TSzx+aM3KFGJlvrjHz8Vl83zl5g
lKep1lIGLjbOTo1770uMsyZD/0F8BK2o5FJ1rdnqd6oVZ+3kXz13nD3PKP9G
tZY7279hnD3XKN+gWsvfsH7TOGv6ster1vLX61cYZ82I4WdwrH3y/3xAozNb
Xavuydou/+8Fx9nJRvkHqrX8q6JXGmfNPMD3VGvWVPm/SjjOmlmVK1Vr+Vfd
r1L9NVtdoVoxsvwE59kJRvlyhcG3ufV/GGfNPOzF6t7y/7/4vnHWZKmvqtby
/wm5WvXXbPVF1eoabnWNcdZk4gtV6x9z6x8aZ00LpPd9Xsetf2ScNb2Uc9W9
f86tr4VDUxytpqhWv+JWPzHOmnZ+omp9E7f+qXHWtJDjVOtbuPXPjLNumV1q
zRwm/2b9TMe+S9UqpDCYxq2ud5ydqbZk0T2m81kaORGpin4+8z/KIB+R\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->156747439]
}, Open  ]],

Cell["This gives a density plot of the array of values. ", "MathCaption",
 CellID->26173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", "t3", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->24429],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxd2LvO7TQQBtBfVClTpEiRIlhRFFmW5Rv3y+EZqKiRqHl1HgEQMdJZu9jW
akf25Jv58vc/f/3ji4+Pj9/++fv3/O/316fPz49fPveCV7zhHR/4xAFf+MYP
jjjhjAuuuOGOB7Zungte8YZ3fOATB3zhGz844oQzLrjihjse2Htm3TxXvOEd
H/jEAV/4xg+OOOGMC6644Y4H9l16z6yb54Z3fOATB3zhGz844oQzLrjihjse
2D7mu/SeWTfPHR/4xAFf+MYPjjjhjAuuuOGOB7bv28d8l94z6+Z54BMHfOEb
PzjihDMuuOKGOx7Y76R93z7mu/SeWTfPEwd84Rs/OOKEMy644oY7Hthc4XfS
vm8f8116z6ybZ8AXvvGDI04444Irbrjjgc1h5gq/k/Z9+5jv0ntm3TwvfOMH
R5xwxgVX3HDHA5tbzWHmCr+T9n37mO/Sexaw540fHHHCGRdcccMdD2zON7ea
w8wVfift+/Yx32XA1s3zwREnnHHBFTfc8cDOReZ8c6s5zFzhd9K+bx8L2Htm
3TwjTjjjgituuOOBnSOdi8z55lZzmLnC76R9P2DfpffMunkmnHHBFTfc8cDO
3c6RzkXmfHOrOcxc4XcyYPuY79J7Zt08My644oY7Htg9hXO3c6RzkTnf3GoO
M1cEbN+3j/kuvWfWzbPgihvueGD3Ou4pnLudI52LzPnmVnNYwH4n7fv2Md+l
98y6eVbccMcDuwdzr+OewrnbOdK5yJxvbg3YXOF30r5vH/Ndes+sm2fDHQ/s
3tA9mHsd9xTO3c6RzkXm/IDNYeYKv5P2ffuY79J7Zt08Ox7YPat7Q/dg7nXc
Uzh3O0c6FwVsbjWHmSv8Ttr37WO+S++ZdfMc2L20e1b3hu7B3Ou4p3Dudo4M
2JxvbjWHmSv8Ttr37WO+S++ZdfOc9fvq9azf9IJXvOEdH/jEAV/4xg+OOOGM
C6644Y4HnvX7+vWs3/SCV7zhHR/4xAFf+MYPjjjhjAuuuOGOB571++b1rN/0
gle84R0f+MQBX/jGD4444YwLrrjhjgee9fv29azf9IJXvOEdH/jEAV/4xg+O
OOGMC6644Y4HnvX77vWs3/SCV7zhHR/4xAFf+MYPjjjhjAuuuOGOB571+/71
rN/0gle84R0f+MQBX/jGD4444YwLrrjhjgee9fvh9azf9IJXvOEdH/jEAV/4
xg+OOOGMC6644Y4HnvX78fWs3/SCV7zhHR/4xAFf+MYPjjjhjAuuuOGOB571
++n1rN/0gle84R0f+MQBX/jGD4444YwLrrjhjgee9fv59azf9IJXvOEdH/jE
AV/4xg+OOOGMC6644Y7H//4bA40KRA==
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwt2Xf81eMbx/HOSaWtvbR3aWvvHZWWFiWyVxQKoUFIygptkgjJLhSVysre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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJztmmtIk1EYx+cqJCg/dcPZSoxGReWHRGvSkyQpXYaXMu2mDrXsbqUsQUtL
uhhGhWUU2c0ozQhzNS3I/JLIki4sKitc6bb2vq80K0s/VH7o60M8cU7bO98v
G/w5nL17fvzPec7/vKHGHUnZapVKlTr0MWLou8Ae6Ex+/BzWq5eNDsmqh+aD
i3d4PnfBd2Pei9elNmjIiVhx5nULBKZ9WXLq7QdFl5mO8cV0U/ebh+kLX4F1
zKQq3Zp2WDn7ijairVvRfVSn+hcbP5Ade7Nn4A3sTivyrJWewaWA5P6XdxyK
7mWd6l8q90JnfdUW8zsoudk74Wr9S5Bs6g5TtUvR/5NO5YitA1TuxY3lraao
Lqj4lR4tbusEfW1DTXC5W9EZ61T/UvdlKveF+S0W/Wk7GG64woMndsGhYmPR
gwJR0f9RZ9U/Y+s/K+5RO3V9MXc/wE8YeTj2mx1C6sTzZVpJ0f+is/Ipte9i
xd1wWPck995HWLwiMWDXyY9gG5GVYZwmKfofnVUfhY3H9n3e3LMu6q6fsHTD
kTUXCqvn9kDFus4wmCkNO51V/0z1tbe477XoDjQ19UDHRuGL1eqAOHOSUxMu
+a3OiiPGBZsH6/e8xf34U90Ge7MDxuVHbRvMdYEqqL32R4Qke51V/8xqv/Y1
7jUu3fzRD5yQWlrm0AW6oSknZrtNL8lG550/U32N9fm+xt2V0h+/p9EFlfHV
6+LmCZCiOTo9ZrLkczrv/BmrP9XXcuF+IC+zNfvcJ2jZn2RdWiLA/UP5be1m
0Ws67/yZOh77Xex8Jxfu2mNW/epSN7gto6INHQJM/ZqxeaVB5K7zzp+p5yaq
r+XOvflapDk+V4DxHktdokaEsozlY947BGY67/wZG4/Vmepr7Fwvd+6rHl2e
syBBhEUztmpWbRJBsEbe2rhPIOu8+2Tqus3K1/7K3dM59vqsSAk2Z04pTx3a
XxPmhyV4Jgqozjt/xupAPRdTfY3lOf7K/Vi/KXSythcqzz4fXKuWwFwT1Fd4
m35/RPURdR6snqx8Pdy48+6jqH6n5h5UX2M5nsL93/ou6rmYmnuw8rW/cued
P2M69r+w+bG6sfI1lt/KnTvv/Jn6XhD1OXn7Wu7ceefPrHIPaq7FytdYbi8X
7rzzZ1a5BzYeqw9vX8uFO+/8mbpfY89JXbd5+xq7r/E17rzPTdTcg7qPU3NL
3r72Ne6882esbpiPqLkW9jxYHXj7Grun8xZ3b72nwSrXoq7b3vK1t7j/Bn9a
HyU=
    "]],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{1., 20.}, {1., 30.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->291622021,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->216629904],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->151800574]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->134199696],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->45577437],

Cell[TextData[ButtonBox["M205: Visualization and Dynamic Interactivity",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://www.wolfram.com/services/education/minicourses/m205.html"], 
   None}]], "TutorialRelatedLinks",
 CellID->87986971]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Plotting Lists of Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Graphics and Sound", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/GraphicsAndSoundOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ThreeDimensionalSurfacePlots"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ParametricPlots"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 55.3558210}", "context" -> "", 
    "keywords" -> {
     "arrays", "contour plots", "density plots", "joining points", "lines", 
      "ListContourPlot", "ListDensityPlot", "ListPlot", "ListPlot3D", "lists",
       "PlotJoined", "plots", "scatter plot", "tables", 
      "Threedimensional plots"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica can be used to make plots of functions. You give Mathematica \
a function, and it builds up a curve or surface by evaluating the function at \
many different points. Here we describe how you can make plots from lists of \
data, instead of functions. (\"Importing and Exporting Data\" discusses how \
to read data from external files and programs.) The Mathematica commands for \
plotting lists of data are direct analogs of the ones for plotting functions. \
Functions for plotting lists of data. ", "synonyms" -> {}, "title" -> 
    "Plotting Lists of Data", "type" -> "Tutorial", "uri" -> 
    "tutorial/PlottingListsOfData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.8"->{
  Cell[2287, 66, 85, 2, 70, "Title",
   CellTags->{"S1.9.8", "8.1"},
   CellID->11224]},
 "8.1"->{
  Cell[2287, 66, 85, 2, 70, "Title",
   CellTags->{"S1.9.8", "8.1"},
   CellID->11224]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.8", 61522, 1355},
 {"8.1", 61621, 1359}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1662, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2287, 66, 85, 2, 70, "Title",
 CellTags->{"S1.9.8", "8.1"},
 CellID->11224],
Cell[2375, 70, 346, 12, 70, "Text",
 CellID->15748],
Cell[2724, 84, 480, 12, 70, "Text",
 CellID->19923],
Cell[3207, 98, 5045, 168, 70, "DefinitionBox",
 CellID->3359],
Cell[8255, 268, 73, 1, 70, "Caption",
 CellID->32257],
Cell[8331, 271, 65, 1, 70, "MathCaption",
 CellID->24766],
Cell[CellGroupData[{
Cell[8421, 276, 220, 8, 28, "Input",
 CellID->4944],
Cell[8644, 286, 299, 9, 36, "Output",
 CellID->320595876]
}, Open  ]],
Cell[8958, 298, 62, 1, 70, "MathCaption",
 CellID->23318],
Cell[CellGroupData[{
Cell[9045, 303, 100, 3, 28, "Input",
 CellID->32726],
Cell[9148, 308, 561, 17, 139, "Output",
 CellID->107216536]
}, Open  ]],
Cell[9724, 328, 73, 1, 70, "MathCaption",
 CellID->21025],
Cell[CellGroupData[{
Cell[9822, 333, 104, 3, 70, "Input",
 CellID->20355],
Cell[9929, 338, 560, 17, 139, "Output",
 CellID->131311881]
}, Open  ]],
Cell[10504, 358, 205, 6, 70, "MathCaption",
 CellID->493100766],
Cell[CellGroupData[{
Cell[10734, 368, 176, 6, 70, "Input",
 CellID->40484278],
Cell[10913, 376, 737, 20, 139, "Output",
 CellID->48834636]
}, Open  ]],
Cell[11665, 399, 176, 7, 70, "MathCaption",
 CellID->22549],
Cell[CellGroupData[{
Cell[11866, 410, 352, 13, 70, "Input",
 CellID->9496],
Cell[12221, 425, 800, 27, 54, "Output",
 CellID->141518008]
}, Open  ]],
Cell[13036, 455, 61, 1, 70, "MathCaption",
 CellID->9515],
Cell[CellGroupData[{
Cell[13122, 460, 100, 3, 70, "Input",
 CellID->17964],
Cell[13225, 465, 630, 19, 135, "Output",
 CellID->273460515]
}, Open  ]],
Cell[13870, 487, 196, 4, 70, "MathCaption",
 CellID->8075],
Cell[14069, 493, 343, 12, 70, "Input",
 CellID->17913],
Cell[14415, 507, 115, 3, 70, "MathCaption",
 CellID->16142],
Cell[CellGroupData[{
Cell[14555, 514, 103, 3, 28, "Input",
 CellID->31196],
Cell[14661, 519, 11066, 185, 167, "Output",
 Evaluatable->False,
 CellID->156747439]
}, Open  ]],
Cell[25742, 707, 89, 1, 70, "MathCaption",
 CellID->26173],
Cell[CellGroupData[{
Cell[25856, 712, 109, 3, 70, "Input",
 CellID->24429],
Cell[25968, 717, 31698, 534, 204, 7025, 125, "CachedBoxData", "BoxData", \
"Output",
 CellID->291622021]
}, Open  ]],
Cell[CellGroupData[{
Cell[57703, 1256, 72, 1, 70, "RelatedTutorialsSection",
 CellID->216629904],
Cell[57778, 1259, 166, 4, 70, "RelatedTutorials",
 CellID->151800574]
}, Open  ]],
Cell[CellGroupData[{
Cell[57981, 1268, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->134199696],
Cell[58082, 1271, 413, 13, 70, "TutorialRelatedLinks",
 CellID->45577437],
Cell[58498, 1286, 243, 5, 70, "TutorialRelatedLinks",
 CellID->87986971]
}, Open  ]]
}, Open  ]],
Cell[58768, 1295, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

