(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12627,        429]
NotebookOptionsPosition[      8643,        308]
NotebookOutlinePosition[     11359,        380]
CellTagsIndexPosition[     11268,        374]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expand" :> Documentation`HelpLookup["paclet:ref/Expand"], 
          "Factor" :> Documentation`HelpLookup["paclet:ref/Factor"], 
          "GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"], "Modulus" :> 
          Documentation`HelpLookup["paclet:ref/Modulus"], "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], 
          "PolynomialMod" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialMod"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Expand\"\>", 2->"\<\"Factor\"\>", 
       3->"\<\"GroebnerBasis\"\>", 4->"\<\"Modulus\"\>", 
       5->"\<\"PolynomialGCD\"\>", 
       6->"\<\"PolynomialMod\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Polynomials Modulo Primes", "Title",
 CellTags->{"S3.3.5", "5.1"},
 CellID->6923],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can work with polynomials whose coefficients are in the finite field ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Z", "p"], TraditionalForm]], "InlineMath"],
 " of integers modulo a prime ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->3831],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PolynomialMod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialMod"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "reduce the coefficients in a polynomial modulo ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Expand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expand"], "[", 
     StyleBox["poly", "TI"], ",", 
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "expand ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " modulo ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["poly", "TI"], ",", 
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "factor ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " modulo ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialGCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialGCD"], "[", 
     SubscriptBox[
      StyleBox["poly", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["poly", "TI"], "2"], ",", 
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find the GCD of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " modulo ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GroebnerBasis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GroebnerBasis"], "[", 
     StyleBox["polys", "TI"], ",", 
     StyleBox["vars", "TI"], ",", 
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find the Gr\[ODoubleDot]bner basis modulo ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19369],

Cell["Functions for manipulating polynomials over finite fields. ", "Caption",
 CellID->3878],

Cell["Here is an ordinary polynomial. ", "MathCaption",
 CellID->20259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19008],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"6", " ", "x"}], "+", 
  RowBox[{"15", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"15", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  SuperscriptBox["x", "6"]}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->22619]
}, Open  ]],

Cell["This reduces the coefficients modulo 2. ", "MathCaption",
 CellID->23971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->30003],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "4"], "+", 
  SuperscriptBox["x", "6"]}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->21945]
}, Open  ]],

Cell["\<\
Here are the factors of the resulting polynomial over the integers. \
\>", "MathCaption",
 CellID->9781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->26504],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output",
 ImageSize->{100, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12392]
}, Open  ]],

Cell["If you work modulo 2, further factoring becomes possible. ", \
"MathCaption",
 CellID->32685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Modulus", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->25313],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "6"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->6698]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->464487819],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polynomials Modulo Primes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/AlgebraicOperationsOnPolynomials"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 56.5433514}", "context" -> "", 
    "keywords" -> {
     "expanding", "factor", "factoring", "field", "finite fields", 
      "Galois fields", "GCD", "GF(p)", "mod", "modulus", "polynomials", 
      "prime moduli"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica can work with polynomials whose coefficients are in the \
finite field Z_p of integers modulo a prime p. Functions for manipulating \
polynomials over finite fields. Here is an ordinary polynomial. ", 
    "synonyms" -> {"3.3.5"}, "title" -> "Polynomials Modulo Primes", "type" -> 
    "Tutorial", "uri" -> "tutorial/PolynomialsModuloPrimes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.5"->{
  Cell[2364, 67, 87, 2, 70, "Title",
   CellTags->{"S3.3.5", "5.1"},
   CellID->6923]},
 "5.1"->{
  Cell[2364, 67, 87, 2, 70, "Title",
   CellTags->{"S3.3.5", "5.1"},
   CellID->6923]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.5", 11059, 363},
 {"5.1", 11157, 367}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1739, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2364, 67, 87, 2, 70, "Title",
 CellTags->{"S3.3.5", "5.1"},
 CellID->6923],
Cell[2454, 71, 355, 12, 70, "Text",
 CellID->3831],
Cell[2812, 85, 3032, 97, 70, "DefinitionBox",
 CellID->19369],
Cell[5847, 184, 93, 1, 70, "Caption",
 CellID->3878],
Cell[5943, 187, 71, 1, 70, "MathCaption",
 CellID->20259],
Cell[CellGroupData[{
Cell[6039, 192, 171, 6, 28, "Input",
 CellID->19008],
Cell[6213, 200, 470, 16, 36, "Output",
 CellID->22619]
}, Open  ]],
Cell[6698, 219, 79, 1, 70, "MathCaption",
 CellID->23971],
Cell[CellGroupData[{
Cell[6802, 224, 129, 4, 28, "Input",
 CellID->30003],
Cell[6934, 230, 269, 9, 36, "Output",
 CellID->21945]
}, Open  ]],
Cell[7218, 242, 114, 3, 70, "MathCaption",
 CellID->9781],
Cell[CellGroupData[{
Cell[7357, 249, 99, 3, 70, "Input",
 CellID->26504],
Cell[7459, 254, 324, 12, 39, "Output",
 CellID->12392]
}, Open  ]],
Cell[7798, 269, 99, 2, 70, "MathCaption",
 CellID->32685],
Cell[CellGroupData[{
Cell[7922, 275, 153, 5, 70, "Input",
 CellID->25313],
Cell[8078, 282, 224, 8, 36, "Output",
 CellID->6698]
}, Open  ]],
Cell[CellGroupData[{
Cell[8339, 295, 72, 1, 70, "RelatedTutorialsSection",
 CellID->464487819],
Cell[8414, 298, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[8616, 306, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

