(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13352,        504]
NotebookOptionsPosition[      8438,        345]
NotebookOutlinePosition[     10972,        411]
CellTagsIndexPosition[     10881,        405]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Strings and Characters" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Properties of Strings", "Title",
 CellTags->{"S2.8.1", "1.1"},
 CellID->17659],

Cell[TextData[{
 "Much of what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does revolves around manipulating structured expressions. But you can also \
use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a system for handling unstructured strings of text."
}], "Text",
 CellID->32498],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", Cell[
    "a string containing arbitrary text", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28486],

Cell["Text strings. ", "Caption",
 CellID->21196],

Cell[TextData[{
 "When you input a string of text to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you must always enclose it in quotes. However, when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " outputs the string it usually does not explicitly show the quotes."
}], "Text",
 CellID->7462],

Cell[TextData[{
 "You can see the quotes by asking for the input form of the string. In \
addition, in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, quotes will typically appear automatically as soon as you start \
to edit a string. "
}], "Text",
 CellID->26633],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " outputs a string, it usually does not explicitly show the quotes. "
}], "MathCaption",
 CellID->12158],

Cell[CellGroupData[{

Cell[BoxData["\"\<This is a string.\>\""], "Input",
 CellLabel->"In[1]:= ",
 CellID->12022],

Cell[BoxData["\<\"This is a string.\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->1146]
}, Open  ]],

Cell["\<\
You can see the quotes, however, by asking for the input form of the string. \
\
\>", "MathCaption",
 CellID->18392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->13037],

Cell["\"This is a string.\"", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm= ",
 CellID->3925]
}, Open  ]],

Cell[TextData[{
 "The fact that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not usually show explicit quotes around strings makes it possible for \
you to use strings to specify quite directly the textual output you want. "
}], "Text",
 CellID->10647],

Cell["The strings are printed out here without explicit quotes. ", \
"MathCaption",
 CellID->29458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"\"\<The value is \>\"", ",", "567", ",", "\"\<.\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6602],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The value is \"\>", "\[InvisibleSpace]", "567", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["The value is ", 567, "."],
  Editable->False]], "Print",
 CellID->30807]
}, Open  ]],

Cell[TextData[{
 "You should understand, however, that even though the string ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " often appears as ",
 Cell[BoxData["x"], "InlineFormula"],
 " in output, it is still a quite different object from the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "Text",
 CellID->4098],

Cell[TextData[{
 "The string ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " is not the same as the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<x\>\"", "===", "x"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->29292],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->14600]
}, Open  ]],

Cell[TextData[{
 "You can test whether any particular expression is a string by looking at \
its head. The head of any string is always ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7278],

Cell[TextData[{
 "All strings have head ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "\"\<x\>\"", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->18352],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->20448]
}, Open  ]],

Cell[TextData[{
 "The pattern ",
 Cell[BoxData["_String"], "InlineFormula"],
 " matches any string. "
}], "MathCaption",
 CellID->13882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<ab\>\"", ",", "x", ",", "\"\<a\>\"", ",", "y"}], "}"}], ",", 
   "_String"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"a\"\>"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->28315]
}, Open  ]],

Cell["\<\
You can use strings just like other expressions as elements of patterns and \
transformations. Note, however, that you cannot assign values directly to \
strings. \
\>", "Text",
 CellID->4575],

Cell["\<\
This gives a definition for an expression that involves a string. \
\>", "MathCaption",
 CellID->8762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "[", "\"\<gold\>\"", "]"}], "=", "79"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->9567],

Cell[BoxData["79"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->22336]
}, Open  ]],

Cell[TextData[{
 "This replaces each occurrence of the string ",
 Cell[BoxData["\"\<aa\>\""], "InlineFormula"],
 " by the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "\"\<aaa\>\"", ",", "\"\<aa\>\"", ",", "\"\<bb\>\"", ",", "\"\<aa\>\""}], 
   "}"}], "/.", 
  RowBox[{"\"\<aa\>\"", "->", "x"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->31418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aaa\"\>", ",", "x", ",", "\<\"bb\"\>", ",", "x"}], 
  "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->19897]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->161371003],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Properties of Strings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OperationsOnStrings"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 2.0122414}", "context" -> "", 
    "keywords" -> {
     "character strings", "double quotes", "patterns", "quotes", "string", 
      "strings", "symbols", "text strings", "\\n", "\\t", "\\r", "\\:"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Much of what Mathematica does revolves around manipulating structured \
expressions. But you can also use Mathematica as a system for handling \
unstructured strings of text. Text strings. When you input a string of text \
to Mathematica you must always enclose it in quotes. However, when \
Mathematica outputs the string it usually does not explicitly show the \
quotes.", "synonyms" -> {"2.8.1"}, "title" -> "Properties of Strings", "type" -> 
    "Tutorial", "uri" -> "tutorial/PropertiesOfStrings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.1"->{
  Cell[1265, 43, 84, 2, 70, "Title",
   CellTags->{"S2.8.1", "1.1"},
   CellID->17659]},
 "1.1"->{
  Cell[1265, 43, 84, 2, 70, "Title",
   CellTags->{"S2.8.1", "1.1"},
   CellID->17659]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.1", 10670, 394},
 {"1.1", 10769, 398}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 640, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1265, 43, 84, 2, 70, "Title",
 CellTags->{"S2.8.1", "1.1"},
 CellID->17659],
Cell[1352, 47, 305, 10, 70, "Text",
 CellID->32498],
Cell[1660, 59, 454, 12, 70, "DefinitionBox",
 CellID->28486],
Cell[2117, 73, 49, 1, 70, "Caption",
 CellID->21196],
Cell[2169, 76, 309, 9, 70, "Text",
 CellID->7462],
Cell[2481, 87, 283, 8, 70, "Text",
 CellID->26633],
Cell[2767, 97, 180, 6, 70, "MathCaption",
 CellID->12158],
Cell[CellGroupData[{
Cell[2972, 107, 91, 2, 28, "Input",
 CellID->12022],
Cell[3066, 111, 179, 5, 36, "Output",
 CellID->1146]
}, Open  ]],
Cell[3260, 119, 126, 4, 70, "MathCaption",
 CellID->18392],
Cell[CellGroupData[{
Cell[3411, 127, 102, 3, 70, "Input",
 CellID->13037],
Cell[3516, 132, 177, 5, 50, "Output",
 CellID->3925]
}, Open  ]],
Cell[3708, 140, 267, 7, 70, "Text",
 CellID->10647],
Cell[3978, 149, 99, 2, 70, "MathCaption",
 CellID->29458],
Cell[CellGroupData[{
Cell[4102, 155, 163, 5, 70, "Input",
 CellID->6602],
Cell[4268, 162, 225, 6, 70, "Print",
 CellID->30807]
}, Open  ]],
Cell[4508, 171, 328, 9, 70, "Text",
 CellID->4098],
Cell[4839, 182, 192, 7, 70, "MathCaption",
 CellID->27830],
Cell[CellGroupData[{
Cell[5056, 193, 99, 3, 70, "Input",
 CellID->29292],
Cell[5158, 198, 159, 5, 36, "Output",
 CellID->14600]
}, Open  ]],
Cell[5332, 206, 286, 9, 70, "Text",
 CellID->7278],
Cell[5621, 217, 198, 8, 70, "MathCaption",
 CellID->20799],
Cell[CellGroupData[{
Cell[5844, 229, 105, 3, 70, "Input",
 CellID->18352],
Cell[5952, 234, 160, 5, 36, "Output",
 CellID->20448]
}, Open  ]],
Cell[6127, 242, 136, 5, 70, "MathCaption",
 CellID->13882],
Cell[CellGroupData[{
Cell[6288, 251, 215, 7, 70, "Input",
 CellID->540],
Cell[6506, 260, 217, 7, 36, "Output",
 CellID->28315]
}, Open  ]],
Cell[6738, 270, 202, 5, 70, "Text",
 CellID->4575],
Cell[6943, 277, 112, 3, 70, "MathCaption",
 CellID->8762],
Cell[CellGroupData[{
Cell[7080, 284, 128, 4, 70, "Input",
 CellID->9567],
Cell[7211, 290, 156, 5, 36, "Output",
 CellID->22336]
}, Open  ]],
Cell[7382, 298, 210, 7, 70, "MathCaption",
 CellID->18397],
Cell[CellGroupData[{
Cell[7617, 309, 235, 8, 70, "Input",
 CellID->31418],
Cell[7855, 319, 243, 8, 36, "Output",
 CellID->19897]
}, Open  ]],
Cell[CellGroupData[{
Cell[8135, 332, 72, 1, 70, "RelatedTutorialsSection",
 CellID->161371003],
Cell[8210, 335, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[8411, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

