(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45294,       1564]
NotebookOptionsPosition[     36807,       1286]
NotebookOutlinePosition[     39612,       1359]
CellTagsIndexPosition[     39519,       1353]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BlockRandom" :> 
          Documentation`HelpLookup["paclet:ref/BlockRandom"], "RandomChoice" :> 
          Documentation`HelpLookup["paclet:ref/RandomChoice"], 
          "RandomComplex" :> 
          Documentation`HelpLookup["paclet:ref/RandomComplex"], 
          "RandomInteger" :> 
          Documentation`HelpLookup["paclet:ref/RandomInteger"], "RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"], "RandomSample" :> 
          Documentation`HelpLookup["paclet:ref/RandomSample"], "SeedRandom" :> 
          Documentation`HelpLookup["paclet:ref/SeedRandom"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BlockRandom\"\>", 
       2->"\<\"RandomChoice\"\>", 3->"\<\"RandomComplex\"\>", 
       4->"\<\"RandomInteger\"\>", 5->"\<\"RandomReal\"\>", 
       6->"\<\"RandomSample\"\>", 
       7->"\<\"SeedRandom\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pseudorandom Numbers", "Title",
 CellTags->{"S3.2.4", "4.1"},
 CellID->4449],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has three functions for generating pseudorandom numbers that are \
distributed uniformly over a range of values."
}], "Text",
 CellID->672691270],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", "]"}], Cell[TextData[{
     "0 or 1 with probability ",
     Cell[BoxData[
      FormBox[
       FractionBox["1", "2"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "an integer between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ", inclusive"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "]"}], Cell[TextData[{
     "an integer between 0 and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ", inclusive"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", " ", "]"}], Cell[
    "a real number between 0 and 1", "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     RowBox[{"{", 
      RowBox[{
       FormBox[
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]],
        TraditionalForm], ",", " ", 
       FormBox[
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]],
        TraditionalForm]}], "}"}], "]"}], Cell[TextData[{
     "a real number between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     "and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], 
     StyleBox["[", "MR"], 
     FormBox[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]],
      TraditionalForm], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "a real number between 0 and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomComplex"], "[", "]"}], Cell[
    "a complex number in the unit square", "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomComplex"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["z", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["z", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "a complex number in the rectangle defined by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomComplex"], "[", 
     FormBox[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]],
      TraditionalForm], "]"}], Cell[TextData[{
     "a complex number in the rectangle defined by 0 and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxDividers->{"Rows" -> {False}}},
 CellID->19404218],

Cell["Pseudorandom number generation.", "Caption",
 CellID->103623534],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["RandomReal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomReal"], "[", 
      RowBox[{
       StyleBox["range", "TI"], ",", 
       StyleBox["n", "TI"]}], "]"}], Cell[", ", "TableText"], 
     RowBox[{
      ButtonBox["RandomComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomComplex"], "[", 
      RowBox[{
       StyleBox["range", "TI"], ",", 
       StyleBox["n", "TI"]}], "]"}], Cell[", ", "TableText"], 
     RowBox[{
      ButtonBox["RandomInteger",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomInteger"], "[", 
      RowBox[{
       StyleBox["range", "TI"], ",", 
       StyleBox["n", "TI"]}], "]"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom numbers from the given range"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["RandomReal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomReal"], "[", 
      RowBox[{
       StyleBox["range", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[
     ", ", "TableText"], 
     RowBox[{
      ButtonBox["RandomComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomComplex"], "[", 
      RowBox[{
       StyleBox["range", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[
     ", ", "TableText"], 
     RowBox[{
      ButtonBox["RandomInteger",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomInteger"], "[", 
      RowBox[{
       StyleBox["range", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Times]", 
        SubscriptBox["n", "1"], "\[Times]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array of pseudorandom numbers"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->811560038],

Cell["Generating tables of pseudorandom numbers.", "Caption",
 CellID->47517730],

Cell["This will give 0 or 1 with equal probability.", "MathCaption",
 CellID->113971513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->496771465],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->368796995]
}, Open  ]],

Cell["This gives a pseudorandom complex number.", "MathCaption",
 CellID->335716811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->6825440],

Cell[BoxData[
 RowBox[{"0.259699954068767`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.7891239623066724`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->14197523]
}, Open  ]],

Cell["\<\
This gives a list of 10 pseudorandom integers between 0 and 9 (inclusive).\
\>", "MathCaption",
 CellID->370888070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "9"}], "}"}], ",", " ", "10"}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->95085604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7", ",", "8", ",", "0", ",", "7", ",", "5", ",", "5", ",", "1", ",", "4", 
   ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->98317757]
}, Open  ]],

Cell["This gives a matrix of pseudorandom reals between 0 and 1.", \
"MathCaption",
 CellID->481291518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"1", ",", " ", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->365332424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.7984574823553421`", ",", "0.9086598153289422`", ",", 
     "0.05013894919892348`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.2543161837529966`", ",", "0.42832678833026994`", ",", 
     "0.7346885562029235`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.29328342276252184`", ",", "0.6285606852930388`", ",", 
     "0.4633964859469788`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{438, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->888248]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " allow you to obtain pseudorandom numbers with any precision."
}], "Text",
 CellID->113448257],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision to use for real or complex numbers ", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19418],

Cell["Changing the precision for pseudorandom numbers.", "Caption",
 CellID->183833217],

Cell["\<\
Here is a 30\[Hyphen]digit pseudorandom real number in the range 0 to 1.\
\>", "MathCaption",
 CellID->29560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"WorkingPrecision", "\[Rule]", "30"}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->15147],

Cell[BoxData["0.592425435593582531459708475075294086957166778346`30."], \
"Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->179869707]
}, Open  ]],

Cell["\<\
Here is a list of four 20-digit pseudorandom complex numbers.\
\>", "MathCaption",
 CellID->13934966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", "I"}], ",", " ", 
     RowBox[{"1", " ", "+", " ", "I"}]}], "}"}], ",", " ", "4", ",", " ", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->412457902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.909049933222855937413049536022224828`20.", "+", 
    RowBox[{
    "0.12394429399708576389487098279307275561`20.", " ", "\[ImaginaryI]"}]}], 
   ",", 
   RowBox[{
    RowBox[{"-", "0.32862367115658248044448783153903548282`20."}], "-", 
    RowBox[{
    "0.99682159655818692191970534915990143077`20.", " ", "\[ImaginaryI]"}]}], 
   ",", 
   RowBox[{"0.28641328852741506413165373245988121198`20.", "+", 
    RowBox[{
    "0.1929225678694758695075730028922755821`20.", " ", "\[ImaginaryI]"}]}], 
   ",", 
   RowBox[{"0.59587180971009053801878269096548024208`20.", "+", 
    RowBox[{
    "0.83133753157739276902352728443323925944`20.", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{358, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->109765432]
}, Open  ]],

Cell["\<\
If you get arrays of pseudorandom numbers repeatedly, you should get a \
\"typical\" sequence of numbers, with no particular pattern. There are many \
ways to use such numbers. \
\>", "Text",
 CellID->22361],

Cell["\<\
One common way to use pseudorandom numbers is in making numerical tests of \
hypotheses. For example, if you believe that two symbolic expressions are \
mathematically equal, you can test this by plugging in \"typical\" numerical \
values for symbolic parameters, and then comparing the numerical results. (If \
you do this, you should be careful about numerical accuracy problems and \
about functions of complex variables that may not have unique values.)\
\>", "Text",
 CellID->31754],

Cell["Here is a symbolic equation. ", "MathCaption",
 CellID->81600639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", "^", "2"}], "]"}], "\[Equal]", 
  RowBox[{"Abs", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->490626066],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   SuperscriptBox["x", "2"]], "\[Equal]", 
  RowBox[{"Abs", "[", "x", "]"}]}]], "Output",
 ImageSize->{95, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->323981903]
}, Open  ]],

Cell[TextData[{
 "Substituting in a random numerical value shows that the equation is not \
always ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->43399634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", 
   RowBox[{"RandomComplex", "[", "]"}]}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->326120418],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->258881031]
}, Open  ]],

Cell[TextData[{
 "Other common uses of pseudorandom numbers include simulating probabilistic \
processes, and sampling large spaces of possibilities. The pseudorandom \
numbers that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " generates for a range of numbers are always uniformly distributed over the \
range you specify. "
}], "Text",
 CellID->8638],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " are unlike almost any other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions in that every time you call them, you potentially get a \
different result. If you use them in a calculation, therefore, you may get \
different answers on different occasions. "
}], "Text",
 CellID->27663],

Cell[TextData[{
 "The sequences that you get from ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " are not in most senses \"truly random\", although they should be \"random \
enough\" for practical purposes. The sequences are in fact produced by \
applying a definite mathematical algorithm, starting from a particular \"seed\
\". If you give the same seed, then you get the same sequence. "
}], "Text",
 CellID->15075],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " starts up, it takes the time of day (measured in small fractions of a \
second) as the seed for the pseudorandom number generator. Two different ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions will therefore almost always give different sequences of \
pseudorandom numbers."
}], "Text",
 CellID->24515],

Cell[TextData[{
 "If you want to make sure that you always get the same sequence of \
pseudorandom numbers, you can explicitly give a seed for the pseudorandom \
generator, using ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11521],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SeedRandom",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SeedRandom"], "[", "]"}], Cell[
    "reseed the pseudorandom generator, with the time of day", "TableText"]},
   {
    RowBox[{
     ButtonBox["SeedRandom",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SeedRandom"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "reseed with the integer ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->17969],

Cell["Pseudorandom number generator seed.", "Caption",
 CellID->352059943],

Cell["This reseeds the pseudorandom generator. ", "MathCaption",
 CellID->475],

Cell[BoxData[
 RowBox[{"SeedRandom", "[", "143", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->15615],

Cell["Here are three pseudorandom numbers. ", "MathCaption",
 CellID->20528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->13234],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.11076190588799828`", ",", "0.36456330829732186`", ",", 
   "0.16368057590777751`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->3522702]
}, Open  ]],

Cell["\<\
If you reseed the pseudorandom generator with the same seed, you get the same \
sequence of pseudorandom numbers. \
\>", "MathCaption",
 CellID->905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "143", "]"}], ";", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->9464],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.11076190588799828`", ",", "0.36456330829732186`", ",", 
   "0.16368057590777751`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->222798871]
}, Open  ]],

Cell[TextData[{
 "Every single time ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " is called, the internal state of the pseudorandom generator that it uses \
is changed. This means that subsequent calls to these functions made in \
subsidiary calculations will have an effect on the numbers returned in your \
main calculation. To avoid any problems associated with this, you can \
localize this effect of their use by doing the calculation inside of ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 "."
}], "Text",
 CellID->28962],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BlockRandom",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BlockRandom"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with the current state of the pseudorandom generators localized"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->189708323],

Cell["\<\
Localizing the effects of using RandomInteger, RandomReal or RandomComplex.\
\>", "Caption",
 CellID->193658271],

Cell[TextData[{
 "By localizing the calculation inside ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 ", the internal state of the pseudorandom generator is restored after \
generating the first list. "
}], "MathCaption",
 CellID->14161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RandomReal", "[", "]"}], ",", 
      RowBox[{"RandomReal", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RandomReal", "[", "]"}], ",", 
     RowBox[{"RandomReal", "[", "]"}]}], "}"}]}], "}"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->30524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9523115480664808`", ",", "0.9359100153747634`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9523115480664808`", ",", "0.9359100153747634`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->683706321]
}, Open  ]],

Cell[TextData[{
 "Many applications require random numbers from non\[Hyphen]uniform \
distributions. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has many distributions built into the system. You can give a distribution \
with appropriate parameters instead of a range to ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 "."
}], "Text",
 CellID->200092650],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["RandomInteger",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomInteger"], "[", 
      StyleBox["dist", "TI"], "]"}], Cell[", ", "TableText"], 
     RowBox[{
      ButtonBox["RandomReal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomReal"], "[", 
      StyleBox["dist", "TI"], "]"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a pseudorandom numbers distributed by the random distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["RandomInteger",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomInteger"], "[", 
      RowBox[{
       StyleBox["dist", "TI"], ",", 
       StyleBox["n", "TI"]}], "]"}], Cell[", ", "TableText"], 
     RowBox[{
      ButtonBox["RandomReal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomReal"], "[", 
      RowBox[{
       StyleBox["dist", "TI"], ",", 
       StyleBox["n", "TI"]}], "]"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom numbers distributed by the random distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["RandomInteger",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomInteger"], "[", 
      RowBox[{
       StyleBox["dist", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[
     ", ", "TableText"], 
     RowBox[{
      ButtonBox["RandomReal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomReal"], "[", 
      RowBox[{
       StyleBox["dist", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "1"], "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array of pseudorandom numbers distributed by the random distribution ",
     
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->50146441],

Cell["\<\
Generating pseudorandom numbers with nonuniform distributions.\
\>", "Caption",
 CellID->133927594],

Cell["\<\
This generates 12 integers distributed by the Poisson distribution with mean \
3.\
\>", "MathCaption",
 CellID->94891488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "3", "]"}], ",", " ", "12"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->436452465],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "3", ",", "1", ",", "3", ",", "2", ",", "2", ",", "5", ",", "3", 
   ",", "5", ",", "2", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1478244]
}, Open  ]],

Cell["\<\
This generates a 4 x 4 matrix of real numbers using the standard normal \
distribution.\
\>", "MathCaption",
 CellID->564943878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7707758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.1768108305969855`", ",", 
     RowBox[{"-", "0.7747328100738092`"}], ",", 
     RowBox[{"-", "1.7413882887958045`"}], ",", "1.3577029010295683`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2610033657963857`"}], ",", "0.04082144579334366`", ",", 
     "0.9890216842461395`", ",", "2.80941837263778`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2714623208752773`"}], ",", "1.6303720738509322`", ",", 
     "1.9822087356733484`", ",", "0.40313452124559856`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0072221896821152`", ",", 
     RowBox[{"-", "0.9273794383927393`"}], ",", "0.7473691272799874`", ",", 
     RowBox[{"-", "2.2806522038067127`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{561, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->108152975]
}, Open  ]],

Cell["\<\
This generates five high-precision real numbers distributed normally with \
mean 2 and standard deviation 4.\
\>", "MathCaption",
 CellID->36621593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"2", ",", "4"}], "]"}], ",", " ", "5", ",", " ", 
   RowBox[{"WorkingPrecision", "\[Rule]", "32"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47581551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.789934440710629070106214619509713541677689881699`32."}], 
   ",", 
   RowBox[{"-", "1.160798607040238100988523623175095038606048905503`32."}], 
   ",", "12.042079595098604792470496688452756668308046467905`32.", ",", 
   "2.350865187913115367057223726741757303190973336997`32.", ",", 
   "5.028745244941346304530057781817309320527907232062`32."}], 
  "}"}]], "Output",
 ImageSize->{499, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->568124129]
}, Open  ]],

Cell[TextData[{
 "An additional use of pseudorandom numbers is for selecting from a list. ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " selects with replacement and ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " samples without replacement."
}], "Text",
 CellID->187041389],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomChoice"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", " ", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "choose ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " items at random from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomChoice"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "1"], "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array of values chosen randomly from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomSample",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomSample"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", " ", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     Cell[BoxData[Cell[TextData[{
       "a sample of size ",
       Cell[BoxData[
        StyleBox["n", "TI"]], "InlineFormula"],
       " from ",
       Cell[BoxData[
        StyleBox["list", "TI"]], "InlineFormula"]
      }], "TableText"]]],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->83634220],

Cell["Selecting at random.", "Caption",
 CellID->445195346],

Cell["Choose 10 items at random from the digits 0 through 9:", "MathCaption",
 CellID->697299102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "9"}], "]"}], ",", " ", "10"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->174228928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8", ",", "8", ",", "3", ",", "5", ",", "3", ",", "5", ",", "0", ",", "8", 
   ",", "4", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->10876875]
}, Open  ]],

Cell["\<\
Chances are very high that at least one of the choices was repeated in the \
output. That is because when an element is chosen, it is immediately \
replaced. On the other hand, if you want to select from an actual set of \
elements, there should be no replacement.\
\>", "Text",
 CellID->146491930],

Cell["\<\
Sample 10 items at random from the digits 0 through 9 without replacement. \
The result is a random permutation of the digits.\
\>", "MathCaption",
 CellID->86744191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "9"}], "]"}], ",", " ", "10"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->245345963],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7", ",", "9", ",", "2", ",", "5", ",", "3", ",", "4", ",", "1", ",", "8", 
   ",", "0", ",", "6"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->29112132]
}, Open  ]],

Cell["\<\
Sample 10 items from a set having different frequencies for each digit.\
\>", "MathCaption",
 CellID->318881332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "4",
      ",", "4", ",", "4", ",", "4", ",", "5", ",", "5", ",", "5", ",", "5", 
     ",", "5", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", 
     ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", 
     ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", 
     ",", "8", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", 
     ",", "9", ",", "9", ",", "9"}], "}"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->271187411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6", ",", "6", ",", "7", ",", "8", ",", "9", ",", "7", ",", "2", ",", "2", 
   ",", "9", ",", "9"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->5035261]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->46378034],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pseudorandom Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PiecewiseFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 2.3403748}", "context" -> "", 
    "keywords" -> {
     "initialization", "integers", "internal state", "localization", 
      "Monte Carlo methods", "numbers", "probabilistic calculations", 
      "Pseudorandom numbers", "random", "random numbers", 
      "seeding of random generator", "SeedRandom", "side effects", "state", 
      "RandomState"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica has three functions for generating pseudorandom numbers that \
are distributed uniformly over a range of values. Pseudorandom number \
generation. Generating tables of pseudorandom numbers.", 
    "synonyms" -> {"3.2.4"}, "title" -> "Pseudorandom Numbers", "type" -> 
    "Tutorial", "uri" -> "tutorial/PseudorandomNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.4"->{
  Cell[2525, 70, 82, 2, 70, "Title",
   CellTags->{"S3.2.4", "4.1"},
   CellID->4449]},
 "4.1"->{
  Cell[2525, 70, 82, 2, 70, "Title",
   CellTags->{"S3.2.4", "4.1"},
   CellID->4449]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.4", 39310, 1342},
 {"4.1", 39408, 1346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1900, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2525, 70, 82, 2, 70, "Title",
 CellTags->{"S3.2.4", "4.1"},
 CellID->4449],
Cell[2610, 74, 213, 6, 70, "Text",
 CellID->672691270],
Cell[2826, 82, 4323, 151, 70, "DefinitionBox",
 CellID->19404218],
Cell[7152, 235, 70, 1, 70, "Caption",
 CellID->103623534],
Cell[7225, 238, 2767, 91, 70, "DefinitionBox",
 CellID->811560038],
Cell[9995, 331, 80, 1, 70, "Caption",
 CellID->47517730],
Cell[10078, 334, 88, 1, 70, "MathCaption",
 CellID->113971513],
Cell[CellGroupData[{
Cell[10191, 339, 105, 3, 28, "Input",
 CellID->496771465],
Cell[10299, 344, 159, 5, 36, "Output",
 CellID->368796995]
}, Open  ]],
Cell[10473, 352, 84, 1, 70, "MathCaption",
 CellID->335716811],
Cell[CellGroupData[{
Cell[10582, 357, 103, 3, 70, "Input",
 CellID->6825440],
Cell[10688, 362, 272, 7, 36, "Output",
 CellID->14197523]
}, Open  ]],
Cell[10975, 372, 125, 3, 70, "MathCaption",
 CellID->370888070],
Cell[CellGroupData[{
Cell[11125, 379, 187, 6, 70, "Input",
 CellID->95085604],
Cell[11315, 387, 291, 9, 36, "Output",
 CellID->98317757]
}, Open  ]],
Cell[11621, 399, 103, 2, 70, "MathCaption",
 CellID->481291518],
Cell[CellGroupData[{
Cell[11749, 405, 184, 6, 70, "Input",
 CellID->365332424],
Cell[11936, 413, 587, 19, 54, "Output",
 CellID->888248]
}, Open  ]],
Cell[12538, 435, 374, 12, 70, "Text",
 CellID->113448257],
Cell[12915, 449, 759, 20, 70, "DefinitionBox3Col",
 CellID->19418],
Cell[13677, 471, 87, 1, 70, "Caption",
 CellID->183833217],
Cell[13767, 474, 119, 3, 70, "MathCaption",
 CellID->29560],
Cell[CellGroupData[{
Cell[13911, 481, 148, 4, 70, "Input",
 CellID->15147],
Cell[14062, 487, 215, 6, 36, "Output",
 CellID->179869707]
}, Open  ]],
Cell[14292, 496, 111, 3, 70, "MathCaption",
 CellID->13934966],
Cell[CellGroupData[{
Cell[14428, 503, 337, 10, 70, "Input",
 CellID->412457902],
Cell[14768, 515, 868, 24, 88, "Output",
 CellID->109765432]
}, Open  ]],
Cell[15651, 542, 217, 5, 70, "Text",
 CellID->22361],
Cell[15871, 549, 497, 8, 70, "Text",
 CellID->31754],
Cell[16371, 559, 71, 1, 70, "MathCaption",
 CellID->81600639],
Cell[CellGroupData[{
Cell[16467, 564, 184, 6, 70, "Input",
 CellID->490626066],
Cell[16654, 572, 254, 9, 45, "Output",
 CellID->323981903]
}, Open  ]],
Cell[16923, 584, 256, 9, 70, "MathCaption",
 CellID->43399634],
Cell[CellGroupData[{
Cell[17204, 597, 153, 5, 70, "Input",
 CellID->326120418],
Cell[17360, 604, 162, 5, 36, "Output",
 CellID->258881031]
}, Open  ]],
Cell[17537, 612, 361, 9, 70, "Text",
 CellID->8638],
Cell[17901, 623, 716, 22, 70, "Text",
 CellID->27663],
Cell[18620, 647, 774, 21, 70, "Text",
 CellID->15075],
Cell[19397, 670, 396, 11, 70, "Text",
 CellID->24515],
Cell[19796, 683, 338, 10, 70, "Text",
 CellID->11521],
Cell[20137, 695, 564, 18, 70, "DefinitionBox",
 CellID->17969],
Cell[20704, 715, 74, 1, 70, "Caption",
 CellID->352059943],
Cell[20781, 718, 78, 1, 70, "MathCaption",
 CellID->475],
Cell[20862, 721, 105, 3, 70, "Input",
 CellID->15615],
Cell[20970, 726, 76, 1, 70, "MathCaption",
 CellID->20528],
Cell[CellGroupData[{
Cell[21071, 731, 150, 5, 70, "Input",
 CellID->13234],
Cell[21224, 738, 277, 9, 36, "Output",
 CellID->3522702]
}, Open  ]],
Cell[21516, 750, 159, 4, 70, "MathCaption",
 CellID->905],
Cell[CellGroupData[{
Cell[21700, 758, 213, 7, 70, "Input",
 CellID->9464],
Cell[21916, 767, 279, 9, 36, "Output",
 CellID->222798871]
}, Open  ]],
Cell[22210, 779, 967, 27, 70, "Text",
 CellID->28962],
Cell[23180, 808, 423, 13, 70, "DefinitionBox",
 CellID->189708323],
Cell[23606, 823, 122, 3, 70, "Caption",
 CellID->193658271],
Cell[23731, 828, 319, 9, 70, "MathCaption",
 CellID->14161],
Cell[CellGroupData[{
Cell[24075, 841, 393, 13, 70, "Input",
 CellID->30524],
Cell[24471, 856, 378, 12, 36, "Output",
 CellID->683706321]
}, Open  ]],
Cell[24864, 871, 582, 18, 70, "Text",
 CellID->200092650],
Cell[25449, 891, 2799, 90, 70, "DefinitionBox",
 CellID->50146441],
Cell[28251, 983, 109, 3, 70, "Caption",
 CellID->133927594],
Cell[28363, 988, 131, 4, 70, "MathCaption",
 CellID->94891488],
Cell[CellGroupData[{
Cell[28519, 996, 188, 6, 70, "Input",
 CellID->436452465],
Cell[28710, 1004, 309, 9, 36, "Output",
 CellID->1478244]
}, Open  ]],
Cell[29034, 1016, 138, 4, 70, "MathCaption",
 CellID->564943878],
Cell[CellGroupData[{
Cell[29197, 1024, 222, 7, 70, "Input",
 CellID->7707758],
Cell[29422, 1033, 931, 24, 54, "Output",
 CellID->108152975]
}, Open  ]],
Cell[30368, 1060, 158, 4, 70, "MathCaption",
 CellID->36621593],
Cell[CellGroupData[{
Cell[30551, 1068, 265, 7, 70, "Input",
 CellID->47581551],
Cell[30819, 1077, 557, 14, 71, "Output",
 CellID->568124129]
}, Open  ]],
Cell[31391, 1094, 446, 13, 70, "Text",
 CellID->187041389],
Cell[31840, 1109, 1821, 62, 70, "DefinitionBox",
 CellID->83634220],
Cell[33664, 1173, 59, 1, 70, "Caption",
 CellID->445195346],
Cell[33726, 1176, 97, 1, 70, "MathCaption",
 CellID->697299102],
Cell[CellGroupData[{
Cell[33848, 1181, 195, 6, 70, "Input",
 CellID->174228928],
Cell[34046, 1189, 290, 9, 36, "Output",
 CellID->10876875]
}, Open  ]],
Cell[34351, 1201, 308, 6, 70, "Text",
 CellID->146491930],
Cell[34662, 1209, 176, 4, 70, "MathCaption",
 CellID->86744191],
Cell[CellGroupData[{
Cell[34863, 1217, 195, 6, 70, "Input",
 CellID->245345963],
Cell[35061, 1225, 290, 9, 36, "Output",
 CellID->29112132]
}, Open  ]],
Cell[35366, 1237, 122, 3, 70, "MathCaption",
 CellID->318881332],
Cell[CellGroupData[{
Cell[35513, 1244, 662, 13, 70, "Input",
 CellID->271187411],
Cell[36178, 1259, 289, 9, 36, "Output",
 CellID->5035261]
}, Open  ]],
Cell[CellGroupData[{
Cell[36504, 1273, 71, 1, 70, "RelatedTutorialsSection",
 CellID->46378034],
Cell[36578, 1276, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[36780, 1284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

