(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    315373,      10261]
NotebookOptionsPosition[    271833,       8789]
NotebookOutlinePosition[    278568,       8974]
CellTagsIndexPosition[    277774,       8946]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BlockRandom" :> 
         Documentation`HelpLookup["paclet:ref/BlockRandom"], "RandomChoice" :> 
         Documentation`HelpLookup["paclet:ref/RandomChoice"], "RandomComplex" :> 
         Documentation`HelpLookup["paclet:ref/RandomComplex"], 
         "RandomInteger" :> 
         Documentation`HelpLookup["paclet:ref/RandomInteger"], "RandomPrime" :> 
         Documentation`HelpLookup["paclet:ref/RandomPrime"], "RandomReal" :> 
         Documentation`HelpLookup["paclet:ref/RandomReal"], "RandomSample" :> 
         Documentation`HelpLookup["paclet:ref/RandomSample"], "SeedRandom" :> 
         Documentation`HelpLookup["paclet:ref/SeedRandom"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"BlockRandom\"\>", 2->"\<\"RandomChoice\"\>", 
      3->"\<\"RandomComplex\"\>", 4->"\<\"RandomInteger\"\>", 
      5->"\<\"RandomPrime\"\>", 6->"\<\"RandomReal\"\>", 
      7->"\<\"RandomSample\"\>", 8->"\<\"SeedRandom\"\>", 
      9->"\<\"True\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Random Number Generation", "Title",
 CellID->35748191],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellID->818101596],

Cell["\<\
The ability to generate pseudorandom numbers is important for simulating \
events, estimating probabilities and other quantities, making randomized \
assignments or selections, and numerically testing symbolic results. Such \
applications may require uniformly distributed numbers, nonuniformly \
distributed numbers, elements sampled with replacement, or elements sampled \
without replacements. \
\>", "Text",
 CellID->304003271],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " generate uniformly distributed random numbers. ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " also generate numbers for built\[Hyphen]in distributions. ",
 Cell[BoxData[
  ButtonBox["RandomPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomPrime"]], "InlineFormula"],
 " generates primes within a range. The functions ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " sample from a list of values with or without replacement. The elements may \
have equal or unequal weights. A framework is also included for defining \
additional methods and distributions for random number generation."
}], "Text",
 CellID->160372189],

Cell[TextData[{
 "A sequence of nonrecurring events can be simulated via ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 ". For instance the probability of randomly sampling the integers 1 through \
",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " in order might be simulated."
}], "Text",
 CellID->581426197],

Cell[TextData[{
 "This estimates the probability of getting ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " elements in order for ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " from 2 to 8."
}], "MathCaption",
 CellID->412052567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"trials", " ", "=", " ", 
      RowBox[{"10", "^", "5"}]}], ",", " ", "count", ",", " ", "rn"}], "}"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"count", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"rn", " ", "=", " ", 
       RowBox[{"Range", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"RandomSample", "[", "rn", "]"}], " ", "==", " ", "rn"}], 
          ",", " ", 
          RowBox[{"count", "++"}]}], "]"}], ",", " ", 
        RowBox[{"{", "trials", "}"}]}], "]"}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"n", ",", " ", 
        RowBox[{"N", "[", 
         RowBox[{"count", "/", "trials"}], "]"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"n", ",", " ", "2", ",", " ", "8"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229152018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0.50127`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0.1656`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0.04225`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0.00824`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0.00144`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0.0002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0.00002`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{370, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121819267]
}, Open  ]],

Cell["\<\
The previous results can be compared with the theoretical probabilities.\
\>", "MathCaption",
 CellID->504467739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"N", "[", 
      RowBox[{"1", "/", 
       RowBox[{"i", "!"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385017307],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0.16666666666666666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0.041666666666666664`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0.008333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0.001388888888888889`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0.0001984126984126984`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0.0000248015873015873`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{391, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->790582335]
}, Open  ]],

Cell[TextData[{
 "Random number generation is at the heart of Monte Carlo estimates. An \
estimate of an expected value of a function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " can be obtained by generating values from the desired distribution and \
finding the mean of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " applied to those values."
}], "Text",
 CellID->147703494],

Cell[TextData[{
 "This estimates the 6",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " raw moment for a normal distribution."
}], "MathCaption",
 CellID->386305087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "2"}], "]"}], ",", 
     RowBox[{"10", "^", "6"}]}], "]"}], "^", "6"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->297804824],

Cell[BoxData["961.6116226391528`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->464555124]
}, Open  ]],

Cell["\<\
In this case, the estimate can be compared with an exact result.\
\>", "MathCaption",
 CellID->638918533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "6"}], ",", 
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "2"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->543920759],

Cell[BoxData["960"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->59920938]
}, Open  ]],

Cell["\<\
Random processes can be simulated by generating a series of numbers with the \
desired properties. A random walk can be created by recursively summing \
pseudorandom numbers.\
\>", "Text",
 CellID->12444400],

Cell["Here a random walk starting at 0 is created.", "MathCaption",
 CellID->348667463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"{", "0.", "}"}], ",", 
    RowBox[{"Accumulate", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", "100", "}"}]}], "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->27987070],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxVknlUVGUYh29ICAPIIjDsoKERYCqLbCE/tmGQAQdmhk1To8ZOZMDRjpAp
TImiJWjhQkmGYMoSYSIgSTIRy5DESIAyxWqBCgQjGodEsDq894/uOffc85zn
+73v+33fXZGYEi3VYBhG+u/733fxUfsz/39g+GJaVlbxcMMiamNb/CS/j1ET
GyK9XTreUDBKbAL1F4Wi8pFJYnN0308cNP1kgtga/MDCPlVuP7E90HNt++35
ZuKVwKmxW1OvXaA5HPBHVMt4xXo2vxqOhluSXlAMETvCXsp8V7WzitgJ3W0F
7+n7jFPeBfUazvU/TT4gfhmyayMCZm8TrV+HfJuPZq8fYudfj6uHy3jlrXeJ
XQFFYufYPiWxGxhO6xbuYB/Vc4dwaOGS4y9sPQ+YF+W8JI/uIb8BvfkzV6oP
ThB7gunzNDNRVNN6LygyHd+4VNFF3hsKl4kJgWCE2AdCU65P2zP2fHxxYvTV
NwutlORfwUTYu/1Tnw0T+6GkhhmtC2d5I7CH0zw9oCL2h97Gow5tVo+IgXUj
HmsFyoVFlgHLluQGn/xBA4s+AAldHVsrbJYssiwAkVu5V51Cn1I+EPnGw/fO
iP6kfCDkOpybfvrl5IOgOHuszFBI+5cF4YnCZmjedYZ8MMzd11R9ef0x+WBc
bk6dFWaz9xUCRr9U66vuevIhGOJ4p442VZPnYZf6Q25Q6yh5Hi7z+MqQrDvk
Q+ElyE2eOUfnIQtFpDR9zi6R7c9HqlhkneNL5yHjI5fx7PXzmSYfhka9PFdu
BkP7D8NbV46O3ytYSuezCcNjyoHvDYhlm2Aw5j/VUErrmXA0ur8fvLP4CdUP
xwdmEZlCb03yAqzQ3D6fEc6hvACfy0NqNeZYH4Fa8a9pLRvY+hF4rHfs/AHV
8+Qj4Xmj6OG5KC3ykehO6EhwX8vmN8My/DTP2Z3tvxle81PqkoCHtD8hgm/s
uzvz2+QiQ4gaq5Q8vSN/0Xohcu2WG0VK6b7lQuSXGfk112lQ/SgoLr6duWcH
eURBkmT46JTfczRPFOpaF0rTLGh+eRRy3OprrI6z80ej2NzN4/QZmh/RaDnY
1PdApU35aLRl1a9mlhLLo+HccyujU7iM8iL4pM72WskNKC+CsGWgRGcveZkI
nT2N8wekRpQXYbeBxhGTdwwpLwa/PCT9macx5cWQfPxtUHulHuXFKN1fqXIV
k5eLcX+V5je7dM0oL8FFy+yGtlRiSMAkhxrznJZTXgKr480OAk3qJ5dgqOJ1
7m5nmoeJAW/8QlLXeeqHGHT49h9KkrL3GYOVZ91PhPxO/5M8BofnPh2c12L/
r1g06FZrKW3Z84uFxO527ckUXcrH4k7itI9ON9s/FgGOtrMqXRPKx6FGLa58
aknzIg7T27LtbG+aUj4O6UM/W3N2WFA+Di5NP47u/5o8E4+iZG37NR7mlI/H
33m1Du2rLPAPlJXJeg==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 101.}, {-1.0002100800389466`, 6.3437885761887784`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->35761101]
}, Open  ]],

Cell["\<\
Substitution of random numbers can be used to test the equivalence of \
symbolic expressions. For instance, the absolute difference between two \
expressions could be evaluated at randomly generated points to test for \
inequality of the expressions.\
\>", "Text",
 CellID->2336844],

Cell[TextData[{
 "This provides no evidence that ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}], 
   TraditionalForm]], "InlineMath"],
 " are different for real values."
}], "MathCaption",
 CellID->6039911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", "^", "2"}], "]"}], "-", 
     RowBox[{"Abs", "[", "x", "]"}]}], "/.", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "10000"}], "]"}]}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->657901805],

Cell[BoxData["4.440892098500626`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->188665616]
}, Open  ]],

Cell[TextData[{
 "This provides evidence that ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}], 
   TraditionalForm]], "InlineMath"],
 " differ for at least some complex values."
}], "MathCaption",
 CellID->664779737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", "^", "2"}], "]"}], "-", 
     RowBox[{"Abs", "[", "x", "]"}]}], "/.", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"RandomComplex", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "10"}], "+", 
          RowBox[{"10", "I"}]}], ",", 
         RowBox[{"10", "+", 
          RowBox[{"10", "I"}]}]}], "}"}], ",", "10000"}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->564884648],

Cell[BoxData["14.141503813006864`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->73976611]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomPrime"]], "InlineFormula"],
 " chooses prime numbers with equal probability, which can be useful\
\[LongDash]for instance, to generate large primes for RSA encryption. The \
prime numbers are uniformly distributed on the primes in the range but are \
not uniformly distributed on the entire range because primes are in general \
not uniformly distributed over ranges of positive integers."
}], "Text",
 CellID->619267854],

Cell["\<\
Primes in a given range are generated with equal probability.\
\>", "MathCaption",
 CellID->294127448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Tally", "[", 
    RowBox[{"RandomPrime", "[", 
     RowBox[{"50", ",", 
      RowBox[{"10", "^", "5"}]}], "]"}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->4713915],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{29., 6630.}, {2., 6579.}, {17., 6781.}, {7., 6548.}, {
   31., 6575.}, {13., 6615.}, {41., 6542.}, {3., 6709.}, {5., 6685.}, {23., 
   6884.}, {37., 6699.}, {19., 6716.}, {43., 6788.}, {47., 6570.}, {11., 
   6679.}, {29., 0.}, {2., 0.}, {17., 0.}, {7., 0.}, {31., 0.}, {13., 0.}, {
   41., 0.}, {3., 0.}, {5., 0.}, {23., 0.}, {37., 0.}, {19., 0.}, {43., 0.}, {
   47., 0.}, {11., 0.}, {29., 6630.}, {2., 6579.}, {17., 6781.}, {7., 
   6548.}, {31., 6575.}, {13., 6615.}, {41., 6542.}, {3., 6709.}, {5., 
   6685.}, {23., 6884.}, {37., 6699.}, {19., 6716.}, {43., 6788.}, {47., 
   6570.}, {11., 6679.}}, {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{16, 1}], LineBox[{17, 2}], 
      LineBox[{18, 3}], LineBox[{19, 4}], LineBox[{20, 5}], LineBox[{21, 6}], 
      LineBox[{22, 7}], LineBox[{23, 8}], LineBox[{24, 9}], LineBox[{25, 10}],
       LineBox[{26, 11}], LineBox[{27, 12}], LineBox[{28, 13}], 
      LineBox[{29, 14}], LineBox[{30, 15}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
       45}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{10., 0},
  PlotRange->{{2., 47.}, {0, 6884.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], {Automatic, 
     Scaled[0.02]}}]], "Output",
 ImageSize->{184, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->474415466]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Random Generation Functions", "Section",
 CellID->550376464],

Cell[TextData[{
 "The main functions are ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " generate numbers given some range of numeric values. ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " generate elements from finite sets that may include non-numeric values."
}], "Text",
 CellID->327571373],

Cell[CellGroupData[{

Cell["Random numbers", "Subsection",
 CellID->121480422],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " generates pseudorandom real numbers over a specified range of real values. \
",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " generates pseudorandom integer numbers over a specified range of integer \
values. ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " generates pseudorandom complex numbers over a specified rectangular region \
in the complex plane. ",
 Cell[BoxData[
  ButtonBox["RandomPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomPrime"]], "InlineFormula"],
 " generates prime numbers with equal probability within a range."
}], "Text",
 CellID->369338644],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", "]"}], Cell[TextData[{
     "gives a pseudorandom real number in the range ",
     Cell[BoxData[
      FormBox["0", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "gives a pseudorandom real number in the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "]"}], Cell[TextData[{
     "gives a pseudorandom real number in the range ",
     Cell[BoxData[
      FormBox["0", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[TextData[{
     "gives a random number from the continuous distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     RowBox[{
      StyleBox["domain", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom reals"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     RowBox[{
      StyleBox["domain", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "gives an ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " array of pseudorandom reals"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->199599391],

Cell["Generation of random reals.", "Caption",
 CellID->499117304],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "gives a pseudorandom integer in the range ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "]"}], Cell[TextData[{
     "gives a pseudorandom integer in the range ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["0", "TR"], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", "]"}], Cell[TextData[{
     "pseudorandomly gives ",
     Cell[BoxData[
      FormBox["0", TraditionalForm]], "InlineMath"],
     " or ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     " with probability ",
     Cell[BoxData[
      FormBox[
       FractionBox["1", "2"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[TextData[{
     "gives a pseudorandom integer from the discrete distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     RowBox[{
      StyleBox["domain", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom integers"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     RowBox[{
      StyleBox["domain", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "gives an ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " array of pseudorandom integers"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->531316417],

Cell["Generation of random integers.", "Caption",
 CellID->18316830],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomComplex"], "[", "]"}], Cell[
    "gives a pseudorandom complex number in the unit square ", "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomComplex"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["z", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["z", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "gives a pseudorandom complex number in the rectangle bounded by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomComplex"], "[", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["max", "TI"]], "]"}], Cell[TextData[{
     "gives a pseudorandom complex number in the rectangle bounded by ",
     Cell[BoxData[
      FormBox["0", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomComplex"], "[", 
     RowBox[{
      StyleBox["domain", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom reals"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomComplex"], "[", 
     RowBox[{
      StyleBox["domain", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "gives an ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " array of pseudorandom reals"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->163784474],

Cell["Generation of random complex numbers.", "Caption",
 CellID->230396300],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomPrime"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "gives a pseudorandom prime in the range ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomPrime"], "[", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "]"}], Cell[TextData[{
     "gives a pseudorandom prime in the range ",
     Cell[BoxData[
      FormBox["2", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomPrime"], "[", 
     RowBox[{
      StyleBox["domain", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom primes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomPrime"], "[", 
     RowBox[{
      StyleBox["domain", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "gives an ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " array of pseudorandom primes"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->50986929],

Cell["Generation of random primes.", "Caption",
 CellID->158144565],

Cell[TextData[{
 "When the domain is specified in terms of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " generate uniformly distributed numbers over the specified range. When the \
domain is specified as a distribution, rules defined for the distribution are \
used. Additionally, mechanisms are included for defining ",
 ButtonBox["new methods and distributions",
  BaseStyle->"Hyperlink",
  ButtonData->"Generators"],
 "."
}], "Text",
 CellID->57544653],

Cell["\<\
The two-argument interface provides a convenient way to obtain multiple \
random numbers at once. Even more importantly, there is a significant \
efficiency advantage to generating a large number of pseudorandom numbers at \
once.\
\>", "Text",
 CellID->194525213],

Cell[TextData[{
 "Generation of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "7"], TraditionalForm]], "InlineMath"],
 " numbers between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " takes a fraction of a second."
}], "MathCaption",
 CellID->23172881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"10", "^", "7"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->262773444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7909999999999996`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->289928106]
}, Open  ]],

Cell[TextData[{
 "Generating ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "7"], TraditionalForm]], "InlineMath"],
 " numbers one at a time takes roughly five times as long."
}], "MathCaption",
 CellID->467055495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", "^", "7"}], "}"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->17681284],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.8350000000000004`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->227233802]
}, Open  ]],

Cell[TextData[{
 "For multidimensional arrays with dimensions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
 " through ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "k"], TraditionalForm]], "InlineMath"],
 ", the total number of required pseudorandom numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", 
     StyleBox["total",
      FontSlant->"Italic"]], "=", 
    RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"i", "=", "1"}], "k"], 
     SubscriptBox["n", "i"]}]}], TraditionalForm]], "InlineMath"],
 " is generated and then partitioned. This makes the multidimensional array \
generation as efficient as possible because the total number of random values \
is generated as efficiently as possible and the time required for \
partitioning is negligible."
}], "Text",
 CellID->720297143],

Cell[TextData[{
 "The time required for a ",
 StyleBox["100\[Times]100\[Times]100\[Times]10",
  Deletable->True],
 " array is about the same as for a vector of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "7"], TraditionalForm]], "InlineMath"],
 " numbers."
}], "MathCaption",
 CellID->59971858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"100", ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100", ",", "100", ",", "10"}], "}"}]}], "]"}], 
   ";"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->572904742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2199999999999997`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->392772291]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"100", ",", 
     RowBox[{"10", "^", "7"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->817070028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.22999999999999926`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->614459509]
}, Open  ]],

Cell[TextData[{
 "An array of the same dimensions generated ",
 StyleBox["10",
  Deletable->True],
 " numbers at a time takes several times as long."
}], "MathCaption",
 CellID->277883751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"100", ",", 
       RowBox[{"{", "10", "}"}]}], "]"}], ",", 
     RowBox[{"{", "100", "}"}], ",", 
     RowBox[{"{", "100", "}"}], ",", 
     RowBox[{"{", "100", "}"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->460743089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5409999999999995`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->88679468]
}, Open  ]],

Cell[TextData[{
 "For statistical distributions, the speed advantage of generating many \
numbers at once can be even greater. In addition to the efficiency benefit \
inherited from the uniform number generators used, many statistical \
distributions also benefit from vectorized evaluation of elementary and \
special functions. For instance, ",
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " benefits from vector evaluations of the elementary functions ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 "."
}], "Text",
 CellID->253583730],

Cell[TextData[{
 "Generation of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "5"], TraditionalForm]], "InlineMath"],
 " Weibull numbers takes virtually no time."
}], "MathCaption",
 CellID->562785678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"WeibullDistribution", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"10", "^", "5"}]}], "]"}], "//", "Length"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->186068181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.020000000000000243`", ",", "100000"}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->464155129]
}, Open  ]],

Cell[TextData[{
 "Several seconds are required when ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "5"], TraditionalForm]], "InlineMath"],
 " Weibulls are generated one at a time."
}], "MathCaption",
 CellID->40888985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{"WeibullDistribution", "[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", "^", "5"}], "}"}]}], "]"}], "//", "Length"}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->375117991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.736999999999999`", ",", "100000"}], "}"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->605734433]
}, Open  ]],

Cell["\<\
Random number generation can be useful in exploratory investigations. For \
instance, you might look for occurrences of a random sequence of digits in a \
longer sequence of digits.\
\>", "Text",
 CellID->27291744],

Cell["This converts a list of 5 random decimal digits to a string.", \
"MathCaption",
 CellID->539793375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"digits", " ", "=", " ", 
  RowBox[{"Apply", "[", 
   RowBox[{"StringJoin", ",", " ", 
    RowBox[{"Map", "[", 
     RowBox[{"ToString", ",", " ", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"9", ",", " ", "5"}], "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->27507839],

Cell[BoxData["\<\"64141\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->504529713]
}, Open  ]],

Cell[TextData[{
 "The following converts the first million digits of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " to a string of integers."
}], "MathCaption",
 CellID->23087406],

Cell[BoxData[
 RowBox[{
  RowBox[{"pistring", " ", "=", " ", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{"ToString", ",", 
      RowBox[{
       RowBox[{"RealDigits", "[", 
        RowBox[{"N", "[", 
         RowBox[{"Pi", ",", " ", 
          RowBox[{"10", "^", "6"}]}], "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->5311115],

Cell[TextData[{
 "This gives the positions where the string of digits appear in the first \
million digits of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->57104516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"pistring", ",", "digits"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->333654813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"157883", ",", "157887"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"516599", ",", "516603"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"883250", ",", "883254"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"901136", ",", "901140"}], "}"}]}], "}"}]], "Output",
 ImageSize->{506, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->344878370]
}, Open  ]],

Cell["\<\
Random number generation is also highly useful in estimating distributions \
for which closed form results are not known or known to be computationally \
difficult. Properties of random matrices provide one example.\
\>", "Text",
 CellID->162711575],

Cell["\<\
This estimates the probability a 5\[Times]5 matrix of uniform reals will have \
real eigenvalues.\
\>", "MathCaption",
 CellID->788655758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"count", " ", "=", " ", "0"}], ",", "ev"}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ev", " ", "=", " ", 
        RowBox[{"Eigenvalues", "[", 
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "[", "ev", "]"}], " ", "==", " ", "ev"}], ",", 
         RowBox[{"count", "++"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"10", "^", "5"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"N", "[", 
     RowBox[{"count", "/", 
      RowBox[{"10", "^", "5"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->336476111],

Cell[BoxData["0.11925`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->474207540]
}, Open  ]],

Cell["\<\
The following does the same for a matrix of standard normal numbers.\
\>", "MathCaption",
 CellID->251554530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"count", " ", "=", " ", "0"}], ",", "ev"}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ev", " ", "=", " ", 
        RowBox[{"Eigenvalues", "[", 
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0", ",", "1"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "[", "ev", "]"}], " ", "==", " ", "ev"}], ",", 
         RowBox[{"count", "++"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"10", "^", "5"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"N", "[", 
     RowBox[{"count", "/", 
      RowBox[{"10", "^", "5"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->75476148],

Cell[BoxData["0.03186`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->6851649]
}, Open  ]],

Cell[TextData[{
 "An example of simulating a multivariate distribution is the Gibbs sampler \
used in Bayesian statistics [",
 Cell[BoxData[
  ButtonBox["1",
   BaseStyle->"Hyperlink",
   ButtonData->"GemanGeman"]], "InlineFormula"],
 "]. The Gibbs sampler provides a means by which to simulate values from \
multivariate distributions provided the distributions of each coordinate \
conditional on the other coordinates are known. Under some restrictions, the \
distribution of random vectors constructed by iteratively sampling from the \
conditional distributions will converge to the true multivariate \
distribution."
}], "Text",
 CellTags->"GibbsSampler",
 CellID->665384613],

Cell[TextData[{
 "The following example will construct a Gibbs sampler for an example given \
by Casella and George [",
 Cell[BoxData[
  ButtonBox["2",
   BaseStyle->"Hyperlink",
   ButtonData->"CasellaGeorge"]], "InlineFormula"],
 "]. The distribution of interest is bivariate. The conditional distribution \
of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " given ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " is a binomial, and the conditional distribution of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " given ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is a beta. As Casella and George mention, various strategies for detecting \
convergence and sampling using the Gibbs sampler have been suggested. For \
simplicity, we will assume that convergence will occur within 1000 \
iterations. A sample of size ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " from the distribution will be taken as the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " values following the 1000",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " iteration. It should be noted that these ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " values will, however, be dependent."
}], "Text",
 CellID->380573244],

Cell["\<\
This defines the sampler with a binomial and a beta conditional distribution.\
\
\>", "MathCaption",
 CellID->366968212],

Cell[BoxData[
 RowBox[{
  RowBox[{"sampler", "[", "len_", "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y0", ",", "dist1", ",", "dist2", ",", "y1", ",", "x0"}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"y0", "=", ".5"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dist1", "[", "y_", "]"}], ":=", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"BinomialDistribution", "[", 
        RowBox[{"16", ",", "y"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"dist2", "[", "x_", "]"}], ":=", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"BetaDistribution", "[", 
        RowBox[{
         RowBox[{"x", "+", "2"}], ",", 
         RowBox[{"16", "-", "x", "+", "4"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y1", "=", "y0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x0", "=", 
           RowBox[{"dist1", "[", "y0", "]"}]}], ",", 
          RowBox[{"y0", "=", 
           RowBox[{"dist2", "[", "x0", "]"}]}]}], "}"}]}], ",", 
       RowBox[{"{", "1000", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y1", "=", "y0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x0", "=", 
           RowBox[{"dist1", "[", "y0", "]"}]}], ",", 
          RowBox[{"y0", "=", 
           RowBox[{"dist2", "[", "x0", "]"}]}]}], "}"}]}], ",", 
       RowBox[{"{", "len", "}"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[21]:=",
 CellID->797105472],

Cell[TextData[{
 "A Gibbs sampler could also be defined as a distribution object within the \
distribution framework for random number generation. An example of this \
particular ",
 ButtonBox["Gibbs sampler as a distribution object",
  BaseStyle->"Hyperlink",
  ButtonData->"GibbsSamplerExample"],
 " is provided in the section \"",
 ButtonBox["Defining Distributions\"",
  BaseStyle->"Hyperlink",
  ButtonData->"DefiningDistributions"],
 "."
}], "Text",
 CellID->41013106],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is a sample of length ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->1545858],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"sampler", "[", 
    RowBox[{"10", "^", "4"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->117414021],

Cell["\<\
The following bar chart shows the marginal distribution of the first \
dimension.\
\>", "MathCaption",
 CellID->745678638],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->302575509],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"frqs", "=", 
   RowBox[{"Sort", "[", 
    RowBox[{"Tally", "[", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"frqs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", 
    RowBox[{"10", "^", "4"}]}], ",", 
   RowBox[{"BarLabels", "\[Rule]", 
    RowBox[{"frqs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[24]:=",
 CellID->14011073],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnU9u00AUh6exAxXQJqUUwQZYIUAI9gi2sGKBYIdYVAjRLhAIWCBWPQDi
DIgFF0CcAXEGxBW4Qphn18nzeBKnrk3G9lcpTub/e99vPJ7YM+nD3fd7L17t
vt9/vnvlwdvdN3v7z99duf/6rY2K1oxZ2zPG/Llg7OeJ/ZS85G/fvtKP8z9d
tseBLbBl3yP7Prbv8eG7hM9KriircWJGKj4rp9O3VPxA1TM4DJ9R4UiFTZSY
k/zpfCaexc9iI6fV0wtzZ22fThIvyTGelS36MFZhqWfbw0CHXUabhRbGvhZy
OcrrGDg5TjlhN128Nyen4bSSQ482nLwuz6XqLiu/0Pr1JbVwwy4n8ST2aFTk
59Y08uaQDMWUSuyPy0+F42U1q4W575zPzmV9Xpw7MvPxRI0auZz1M/eNEaqF
Q0sSqid0u+lxc2W03bEio69H3Hkjs2fUWQXlBeX9Kmx6Yws9/ghjeNFT3wgx
8HAsr6nItTHSC2twWZf0Uc16qGPN3NjEhtwcYZme6ObL5gBufNazo8lsbqDD
G3PCeu4g4djDJYvPrvs6nHAxO04pOTwqSdGzFJe2tnQ4v4acoonlntHHVdoN
11GfxD9JXaluU67HHBwcmM1nT7+Z6PatxznLbdjGS9IZOQxtzlypkTe2Wl3+
UjZFl6qpVqdUM7U2SmtkMwwnx+yZ9IJ29YJoWsqcR/u+a6+uaScm+SvuEIU7
oPAOKqIiKqIiKi5V18gmXEStFqh1Y6rS9BlCCsFsoFFwGnEmoRIqHYWW3J25
iTKrV0bN4+6hB3qgB3qgB3qgR4f04DtkSGpwdqAHeqAHeqAHeqAHeqAHeqAH
3wb7qAZnB3qgB3oEpofNgB4r00ORVzt3IL8C8mU7o6SWONtbgEKrUCgu7PHI
xQyUagalAlbKPb8ilApUKXdnqtQqQqFNmNpwFgWiFLsPQ9aLHYMBqsJ3H8hD
HvJ11Dq2CY8h3BDhF5BtnCxP7+ixkIUsZCELWchCFrKQhaxLlu8J9FjIQhay
kIUsZCFbF1lZG/sSmtVoqiddH6YMmaselyC9EIYwhCEMYQjDMBiW7Rxx1+my
2r0G5jE7DAJgPtQxmQiSwh6BGuiuF9eQp0fWKDc/gkgtrAeHdetYe/Y2MANh
5gxDGMIQhtzfD5lgsRfKU6gYbmXc1OxmB1rQgha0oNUaWrJf8yNUVPonaHhp
CAwo0CegAQ1oQAMa0IAGsy76BDSgAQ1ohEyjbK1k7lcYe0JtbIOfUyxxYZ3M
sr8j2gNWX2DUOCN5/LjdNzaFVaxRj0aguVRyMW5fcVeUdZzOnDV1vrV13SbR
l9kM3uIt3rbZ2y7fseqrpniLt3iLt3iLt8wq0BRv8RZv8RZv8bbN3maziuS/
cXfKM63jNaetjeD9Ej2+ttMXtdvkOx7gQU0eVF2/0UJPi09EK6wz6JPf8hj9
ahf8LTz5pkfjdwv9Lvsvx632rv3XUjzAg3o8EAfaaXn72eMBHuABHjTrgfw+
xo/gLf05tTC0K9LMsvDZYSEWYiEW/h8LGanbaaHMCH6t3JLfXguu28PIZo9L
SNbZ5t2OtLXoCUu04H50ozbl7qDKvcTFu8PccGi2yZOKO4HZFDIvbDva3fSu
jEW0VU9b0lSX/KGtvrclK6P+VK4/Weem7sH9rVSTHKJpyWXOsXyJ6m21t+S9
STozl8DQm0MOj46VkiWkMWbtH5la5AI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->745263309]
}, Open  ]],

Cell["\<\
The marginal distribution of the second coordinate can be visualized with a \
histogram.\
\>", "MathCaption",
 CellID->160396599],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Histograms`\>\"", "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->63982111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram", "[", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
   RowBox[{"HistogramScale", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->587414662],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->348404138]
}, Open  ]],

Cell["\<\
Conditional distributions should closely match the assumed binomial and beta \
distributions provided there is enough data for the conditional distribution. \
The greatest amount of data occurs when the densities of the marginal \
distributions are highest, so those values can be used for comparisons. The \
following graphics compare the empirical and assumed conditional \
distributions, using bins of width .05 for estimating probabilities of \
continuous values.\
\>", "Text",
 CellID->51966789],

Cell[TextData[{
 "This compares the empirical and theoretical distributions of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0.3`", "\[LessEqual]", "y", "<", "0.35`"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "MathCaption",
 CellID->125828751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "=", ".3"}], ",", "bcounts", ",", "probs", ",", "cdata"}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cdata", "=", 
     RowBox[{
      RowBox[{"Select", "[", 
       RowBox[{"data", ",", 
        RowBox[{
         RowBox[{"y", "<=", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "<", 
          RowBox[{"y", "+", ".05"}]}], "&"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"bcounts", "=", 
     RowBox[{
      RowBox[{"BinCounts", "[", 
       RowBox[{"cdata", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "17"}], "}"}]}], "]"}], "/", 
      RowBox[{"Length", "[", "cdata", "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"probs", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "-", ".025"}], ",", 
         RowBox[{"PDF", "[", 
          RowBox[{
           RowBox[{"BinomialDistribution", "[", 
            RowBox[{"16", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "16"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Range", "[", 
            RowBox[{"0", ",", "16"}], "]"}], ",", "bcounts"}], "}"}], "]"}], 
        ",", "probs"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->152843925],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWutLFFEUn3ZzjQx6YNDjS1Qfouw/aKk0DYLsgRpFRWaRW6llCvWxp1ZG
Ly1ES7PVSLGnWVRQGVKSZH0po/qyRUElabAQPdjOfezeO3dmZ3fHmZ0xXNiZ
OXfuPed3zz1zzj333qW5JfmbC3JLPHm50xYX5+7I9+TtmpZRVAxFzhGSJLXB
v3iSBM8BeML/tkAA7sprKlydUCGF3h1wd8B9NqWlkbga/SVhIh1d0csA/uG6
0khGEy58jVkC7RToUUOSbxrV1dzo+LEatF1SiAtfNyU6bgk8NzQ2Y/B9EeU9
h96d3Hg66HCi++iAaAkTBSm1qqU7MN3jvV/t3vm4okVyYbTPL94DutS991jF
Y1zirNvVACWVa09JiQKtbIH7J02AawO2smTc4vzOeniuWneacvjm6yMwKA3E
9z4/eiQSf/l/yt7Hrz55f3LBbqDPuIvpe0/mWaA3LTxKe+x7+tq7vgKKbrf3
khb3LnQA2Vx+jbZgtLIF0VGyqiRA8u7lR4bsTddbEfmLR29kyGX1VXqqWT88
fxdnHWgkQ/06vmRfS/l1Snc99RUV3oROSVMF60riekm0wVoNtpfG1Sd0U/Z+
6GVNaonkVv1SXHZEjWyqJqd8g/swfHfzQrgdobGyD17yPierab67Oj2tVmJo
7axl0cK1UNdUdULfYCAsQt1dd4d68QwNlNkrvHQErEHZmLUPUNamlXIokb0S
eya+pizzCCjbGnzwRV3edLy3vSuMFhMCzFvUppaSuUMcUVK69yvFk66BEvpy
s7AK9SXeKOlYe3voF6Guy3GWoFqVHfRBcgscbwka8C2FBdi32ENHy4ZR2BaF
FVZqJx2QxI38xBzOQTMrVJRgD7SyrA8n3soSvgdxRs3P7u8fvCQt140akWNx
OfH4hw4+oNKMRsvirn60PE1Qs4hgDmqIw635p3paO6NEHVy1Ee2YoIWIsXVz
a3vbK8PREvrz5x8DAz+jt2NRp6LOiR33vf/09/cfM+w4DGrOV7gC8tUSeyCU
e3QrpNtDB8Mo7GgPxNeQ6NBxpDlOvkYdBfX6kDNaiYJlU+ZECRI7yw49pFFC
RDHZFKks9jGpyAqnmCINZzs3ULYTnz6u/i+lmDE+8eyD1jye37US5z8moZHN
Zsg6lNb8RqT/T1R8dnBrT720RjcqRBqDhq3R60djvI4gLlzbVvnE+9AmqMh7
v//XB18/Z08q8+HgbqI535mIwFjPpcbd+D7U13XTFUwzpeRkNdIYrCWloe6Z
bH9Bxy4Gjb1q48EwxMo9TwNz56P327ZcQTKN5Aq1+n1f9Oh7aHKVfTU2xTiU
uNpdn5HmR/JTPOrem+0G6sSgjGIaJ2jUY1hTaK/POgxi1mY+BkTOMEqW4pSR
ONqGSVKcQBL7qlNSDOtw+iQEv+iZulvHjoF9XYPhwvbCB8MF71ifQBaujwul
QzvKG2PSavjWOvQR2i8ejD7YioYWl0inNdiZDzUry14Z7hTFdg2ZHXd7t3uu
stlQNK0c/q8D4u693tpB/EbxDBenMC2Fz+MjcJX5Jtw2IcSXco+UQ8UiIfYM
LRbuiYJewmXIRvPk6emYJrn8gwONitMgajKwb3bxJdHphshiK7aRLSdSNko4
inGc7VsWBHj7nsvJr0kt5d4qTuVy+3Jatdi6rFYt5nW0ajGvIkd9jqhjxD9m
pKE1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->205880232]
}, Open  ]],

Cell[TextData[{
 "This compares the empirical and theoretical distributions of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->362504773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "=", "1"}], ",", "bcounts", ",", "probs", ",", "cdata"}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cdata", "=", 
     RowBox[{
      RowBox[{"Select", "[", 
       RowBox[{"data", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "x"}], "&"}]}], "]"}], 
      "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"bcounts", "=", 
     RowBox[{
      RowBox[{"BinCounts", "[", 
       RowBox[{"cdata", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", ".05"}], "}"}]}], "]"}], "/", 
      RowBox[{"Length", "[", "cdata", "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"probs", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y", "-", ".025"}], ",", 
         RowBox[{
          RowBox[{"CDF", "[", 
           RowBox[{
            RowBox[{"BetaDistribution", "[", 
             RowBox[{
              RowBox[{"x", "+", "2"}], ",", 
              RowBox[{"16", "-", "x", "+", "4"}]}], "]"}], ",", "y"}], "]"}], 
          "-", 
          RowBox[{"CDF", "[", 
           RowBox[{
            RowBox[{"BetaDistribution", "[", 
             RowBox[{
              RowBox[{"x", "+", "2"}], ",", 
              RowBox[{"16", "-", "x", "+", "4"}]}], "]"}], ",", 
            RowBox[{"y", "-", ".05"}]}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", "1", ",", ".05"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Range", "[", 
            RowBox[{".025", ",", ".975", ",", ".05"}], "]"}], ",", 
           "bcounts"}], "}"}], "]"}], ",", "probs"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->31028577],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWt1LFFEUH/fD6iWsNIIK/AvqL1gqpKSgHvx8qYfNRLdQ8yNIelp9SMlQ
Sw1lU9evB62oNMuKwExYyYwM0pelkOilJKKHKJPt3rlz54537szcnZmdNXRh
d+eeufec3zn33N8983HSX1NaXOavCRT5M7Or/BdLA0XVmccqqoDInSIIwhj4
1u4RwHEMHInfsVgM/Kt/D4JfF+jghi037AmlgniYrjznRefQB/bYzRgJD10G
5/aJ4w/AXw85IwheCsEuVY9USpu6h0clSefos1cDEW1vJ1OXh9OKFSRbKCQ7
2LoU0cswhcgrzZvWHBnjwBrY9t2cyLTioO6pzgFtBMoMg4f8M4JXSapCt4sR
j3SFXNkPj0NxRSsvgxob0pGmidK3A887fZVTTSOCi+qVTZ1HnvbU9IN2+5mb
uF3dB9ptp2841abty20Rv7Ad/A7BZJX8W4osjJa3L47PoPNrGOfNxHuah37/
+vNucoFP+uPbz8WZKJ/06+fv0fklDamILFWWIpdaCpspeevhy0De4aui5IFT
t+p9V84duUbJn4VfNh+vG2l4wJIHhxvu/wfyExr4iRxlt2peEc+iiRM7MNto
suAhlR3SLCItaJrIKNJGDClPDD2TMlI0biayVFE++nh8EbG+Yq3tZ7Vt8ozd
NvIJJQ+YFOGsjAWyDWIJgENC6kkwmoDjkXjVMSYxnvO2+3OCwHYo65LCtnNR
X3wxf7ekFXKl85533359yNd5vWkqCbYL84eA7aNZoaREnbCCk55XJsWWE1FF
1tBWiz6sKwaIwo3rN4ciYFQXKuttEWcCsRGWW3/YBnLqJBY0j82NJx4lmgaS
eJGF6h6CUqu1fIATGUTiSnCWFeRh9uLHpIyWJ4HYCLepVyW+fvFQ/3bzQ20s
ljCmc0b3ZlSSEXExxPLlr1X+UOAm1wdD+fWI6BKiPXz1ESIr+7TLcZFLJnt0
6+3WbppHiYcyvdiEQn2nTpc56fbWpKGAzeRZtx6DSNe4VI0kE8VgLq47zKOA
WbrNlPXuelxbqNcE3ivdMcU6sOwvqRwU/GFZK9nz7dEalLWYiW3QZgybntjl
iRHnoxIHf6xmvGRT91mM6jpxA9k0s4No2iKSmD18pWlJ9QSR9tWkJY7rlI2+
ftebJ/Fr6e6ake45molHQe6gtHtawTA9Gb1Qcg/ulla0zPY8keonM54M5uG6
R5+ZxbZAVeNxY4VP5Mra4F1m1qpW3ikhVq3We40MS/ZV1iztyqe4ifLACRvi
JpyqlGjHiifjGlUZZrW2RRrjXTdWR/H7ujGQ9fXOSlzKg6wgD3OncX6wGIin
NoxMfzpffAcyK0+eeykrzPvdKhurK3+Xo1908tyG2i8+G/TbI/qcZlG3Zuzj
08t5jzp+K9xVnJEmds7P9T1d824M3yj5ph/XSiHvr/DZSIuj12zvhIR/rWXx
DSxQFWCcejo+Tn8YLm6B+PR6raysRqPLRnj6++YkDjFmAXrHILjJ01w79kyE
jNzTsENniKED+yD2Zb7jxhplXMOETeANq6LvlTDgiA+Ip9Rvfgop/wDJmij6
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->26162976]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbitrary precision reals and complexes", "Subsubsection",
 CellID->242153530],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " generate machine-precision numbers. Arbitrary precision numbers can be \
obtained by setting the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option."
}], "Text",
 CellID->225207923],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision of the arithmetic to use in calculations", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->10755],

Cell[TextData[{
 "Option for ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->6773024],

Cell[TextData[{
 "The option is valid for uniformly distributed reals, complexes, and reals \
from built\[Hyphen]in distributions. ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " can also be incorporated into user\[Hyphen]defined distributions."
}], "Text",
 CellID->704071049],

Cell["Here is a precision-25 real number between 5 and 50.", "MathCaption",
 CellID->169333759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "50"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "25"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->240601987],

Cell[BoxData["47.91955298232309007697518948060133407809`25."], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->32926747]
}, Open  ]],

Cell[TextData[{
 "This gives a precision-50 ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 "\[Hyphen]distributed number."
}], "MathCaption",
 CellID->148798415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "10", "]"}], ",", 
   RowBox[{"WorkingPrecision", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->33623624],

Cell[BoxData["0.\
636572711318560661620155381590239063788365660007223325985913167497`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->207186367]
}, Open  ]],

Cell[TextData[{
 "Increased ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " can be useful in simulations where loss of precision can be expected and \
highly accurate results are necessary. Increased precision can also be used \
to estimate the precision loss in computations."
}], "Text",
 CellID->232500491],

Cell[TextData[{
 "This estimates the worst precision loss in computing ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["J", "1"], TraditionalForm]], "InlineMath"],
 " on the interval [0, 1000]."
}], "MathCaption",
 CellID->278672462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"100", "-", " ", 
  RowBox[{"Precision", "[", 
   RowBox[{"BesselJ", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1000"}], "}"}], ",", " ", "1000", ",", " ", 
       RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[32]:=",
 CellID->14336177],

Cell[BoxData["5.562837054507156`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->18612785]
}, Open  ]],

Cell[TextData[{
 "If the precision of the input is less than the specified ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ", the function will warn of the problem. The precision of the input will \
then be artificially increased to generate a pseudorandom number of the \
desired precision."
}], "Text",
 CellID->505338692],

Cell["\<\
A warning is generated because the machine number 7.5 has precision less than \
50.\
\>", "MathCaption",
 CellID->687639791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{
   RowBox[{"7.5", "+", "I"}], ",", 
   RowBox[{"WorkingPrecision", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->357745337],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomComplex", "::", "\<\"precw\"\>"}], ":", 
  " ", "\<\"The precision of the argument function (\\!\\({0, \
\\(\\(\\(\\(7.5` \[InvisibleSpace]\\)\\) + \[ImaginaryI]\\)\\)}\\)) is less \
than WorkingPrecision (\\!\\(50.`\\)). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/precw\\\", \
ButtonNote -> \\\"RandomComplex::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[33]:=",
 CellID->97442093],

Cell[BoxData[
 RowBox[{"6.\
3710920570099177598371192096170516471502712289510239215856255662985`50.", "+",
   
  RowBox[{
  "0.3415155440874674092495402823520279668684049000922251110946207919982`50.",
    " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->475092171]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " is not an option for ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ". Integers have infinite precision, so the precision is completely \
specified by the function name."
}], "Text",
 CellID->903130573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " is not meaningful for pseudorandom integers."
}], "MathCaption",
 CellID->478798666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"10", ",", 
   RowBox[{"WorkingPrecision", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->37282039],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomInteger", "::", "\<\"array\"\>"}], ":", 
  " ", "\<\"The array dimensions \\!\\(WorkingPrecision \[Rule] 50\\) given \
in position 2 of \\!\\(RandomInteger[\\(\\(10, \\(\\(WorkingPrecision \[Rule] \
50\\)\\)\\)\\)]\\) should be a list of non-negative machine-sized integers \
giving the dimensions for the result.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[34]:=",
 CellID->12045576],

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"10", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->30664504]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Random elements", "Subsection",
 CellID->58746613],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " generate pseudorandom selections from a list of possible elements. The \
elements can be numeric or nonnumeric. "
}], "Text",
 CellID->292179951],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomChoice"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "gives a pseudorandom choice of one of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomChoice"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom choices from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomChoice"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "gives ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " pseudorandom choices from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomChoice"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "gives a pseudorandom choice weighted by the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomChoice"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["wlist", "TI"], "->", 
       StyleBox["elist", "TI"]}], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " weighted choices"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomChoice"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["wlist", "TI"], "->", 
       StyleBox["elist", "TI"]}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "gives an array of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " array of weighted choices"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->51762611],

Cell["Random choice from a list.", "Caption",
 CellID->621329494],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomSample",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomSample"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a pseudorandom sample of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomSample",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomSample"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["w", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["w", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
      StyleBox["n", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "gives a pseudorandom sample of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " chosen using weights ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomSample",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomSample"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "gives a pseudorandom permutation of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomSample",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomSample"], "[", 
     RowBox[{
      StyleBox["wlist", "TI"], "->", 
      StyleBox["elist", "TI"]}], "]"}], Cell[TextData[{
     "gives a pseudorandom permutation of ",
     Cell[BoxData[
      StyleBox["elist", "TI"]], "InlineFormula"],
     " using initial weights ",
     Cell[BoxData[
      StyleBox["wlist", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->728594466],

Cell["Random sample from a list.", "Caption",
 CellID->89076591],

Cell[TextData[{
 "The main difference between ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " is that ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " selects from the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " with replacement, while ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " samples without replacement. The number of elements chosen by ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " is not limited by the number of elements in ",
 Cell[BoxData[
  StyleBox["elist", "TI"]], "InlineFormula"],
 ", and an element ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " may be chosen more than once. The size of a sample returned by ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " is limited by the number of elements in ",
 Cell[BoxData[
  StyleBox["elist", "TI"]], "InlineFormula"],
 ", and the number of occurrences of a distinct element in that sample is \
limited by the number of occurrences of that element in ",
 Cell[BoxData[
  StyleBox["elist", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->36845972],

Cell[TextData[{
 " If the first argument to ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " is a list, elements are selected with equal probability. The weight \
specification defines a distribution on the set of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "s. The weights must be positive, but need not sum to 1. For weights ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["w", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["w", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 " the probability of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in the initial distribution is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["w", "i"], "/", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "1"}], "n"], 
     SubscriptBox["w", "j"]}]}], TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " samples without replacement, weights are updated internally based on the \
total remaining weight after each selection."
}], "Text",
 CellID->114762515],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " can be used for simulation of independent identically distributed events \
with a finite list of possible outcomes."
}], "Text",
 CellID->285987478],

Cell["This gives 15 simulated fair coin tosses.", "MathCaption",
 CellID->289943446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<heads\>\"", ",", "\"\<tails\>\""}], "}"}], ",", "15"}], 
  "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->143648604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"heads\"\>", ",", "\<\"heads\"\>", ",", "\<\"heads\"\>", 
   ",", "\<\"heads\"\>", ",", "\<\"tails\"\>", ",", "\<\"heads\"\>", 
   ",", "\<\"tails\"\>", ",", "\<\"tails\"\>", ",", "\<\"tails\"\>", 
   ",", "\<\"tails\"\>", ",", "\<\"heads\"\>", ",", "\<\"tails\"\>", 
   ",", "\<\"heads\"\>", ",", "\<\"heads\"\>", ",", "\<\"tails\"\>"}], 
  "}"}]], "Output",
 ImageSize->{377, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->345714348]
}, Open  ]],

Cell["This gives 20 rolls of a die loaded toward 5s.", "MathCaption",
 CellID->249515450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     ".15", ",", ".1", ",", ".15", ",", ".15", ",", ".3", ",", ".15"}], "}"}],
     "->", 
    RowBox[{"Range", "[", "6", "]"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->140180825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "5", ",", "5", ",", "5", ",", "1", ",", "3", ",", "4", 
   ",", "5", ",", "5", ",", "1", ",", "6", ",", "3", ",", "2", ",", "4", ",", 
   "6", ",", "6", ",", "1", ",", "6", ",", "5"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->364941046]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " can be used to generate observations from any discrete distribution with \
finite support."
}], "Text",
 CellID->858556433],

Cell[TextData[{
 "The following generates a random observation from a discrete analog of a ",
 Cell[BoxData[
  ButtonBox["TriangularDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TriangularDistribution"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->788996469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "5", ",", "3", ",", "1"}], "}"}], "->", 
   RowBox[{"Range", "[", 
    RowBox[{"4", ",", "8"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->434722153],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->30289803]
}, Open  ]],

Cell["Here is the empirical PDF for 1000 simulated points.", "MathCaption",
 CellID->121017815],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->102541292],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"frqs", "=", 
   RowBox[{"Tally", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "5", ",", "3", ",", "1"}], "}"}], "->", 
       RowBox[{"Range", "[", 
        RowBox[{"4", ",", "8"}], "]"}]}], ",", "1000"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"frqs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "100"}], ",", 
   RowBox[{"BarLabels", "\[Rule]", 
    RowBox[{"frqs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[39]:=",
 CellID->24566967],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM1u00AQ3tT5oQIBR465lV5KJFrgACG9tKdwQaqEEIcoQkoOCJTmAfIC
CCTegefiTdId/yT2xI7Xrp2dNV+UOJ7dzHzfjmfXnl0748ly9vXbZDmfTvrX
i8mP2Xx627/6vtBFXkup1kwp9e+Z0vtrved/6DXXn2A3e+9Cbz2t8J4kL9Jc
+/KRFkfh9yWrP/G137DSt0we0qa9lVVKycjI8rs0OccylVDB85IWIx/EfaO3
6tT/fhXzELez8Wiqva1+Pv5+byYtvg6lYcggOnbRr9KP4VNWSpubnBrlha6I
dmO/IqROtmaCf3unRe17adL3p4BWQZyHvrxarb58/qvfakAbksP6R0b1L84+
1lmPVrnUqlgf6a6DHsj7hRst4eOAO6yJtDts3fQxWIM1eiFYg7Vs1uiFYA3W
YI2xA6yrz3Djs0Aku5vtJuceeqwNRw1tU0eLxw1pi+vHh/pNU/oPb4P7c3m9
8Oi42RI3zzS4BgFrd1i/1OITkew+bFhJ6E1bNjJ9BFZ+NOtq+0x+HzRyt2h2
2gjUZqIidutADS7FoxfPAG1kUgEvzsRPIqze2VCE1yFmBJrgJ/Da9EMBd7zY
Hv0wwgMVUQRUCaiIIqC6iorYreUKLTNTsrVmm35F22XyoVf1zFnZy5Jk+ogC
TE4c8TzIfl5ka/UQIytQ3UdF7AIVUQTU/xcVsVsHalvUulGUpcUEAbP70laN
dp47F+InqbykPWUtcc0IoytQXUVF7AIVUQRUA1StSDd1DtidnfWgjiuNzeqs
Vc+RZxFZayqEdq6VHxtZTWYDec87/TKyWXQtwcwqv/Ll7Y7WS36WskZymjfN
uBV7KsnQpsG8vpklHo/mWqRUN0ZTteA7eEG27zxl9v965cbn/JkJu3bj42sn
1ab52aT4PbOWfbpnPsT1qG6yFnwHL8j2HT+nZGUp1V3zS7EaP588SLFY/myS
dddTudZyufwZBFmJe1pN9x09Hf8n0VqqyvvH6TI1qnUHsM1ZjA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->53954305]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " can be used to simulate observations from a finite set of outcomes in \
which each element in the list of outcomes can only be observed once. There \
may be more than one occurrence of distinct values in the list."
}], "Text",
 CellID->304375186],

Cell["\<\
This simulates 7 draws from a container of 80 blue and 45 red objects.\
\>", "MathCaption",
 CellID->30493468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"\"\<blue\>\"", ",", 
       RowBox[{"{", "80", "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<red\>\"", ",", 
       RowBox[{"{", "45", "}"}]}], "]"}]}], "]"}], ",", "7"}], "]"}]], "Input",\

 CellLabel->"In[41]:=",
 CellID->225414954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"blue\"\>", ",", "\<\"blue\"\>", ",", "\<\"blue\"\>", 
   ",", "\<\"blue\"\>", ",", "\<\"blue\"\>", ",", "\<\"blue\"\>", 
   ",", "\<\"blue\"\>"}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->615494329]
}, Open  ]],

Cell["\<\
Randomly sampling all elements in the list results in a random permutation.\
\>", "Text",
 CellID->150965768],

Cell["\<\
The following is a random permutation of the integers from 1 to 10.\
\>", "MathCaption",
 CellID->96620109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->15101454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "2", ",", "10", ",", "1", ",", "6", ",", "3", ",", "8", ",", "9", 
   ",", "7", ",", "5"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->657626359]
}, Open  ]],

Cell["\<\
Assigning weights to the elements results in a random permutation in which \
values with greater weight tend to appear earlier in the permutation than \
values with lesser weight.\
\>", "Text",
 CellID->249698174],

Cell["\<\
Here is a random permutation weighted by the squares of the data values.\
\>", "MathCaption",
 CellID->53608588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Range", "[", "10", "]"}], "^", "2"}], "->", 
   RowBox[{"Range", "[", "10", "]"}]}], "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->430551292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9", ",", "10", ",", "6", ",", "7", ",", "5", ",", "4", ",", "8", ",", "2", 
   ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->230374885]
}, Open  ]],

Cell[TextData[{
 "For the same list of weighted or unweighted elements, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["RandomSample",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RandomSample"], "[", 
    RowBox[{"#", ",", "1"}], "]"}], "&"}]], "InlineFormula"],
 " is distributionally equivalent to ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 "."
}], "Text",
 CellID->185433750],

Cell[TextData[{
 "This gives an empirical ",
 "PDF",
 " for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "5"], TraditionalForm]], "InlineMath"],
 " random samples of size 1."
}], "MathCaption",
 CellID->212208469],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Range", "[", "10", "]"}]}], ";"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->90390730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tallies", "=", 
  RowBox[{"Tally", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomSample", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "^", "2"}], "->", "data"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", "^", "5"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[45]:=",
 CellID->570447660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "3", "}"}], ",", "2420"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "4", "}"}], ",", "4314"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "10", "}"}], ",", "26091"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "7", "}"}], ",", "12508"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "9", "}"}], ",", "21109"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "8", "}"}], ",", "16509"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", "1029"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "5", "}"}], ",", "6336"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "6", "}"}], ",", "9406"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", "278"}], "}"}]}], "}"}]], "Output",
 ImageSize->{469, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->37238496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sort", "[", "tallies", "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", 
  RowBox[{"10", "^", "5."}]}]], "Input",
 CellLabel->"In[46]:=",
 CellID->786725747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0027800000000000004`", ",", "0.01029`", ",", "0.024200000000000003`", 
   ",", "0.043140000000000005`", ",", "0.06336`", ",", "0.09406`", ",", 
   "0.12508`", ",", "0.16509000000000001`", ",", "0.21109000000000003`", ",", 
   "0.26091000000000003`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]=",
 CellID->315996589]
}, Open  ]],

Cell[TextData[{
 "Here is an empirical distribution for a distributionally equivalent ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->572764500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"Tally", "[", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "^", "2"}], "->", "data"}], ",", 
       RowBox[{"10", "^", "5"}]}], "]"}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", 
  RowBox[{"10", "^", "5."}]}]], "Input",
 CellLabel->"In[47]:=",
 CellID->1016772110],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0025800000000000003`", ",", "0.010110000000000001`", ",", "0.02324`", 
   ",", "0.041100000000000005`", ",", "0.06343`", ",", "0.09369000000000001`",
    ",", "0.12762`", ",", "0.16485000000000002`", ",", "0.21333000000000002`",
    ",", "0.26005`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->666116691]
}, Open  ]],

Cell["\<\
The probabilities for the two examples are very close to each other and to \
the theoretical values.\
\>", "Text",
 CellID->7293204],

Cell["These are the theoretical probabilities.", "MathCaption",
 CellID->126671741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"data", "^", "2"}], "/", 
   RowBox[{"Total", "[", 
    RowBox[{"data", "^", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->168972178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0025974025974025974`", ",", "0.01038961038961039`", ",", 
   "0.023376623376623377`", ",", "0.04155844155844156`", ",", 
   "0.06493506493506493`", ",", "0.09350649350649351`", ",", 
   "0.12727272727272726`", ",", "0.16623376623376623`", ",", 
   "0.21038961038961038`", ",", "0.2597402597402597`"}], "}"}]], "Output",
 ImageSize->{410, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->552655746]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " can also be used for random assignments to groups, such as in clinical \
trials. The following uses integers, but other identifying values such as \
name or identification number could be used instead."
}], "Text",
 CellID->910762301],

Cell["\<\
The following randomly places 20 elements into four groups of equal size.\
\>", "MathCaption",
 CellID->615358382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"RandomSample", "[", 
    RowBox[{"Range", "[", "20", "]"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->29010796],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "11", ",", "14", ",", "9", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "10", ",", "15", ",", "3", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "7", ",", "4", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "1", ",", "13", ",", "5", ",", "12"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->1301043]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " can be affected by changes to the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 ". Built-in methods are described ",
 ButtonBox["here",
  BaseStyle->"Hyperlink",
  ButtonData->"Methods"],
 ". Additionally, mechanisms for defining new methods are described ",
 ButtonBox["here",
  BaseStyle->"Hyperlink",
  ButtonData->"Generators"],
 "."
}], "Text",
 CellID->3684708]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seeding and Localization", "Section",
 CellID->8730447],

Cell["\<\
Pseudorandom number generators algorithmically create numbers that have some \
apparent level of randomness. Methods for pseudorandom number generation \
typically use a recurrence relation to generate a number from the current \
state and to establish a new state from which the next number will be \
generated. The state can be set by seeding the generator with an integer that \
will be used to initialize the recurrence relation in the algorithm.\
\>", "Text",
 CellID->62375196],

Cell["\<\
Given an initial starting point, called a seed, pseudorandom number \
generators are completely deterministic. In many cases it is desirable to \
locally or globally set the seed for a random number generator to obtain a \
constant sequence of \"random\" values. If set globally, the seed will affect \
future pseudorandom numbers unless a new seed is explicitly set. If set \
locally, the seed will only affect random number and element generation \
within the localized code.\
\>", "Text",
 CellID->75837341],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BlockRandom",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BlockRandom"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all pseudorandom generators localized"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SeedRandom",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SeedRandom"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "resets the pseudorandom generator using ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " as a seed"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SeedRandom",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SeedRandom"], "[", "]"}], Cell[TextData[{
     "resets the generator using as a seed the time of day and certain \
attributes of the current ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->137389150],

Cell["Localization and seeding functions.", "Caption",
 CellID->54750400],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " function provides a means by which to seed the random generator. Used on \
its own, ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " will globally set the seed for random generators. The ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " function provides a means by which to locally set or change the seed for \
random generators without affecting the global state."
}], "Text",
 CellID->276243315],

Cell["The following seeds the random generator globally.", "MathCaption",
 CellID->388157339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "1", "]"}], ";", 
    RowBox[{"RandomReal", "[", "]"}]}], ",", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "1", "]"}], ";", 
    RowBox[{"RandomReal", "[", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->202704636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8173894901710712`", ",", "0.8173894901710712`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->200703061]
}, Open  ]],

Cell[TextData[{
 "The following gives two different numbers because the first ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " is generated within ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 ", while the second is generated outside of ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 "."
}], "Text",
 CellID->34088934],

Cell[TextData[{
 "The second ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " is not generated using the seed 1."
}], "MathCaption",
 CellID->10768640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1", "]"}], ";", 
     RowBox[{"RandomReal", "[", "]"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"BlockRandom", "[", 
     RowBox[{"SeedRandom", "[", "1", "]"}], "]"}], ";", 
    RowBox[{"RandomReal", "[", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->157868588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8173894901710712`", ",", "0.11141961113123644`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]=",
 CellID->628293208]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " also provides the mechanism for switching the random generator."
}], "Text",
 CellID->274001164],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to be seeded and used", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->340545550],

Cell[TextData[{
 "Option for ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->71473729],

Cell[TextData[{
 "An individual generator can be seeded directly by specifying that generator \
via the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option. All generators can be seeded by setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->163988397],

Cell[TextData[{
 "Here the default generator is seeded with ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", but the ",
 Cell[BoxData["\"\<Rule30CA\>\""], "InlineFormula"],
 " generator is not."
}], "MathCaption",
 CellID->41158855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "1", "]"}], ";", "\[IndentingNewLine]", 
   RowBox[{"SeedRandom", "[", 
    RowBox[{"Method", "->", "\"\<Rule30CA\>\""}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"RandomReal", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->129589009],

Cell[BoxData["0.1642766023875113`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->86779841]
}, Open  ]],

Cell[TextData[{
 "Seeding the ",
 Cell[BoxData["\"\<Rule30CA\>\""], "InlineFormula"],
 " generator with ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " gives a different random number."
}], "MathCaption",
 CellID->297828284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Method", "->", "\"\<Rule30CA\>\""}]}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"RandomReal", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->104339044],

Cell[BoxData["0.46344995680092915`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->41871844]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Methods", "Section",
 CellTags->"Methods",
 CellID->185956823],

Cell[TextData[{
 "Five pseudorandom generator methods are available on all systems. A sixth \
platform\[Hyphen]dependent method is available on Intel\[Hyphen]based \
systems. A framework for defining new methods, described in the section \"",
 ButtonBox["Defining Your Own Generator\"",
  BaseStyle->"Hyperlink",
  ButtonData->"Generators"],
 ", is also included."
}], "Text",
 CellID->144094561],

Cell[BoxData[GridBox[{
   {"\"\<Congruential\>\"", Cell["\<\
linear congruential generator (low\[Hyphen]quality randomness)\
\>", "TableText"]},
   {"\"\<ExtendedCA\>\"", Cell[
    "extended cellular automaton generator (default)", "TableText"]},
   {"\"\<Legacy\>\"", Cell[TextData[{
     "default generators prior to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " 6.0"
    }], "TableText"]},
   {"\"\<MersenneTwister\>\"", Cell[
    "Mersenne Twister shift register generator", "TableText"]},
   {"\"\<MKL\>\"", Cell["\<\
Intel MKL generator (Intel\[Hyphen]based systems)\
\>", "TableText"]},
   {"\"\<Rule30CA\>\"", Cell["Wolfram rule 30 generator", "TableText"]}
  }]], "DefinitionBox",
 CellID->154028361],

Cell["Built-in methods.", "Caption",
 CellID->19627742],

Cell["\<\
This gives pseudorandom integers from each method with seed 2020.\
\>", "MathCaption",
 CellID->179875953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BlockRandom", "[", 
     RowBox[{
      RowBox[{"SeedRandom", "[", 
       RowBox[{"2020", ",", 
        RowBox[{"Method", "->", "#"}]}], "]"}], ";", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"10", "^", "20"}], "]"}]}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Congruential\>\"", ",", "\"\<ExtendedCA\>\"", ",", "\"\<Legacy\>\"", 
     ",", "\"\<MersenneTwister\>\"", ",", "\"\<MKL\>\"", ",", 
     "\"\<Rule30CA\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->43803727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "55649265348960921658", ",", "459120772313493841", ",", 
   "50876346696796959169", ",", "77391724740010742551", ",", 
   "58128025990681059425", ",", "74027343124503736203"}], "}"}]], "Output",
 ImageSize->{499, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->418438995]
}, Open  ]],

Cell["This gives pseudorandom reals from the same seed.", "MathCaption",
 CellID->95050898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BlockRandom", "[", 
     RowBox[{
      RowBox[{"SeedRandom", "[", 
       RowBox[{"2020", ",", 
        RowBox[{"Method", "->", "#"}]}], "]"}], ";", 
      RowBox[{"RandomReal", "[", "]"}]}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Congruential\>\"", ",", "\"\<ExtendedCA\>\"", ",", "\"\<Legacy\>\"", 
     ",", "\"\<MersenneTwister\>\"", ",", "\"\<MKL\>\"", ",", 
     "\"\<Rule30CA\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->163023894],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6885470449642679`", ",", "0.0031111233673468686`", ",", 
   "0.8748933457418365`", ",", "0.5244267255969988`", ",", 
   "0.39389084450043427`", ",", "0.50162878899323`"}], "}"}]], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->353711008]
}, Open  ]],

Cell[CellGroupData[{

Cell["Congruential", "Subsection",
 CellID->163245837],

Cell[TextData[{
 Cell[BoxData["\"\<Congruential\>\""], "InlineFormula"],
 " uses a linear congruential generator. This is one of the simplest types of \
pseudorandom number generators, with pseudorandom numbers between 0 and 1 \
obtained from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "i"], "/", "m"}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " is given by the modular recurrence relation"
}], "Text",
 CellID->58803267],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["x", "i"], "\[Congruent]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "\[InvisibleTimes]", 
       SubscriptBox["x", 
        RowBox[{"i", "-", "1"}]]}], "+", "c"}], ")"}], " ", "mod", " ", 
    "m"}]}], TraditionalForm]], "DisplayMath",
 CellID->34758699],

Cell[TextData[{
 "for some fixed integers ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " called the multiplier, increment, and modulus respectively. If the \
increment is 0, the generator is a multiplicative congruential generator. The \
values of ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " can be set via options to the ",
 Cell[BoxData["\"\<Congruential\>\""], "InlineFormula"],
 " method."
}], "Text",
 CellID->54158622],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"\"\<Bits\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
specify range of bits to use for numbers constructed from bits\
\>", "TableText"]},
   {"\"\<Multiplier\>\"", "1283839219676404755", Cell[
    "multiplier value", "TableText"]},
   {"\"\<Increment\>\"", "0", Cell["increment value", "TableText"]},
   {"\"\<Modulus\>\"", "2305843009213693951", Cell[
    "modulus value", "TableText"]},
   {"\"\<ConvertToRealsDirectly\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether reals should be constructed directly from the congruence relation\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.35], 
     Scaled[0.3], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->113304678],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " ",
 Cell[BoxData["\"\<Congruential\>\""], "InlineFormula"],
 "."
}], "Caption",
 CellID->326368191],

Cell[TextData[{
 "Linear congruential generators are periodic and tend to give a lower \
quality of randomness, especially when a large number of random values is \
needed. If reals are generated directly from the congruence relation, the \
period is less than or equal to ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->11228194],

Cell[TextData[{
 "The default option values are chosen to have a large period and for 64-bit \
efficiency. With the default options, the ",
 Cell[BoxData["\"\<Congruential\>\""], "InlineFormula"],
 " generator passes many standard tests of randomness despite the inherent \
issues with congruential number generators."
}], "Text",
 CellID->256112524],

Cell["\<\
This generates 40 numbers from a multiplicative congruential generator.\
\>", "MathCaption",
 CellID->18625225],

Cell[BoxData[
 RowBox[{
  RowBox[{"lcdata", "=", 
   RowBox[{"BlockRandom", "[", 
    RowBox[{
     RowBox[{"SeedRandom", "[", 
      RowBox[{"1", ",", 
       RowBox[{"Method", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<Congruential\>\"", ",", 
          RowBox[{"\"\<Multiplier\>\"", "->", "11"}], ",", 
          RowBox[{"\"\<Increment\>\"", "->", "0"}], ",", 
          RowBox[{"\"\<Modulus\>\"", "->", "63"}]}], "}"}]}]}], "]"}], ";", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", "40"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[56]:=",
 CellID->99631247],

Cell["\<\
The period of a multiplicative congruential generator is bounded above by the \
number of positive integers less than or equal to the modulus that are \
relatively prime to the modulus. This upper bound is Euler's totient function \
of the modulus.\
\>", "Text",
 CellID->4944471],

Cell["With a modulus of 63, the period of the cycle is at most 36.", \
"MathCaption",
 CellID->76394543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerPhi", "[", "63", "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->708581332],

Cell[BoxData["36"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->345955459]
}, Open  ]],

Cell[TextData[{
 "The actual period can be determined by finding the smallest integer ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 "\[Congruent] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["b", "i"], "\[InvisibleTimes]"}], TraditionalForm]], 
  "InlineMath"],
 " mod ",
 StyleBox["m.",
  FontSlant->"Italic"]
}], "Text",
 CellID->555465810],

Cell["The period with multiplier 11 and modulus 63 is 6.", "MathCaption",
 CellID->408465059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Range", "[", "36", "]"}], ",", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"11", "^", "#"}], ",", "63"}], "]"}], "===", "1"}], "&"}], 
     ")"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->180997701],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->152187528]
}, Open  ]],

Cell["\<\
Partitioning the data into sets of 6 elements shows the recursion.\
\>", "MathCaption",
 CellID->421180804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"lcdata", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[59]:=",
 CellID->63714427],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.1746031746031746`", ",", "0.9206349206349206`", ",", 
     "0.12698412698412698`", ",", "0.3968253968253968`", ",", 
     "0.36507936507936506`", ",", "0.015873015873015872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1746031746031746`", ",", "0.9206349206349206`", ",", 
     "0.12698412698412698`", ",", "0.3968253968253968`", ",", 
     "0.36507936507936506`", ",", "0.015873015873015872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1746031746031746`", ",", "0.9206349206349206`", ",", 
     "0.12698412698412698`", ",", "0.3968253968253968`", ",", 
     "0.36507936507936506`", ",", "0.015873015873015872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1746031746031746`", ",", "0.9206349206349206`", ",", 
     "0.12698412698412698`", ",", "0.3968253968253968`", ",", 
     "0.36507936507936506`", ",", "0.015873015873015872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1746031746031746`", ",", "0.9206349206349206`", ",", 
     "0.12698412698412698`", ",", "0.3968253968253968`", ",", 
     "0.36507936507936506`", ",", "0.015873015873015872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1746031746031746`", ",", "0.9206349206349206`", ",", 
     "0.12698412698412698`", ",", "0.3968253968253968`", ",", 
     "0.36507936507936506`", ",", "0.015873015873015872`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{424, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[59]=",
 CellID->725704780]
}, Open  ]],

Cell["\<\
The distinct numbers can also be seen graphically by plotting a sequence of \
generated numbers.\
\>", "Text",
 CellID->613768652],

Cell["\<\
Here is a plot of 1000 values from the congruential generator.\
\>", "MathCaption",
 CellID->1136747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"BlockRandom", "[", 
   RowBox[{
    RowBox[{"SeedRandom", "[", 
     RowBox[{"1", ",", 
      RowBox[{"Method", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Congruential\>\"", ",", 
         RowBox[{"\"\<Multiplier\>\"", "->", "11"}], ",", 
         RowBox[{"\"\<Increment\>\"", "->", "0"}], ",", 
         RowBox[{"\"\<Modulus\>\"", "->", "63"}]}], "}"}]}]}], "]"}], ";", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", "1000"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->142718018],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV0tLAzEQTptNtwpqfRwEPXjz8R/Egy8QigfxcVCwiqAH8fkjRPRqFRRU
VBCvolfBi568evaPrEmajdnZbDdb2d1uaTOZ5JuddGbyTVuuHG5ubFcOt9Yr
A9P7ld3NrfWDgamdfbqEcwihZ/rZ60V07tAZ/zw7DpX+cZCOFgXkqcxTiYXs
Zrtsw3FfcFfVXdkVsN5JJdZ4USVCQ2wkNZ9y5DYI63U2LXlPamDRwYaCamFm
196gXUekE7o6S2SOSb42HPlbtovMIlueNTCuWY3KiIGF76xwP+Ts/4kNs8tH
9ZNwTBo5I46AT7M+BhPKG+cgInXDyKcZmSFHz8T1eb9HiYsp7wfx/R/vq/2o
BL7rTZ3VNjpeI5fgJGZs9IK+EWGDoltAh/tx49P2b4wXMS5qo9oPrPqAbryv
97K2+jQ/d4fybMCz5ZuJ8cvyzDUqhugtEfGpPW9q8ur46A21Rq71krgxtw1Z
NuaF8wy+v/uqpQ+d89ydnrwLG1tBLc4/eFCT45ca1OfHD0WxYGQmY4Z4wvWV
5cfXl29NXf87yoIq+QsDdsdyLSwL3q5B4HNAjkjGc6K3hznyxqQAMoYdXQa9
NjbAsO7IVFNs2PMtB/Z7S2+l1EhB1BjRIpuHYxL2IrrQGbhj+l53Bu5Q0Rdl
PvX97uMxL8huJgsw7vuRyP0jUq9dJNHLDG+RiGxVz3G+GreEZKZVA0ZT74XM
BEMsLTwkk4Okn4cNOI049bggElapfchkeqZsQg5IwUtQ92ZT08wYd4HYrIJ6
mrtnWl8qJryT2SK+emSzZz5NL1mrOpV76tVajOfJ4C+oOP+l2RnvjlC3I/xL
Q7lflgMeSA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->289766018]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData["\"\<ConvertToRealsDirectly\>\""], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", reals are generated by taking eight bits at a time from elements of the \
sequence to construct a 52-bit machine precision number. Congruential numbers \
generated in this fashion will still cycle, but cycling will depend on \
repetition in the bit pattern rather than in the initial congruence \
relation."
}], "Text",
 CellID->341821088],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Bits\>\""], "InlineFormula"],
 " option can be ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a nonzero integer, or a list of two nonzero integers specifying the range \
of bits in the modulus ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " used for constructing numbers from bits. ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 " unless ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is a power of 2, in which case ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 " is used."
}], "Text",
 CellID->731576808]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExtendedCA", "Subsection",
 CellID->18361715],

Cell[TextData[{
 "The default ",
 Cell[BoxData["\"\<ExtendedCA\>\""], "InlineFormula"],
 " method makes use of cellular automata to generate high-quality \
pseudorandom numbers. This generator uses a particular five-neighbor rule, so \
each new cell depends on five nonadjacent cells from the previous step."
}], "Text",
 CellID->251647820],

Cell["\<\
Cellular automata\[Hyphen]based random number generators evolve a state \
vector of 0s and 1s according to a deterministic rule. For a given cellular \
automaton, an element (or cell) at a given position in the new state vector \
is determined by certain neighboring cells of that cell in the old state \
vector. A subset of cells in the state vectors are then output as random bits \
from which the pseudorandom numbers are generated.\
\>", "Text",
 CellID->68447227],

Cell[TextData[{
 "The cellular automaton used by ",
 Cell[BoxData["\"\<ExtendedCA\>\""], "InlineFormula"],
 " produces an extremely high level of randomness. It is so high that even \
using every single cell in output will give a stream of bits that passes many \
randomness tests, in spite of the obvious correlation between one cell and \
five previous ones."
}], "Text",
 CellID->388724034],

Cell["\<\
Two options are included for modifying the size of the state vector and the \
cells skipped. The defaults are chosen for quality and speed and there is \
typically no need to modify these options.\
\>", "Text",
 CellID->22636609],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"\"\<Size\>\"", "80", Cell[
    "state vector size as a multiplier of 64", "TableText"]},
   {"\"\<Skip\>\"", "4", Cell["number of cells to skip", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->318204019],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " ",
 Cell[BoxData["\"\<ExtendedCA\>\""], "InlineFormula"],
 "."
}], "Caption",
 CellID->1664784],

Cell[TextData[{
 "The length of the state vectors used is by default set to 80\[Times]64=5120 \
cells. The multiple of 64 can be controlled by the ",
 Cell[BoxData["\"\<Size\>\""], "InlineFormula"],
 " option. "
}], "Text",
 CellID->66525012],

Cell[TextData[{
 "In practice using every fourth cell in each state vector proves to be \
sufficient to pass very stringent randomness tests. This is the default used \
for the ",
 Cell[BoxData["\"\<Skip\>\""], "InlineFormula"],
 " option. For even faster random number generation, a ",
 Cell[BoxData["\"\<Skip\>\""], "InlineFormula"],
 " setting of 2 or even 1 could be used, but the quality of the random \
numbers will then decline. "
}], "Text",
 CellID->4122129],

Cell[TextData[{
 Cell[BoxData["\"\<ExtendedCA\>\""], "InlineFormula"],
 " is the default number generator."
}], "MathCaption",
 CellID->96541496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "1", "]"}], ";", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "5"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->31071355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8173894901710712`", ",", "0.11141961113123644`", ",", 
   "0.7895259946338515`", ",", "0.18780314670602638`", ",", 
   "0.24136096745765045`"}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[61]=",
 CellID->47027384]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Method", "->", "\"\<ExtendedCA\>\""}]}], "]"}], ";", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "5"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->564889951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8173894901710712`", ",", "0.11141961113123644`", ",", 
   "0.7895259946338515`", ",", "0.18780314670602638`", ",", 
   "0.24136096745765045`"}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->291633951]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Legacy", "Subsection",
 CellID->791005668],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Legacy\>\""], "InlineFormula"],
 " method uses the generator called by ",
 Cell[BoxData[
  ButtonBox["Random",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Random"]], "InlineFormula"],
 " in versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prior to Version 6.0. A Marsaglia\[Dash]Zaman subtract\[Hyphen]with\
\[Hyphen]borrow generator is used for reals. The integer generator is based \
on a Wolfram rule 30 cellular automaton generator. The rule 30 generator is \
used directly for small integers and used to generate certain bits for large \
integers."
}], "Text",
 CellID->569511979],

Cell[TextData[{
 "Here are ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " values obtained via the ",
 Cell[BoxData["\"\<Legacy\>\""], "InlineFormula"],
 " method."
}], "MathCaption",
 CellID->151537546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", 
    RowBox[{"31", ",", 
     RowBox[{"Method", "->", "\"\<Legacy\>\""}]}], "]"}], ";", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RandomReal", "[", "]"}], ",", 
     RowBox[{"RandomInteger", "[", "50", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[63]:=",
 CellID->89341507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.21059558727859032`", ",", "8"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[63]=",
 CellID->54154574]
}, Open  ]],

Cell[TextData[{
 "The same values are given by equivalent ",
 Cell[BoxData[
  ButtonBox["Random",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Random"]], "InlineFormula"],
 " calls."
}], "MathCaption",
 CellID->145031155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "31", "]"}], ";", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "50"}], "}"}]}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[64]:=",
 CellID->24328261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.21059558727859032`", ",", "8"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[64]=",
 CellID->12006888]
}, Open  ]],

Cell[TextData[{
 "To guarantee consistency with sequences generated prior to Version 6.0, \
seeds set for the ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " method are also applied to the ",
 Cell[BoxData["\"\<Legacy\>\""], "InlineFormula"],
 " method."
}], "Text",
 CellID->635598082],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Legacy\>\""], "InlineFormula"],
 " method has no options."
}], "Text",
 CellID->527415379]
}, Open  ]],

Cell[CellGroupData[{

Cell["MersenneTwister", "Subsection",
 CellID->569959585],

Cell[TextData[{
 Cell[BoxData["\"\<MersenneTwister\>\""], "InlineFormula"],
 " uses the Mersenne Twister generator due to Matsumoto and Nishimura[",
 Cell[BoxData[
  ButtonBox["3",
   BaseStyle->"Hyperlink",
   ButtonData->"MatsumotoNishimura"]], "InlineFormula"],
 "][",
 Cell[BoxData[
  ButtonBox["4",
   BaseStyle->"Hyperlink",
   ButtonData->"Nishimura"]], "InlineFormula"],
 "]. The Mersenne Twister is a generalized feedback shift register generator \
with period ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "19937"], "-", "1"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->378768533],

Cell["\<\
This gives 5 random numbers from a Mersenne Twister generator.\
\>", "MathCaption",
 CellID->177721484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Method", "->", "\"\<MersenneTwister\>\""}]}], "]"}], ";", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "5"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[65]:=",
 CellID->453275651],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.393561980389721`", ",", "0.7010332601128046`", ",", 
   "0.9662311622055664`", ",", "0.22145602410157195`", ",", 
   "0.4367676249917123`"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[65]=",
 CellID->654338668]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<MersenneTwister\>\""], "InlineFormula"],
 " method has no options."
}], "Text",
 CellID->316567745]
}, Open  ]],

Cell[CellGroupData[{

Cell["MKL", "Subsection",
 CellID->57850632],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<MKL\>\""], "InlineFormula"],
 " method uses the random number generators provided in Intel's MKL \
libraries. The MKL libraries are platform dependent. The ",
 Cell[BoxData["\"\<MKL\>\""], "InlineFormula"],
 " method is only available on Intel\[Hyphen]based systems."
}], "Text",
 CellID->483061491],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "MKL generator to use", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->391202130],

Cell[TextData[{
 "Option for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " ",
 Cell[BoxData["\"\<MKL\>\""], "InlineFormula"],
 "."
}], "Caption",
 CellID->17973746],

Cell[BoxData[GridBox[{
   {"\"\<MCG31\>\"", Cell[
    "31-bit multiplicative congruential generator", "TableText"]},
   {"\"\<MCG59\>\"", Cell[
    "59-bit multiplicative congruential generator", "TableText"]},
   {"\"\<MRG32K3A\>\"", Cell["\<\
combined multiple recursive generators with two components of order 3\
\>", "TableText"]},
   {"\"\<MersenneTwister\>\"", Cell[
    "Mersenne Twister shift register generator", "TableText"]},
   {"\"\<R250\>\"", Cell[
    "generalized feedback shift register generator", "TableText"]},
   {"\"\<WH\>\"", Cell["\<\
Wichmann\[Dash]Hill combined multiplicative congruential generators\
\>", "TableText"]},
   {"\"\<Niederreiter\>\"", Cell[
    "Niederreiter low discrepancy sequence", "TableText"]},
   {"\"\<Sobol\>\"", Cell["Sobol low discrepancy sequence", "TableText"]}
  }]], "DefinitionBox",
 CellID->369023658],

Cell[TextData[{
 Cell[BoxData["\"\<MKL\>\""], "InlineFormula"],
 " methods."
}], "Caption",
 CellID->96150342],

Cell[TextData[{
 "The first six methods are uniform generators. ",
 Cell[BoxData["\"\<Niederreiter\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Sobol\>\""], "InlineFormula"],
 " generate Niederreiter and Sobol sequences. These sequences are nonuniform \
and have underlying structure which is sometimes useful in numerical methods. \
For instance, these sequences typically provide faster convergence in \
multidimensional Monte Carlo integration. "
}], "Text",
 CellID->18106354],

Cell["\<\
The following shows the structure of a Niederreiter sequence in dimension 2.\
\>", "MathCaption",
 CellID->70217261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"BlockRandom", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", 
      RowBox[{"Method", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<MKL\>\"", ",", " ", 
         RowBox[{"Method", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<Niederreiter\>\"", ",", " ", 
            RowBox[{"\"\<Dimension\>\"", "->", "2"}]}], "}"}]}]}], "}"}]}], 
      "]"}], ";", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "2"}], "}"}]}], "]"}]}], "]"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"AspectRatio", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[66]:=",
 CellID->518868435],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt211M21l6x/GolUUlhKjECi4Qob2IrKpCtOLCF4iyN5SLLLVULpCWAqut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     "]]}, {}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 0.9997431943193078}, {0., 0.9999571619555354}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[66]=",
 CellID->158458127]
}, Open  ]],

Cell["This shows the structure of a Sobol sequence in dimension 2.", \
"MathCaption",
 CellID->413316904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"BlockRandom", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", 
      RowBox[{"Method", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<MKL\>\"", ",", " ", 
         RowBox[{"Method", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<Sobol\>\"", ",", " ", 
            RowBox[{"\"\<Dimension\>\"", "->", "2"}]}], "}"}]}]}], "}"}]}], 
      "]"}], ";", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "2"}], "}"}]}], "]"}]}], "]"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"AspectRatio", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[67]:=",
 CellID->305039619],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt211M21l6x/GolUUlhKjECi4Qob2IrKpCtOLCF4iyN5SLLLVULpCWAqut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     "]]}, {}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 0.9999571619555354}, {0., 0.9997431943193078}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[67]=",
 CellID->542080558]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rule30CA", "Subsection",
 CellID->830168163],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Rule30CA\>\""], "InlineFormula"],
 " method uses a Wolfram rule 30 cellular automaton generator. Bits are \
obtained by evolving a state vector of 0s and 1s using the relation"
}], "Text",
 CellID->19390676],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", 
      RowBox[{"i", ",", " ", 
       RowBox[{"t", "+", "1"}]}], ")"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"f", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"i", "-", "1"}], ",", "t"}], ")"}]}], " ", "\[Xor]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", 
        RowBox[{"(", 
         RowBox[{"i", ",", "t"}], ")"}]}], " ", "\[Or]", " ", 
       RowBox[{"f", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"i", "+", "1"}], ",", "t"}], ")"}]}]}], ")"}]}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellID->1000570005],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", 
    RowBox[{"(", 
     RowBox[{"i", ",", "t"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " is the value of cell ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " at time ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->383398421],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"\"\<Size\>\"", "9", Cell[
    "state vector size as a multiplier of 29", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11284374],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " ",
 Cell[BoxData["\"\<Rule30CA\>\""], "InlineFormula"],
 "."
}], "Caption",
 CellID->23773934],

Cell[TextData[{
 "The length of the state vectors used is by default set to 9\[Times]29=261 \
cells. The multiplier for 29 can be controlled by the ",
 Cell[BoxData["\"\<Size\>\""], "InlineFormula"],
 " option."
}], "Text",
 CellID->229377272],

Cell[TextData[{
 "This gives a 2\[Times]3\[Times]4 tensor of random integers using ",
 Cell[BoxData["\"\<Rule30CA\>\""], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->814167608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Method", "->", "\"\<Rule30CA\>\""}]}], "]"}], ";", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"10", "^", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[68]:=",
 CellID->110280843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"60745", ",", "40991", ",", "22336", ",", "76623"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"57042", ",", "92146", ",", "91746", ",", "18972"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"70251", ",", "62829", ",", "78488", ",", "82331"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"93628", ",", "53079", ",", "11476", ",", "55013"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"7702", ",", "96543", ",", "99411", ",", "79327"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"42137", ",", "83772", ",", "56154", ",", "6410"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{443, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[68]=",
 CellID->35838246]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Rule30CA\>\""], "InlineFormula"],
 " method uses only the first bit from each state vector, making it slower \
than the ",
 Cell[BoxData["\"\<ExtendedCA\>\""], "InlineFormula"],
 " method, which uses multiple bits from each state vector."
}], "Text",
 CellID->261891603]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining your own generator", "Subsection",
 CellTags->"Generators",
 CellID->215995533],

Cell[TextData[{
 "Methods can be plugged into the random framework as long as they follow the \
correct template. A generator object is of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gsym", "TI"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["gsym", "TI"]], "InlineFormula"],
 " is the symbol that identifies the generator and to which rules are \
attached. ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is effectively private to the top-level evaluations associated with the \
generator definitions."
}], "Text",
 CellID->47164682],

Cell[TextData[{
 "Generator initialization is handled by a call to ",
 Cell[BoxData["Random`InitializeGenerator"], "InlineFormula"],
 ". "
}], "Text",
 CellID->341192944],

Cell[BoxData[GridBox[{
   {
    RowBox[{"Random`InitializeGenerator", "[", 
     RowBox[{
      StyleBox["gsym", "TI"], ",", 
      StyleBox["opts", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "initializes the generator ",
     Cell[BoxData[
      StyleBox["gsym", "TI"]], "InlineFormula"],
     " with options ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->391001025],

Cell["Generator initialization function.", "Caption",
 CellID->204201832],

Cell[TextData[{
 Cell[BoxData["Random`InitializeGenerator"], "InlineFormula"],
 " is expected to return a generator object ",
 Cell[BoxData[
  StyleBox["gobj", "TI"]], "InlineFormula"],
 " of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gsym", "TI"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->636103569],

Cell["\<\
Generators can support generation of random bit streams, random integers, and \
random reals. If the generator supports bit streams, reals and integers can \
be generated by conversion of the bit stream. At method setup time, \
properties are queried to determine what is supported and how.\
\>", "Text",
 CellID->131198039],

Cell[BoxData[GridBox[{
   {"GeneratesBitsQ", Cell[TextData[{
     "set to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the method generates bits"
    }], "TableText"]},
   {"GeneratesIntegersQ", Cell[TextData[{
     "set to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the method generates integers for a given range"
    }], "TableText"]},
   {"GeneratesRealsQ", Cell[TextData[{
     "set to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the method generates reals for a given range and precision"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->41499560],

Cell["Generator properties.", "Caption",
 CellID->27535580],

Cell[TextData[{
 "If bit streams are supported, then ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gobj", "TI"], "[", 
   RowBox[{"\"\<GenerateBits\>\"", "[", 
    StyleBox["nbits", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is expected to return an integer comprised of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " random bits or a list of length ",
 Cell[BoxData[
  StyleBox["nbits", "TI"]], "InlineFormula"],
 " with entries that are 0 or 1."
}], "Text",
 CellID->74890238],

Cell[TextData[{
 "If random integers are supported, then ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gobj", "TI"], "[", 
   RowBox[{"\"\<GenerateIntegers\>\"", "[", 
    RowBox[{
     StyleBox["n", "TI"], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"]}], "}"}]}], "]"}], "]"}]], "InlineFormula"],
 " is expected to return a list of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " random integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]], "InlineMath"],
 ". ",
 "A warning message will be issued when results are out of range."
}], "Text",
 CellID->107416421],

Cell[TextData[{
 "If random reals are supported, then ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gobj", "TI"], "[", 
   RowBox[{"\"\<GenerateReals\>\"", "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"]}], "}"}], ",", 
     StyleBox["prec", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 " is expected to return a list of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " random reals with precision ",
 Cell[BoxData[
  StyleBox["prec", "TI"]], "InlineFormula"],
 " in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]], "InlineMath"],
 ". A warning message will be issued when results are out of range or of the \
wrong precision."
}], "Text",
 CellID->178084341],

Cell[TextData[{
 "For any of the generation functions, the return can be ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["res", "TI"], ",", 
    StyleBox["gobj", "TI"]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["res", "TI"]], "InlineFormula"],
 " is the result of the correct type and ",
 Cell[BoxData[
  StyleBox["gobj", "TI"]], "InlineFormula"],
 " is a new generator object (reflecting any state change)."
}], "Text",
 CellID->491102950],

Cell[TextData[{
 "Seeding is done by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gobj", "TI"], "[", 
   RowBox[{"\"\<SeedGenerator\>\"", "[", 
    StyleBox["seed", "TI"], "]"}], "]"}]], "InlineFormula"],
 " for an integer ",
 Cell[BoxData[
  StyleBox["seed", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gobj", "TI"], "[", 
   RowBox[{"\"\<SeedGenerator\>\"", "[", 
    StyleBox["seed", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is expected to return a new generator object."
}], "Text",
 CellID->352892580],

Cell[CellGroupData[{

Cell["Example: multiplicative congruential generator", "Subsubsection",
 CellID->53206063],

Cell["\<\
In the following example a multiplicative congruential generator will be \
defined. A multiplicative congruential generator follows the recurrence \
relation\
\>", "Text",
 CellID->306834972],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["x", "i"], "\[Congruent]", 
   RowBox[{"b", "\[InvisibleTimes]", 
    SubscriptBox["x", 
     RowBox[{"i", "-", "1"}]], " ", "mod", " ", "m"}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->51307053],

Cell["\<\
The generator, as defined below, will allow only for generation of real \
numbers.\
\>", "Text",
 CellID->651321203],

Cell[TextData[{
 "This sets default options for the generator ",
 Cell[BoxData["MultiplicativeCongruential"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->236141184],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "MultiplicativeCongruential", "]"}], " ", "=", " ",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Multiplier\>\"", "\[Rule]", "123456789"}], ",", " ", 
     RowBox[{"\"\<Modulus\>\"", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "^", "35"}], "-", "1"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[69]:=",
 CellID->207931436],

Cell["\<\
Initialization of the generator will extract the values of the multiplier and \
modulus. Initialization will fail if either of these values is not a positive \
integer.\
\>", "Text",
 CellID->105519449],

Cell["The following initializes the generator.", "MathCaption",
 CellID->220603967],

Cell[BoxData[
 RowBox[{
  RowBox[{"MultiplicativeCongruential", " ", "/:", " ", 
   RowBox[{"Random`InitializeGenerator", "[", 
    RowBox[{"MultiplicativeCongruential", ",", " ", "opts___"}], "]"}], " ", ":=",
    " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"mult", ",", " ", "mod", ",", " ", 
       RowBox[{"flops", " ", "=", " ", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{"opts", ",", " ", 
           RowBox[{"Options", "[", "MultiplicativeCongruential", "]"}]}], 
          "}"}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"mult", " ", "=", " ", 
       RowBox[{"\"\<Multiplier\>\"", " ", "/.", " ", "flops"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"IntegerQ", "[", "mult", "]"}], "&&", 
           RowBox[{"Positive", "[", "mult", "]"}]}], ")"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Throw", "[", "$Failed", "]"}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"mod", " ", "=", " ", 
       RowBox[{"\"\<Modulus\>\"", " ", "/.", " ", "flops"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"IntegerQ", "[", "mod", "]"}], "&&", 
           RowBox[{"Positive", "[", "mult", "]"}]}], ")"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Throw", "[", "$Failed", "]"}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"MultiplicativeCongruential", "[", 
       RowBox[{"mult", ",", " ", "mod", ",", "1"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[70]:=",
 CellID->15261556],

Cell[TextData[{
 "This establishes that ",
 Cell[BoxData["MultiplicativeCongruential"], "InlineFormula"],
 " generates reals."
}], "MathCaption",
 CellID->75701923],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MultiplicativeCongruential", "[", "___", "]"}], "[", 
    "\"\<GeneratesRealsQ\>\"", "]"}], " ", ":=", " ", "True"}], 
  ";"}]], "Input",
 CellLabel->"In[71]:=",
 CellID->413732366],

Cell["\<\
The following seeds the generator using the recurrence relation.\
\>", "MathCaption",
 CellID->835193870],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MultiplicativeCongruential", "[", 
     RowBox[{"mult_", ",", "mod_", ",", " ", "___"}], "]"}], "[", 
    RowBox[{"\"\<SeedGenerator\>\"", "[", "seed_", "]"}], "]"}], " ", ":=", 
   " ", "\[IndentingNewLine]", 
   RowBox[{"MultiplicativeCongruential", "[", 
    RowBox[{"mult", ",", "mod", ",", " ", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"mult", "*", "seed"}], ")"}], ",", "mod"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[72]:=",
 CellID->7906412],

Cell[TextData[{
 "The real number generator will return the desired number of reals ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and a new ",
 Cell[BoxData["MultiplicativeCongruential"], "InlineFormula"],
 " generator. The seed for the new generator is updated based on the \
recurrence relation."
}], "Text",
 CellID->464531126],

Cell["This defines the real number generator.", "MathCaption",
 CellID->487178613],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MultiplicativeCongruential", "[", 
    RowBox[{"mult_", ",", "mod_", ",", " ", "s_"}], "]"}], "[", 
   RowBox[{"\"\<GenerateReals\>\"", "[", 
    RowBox[{"n_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], ",", "prec_"}], "]"}], "]"}], " ", ":=",
   " ", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "=", "s"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "a"}], ")"}], 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "=", 
             RowBox[{"mult", "*", "x"}]}], ";", 
            RowBox[{"Mod", "[", 
             RowBox[{"x", ",", "mod"}], "]"}]}], ",", 
           RowBox[{"{", "n", "}"}]}], "]"}], "/", "mod"}]}]}], ",", 
      RowBox[{"MultiplicativeCongruential", "[", 
       RowBox[{"mult", ",", "mod", ",", " ", "x"}], "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[73]:=",
 CellID->216655639],

Cell[TextData[{
 "This generates 10 reals using the ",
 Cell[BoxData["MultiplicativeCongruential"], "InlineFormula"],
 " generator."
}], "MathCaption",
 CellID->100115776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", 
    RowBox[{"Method", "->", "MultiplicativeCongruential"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "50"}], "}"}], ",", "10"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[74]:=",
 CellID->242224527],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "33.15474495752001`", ",", "47.56936157639049`", ",", "45.00114839072925`", 
   ",", "31.631950148195955`", ",", "25.104347139279835`", ",", 
   "37.75682405998688`", ",", "16.283923909396513`", ",", 
   "48.17442042442197`", ",", "17.535153646095864`", ",", 
   "48.76863776266018`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[74]=",
 CellID->325997614]
}, Open  ]],

Cell["The generator is not defined for integers.", "MathCaption",
 CellID->762875179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", 
    RowBox[{"Method", "->", "MultiplicativeCongruential"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "50"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[75]:=",
 CellID->649853174],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomInteger", "::", "\<\"unstyp\"\>"}], ":", 
  " ", "\<\"The current random generator does not support generation of \
random integers in the given range.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[75]:=",
 CellID->322452064],

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "50"}], "}"}], "]"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[75]=",
 CellID->16252677]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Example: Blum\[Dash]Blum\[Dash]Shub generator\
\>", "Subsubsection",
 CellID->37119089],

Cell[TextData[{
 "The Blum\[Dash]Blum\[Dash]Shub generator is a quadratic congruential method \
for generating pseudorandom bits for cryptographic purposes[",
 Cell[BoxData[
  ButtonBox["5",
   BaseStyle->"Hyperlink",
   ButtonData->"Junod"]], "InlineFormula"],
 "]. The congruence is mod ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 "\[Times]",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " for specified primes ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->343503892],

Cell[TextData[{
 "This sets default options for the generator ",
 Cell[BoxData["BlumBlumShub"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->566157157],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "BlumBlumShub", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<BlumPrimes\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "1267650600228229401496703981519", ",", " ", 
        "1267650600228229401496704318359"}], "}"}]}], ",", " ", 
     RowBox[{"\"\<BitWidth\>\"", "\[Rule]", "Automatic"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[76]:=",
 CellID->516905451],

Cell["\<\
The following define an auxiliary function and error messages for the \
generator.\
\>", "MathCaption",
 CellID->366343203],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpecialBlumPrimeQ", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Positive", "[", "x", "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"x", ",", " ", "4"}], "]"}], " ", "\[Equal]", " ", "3"}], 
     ")"}], " ", "&&", " ", 
    RowBox[{"PrimeQ", "[", "x", "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[77]:=",
 CellID->7297936],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BlumBlumShub", "::", "bprime"}], " ", "=", " ", 
   "\"\<`1` is not a list of two distinct special Blum primes.\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[78]:=",
 CellID->164389542],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BlumBlumShub", "::", "bw"}], " ", "=", " ", 
   "\"\<Warning: the value of the option BitWidth->`1` exceeds the number `2` \
that has been proved cyptographically secure.\>\""}], ";"}]], "Input",
 CellLabel->"In[79]:=",
 CellID->449032134],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BlumBlumShub", "::", "bw1"}], " ", "=", " ", 
   "\"\<The value of the option BitWidth->`1` should be a positive machine \
sized integer or Automatic.\>\""}], ";"}]], "Input",
 CellLabel->"In[80]:=",
 CellID->665424257],

Cell["\<\
The generator initialization will extract option values and issue error \
messages if necessary before calling the actual generator.\
\>", "Text",
 CellID->325919855],

Cell["The following initializes the generator.", "MathCaption",
 CellID->48224491],

Cell[BoxData[
 RowBox[{
  RowBox[{"BlumBlumShub", " ", "/:", " ", 
   RowBox[{"Random`InitializeGenerator", "[", 
    RowBox[{"BlumBlumShub", ",", " ", "opts___"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", " ", "abw", ",", " ", "bw", ",", " ", 
       RowBox[{"flops", " ", "=", " ", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{"opts", ",", " ", 
           RowBox[{"Options", "[", "BlumBlumShub", "]"}]}], "}"}], "]"}]}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"n", " ", "=", " ", 
       RowBox[{"\"\<BlumPrimes\>\"", " ", "/.", " ", "flops"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"And", "[", 
          RowBox[{
           RowBox[{"VectorQ", "[", 
            RowBox[{"n", ",", " ", "SpecialBlumPrimeQ"}], "]"}], ",", " ", 
           RowBox[{
            RowBox[{"Length", "[", "n", "]"}], " ", "\[Equal]", " ", "2"}], 
           ",", " ", 
           RowBox[{"Not", "[", 
            RowBox[{"Apply", "[", 
             RowBox[{"Equal", ",", " ", "n"}], "]"}], "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"BlumBlumShub", "::", "\"\<bprime\>\""}], ",", " ", "n"}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"n", " ", "=", " ", 
       RowBox[{"Apply", "[", 
        RowBox[{"Times", ",", " ", "n"}], "]"}]}], ";", "\[IndentingNewLine]",
       
      RowBox[{"abw", " ", "=", " ", 
       RowBox[{"Max", "[", 
        RowBox[{"1", ",", 
         RowBox[{"Floor", "[", 
          RowBox[{"Log", "[", 
           RowBox[{"2.", ",", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"2.", ",", "n"}], "]"}]}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"bw", " ", "=", " ", 
       RowBox[{"\"\<BitWidth\>\"", " ", "/.", " ", "flops"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"bw", " ", "===", " ", "Automatic"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"bw", " ", "=", " ", "abw"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IntegerQ", "[", "bw", "]"}], " ", "&&", " ", 
              RowBox[{"Positive", "[", "bw", "]"}]}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"BlumBlumShub", "::", "bwi"}], ",", " ", "bw"}], "]"}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"bw", " ", ">", " ", "abw"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"BlumBlumShub", "::", "bw"}], ",", " ", "bw", ",", " ", 
             "abw"}], "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"BlumBlumShub", "[", 
       RowBox[{"n", ",", " ", "bw", ",", " ", 
        RowBox[{
         RowBox[{"2", "^", "bw"}], " ", "-", " ", "1"}], ",", " ", "2"}], 
       "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[81]:=",
 CellID->342070724],

Cell[TextData[{
 "This establishes that ",
 Cell[BoxData["BlumBlumShub"], "InlineFormula"],
 " is a bit generator and determines the bit width."
}], "MathCaption",
 CellID->20130777],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BlumBlumShub", "[", "___", "]"}], "[", "\"\<GeneratesBitsQ\>\"", 
    "]"}], " ", ":=", " ", "True"}], ";"}]], "Input",
 CellLabel->"In[82]:=",
 CellID->717886833],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BlumBlumShub", "[", 
     RowBox[{"n_", ",", " ", "bw_", ",", " ", "__"}], "]"}], "[", 
    "\"\<BitWidth\>\"", "]"}], " ", ":=", " ", "bw"}], ";"}]], "Input",
 CellLabel->"In[83]:=",
 CellID->90710492],

Cell["The following seeds the generator.", "MathCaption",
 CellID->455054847],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BlumBlumShub", "[", 
    RowBox[{"n_", ",", "bw_", ",", " ", "mask_", ",", "  ", "___"}], "]"}], 
   "[", 
   RowBox[{"\"\<SeedGenerator\>\"", "[", "seed_", "]"}], "]"}], " ", ":=", 
  " ", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", " ", ",", " ", 
      RowBox[{"i", " ", "=", " ", "0"}], ",", " ", 
      RowBox[{"state", " ", "=", " ", 
       RowBox[{"{", "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"Union", "[", "state", "]"}], "]"}], " ", "<", " ", "10"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"x", " ", "=", " ", 
         RowBox[{"seed", " ", "+", " ", "i"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"state", " ", "=", " ", 
         RowBox[{"NestList", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerMod", "[", 
             RowBox[{"#", ",", " ", "2", ",", " ", "n"}], "]"}], "&"}], ",", 
           " ", "x", ",", " ", "9"}], "]"}]}], ";"}]}], "\[IndentingNewLine]",
       "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"BlumBlumShub", "[", 
      RowBox[{"n", ",", " ", "bw", ",", " ", "mask", ",", "  ", 
       RowBox[{"Last", "[", "state", "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[84]:=",
 CellID->1012736182],

Cell["This defines the bit generator.", "MathCaption",
 CellID->171866137],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BlumBlumShub", "[", 
    RowBox[{"n_", ",", " ", "bw_", ",", " ", "mask_", ",", " ", "s_"}], "]"}],
    "[", 
   RowBox[{"\"\<GenerateBits\>\"", "[", "bits_", "]"}], "]"}], " ", ":=", " ",
   "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", " ", "=", " ", 
      RowBox[{"PowerMod", "[", 
       RowBox[{"s", ",", " ", "2", ",", " ", "n"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BitAnd", "[", 
       RowBox[{"x", ",", " ", "mask"}], "]"}], ",", " ", 
      RowBox[{"BlumBlumShub", "[", 
       RowBox[{"n", ",", "bw", ",", " ", "mask", ",", " ", "x"}], "]"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[85]:=",
 CellID->470227807],

Cell[TextData[{
 "This generates 5 integers and 5 reals using the ",
 Cell[BoxData["BlumBlumShub"], "InlineFormula"],
 " generator."
}], "MathCaption",
 CellID->148364729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", 
    RowBox[{"Method", "->", "BlumBlumShub"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "10"}], "}"}], ",", "5"}], "]"}], ",", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"4", ",", "5"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[86]:=",
 CellID->961269082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.374064713072026`", ",", "1.5992171125755013`", ",", 
     "1.1163569541732672`", ",", "3.7007867232440272`", ",", 
     "0.29338032169588146`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[86]=",
 CellID->48934540]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Statistical Distributions", "Section",
 CellTags->"Distributions",
 CellID->554867591],

Cell["\<\
The general idea behind generating random variates from a nonuniform \
statistical distribution is to generate a random uniform variate between 0 \
and 1 and then compute the inverse CDF of that random value in the desired \
distribution. In practice, however, following this recipe directly can be \
very computationally intensive if a large number of random variates is \
desired, particularly when the inverse CDF is complicated or cannot be \
expressed in a closed form.\
\>", "Text",
 CellID->70729116],

Cell[TextData[{
 "In such cases, table lookups, direct construction based on distributional \
relationships, or acceptance\[Hyphen]rejection methods are often more \
efficient alternatives to direct inversion of the CDF. On some level, these \
methodologies will all still rely on uniformly distributed ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " values, uniformly distributed ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " values, observations from a weighted ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 ", or a combination of these values. As a result, methods set via ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " will have an effect on random observations from statistical \
distributions."
}], "Text",
 CellID->171976680],

Cell[TextData[{
 "The methods used by ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " for many of the distributions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follow methods suggested or described in Gentle [",
 Cell[BoxData[
  ButtonBox["6",
   BaseStyle->"Hyperlink",
   ButtonData->"Gentle"]], "InlineFormula"],
 "], and are not necessarily the same methods used by ",
 Cell[BoxData[
  ButtonBox["Random",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Random"]], "InlineFormula"],
 " and ",
 Cell[BoxData["RandomArray"], "InlineFormula"],
 " in the standard add\[Hyphen]ons included with versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prior to Version 6.0."
}], "Text",
 CellID->518342337],

Cell[TextData[{
 "Random observations from all built-in statistical distributions can be \
generated using either ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 "."
}], "Text",
 CellID->66156762],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[TextData[{
     "gives a random number from the continuous distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     RowBox[{
      StyleBox["dist", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom reals from ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     RowBox[{
      StyleBox["dist", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "gives an ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " array of pseudorandom reals from ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->99656438],

Cell["Generation of random values from continuous distributions.", "Caption",
 CellID->205603206],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     StyleBox["dist", "TI"], "]"}], Cell[TextData[{
     "gives a random number from the discrete distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     RowBox[{
      StyleBox["dist", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom integers from ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], "[", 
     RowBox[{
      StyleBox["dist", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "gives an ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " array of pseudorandom integers from ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->974420881],

Cell["Generation of random values from discrete distributions.", "Caption",
 CellID->261861085],

Cell[TextData[{
 "Observations from continuous univariate and multivariate distributions are \
obtained via ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ", while discrete univariate and multivariate distributions are obtained via \
",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " is used on a continuous distribution, or ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " on a discrete distribution, an error is generated and the input is \
returned unevaluated."
}], "Text",
 CellID->472715616],

Cell[TextData[{
 "This fails because the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " distribution is continuous."
}], "MathCaption",
 CellID->139215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"ChiSquareDistribution", "[", "8", "]"}], "]"}]], "Input",
 CellLabel->"In[87]:=",
 CellID->1014332979],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomInteger", "::", "\<\"unsdst\"\>"}], ":", 
  " ", "\<\"The distribution  \\!\\(ChiSquareDistribution[8]\\) is defined on \
a set of real values.  Use RandomReal instead.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[87]:=",
 CellID->23701167],

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"ChiSquareDistribution", "[", "8", "]"}], "]"}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[87]=",
 CellID->22724633]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " is an option to ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " for continuous distributions just as it is for uniform numbers over \
ranges."
}], "Text",
 CellID->56452128],

Cell["\<\
Here is a precision-30 beta\[Hyphen]distributed variate. \
\>", "MathCaption",
 CellID->834942158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"BetaDistribution", "[", 
    RowBox[{"3", ",", "7"}], "]"}], ",", 
   RowBox[{"WorkingPrecision", "->", "30"}]}], "]"}]], "Input",
 CellLabel->"In[88]:=",
 CellID->22222704],

Cell[BoxData["0.453568522862231707895720399465631771944363294176`30."], \
"Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[88]=",
 CellID->749080506]
}, Open  ]],

Cell["\<\
Multivariate distributions and distributions derived from the multivariate \
normal distribution are included in the Multivariate Statistics Package. \
Generators for those distributions can be accessed by loading the package.\
\>", "Text",
 CellID->66643121],

Cell["This loads the package.", "MathCaption",
 CellID->415249406],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input",
 CellLabel->"In[89]:=",
 CellID->3796874],

Cell["\<\
Here is a random vector from a bivariate normal distribution. \
\>", "MathCaption",
 CellID->51241293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", ".5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{".5", ",", "3"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[90]:=",
 CellID->23504658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.8453006864421382`", ",", "3.5941730256282485`"}], 
  "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[90]=",
 CellID->414750415]
}, Open  ]],

Cell["This is a random vector from a multinomial distribution. ", \
"MathCaption",
 CellID->252673169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{"20", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "3"}], ",", 
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "6"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[91]:=",
 CellID->196273874],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "9", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[91]=",
 CellID->55526216]
}, Open  ]],

Cell[CellGroupData[{

Cell["Continuous Distributions", "Subsection",
 CellID->452639384],

Cell[TextData[{
 "For distributions whose inverse CDFs contain only elementary functions, \
direct computation of the inverse CDF for a random uniform is generally used. \
This can be seen as a direct construction from a uniformly distributed random \
variable. Continuous distributions falling in this category include ",
 Cell[BoxData[
  ButtonBox["CauchyDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CauchyDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ExtremeValueDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GumbelDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LaplaceDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LogisticDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogisticDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ParetoDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParetoDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RayleighDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RayleighDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TriangularDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TriangularDistribution"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 "."
}], "Text",
 CellID->711596005],

Cell[TextData[{
 "Direct construction of a single random variate from multiple uniform \
variates, or from variates other than the uniform distribution are also \
employed. Normal variates are generated in pairs from pairs of random \
uniforms using the Box\[Dash]M\[UDoubleDot]ller method. ",
 Cell[BoxData[
  ButtonBox["HalfNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HalfNormalDistribution"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LogNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFormula"],
 " variates are obtained by direct transformation of normal variates. ",
 Cell[BoxData[
  ButtonBox["MultinormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["QuadraticFormDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/QuadraticFormDistribution"]], 
  "InlineFormula"],
 " from the Multivariate Statistics Package also use direct construction from \
normal variates. "
}], "Text",
 CellID->443607893],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGaussianDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGaussianDistribution"]], "InlineFormula"],
 " uses an acceptance\[Hyphen]complement method involving normal and uniform \
variates. The method is due to Michael, Schucany and Haas and described in \
Gentle [",
 Cell[BoxData[
  ButtonBox["6",
   BaseStyle->"Hyperlink",
   ButtonData->"Gentle"]], "InlineFormula"],
 "]. ",
 Cell[BoxData[
  ButtonBox["MaxwellDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxwellDistribution"]], "InlineFormula"],
 " variates are constructed from ",
 Cell[BoxData[
  ButtonBox["ChiDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChiDistribution"]], "InlineFormula"],
 " variates",
 ". ",
 "The chi variates themselves are obtained from ",
 Cell[BoxData[
  ButtonBox["ChiSquareDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChiSquareDistribution"]], "InlineFormula"],
 " variates, which are special cases of ",
 Cell[BoxData[
  ButtonBox["GammaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaDistribution"]], "InlineFormula"],
 " variates."
}], "Text",
 CellID->440116445],

Cell[TextData[{
 "In most cases ",
 Cell[BoxData[
  ButtonBox["FRatioDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FRatioDistribution"]], "InlineFormula"],
 " constructs each random value from a single random beta variate. For small \
degrees of freedom, ",
 Cell[BoxData[
  ButtonBox["FRatioDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FRatioDistribution"]], "InlineFormula"],
 " variates are instead generated from pairs of gamma variates to avoid \
possible divisions by 0 that may arise in the beta construction."
}], "Text",
 CellID->295085736],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NoncentralChiSquareDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralChiSquareDistribution"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", " ", 
    StyleBox["\[Lambda]", "TR"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Chi]", "\[Nu]", "2"], "(", "\[Lambda]", ")"}], 
   TraditionalForm]], "InlineMath"],
 ", variate generation uses additive properties of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " distributions to avoid expensive inverse CDF computations for nonintegral \
",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 ". The additive properties are given in, for instance, Johnson, Kotz and \
Balakrishnan [",
 Cell[BoxData[
  ButtonBox["7",
   BaseStyle->"Hyperlink",
   ButtonData->"JohnsonKotzBalakrishnan"]], "InlineFormula"],
 "]. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", "=", "1"}], TraditionalForm]], "InlineMath"],
 " a noncentral ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " variate can be generated as the square of a normal variate with mean ",
 Cell[BoxData[
  FormBox[
   SqrtBox["\[Lambda]"], TraditionalForm]], "InlineMath"],
 " and variance 1. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", "\[NotEqual]", "1"}], TraditionalForm]], "InlineMath"],
 " noncentral ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " variates are obtained as the sum of a central and a noncentral ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " random variable. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", ">", "1"}], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "+", "Y"}], TraditionalForm]], "InlineMath"],
 " is distributed ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Chi]", "\[Nu]", "2"], "(", "\[Lambda]", ")"}], 
   TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "~", 
    RowBox[{
     SubsuperscriptBox["\[Chi]", "1", "2"], "(", "\[Lambda]", ")"}]}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Y", "~", 
    SubsuperscriptBox["\[Chi]", 
     RowBox[{"\[Nu]", "-", "1"}], "2"]}], TraditionalForm]], "InlineMath"],
 ". This relationship cannot be used for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", "<", "1"}], TraditionalForm]], "InlineMath"],
 ". In that case the construction is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "+", "Y"}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "~", 
    RowBox[{
     SubsuperscriptBox["\[Chi]", "0", "2"], "(", "\[Lambda]", ")"}]}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Y", "~", 
    SubsuperscriptBox["\[Chi]", 
     RowBox[{"\[Nu]", "-", "1"}], "2"]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Chi]", "0", "2"], "(", "\[Lambda]", ")"}], 
   TraditionalForm]], "InlineMath"],
 " is the limiting noncentral ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " distribution as ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " goes to 0. The limiting distribution ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Chi]", "0", "2"], "(", "\[Lambda]", ")"}], 
   TraditionalForm]], "InlineMath"],
 " is a mixture of Poisson and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " variables, which has a nonzero probability mass at 0 and a continuous \
density for positive values. ",
 Cell[BoxData[
  ButtonBox["NoncentralFRatioDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralFRatioDistribution"]], "InlineFormula"],
 " variates are obtained from one central and one noncentral ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " variate."
}], "Text",
 CellID->64303130],

Cell[TextData[{
 "For the ",
 Cell[BoxData[
  ButtonBox["WishartDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/WishartDistribution"]], 
  "InlineFormula"],
 " from the Multivariate Statistics Package, matrices are generated via Smith \
and Hocking's method [",
 Cell[BoxData[
  ButtonBox["8",
   BaseStyle->"Hyperlink",
   ButtonData->"SmithHocking"]], "InlineFormula"],
 "]. This method constructs Wishart matrices from matrices with chi \
distributed diagonal entries and normally distributed off\[Hyphen]diagonal \
entries."
}], "Text",
 CellID->21667378],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralStudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralStudentTDistribution"]], 
  "InlineFormula"],
 ", and the ",
 Cell[BoxData[
  ButtonBox["HotellingTSquareDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MultivariateTDistribution",
   BaseStyle->"Link",
   ButtonData->
    "paclet:MultivariateStatistics/ref/MultivariateTDistribution"]], 
  "InlineFormula"],
 " from the Multivariate Statistics Package each use direct construction from \
univariate random variates."
}], "Text",
 CellID->71961257],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GammaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BetaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaDistribution"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["StudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFormula"],
 " use acceptance\[Hyphen]rejection methods to some extent. "
}], "Text",
 CellID->242364124],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GammaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", " ", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 " exponential variates are generated when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". Otherwise, methods due to Cheng and Feast [",
 Cell[BoxData[
  ButtonBox["9",
   BaseStyle->"Hyperlink",
   ButtonData->"ChengFeast"]], "InlineFormula"],
 "] and Ahrens and Dieter [",
 Cell[BoxData[
  ButtonBox["10",
   BaseStyle->"Hyperlink",
   ButtonData->"Johnson"]], "InlineFormula"],
 "] are used."
}], "Text",
 CellID->49100563],

Cell[TextData[{
 "Beta variates are constructed by switching between multiple methods \
depending on the values of the beta parameters ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineMath"],
 ". If both parameters are 1, uniform random variates will be generated. If \
one of the beta parameters is 1, then a closed form inverse CDF evaluation is \
used. Otherwise, ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " switches between acceptance\[Hyphen]rejection methods due to \
J\[ODoubleDot]hnk [",
 Cell[BoxData[
  ButtonBox["11",
   BaseStyle->"Hyperlink",
   ButtonData->"Johnk"]], "InlineFormula"],
 "], Cheng [",
 Cell[BoxData[
  ButtonBox["12",
   BaseStyle->"Hyperlink",
   ButtonData->"Cheng"]], "InlineFormula"],
 "] and Atkinson [",
 Cell[BoxData[
  ButtonBox["13",
   BaseStyle->"Hyperlink",
   ButtonData->"Atkinson"]], "InlineFormula"],
 "]. An example of the advantage of using an acceptance\[Hyphen]rejection \
method over construction from two gammas can be seen in the following. The \
direct acceptance\[Hyphen]rejection method is nearly twice as fast as the \
gamma\[Hyphen]pair construction."
}], "Text",
 CellID->188586306],

Cell["\<\
Comparison of direct construction and acceptance-rejection methods for beta \
variates.\
\>", "MathCaption",
 CellID->68150037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"GammaDistribution", "[", 
          RowBox[{"7", ",", "1"}], "]"}], ",", 
         RowBox[{"10", "^", "6"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"x1", "/", 
      RowBox[{"(", 
       RowBox[{"x1", "+", 
        RowBox[{"RandomReal", "[", 
         RowBox[{
          RowBox[{"GammaDistribution", "[", 
           RowBox[{"3", ",", "1"}], "]"}], ",", 
          RowBox[{"10", "^", "6"}]}], "]"}]}], ")"}]}]}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[92]:=",
 CellID->106742096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.4220000000000015`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[92]=",
 CellID->57349852]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"BetaDistribution", "[", 
      RowBox[{"7", ",", "3"}], "]"}], ",", 
     RowBox[{"10", "^", "6"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[93]:=",
 CellID->239183609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0210000000000046`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[93]=",
 CellID->216735632]
}, Open  ]],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["StudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFormula"],
 " the method used by ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " is a polar rejection method due to Bailey [",
 Cell[BoxData[
  ButtonBox["14",
   BaseStyle->"Hyperlink",
   ButtonData->"Bailey"]], "InlineFormula"],
 "]. This method is more efficient than direct construction from normal and \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " variates as can be seen in the following. The direct construction takes \
roughly 1.5 times as long as the polar method for a million Student's ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " variates."
}], "Text",
 CellID->760115118],

Cell[TextData[{
 "Comparison of direct construction and Bailey's polar rejection method for \
Student's ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->497763262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0", ",", "1"}], "]"}], ",", 
      RowBox[{"10", "^", "6"}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"ChiSquareDistribution", "[", "6", "]"}], ",", 
        RowBox[{"10", "^", "6"}]}], "]"}], "/", "6"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[94]:=",
 CellID->608133],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.2820000000000051`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[94]=",
 CellID->18796968]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"StudentTDistribution", "[", "6", "]"}], ",", 
     RowBox[{"10", "^", "6"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[95]:=",
 CellID->489471199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6110000000000027`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[95]=",
 CellID->387024250]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Discrete distributions", "Subsection",
 CellID->222897986],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeometricDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BetaBinomialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaBinomialDistribution"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["BetaNegativeBinomialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaNegativeBinomialDistribution"]], 
  "InlineFormula"],
 " use direct construction. ",
 Cell[BoxData[
  ButtonBox["GeometricDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricDistribution"]], "InlineFormula"],
 " variates are generated as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftFloor]", 
    FractionBox[
     RowBox[{"log", "(", "U", ")"}], 
     RowBox[{"log", "(", 
      RowBox[{"1", "-", "p"}], ")"}]], "\[RightFloor]"}], TraditionalForm]], 
  "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " follows ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UniformDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UniformDistribution"], "[", 
   RowBox[{"0", ",", "1"}], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["BetaBinomialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaBinomialDistribution"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BetaNegativeBinomialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaNegativeBinomialDistribution"]], 
  "InlineFormula"],
 " are constructed from ",
 Cell[BoxData[
  ButtonBox["BinomialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinomialDistribution"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NegativeBinomialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NegativeBinomialDistribution"]], "InlineFormula"],
 " variates with probability parameters taken as random ",
 Cell[BoxData[
  ButtonBox["BetaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaDistribution"]], "InlineFormula"],
 " variates."
}], "Text",
 CellID->688854147],

Cell[TextData[{
 "When used, table lookups for random integer generation are implemented via \
",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " using the distribution's probability mass function for the weights. Most \
discrete distributions switch to other methods whenever construction of the \
list of weights is expected to be expensive given the desired sampled size. \
For example, as ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " approaches 1 ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogSeriesDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogSeriesDistribution"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 " switches to the direct construction ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftFloor]", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"log", "(", "V", ")"}], 
      RowBox[{"log", "(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}], "U"]}], ")"}]]}], "\[RightFloor]"}],
    TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]], "InlineMath"],
 " are uniformly distributed on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", "1"}], "]"}], TraditionalForm]], "InlineMath"],
 " [",
 Cell[BoxData[
  ButtonBox["15",
   BaseStyle->"Hyperlink",
   ButtonData->"Devroye"]], "InlineFormula"],
 "]. Depending on parameters and sample size ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NegativeBinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NegativeBinomialDistribution"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " may switch to construction as a Poisson-gamma mixture, which is a Poisson \
variable with mean following a gamma distribution [",
 Cell[BoxData[
  ButtonBox["6",
   BaseStyle->"Hyperlink",
   ButtonData->"Gentle"]], "InlineFormula"],
 "]."
}], "Text",
 CellID->676686120],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinomialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinomialDistribution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HypergeometricDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricDistribution"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["PoissonDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFormula"],
 " rely on direct sampling from the density function if the computational \
overhead of computing the PDF values is small relative to the number of \
desired random values. Otherwise they switch to acceptance\[Hyphen]rejection \
methods. The acceptance-rejection methods also allow for generation of \
variates when overflows or underflows would occur in directly computing the \
PDF values, thus extending the range of parameter values for which random \
numbers can be generated."
}], "Text",
 CellID->241018388],

Cell[TextData[{
 "The binomial and hypergeometric distributions switch to \
acceptance\[Hyphen]rejection methods due to Kachitvichyanukul and Schmeiser \
with small modifications. The binomial method, based on the acceptance\
\[Hyphen]rejection portion of their BTPE (Binomial, Triangle, Parallelogram, \
Exponential) algorithm [",
 Cell[BoxData[
  ButtonBox["16",
   BaseStyle->"Hyperlink",
   ButtonData->"BTPE"]], "InlineFormula"],
 "], effectively uses a piecewise majorizing function with three regions and \
a triangular minorizing function for a quick acceptance test. The majorizing \
and minorizing functions create a two\[Hyphen]parallelogram envelope around \
the center of the rescaled binomial density, and the tails of the majorizing \
function form exponential envelopes on the tails of the scaled binomial \
distribution. One case where it is clearly better to use BTPE rather than to \
construct a lookup table is when few observations are desired and the lookup \
table would be large."
}], "Text",
 CellID->163022094],

Cell[TextData[{
 "The hypergeometric method, based on the acceptance\[Hyphen]rejection \
portion of Kachitvichyanukul and Schmeiser's H2PE algorithm [",
 Cell[BoxData[
  ButtonBox["17",
   BaseStyle->"Hyperlink",
   ButtonData->"H2PE"]], "InlineFormula"],
 "], uses a majorizing function with three regions around a scaled \
hypergeometric density. The middle portion of the density is enveloped by a \
rectangular region and the tails of the distribution are bounded by \
exponentials."
}], "Text",
 CellID->339383142],

Cell[TextData[{
 "The acceptance\[Hyphen]rejection method used by ",
 Cell[BoxData[
  ButtonBox["PoissonDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFormula"],
 " is due to Ahrens and Dieter [",
 Cell[BoxData[
  ButtonBox["18",
   BaseStyle->"Hyperlink",
   ButtonData->"AhrensDieter"]], "InlineFormula"],
 "]. The acceptance and rejection is carried out using discrete normal \
variates, taking advantage of the tendency of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PoissonDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PoissonDistribution"], "[", 
   StyleBox["\[Mu]", "TR"], "]"}]], "InlineFormula"],
 " toward ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"], "[", 
   RowBox[{
    StyleBox["\[Mu]", "TR"], ",", 
    SqrtBox[
     StyleBox["\[Mu]", "TR"]]}], "]"}]], "InlineFormula"],
 "as ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineMath"],
 " increases."
}], "Text",
 CellID->344810340],

Cell[TextData[{
 "Random values from the ",
 Cell[BoxData[
  ButtonBox["ZipfDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZipfDistribution"]], "InlineFormula"],
 " are generated via an acceptance\[Hyphen]rejection method described by \
Devroye [",
 Cell[BoxData[
  ButtonBox["15",
   BaseStyle->"Hyperlink",
   ButtonData->"Devroye"]], "InlineFormula"],
 "]. The method uses pairs of uniform variates and a test involving only a ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " and noninteger powers, aside from basic arithmetic, to efficiently obtain \
Zipf\[Hyphen]distributed values."
}], "Text",
 CellID->492968738]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining distributions", "Subsection",
 CellTags->"DefiningDistributions",
 CellID->155138169],

Cell[TextData[{
 "Definitions for distributions are supported through rules for ",
 Cell[BoxData["Random`DistributionVector"], "InlineFormula"],
 ". ",
 Cell[BoxData["DistributionVector"], "InlineFormula"],
 " is expected to return a vector of the given length with numbers of the \
given precision."
}], "Text",
 CellID->226627364],

Cell[BoxData[GridBox[{
   {
    RowBox[{"Random`DistributionVector", "[", 
     RowBox[{
      StyleBox["dist", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["prec", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "defines rules for generating ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " observations from ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     " with precision ",
     Cell[BoxData[
      StyleBox["prec", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->297913222],

Cell["Function for defining random generation from distributions.", "Caption",
 CellID->391197044],

Cell[TextData[{
 "Rules for generating random values from distributions are generally defined \
via a ",
 Cell[BoxData[
  ButtonBox["TagSet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"]], "InlineFormula"],
 " on the head of the distribution. The distribution itself may contain \
parameters. As a simple example, the following defines rules for ",
 Cell[BoxData[
  RowBox[{"NegativeOfUniform", "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " , which represents a uniform distribution on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "a"}]}], "]"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->386939091],

Cell[BoxData[
 RowBox[{"NegativeOfUniform", "/:", "\[IndentingNewLine]", 
  RowBox[{"Random`DistributionVector", "[", 
   RowBox[{
    RowBox[{"NegativeOfUniform", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ",", "n_Integer", ",", 
    RowBox[{"prec_", "?", "Positive"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "n", ",", 
      RowBox[{"WorkingPrecision", "->", "prec"}]}], "]"}]}], "/;", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"VectorQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "NumericQ"}], "]"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "Reals"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[96]:=",
 CellID->163709496],

Cell[TextData[{
 "Random numbers from ",
 Cell[BoxData["NegativeOfUniform"], "InlineFormula"],
 " can now be generated via ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " just like any built-in continuous distribution."
}], "Text",
 CellID->757995541],

Cell[TextData[{
 "The following give a machine-precision and a precision-20 number from ",
 Cell[BoxData["NegativeOfUniform"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->461654446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"NegativeOfUniform", "[", 
     RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NegativeOfUniform", "[", 
      RowBox[{"1", ",", "3"}], "]"}], ",", 
     RowBox[{"WorkingPrecision", "->", "20"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[97]:=",
 CellID->442051976],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.906618370108771`"}], ",", 
   RowBox[{"-", "2.02311133014078171823025426023789918872`20."}]}], 
  "}"}]], "Output",
 ImageSize->{241, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[97]=",
 CellID->142540992]
}, Open  ]],

Cell[TextData[{
 "Matrices and higher\[Hyphen]dimensional tensors can also be generated \
directly via ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " uses the definition given to ",
 Cell[BoxData["Random`DistributionVector"], "InlineFormula"],
 " to generate the total number of random values desired, and partitions that \
total number into the specified dimensions."
}], "Text",
 CellID->42938867],

Cell[TextData[{
 "Here is a 3\[Times]4 array of ",
 Cell[BoxData["NegativeOfUniform"], "InlineFormula"],
 " numbers."
}], "MathCaption",
 CellID->173872560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"NegativeOfUniform", "[", 
    RowBox[{"7", ",", "21"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[98]:=",
 CellID->396558676],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "7.449518809610082`"}], ",", 
     RowBox[{"-", "7.125762735860844`"}], ",", 
     RowBox[{"-", "15.661594822877163`"}], ",", 
     RowBox[{"-", "13.998458328039444`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "18.37753166774053`"}], ",", 
     RowBox[{"-", "11.659715043421022`"}], ",", 
     RowBox[{"-", "17.395526055276942`"}], ",", 
     RowBox[{"-", "15.416439715786801`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "13.233417209088085`"}], ",", 
     RowBox[{"-", "17.433718120954882`"}], ",", 
     RowBox[{"-", "20.54419896176349`"}], ",", 
     RowBox[{"-", "15.083552453056077`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{578, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[98]=",
 CellID->91323423]
}, Open  ]],

Cell[TextData[{
 "Discrete distributions can be defined in a similar way. The main difference \
is that the precision argument to ",
 Cell[BoxData["Random`DistributionVector"], "InlineFormula"],
 " will now be ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". The discrete version of ",
 Cell[BoxData["NegativeOfUniform"], "InlineFormula"],
 " provides a simple example."
}], "Text",
 CellID->379626560],

Cell[BoxData[
 RowBox[{"NegativeOfDiscreteUniform", "/:", "\[IndentingNewLine]", 
  RowBox[{"Random`DistributionVector", "[", 
   RowBox[{
    RowBox[{"NegativeOfDiscreteUniform", "[", 
     RowBox[{"a_Integer", ",", "b_Integer"}], "]"}], ",", "n_Integer", ",", 
    "Infinity"}], "]"}], ":=", 
  RowBox[{"-", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "n"}], "]"}]}]}]], "Input",
 CellLabel->"In[99]:=",
 CellID->980368218],

Cell[TextData[{
 "Random values from ",
 Cell[BoxData["NegativeOfDiscreteUniform"], "InlineFormula"],
 " can now be obtained from ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 "."
}], "Text",
 CellID->290895708],

Cell[TextData[{
 "Here are 10 ",
 Cell[BoxData["NegativeOfDiscreteUniform"], "InlineFormula"],
 " numbers."
}], "MathCaption",
 CellID->279910127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"NegativeOfDiscreteUniform", "[", 
    RowBox[{"1", ",", "3"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[100]:=",
 CellID->22057528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[100]=",
 CellID->195319682]
}, Open  ]],

Cell[TextData[{
 "While the previous examples show the basic framework for defining \
distributions, the distributions themselves are not particularly interesting. \
In fact, it would have been easier in these two cases to just generate values \
from ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " and multiply the end result by -1 instead of attaching definitions to a \
new distribution symbol. The following examples will demonstrate slightly \
more complicated distributions, in which case attaching definitions to a \
distribution will be more useful."
}], "Text",
 CellID->135939224],

Cell[CellGroupData[{

Cell["Example: normal distribution by inversion", "Subsubsection",
 CellID->301517985],

Cell["\<\
The textbook definition for generating random values from a generic \
univariate statistical distribution involves two steps: \
\>", "Text",
 CellID->69609371],

Cell[TextData[{
 "generate a uniform random number ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", "1"}], "]"}], TraditionalForm]], "InlineMath"]
}], "BulletedText",
 CellID->1022472671],

Cell[CellGroupData[{

Cell[TextData[{
 "compute the inverse cumulative distribution function of ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " for the distribution of interest"
}], "BulletedText",
 CellID->407897249],

Cell[TextData[{
 "To demonstrate the process, use the normal distribution. To generate random \
normal variates using this method, start with the ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " for the normal distribution at a point ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " and replace ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " with a random uniform between 0 and 1."
}], "Text",
 CellID->240367624],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " function for a normal with mean ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineMath"],
 " and standard deviation ",
 Cell[BoxData[
  FormBox["\[Sigma]", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->221271130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[101]:=",
 CellID->27142828],

Cell[BoxData[
 RowBox[{"\[Mu]", "+", 
  RowBox[{
   SqrtBox["2"], " ", "\[Sigma]", " ", 
   RowBox[{"InverseErf", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "q"}]}], "]"}]}]}]], "Output",
 ImageSize->{189, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[101]=",
 CellID->524821246]
}, Open  ]],

Cell["\<\
A new distribution object can now be used to define a normal random number \
generator that uses inversion of the cumulative distribution function.\
\>", "Text",
 CellID->542968583],

Cell["This defines generation of normals by inversion.", "MathCaption",
 CellID->238508485],

Cell[BoxData[
 RowBox[{"NormalByInversion", "/:", "\[IndentingNewLine]", 
  RowBox[{"Random`DistributionVector", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NormalByInversion", "[", 
     RowBox[{
      RowBox[{"mu_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"NumericQ", "[", "#", "]"}], "&&", 
          RowBox[{
           RowBox[{"Im", "[", "#", "]"}], "===", "0"}]}], "&"}], ")"}]}], ",",
       
      RowBox[{"sigma_", "?", "Positive"}]}], "]"}], ",", "n_Integer", ",", 
    RowBox[{"prec_", "?", "Positive"}]}], "]"}], ":=", 
  RowBox[{"mu", "+", 
   RowBox[{
    SqrtBox["2"], " ", "sigma", " ", 
    RowBox[{"InverseErf", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", "n", ",", 
         RowBox[{"WorkingPrecision", "->", "prec"}]}], "]"}]}]}], 
     "]"}]}]}]}]], "Input",
 CellLabel->"In[102]:=",
 CellID->13524569],

Cell["Here are 10 random normals generated by inversion.", "MathCaption",
 CellID->120045305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"NormalByInversion", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[103]:=",
 CellID->27011428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.4576365113977734`"}], ",", 
   RowBox[{"-", "1.598541124701708`"}], ",", "1.534921774617536`", ",", 
   "1.8525101737694802`", ",", "5.062226122646251`", ",", 
   RowBox[{"-", "0.7658278281084339`"}], ",", 
   RowBox[{"-", "2.8677771244326626`"}], ",", 
   RowBox[{"-", "0.5123587525321436`"}], ",", "1.5551423221526686`", ",", 
   "4.641433033343285`"}], "}"}]], "Output",
 ImageSize->{405, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[103]=",
 CellID->227544837]
}, Open  ]],

Cell[TextData[{
 "Here is a sample of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]], "InlineMath"],
 " random normals along with the sample mean and standard deviation."
}], "MathCaption",
 CellID->864417951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"ninv", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"NormalByInversion", "[", 
        RowBox[{"1", ",", "2"}], "]"}], ",", 
       RowBox[{"10", "^", "4"}]}], "]"}]}], ")"}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[104]:=",
 CellID->353066439],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.384999999999998`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[104]=",
 CellID->408932129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "[", "ninv", "]"}], ",", 
   RowBox[{"StandardDeviation", "[", "ninv", "]"}]}], "}"}]], "Input",
 CellLabel->"In[105]:=",
 CellID->322532405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9893651429375888`", ",", "2.0114452937560388`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[105]=",
 CellID->720054186]
}, Open  ]],

Cell[TextData[{
 "The normal distribution is one example where methods other than direct \
inversion are generally preferred. While inversion of the ",
 "CDF",
 " is a perfectly valid method for generating pseudorandom normal numbers, it \
is not particularly efficient. Numeric evaluation of ",
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 " is computationally much more expensive than the sinusoid and logarithmic \
evaluations required by the Box\[Dash]M\[UDoubleDot]ller method used by ",
 Cell[BoxData[
  ButtonBox["NormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormalDistribution"]], "InlineFormula"],
 "."
}], "Text",
 CellID->22239395],

Cell["\<\
The built-in method takes almost no time for the same number of values.\
\>", "MathCaption",
 CellID->37131244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"ndist", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"1", ",", "2"}], "]"}], ",", 
       RowBox[{"10", "^", "4"}]}], "]"}]}], ")"}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[106]:=",
 CellID->270422545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[106]=",
 CellID->240723233]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "[", "ndist", "]"}], ",", 
   RowBox[{"StandardDeviation", "[", "ndist", "]"}]}], "}"}]], "Input",
 CellLabel->"In[107]:=",
 CellID->3617447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0292150150097426`", ",", "1.9955187092677484`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[107]=",
 CellID->262589401]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"ninv", ",", "ndist"}], "]"}]], "Input",
 CellLabel->"In[108]:=",
 CellID->665203069]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example: Uniform distribution on a disk", "Subsubsection",
 CellID->132002727],

Cell[TextData[{
 Cell[BoxData["Random`DistributionVector"], "InlineFormula"],
 " can also be used to define generators for multidimensional distributions. \
For instance, suppose a random point from a uniform distribution on the unit \
disk, the set of real points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]], "\[LessEqual]", "1"}], TraditionalForm]], 
  "InlineMath"],
 ", is desired. Such a random point can be constructed as follows:"
}], "Text",
 CellID->223083910],

Cell[TextData[{
 "generate a random angle ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineMath"],
 " uniformly distributed on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", " ", 
     RowBox[{"2", 
      StyleBox["\[Pi]", "TR"]}]}], ")"}], TraditionalForm]], "InlineMath"]
}], "BulletedText",
 CellID->18450053],

Cell[TextData[{
 "generate a random vector ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " uniformly distributed on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", "1"}], "]"}], TraditionalForm]], "InlineMath"]
}], "BulletedText",
 CellID->88943028],

Cell[CellGroupData[{

Cell[TextData[{
 "return ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox["u"], "sin", "\[Phi]"}], ",", 
     RowBox[{
      SqrtBox["u"], "cos", "\[Phi]"}]}], "}"}], TraditionalForm]], 
  "InlineMath"]
}], "BulletedText",
 CellID->554520807],

Cell[TextData[{
 "The returned ordered pair can be multiplied by ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " to generate points uniformly distributed on a disk of radius ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->71383229],

Cell[TextData[{
 "The following defines a generator for a uniform disk of radius ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->33041809],

Cell[BoxData[
 RowBox[{"UniformDisk", "/:", "\[IndentingNewLine]", 
  RowBox[{"Random`DistributionVector", "[", 
   RowBox[{
    RowBox[{"UniformDisk", "[", 
     RowBox[{"r_", "?", "Positive"}], "]"}], ",", "n_Integer", ",", 
    RowBox[{"prec_", "?", "Positive"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  
  RowBox[{"r", "*", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", "n", ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "prec"}]}], "]"}], "]"}], "*", 
   "\[IndentingNewLine]", 
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "#", "]"}], ",", 
        RowBox[{"Sin", "[", "#", "]"}]}], "}"}], "&"}], "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"2", "Pi"}], ",", "n", ",", 
       RowBox[{"WorkingPrecision", "\[Rule]", "prec"}]}], "]"}], "]"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[109]:=",
 CellID->430238184],

Cell["Here is one random ordered pair from a disk of radius 2.", "MathCaption",
 CellID->126063801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"UniformDisk", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[110]:=",
 CellID->348058384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.23232511921577723`", ",", "0.6600457954620502`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[110]=",
 CellID->379192092]
}, Open  ]],

Cell[TextData[{
 "The following visualizes the distribution of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]], "InlineMath"],
 " generated points on this disk. "
}], "MathCaption",
 CellID->301272109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"UniformDisk", "[", "2", "]"}], ",", "1000"}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[111]:=",
 CellID->20349099],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[111]=",
 CellID->73509560]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example: Dirichlet distribution", "Subsubsection",
 CellID->70634134],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Hyphen]dimensional Dirichlet distribution is parameterized by a vector of \
positive values ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Alpha]", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["\[Alpha]", "n"]}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " and has support on the set of vectors ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", 
       RowBox[{"1", ","}]], "\[Ellipsis]"}], ",", 
     SubscriptBox["x", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "1"}], "n"], 
     SubscriptBox["x", "i"]}], "=", "1"}], TraditionalForm]], "InlineMath"],
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "i"], "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", "1"}], "]"}]}], TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " from 1 to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". Thus, the Dirichlet distribution is defined on an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "-", "1"}], TraditionalForm]], "InlineMath"],
 " dimensional subspace of the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Hyphen]dimensional unit hypercube ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"[", 
     RowBox[{"0", ",", "1"}], "]"}], "n"], TraditionalForm]], "InlineMath"],
 ". The Dirichlet distribution is the multivariate extension of the beta \
distribution. If ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " follows ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"1", "-", "y"}]}], "}"}], TraditionalForm]], "InlineMath"],
 " follows a Dirichlet distribution with parameter vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->112688026],

Cell[TextData[{
 "An ",
 StyleBox["n",
  FontSlant->"Italic"],
 "\[Hyphen]dimensional Dirichlet variate can be generated from ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " gamma variates. With parameter vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Alpha]", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["\[Alpha]", "n"]}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ",",
 " ",
 "the process is as follows:"
}], "Text",
 CellID->10618202],

Cell[TextData[{
 "generate a random number ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "i"], TraditionalForm]], "InlineMath"],
 " from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GammaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaDistribution"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Alpha]", "TR"], 
     StyleBox["1", "TR"]], ",", "1"}], "]"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " from 1 to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"]
}], "BulletedText",
 CellID->159755815],

Cell[CellGroupData[{

Cell[TextData[{
 "return ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["\[Gamma]", "n"]}], "}"}], "/", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "1"}], "n"], 
     SubscriptBox["\[Gamma]", "i"]}]}], TraditionalForm]], "InlineMath"]
}], "BulletedText",
 CellID->478030536],

Cell[TextData[{
 "This defines a Dirichlet generator attached to the symbol ",
 Cell[BoxData["DirichletDistribution"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->155428599],

Cell[BoxData[
 RowBox[{"DirichletDistribution", "/:", 
  RowBox[{"Random`DistributionVector", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DirichletDistribution", "[", 
     RowBox[{"alpha_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"VectorQ", "[", 
         RowBox[{"#", ",", "Positive"}], "]"}], "&"}], ")"}]}], "]"}], ",", 
    "n_Integer", ",", 
    RowBox[{"prec_", "?", "Positive"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", "gammas", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"gammas", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"GammaDistribution", "[", 
            RowBox[{"#", ",", "1"}], "]"}], ",", "n", ",", 
           RowBox[{"WorkingPrecision", "\[Rule]", "prec"}]}], "]"}], "&"}], 
        ",", "alpha"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Transpose", "[", "gammas", "]"}], "/", 
      RowBox[{"Total", "[", "gammas", "]"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[112]:=",
 CellID->592587094],

Cell["\<\
Here is a three\[Hyphen]dimensional Dirichlet vector with precision 25.\
\>", "MathCaption",
 CellID->213498442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"DirichletDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", 
      RowBox[{"5", "/", "2"}]}], "}"}], "]"}], ",", 
   RowBox[{"WorkingPrecision", "->", "25"}]}], "]"}]], "Input",
 CellLabel->"In[113]:=",
 CellID->461738284],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.01839604137321369637771128639530371925`25.", ",", 
   "0.6997948901744933898460559872907848079`25.", ",", 
   "0.28180906845229291377623272631391147284`25."}], "}"}]], "Output",
 ImageSize->{408, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[113]=",
 CellID->48753385]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example: Gibbs sampler", "Subsubsection",
 CellTags->"GibbsSamplerExample",
 CellID->15716282],

Cell[TextData[{
 "Gibbs samplers can also be defined as distributions. As an example we will \
take a Gibbs sampler that mixes beta and binomial distributions. A specific \
case of this sampler was explored in a ",
 ButtonBox["previous example",
  BaseStyle->"Hyperlink",
  ButtonData->"GibbsSampler"],
 ". Here, the distribution will be defined with two parameters ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 "."
}], "Text",
 CellID->490895286],

Cell[TextData[{
 "This defines a Gibbs sampler ",
 Cell[BoxData["BinomialBetaSampler"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->592240592],

Cell[BoxData[
 RowBox[{"BinomialBetaSampler", "/:", 
  RowBox[{"Random`DistributionVector", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BinomialBetaSampler", "[", 
     RowBox[{"m_Integer", ",", 
      RowBox[{"\[Alpha]_", "?", "Positive"}]}], "]"}], ",", "n_Integer", ",", 
    
    RowBox[{"prec_", "?", "Positive"}]}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y0", ",", "dist1", ",", "dist2", ",", "y1", ",", "x0"}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"y0", "=", ".5"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dist1", "[", "y_", "]"}], ":=", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"BinomialDistribution", "[", 
        RowBox[{"m", ",", "y"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"dist2", "[", "x_", "]"}], ":=", 
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"BetaDistribution", "[", 
         RowBox[{
          RowBox[{"x", "+", "\[Alpha]"}], ",", 
          RowBox[{"m", "-", "x", "+", "4"}]}], "]"}], ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", "prec"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y1", "=", "y0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x0", "=", 
           RowBox[{"dist1", "[", "y0", "]"}]}], ",", 
          RowBox[{"y0", "=", 
           RowBox[{"dist2", "[", "x0", "]"}]}]}], "}"}]}], ",", 
       RowBox[{"{", "1000", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y1", "=", "y0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x0", "=", 
           RowBox[{"dist1", "[", "y0", "]"}]}], ",", 
          RowBox[{"y0", "=", 
           RowBox[{"dist2", "[", "x0", "]"}]}]}], "}"}]}], ",", 
       RowBox[{"{", "n", "}"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[114]:=",
 CellID->145732411],

Cell[TextData[{
 "For the specific Gibbs sampler constructed earlier, ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " was 16 and ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " was 2."
}], "Text",
 CellID->163462406],

Cell[TextData[{
 "Here are 5 vectors from the sampler with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", "16"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", "2"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->83569915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"BinomialBetaSampler", "[", 
    RowBox[{"16", ",", "2"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[115]:=",
 CellID->234579757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0.047440388696289595`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0.19205394330666212`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0.2997685794342642`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0.11368323107292491`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0.04807144755659167`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{518, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[115]=",
 CellID->387698823]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section",
 CellID->483626572],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "S. Geman and D. Geman, \"Stochastic Relaxation, Gibbs Distributions, and \
the Bayesian Restoration of Images,\" ",
 StyleBox["IEEE Transactions on Pattern Analysis and Machine Intelligence",
  FontSlant->"Italic"],
 " 6(6), 1984 pp. 721\[Dash]741. "
}], "Reference",
 CellTags->"GemanGeman",
 CellID->408824937],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "G. Casella and E. I. George, \"Explaining the Gibbs Sampler,\" ",
 StyleBox["The American Statistician",
  FontSlant->"Italic"],
 " 46(3), 1992 pp. 167\[Dash]174."
}], "Reference",
 CellTags->"CasellaGeorge",
 CellID->242992614],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "M. Matsumoto and T. Nishimura, \"Mersenne Twister: a 623-Dimensionally \
Equidistributed Uniform Pseudorandom Number Generator,\" ",
 StyleBox["ACM Transactions on Modeling and Computer Simulation",
  FontSlant->"Italic"],
 " 8(1), 1998 pp. 3\[Dash]30."
}], "Reference",
 CellTags->"MatsumotoNishimura",
 CellID->440717610],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "T. Nishimura, \"Tables of 64-Bit Mersenne Twisters,\" ",
 StyleBox["ACM Transactions on Modeling and Computer Simulation",
  FontSlant->"Italic"],
 " 10(4), 2000 pp. 348",
 "\[Dash]",
 "357."
}], "Reference",
 CellTags->"Nishimura",
 CellID->17711876],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "P. Junod, \"Cryptographic Secure Pseudo-Random Bits Generation: The Blum\
\[Dash]Blum\[Dash]Shub Generator,\" (August 1999) \
http://crypto.junod.info/bbs.pdf"
}], "Reference",
 CellTags->"Junod",
 CellID->27959193],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "J. E. Gentle, ",
 StyleBox["Random Number Generation and Monte Carlo Methods",
  FontSlant->"Italic"],
 ", 2nd ed., New York: Springer-Verlag, 2003. "
}], "Reference",
 CellTags->"Gentle",
 CellID->433710669],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "N. L. Johnson, S. Kotz, and N. Balakrishnan, ",
 StyleBox["Continuous Univariate Distributions, Volume 2",
  FontSlant->"Italic"],
 ", 2nd ed., New York: John Wiley & Sons, 1995."
}], "Reference",
 CellTags->"JohnsonKotzBalakrishnan",
 CellID->185370529],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "W. B. Smith and R. R. Hocking, \"Algorithm AS 53: Wishart Variate \
Generator,\" ",
 StyleBox["Applied Statistics",
  FontSlant->"Italic"],
 " 21(3), 1972 pp. 341\[Dash]345."
}], "Reference",
 CellTags->"SmithHocking",
 CellID->2642763],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "R. C. H. Cheng and G. M. Feast, \"Some Simple Gamma Variate Generators,\" \
",
 StyleBox["Applied Statistics",
  FontSlant->"Italic"],
 " 28(3), 1979 pp. 290\[Dash]295."
}], "Reference",
 CellTags->"ChengFeast",
 CellID->197589201],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "M. E. Johnson, ",
 StyleBox["Multivariate Statistical Simulation",
  FontSlant->"Italic"],
 ", New York: John Wiley & Sons, 1987."
}], "Reference",
 CellTags->"Johnson",
 CellID->432715931],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "M. D. J\[ODoubleDot]hnk, \"Erzeugung von Betaverteilten und Gammaverteilten \
Zufallszahlen\", ",
 StyleBox["Metrika",
  FontSlant->"Italic"],
 " 8, 1964 pp. 5\[Dash]15."
}], "Reference",
 CellTags->"Johnk",
 CellID->60616796],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "R. C. H. Cheng, \"Generating Beta Variables with Nonintegral Shape \
Parameters,\" ",
 StyleBox["Communications of the ACM",
  FontSlant->"Italic"],
 " 21(4), 1978 pp. 317\[Dash]322."
}], "Reference",
 CellTags->"Cheng",
 CellID->347364034],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "A. C. Atkinson, \"A Family of Switching Algorithms for the Computer \
Generation of Beta Random Variables,\" ",
 StyleBox["Biometrika",
  FontSlant->"Italic"],
 " 66(1), 1979 pp. 141\[Dash]145."
}], "Reference",
 CellTags->"Atkinson",
 CellID->514602903],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "R. W. Bailey, \"Polar Generation of Random Variates with the ",
 StyleBox["t",
  FontSlant->"Italic"],
 "-Distribution,\" ",
 StyleBox["Mathematics of Computation",
  FontSlant->"Italic"],
 " 62(206), 1994 pp. 779\[Dash]781."
}], "Reference",
 CellTags->"Bailey",
 CellID->431268247],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "L. Devroye, ",
 StyleBox["Non-Uniform Random Variate Generation",
  FontSlant->"Italic"],
 ", New York: Springer-Verlag, 1986."
}], "Reference",
 CellTags->"Devroye",
 CellID->371900916],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "V. Kachitvichyanukul and B. W. Schmeiser, \"Binomial Random Variate \
Generation,\" ",
 StyleBox["Communications of the ACM",
  FontSlant->"Italic"],
 " 31(2), 1988 pp. 216\[Dash]223."
}], "Reference",
 CellTags->"BTPE",
 CellID->337532825],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "V. Kachitvichyanukul and B. W. Schmeiser, \"Computer Generation of \
Hypergeometric Random Variates,\" ",
 StyleBox["Journal of Statistical Computation and Simulation",
  FontSlant->"Italic"],
 " 22(2), 1985 pp. 127\[Dash]145."
}], "Reference",
 CellTags->"H2PE",
 CellID->252215890],

Cell[TextData[{
 Cell[TextData[{
  "[",
  
  CounterBox["Reference"],
  "]\[ThickSpace]\[MediumSpace]"
 }],
  CellSize->{30, Inherited},
  TextAlignment->Right],
 "J. H. Ahrens and U. Dieter, \"Computer Generation of Poisson Deviates from \
Modified Normal Distributions,\" ",
 StyleBox["ACM Transactions on Mathematical Software",
  FontSlant->"Italic"],
 " 8(2), 1982 pp. 163\[Dash]179."
}], "Reference",
 CellTags->"AhrensDieter",
 CellID->179402736],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->70400116],

Cell[TextData[{
 ButtonBox["M215: Applied Statistical Analysis with ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->55680198]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Random Number Generation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 6.1060962}", "context" -> "", 
    "keywords" -> {
     "initialization", "random number generator", "random number generation", 
      "random seed", "random state", "seeding of random generator", 
      "seed random", "random sample", "random subset", "random permutation", 
      "sampling without replacement", "rand", "random real", "rnd", 
      "random number", "random prime", "randomint", "random integer", 
      "random complex", "random complex number", "Gibbs sampler", 
      "defining distributions", "defining generators", "generator methods", 
      "number generator", "simulation", "Monte Carlo simulation", 
      "congruential", "linear congruential", "multiplicative congruential", 
      "ca generator", "cellular automaton number generator", 
      "Mersenne Twister", "Blum Blum Shub", "MKL generator", 
      "Neiderreiter sequence", "Sobol sequence", "low discrepancy numbers", 
      "low discrepancy sequence", "bit generator"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The ability to generate pseudorandom numbers is important for simulating \
events, estimating probabilities and other quantities, making randomized \
assignments or selections, and numerically testing symbolic results. Such \
applications may require uniformly distributed numbers, nonuniformly \
distributed numbers, elements sampled with replacement, or elements sampled \
without replacements. The functions RandomReal, RandomInteger, and \
RandomComplex generate uniformly distributed random numbers. RandomReal and \
RandomInteger also generate numbers for built-in distributions. RandomPrime \
generates primes within a range. The functions RandomChoice and RandomSample \
sample from a list of values with or without replacement. The elements may \
have equal or unequal weights. A framework is also included for defining \
additional methods and distributions for random number generation. A sequence \
of nonrecurring events can be simulated via RandomSample. For instance the \
probability of randomly sampling the integers 1 through n in order might be \
simulated.", "synonyms" -> {}, "title" -> "Random Number Generation", "type" -> 
    "Tutorial", "uri" -> "tutorial/RandomNumberGeneration"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GibbsSampler"->{
  Cell[46203, 1587, 681, 15, 70, "Text",
   CellTags->"GibbsSampler",
   CellID->665384613]},
 "Methods"->{
  Cell[109608, 3644, 68, 2, 70, "Section",
   CellTags->"Methods",
   CellID->185956823]},
 "Generators"->{
  Cell[159069, 5069, 94, 2, 70, "Subsection",
   CellTags->"Generators",
   CellID->215995533]},
 "Distributions"->{
  Cell[184348, 5898, 92, 2, 70, "Section",
   CellTags->"Distributions",
   CellID->554867591]},
 "DefiningDistributions"->{
  Cell[221970, 7138, 100, 2, 70, "Subsection",
   CellTags->"DefiningDistributions",
   CellID->155138169]},
 "GibbsSamplerExample"->{
  Cell[259447, 8298, 100, 2, 70, "Subsubsection",
   CellTags->"GibbsSamplerExample",
   CellID->15716282]},
 "GemanGeman"->{
  Cell[263762, 8444, 476, 16, 70, "Reference",
   CellTags->"GemanGeman",
   CellID->408824937]},
 "CasellaGeorge"->{
  Cell[264241, 8462, 392, 15, 70, "Reference",
   CellTags->"CasellaGeorge",
   CellID->242992614]},
 "MatsumotoNishimura"->{
  Cell[264636, 8479, 487, 16, 70, "Reference",
   CellTags->"MatsumotoNishimura",
   CellID->440717610]},
 "Nishimura"->{
  Cell[265126, 8497, 415, 17, 70, "Reference",
   CellTags->"Nishimura",
   CellID->17711876]},
 "Junod"->{
  Cell[265544, 8516, 379, 14, 70, "Reference",
   CellTags->"Junod",
   CellID->27959193]},
 "Gentle"->{
  Cell[265926, 8532, 372, 15, 70, "Reference",
   CellTags->"Gentle",
   CellID->433710669]},
 "JohnsonKotzBalakrishnan"->{
  Cell[266301, 8549, 418, 15, 70, "Reference",
   CellTags->"JohnsonKotzBalakrishnan",
   CellID->185370529]},
 "SmithHocking"->{
  Cell[266722, 8566, 400, 16, 70, "Reference",
   CellTags->"SmithHocking",
   CellID->2642763]},
 "ChengFeast"->{
  Cell[267125, 8584, 395, 16, 70, "Reference",
   CellTags->"ChengFeast",
   CellID->197589201]},
 "Johnson"->{
  Cell[267523, 8602, 353, 15, 70, "Reference",
   CellTags->"Johnson",
   CellID->432715931]},
 "Johnk"->{
  Cell[267879, 8619, 390, 16, 70, "Reference",
   CellTags->"Johnk",
   CellID->60616796]},
 "Cheng"->{
  Cell[268272, 8637, 404, 16, 70, "Reference",
   CellTags->"Cheng",
   CellID->347364034]},
 "Atkinson"->{
  Cell[268679, 8655, 418, 16, 70, "Reference",
   CellTags->"Atkinson",
   CellID->514602903]},
 "Bailey"->{
  Cell[269100, 8673, 447, 18, 70, "Reference",
   CellTags->"Bailey",
   CellID->431268247]},
 "Devroye"->{
  Cell[269550, 8693, 350, 15, 70, "Reference",
   CellTags->"Devroye",
   CellID->371900916]},
 "BTPE"->{
  Cell[269903, 8710, 404, 16, 70, "Reference",
   CellTags->"BTPE",
   CellID->337532825]},
 "H2PE"->{
  Cell[270310, 8728, 447, 16, 70, "Reference",
   CellTags->"H2PE",
   CellID->252215890]},
 "AhrensDieter"->{
  Cell[270760, 8746, 453, 16, 70, "Reference",
   CellTags->"AhrensDieter",
   CellID->179402736]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GibbsSampler", 275016, 8847},
 {"Methods", 275124, 8851},
 {"Generators", 275232, 8855},
 {"Distributions", 275349, 8859},
 {"DefiningDistributions", 275474, 8863},
 {"GibbsSamplerExample", 275609, 8867},
 {"GemanGeman", 275735, 8871},
 {"CasellaGeorge", 275853, 8875},
 {"MatsumotoNishimura", 275979, 8879},
 {"Nishimura", 276101, 8883},
 {"Junod", 276209, 8887},
 {"Gentle", 276314, 8891},
 {"JohnsonKotzBalakrishnan", 276438, 8895},
 {"SmithHocking", 276568, 8899},
 {"ChengFeast", 276683, 8903},
 {"Johnson", 276795, 8907},
 {"Johnk", 276902, 8911},
 {"Cheng", 277006, 8915},
 {"Atkinson", 277114, 8919},
 {"Bailey", 277223, 8923},
 {"Devroye", 277331, 8927},
 {"BTPE", 277437, 8931},
 {"H2PE", 277540, 8935},
 {"AhrensDieter", 277651, 8939}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1431, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2056, 54, 60, 1, 70, "Title",
 CellID->35748191],
Cell[CellGroupData[{
Cell[2141, 59, 51, 1, 70, "Section",
 CellID->818101596],
Cell[2195, 62, 441, 8, 70, "Text",
 CellID->304003271],
Cell[2639, 72, 1509, 45, 70, "Text",
 CellID->160372189],
Cell[4151, 119, 413, 12, 70, "Text",
 CellID->581426197],
Cell[4567, 133, 274, 9, 70, "MathCaption",
 CellID->412052567],
Cell[CellGroupData[{
Cell[4866, 146, 1160, 33, 137, "Input",
 CellID->229152018],
Cell[6029, 181, 644, 21, 54, "Output",
 CellID->121819267]
}, Open  ]],
Cell[6688, 205, 123, 3, 70, "MathCaption",
 CellID->504467739],
Cell[CellGroupData[{
Cell[6836, 212, 313, 11, 70, "Input",
 CellID->385017307],
Cell[7152, 225, 721, 21, 54, "Output",
 CellID->790582335]
}, Open  ]],
Cell[7888, 249, 424, 11, 70, "Text",
 CellID->147703494],
Cell[8315, 262, 203, 7, 70, "MathCaption",
 CellID->386305087],
Cell[CellGroupData[{
Cell[8543, 273, 288, 9, 70, "Input",
 CellID->297804824],
Cell[8834, 284, 175, 5, 36, "Output",
 CellID->464555124]
}, Open  ]],
Cell[9024, 292, 115, 3, 70, "MathCaption",
 CellID->638918533],
Cell[CellGroupData[{
Cell[9164, 299, 237, 7, 70, "Input",
 CellID->543920759],
Cell[9404, 308, 159, 5, 36, "Output",
 CellID->59920938]
}, Open  ]],
Cell[9578, 316, 217, 5, 70, "Text",
 CellID->12444400],
Cell[9798, 323, 87, 1, 70, "MathCaption",
 CellID->348667463],
Cell[CellGroupData[{
Cell[9910, 328, 406, 13, 70, "Input",
 CellID->27987070],
Cell[10319, 343, 1984, 41, 128, "Output",
 CellID->35761101]
}, Open  ]],
Cell[12318, 387, 292, 6, 70, "Text",
 CellID->2336844],
Cell[12613, 395, 367, 13, 70, "MathCaption",
 CellID->6039911],
Cell[CellGroupData[{
Cell[13005, 412, 463, 16, 70, "Input",
 CellID->657901805],
Cell[13471, 430, 180, 5, 36, "Output",
 CellID->188665616]
}, Open  ]],
Cell[13666, 438, 376, 13, 70, "MathCaption",
 CellID->664779737],
Cell[CellGroupData[{
Cell[14067, 455, 580, 20, 70, "Input",
 CellID->564884648],
Cell[14650, 477, 175, 5, 36, "Output",
 CellID->73976611]
}, Open  ]],
Cell[14840, 485, 534, 11, 70, "Text",
 CellID->619267854],
Cell[15377, 498, 112, 3, 70, "MathCaption",
 CellID->294127448],
Cell[CellGroupData[{
Cell[15514, 505, 399, 12, 70, "Input",
 CellID->4713915],
Cell[15916, 519, 1531, 31, 153, "Output",
 CellID->474415466]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17496, 556, 66, 1, 70, "Section",
 CellID->550376464],
Cell[17565, 559, 1547, 53, 70, "Text",
 CellID->327571373],
Cell[CellGroupData[{
Cell[19137, 616, 56, 1, 70, "Subsection",
 CellID->121480422],
Cell[19196, 619, 897, 25, 70, "Text",
 CellID->369338644],
Cell[20096, 646, 3216, 110, 70, "DefinitionBox",
 CellID->199599391],
Cell[23315, 758, 66, 1, 70, "Caption",
 CellID->499117304],
Cell[23384, 761, 3448, 115, 70, "DefinitionBox",
 CellID->531316417],
Cell[26835, 878, 68, 1, 70, "Caption",
 CellID->18316830],
Cell[26906, 881, 2790, 94, 70, "DefinitionBox",
 CellID->163784474],
Cell[29699, 977, 76, 1, 70, "Caption",
 CellID->230396300],
Cell[29778, 980, 2554, 88, 70, "DefinitionBox",
 CellID->50986929],
Cell[32335, 1070, 67, 1, 70, "Caption",
 CellID->158144565],
Cell[32405, 1073, 898, 29, 70, "Text",
 CellID->57544653],
Cell[33306, 1104, 274, 6, 70, "Text",
 CellID->194525213],
Cell[33583, 1112, 356, 13, 70, "MathCaption",
 CellID->23172881],
Cell[CellGroupData[{
Cell[33964, 1129, 210, 7, 70, "Input",
 CellID->262773444],
Cell[34177, 1138, 224, 7, 36, "Output",
 CellID->289928106]
}, Open  ]],
Cell[34416, 1148, 220, 7, 70, "MathCaption",
 CellID->467055495],
Cell[CellGroupData[{
Cell[34661, 1159, 272, 9, 70, "Input",
 CellID->17681284],
Cell[34936, 1170, 225, 7, 36, "Output",
 CellID->227233802]
}, Open  ]],
Cell[35176, 1180, 872, 25, 70, "Text",
 CellID->720297143],
Cell[36051, 1207, 303, 10, 70, "MathCaption",
 CellID->59971858],
Cell[CellGroupData[{
Cell[36379, 1221, 273, 9, 70, "Input",
 CellID->572904742],
Cell[36655, 1232, 225, 7, 36, "Output",
 CellID->392772291]
}, Open  ]],
Cell[CellGroupData[{
Cell[36917, 1244, 216, 7, 70, "Input",
 CellID->817070028],
Cell[37136, 1253, 226, 7, 36, "Output",
 CellID->614459509]
}, Open  ]],
Cell[37377, 1263, 188, 6, 70, "MathCaption",
 CellID->277883751],
Cell[CellGroupData[{
Cell[37590, 1273, 384, 12, 70, "Input",
 CellID->460743089],
Cell[37977, 1287, 224, 7, 36, "Output",
 CellID->88679468]
}, Open  ]],
Cell[38216, 1297, 944, 27, 70, "Text",
 CellID->253583730],
Cell[39163, 1326, 208, 7, 70, "MathCaption",
 CellID->562785678],
Cell[CellGroupData[{
Cell[39396, 1337, 298, 9, 70, "Input",
 CellID->186068181],
Cell[39697, 1348, 230, 7, 36, "Output",
 CellID->464155129]
}, Open  ]],
Cell[39942, 1358, 224, 7, 70, "MathCaption",
 CellID->40888985],
Cell[CellGroupData[{
Cell[40191, 1369, 365, 12, 70, "Input",
 CellID->375117991],
Cell[40559, 1383, 227, 7, 36, "Output",
 CellID->605734433]
}, Open  ]],
Cell[40801, 1393, 224, 5, 70, "Text",
 CellID->27291744],
Cell[41028, 1400, 105, 2, 70, "MathCaption",
 CellID->539793375],
Cell[CellGroupData[{
Cell[41158, 1406, 324, 9, 70, "Input",
 CellID->27507839],
Cell[41485, 1417, 171, 5, 36, "Output",
 CellID->504529713]
}, Open  ]],
Cell[41671, 1425, 206, 6, 70, "MathCaption",
 CellID->23087406],
Cell[41880, 1433, 433, 13, 70, "Input",
 CellID->5311115],
Cell[42316, 1448, 223, 7, 70, "MathCaption",
 CellID->57104516],
Cell[CellGroupData[{
Cell[42564, 1459, 146, 4, 70, "Input",
 CellID->333654813],
Cell[42713, 1465, 461, 15, 36, "Output",
 CellID->344878370]
}, Open  ]],
Cell[43189, 1483, 259, 5, 70, "Text",
 CellID->162711575],
Cell[43451, 1490, 148, 4, 70, "MathCaption",
 CellID->788655758],
Cell[CellGroupData[{
Cell[43624, 1498, 1024, 31, 70, "Input",
 CellID->336476111],
Cell[44651, 1531, 166, 5, 36, "Output",
 CellID->474207540]
}, Open  ]],
Cell[44832, 1539, 119, 3, 70, "MathCaption",
 CellID->251554530],
Cell[CellGroupData[{
Cell[44976, 1546, 1045, 31, 70, "Input",
 CellID->75476148],
Cell[46024, 1579, 164, 5, 36, "Output",
 CellID->6851649]
}, Open  ]],
Cell[46203, 1587, 681, 15, 70, "Text",
 CellTags->"GibbsSampler",
 CellID->665384613],
Cell[46887, 1604, 1382, 38, 70, "Text",
 CellID->380573244],
Cell[48272, 1644, 130, 4, 70, "MathCaption",
 CellID->366968212],
Cell[48405, 1650, 1668, 46, 70, "Input",
 CellID->797105472],
Cell[50076, 1698, 474, 13, 70, "Text",
 CellID->41013106],
Cell[50553, 1713, 235, 9, 70, "MathCaption",
 CellID->1545858],
Cell[50791, 1724, 175, 6, 70, "Input",
 CellID->117414021],
Cell[50969, 1732, 132, 4, 70, "MathCaption",
 CellID->745678638],
Cell[51104, 1738, 119, 3, 70, "Input",
 CellID->302575509],
Cell[CellGroupData[{
Cell[51248, 1745, 604, 20, 47, "Input",
 CellID->14011073],
Cell[51855, 1767, 1954, 36, 242, "Output",
 Evaluatable->False,
 CellID->745263309]
}, Open  ]],
Cell[53824, 1806, 139, 4, 70, "MathCaption",
 CellID->160396599],
Cell[53966, 1812, 119, 3, 70, "Input",
 CellID->63982111],
Cell[CellGroupData[{
Cell[54110, 1819, 279, 9, 28, "Input",
 CellID->587414662],
Cell[54392, 1830, 3146, 56, 249, "Output",
 Evaluatable->False,
 CellID->348404138]
}, Open  ]],
Cell[57553, 1889, 510, 9, 70, "Text",
 CellID->51966789],
Cell[58066, 1900, 318, 11, 70, "MathCaption",
 CellID->125828751],
Cell[CellGroupData[{
Cell[58409, 1915, 1739, 53, 101, "Input",
 CellID->152843925],
Cell[60151, 1970, 1926, 36, 135, "Output",
 Evaluatable->False,
 CellID->205880232]
}, Open  ]],
Cell[62092, 2009, 287, 10, 70, "MathCaption",
 CellID->362504773],
Cell[CellGroupData[{
Cell[62404, 2023, 2207, 64, 137, "Input",
 CellID->31028577],
Cell[64614, 2089, 1799, 34, 142, "Output",
 Evaluatable->False,
 CellID->26162976]
}, Open  ]],
Cell[CellGroupData[{
Cell[66450, 2128, 84, 1, 70, "Subsubsection",
 CellID->242153530],
Cell[66537, 2131, 576, 19, 70, "Text",
 CellID->225207923],
Cell[67116, 2152, 609, 16, 70, "DefinitionBox3Col",
 CellID->10755],
Cell[67728, 2170, 331, 13, 70, "Caption",
 CellID->6773024],
Cell[68062, 2185, 370, 9, 70, "Text",
 CellID->704071049],
Cell[68435, 2196, 95, 1, 70, "MathCaption",
 CellID->169333759],
Cell[CellGroupData[{
Cell[68555, 2201, 221, 7, 70, "Input",
 CellID->240601987],
Cell[68779, 2210, 203, 5, 36, "Output",
 CellID->32926747]
}, Open  ]],
Cell[68997, 2218, 181, 6, 70, "MathCaption",
 CellID->148798415],
Cell[CellGroupData[{
Cell[69203, 2228, 219, 6, 70, "Input",
 CellID->33623624],
Cell[69425, 2236, 235, 7, 36, "Output",
 CellID->207186367]
}, Open  ]],
Cell[69675, 2246, 402, 10, 70, "Text",
 CellID->232500491],
Cell[70080, 2258, 230, 7, 70, "MathCaption",
 CellID->278672462],
Cell[CellGroupData[{
Cell[70335, 2269, 405, 12, 70, "Input",
 CellID->14336177],
Cell[70743, 2283, 175, 5, 36, "Output",
 CellID->18612785]
}, Open  ]],
Cell[70933, 2291, 415, 10, 70, "Text",
 CellID->505338692],
Cell[71351, 2303, 134, 4, 70, "MathCaption",
 CellID->687639791],
Cell[CellGroupData[{
Cell[71510, 2311, 200, 6, 70, "Input",
 CellID->357745337],
Cell[71713, 2319, 551, 10, 70, "Message",
 CellID->97442093],
Cell[72267, 2331, 373, 11, 54, "Output",
 CellID->475092171]
}, Open  ]],
Cell[72655, 2345, 442, 13, 70, "Text",
 CellID->903130573],
Cell[73100, 2360, 238, 7, 70, "MathCaption",
 CellID->478798666],
Cell[CellGroupData[{
Cell[73363, 2371, 174, 5, 70, "Input",
 CellID->37282039],
Cell[73540, 2378, 445, 8, 70, "Message",
 CellID->12045576],
Cell[73988, 2388, 268, 8, 36, "Output",
 CellID->30664504]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74317, 2403, 56, 1, 70, "Subsection",
 CellID->58746613],
Cell[74376, 2406, 428, 13, 70, "Text",
 CellID->292179951],
Cell[74807, 2421, 4367, 150, 70, "DefinitionBox",
 CellID->51762611],
Cell[79177, 2573, 65, 1, 70, "Caption",
 CellID->621329494],
Cell[79245, 2576, 3052, 103, 70, "DefinitionBox",
 CellID->728594466],
Cell[82300, 2681, 64, 1, 70, "Caption",
 CellID->89076591],
Cell[82367, 2684, 1696, 53, 70, "Text",
 CellID->36845972],
Cell[84066, 2739, 1554, 50, 70, "Text",
 CellID->114762515],
Cell[85623, 2791, 294, 8, 70, "Text",
 CellID->285987478],
Cell[85920, 2801, 84, 1, 70, "MathCaption",
 CellID->289943446],
Cell[CellGroupData[{
Cell[86029, 2806, 209, 7, 70, "Input",
 CellID->143648604],
Cell[86241, 2815, 534, 12, 54, "Output",
 CellID->345714348]
}, Open  ]],
Cell[86790, 2830, 89, 1, 70, "MathCaption",
 CellID->249515450],
Cell[CellGroupData[{
Cell[86904, 2835, 304, 10, 70, "Input",
 CellID->140180825],
Cell[87211, 2847, 396, 10, 36, "Output",
 CellID->364941046]
}, Open  ]],
Cell[87622, 2860, 269, 8, 70, "Text",
 CellID->858556433],
Cell[87894, 2870, 284, 8, 70, "MathCaption",
 CellID->788996469],
Cell[CellGroupData[{
Cell[88203, 2882, 270, 8, 70, "Input",
 CellID->434722153],
Cell[88476, 2892, 158, 5, 36, "Output",
 CellID->30289803]
}, Open  ]],
Cell[88649, 2900, 95, 1, 70, "MathCaption",
 CellID->121017815],
Cell[88747, 2903, 119, 3, 70, "Input",
 CellID->102541292],
Cell[CellGroupData[{
Cell[88891, 2910, 710, 23, 47, "Input",
 CellID->24566967],
Cell[89604, 2935, 1241, 24, 245, "Output",
 Evaluatable->False,
 CellID->53954305]
}, Open  ]],
Cell[90860, 2962, 392, 9, 70, "Text",
 CellID->304375186],
Cell[91255, 2973, 120, 3, 70, "MathCaption",
 CellID->30493468],
Cell[CellGroupData[{
Cell[91400, 2980, 394, 13, 70, "Input",
 CellID->225414954],
Cell[91797, 2995, 340, 9, 36, "Output",
 CellID->615494329]
}, Open  ]],
Cell[92152, 3007, 119, 3, 70, "Text",
 CellID->150965768],
Cell[92274, 3012, 117, 3, 70, "MathCaption",
 CellID->96620109],
Cell[CellGroupData[{
Cell[92416, 3019, 141, 4, 70, "Input",
 CellID->15101454],
Cell[92560, 3025, 293, 9, 36, "Output",
 CellID->657626359]
}, Open  ]],
Cell[92868, 3037, 223, 5, 70, "Text",
 CellID->249698174],
Cell[93094, 3044, 122, 3, 70, "MathCaption",
 CellID->53608588],
Cell[CellGroupData[{
Cell[93241, 3051, 226, 7, 70, "Input",
 CellID->430551292],
Cell[93470, 3060, 293, 9, 36, "Output",
 CellID->230374885]
}, Open  ]],
Cell[93778, 3072, 483, 16, 70, "Text",
 CellID->185433750],
Cell[94264, 3090, 221, 9, 70, "MathCaption",
 CellID->212208469],
Cell[94488, 3101, 147, 5, 70, "Input",
 CellID->90390730],
Cell[CellGroupData[{
Cell[94660, 3110, 376, 12, 70, "Input",
 CellID->570447660],
Cell[95039, 3124, 1068, 37, 54, "Output",
 CellID->37238496]
}, Open  ]],
Cell[CellGroupData[{
Cell[96144, 3166, 235, 8, 70, "Input",
 CellID->786725747],
Cell[96382, 3176, 446, 11, 54, "Output",
 CellID->315996589]
}, Open  ]],
Cell[96843, 3190, 259, 8, 70, "MathCaption",
 CellID->572764500],
Cell[CellGroupData[{
Cell[97127, 3202, 426, 14, 70, "Input",
 CellID->1016772110],
Cell[97556, 3218, 446, 11, 54, "Output",
 CellID->666116691]
}, Open  ]],
Cell[98017, 3232, 142, 4, 70, "Text",
 CellID->7293204],
Cell[98162, 3238, 83, 1, 70, "MathCaption",
 CellID->126671741],
Cell[CellGroupData[{
Cell[98270, 3243, 209, 7, 70, "Input",
 CellID->168972178],
Cell[98482, 3252, 496, 12, 54, "Output",
 CellID->552655746]
}, Open  ]],
Cell[98993, 3267, 380, 9, 70, "Text",
 CellID->910762301],
Cell[99376, 3278, 124, 3, 70, "MathCaption",
 CellID->615358382],
Cell[CellGroupData[{
Cell[99525, 3285, 203, 6, 70, "Input",
 CellID->29010796],
Cell[99731, 3293, 553, 16, 36, "Output",
 CellID->1301043]
}, Open  ]],
Cell[100299, 3312, 862, 30, 70, "Text",
 CellID->3684708]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[101210, 3348, 61, 1, 70, "Section",
 CellID->8730447],
Cell[101274, 3351, 493, 8, 70, "Text",
 CellID->62375196],
Cell[101770, 3361, 520, 9, 70, "Text",
 CellID->75837341],
Cell[102293, 3372, 1070, 35, 70, "DefinitionBox",
 CellID->137389150],
Cell[103366, 3409, 73, 1, 70, "Caption",
 CellID->54750400],
Cell[103442, 3412, 710, 20, 70, "Text",
 CellID->276243315],
Cell[104155, 3434, 93, 1, 70, "MathCaption",
 CellID->388157339],
Cell[CellGroupData[{
Cell[104273, 3439, 310, 10, 70, "Input",
 CellID->202704636],
Cell[104586, 3451, 244, 8, 36, "Output",
 CellID->200703061]
}, Open  ]],
Cell[104845, 3462, 563, 18, 70, "Text",
 CellID->34088934],
Cell[105411, 3482, 231, 8, 70, "MathCaption",
 CellID->10768640],
Cell[CellGroupData[{
Cell[105667, 3494, 393, 12, 70, "Input",
 CellID->157868588],
Cell[106063, 3508, 245, 8, 36, "Output",
 CellID->628293208]
}, Open  ]],
Cell[106323, 3519, 238, 7, 70, "Text",
 CellID->274001164],
Cell[106564, 3528, 694, 19, 70, "DefinitionBox3Col",
 CellID->340545550],
Cell[107261, 3549, 193, 8, 70, "Caption",
 CellID->71473729],
Cell[107457, 3559, 528, 18, 70, "Text",
 CellID->163988397],
Cell[107988, 3579, 254, 8, 70, "MathCaption",
 CellID->41158855],
Cell[CellGroupData[{
Cell[108267, 3591, 346, 9, 70, "Input",
 CellID->129589009],
Cell[108616, 3602, 176, 5, 36, "Output",
 CellID->86779841]
}, Open  ]],
Cell[108807, 3610, 246, 8, 70, "MathCaption",
 CellID->297828284],
Cell[CellGroupData[{
Cell[109078, 3622, 301, 9, 70, "Input",
 CellID->104339044],
Cell[109382, 3633, 177, 5, 36, "Output",
 CellID->41871844]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[109608, 3644, 68, 2, 70, "Section",
 CellTags->"Methods",
 CellID->185956823],
Cell[109679, 3648, 396, 9, 70, "Text",
 CellID->144094561],
Cell[110078, 3659, 730, 19, 70, "DefinitionBox",
 CellID->154028361],
Cell[110811, 3680, 55, 1, 70, "Caption",
 CellID->19627742],
Cell[110869, 3683, 116, 3, 70, "MathCaption",
 CellID->179875953],
Cell[CellGroupData[{
Cell[111010, 3690, 590, 17, 70, "Input",
 CellID->43803727],
Cell[111603, 3709, 368, 10, 54, "Output",
 CellID->418438995]
}, Open  ]],
Cell[111986, 3722, 91, 1, 70, "MathCaption",
 CellID->95050898],
Cell[CellGroupData[{
Cell[112102, 3727, 553, 16, 70, "Input",
 CellID->163023894],
Cell[112658, 3745, 366, 10, 36, "Output",
 CellID->353711008]
}, Open  ]],
Cell[CellGroupData[{
Cell[113061, 3760, 54, 1, 70, "Subsection",
 CellID->163245837],
Cell[113118, 3763, 536, 15, 70, "Text",
 CellID->58803267],
Cell[113657, 3780, 328, 11, 70, "DisplayMath",
 CellID->34758699],
Cell[113988, 3793, 764, 25, 70, "Text",
 CellID->54158622],
Cell[114755, 3820, 1301, 33, 70, "DefinitionBox3Col",
 CellID->113304678],
Cell[116059, 3855, 250, 10, 70, "Caption",
 CellID->326368191],
Cell[116312, 3867, 375, 9, 70, "Text",
 CellID->11228194],
Cell[116690, 3878, 350, 7, 70, "Text",
 CellID->256112524],
Cell[117043, 3887, 121, 3, 70, "MathCaption",
 CellID->18625225],
Cell[117167, 3892, 591, 16, 70, "Input",
 CellID->99631247],
Cell[117761, 3910, 290, 6, 70, "Text",
 CellID->4944471],
Cell[118054, 3918, 104, 2, 70, "MathCaption",
 CellID->76394543],
Cell[CellGroupData[{
Cell[118183, 3924, 106, 3, 70, "Input",
 CellID->708581332],
Cell[118292, 3929, 160, 5, 36, "Output",
 CellID->345955459]
}, Open  ]],
Cell[118467, 3937, 459, 17, 70, "Text",
 CellID->555465810],
Cell[118929, 3956, 93, 1, 70, "MathCaption",
 CellID->408465059],
Cell[CellGroupData[{
Cell[119047, 3961, 371, 13, 70, "Input",
 CellID->180997701],
Cell[119421, 3976, 159, 5, 36, "Output",
 CellID->152187528]
}, Open  ]],
Cell[119595, 3984, 117, 3, 70, "MathCaption",
 CellID->421180804],
Cell[CellGroupData[{
Cell[119737, 3991, 133, 4, 70, "Input",
 CellID->63714427],
Cell[119873, 3997, 1557, 38, 122, "Output",
 CellID->725704780]
}, Open  ]],
Cell[121445, 4038, 140, 4, 70, "Text",
 CellID->613768652],
Cell[121588, 4044, 111, 3, 70, "MathCaption",
 CellID->1136747],
Cell[CellGroupData[{
Cell[121724, 4051, 571, 15, 65, "Input",
 CellID->142718018],
Cell[122298, 4068, 1080, 22, 134, "Output",
 Evaluatable->False,
 CellID->289766018]
}, Open  ]],
Cell[123393, 4093, 563, 14, 70, "Text",
 CellID->341821088],
Cell[123959, 4109, 932, 32, 70, "Text",
 CellID->731576808]
}, Open  ]],
Cell[CellGroupData[{
Cell[124928, 4146, 51, 1, 70, "Subsection",
 CellID->18361715],
Cell[124982, 4149, 340, 7, 70, "Text",
 CellID->251647820],
Cell[125325, 4158, 478, 8, 70, "Text",
 CellID->68447227],
Cell[125806, 4168, 393, 8, 70, "Text",
 CellID->388724034],
Cell[126202, 4178, 239, 5, 70, "Text",
 CellID->22636609],
Cell[126444, 4185, 617, 14, 70, "DefinitionBox3Col",
 CellID->318204019],
Cell[127064, 4201, 246, 10, 70, "Caption",
 CellID->1664784],
Cell[127313, 4213, 242, 6, 70, "Text",
 CellID->66525012],
Cell[127558, 4221, 467, 10, 70, "Text",
 CellID->4122129],
Cell[128028, 4233, 145, 4, 70, "MathCaption",
 CellID->96541496],
Cell[CellGroupData[{
Cell[128198, 4241, 231, 7, 70, "Input",
 CellID->31071355],
Cell[128432, 4250, 338, 10, 36, "Output",
 CellID->47027384]
}, Open  ]],
Cell[CellGroupData[{
Cell[128807, 4265, 306, 9, 70, "Input",
 CellID->564889951],
Cell[129116, 4276, 339, 10, 36, "Output",
 CellID->291633951]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129504, 4292, 48, 1, 70, "Subsection",
 CellID->791005668],
Cell[129555, 4295, 652, 17, 70, "Text",
 CellID->569511979],
Cell[130210, 4314, 423, 15, 70, "MathCaption",
 CellID->151537546],
Cell[CellGroupData[{
Cell[130658, 4333, 367, 11, 70, "Input",
 CellID->89341507],
Cell[131028, 4346, 222, 7, 36, "Output",
 CellID->54154574]
}, Open  ]],
Cell[131265, 4356, 225, 8, 70, "MathCaption",
 CellID->145031155],
Cell[CellGroupData[{
Cell[131515, 4368, 376, 12, 70, "Input",
 CellID->24328261],
Cell[131894, 4382, 222, 7, 36, "Output",
 CellID->12006888]
}, Open  ]],
Cell[132131, 4392, 365, 11, 70, "Text",
 CellID->635598082],
Cell[132499, 4405, 134, 5, 70, "Text",
 CellID->527415379]
}, Open  ]],
Cell[CellGroupData[{
Cell[132670, 4415, 57, 1, 70, "Subsection",
 CellID->569959585],
Cell[132730, 4418, 630, 21, 70, "Text",
 CellID->378768533],
Cell[133363, 4441, 113, 3, 70, "MathCaption",
 CellID->177721484],
Cell[CellGroupData[{
Cell[133501, 4448, 311, 9, 70, "Input",
 CellID->453275651],
Cell[133815, 4459, 336, 10, 36, "Output",
 CellID->654338668]
}, Open  ]],
Cell[134166, 4472, 143, 5, 70, "Text",
 CellID->316567745]
}, Open  ]],
Cell[CellGroupData[{
Cell[134346, 4482, 44, 1, 70, "Subsection",
 CellID->57850632],
Cell[134393, 4485, 343, 8, 70, "Text",
 CellID->483061491],
Cell[134739, 4495, 686, 19, 70, "DefinitionBox3Col",
 CellID->391202130],
Cell[135428, 4516, 239, 10, 70, "Caption",
 CellID->17973746],
Cell[135670, 4528, 859, 19, 70, "DefinitionBox",
 CellID->369023658],
Cell[136532, 4549, 110, 4, 70, "Caption",
 CellID->96150342],
Cell[136645, 4555, 489, 10, 70, "Text",
 CellID->18106354],
Cell[137137, 4567, 126, 3, 70, "MathCaption",
 CellID->70217261],
Cell[CellGroupData[{
Cell[137288, 4574, 734, 21, 70, "Input",
 CellID->518868435],
Cell[138025, 4597, 7945, 139, 199, "Output",
 CellID->158458127]
}, Open  ]],
Cell[145985, 4739, 105, 2, 70, "MathCaption",
 CellID->413316904],
Cell[CellGroupData[{
Cell[146115, 4745, 727, 21, 70, "Input",
 CellID->305039619],
Cell[146845, 4768, 7945, 139, 200, "Output",
 CellID->542080558]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154839, 4913, 50, 1, 70, "Subsection",
 CellID->830168163],
Cell[154892, 4916, 251, 6, 70, "Text",
 CellID->19390676],
Cell[155146, 4924, 650, 23, 70, "DisplayMath",
 CellID->1000570005],
Cell[155799, 4949, 366, 15, 70, "Text",
 CellID->383398421],
Cell[156168, 4966, 543, 13, 70, "DefinitionBox3Col",
 CellID->11284374],
Cell[156714, 4981, 245, 10, 70, "Caption",
 CellID->23773934],
Cell[156962, 4993, 243, 6, 70, "Text",
 CellID->229377272],
Cell[157208, 5001, 182, 5, 70, "MathCaption",
 CellID->814167608],
Cell[CellGroupData[{
Cell[157415, 5010, 397, 12, 70, "Input",
 CellID->110280843],
Cell[157815, 5024, 888, 29, 71, "Output",
 CellID->35838246]
}, Open  ]],
Cell[158718, 5056, 314, 8, 70, "Text",
 CellID->261891603]
}, Open  ]],
Cell[CellGroupData[{
Cell[159069, 5069, 94, 2, 70, "Subsection",
 CellTags->"Generators",
 CellID->215995533],
Cell[159166, 5073, 611, 17, 70, "Text",
 CellID->47164682],
Cell[159780, 5092, 170, 5, 70, "Text",
 CellID->341192944],
Cell[159953, 5099, 467, 15, 70, "DefinitionBox",
 CellID->391001025],
Cell[160423, 5116, 73, 1, 70, "Caption",
 CellID->204201832],
Cell[160499, 5119, 352, 12, 70, "Text",
 CellID->636103569],
Cell[160854, 5133, 334, 6, 70, "Text",
 CellID->131198039],
Cell[161191, 5141, 847, 26, 70, "DefinitionBox",
 CellID->41499560],
Cell[162041, 5169, 59, 1, 70, "Caption",
 CellID->27535580],
Cell[162103, 5172, 497, 15, 70, "Text",
 CellID->74890238],
Cell[162603, 5189, 704, 23, 70, "Text",
 CellID->107416421],
Cell[163310, 5214, 834, 27, 70, "Text",
 CellID->178084341],
Cell[164147, 5243, 476, 15, 70, "Text",
 CellID->491102950],
Cell[164626, 5260, 533, 18, 70, "Text",
 CellID->352892580],
Cell[CellGroupData[{
Cell[165184, 5282, 90, 1, 70, "Subsubsection",
 CellID->53206063],
Cell[165277, 5285, 201, 5, 70, "Text",
 CellID->306834972],
Cell[165481, 5292, 252, 8, 70, "DisplayMath",
 CellID->51307053],
Cell[165736, 5302, 126, 4, 70, "Text",
 CellID->651321203],
Cell[165865, 5308, 171, 5, 70, "MathCaption",
 CellID->236141184],
Cell[166039, 5315, 398, 12, 70, "Input",
 CellID->207931436],
Cell[166440, 5329, 212, 5, 70, "Text",
 CellID->105519449],
Cell[166655, 5336, 83, 1, 70, "MathCaption",
 CellID->220603967],
Cell[166741, 5339, 1837, 47, 70, "Input",
 CellID->15261556],
Cell[168581, 5388, 164, 5, 70, "MathCaption",
 CellID->75701923],
Cell[168748, 5395, 241, 8, 70, "Input",
 CellID->413732366],
Cell[168992, 5405, 115, 3, 70, "MathCaption",
 CellID->835193870],
Cell[169110, 5410, 562, 16, 70, "Input",
 CellID->7906412],
Cell[169675, 5428, 354, 9, 70, "Text",
 CellID->464531126],
Cell[170032, 5439, 82, 1, 70, "MathCaption",
 CellID->487178613],
Cell[170117, 5442, 1138, 33, 70, "Input",
 CellID->216655639],
Cell[171258, 5477, 171, 5, 70, "MathCaption",
 CellID->100115776],
Cell[CellGroupData[{
Cell[171454, 5486, 393, 11, 70, "Input",
 CellID->242224527],
Cell[171850, 5499, 478, 12, 54, "Output",
 CellID->325997614]
}, Open  ]],
Cell[172343, 5514, 85, 1, 70, "MathCaption",
 CellID->762875179],
Cell[CellGroupData[{
Cell[172453, 5519, 368, 10, 70, "Input",
 CellID->649853174],
Cell[172824, 5531, 284, 6, 70, "Message",
 CellID->322452064],
Cell[173111, 5539, 246, 8, 36, "Output",
 CellID->16252677]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[173406, 5553, 97, 3, 70, "Subsubsection",
 CellID->37119089],
Cell[173506, 5558, 634, 21, 70, "Text",
 CellID->343503892],
Cell[174143, 5581, 157, 5, 70, "MathCaption",
 CellID->566157157],
Cell[174303, 5588, 465, 14, 70, "Input",
 CellID->516905451],
Cell[174771, 5604, 133, 4, 70, "MathCaption",
 CellID->366343203],
Cell[174907, 5610, 439, 13, 70, "Input",
 CellID->7297936],
Cell[175349, 5625, 230, 7, 70, "Input",
 CellID->164389542],
Cell[175582, 5634, 286, 7, 70, "Input",
 CellID->449032134],
Cell[175871, 5643, 266, 7, 70, "Input",
 CellID->665424257],
Cell[176140, 5652, 176, 4, 70, "Text",
 CellID->325919855],
Cell[176319, 5658, 82, 1, 70, "MathCaption",
 CellID->48224491],
Cell[176404, 5661, 3630, 91, 70, "Input",
 CellID->342070724],
Cell[180037, 5754, 182, 5, 70, "MathCaption",
 CellID->20130777],
Cell[180222, 5761, 223, 7, 70, "Input",
 CellID->717886833],
Cell[180448, 5770, 262, 8, 70, "Input",
 CellID->90710492],
Cell[180713, 5780, 77, 1, 70, "MathCaption",
 CellID->455054847],
Cell[180793, 5783, 1431, 37, 70, "Input",
 CellID->1012736182],
Cell[182227, 5822, 74, 1, 70, "MathCaption",
 CellID->171866137],
Cell[182304, 5825, 795, 23, 70, "Input",
 CellID->470227807],
Cell[183102, 5850, 171, 5, 70, "MathCaption",
 CellID->148364729],
Cell[CellGroupData[{
Cell[183298, 5859, 505, 15, 70, "Input",
 CellID->961269082],
Cell[183806, 5876, 469, 14, 36, "Output",
 CellID->48934540]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[184348, 5898, 92, 2, 70, "Section",
 CellTags->"Distributions",
 CellID->554867591],
Cell[184443, 5902, 517, 9, 70, "Text",
 CellID->70729116],
Cell[184963, 5913, 1069, 27, 70, "Text",
 CellID->171976680],
Cell[186035, 5942, 950, 31, 70, "Text",
 CellID->518342337],
Cell[186988, 5975, 413, 14, 70, "Text",
 CellID->66156762],
Cell[187404, 5991, 1783, 60, 70, "DefinitionBox",
 CellID->99656438],
Cell[189190, 6053, 97, 1, 70, "Caption",
 CellID->205603206],
Cell[189290, 6056, 1806, 60, 70, "DefinitionBox",
 CellID->974420881],
Cell[191099, 6118, 95, 1, 70, "Caption",
 CellID->261861085],
Cell[191197, 6121, 881, 26, 70, "Text",
 CellID->472715616],
Cell[192081, 6149, 205, 7, 70, "MathCaption",
 CellID->139215],
Cell[CellGroupData[{
Cell[192311, 6160, 159, 4, 70, "Input",
 CellID->1014332979],
Cell[192473, 6166, 300, 6, 70, "Message",
 CellID->23701167],
Cell[192776, 6174, 246, 7, 36, "Output",
 CellID->22724633]
}, Open  ]],
Cell[193037, 6184, 408, 13, 70, "Text",
 CellID->56452128],
Cell[193448, 6199, 108, 3, 70, "MathCaption",
 CellID->834942158],
Cell[CellGroupData[{
Cell[193581, 6206, 239, 7, 70, "Input",
 CellID->22222704],
Cell[193823, 6215, 215, 6, 36, "Output",
 CellID->749080506]
}, Open  ]],
Cell[194053, 6224, 269, 5, 70, "Text",
 CellID->66643121],
Cell[194325, 6231, 66, 1, 70, "MathCaption",
 CellID->415249406],
Cell[194394, 6234, 130, 3, 70, "Input",
 CellID->3796874],
Cell[194527, 6239, 112, 3, 70, "MathCaption",
 CellID->51241293],
Cell[CellGroupData[{
Cell[194664, 6246, 394, 13, 70, "Input",
 CellID->23504658],
Cell[195061, 6261, 244, 8, 36, "Output",
 CellID->414750415]
}, Open  ]],
Cell[195320, 6272, 102, 2, 70, "MathCaption",
 CellID->252673169],
Cell[CellGroupData[{
Cell[195447, 6278, 327, 10, 70, "Input",
 CellID->196273874],
Cell[195777, 6290, 213, 7, 36, "Output",
 CellID->55526216]
}, Open  ]],
Cell[CellGroupData[{
Cell[196027, 6302, 66, 1, 70, "Subsection",
 CellID->452639384],
Cell[196096, 6305, 1858, 56, 70, "Text",
 CellID->711596005],
Cell[197957, 6363, 1168, 30, 70, "Text",
 CellID->443607893],
Cell[199128, 6395, 1204, 36, 70, "Text",
 CellID->440116445],
Cell[200335, 6433, 586, 15, 70, "Text",
 CellID->295085736],
Cell[200924, 6450, 4237, 136, 70, "Text",
 CellID->64303130],
Cell[205164, 6588, 598, 17, 70, "Text",
 CellID->21667378],
Cell[205765, 6607, 720, 23, 70, "Text",
 CellID->71961257],
Cell[206488, 6632, 542, 17, 70, "Text",
 CellID->242364124],
Cell[207033, 6651, 757, 26, 70, "Text",
 CellID->49100563],
Cell[207793, 6679, 1323, 36, 70, "Text",
 CellID->188586306],
Cell[209119, 6717, 137, 4, 70, "MathCaption",
 CellID->68150037],
Cell[CellGroupData[{
Cell[209281, 6725, 691, 22, 70, "Input",
 CellID->106742096],
Cell[209975, 6749, 224, 7, 36, "Output",
 CellID->57349852]
}, Open  ]],
Cell[CellGroupData[{
Cell[210236, 6761, 284, 9, 70, "Input",
 CellID->239183609],
Cell[210523, 6772, 225, 7, 36, "Output",
 CellID->216735632]
}, Open  ]],
Cell[210763, 6782, 904, 27, 70, "Text",
 CellID->760115118],
Cell[211670, 6811, 214, 7, 70, "MathCaption",
 CellID->497763262],
Cell[CellGroupData[{
Cell[211909, 6822, 527, 17, 70, "Input",
 CellID->608133],
Cell[212439, 6841, 224, 7, 36, "Output",
 CellID->18796968]
}, Open  ]],
Cell[CellGroupData[{
Cell[212700, 6853, 261, 8, 70, "Input",
 CellID->489471199],
Cell[212964, 6863, 225, 7, 36, "Output",
 CellID->387024250]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[213238, 6876, 64, 1, 70, "Subsection",
 CellID->222897986],
Cell[213305, 6879, 2140, 68, 70, "Text",
 CellID->688854147],
Cell[215448, 6949, 2153, 66, 70, "Text",
 CellID->676686120],
Cell[217604, 7017, 987, 23, 70, "Text",
 CellID->241018388],
Cell[218594, 7042, 1036, 19, 70, "Text",
 CellID->163022094],
Cell[219633, 7063, 519, 12, 70, "Text",
 CellID->339383142],
Cell[220155, 7077, 1068, 34, 70, "Text",
 CellID->344810340],
Cell[221226, 7113, 707, 20, 70, "Text",
 CellID->492968738]
}, Open  ]],
Cell[CellGroupData[{
Cell[221970, 7138, 100, 2, 70, "Subsection",
 CellTags->"DefiningDistributions",
 CellID->155138169],
Cell[222073, 7142, 332, 8, 70, "Text",
 CellID->226627364],
Cell[222408, 7152, 597, 19, 70, "DefinitionBox",
 CellID->297913222],
Cell[223008, 7173, 98, 1, 70, "Caption",
 CellID->391197044],
Cell[223109, 7176, 765, 23, 70, "Text",
 CellID->386939091],
Cell[223877, 7201, 864, 25, 70, "Input",
 CellID->163709496],
Cell[224744, 7228, 332, 10, 70, "Text",
 CellID->757995541],
Cell[225079, 7240, 188, 5, 70, "MathCaption",
 CellID->461654446],
Cell[CellGroupData[{
Cell[225292, 7249, 406, 12, 70, "Input",
 CellID->442051976],
Cell[225701, 7263, 306, 10, 36, "Output",
 CellID->142540992]
}, Open  ]],
Cell[226022, 7276, 611, 17, 70, "Text",
 CellID->42938867],
Cell[226636, 7295, 156, 5, 70, "MathCaption",
 CellID->173872560],
Cell[CellGroupData[{
Cell[226817, 7304, 250, 8, 70, "Input",
 CellID->396558676],
Cell[227070, 7314, 885, 25, 54, "Output",
 CellID->91323423]
}, Open  ]],
Cell[227970, 7342, 479, 13, 70, "Text",
 CellID->379626560],
Cell[228452, 7357, 491, 13, 70, "Input",
 CellID->980368218],
Cell[228946, 7372, 298, 10, 70, "Text",
 CellID->290895708],
Cell[229247, 7384, 146, 5, 70, "MathCaption",
 CellID->279910127],
Cell[CellGroupData[{
Cell[229418, 7393, 212, 6, 70, "Input",
 CellID->22057528],
Cell[229633, 7401, 476, 17, 36, "Output",
 CellID->195319682]
}, Open  ]],
Cell[230124, 7421, 810, 19, 70, "Text",
 CellID->135939224],
Cell[CellGroupData[{
Cell[230959, 7444, 86, 1, 70, "Subsubsection",
 CellID->301517985],
Cell[231048, 7447, 169, 4, 70, "Text",
 CellID->69609371],
Cell[231220, 7453, 292, 10, 70, "BulletedText",
 CellID->1022472671],
Cell[CellGroupData[{
Cell[231537, 7467, 217, 6, 70, "BulletedText",
 CellID->407897249],
Cell[231757, 7475, 533, 15, 70, "Text",
 CellID->240367624],
Cell[232293, 7492, 401, 14, 70, "MathCaption",
 CellID->221271130],
Cell[CellGroupData[{
Cell[232719, 7510, 210, 6, 70, "Input",
 CellID->27142828],
Cell[232932, 7518, 350, 12, 38, "Output",
 CellID->524821246]
}, Open  ]],
Cell[233297, 7533, 191, 4, 70, "Text",
 CellID->542968583],
Cell[233491, 7539, 91, 1, 70, "MathCaption",
 CellID->238508485],
Cell[233585, 7542, 967, 28, 70, "Input",
 CellID->13524569],
Cell[234555, 7572, 93, 1, 70, "MathCaption",
 CellID->120045305],
Cell[CellGroupData[{
Cell[234673, 7577, 201, 6, 70, "Input",
 CellID->27011428],
Cell[234877, 7585, 565, 14, 54, "Output",
 CellID->227544837]
}, Open  ]],
Cell[235457, 7602, 239, 7, 70, "MathCaption",
 CellID->864417951],
Cell[CellGroupData[{
Cell[235721, 7613, 347, 12, 70, "Input",
 CellID->353066439],
Cell[236071, 7627, 225, 7, 36, "Output",
 CellID->408932129]
}, Open  ]],
Cell[CellGroupData[{
Cell[236333, 7639, 200, 6, 70, "Input",
 CellID->322532405],
Cell[236536, 7647, 245, 8, 36, "Output",
 CellID->720054186]
}, Open  ]],
Cell[236796, 7658, 746, 18, 70, "Text",
 CellID->22239395],
Cell[237545, 7678, 121, 3, 70, "MathCaption",
 CellID->37131244],
Cell[CellGroupData[{
Cell[237691, 7685, 349, 12, 70, "Input",
 CellID->270422545],
Cell[238043, 7699, 210, 7, 36, "Output",
 CellID->240723233]
}, Open  ]],
Cell[CellGroupData[{
Cell[238290, 7711, 200, 6, 70, "Input",
 CellID->3617447],
Cell[238493, 7719, 245, 8, 36, "Output",
 CellID->262589401]
}, Open  ]],
Cell[238753, 7730, 133, 4, 70, "Input",
 CellID->665203069]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[238935, 7740, 84, 1, 70, "Subsubsection",
 CellID->132002727],
Cell[239022, 7743, 689, 20, 70, "Text",
 CellID->223083910],
Cell[239714, 7765, 348, 12, 70, "BulletedText",
 CellID->18450053],
Cell[240065, 7779, 291, 10, 70, "BulletedText",
 CellID->88943028],
Cell[CellGroupData[{
Cell[240381, 7793, 280, 12, 70, "BulletedText",
 CellID->554520807],
Cell[240664, 7807, 299, 9, 70, "Text",
 CellID->71383229],
Cell[240966, 7818, 190, 6, 70, "MathCaption",
 CellID->33041809],
Cell[241159, 7826, 960, 27, 70, "Input",
 CellID->430238184],
Cell[242122, 7855, 99, 1, 70, "MathCaption",
 CellID->126063801],
Cell[CellGroupData[{
Cell[242246, 7860, 146, 4, 70, "Input",
 CellID->348058384],
Cell[242395, 7866, 246, 8, 36, "Output",
 CellID->379192092]
}, Open  ]],
Cell[242656, 7877, 230, 7, 70, "MathCaption",
 CellID->301272109],
Cell[CellGroupData[{
Cell[242911, 7888, 275, 8, 28, "Input",
 CellID->20349099],
Cell[243189, 7898, 9925, 167, 205, "Output",
 Evaluatable->False,
 CellID->73509560]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[253175, 8072, 75, 1, 70, "Subsubsection",
 CellID->70634134],
Cell[253253, 8075, 2421, 83, 70, "Text",
 CellID->112688026],
Cell[255677, 8160, 514, 19, 70, "Text",
 CellID->10618202],
Cell[256194, 8181, 610, 22, 70, "BulletedText",
 CellID->159755815],
Cell[CellGroupData[{
Cell[256829, 8207, 411, 14, 70, "BulletedText",
 CellID->478030536],
Cell[257243, 8223, 180, 5, 70, "MathCaption",
 CellID->155428599],
Cell[257426, 8230, 1144, 31, 70, "Input",
 CellID->592587094],
Cell[258573, 8263, 122, 3, 70, "MathCaption",
 CellID->213498442],
Cell[CellGroupData[{
Cell[258720, 8270, 309, 9, 70, "Input",
 CellID->461738284],
Cell[259032, 8281, 354, 10, 54, "Output",
 CellID->48753385]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[259447, 8298, 100, 2, 70, "Subsubsection",
 CellTags->"GibbsSamplerExample",
 CellID->15716282],
Cell[259550, 8302, 536, 15, 70, "Text",
 CellID->490895286],
Cell[260089, 8319, 149, 5, 70, "MathCaption",
 CellID->592240592],
Cell[260241, 8326, 2031, 54, 70, "Input",
 CellID->145732411],
Cell[262275, 8382, 253, 9, 70, "Text",
 CellID->163462406],
Cell[262531, 8393, 298, 11, 70, "MathCaption",
 CellID->83569915],
Cell[CellGroupData[{
Cell[262854, 8408, 204, 6, 70, "Input",
 CellID->234579757],
Cell[263061, 8416, 576, 17, 36, "Output",
 CellID->387698823]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[263710, 8441, 49, 1, 70, "Section",
 CellID->483626572],
Cell[263762, 8444, 476, 16, 70, "Reference",
 CellTags->"GemanGeman",
 CellID->408824937],
Cell[264241, 8462, 392, 15, 70, "Reference",
 CellTags->"CasellaGeorge",
 CellID->242992614],
Cell[264636, 8479, 487, 16, 70, "Reference",
 CellTags->"MatsumotoNishimura",
 CellID->440717610],
Cell[265126, 8497, 415, 17, 70, "Reference",
 CellTags->"Nishimura",
 CellID->17711876],
Cell[265544, 8516, 379, 14, 70, "Reference",
 CellTags->"Junod",
 CellID->27959193],
Cell[265926, 8532, 372, 15, 70, "Reference",
 CellTags->"Gentle",
 CellID->433710669],
Cell[266301, 8549, 418, 15, 70, "Reference",
 CellTags->"JohnsonKotzBalakrishnan",
 CellID->185370529],
Cell[266722, 8566, 400, 16, 70, "Reference",
 CellTags->"SmithHocking",
 CellID->2642763],
Cell[267125, 8584, 395, 16, 70, "Reference",
 CellTags->"ChengFeast",
 CellID->197589201],
Cell[267523, 8602, 353, 15, 70, "Reference",
 CellTags->"Johnson",
 CellID->432715931],
Cell[267879, 8619, 390, 16, 70, "Reference",
 CellTags->"Johnk",
 CellID->60616796],
Cell[268272, 8637, 404, 16, 70, "Reference",
 CellTags->"Cheng",
 CellID->347364034],
Cell[268679, 8655, 418, 16, 70, "Reference",
 CellTags->"Atkinson",
 CellID->514602903],
Cell[269100, 8673, 447, 18, 70, "Reference",
 CellTags->"Bailey",
 CellID->431268247],
Cell[269550, 8693, 350, 15, 70, "Reference",
 CellTags->"Devroye",
 CellID->371900916],
Cell[269903, 8710, 404, 16, 70, "Reference",
 CellTags->"BTPE",
 CellID->337532825],
Cell[270310, 8728, 447, 16, 70, "Reference",
 CellTags->"H2PE",
 CellID->252215890],
Cell[270760, 8746, 453, 16, 70, "Reference",
 CellTags->"AhrensDieter",
 CellID->179402736],
Cell[CellGroupData[{
Cell[271238, 8766, 97, 1, 70, "TutorialRelatedLinksSection",
 CellID->70400116],
Cell[271338, 8769, 429, 13, 70, "TutorialRelatedLinks",
 CellID->55680198]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[271806, 8787, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

