(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24738,        793]
NotebookOptionsPosition[     18616,        615]
NotebookOutlinePosition[     22079,        694]
CellTagsIndexPosition[     21988,        688]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Strings and Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/FromCharacterCode"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"], 
          "$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], 
          "$SystemCharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$SystemCharacterEncoding"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"FromCharacterCode\"\>", 
       2->"\<\"None\"\>", 3->"\<\"ToCharacterCode\"\>", 
       4->"\<\"$CharacterEncoding\"\>", 
       5->"\<\"$SystemCharacterEncoding\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Raw Character Encodings", "Title",
 CellTags->{"S2.8.9", "9.1"},
 CellID->189],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always allows you to refer to special characters by using names such as ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", "Alpha", "]"}]}]], "InlineFormula"],
 " or explicit hexadecimal codes such as ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{":", 
    RowBox[{"03", "b1"}]}]}]], "InlineFormula"],
 ". And when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " writes out files, it by default uses these names or hexadecimal codes."
}], "Text",
 CellID->16100],

Cell["\<\
But sometimes you may find it convenient to use raw encodings for at least \
some special characters. What this means is that rather than representing \
special characters by names or explicit hexadecimal codes, you instead \
represent them by raw bit patterns appropriate for a particular computer \
system or particular font. \
\>", "Text",
 CellID->19812],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["$CharacterEncoding",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$CharacterEncoding"], "=", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "use printable ASCII names for all special characters", "TableText"]},
   {
    RowBox[{
     ButtonBox["$CharacterEncoding",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$CharacterEncoding"], "=", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], Cell[TextData[{
     "use the raw character encoding specified by ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["$SystemCharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemCharacterEncoding"], Cell["\<\
the default raw character encoding for your particular computer system\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {True}, False}, "RowsIndexed" -> {}}},
 CellID->30648],

Cell["Setting up raw character encodings. ", "Caption",
 CellID->9523],

Cell[TextData[{
 "When you press a key or combination of keys on your keyboard, the operating \
system of your computer sends a certain bit pattern to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". How this bit pattern is interpreted as a character within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will depend on the character encoding that has been set up. "
}], "Text",
 CellID->19851],

Cell[TextData[{
 "The notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " typically takes care of setting up the appropriate character encoding \
automatically for whatever font you are using. But if you use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a text\[Hyphen]based interface or via files or pipes, then you may \
need to set ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 " explicitly. "
}], "Text",
 CellID->24474],

Cell[TextData[{
 "By specifying an appropriate value for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 " you will typically be able to get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to handle raw text generated by whatever language\[Hyphen]specific text \
editor or operating system you use. "
}], "Text",
 CellID->28633],

Cell[TextData[{
 "You should realize, however, that while the standard representation of \
special characters used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is completely portable across different computer systems, any \
representation that involves raw character encodings will inevitably not be. \
"
}], "Text",
 CellID->29891],

Cell[BoxData[GridBox[{
   {"\"\<PrintableASCII\>\"", Cell[
    "printable ASCII characters only (default)", "TableText"]},
   {"\"\<ASCII\>\"", Cell[
    "all ASCII including control characters", "TableText"]},
   {"\"\<ISOLatin1\>\"", Cell[
    "characters for common western European languages", "TableText"]},
   {"\"\<ISOLatin2\>\"", Cell[
    "characters for central and eastern European languages", "TableText"]},
   {"\"\<ISOLatin3\>\"", Cell["\<\
characters for additional European languages (e.g. Catalan, Turkish)\
\>", "TableText"]},
   {"\"\<ISOLatin4\>\"", Cell["\<\
characters for other additional European languages (e.g. Estonian, Lappish)\
\>", "TableText"]},
   {"\"\<ISOLatinCyrillic\>\"", Cell[
    "English and Cyrillic characters", "TableText"]},
   {"\"\<AdobeStandard\>\"", Cell[
    "Adobe standard PostScript font encoding", "TableText"]},
   {"\"\<MacintoshRoman\>\"", Cell[
    "Macintosh roman font encoding", "TableText"]},
   {"\"\<WindowsANSI\>\"", Cell[
    "Windows standard font encoding", "TableText"]},
   {"\"\<Symbol\>\"", Cell["symbol font encoding", "TableText"]},
   {"\"\<ZapfDingbats\>\"", Cell[
    "Zapf dingbats font encoding", "TableText"]},
   {"\"\<ShiftJIS\>\"", Cell["\<\
shift\[Hyphen]JIS for Japanese (mixture of 8\[Hyphen] and 16\[Hyphen]bit)\
\>", "TableText"]},
   {"\"\<EUC\>\"", Cell["\<\
extended Unix code for Japanese (mixture of 8\[Hyphen] and 16\[Hyphen]bit)\
\>", "TableText"]},
   {"\"\<UTF8\>\"", Cell[
    "Unicode transformation format encoding", "TableText"]},
   {"\"\<Unicode\>\"", Cell["\<\
raw 16\[Hyphen]bit Unicode bit patterns\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, True, False, False, False, False, False, False, False, 
     False, False, True, False, False, {True}, False}, "RowsIndexed" -> {}}},
 CellID->27200],

Cell[TextData[{
 "Some raw character encodings supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->19854],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows about various raw character encodings, appropriate for different \
computer systems and different languages. Copying of characters between the \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook interface and user interface environment on your computer \
generally uses the native character encoding for that environment. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " characters which are not included in the native encoding will be written \
out using standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " full names or hexadecimal codes."
}], "Text",
 CellID->9990],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel can use any character encoding you specify when it writes or reads \
text files. By default, ",
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PutAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PutAppend"]], "InlineFormula"],
 " produce an ASCII representation for reliable portability of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language files from one system to another."
}], "Text",
 CellID->25697],

Cell[TextData[{
 "This writes a string to the file ",
 Cell[BoxData["tmp"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->17780],

Cell[BoxData[
 RowBox[{"\"\<a b c \[EAcute] \[Alpha] \[Pi] \:2766\>\"", ">>", 
  "tmp"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22578],

Cell["\<\
Special characters are written out using full names or explicit hexadecimal \
codes. \
\>", "MathCaption",
 CellID->12931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"\"\<tmp\>\"", ",", "String"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32544],

Cell[BoxData["\<\"\\\"a b c \\\\[EAcute] \\\\[Alpha] \\\\[Pi] \\\\:2766\\\"\"\
\>"], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9290673]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports both 8\[Hyphen] and 16\[Hyphen]bit raw character encodings. In an \
encoding such as ",
 Cell[BoxData["\"\<ISOLatin1\>\""], "InlineFormula"],
 ", all characters are represented by bit patterns containing 8 bits. But in \
an encoding such as ",
 Cell[BoxData["\"\<ShiftJIS\>\""], "InlineFormula"],
 " some characters instead involve bit patterns containing 16 bits."
}], "Text",
 CellID->18529],

Cell[TextData[{
 "Most of the raw character encodings supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " include basic ASCII as a subset. This means that even when you are using \
such encodings, you can still give ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input in the usual way, and you can specify special characters using ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "["}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", ":"}]], "InlineFormula"],
 " sequences. "
}], "Text",
 CellID->31540],

Cell[TextData[{
 "Some raw character encodings, however, do not include basic ASCII as a \
subset. An example is the ",
 Cell[BoxData["\"\<Symbol\>\""], "InlineFormula"],
 " encoding, in which the character codes normally used for ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 " are instead used for ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->18805],

Cell["\<\
This gives the usual ASCII character codes for a few English letters. \
\>", "MathCaption",
 CellID->28791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", "\"\<abcdefgh\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "97", ",", "98", ",", "99", ",", "100", ",", "101", ",", "102", ",", "103", 
   ",", "104"}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->268848210]
}, Open  ]],

Cell[TextData[{
 "In the ",
 Cell[BoxData["\"\<Symbol\>\""], "InlineFormula"],
 " encoding, these character codes are used for Greek letters. "
}], "MathCaption",
 CellID->13549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"%", ",", "\"\<Symbol\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21578],

Cell[BoxData["\<\"\[Alpha]\[Beta]\[Chi]\[Delta]\[Epsilon]\[Phi]\[Gamma]\[Eta]\
\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->47846259]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToCharacterCode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToCharacterCode"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "generate codes for characters using the standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " encoding"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToCharacterCode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToCharacterCode"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"encoding\", \"TI\"]\)\>\"", "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "generate codes for characters using the specified encoding", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["FromCharacterCode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromCharacterCode"], "[", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "generate characters from codes using the standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " encoding"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FromCharacterCode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromCharacterCode"], "[", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "\"\<\!\(\*
StyleBox[\"encoding\", \"TI\"]\)\>\"", "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "generate characters from codes using the specified encoding", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30971],

Cell["Handling character codes with different encodings. ", "Caption",
 CellID->9277],

Cell[TextData[{
 "This gives the codes assigned to various characters by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->73],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", "\"\<abc\[EAcute]\[Pi]\>\"", "]"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->20193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"97", ",", "98", ",", "99", ",", "233", ",", "960"}], 
  "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->77052254]
}, Open  ]],

Cell["\<\
Here are the codes assigned to the same characters in the Macintosh roman \
encoding. \
\>", "MathCaption",
 CellID->21497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", 
  RowBox[{"\"\<abc\[EAcute]\[Pi]\>\"", ",", "\"\<MacintoshRoman\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->13826],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"97", ",", "98", ",", "99", ",", "142", ",", "185"}], 
  "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->242465519]
}, Open  ]],

Cell[TextData[{
 "Here are the codes in the Windows standard encoding. There is no code for \
",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", 
    ButtonBox["Pi",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pi"], "]"}]}]], "InlineFormula"],
 " in that encoding. "
}], "MathCaption",
 CellID->19790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", 
  RowBox[{"\"\<abc\[EAcute]\[Pi]\>\"", ",", "\"\<WindowsANSI\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->6582],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"97", ",", "98", ",", "99", ",", "233", ",", "None"}], 
  "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->17906694]
}, Open  ]],

Cell[TextData[{
 "The character codes used internally by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are based on Unicode. But externally ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default always uses plain ASCII sequences such as ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", 
    StyleBox["Name", "TI"], "]"}]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{":", 
    StyleBox["nnnn", "TI"]}]}]], "InlineFormula"],
 " to refer to special characters. By telling it to use the raw ",
 Cell[BoxData["\"\<Unicode\>\""], "InlineFormula"],
 " character encoding, however, you can get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to read and write characters in raw 16\[Hyphen]bit Unicode form. "
}], "Text",
 CellID->11159],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->67790652],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Raw Character Encodings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CharacterCodes"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 7.7467632}", "context" -> "", 
    "keywords" -> {
     "16-bit characters", "16 bit", "adobe character encoding", "ASCII", 
      "bytes", "CharacterEncoding", "character encoding", "character sets", 
      "CJK characters", "compatibility", "dingbats", "encoding", "EUC", 
      "European characters", "extended character sets", "extended Unix code", 
      "files", "font", "font encodings", "foreign characters", 
      "FromCharacterCode", "international characters", "ISO Latin1", 
      "ISO Latin 1", "ISO Latin2", "ISO Latin 2", "ISO LatinCyrillic", 
      "Japanese characters", "languages", "native character sets", 
      "octet encodings", "portability", "raw character input", "Roman fonts", 
      "shift JIS", "streams", "strings", "symbol font", "ToCharacterCode", 
      "translation", "Unicode", "Unicode transformation format", 
      "Zapf dingbats", "SystemCharacterEncoding"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica always allows you to refer to special characters by using \
names such as \\[Alpha] or explicit hexadecimal codes such as \\:03b1. And \
when Mathematica writes out files, it by default uses these names or \
hexadecimal codes. But sometimes you may find it convenient to use raw \
encodings for at least some special characters. What this means is that \
rather than representing special characters by names or explicit hexadecimal \
codes, you instead represent them by raw bit patterns appropriate for a \
particular computer system or particular font. Setting up raw character \
encodings. ", "synonyms" -> {"2.8.9"}, "title" -> "Raw Character Encodings", 
    "type" -> "Tutorial", "uri" -> "tutorial/RawCharacterEncodings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.9"->{
  Cell[2362, 67, 84, 2, 70, "Title",
   CellTags->{"S2.8.9", "9.1"},
   CellID->189]},
 "9.1"->{
  Cell[2362, 67, 84, 2, 70, "Title",
   CellTags->{"S2.8.9", "9.1"},
   CellID->189]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.9", 21781, 677},
 {"9.1", 21878, 681}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1737, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2362, 67, 84, 2, 70, "Title",
 CellTags->{"S2.8.9", "9.1"},
 CellID->189],
Cell[2449, 71, 557, 17, 70, "Text",
 CellID->16100],
Cell[3009, 90, 368, 7, 70, "Text",
 CellID->19812],
Cell[3380, 99, 1100, 31, 70, "DefinitionBox",
 CellID->30648],
Cell[4483, 132, 70, 1, 70, "Caption",
 CellID->9523],
Cell[4556, 135, 409, 10, 70, "Text",
 CellID->19851],
Cell[4968, 147, 561, 16, 70, "Text",
 CellID->24474],
Cell[5532, 165, 430, 12, 70, "Text",
 CellID->28633],
Cell[5965, 179, 345, 9, 70, "Text",
 CellID->29891],
Cell[6313, 190, 1920, 44, 70, "DefinitionBox",
 CellID->27200],
Cell[8236, 236, 148, 6, 70, "Caption",
 CellID->19854],
Cell[8387, 244, 674, 18, 70, "Text",
 CellID->9990],
Cell[9064, 264, 609, 20, 70, "Text",
 CellID->25697],
Cell[9676, 286, 133, 5, 70, "MathCaption",
 CellID->17780],
Cell[9812, 293, 138, 4, 70, "Input",
 CellID->22578],
Cell[9953, 299, 132, 4, 70, "MathCaption",
 CellID->12931],
Cell[CellGroupData[{
Cell[10110, 307, 134, 4, 70, "Input",
 CellID->32544],
Cell[10247, 313, 223, 6, 36, "Output",
 CellID->9290673]
}, Open  ]],
Cell[10485, 322, 470, 11, 70, "Text",
 CellID->18529],
Cell[10958, 335, 555, 16, 70, "Text",
 CellID->31540],
Cell[11516, 353, 530, 16, 70, "Text",
 CellID->18805],
Cell[12049, 371, 117, 3, 70, "MathCaption",
 CellID->28791],
Cell[CellGroupData[{
Cell[12191, 378, 122, 3, 70, "Input",
 CellID->13392],
Cell[12316, 383, 284, 9, 36, "Output",
 CellID->268848210]
}, Open  ]],
Cell[12615, 395, 178, 5, 70, "MathCaption",
 CellID->13549],
Cell[CellGroupData[{
Cell[12818, 404, 145, 4, 70, "Input",
 CellID->21578],
Cell[12966, 410, 225, 6, 36, "Output",
 CellID->47846259]
}, Open  ]],
Cell[13206, 419, 2226, 64, 70, "DefinitionBox",
 CellID->30971],
Cell[15435, 485, 85, 1, 70, "Caption",
 CellID->9277],
Cell[15523, 488, 162, 6, 70, "MathCaption",
 CellID->73],
Cell[CellGroupData[{
Cell[15710, 498, 133, 4, 70, "Input",
 CellID->20193],
Cell[15846, 504, 243, 8, 36, "Output",
 CellID->77052254]
}, Open  ]],
Cell[16104, 515, 133, 4, 70, "MathCaption",
 CellID->21497],
Cell[CellGroupData[{
Cell[16262, 523, 178, 5, 70, "Input",
 CellID->13826],
Cell[16443, 530, 244, 8, 36, "Output",
 CellID->242465519]
}, Open  ]],
Cell[16702, 541, 320, 11, 70, "MathCaption",
 CellID->19790],
Cell[CellGroupData[{
Cell[17047, 556, 174, 5, 70, "Input",
 CellID->6582],
Cell[17224, 563, 244, 8, 36, "Output",
 CellID->17906694]
}, Open  ]],
Cell[17483, 574, 806, 24, 70, "Text",
 CellID->11159],
Cell[CellGroupData[{
Cell[18314, 602, 71, 1, 70, "RelatedTutorialsSection",
 CellID->67790652],
Cell[18388, 605, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[18589, 613, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

