(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65481,       2297]
NotebookOptionsPosition[     52141,       1849]
NotebookOutlinePosition[     55857,       1932]
CellTagsIndexPosition[     55763,       1926]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Byte" :> Documentation`HelpLookup["paclet:ref/Byte"], 
          "Character" :> Documentation`HelpLookup["paclet:ref/Character"], 
          "Close" :> Documentation`HelpLookup["paclet:ref/Close"], 
          "Expression" :> Documentation`HelpLookup["paclet:ref/Expression"], 
          "Hold" :> Documentation`HelpLookup["paclet:ref/Hold"], "Number" :> 
          Documentation`HelpLookup["paclet:ref/Number"], "OpenRead" :> 
          Documentation`HelpLookup["paclet:ref/OpenRead"], "Read" :> 
          Documentation`HelpLookup["paclet:ref/Read"], "ReadList" :> 
          Documentation`HelpLookup["paclet:ref/ReadList"], "Real" :> 
          Documentation`HelpLookup["paclet:ref/Real"], "Record" :> 
          Documentation`HelpLookup["paclet:ref/Record"], "RecordLists" :> 
          Documentation`HelpLookup["paclet:ref/RecordLists"], 
          "RecordSeparators" :> 
          Documentation`HelpLookup["paclet:ref/RecordSeparators"], "Skip" :> 
          Documentation`HelpLookup["paclet:ref/Skip"], "String" :> 
          Documentation`HelpLookup["paclet:ref/String"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "Word" :> 
          Documentation`HelpLookup["paclet:ref/Word"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Byte\"\>", 2->"\<\"Character\"\>", 
       3->"\<\"Close\"\>", 4->"\<\"Expression\"\>", 5->"\<\"Hold\"\>", 
       6->"\<\"Number\"\>", 7->"\<\"OpenRead\"\>", 8->"\<\"Read\"\>", 
       9->"\<\"ReadList\"\>", 10->"\<\"Real\"\>", 11->"\<\"Record\"\>", 
       12->"\<\"RecordLists\"\>", 13->"\<\"RecordSeparators\"\>", 
       14->"\<\"Skip\"\>", 15->"\<\"String\"\>", 16->"\<\"Table\"\>", 
       17->"\<\"True\"\>", 18->"\<\"Word\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Reading Textual Data", "Title",
 CellTags->{"S2.12.8", "8.1"},
 CellID->3333],

Cell[TextData[{
 "With ",
 Cell[BoxData["<<"], "InlineFormula"],
 ", you can read files which contain ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions given in input form. Sometimes, however, you may instead need \
to read files of ",
 StyleBox["data",
  FontSlant->"Italic"],
 " in other formats. For example, you may have data generated by an external \
program which consists of a sequence of numbers separated by spaces. This \
data cannot be read directly as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. However, the function ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " can take such data from a file or input stream, and convert it to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list. "
}], "Text",
 CellID->13865],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     ButtonBox["Number",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Number"], "]"}], Cell[TextData[{
     "read a sequence of numbers from a file, and put them in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " list"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22214],

Cell["Reading numbers from a file. ", "Caption",
 CellID->17282],

Cell["Here is a file of numbers. ", "MathCaption",
 CellID->27007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/numbers\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1017532992],

Cell["\<\
11.1   22.2    33.3

44.4   55.5    66.6
\
\>", "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->355535124]
}, Open  ]],

Cell["\<\
This reads all the numbers in the file, and returns a list of them. \
\>", "MathCaption",
 CellID->16367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/numbers\>\"", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "11.1`", ",", "22.2`", ",", "33.3`", ",", "44.4`", ",", "55.5`", ",", 
   "66.6`"}], "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->567442848]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "{", 
     ButtonBox["Number",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Number"], ",", 
     ButtonBox["Number",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Number"], "}", "]"}], Cell["\<\
read numbers from a file, putting each successive pair into a separate list\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     ButtonBox["Number",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Number"], ",", "{", 
     StyleBox["n", "TI"], "}", "]", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "put each successive block of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " numbers in a separate list"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     ButtonBox["Number",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Number"], ",", 
     ButtonBox["RecordLists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RecordLists"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
put all the numbers on each line of the file into a separate list\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31810],

Cell["Reading blocks of numbers. ", "Caption",
 CellID->17641],

Cell["\<\
This puts each successive pair of numbers from the file into a separate list. \
\
\>", "MathCaption",
 CellID->7231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/numbers\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"Number", ",", "Number"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11.1`", ",", "22.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33.3`", ",", "44.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55.5`", ",", "66.6`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->6705]
}, Open  ]],

Cell["This makes each line in the file into a separate list. ", "MathCaption",
 CellID->6479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/numbers\>\"", ",", "Number", ",", 
   RowBox[{"RecordLists", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6321],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11.1`", ",", "22.2`", ",", "33.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44.4`", ",", "55.5`", ",", "66.6`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->6538]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " can handle numbers which are given in Fortran\[Hyphen]like \
\[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 "\[CloseCurlyDoubleQuote] notation. Thus, for example, ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " will read ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"2.5", 
    ButtonBox["E",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/E"]}], "+", "5"}]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2.5", "\[Cross]", 
    SuperscriptBox["10", "5"]}], TraditionalForm]], "InlineMath"],
 ". Note that ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " can handle numbers with any number of digits of precision. "
}], "Text",
 CellID->31351],

Cell[TextData[{
 "Here is a file containing numbers in Fortran\[Hyphen]like \"",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 "\" notation. "
}], "MathCaption",
 CellID->19447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/bignum\>\"", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->24208],

Cell["\<\
4.5E-5      7.8E4
2.5E2      -8.9\
\>", "Print",
 CellID->9646]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " can handle numbers in this form. "
}], "MathCaption",
 CellID->22276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/bignum\>\"", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->25759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.000045`", ",", "78000.`", ",", "250.`", ",", 
   RowBox[{"-", "8.9`"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->30189]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "read a sequence of objects of a particular type", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["type", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "read at most ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " objects"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30422],

Cell["Reading objects of various types. ", "Caption",
 CellID->27666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " can read not only numbers, but also a variety of other types of object. \
Each type of object is specified by a symbol such as ",
 Cell[BoxData[
  ButtonBox["Number",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Number"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->8486],

Cell["Here is a file containing text. ", "MathCaption",
 CellID->3455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/strings\>\"", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->2028],

Cell["\<\
Here is text. 
And more text.\
\>", "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"During evaluation of In[7]:=",
 CellID->2126668659]
}, Open  ]],

Cell["\<\
This produces a list of the characters in the file, each given as a one\
\[Hyphen]character string. \
\>", "MathCaption",
 CellID->4860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/strings\>\"", ",", "Character"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->29253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"H\"\>", ",", "\<\"e\"\>", ",", "\<\"r\"\>", ",", "\<\"e\"\>", 
   ",", "\<\" \"\>", ",", "\<\"i\"\>", ",", "\<\"s\"\>", ",", "\<\" \"\>", 
   ",", "\<\"t\"\>", ",", "\<\"e\"\>", ",", "\<\"x\"\>", ",", "\<\"t\"\>", 
   ",", "\<\".\"\>", ",", "\<\" \"\>", ",", "\<\"\\n\"\>", ",", "\<\"A\"\>", 
   ",", "\<\"n\"\>", ",", "\<\"d\"\>", ",", "\<\" \"\>", ",", "\<\"m\"\>", 
   ",", "\<\"o\"\>", ",", "\<\"r\"\>", ",", "\<\"e\"\>", ",", "\<\" \"\>", 
   ",", "\<\"t\"\>", ",", "\<\"e\"\>", ",", "\<\"x\"\>", ",", "\<\"t\"\>", 
   ",", "\<\".\"\>", ",", "\<\"\\n\"\>"}], "}"}]], "Output",
 ImageSize->{270, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->11777]
}, Open  ]],

Cell["\<\
Here are the integer codes corresponding to each of the bytes in the file. \
\>", "MathCaption",
 CellID->31348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/strings\>\"", ",", "Byte"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->12503],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "72", ",", "101", ",", "114", ",", "101", ",", "32", ",", "105", ",", "115",
    ",", "32", ",", "116", ",", "101", ",", "120", ",", "116", ",", "46", ",",
    "32", ",", "10", ",", "65", ",", "110", ",", "100", ",", "32", ",", "109",
    ",", "111", ",", "114", ",", "101", ",", "32", ",", "116", ",", "101", 
   ",", "120", ",", "116", ",", "46", ",", "10"}], "}"}]], "Output",
 ImageSize->{480, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->10861]
}, Open  ]],

Cell["\<\
This puts the data from each line in the file into a separate list. \
\>", "MathCaption",
 CellID->22431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/strings\>\"", ",", "Byte", ",", 
   RowBox[{"RecordLists", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->29082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "72", ",", "101", ",", "114", ",", "101", ",", "32", ",", "105", ",", 
     "115", ",", "32", ",", "116", ",", "101", ",", "120", ",", "116", ",", 
     "46", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "65", ",", "110", ",", "100", ",", "32", ",", "109", ",", "111", ",", 
     "114", ",", "101", ",", "32", ",", "116", ",", "101", ",", "120", ",", 
     "116", ",", "46"}], "}"}]}], "}"}]], "Output",
 ImageSize->{444, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->12455]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Byte",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Byte"], Cell[
    "single byte of data, returned as an integer", "TableText"]},
   {
    ButtonBox["Character",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Character"], Cell["\<\
single character, returned as a one\[Hyphen]character string\
\>", "TableText"]},
   {
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell["\<\
approximate number in Fortran\[Hyphen]like notation\
\>", "TableText"]},
   {
    ButtonBox["Number",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Number"], Cell["\<\
exact or approximate number in Fortran\[Hyphen]like notation\
\>", "TableText"]},
   {
    ButtonBox["Word",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Word"], Cell[
    "sequence of characters delimited by word separators", "TableText"]},
   {
    ButtonBox["Record",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Record"], Cell[
    "sequence of characters delimited by record separators", "TableText"]},
   {
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], Cell[
    "string terminated by a newline", "TableText"]},
   {
    ButtonBox["Expression",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Expression"], Cell[TextData[{
     "complete ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "[", 
     ButtonBox["Expression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expression"], "]"}], Cell[TextData[{
     "complete ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression, returned inside ",
     Cell[BoxData[
      ButtonBox["Hold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hold"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14197],

Cell["Types of objects to read.", "Caption",
 CellID->22106],

Cell[TextData[{
 "This returns a list of the \[OpenCurlyDoubleQuote]words\
\[CloseCurlyDoubleQuote] in the file ",
 Cell[BoxData["strings"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/strings\>\"", ",", "Word"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->15821],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Here\"\>", ",", "\<\"is\"\>", ",", "\<\"text.\"\>", 
   ",", "\<\"And\"\>", ",", "\<\"more\"\>", ",", "\<\"text.\"\>"}], 
  "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->17296]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " allows you to read \[OpenCurlyDoubleQuote]words\[CloseCurlyDoubleQuote] \
from a file. It considers a \[OpenCurlyDoubleQuote]word\
\[CloseCurlyDoubleQuote] to be any sequence of characters delimited by word \
separators. You can set the option ",
 Cell[BoxData[
  ButtonBox["WordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordSeparators"]], "InlineFormula"],
 " to specify the strings you want to treat as word separators. The default \
is to include spaces and tabs, but not to include, for example, standard \
punctuation characters. Note that in all cases successive words can be \
separated by any number of word separators. These separators are never taken \
to be part of the actual words returned by ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26281],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["RecordLists",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RecordLists"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to make a separate list for the objects in each record\
\>", "TableText"]},
   {
    ButtonBox["RecordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RecordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\<\\r\\n\>\"", ",", "\n", "\"\<\\n\>\"", ",", "\"\<\\r\>\""}],
      "}"}], Cell["separators for records", "TableText"]},
   {
    ButtonBox["WordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSeparators"], 
    RowBox[{"{", "\"\< \>\"", ",", "\"\<\[Backslash]t\>\"", "}"}], Cell[
    "separators for words", "TableText"]},
   {
    ButtonBox["NullRecords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NullRecords"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to keep zero\[Hyphen]length records\
\>", "TableText"]},
   {
    ButtonBox["NullWords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NullWords"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to keep zero\[Hyphen]length words\
\>", "TableText"]},
   {
    ButtonBox["TokenWords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TokenWords"], 
    RowBox[{"{", "}"}], Cell["words to take as tokens", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26021],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->24455],

Cell[TextData[{
 "This reads the text in the file ",
 Cell[BoxData["strings"], "InlineFormula"],
 " as a sequence of words, using the letter ",
 Cell[BoxData["e"], "InlineFormula"],
 " and ",
 Cell[BoxData["."], "InlineFormula"],
 " as word separators. "
}], "MathCaption",
 CellID->15947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/strings\>\"", ",", "Word", ",", 
   RowBox[{"WordSeparators", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<e\>\"", ",", "\"\<.\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->27124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"H\"\>", ",", "\<\"r\"\>", ",", "\<\" is t\"\>", 
   ",", "\<\"xt\"\>", ",", "\<\" \"\>", ",", "\<\"And mor\"\>", 
   ",", "\<\" t\"\>", ",", "\<\"xt\"\>"}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->18318]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " considers any data file to consist of a sequence of ",
 StyleBox["records",
  FontSlant->"Italic"],
 ". By default, each line is considered to be a separate record. In general, \
you can set the option ",
 Cell[BoxData[
  ButtonBox["RecordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordSeparators"]], "InlineFormula"],
 " to give a list of separators for records. Note that words can never cross \
record separators. As with word separators, any number of record separators \
can exist between successive records, and these separators are not considered \
to be part of the records themselves. "
}], "Text",
 CellID->9135],

Cell["\<\
By default, each line of the file is considered to be a record. \
\>", "MathCaption",
 CellID->11376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadList", "[", 
   RowBox[{"\"\<ExampleData/strings\>\"", ",", "Record"}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1774],

Cell["{\"Here is text. \", \"And more text.\"}", "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//InputForm= ",
 CellID->29859]
}, Open  ]],

Cell["\<\
Here is a file containing three \[OpenCurlyDoubleQuote]sentences\
\[CloseCurlyDoubleQuote] ending with periods. \
\>", "MathCaption",
 CellID->24998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/sentences\>\"", "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->12074],

Cell["\<\
Here is text. And more.
And a second line.\
\>", "Print",
 CellID->9253]
}, Open  ]],

Cell["This allows both periods and newlines as record separators. ", \
"MathCaption",
 CellID->6922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/sentences\>\"", ",", "Record", ",", 
   RowBox[{"RecordSeparators", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<.\>\"", ",", "\"\<\\n\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->10635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Here is text\"\>", ",", "\<\" And more\"\>", 
   ",", "\<\"And a second line\"\>"}], "}"}]], "Output",
 ImageSize->{307, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->1643]
}, Open  ]],

Cell["\<\
This puts the words in each \[OpenCurlyDoubleQuote]sentence\
\[CloseCurlyDoubleQuote] into a separate list. \
\>", "MathCaption",
 CellID->28888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/sentences\>\"", ",", "Word", ",", 
   RowBox[{"RecordLists", "->", "True"}], ",", 
   RowBox[{"RecordSeparators", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<.\>\"", ",", "\"\<\\n\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->8153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Here\"\>", ",", "\<\"is\"\>", ",", "\<\"text\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"And\"\>", ",", "\<\"more\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"And\"\>", ",", "\<\"a\"\>", ",", "\<\"second\"\>", 
     ",", "\<\"line\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->13232]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     ButtonBox["Record",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Record"], ",", 
     ButtonBox["RecordSeparators",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RecordSeparators"], "->", "{", "}", "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["read the whole of a file as a single string", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
      ButtonBox["Record",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Record"], ",", 
      RowBox[{
       ButtonBox["RecordSeparators",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RecordSeparators"], "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"lsep\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"rsep\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "make a list of those parts of a file which lie between the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lsep", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " and the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rsep", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4747],

Cell[TextData[{
 "Settings for the ",
 Cell[BoxData[
  ButtonBox["RecordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordSeparators"]], "InlineFormula"],
 " option. "
}], "Caption",
 CellID->28680],

Cell["Here is a file containing some text. ", "MathCaption",
 CellID->19926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/source\>\"", "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->25678],

Cell["\<\
f[x] (: function f :)
g[x] (: function g :)\
\>", "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"During evaluation of In[8]:=",
 CellID->202331145]
}, Open  ]],

Cell[TextData[{
 "This reads all the text in the file ",
 Cell[BoxData["source"], "InlineFormula"],
 ", and returns it as a single string. "
}], "MathCaption",
 CellID->14801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"ReadList", "[", 
   RowBox[{"\"\<ExampleData/source\>\"", ",", "Record", ",", 
    RowBox[{"RecordSeparators", "->", 
     RowBox[{"{", "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->24961],

Cell["{\"f[x] (: function f :)\\ng[x] (: function g :)\\n\"}", "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]//InputForm= ",
 CellID->14199]
}, Open  ]],

Cell[TextData[{
 "This gives a list of the parts of the file that lie between ",
 Cell[BoxData[
  RowBox[{"(", ":"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{":", ")"}]], "InlineFormula"],
 " separators. "
}], "MathCaption",
 CellID->20855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/source\>\"", ",", "Record", ",", 
   RowBox[{"RecordSeparators", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "\"\<(: \>\"", "}"}], ",", 
      RowBox[{"{", "\"\< :)\>\"", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->26363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"function f\"\>", ",", "\<\"function g\"\>"}], "}"}]], "Output",\

 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->5716]
}, Open  ]],

Cell["\<\
By choosing appropriate separators, you can pick out specific parts of files. \
\
\>", "MathCaption",
 CellID->10573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/source\>\"", ",", "Record", ",", 
   RowBox[{"RecordSeparators", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<(: function \>\"", ",", "\"\<[\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\< :)\>\"", ",", "\"\<]\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->31561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"x\"\>", ",", "\<\"f\"\>", ",", "\<\"x\"\>", ",", "\<\"g\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->23245]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " usually allows any number of appropriate separators to appear between \
successive records or words. Sometimes, however, when several separators are \
present, you may want to assume that a \[OpenCurlyDoubleQuote]null record\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]null word\
\[CloseCurlyDoubleQuote] appears between each pair of adjacent separators. \
You can do this by setting the options ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NullRecords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullRecords"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NullWords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullWords"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6473],

Cell["\<\
Here is a file containing \
\[OpenCurlyDoubleQuote]words\[CloseCurlyDoubleQuote] separated by colons. \
\>", "MathCaption",
 CellID->28274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/words\>\"", "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1550],

Cell["first:second::fourth:::seventh", "Print",
 CellID->24353]
}, Open  ]],

Cell["Here the repeated colons are treated as single separators. ", \
"MathCaption",
 CellID->1181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/words\>\"", ",", "Word", ",", 
   RowBox[{"WordSeparators", "->", 
    RowBox[{"{", "\"\<:\>\"", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->4287],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"first\"\>", ",", "\<\"second\"\>", ",", "\<\"fourth\"\>", 
   ",", "\<\"seventh\"\>"}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->2699]
}, Open  ]],

Cell["\<\
Now repeated colons are taken to have null words in between. \
\>", "MathCaption",
 CellID->18110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/words\>\"", ",", "Word", ",", 
   RowBox[{"WordSeparators", "->", 
    RowBox[{"{", "\"\<:\>\"", "}"}]}], ",", 
   RowBox[{"NullWords", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->18643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"first\"\>", ",", "\<\"second\"\>", ",", "\<\"\"\>", 
   ",", "\<\"fourth\"\>", ",", "\<\"\"\>", ",", "\<\"\"\>", 
   ",", "\<\"seventh\"\>"}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->17465]
}, Open  ]],

Cell[TextData[{
 "In most cases, you want words to be delimited by separators which are not \
themselves considered as words. Sometimes, however, it is convenient to allow \
words to be delimited by special \[OpenCurlyDoubleQuote]token words\
\[CloseCurlyDoubleQuote], which are themselves words. You can give a list of \
such token words as a setting for the option ",
 Cell[BoxData[
  ButtonBox["TokenWords",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TokenWords"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7172],

Cell["Here is some text. ", "MathCaption",
 CellID->2529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/language\>\"", "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->9981],

Cell["22*a*b+56*c+13*a*d", "Print",
 CellID->2112]
}, Open  ]],

Cell["\<\
This reads the text, using the specified token words to delimit words in the \
text. \
\>", "MathCaption",
 CellID->13476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/language\>\"", ",", "Word", ",", 
   RowBox[{"TokenWords", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<+\>\"", ",", "\"\<*\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->4381],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"22\"\>", ",", "\<\"*\"\>", ",", "\<\"a\"\>", ",", "\<\"*\"\>", 
   ",", "\<\"b\"\>", ",", "\<\"+\"\>", ",", "\<\"56\"\>", ",", "\<\"*\"\>", 
   ",", "\<\"c\"\>", ",", "\<\"+\"\>", ",", "\<\"13\"\>", ",", "\<\"*\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"*\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->8247]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " to read ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions from files. In general, each expression must end with a \
newline, although a single expression may go on for several lines. "
}], "Text",
 CellID->26890],

Cell[TextData[{
 "Here is a file containing text that can be used as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "MathCaption",
 CellID->16671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/exprs\>\"", "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->8805],

Cell["\<\
x + y +
z
2^8\
\>", "Print",
 CellID->32372]
}, Open  ]],

Cell[TextData[{
 "This reads the text in ",
 Cell[BoxData["exprs"], "InlineFormula"],
 " as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "MathCaption",
 CellID->30032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/exprs\>\"", ",", "Expression"}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->3989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", "y", "+", "z"}], ",", "256"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->9320]
}, Open  ]],

Cell["This prevents the expressions from being evaluated. ", "MathCaption",
 CellID->23165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/exprs\>\"", ",", 
   RowBox[{"Hold", "[", "Expression", "]"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->15431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"x", "+", "y", "+", "z"}], "]"}], ",", 
   RowBox[{"Hold", "[", 
    SuperscriptBox["2", "8"], "]"}]}], "}"}]], "Output",
 ImageSize->{172, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->9658]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " can insert the objects it reads into any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. The second argument to ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " can consist of any expression containing symbols such as ",
 Cell[BoxData[
  ButtonBox["Number",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Number"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Word",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Word"]], "InlineFormula"],
 " specifying objects to read. Thus, for example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Number",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Number"], ",", 
      ButtonBox["Number",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Number"]}], "}"}]}], "]"}]], "InlineFormula"],
 " inserts successive pairs of numbers that it reads into lists. Similarly, \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "[", 
     ButtonBox["Expression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expression"], "]"}]}], "]"}]], 
  "InlineFormula"],
 " puts expressions that it reads inside ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11293],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " reaches the end of your file before it has finished reading a particular \
set of objects you have asked for, then it inserts the special symbol ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " in place of the objects it has not yet read. "
}], "Text",
 CellID->17206],

Cell["Here is a file of numbers. ", "MathCaption",
 CellID->26578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/numbers\>\"", "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->16948],

Cell["\<\
11.1   22.2    33.3
44.4   55.5    66.6\
\>", "Print",
 CellID->2206]
}, Open  ]],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " appears in place of numbers that were needed after the end of the file was \
reached. "
}], "MathCaption",
 CellID->27171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/numbers\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"Number", ",", "Number", ",", "Number", ",", "Number"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->18166],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11.1`", ",", "22.2`", ",", "33.3`", ",", "44.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55.5`", ",", "66.6`", ",", "EndOfFile", ",", "EndOfFile"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]= ",
 CellID->3396]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "execute a command, and read its output", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "read any input stream", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16697],

Cell["Reading from commands and streams. ", "Caption",
 CellID->31020],

Cell[TextData[{
 "This executes the Unix command ",
 Cell[BoxData["date"], "InlineFormula"],
 ", and reads its output as a string. "
}], "MathCaption",
 CellID->23694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<!date\>\"", ",", "String"}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[31]:=",
 CellID->15529],

Cell[BoxData[
 RowBox[{"{", "\<\"Thu Mar 31 19:20:36 CST 2005\"\>", "}"}]], "Output", \
"ConversionLockdown",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]= ",
 CellID->14788]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["OpenRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OpenRead"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "open a file for reading", "TableText"]},
   {
    RowBox[{
     ButtonBox["OpenRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OpenRead"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", "]"}], Cell[
    "open a pipe for reading", "TableText"]},
   {
    RowBox[{
     ButtonBox["Read",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Read"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "read an object of the specified type from a stream", "TableText"]},
   {
    RowBox[{
     ButtonBox["Skip",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Skip"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "skip over an object of the specified type in an input stream", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Skip",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Skip"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["type", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "skip over ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " objects of the specified type in an input stream"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Close",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Close"], "[", 
     StyleBox["stream", "TI"], "]"}], Cell[
    "close an input stream", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30109],

Cell["Functions for reading from input streams. ", "Caption",
 CellID->17984],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " allows you to read ",
 StyleBox["all",
  FontSlant->"Italic"],
 " the data in a particular file or input stream. Sometimes, however, you \
want to get data a piece at a time, perhaps doing tests to find out what kind \
of data to expect next. "
}], "Text",
 CellID->11969],

Cell[TextData[{
 "When you read individual pieces of data from a file, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always remembers the \[OpenCurlyDoubleQuote]current point\
\[CloseCurlyDoubleQuote] that you are at in the file. When you call ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sets up an input stream from a file, and makes your current point the \
beginning of the file. Every time you read an object from the file using ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sets your current point to be just after the object you have read. Using \
",
 Cell[BoxData[
  ButtonBox["Skip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skip"]], "InlineFormula"],
 ", you can advance the current point past a sequence of objects without \
actually reading the objects. "
}], "Text",
 CellID->28978],

Cell["Here is a file of numbers. ", "MathCaption",
 CellID->21617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/numbers\>\"", "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->4015],

Cell["\<\
11.1   22.2    33.3
44.4   55.5    66.6\
\>", "Print",
 CellID->16626]
}, Open  ]],

Cell["This opens an input stream from the file. ", "MathCaption",
 CellID->3684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"snum", "=", 
  RowBox[{"OpenRead", "[", "\"\<ExampleData/numbers\>\"", "]"}]}]], "Input",
 CellLabel->"In[33]:=",
 CellID->9168],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"\<\"ExampleData/numbers\"\>", ",", "26"}], "]"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]="]
}, Open  ]],

Cell["This reads the first number from the file. ", "MathCaption",
 CellID->25928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"snum", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->12097],

Cell[BoxData["11.1`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]= ",
 CellID->28118]
}, Open  ]],

Cell["This reads the second pair of numbers. ", "MathCaption",
 CellID->24390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"snum", ",", 
   RowBox[{"{", 
    RowBox[{"Number", ",", "Number"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->15199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22.2`", ",", "33.3`"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]= ",
 CellID->11785]
}, Open  ]],

Cell["This skips the next number. ", "MathCaption",
 CellID->14486],

Cell[BoxData[
 RowBox[{"Skip", "[", 
  RowBox[{"snum", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->19199],

Cell["And this reads the remaining numbers. ", "MathCaption",
 CellID->12420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"snum", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->20710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"55.5`", ",", "66.6`"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]= ",
 CellID->18271]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
 CellID->15813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "snum", "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->27415],

Cell[BoxData["\<\"ExampleData/numbers\"\>"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]="]
}, Open  ]],

Cell[TextData[{
 "You can use the options ",
 Cell[BoxData[
  ButtonBox["WordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordSeparators"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RecordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordSeparators"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Skip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skip"]], "InlineFormula"],
 " just as you do in ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->318],

Cell[TextData[{
 "Note that if you try to read past the end of file, ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " returns the symbol ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->3580],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Reading Textual Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ImportingAndExportingFiles"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SearchingFiles"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 10.7468400}", "context" -> "", 
    "keywords" -> {
     "arrays", "brackets", "byte", "character", "characters", "close", 
      "data files", "delimiters", "discard data", "EndOfFile", "EOF", 
      "expression", "expressions", "external programs", "extracting", 
      "file pointer", "current point", "file position", "files", "filtering", 
      "Fortran", "hold", "ignore data", "input", "input streams", "markers", 
      "matrices", "newlines", "NullRecords", "NullWords", "number", "numbers",
       "OpenRead", "parsing", "pipes", "programs", "punctuation", "read", 
      "reading files", "ReadList", "real", "record", "RecordLists", "records",
       "RecordSeparators", "record separators", "sentences", "separators", 
      "sequential reading from files", "skip", "spaces", "spreadsheets", 
      "streams", "string", "strings", "text", "tokens", "TokenWords", 
      "unevaluated expressions", "white space", "word", "words", 
      "WordSeparators"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "With <<, you can read files which contain Mathematica expressions given \
in input form. Sometimes, however, you may instead need to read files of data \
in other formats. For example, you may have data generated by an external \
program which consists of a sequence of numbers separated by spaces. This \
data cannot be read directly as Mathematica input. However, the function \
ReadList can take such data from a file or input stream, and convert it to a \
Mathematica list. Reading numbers from a file. Here is a file of numbers. ", 
    "synonyms" -> {"2.12.8"}, "title" -> "Reading Textual Data", "type" -> 
    "Tutorial", "uri" -> "tutorial/ReadingTextualData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.8"->{
  Cell[3426, 81, 83, 2, 70, "Title",
   CellTags->{"S2.12.8", "8.1"},
   CellID->3333]},
 "8.1"->{
  Cell[3426, 81, 83, 2, 70, "Title",
   CellTags->{"S2.12.8", "8.1"},
   CellID->3333]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.8", 55552, 1915},
 {"8.1", 55651, 1919}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2801, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3426, 81, 83, 2, 70, "Title",
 CellTags->{"S2.12.8", "8.1"},
 CellID->3333],
Cell[3512, 85, 849, 25, 70, "Text",
 CellID->13865],
Cell[4364, 112, 783, 23, 70, "DefinitionBox",
 CellID->22214],
Cell[5150, 137, 64, 1, 70, "Caption",
 CellID->17282],
Cell[5217, 140, 66, 1, 70, "MathCaption",
 CellID->27007],
Cell[CellGroupData[{
Cell[5308, 145, 132, 3, 70, "Input",
 CellID->1017532992],
Cell[5443, 150, 130, 7, 70, "Print",
 CellID->355535124]
}, Open  ]],
Cell[5588, 160, 115, 3, 70, "MathCaption",
 CellID->16367],
Cell[CellGroupData[{
Cell[5728, 167, 154, 4, 28, "Input",
 CellID->28522],
Cell[5885, 173, 275, 9, 36, "Output",
 CellID->567442848]
}, Open  ]],
Cell[6175, 185, 2200, 64, 70, "DefinitionBox",
 CellID->31810],
Cell[8378, 251, 62, 1, 70, "Caption",
 CellID->17641],
Cell[8443, 254, 126, 4, 70, "MathCaption",
 CellID->7231],
Cell[CellGroupData[{
Cell[8594, 262, 207, 6, 70, "Input",
 CellID->2187],
Cell[8804, 270, 381, 13, 36, "Output",
 CellID->6705]
}, Open  ]],
Cell[9200, 286, 93, 1, 70, "MathCaption",
 CellID->6479],
Cell[CellGroupData[{
Cell[9318, 291, 201, 5, 70, "Input",
 CellID->6321],
Cell[9522, 298, 342, 11, 36, "Output",
 CellID->6538]
}, Open  ]],
Cell[9879, 312, 1039, 35, 70, "Text",
 CellID->31351],
Cell[10921, 349, 237, 8, 70, "MathCaption",
 CellID->19447],
Cell[CellGroupData[{
Cell[11183, 361, 126, 3, 70, "Input",
 CellID->24208],
Cell[11312, 366, 73, 4, 70, "Print",
 CellID->9646]
}, Open  ]],
Cell[11400, 373, 207, 7, 70, "MathCaption",
 CellID->22276],
Cell[CellGroupData[{
Cell[11632, 384, 153, 4, 70, "Input",
 CellID->25759],
Cell[11788, 390, 261, 8, 36, "Output",
 CellID->30189]
}, Open  ]],
Cell[12064, 401, 1004, 30, 70, "DefinitionBox",
 CellID->30422],
Cell[13071, 433, 69, 1, 70, "Caption",
 CellID->27666],
Cell[13143, 436, 415, 13, 70, "Text",
 CellID->8486],
Cell[13561, 451, 70, 1, 70, "MathCaption",
 CellID->3455],
Cell[CellGroupData[{
Cell[13656, 456, 126, 3, 70, "Input",
 CellID->2028],
Cell[13785, 461, 169, 7, 70, "Print",
 CellID->2126668659]
}, Open  ]],
Cell[13969, 471, 146, 4, 70, "MathCaption",
 CellID->4860],
Cell[CellGroupData[{
Cell[14140, 479, 157, 4, 70, "Input",
 CellID->29253],
Cell[14300, 485, 753, 14, 71, "Output",
 CellID->11777]
}, Open  ]],
Cell[15068, 502, 122, 3, 70, "MathCaption",
 CellID->31348],
Cell[CellGroupData[{
Cell[15215, 509, 152, 4, 70, "Input",
 CellID->12503],
Cell[15370, 515, 549, 12, 54, "Output",
 CellID->10861]
}, Open  ]],
Cell[15934, 530, 115, 3, 70, "MathCaption",
 CellID->22431],
Cell[CellGroupData[{
Cell[16074, 537, 201, 5, 70, "Input",
 CellID->29082],
Cell[16278, 544, 621, 17, 54, "Output",
 CellID->12455]
}, Open  ]],
Cell[16914, 564, 2331, 75, 70, "DefinitionBox",
 CellID->14197],
Cell[19248, 641, 60, 1, 70, "Caption",
 CellID->22106],
Cell[19311, 644, 198, 6, 70, "MathCaption",
 CellID->8752],
Cell[CellGroupData[{
Cell[19534, 654, 153, 4, 70, "Input",
 CellID->15821],
Cell[19690, 660, 314, 9, 36, "Output",
 CellID->17296]
}, Open  ]],
Cell[20019, 672, 1019, 24, 70, "Text",
 CellID->26281],
Cell[21041, 698, 1947, 57, 70, "DefinitionBox3Col",
 CellID->26021],
Cell[22991, 757, 188, 8, 70, "Caption",
 CellID->24455],
Cell[23182, 767, 289, 9, 70, "MathCaption",
 CellID->15947],
Cell[CellGroupData[{
Cell[23496, 780, 268, 7, 70, "Input",
 CellID->27124],
Cell[23767, 789, 347, 9, 36, "Output",
 CellID->18318]
}, Open  ]],
Cell[24129, 801, 711, 17, 70, "Text",
 CellID->9135],
Cell[24843, 820, 111, 3, 70, "MathCaption",
 CellID->11376],
Cell[CellGroupData[{
Cell[24979, 827, 190, 6, 70, "Input",
 CellID->1774],
Cell[25172, 835, 198, 5, 50, "Output",
 CellID->29859]
}, Open  ]],
Cell[25385, 843, 159, 4, 70, "MathCaption",
 CellID->24998],
Cell[CellGroupData[{
Cell[25569, 851, 130, 3, 70, "Input",
 CellID->12074],
Cell[25702, 856, 82, 4, 70, "Print",
 CellID->9253]
}, Open  ]],
Cell[25799, 863, 100, 2, 70, "MathCaption",
 CellID->6922],
Cell[CellGroupData[{
Cell[25924, 869, 276, 7, 70, "Input",
 CellID->10635],
Cell[26203, 878, 274, 8, 36, "Output",
 CellID->1643]
}, Open  ]],
Cell[26492, 889, 155, 4, 70, "MathCaption",
 CellID->28888],
Cell[CellGroupData[{
Cell[26672, 897, 321, 8, 70, "Input",
 CellID->8153],
Cell[26996, 907, 493, 15, 36, "Output",
 CellID->13232]
}, Open  ]],
Cell[27504, 925, 2239, 65, 70, "DefinitionBox",
 CellID->4747],
Cell[29746, 992, 216, 8, 70, "Caption",
 CellID->28680],
Cell[29965, 1002, 76, 1, 70, "MathCaption",
 CellID->19926],
Cell[CellGroupData[{
Cell[30066, 1007, 127, 3, 70, "Input",
 CellID->25678],
Cell[30196, 1012, 182, 7, 70, "Print",
 CellID->202331145]
}, Open  ]],
Cell[30393, 1022, 175, 5, 70, "MathCaption",
 CellID->14801],
Cell[CellGroupData[{
Cell[30593, 1031, 263, 7, 70, "Input",
 CellID->24961],
Cell[30859, 1040, 212, 5, 50, "Output",
 CellID->14199]
}, Open  ]],
Cell[31086, 1048, 254, 9, 70, "MathCaption",
 CellID->20855],
Cell[CellGroupData[{
Cell[31365, 1061, 329, 9, 70, "Input",
 CellID->26363],
Cell[31697, 1072, 237, 8, 36, "Output",
 CellID->5716]
}, Open  ]],
Cell[31949, 1083, 127, 4, 70, "MathCaption",
 CellID->10573],
Cell[CellGroupData[{
Cell[32101, 1091, 413, 12, 70, "Input",
 CellID->31561],
Cell[32517, 1105, 256, 8, 36, "Output",
 CellID->23245]
}, Open  ]],
Cell[32788, 1116, 968, 28, 70, "Text",
 CellID->6473],
Cell[33759, 1146, 149, 4, 70, "MathCaption",
 CellID->28274],
Cell[CellGroupData[{
Cell[33933, 1154, 125, 3, 70, "Input",
 CellID->1550],
Cell[34061, 1159, 63, 1, 70, "Print",
 CellID->24353]
}, Open  ]],
Cell[34139, 1163, 99, 2, 70, "MathCaption",
 CellID->1181],
Cell[CellGroupData[{
Cell[34263, 1169, 231, 6, 70, "Input",
 CellID->4287],
Cell[34497, 1177, 277, 8, 36, "Output",
 CellID->2699]
}, Open  ]],
Cell[34789, 1188, 108, 3, 70, "MathCaption",
 CellID->18110],
Cell[CellGroupData[{
Cell[34922, 1195, 278, 7, 70, "Input",
 CellID->18643],
Cell[35203, 1204, 333, 9, 36, "Output",
 CellID->17465]
}, Open  ]],
Cell[35551, 1216, 525, 12, 70, "Text",
 CellID->7172],
Cell[36079, 1230, 57, 1, 70, "MathCaption",
 CellID->2529],
Cell[CellGroupData[{
Cell[36161, 1235, 128, 3, 70, "Input",
 CellID->9981],
Cell[36292, 1240, 50, 1, 70, "Print",
 CellID->2112]
}, Open  ]],
Cell[36357, 1244, 132, 4, 70, "MathCaption",
 CellID->13476],
Cell[CellGroupData[{
Cell[36514, 1252, 264, 7, 70, "Input",
 CellID->4381],
Cell[36781, 1261, 466, 10, 36, "Output",
 CellID->8247]
}, Open  ]],
Cell[37262, 1274, 384, 12, 70, "Text",
 CellID->26890],
Cell[37649, 1288, 167, 6, 70, "MathCaption",
 CellID->16671],
Cell[CellGroupData[{
Cell[37841, 1298, 125, 3, 70, "Input",
 CellID->8805],
Cell[37969, 1303, 54, 5, 70, "Print",
 CellID->32372]
}, Open  ]],
Cell[38038, 1311, 196, 8, 70, "MathCaption",
 CellID->30032],
Cell[CellGroupData[{
Cell[38259, 1323, 156, 4, 70, "Input",
 CellID->3989],
Cell[38418, 1329, 236, 8, 36, "Output",
 CellID->9320]
}, Open  ]],
Cell[38669, 1340, 91, 1, 70, "MathCaption",
 CellID->23165],
Cell[CellGroupData[{
Cell[38785, 1345, 189, 5, 70, "Input",
 CellID->15431],
Cell[38977, 1352, 326, 11, 39, "Output",
 CellID->9658]
}, Open  ]],
Cell[39318, 1366, 1882, 63, 70, "Text",
 CellID->11293],
Cell[41203, 1431, 492, 14, 70, "Text",
 CellID->17206],
Cell[41698, 1447, 66, 1, 70, "MathCaption",
 CellID->26578],
Cell[CellGroupData[{
Cell[41789, 1452, 128, 3, 70, "Input",
 CellID->16948],
Cell[41920, 1457, 79, 4, 70, "Print",
 CellID->2206]
}, Open  ]],
Cell[42014, 1464, 278, 9, 70, "MathCaption",
 CellID->27171],
Cell[CellGroupData[{
Cell[42317, 1477, 242, 7, 70, "Input",
 CellID->18166],
Cell[42562, 1486, 384, 12, 36, "Output",
 CellID->3396]
}, Open  ]],
Cell[42961, 1501, 853, 25, 70, "DefinitionBox",
 CellID->16697],
Cell[43817, 1528, 70, 1, 70, "Caption",
 CellID->31020],
Cell[43890, 1531, 167, 5, 70, "MathCaption",
 CellID->23694],
Cell[CellGroupData[{
Cell[44082, 1540, 165, 5, 70, "Input",
 CellID->15529],
Cell[44250, 1547, 238, 7, 36, "Output",
 CellID->14788]
}, Open  ]],
Cell[44503, 1557, 1973, 61, 70, "DefinitionBox",
 CellID->30109],
Cell[46479, 1620, 77, 1, 70, "Caption",
 CellID->17984],
Cell[46559, 1623, 410, 12, 70, "Text",
 CellID->11969],
Cell[46972, 1637, 1075, 31, 70, "Text",
 CellID->28978],
Cell[48050, 1670, 66, 1, 70, "MathCaption",
 CellID->21617],
Cell[CellGroupData[{
Cell[48141, 1675, 127, 3, 70, "Input",
 CellID->4015],
Cell[48271, 1680, 80, 4, 70, "Print",
 CellID->16626]
}, Open  ]],
Cell[48366, 1687, 80, 1, 70, "MathCaption",
 CellID->3684],
Cell[CellGroupData[{
Cell[48471, 1692, 152, 4, 70, "Input",
 CellID->9168],
Cell[48626, 1698, 227, 6, 36, "Output"]
}, Open  ]],
Cell[48868, 1707, 82, 1, 70, "MathCaption",
 CellID->25928],
Cell[CellGroupData[{
Cell[48975, 1712, 128, 4, 70, "Input",
 CellID->12097],
Cell[49106, 1718, 160, 5, 36, "Output",
 CellID->28118]
}, Open  ]],
Cell[49281, 1726, 78, 1, 70, "MathCaption",
 CellID->24390],
Cell[CellGroupData[{
Cell[49384, 1731, 182, 6, 70, "Input",
 CellID->15199],
Cell[49569, 1739, 209, 7, 36, "Output",
 CellID->11785]
}, Open  ]],
Cell[49793, 1749, 67, 1, 70, "MathCaption",
 CellID->14486],
Cell[49863, 1752, 128, 4, 70, "Input",
 CellID->19199],
Cell[49994, 1758, 77, 1, 70, "MathCaption",
 CellID->12420],
Cell[CellGroupData[{
Cell[50096, 1763, 132, 4, 70, "Input",
 CellID->20710],
Cell[50231, 1769, 209, 7, 36, "Output",
 CellID->18271]
}, Open  ]],
Cell[50455, 1779, 69, 1, 70, "MathCaption",
 CellID->15813],
Cell[CellGroupData[{
Cell[50549, 1784, 101, 3, 70, "Input",
 CellID->27415],
Cell[50653, 1789, 166, 4, 36, "Output"]
}, Open  ]],
Cell[50834, 1796, 736, 28, 70, "Text",
 CellID->318],
Cell[51573, 1826, 361, 13, 70, "Text",
 CellID->3580],
Cell[51937, 1841, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]],
Cell[52114, 1847, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

