(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     68532,       1722]
NotebookOptionsPosition[     61690,       1498]
NotebookOutlinePosition[     64397,       1567]
CellTagsIndexPosition[     64304,       1561]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Combining Graphics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphicsColumn" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsColumn"], 
          "GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"], "GraphicsRow" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsRow"], "InputForm" :> 
          Documentation`HelpLookup["paclet:ref/InputForm"], "Show" :> 
          Documentation`HelpLookup["paclet:ref/Show"], "Spacings" :> 
          Documentation`HelpLookup["paclet:ref/Spacings"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GraphicsColumn\"\>", 
       2->"\<\"GraphicsGrid\"\>", 3->"\<\"GraphicsRow\"\>", 
       4->"\<\"InputForm\"\>", 5->"\<\"Show\"\>", 
       6->"\<\"Spacings\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Redrawing and Combining Plots", "Title",
 CellTags->{"S1.9.3", "3.1"},
 CellID->9501],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " saves information about every plot you produce, so that you can later \
redraw it. When you redraw plots, you can change some of the options you \
use."
}], "Text",
 CellID->17482],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Show",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Show"], "[", 
     StyleBox["plot", "TI"], ",", 
     StyleBox["option", "TI"], "->", 
     StyleBox["value", "TI"], "]"}], Cell[
    "redraw a plot with options changed", "TableText"]},
   {
    RowBox[{
     ButtonBox["Show",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Show"], "[", 
     SubscriptBox[
      StyleBox["plot", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["plot", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "combine several plots", "TableText"]},
   {
    RowBox[{
     ButtonBox["Show",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Show"], "[", 
     ButtonBox["GraphicsGrid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsGrid",
      ButtonNote->"ObsLink: GraphicsArray -> GraphicsGrid (Grid)"], "[", "{", 
     "{", 
     SubscriptBox[
      StyleBox["plot", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["plot", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", "]"}], "\[SpanFromLeft]"},
   {"", Cell["draw an array of plots", "TableText"]},
   {
    RowBox[{
     ButtonBox["InputForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputForm"], "[", 
     StyleBox["plot", "TI"], "]"}], Cell[
    "show the underlying textual description of the plot", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29447],

Cell["Functions for manipulating plots. ", "Caption",
 CellID->15665],

Cell["Here is a simple plot.", "MathCaption",
 CellID->10753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ChebyshevT", "[", 
    RowBox[{"7", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22104],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142196509]
}, Open  ]],

Cell[TextData[{
 "When you redraw the plot, you can change some of the options. This changes \
the choice of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " scale. "
}], "MathCaption",
 CellID->3964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21781],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->182440678]
}, Open  ]],

Cell["\<\
This takes the plot from the previous line, and changes another option in it. \
\
\>", "MathCaption",
 CellID->8106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"PlotLabel", "->", "\"\<A Chebyshev Polynomial\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3656],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->163140190]
}, Open  ]],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " with a sequence of different options, you can look at the same plot in \
many different ways. You may want to do this, for example, if you are trying \
to find the best possible setting of options. "
}], "Text",
 CellID->22593],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " to combine plots. All of the options for the resulting graphic will be \
based upon the options of the first graphic in the ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " expression."
}], "Text",
 CellID->27080],

Cell[TextData[{
 "This sets ",
 Cell[BoxData["gj0"], "InlineFormula"],
 " to be a plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "0"], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->16080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gj0", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"0", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->14868],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->210435045]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "1"], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 " to\[NonBreakingSpace]",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->13713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gy1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"BesselY", "[", 
     RowBox[{"1", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->20968],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->583954895]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " specifies an explicit ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " for each graphic."
}], "MathCaption",
 CellID->982120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"gj0", ",", "PlotRange"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->102267092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.402759374484334`"}], ",", "0.9999999999999896`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->37444834]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to override the explicit value set for ",
 Cell[BoxData["gj0"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->27216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gjy", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"gj0", ",", "gy1", ",", 
    RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]}]], "Input",
 CellLabel->"In[39]:=",
 CellID->12079],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->128506205]
}, Open  ]],

Cell[TextData[{
 "All ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics are expressions and can be manipulated in the same way as any \
other expression. Doing these kinds of manipulations does not require the use \
of ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 "."
}], "Text",
 CellID->435537690],

Cell[TextData[{
 "This replaces all instances of the symbol ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " with the symbol ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " in the graphics expression represented by ",
 Cell[BoxData["gj0"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->490232017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gj0", " ", "/.", " ", 
  RowBox[{"Line", "\[Rule]", "Point"}]}]], "Input",
 CellLabel->"In[43]:=",
 CellID->170254811],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->203473578]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Show",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Show"], "["}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["plot", "TI"], "1"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["plot", "TI"], "2"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   RowBox[{",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " you can combine several plots into one. ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid",
   ButtonNote->"ObsLink: GraphicsArray -> GraphicsGrid (Grid)"]], 
  "InlineFormula"],
 " allows you to draw several plots in an array. "
}], "Text",
 CellID->17040],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["GraphicsGrid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsGrid"], "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["plot", "TI"], 
           StyleBox["11", "TR"]], ",", 
          SubscriptBox[
           StyleBox["plot", "TI"], 
           StyleBox["12", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], 
         StyleBox["}", "TR"]}], 
        StyleBox[",", "TR"], 
        StyleBox["\[Ellipsis]", "TR"]}], 
       StyleBox["}", "TR"]}], 
      StyleBox["]", "TR"]}], " "}], "\[SpanFromLeft]"},
   {"", Cell["draw a rectangular array of plots", "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphicsRow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsRow"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["plot", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["plot", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["draw several plots side by side", "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphicsColumn",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsColumn"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["plot", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["plot", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["draw a column of plots", "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphicsGrid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsGrid"], "[", 
     RowBox[{
      StyleBox["plots", "TI"], ",", 
      RowBox[{
       ButtonBox["Spacings",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Spacings"], "->", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["h", "TI"], ",", 
         StyleBox["v", "TI"]}], "}"}]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
put the specified horizontal and vertical spacing between the plots\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31531],

Cell["Drawing arrays of plots. ", "Caption",
 CellID->12933],

Cell["This shows the plots given above in an array. ", "MathCaption",
 CellID->23779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gj0", ",", "gjy"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"gy1", ",", "gjy"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->20663],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->19338050]
}, Open  ]],

Cell[TextData[{
 "If you redisplay an array of plots using ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ", any options you specify will be used for the whole array, rather than for \
individual plots. "
}], "MathCaption",
 CellID->26653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameTicks", "->", "None"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->27936],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->805284718]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid",
   ButtonNote->"ObsLink: GraphicsArray -> GraphicsGrid (Grid)"]], 
  "InlineFormula"],
 " by default puts a narrow border around each of the plots in the array it \
gives. You can change the size of this border by setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Spacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacings"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["h", "TI"], ",", 
     StyleBox["v", "TI"]}], "}"}]}]], "InlineFormula"],
 ". The parameters ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " give the horizontal and vertical spacings to be used. The ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " option uses the width and height of characters in the default font to \
scale the ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " parameters by default, but it is generally more useful in graphics to use \
",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates. ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " scales widths and heights so that a value of 1 represents the width and \
height of one element of the grid."
}], "Text",
 CellID->26835],

Cell["\<\
This increases the horizontal spacing, but decreases the vertical spacing \
between the plots in the array. \
\>", "MathCaption",
 CellID->25680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gj0", ",", "gjy"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"gy1", ",", "gjy"}], "}"}]}], "}"}], ",", 
   RowBox[{"Spacings", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", ".3", "]"}], ",", 
      RowBox[{"Scaled", "[", "0", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->8976],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->408220358]
}, Open  ]],

Cell[TextData[{
 "When you make a plot, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " saves the list of points it used, together with some other information. \
Using what is saved, you can redraw plots in many different ways with ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ". However, you should realize that no matter what options you specify, ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " still has the same basic set of points to work with. So, for example, if \
you set the options so that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " displays a small portion of your original plot magnified, you will \
probably be able to see the individual sample points that ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " used. Options like ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " can only be set in the original ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " command itself. (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always plots the actual points it has; it avoids using smoothed or splined \
curves, which can give misleading results in mathematical graphics.) "
}], "Text",
 CellID->5725],

Cell["Here is a simple plot. ", "MathCaption",
 CellID->4071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->24808],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->453485893]
}, Open  ]],

Cell[TextData[{
 "This shows a small region of the plot in a magnified form. At this \
resolution, you can see the individual line segments that were produced by \
the original ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " command. "
}], "MathCaption",
 CellID->9156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", ".005"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{".99999", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->5602],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWV2IlFUY/tyZz0K60NRSM1vDn7Ss/O3HTE3d9TeV3DZZN51dV3cw3W0d
ieymbtILg9CbvKkLS/DnQlGUwEAUJCESJEEqCIXQCyVIvFgQPp/3/b5v58w7
D+O4MzszC7PnvOc833mfc877982sSmU6O7anMun2VH1jT6q7M92+s76hqwdD
iUGe553GJzXKQz9ATz+ngwBt/n8vETZe3E0KOh6SkboCbTJqvw2fiJ4NhcHS
JLIjdf2Rc1Z81BO7VO7tfdDcdPju3fveUMLKR5OI1irUKtB9UPcqM6GWA/sv
HTt6VbpMi2C9we5I/g68EmV2AhmV//rzTnvbcekOqzluIAZ6tcZtp8onT1z7
Zt9F6T4dWN8Qay7kCbb1jYYelWGVrS1H7t3r9Ybr0lMidKj/qy/P/XLub+lm
Z901PlX5yu//du04Jd0RFNWt8q1b/wOF/95IiuoyqGdy+NjZZ+ka2+M9pTtP
CGoURX2iMvaMtXD13miK2mZQY3L42Nnn6BrpIPL/XZkzOCVvbN4tPn6EkzYZ
W6ajqzPW9cXuny//etN7nlhzWSLgE31y4DhEHp+ths84wqfY2Jcwayei8S1G
xwtEx0B4cDFnFXLb8/X5s2euS7eWuHUYbvUV4lYM182G2/igHJFP2nBlBFSE
Vem+GDCfbRP0D9//NoHOpqLZiXR2UzQ7ic5uVBlJGqlaulmUsAtnsWlsXbqT
6RqtBvUSRW0wqCkU1aIy/AbeAx/ypubwsbMv593D48cum4OsX683Ol8hdlmW
GFZAtpw+UhnRGzFcOE0jnIqu4ZzTi6tVV1ezysgnyCqSk18lusrql36fHI3G
O/nQMHltoJm4N0Ispcnweb3KfNapjBoD5aPwmR70N0pZG7D290GsKap8ZgSu
l9rZmX2z7hprDWoWRa1RGbtB9XTjxn/ebIpaHaOiymdODh87+wZdY5XK8CZo
EtSbFLUyRkXZ/S2KWmFQb+fwsbNz6RrLVQbk4oV/pDs37zb7/yZqLWeZytn8
9g6x5Mq/qS41rOYRVqW9qbraGo22d4m2StYfIjbo+MHvLv/04xXpzq8kJ2In
S4Kwllg40DwKWt7iiMV7QSnxjcW5RdHKiwLXX1VyKpfsrPvsQoNaTFELDGoJ
Rek9J+D4cH/pNuTwCWezFUkjXUN9OIkaAaiwTFhKcRqbkmCErIEACaXLKU6j
po8oCltcu/oQ+EuUXJnDTOOuj2iOghYYGK58w/Q+XU+zgh/uornpMOpf2cua
vDstX5TT/OxDCzbb2nIEh4LNhtmq6rFOqyofpwXrw2ngdCXbNRFupX83pxWs
j/WhBbqgUW6pmeiqZPUyNbYH3AtuB3ck9rC+QqwoSyNPzrMfyd4baojhRGpF
Hwf9jZP2bXUCtZxNAfPv8fQ+2yh2HD3ZDoodS/e4lWLHUL7pPqzsaTTluY2u
N5Ly3EGxwynPboodRnnqt6HhG3kCQ1B17Y/b6jtDKeeMY3zxH/O8Ym9dnx0C
zdCCohgjiOlIEQf2X8IgMgsSwJP0RD5TCvQttlJe8RRkHCJYHjt6FXTBGwlu
/ryDOF/0w5qqTr4ATboX9Hn1mTuyxsgk8il4gi5I14G7WgP2JpO7q85XxL1V
Z+HKtcimlOgb/m5IfpUc9BCol3Sb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->563146840]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->4862189],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "TutorialMoreAbout",
 CellID->768947809]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->318794552],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->151800574]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Redrawing and Combining Plots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Graphics and Sound", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/GraphicsAndSoundOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Options"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ManipulatingOptions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 16.3719840}", "context" -> "", 
    "keywords" -> {
     "GraphicsArray", "GraphicsSpacing", "InputForm", "layout", "options", 
      "overlaying plots", "plots", "redisplay graphics", "redraw plot", 
      "show", "spacing", "splines", "superimposing graphics"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica saves information about every plot you produce, so that you \
can later redraw it. When you redraw plots, you can change some of the \
options you use. Functions for manipulating plots. Here is a simple plot.", 
    "synonyms" -> {"1.9.3"}, "title" -> "Redrawing and Combining Plots", 
    "type" -> "Tutorial", "uri" -> "tutorial/RedrawingAndCombiningPlots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.3"->{
  Cell[2920, 82, 91, 2, 70, "Title",
   CellTags->{"S1.9.3", "3.1"},
   CellID->9501]},
 "3.1"->{
  Cell[2920, 82, 91, 2, 70, "Title",
   CellTags->{"S1.9.3", "3.1"},
   CellID->9501]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.3", 64095, 1550},
 {"3.1", 64193, 1554}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2295, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2920, 82, 91, 2, 70, "Title",
 CellTags->{"S1.9.3", "3.1"},
 CellID->9501],
Cell[3014, 86, 248, 7, 70, "Text",
 CellID->17482],
Cell[3265, 95, 1950, 57, 70, "DefinitionBox",
 CellID->29447],
Cell[5218, 154, 69, 1, 70, "Caption",
 CellID->15665],
Cell[5290, 157, 61, 1, 70, "MathCaption",
 CellID->10753],
Cell[CellGroupData[{
Cell[5376, 162, 262, 9, 28, "Input",
 CellID->22104],
Cell[5641, 173, 4356, 75, 134, "Output",
 Evaluatable->False,
 CellID->142196509]
}, Open  ]],
Cell[10012, 251, 221, 7, 70, "MathCaption",
 CellID->3964],
Cell[CellGroupData[{
Cell[10258, 262, 225, 8, 28, "Input",
 CellID->21781],
Cell[10486, 272, 3669, 64, 134, "Output",
 Evaluatable->False,
 CellID->182440678]
}, Open  ]],
Cell[14170, 339, 126, 4, 70, "MathCaption",
 CellID->8106],
Cell[CellGroupData[{
Cell[14321, 347, 183, 6, 28, "Input",
 CellID->3656],
Cell[14507, 355, 4121, 72, 150, "Output",
 Evaluatable->False,
 CellID->163140190]
}, Open  ]],
Cell[18643, 430, 371, 10, 70, "Text",
 CellID->22593],
Cell[19017, 442, 433, 14, 70, "Text",
 CellID->27080],
Cell[19453, 458, 438, 18, 70, "MathCaption",
 CellID->16080],
Cell[CellGroupData[{
Cell[19916, 480, 269, 9, 28, "Input",
 CellID->14868],
Cell[20188, 491, 2600, 47, 127, "Output",
 Evaluatable->False,
 CellID->210435045]
}, Open  ]],
Cell[22803, 541, 402, 16, 70, "MathCaption",
 CellID->13713],
Cell[CellGroupData[{
Cell[23230, 561, 269, 9, 28, "Input",
 CellID->20968],
Cell[23502, 572, 2819, 50, 139, "Output",
 Evaluatable->False,
 CellID->583954895]
}, Open  ]],
Cell[26336, 625, 333, 12, 70, "MathCaption",
 CellID->982120],
Cell[CellGroupData[{
Cell[26694, 641, 137, 4, 70, "Input",
 CellID->102267092],
Cell[26834, 647, 439, 15, 36, "Output",
 CellID->37444834]
}, Open  ]],
Cell[27288, 665, 276, 10, 70, "MathCaption",
 CellID->27216],
Cell[CellGroupData[{
Cell[27589, 679, 207, 6, 28, "Input",
 CellID->12079],
Cell[27799, 687, 3174, 56, 123, "Output",
 Evaluatable->False,
 CellID->128506205]
}, Open  ]],
Cell[30988, 746, 383, 13, 70, "Text",
 CellID->435537690],
Cell[31374, 761, 440, 15, 70, "MathCaption",
 CellID->490232017],
Cell[CellGroupData[{
Cell[31839, 780, 142, 4, 28, "Input",
 CellID->170254811],
Cell[31984, 786, 2340, 42, 127, "Output",
 Evaluatable->False,
 CellID->203473578]
}, Open  ]],
Cell[34339, 831, 849, 30, 70, "Text",
 CellID->17040],
Cell[35191, 863, 2745, 85, 70, "DefinitionBox",
 CellID->31531],
Cell[37939, 950, 60, 1, 70, "Caption",
 CellID->12933],
Cell[38002, 953, 85, 1, 70, "MathCaption",
 CellID->23779],
Cell[CellGroupData[{
Cell[38112, 958, 262, 9, 28, "Input",
 CellID->20663],
Cell[38377, 969, 4332, 75, 133, "Output",
 Evaluatable->False,
 CellID->19338050]
}, Open  ]],
Cell[42724, 1047, 307, 9, 70, "MathCaption",
 CellID->26653],
Cell[CellGroupData[{
Cell[43056, 1060, 199, 6, 28, "Input",
 CellID->27936],
Cell[43258, 1068, 4496, 78, 134, "Output",
 Evaluatable->False,
 CellID->805284718]
}, Open  ]],
Cell[47769, 1149, 1610, 50, 70, "Text",
 CellID->26835],
Cell[49382, 1201, 155, 4, 70, "MathCaption",
 CellID->25680],
Cell[CellGroupData[{
Cell[49562, 1209, 448, 15, 28, "Input",
 CellID->8976],
Cell[50013, 1226, 3864, 67, 115, "Output",
 Evaluatable->False,
 CellID->408220358]
}, Open  ]],
Cell[53892, 1296, 1488, 41, 70, "Text",
 CellID->5725],
Cell[55383, 1339, 61, 1, 70, "MathCaption",
 CellID->4071],
Cell[CellGroupData[{
Cell[55469, 1344, 233, 8, 28, "Input",
 CellID->24808],
Cell[55705, 1354, 2804, 50, 140, "Output",
 Evaluatable->False,
 CellID->453485893]
}, Open  ]],
Cell[58524, 1407, 338, 10, 70, "MathCaption",
 CellID->9156],
Cell[CellGroupData[{
Cell[58887, 1421, 321, 11, 28, "Input",
 CellID->5602],
Cell[59211, 1434, 1888, 35, 118, "Output",
 Evaluatable->False,
 CellID->563146840]
}, Open  ]],
Cell[CellGroupData[{
Cell[61136, 1474, 64, 1, 70, "TutorialMoreAboutSection",
 CellID->4862189],
Cell[61203, 1477, 155, 3, 70, "TutorialMoreAbout",
 CellID->768947809]
}, Open  ]],
Cell[CellGroupData[{
Cell[61395, 1485, 72, 1, 70, "RelatedTutorialsSection",
 CellID->318794552],
Cell[61470, 1488, 166, 4, 70, "RelatedTutorials",
 CellID->151800574]
}, Open  ]]
}, Open  ]],
Cell[61663, 1496, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

