(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13498,        473]
NotebookOptionsPosition[      9184,        346]
NotebookOutlinePosition[     12136,        420]
CellTagsIndexPosition[     12045,        414]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions and Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionsAndProgramsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functions and Programs\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Do" :> Documentation`HelpLookup["paclet:ref/Do"], "Print" :> 
          Documentation`HelpLookup["paclet:ref/Print"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Do\"\>", 2->"\<\"Print\"\>", 
       3->"\<\"Table\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Repetitive Operations", "Title",
 CellTags->{"S1.7.3", "3.1"},
 CellID->3565],

Cell[TextData[{
 "In using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you sometimes need to repeat an operation many times. There are many ways \
to do this. Often the most natural is in fact to set up a structure such as a \
list with many elements, and then apply your operation to each of the \
elements. "
}], "Text",
 CellID->17421],

Cell[TextData[{
 "Another approach is to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ", which works much like the iteration constructs in languages such as C and \
Fortran. ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " uses the same ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 ButtonBox["iterator notation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SomeGeneralNotationsAndConventions#27272"],
 " as ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 ", described in \"",
 ButtonBox["Sums and Products",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SumsAndProducts"],
 "\". "
}], "Text",
 CellID->23445],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Do",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Do"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox[
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TI"]], "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " running from ",
     Cell[BoxData["1"], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Do",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Do"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]], ",", 
        StyleBox["di", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " running from ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Print",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Print"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "print ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox[
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TI"]], "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "make a list of the values of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " running from ",
     Cell[BoxData["1"], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18610],

Cell["Implementing repetitive operations. ", "Caption",
 CellID->495],

Cell["This prints out the values of the first five factorials. ", \
"MathCaption",
 CellID->16741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"i", "!"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->15022],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellID->31812],

Cell[BoxData["2"], "Print",
 CellID->29151],

Cell[BoxData["6"], "Print",
 CellID->23015],

Cell[BoxData["24"], "Print",
 CellID->8055],

Cell[BoxData["120"], "Print",
 CellID->3393]
}, Open  ]]
}, Open  ]],

Cell["\<\
It is often more useful to have a list of results, which you can then \
manipulate further. \
\>", "MathCaption",
 CellID->8738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "!"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->15279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "6", ",", "24", ",", "120"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->19882]
}, Open  ]],

Cell[TextData[{
 "If you do not give an iteration variable, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " simply repeats the operation you have specified, without changing \
anything. "
}], "MathCaption",
 CellID->1608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", "1"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", "r"}], ")"}]}]}], ",", 
    RowBox[{"{", "100", "}"}]}], "]"}], ";", "r"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->12654],

Cell[BoxData[
 FractionBox["573147844013817084101", "927372692193078999176"]], "Output",
 ImageSize->{168, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->3822]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->100032405],

Cell[TextData[ButtonBox["Functions and Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionsAndProgramsOverview"]], "RelatedTutorials",
 CellID->1392681]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Repetitive Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functions and Programs", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionsAndProgramsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FunctionsAsProcedures"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TransformationRulesForFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 20.2002070}", "context" -> "", 
    "keywords" -> {
     "do", "Fortran", "iteration constructs", "print", "repeat", 
      "repetitive operations", "table"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In using Mathematica, you sometimes need to repeat an operation many \
times. There are many ways to do this. Often the most natural is in fact to \
set up a structure such as a list with many elements, and then apply your \
operation to each of the elements. Another approach is to use the Mathematica \
function Do, which works much like the iteration constructs in languages such \
as C and Fortran. Do uses the same Mathematica iterator notation as Sum and \
Product, described in \"Sums and Products\". Implementing repetitive \
operations. ", "synonyms" -> {"1.7.3"}, "title" -> "Repetitive Operations", 
    "type" -> "Tutorial", "uri" -> "tutorial/RepetitiveOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.7.3"->{
  Cell[1968, 60, 83, 2, 70, "Title",
   CellTags->{"S1.7.3", "3.1"},
   CellID->3565]},
 "3.1"->{
  Cell[1968, 60, 83, 2, 70, "Title",
   CellTags->{"S1.7.3", "3.1"},
   CellID->3565]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.7.3", 11836, 403},
 {"3.1", 11934, 407}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1343, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1968, 60, 83, 2, 70, "Title",
 CellTags->{"S1.7.3", "3.1"},
 CellID->3565],
Cell[2054, 64, 350, 9, 70, "Text",
 CellID->17421],
Cell[2407, 75, 1030, 38, 70, "Text",
 CellID->23445],
Cell[3440, 115, 3324, 116, 70, "DefinitionBox",
 CellID->18610],
Cell[6767, 233, 69, 1, 70, "Caption",
 CellID->495],
Cell[6839, 236, 98, 2, 70, "MathCaption",
 CellID->16741],
Cell[CellGroupData[{
Cell[6962, 242, 220, 8, 70, "Input",
 CellID->15022],
Cell[CellGroupData[{
Cell[7207, 254, 43, 1, 70, "Print",
 CellID->31812],
Cell[7253, 257, 43, 1, 70, "Print",
 CellID->29151],
Cell[7299, 260, 43, 1, 70, "Print",
 CellID->23015],
Cell[7345, 263, 43, 1, 70, "Print",
 CellID->8055],
Cell[7391, 266, 44, 1, 70, "Print",
 CellID->3393]
}, Open  ]]
}, Open  ]],
Cell[7462, 271, 138, 4, 70, "MathCaption",
 CellID->8738],
Cell[CellGroupData[{
Cell[7625, 279, 189, 7, 70, "Input",
 CellID->15279],
Cell[7817, 288, 234, 7, 36, "Output",
 CellID->19882]
}, Open  ]],
Cell[8066, 298, 228, 7, 70, "MathCaption",
 CellID->1608],
Cell[CellGroupData[{
Cell[8319, 309, 308, 11, 70, "Input",
 CellID->12654],
Cell[8630, 322, 215, 6, 51, "Output",
 CellID->3822]
}, Open  ]],
Cell[CellGroupData[{
Cell[8882, 333, 72, 1, 70, "RelatedTutorialsSection",
 CellID->100032405],
Cell[8957, 336, 173, 4, 70, "RelatedTutorials",
 CellID->1392681]
}, Open  ]]
}, Open  ]],
Cell[9157, 344, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

