(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45610,       1568]
NotebookOptionsPosition[     36083,       1275]
NotebookOutlinePosition[     40304,       1367]
CellTagsIndexPosition[     40209,       1361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColumnLines" :> 
          Documentation`HelpLookup["paclet:ref/ColumnLines"], "DisplayForm" :> 
          Documentation`HelpLookup["paclet:ref/DisplayForm"], "ErrorBox" :> 
          Documentation`HelpLookup["paclet:ref/ErrorBox"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "FormBox" :> 
          Documentation`HelpLookup["paclet:ref/FormBox"], "FractionBox" :> 
          Documentation`HelpLookup["paclet:ref/FractionBox"], "FrameBox" :> 
          Documentation`HelpLookup["paclet:ref/FrameBox"], "GridBox" :> 
          Documentation`HelpLookup["paclet:ref/GridBox"], "InterpretationBox" :> 
          Documentation`HelpLookup["paclet:ref/InterpretationBox"], 
          "OverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/OverscriptBox"], "RadicalBox" :> 
          Documentation`HelpLookup["paclet:ref/RadicalBox"], "RowBox" :> 
          Documentation`HelpLookup["paclet:ref/RowBox"], "RowLines" :> 
          Documentation`HelpLookup["paclet:ref/RowLines"], "SqrtBox" :> 
          Documentation`HelpLookup["paclet:ref/SqrtBox"], "StyleBox" :> 
          Documentation`HelpLookup["paclet:ref/StyleBox"], "SubscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubscriptBox"], 
          "SubsuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubsuperscriptBox"], 
          "SuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SuperscriptBox"], "TagBox" :> 
          Documentation`HelpLookup["paclet:ref/TagBox"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "UnderoverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderoverscriptBox"], 
          "UnderscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderscriptBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ColumnLines\"\>", 
       2->"\<\"DisplayForm\"\>", 3->"\<\"ErrorBox\"\>", 4->"\<\"False\"\>", 
       5->"\<\"FormBox\"\>", 6->"\<\"FractionBox\"\>", 7->"\<\"FrameBox\"\>", 
       8->"\<\"GridBox\"\>", 9->"\<\"InterpretationBox\"\>", 
       10->"\<\"OverscriptBox\"\>", 11->"\<\"RadicalBox\"\>", 
       12->"\<\"RowBox\"\>", 13->"\<\"RowLines\"\>", 14->"\<\"SqrtBox\"\>", 
       15->"\<\"StyleBox\"\>", 16->"\<\"SubscriptBox\"\>", 
       17->"\<\"SubsuperscriptBox\"\>", 18->"\<\"SuperscriptBox\"\>", 
       19->"\<\"TagBox\"\>", 20->"\<\"True\"\>", 
       21->"\<\"UnderoverscriptBox\"\>", 
       22->"\<\"UnderscriptBox\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Representing Textual Forms by Boxes", "Title",
 CellTags->{"S2.9.10", "10.1"},
 CellID->32707],

Cell[TextData[{
 "All textual and graphical forms in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are ultimately represented in terms of nested collections of ",
 StyleBox["boxes",
  FontSlant->"Italic"],
 ". Typically the elements of these boxes correspond to objects that are to \
be placed at definite relative positions in two dimensions."
}], "Text",
 CellID->24245],

Cell[TextData[{
 "Here are the boxes corresponding to the expression ",
 Cell[BoxData[
  RowBox[{"a", "+", "b"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->144],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"a\"\>", ",", "\<\"+\"\>", ",", "\<\"b\"\>"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->22290]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " shows how these boxes would be displayed. "
}], "MathCaption",
 CellID->31339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->23154],

Cell[BoxData[
 TagBox[
  RowBox[{"a", "+", "b"}],
  DisplayForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//DisplayForm= ",
 CellID->24604]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DisplayForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DisplayForm"], "[", 
     StyleBox["boxes", "TI"], "]"}], Cell[TextData[{
     "show ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " as they would be displayed"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4623],

Cell["Showing the displayed form of boxes. ", "Caption",
 CellID->22225],

Cell["This displays three strings in a row. ", "MathCaption",
 CellID->20078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<a\>\"", ",", "\"\<+\>\"", ",", "\"\<b\>\""}], "}"}], "]"}], "//",
   "DisplayForm"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->21724],

Cell[BoxData[
 TagBox[
  RowBox[{"a", "+", "b"}],
  DisplayForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//DisplayForm= ",
 CellID->31981]
}, Open  ]],

Cell["This displays one string as a subscript of another. ", "MathCaption",
 CellID->2330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SubscriptBox", "[", 
   RowBox[{"\"\<a\>\"", ",", "\"\<i\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->29733],

Cell[BoxData[
 TagBox[
  SubscriptBox["a", "i"],
  DisplayForm]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//DisplayForm= ",
 CellID->28223]
}, Open  ]],

Cell["This puts two subscript boxes in a row. ", "MathCaption",
 CellID->20594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SubscriptBox", "[", 
      RowBox[{"\"\<a\>\"", ",", "\"\<1\>\""}], "]"}], ",", 
     RowBox[{"SubscriptBox", "[", 
      RowBox[{"\"\<b\>\"", ",", "\"\<2\>\""}], "]"}]}], "}"}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->29130],

Cell[BoxData[
 TagBox[
  RowBox[{
   SubscriptBox["a", "1"], 
   SubscriptBox["b", "2"]}],
  DisplayForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//DisplayForm= ",
 CellID->18846]
}, Open  ]],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", Cell["literal text", "TableText"]},
   {
    RowBox[{
     ButtonBox["RowBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RowBox"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "a row of boxes or strings ",
     Cell[BoxData[
      FormBox[
       RowBox[{"a", ",", "b", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GridBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridBox"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["b", "TI"], 
          StyleBox["1", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["b", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a grid of boxes ",
     Cell[BoxData[
      FormBox[GridBox[{
         {
          SubscriptBox["a", "1"], 
          SubscriptBox["b", "1"], "\[Ellipsis]"},
         {
          SubscriptBox["a", "2"], 
          SubscriptBox["b", "2"], "\[Ellipsis]"},
         {"\[VerticalEllipsis]", "\[VerticalEllipsis]", " "}
        }], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SubscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubscriptBox"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "subscript ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["a", "b"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SuperscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperscriptBox"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "superscript ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["a", "b"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SubsuperscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubsuperscriptBox"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], "]"}], Cell[TextData[{
     "subscript and superscript ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["a", "b", "c"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UnderscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderscriptBox"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "underscript ",
     Cell[BoxData[
      FormBox[
       UnderscriptBox["a", "b"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OverscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverscriptBox"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "overscript ",
     Cell[BoxData[
      FormBox[
       OverscriptBox["a", "b"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UnderoverscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderoverscriptBox"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], "]"}], Cell[TextData[{
     "underscript and overscript ",
     Cell[BoxData[
      FormBox[
       UnderoverscriptBox["a", "b", "c"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FractionBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FractionBox"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "fraction ",
     Cell[BoxData[
      FormBox[
       FractionBox["a", "b"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SqrtBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SqrtBox"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "square root ",
     Cell[BoxData[
      FormBox[
       SqrtBox["a"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RadicalBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RadicalBox"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " root ",
     Cell[BoxData[
      FormBox[
       RadicalBox["a", "b"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4987],

Cell["Some basic box types. ", "Caption",
 CellID->29445],

Cell["This nests a fraction inside a radical. ", "MathCaption",
 CellID->18805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RadicalBox", "[", 
   RowBox[{
    RowBox[{"FractionBox", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "n"}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->8616],

Cell[BoxData[
 TagBox[
  RadicalBox[
   FractionBox["x", "y"], "n"],
  DisplayForm]], "Output",
 ImageSize->{35, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//DisplayForm= ",
 CellID->5750]
}, Open  ]],

Cell["This puts a superscript on a subscripted object. ", "MathCaption",
 CellID->20489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SuperscriptBox", "[", 
   RowBox[{
    RowBox[{"SubscriptBox", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->27338],

Cell[BoxData[
 TagBox[
  SuperscriptBox[
   SubscriptBox["a", "b"], "c"],
  DisplayForm]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//DisplayForm= ",
 CellID->21963]
}, Open  ]],

Cell["\<\
This puts both a subscript and a superscript on the same object. \
\>", "MathCaption",
 CellID->28135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SubsuperscriptBox", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->14697],

Cell[BoxData[
 TagBox[
  SubsuperscriptBox["a", "b", "c"],
  DisplayForm]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//DisplayForm= ",
 CellID->32209]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FrameBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameBox"], "[", 
     StyleBox["box", "TI"], "]"}], Cell[TextData[{
     "render ",
     Cell[BoxData[
      StyleBox["box", "TI"]], "InlineFormula"],
     " with a frame drawn around it"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GridBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridBox"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       ButtonBox["RowLines",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RowLines"], "->", 
       ButtonBox["True",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/True"]}]}], "]"}], Cell[TextData[{
     "put lines between rows in a ",
     Cell[BoxData[
      ButtonBox["GridBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GridBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridBox"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       ButtonBox["ColumnLines",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColumnLines"], "->", 
       ButtonBox["True",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/True"]}]}], "]"}], Cell[
    "put lines between columns", "TableText"]},
   {
    RowBox[{
     ButtonBox["GridBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridBox"], "[", 
     StyleBox["list", "TI"], ",", 
     ButtonBox["RowLines",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RowLines"], "->", "{", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], ",", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "put a line below the first row, but not subsequent ones", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21630],

Cell["Inserting frames and grid lines. ", "Caption",
 CellID->23224],

Cell["This shows a fraction with a frame drawn around it. ", "MathCaption",
 CellID->1908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FrameBox", "[", 
   RowBox[{"FractionBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "]"}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->26737],

Cell[BoxData[
 TagBox[
  FrameBox[
   FractionBox["x", "y"]],
  DisplayForm]], "Output",
 ImageSize->{26, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//DisplayForm= ",
 CellID->24474]
}, Open  ]],

Cell["This puts lines between rows and columns of an array. ", "MathCaption",
 CellID->31920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GridBox", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"i", "+", "j"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"RowLines", "->", "True"}], ",", 
    RowBox[{"ColumnLines", "->", "True"}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->27372],

Cell[BoxData[
 TagBox[GridBox[{
    {"2", "3", "4"},
    {"3", "4", "5"},
    {"4", "5", "6"}
   },
   GridBoxDividers->{
    "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
     "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}}],
  DisplayForm]], "Output",
 ImageSize->{43, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//DisplayForm= ",
 CellID->10293]
}, Open  ]],

Cell["And this also puts a frame around the outside. ", "MathCaption",
 CellID->3855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FrameBox", "[", "%", "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->6734],

Cell[BoxData[
 TagBox[
  FrameBox[GridBox[{
     {"2", "3", "4"},
     {"3", "4", "5"},
     {"4", "5", "6"}
    },
    GridBoxDividers->{
     "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}}]],
  DisplayForm]], "Output",
 ImageSize->{53, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//DisplayForm= ",
 CellID->9561]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StyleBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StyleBox"], "[", 
     StyleBox["boxes", "TI"], ",", 
     StyleBox["options", "TI"], "]"}], Cell[TextData[{
     "render ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " with the specified option settings"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StyleBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StyleBox"], "[", 
     StyleBox["boxes", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "render ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " in the specified style"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31056],

Cell["Modifying the appearance of boxes. ", "Caption",
 CellID->27606],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " takes the same options as ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style",
   ButtonNote->"ObsLink: StyleForm -> Style"]], "InlineFormula"],
 ". The difference is that ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style",
   ButtonNote->"ObsLink: StyleForm -> Style"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote] for any \
expression, while ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " represents underlying box structure. "
}], "Text",
 CellID->8184],

Cell[TextData[{
 "This shows the string ",
 Cell[BoxData["\"\<name\>\""], "InlineFormula"],
 " in italics. "
}], "MathCaption",
 CellID->7075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{"\"\<name\>\"", ",", 
    RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->28382],

Cell[BoxData[
 TagBox[
  StyleBox["name",
   FontSlant->"Italic"],
  DisplayForm]], "Output",
 ImageSize->{32, 16},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//DisplayForm= ",
 CellID->14119]
}, Open  ]],

Cell[TextData[{
 "This shows ",
 Cell[BoxData["\"\<name\>\""], "InlineFormula"],
 " in the style used for section headings in your current notebook. "
}], "MathCaption",
 CellID->6741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{"\"\<name\>\"", ",", "\"\<Section\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->30432],

Cell[BoxData[
 TagBox[
  StyleBox["name", "Section"],
  DisplayForm]], "Output",
 ImageSize->{53, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//DisplayForm= ",
 CellID->24684]
}, Open  ]],

Cell["\<\
This uses section heading style, but with characters shown in gray. \
\>", "MathCaption",
 CellID->12779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{"\"\<name\>\"", ",", "\"\<Section\>\"", ",", 
    RowBox[{"FontColor", "->", 
     RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->12279],

Cell[BoxData[
 TagBox[
  StyleBox["name", "Section",
   FontColor->GrayLevel[0.5]],
  DisplayForm]], "Output",
 ImageSize->{53, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//DisplayForm= ",
 CellID->18283]
}, Open  ]],

Cell[TextData[{
 "If you use a notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you will be able to change the style and appearance of what you see \
on the screen directly by using menu items. Internally, however, these \
changes will still be recorded by the insertion of appropriate ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " objects. "
}], "Text",
 CellID->20667],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FormBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormBox"], "[", 
     StyleBox["boxes", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "interpret ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " using rules associated with the specified form"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InterpretationBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InterpretationBox"], "[", 
     StyleBox["boxes", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "interpret ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " as representing the expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TagBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TagBox"], "[", 
     StyleBox["boxes", "TI"], ",", 
     StyleBox["tag", "TI"], "]"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["tag", "TI"]], "InlineFormula"],
     " to guide the interpretation of ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ErrorBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ErrorBox"], "[", 
     StyleBox["boxes", "TI"], "]"}], Cell[TextData[{
     "indicate an error and do not attempt further interpretation of ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30836],

Cell["Controlling the interpretation of boxes. ", "Caption",
 CellID->24125],

Cell[TextData[{
 "This prints as ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " with a superscript. "
}], "MathCaption",
 CellID->24118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SuperscriptBox", "[", 
   RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->12737],

Cell[BoxData[
 TagBox[
  SuperscriptBox["x", "2"],
  DisplayForm]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//DisplayForm= ",
 CellID->18028]
}, Open  ]],

Cell["It is normally interpreted as a power. ", "MathCaption",
 CellID->32119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToExpression", "[", "%", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->20577],

Cell["x^2", "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]//InputForm= ",
 CellID->10737]
}, Open  ]],

Cell[TextData[{
 "This again prints as ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " with a superscript. "
}], "MathCaption",
 CellID->14091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpretationBox", "[", 
   RowBox[{
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"x", ",", "2"}], "]"}]}], "]"}], "//", "DisplayForm"}]], "Input",\

 CellLabel->"In[17]:= ",
 CellID->20556],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SuperscriptBox["x", "2"],
   vec[x, 2]],
  DisplayForm]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//DisplayForm= ",
 CellID->22795]
}, Open  ]],

Cell[TextData[{
 "But now it is interpreted as ",
 Cell[BoxData[
  RowBox[{"vec", "[", 
   RowBox[{"x", ",", "2"}], "]"}]], "InlineFormula"],
 ", following the specification given in the ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToExpression", "[", "%", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->21901],

Cell["vec[x, 2]", "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]//InputForm= ",
 CellID->8793]
}, Open  ]],

Cell[TextData[{
 "If you edit the boxes given in an ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 ", then there is no guarantee that the interpretation specified by the \
interpretation box will still be correct. As a result, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides various options that allow you to control the selection and \
editing of ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " objects. "
}], "Text",
 CellID->3432],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["default value", "TableHeader"], ""},
   {
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to allow the contents to be edited", "TableText"]},
   {
    ButtonBox["Selectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Selectable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow the contents to be selected", "TableText"]},
   {
    ButtonBox["Deletable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deletable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow the box to be deleted", "TableText"]},
   {
    ButtonBox["DeletionWarning",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DeletionWarning"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to issue a warning if the box is deleted", "TableText"]},
   {"BoxAutoDelete", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to strip the box if its contents are modified", "TableText"]},
   {"StripWrapperBoxes", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to remove ",
     Cell[BoxData[
      ButtonBox["StyleBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
     " etc. from within ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["TagBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TagBox"], "[", 
       StyleBox["boxes", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2136],

Cell[TextData[{
 "Options for ",
 StyleBox["InterpretationBox", "MR"],
 " and related boxes. "
}], "Caption",
 CellID->4580],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " objects are used to store information that will not be displayed but which \
can nevertheless be used by the rules that interpret boxes. Typically the ",
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TagBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagBox"], "[", 
   RowBox[{
    StyleBox["boxes", "TI"], ",", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 " is a symbol which gives the head of the expression corresponding to ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 ". If you edit only the arguments of this expression then there is a good \
chance that the interpretation specified by the ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " will still be appropriate. As a result, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Editable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Editable"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is effectively the default setting for a ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14875],

Cell[TextData[{
 "The rules that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses for interpreting boxes are in general set up to ignore details of \
formatting, such as those defined by ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " objects. Thus, unless ",
 Cell[BoxData[
  RowBox[{"StripWrapperBoxes", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", a red ",
 Cell[BoxData["x"], "InlineFormula"],
 ", for example, will normally not be distinguished from an ordinary black ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "Text",
 CellID->5907],

Cell[TextData[{
 "A red ",
 Cell[BoxData["x"], "InlineFormula"],
 " is usually treated as identical to an ordinary one. "
}], "MathCaption",
 CellID->21184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToExpression", "[", 
   RowBox[{"StyleBox", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontColor", "->", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}]}]}], "]"}], "]"}], "==", 
  "x"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->28074],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->8719]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->11918448],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "RelatedTutorials",
 CellID->175077611]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Representing Textual Forms by Boxes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/StylesAndFontsInOutput"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ConvertingBetweenStringsBoxesAndExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 20.7470960}", "context" -> "", 
    "keywords" -> {
     "above overscript", "\\above (TeX)", "\\accent (TeX)", "active", 
      "active element", "arrangement", "arrays", "atop overscript", 
      "\\atop (TeX)", "below underscript", "box", "BoxAutoDelete", "boxes", 
      "\\brace (TeX)", "\\brack (TeX)", "\\buildrel (TeX)", 
      "builtup fractions", "ButtonBox", "\\cases (TeX)", "\\choose (TeX)", 
      "Clickable elements", "ColumnLines", "concatenate", "deletable", 
      "DeletionWarning", "DisplayForm", "editable", "ErrorBox", 
      "\\fbox (TeX)", "FormBox", "\\frac (TeX)", "FractionBox", "FrameBox", 
      "\\framebox (TeX)", "GridBox", "\\hbox (TeX)", "hidden box data", 
      "horizontal box", "horizontal lines", "InterpretationBox", "layout", 
      "limits", "lines", "matrices", "on top overscript", "Overscript", 
      "OverscriptBox", "\\over (TeX)", "palette element", "positioning", 
      "RadicalBox", "radicals", "rational functions", "red variable names", 
      "roots", "RowBox", "RowLines", "\\sb (TeX)", "script boxes", 
      "selectable", "separators", "sequence", "\\sp (TeX)", "SqrtBox", 
      "\\sqrt (TeX)", "square roots", "stack overscript", "\\stackrel (TeX)", 
      "StripWrapperBoxes", "StyleBox", "styles", "SubscriptBox", 
      "SubsuperscriptBox", "SuperscriptBox", "surds", "tables", "TagBox", 
      "typesetting", "underneath underscript", "UnderoverscriptBox", 
      "Underscript", "UnderscriptBox", "uninterpretable input", 
      "\\vbox (TeX)", "vertical lines"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "All textual and graphical forms in Mathematica are ultimately \
represented in terms of nested collections of boxes. Typically the elements \
of these boxes correspond to objects that are to be placed at definite \
relative positions in two dimensions. Here are the boxes corresponding to the \
expression a+b. DisplayForm shows how these boxes would be displayed. ", 
    "synonyms" -> {"2.9.10"}, "title" -> 
    "Representing Textual Forms by Boxes", "type" -> "Tutorial", "uri" -> 
    "tutorial/RepresentingTextualFormsByBoxes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.10"->{
  Cell[4275, 96, 100, 2, 70, "Title",
   CellTags->{"S2.9.10", "10.1"},
   CellID->32707]},
 "10.1"->{
  Cell[4275, 96, 100, 2, 70, "Title",
   CellTags->{"S2.9.10", "10.1"},
   CellID->32707]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.10", 39991, 1350},
 {"10.1", 40094, 1354}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3650, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4275, 96, 100, 2, 70, "Title",
 CellTags->{"S2.9.10", "10.1"},
 CellID->32707],
Cell[4378, 100, 381, 10, 70, "Text",
 CellID->24245],
Cell[4762, 112, 172, 6, 70, "MathCaption",
 CellID->1338],
Cell[CellGroupData[{
Cell[4959, 122, 121, 4, 28, "Input",
 CellID->144],
Cell[5083, 128, 272, 9, 36, "Output",
 CellID->22290]
}, Open  ]],
Cell[5370, 140, 222, 7, 70, "MathCaption",
 CellID->31339],
Cell[CellGroupData[{
Cell[5617, 151, 104, 3, 28, "Input",
 CellID->23154],
Cell[5724, 156, 216, 8, 50, "Output",
 CellID->24604]
}, Open  ]],
Cell[5955, 167, 657, 20, 70, "DefinitionBox",
 CellID->4623],
Cell[6615, 189, 72, 1, 70, "Caption",
 CellID->22225],
Cell[6690, 192, 77, 1, 70, "MathCaption",
 CellID->20078],
Cell[CellGroupData[{
Cell[6792, 197, 219, 7, 70, "Input",
 CellID->21724],
Cell[7014, 206, 216, 8, 50, "Output",
 CellID->31981]
}, Open  ]],
Cell[7245, 217, 90, 1, 70, "MathCaption",
 CellID->2330],
Cell[CellGroupData[{
Cell[7360, 222, 182, 6, 70, "Input",
 CellID->29733],
Cell[7545, 230, 215, 8, 50, "Output",
 CellID->28223]
}, Open  ]],
Cell[7775, 241, 79, 1, 70, "MathCaption",
 CellID->20594],
Cell[CellGroupData[{
Cell[7879, 246, 355, 11, 70, "Input",
 CellID->29130],
Cell[8237, 259, 257, 10, 50, "Output",
 CellID->18846]
}, Open  ]],
Cell[8509, 272, 5662, 183, 70, "DefinitionBox",
 CellID->4987],
Cell[14174, 457, 57, 1, 70, "Caption",
 CellID->29445],
Cell[14234, 460, 79, 1, 70, "MathCaption",
 CellID->18805],
Cell[CellGroupData[{
Cell[14338, 465, 229, 8, 70, "Input",
 CellID->8616],
Cell[14570, 475, 234, 9, 74, "Output",
 CellID->5750]
}, Open  ]],
Cell[14819, 487, 88, 1, 70, "MathCaption",
 CellID->20489],
Cell[CellGroupData[{
Cell[14932, 492, 235, 8, 70, "Input",
 CellID->27338],
Cell[15170, 502, 240, 9, 50, "Output",
 CellID->21963]
}, Open  ]],
Cell[15425, 514, 112, 3, 70, "MathCaption",
 CellID->28135],
Cell[CellGroupData[{
Cell[15562, 521, 178, 5, 70, "Input",
 CellID->14697],
Cell[15743, 528, 225, 8, 50, "Output",
 CellID->32209]
}, Open  ]],
Cell[15983, 539, 2442, 77, 70, "DefinitionBox",
 CellID->21630],
Cell[18428, 618, 68, 1, 70, "Caption",
 CellID->23224],
Cell[18499, 621, 90, 1, 70, "MathCaption",
 CellID->1908],
Cell[CellGroupData[{
Cell[18614, 626, 218, 7, 70, "Input",
 CellID->26737],
Cell[18835, 635, 228, 9, 75, "Output",
 CellID->24474]
}, Open  ]],
Cell[19078, 647, 93, 1, 70, "MathCaption",
 CellID->31920],
Cell[CellGroupData[{
Cell[19196, 652, 454, 15, 70, "Input",
 CellID->27372],
Cell[19653, 669, 417, 14, 80, "Output",
 CellID->10293]
}, Open  ]],
Cell[20085, 686, 85, 1, 70, "MathCaption",
 CellID->3855],
Cell[CellGroupData[{
Cell[20195, 691, 135, 4, 70, "Input",
 CellID->6734],
Cell[20333, 697, 436, 15, 90, "Output",
 CellID->9561]
}, Open  ]],
Cell[20784, 715, 1058, 33, 70, "DefinitionBox",
 CellID->31056],
Cell[21845, 750, 70, 1, 70, "Caption",
 CellID->27606],
Cell[21918, 753, 801, 25, 70, "Text",
 CellID->8184],
Cell[22722, 780, 142, 5, 70, "MathCaption",
 CellID->7075],
Cell[CellGroupData[{
Cell[22889, 789, 221, 7, 70, "Input",
 CellID->28382],
Cell[23113, 798, 234, 9, 51, "Output",
 CellID->14119]
}, Open  ]],
Cell[23362, 810, 184, 5, 70, "MathCaption",
 CellID->6741],
Cell[CellGroupData[{
Cell[23571, 819, 188, 6, 70, "Input",
 CellID->30432],
Cell[23762, 827, 221, 8, 53, "Output",
 CellID->24684]
}, Open  ]],
Cell[23998, 838, 115, 3, 70, "MathCaption",
 CellID->12779],
Cell[CellGroupData[{
Cell[24138, 845, 273, 8, 70, "Input",
 CellID->12279],
Cell[24414, 855, 251, 9, 53, "Output",
 CellID->18283]
}, Open  ]],
Cell[24680, 867, 484, 13, 70, "Text",
 CellID->20667],
Cell[25167, 882, 1923, 59, 70, "DefinitionBox",
 CellID->30836],
Cell[27093, 943, 76, 1, 70, "Caption",
 CellID->24125],
Cell[27172, 946, 159, 6, 70, "MathCaption",
 CellID->24118],
Cell[CellGroupData[{
Cell[27356, 956, 185, 6, 70, "Input",
 CellID->12737],
Cell[27544, 964, 218, 8, 50, "Output",
 CellID->18028]
}, Open  ]],
Cell[27777, 975, 78, 1, 70, "MathCaption",
 CellID->32119],
Cell[CellGroupData[{
Cell[27880, 980, 138, 4, 70, "Input",
 CellID->20577],
Cell[28021, 986, 160, 5, 50, "Output",
 CellID->10737]
}, Open  ]],
Cell[28196, 994, 165, 6, 70, "MathCaption",
 CellID->14091],
Cell[CellGroupData[{
Cell[28386, 1004, 314, 10, 70, "Input",
 CellID->20556],
Cell[28703, 1016, 255, 10, 50, "Output",
 CellID->22795]
}, Open  ]],
Cell[28973, 1029, 367, 12, 70, "MathCaption",
 CellID->16060],
Cell[CellGroupData[{
Cell[29365, 1045, 138, 4, 70, "Input",
 CellID->21901],
Cell[29506, 1051, 165, 5, 50, "Output",
 CellID->8793]
}, Open  ]],
Cell[29686, 1059, 638, 18, 70, "Text",
 CellID->3432],
Cell[30327, 1079, 2355, 69, 70, "DefinitionBox3Col",
 CellID->2136],
Cell[32685, 1150, 124, 5, 70, "Caption",
 CellID->4580],
Cell[32812, 1157, 1415, 43, 70, "Text",
 CellID->14875],
Cell[34230, 1202, 703, 22, 70, "Text",
 CellID->5907],
Cell[34936, 1226, 156, 5, 70, "MathCaption",
 CellID->21184],
Cell[CellGroupData[{
Cell[35117, 1235, 306, 10, 70, "Input",
 CellID->28074],
Cell[35426, 1247, 158, 5, 36, "Output",
 CellID->8719]
}, Open  ]],
Cell[CellGroupData[{
Cell[35621, 1257, 71, 1, 70, "RelatedTutorialsSection",
 CellID->11918448],
Cell[35695, 1260, 178, 4, 70, "RelatedTutorials",
 CellID->364580606],
Cell[35876, 1266, 153, 3, 70, "RelatedTutorials",
 CellID->175077611]
}, Open  ]]
}, Open  ]],
Cell[36056, 1273, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

